// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddRoleToDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_role_to_db_cluster`](crate::client::Client::add_role_to_db_cluster).
///
/// See [`crate::client::fluent_builders::AddRoleToDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddRoleToDBCluster {
    _private: (),
}
impl AddRoleToDBCluster {
    /// Creates a new builder-style object to manufacture [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
    pub fn builder() -> crate::input::add_role_to_db_cluster_input::Builder {
        crate::input::add_role_to_db_cluster_input::Builder::default()
    }
    /// Creates a new `AddRoleToDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddRoleToDBCluster {
    type Output = std::result::Result<
        crate::output::AddRoleToDbClusterOutput,
        crate::error::AddRoleToDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_role_to_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_add_role_to_db_cluster_response(response)
        }
    }
}

/// Operation shape for `AddRoleToDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_role_to_db_instance`](crate::client::Client::add_role_to_db_instance).
///
/// See [`crate::client::fluent_builders::AddRoleToDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddRoleToDBInstance {
    _private: (),
}
impl AddRoleToDBInstance {
    /// Creates a new builder-style object to manufacture [`AddRoleToDbInstanceInput`](crate::input::AddRoleToDbInstanceInput)
    pub fn builder() -> crate::input::add_role_to_db_instance_input::Builder {
        crate::input::add_role_to_db_instance_input::Builder::default()
    }
    /// Creates a new `AddRoleToDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddRoleToDBInstance {
    type Output = std::result::Result<
        crate::output::AddRoleToDbInstanceOutput,
        crate::error::AddRoleToDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_role_to_db_instance_error(response)
        } else {
            crate::operation_deser::parse_add_role_to_db_instance_response(response)
        }
    }
}

/// Operation shape for `AddSourceIdentifierToSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_source_identifier_to_subscription`](crate::client::Client::add_source_identifier_to_subscription).
///
/// See [`crate::client::fluent_builders::AddSourceIdentifierToSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddSourceIdentifierToSubscription {
    _private: (),
}
impl AddSourceIdentifierToSubscription {
    /// Creates a new builder-style object to manufacture [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    pub fn builder() -> crate::input::add_source_identifier_to_subscription_input::Builder {
        crate::input::add_source_identifier_to_subscription_input::Builder::default()
    }
    /// Creates a new `AddSourceIdentifierToSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddSourceIdentifierToSubscription {
    type Output = std::result::Result<
        crate::output::AddSourceIdentifierToSubscriptionOutput,
        crate::error::AddSourceIdentifierToSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_source_identifier_to_subscription_error(response)
        } else {
            crate::operation_deser::parse_add_source_identifier_to_subscription_response(response)
        }
    }
}

/// Operation shape for `AddTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_resource`](crate::client::Client::add_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToResource {
    _private: (),
}
impl AddTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToResource {
    type Output = std::result::Result<
        crate::output::AddTagsToResourceOutput,
        crate::error::AddTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `ApplyPendingMaintenanceAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_pending_maintenance_action`](crate::client::Client::apply_pending_maintenance_action).
///
/// See [`crate::client::fluent_builders::ApplyPendingMaintenanceAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplyPendingMaintenanceAction {
    _private: (),
}
impl ApplyPendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    pub fn builder() -> crate::input::apply_pending_maintenance_action_input::Builder {
        crate::input::apply_pending_maintenance_action_input::Builder::default()
    }
    /// Creates a new `ApplyPendingMaintenanceAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ApplyPendingMaintenanceAction {
    type Output = std::result::Result<
        crate::output::ApplyPendingMaintenanceActionOutput,
        crate::error::ApplyPendingMaintenanceActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_pending_maintenance_action_error(response)
        } else {
            crate::operation_deser::parse_apply_pending_maintenance_action_response(response)
        }
    }
}

/// Operation shape for `AuthorizeDBSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_db_security_group_ingress`](crate::client::Client::authorize_db_security_group_ingress).
///
/// See [`crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeDBSecurityGroupIngress {
    _private: (),
}
impl AuthorizeDBSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`AuthorizeDbSecurityGroupIngressInput`](crate::input::AuthorizeDbSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_db_security_group_ingress_input::Builder {
        crate::input::authorize_db_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `AuthorizeDBSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeDBSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::AuthorizeDbSecurityGroupIngressOutput,
        crate::error::AuthorizeDBSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_db_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_authorize_db_security_group_ingress_response(response)
        }
    }
}

/// Operation shape for `BacktrackDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`backtrack_db_cluster`](crate::client::Client::backtrack_db_cluster).
///
/// See [`crate::client::fluent_builders::BacktrackDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BacktrackDBCluster {
    _private: (),
}
impl BacktrackDBCluster {
    /// Creates a new builder-style object to manufacture [`BacktrackDbClusterInput`](crate::input::BacktrackDbClusterInput)
    pub fn builder() -> crate::input::backtrack_db_cluster_input::Builder {
        crate::input::backtrack_db_cluster_input::Builder::default()
    }
    /// Creates a new `BacktrackDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BacktrackDBCluster {
    type Output = std::result::Result<
        crate::output::BacktrackDbClusterOutput,
        crate::error::BacktrackDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_backtrack_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_backtrack_db_cluster_response(response)
        }
    }
}

/// Operation shape for `CancelExportTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_export_task`](crate::client::Client::cancel_export_task).
///
/// See [`crate::client::fluent_builders::CancelExportTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelExportTask {
    _private: (),
}
impl CancelExportTask {
    /// Creates a new builder-style object to manufacture [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
    pub fn builder() -> crate::input::cancel_export_task_input::Builder {
        crate::input::cancel_export_task_input::Builder::default()
    }
    /// Creates a new `CancelExportTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelExportTask {
    type Output = std::result::Result<
        crate::output::CancelExportTaskOutput,
        crate::error::CancelExportTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_export_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_export_task_response(response)
        }
    }
}

/// Operation shape for `CopyDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_db_cluster_parameter_group`](crate::client::Client::copy_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::CopyDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyDBClusterParameterGroup {
    _private: (),
}
impl CopyDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_cluster_parameter_group_input::Builder {
        crate::input::copy_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `CopyDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::CopyDbClusterParameterGroupOutput,
        crate::error::CopyDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_copy_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CopyDBClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_db_cluster_snapshot`](crate::client::Client::copy_db_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::CopyDBClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyDBClusterSnapshot {
    _private: (),
}
impl CopyDBClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    pub fn builder() -> crate::input::copy_db_cluster_snapshot_input::Builder {
        crate::input::copy_db_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `CopyDBClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyDBClusterSnapshot {
    type Output = std::result::Result<
        crate::output::CopyDbClusterSnapshotOutput,
        crate::error::CopyDBClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_db_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_db_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `CopyDBParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_db_parameter_group`](crate::client::Client::copy_db_parameter_group).
///
/// See [`crate::client::fluent_builders::CopyDBParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyDBParameterGroup {
    _private: (),
}
impl CopyDBParameterGroup {
    /// Creates a new builder-style object to manufacture [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_parameter_group_input::Builder {
        crate::input::copy_db_parameter_group_input::Builder::default()
    }
    /// Creates a new `CopyDBParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyDBParameterGroup {
    type Output = std::result::Result<
        crate::output::CopyDbParameterGroupOutput,
        crate::error::CopyDBParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_db_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_copy_db_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CopyDBSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_db_snapshot`](crate::client::Client::copy_db_snapshot).
///
/// See [`crate::client::fluent_builders::CopyDBSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyDBSnapshot {
    _private: (),
}
impl CopyDBSnapshot {
    /// Creates a new builder-style object to manufacture [`CopyDbSnapshotInput`](crate::input::CopyDbSnapshotInput)
    pub fn builder() -> crate::input::copy_db_snapshot_input::Builder {
        crate::input::copy_db_snapshot_input::Builder::default()
    }
    /// Creates a new `CopyDBSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyDBSnapshot {
    type Output =
        std::result::Result<crate::output::CopyDbSnapshotOutput, crate::error::CopyDBSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_db_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_db_snapshot_response(response)
        }
    }
}

/// Operation shape for `CopyOptionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_option_group`](crate::client::Client::copy_option_group).
///
/// See [`crate::client::fluent_builders::CopyOptionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyOptionGroup {
    _private: (),
}
impl CopyOptionGroup {
    /// Creates a new builder-style object to manufacture [`CopyOptionGroupInput`](crate::input::CopyOptionGroupInput)
    pub fn builder() -> crate::input::copy_option_group_input::Builder {
        crate::input::copy_option_group_input::Builder::default()
    }
    /// Creates a new `CopyOptionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyOptionGroup {
    type Output = std::result::Result<
        crate::output::CopyOptionGroupOutput,
        crate::error::CopyOptionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_option_group_error(response)
        } else {
            crate::operation_deser::parse_copy_option_group_response(response)
        }
    }
}

/// Operation shape for `CreateCustomAvailabilityZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_availability_zone`](crate::client::Client::create_custom_availability_zone).
///
/// See [`crate::client::fluent_builders::CreateCustomAvailabilityZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomAvailabilityZone {
    _private: (),
}
impl CreateCustomAvailabilityZone {
    /// Creates a new builder-style object to manufacture [`CreateCustomAvailabilityZoneInput`](crate::input::CreateCustomAvailabilityZoneInput)
    pub fn builder() -> crate::input::create_custom_availability_zone_input::Builder {
        crate::input::create_custom_availability_zone_input::Builder::default()
    }
    /// Creates a new `CreateCustomAvailabilityZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomAvailabilityZone {
    type Output = std::result::Result<
        crate::output::CreateCustomAvailabilityZoneOutput,
        crate::error::CreateCustomAvailabilityZoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_availability_zone_error(response)
        } else {
            crate::operation_deser::parse_create_custom_availability_zone_response(response)
        }
    }
}

/// Operation shape for `CreateCustomDBEngineVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_db_engine_version`](crate::client::Client::create_custom_db_engine_version).
///
/// See [`crate::client::fluent_builders::CreateCustomDBEngineVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomDBEngineVersion {
    _private: (),
}
impl CreateCustomDBEngineVersion {
    /// Creates a new builder-style object to manufacture [`CreateCustomDbEngineVersionInput`](crate::input::CreateCustomDbEngineVersionInput)
    pub fn builder() -> crate::input::create_custom_db_engine_version_input::Builder {
        crate::input::create_custom_db_engine_version_input::Builder::default()
    }
    /// Creates a new `CreateCustomDBEngineVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomDBEngineVersion {
    type Output = std::result::Result<
        crate::output::CreateCustomDbEngineVersionOutput,
        crate::error::CreateCustomDBEngineVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_db_engine_version_error(response)
        } else {
            crate::operation_deser::parse_create_custom_db_engine_version_response(response)
        }
    }
}

/// Operation shape for `CreateDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_cluster`](crate::client::Client::create_db_cluster).
///
/// See [`crate::client::fluent_builders::CreateDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBCluster {
    _private: (),
}
impl CreateDBCluster {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    pub fn builder() -> crate::input::create_db_cluster_input::Builder {
        crate::input::create_db_cluster_input::Builder::default()
    }
    /// Creates a new `CreateDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBCluster {
    type Output = std::result::Result<
        crate::output::CreateDbClusterOutput,
        crate::error::CreateDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_db_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateDBClusterEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_cluster_endpoint`](crate::client::Client::create_db_cluster_endpoint).
///
/// See [`crate::client::fluent_builders::CreateDBClusterEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBClusterEndpoint {
    _private: (),
}
impl CreateDBClusterEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
    pub fn builder() -> crate::input::create_db_cluster_endpoint_input::Builder {
        crate::input::create_db_cluster_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateDBClusterEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBClusterEndpoint {
    type Output = std::result::Result<
        crate::output::CreateDbClusterEndpointOutput,
        crate::error::CreateDBClusterEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_cluster_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_db_cluster_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_cluster_parameter_group`](crate::client::Client::create_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::CreateDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBClusterParameterGroup {
    _private: (),
}
impl CreateDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::create_db_cluster_parameter_group_input::Builder {
        crate::input::create_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `CreateDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::CreateDbClusterParameterGroupOutput,
        crate::error::CreateDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_create_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CreateDBClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_cluster_snapshot`](crate::client::Client::create_db_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::CreateDBClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBClusterSnapshot {
    _private: (),
}
impl CreateDBClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    pub fn builder() -> crate::input::create_db_cluster_snapshot_input::Builder {
        crate::input::create_db_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateDBClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBClusterSnapshot {
    type Output = std::result::Result<
        crate::output::CreateDbClusterSnapshotOutput,
        crate::error::CreateDBClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_db_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_instance`](crate::client::Client::create_db_instance).
///
/// See [`crate::client::fluent_builders::CreateDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBInstance {
    _private: (),
}
impl CreateDBInstance {
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    pub fn builder() -> crate::input::create_db_instance_input::Builder {
        crate::input::create_db_instance_input::Builder::default()
    }
    /// Creates a new `CreateDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBInstance {
    type Output = std::result::Result<
        crate::output::CreateDbInstanceOutput,
        crate::error::CreateDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_instance_error(response)
        } else {
            crate::operation_deser::parse_create_db_instance_response(response)
        }
    }
}

/// Operation shape for `CreateDBInstanceReadReplica`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_instance_read_replica`](crate::client::Client::create_db_instance_read_replica).
///
/// See [`crate::client::fluent_builders::CreateDBInstanceReadReplica`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBInstanceReadReplica {
    _private: (),
}
impl CreateDBInstanceReadReplica {
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceReadReplicaInput`](crate::input::CreateDbInstanceReadReplicaInput)
    pub fn builder() -> crate::input::create_db_instance_read_replica_input::Builder {
        crate::input::create_db_instance_read_replica_input::Builder::default()
    }
    /// Creates a new `CreateDBInstanceReadReplica` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBInstanceReadReplica {
    type Output = std::result::Result<
        crate::output::CreateDbInstanceReadReplicaOutput,
        crate::error::CreateDBInstanceReadReplicaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_instance_read_replica_error(response)
        } else {
            crate::operation_deser::parse_create_db_instance_read_replica_response(response)
        }
    }
}

/// Operation shape for `CreateDBParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_parameter_group`](crate::client::Client::create_db_parameter_group).
///
/// See [`crate::client::fluent_builders::CreateDBParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBParameterGroup {
    _private: (),
}
impl CreateDBParameterGroup {
    /// Creates a new builder-style object to manufacture [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
    pub fn builder() -> crate::input::create_db_parameter_group_input::Builder {
        crate::input::create_db_parameter_group_input::Builder::default()
    }
    /// Creates a new `CreateDBParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBParameterGroup {
    type Output = std::result::Result<
        crate::output::CreateDbParameterGroupOutput,
        crate::error::CreateDBParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_create_db_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CreateDBProxy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_proxy`](crate::client::Client::create_db_proxy).
///
/// See [`crate::client::fluent_builders::CreateDBProxy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBProxy {
    _private: (),
}
impl CreateDBProxy {
    /// Creates a new builder-style object to manufacture [`CreateDbProxyInput`](crate::input::CreateDbProxyInput)
    pub fn builder() -> crate::input::create_db_proxy_input::Builder {
        crate::input::create_db_proxy_input::Builder::default()
    }
    /// Creates a new `CreateDBProxy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBProxy {
    type Output =
        std::result::Result<crate::output::CreateDbProxyOutput, crate::error::CreateDBProxyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_proxy_error(response)
        } else {
            crate::operation_deser::parse_create_db_proxy_response(response)
        }
    }
}

/// Operation shape for `CreateDBProxyEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_proxy_endpoint`](crate::client::Client::create_db_proxy_endpoint).
///
/// See [`crate::client::fluent_builders::CreateDBProxyEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBProxyEndpoint {
    _private: (),
}
impl CreateDBProxyEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateDbProxyEndpointInput`](crate::input::CreateDbProxyEndpointInput)
    pub fn builder() -> crate::input::create_db_proxy_endpoint_input::Builder {
        crate::input::create_db_proxy_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateDBProxyEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBProxyEndpoint {
    type Output = std::result::Result<
        crate::output::CreateDbProxyEndpointOutput,
        crate::error::CreateDBProxyEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_proxy_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_db_proxy_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateDBSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_security_group`](crate::client::Client::create_db_security_group).
///
/// See [`crate::client::fluent_builders::CreateDBSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBSecurityGroup {
    _private: (),
}
impl CreateDBSecurityGroup {
    /// Creates a new builder-style object to manufacture [`CreateDbSecurityGroupInput`](crate::input::CreateDbSecurityGroupInput)
    pub fn builder() -> crate::input::create_db_security_group_input::Builder {
        crate::input::create_db_security_group_input::Builder::default()
    }
    /// Creates a new `CreateDBSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBSecurityGroup {
    type Output = std::result::Result<
        crate::output::CreateDbSecurityGroupOutput,
        crate::error::CreateDBSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_security_group_error(response)
        } else {
            crate::operation_deser::parse_create_db_security_group_response(response)
        }
    }
}

/// Operation shape for `CreateDBSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_snapshot`](crate::client::Client::create_db_snapshot).
///
/// See [`crate::client::fluent_builders::CreateDBSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBSnapshot {
    _private: (),
}
impl CreateDBSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateDbSnapshotInput`](crate::input::CreateDbSnapshotInput)
    pub fn builder() -> crate::input::create_db_snapshot_input::Builder {
        crate::input::create_db_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateDBSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBSnapshot {
    type Output = std::result::Result<
        crate::output::CreateDbSnapshotOutput,
        crate::error::CreateDBSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_db_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateDBSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_db_subnet_group`](crate::client::Client::create_db_subnet_group).
///
/// See [`crate::client::fluent_builders::CreateDBSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDBSubnetGroup {
    _private: (),
}
impl CreateDBSubnetGroup {
    /// Creates a new builder-style object to manufacture [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    pub fn builder() -> crate::input::create_db_subnet_group_input::Builder {
        crate::input::create_db_subnet_group_input::Builder::default()
    }
    /// Creates a new `CreateDBSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDBSubnetGroup {
    type Output = std::result::Result<
        crate::output::CreateDbSubnetGroupOutput,
        crate::error::CreateDBSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_db_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_create_db_subnet_group_response(response)
        }
    }
}

/// Operation shape for `CreateEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_subscription`](crate::client::Client::create_event_subscription).
///
/// See [`crate::client::fluent_builders::CreateEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventSubscription {
    _private: (),
}
impl CreateEventSubscription {
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
    /// Creates a new `CreateEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventSubscription {
    type Output = std::result::Result<
        crate::output::CreateEventSubscriptionOutput,
        crate::error::CreateEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_event_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_global_cluster`](crate::client::Client::create_global_cluster).
///
/// See [`crate::client::fluent_builders::CreateGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGlobalCluster {
    _private: (),
}
impl CreateGlobalCluster {
    /// Creates a new builder-style object to manufacture [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
    pub fn builder() -> crate::input::create_global_cluster_input::Builder {
        crate::input::create_global_cluster_input::Builder::default()
    }
    /// Creates a new `CreateGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGlobalCluster {
    type Output = std::result::Result<
        crate::output::CreateGlobalClusterOutput,
        crate::error::CreateGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_global_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateOptionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_option_group`](crate::client::Client::create_option_group).
///
/// See [`crate::client::fluent_builders::CreateOptionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOptionGroup {
    _private: (),
}
impl CreateOptionGroup {
    /// Creates a new builder-style object to manufacture [`CreateOptionGroupInput`](crate::input::CreateOptionGroupInput)
    pub fn builder() -> crate::input::create_option_group_input::Builder {
        crate::input::create_option_group_input::Builder::default()
    }
    /// Creates a new `CreateOptionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOptionGroup {
    type Output = std::result::Result<
        crate::output::CreateOptionGroupOutput,
        crate::error::CreateOptionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_option_group_error(response)
        } else {
            crate::operation_deser::parse_create_option_group_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomAvailabilityZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_availability_zone`](crate::client::Client::delete_custom_availability_zone).
///
/// See [`crate::client::fluent_builders::DeleteCustomAvailabilityZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomAvailabilityZone {
    _private: (),
}
impl DeleteCustomAvailabilityZone {
    /// Creates a new builder-style object to manufacture [`DeleteCustomAvailabilityZoneInput`](crate::input::DeleteCustomAvailabilityZoneInput)
    pub fn builder() -> crate::input::delete_custom_availability_zone_input::Builder {
        crate::input::delete_custom_availability_zone_input::Builder::default()
    }
    /// Creates a new `DeleteCustomAvailabilityZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomAvailabilityZone {
    type Output = std::result::Result<
        crate::output::DeleteCustomAvailabilityZoneOutput,
        crate::error::DeleteCustomAvailabilityZoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_availability_zone_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_availability_zone_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomDBEngineVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_db_engine_version`](crate::client::Client::delete_custom_db_engine_version).
///
/// See [`crate::client::fluent_builders::DeleteCustomDBEngineVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomDBEngineVersion {
    _private: (),
}
impl DeleteCustomDBEngineVersion {
    /// Creates a new builder-style object to manufacture [`DeleteCustomDbEngineVersionInput`](crate::input::DeleteCustomDbEngineVersionInput)
    pub fn builder() -> crate::input::delete_custom_db_engine_version_input::Builder {
        crate::input::delete_custom_db_engine_version_input::Builder::default()
    }
    /// Creates a new `DeleteCustomDBEngineVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomDBEngineVersion {
    type Output = std::result::Result<
        crate::output::DeleteCustomDbEngineVersionOutput,
        crate::error::DeleteCustomDBEngineVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_db_engine_version_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_db_engine_version_response(response)
        }
    }
}

/// Operation shape for `DeleteDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_cluster`](crate::client::Client::delete_db_cluster).
///
/// See [`crate::client::fluent_builders::DeleteDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBCluster {
    _private: (),
}
impl DeleteDBCluster {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    pub fn builder() -> crate::input::delete_db_cluster_input::Builder {
        crate::input::delete_db_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBCluster {
    type Output = std::result::Result<
        crate::output::DeleteDbClusterOutput,
        crate::error::DeleteDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_db_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteDBClusterEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_cluster_endpoint`](crate::client::Client::delete_db_cluster_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteDBClusterEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBClusterEndpoint {
    _private: (),
}
impl DeleteDBClusterEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
    pub fn builder() -> crate::input::delete_db_cluster_endpoint_input::Builder {
        crate::input::delete_db_cluster_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteDBClusterEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBClusterEndpoint {
    type Output = std::result::Result<
        crate::output::DeleteDbClusterEndpointOutput,
        crate::error::DeleteDBClusterEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_cluster_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_db_cluster_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_cluster_parameter_group`](crate::client::Client::delete_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::DeleteDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBClusterParameterGroup {
    _private: (),
}
impl DeleteDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_cluster_parameter_group_input::Builder {
        crate::input::delete_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `DeleteDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::DeleteDbClusterParameterGroupOutput,
        crate::error::DeleteDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_delete_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `DeleteDBClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_cluster_snapshot`](crate::client::Client::delete_db_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteDBClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBClusterSnapshot {
    _private: (),
}
impl DeleteDBClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    pub fn builder() -> crate::input::delete_db_cluster_snapshot_input::Builder {
        crate::input::delete_db_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteDBClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBClusterSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteDbClusterSnapshotOutput,
        crate::error::DeleteDBClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_db_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_instance`](crate::client::Client::delete_db_instance).
///
/// See [`crate::client::fluent_builders::DeleteDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBInstance {
    _private: (),
}
impl DeleteDBInstance {
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    pub fn builder() -> crate::input::delete_db_instance_input::Builder {
        crate::input::delete_db_instance_input::Builder::default()
    }
    /// Creates a new `DeleteDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBInstance {
    type Output = std::result::Result<
        crate::output::DeleteDbInstanceOutput,
        crate::error::DeleteDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_db_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteDBInstanceAutomatedBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_instance_automated_backup`](crate::client::Client::delete_db_instance_automated_backup).
///
/// See [`crate::client::fluent_builders::DeleteDBInstanceAutomatedBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBInstanceAutomatedBackup {
    _private: (),
}
impl DeleteDBInstanceAutomatedBackup {
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceAutomatedBackupInput`](crate::input::DeleteDbInstanceAutomatedBackupInput)
    pub fn builder() -> crate::input::delete_db_instance_automated_backup_input::Builder {
        crate::input::delete_db_instance_automated_backup_input::Builder::default()
    }
    /// Creates a new `DeleteDBInstanceAutomatedBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBInstanceAutomatedBackup {
    type Output = std::result::Result<
        crate::output::DeleteDbInstanceAutomatedBackupOutput,
        crate::error::DeleteDBInstanceAutomatedBackupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_instance_automated_backup_error(response)
        } else {
            crate::operation_deser::parse_delete_db_instance_automated_backup_response(response)
        }
    }
}

/// Operation shape for `DeleteDBParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_parameter_group`](crate::client::Client::delete_db_parameter_group).
///
/// See [`crate::client::fluent_builders::DeleteDBParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBParameterGroup {
    _private: (),
}
impl DeleteDBParameterGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_parameter_group_input::Builder {
        crate::input::delete_db_parameter_group_input::Builder::default()
    }
    /// Creates a new `DeleteDBParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBParameterGroup {
    type Output = std::result::Result<
        crate::output::DeleteDbParameterGroupOutput,
        crate::error::DeleteDBParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_delete_db_parameter_group_response(response)
        }
    }
}

/// Operation shape for `DeleteDBProxy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_proxy`](crate::client::Client::delete_db_proxy).
///
/// See [`crate::client::fluent_builders::DeleteDBProxy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBProxy {
    _private: (),
}
impl DeleteDBProxy {
    /// Creates a new builder-style object to manufacture [`DeleteDbProxyInput`](crate::input::DeleteDbProxyInput)
    pub fn builder() -> crate::input::delete_db_proxy_input::Builder {
        crate::input::delete_db_proxy_input::Builder::default()
    }
    /// Creates a new `DeleteDBProxy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBProxy {
    type Output =
        std::result::Result<crate::output::DeleteDbProxyOutput, crate::error::DeleteDBProxyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_proxy_error(response)
        } else {
            crate::operation_deser::parse_delete_db_proxy_response(response)
        }
    }
}

/// Operation shape for `DeleteDBProxyEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_proxy_endpoint`](crate::client::Client::delete_db_proxy_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteDBProxyEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBProxyEndpoint {
    _private: (),
}
impl DeleteDBProxyEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteDbProxyEndpointInput`](crate::input::DeleteDbProxyEndpointInput)
    pub fn builder() -> crate::input::delete_db_proxy_endpoint_input::Builder {
        crate::input::delete_db_proxy_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteDBProxyEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBProxyEndpoint {
    type Output = std::result::Result<
        crate::output::DeleteDbProxyEndpointOutput,
        crate::error::DeleteDBProxyEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_proxy_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_db_proxy_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteDBSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_security_group`](crate::client::Client::delete_db_security_group).
///
/// See [`crate::client::fluent_builders::DeleteDBSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBSecurityGroup {
    _private: (),
}
impl DeleteDBSecurityGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDbSecurityGroupInput`](crate::input::DeleteDbSecurityGroupInput)
    pub fn builder() -> crate::input::delete_db_security_group_input::Builder {
        crate::input::delete_db_security_group_input::Builder::default()
    }
    /// Creates a new `DeleteDBSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBSecurityGroup {
    type Output = std::result::Result<
        crate::output::DeleteDbSecurityGroupOutput,
        crate::error::DeleteDBSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_security_group_error(response)
        } else {
            crate::operation_deser::parse_delete_db_security_group_response(response)
        }
    }
}

/// Operation shape for `DeleteDBSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_snapshot`](crate::client::Client::delete_db_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteDBSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBSnapshot {
    _private: (),
}
impl DeleteDBSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteDbSnapshotInput`](crate::input::DeleteDbSnapshotInput)
    pub fn builder() -> crate::input::delete_db_snapshot_input::Builder {
        crate::input::delete_db_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteDBSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteDbSnapshotOutput,
        crate::error::DeleteDBSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_db_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteDBSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_db_subnet_group`](crate::client::Client::delete_db_subnet_group).
///
/// See [`crate::client::fluent_builders::DeleteDBSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDBSubnetGroup {
    _private: (),
}
impl DeleteDBSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    pub fn builder() -> crate::input::delete_db_subnet_group_input::Builder {
        crate::input::delete_db_subnet_group_input::Builder::default()
    }
    /// Creates a new `DeleteDBSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDBSubnetGroup {
    type Output = std::result::Result<
        crate::output::DeleteDbSubnetGroupOutput,
        crate::error::DeleteDBSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_db_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_delete_db_subnet_group_response(response)
        }
    }
}

/// Operation shape for `DeleteEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_subscription`](crate::client::Client::delete_event_subscription).
///
/// See [`crate::client::fluent_builders::DeleteEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventSubscription {
    _private: (),
}
impl DeleteEventSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventSubscription {
    type Output = std::result::Result<
        crate::output::DeleteEventSubscriptionOutput,
        crate::error::DeleteEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_event_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_global_cluster`](crate::client::Client::delete_global_cluster).
///
/// See [`crate::client::fluent_builders::DeleteGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGlobalCluster {
    _private: (),
}
impl DeleteGlobalCluster {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
    pub fn builder() -> crate::input::delete_global_cluster_input::Builder {
        crate::input::delete_global_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGlobalCluster {
    type Output = std::result::Result<
        crate::output::DeleteGlobalClusterOutput,
        crate::error::DeleteGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_global_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteInstallationMedia`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_installation_media`](crate::client::Client::delete_installation_media).
///
/// See [`crate::client::fluent_builders::DeleteInstallationMedia`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstallationMedia {
    _private: (),
}
impl DeleteInstallationMedia {
    /// Creates a new builder-style object to manufacture [`DeleteInstallationMediaInput`](crate::input::DeleteInstallationMediaInput)
    pub fn builder() -> crate::input::delete_installation_media_input::Builder {
        crate::input::delete_installation_media_input::Builder::default()
    }
    /// Creates a new `DeleteInstallationMedia` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInstallationMedia {
    type Output = std::result::Result<
        crate::output::DeleteInstallationMediaOutput,
        crate::error::DeleteInstallationMediaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_installation_media_error(response)
        } else {
            crate::operation_deser::parse_delete_installation_media_response(response)
        }
    }
}

/// Operation shape for `DeleteOptionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_option_group`](crate::client::Client::delete_option_group).
///
/// See [`crate::client::fluent_builders::DeleteOptionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOptionGroup {
    _private: (),
}
impl DeleteOptionGroup {
    /// Creates a new builder-style object to manufacture [`DeleteOptionGroupInput`](crate::input::DeleteOptionGroupInput)
    pub fn builder() -> crate::input::delete_option_group_input::Builder {
        crate::input::delete_option_group_input::Builder::default()
    }
    /// Creates a new `DeleteOptionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOptionGroup {
    type Output = std::result::Result<
        crate::output::DeleteOptionGroupOutput,
        crate::error::DeleteOptionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_option_group_error(response)
        } else {
            crate::operation_deser::parse_delete_option_group_response(response)
        }
    }
}

/// Operation shape for `DeregisterDBProxyTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_db_proxy_targets`](crate::client::Client::deregister_db_proxy_targets).
///
/// See [`crate::client::fluent_builders::DeregisterDBProxyTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterDBProxyTargets {
    _private: (),
}
impl DeregisterDBProxyTargets {
    /// Creates a new builder-style object to manufacture [`DeregisterDbProxyTargetsInput`](crate::input::DeregisterDbProxyTargetsInput)
    pub fn builder() -> crate::input::deregister_db_proxy_targets_input::Builder {
        crate::input::deregister_db_proxy_targets_input::Builder::default()
    }
    /// Creates a new `DeregisterDBProxyTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterDBProxyTargets {
    type Output = std::result::Result<
        crate::output::DeregisterDbProxyTargetsOutput,
        crate::error::DeregisterDBProxyTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_db_proxy_targets_error(response)
        } else {
            crate::operation_deser::parse_deregister_db_proxy_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_attributes`](crate::client::Client::describe_account_attributes).
///
/// See [`crate::client::fluent_builders::DescribeAccountAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAttributes {
    _private: (),
}
impl DescribeAccountAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAttributes {
    type Output = std::result::Result<
        crate::output::DescribeAccountAttributesOutput,
        crate::error::DescribeAccountAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_account_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_certificates`](crate::client::Client::describe_certificates).
///
/// See [`crate::client::fluent_builders::DescribeCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCertificates {
    _private: (),
}
impl DescribeCertificates {
    /// Creates a new builder-style object to manufacture [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    pub fn builder() -> crate::input::describe_certificates_input::Builder {
        crate::input::describe_certificates_input::Builder::default()
    }
    /// Creates a new `DescribeCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCertificates {
    type Output = std::result::Result<
        crate::output::DescribeCertificatesOutput,
        crate::error::DescribeCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_certificates_error(response)
        } else {
            crate::operation_deser::parse_describe_certificates_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomAvailabilityZones`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_availability_zones`](crate::client::Client::describe_custom_availability_zones).
///
/// See [`crate::client::fluent_builders::DescribeCustomAvailabilityZones`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomAvailabilityZones {
    _private: (),
}
impl DescribeCustomAvailabilityZones {
    /// Creates a new builder-style object to manufacture [`DescribeCustomAvailabilityZonesInput`](crate::input::DescribeCustomAvailabilityZonesInput)
    pub fn builder() -> crate::input::describe_custom_availability_zones_input::Builder {
        crate::input::describe_custom_availability_zones_input::Builder::default()
    }
    /// Creates a new `DescribeCustomAvailabilityZones` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomAvailabilityZones {
    type Output = std::result::Result<
        crate::output::DescribeCustomAvailabilityZonesOutput,
        crate::error::DescribeCustomAvailabilityZonesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_availability_zones_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_availability_zones_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterBacktracks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_backtracks`](crate::client::Client::describe_db_cluster_backtracks).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterBacktracks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterBacktracks {
    _private: (),
}
impl DescribeDBClusterBacktracks {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterBacktracksInput`](crate::input::DescribeDbClusterBacktracksInput)
    pub fn builder() -> crate::input::describe_db_cluster_backtracks_input::Builder {
        crate::input::describe_db_cluster_backtracks_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterBacktracks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterBacktracks {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterBacktracksOutput,
        crate::error::DescribeDBClusterBacktracksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_backtracks_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_backtracks_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_endpoints`](crate::client::Client::describe_db_cluster_endpoints).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterEndpoints {
    _private: (),
}
impl DescribeDBClusterEndpoints {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
    pub fn builder() -> crate::input::describe_db_cluster_endpoints_input::Builder {
        crate::input::describe_db_cluster_endpoints_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterEndpoints {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterEndpointsOutput,
        crate::error::DescribeDBClusterEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_endpoints_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_endpoints_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterParameterGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_parameter_groups`](crate::client::Client::describe_db_cluster_parameter_groups).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterParameterGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterParameterGroups {
    _private: (),
}
impl DescribeDBClusterParameterGroups {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameter_groups_input::Builder {
        crate::input::describe_db_cluster_parameter_groups_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterParameterGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterParameterGroups {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterParameterGroupsOutput,
        crate::error::DescribeDBClusterParameterGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_parameter_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_parameter_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_parameters`](crate::client::Client::describe_db_cluster_parameters).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterParameters {
    _private: (),
}
impl DescribeDBClusterParameters {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameters_input::Builder {
        crate::input::describe_db_cluster_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterParameters {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterParametersOutput,
        crate::error::DescribeDBClusterParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_clusters`](crate::client::Client::describe_db_clusters).
///
/// See [`crate::client::fluent_builders::DescribeDBClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusters {
    _private: (),
}
impl DescribeDBClusters {
    /// Creates a new builder-style object to manufacture [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    pub fn builder() -> crate::input::describe_db_clusters_input::Builder {
        crate::input::describe_db_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusters {
    type Output = std::result::Result<
        crate::output::DescribeDbClustersOutput,
        crate::error::DescribeDBClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_db_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterSnapshotAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_snapshot_attributes`](crate::client::Client::describe_db_cluster_snapshot_attributes).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterSnapshotAttributes {
    _private: (),
}
impl DescribeDBClusterSnapshotAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshot_attributes_input::Builder {
        crate::input::describe_db_cluster_snapshot_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterSnapshotAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterSnapshotAttributes {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterSnapshotAttributesOutput,
        crate::error::DescribeDBClusterSnapshotAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_snapshot_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_snapshot_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeDBClusterSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_cluster_snapshots`](crate::client::Client::describe_db_cluster_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeDBClusterSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBClusterSnapshots {
    _private: (),
}
impl DescribeDBClusterSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshots_input::Builder {
        crate::input::describe_db_cluster_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeDBClusterSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBClusterSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeDbClusterSnapshotsOutput,
        crate::error::DescribeDBClusterSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_cluster_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_db_cluster_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeDBEngineVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_engine_versions`](crate::client::Client::describe_db_engine_versions).
///
/// See [`crate::client::fluent_builders::DescribeDBEngineVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBEngineVersions {
    _private: (),
}
impl DescribeDBEngineVersions {
    /// Creates a new builder-style object to manufacture [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    pub fn builder() -> crate::input::describe_db_engine_versions_input::Builder {
        crate::input::describe_db_engine_versions_input::Builder::default()
    }
    /// Creates a new `DescribeDBEngineVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBEngineVersions {
    type Output = std::result::Result<
        crate::output::DescribeDbEngineVersionsOutput,
        crate::error::DescribeDBEngineVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_engine_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_db_engine_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeDBInstanceAutomatedBackups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_instance_automated_backups`](crate::client::Client::describe_db_instance_automated_backups).
///
/// See [`crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBInstanceAutomatedBackups {
    _private: (),
}
impl DescribeDBInstanceAutomatedBackups {
    /// Creates a new builder-style object to manufacture [`DescribeDbInstanceAutomatedBackupsInput`](crate::input::DescribeDbInstanceAutomatedBackupsInput)
    pub fn builder() -> crate::input::describe_db_instance_automated_backups_input::Builder {
        crate::input::describe_db_instance_automated_backups_input::Builder::default()
    }
    /// Creates a new `DescribeDBInstanceAutomatedBackups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBInstanceAutomatedBackups {
    type Output = std::result::Result<
        crate::output::DescribeDbInstanceAutomatedBackupsOutput,
        crate::error::DescribeDBInstanceAutomatedBackupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_instance_automated_backups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_instance_automated_backups_response(response)
        }
    }
}

/// Operation shape for `DescribeDBInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_instances`](crate::client::Client::describe_db_instances).
///
/// See [`crate::client::fluent_builders::DescribeDBInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBInstances {
    _private: (),
}
impl DescribeDBInstances {
    /// Creates a new builder-style object to manufacture [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    pub fn builder() -> crate::input::describe_db_instances_input::Builder {
        crate::input::describe_db_instances_input::Builder::default()
    }
    /// Creates a new `DescribeDBInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBInstances {
    type Output = std::result::Result<
        crate::output::DescribeDbInstancesOutput,
        crate::error::DescribeDBInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_db_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeDBLogFiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_log_files`](crate::client::Client::describe_db_log_files).
///
/// See [`crate::client::fluent_builders::DescribeDBLogFiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBLogFiles {
    _private: (),
}
impl DescribeDBLogFiles {
    /// Creates a new builder-style object to manufacture [`DescribeDbLogFilesInput`](crate::input::DescribeDbLogFilesInput)
    pub fn builder() -> crate::input::describe_db_log_files_input::Builder {
        crate::input::describe_db_log_files_input::Builder::default()
    }
    /// Creates a new `DescribeDBLogFiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBLogFiles {
    type Output = std::result::Result<
        crate::output::DescribeDbLogFilesOutput,
        crate::error::DescribeDBLogFilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_log_files_error(response)
        } else {
            crate::operation_deser::parse_describe_db_log_files_response(response)
        }
    }
}

/// Operation shape for `DescribeDBParameterGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_parameter_groups`](crate::client::Client::describe_db_parameter_groups).
///
/// See [`crate::client::fluent_builders::DescribeDBParameterGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBParameterGroups {
    _private: (),
}
impl DescribeDBParameterGroups {
    /// Creates a new builder-style object to manufacture [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_parameter_groups_input::Builder {
        crate::input::describe_db_parameter_groups_input::Builder::default()
    }
    /// Creates a new `DescribeDBParameterGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBParameterGroups {
    type Output = std::result::Result<
        crate::output::DescribeDbParameterGroupsOutput,
        crate::error::DescribeDBParameterGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_parameter_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_parameter_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeDBParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_parameters`](crate::client::Client::describe_db_parameters).
///
/// See [`crate::client::fluent_builders::DescribeDBParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBParameters {
    _private: (),
}
impl DescribeDBParameters {
    /// Creates a new builder-style object to manufacture [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
    pub fn builder() -> crate::input::describe_db_parameters_input::Builder {
        crate::input::describe_db_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeDBParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBParameters {
    type Output = std::result::Result<
        crate::output::DescribeDbParametersOutput,
        crate::error::DescribeDBParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_db_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeDBProxies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_proxies`](crate::client::Client::describe_db_proxies).
///
/// See [`crate::client::fluent_builders::DescribeDBProxies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBProxies {
    _private: (),
}
impl DescribeDBProxies {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxiesInput`](crate::input::DescribeDbProxiesInput)
    pub fn builder() -> crate::input::describe_db_proxies_input::Builder {
        crate::input::describe_db_proxies_input::Builder::default()
    }
    /// Creates a new `DescribeDBProxies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBProxies {
    type Output = std::result::Result<
        crate::output::DescribeDbProxiesOutput,
        crate::error::DescribeDBProxiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_proxies_error(response)
        } else {
            crate::operation_deser::parse_describe_db_proxies_response(response)
        }
    }
}

/// Operation shape for `DescribeDBProxyEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_proxy_endpoints`](crate::client::Client::describe_db_proxy_endpoints).
///
/// See [`crate::client::fluent_builders::DescribeDBProxyEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBProxyEndpoints {
    _private: (),
}
impl DescribeDBProxyEndpoints {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyEndpointsInput`](crate::input::DescribeDbProxyEndpointsInput)
    pub fn builder() -> crate::input::describe_db_proxy_endpoints_input::Builder {
        crate::input::describe_db_proxy_endpoints_input::Builder::default()
    }
    /// Creates a new `DescribeDBProxyEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBProxyEndpoints {
    type Output = std::result::Result<
        crate::output::DescribeDbProxyEndpointsOutput,
        crate::error::DescribeDBProxyEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_proxy_endpoints_error(response)
        } else {
            crate::operation_deser::parse_describe_db_proxy_endpoints_response(response)
        }
    }
}

/// Operation shape for `DescribeDBProxyTargetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_proxy_target_groups`](crate::client::Client::describe_db_proxy_target_groups).
///
/// See [`crate::client::fluent_builders::DescribeDBProxyTargetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBProxyTargetGroups {
    _private: (),
}
impl DescribeDBProxyTargetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyTargetGroupsInput`](crate::input::DescribeDbProxyTargetGroupsInput)
    pub fn builder() -> crate::input::describe_db_proxy_target_groups_input::Builder {
        crate::input::describe_db_proxy_target_groups_input::Builder::default()
    }
    /// Creates a new `DescribeDBProxyTargetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBProxyTargetGroups {
    type Output = std::result::Result<
        crate::output::DescribeDbProxyTargetGroupsOutput,
        crate::error::DescribeDBProxyTargetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_proxy_target_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_proxy_target_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeDBProxyTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_proxy_targets`](crate::client::Client::describe_db_proxy_targets).
///
/// See [`crate::client::fluent_builders::DescribeDBProxyTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBProxyTargets {
    _private: (),
}
impl DescribeDBProxyTargets {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyTargetsInput`](crate::input::DescribeDbProxyTargetsInput)
    pub fn builder() -> crate::input::describe_db_proxy_targets_input::Builder {
        crate::input::describe_db_proxy_targets_input::Builder::default()
    }
    /// Creates a new `DescribeDBProxyTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBProxyTargets {
    type Output = std::result::Result<
        crate::output::DescribeDbProxyTargetsOutput,
        crate::error::DescribeDBProxyTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_proxy_targets_error(response)
        } else {
            crate::operation_deser::parse_describe_db_proxy_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeDBSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_security_groups`](crate::client::Client::describe_db_security_groups).
///
/// See [`crate::client::fluent_builders::DescribeDBSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBSecurityGroups {
    _private: (),
}
impl DescribeDBSecurityGroups {
    /// Creates a new builder-style object to manufacture [`DescribeDbSecurityGroupsInput`](crate::input::DescribeDbSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_db_security_groups_input::Builder {
        crate::input::describe_db_security_groups_input::Builder::default()
    }
    /// Creates a new `DescribeDBSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBSecurityGroups {
    type Output = std::result::Result<
        crate::output::DescribeDbSecurityGroupsOutput,
        crate::error::DescribeDBSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_security_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_security_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeDBSnapshotAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_snapshot_attributes`](crate::client::Client::describe_db_snapshot_attributes).
///
/// See [`crate::client::fluent_builders::DescribeDBSnapshotAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBSnapshotAttributes {
    _private: (),
}
impl DescribeDBSnapshotAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeDbSnapshotAttributesInput`](crate::input::DescribeDbSnapshotAttributesInput)
    pub fn builder() -> crate::input::describe_db_snapshot_attributes_input::Builder {
        crate::input::describe_db_snapshot_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeDBSnapshotAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBSnapshotAttributes {
    type Output = std::result::Result<
        crate::output::DescribeDbSnapshotAttributesOutput,
        crate::error::DescribeDBSnapshotAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_snapshot_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_db_snapshot_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeDBSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_snapshots`](crate::client::Client::describe_db_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeDBSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBSnapshots {
    _private: (),
}
impl DescribeDBSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeDbSnapshotsInput`](crate::input::DescribeDbSnapshotsInput)
    pub fn builder() -> crate::input::describe_db_snapshots_input::Builder {
        crate::input::describe_db_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeDBSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeDbSnapshotsOutput,
        crate::error::DescribeDBSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_db_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeDBSubnetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_db_subnet_groups`](crate::client::Client::describe_db_subnet_groups).
///
/// See [`crate::client::fluent_builders::DescribeDBSubnetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDBSubnetGroups {
    _private: (),
}
impl DescribeDBSubnetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_db_subnet_groups_input::Builder {
        crate::input::describe_db_subnet_groups_input::Builder::default()
    }
    /// Creates a new `DescribeDBSubnetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDBSubnetGroups {
    type Output = std::result::Result<
        crate::output::DescribeDbSubnetGroupsOutput,
        crate::error::DescribeDBSubnetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_db_subnet_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_db_subnet_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeEngineDefaultClusterParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_engine_default_cluster_parameters`](crate::client::Client::describe_engine_default_cluster_parameters).
///
/// See [`crate::client::fluent_builders::DescribeEngineDefaultClusterParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEngineDefaultClusterParameters {
    _private: (),
}
impl DescribeEngineDefaultClusterParameters {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_cluster_parameters_input::Builder {
        crate::input::describe_engine_default_cluster_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeEngineDefaultClusterParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEngineDefaultClusterParameters {
    type Output = std::result::Result<
        crate::output::DescribeEngineDefaultClusterParametersOutput,
        crate::error::DescribeEngineDefaultClusterParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_engine_default_cluster_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_engine_default_cluster_parameters_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeEngineDefaultParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_engine_default_parameters`](crate::client::Client::describe_engine_default_parameters).
///
/// See [`crate::client::fluent_builders::DescribeEngineDefaultParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEngineDefaultParameters {
    _private: (),
}
impl DescribeEngineDefaultParameters {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_parameters_input::Builder {
        crate::input::describe_engine_default_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeEngineDefaultParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEngineDefaultParameters {
    type Output = std::result::Result<
        crate::output::DescribeEngineDefaultParametersOutput,
        crate::error::DescribeEngineDefaultParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_engine_default_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_engine_default_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeEventCategories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_categories`](crate::client::Client::describe_event_categories).
///
/// See [`crate::client::fluent_builders::DescribeEventCategories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventCategories {
    _private: (),
}
impl DescribeEventCategories {
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
    /// Creates a new `DescribeEventCategories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventCategories {
    type Output = std::result::Result<
        crate::output::DescribeEventCategoriesOutput,
        crate::error::DescribeEventCategoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_categories_error(response)
        } else {
            crate::operation_deser::parse_describe_event_categories_response(response)
        }
    }
}

/// Operation shape for `DescribeEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events`](crate::client::Client::describe_events).
///
/// See [`crate::client::fluent_builders::DescribeEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEvents {
    _private: (),
}
impl DescribeEvents {
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
    /// Creates a new `DescribeEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEvents {
    type Output =
        std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_error(response)
        } else {
            crate::operation_deser::parse_describe_events_response(response)
        }
    }
}

/// Operation shape for `DescribeEventSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_subscriptions`](crate::client::Client::describe_event_subscriptions).
///
/// See [`crate::client::fluent_builders::DescribeEventSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventSubscriptions {
    _private: (),
}
impl DescribeEventSubscriptions {
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
    /// Creates a new `DescribeEventSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventSubscriptions {
    type Output = std::result::Result<
        crate::output::DescribeEventSubscriptionsOutput,
        crate::error::DescribeEventSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_describe_event_subscriptions_response(response)
        }
    }
}

/// Operation shape for `DescribeExportTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_export_tasks`](crate::client::Client::describe_export_tasks).
///
/// See [`crate::client::fluent_builders::DescribeExportTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExportTasks {
    _private: (),
}
impl DescribeExportTasks {
    /// Creates a new builder-style object to manufacture [`DescribeExportTasksInput`](crate::input::DescribeExportTasksInput)
    pub fn builder() -> crate::input::describe_export_tasks_input::Builder {
        crate::input::describe_export_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeExportTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExportTasks {
    type Output = std::result::Result<
        crate::output::DescribeExportTasksOutput,
        crate::error::DescribeExportTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_export_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_export_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_clusters`](crate::client::Client::describe_global_clusters).
///
/// See [`crate::client::fluent_builders::DescribeGlobalClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalClusters {
    _private: (),
}
impl DescribeGlobalClusters {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalClustersInput`](crate::input::DescribeGlobalClustersInput)
    pub fn builder() -> crate::input::describe_global_clusters_input::Builder {
        crate::input::describe_global_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalClusters {
    type Output = std::result::Result<
        crate::output::DescribeGlobalClustersOutput,
        crate::error::DescribeGlobalClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_global_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeInstallationMedia`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_installation_media`](crate::client::Client::describe_installation_media).
///
/// See [`crate::client::fluent_builders::DescribeInstallationMedia`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstallationMedia {
    _private: (),
}
impl DescribeInstallationMedia {
    /// Creates a new builder-style object to manufacture [`DescribeInstallationMediaInput`](crate::input::DescribeInstallationMediaInput)
    pub fn builder() -> crate::input::describe_installation_media_input::Builder {
        crate::input::describe_installation_media_input::Builder::default()
    }
    /// Creates a new `DescribeInstallationMedia` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstallationMedia {
    type Output = std::result::Result<
        crate::output::DescribeInstallationMediaOutput,
        crate::error::DescribeInstallationMediaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_installation_media_error(response)
        } else {
            crate::operation_deser::parse_describe_installation_media_response(response)
        }
    }
}

/// Operation shape for `DescribeOptionGroupOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_option_group_options`](crate::client::Client::describe_option_group_options).
///
/// See [`crate::client::fluent_builders::DescribeOptionGroupOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOptionGroupOptions {
    _private: (),
}
impl DescribeOptionGroupOptions {
    /// Creates a new builder-style object to manufacture [`DescribeOptionGroupOptionsInput`](crate::input::DescribeOptionGroupOptionsInput)
    pub fn builder() -> crate::input::describe_option_group_options_input::Builder {
        crate::input::describe_option_group_options_input::Builder::default()
    }
    /// Creates a new `DescribeOptionGroupOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOptionGroupOptions {
    type Output = std::result::Result<
        crate::output::DescribeOptionGroupOptionsOutput,
        crate::error::DescribeOptionGroupOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_option_group_options_error(response)
        } else {
            crate::operation_deser::parse_describe_option_group_options_response(response)
        }
    }
}

/// Operation shape for `DescribeOptionGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_option_groups`](crate::client::Client::describe_option_groups).
///
/// See [`crate::client::fluent_builders::DescribeOptionGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOptionGroups {
    _private: (),
}
impl DescribeOptionGroups {
    /// Creates a new builder-style object to manufacture [`DescribeOptionGroupsInput`](crate::input::DescribeOptionGroupsInput)
    pub fn builder() -> crate::input::describe_option_groups_input::Builder {
        crate::input::describe_option_groups_input::Builder::default()
    }
    /// Creates a new `DescribeOptionGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOptionGroups {
    type Output = std::result::Result<
        crate::output::DescribeOptionGroupsOutput,
        crate::error::DescribeOptionGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_option_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_option_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeOrderableDBInstanceOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_orderable_db_instance_options`](crate::client::Client::describe_orderable_db_instance_options).
///
/// See [`crate::client::fluent_builders::DescribeOrderableDBInstanceOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrderableDBInstanceOptions {
    _private: (),
}
impl DescribeOrderableDBInstanceOptions {
    /// Creates a new builder-style object to manufacture [`DescribeOrderableDbInstanceOptionsInput`](crate::input::DescribeOrderableDbInstanceOptionsInput)
    pub fn builder() -> crate::input::describe_orderable_db_instance_options_input::Builder {
        crate::input::describe_orderable_db_instance_options_input::Builder::default()
    }
    /// Creates a new `DescribeOrderableDBInstanceOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrderableDBInstanceOptions {
    type Output = std::result::Result<
        crate::output::DescribeOrderableDbInstanceOptionsOutput,
        crate::error::DescribeOrderableDBInstanceOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_orderable_db_instance_options_error(response)
        } else {
            crate::operation_deser::parse_describe_orderable_db_instance_options_response(response)
        }
    }
}

/// Operation shape for `DescribePendingMaintenanceActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pending_maintenance_actions`](crate::client::Client::describe_pending_maintenance_actions).
///
/// See [`crate::client::fluent_builders::DescribePendingMaintenanceActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePendingMaintenanceActions {
    _private: (),
}
impl DescribePendingMaintenanceActions {
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    pub fn builder() -> crate::input::describe_pending_maintenance_actions_input::Builder {
        crate::input::describe_pending_maintenance_actions_input::Builder::default()
    }
    /// Creates a new `DescribePendingMaintenanceActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePendingMaintenanceActions {
    type Output = std::result::Result<
        crate::output::DescribePendingMaintenanceActionsOutput,
        crate::error::DescribePendingMaintenanceActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pending_maintenance_actions_error(response)
        } else {
            crate::operation_deser::parse_describe_pending_maintenance_actions_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedDBInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_db_instances`](crate::client::Client::describe_reserved_db_instances).
///
/// See [`crate::client::fluent_builders::DescribeReservedDBInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedDBInstances {
    _private: (),
}
impl DescribeReservedDBInstances {
    /// Creates a new builder-style object to manufacture [`DescribeReservedDbInstancesInput`](crate::input::DescribeReservedDbInstancesInput)
    pub fn builder() -> crate::input::describe_reserved_db_instances_input::Builder {
        crate::input::describe_reserved_db_instances_input::Builder::default()
    }
    /// Creates a new `DescribeReservedDBInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedDBInstances {
    type Output = std::result::Result<
        crate::output::DescribeReservedDbInstancesOutput,
        crate::error::DescribeReservedDBInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_db_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_db_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedDBInstancesOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_db_instances_offerings`](crate::client::Client::describe_reserved_db_instances_offerings).
///
/// See [`crate::client::fluent_builders::DescribeReservedDBInstancesOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedDBInstancesOfferings {
    _private: (),
}
impl DescribeReservedDBInstancesOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeReservedDbInstancesOfferingsInput`](crate::input::DescribeReservedDbInstancesOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_db_instances_offerings_input::Builder {
        crate::input::describe_reserved_db_instances_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeReservedDBInstancesOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedDBInstancesOfferings {
    type Output = std::result::Result<
        crate::output::DescribeReservedDbInstancesOfferingsOutput,
        crate::error::DescribeReservedDBInstancesOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_db_instances_offerings_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_db_instances_offerings_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeSourceRegions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_source_regions`](crate::client::Client::describe_source_regions).
///
/// See [`crate::client::fluent_builders::DescribeSourceRegions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSourceRegions {
    _private: (),
}
impl DescribeSourceRegions {
    /// Creates a new builder-style object to manufacture [`DescribeSourceRegionsInput`](crate::input::DescribeSourceRegionsInput)
    pub fn builder() -> crate::input::describe_source_regions_input::Builder {
        crate::input::describe_source_regions_input::Builder::default()
    }
    /// Creates a new `DescribeSourceRegions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSourceRegions {
    type Output = std::result::Result<
        crate::output::DescribeSourceRegionsOutput,
        crate::error::DescribeSourceRegionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_source_regions_error(response)
        } else {
            crate::operation_deser::parse_describe_source_regions_response(response)
        }
    }
}

/// Operation shape for `DescribeValidDBInstanceModifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_valid_db_instance_modifications`](crate::client::Client::describe_valid_db_instance_modifications).
///
/// See [`crate::client::fluent_builders::DescribeValidDBInstanceModifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeValidDBInstanceModifications {
    _private: (),
}
impl DescribeValidDBInstanceModifications {
    /// Creates a new builder-style object to manufacture [`DescribeValidDbInstanceModificationsInput`](crate::input::DescribeValidDbInstanceModificationsInput)
    pub fn builder() -> crate::input::describe_valid_db_instance_modifications_input::Builder {
        crate::input::describe_valid_db_instance_modifications_input::Builder::default()
    }
    /// Creates a new `DescribeValidDBInstanceModifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeValidDBInstanceModifications {
    type Output = std::result::Result<
        crate::output::DescribeValidDbInstanceModificationsOutput,
        crate::error::DescribeValidDBInstanceModificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_valid_db_instance_modifications_error(response)
        } else {
            crate::operation_deser::parse_describe_valid_db_instance_modifications_response(
                response,
            )
        }
    }
}

/// Operation shape for `DownloadDBLogFilePortion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`download_db_log_file_portion`](crate::client::Client::download_db_log_file_portion).
///
/// See [`crate::client::fluent_builders::DownloadDBLogFilePortion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DownloadDBLogFilePortion {
    _private: (),
}
impl DownloadDBLogFilePortion {
    /// Creates a new builder-style object to manufacture [`DownloadDbLogFilePortionInput`](crate::input::DownloadDbLogFilePortionInput)
    pub fn builder() -> crate::input::download_db_log_file_portion_input::Builder {
        crate::input::download_db_log_file_portion_input::Builder::default()
    }
    /// Creates a new `DownloadDBLogFilePortion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DownloadDBLogFilePortion {
    type Output = std::result::Result<
        crate::output::DownloadDbLogFilePortionOutput,
        crate::error::DownloadDBLogFilePortionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_download_db_log_file_portion_error(response)
        } else {
            crate::operation_deser::parse_download_db_log_file_portion_response(response)
        }
    }
}

/// Operation shape for `FailoverDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`failover_db_cluster`](crate::client::Client::failover_db_cluster).
///
/// See [`crate::client::fluent_builders::FailoverDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FailoverDBCluster {
    _private: (),
}
impl FailoverDBCluster {
    /// Creates a new builder-style object to manufacture [`FailoverDbClusterInput`](crate::input::FailoverDbClusterInput)
    pub fn builder() -> crate::input::failover_db_cluster_input::Builder {
        crate::input::failover_db_cluster_input::Builder::default()
    }
    /// Creates a new `FailoverDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FailoverDBCluster {
    type Output = std::result::Result<
        crate::output::FailoverDbClusterOutput,
        crate::error::FailoverDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_failover_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_failover_db_cluster_response(response)
        }
    }
}

/// Operation shape for `FailoverGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`failover_global_cluster`](crate::client::Client::failover_global_cluster).
///
/// See [`crate::client::fluent_builders::FailoverGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FailoverGlobalCluster {
    _private: (),
}
impl FailoverGlobalCluster {
    /// Creates a new builder-style object to manufacture [`FailoverGlobalClusterInput`](crate::input::FailoverGlobalClusterInput)
    pub fn builder() -> crate::input::failover_global_cluster_input::Builder {
        crate::input::failover_global_cluster_input::Builder::default()
    }
    /// Creates a new `FailoverGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FailoverGlobalCluster {
    type Output = std::result::Result<
        crate::output::FailoverGlobalClusterOutput,
        crate::error::FailoverGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_failover_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_failover_global_cluster_response(response)
        }
    }
}

/// Operation shape for `ImportInstallationMedia`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_installation_media`](crate::client::Client::import_installation_media).
///
/// See [`crate::client::fluent_builders::ImportInstallationMedia`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportInstallationMedia {
    _private: (),
}
impl ImportInstallationMedia {
    /// Creates a new builder-style object to manufacture [`ImportInstallationMediaInput`](crate::input::ImportInstallationMediaInput)
    pub fn builder() -> crate::input::import_installation_media_input::Builder {
        crate::input::import_installation_media_input::Builder::default()
    }
    /// Creates a new `ImportInstallationMedia` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportInstallationMedia {
    type Output = std::result::Result<
        crate::output::ImportInstallationMediaOutput,
        crate::error::ImportInstallationMediaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_installation_media_error(response)
        } else {
            crate::operation_deser::parse_import_installation_media_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ModifyCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_certificates`](crate::client::Client::modify_certificates).
///
/// See [`crate::client::fluent_builders::ModifyCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCertificates {
    _private: (),
}
impl ModifyCertificates {
    /// Creates a new builder-style object to manufacture [`ModifyCertificatesInput`](crate::input::ModifyCertificatesInput)
    pub fn builder() -> crate::input::modify_certificates_input::Builder {
        crate::input::modify_certificates_input::Builder::default()
    }
    /// Creates a new `ModifyCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCertificates {
    type Output = std::result::Result<
        crate::output::ModifyCertificatesOutput,
        crate::error::ModifyCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_certificates_error(response)
        } else {
            crate::operation_deser::parse_modify_certificates_response(response)
        }
    }
}

/// Operation shape for `ModifyCurrentDBClusterCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_current_db_cluster_capacity`](crate::client::Client::modify_current_db_cluster_capacity).
///
/// See [`crate::client::fluent_builders::ModifyCurrentDBClusterCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCurrentDBClusterCapacity {
    _private: (),
}
impl ModifyCurrentDBClusterCapacity {
    /// Creates a new builder-style object to manufacture [`ModifyCurrentDbClusterCapacityInput`](crate::input::ModifyCurrentDbClusterCapacityInput)
    pub fn builder() -> crate::input::modify_current_db_cluster_capacity_input::Builder {
        crate::input::modify_current_db_cluster_capacity_input::Builder::default()
    }
    /// Creates a new `ModifyCurrentDBClusterCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCurrentDBClusterCapacity {
    type Output = std::result::Result<
        crate::output::ModifyCurrentDbClusterCapacityOutput,
        crate::error::ModifyCurrentDBClusterCapacityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_current_db_cluster_capacity_error(response)
        } else {
            crate::operation_deser::parse_modify_current_db_cluster_capacity_response(response)
        }
    }
}

/// Operation shape for `ModifyCustomDBEngineVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_custom_db_engine_version`](crate::client::Client::modify_custom_db_engine_version).
///
/// See [`crate::client::fluent_builders::ModifyCustomDBEngineVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCustomDBEngineVersion {
    _private: (),
}
impl ModifyCustomDBEngineVersion {
    /// Creates a new builder-style object to manufacture [`ModifyCustomDbEngineVersionInput`](crate::input::ModifyCustomDbEngineVersionInput)
    pub fn builder() -> crate::input::modify_custom_db_engine_version_input::Builder {
        crate::input::modify_custom_db_engine_version_input::Builder::default()
    }
    /// Creates a new `ModifyCustomDBEngineVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCustomDBEngineVersion {
    type Output = std::result::Result<
        crate::output::ModifyCustomDbEngineVersionOutput,
        crate::error::ModifyCustomDBEngineVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_custom_db_engine_version_error(response)
        } else {
            crate::operation_deser::parse_modify_custom_db_engine_version_response(response)
        }
    }
}

/// Operation shape for `ModifyDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_cluster`](crate::client::Client::modify_db_cluster).
///
/// See [`crate::client::fluent_builders::ModifyDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBCluster {
    _private: (),
}
impl ModifyDBCluster {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterInput`](crate::input::ModifyDbClusterInput)
    pub fn builder() -> crate::input::modify_db_cluster_input::Builder {
        crate::input::modify_db_cluster_input::Builder::default()
    }
    /// Creates a new `ModifyDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBCluster {
    type Output = std::result::Result<
        crate::output::ModifyDbClusterOutput,
        crate::error::ModifyDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_modify_db_cluster_response(response)
        }
    }
}

/// Operation shape for `ModifyDBClusterEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_cluster_endpoint`](crate::client::Client::modify_db_cluster_endpoint).
///
/// See [`crate::client::fluent_builders::ModifyDBClusterEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBClusterEndpoint {
    _private: (),
}
impl ModifyDBClusterEndpoint {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterEndpointInput`](crate::input::ModifyDbClusterEndpointInput)
    pub fn builder() -> crate::input::modify_db_cluster_endpoint_input::Builder {
        crate::input::modify_db_cluster_endpoint_input::Builder::default()
    }
    /// Creates a new `ModifyDBClusterEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBClusterEndpoint {
    type Output = std::result::Result<
        crate::output::ModifyDbClusterEndpointOutput,
        crate::error::ModifyDBClusterEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_cluster_endpoint_error(response)
        } else {
            crate::operation_deser::parse_modify_db_cluster_endpoint_response(response)
        }
    }
}

/// Operation shape for `ModifyDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_cluster_parameter_group`](crate::client::Client::modify_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::ModifyDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBClusterParameterGroup {
    _private: (),
}
impl ModifyDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterParameterGroupInput`](crate::input::ModifyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::modify_db_cluster_parameter_group_input::Builder {
        crate::input::modify_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `ModifyDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::ModifyDbClusterParameterGroupOutput,
        crate::error::ModifyDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_modify_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `ModifyDBClusterSnapshotAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_cluster_snapshot_attribute`](crate::client::Client::modify_db_cluster_snapshot_attribute).
///
/// See [`crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBClusterSnapshotAttribute {
    _private: (),
}
impl ModifyDBClusterSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterSnapshotAttributeInput`](crate::input::ModifyDbClusterSnapshotAttributeInput)
    pub fn builder() -> crate::input::modify_db_cluster_snapshot_attribute_input::Builder {
        crate::input::modify_db_cluster_snapshot_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyDBClusterSnapshotAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBClusterSnapshotAttribute {
    type Output = std::result::Result<
        crate::output::ModifyDbClusterSnapshotAttributeOutput,
        crate::error::ModifyDBClusterSnapshotAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_cluster_snapshot_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_db_cluster_snapshot_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_instance`](crate::client::Client::modify_db_instance).
///
/// See [`crate::client::fluent_builders::ModifyDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBInstance {
    _private: (),
}
impl ModifyDBInstance {
    /// Creates a new builder-style object to manufacture [`ModifyDbInstanceInput`](crate::input::ModifyDbInstanceInput)
    pub fn builder() -> crate::input::modify_db_instance_input::Builder {
        crate::input::modify_db_instance_input::Builder::default()
    }
    /// Creates a new `ModifyDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBInstance {
    type Output = std::result::Result<
        crate::output::ModifyDbInstanceOutput,
        crate::error::ModifyDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_instance_error(response)
        } else {
            crate::operation_deser::parse_modify_db_instance_response(response)
        }
    }
}

/// Operation shape for `ModifyDBParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_parameter_group`](crate::client::Client::modify_db_parameter_group).
///
/// See [`crate::client::fluent_builders::ModifyDBParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBParameterGroup {
    _private: (),
}
impl ModifyDBParameterGroup {
    /// Creates a new builder-style object to manufacture [`ModifyDbParameterGroupInput`](crate::input::ModifyDbParameterGroupInput)
    pub fn builder() -> crate::input::modify_db_parameter_group_input::Builder {
        crate::input::modify_db_parameter_group_input::Builder::default()
    }
    /// Creates a new `ModifyDBParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBParameterGroup {
    type Output = std::result::Result<
        crate::output::ModifyDbParameterGroupOutput,
        crate::error::ModifyDBParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_modify_db_parameter_group_response(response)
        }
    }
}

/// Operation shape for `ModifyDBProxy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_proxy`](crate::client::Client::modify_db_proxy).
///
/// See [`crate::client::fluent_builders::ModifyDBProxy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBProxy {
    _private: (),
}
impl ModifyDBProxy {
    /// Creates a new builder-style object to manufacture [`ModifyDbProxyInput`](crate::input::ModifyDbProxyInput)
    pub fn builder() -> crate::input::modify_db_proxy_input::Builder {
        crate::input::modify_db_proxy_input::Builder::default()
    }
    /// Creates a new `ModifyDBProxy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBProxy {
    type Output =
        std::result::Result<crate::output::ModifyDbProxyOutput, crate::error::ModifyDBProxyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_proxy_error(response)
        } else {
            crate::operation_deser::parse_modify_db_proxy_response(response)
        }
    }
}

/// Operation shape for `ModifyDBProxyEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_proxy_endpoint`](crate::client::Client::modify_db_proxy_endpoint).
///
/// See [`crate::client::fluent_builders::ModifyDBProxyEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBProxyEndpoint {
    _private: (),
}
impl ModifyDBProxyEndpoint {
    /// Creates a new builder-style object to manufacture [`ModifyDbProxyEndpointInput`](crate::input::ModifyDbProxyEndpointInput)
    pub fn builder() -> crate::input::modify_db_proxy_endpoint_input::Builder {
        crate::input::modify_db_proxy_endpoint_input::Builder::default()
    }
    /// Creates a new `ModifyDBProxyEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBProxyEndpoint {
    type Output = std::result::Result<
        crate::output::ModifyDbProxyEndpointOutput,
        crate::error::ModifyDBProxyEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_proxy_endpoint_error(response)
        } else {
            crate::operation_deser::parse_modify_db_proxy_endpoint_response(response)
        }
    }
}

/// Operation shape for `ModifyDBProxyTargetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_proxy_target_group`](crate::client::Client::modify_db_proxy_target_group).
///
/// See [`crate::client::fluent_builders::ModifyDBProxyTargetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBProxyTargetGroup {
    _private: (),
}
impl ModifyDBProxyTargetGroup {
    /// Creates a new builder-style object to manufacture [`ModifyDbProxyTargetGroupInput`](crate::input::ModifyDbProxyTargetGroupInput)
    pub fn builder() -> crate::input::modify_db_proxy_target_group_input::Builder {
        crate::input::modify_db_proxy_target_group_input::Builder::default()
    }
    /// Creates a new `ModifyDBProxyTargetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBProxyTargetGroup {
    type Output = std::result::Result<
        crate::output::ModifyDbProxyTargetGroupOutput,
        crate::error::ModifyDBProxyTargetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_proxy_target_group_error(response)
        } else {
            crate::operation_deser::parse_modify_db_proxy_target_group_response(response)
        }
    }
}

/// Operation shape for `ModifyDBSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_snapshot`](crate::client::Client::modify_db_snapshot).
///
/// See [`crate::client::fluent_builders::ModifyDBSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBSnapshot {
    _private: (),
}
impl ModifyDBSnapshot {
    /// Creates a new builder-style object to manufacture [`ModifyDbSnapshotInput`](crate::input::ModifyDbSnapshotInput)
    pub fn builder() -> crate::input::modify_db_snapshot_input::Builder {
        crate::input::modify_db_snapshot_input::Builder::default()
    }
    /// Creates a new `ModifyDBSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBSnapshot {
    type Output = std::result::Result<
        crate::output::ModifyDbSnapshotOutput,
        crate::error::ModifyDBSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_snapshot_error(response)
        } else {
            crate::operation_deser::parse_modify_db_snapshot_response(response)
        }
    }
}

/// Operation shape for `ModifyDBSnapshotAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_snapshot_attribute`](crate::client::Client::modify_db_snapshot_attribute).
///
/// See [`crate::client::fluent_builders::ModifyDBSnapshotAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBSnapshotAttribute {
    _private: (),
}
impl ModifyDBSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyDbSnapshotAttributeInput`](crate::input::ModifyDbSnapshotAttributeInput)
    pub fn builder() -> crate::input::modify_db_snapshot_attribute_input::Builder {
        crate::input::modify_db_snapshot_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyDBSnapshotAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBSnapshotAttribute {
    type Output = std::result::Result<
        crate::output::ModifyDbSnapshotAttributeOutput,
        crate::error::ModifyDBSnapshotAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_snapshot_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_db_snapshot_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyDBSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_db_subnet_group`](crate::client::Client::modify_db_subnet_group).
///
/// See [`crate::client::fluent_builders::ModifyDBSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDBSubnetGroup {
    _private: (),
}
impl ModifyDBSubnetGroup {
    /// Creates a new builder-style object to manufacture [`ModifyDbSubnetGroupInput`](crate::input::ModifyDbSubnetGroupInput)
    pub fn builder() -> crate::input::modify_db_subnet_group_input::Builder {
        crate::input::modify_db_subnet_group_input::Builder::default()
    }
    /// Creates a new `ModifyDBSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDBSubnetGroup {
    type Output = std::result::Result<
        crate::output::ModifyDbSubnetGroupOutput,
        crate::error::ModifyDBSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_db_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_modify_db_subnet_group_response(response)
        }
    }
}

/// Operation shape for `ModifyEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_event_subscription`](crate::client::Client::modify_event_subscription).
///
/// See [`crate::client::fluent_builders::ModifyEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyEventSubscription {
    _private: (),
}
impl ModifyEventSubscription {
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    pub fn builder() -> crate::input::modify_event_subscription_input::Builder {
        crate::input::modify_event_subscription_input::Builder::default()
    }
    /// Creates a new `ModifyEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyEventSubscription {
    type Output = std::result::Result<
        crate::output::ModifyEventSubscriptionOutput,
        crate::error::ModifyEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_modify_event_subscription_response(response)
        }
    }
}

/// Operation shape for `ModifyGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_global_cluster`](crate::client::Client::modify_global_cluster).
///
/// See [`crate::client::fluent_builders::ModifyGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyGlobalCluster {
    _private: (),
}
impl ModifyGlobalCluster {
    /// Creates a new builder-style object to manufacture [`ModifyGlobalClusterInput`](crate::input::ModifyGlobalClusterInput)
    pub fn builder() -> crate::input::modify_global_cluster_input::Builder {
        crate::input::modify_global_cluster_input::Builder::default()
    }
    /// Creates a new `ModifyGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyGlobalCluster {
    type Output = std::result::Result<
        crate::output::ModifyGlobalClusterOutput,
        crate::error::ModifyGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_modify_global_cluster_response(response)
        }
    }
}

/// Operation shape for `ModifyOptionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_option_group`](crate::client::Client::modify_option_group).
///
/// See [`crate::client::fluent_builders::ModifyOptionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyOptionGroup {
    _private: (),
}
impl ModifyOptionGroup {
    /// Creates a new builder-style object to manufacture [`ModifyOptionGroupInput`](crate::input::ModifyOptionGroupInput)
    pub fn builder() -> crate::input::modify_option_group_input::Builder {
        crate::input::modify_option_group_input::Builder::default()
    }
    /// Creates a new `ModifyOptionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyOptionGroup {
    type Output = std::result::Result<
        crate::output::ModifyOptionGroupOutput,
        crate::error::ModifyOptionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_option_group_error(response)
        } else {
            crate::operation_deser::parse_modify_option_group_response(response)
        }
    }
}

/// Operation shape for `PromoteReadReplica`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`promote_read_replica`](crate::client::Client::promote_read_replica).
///
/// See [`crate::client::fluent_builders::PromoteReadReplica`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PromoteReadReplica {
    _private: (),
}
impl PromoteReadReplica {
    /// Creates a new builder-style object to manufacture [`PromoteReadReplicaInput`](crate::input::PromoteReadReplicaInput)
    pub fn builder() -> crate::input::promote_read_replica_input::Builder {
        crate::input::promote_read_replica_input::Builder::default()
    }
    /// Creates a new `PromoteReadReplica` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PromoteReadReplica {
    type Output = std::result::Result<
        crate::output::PromoteReadReplicaOutput,
        crate::error::PromoteReadReplicaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_promote_read_replica_error(response)
        } else {
            crate::operation_deser::parse_promote_read_replica_response(response)
        }
    }
}

/// Operation shape for `PromoteReadReplicaDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`promote_read_replica_db_cluster`](crate::client::Client::promote_read_replica_db_cluster).
///
/// See [`crate::client::fluent_builders::PromoteReadReplicaDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PromoteReadReplicaDBCluster {
    _private: (),
}
impl PromoteReadReplicaDBCluster {
    /// Creates a new builder-style object to manufacture [`PromoteReadReplicaDbClusterInput`](crate::input::PromoteReadReplicaDbClusterInput)
    pub fn builder() -> crate::input::promote_read_replica_db_cluster_input::Builder {
        crate::input::promote_read_replica_db_cluster_input::Builder::default()
    }
    /// Creates a new `PromoteReadReplicaDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PromoteReadReplicaDBCluster {
    type Output = std::result::Result<
        crate::output::PromoteReadReplicaDbClusterOutput,
        crate::error::PromoteReadReplicaDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_promote_read_replica_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_promote_read_replica_db_cluster_response(response)
        }
    }
}

/// Operation shape for `PurchaseReservedDBInstancesOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_reserved_db_instances_offering`](crate::client::Client::purchase_reserved_db_instances_offering).
///
/// See [`crate::client::fluent_builders::PurchaseReservedDBInstancesOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseReservedDBInstancesOffering {
    _private: (),
}
impl PurchaseReservedDBInstancesOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedDbInstancesOfferingInput`](crate::input::PurchaseReservedDbInstancesOfferingInput)
    pub fn builder() -> crate::input::purchase_reserved_db_instances_offering_input::Builder {
        crate::input::purchase_reserved_db_instances_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseReservedDBInstancesOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseReservedDBInstancesOffering {
    type Output = std::result::Result<
        crate::output::PurchaseReservedDbInstancesOfferingOutput,
        crate::error::PurchaseReservedDBInstancesOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_reserved_db_instances_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_reserved_db_instances_offering_response(response)
        }
    }
}

/// Operation shape for `RebootDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_db_instance`](crate::client::Client::reboot_db_instance).
///
/// See [`crate::client::fluent_builders::RebootDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootDBInstance {
    _private: (),
}
impl RebootDBInstance {
    /// Creates a new builder-style object to manufacture [`RebootDbInstanceInput`](crate::input::RebootDbInstanceInput)
    pub fn builder() -> crate::input::reboot_db_instance_input::Builder {
        crate::input::reboot_db_instance_input::Builder::default()
    }
    /// Creates a new `RebootDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootDBInstance {
    type Output = std::result::Result<
        crate::output::RebootDbInstanceOutput,
        crate::error::RebootDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_db_instance_error(response)
        } else {
            crate::operation_deser::parse_reboot_db_instance_response(response)
        }
    }
}

/// Operation shape for `RegisterDBProxyTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_db_proxy_targets`](crate::client::Client::register_db_proxy_targets).
///
/// See [`crate::client::fluent_builders::RegisterDBProxyTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterDBProxyTargets {
    _private: (),
}
impl RegisterDBProxyTargets {
    /// Creates a new builder-style object to manufacture [`RegisterDbProxyTargetsInput`](crate::input::RegisterDbProxyTargetsInput)
    pub fn builder() -> crate::input::register_db_proxy_targets_input::Builder {
        crate::input::register_db_proxy_targets_input::Builder::default()
    }
    /// Creates a new `RegisterDBProxyTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterDBProxyTargets {
    type Output = std::result::Result<
        crate::output::RegisterDbProxyTargetsOutput,
        crate::error::RegisterDBProxyTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_db_proxy_targets_error(response)
        } else {
            crate::operation_deser::parse_register_db_proxy_targets_response(response)
        }
    }
}

/// Operation shape for `RemoveFromGlobalCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_from_global_cluster`](crate::client::Client::remove_from_global_cluster).
///
/// See [`crate::client::fluent_builders::RemoveFromGlobalCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveFromGlobalCluster {
    _private: (),
}
impl RemoveFromGlobalCluster {
    /// Creates a new builder-style object to manufacture [`RemoveFromGlobalClusterInput`](crate::input::RemoveFromGlobalClusterInput)
    pub fn builder() -> crate::input::remove_from_global_cluster_input::Builder {
        crate::input::remove_from_global_cluster_input::Builder::default()
    }
    /// Creates a new `RemoveFromGlobalCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveFromGlobalCluster {
    type Output = std::result::Result<
        crate::output::RemoveFromGlobalClusterOutput,
        crate::error::RemoveFromGlobalClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_from_global_cluster_error(response)
        } else {
            crate::operation_deser::parse_remove_from_global_cluster_response(response)
        }
    }
}

/// Operation shape for `RemoveRoleFromDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_role_from_db_cluster`](crate::client::Client::remove_role_from_db_cluster).
///
/// See [`crate::client::fluent_builders::RemoveRoleFromDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveRoleFromDBCluster {
    _private: (),
}
impl RemoveRoleFromDBCluster {
    /// Creates a new builder-style object to manufacture [`RemoveRoleFromDbClusterInput`](crate::input::RemoveRoleFromDbClusterInput)
    pub fn builder() -> crate::input::remove_role_from_db_cluster_input::Builder {
        crate::input::remove_role_from_db_cluster_input::Builder::default()
    }
    /// Creates a new `RemoveRoleFromDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveRoleFromDBCluster {
    type Output = std::result::Result<
        crate::output::RemoveRoleFromDbClusterOutput,
        crate::error::RemoveRoleFromDBClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_role_from_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_remove_role_from_db_cluster_response(response)
        }
    }
}

/// Operation shape for `RemoveRoleFromDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_role_from_db_instance`](crate::client::Client::remove_role_from_db_instance).
///
/// See [`crate::client::fluent_builders::RemoveRoleFromDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveRoleFromDBInstance {
    _private: (),
}
impl RemoveRoleFromDBInstance {
    /// Creates a new builder-style object to manufacture [`RemoveRoleFromDbInstanceInput`](crate::input::RemoveRoleFromDbInstanceInput)
    pub fn builder() -> crate::input::remove_role_from_db_instance_input::Builder {
        crate::input::remove_role_from_db_instance_input::Builder::default()
    }
    /// Creates a new `RemoveRoleFromDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveRoleFromDBInstance {
    type Output = std::result::Result<
        crate::output::RemoveRoleFromDbInstanceOutput,
        crate::error::RemoveRoleFromDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_role_from_db_instance_error(response)
        } else {
            crate::operation_deser::parse_remove_role_from_db_instance_response(response)
        }
    }
}

/// Operation shape for `RemoveSourceIdentifierFromSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_source_identifier_from_subscription`](crate::client::Client::remove_source_identifier_from_subscription).
///
/// See [`crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveSourceIdentifierFromSubscription {
    _private: (),
}
impl RemoveSourceIdentifierFromSubscription {
    /// Creates a new builder-style object to manufacture [`RemoveSourceIdentifierFromSubscriptionInput`](crate::input::RemoveSourceIdentifierFromSubscriptionInput)
    pub fn builder() -> crate::input::remove_source_identifier_from_subscription_input::Builder {
        crate::input::remove_source_identifier_from_subscription_input::Builder::default()
    }
    /// Creates a new `RemoveSourceIdentifierFromSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveSourceIdentifierFromSubscription {
    type Output = std::result::Result<
        crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
        crate::error::RemoveSourceIdentifierFromSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_source_identifier_from_subscription_error(response)
        } else {
            crate::operation_deser::parse_remove_source_identifier_from_subscription_response(
                response,
            )
        }
    }
}

/// Operation shape for `RemoveTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_resource`](crate::client::Client::remove_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromResource {
    _private: (),
}
impl RemoveTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromResourceOutput,
        crate::error::RemoveTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `ResetDBClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_db_cluster_parameter_group`](crate::client::Client::reset_db_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::ResetDBClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetDBClusterParameterGroup {
    _private: (),
}
impl ResetDBClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`ResetDbClusterParameterGroupInput`](crate::input::ResetDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::reset_db_cluster_parameter_group_input::Builder {
        crate::input::reset_db_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `ResetDBClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetDBClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::ResetDbClusterParameterGroupOutput,
        crate::error::ResetDBClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_db_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_reset_db_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `ResetDBParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_db_parameter_group`](crate::client::Client::reset_db_parameter_group).
///
/// See [`crate::client::fluent_builders::ResetDBParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetDBParameterGroup {
    _private: (),
}
impl ResetDBParameterGroup {
    /// Creates a new builder-style object to manufacture [`ResetDbParameterGroupInput`](crate::input::ResetDbParameterGroupInput)
    pub fn builder() -> crate::input::reset_db_parameter_group_input::Builder {
        crate::input::reset_db_parameter_group_input::Builder::default()
    }
    /// Creates a new `ResetDBParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetDBParameterGroup {
    type Output = std::result::Result<
        crate::output::ResetDbParameterGroupOutput,
        crate::error::ResetDBParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_db_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_reset_db_parameter_group_response(response)
        }
    }
}

/// Operation shape for `RestoreDBClusterFromS3`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_cluster_from_s3`](crate::client::Client::restore_db_cluster_from_s3).
///
/// See [`crate::client::fluent_builders::RestoreDBClusterFromS3`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBClusterFromS3 {
    _private: (),
}
impl RestoreDBClusterFromS3 {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromS3Input`](crate::input::RestoreDbClusterFromS3Input)
    pub fn builder() -> crate::input::restore_db_cluster_from_s3_input::Builder {
        crate::input::restore_db_cluster_from_s3_input::Builder::default()
    }
    /// Creates a new `RestoreDBClusterFromS3` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBClusterFromS3 {
    type Output = std::result::Result<
        crate::output::RestoreDbClusterFromS3Output,
        crate::error::RestoreDBClusterFromS3Error,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_cluster_from_s3_error(response)
        } else {
            crate::operation_deser::parse_restore_db_cluster_from_s3_response(response)
        }
    }
}

/// Operation shape for `RestoreDBClusterFromSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_cluster_from_snapshot`](crate::client::Client::restore_db_cluster_from_snapshot).
///
/// See [`crate::client::fluent_builders::RestoreDBClusterFromSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBClusterFromSnapshot {
    _private: (),
}
impl RestoreDBClusterFromSnapshot {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromSnapshotInput`](crate::input::RestoreDbClusterFromSnapshotInput)
    pub fn builder() -> crate::input::restore_db_cluster_from_snapshot_input::Builder {
        crate::input::restore_db_cluster_from_snapshot_input::Builder::default()
    }
    /// Creates a new `RestoreDBClusterFromSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBClusterFromSnapshot {
    type Output = std::result::Result<
        crate::output::RestoreDbClusterFromSnapshotOutput,
        crate::error::RestoreDBClusterFromSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_cluster_from_snapshot_error(response)
        } else {
            crate::operation_deser::parse_restore_db_cluster_from_snapshot_response(response)
        }
    }
}

/// Operation shape for `RestoreDBClusterToPointInTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_cluster_to_point_in_time`](crate::client::Client::restore_db_cluster_to_point_in_time).
///
/// See [`crate::client::fluent_builders::RestoreDBClusterToPointInTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBClusterToPointInTime {
    _private: (),
}
impl RestoreDBClusterToPointInTime {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterToPointInTimeInput`](crate::input::RestoreDbClusterToPointInTimeInput)
    pub fn builder() -> crate::input::restore_db_cluster_to_point_in_time_input::Builder {
        crate::input::restore_db_cluster_to_point_in_time_input::Builder::default()
    }
    /// Creates a new `RestoreDBClusterToPointInTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBClusterToPointInTime {
    type Output = std::result::Result<
        crate::output::RestoreDbClusterToPointInTimeOutput,
        crate::error::RestoreDBClusterToPointInTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_cluster_to_point_in_time_error(response)
        } else {
            crate::operation_deser::parse_restore_db_cluster_to_point_in_time_response(response)
        }
    }
}

/// Operation shape for `RestoreDBInstanceFromDBSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_instance_from_db_snapshot`](crate::client::Client::restore_db_instance_from_db_snapshot).
///
/// See [`crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBInstanceFromDBSnapshot {
    _private: (),
}
impl RestoreDBInstanceFromDBSnapshot {
    /// Creates a new builder-style object to manufacture [`RestoreDbInstanceFromDbSnapshotInput`](crate::input::RestoreDbInstanceFromDbSnapshotInput)
    pub fn builder() -> crate::input::restore_db_instance_from_db_snapshot_input::Builder {
        crate::input::restore_db_instance_from_db_snapshot_input::Builder::default()
    }
    /// Creates a new `RestoreDBInstanceFromDBSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBInstanceFromDBSnapshot {
    type Output = std::result::Result<
        crate::output::RestoreDbInstanceFromDbSnapshotOutput,
        crate::error::RestoreDBInstanceFromDBSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_instance_from_db_snapshot_error(response)
        } else {
            crate::operation_deser::parse_restore_db_instance_from_db_snapshot_response(response)
        }
    }
}

/// Operation shape for `RestoreDBInstanceFromS3`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_instance_from_s3`](crate::client::Client::restore_db_instance_from_s3).
///
/// See [`crate::client::fluent_builders::RestoreDBInstanceFromS3`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBInstanceFromS3 {
    _private: (),
}
impl RestoreDBInstanceFromS3 {
    /// Creates a new builder-style object to manufacture [`RestoreDbInstanceFromS3Input`](crate::input::RestoreDbInstanceFromS3Input)
    pub fn builder() -> crate::input::restore_db_instance_from_s3_input::Builder {
        crate::input::restore_db_instance_from_s3_input::Builder::default()
    }
    /// Creates a new `RestoreDBInstanceFromS3` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBInstanceFromS3 {
    type Output = std::result::Result<
        crate::output::RestoreDbInstanceFromS3Output,
        crate::error::RestoreDBInstanceFromS3Error,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_instance_from_s3_error(response)
        } else {
            crate::operation_deser::parse_restore_db_instance_from_s3_response(response)
        }
    }
}

/// Operation shape for `RestoreDBInstanceToPointInTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_db_instance_to_point_in_time`](crate::client::Client::restore_db_instance_to_point_in_time).
///
/// See [`crate::client::fluent_builders::RestoreDBInstanceToPointInTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreDBInstanceToPointInTime {
    _private: (),
}
impl RestoreDBInstanceToPointInTime {
    /// Creates a new builder-style object to manufacture [`RestoreDbInstanceToPointInTimeInput`](crate::input::RestoreDbInstanceToPointInTimeInput)
    pub fn builder() -> crate::input::restore_db_instance_to_point_in_time_input::Builder {
        crate::input::restore_db_instance_to_point_in_time_input::Builder::default()
    }
    /// Creates a new `RestoreDBInstanceToPointInTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreDBInstanceToPointInTime {
    type Output = std::result::Result<
        crate::output::RestoreDbInstanceToPointInTimeOutput,
        crate::error::RestoreDBInstanceToPointInTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_db_instance_to_point_in_time_error(response)
        } else {
            crate::operation_deser::parse_restore_db_instance_to_point_in_time_response(response)
        }
    }
}

/// Operation shape for `RevokeDBSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_db_security_group_ingress`](crate::client::Client::revoke_db_security_group_ingress).
///
/// See [`crate::client::fluent_builders::RevokeDBSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeDBSecurityGroupIngress {
    _private: (),
}
impl RevokeDBSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`RevokeDbSecurityGroupIngressInput`](crate::input::RevokeDbSecurityGroupIngressInput)
    pub fn builder() -> crate::input::revoke_db_security_group_ingress_input::Builder {
        crate::input::revoke_db_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `RevokeDBSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeDBSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::RevokeDbSecurityGroupIngressOutput,
        crate::error::RevokeDBSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_db_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_revoke_db_security_group_ingress_response(response)
        }
    }
}

/// Operation shape for `StartActivityStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_activity_stream`](crate::client::Client::start_activity_stream).
///
/// See [`crate::client::fluent_builders::StartActivityStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartActivityStream {
    _private: (),
}
impl StartActivityStream {
    /// Creates a new builder-style object to manufacture [`StartActivityStreamInput`](crate::input::StartActivityStreamInput)
    pub fn builder() -> crate::input::start_activity_stream_input::Builder {
        crate::input::start_activity_stream_input::Builder::default()
    }
    /// Creates a new `StartActivityStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartActivityStream {
    type Output = std::result::Result<
        crate::output::StartActivityStreamOutput,
        crate::error::StartActivityStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_activity_stream_error(response)
        } else {
            crate::operation_deser::parse_start_activity_stream_response(response)
        }
    }
}

/// Operation shape for `StartDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_db_cluster`](crate::client::Client::start_db_cluster).
///
/// See [`crate::client::fluent_builders::StartDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDBCluster {
    _private: (),
}
impl StartDBCluster {
    /// Creates a new builder-style object to manufacture [`StartDbClusterInput`](crate::input::StartDbClusterInput)
    pub fn builder() -> crate::input::start_db_cluster_input::Builder {
        crate::input::start_db_cluster_input::Builder::default()
    }
    /// Creates a new `StartDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDBCluster {
    type Output =
        std::result::Result<crate::output::StartDbClusterOutput, crate::error::StartDBClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_start_db_cluster_response(response)
        }
    }
}

/// Operation shape for `StartDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_db_instance`](crate::client::Client::start_db_instance).
///
/// See [`crate::client::fluent_builders::StartDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDBInstance {
    _private: (),
}
impl StartDBInstance {
    /// Creates a new builder-style object to manufacture [`StartDbInstanceInput`](crate::input::StartDbInstanceInput)
    pub fn builder() -> crate::input::start_db_instance_input::Builder {
        crate::input::start_db_instance_input::Builder::default()
    }
    /// Creates a new `StartDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDBInstance {
    type Output = std::result::Result<
        crate::output::StartDbInstanceOutput,
        crate::error::StartDBInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_db_instance_error(response)
        } else {
            crate::operation_deser::parse_start_db_instance_response(response)
        }
    }
}

/// Operation shape for `StartDBInstanceAutomatedBackupsReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_db_instance_automated_backups_replication`](crate::client::Client::start_db_instance_automated_backups_replication).
///
/// See [`crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDBInstanceAutomatedBackupsReplication {
    _private: (),
}
impl StartDBInstanceAutomatedBackupsReplication {
    /// Creates a new builder-style object to manufacture [`StartDbInstanceAutomatedBackupsReplicationInput`](crate::input::StartDbInstanceAutomatedBackupsReplicationInput)
    pub fn builder() -> crate::input::start_db_instance_automated_backups_replication_input::Builder
    {
        crate::input::start_db_instance_automated_backups_replication_input::Builder::default()
    }
    /// Creates a new `StartDBInstanceAutomatedBackupsReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDBInstanceAutomatedBackupsReplication {
    type Output = std::result::Result<
        crate::output::StartDbInstanceAutomatedBackupsReplicationOutput,
        crate::error::StartDBInstanceAutomatedBackupsReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_db_instance_automated_backups_replication_error(
                response,
            )
        } else {
            crate::operation_deser::parse_start_db_instance_automated_backups_replication_response(
                response,
            )
        }
    }
}

/// Operation shape for `StartExportTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_export_task`](crate::client::Client::start_export_task).
///
/// See [`crate::client::fluent_builders::StartExportTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartExportTask {
    _private: (),
}
impl StartExportTask {
    /// Creates a new builder-style object to manufacture [`StartExportTaskInput`](crate::input::StartExportTaskInput)
    pub fn builder() -> crate::input::start_export_task_input::Builder {
        crate::input::start_export_task_input::Builder::default()
    }
    /// Creates a new `StartExportTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartExportTask {
    type Output = std::result::Result<
        crate::output::StartExportTaskOutput,
        crate::error::StartExportTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_export_task_error(response)
        } else {
            crate::operation_deser::parse_start_export_task_response(response)
        }
    }
}

/// Operation shape for `StopActivityStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_activity_stream`](crate::client::Client::stop_activity_stream).
///
/// See [`crate::client::fluent_builders::StopActivityStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopActivityStream {
    _private: (),
}
impl StopActivityStream {
    /// Creates a new builder-style object to manufacture [`StopActivityStreamInput`](crate::input::StopActivityStreamInput)
    pub fn builder() -> crate::input::stop_activity_stream_input::Builder {
        crate::input::stop_activity_stream_input::Builder::default()
    }
    /// Creates a new `StopActivityStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopActivityStream {
    type Output = std::result::Result<
        crate::output::StopActivityStreamOutput,
        crate::error::StopActivityStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_activity_stream_error(response)
        } else {
            crate::operation_deser::parse_stop_activity_stream_response(response)
        }
    }
}

/// Operation shape for `StopDBCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_db_cluster`](crate::client::Client::stop_db_cluster).
///
/// See [`crate::client::fluent_builders::StopDBCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDBCluster {
    _private: (),
}
impl StopDBCluster {
    /// Creates a new builder-style object to manufacture [`StopDbClusterInput`](crate::input::StopDbClusterInput)
    pub fn builder() -> crate::input::stop_db_cluster_input::Builder {
        crate::input::stop_db_cluster_input::Builder::default()
    }
    /// Creates a new `StopDBCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDBCluster {
    type Output =
        std::result::Result<crate::output::StopDbClusterOutput, crate::error::StopDBClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_db_cluster_error(response)
        } else {
            crate::operation_deser::parse_stop_db_cluster_response(response)
        }
    }
}

/// Operation shape for `StopDBInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_db_instance`](crate::client::Client::stop_db_instance).
///
/// See [`crate::client::fluent_builders::StopDBInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDBInstance {
    _private: (),
}
impl StopDBInstance {
    /// Creates a new builder-style object to manufacture [`StopDbInstanceInput`](crate::input::StopDbInstanceInput)
    pub fn builder() -> crate::input::stop_db_instance_input::Builder {
        crate::input::stop_db_instance_input::Builder::default()
    }
    /// Creates a new `StopDBInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDBInstance {
    type Output =
        std::result::Result<crate::output::StopDbInstanceOutput, crate::error::StopDBInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_db_instance_error(response)
        } else {
            crate::operation_deser::parse_stop_db_instance_response(response)
        }
    }
}

/// Operation shape for `StopDBInstanceAutomatedBackupsReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_db_instance_automated_backups_replication`](crate::client::Client::stop_db_instance_automated_backups_replication).
///
/// See [`crate::client::fluent_builders::StopDBInstanceAutomatedBackupsReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopDBInstanceAutomatedBackupsReplication {
    _private: (),
}
impl StopDBInstanceAutomatedBackupsReplication {
    /// Creates a new builder-style object to manufacture [`StopDbInstanceAutomatedBackupsReplicationInput`](crate::input::StopDbInstanceAutomatedBackupsReplicationInput)
    pub fn builder() -> crate::input::stop_db_instance_automated_backups_replication_input::Builder
    {
        crate::input::stop_db_instance_automated_backups_replication_input::Builder::default()
    }
    /// Creates a new `StopDBInstanceAutomatedBackupsReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopDBInstanceAutomatedBackupsReplication {
    type Output = std::result::Result<
        crate::output::StopDbInstanceAutomatedBackupsReplicationOutput,
        crate::error::StopDBInstanceAutomatedBackupsReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_db_instance_automated_backups_replication_error(
                response,
            )
        } else {
            crate::operation_deser::parse_stop_db_instance_automated_backups_replication_response(
                response,
            )
        }
    }
}
