// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonRDSv19`.
///
/// This client allows ergonomic access to a `AmazonRDSv19`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddRoleToDBCluster` operation.
    ///
    /// See [`AddRoleToDBCluster`](crate::client::fluent_builders::AddRoleToDBCluster) for more information about the
    /// operation and its arguments.
    pub fn add_role_to_db_cluster(&self) -> fluent_builders::AddRoleToDBCluster<C, M, R> {
        fluent_builders::AddRoleToDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddRoleToDBInstance` operation.
    ///
    /// See [`AddRoleToDBInstance`](crate::client::fluent_builders::AddRoleToDBInstance) for more information about the
    /// operation and its arguments.
    pub fn add_role_to_db_instance(&self) -> fluent_builders::AddRoleToDBInstance<C, M, R> {
        fluent_builders::AddRoleToDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddSourceIdentifierToSubscription` operation.
    ///
    /// See [`AddSourceIdentifierToSubscription`](crate::client::fluent_builders::AddSourceIdentifierToSubscription) for more information about the
    /// operation and its arguments.
    pub fn add_source_identifier_to_subscription(
        &self,
    ) -> fluent_builders::AddSourceIdentifierToSubscription<C, M, R> {
        fluent_builders::AddSourceIdentifierToSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplyPendingMaintenanceAction` operation.
    ///
    /// See [`ApplyPendingMaintenanceAction`](crate::client::fluent_builders::ApplyPendingMaintenanceAction) for more information about the
    /// operation and its arguments.
    pub fn apply_pending_maintenance_action(
        &self,
    ) -> fluent_builders::ApplyPendingMaintenanceAction<C, M, R> {
        fluent_builders::ApplyPendingMaintenanceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeDBSecurityGroupIngress` operation.
    ///
    /// See [`AuthorizeDBSecurityGroupIngress`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress) for more information about the
    /// operation and its arguments.
    pub fn authorize_db_security_group_ingress(
        &self,
    ) -> fluent_builders::AuthorizeDBSecurityGroupIngress<C, M, R> {
        fluent_builders::AuthorizeDBSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BacktrackDBCluster` operation.
    ///
    /// See [`BacktrackDBCluster`](crate::client::fluent_builders::BacktrackDBCluster) for more information about the
    /// operation and its arguments.
    pub fn backtrack_db_cluster(&self) -> fluent_builders::BacktrackDBCluster<C, M, R> {
        fluent_builders::BacktrackDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelExportTask` operation.
    ///
    /// See [`CancelExportTask`](crate::client::fluent_builders::CancelExportTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_export_task(&self) -> fluent_builders::CancelExportTask<C, M, R> {
        fluent_builders::CancelExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBClusterParameterGroup` operation.
    ///
    /// See [`CopyDBClusterParameterGroup`](crate::client::fluent_builders::CopyDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn copy_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CopyDBClusterParameterGroup<C, M, R> {
        fluent_builders::CopyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBClusterSnapshot` operation.
    ///
    /// See [`CopyDBClusterSnapshot`](crate::client::fluent_builders::CopyDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_db_cluster_snapshot(&self) -> fluent_builders::CopyDBClusterSnapshot<C, M, R> {
        fluent_builders::CopyDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBParameterGroup` operation.
    ///
    /// See [`CopyDBParameterGroup`](crate::client::fluent_builders::CopyDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn copy_db_parameter_group(&self) -> fluent_builders::CopyDBParameterGroup<C, M, R> {
        fluent_builders::CopyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyDBSnapshot` operation.
    ///
    /// See [`CopyDBSnapshot`](crate::client::fluent_builders::CopyDBSnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_db_snapshot(&self) -> fluent_builders::CopyDBSnapshot<C, M, R> {
        fluent_builders::CopyDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyOptionGroup` operation.
    ///
    /// See [`CopyOptionGroup`](crate::client::fluent_builders::CopyOptionGroup) for more information about the
    /// operation and its arguments.
    pub fn copy_option_group(&self) -> fluent_builders::CopyOptionGroup<C, M, R> {
        fluent_builders::CopyOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomAvailabilityZone` operation.
    ///
    /// See [`CreateCustomAvailabilityZone`](crate::client::fluent_builders::CreateCustomAvailabilityZone) for more information about the
    /// operation and its arguments.
    pub fn create_custom_availability_zone(
        &self,
    ) -> fluent_builders::CreateCustomAvailabilityZone<C, M, R> {
        fluent_builders::CreateCustomAvailabilityZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomDBEngineVersion` operation.
    ///
    /// See [`CreateCustomDBEngineVersion`](crate::client::fluent_builders::CreateCustomDBEngineVersion) for more information about the
    /// operation and its arguments.
    pub fn create_custom_db_engine_version(
        &self,
    ) -> fluent_builders::CreateCustomDBEngineVersion<C, M, R> {
        fluent_builders::CreateCustomDBEngineVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBCluster` operation.
    ///
    /// See [`CreateDBCluster`](crate::client::fluent_builders::CreateDBCluster) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster(&self) -> fluent_builders::CreateDBCluster<C, M, R> {
        fluent_builders::CreateDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterEndpoint` operation.
    ///
    /// See [`CreateDBClusterEndpoint`](crate::client::fluent_builders::CreateDBClusterEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_endpoint(&self) -> fluent_builders::CreateDBClusterEndpoint<C, M, R> {
        fluent_builders::CreateDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterParameterGroup` operation.
    ///
    /// See [`CreateDBClusterParameterGroup`](crate::client::fluent_builders::CreateDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CreateDBClusterParameterGroup<C, M, R> {
        fluent_builders::CreateDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBClusterSnapshot` operation.
    ///
    /// See [`CreateDBClusterSnapshot`](crate::client::fluent_builders::CreateDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_db_cluster_snapshot(&self) -> fluent_builders::CreateDBClusterSnapshot<C, M, R> {
        fluent_builders::CreateDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBInstance` operation.
    ///
    /// See [`CreateDBInstance`](crate::client::fluent_builders::CreateDBInstance) for more information about the
    /// operation and its arguments.
    pub fn create_db_instance(&self) -> fluent_builders::CreateDBInstance<C, M, R> {
        fluent_builders::CreateDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBInstanceReadReplica` operation.
    ///
    /// See [`CreateDBInstanceReadReplica`](crate::client::fluent_builders::CreateDBInstanceReadReplica) for more information about the
    /// operation and its arguments.
    pub fn create_db_instance_read_replica(
        &self,
    ) -> fluent_builders::CreateDBInstanceReadReplica<C, M, R> {
        fluent_builders::CreateDBInstanceReadReplica::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBParameterGroup` operation.
    ///
    /// See [`CreateDBParameterGroup`](crate::client::fluent_builders::CreateDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_parameter_group(&self) -> fluent_builders::CreateDBParameterGroup<C, M, R> {
        fluent_builders::CreateDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBProxy` operation.
    ///
    /// See [`CreateDBProxy`](crate::client::fluent_builders::CreateDBProxy) for more information about the
    /// operation and its arguments.
    pub fn create_db_proxy(&self) -> fluent_builders::CreateDBProxy<C, M, R> {
        fluent_builders::CreateDBProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBProxyEndpoint` operation.
    ///
    /// See [`CreateDBProxyEndpoint`](crate::client::fluent_builders::CreateDBProxyEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_db_proxy_endpoint(&self) -> fluent_builders::CreateDBProxyEndpoint<C, M, R> {
        fluent_builders::CreateDBProxyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBSecurityGroup` operation.
    ///
    /// See [`CreateDBSecurityGroup`](crate::client::fluent_builders::CreateDBSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_security_group(&self) -> fluent_builders::CreateDBSecurityGroup<C, M, R> {
        fluent_builders::CreateDBSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBSnapshot` operation.
    ///
    /// See [`CreateDBSnapshot`](crate::client::fluent_builders::CreateDBSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_db_snapshot(&self) -> fluent_builders::CreateDBSnapshot<C, M, R> {
        fluent_builders::CreateDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDBSubnetGroup` operation.
    ///
    /// See [`CreateDBSubnetGroup`](crate::client::fluent_builders::CreateDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_db_subnet_group(&self) -> fluent_builders::CreateDBSubnetGroup<C, M, R> {
        fluent_builders::CreateDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventSubscription` operation.
    ///
    /// See [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription<C, M, R> {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGlobalCluster` operation.
    ///
    /// See [`CreateGlobalCluster`](crate::client::fluent_builders::CreateGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn create_global_cluster(&self) -> fluent_builders::CreateGlobalCluster<C, M, R> {
        fluent_builders::CreateGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOptionGroup` operation.
    ///
    /// See [`CreateOptionGroup`](crate::client::fluent_builders::CreateOptionGroup) for more information about the
    /// operation and its arguments.
    pub fn create_option_group(&self) -> fluent_builders::CreateOptionGroup<C, M, R> {
        fluent_builders::CreateOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomAvailabilityZone` operation.
    ///
    /// See [`DeleteCustomAvailabilityZone`](crate::client::fluent_builders::DeleteCustomAvailabilityZone) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_availability_zone(
        &self,
    ) -> fluent_builders::DeleteCustomAvailabilityZone<C, M, R> {
        fluent_builders::DeleteCustomAvailabilityZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomDBEngineVersion` operation.
    ///
    /// See [`DeleteCustomDBEngineVersion`](crate::client::fluent_builders::DeleteCustomDBEngineVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_db_engine_version(
        &self,
    ) -> fluent_builders::DeleteCustomDBEngineVersion<C, M, R> {
        fluent_builders::DeleteCustomDBEngineVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBCluster` operation.
    ///
    /// See [`DeleteDBCluster`](crate::client::fluent_builders::DeleteDBCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster(&self) -> fluent_builders::DeleteDBCluster<C, M, R> {
        fluent_builders::DeleteDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterEndpoint` operation.
    ///
    /// See [`DeleteDBClusterEndpoint`](crate::client::fluent_builders::DeleteDBClusterEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_endpoint(&self) -> fluent_builders::DeleteDBClusterEndpoint<C, M, R> {
        fluent_builders::DeleteDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterParameterGroup` operation.
    ///
    /// See [`DeleteDBClusterParameterGroup`](crate::client::fluent_builders::DeleteDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::DeleteDBClusterParameterGroup<C, M, R> {
        fluent_builders::DeleteDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBClusterSnapshot` operation.
    ///
    /// See [`DeleteDBClusterSnapshot`](crate::client::fluent_builders::DeleteDBClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_db_cluster_snapshot(&self) -> fluent_builders::DeleteDBClusterSnapshot<C, M, R> {
        fluent_builders::DeleteDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBInstance` operation.
    ///
    /// See [`DeleteDBInstance`](crate::client::fluent_builders::DeleteDBInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_db_instance(&self) -> fluent_builders::DeleteDBInstance<C, M, R> {
        fluent_builders::DeleteDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBInstanceAutomatedBackup` operation.
    ///
    /// See [`DeleteDBInstanceAutomatedBackup`](crate::client::fluent_builders::DeleteDBInstanceAutomatedBackup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_instance_automated_backup(
        &self,
    ) -> fluent_builders::DeleteDBInstanceAutomatedBackup<C, M, R> {
        fluent_builders::DeleteDBInstanceAutomatedBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBParameterGroup` operation.
    ///
    /// See [`DeleteDBParameterGroup`](crate::client::fluent_builders::DeleteDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_parameter_group(&self) -> fluent_builders::DeleteDBParameterGroup<C, M, R> {
        fluent_builders::DeleteDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBProxy` operation.
    ///
    /// See [`DeleteDBProxy`](crate::client::fluent_builders::DeleteDBProxy) for more information about the
    /// operation and its arguments.
    pub fn delete_db_proxy(&self) -> fluent_builders::DeleteDBProxy<C, M, R> {
        fluent_builders::DeleteDBProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBProxyEndpoint` operation.
    ///
    /// See [`DeleteDBProxyEndpoint`](crate::client::fluent_builders::DeleteDBProxyEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_db_proxy_endpoint(&self) -> fluent_builders::DeleteDBProxyEndpoint<C, M, R> {
        fluent_builders::DeleteDBProxyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBSecurityGroup` operation.
    ///
    /// See [`DeleteDBSecurityGroup`](crate::client::fluent_builders::DeleteDBSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_security_group(&self) -> fluent_builders::DeleteDBSecurityGroup<C, M, R> {
        fluent_builders::DeleteDBSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBSnapshot` operation.
    ///
    /// See [`DeleteDBSnapshot`](crate::client::fluent_builders::DeleteDBSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_db_snapshot(&self) -> fluent_builders::DeleteDBSnapshot<C, M, R> {
        fluent_builders::DeleteDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDBSubnetGroup` operation.
    ///
    /// See [`DeleteDBSubnetGroup`](crate::client::fluent_builders::DeleteDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_db_subnet_group(&self) -> fluent_builders::DeleteDBSubnetGroup<C, M, R> {
        fluent_builders::DeleteDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventSubscription` operation.
    ///
    /// See [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription<C, M, R> {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGlobalCluster` operation.
    ///
    /// See [`DeleteGlobalCluster`](crate::client::fluent_builders::DeleteGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_global_cluster(&self) -> fluent_builders::DeleteGlobalCluster<C, M, R> {
        fluent_builders::DeleteGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstallationMedia` operation.
    ///
    /// See [`DeleteInstallationMedia`](crate::client::fluent_builders::DeleteInstallationMedia) for more information about the
    /// operation and its arguments.
    pub fn delete_installation_media(&self) -> fluent_builders::DeleteInstallationMedia<C, M, R> {
        fluent_builders::DeleteInstallationMedia::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOptionGroup` operation.
    ///
    /// See [`DeleteOptionGroup`](crate::client::fluent_builders::DeleteOptionGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_option_group(&self) -> fluent_builders::DeleteOptionGroup<C, M, R> {
        fluent_builders::DeleteOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterDBProxyTargets` operation.
    ///
    /// See [`DeregisterDBProxyTargets`](crate::client::fluent_builders::DeregisterDBProxyTargets) for more information about the
    /// operation and its arguments.
    pub fn deregister_db_proxy_targets(
        &self,
    ) -> fluent_builders::DeregisterDBProxyTargets<C, M, R> {
        fluent_builders::DeregisterDBProxyTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAttributes` operation.
    ///
    /// See [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_account_attributes(
        &self,
    ) -> fluent_builders::DescribeAccountAttributes<C, M, R> {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCertificates` operation.
    ///
    /// See [`DescribeCertificates`](crate::client::fluent_builders::DescribeCertificates) for more information about the
    /// operation and its arguments.
    pub fn describe_certificates(&self) -> fluent_builders::DescribeCertificates<C, M, R> {
        fluent_builders::DescribeCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomAvailabilityZones` operation.
    ///
    /// See [`DescribeCustomAvailabilityZones`](crate::client::fluent_builders::DescribeCustomAvailabilityZones) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_availability_zones(
        &self,
    ) -> fluent_builders::DescribeCustomAvailabilityZones<C, M, R> {
        fluent_builders::DescribeCustomAvailabilityZones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterBacktracks` operation.
    ///
    /// See [`DescribeDBClusterBacktracks`](crate::client::fluent_builders::DescribeDBClusterBacktracks) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_backtracks(
        &self,
    ) -> fluent_builders::DescribeDBClusterBacktracks<C, M, R> {
        fluent_builders::DescribeDBClusterBacktracks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterEndpoints` operation.
    ///
    /// See [`DescribeDBClusterEndpoints`](crate::client::fluent_builders::DescribeDBClusterEndpoints) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_endpoints(
        &self,
    ) -> fluent_builders::DescribeDBClusterEndpoints<C, M, R> {
        fluent_builders::DescribeDBClusterEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterParameterGroups` operation.
    ///
    /// See [`DescribeDBClusterParameterGroups`](crate::client::fluent_builders::DescribeDBClusterParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameterGroups<C, M, R> {
        fluent_builders::DescribeDBClusterParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterParameters` operation.
    ///
    /// See [`DescribeDBClusterParameters`](crate::client::fluent_builders::DescribeDBClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameters<C, M, R> {
        fluent_builders::DescribeDBClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusters` operation.
    ///
    /// See [`DescribeDBClusters`](crate::client::fluent_builders::DescribeDBClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_clusters(&self) -> fluent_builders::DescribeDBClusters<C, M, R> {
        fluent_builders::DescribeDBClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterSnapshotAttributes` operation.
    ///
    /// See [`DescribeDBClusterSnapshotAttributes`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_snapshot_attributes(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshotAttributes<C, M, R> {
        fluent_builders::DescribeDBClusterSnapshotAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBClusterSnapshots` operation.
    ///
    /// See [`DescribeDBClusterSnapshots`](crate::client::fluent_builders::DescribeDBClusterSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_db_cluster_snapshots(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshots<C, M, R> {
        fluent_builders::DescribeDBClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBEngineVersions` operation.
    ///
    /// See [`DescribeDBEngineVersions`](crate::client::fluent_builders::DescribeDBEngineVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_db_engine_versions(
        &self,
    ) -> fluent_builders::DescribeDBEngineVersions<C, M, R> {
        fluent_builders::DescribeDBEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBInstanceAutomatedBackups` operation.
    ///
    /// See [`DescribeDBInstanceAutomatedBackups`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_instance_automated_backups(
        &self,
    ) -> fluent_builders::DescribeDBInstanceAutomatedBackups<C, M, R> {
        fluent_builders::DescribeDBInstanceAutomatedBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBInstances` operation.
    ///
    /// See [`DescribeDBInstances`](crate::client::fluent_builders::DescribeDBInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_db_instances(&self) -> fluent_builders::DescribeDBInstances<C, M, R> {
        fluent_builders::DescribeDBInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBLogFiles` operation.
    ///
    /// See [`DescribeDBLogFiles`](crate::client::fluent_builders::DescribeDBLogFiles) for more information about the
    /// operation and its arguments.
    pub fn describe_db_log_files(&self) -> fluent_builders::DescribeDBLogFiles<C, M, R> {
        fluent_builders::DescribeDBLogFiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBParameterGroups` operation.
    ///
    /// See [`DescribeDBParameterGroups`](crate::client::fluent_builders::DescribeDBParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeDBParameterGroups<C, M, R> {
        fluent_builders::DescribeDBParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBParameters` operation.
    ///
    /// See [`DescribeDBParameters`](crate::client::fluent_builders::DescribeDBParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_db_parameters(&self) -> fluent_builders::DescribeDBParameters<C, M, R> {
        fluent_builders::DescribeDBParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBProxies` operation.
    ///
    /// See [`DescribeDBProxies`](crate::client::fluent_builders::DescribeDBProxies) for more information about the
    /// operation and its arguments.
    pub fn describe_db_proxies(&self) -> fluent_builders::DescribeDBProxies<C, M, R> {
        fluent_builders::DescribeDBProxies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBProxyEndpoints` operation.
    ///
    /// See [`DescribeDBProxyEndpoints`](crate::client::fluent_builders::DescribeDBProxyEndpoints) for more information about the
    /// operation and its arguments.
    pub fn describe_db_proxy_endpoints(
        &self,
    ) -> fluent_builders::DescribeDBProxyEndpoints<C, M, R> {
        fluent_builders::DescribeDBProxyEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBProxyTargetGroups` operation.
    ///
    /// See [`DescribeDBProxyTargetGroups`](crate::client::fluent_builders::DescribeDBProxyTargetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_proxy_target_groups(
        &self,
    ) -> fluent_builders::DescribeDBProxyTargetGroups<C, M, R> {
        fluent_builders::DescribeDBProxyTargetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBProxyTargets` operation.
    ///
    /// See [`DescribeDBProxyTargets`](crate::client::fluent_builders::DescribeDBProxyTargets) for more information about the
    /// operation and its arguments.
    pub fn describe_db_proxy_targets(&self) -> fluent_builders::DescribeDBProxyTargets<C, M, R> {
        fluent_builders::DescribeDBProxyTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBSecurityGroups` operation.
    ///
    /// See [`DescribeDBSecurityGroups`](crate::client::fluent_builders::DescribeDBSecurityGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_security_groups(
        &self,
    ) -> fluent_builders::DescribeDBSecurityGroups<C, M, R> {
        fluent_builders::DescribeDBSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBSnapshotAttributes` operation.
    ///
    /// See [`DescribeDBSnapshotAttributes`](crate::client::fluent_builders::DescribeDBSnapshotAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_db_snapshot_attributes(
        &self,
    ) -> fluent_builders::DescribeDBSnapshotAttributes<C, M, R> {
        fluent_builders::DescribeDBSnapshotAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBSnapshots` operation.
    ///
    /// See [`DescribeDBSnapshots`](crate::client::fluent_builders::DescribeDBSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_db_snapshots(&self) -> fluent_builders::DescribeDBSnapshots<C, M, R> {
        fluent_builders::DescribeDBSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDBSubnetGroups` operation.
    ///
    /// See [`DescribeDBSubnetGroups`](crate::client::fluent_builders::DescribeDBSubnetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_db_subnet_groups(&self) -> fluent_builders::DescribeDBSubnetGroups<C, M, R> {
        fluent_builders::DescribeDBSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEngineDefaultClusterParameters` operation.
    ///
    /// See [`DescribeEngineDefaultClusterParameters`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_engine_default_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultClusterParameters<C, M, R> {
        fluent_builders::DescribeEngineDefaultClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEngineDefaultParameters` operation.
    ///
    /// See [`DescribeEngineDefaultParameters`](crate::client::fluent_builders::DescribeEngineDefaultParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_engine_default_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultParameters<C, M, R> {
        fluent_builders::DescribeEngineDefaultParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventCategories` operation.
    ///
    /// See [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) for more information about the
    /// operation and its arguments.
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories<C, M, R> {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventSubscriptions` operation.
    ///
    /// See [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn describe_event_subscriptions(
        &self,
    ) -> fluent_builders::DescribeEventSubscriptions<C, M, R> {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExportTasks` operation.
    ///
    /// See [`DescribeExportTasks`](crate::client::fluent_builders::DescribeExportTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_export_tasks(&self) -> fluent_builders::DescribeExportTasks<C, M, R> {
        fluent_builders::DescribeExportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGlobalClusters` operation.
    ///
    /// See [`DescribeGlobalClusters`](crate::client::fluent_builders::DescribeGlobalClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_global_clusters(&self) -> fluent_builders::DescribeGlobalClusters<C, M, R> {
        fluent_builders::DescribeGlobalClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstallationMedia` operation.
    ///
    /// See [`DescribeInstallationMedia`](crate::client::fluent_builders::DescribeInstallationMedia) for more information about the
    /// operation and its arguments.
    pub fn describe_installation_media(
        &self,
    ) -> fluent_builders::DescribeInstallationMedia<C, M, R> {
        fluent_builders::DescribeInstallationMedia::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOptionGroupOptions` operation.
    ///
    /// See [`DescribeOptionGroupOptions`](crate::client::fluent_builders::DescribeOptionGroupOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_option_group_options(
        &self,
    ) -> fluent_builders::DescribeOptionGroupOptions<C, M, R> {
        fluent_builders::DescribeOptionGroupOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOptionGroups` operation.
    ///
    /// See [`DescribeOptionGroups`](crate::client::fluent_builders::DescribeOptionGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_option_groups(&self) -> fluent_builders::DescribeOptionGroups<C, M, R> {
        fluent_builders::DescribeOptionGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrderableDBInstanceOptions` operation.
    ///
    /// See [`DescribeOrderableDBInstanceOptions`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_orderable_db_instance_options(
        &self,
    ) -> fluent_builders::DescribeOrderableDBInstanceOptions<C, M, R> {
        fluent_builders::DescribeOrderableDBInstanceOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePendingMaintenanceActions` operation.
    ///
    /// See [`DescribePendingMaintenanceActions`](crate::client::fluent_builders::DescribePendingMaintenanceActions) for more information about the
    /// operation and its arguments.
    pub fn describe_pending_maintenance_actions(
        &self,
    ) -> fluent_builders::DescribePendingMaintenanceActions<C, M, R> {
        fluent_builders::DescribePendingMaintenanceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedDBInstances` operation.
    ///
    /// See [`DescribeReservedDBInstances`](crate::client::fluent_builders::DescribeReservedDBInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_db_instances(
        &self,
    ) -> fluent_builders::DescribeReservedDBInstances<C, M, R> {
        fluent_builders::DescribeReservedDBInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedDBInstancesOfferings` operation.
    ///
    /// See [`DescribeReservedDBInstancesOfferings`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_db_instances_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedDBInstancesOfferings<C, M, R> {
        fluent_builders::DescribeReservedDBInstancesOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSourceRegions` operation.
    ///
    /// See [`DescribeSourceRegions`](crate::client::fluent_builders::DescribeSourceRegions) for more information about the
    /// operation and its arguments.
    pub fn describe_source_regions(&self) -> fluent_builders::DescribeSourceRegions<C, M, R> {
        fluent_builders::DescribeSourceRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeValidDBInstanceModifications` operation.
    ///
    /// See [`DescribeValidDBInstanceModifications`](crate::client::fluent_builders::DescribeValidDBInstanceModifications) for more information about the
    /// operation and its arguments.
    pub fn describe_valid_db_instance_modifications(
        &self,
    ) -> fluent_builders::DescribeValidDBInstanceModifications<C, M, R> {
        fluent_builders::DescribeValidDBInstanceModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DownloadDBLogFilePortion` operation.
    ///
    /// See [`DownloadDBLogFilePortion`](crate::client::fluent_builders::DownloadDBLogFilePortion) for more information about the
    /// operation and its arguments.
    pub fn download_db_log_file_portion(
        &self,
    ) -> fluent_builders::DownloadDBLogFilePortion<C, M, R> {
        fluent_builders::DownloadDBLogFilePortion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FailoverDBCluster` operation.
    ///
    /// See [`FailoverDBCluster`](crate::client::fluent_builders::FailoverDBCluster) for more information about the
    /// operation and its arguments.
    pub fn failover_db_cluster(&self) -> fluent_builders::FailoverDBCluster<C, M, R> {
        fluent_builders::FailoverDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FailoverGlobalCluster` operation.
    ///
    /// See [`FailoverGlobalCluster`](crate::client::fluent_builders::FailoverGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn failover_global_cluster(&self) -> fluent_builders::FailoverGlobalCluster<C, M, R> {
        fluent_builders::FailoverGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportInstallationMedia` operation.
    ///
    /// See [`ImportInstallationMedia`](crate::client::fluent_builders::ImportInstallationMedia) for more information about the
    /// operation and its arguments.
    pub fn import_installation_media(&self) -> fluent_builders::ImportInstallationMedia<C, M, R> {
        fluent_builders::ImportInstallationMedia::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyCertificates` operation.
    ///
    /// See [`ModifyCertificates`](crate::client::fluent_builders::ModifyCertificates) for more information about the
    /// operation and its arguments.
    pub fn modify_certificates(&self) -> fluent_builders::ModifyCertificates<C, M, R> {
        fluent_builders::ModifyCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyCurrentDBClusterCapacity` operation.
    ///
    /// See [`ModifyCurrentDBClusterCapacity`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity) for more information about the
    /// operation and its arguments.
    pub fn modify_current_db_cluster_capacity(
        &self,
    ) -> fluent_builders::ModifyCurrentDBClusterCapacity<C, M, R> {
        fluent_builders::ModifyCurrentDBClusterCapacity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyCustomDBEngineVersion` operation.
    ///
    /// See [`ModifyCustomDBEngineVersion`](crate::client::fluent_builders::ModifyCustomDBEngineVersion) for more information about the
    /// operation and its arguments.
    pub fn modify_custom_db_engine_version(
        &self,
    ) -> fluent_builders::ModifyCustomDBEngineVersion<C, M, R> {
        fluent_builders::ModifyCustomDBEngineVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBCluster` operation.
    ///
    /// See [`ModifyDBCluster`](crate::client::fluent_builders::ModifyDBCluster) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster(&self) -> fluent_builders::ModifyDBCluster<C, M, R> {
        fluent_builders::ModifyDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterEndpoint` operation.
    ///
    /// See [`ModifyDBClusterEndpoint`](crate::client::fluent_builders::ModifyDBClusterEndpoint) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_endpoint(&self) -> fluent_builders::ModifyDBClusterEndpoint<C, M, R> {
        fluent_builders::ModifyDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterParameterGroup` operation.
    ///
    /// See [`ModifyDBClusterParameterGroup`](crate::client::fluent_builders::ModifyDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ModifyDBClusterParameterGroup<C, M, R> {
        fluent_builders::ModifyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBClusterSnapshotAttribute` operation.
    ///
    /// See [`ModifyDBClusterSnapshotAttribute`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_db_cluster_snapshot_attribute(
        &self,
    ) -> fluent_builders::ModifyDBClusterSnapshotAttribute<C, M, R> {
        fluent_builders::ModifyDBClusterSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBInstance` operation.
    ///
    /// See [`ModifyDBInstance`](crate::client::fluent_builders::ModifyDBInstance) for more information about the
    /// operation and its arguments.
    pub fn modify_db_instance(&self) -> fluent_builders::ModifyDBInstance<C, M, R> {
        fluent_builders::ModifyDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBParameterGroup` operation.
    ///
    /// See [`ModifyDBParameterGroup`](crate::client::fluent_builders::ModifyDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_parameter_group(&self) -> fluent_builders::ModifyDBParameterGroup<C, M, R> {
        fluent_builders::ModifyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBProxy` operation.
    ///
    /// See [`ModifyDBProxy`](crate::client::fluent_builders::ModifyDBProxy) for more information about the
    /// operation and its arguments.
    pub fn modify_db_proxy(&self) -> fluent_builders::ModifyDBProxy<C, M, R> {
        fluent_builders::ModifyDBProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBProxyEndpoint` operation.
    ///
    /// See [`ModifyDBProxyEndpoint`](crate::client::fluent_builders::ModifyDBProxyEndpoint) for more information about the
    /// operation and its arguments.
    pub fn modify_db_proxy_endpoint(&self) -> fluent_builders::ModifyDBProxyEndpoint<C, M, R> {
        fluent_builders::ModifyDBProxyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBProxyTargetGroup` operation.
    ///
    /// See [`ModifyDBProxyTargetGroup`](crate::client::fluent_builders::ModifyDBProxyTargetGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_proxy_target_group(
        &self,
    ) -> fluent_builders::ModifyDBProxyTargetGroup<C, M, R> {
        fluent_builders::ModifyDBProxyTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBSnapshot` operation.
    ///
    /// See [`ModifyDBSnapshot`](crate::client::fluent_builders::ModifyDBSnapshot) for more information about the
    /// operation and its arguments.
    pub fn modify_db_snapshot(&self) -> fluent_builders::ModifyDBSnapshot<C, M, R> {
        fluent_builders::ModifyDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBSnapshotAttribute` operation.
    ///
    /// See [`ModifyDBSnapshotAttribute`](crate::client::fluent_builders::ModifyDBSnapshotAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_db_snapshot_attribute(
        &self,
    ) -> fluent_builders::ModifyDBSnapshotAttribute<C, M, R> {
        fluent_builders::ModifyDBSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDBSubnetGroup` operation.
    ///
    /// See [`ModifyDBSubnetGroup`](crate::client::fluent_builders::ModifyDBSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_db_subnet_group(&self) -> fluent_builders::ModifyDBSubnetGroup<C, M, R> {
        fluent_builders::ModifyDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEventSubscription` operation.
    ///
    /// See [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription<C, M, R> {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyGlobalCluster` operation.
    ///
    /// See [`ModifyGlobalCluster`](crate::client::fluent_builders::ModifyGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn modify_global_cluster(&self) -> fluent_builders::ModifyGlobalCluster<C, M, R> {
        fluent_builders::ModifyGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyOptionGroup` operation.
    ///
    /// See [`ModifyOptionGroup`](crate::client::fluent_builders::ModifyOptionGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_option_group(&self) -> fluent_builders::ModifyOptionGroup<C, M, R> {
        fluent_builders::ModifyOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PromoteReadReplica` operation.
    ///
    /// See [`PromoteReadReplica`](crate::client::fluent_builders::PromoteReadReplica) for more information about the
    /// operation and its arguments.
    pub fn promote_read_replica(&self) -> fluent_builders::PromoteReadReplica<C, M, R> {
        fluent_builders::PromoteReadReplica::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PromoteReadReplicaDBCluster` operation.
    ///
    /// See [`PromoteReadReplicaDBCluster`](crate::client::fluent_builders::PromoteReadReplicaDBCluster) for more information about the
    /// operation and its arguments.
    pub fn promote_read_replica_db_cluster(
        &self,
    ) -> fluent_builders::PromoteReadReplicaDBCluster<C, M, R> {
        fluent_builders::PromoteReadReplicaDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseReservedDBInstancesOffering` operation.
    ///
    /// See [`PurchaseReservedDBInstancesOffering`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_reserved_db_instances_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedDBInstancesOffering<C, M, R> {
        fluent_builders::PurchaseReservedDBInstancesOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootDBInstance` operation.
    ///
    /// See [`RebootDBInstance`](crate::client::fluent_builders::RebootDBInstance) for more information about the
    /// operation and its arguments.
    pub fn reboot_db_instance(&self) -> fluent_builders::RebootDBInstance<C, M, R> {
        fluent_builders::RebootDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterDBProxyTargets` operation.
    ///
    /// See [`RegisterDBProxyTargets`](crate::client::fluent_builders::RegisterDBProxyTargets) for more information about the
    /// operation and its arguments.
    pub fn register_db_proxy_targets(&self) -> fluent_builders::RegisterDBProxyTargets<C, M, R> {
        fluent_builders::RegisterDBProxyTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveFromGlobalCluster` operation.
    ///
    /// See [`RemoveFromGlobalCluster`](crate::client::fluent_builders::RemoveFromGlobalCluster) for more information about the
    /// operation and its arguments.
    pub fn remove_from_global_cluster(&self) -> fluent_builders::RemoveFromGlobalCluster<C, M, R> {
        fluent_builders::RemoveFromGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveRoleFromDBCluster` operation.
    ///
    /// See [`RemoveRoleFromDBCluster`](crate::client::fluent_builders::RemoveRoleFromDBCluster) for more information about the
    /// operation and its arguments.
    pub fn remove_role_from_db_cluster(&self) -> fluent_builders::RemoveRoleFromDBCluster<C, M, R> {
        fluent_builders::RemoveRoleFromDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveRoleFromDBInstance` operation.
    ///
    /// See [`RemoveRoleFromDBInstance`](crate::client::fluent_builders::RemoveRoleFromDBInstance) for more information about the
    /// operation and its arguments.
    pub fn remove_role_from_db_instance(
        &self,
    ) -> fluent_builders::RemoveRoleFromDBInstance<C, M, R> {
        fluent_builders::RemoveRoleFromDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveSourceIdentifierFromSubscription` operation.
    ///
    /// See [`RemoveSourceIdentifierFromSubscription`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription) for more information about the
    /// operation and its arguments.
    pub fn remove_source_identifier_from_subscription(
        &self,
    ) -> fluent_builders::RemoveSourceIdentifierFromSubscription<C, M, R> {
        fluent_builders::RemoveSourceIdentifierFromSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetDBClusterParameterGroup` operation.
    ///
    /// See [`ResetDBClusterParameterGroup`](crate::client::fluent_builders::ResetDBClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn reset_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ResetDBClusterParameterGroup<C, M, R> {
        fluent_builders::ResetDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetDBParameterGroup` operation.
    ///
    /// See [`ResetDBParameterGroup`](crate::client::fluent_builders::ResetDBParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn reset_db_parameter_group(&self) -> fluent_builders::ResetDBParameterGroup<C, M, R> {
        fluent_builders::ResetDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBClusterFromS3` operation.
    ///
    /// See [`RestoreDBClusterFromS3`](crate::client::fluent_builders::RestoreDBClusterFromS3) for more information about the
    /// operation and its arguments.
    pub fn restore_db_cluster_from_s3(&self) -> fluent_builders::RestoreDBClusterFromS3<C, M, R> {
        fluent_builders::RestoreDBClusterFromS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBClusterFromSnapshot` operation.
    ///
    /// See [`RestoreDBClusterFromSnapshot`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot) for more information about the
    /// operation and its arguments.
    pub fn restore_db_cluster_from_snapshot(
        &self,
    ) -> fluent_builders::RestoreDBClusterFromSnapshot<C, M, R> {
        fluent_builders::RestoreDBClusterFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBClusterToPointInTime` operation.
    ///
    /// See [`RestoreDBClusterToPointInTime`](crate::client::fluent_builders::RestoreDBClusterToPointInTime) for more information about the
    /// operation and its arguments.
    pub fn restore_db_cluster_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreDBClusterToPointInTime<C, M, R> {
        fluent_builders::RestoreDBClusterToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBInstanceFromDBSnapshot` operation.
    ///
    /// See [`RestoreDBInstanceFromDBSnapshot`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot) for more information about the
    /// operation and its arguments.
    pub fn restore_db_instance_from_db_snapshot(
        &self,
    ) -> fluent_builders::RestoreDBInstanceFromDBSnapshot<C, M, R> {
        fluent_builders::RestoreDBInstanceFromDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBInstanceFromS3` operation.
    ///
    /// See [`RestoreDBInstanceFromS3`](crate::client::fluent_builders::RestoreDBInstanceFromS3) for more information about the
    /// operation and its arguments.
    pub fn restore_db_instance_from_s3(&self) -> fluent_builders::RestoreDBInstanceFromS3<C, M, R> {
        fluent_builders::RestoreDBInstanceFromS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreDBInstanceToPointInTime` operation.
    ///
    /// See [`RestoreDBInstanceToPointInTime`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime) for more information about the
    /// operation and its arguments.
    pub fn restore_db_instance_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreDBInstanceToPointInTime<C, M, R> {
        fluent_builders::RestoreDBInstanceToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeDBSecurityGroupIngress` operation.
    ///
    /// See [`RevokeDBSecurityGroupIngress`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress) for more information about the
    /// operation and its arguments.
    pub fn revoke_db_security_group_ingress(
        &self,
    ) -> fluent_builders::RevokeDBSecurityGroupIngress<C, M, R> {
        fluent_builders::RevokeDBSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartActivityStream` operation.
    ///
    /// See [`StartActivityStream`](crate::client::fluent_builders::StartActivityStream) for more information about the
    /// operation and its arguments.
    pub fn start_activity_stream(&self) -> fluent_builders::StartActivityStream<C, M, R> {
        fluent_builders::StartActivityStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDBCluster` operation.
    ///
    /// See [`StartDBCluster`](crate::client::fluent_builders::StartDBCluster) for more information about the
    /// operation and its arguments.
    pub fn start_db_cluster(&self) -> fluent_builders::StartDBCluster<C, M, R> {
        fluent_builders::StartDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDBInstance` operation.
    ///
    /// See [`StartDBInstance`](crate::client::fluent_builders::StartDBInstance) for more information about the
    /// operation and its arguments.
    pub fn start_db_instance(&self) -> fluent_builders::StartDBInstance<C, M, R> {
        fluent_builders::StartDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDBInstanceAutomatedBackupsReplication` operation.
    ///
    /// See [`StartDBInstanceAutomatedBackupsReplication`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication) for more information about the
    /// operation and its arguments.
    pub fn start_db_instance_automated_backups_replication(
        &self,
    ) -> fluent_builders::StartDBInstanceAutomatedBackupsReplication<C, M, R> {
        fluent_builders::StartDBInstanceAutomatedBackupsReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartExportTask` operation.
    ///
    /// See [`StartExportTask`](crate::client::fluent_builders::StartExportTask) for more information about the
    /// operation and its arguments.
    pub fn start_export_task(&self) -> fluent_builders::StartExportTask<C, M, R> {
        fluent_builders::StartExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopActivityStream` operation.
    ///
    /// See [`StopActivityStream`](crate::client::fluent_builders::StopActivityStream) for more information about the
    /// operation and its arguments.
    pub fn stop_activity_stream(&self) -> fluent_builders::StopActivityStream<C, M, R> {
        fluent_builders::StopActivityStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDBCluster` operation.
    ///
    /// See [`StopDBCluster`](crate::client::fluent_builders::StopDBCluster) for more information about the
    /// operation and its arguments.
    pub fn stop_db_cluster(&self) -> fluent_builders::StopDBCluster<C, M, R> {
        fluent_builders::StopDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDBInstance` operation.
    ///
    /// See [`StopDBInstance`](crate::client::fluent_builders::StopDBInstance) for more information about the
    /// operation and its arguments.
    pub fn stop_db_instance(&self) -> fluent_builders::StopDBInstance<C, M, R> {
        fluent_builders::StopDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopDBInstanceAutomatedBackupsReplication` operation.
    ///
    /// See [`StopDBInstanceAutomatedBackupsReplication`](crate::client::fluent_builders::StopDBInstanceAutomatedBackupsReplication) for more information about the
    /// operation and its arguments.
    pub fn stop_db_instance_automated_backups_replication(
        &self,
    ) -> fluent_builders::StopDBInstanceAutomatedBackupsReplication<C, M, R> {
        fluent_builders::StopDBInstanceAutomatedBackupsReplication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddRoleToDBCluster`.
    ///
    /// <p>Associates an Identity and Access Management (IAM) role from an Amazon Aurora DB cluster.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.html">Authorizing Amazon Aurora MySQL
    /// to Access Other Amazon Web Services Services on Your Behalf</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AddRoleToDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_role_to_db_cluster_input::Builder,
    }
    impl<C, M, R> AddRoleToDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddRoleToDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRoleToDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddRoleToDbClusterInputOperationOutputAlias,
                crate::output::AddRoleToDbClusterOutput,
                crate::error::AddRoleToDBClusterError,
                crate::input::AddRoleToDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB
        /// cluster, for example, <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB
        /// cluster, for example, <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be associated with.
        /// For information about supported feature names, see <a>DBEngineVersion</a>.</p>
        pub fn feature_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(inp);
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be associated with.
        /// For information about supported feature names, see <a>DBEngineVersion</a>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddRoleToDBInstance`.
    ///
    /// <p>Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.</p>
    /// <note>
    /// <p>To add a role to a DB instance, the status of the DB instance must be <code>available</code>.</p>
    /// </note>
    /// <p>This command doesn't apply to RDS Custom.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddRoleToDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_role_to_db_instance_input::Builder,
    }
    impl<C, M, R> AddRoleToDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddRoleToDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRoleToDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRoleToDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddRoleToDbInstanceInputOperationOutputAlias,
                crate::output::AddRoleToDbInstanceOutput,
                crate::error::AddRoleToDBInstanceError,
                crate::input::AddRoleToDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB instance to associate the IAM role with.</p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The name of the DB instance to associate the IAM role with.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for
        /// example <code>arn:aws:iam::123456789012:role/AccessRole</code>. </p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for
        /// example <code>arn:aws:iam::123456789012:role/AccessRole</code>. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the DB instance that the IAM role is to be associated with.
        /// For information about supported feature names, see <a>DBEngineVersion</a>.
        /// </p>
        pub fn feature_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(inp);
            self
        }
        /// <p>The name of the feature for the DB instance that the IAM role is to be associated with.
        /// For information about supported feature names, see <a>DBEngineVersion</a>.
        /// </p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddSourceIdentifierToSubscription`.
    ///
    /// <p>Adds a source identifier to an existing RDS event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddSourceIdentifierToSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_source_identifier_to_subscription_input::Builder,
    }
    impl<C, M, R> AddSourceIdentifierToSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddSourceIdentifierToSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddSourceIdentifierToSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddSourceIdentifierToSubscriptionInputOperationOutputAlias,
                crate::output::AddSourceIdentifierToSubscriptionOutput,
                crate::error::AddSourceIdentifierToSubscriptionError,
                crate::input::AddSourceIdentifierToSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.</p>
    /// <p>For an overview on tagging Amazon RDS resources,
    /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyPendingMaintenanceAction`.
    ///
    /// <p>Applies a pending maintenance action to a resource (for example, to a DB instance).</p>
    #[derive(std::fmt::Debug)]
    pub struct ApplyPendingMaintenanceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_pending_maintenance_action_input::Builder,
    }
    impl<C, M, R> ApplyPendingMaintenanceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplyPendingMaintenanceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyPendingMaintenanceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplyPendingMaintenanceActionInputOperationOutputAlias,
                crate::output::ApplyPendingMaintenanceActionOutput,
                crate::error::ApplyPendingMaintenanceActionError,
                crate::input::ApplyPendingMaintenanceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The RDS Amazon Resource Name (ARN) of the resource that the
        /// pending maintenance action applies to. For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The RDS Amazon Resource Name (ARN) of the resource that the
        /// pending maintenance action applies to. For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>,
        /// <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code>
        /// </p>
        pub fn apply_action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.apply_action(inp);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>,
        /// <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code>
        /// </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_apply_action(input);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in
        /// request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during
        /// the next maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code>
        /// opt-in requests.</p>
        /// </li>
        /// </ul>
        pub fn opt_in_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_in_type(inp);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in
        /// request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during
        /// the next maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code>
        /// opt-in requests.</p>
        /// </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_opt_in_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeDBSecurityGroupIngress`.
    ///
    /// <p>Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security
    /// groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC
    /// instances. Second, IP ranges are available if the application accessing your database is running on the Internet.
    /// Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId
    /// and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).</p>
    /// <note>
    /// <p>You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance in
    /// another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.</p>
    /// </note>
    /// <p>For an overview of CIDR ranges, go to the
    /// <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AuthorizeDBSecurityGroupIngress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_db_security_group_ingress_input::Builder,
    }
    impl<C, M, R> AuthorizeDBSecurityGroupIngress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeDBSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeDbSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeDBSecurityGroupIngressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeDbSecurityGroupIngressInputOperationOutputAlias,
                crate::output::AuthorizeDbSecurityGroupIngressOutput,
                crate::error::AuthorizeDBSecurityGroupIngressError,
                crate::input::AuthorizeDbSecurityGroupIngressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB security group to add authorization to.</p>
        pub fn db_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_group_name(inp);
            self
        }
        /// <p>The name of the DB security group to add authorization to.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_security_group_name(input);
            self
        }
        /// <p>The IP range to authorize.</p>
        pub fn cidrip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidrip(inp);
            self
        }
        /// <p>The IP range to authorize.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidrip(input);
            self
        }
        /// <p>
        /// Name of the EC2 security group to authorize.
        /// For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided.
        /// Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code>
        /// or <code>EC2SecurityGroupId</code> must be provided.
        /// </p>
        pub fn ec2_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_name(inp);
            self
        }
        /// <p>
        /// Name of the EC2 security group to authorize.
        /// For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided.
        /// Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code>
        /// or <code>EC2SecurityGroupId</code> must be provided.
        /// </p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_name(input);
            self
        }
        /// <p>
        /// Id of the EC2 security group to authorize.
        /// For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided.
        /// Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
        /// </p>
        pub fn ec2_security_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_id(inp);
            self
        }
        /// <p>
        /// Id of the EC2 security group to authorize.
        /// For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided.
        /// Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
        /// </p>
        pub fn set_ec2_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_id(input);
            self
        }
        /// <p>
        /// Amazon Web Services account number of the owner of the EC2 security group
        /// specified in the <code>EC2SecurityGroupName</code> parameter.
        /// The Amazon Web Services access key ID isn't an acceptable value.
        /// For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided.
        /// Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
        /// </p>
        pub fn ec2_security_group_owner_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_owner_id(inp);
            self
        }
        /// <p>
        /// Amazon Web Services account number of the owner of the EC2 security group
        /// specified in the <code>EC2SecurityGroupName</code> parameter.
        /// The Amazon Web Services access key ID isn't an acceptable value.
        /// For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided.
        /// Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
        /// </p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BacktrackDBCluster`.
    ///
    /// <p>Backtracks a DB cluster to a specific time, without creating a new DB cluster.</p>
    /// <p>For more information on backtracking, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
    /// Backtracking an Aurora DB Cluster</a> in the
    /// <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora MySQL DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BacktrackDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::backtrack_db_cluster_input::Builder,
    }
    impl<C, M, R> BacktrackDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BacktrackDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BacktrackDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::BacktrackDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BacktrackDbClusterInputOperationOutputAlias,
                crate::output::BacktrackDbClusterOutput,
                crate::error::BacktrackDBClusterError,
                crate::input::BacktrackDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO
        /// 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
        /// page.</a>
        /// </p>
        /// <note>
        /// <p>If the specified time isn't a consistent time for the DB cluster,
        /// Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain a valid ISO 8601 timestamp.</p>
        /// </li>
        /// <li>
        /// <p>Can't contain a timestamp set in the future.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2017-07-08T18:00Z</code>
        /// </p>
        pub fn backtrack_to(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.backtrack_to(inp);
            self
        }
        /// <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO
        /// 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
        /// page.</a>
        /// </p>
        /// <note>
        /// <p>If the specified time isn't a consistent time for the DB cluster,
        /// Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain a valid ISO 8601 timestamp.</p>
        /// </li>
        /// <li>
        /// <p>Can't contain a timestamp set in the future.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>2017-07-08T18:00Z</code>
        /// </p>
        pub fn set_backtrack_to(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_backtrack_to(input);
            self
        }
        /// <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is
        /// enabled. Otherwise, an error occurs when binary logging is enabled.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is
        /// enabled. Otherwise, an error occurs when binary logging is enabled.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>A value that indicates whether to backtrack the DB cluster to the earliest possible
        /// backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest
        /// backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest
        /// backtrack time, an error occurs.</p>
        pub fn use_earliest_time_on_point_in_time_unavailable(mut self, inp: bool) -> Self {
            self.inner = self
                .inner
                .use_earliest_time_on_point_in_time_unavailable(inp);
            self
        }
        /// <p>A value that indicates whether to backtrack the DB cluster to the earliest possible
        /// backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest
        /// backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest
        /// backtrack time, an error occurs.</p>
        pub fn set_use_earliest_time_on_point_in_time_unavailable(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_use_earliest_time_on_point_in_time_unavailable(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelExportTask`.
    ///
    /// <p>Cancels an export task in progress that is exporting a snapshot to Amazon S3.
    /// Any data that has already been written to the S3 bucket isn't removed.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CancelExportTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_export_task_input::Builder,
    }
    impl<C, M, R> CancelExportTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelExportTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelExportTaskInputOperationOutputAlias,
                crate::output::CancelExportTaskOutput,
                crate::error::CancelExportTaskError,
                crate::input::CancelExportTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot export task to cancel.</p>
        pub fn export_task_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_task_identifier(inp);
            self
        }
        /// <p>The identifier of the snapshot export task to cancel.</p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_export_task_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterParameterGroup`.
    ///
    /// <p>Copies the specified DB cluster parameter group.</p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> CopyDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::CopyDbClusterParameterGroupOutput,
                crate::error::CopyDBClusterParameterGroupError,
                crate::input::CopyDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group.
        /// For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_cluster_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group.
        /// For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_source_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_cluster_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code>
        /// </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_parameter_group_description(inp);
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterSnapshot`.
    ///
    /// <p>Copies a snapshot of a DB cluster.</p>
    /// <p>To copy a DB cluster snapshot from a shared manual DB cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code>
    /// must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.</p>
    ///
    /// <p>You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon Web Services Region where you call the <code>CopyDBClusterSnapshot</code> action
    /// is the destination Amazon Web Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot from another Amazon Web Services Region,
    /// you must provide the following values:</p>     
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to
    /// encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PreSignedUrl</code> -  A URL that contains a Signature Version 4 signed request for the
    /// <code>CopyDBClusterSnapshot</code> action to be called in the source Amazon Web Services Region where the DB cluster snapshot is copied from.
    /// The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the
    /// source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied.</p>
    /// <p>The pre-signed URL request must contain the following parameter values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB
    /// cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code>
    /// action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
    /// snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example,
    /// if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code>
    /// looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p>
    /// </li>
    /// </ul>
    /// <p>To learn how to generate a Signature Version 4 signed request, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
    /// Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
    /// Signature Version 4 Signing Process</a>.</p>
    /// <note>
    /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
    /// instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid
    /// request for the operation that can be executed in the source Amazon Web Services Region.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in the destination Amazon Web Services Region.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied.
    /// This identifier must be in the ARN format for the source Amazon Web Services Region and is the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the pre-signed URL. </p>
    /// </li>
    /// </ul>
    /// <p>To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified
    /// by <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.</p>
    /// <p>For more information on copying encrypted DB cluster snapshots from one Amazon Web Services Region to another, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
    /// Copying a Snapshot</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <p>For more information on Amazon Aurora, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CopyDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbClusterSnapshotInputOperationOutputAlias,
                crate::output::CopyDbClusterSnapshotOutput,
                crate::error::CopyDBClusterSnapshotError,
                crate::input::CopyDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p>
        /// <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy,
        /// specify a valid DB cluster snapshot ARN. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions">
        /// Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p>
        /// <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p>
        /// </li>
        /// <li>
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy,
        /// specify a valid DB cluster snapshot ARN. For more information, go to
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions">
        /// Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code>
        /// </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code>
        /// </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot.
        /// The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p>             
        ///
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key.
        /// If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
        /// </p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>. </p>
        ///
        /// <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier
        /// you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services
        /// Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region
        /// in another Amazon Web Services Region.</p>
        ///
        /// <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter,
        /// an error is returned.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot.
        /// The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p>             
        ///
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key.
        /// If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
        /// </p>
        ///
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>. </p>
        ///
        /// <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier
        /// you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services
        /// Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region
        /// in another Amazon Web Services Region.</p>
        ///
        /// <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter,
        /// an error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the
        /// source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region.
        /// Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be
        /// executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied.
        /// The pre-signed URL request must contain the following parameter values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB
        /// cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code>
        /// action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
        /// snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example,
        /// if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code>
        /// looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        ///
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
        /// Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
        /// Signature Version 4 Signing Process</a>.</p>
        ///
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid
        /// request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the
        /// source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region.
        /// Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be
        /// executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied.
        /// The pre-signed URL request must contain the following parameter values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB
        /// cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code>
        /// action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
        /// snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example,
        /// if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code>
        /// looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        ///
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
        /// Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
        /// Signature Version 4 Signing Process</a>.</p>
        ///
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid
        /// request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot.
        /// By default, tags are not copied.</p>
        pub fn copy_tags(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags(inp);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot.
        /// By default, tags are not copied.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBParameterGroup`.
    ///
    /// <p>Copies the specified DB parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_parameter_group_input::Builder,
    }
    impl<C, M, R> CopyDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbParameterGroupInputOperationOutputAlias,
                crate::output::CopyDbParameterGroupOutput,
                crate::error::CopyDBParameterGroupError,
                crate::input::CopyDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier or ARN for the source DB parameter group.
        /// For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB parameter group.</p>
        /// </li>
        /// </ul>
        pub fn source_db_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_parameter_group_identifier(inp);
            self
        }
        /// <p>
        /// The identifier or ARN for the source DB parameter group.
        /// For information about  
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid DB parameter group.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code>
        /// </p>
        pub fn target_db_parameter_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_parameter_group_identifier(inp);
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code>
        /// </p>
        pub fn set_target_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn target_db_parameter_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_parameter_group_description(inp);
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn set_target_db_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBSnapshot`.
    ///
    /// <p>Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.</p>
    ///
    /// <p>You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services Region
    /// where you call the <code>CopyDBSnapshot</code> action is the destination Amazon Web Services Region for the
    /// DB snapshot copy. </p>     
    ///
    /// <p>This command doesn't apply to RDS Custom.</p>
    ///
    /// <p>For more information about copying snapshots, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying a DB Snapshot</a> in the <i>Amazon RDS User Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CopyDBSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_db_snapshot_input::Builder,
    }
    impl<C, M, R> CopyDBSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyDBSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyDbSnapshotInputOperationOutputAlias,
                crate::output::CopyDbSnapshotOutput,
                crate::error::CopyDBSnapshotError,
                crate::input::CopyDbSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the source DB snapshot.</p>
        ///
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB
        /// snapshot identifier. For example, you might specify
        /// <code>rds:mysql-instance1-snapshot-20130805</code>. </p>
        ///
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB
        /// snapshot ARN. For example, you might specify
        /// <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>. </p>
        ///
        /// <p>If you are copying from a shared manual DB snapshot,
        /// this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.
        /// </p>
        ///
        /// <p>If you are copying an encrypted snapshot
        /// this parameter must be in the ARN format for the source Amazon Web Services Region,
        /// and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter.
        /// </p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>rds:mydb-2012-04-02-00-01</code>
        /// </p>
        ///
        /// <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>
        /// </p>
        pub fn source_db_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the source DB snapshot.</p>
        ///
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB
        /// snapshot identifier. For example, you might specify
        /// <code>rds:mysql-instance1-snapshot-20130805</code>. </p>
        ///
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB
        /// snapshot ARN. For example, you might specify
        /// <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>. </p>
        ///
        /// <p>If you are copying from a shared manual DB snapshot,
        /// this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.
        /// </p>
        ///
        /// <p>If you are copying an encrypted snapshot
        /// this parameter must be in the ARN format for the source Amazon Web Services Region,
        /// and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter.
        /// </p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid system snapshot in the "available" state.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>rds:mydb-2012-04-02-00-01</code>
        /// </p>
        ///
        /// <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>
        /// </p>
        pub fn set_source_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_snapshot_identifier(input);
            self
        }
        /// <p>The identifier for the copy of the snapshot.
        /// </p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>my-db-snapshot</code>
        /// </p>
        pub fn target_db_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the copy of the snapshot.
        /// </p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>my-db-snapshot</code>
        /// </p>
        pub fn set_target_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot.
        /// The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
        /// </p>
        ///
        /// <p>If you copy an encrypted DB snapshot from your Amazon Web Services account,
        /// you can specify a value for this parameter to encrypt the copy with a new KMS key.
        /// If you don't specify a value for this parameter,
        /// then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.
        /// </p>
        ///
        /// <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account,
        /// then you must specify a value for this parameter.
        /// </p>
        ///
        /// <p>If you specify this parameter when you copy an unencrypted snapshot,
        /// the copy is encrypted.
        /// </p>
        ///
        /// <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify
        /// an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region
        /// that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another
        /// Amazon Web Services Region.
        /// </p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot.
        /// The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
        /// </p>
        ///
        /// <p>If you copy an encrypted DB snapshot from your Amazon Web Services account,
        /// you can specify a value for this parameter to encrypt the copy with a new KMS key.
        /// If you don't specify a value for this parameter,
        /// then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.
        /// </p>
        ///
        /// <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account,
        /// then you must specify a value for this parameter.
        /// </p>
        ///
        /// <p>If you specify this parameter when you copy an unencrypted snapshot,
        /// the copy is encrypted.
        /// </p>
        ///
        /// <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify
        /// an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region
        /// that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another
        /// Amazon Web Services Region.
        /// </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
        pub fn copy_tags(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags(inp);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the
        /// <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the
        /// source DB snapshot to copy. </p>
        ///
        /// <p>You must specify this parameter when you copy an encrypted DB snapshot from another
        /// Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are
        /// copying an encrypted DB snapshot in the same Amazon Web Services Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action
        /// that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied.
        /// The presigned URL request must contain the following parameter values:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to.
        /// This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL.
        /// </p>
        ///
        /// <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region
        /// to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in
        /// the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the
        /// <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this
        /// example, the <code>DestinationRegion</code> in the presigned URL must be set to
        /// the us-east-1 Amazon Web Services Region. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region.
        /// This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region,
        /// and the action contained in the presigned URL.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied.
        /// This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region.
        /// For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like
        /// the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.
        /// </p>
        ///
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid
        /// request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the
        /// <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the
        /// source DB snapshot to copy. </p>
        ///
        /// <p>You must specify this parameter when you copy an encrypted DB snapshot from another
        /// Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are
        /// copying an encrypted DB snapshot in the same Amazon Web Services Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action
        /// that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied.
        /// The presigned URL request must contain the following parameter values:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to.
        /// This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL.
        /// </p>
        ///
        /// <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region
        /// to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in
        /// the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the
        /// <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this
        /// example, the <code>DestinationRegion</code> in the presigned URL must be set to
        /// the us-east-1 Amazon Web Services Region. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region.
        /// This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region,
        /// and the action contained in the presigned URL.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied.
        /// This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region.
        /// For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like
        /// the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.
        /// </p>
        ///
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid
        /// request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>The name of an option group to associate with the copy of the snapshot.</p>
        ///
        /// <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another,
        /// and your DB instance uses a nondefault option group.
        /// If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server,
        /// you must specify this option when copying across Amazon Web Services Regions.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>The name of an option group to associate with the copy of the snapshot.</p>
        ///
        /// <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another,
        /// and your DB instance uses a nondefault option group.
        /// If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server,
        /// you must specify this option when copying across Amazon Web Services Regions.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p>
        /// <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
        pub fn target_custom_availability_zone(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_custom_availability_zone(inp);
            self
        }
        /// <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p>
        /// <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
        pub fn set_target_custom_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_custom_availability_zone(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyOptionGroup`.
    ///
    /// <p>Copies the specified option group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyOptionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_option_group_input::Builder,
    }
    impl<C, M, R> CopyOptionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyOptionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyOptionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyOptionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyOptionGroupInputOperationOutputAlias,
                crate::output::CopyOptionGroupOutput,
                crate::error::CopyOptionGroupError,
                crate::input::CopyOptionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the source option group.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid option group.</p>
        /// </li>
        /// </ul>
        pub fn source_option_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_option_group_identifier(inp);
            self
        }
        /// <p>The identifier for the source option group.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid option group.</p>
        /// </li>
        /// </ul>
        pub fn set_source_option_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_option_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-option-group</code>
        /// </p>
        pub fn target_option_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_option_group_identifier(inp);
            self
        }
        /// <p>The identifier for the copied option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-option-group</code>
        /// </p>
        pub fn set_target_option_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_option_group_identifier(input);
            self
        }
        /// <p>The description for the copied option group.</p>
        pub fn target_option_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_option_group_description(inp);
            self
        }
        /// <p>The description for the copied option group.</p>
        pub fn set_target_option_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_option_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomAvailabilityZone`.
    ///
    /// <p>Creates a custom Availability Zone (AZ).</p>
    /// <p>A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
    /// <p>For more information about RDS on VMware, see the
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
    /// RDS on VMware User Guide.</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomAvailabilityZone<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_availability_zone_input::Builder,
    }
    impl<C, M, R> CreateCustomAvailabilityZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomAvailabilityZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomAvailabilityZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomAvailabilityZoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomAvailabilityZoneInputOperationOutputAlias,
                crate::output::CreateCustomAvailabilityZoneOutput,
                crate::error::CreateCustomAvailabilityZoneError,
                crate::input::CreateCustomAvailabilityZoneInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom Availability Zone (AZ).</p>
        pub fn custom_availability_zone_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.custom_availability_zone_name(inp);
            self
        }
        /// <p>The name of the custom Availability Zone (AZ).</p>
        pub fn set_custom_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_availability_zone_name(input);
            self
        }
        /// <p>The ID of an existing virtual private network (VPN) between the Amazon RDS website and
        /// the VMware vSphere cluster.</p>
        pub fn existing_vpn_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.existing_vpn_id(inp);
            self
        }
        /// <p>The ID of an existing virtual private network (VPN) between the Amazon RDS website and
        /// the VMware vSphere cluster.</p>
        pub fn set_existing_vpn_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_existing_vpn_id(input);
            self
        }
        /// <p>The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.</p>
        /// <p>Specify this parameter only if <code>ExistingVpnId</code> isn't specified.</p>
        pub fn new_vpn_tunnel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_vpn_tunnel_name(inp);
            self
        }
        /// <p>The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster.</p>
        /// <p>Specify this parameter only if <code>ExistingVpnId</code> isn't specified.</p>
        pub fn set_new_vpn_tunnel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_vpn_tunnel_name(input);
            self
        }
        /// <p>The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.</p>
        /// <p>Specify this parameter only if <code>ExistingVpnId</code> isn't specified.</p>
        pub fn vpn_tunnel_originator_ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpn_tunnel_originator_ip(inp);
            self
        }
        /// <p>The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.</p>
        /// <p>Specify this parameter only if <code>ExistingVpnId</code> isn't specified.</p>
        pub fn set_vpn_tunnel_originator_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpn_tunnel_originator_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomDBEngineVersion`.
    ///
    /// <p>Creates a custom DB engine version (CEV). A CEV is a binary volume snapshot of a database engine and
    /// specific AMI. The only supported engine is Oracle Database 19c Enterprise Edition with the January 2021
    /// or later RU/RUR. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
    /// Amazon RDS Custom requirements and limitations</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// <p>Amazon RDS, which is a fully managed service, supplies the Amazon Machine Image (AMI) and database software.
    /// The Amazon RDS database software is preinstalled, so you need only select a DB engine and version, and create
    /// your database. With Amazon RDS Custom, you upload your database installation files in Amazon S3. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.html#custom-cev.preparing">
    /// Preparing to create a CEV</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// <p>When you create a custom engine version, you specify the files in a JSON document called a CEV manifest.
    /// This document describes installation .zip files stored in Amazon S3. RDS Custom creates your CEV from
    /// the installation files that you provided. This service model is called Bring Your Own Media (BYOM).</p>
    /// <p>Creation takes approximately two hours. If creation fails, RDS Custom issues <code>RDS-EVENT-0196</code> with
    /// the message <code>Creation failed for custom engine version</code>, and includes details about the failure.
    /// For example, the event prints missing files. </p>
    /// <p>After you create the CEV, it is available for use. You can create multiple CEVs, and create multiple
    /// RDS Custom instances from any CEV. You can also change the status of a CEV to make it available or
    /// inactive.</p>
    /// <note>
    /// <p>The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
    /// Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
    /// <code>CreateCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the
    /// API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
    /// the <code>CreateCustomDbEngineVersion</code> event.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.create">
    /// Creating a CEV</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomDBEngineVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_db_engine_version_input::Builder,
    }
    impl<C, M, R> CreateCustomDBEngineVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomDBEngineVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomDbEngineVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomDBEngineVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomDbEngineVersionInputOperationOutputAlias,
                crate::output::CreateCustomDbEngineVersionOutput,
                crate::error::CreateCustomDBEngineVersionError,
                crate::input::CreateCustomDbEngineVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The database engine to use for your custom engine version (CEV). The only supported value is
        /// <code>custom-oracle-ee</code>.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The database engine to use for your custom engine version (CEV). The only supported value is
        /// <code>custom-oracle-ee</code>.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The name of your CEV. The name format is <code>19.<i>customized_string</i>
        /// </code>. For example,
        /// a valid name is <code>19.my_cev1</code>. This setting is required for RDS Custom, but optional for Amazon RDS.
        /// The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The name of your CEV. The name format is <code>19.<i>customized_string</i>
        /// </code>. For example,
        /// a valid name is <code>19.my_cev1</code>. This setting is required for RDS Custom, but optional for Amazon RDS.
        /// The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid
        /// bucket name is <code>my-custom-installation-files</code>.</p>
        pub fn database_installation_files_s3_bucket_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.database_installation_files_s3_bucket_name(inp);
            self
        }
        /// <p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid
        /// bucket name is <code>my-custom-installation-files</code>.</p>
        pub fn set_database_installation_files_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_database_installation_files_s3_bucket_name(input);
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid
        /// bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.</p>
        pub fn database_installation_files_s3_prefix(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.database_installation_files_s3_prefix(inp);
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid
        /// bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.</p>
        pub fn set_database_installation_files_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_installation_files_s3_prefix(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        /// <p>If you have an existing symmetric KMS key in your account, you can use it with RDS Custom.
        /// No further action is necessary. If you don't already have a symmetric KMS key in your account,
        /// follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">
        /// Creating symmetric KMS keys</a> in the <i>Amazon Web Services Key Management Service
        /// Developer Guide</i>.</p>
        /// <p>You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        /// <p>If you have an existing symmetric KMS key in your account, you can use it with RDS Custom.
        /// No further action is necessary. If you don't already have a symmetric KMS key in your account,
        /// follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">
        /// Creating symmetric KMS keys</a> in the <i>Amazon Web Services Key Management Service
        /// Developer Guide</i>.</p>
        /// <p>You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3.
        /// Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which
        /// they are listed.</p>
        /// <p>The following JSON fields are valid:</p>
        /// <dl>
        /// <dt>MediaImportTemplateVersion</dt>
        /// <dd>
        /// <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p>
        /// </dd>
        /// <dt>databaseInstallationFileNames</dt>
        /// <dd>
        /// <p>Ordered list of installation files for the CEV.</p>
        /// </dd>
        /// <dt>opatchFileNames</dt>
        /// <dd>
        /// <p>Ordered list of OPatch installers used for the Oracle DB engine.</p>
        /// </dd>
        /// <dt>psuRuPatchFileNames</dt>
        /// <dd>
        /// <p>The PSU and RU patches for this CEV.</p>
        /// </dd>
        /// <dt>OtherPatchFileNames</dt>
        /// <dd>
        /// <p>The patches that are not in the list of PSU and RU patches.
        /// Amazon RDS applies these patches after applying the PSU and RU patches. </p>
        /// </dd>
        /// </dl>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
        /// Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn manifest(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.manifest(inp);
            self
        }
        /// <p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3.
        /// Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which
        /// they are listed.</p>
        /// <p>The following JSON fields are valid:</p>
        /// <dl>
        /// <dt>MediaImportTemplateVersion</dt>
        /// <dd>
        /// <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p>
        /// </dd>
        /// <dt>databaseInstallationFileNames</dt>
        /// <dd>
        /// <p>Ordered list of installation files for the CEV.</p>
        /// </dd>
        /// <dt>opatchFileNames</dt>
        /// <dd>
        /// <p>Ordered list of OPatch installers used for the Oracle DB engine.</p>
        /// </dd>
        /// <dt>psuRuPatchFileNames</dt>
        /// <dd>
        /// <p>The PSU and RU patches for this CEV.</p>
        /// </dd>
        /// <dt>OtherPatchFileNames</dt>
        /// <dd>
        /// <p>The patches that are not in the list of PSU and RU patches.
        /// Amazon RDS applies these patches after applying the PSU and RU patches. </p>
        /// </dd>
        /// </dl>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
        /// Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_manifest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_manifest(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBCluster`.
    ///
    /// <p>Creates a new Amazon Aurora DB cluster.</p>
    /// <p>You can use the <code>ReplicationSourceIdentifier</code> parameter to create the DB
    /// cluster as a read replica of another DB cluster or Amazon RDS MySQL or PostgreSQL DB instance. For
    /// cross-region replication where the DB cluster identified by
    /// <code>ReplicationSourceIdentifier</code> is encrypted, you must also specify the
    /// <code>PreSignedUrl</code> parameter.</p>
    ///
    /// <p>For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_input::Builder,
    }
    impl<C, M, R> CreateDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterInputOperationOutputAlias,
                crate::output::CreateDbClusterOutput,
                crate::error::CreateDBClusterError,
                crate::input::CreateDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on
        /// Amazon Web Services Regions and Availability Zones, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and
        /// Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        pub fn availability_zones(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(inp);
            self
        }
        /// <p>A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on
        /// Amazon Web Services Regions and Availability Zones, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and
        /// Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 1 to 35</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>
        pub fn character_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.character_set_name(inp);
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_character_set_name(input);
            self
        }
        /// <p>The name for your database of up to 64 alphanumeric characters. If you do not
        /// provide a name, Amazon RDS doesn't create a database in the DB cluster you are
        /// creating.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name for your database of up to 64 alphanumeric characters. If you do not
        /// provide a name, Amazon RDS doesn't create a database in the DB cluster you are
        /// creating.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>
        /// The name of the DB cluster parameter group to associate
        /// with this DB cluster. If you do not specify a value, then
        /// the default DB cluster parameter group for the specified DB engine and version is used.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>
        /// The name of the DB cluster parameter group to associate
        /// with this DB cluster. If you do not specify a value, then
        /// the default DB cluster parameter group for the specified DB engine and version is used.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
        /// </p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
        /// </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
        /// </p>
        /// <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
        /// </p>
        /// <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
        /// </p>
        /// <p>
        /// <b>Aurora MySQL</b>
        /// </p>
        /// <p>Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>, <code>5.7.mysql_aurora.2.04.5</code>
        /// </p>
        /// <p>
        /// <b>Aurora PostgreSQL</b>
        /// </p>
        /// <p>Example: <code>9.6.3</code>, <code>10.7</code>
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
        /// </p>
        /// <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
        /// </p>
        /// <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
        /// </p>
        /// <p>
        /// <b>Aurora MySQL</b>
        /// </p>
        /// <p>Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>, <code>5.7.mysql_aurora.2.04.5</code>
        /// </p>
        /// <p>
        /// <b>Aurora PostgreSQL</b>
        /// </p>
        /// <p>Example: <code>9.6.3</code>, <code>10.7</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p>
        /// Default: <code>3306</code> if engine is set as aurora or <code>5432</code> if set to aurora-postgresql.
        /// </p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p>
        /// Default: <code>3306</code> if engine is set as aurora or <code>5432</code> if set to aurora-postgresql.
        /// </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the master user for the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        pub fn master_username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(inp);
            self
        }
        /// <p>The name of the master user for the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>
        /// <p>Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster.</p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>
        /// <p>Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The daily time range during which automated backups are created
        /// if automated backups are enabled
        /// using the <code>BackupRetentionPeriod</code> parameter.
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region.
        /// To view the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">
        /// Backup window</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>The daily time range during which automated backups are created
        /// if automated backups are enabled
        /// using the <code>BackupRetentionPeriod</code> parameter.
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region.
        /// To view the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">
        /// Backup window</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
        /// week. To see the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">
        /// Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
        /// week. To see the time blocks available, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">
        /// Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB
        /// cluster is created as a read replica.</p>
        pub fn replication_source_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_source_identifier(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB
        /// cluster is created as a read replica.</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_source_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB cluster.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to assign to the DB cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.storage_encrypted(inp);
            self
        }
        /// <p>A value that indicates whether the DB cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
        /// To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>When a KMS key isn't specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted
        /// source, then Amazon RDS will use the KMS key used to encrypt the
        /// source. Otherwise, Amazon RDS will use your default KMS key. </p>
        /// </li>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is enabled and
        /// <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS
        /// will use your default KMS key.</p>
        /// </li>
        /// </ul>
        /// <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
        /// has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you
        /// must set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services
        /// Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
        /// To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>When a KMS key isn't specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted
        /// source, then Amazon RDS will use the KMS key used to encrypt the
        /// source. Otherwise, Amazon RDS will use your default KMS key. </p>
        /// </li>
        /// <li>
        /// <p>If the <code>StorageEncrypted</code> parameter is enabled and
        /// <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS
        /// will use your default KMS key.</p>
        /// </li>
        /// </ul>
        /// <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
        /// has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you
        /// must set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services
        /// Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>A URL that contains a Signature Version 4 signed request for
        /// the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from.
        /// You only need to specify <code>PreSignedUrl</code> when you are performing cross-region replication from an encrypted DB cluster.</p>
        ///
        /// <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action
        /// that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p>
        /// <p>The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of
        /// the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code>
        /// action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will
        /// be created in.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied.
        /// This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an
        /// encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like
        /// Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
        /// Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
        /// Signature Version 4 Signing Process</a>.</p>
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid
        /// request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>A URL that contains a Signature Version 4 signed request for
        /// the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from.
        /// You only need to specify <code>PreSignedUrl</code> when you are performing cross-region replication from an encrypted DB cluster.</p>
        ///
        /// <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action
        /// that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p>
        /// <p>The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of
        /// the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code>
        /// action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will
        /// be created in.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied.
        /// This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an
        /// encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like
        /// Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
        /// Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
        /// Signature Version 4 Signing Process</a>.</p>
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid
        /// request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
        /// Management (IAM) accounts to database accounts. By default, mapping is disabled.</p>
        ///
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
        /// IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
        /// Management (IAM) accounts to database accounts. By default, mapping is disabled.</p>
        ///
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
        /// IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>The target backtrack window, in seconds. To disable backtracking, set this value to
        /// 0. </p>
        /// <note>
        /// <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p>
        /// </note>
        /// <p>Default: 0</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p>
        /// </li>
        /// </ul>
        pub fn backtrack_window(mut self, inp: i64) -> Self {
            self.inner = self.inner.backtrack_window(inp);
            self
        }
        /// <p>The target backtrack window, in seconds. To disable backtracking, set this value to
        /// 0. </p>
        /// <note>
        /// <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p>
        /// </note>
        /// <p>Default: 0</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p>
        /// </li>
        /// </ul>
        pub fn set_backtrack_window(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_backtrack_window(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values
        /// in the list depend on the DB engine being used. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>
        /// <b>Aurora MySQL</b>
        /// </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
        /// </p>
        /// <p>
        /// <b>Aurora PostgreSQL</b>
        /// </p>
        /// <p>Possible value is <code>postgresql</code>.
        /// </p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values
        /// in the list depend on the DB engine being used. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>
        /// <b>Aurora MySQL</b>
        /// </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
        /// </p>
        /// <p>
        /// <b>Aurora PostgreSQL</b>
        /// </p>
        /// <p>Possible value is <code>postgresql</code>.
        /// </p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>,
        /// <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions,
        /// and version 2.09 and higher 2.x versions.</p>
        /// <p>The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions,
        /// and <code>global</code> engine mode isn't required for any 2.x versions.</p>
        /// <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p>
        /// <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code>
        /// and the <code>multimaster</code> engine modes currently aren't supported.</p>
        /// <p>Limitations and requirements apply to some DB engine modes. For more information, see the
        /// following sections in the <i>Amazon Aurora User Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">
        /// Limitations of Aurora Serverless</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">
        /// Limitations of Parallel Query</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">
        /// Limitations of Aurora Global Databases</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">
        /// Limitations of Multi-Master Clusters</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine_mode(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_mode(inp);
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>,
        /// <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions,
        /// and version 2.09 and higher 2.x versions.</p>
        /// <p>The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions,
        /// and <code>global</code> engine mode isn't required for any 2.x versions.</p>
        /// <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p>
        /// <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code>
        /// and the <code>multimaster</code> engine modes currently aren't supported.</p>
        /// <p>Limitations and requirements apply to some DB engine modes. For more information, see the
        /// following sections in the <i>Amazon Aurora User Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">
        /// Limitations of Aurora Serverless</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">
        /// Limitations of Parallel Query</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">
        /// Limitations of Aurora Global Databases</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">
        /// Limitations of Multi-Master Clusters</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_mode(input);
            self
        }
        /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
        pub fn scaling_configuration(mut self, inp: crate::model::ScalingConfiguration) -> Self {
            self.inner = self.inner.scaling_configuration(inp);
            self
        }
        /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
        pub fn set_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::ScalingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_scaling_configuration(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>
        /// The global cluster ID of an Aurora cluster that becomes the primary cluster
        /// in the new global database cluster.
        /// </p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>
        /// The global cluster ID of an Aurora cluster that becomes the primary cluster
        /// in the new global database cluster.
        /// </p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint
        /// is disabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running
        /// SQL queries on the Aurora Serverless DB cluster. You can also query your database
        /// from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the
        /// <i>Amazon Aurora User Guide</i>.</p>
        pub fn enable_http_endpoint(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_http_endpoint(inp);
            self
        }
        /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint
        /// is disabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running
        /// SQL queries on the Aurora Serverless DB cluster. You can also query your database
        /// from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the
        /// <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_enable_http_endpoint(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_http_endpoint(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
        /// The default is not to copy them.</p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
        /// The default is not to copy them.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The Active Directory directory ID to create the DB cluster in.</p>
        /// <p>
        /// For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a>
        /// in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The Active Directory directory ID to create the DB cluster in.</p>
        /// <p>
        /// For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a>
        /// in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn domain_iam_role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(inp);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an
        /// Aurora global database (<a>GlobalCluster</a>). By default, write operations are not allowed on Aurora DB clusters that
        /// are secondary clusters in an Aurora global database.</p>
        /// <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter
        /// enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to
        /// this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the
        /// primary is demoted by the <a>FailoverGlobalCluster</a> API operation, but it does nothing until then.
        /// </p>
        pub fn enable_global_write_forwarding(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_global_write_forwarding(inp);
            self
        }
        /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an
        /// Aurora global database (<a>GlobalCluster</a>). By default, write operations are not allowed on Aurora DB clusters that
        /// are secondary clusters in an Aurora global database.</p>
        /// <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter
        /// enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to
        /// this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the
        /// primary is demoted by the <a>FailoverGlobalCluster</a> API operation, but it does nothing until then.
        /// </p>
        pub fn set_enable_global_write_forwarding(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_global_write_forwarding(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterEndpoint`.
    ///
    /// <p>Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.</p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_endpoint_input::Builder,
    }
    impl<C, M, R> CreateDBClusterEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterEndpointInputOperationOutputAlias,
                crate::output::CreateDbClusterEndpointOutput,
                crate::error::CreateDBClusterEndpointError,
                crate::input::CreateDbClusterEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(inp);
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(inp);
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// Appends an item to `StaticMembers`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_members(inp);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_static_members(input);
            self
        }
        /// Appends an item to `ExcludedMembers`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_members(inp);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_members(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterParameterGroup`.
    ///
    /// <p>Creates a new DB cluster parameter group.</p>
    /// <p>Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.</p>
    /// <p>
    /// A DB cluster parameter group is initially created with the default parameters for the
    /// database engine used by instances in the DB cluster. To provide custom values for any of the
    /// parameters, you must modify the group after creating it using
    /// <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group, you need to
    /// associate it with your DB cluster using <code>ModifyDBCluster</code>. When you associate
    /// a new DB cluster parameter group with a running DB cluster, you need to reboot the DB
    /// instances in the DB cluster without failover for the new DB cluster parameter group and
    /// associated settings to take effect.
    /// </p>
    /// <important>
    /// <p>After you create a DB cluster parameter group, you should wait at least 5 minutes
    /// before creating your first DB cluster
    /// that uses that DB cluster parameter group as the default parameter
    /// group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter
    /// group is used as the default for a new DB cluster. This is especially important for parameters
    /// that are critical when creating the default database for a DB cluster, such as the character set
    /// for the default database defined by the <code>character_set_database</code> parameter. You can use the
    /// <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the
    /// <code>DescribeDBClusterParameters</code> action to verify
    /// that your DB cluster parameter group has been created or modified.</p>
    /// </important>
    ///
    /// <p>For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::CreateDbClusterParameterGroupOutput,
                crate::error::CreateDBClusterParameterGroupError,
                crate::input::CreateDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster
        /// parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        /// <p>
        /// <b>Aurora MySQL</b>
        /// </p>
        /// <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code>
        /// </p>
        /// <p>
        /// <b>Aurora PostgreSQL</b>
        /// </p>
        /// <p>Example: <code>aurora-postgresql9.6</code>
        /// </p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine></code>
        /// </p>
        /// <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code>
        /// </p>
        /// <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster
        /// parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        /// <p>
        /// <b>Aurora MySQL</b>
        /// </p>
        /// <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code>
        /// </p>
        /// <p>
        /// <b>Aurora PostgreSQL</b>
        /// </p>
        /// <p>Example: <code>aurora-postgresql9.6</code>
        /// </p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine></code>
        /// </p>
        /// <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code>
        /// </p>
        /// <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB cluster parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to assign to the DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterSnapshot`.
    ///
    /// <p>Creates a snapshot of a DB cluster. For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CreateDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbClusterSnapshotInputOperationOutputAlias,
                crate::output::CreateDbClusterSnapshotOutput,
                crate::error::CreateDBClusterSnapshotError,
                crate::input::CreateDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code>
        /// </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code>
        /// </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBInstance`.
    ///
    /// <p>Creates a new DB instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_instance_input::Builder,
    }
    impl<C, M, R> CreateDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbInstanceInputOperationOutputAlias,
                crate::output::CreateDbInstanceOutput,
                crate::error::CreateDBInstanceError,
                crate::input::CreateDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, a database named <code>postgres</code>
        /// is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 63 letters, numbers, or underscores.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>The Oracle System ID (SID) of the created DB instance.
        /// If you specify <code>null</code>, the default value <code>ORCL</code> is used.
        /// You can't specify the string NULL, or any other reserved word, for <code>DBName</code>.
        /// </p>
        /// <p>Default: <code>ORCL</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be longer than 8 characters</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>The Oracle System ID (SID) of the created RDS Custom DB instance.
        /// If you don't specify a value, the default value is <code>ORCL</code>.
        /// </p>
        /// <p>Default: <code>ORCL</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>It must contain 1 to 8 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>It must contain a letter.</p>
        /// </li>
        /// <li>
        /// <p>It can't be a word reserved by the database engine.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>SQL Server</b>
        /// </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p>
        /// <b>Amazon Aurora MySQL</b>
        /// </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is
        /// created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created
        /// in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>It must contain 1 to 64 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>It can't be a word reserved by the database engine.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>Amazon Aurora PostgreSQL</b>
        /// </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
        /// created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster,
        /// a database named <code>postgres</code> is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>It must contain 1 to 63 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>It must begin with a letter or an underscore.
        /// Subsequent characters can be letters, underscores, or digits
        /// (0 to 9).</p>
        /// </li>
        /// <li>
        /// <p>It can't be a word reserved by the
        /// database engine.</p>
        /// </li>
        /// </ul>
        pub fn db_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(inp);
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, a database named <code>postgres</code>
        /// is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 63 letters, numbers, or underscores.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>The Oracle System ID (SID) of the created DB instance.
        /// If you specify <code>null</code>, the default value <code>ORCL</code> is used.
        /// You can't specify the string NULL, or any other reserved word, for <code>DBName</code>.
        /// </p>
        /// <p>Default: <code>ORCL</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be longer than 8 characters</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>The Oracle System ID (SID) of the created RDS Custom DB instance.
        /// If you don't specify a value, the default value is <code>ORCL</code>.
        /// </p>
        /// <p>Default: <code>ORCL</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>It must contain 1 to 8 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>It must contain a letter.</p>
        /// </li>
        /// <li>
        /// <p>It can't be a word reserved by the database engine.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>SQL Server</b>
        /// </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p>
        /// <b>Amazon Aurora MySQL</b>
        /// </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is
        /// created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created
        /// in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>It must contain 1 to 64 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>It can't be a word reserved by the database engine.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>Amazon Aurora PostgreSQL</b>
        /// </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is
        /// created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster,
        /// a database named <code>postgres</code> is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>It must contain 1 to 63 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>It must begin with a letter or an underscore.
        /// Subsequent characters can be letters, underscores, or digits
        /// (0 to 9).</p>
        /// </li>
        /// <li>
        /// <p>It can't be a word reserved by the
        /// database engine.</p>
        /// </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code>
        /// </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your
        /// database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p>
        ///
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 40 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 40 to 65536.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>SQL Server</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2):</p>
        /// <ul>
        /// <li>
        /// <p>Enterprise and Standard editions: Must be an integer from 200 to 16384.</p>
        /// </li>
        /// <li>
        /// <p>Web and Express editions: Must be an integer from 20 to 16384.</p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1):</p>
        /// <ul>
        /// <li>
        /// <p>Enterprise and Standard editions: Must be an integer from 200 to 16384.</p>
        /// </li>
        /// <li>
        /// <p>Web and Express editions: Must be an integer from 100 to 16384.</p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard):</p>
        /// <ul>
        /// <li>
        /// <p>Enterprise and Standard editions: Must be an integer from 200 to 1024.</p>
        /// </li>
        /// <li>
        /// <p>Web and Express editions: Must be an integer from 20 to 1024.</p>
        /// </li>
        /// </ul>            
        /// </li>
        /// </ul>
        pub fn allocated_storage(mut self, inp: i32) -> Self {
            self.inner = self.inner.allocated_storage(inp);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your
        /// database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p>
        ///
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 40 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 40 to 65536.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p>
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>SQL Server</b>
        /// </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>General Purpose (SSD) storage (gp2):</p>
        /// <ul>
        /// <li>
        /// <p>Enterprise and Standard editions: Must be an integer from 200 to 16384.</p>
        /// </li>
        /// <li>
        /// <p>Web and Express editions: Must be an integer from 20 to 16384.</p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>Provisioned IOPS storage (io1):</p>
        /// <ul>
        /// <li>
        /// <p>Enterprise and Standard editions: Must be an integer from 200 to 16384.</p>
        /// </li>
        /// <li>
        /// <p>Web and Express editions: Must be an integer from 100 to 16384.</p>
        /// </li>
        /// </ul>            
        /// </li>
        /// <li>
        /// <p>Magnetic storage (standard):</p>
        /// <ul>
        /// <li>
        /// <p>Enterprise and Standard editions: Must be an integer from 200 to 1024.</p>
        /// </li>
        /// <li>
        /// <p>Web and Express editions: Must be an integer from 20 to 1024.</p>
        /// </li>
        /// </ul>            
        /// </li>
        /// </ul>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>.
        /// Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
        /// For the full list of DB instance classes,
        /// and availability for your engine, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example, <code>db.m4.large</code>.
        /// Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
        /// For the full list of DB instance classes,
        /// and availability for your engine, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The name of the database engine to be used for this instance.
        /// </p>
        ///
        /// <p>Not every database engine is available for every Amazon Web Services Region.
        /// </p>
        ///
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom-oracle-ee (for RDS Custom instances)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this instance.
        /// </p>
        ///
        /// <p>Not every database engine is available for every Amazon Web Services Region.
        /// </p>
        ///
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>custom-oracle-ee (for RDS Custom instances)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The name for the master user.</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The name for the master user is managed by the DB cluster.
        /// </p>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for MariaDB.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for SQL Server.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 128 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for MySQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for Oracle.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 30 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        pub fn master_username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(inp);
            self
        }
        /// <p>The name for the master user.</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The name for the master user is managed by the DB cluster.
        /// </p>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for MariaDB.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for SQL Server.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 128 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>The first character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for MySQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for Oracle.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 30 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The password for the master user is managed by the DB
        /// cluster.</p>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 30 characters.</p>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The password for the master user is managed by the DB
        /// cluster.</p>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 30 characters.</p>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// Appends an item to `DBSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn db_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_groups(inp);
            self
        }
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by
        /// the DB cluster.</p>
        ///
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by
        /// the DB cluster.</p>
        ///
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>
        /// The Availability Zone (AZ) where the database will be created. For information on
        /// Amazon Web Services Regions and Availability Zones, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions
        /// and Availability Zones</a>.
        /// </p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>
        /// Example: <code>us-east-1d</code>
        /// </p>
        /// <p>
        /// Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment.
        /// The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.
        /// </p>
        /// <note>
        /// <p>If you're creating a DB instance in an RDS on VMware environment,
        /// specify the identifier of the custom Availability Zone to create the DB instance
        /// in.</p>
        /// <p>For more information about RDS on VMware, see the
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
        /// RDS on VMware User Guide.</a>
        /// </p>
        /// </note>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>
        /// The Availability Zone (AZ) where the database will be created. For information on
        /// Amazon Web Services Regions and Availability Zones, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions
        /// and Availability Zones</a>.
        /// </p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>
        /// Example: <code>us-east-1d</code>
        /// </p>
        /// <p>
        /// Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment.
        /// The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.
        /// </p>
        /// <note>
        /// <p>If you're creating a DB instance in an RDS on VMware environment,
        /// specify the identifier of the custom Availability Zone to create the DB instance
        /// in.</p>
        /// <p>For more information about RDS on VMware, see the
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
        /// RDS on VMware User Guide.</a>
        /// </p>
        /// </note>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>If there is no DB subnet group, then it is a non-VPC DB instance.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The time range each week during which system maintenance can occur,
        /// in Universal Coordinated Time (UTC).
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>.
        /// </p>
        /// <p>
        /// Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
        /// week.
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The time range each week during which system maintenance can occur,
        /// in Universal Coordinated Time (UTC).
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>.
        /// </p>
        /// <p>
        /// Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
        /// week.
        /// </p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then
        /// the default DB parameter group for the specified DB engine and version is used.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then
        /// the default DB parameter group for the specified DB engine and version is used.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables
        /// backups. Setting this parameter to 0 disables automated backups.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 0 to 35</p>
        /// </li>
        /// <li>
        /// <p>Can't be set to 0 if the DB instance is a source to read replicas</p>
        /// </li>
        /// <li>
        /// <p>Can't be set to 0 or 35 for an RDS Custom DB instance</p>
        /// </li>
        /// </ul>
        pub fn backup_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.backup_retention_period(inp);
            self
        }
        /// <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables
        /// backups. Setting this parameter to 0 disables automated backups.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be a value from 0 to 35</p>
        /// </li>
        /// <li>
        /// <p>Can't be set to 0 if the DB instance is a source to read replicas</p>
        /// </li>
        /// <li>
        /// <p>Can't be set to 0 or 35 for an RDS Custom DB instance</p>
        /// </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>
        /// The daily time range during which automated backups are created
        /// if automated backups are enabled,
        /// using the <code>BackupRetentionPeriod</code> parameter.
        /// The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by
        /// the DB cluster.</p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>
        /// The daily time range during which automated backups are created
        /// if automated backups are enabled,
        /// using the <code>BackupRetentionPeriod</code> parameter.
        /// The default is a 30-minute window selected at random from an
        /// 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by
        /// the DB cluster.</p>
        ///
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must be in Universal Coordinated Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>
        /// Default: <code>3306</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>
        /// Default: <code>3306</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>
        /// Default: <code>5432</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>
        /// Default: <code>1521</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>
        /// <b>SQL Server</b>
        /// </p>
        /// <p>
        /// Default: <code>1433</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>,
        /// <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and
        /// <code>49152-49156</code>.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>
        /// Default: <code>3306</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>
        /// Default: <code>3306</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>
        /// Default: <code>3306</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>
        /// Default: <code>5432</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>
        /// Default: <code>1521</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>
        /// <b>SQL Server</b>
        /// </p>
        /// <p>
        /// Default: <code>1433</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>,
        /// <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and
        /// <code>49152-49156</code>.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>
        /// Default: <code>3306</code>
        /// </p>
        /// <p> Valid values: <code>1150-65535</code>
        /// </p>
        /// <p>Type: Integer</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set
        /// the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set
        /// the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, use the  <code>DescribeDBEngineVersions</code> action.</p>
        /// <p>The following are the database engines and links to information about the major and minor versions that are available with
        /// Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The version number of the database engine to be used by the DB
        /// instance is managed by the DB cluster.</p>
        ///
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom. The CEV
        /// name has the following format: <code>19.<i>customized_string</i>
        /// </code>. An example identifier is
        /// <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create">
        /// Creating an RDS Custom DB instance</a> in the <i>Amazon RDS User Guide.</i>.</p>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>     
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, use the  <code>DescribeDBEngineVersions</code> action.</p>
        /// <p>The following are the database engines and links to information about the major and minor versions that are available with
        /// Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p>
        ///
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The version number of the database engine to be used by the DB
        /// instance is managed by the DB cluster.</p>
        ///
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom. The CEV
        /// name has the following format: <code>19.<i>customized_string</i>
        /// </code>. An example identifier is
        /// <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create">
        /// Creating an RDS Custom DB instance</a> in the <i>Amazon RDS User Guide.</i>.</p>
        ///
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        ///
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>     
        ///
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        ///
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the
        /// <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
        /// By default, minor engine upgrades are applied automatically.</p>
        /// <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to
        /// <code>false</code>.</p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
        /// By default, minor engine upgrades are applied automatically.</p>
        /// <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to
        /// <code>false</code>.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p>
        /// Valid values:  <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code>
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn license_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(inp);
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p>
        /// Valid values:  <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code>
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.
        /// For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        /// <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of the storage amount for the DB instance.
        /// For SQL Server DB instances, must be a multiple between 1 and 50 of the storage amount for the DB instance.
        /// </p>
        pub fn iops(mut self, inp: i32) -> Self {
            self.inner = self.inner.iops(inp);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.
        /// For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        /// <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of the storage amount for the DB instance.
        /// For SQL Server DB instances, must be a multiple between 1 and 50 of the storage amount for the DB instance.
        /// </p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_iops(input);
            self
        }
        /// <p>A value that indicates that the DB instance should be associated with the specified option group.</p>
        /// <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed
        /// from an option group. Also, that option group can't be removed from a DB instance after it is
        /// associated with a DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>A value that indicates that the DB instance should be associated with the specified option group.</p>
        /// <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed
        /// from an option group. Also, that option group can't be removed from a DB instance after it is
        /// associated with a DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>For supported engines, this value indicates that the DB instance should be associated with the
        /// specified <code>CharacterSet</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom. However, if you need to change the character set,
        /// you can change it on the database itself.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The character set is managed by
        /// the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        pub fn character_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.character_set_name(inp);
            self
        }
        /// <p>For supported engines, this value indicates that the DB instance should be associated with the
        /// specified <code>CharacterSet</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom. However, if you need to change the character set,
        /// you can change it on the database itself.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The character set is managed by
        /// the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_character_set_name(input);
            self
        }
        /// <p>The name of the NCHAR character set for the Oracle DB instance.</p>
        /// <p>This parameter doesn't apply to RDS Custom.</p>
        pub fn nchar_character_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nchar_character_set_name(inp);
            self
        }
        /// <p>The name of the NCHAR character set for the Oracle DB instance.</p>
        /// <p>This parameter doesn't apply to RDS Custom.</p>
        pub fn set_nchar_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nchar_character_set_name(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC,
        /// and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses,
        /// and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li>
        /// <p>If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB instance is private.</p>
        /// </li>
        /// <li>
        /// <p>If the default VPC in the target region has an Internet gateway attached to it, the DB instance is public.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li>
        /// <p>If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance is private.</p>
        /// </li>
        /// <li>
        /// <p>If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is public.</p>
        /// </li>
        /// </ul>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC,
        /// and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses,
        /// and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li>
        /// <p>If the default VPC in the target region doesn’t have an Internet gateway attached to it, the DB instance is private.</p>
        /// </li>
        /// <li>
        /// <p>If the default VPC in the target region has an Internet gateway attached to it, the DB instance is public.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li>
        /// <p>If the subnets are part of a VPC that doesn’t have an Internet gateway attached to it, the DB instance is private.</p>
        /// </li>
        /// <li>
        /// <p>If the subnets are part of a VPC that has an Internet gateway attached to it, the DB instance is public.</p>
        /// </li>
        /// </ul>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB instance.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to assign to the DB instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>
        /// Valid values: <code>standard | gp2 | io1</code>
        /// </p>
        /// <p>
        /// If you specify <code>io1</code>, you must also include a value for the
        /// <code>Iops</code> parameter.
        /// </p>
        /// <p>
        /// Default: <code>io1</code> if the <code>Iops</code> parameter
        /// is specified, otherwise <code>gp2</code>
        /// </p>
        pub fn storage_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(inp);
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>
        /// Valid values: <code>standard | gp2 | io1</code>
        /// </p>
        /// <p>
        /// If you specify <code>io1</code>, you must also include a value for the
        /// <code>Iops</code> parameter.
        /// </p>
        /// <p>
        /// Default: <code>io1</code> if the <code>Iops</code> parameter
        /// is specified, otherwise <code>gp2</code>
        /// </p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn tde_credential_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_arn(inp);
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_arn(input);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn tde_credential_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tde_credential_password(inp);
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tde_credential_password(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p>
        /// <p>For RDS Custom Oracle instances, either set this parameter to <code>true</code> or leave it unset.
        /// If you set this parameter to <code>false</code>, RDS reports an error.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster.</p>
        pub fn storage_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.storage_encrypted(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p>
        /// <p>For RDS Custom Oracle instances, either set this parameter to <code>true</code> or leave it unset.
        /// If you set this parameter to <code>false</code>, RDS reports an error.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
        /// To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The Amazon Web Services KMS key identifier is managed by
        /// the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>     
        /// <p>If <code>StorageEncrypted</code> is enabled, and you do
        /// not specify a value for the <code>KmsKeyId</code> parameter, then
        /// Amazon RDS uses your default KMS key. There is a  
        /// default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
        /// default KMS key for each Amazon Web Services Region.</p>
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>A KMS key is required for RDS Custom Oracle instances. For most RDS engines, if you leave this parameter empty
        /// while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However, RDS Custom for Oracle
        /// doesn't use the default key when this parameter is empty. You must explicitly specify a key.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
        /// To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. The Amazon Web Services KMS key identifier is managed by
        /// the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>     
        /// <p>If <code>StorageEncrypted</code> is enabled, and you do
        /// not specify a value for the <code>KmsKeyId</code> parameter, then
        /// Amazon RDS uses your default KMS key. There is a  
        /// default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
        /// default KMS key for each Amazon Web Services Region.</p>
        /// <p>
        /// <b>Amazon RDS Custom</b>
        /// </p>
        /// <p>A KMS key is required for RDS Custom Oracle instances. For most RDS engines, if you leave this parameter empty
        /// while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However, RDS Custom for Oracle
        /// doesn't use the default key when this parameter is empty. You must explicitly specify a key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
        /// Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
        /// Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
        /// Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
        /// Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this
        /// value for an Aurora DB instance has no effect on the DB cluster setting.</p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this
        /// value for an Aurora DB instance has no effect on the DB cluster setting.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for
        /// the DB instance. To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code>
        /// to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn monitoring_interval(mut self, inp: i32) -> Self {
            self.inner = self.inner.monitoring_interval(inp);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for
        /// the DB instance. To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code>
        /// to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_monitoring_interval(input);
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
        /// example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn monitoring_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_role_arn(inp);
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
        /// example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_role_arn(input);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain_iam_role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(inp);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance
        /// after a failure of the existing primary instance. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance">
        /// Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, inp: i32) -> Self {
            self.inner = self.inner.promotion_tier(inp);
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance
        /// after a failure of the existing primary instance. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance">
        /// Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_promotion_tier(input);
            self
        }
        /// <p>The time zone of the DB instance.
        /// The time zone parameter is currently supported only by
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a>.
        /// </p>
        pub fn timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timezone(inp);
            self
        }
        /// <p>The time zone of the DB instance.
        /// The time zone parameter is currently supported only by
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a>.
        /// </p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_timezone(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
        /// Management (IAM) accounts to database accounts. By default, mapping is disabled.</p>      
        /// <p>This setting doesn't apply to RDS Custom or Amazon Aurora. In Aurora, mapping Amazon Web Services IAM accounts
        /// to database accounts is managed by the DB cluster.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
        /// IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
        /// Management (IAM) accounts to database accounts. By default, mapping is disabled.</p>      
        /// <p>This setting doesn't apply to RDS Custom or Amazon Aurora. In Aurora, mapping Amazon Web Services IAM accounts
        /// to database accounts is managed by the DB cluster.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
        /// IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the DB instance. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon Relational Database Service
        /// User Guide</i>.
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_performance_insights(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_performance_insights(inp);
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the DB instance. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon Relational Database Service
        /// User Guide</i>.
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_insights(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS
        /// uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
        /// Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.performance_insights_kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS
        /// uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
        /// Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_kms_key_id(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.performance_insights_retention_period(inp);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_retention_period(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values
        /// in the list depend on the DB engine. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Relational Database
        /// Service User Guide</i>.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. CloudWatch Logs exports are managed by the DB cluster.
        /// </p>
        /// <p>
        /// <b>RDS Custom</b>
        /// </p>
        /// <p>Not applicable.
        /// </p>
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
        /// </p>
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        /// <p>Possible values are <code>agent</code> and <code>error</code>.
        /// </p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
        /// </p>
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and
        /// <code>oemagent</code>.
        /// </p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.
        /// </p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values
        /// in the list depend on the DB engine. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Relational Database
        /// Service User Guide</i>.</p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. CloudWatch Logs exports are managed by the DB cluster.
        /// </p>
        /// <p>
        /// <b>RDS Custom</b>
        /// </p>
        /// <p>Not applicable.
        /// </p>
        /// <p>
        /// <b>MariaDB</b>
        /// </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
        /// </p>
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        /// <p>Possible values are <code>agent</code> and <code>error</code>.
        /// </p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.
        /// </p>
        /// <p>
        /// <b>Oracle</b>
        /// </p>
        /// <p>Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and
        /// <code>oemagent</code>.
        /// </p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.
        /// </p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// Appends an item to `ProcessorFeatures`.
        ///
        /// To override the contents of this collection use [`set_processor_features`](Self::set_processor_features).
        ///
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn processor_features(
            mut self,
            inp: impl Into<crate::model::ProcessorFeature>,
        ) -> Self {
            self.inner = self.inner.processor_features(inp);
            self
        }
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        ) -> Self {
            self.inner = self.inner.set_processor_features(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
        /// Deleting a DB Instance</a>.
        /// </p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. You can enable or disable deletion protection for the DB cluster.
        /// For more information, see <code>CreateDBCluster</code>. DB instances in a DB
        /// cluster can be deleted even when deletion protection is enabled for the DB cluster.
        /// </p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
        /// Deleting a DB Instance</a>.
        /// </p>
        /// <p>
        /// <b>Amazon Aurora</b>
        /// </p>
        /// <p>Not applicable. You can enable or disable deletion protection for the DB cluster.
        /// For more information, see <code>CreateDBCluster</code>. DB instances in a DB
        /// cluster can be deleted even when deletion protection is enabled for the DB cluster.
        /// </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
        /// Managing capacity automatically with Amazon RDS storage autoscaling</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn max_allocated_storage(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_allocated_storage(inp);
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
        /// Managing capacity automatically with Amazon RDS storage autoscaling</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_max_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_allocated_storage(input);
            self
        }
        /// <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS
        /// on Outposts DB instance.</p>
        /// <p>A <i>CoIP</i> provides local or external connectivity to resources in
        /// your Outpost subnets through your on-premises network. For some use cases, a CoIP can
        /// provide lower latency for connections to the DB instance from outside of its virtual
        /// private cloud (VPC) on your local network.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a>
        /// in the <i>Amazon Web Services Outposts User Guide</i>.</p>
        pub fn enable_customer_owned_ip(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_customer_owned_ip(inp);
            self
        }
        /// <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS
        /// on Outposts DB instance.</p>
        /// <p>A <i>CoIP</i> provides local or external connectivity to resources in
        /// your Outpost subnets through your on-premises network. For some use cases, a CoIP can
        /// provide lower latency for connections to the DB instance from outside of its virtual
        /// private cloud (VPC) on your local network.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a>
        /// in the <i>Amazon Web Services Outposts User Guide</i>.</p>
        pub fn set_enable_customer_owned_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_customer_owned_ip(input);
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an
        /// RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>The profile must exist in your account.</p>
        /// </li>
        /// <li>
        /// <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p>
        /// </li>
        /// <li>
        /// <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
        /// Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service
        /// User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn custom_iam_instance_profile(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_iam_instance_profile(inp);
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an
        /// RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>The profile must exist in your account.</p>
        /// </li>
        /// <li>
        /// <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p>
        /// </li>
        /// <li>
        /// <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
        /// Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service
        /// User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn set_custom_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_iam_instance_profile(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBInstanceReadReplica`.
    ///
    /// <p>Creates a new DB instance that acts as a read replica for an existing source DB
    /// instance. You can create a read replica for a DB instance running MySQL, MariaDB,
    /// Oracle, PostgreSQL, or SQL Server. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with Read
    /// Replicas</a> in the <i>Amazon RDS User Guide</i>. </p>
    ///
    /// <p>Amazon Aurora doesn't support this action. Call the <code>CreateDBInstance</code>
    /// action to create a DB instance for an Aurora DB cluster.</p>
    ///
    /// <p>All read replica DB instances are created with backups disabled. All other DB
    /// instance attributes (including DB security groups and DB parameter groups) are inherited
    /// from the source DB instance, except as specified.</p>
    ///
    /// <important>
    /// <p>Your source DB instance must have backup retention enabled.
    /// </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBInstanceReadReplica<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_instance_read_replica_input::Builder,
    }
    impl<C, M, R> CreateDBInstanceReadReplica<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBInstanceReadReplica`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbInstanceReadReplicaOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceReadReplicaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbInstanceReadReplicaInputOperationOutputAlias,
                crate::output::CreateDbInstanceReadReplicaOutput,
                crate::error::CreateDBInstanceReadReplicaError,
                crate::input::CreateDbInstanceReadReplicaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier of the read replica. This identifier is the unique key
        /// that identifies a DB instance. This parameter is stored as a lowercase string.</p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The DB instance identifier of the read replica. This identifier is the unique key
        /// that identifies a DB instance. This parameter is stored as a lowercase string.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The identifier of the DB instance that will act as the source for the read replica.
        /// Each DB instance can have up to five read replicas.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier of an existing MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server DB
        /// instance.</p>
        /// </li>
        /// <li>
        /// <p>Can specify a DB instance that is a MySQL read replica only if the source is running MySQL
        /// 5.6 or later.</p>
        /// </li>
        /// <li>
        /// <p>For the limitations of Oracle read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Read Replica Limitations with Oracle</a> in the
        /// <i>Amazon RDS User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>For the limitations of SQL Server read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.Limitations.html">Read Replica
        /// Limitations with Microsoft SQL Server</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>Can specify a PostgreSQL DB instance only if the source is running PostgreSQL 9.3.5 or
        /// later (9.4.7 and higher for cross-region replication).</p>
        /// </li>
        /// <li>
        /// <p>The specified DB instance must have automatic backups enabled, that is, its backup
        /// retention period must be greater than 0.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB
        /// instance identifier.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">Constructing an ARN for Amazon RDS</a>
        /// in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL Server or RDS Custom, which don't support
        /// cross-Region replicas.</p>
        /// </li>
        /// </ul>
        pub fn source_db_instance_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_instance_identifier(inp);
            self
        }
        /// <p>The identifier of the DB instance that will act as the source for the read replica.
        /// Each DB instance can have up to five read replicas.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier of an existing MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server DB
        /// instance.</p>
        /// </li>
        /// <li>
        /// <p>Can specify a DB instance that is a MySQL read replica only if the source is running MySQL
        /// 5.6 or later.</p>
        /// </li>
        /// <li>
        /// <p>For the limitations of Oracle read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Read Replica Limitations with Oracle</a> in the
        /// <i>Amazon RDS User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>For the limitations of SQL Server read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.Limitations.html">Read Replica
        /// Limitations with Microsoft SQL Server</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>Can specify a PostgreSQL DB instance only if the source is running PostgreSQL 9.3.5 or
        /// later (9.4.7 and higher for cross-region replication).</p>
        /// </li>
        /// <li>
        /// <p>The specified DB instance must have automatic backups enabled, that is, its backup
        /// retention period must be greater than 0.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB
        /// instance identifier.</p>
        /// </li>
        /// <li>
        /// <p>If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">Constructing an ARN for Amazon RDS</a>
        /// in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL Server or RDS Custom, which don't support
        /// cross-Region replicas.</p>
        /// </li>
        /// </ul>
        pub fn set_source_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_instance_identifier(input);
            self
        }
        /// <p>The compute and memory capacity of the read replica, for example,
        /// <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services
        /// Regions, or for all database engines. For the full list of DB instance classes, and
        /// availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
        /// Class</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        /// <p>Default: Inherits from the source DB instance.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The compute and memory capacity of the read replica, for example,
        /// <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services
        /// Regions, or for all database engines. For the full list of DB instance classes, and
        /// availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance
        /// Class</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        /// <p>Default: Inherits from the source DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The Availability Zone (AZ) where the read replica will be created.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>
        /// Example: <code>us-east-1d</code>
        /// </p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone (AZ) where the read replica will be created.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>
        /// Example: <code>us-east-1d</code>
        /// </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The port number that the DB instance uses for connections.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        /// <p>Valid Values: <code>1150-65535</code>
        /// </p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number that the DB instance uses for connections.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        /// <p>Valid Values: <code>1150-65535</code>
        /// </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>A value that indicates whether the read replica is in a Multi-AZ deployment. </p>
        ///
        /// <p>You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of
        /// your replica in another Availability Zone for failover support for the replica. Creating
        /// your read replica as a Multi-AZ DB instance is independent of whether the source
        /// database is a Multi-AZ DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p>A value that indicates whether the read replica is in a Multi-AZ deployment. </p>
        ///
        /// <p>You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of
        /// your replica in another Availability Zone for failover support for the replica. Creating
        /// your read replica as a Multi-AZ DB instance is independent of whether the source
        /// database is a Multi-AZ DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the
        /// read replica during the maintenance window.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the
        /// read replica during the maintenance window.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
        pub fn iops(mut self, inp: i32) -> Self {
            self.inner = self.inner.iops(inp);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_iops(input);
            self
        }
        /// <p>The option group the DB instance is associated with. If omitted, the option group associated with the source instance is used.</p>
        /// <note>
        /// <p>For SQL Server, you must use the option group associated with the source
        /// instance.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>The option group the DB instance is associated with. If omitted, the option group associated with the source instance is used.</p>
        /// <note>
        /// <p>For SQL Server, you must use the option group associated with the source
        /// instance.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance.</p>
        /// <p>If you do not specify a value for <code>DBParameterGroupName</code>, then Amazon RDS
        /// uses the <code>DBParameterGroup</code> of source DB instance for a same region read
        /// replica, or the default <code>DBParameterGroup</code> for the specified DB engine for a
        /// cross region read replica.</p>
        /// <p>Specifying a parameter group for this operation is only supported for Oracle DB instances. It
        /// isn't supported for RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance.</p>
        /// <p>If you do not specify a value for <code>DBParameterGroupName</code>, then Amazon RDS
        /// uses the <code>DBParameterGroup</code> of source DB instance for a same region read
        /// replica, or the default <code>DBParameterGroup</code> for the specified DB engine for a
        /// cross region read replica.</p>
        /// <p>Specifying a parameter group for this operation is only supported for Oracle DB instances. It
        /// isn't supported for RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC,
        /// and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses,
        /// and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  
        /// <p>For more information, see <a>CreateDBInstance</a>.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC,
        /// and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses,
        /// and that public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  
        /// <p>For more information, see <a>CreateDBInstance</a>.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies a DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can only be specified if the source DB instance identifier specifies a DB instance in another Amazon Web Services Region.</p>
        /// </li>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// </li>
        /// <li>
        /// <p>The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.</p>
        /// </li>
        /// <li>
        /// <p>All read replicas in one Amazon Web Services Region that are created from the same source DB
        /// instance must either:></p>
        /// <ul>
        /// <li>
        /// <p>Specify DB subnet groups from the same VPC. All these read replicas are created in the same
        /// VPC.</p>
        /// </li>
        /// <li>
        /// <p>Not specify a DB subnet group. All these read replicas are created outside of any
        /// VPC.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>Specifies a DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can only be specified if the source DB instance identifier specifies a DB instance in another Amazon Web Services Region.</p>
        /// </li>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBSubnetGroup.</p>
        /// </li>
        /// <li>
        /// <p>The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.</p>
        /// </li>
        /// <li>
        /// <p>All read replicas in one Amazon Web Services Region that are created from the same source DB
        /// instance must either:></p>
        /// <ul>
        /// <li>
        /// <p>Specify DB subnet groups from the same VPC. All these read replicas are created in the same
        /// VPC.</p>
        /// </li>
        /// <li>
        /// <p>Not specify a DB subnet group. All these read replicas are created outside of any
        /// VPC.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p> A list of Amazon EC2 VPC security groups to associate with the read replica. </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>
        /// Default: The default EC2 VPC security group for the DB subnet group's VPC.
        /// </p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p> A list of Amazon EC2 VPC security groups to associate with the read replica. </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>
        /// Default: The default EC2 VPC security group for the DB subnet group's VPC.
        /// </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>Specifies the storage type to be associated with the read replica.</p>
        /// <p>
        /// Valid values: <code>standard | gp2 | io1</code>
        /// </p>
        /// <p>
        /// If you specify <code>io1</code>, you must also include a value for the
        /// <code>Iops</code> parameter.
        /// </p>
        /// <p>
        /// Default: <code>io1</code> if the <code>Iops</code> parameter
        /// is specified, otherwise <code>gp2</code>
        /// </p>
        pub fn storage_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(inp);
            self
        }
        /// <p>Specifies the storage type to be associated with the read replica.</p>
        /// <p>
        /// Valid values: <code>standard | gp2 | io1</code>
        /// </p>
        /// <p>
        /// If you specify <code>io1</code>, you must also include a value for the
        /// <code>Iops</code> parameter.
        /// </p>
        /// <p>
        /// Default: <code>io1</code> if the <code>Iops</code> parameter
        /// is specified, otherwise <code>gp2</code>
        /// </p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the read replica to snapshots of
        /// the read replica. By default, tags are not copied.</p>
        pub fn copy_tags_to_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(inp);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the read replica to snapshots of
        /// the read replica. By default, tags are not copied.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are
        /// collected for the read replica. To disable collecting Enhanced Monitoring metrics,
        /// specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code>
        /// to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn monitoring_interval(mut self, inp: i32) -> Self {
            self.inner = self.inner.monitoring_interval(inp);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are
        /// collected for the read replica. To disable collecting Enhanced Monitoring metrics,
        /// specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code>
        /// to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
        /// </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_monitoring_interval(input);
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
        /// example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
        /// go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
        /// create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must
        /// supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn monitoring_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_role_arn(inp);
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For
        /// example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role,
        /// go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To
        /// create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must
        /// supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_role_arn(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted read replica.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you create an encrypted read replica in the same Amazon Web Services Region as the source DB
        /// instance, then do not specify a value for this parameter. A read replica in the same Amazon Web Services Region
        /// is always encrypted with the same KMS key as the source DB instance.</p>       
        /// <p>If you create an encrypted read replica in a different Amazon Web Services Region, then you must
        /// specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to
        /// the Amazon Web Services Region that they are created in, and you can't use KMS keys from one
        /// Amazon Web Services Region in another Amazon Web Services Region.</p>       
        /// <p>You can't create an encrypted read replica from an unencrypted DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary
        /// replica.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted read replica.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you create an encrypted read replica in the same Amazon Web Services Region as the source DB
        /// instance, then do not specify a value for this parameter. A read replica in the same Amazon Web Services Region
        /// is always encrypted with the same KMS key as the source DB instance.</p>       
        /// <p>If you create an encrypted read replica in a different Amazon Web Services Region, then you must
        /// specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to
        /// the Amazon Web Services Region that they are created in, and you can't use KMS keys from one
        /// Amazon Web Services Region in another Amazon Web Services Region.</p>       
        /// <p>You can't create an encrypted read replica from an unencrypted DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary
        /// replica.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CreateDBInstanceReadReplica</code> API action
        /// in the source Amazon Web Services Region that contains the source DB instance.
        /// </p>
        ///
        /// <p>You must specify this parameter when you create an encrypted read replica from
        /// another Amazon Web Services Region by using the Amazon RDS API. Don't specify
        /// <code>PreSignedUrl</code> when you are creating an encrypted read replica in the
        /// same Amazon Web Services Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API action
        /// that can be executed in the source Amazon Web Services Region that contains the encrypted source DB instance.
        /// The presigned URL request must contain the following parameter values:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read
        /// replica is created in. This Amazon Web Services Region is the same one where the
        /// <code>CreateDBInstanceReadReplica</code> action is called that contains this presigned URL.</p>
        ///
        /// <p>For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region,
        /// from a source DB instance in the us-east-2 Amazon Web Services Region,
        /// then you call the <code>CreateDBInstanceReadReplica</code> action in
        /// the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the
        /// <code>CreateDBInstanceReadReplica</code> action in the us-west-2 Amazon Web Services Region. For this
        /// example, the <code>DestinationRegion</code> in the presigned URL must be set to
        /// the us-east-1 Amazon Web Services Region.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the key to use to
        /// encrypt the read replica in the destination Amazon Web Services Region. This is the same
        /// identifier for both the <code>CreateDBInstanceReadReplica</code> action that is
        /// called in the destination Amazon Web Services Region, and the action contained in the presigned
        /// URL. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for
        /// the encrypted DB instance to be replicated. This identifier must be in the
        /// Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you
        /// are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services
        /// Region, then your <code>SourceDBInstanceIdentifier</code> looks like the
        /// following example:
        /// <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>. </p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.
        /// </p>
        ///
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
        /// <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying
        /// <code>SourceRegion</code> autogenerates a presigned URL that is a valid request
        /// for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// <p>
        /// <code>SourceRegion</code> isn't supported for SQL Server, because SQL Server on Amazon RDS
        /// doesn't support cross-region read replicas.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn pre_signed_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(inp);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CreateDBInstanceReadReplica</code> API action
        /// in the source Amazon Web Services Region that contains the source DB instance.
        /// </p>
        ///
        /// <p>You must specify this parameter when you create an encrypted read replica from
        /// another Amazon Web Services Region by using the Amazon RDS API. Don't specify
        /// <code>PreSignedUrl</code> when you are creating an encrypted read replica in the
        /// same Amazon Web Services Region.</p>
        ///
        /// <p>The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API action
        /// that can be executed in the source Amazon Web Services Region that contains the encrypted source DB instance.
        /// The presigned URL request must contain the following parameter values:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read
        /// replica is created in. This Amazon Web Services Region is the same one where the
        /// <code>CreateDBInstanceReadReplica</code> action is called that contains this presigned URL.</p>
        ///
        /// <p>For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region,
        /// from a source DB instance in the us-east-2 Amazon Web Services Region,
        /// then you call the <code>CreateDBInstanceReadReplica</code> action in
        /// the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the
        /// <code>CreateDBInstanceReadReplica</code> action in the us-west-2 Amazon Web Services Region. For this
        /// example, the <code>DestinationRegion</code> in the presigned URL must be set to
        /// the us-east-1 Amazon Web Services Region.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the key to use to
        /// encrypt the read replica in the destination Amazon Web Services Region. This is the same
        /// identifier for both the <code>CreateDBInstanceReadReplica</code> action that is
        /// called in the destination Amazon Web Services Region, and the action contained in the presigned
        /// URL. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for
        /// the encrypted DB instance to be replicated. This identifier must be in the
        /// Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you
        /// are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services
        /// Region, then your <code>SourceDBInstanceIdentifier</code> looks like the
        /// following example:
        /// <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>. </p>
        /// </li>
        /// </ul>
        ///
        /// <p>To learn how to generate a Signature Version 4 signed request, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.
        /// </p>
        ///
        /// <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify
        /// <code>SourceRegion</code> (or <code>--source-region</code> for the CLI)
        /// instead of specifying <code>PreSignedUrl</code> manually. Specifying
        /// <code>SourceRegion</code> autogenerates a presigned URL that is a valid request
        /// for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// <p>
        /// <code>SourceRegion</code> isn't supported for SQL Server, because SQL Server on Amazon RDS
        /// doesn't support cross-region read replicas.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
        /// Management (IAM) accounts to database accounts. By default, mapping is disabled.</p>
        ///
        /// <p>For more information about IAM database authentication, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
        /// IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_iam_database_authentication(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(inp);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
        /// Management (IAM) accounts to database accounts. By default, mapping is disabled.</p>
        ///
        /// <p>For more information about IAM database authentication, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">
        /// IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the read replica.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using
        /// Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_performance_insights(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_performance_insights(inp);
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the read replica.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using
        /// Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.
        /// </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_insights(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS
        /// uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
        /// Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.performance_insights_kms_key_id(inp);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS
        /// uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
        /// Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_kms_key_id(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.performance_insights_retention_period(inp);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_retention_period(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the new DB instance is to export to CloudWatch Logs. The values
        /// in the list depend on the DB engine being used. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing
        /// Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(inp);
            self
        }
        /// <p>The list of logs that the new DB instance is to export to CloudWatch Logs. The values
        /// in the list depend on the DB engine being used. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing
        /// Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// Appends an item to `ProcessorFeatures`.
        ///
        /// To override the contents of this collection use [`set_processor_features`](Self::set_processor_features).
        ///
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn processor_features(
            mut self,
            inp: impl Into<crate::model::ProcessorFeature>,
        ) -> Self {
            self.inner = self.inner.processor_features(inp);
            self
        }
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        ) -> Self {
            self.inner = self.inner.set_processor_features(input);
            self
        }
        /// <p>A value that indicates whether the DB instance class of the DB instance uses its default
        /// processor features.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn use_default_processor_features(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_default_processor_features(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance class of the DB instance uses its default
        /// processor features.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_use_default_processor_features(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_default_processor_features(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
        /// Deleting a DB Instance</a>.
        /// </p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled.
        /// The database can't be deleted when deletion protection is enabled. By default,
        /// deletion protection is disabled. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">
        /// Deleting a DB Instance</a>.
        /// </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
        /// Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
        /// Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL
        /// Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">
        /// Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain_iam_role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(inp);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>The open mode of the replica database: mounted or read-only.</p>
        /// <note>
        /// <p>This parameter is only supported for Oracle DB instances.</p>
        /// </note>
        /// <p>Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for
        /// mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active
        /// Data Guard to transmit information to the mounted replica. Because it doesn't accept
        /// user connections, a mounted replica can't serve a read-only workload.</p>
        /// <p>You can create a combination of mounted and read-only DB replicas for the same primary DB instance.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by default.
        /// After replica creation, you can manage the open mode manually.</p>
        pub fn replica_mode(mut self, inp: crate::model::ReplicaMode) -> Self {
            self.inner = self.inner.replica_mode(inp);
            self
        }
        /// <p>The open mode of the replica database: mounted or read-only.</p>
        /// <note>
        /// <p>This parameter is only supported for Oracle DB instances.</p>
        /// </note>
        /// <p>Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for
        /// mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active
        /// Data Guard to transmit information to the mounted replica. Because it doesn't accept
        /// user connections, a mounted replica can't serve a read-only workload.</p>
        /// <p>You can create a combination of mounted and read-only DB replicas for the same primary DB instance.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by default.
        /// After replica creation, you can manage the open mode manually.</p>
        pub fn set_replica_mode(
            mut self,
            input: std::option::Option<crate::model::ReplicaMode>,
        ) -> Self {
            self.inner = self.inner.set_replica_mode(input);
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
        /// Managing capacity automatically with Amazon RDS storage autoscaling</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        pub fn max_allocated_storage(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_allocated_storage(inp);
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">
        /// Managing capacity automatically with Amazon RDS storage autoscaling</a>
        /// in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_max_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_allocated_storage(input);
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an
        /// RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>The profile must exist in your account.</p>
        /// </li>
        /// <li>
        /// <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p>
        /// </li>
        /// <li>
        /// <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
        /// Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service
        /// User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn custom_iam_instance_profile(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_iam_instance_profile(inp);
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an
        /// RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>The profile must exist in your account.</p>
        /// </li>
        /// <li>
        /// <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p>
        /// </li>
        /// <li>
        /// <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc">
        /// Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service
        /// User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn set_custom_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_iam_instance_profile(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBParameterGroup`.
    ///
    /// <p>Creates a new DB parameter group.</p>
    /// <p>
    /// A DB parameter group is initially created with the default parameters for the
    /// database engine used by the DB instance. To provide custom values for any of the
    /// parameters, you must modify the group after creating it using
    /// <code>ModifyDBParameterGroup</code>. Once you've created a DB parameter group, you need to
    /// associate it with your DB instance using <code>ModifyDBInstance</code>. When you associate
    /// a new DB parameter group with a running DB instance, you need to reboot the DB
    /// instance without failover for the new DB parameter group and associated settings to take effect.
    /// </p>
    /// <p>This command doesn't apply to RDS Custom.</p>
    /// <important>
    /// <p>After you create a DB parameter group, you should wait at least 5 minutes
    /// before creating your first DB instance that uses that DB parameter group as the default parameter
    /// group. This allows Amazon RDS to fully complete the create action before the parameter
    /// group is used as the default for a new DB instance. This is especially important for parameters
    /// that are critical when creating the default database for a DB instance, such as the character set
    /// for the default database defined by the <code>character_set_database</code> parameter. You can use the
    /// <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the
    /// <i>DescribeDBParameters</i> command to verify
    /// that your DB parameter group has been created or modified.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbParameterGroupInputOperationOutputAlias,
                crate::output::CreateDbParameterGroupOutput,
                crate::error::CreateDBParameterGroupError,
                crate::input::CreateDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine></code>
        /// </p>
        /// <p>For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code>
        /// </p>
        /// <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine></code>
        /// </p>
        /// <p>For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code>
        /// </p>
        /// <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB parameter group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to assign to the DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBProxy`.
    ///
    /// <p>Creates a new DB proxy.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_proxy_input::Builder,
    }
    impl<C, M, R> CreateDBProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbProxyInputOperationOutputAlias,
                crate::output::CreateDbProxyOutput,
                crate::error::CreateDBProxyError,
                crate::input::CreateDbProxyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
        /// <p>The kinds of databases that the proxy can connect to.
        /// This value determines which database network protocol the proxy recognizes when it interprets
        /// network traffic to and from the database.
        /// The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
        pub fn engine_family(mut self, inp: crate::model::EngineFamily) -> Self {
            self.inner = self.inner.engine_family(inp);
            self
        }
        /// <p>The kinds of databases that the proxy can connect to.
        /// This value determines which database network protocol the proxy recognizes when it interprets
        /// network traffic to and from the database.
        /// The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
        pub fn set_engine_family(
            mut self,
            input: std::option::Option<crate::model::EngineFamily>,
        ) -> Self {
            self.inner = self.inner.set_engine_family(input);
            self
        }
        /// Appends an item to `Auth`.
        ///
        /// To override the contents of this collection use [`set_auth`](Self::set_auth).
        ///
        /// <p>The authorization mechanism that the proxy uses.</p>
        pub fn auth(mut self, inp: impl Into<crate::model::UserAuthConfig>) -> Self {
            self.inner = self.inner.auth(inp);
            self
        }
        /// <p>The authorization mechanism that the proxy uses.</p>
        pub fn set_auth(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserAuthConfig>>,
        ) -> Self {
            self.inner = self.inner.set_auth(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `VpcSubnetIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_subnet_ids`](Self::set_vpc_subnet_ids).
        ///
        /// <p>One or more VPC subnet IDs to associate with the new proxy.</p>
        pub fn vpc_subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_subnet_ids(inp);
            self
        }
        /// <p>One or more VPC subnet IDs to associate with the new proxy.</p>
        pub fn set_vpc_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_subnet_ids(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>One or more VPC security group IDs to associate with the new proxy.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>One or more VPC security group IDs to associate with the new proxy.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
        /// By enabling this setting, you can enforce encrypted TLS connections to the proxy.</p>
        pub fn require_tls(mut self, inp: bool) -> Self {
            self.inner = self.inner.require_tls(inp);
            self
        }
        /// <p>A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
        /// By enabling this setting, you can enforce encrypted TLS connections to the proxy.</p>
        pub fn set_require_tls(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_tls(input);
            self
        }
        /// <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this
        /// value higher or lower than the connection timeout limit for the associated database.</p>
        pub fn idle_client_timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.idle_client_timeout(inp);
            self
        }
        /// <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this
        /// value higher or lower than the connection timeout limit for the associated database.</p>
        pub fn set_idle_client_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_idle_client_timeout(input);
            self
        }
        /// <p>Whether the proxy includes detailed information about SQL statements in its logs.
        /// This information helps you to debug issues involving SQL behavior or the performance
        /// and scalability of the proxy connections. The debug information includes the text of
        /// SQL statements that you submit through the proxy. Thus, only enable this setting
        /// when needed for debugging, and only when you have security measures in place to
        /// safeguard any sensitive information that appears in the logs.</p>
        pub fn debug_logging(mut self, inp: bool) -> Self {
            self.inner = self.inner.debug_logging(inp);
            self
        }
        /// <p>Whether the proxy includes detailed information about SQL statements in its logs.
        /// This information helps you to debug issues involving SQL behavior or the performance
        /// and scalability of the proxy connections. The debug information includes the text of
        /// SQL statements that you submit through the proxy. Thus, only enable this setting
        /// when needed for debugging, and only when you have security measures in place to
        /// safeguard any sensitive information that appears in the logs.</p>
        pub fn set_debug_logging(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_debug_logging(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBProxyEndpoint`.
    ///
    /// <p>
    /// Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters.
    /// You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use
    /// DB proxy endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBProxyEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_proxy_endpoint_input::Builder,
    }
    impl<C, M, R> CreateDBProxyEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBProxyEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbProxyEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBProxyEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbProxyEndpointInputOperationOutputAlias,
                crate::output::CreateDbProxyEndpointOutput,
                crate::error::CreateDBProxyEndpointError,
                crate::input::CreateDbProxyEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB proxy associated with the DB proxy endpoint that you create.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The name of the DB proxy associated with the DB proxy endpoint that you create.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
        /// <p>The name of the DB proxy endpoint to create.</p>
        pub fn db_proxy_endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_endpoint_name(inp);
            self
        }
        /// <p>The name of the DB proxy endpoint to create.</p>
        pub fn set_db_proxy_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_endpoint_name(input);
            self
        }
        /// Appends an item to `VpcSubnetIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_subnet_ids`](Self::set_vpc_subnet_ids).
        ///
        /// <p>The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a
        /// different set of subnet IDs than for the original DB proxy.</p>
        pub fn vpc_subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_subnet_ids(inp);
            self
        }
        /// <p>The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a
        /// different set of subnet IDs than for the original DB proxy.</p>
        pub fn set_vpc_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_subnet_ids(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The VPC security group IDs for the DB proxy endpoint that you create. You can
        /// specify a different set of security group IDs than for the original DB proxy.
        /// The default is the default security group for the VPC.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>The VPC security group IDs for the DB proxy endpoint that you create. You can
        /// specify a different set of security group IDs than for the original DB proxy.
        /// The default is the default security group for the VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write
        /// or read-only operations. The default is <code>READ_WRITE</code>.</p>
        pub fn target_role(mut self, inp: crate::model::DbProxyEndpointTargetRole) -> Self {
            self.inner = self.inner.target_role(inp);
            self
        }
        /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write
        /// or read-only operations. The default is <code>READ_WRITE</code>.</p>
        pub fn set_target_role(
            mut self,
            input: std::option::Option<crate::model::DbProxyEndpointTargetRole>,
        ) -> Self {
            self.inner = self.inner.set_target_role(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBSecurityGroup`.
    ///
    /// <p>Creates a new DB security group. DB security groups control access to a DB instance.</p>
    /// <note>
    /// <p>A DB security group controls access to EC2-Classic DB instances that are not in a VPC.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_security_group_input::Builder,
    }
    impl<C, M, R> CreateDBSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbSecurityGroupInputOperationOutputAlias,
                crate::output::CreateDbSecurityGroupOutput,
                crate::error::CreateDBSecurityGroupError,
                crate::input::CreateDbSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the DB security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default"</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mysecuritygroup</code>
        /// </p>
        pub fn db_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_group_name(inp);
            self
        }
        /// <p>The name for the DB security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default"</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>mysecuritygroup</code>
        /// </p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_security_group_name(input);
            self
        }
        /// <p>The description for the DB security group.</p>
        pub fn db_security_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_security_group_description(inp);
            self
        }
        /// <p>The description for the DB security group.</p>
        pub fn set_db_security_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_security_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB security group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to assign to the DB security group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBSnapshot`.
    ///
    /// <p>Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or
    /// <code>storage-optimization</code> state.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_snapshot_input::Builder,
    }
    impl<C, M, R> CreateDBSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbSnapshotInputOperationOutputAlias,
                crate::output::CreateDbSnapshotOutput,
                crate::error::CreateDBSnapshotError,
                crate::input::CreateDbSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Can't be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the DB instance that you want to create the snapshot of.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The identifier of the DB instance that you want to create the snapshot of.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBSubnetGroup`.
    ///
    /// <p>Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_db_subnet_group_input::Builder,
    }
    impl<C, M, R> CreateDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDbSubnetGroupInputOperationOutputAlias,
                crate::output::CreateDbSubnetGroupOutput,
                crate::error::CreateDBSubnetGroupError,
                crate::input::CreateDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_description(inp);
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB subnet group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to assign to the DB subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p>Creates an RDS event notification subscription. This action requires a topic Amazon
    /// Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API.
    /// To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the
    /// topic. The ARN is displayed in the SNS console.</p>
    /// <p>You can specify the type of source (<code>SourceType</code>) that you want to be
    /// notified of and provide a list of RDS sources (<code>SourceIds</code>) that triggers the
    /// events. You can also provide a list of event categories (<code>EventCategories</code>)
    /// for events that you want to be notified of. For example, you can specify
    /// <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> =
    /// <code>mydbinstance1</code>, <code>mydbinstance2</code> and
    /// <code>EventCategories</code> = <code>Availability</code>,
    /// <code>Backup</code>.</p>
    ///
    /// <p>If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> = <code>db-instance</code>
    /// and <code>SourceIdentifier</code> = <code>myDBInstance1</code>, you are notified of all the <code>db-instance</code> events for
    /// the specified source. If you specify a <code>SourceType</code> but do not specify a <code>SourceIdentifier</code>,
    /// you receive notice of the events for that source type for all your RDS sources. If you
    /// don't specify either the SourceType or the <code>SourceIdentifier</code>, you are notified of events
    /// generated from all RDS sources belonging to your customer account.</p>
    /// <note>
    /// <p>RDS event notification is only available for unencrypted SNS topics. If you specify an
    /// encrypted SNS topic, event notifications aren't sent for the topic.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl<C, M, R> CreateEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventSubscriptionInputOperationOutputAlias,
                crate::output::CreateEventSubscriptionOutput,
                crate::error::CreateEventSubscriptionError,
                crate::input::CreateEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be
        /// notified of events generated by a DB instance, you set this parameter to
        /// <code>db-instance</code>. If this value isn't specified, all events are
        /// returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code>
        /// </p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be
        /// notified of events generated by a DB instance, you set this parameter to
        /// <code>db-instance</code>. If this value isn't specified, all events are
        /// returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a particular source type (<code>SourceType</code>)
        /// that you want to subscribe to. You can see a list of the categories for a given source
        /// type in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the
        /// <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation. </p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p> A list of event categories for a particular source type (<code>SourceType</code>)
        /// that you want to subscribe to. You can see a list of the categories for a given source
        /// type in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the
        /// <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation. </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response.
        /// An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// </ul>
        pub fn source_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(inp);
            self
        }
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response.
        /// An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// </ul>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// <p>
        /// A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.
        /// </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>
        /// A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.
        /// </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGlobalCluster`.
    ///
    /// <p>
    /// Creates an Aurora global database
    /// spread across multiple Amazon Web Services Regions. The global database
    /// contains a single primary cluster with read-write capability,
    /// and a read-only secondary cluster that receives
    /// data from the primary cluster through high-speed replication
    /// performed by the Aurora storage subsystem.
    /// </p>
    /// <p>
    /// You can create a global database that is initially empty, and then
    /// add a primary cluster and a secondary cluster to it.
    /// Or you can specify an existing Aurora cluster during the create operation,
    /// and this cluster becomes the primary cluster of the global database.
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateGlobalCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_global_cluster_input::Builder,
    }
    impl<C, M, R> CreateGlobalCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGlobalCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGlobalClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGlobalClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGlobalClusterInputOperationOutputAlias,
                crate::output::CreateGlobalClusterOutput,
                crate::error::CreateGlobalClusterError,
                crate::input::CreateGlobalClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the new global database cluster.</p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the new global database cluster.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
        /// This parameter is optional.
        /// </p>
        pub fn source_db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_db_cluster_identifier(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
        /// This parameter is optional.
        /// </p>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The engine version of the Aurora global database.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The engine version of the Aurora global database.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>
        /// The deletion protection setting for the new global database.
        /// The global database can't be deleted when deletion protection is enabled.
        /// </p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>
        /// The deletion protection setting for the new global database.
        /// The global database can't be deleted when deletion protection is enabled.
        /// </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>
        /// The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon
        /// Aurora will not create a database in the global database cluster you are creating.
        /// </p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>
        /// The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon
        /// Aurora will not create a database in the global database cluster you are creating.
        /// </p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>
        /// The storage encryption setting for the new global database cluster.
        /// </p>
        pub fn storage_encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.storage_encrypted(inp);
            self
        }
        /// <p>
        /// The storage encryption setting for the new global database cluster.
        /// </p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOptionGroup`.
    ///
    /// <p>Creates a new option group. You can create up to 20 option groups.</p>
    /// <p>This command doesn't apply to RDS Custom.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOptionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_option_group_input::Builder,
    }
    impl<C, M, R> CreateOptionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOptionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOptionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOptionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOptionGroupInputOperationOutputAlias,
                crate::output::CreateOptionGroupOutput,
                crate::error::CreateOptionGroupError,
                crate::input::CreateOptionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the option group to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myoptiongroup</code>
        /// </p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>Specifies the name of the option group to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myoptiongroup</code>
        /// </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>Specifies the name of the engine that this option group should be associated with.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(inp);
            self
        }
        /// <p>Specifies the name of the engine that this option group should be associated with.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>Specifies the major version of the engine that this option group should be associated with.</p>
        pub fn major_engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_engine_version(inp);
            self
        }
        /// <p>Specifies the major version of the engine that this option group should be associated with.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_engine_version(input);
            self
        }
        /// <p>The description of the option group.</p>
        pub fn option_group_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_description(inp);
            self
        }
        /// <p>The description of the option group.</p>
        pub fn set_option_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the option group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to assign to the option group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomAvailabilityZone`.
    ///
    /// <p>Deletes a custom Availability Zone (AZ).</p>
    /// <p>A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
    /// <p>For more information about RDS on VMware, see the
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
    /// RDS on VMware User Guide.</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomAvailabilityZone<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_availability_zone_input::Builder,
    }
    impl<C, M, R> DeleteCustomAvailabilityZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomAvailabilityZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomAvailabilityZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomAvailabilityZoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomAvailabilityZoneInputOperationOutputAlias,
                crate::output::DeleteCustomAvailabilityZoneOutput,
                crate::error::DeleteCustomAvailabilityZoneError,
                crate::input::DeleteCustomAvailabilityZoneInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The custom AZ identifier.</p>
        pub fn custom_availability_zone_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_availability_zone_id(inp);
            self
        }
        /// <p>The custom AZ identifier.</p>
        pub fn set_custom_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_availability_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomDBEngineVersion`.
    ///
    /// <p>Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:</p>
    /// <ul>
    /// <li>
    /// <p>The CEV must not be the default for RDS Custom. If it is, change the default
    /// before running this command.</p>
    /// </li>
    /// <li>
    /// <p>The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot,
    /// or automated backup of your RDS Custom instance.</p>
    /// </li>
    /// </ul>
    /// <p>Typically, deletion takes a few minutes.</p>
    /// <note>
    /// <p>The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
    /// Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
    /// <code>DeleteCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the
    /// API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
    /// the <code>DeleteCustomDbEngineVersion</code> event.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">
    /// Deleting a CEV</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomDBEngineVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_db_engine_version_input::Builder,
    }
    impl<C, M, R> DeleteCustomDBEngineVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomDBEngineVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomDbEngineVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomDBEngineVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomDbEngineVersionInputOperationOutputAlias,
                crate::output::DeleteCustomDbEngineVersionOutput,
                crate::error::DeleteCustomDBEngineVersionError,
                crate::input::DeleteCustomDbEngineVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The database engine. The only supported engine is <code>custom-oracle-ee</code>.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The database engine. The only supported engine is <code>custom-oracle-ee</code>.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The custom engine version (CEV) for your DB instance. This option is required for
        /// RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and
        /// <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The custom engine version (CEV) for your DB instance. This option is required for
        /// RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and
        /// <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBCluster`.
    ///
    /// <p>The DeleteDBCluster action deletes a previously provisioned DB cluster.
    /// When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered.
    /// Manual DB cluster snapshots of the specified DB cluster are not deleted.</p>
    /// <p></p>
    /// <p>For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_input::Builder,
    }
    impl<C, M, R> DeleteDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterInputOperationOutputAlias,
                crate::output::DeleteDbClusterOutput,
                crate::error::DeleteDBClusterError,
                crate::input::DeleteDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted.
        /// If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot
        /// is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created.
        /// By default, this parameter is disabled.</p>
        /// <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is disabled.</p>
        /// </note>
        pub fn skip_final_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(inp);
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted.
        /// If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot
        /// is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created.
        /// By default, this parameter is disabled.</p>
        /// <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is disabled.</p>
        /// </note>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p>
        /// The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code>
        /// is disabled.
        /// </p>
        /// <note>
        /// <p>
        /// Specifying this parameter and also skipping the creation of a final DB cluster snapshot
        /// with the <code>SkipFinalShapshot</code> parameter results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_db_snapshot_identifier(inp);
            self
        }
        /// <p>
        /// The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code>
        /// is disabled.
        /// </p>
        /// <note>
        /// <p>
        /// Specifying this parameter and also skipping the creation of a final DB cluster snapshot
        /// with the <code>SkipFinalShapshot</code> parameter results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterEndpoint`.
    ///
    /// <p>Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.</p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterEndpointInputOperationOutputAlias,
                crate::output::DeleteDbClusterEndpointOutput,
                crate::error::DeleteDBClusterEndpointError,
                crate::input::DeleteDbClusterEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(inp);
            self
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterParameterGroup`.
    ///
    /// <p>Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.</p>
    /// <p>For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterParameterGroupInputOperationOutputAlias,
                crate::output::DeleteDbClusterParameterGroupOutput,
                crate::error::DeleteDBClusterParameterGroupError,
                crate::input::DeleteDbClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Can't be associated with any DB clusters.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Can't be associated with any DB clusters.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBClusterSnapshot`.
    ///
    /// <p>Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.</p>
    /// <note>
    /// <p>The DB cluster snapshot must be in the <code>available</code> state to be
    /// deleted.</p>
    /// </note>
    /// <p>For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteDBClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbClusterSnapshotInputOperationOutputAlias,
                crate::output::DeleteDbClusterSnapshotOutput,
                crate::error::DeleteDBClusterSnapshotError,
                crate::input::DeleteDbClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBInstance`.
    ///
    /// <p>The DeleteDBInstance action deletes a previously provisioned DB instance.
    /// When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered.
    /// Manual DB snapshots of the DB instance to be deleted by <code>DeleteDBInstance</code> are not deleted.</p>
    /// <p>
    /// If you request a final DB snapshot
    /// the status of the Amazon RDS DB instance is <code>deleting</code> until the DB snapshot is created. The API action <code>DescribeDBInstance</code>
    /// is used to monitor the status of this operation. The action can't be canceled or reverted once submitted.
    /// </p>
    /// <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>,
    /// or <code>incompatible-network</code>, you can only delete it when you skip creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.</p>
    ///
    /// <p>If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of the following
    /// conditions are true:</p>
    /// <ul>
    /// <li>
    /// <p>The DB cluster is a read replica of another Amazon Aurora DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>The DB instance is the only instance in the DB cluster.</p>
    /// </li>
    /// </ul>
    /// <p>To delete a DB instance in this case, first call the
    /// <code>PromoteReadReplicaDBCluster</code> API action to promote the DB cluster so
    /// it's no longer a read replica. After the promotion completes, then call the
    /// <code>DeleteDBInstance</code> API action to delete the final instance in the DB
    /// cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_instance_input::Builder,
    }
    impl<C, M, R> DeleteDBInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbInstanceInputOperationOutputAlias,
                crate::output::DeleteDbInstanceOutput,
                crate::error::DeleteDBInstanceError,
                crate::input::DeleteDbInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB instance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the name of an existing DB instance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance.
        /// If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter,
        /// RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled,
        /// and the DB snapshot is created.</p>
        /// <note>
        /// <p>If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>,
        /// or <code>incompatible-network</code>, RDS can delete the instance only if you enable this parameter.</p>
        /// <p>If you delete a read replica or an RDS Custom instance, you must enable this setting.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn skip_final_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(inp);
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance.
        /// If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter,
        /// RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled,
        /// and the DB snapshot is created.</p>
        /// <note>
        /// <p>If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>,
        /// or <code>incompatible-network</code>, RDS can delete the instance only if you enable this parameter.</p>
        /// <p>If you delete a read replica or an RDS Custom instance, you must enable this setting.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p>
        /// The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code>
        /// parameter is disabled.
        /// </p>
        /// <note>
        /// <p>If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Can't be specified when deleting a read replica.</p>
        /// </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_db_snapshot_identifier(inp);
            self
        }
        /// <p>
        /// The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code>
        /// parameter is disabled.
        /// </p>
        /// <note>
        /// <p>If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Can't be specified when deleting a read replica.</p>
        /// </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_db_snapshot_identifier(input);
            self
        }
        /// <p>A value that indicates whether to remove automated backups immediately after the DB
        /// instance is deleted. This parameter isn't case-sensitive. The default is to remove
        /// automated backups immediately after the DB instance is deleted.</p>
        pub fn delete_automated_backups(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_automated_backups(inp);
            self
        }
        /// <p>A value that indicates whether to remove automated backups immediately after the DB
        /// instance is deleted. This parameter isn't case-sensitive. The default is to remove
        /// automated backups immediately after the DB instance is deleted.</p>
        pub fn set_delete_automated_backups(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_automated_backups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBInstanceAutomatedBackup`.
    ///
    /// <p>Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBInstanceAutomatedBackup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_instance_automated_backup_input::Builder,
    }
    impl<C, M, R> DeleteDBInstanceAutomatedBackup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBInstanceAutomatedBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbInstanceAutomatedBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceAutomatedBackupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbInstanceAutomatedBackupInputOperationOutputAlias,
                crate::output::DeleteDbInstanceAutomatedBackupOutput,
                crate::error::DeleteDBInstanceAutomatedBackupError,
                crate::input::DeleteDbInstanceAutomatedBackupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn dbi_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dbi_resource_id(inp);
            self
        }
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dbi_resource_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the automated backups to delete, for example,
        /// <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn db_instance_automated_backups_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_instance_automated_backups_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the automated backups to delete, for example,
        /// <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_db_instance_automated_backups_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_automated_backups_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBParameterGroup`.
    ///
    /// <p>Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteDBParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbParameterGroupInputOperationOutputAlias,
                crate::output::DeleteDbParameterGroupOutput,
                crate::error::DeleteDBParameterGroupError,
                crate::input::DeleteDbParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>Can't be associated with any DB instances</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>You can't delete a default DB parameter group</p>
        /// </li>
        /// <li>
        /// <p>Can't be associated with any DB instances</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBProxy`.
    ///
    /// <p>Deletes an existing DB proxy.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBProxy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_proxy_input::Builder,
    }
    impl<C, M, R> DeleteDBProxy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBProxy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbProxyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBProxyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbProxyInputOperationOutputAlias,
                crate::output::DeleteDbProxyOutput,
                crate::error::DeleteDBProxyError,
                crate::input::DeleteDbProxyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB proxy to delete.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The name of the DB proxy to delete.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBProxyEndpoint`.
    ///
    /// <p>Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the
    /// endpoint that you defined. The endpoint that you delete might have provided capabilities such as read/write
    /// or read-only operations, or using a different VPC than the DB proxy's default VPC.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBProxyEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_proxy_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteDBProxyEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBProxyEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbProxyEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBProxyEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbProxyEndpointInputOperationOutputAlias,
                crate::output::DeleteDbProxyEndpointOutput,
                crate::error::DeleteDBProxyEndpointError,
                crate::input::DeleteDbProxyEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB proxy endpoint to delete.</p>
        pub fn db_proxy_endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_endpoint_name(inp);
            self
        }
        /// <p>The name of the DB proxy endpoint to delete.</p>
        pub fn set_db_proxy_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_endpoint_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBSecurityGroup`.
    ///
    /// <p>Deletes a DB security group.</p>
    /// <note>
    /// <p>The specified DB security group must not be associated with any DB instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_security_group_input::Builder,
    }
    impl<C, M, R> DeleteDBSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbSecurityGroupInputOperationOutputAlias,
                crate::output::DeleteDbSecurityGroupOutput,
                crate::error::DeleteDBSecurityGroupError,
                crate::input::DeleteDbSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB security group to delete.</p>
        /// <note>
        /// <p>You can't delete the default DB security group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default"</p>
        /// </li>
        /// </ul>
        pub fn db_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_group_name(inp);
            self
        }
        /// <p>The name of the DB security group to delete.</p>
        /// <note>
        /// <p>You can't delete the default DB security group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters, numbers, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default"</p>
        /// </li>
        /// </ul>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_security_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBSnapshot`.
    ///
    /// <p>Deletes a DB snapshot. If the snapshot is being copied, the copy operation is
    /// terminated.</p>
    /// <note>
    /// <p>The DB snapshot must be in the <code>available</code> state to be deleted.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteDBSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbSnapshotInputOperationOutputAlias,
                crate::output::DeleteDbSnapshotOutput,
                crate::error::DeleteDBSnapshotError,
                crate::input::DeleteDbSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB snapshot identifier.</p>
        /// <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>
        pub fn db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_snapshot_identifier(inp);
            self
        }
        /// <p>The DB snapshot identifier.</p>
        /// <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDBSubnetGroup`.
    ///
    /// <p>Deletes a DB subnet group.</p>
    /// <note>
    /// <p>The specified database subnet group must not be associated with any DB instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDBSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_db_subnet_group_input::Builder,
    }
    impl<C, M, R> DeleteDBSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDBSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDbSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDbSubnetGroupInputOperationOutputAlias,
                crate::output::DeleteDbSubnetGroupOutput,
                crate::error::DeleteDBSubnetGroupError,
                crate::input::DeleteDbSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the database subnet group to delete.</p>
        /// <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p>Deletes an RDS event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl<C, M, R> DeleteEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventSubscriptionInputOperationOutputAlias,
                crate::output::DeleteEventSubscriptionOutput,
                crate::error::DeleteEventSubscriptionError,
                crate::input::DeleteEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the RDS event notification subscription you want to delete.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the RDS event notification subscription you want to delete.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGlobalCluster`.
    ///
    /// <p>
    /// Deletes a global database cluster. The primary and secondary clusters must already be detached or
    /// destroyed first.
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGlobalCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_global_cluster_input::Builder,
    }
    impl<C, M, R> DeleteGlobalCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGlobalCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGlobalClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGlobalClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGlobalClusterInputOperationOutputAlias,
                crate::output::DeleteGlobalClusterOutput,
                crate::error::DeleteGlobalClusterError,
                crate::input::DeleteGlobalClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The cluster identifier of the global database cluster being deleted.
        /// </p>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>
        /// The cluster identifier of the global database cluster being deleted.
        /// </p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstallationMedia`.
    ///
    /// <p>Deletes the installation medium for a DB engine that requires an on-premises customer provided license,
    /// such as Microsoft SQL Server.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInstallationMedia<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_installation_media_input::Builder,
    }
    impl<C, M, R> DeleteInstallationMedia<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstallationMedia`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstallationMediaOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInstallationMediaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInstallationMediaInputOperationOutputAlias,
                crate::output::DeleteInstallationMediaOutput,
                crate::error::DeleteInstallationMediaError,
                crate::input::DeleteInstallationMediaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The installation medium ID.</p>
        pub fn installation_media_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.installation_media_id(inp);
            self
        }
        /// <p>The installation medium ID.</p>
        pub fn set_installation_media_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_installation_media_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOptionGroup`.
    ///
    /// <p>Deletes an existing option group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOptionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_option_group_input::Builder,
    }
    impl<C, M, R> DeleteOptionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOptionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOptionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOptionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOptionGroupInputOperationOutputAlias,
                crate::output::DeleteOptionGroupOutput,
                crate::error::DeleteOptionGroupError,
                crate::input::DeleteOptionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the option group to be deleted.</p>
        /// <note>
        /// <p>You can't delete default option groups.</p>
        /// </note>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>The name of the option group to be deleted.</p>
        /// <note>
        /// <p>You can't delete default option groups.</p>
        /// </note>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterDBProxyTargets`.
    ///
    /// <p>Remove the association between one or more <code>DBProxyTarget</code> data structures and a <code>DBProxyTargetGroup</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterDBProxyTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_db_proxy_targets_input::Builder,
    }
    impl<C, M, R> DeregisterDBProxyTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterDBProxyTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterDbProxyTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterDBProxyTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterDbProxyTargetsInputOperationOutputAlias,
                crate::output::DeregisterDbProxyTargetsOutput,
                crate::error::DeregisterDBProxyTargetsError,
                crate::input::DeregisterDbProxyTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
        pub fn target_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_name(inp);
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
        pub fn set_target_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_name(input);
            self
        }
        /// Appends an item to `DBInstanceIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_db_instance_identifiers`](Self::set_db_instance_identifiers).
        ///
        /// <p>One or more DB instance identifiers.</p>
        pub fn db_instance_identifiers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifiers(inp);
            self
        }
        /// <p>One or more DB instance identifiers.</p>
        pub fn set_db_instance_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifiers(input);
            self
        }
        /// Appends an item to `DBClusterIdentifiers`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_identifiers`](Self::set_db_cluster_identifiers).
        ///
        /// <p>One or more DB cluster identifiers.</p>
        pub fn db_cluster_identifiers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifiers(inp);
            self
        }
        /// <p>One or more DB cluster identifiers.</p>
        pub fn set_db_cluster_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifiers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.</p>
    /// <p>This command doesn't take any parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl<C, M, R> DescribeAccountAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAttributesInputOperationOutputAlias,
                crate::output::DescribeAccountAttributesOutput,
                crate::error::DescribeAccountAttributesError,
                crate::input::DescribeAccountAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificates`.
    ///
    /// <p>Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_certificates_input::Builder,
    }
    impl<C, M, R> DescribeCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCertificatesInputOperationOutputAlias,
                crate::output::DescribeCertificatesOutput,
                crate::error::DescribeCertificatesError,
                crate::input::DescribeCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing CertificateIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn certificate_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_identifier(inp);
            self
        }
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match an existing CertificateIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeCertificates</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeCertificates</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomAvailabilityZones`.
    ///
    /// <p>Returns information about custom Availability Zones (AZs).</p>
    /// <p>A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
    /// <p>For more information about RDS on VMware, see the
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
    /// RDS on VMware User Guide.</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCustomAvailabilityZones<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_availability_zones_input::Builder,
    }
    impl<C, M, R> DescribeCustomAvailabilityZones<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomAvailabilityZones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomAvailabilityZonesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomAvailabilityZonesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomAvailabilityZonesInputOperationOutputAlias,
                crate::output::DescribeCustomAvailabilityZonesOutput,
                crate::error::DescribeCustomAvailabilityZonesError,
                crate::input::DescribeCustomAvailabilityZonesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The custom AZ identifier. If this parameter is specified, information from only the specific custom AZ is returned.</p>
        pub fn custom_availability_zone_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_availability_zone_id(inp);
            self
        }
        /// <p>The custom AZ identifier. If this parameter is specified, information from only the specific custom AZ is returned.</p>
        pub fn set_custom_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_availability_zone_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more custom AZs to describe.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more custom AZs to describe.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeCustomAvailabilityZones</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeCustomAvailabilityZones</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterBacktracks`.
    ///
    /// <p>Returns information about backtracks for a DB cluster.</p>
    /// <p>For more information on Amazon Aurora, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora MySQL DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterBacktracks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_backtracks_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterBacktracks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterBacktracks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterBacktracksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterBacktracksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterBacktracksInputOperationOutputAlias,
                crate::output::DescribeDbClusterBacktracksOutput,
                crate::error::DescribeDBClusterBacktracksError,
                crate::input::DescribeDbClusterBacktracksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster to be described. This parameter is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the DB cluster to be described. This parameter is
        /// stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code>
        /// </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>If specified, this value is the backtrack identifier of the backtrack to be
        /// described.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain a valid universally unique identifier (UUID). For more
        /// information about UUIDs, see <a href="http://www.ietf.org/rfc/rfc4122.txt">A Universally Unique Identifier
        /// (UUID) URN Namespace</a>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>123e4567-e89b-12d3-a456-426655440000</code>
        /// </p>
        pub fn backtrack_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backtrack_identifier(inp);
            self
        }
        /// <p>If specified, this value is the backtrack identifier of the backtrack to be
        /// described.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain a valid universally unique identifier (UUID). For more
        /// information about UUIDs, see <a href="http://www.ietf.org/rfc/rfc4122.txt">A Universally Unique Identifier
        /// (UUID) URN Namespace</a>.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>123e4567-e89b-12d3-a456-426655440000</code>
        /// </p>
        pub fn set_backtrack_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_backtrack_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB clusters to describe. Supported filters
        /// include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-backtrack-id</code> - Accepts backtrack identifiers. The
        /// results list includes information about only the backtracks identified by these
        /// identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-cluster-backtrack-status</code> - Accepts any of the following backtrack status values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>applying</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>completed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The results list includes information about only the backtracks identified
        /// by these values.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more DB clusters to describe. Supported filters
        /// include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-backtrack-id</code> - Accepts backtrack identifiers. The
        /// results list includes information about only the backtracks identified by these
        /// identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-cluster-backtrack-status</code> - Accepts any of the following backtrack status values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>applying</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>completed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The results list includes information about only the backtracks identified
        /// by these values.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterBacktracks</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterBacktracks</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterEndpoints`.
    ///
    /// <p>Returns information about endpoints for an Amazon Aurora DB cluster.</p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_endpoints_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterEndpointsInputOperationOutputAlias,
                crate::output::DescribeDbClusterEndpointsOutput,
                crate::error::DescribeDBClusterEndpointsError,
                crate::input::DescribeDbClusterEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(inp);
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name-value pairs that define which endpoints to include in the output.
        /// The filters are specified as name-value pairs, in the format
        /// <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>.
        /// <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>.
        /// <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A set of name-value pairs that define which endpoints to include in the output.
        /// The filters are specified as name-value pairs, in the format
        /// <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>.
        /// <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>.
        /// <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>.
        /// <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameterGroups`.
    ///
    /// <p>
    /// Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
    /// <code>DBClusterParameterGroupName</code> parameter is specified,
    /// the list will contain only the description of the specified DB cluster parameter group.
    /// </p>
    /// <p>For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeDbClusterParameterGroupsOutput,
                crate::error::DescribeDBClusterParameterGroupsError,
                crate::input::DescribeDbClusterParameterGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular DB cluster parameter group.</p>
    /// <p>For more information on Amazon Aurora, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterParametersInputOperationOutputAlias,
                crate::output::DescribeDbClusterParametersOutput,
                crate::error::DescribeDBClusterParametersError,
                crate::input::DescribeDbClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>
        /// A value that indicates to return only parameters for a specific source.
        /// Parameter sources can be <code>engine</code>, <code>service</code>,
        /// or <code>customer</code>.
        /// </p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>
        /// A value that indicates to return only parameters for a specific source.
        /// Parameter sources can be <code>engine</code>, <code>service</code>,
        /// or <code>customer</code>.
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusters`.
    ///
    /// <p>Returns information about provisioned Aurora DB clusters. This API supports pagination.</p>
    /// <p>For more information on Amazon Aurora, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>         
    /// </p>
    /// <note>
    /// <p>This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_clusters_input::Builder,
    }
    impl<C, M, R> DescribeDBClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClustersInputOperationOutputAlias,
                crate::output::DescribeDbClustersOutput,
                crate::error::DescribeDBClustersError,
                crate::input::DescribeDbClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>clone-group-id</code> - Accepts clone group identifiers.
        /// The results list will only include information about
        /// the DB clusters associated with these clone groups.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs). The results list will only include information about
        /// the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>domain</code> - Accepts Active Directory directory IDs.
        /// The results list will only include information about
        /// the DB clusters associated with these domains.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts engine names.
        /// The results list will only include information about
        /// the DB clusters for these engines.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>clone-group-id</code> - Accepts clone group identifiers.
        /// The results list will only include information about
        /// the DB clusters associated with these clone groups.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs). The results list will only include information about
        /// the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>domain</code> - Accepts Active Directory directory IDs.
        /// The results list will only include information about
        /// the DB clusters associated with these domains.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts engine names.
        /// The results list will only include information about
        /// the DB clusters for these engines.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Optional Boolean parameter that specifies whether the output includes information about clusters
        /// shared from other Amazon Web Services accounts.</p>
        pub fn include_shared(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_shared(inp);
            self
        }
        /// <p>Optional Boolean parameter that specifies whether the output includes information about clusters
        /// shared from other Amazon Web Services accounts.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_shared(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshotAttributes`.
    ///
    /// <p>Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.</p>
    /// <p>When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code>
    /// returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
    /// authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of
    /// values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and
    /// can be copied or restored by all Amazon Web Services accounts.</p>
    /// <p>To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to make the
    /// manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshotAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_snapshot_attributes_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterSnapshotAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterSnapshotAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDBClusterSnapshotAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterSnapshotAttributesInputOperationOutputAlias,
                crate::output::DescribeDbClusterSnapshotAttributesOutput,
                crate::error::DescribeDBClusterSnapshotAttributesError,
                crate::input::DescribeDbClusterSnapshotAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBClusterSnapshots`.
    ///
    /// <p>Returns information about DB cluster snapshots. This API action supports pagination.</p>
    /// <p>For more information on Amazon Aurora, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBClusterSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_cluster_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeDBClusterSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbClusterSnapshotsInputOperationOutputAlias,
                crate::output::DescribeDbClusterSnapshotsOutput,
                crate::error::DescribeDBClusterSnapshotsError,
                crate::input::DescribeDbClusterSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for.
        /// This parameter can't be used in conjunction with the
        /// <code>DBClusterSnapshotIdentifier</code> parameter.
        /// This parameter isn't case-sensitive.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for.
        /// This parameter can't be used in conjunction with the
        /// <code>DBClusterSnapshotIdentifier</code> parameter.
        /// This parameter isn't case-sensitive.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe.
        /// This parameter can't be used in conjunction with the
        /// <code>DBClusterIdentifier</code> parameter.            
        /// This value is stored as a lowercase string.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe.
        /// This parameter can't be used in conjunction with the
        /// <code>DBClusterIdentifier</code> parameter.            
        /// This value is stored as a lowercase string.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by
        /// Amazon RDS for my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are
        /// returned. You can include shared DB cluster snapshots with these results by enabling the <code>IncludeShared</code>
        /// parameter. You can include public DB cluster snapshots with these results by enabling the
        /// <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values
        /// of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is
        /// set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>public</code>.</p>
        pub fn snapshot_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_type(inp);
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by
        /// Amazon RDS for my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are
        /// returned. You can include shared DB cluster snapshots with these results by enabling the <code>IncludeShared</code>
        /// parameter. You can include public DB cluster snapshots with these results by enabling the
        /// <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values
        /// of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is
        /// set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB cluster snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-cluster-snapshot-id</code> - Accepts DB cluster snapshot identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>snapshot-type</code> - Accepts types of DB cluster snapshots.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts names of database engines.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more DB cluster snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-cluster-snapshot-id</code> - Accepts DB cluster snapshot identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>snapshot-type</code> - Accepts types of DB cluster snapshots.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts names of database engines.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots
        /// from other Amazon Web Services accounts that this Amazon Web Services account has been given
        /// permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB cluster snapshot from
        /// another Amazon Web Services account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn include_shared(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_shared(inp);
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots
        /// from other Amazon Web Services accounts that this Amazon Web Services account has been given
        /// permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB cluster snapshot from
        /// another Amazon Web Services account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_shared(input);
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied
        /// or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB cluster snapshot  as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn include_public(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_public(inp);
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied
        /// or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB cluster snapshot  as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_public(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBEngineVersions`.
    ///
    /// <p>Returns a list of the available DB engines.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBEngineVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_engine_versions_input::Builder,
    }
    impl<C, M, R> DescribeDBEngineVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbEngineVersionsInputOperationOutputAlias,
                crate::output::DescribeDbEngineVersionsOutput,
                crate::error::DescribeDBEngineVersionsError,
                crate::input::DescribeDbEngineVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The database engine to return.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The database engine to return.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code>
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBParameterGroupFamily.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBParameterGroupFamily.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>A value that indicates whether only the default version of the specified engine or engine and major version combination is returned.</p>
        pub fn default_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.default_only(inp);
            self
        }
        /// <p>A value that indicates whether only the default version of the specified engine or engine and major version combination is returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_only(input);
            self
        }
        /// <p>A value that indicates whether to list the supported character sets for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for
        /// <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine
        /// version.</p>
        /// <p>For RDS Custom, the default is not to list supported character sets. If you set <code>ListSupportedCharacterSets</code>
        /// to <code>true</code>, RDS Custom returns no results.
        /// </p>
        pub fn list_supported_character_sets(mut self, inp: bool) -> Self {
            self.inner = self.inner.list_supported_character_sets(inp);
            self
        }
        /// <p>A value that indicates whether to list the supported character sets for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for
        /// <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine
        /// version.</p>
        /// <p>For RDS Custom, the default is not to list supported character sets. If you set <code>ListSupportedCharacterSets</code>
        /// to <code>true</code>, RDS Custom returns no results.
        /// </p>
        pub fn set_list_supported_character_sets(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_list_supported_character_sets(input);
            self
        }
        /// <p>A value that indicates whether to list the supported time zones for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>,
        /// the response includes a list of supported time zones for each engine version.
        /// </p>
        /// <p>For RDS Custom, the default is not to list supported time zones. If you set <code>ListSupportedTimezones</code>
        /// to <code>true</code>, RDS Custom returns no results.
        /// </p>
        pub fn list_supported_timezones(mut self, inp: bool) -> Self {
            self.inner = self.inner.list_supported_timezones(inp);
            self
        }
        /// <p>A value that indicates whether to list the supported time zones for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>,
        /// the response includes a list of supported time zones for each engine version.
        /// </p>
        /// <p>For RDS Custom, the default is not to list supported time zones. If you set <code>ListSupportedTimezones</code>
        /// to <code>true</code>, RDS Custom returns no results.
        /// </p>
        pub fn set_list_supported_timezones(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_list_supported_timezones(input);
            self
        }
        /// <p>A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions.</p>
        pub fn include_all(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_all(inp);
            self
        }
        /// <p>A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions.</p>
        pub fn set_include_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_all(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBInstanceAutomatedBackups`.
    ///
    /// <p>Displays backups for both current and deleted
    /// instances. For example, use this operation to
    /// find details about automated backups for previously deleted instances. Current instances
    /// with retention periods greater than zero (0) are returned for both the
    /// <code>DescribeDBInstanceAutomatedBackups</code> and
    /// <code>DescribeDBInstances</code> operations.</p>
    /// <p>All parameters are optional.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBInstanceAutomatedBackups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_instance_automated_backups_input::Builder,
    }
    impl<C, M, R> DescribeDBInstanceAutomatedBackups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBInstanceAutomatedBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbInstanceAutomatedBackupsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDBInstanceAutomatedBackupsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbInstanceAutomatedBackupsInputOperationOutputAlias,
                crate::output::DescribeDbInstanceAutomatedBackupsOutput,
                crate::error::DescribeDBInstanceAutomatedBackupsError,
                crate::input::DescribeDbInstanceAutomatedBackupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource ID of the DB instance that is the source of
        /// the automated backup. This parameter isn't case-sensitive. </p>
        pub fn dbi_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dbi_resource_id(inp);
            self
        }
        /// <p>The resource ID of the DB instance that is the source of
        /// the automated backup. This parameter isn't case-sensitive. </p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dbi_resource_id(input);
            self
        }
        /// <p>(Optional) The user-supplied instance identifier. If this parameter is specified, it must
        /// match the identifier of an existing DB instance. It returns information from the
        /// specific DB instance' automated backup. This parameter isn't case-sensitive. </p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>(Optional) The user-supplied instance identifier. If this parameter is specified, it must
        /// match the identifier of an existing DB instance. It returns information from the
        /// specific DB instance' automated backup. This parameter isn't case-sensitive. </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies which resources to return based on status.</p>
        /// <p>Supported filters are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>active</code> - automated backups for current instances</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>retained</code> - automated backups for deleted instances and after backup replication is stopped</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs).
        /// The results list includes only information about the DB instance automated backups identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs).
        /// The results list includes only information about the DB instance resources identified by these ARNs.</p>
        /// </li>
        /// </ul>
        /// <p>Returns all resources by default. The status for each resource is specified in the response.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies which resources to return based on status.</p>
        /// <p>Supported filters are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>active</code> - automated backups for current instances</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>retained</code> - automated backups for deleted instances and after backup replication is stopped</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs).
        /// The results list includes only information about the DB instance automated backups identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs).
        /// The results list includes only information about the DB instance resources identified by these ARNs.</p>
        /// </li>
        /// </ul>
        /// <p>Returns all resources by default. The status for each resource is specified in the response.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified
        /// <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified
        /// <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response
        /// includes only records beyond the marker, up to <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response
        /// includes only records beyond the marker, up to <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replicated automated backups, for example,
        /// <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn db_instance_automated_backups_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_instance_automated_backups_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replicated automated backups, for example,
        /// <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_db_instance_automated_backups_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_automated_backups_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBInstances`.
    ///
    /// <p>Returns information about provisioned RDS instances. This API supports pagination.</p>
    /// <note>
    /// <p>This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_instances_input::Builder,
    }
    impl<C, M, R> DescribeDBInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbInstancesInputOperationOutputAlias,
                crate::output::DescribeDbInstancesOutput,
                crate::error::DescribeDBInstancesError,
                crate::input::DescribeDbInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs). The results list will only include information about
        /// the DB instances associated with the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB
        /// instance Amazon Resource Names (ARNs). The results list will only include information about
        /// the DB instances identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dbi-resource-id</code> - Accepts DB instance resource identifiers. The results list will
        /// only include information about the DB instances identified by these DB instance resource identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>domain</code> - Accepts Active Directory directory IDs. The results list will only
        /// include information about the DB instances associated with these domains.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts engine names. The results list will only include information
        /// about the DB instances for these engines.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs). The results list will only include information about
        /// the DB instances associated with the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB
        /// instance Amazon Resource Names (ARNs). The results list will only include information about
        /// the DB instances identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dbi-resource-id</code> - Accepts DB instance resource identifiers. The results list will
        /// only include information about the DB instances identified by these DB instance resource identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>domain</code> - Accepts Active Directory directory IDs. The results list will only
        /// include information about the DB instances associated with these domains.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts engine names. The results list will only include information
        /// about the DB instances for these engines.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBInstances</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBInstances</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBLogFiles`.
    ///
    /// <p>Returns a list of DB log files for the DB instance.</p>
    /// <p>This command doesn't apply to RDS Custom.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBLogFiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_log_files_input::Builder,
    }
    impl<C, M, R> DescribeDBLogFiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBLogFiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbLogFilesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBLogFilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbLogFilesInputOperationOutputAlias,
                crate::output::DescribeDbLogFilesOutput,
                crate::error::DescribeDBLogFilesError,
                crate::input::DescribeDbLogFilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>Filters the available log files for log file names that contain the specified string.</p>
        pub fn filename_contains(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filename_contains(inp);
            self
        }
        /// <p>Filters the available log files for log file names that contain the specified string.</p>
        pub fn set_filename_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filename_contains(input);
            self
        }
        /// <p>Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.</p>
        pub fn file_last_written(mut self, inp: i64) -> Self {
            self.inner = self.inner.file_last_written(inp);
            self
        }
        /// <p>Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.</p>
        pub fn set_file_last_written(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_file_last_written(input);
            self
        }
        /// <p>Filters the available log files for files larger than the specified size.</p>
        pub fn file_size(mut self, inp: i64) -> Self {
            self.inner = self.inner.file_size(inp);
            self
        }
        /// <p>Filters the available log files for files larger than the specified size.</p>
        pub fn set_file_size(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_file_size(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBParameterGroups`.
    ///
    /// <p>
    /// Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is specified,
    /// the list will contain only the description of the specified DB parameter group.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeDbParameterGroupsOutput,
                crate::error::DescribeDBParameterGroupsError,
                crate::input::DescribeDbParameterGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBParameterGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBParameterGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular DB parameter group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_parameters_input::Builder,
    }
    impl<C, M, R> DescribeDBParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbParametersInputOperationOutputAlias,
                crate::output::DescribeDbParametersOutput,
                crate::error::DescribeDBParametersError,
                crate::input::DescribeDbParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the name of an existing DBParameterGroup.</p>
        /// </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code>
        /// </p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code>
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBProxies`.
    ///
    /// <p>Returns information about DB proxies.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBProxies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_proxies_input::Builder,
    }
    impl<C, M, R> DescribeDBProxies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBProxies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbProxiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBProxiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbProxiesInputOperationOutputAlias,
                crate::output::DescribeDbProxiesOutput,
                crate::error::DescribeDBProxiesError,
                crate::input::DescribeDbProxiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB proxy. If you omit this parameter,
        /// the output includes information about all DB proxies owned by
        /// your Amazon Web Services account ID.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The name of the DB proxy. If you omit this parameter,
        /// the output includes information about all DB proxies owned by
        /// your Amazon Web Services account ID.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBProxyEndpoints`.
    ///
    /// <p>Returns information about DB proxy endpoints.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBProxyEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_proxy_endpoints_input::Builder,
    }
    impl<C, M, R> DescribeDBProxyEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBProxyEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbProxyEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbProxyEndpointsInputOperationOutputAlias,
                crate::output::DescribeDbProxyEndpointsOutput,
                crate::error::DescribeDBProxyEndpointsError,
                crate::input::DescribeDbProxyEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB proxy whose endpoints you want to describe. If you omit
        /// this parameter, the output includes information about all DB proxy endpoints
        /// associated with all your DB proxies.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The name of the DB proxy whose endpoints you want to describe. If you omit
        /// this parameter, the output includes information about all DB proxy endpoints
        /// associated with all your DB proxies.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
        /// <p>The name of a DB proxy endpoint to describe. If you omit this parameter,
        /// the output includes information about all DB proxy endpoints associated with
        /// the specified proxy.</p>
        pub fn db_proxy_endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_endpoint_name(inp);
            self
        }
        /// <p>The name of a DB proxy endpoint to describe. If you omit this parameter,
        /// the output includes information about all DB proxy endpoints associated with
        /// the specified proxy.</p>
        pub fn set_db_proxy_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_endpoint_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBProxyTargetGroups`.
    ///
    /// <p>Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBProxyTargetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_proxy_target_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBProxyTargetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBProxyTargetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbProxyTargetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyTargetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbProxyTargetGroupsInputOperationOutputAlias,
                crate::output::DescribeDbProxyTargetGroupsOutput,
                crate::error::DescribeDBProxyTargetGroupsError,
                crate::input::DescribeDbProxyTargetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <code>DBProxy</code> associated with the target group.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The identifier of the <code>DBProxy</code> associated with the target group.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn target_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_name(inp);
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn set_target_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBProxyTargets`.
    ///
    /// <p>Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBProxyTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_proxy_targets_input::Builder,
    }
    impl<C, M, R> DescribeDBProxyTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBProxyTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbProxyTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbProxyTargetsInputOperationOutputAlias,
                crate::output::DescribeDbProxyTargetsOutput,
                crate::error::DescribeDBProxyTargetsError,
                crate::input::DescribeDbProxyTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <code>DBProxyTarget</code> to describe.</p>
        pub fn db_proxy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_proxy_name(inp);
            self
        }
        /// <p>The identifier of the <code>DBProxyTarget</code> to describe.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_proxy_name(input);
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn target_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_group_name(inp);
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn set_target_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that the remaining
        /// results can be retrieved.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBSecurityGroups`.
    ///
    /// <p>
    /// Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
    /// the list will contain only the descriptions of the specified DB security group.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBSecurityGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_security_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBSecurityGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBSecurityGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbSecurityGroupsInputOperationOutputAlias,
                crate::output::DescribeDbSecurityGroupsOutput,
                crate::error::DescribeDBSecurityGroupsError,
                crate::input::DescribeDbSecurityGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB security group to return details for.</p>
        pub fn db_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_group_name(inp);
            self
        }
        /// <p>The name of the DB security group to return details for.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_security_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBSecurityGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBSecurityGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBSnapshotAttributes`.
    ///
    /// <p>Returns a list of DB snapshot attribute names and values for a manual DB snapshot.</p>
    /// <p>When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code>
    /// returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
    /// authorized to copy or restore the manual DB snapshot. If <code>all</code> is included in the list of
    /// values for the <code>restore</code> attribute, then the manual DB snapshot is public and
    /// can be copied or restored by all Amazon Web Services accounts.</p>
    /// <p>To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make the
    /// manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBSnapshotAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_snapshot_attributes_input::Builder,
    }
    impl<C, M, R> DescribeDBSnapshotAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBSnapshotAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbSnapshotAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBSnapshotAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbSnapshotAttributesInputOperationOutputAlias,
                crate::output::DescribeDbSnapshotAttributesOutput,
                crate::error::DescribeDBSnapshotAttributesError,
                crate::input::DescribeDbSnapshotAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the DB snapshot to describe the attributes for.</p>
        pub fn db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the DB snapshot to describe the attributes for.</p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBSnapshots`.
    ///
    /// <p>Returns information about DB snapshots. This API action supports pagination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeDBSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbSnapshotsInputOperationOutputAlias,
                crate::output::DescribeDbSnapshotsOutput,
                crate::error::DescribeDBSnapshotsError,
                crate::input::DescribeDbSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the DB instance to retrieve the list of DB snapshots for.
        /// This parameter can't be used in conjunction with <code>DBSnapshotIdentifier</code>.
        /// This parameter isn't case-sensitive.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The ID of the DB instance to retrieve the list of DB snapshots for.
        /// This parameter can't be used in conjunction with <code>DBSnapshotIdentifier</code>.
        /// This parameter isn't case-sensitive.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>
        /// A specific DB snapshot identifier to describe. This parameter can't be used in conjunction with <code>DBInstanceIdentifier</code>.            
        /// This value is stored as a lowercase string.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn db_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_snapshot_identifier(inp);
            self
        }
        /// <p>
        /// A specific DB snapshot identifier to describe. This parameter can't be used in conjunction with <code>DBInstanceIdentifier</code>.            
        /// This value is stored as a lowercase string.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match the identifier of an existing DBSnapshot.</p>
        /// </li>
        /// <li>
        /// <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p>
        /// </li>
        /// </ul>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_snapshot_identifier(input);
            self
        }
        /// <p>The type of snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB snapshots that have been automatically taken by
        /// Amazon RDS for my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB snapshots that have been marked as public.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.</p>
        /// <p>For information about Amazon Web Services Backup, see the
        /// <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html">
        /// <i>Amazon Web Services Backup Developer Guide.</i>
        /// </a>
        /// </p>
        /// <p>The <code>awsbackup</code> type does not apply to Aurora.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are
        /// returned. Shared and public DB snapshots are not included in the returned results by default.
        /// You can include shared snapshots with these results by enabling the <code>IncludeShared</code>
        /// parameter. You can include public snapshots with these results by enabling the
        /// <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values
        /// of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is
        /// set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>public</code>.</p>
        pub fn snapshot_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_type(inp);
            self
        }
        /// <p>The type of snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>automated</code> - Return all DB snapshots that have been automatically taken by
        /// Amazon RDS for my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public</code> - Return all DB snapshots that have been marked as public.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.</p>
        /// <p>For information about Amazon Web Services Backup, see the
        /// <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html">
        /// <i>Amazon Web Services Backup Developer Guide.</i>
        /// </a>
        /// </p>
        /// <p>The <code>awsbackup</code> type does not apply to Aurora.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are
        /// returned. Shared and public DB snapshots are not included in the returned results by default.
        /// You can include shared snapshots with these results by enabling the <code>IncludeShared</code>
        /// parameter. You can include public snapshots with these results by enabling the
        /// <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values
        /// of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is
        /// set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to
        /// <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB
        /// instance Amazon Resource Names (ARNs).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>snapshot-type</code> - Accepts types of DB snapshots.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts names of database engines.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more DB snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB
        /// instance Amazon Resource Names (ARNs).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>snapshot-type</code> - Accepts types of DB snapshots.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts names of database engines.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBSnapshots</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBSnapshots</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots
        /// from other Amazon Web Services accounts that this Amazon Web Services account has been given
        /// permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB snapshot from
        /// another Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn include_shared(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_shared(inp);
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots
        /// from other Amazon Web Services accounts that this Amazon Web Services account has been given
        /// permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB snapshot from
        /// another Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_shared(input);
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied
        /// or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn include_public(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_public(inp);
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied
        /// or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_public(input);
            self
        }
        /// <p>A specific DB resource ID to describe.</p>
        pub fn dbi_resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dbi_resource_id(inp);
            self
        }
        /// <p>A specific DB resource ID to describe.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dbi_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDBSubnetGroups`.
    ///
    /// <p>Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.</p>
    /// <p>For an overview of CIDR ranges, go to the
    /// <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDBSubnetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_db_subnet_groups_input::Builder,
    }
    impl<C, M, R> DescribeDBSubnetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDBSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDbSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDbSubnetGroupsInputOperationOutputAlias,
                crate::output::DescribeDbSubnetGroupsOutput,
                crate::error::DescribeDBSubnetGroupsError,
                crate::input::DescribeDbSubnetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn db_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(inp);
            self
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous DescribeDBSubnetGroups request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous DescribeDBSubnetGroups request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultClusterParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the cluster database engine.</p>
    /// <p>For more information on Amazon Aurora, see  
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEngineDefaultClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engine_default_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeEngineDefaultClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngineDefaultClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultClusterParametersOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEngineDefaultClusterParametersError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngineDefaultClusterParametersInputOperationOutputAlias,
                crate::output::DescribeEngineDefaultClusterParametersOutput,
                crate::error::DescribeEngineDefaultClusterParametersError,
                crate::input::DescribeEngineDefaultClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultClusterParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultClusterParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the specified database engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEngineDefaultParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engine_default_parameters_input::Builder,
    }
    impl<C, M, R> DescribeEngineDefaultParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngineDefaultParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngineDefaultParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngineDefaultParametersInputOperationOutputAlias,
                crate::output::DescribeEngineDefaultParametersOutput,
                crate::error::DescribeEngineDefaultParametersError,
                crate::input::DescribeEngineDefaultParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB parameter group family.</p>
        pub fn db_parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(inp);
            self
        }
        /// <p>The name of the DB parameter group family.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeEngineDefaultParameters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Displays a list of categories for all event source types, or, if specified, for a specified source type.
    /// You can see a list of the event categories and source types  
    /// in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">
    /// Events</a> in the <i>Amazon RDS User Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventCategories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl<C, M, R> DescribeEventCategories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventCategoriesInputOperationOutputAlias,
                crate::output::DescribeEventCategoriesOutput,
                crate::error::DescribeEventCategoriesError,
                crate::input::DescribeEventCategoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code>
        /// </p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that is generating the events.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, and DB cluster snapshots for the past 14 days.
    /// Events specific to a particular DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, and DB cluster snapshots group can be
    /// obtained by providing the name as a parameter.</p>
    /// <note>
    /// <p>By default, the past hour of events are returned.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIdentifier</code> is supplied, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>SourceIdentifier</code> is supplied, <code>SourceType</code> must also be provided.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>
        /// The beginning of the time interval to retrieve events for,
        /// specified in ISO 8601 format. For more information about ISO 8601,
        /// go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>
        /// The beginning of the time interval to retrieve events for,
        /// specified in ISO 8601 format. For more information about ISO 8601,
        /// go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>
        /// The end of the time interval for which to retrieve events,
        /// specified in ISO 8601 format. For more information about ISO 8601,
        /// go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>
        /// The end of the time interval for which to retrieve events,
        /// specified in ISO 8601 format. For more information about ISO 8601,
        /// go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories that trigger notifications for a event notification subscription.</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p>A list of event categories that trigger notifications for a event notification subscription.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeEvents request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeEvents request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists all the subscription descriptions for a customer account. The description for a subscription includes
    /// <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>, <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.</p>
    /// <p>If you specify a <code>SubscriptionName</code>, lists the description for that subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeEventSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeEventSubscriptionsOutput,
                crate::error::DescribeEventSubscriptionsError,
                crate::input::DescribeEventSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the RDS event notification subscription you want to describe.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the RDS event notification subscription you want to describe.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeOrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeOrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExportTasks`.
    ///
    /// <p>Returns information about a snapshot export to Amazon S3. This API operation supports
    /// pagination. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeExportTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_export_tasks_input::Builder,
    }
    impl<C, M, R> DescribeExportTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExportTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExportTasksInputOperationOutputAlias,
                crate::output::DescribeExportTasksOutput,
                crate::error::DescribeExportTasksError,
                crate::input::DescribeExportTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot export task to be described.</p>
        pub fn export_task_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_task_identifier(inp);
            self
        }
        /// <p>The identifier of the snapshot export task to be described.</p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_export_task_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to
        /// include in the output. Filter names and values are case-sensitive.</p>
        /// <p>Supported filters include the following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>export-task-identifier</code> - An identifier for the snapshot export task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>canceled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>canceling</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>complete</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>starting</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to
        /// include in the output. Filter names and values are case-sensitive.</p>
        /// <p>Supported filters include the following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>export-task-identifier</code> - An identifier for the snapshot export task.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>canceled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>canceling</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>complete</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>starting</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous <code>DescribeExportTasks</code> request.
        /// If you specify this parameter, the response includes only records beyond the marker,
        /// up to the value specified by the <code>MaxRecords</code> parameter.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous <code>DescribeExportTasks</code> request.
        /// If you specify this parameter, the response includes only records beyond the marker,
        /// up to the value specified by the <code>MaxRecords</code> parameter.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response. If more records exist than the
        /// specified value, a pagination token called a marker is included in the response.
        /// You can use the marker in a later <code>DescribeExportTasks</code> request
        /// to retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response. If more records exist than the
        /// specified value, a pagination token called a marker is included in the response.
        /// You can use the marker in a later <code>DescribeExportTasks</code> request
        /// to retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalClusters`.
    ///
    /// <p>
    /// Returns information about Aurora global database clusters. This API supports pagination.
    /// </p>
    /// <p>
    /// For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What Is Amazon Aurora?</a> in the
    /// <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGlobalClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_global_clusters_input::Builder,
    }
    impl<C, M, R> DescribeGlobalClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGlobalClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGlobalClustersInputOperationOutputAlias,
                crate::output::DescribeGlobalClustersOutput,
                crate::error::DescribeGlobalClustersError,
                crate::input::DescribeGlobalClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>
        /// The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>If supplied, must match an existing DBClusterIdentifier.</p>
        /// </li>
        /// </ul>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response. If more records exist than the specified
        /// <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response. If more records exist than the specified
        /// <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If
        /// this parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If
        /// this parameter is specified, the response includes only records beyond the marker, up to the value
        /// specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstallationMedia`.
    ///
    /// <p>Describes the available installation media for a DB engine that requires an
    /// on-premises customer provided license, such as Microsoft SQL Server.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstallationMedia<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_installation_media_input::Builder,
    }
    impl<C, M, R> DescribeInstallationMedia<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstallationMedia`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstallationMediaOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstallationMediaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstallationMediaInputOperationOutputAlias,
                crate::output::DescribeInstallationMediaOutput,
                crate::error::DescribeInstallationMediaError,
                crate::input::DescribeInstallationMediaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The installation medium ID.</p>
        pub fn installation_media_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.installation_media_id(inp);
            self
        }
        /// <p>The installation medium ID.</p>
        pub fn set_installation_media_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_installation_media_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more installation media to describe. Supported filters
        /// include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ)
        /// identifiers. The results list includes information about only the custom AZs
        /// identified by these identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts database engines. The results list includes information about
        /// only the database engines identified by these identifiers.</p>
        /// <p>For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more installation media to describe. Supported filters
        /// include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>custom-availability-zone-id</code> - Accepts custom Availability Zone (AZ)
        /// identifiers. The results list includes information about only the custom AZs
        /// identified by these identifiers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>engine</code> - Accepts database engines. The results list includes information about
        /// only the database engines identified by these identifiers.</p>
        /// <p>For more information about the valid engines for installation media, see <a>ImportInstallationMedia</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeInstallationMedia request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeInstallationMedia request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOptionGroupOptions`.
    ///
    /// <p>Describes all available options.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOptionGroupOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_option_group_options_input::Builder,
    }
    impl<C, M, R> DescribeOptionGroupOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOptionGroupOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOptionGroupOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOptionGroupOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOptionGroupOptionsInputOperationOutputAlias,
                crate::output::DescribeOptionGroupOptionsOutput,
                crate::error::DescribeOptionGroupOptionsError,
                crate::input::DescribeOptionGroupOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A required parameter. Options available for the given engine name are described.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(inp);
            self
        }
        /// <p>A required parameter. Options available for the given engine name are described.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>If specified, filters the results to include only options for the specified major engine version.</p>
        pub fn major_engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_engine_version(inp);
            self
        }
        /// <p>If specified, filters the results to include only options for the specified major engine version.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_engine_version(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOptionGroups`.
    ///
    /// <p>Describes the available option groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOptionGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_option_groups_input::Builder,
    }
    impl<C, M, R> DescribeOptionGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOptionGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOptionGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOptionGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOptionGroupsInputOperationOutputAlias,
                crate::output::DescribeOptionGroupsOutput,
                crate::error::DescribeOptionGroupsError,
                crate::input::DescribeOptionGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the option group to describe. Can't be supplied together with EngineName or MajorEngineVersion.</p>
        pub fn option_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(inp);
            self
        }
        /// <p>The name of the option group to describe. Can't be supplied together with EngineName or MajorEngineVersion.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous DescribeOptionGroups request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous DescribeOptionGroups request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>Filters the list of option groups to only include groups associated with a specific database engine.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(inp);
            self
        }
        /// <p>Filters the list of option groups to only include groups associated with a specific database engine.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified.</p>
        pub fn major_engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_engine_version(inp);
            self
        }
        /// <p>Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_engine_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableDBInstanceOptions`.
    ///
    /// <p>Returns a list of orderable DB instance options for the specified engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrderableDBInstanceOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_orderable_db_instance_options_input::Builder,
    }
    impl<C, M, R> DescribeOrderableDBInstanceOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrderableDBInstanceOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableDbInstanceOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrderableDBInstanceOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrderableDbInstanceOptionsInputOperationOutputAlias,
                crate::output::DescribeOrderableDbInstanceOptionsOutput,
                crate::error::DescribeOrderableDBInstanceOptionsError,
                crate::input::DescribeOrderableDbInstanceOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the engine to retrieve DB instance options for.</p>
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aurora-postgresql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mariadb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>mysql</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-ee-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>oracle-se2-cdb</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>postgres</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available offerings
        /// matching the specified license model.</p>
        /// <p>RDS Custom supports only the BYOL licensing model.</p>
        pub fn license_model(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_model(inp);
            self
        }
        /// <p>The license model filter value. Specify this parameter to show only the available offerings
        /// matching the specified license model.</p>
        /// <p>RDS Custom supports only the BYOL licensing model.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_model(input);
            self
        }
        /// <p>The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available offerings for the Local Zones in the group.</p>
        /// <p>Omit this parameter to show the available offerings in the specified Amazon Web Services Region.</p>
        /// <p> This setting doesn't apply to RDS Custom.</p>
        pub fn availability_zone_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone_group(inp);
            self
        }
        /// <p>The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available offerings for the Local Zones in the group.</p>
        /// <p>Omit this parameter to show the available offerings in the specified Amazon Web Services Region.</p>
        /// <p> This setting doesn't apply to RDS Custom.</p>
        pub fn set_availability_zone_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_group(input);
            self
        }
        /// <p>A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports
        /// only VPC offerings.</p>
        /// <p>RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output
        /// shows VPC offerings.</p>
        pub fn vpc(mut self, inp: bool) -> Self {
            self.inner = self.inner.vpc(inp);
            self
        }
        /// <p>A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports
        /// only VPC offerings.</p>
        /// <p>RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output
        /// shows VPC offerings.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeOrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeOrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePendingMaintenanceActions`.
    ///
    /// <p>Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePendingMaintenanceActions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pending_maintenance_actions_input::Builder,
    }
    impl<C, M, R> DescribePendingMaintenanceActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePendingMaintenanceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePendingMaintenanceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePendingMaintenanceActionsInputOperationOutputAlias,
                crate::output::DescribePendingMaintenanceActionsOutput,
                crate::error::DescribePendingMaintenanceActionsError,
                crate::input::DescribePendingMaintenanceActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>The ARN of a resource to return pending maintenance actions for.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more resources to return pending maintenance actions for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance
        /// actions for the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB
        /// instance ARNs. The results list will only include pending maintenance
        /// actions for the DB instances identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter that specifies one or more resources to return pending maintenance actions for.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB
        /// cluster Amazon Resource Names (ARNs). The results list will only include pending maintenance
        /// actions for the DB clusters identified by these ARNs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>db-instance-id</code> - Accepts DB instance identifiers and DB
        /// instance ARNs. The results list will only include pending maintenance
        /// actions for the DB instances identified by these ARNs.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to a number of records specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to a number of records specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more records exist than the specified <code>MaxRecords</code> value,
        /// a pagination token called a marker is included in the response so that
        /// you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedDBInstances`.
    ///
    /// <p>Returns information about reserved DB instances for this account, or about a specified reserved DB instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservedDBInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_db_instances_input::Builder,
    }
    impl<C, M, R> DescribeReservedDBInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedDBInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedDbInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedDBInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservedDbInstancesInputOperationOutputAlias,
                crate::output::DescribeReservedDbInstancesOutput,
                crate::error::DescribeReservedDBInstancesError,
                crate::input::DescribeReservedDbInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID.</p>
        pub fn reserved_db_instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_db_instance_id(inp);
            self
        }
        /// <p>The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID.</p>
        pub fn set_reserved_db_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_db_instance_id(input);
            self
        }
        /// <p>The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier.</p>
        pub fn reserved_db_instances_offering_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_db_instances_offering_id(inp);
            self
        }
        /// <p>The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier.</p>
        pub fn set_reserved_db_instances_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_db_instances_offering_id(input);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
        /// </p>
        pub fn duration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
        /// </p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The product description filter value. Specify this parameter to show only those reservations matching the specified product description.</p>
        pub fn product_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_description(inp);
            self
        }
        /// <p>The product description filter value. Specify this parameter to show only those reservations matching the specified product description.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_product_description(input);
            self
        }
        /// <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
        /// </p>
        pub fn offering_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_type(inp);
            self
        }
        /// <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
        /// </p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_offering_type(input);
            self
        }
        /// <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified lease ID.</p>
        /// <note>
        /// <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p>
        /// </note>
        pub fn lease_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lease_id(inp);
            self
        }
        /// <p>The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified lease ID.</p>
        /// <note>
        /// <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p>
        /// </note>
        pub fn set_lease_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lease_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedDBInstancesOfferings`.
    ///
    /// <p>Lists available reserved DB instance offerings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservedDBInstancesOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_db_instances_offerings_input::Builder,
    }
    impl<C, M, R> DescribeReservedDBInstancesOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedDBInstancesOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedDbInstancesOfferingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReservedDBInstancesOfferingsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservedDbInstancesOfferingsInputOperationOutputAlias,
                crate::output::DescribeReservedDbInstancesOfferingsOutput,
                crate::error::DescribeReservedDBInstancesOfferingsError,
                crate::input::DescribeReservedDbInstancesOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
        /// </p>
        pub fn reserved_db_instances_offering_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_db_instances_offering_id(inp);
            self
        }
        /// <p>The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
        /// </p>
        pub fn set_reserved_db_instances_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_db_instances_offering_id(input);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
        pub fn db_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(inp);
            self
        }
        /// <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
        /// </p>
        pub fn duration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
        /// </p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>Product description filter value. Specify this parameter to show only the available offerings that contain the specified product description.</p>
        /// <note>
        /// <p>The results show offerings that partially match the filter value.</p>
        /// </note>
        pub fn product_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_description(inp);
            self
        }
        /// <p>Product description filter value. Specify this parameter to show only the available offerings that contain the specified product description.</p>
        /// <note>
        /// <p>The results show offerings that partially match the filter value.</p>
        /// </note>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_product_description(input);
            self
        }
        /// <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
        /// </p>
        pub fn offering_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_type(inp);
            self
        }
        /// <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
        /// </p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_offering_type(input);
            self
        }
        /// <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>
        /// The maximum number of records to include in the response.
        /// If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results.
        /// </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSourceRegions`.
    ///
    /// <p>Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create a read replica,
    /// copy a DB snapshot from, or replicate automated backups from. This API action supports pagination.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSourceRegions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_source_regions_input::Builder,
    }
    impl<C, M, R> DescribeSourceRegions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSourceRegions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSourceRegionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSourceRegionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSourceRegionsInputOperationOutputAlias,
                crate::output::DescribeSourceRegionsOutput,
                crate::error::DescribeSourceRegionsError,
                crate::input::DescribeSourceRegionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The source Amazon Web Services Region name. For example, <code>us-east-1</code>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid Amazon Web Services Region name.</p>
        /// </li>
        /// </ul>
        pub fn region_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_name(inp);
            self
        }
        /// <p>The source Amazon Web Services Region name. For example, <code>us-east-1</code>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must specify a valid Amazon Web Services Region name.</p>
        /// </li>
        /// </ul>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so you can retrieve the remaining results. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeSourceRegions</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeSourceRegions</code> request. If this parameter is specified, the response
        /// includes only records beyond the marker, up to the value specified by
        /// <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeValidDBInstanceModifications`.
    ///
    /// <p>You can call <code>DescribeValidDBInstanceModifications</code> to learn what modifications you can make to
    /// your DB instance. You can use this information when you call <code>ModifyDBInstance</code>.
    /// </p>
    /// <p>This command doesn't apply to RDS Custom.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeValidDBInstanceModifications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_valid_db_instance_modifications_input::Builder,
    }
    impl<C, M, R> DescribeValidDBInstanceModifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeValidDBInstanceModifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeValidDbInstanceModificationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeValidDBInstanceModificationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeValidDbInstanceModificationsInputOperationOutputAlias,
                crate::output::DescribeValidDbInstanceModificationsOutput,
                crate::error::DescribeValidDBInstanceModificationsError,
                crate::input::DescribeValidDbInstanceModificationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The customer identifier or the ARN of your DB instance.
        /// </p>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The customer identifier or the ARN of your DB instance.
        /// </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DownloadDBLogFilePortion`.
    ///
    /// <p>Downloads all or a portion of the specified log file, up to 1 MB in size.</p>
    /// <p>This command doesn't apply to RDS Custom.</p>
    #[derive(std::fmt::Debug)]
    pub struct DownloadDBLogFilePortion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::download_db_log_file_portion_input::Builder,
    }
    impl<C, M, R> DownloadDBLogFilePortion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DownloadDBLogFilePortion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DownloadDbLogFilePortionOutput,
            aws_smithy_http::result::SdkError<crate::error::DownloadDBLogFilePortionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DownloadDbLogFilePortionInputOperationOutputAlias,
                crate::output::DownloadDbLogFilePortionOutput,
                crate::error::DownloadDBLogFilePortionError,
                crate::input::DownloadDbLogFilePortionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(inp);
            self
        }
        /// <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBInstance.</p>
        /// </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The name of the log file to be downloaded.</p>
        pub fn log_file_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_file_name(inp);
            self
        }
        /// <p>The name of the log file to be downloaded.</p>
        pub fn set_log_file_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_file_name(input);
            self
        }
        /// <p>The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.</p>
        /// <p>If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning
        /// or the end of the log file, depending on the value of the Marker parameter.</p>
        /// <ul>
        /// <li>
        /// <p>If neither Marker or NumberOfLines are specified, the entire log file is returned up to a
        /// maximum of 10000 lines, starting with the most recent log entries first.</p>
        /// </li>
        /// <li>
        /// <p>If
        /// NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end
        /// of the log file are returned.</p>
        /// </li>
        /// <li>
        /// <p>If Marker is specified as "0", then the specified
        /// number of lines from the beginning of the log file are returned.</p>
        /// </li>
        /// <li>
        /// <p>You can
        /// download the log file in blocks of lines by specifying the size of the block using
        /// the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your
        /// first request. Include the Marker value returned in the response as the Marker value for the next
        /// request, continuing until the AdditionalDataPending response element returns false.</p>
        /// </li>
        /// </ul>
        pub fn number_of_lines(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_lines(inp);
            self
        }
        /// <p>The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.</p>
        /// <p>If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning
        /// or the end of the log file, depending on the value of the Marker parameter.</p>
        /// <ul>
        /// <li>
        /// <p>If neither Marker or NumberOfLines are specified, the entire log file is returned up to a
        /// maximum of 10000 lines, starting with the most recent log entries first.</p>
        /// </li>
        /// <li>
        /// <p>If
        /// NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end
        /// of the log file are returned.</p>
        /// </li>
        /// <li>
        /// <p>If Marker is specified as "0", then the specified
        /// number of lines from the beginning of the log file are returned.</p>
        /// </li>
        /// <li>
        /// <p>You can
        /// download the log file in blocks of lines by specifying the size of the block using
        /// the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your
        /// first request. Include the Marker value returned in the response as the Marker value for the next
        /// request, continuing until the AdditionalDataPending response element returns false.</p>
        /// </li>
        /// </ul>
        pub fn set_number_of_lines(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_lines(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverDBCluster`.
    ///
    /// <p>Forces a failover for a DB cluster.</p>
    /// <p>A failover for a DB cluster promotes one of the Aurora Replicas (read-only instances)
    /// in the DB cluster to be the primary instance (the cluster writer).</p>
    /// <p>Amazon Aurora will automatically fail over to an Aurora Replica, if one exists,
    /// when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing.
    /// Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing
    /// connections that use those endpoint addresses when the failover is complete.</p>
    /// <p>For more information on Amazon Aurora, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct FailoverDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::failover_db_cluster_input::Builder,
    }
    impl<C, M, R> FailoverDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FailoverDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FailoverDbClusterInputOperationOutputAlias,
                crate::output::FailoverDbClusterOutput,
                crate::error::FailoverDBClusterError,
                crate::input::FailoverDbClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A DB cluster identifier to force a failover for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>A DB cluster identifier to force a failover for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DBCluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Aurora Replica in the DB cluster.
        /// For example, <code>mydbcluster-replica1</code>.</p>
        pub fn target_db_instance_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_instance_identifier(inp);
            self
        }
        /// <p>The name of the instance to promote to the primary instance.</p>
        /// <p>You must specify the instance identifier for an Aurora Replica in the DB cluster.
        /// For example, <code>mydbcluster-replica1</code>.</p>
        pub fn set_target_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverGlobalCluster`.
    ///
    /// <p>Initiates the failover process for an Aurora global database (<a>GlobalCluster</a>).</p>
    /// <p>A failover for an Aurora global database promotes one of secondary read-only DB clusters to be
    /// the primary DB cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words,
    /// the role of the current primary DB cluster and the selected (target) DB cluster are switched. The selected
    /// secondary DB cluster assumes full read/write capabilities for the Aurora global database.</p>
    /// <p>For more information about failing over an Amazon Aurora global database, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover">Managed planned failover for Amazon Aurora global
    /// databases</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action applies to <a>GlobalCluster</a> (Aurora global databases) only. Use this action only on
    /// healthy Aurora global databases with running Aurora DB clusters and no Region-wide outages, to test disaster recovery scenarios or to
    /// reconfigure your Aurora global database topology.
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct FailoverGlobalCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::failover_global_cluster_input::Builder,
    }
    impl<C, M, R> FailoverGlobalCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FailoverGlobalCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverGlobalClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverGlobalClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FailoverGlobalClusterInputOperationOutputAlias,
                crate::output::FailoverGlobalClusterOutput,
                crate::error::FailoverGlobalClusterError,
                crate::input::FailoverGlobalClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier of the Aurora global database (<a>GlobalCluster</a>)
        /// that should be failed over. The identifier is the unique key assigned by
        /// the user when the Aurora global database was created. In other words,
        /// it's the name of the Aurora global database that you want to fail over. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing
        /// <a>GlobalCluster</a> (Aurora global database).</p>
        /// </li>
        /// </ul>
        pub fn global_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(inp);
            self
        }
        /// <p>Identifier of the Aurora global database (<a>GlobalCluster</a>)
        /// that should be failed over. The identifier is the unique key assigned by
        /// the user when the Aurora global database was created. In other words,
        /// it's the name of the Aurora global database that you want to fail over. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing
        /// <a>GlobalCluster</a> (Aurora global database).</p>
        /// </li>
        /// </ul>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// <p>Identifier of the secondary Aurora DB cluster that you want to promote to primary for the Aurora
        /// global database (<a>GlobalCluster</a>.) Use the Amazon Resource Name (ARN) for the identifier so that
        /// Aurora can locate the cluster in its Amazon Web Services Region.      
        /// </p>
        pub fn target_db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_db_cluster_identifier(inp);
            self
        }
        /// <p>Identifier of the secondary Aurora DB cluster that you want to promote to primary for the Aurora
        /// global database (<a>GlobalCluster</a>.) Use the Amazon Resource Name (ARN) for the identifier so that
        /// Aurora can locate the cluster in its Amazon Web Services Region.      
        /// </p>
        pub fn set_target_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportInstallationMedia`.
    ///
    /// <p>Imports the installation media for a DB engine that requires an on-premises
    /// customer provided license, such as SQL Server.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportInstallationMedia<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_installation_media_input::Builder,
    }
    impl<C, M, R> ImportInstallationMedia<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportInstallationMedia`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportInstallationMediaOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportInstallationMediaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportInstallationMediaInputOperationOutputAlias,
                crate::output::ImportInstallationMediaOutput,
                crate::error::ImportInstallationMediaError,
                crate::input::ImportInstallationMediaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the custom Availability Zone (AZ) to import the installation media to.</p>
        pub fn custom_availability_zone_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_availability_zone_id(inp);
            self
        }
        /// <p>The identifier of the custom Availability Zone (AZ) to import the installation media to.</p>
        pub fn set_custom_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_availability_zone_id(input);
            self
        }
        /// <p>The name of the database engine to be used for this instance.
        /// </p>
        ///
        /// <p>The list only includes supported DB engines that require an on-premises
        /// customer provided license.
        /// </p>
        ///
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The name of the database engine to be used for this instance.
        /// </p>
        ///
        /// <p>The list only includes supported DB engines that require an on-premises
        /// customer provided license.
        /// </p>
        ///
        /// <p>Valid Values:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sqlserver-ee</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-se</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-ex</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqlserver-web</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, call <a>DescribeDBEngineVersions</a>.</p>
        /// <p>The following are the database engines and links to information about the major and minor
        /// versions. The list only includes DB engines that require an on-premises
        /// customer provided license.</p>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">
        /// Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, call <a>DescribeDBEngineVersions</a>.</p>
        /// <p>The following are the database engines and links to information about the major and minor
        /// versions. The list only includes DB engines that require an on-premises
        /// customer provided license.</p>
        ///
        /// <p>
        /// <b>Microsoft SQL Server</b>
        /// </p>
        ///
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">
        /// Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i>
        /// </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The path to the installation medium for the specified DB engine.</p>
        /// <p>Example: <code>SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso</code>
        /// </p>
        pub fn engine_installation_media_path(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.engine_installation_media_path(inp);
            self
        }
        /// <p>The path to the installation medium for the specified DB engine.</p>
        /// <p>Example: <code>SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso</code>
        /// </p>
        pub fn set_engine_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_installation_media_path(input);
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the specified DB engine.</p>
        /// <p>Example: <code>WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso</code>
        /// </p>
        pub fn os_installation_media_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.os_installation_media_path(inp);
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the specified DB engine.</p>
        /// <p>Example: <code>WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso</code>
        /// </p>
        pub fn set_os_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_os_installation_media_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on an Amazon RDS resource.</p>
    /// <p>For an overview on tagging an Amazon RDS resource,
    /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a>
    /// in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon RDS resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon RDS resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about
        /// creating an ARN,
        /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">
        /// Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCertificates`.
    ///
    /// <p>Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS)
    /// certificate for Amazon RDS for new DB instances temporarily, or remove the override.</p>
    /// <p>By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB
    /// instances that is different from the default certificate provided by RDS. You can also
    /// use this operation to remove the override, so that new DB instances use the default
    /// certificate provided by RDS.</p>   
    /// <p>You might need to override the default certificate in the following situations:</p>
    /// <ul>
    /// <li>
    /// <p>You already migrated your applications to support the latest certificate authority (CA) certificate, but the new CA certificate is not yet
    /// the RDS default CA certificate for the specified Amazon Web Services Region.</p>
    /// </li>
    /// <li>
    /// <p>RDS has already moved to a new default CA certificate for the specified Amazon Web Services
    /// Region, but you are still in the process of supporting the new CA certificate.
    /// In this case, you temporarily need additional time to finish your application
    /// changes.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about rotating your SSL/TLS certificate for RDS DB engines, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
    /// Rotating Your SSL/TLS Certificate</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// <p>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
    /// Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_certificates_input::Builder,
    }
    impl<C, M, R> ModifyCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyCertificatesInputOperationOutputAlias,
                crate::output::ModifyCertificatesOutput,
                crate::error::ModifyCertificatesError,
                crate::input::ModifyCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new default certificate identifier to override the current one with.</p>
        /// <p>To determine the valid values, use the <code>describe-certificates</code> CLI
        /// command or the <code>DescribeCertificates</code> API operation.</p>
        pub fn certificate_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_identifier(inp);
            self
        }
        /// <p>The new default certificate identifier to override the current one with.</p>
        /// <p>To determine the valid values, use the <code>describe-certificates</code> CLI
        /// command or the <code>DescribeCertificates</code> API operation.</p>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_identifier(input);
            self
        }
        /// <p>A value that indicates whether to remove the override for the default certificate.
        /// If the override is removed, the default certificate is the system
        /// default.</p>
        pub fn remove_customer_override(mut self, inp: bool) -> Self {
            self.inner = self.inner.remove_customer_override(inp);
            self
        }
        /// <p>A value that indicates whether to remove the override for the default certificate.
        /// If the override is removed, the default certificate is the system
        /// default.</p>
        pub fn set_remove_customer_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remove_customer_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCurrentDBClusterCapacity`.
    ///
    /// <p>Set the capacity of an Aurora Serverless DB cluster to a specific value.</p>
    /// <p>Aurora Serverless scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might not scale
    /// fast enough to meet a sudden change in workload, such as a large number of new transactions. Call <code>ModifyCurrentDBClusterCapacity</code>
    /// to set the capacity explicitly.</p>
    /// <p>After this call sets the DB cluster capacity, Aurora Serverless can automatically scale
    /// the DB cluster based on the cooldown period for scaling up and the cooldown period
    /// for scaling down.</p>
    /// <p>For more information about Aurora Serverless, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the
    /// <i>Amazon Aurora User Guide</i>.</p>
    /// <important>
    /// <p>If you call <code>ModifyCurrentDBClusterCapacity</code> with the default <code>TimeoutAction</code>, connections that
    /// prevent Aurora Serverless from finding a scaling point might be dropped. For more information about scaling points,
    /// see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling">
    /// Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// </important>
    /// <note>
    /// <p>This action only applies to Aurora Serverless DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ModifyCurrentDBClusterCapacity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_current_db_cluster_capacity_input::Builder,
    }
    impl<C, M, R> ModifyCurrentDBClusterCapacity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyCurrentDBClusterCapacity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyCurrentDbClusterCapacityOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyCurrentDBClusterCapacityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyCurrentDbClusterCapacityInputOperationOutputAlias,
                crate::output::ModifyCurrentDbClusterCapacityOutput,
                crate::error::ModifyCurrentDBClusterCapacityError,
                crate::input::ModifyCurrentDbClusterCapacityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DB cluster.</p>
        /// </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(inp);
            self
        }
        /// <p>The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must match the identifier of an existing DB cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The DB cluster capacity.</p>
        /// <p>When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
        /// </li>
        /// <li>
        /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
        /// </li>
        /// </ul>
        pub fn capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.capacity(inp);
            self
        }
        /// <p>The DB cluster capacity.</p>
        /// <p>When you change the capacity of a paused Aurora Serverless DB cluster, it automatically resumes.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
        /// </li>
        /// <li>
        /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_capacity(input);
            self
        }
        /// <p>The amount of time, in seconds, that Aurora Serverless tries to find a scaling point
        /// to perform seamless scaling before enforcing the timeout action. The default is
        /// 300.</p>
        /// <p>Specify a value between 10 and 600 seconds.</p>
        pub fn seconds_before_timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.seconds_before_timeout(inp);
            self
        }
        /// <p>The amount of time, in seconds, that Aurora Serverless tries to find a scaling point
        /// to perform seamless scaling before enforcing the timeout action. The default is
        /// 300.</p>
        /// <p>Specify a value between 10 and 600 seconds.</p>
        pub fn set_seconds_before_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_seconds_before_timeout(input);
            self
        }
        /// <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        /// <p>
        /// <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p>
        /// <p>
        /// <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
        pub fn timeout_action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timeout_action(inp);
            self
        }
        /// <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        /// <p>
        /// <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p>
        /// <p>
        /// <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
        pub fn set_timeout_action(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_timeout_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCustomDBEngineVersion`.
    ///
    /// <p>Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling
    /// <code>DescribeDBEngineVersions</code>.</p>
    /// <note>
    /// <p>The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
    /// Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
    /// <code>ModifyCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the
    /// API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
    /// the <code>ModifyCustomDbEngineVersion</code> event.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">Modifying CEV status</a>
    /// in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyCustomDBEngineVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_custom_db_engine_version_input::Builder,
    }
    impl<C, M, R> ModifyCustomDBEngineVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyCustomDBEngineVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyCustomDbEngineVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyCustomDBEngineVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyCustomDbEngineVersionInputOperationOutputAlias,
                crate::output::ModifyCustomDbEngineVersionOutput,
                crate::error::ModifyCustomDBEngineVersionError,
                crate::input::ModifyCustomDbEngineVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB engine. The only supported value is <code>custom-oracle-ee</code>.</p>
        pub fn engine(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(inp);
            self
        }
        /// <p>The DB engine. The only supported value is <code>custom-oracle-ee</code>.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The custom engine version (CEV) that you want to modify. This option is required for
        /// RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and
        /// <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The custom engine version (CEV) that you want to modify. This option is required for
        /// RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and
        /// <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The availability status to be assigned to the CEV. Valid values are as follows:</p>
        /// <dl>
        /// <dt>available</dt>
        /// <dd>
        /// <p>You can use this CEV to create a new RDS Custom DB instance.</p>
        /// </dd>
        /// <dt>inactive</dt>
        /// <dd>
        /// <p>You can create a new RDS Custom instance by restoring a DB snapshot with this CEV.
        /// You can't patch or create new instances with this CEV.</p>
        /// </dd>
        /// </dl>
        /// <p>You can change any status to any status. A typical reason to change status is to prevent the accidental
        /// use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status
        /// of your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to
        /// <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an
        /// RDS Custom instance, snapshot, or automated backup.
        /// </p>
        pub fn status(mut self, inp: crate::model::CustomEngineVersionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The availability status to be assigned to the CEV. Valid values are as follows:</p>
        /// <dl>
        /// <dt>available</dt>
        /// <dd>
        /// <p>You can use this CEV to create a new RDS Custom DB instance.</p>
        /// </dd>
        /// <dt>inactive</dt>
        /// <dd>
        /// <p>You can create a new RDS Custom instance by restoring a DB snapshot with this CEV.
        /// You can't patch or create new instances with this CEV.</p>
        /// </dd>
        /// </dl>
        /// <p>You can change any status to any status. A typical reason to change status is to prevent the accidental
        /// use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status
        /// of your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to
        /// <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an
        /// RDS Custom instance, snapshot, or automated backup.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CustomEngineVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDBCluster`.
    ///
    /// <p>Modify a setting for an Amazon Aurora DB cluster.
    /// You can change one
    /// or more database configuration parameters by specifying these parameters and the new values in the
    /// request. For more information on Amazon Aurora, see
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
    /// What Is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i>
    /// </p>
    /// <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDBCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_db_cluster_input::Builder,
    }
    impl<C, M, R> ModifyDBCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is conf