// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleOutput {
    /// <p>The unique ID of the retention rule.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>The retention rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The resource type retained by the retention rule.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Information about the resource tags used to identify resources that are retained by the retention
    /// rule.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
    pub status: std::option::Option<crate::model::RuleStatus>,
}
impl UpdateRuleOutput {
    /// <p>The unique ID of the retention rule.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>The retention rule description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The resource type retained by the retention rule.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Information about the resource tags used to identify resources that are retained by the retention
    /// rule.</p>
    pub fn resource_tags(&self) -> std::option::Option<&[crate::model::ResourceTag]> {
        self.resource_tags.as_deref()
    }
    /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RuleStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for UpdateRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleOutput");
        formatter.field("identifier", &self.identifier);
        formatter.field("retention_period", &self.retention_period);
        formatter.field("description", &self.description);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
pub mod update_rule_output {
    /// A builder for [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        pub(crate) status: std::option::Option<crate::model::RuleStatus>,
    }
    impl Builder {
        /// <p>The unique ID of the retention rule.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The unique ID of the retention rule.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>The retention rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The retention rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The resource type retained by the retention rule.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type retained by the retention rule.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>Information about the resource tags used to identify resources that are retained by the retention
        /// rule.</p>
        pub fn resource_tags(mut self, input: impl Into<crate::model::ResourceTag>) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input.into());
            self.resource_tags = Some(v);
            self
        }
        /// <p>Information about the resource tags used to identify resources that are retained by the retention
        /// rule.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
        pub fn status(mut self, input: crate::model::RuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::RuleStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
        pub fn build(self) -> crate::output::UpdateRuleOutput {
            crate::output::UpdateRuleOutput {
                identifier: self.identifier,
                retention_period: self.retention_period,
                description: self.description,
                resource_type: self.resource_type,
                resource_tags: self.resource_tags,
                status: self.status,
            }
        }
    }
}
impl UpdateRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
    pub fn builder() -> crate::output::update_rule_output::Builder {
        crate::output::update_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Information about the tags assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>Information about the tags assigned to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Information about the tags assigned to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Information about the tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesOutput {
    /// <p>Information about the retention rules.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRulesOutput {
    /// <p>Information about the retention rules.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::RuleSummary]> {
        self.rules.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesOutput");
        formatter.field("rules", &self.rules);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRulesOutput`](crate::output::ListRulesOutput)
pub mod list_rules_output {
    /// A builder for [`ListRulesOutput`](crate::output::ListRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Information about the retention rules.</p>
        pub fn rules(mut self, input: impl Into<crate::model::RuleSummary>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Information about the retention rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesOutput`](crate::output::ListRulesOutput)
        pub fn build(self) -> crate::output::ListRulesOutput {
            crate::output::ListRulesOutput {
                rules: self.rules,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListRulesOutput`](crate::output::ListRulesOutput)
    pub fn builder() -> crate::output::list_rules_output::Builder {
        crate::output::list_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRuleOutput {
    /// <p>The unique ID of the retention rule.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The description assigned to the retention rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The resource type retained by the retention rule. Currently, only Amazon EBS snapshots are supported.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Information about the period for which the retention rule retains resources.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>The resource tags used to identify resources that are to be retained by the retention rule.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
    pub status: std::option::Option<crate::model::RuleStatus>,
}
impl GetRuleOutput {
    /// <p>The unique ID of the retention rule.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The description assigned to the retention rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The resource type retained by the retention rule. Currently, only Amazon EBS snapshots are supported.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Information about the period for which the retention rule retains resources.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>The resource tags used to identify resources that are to be retained by the retention rule.</p>
    pub fn resource_tags(&self) -> std::option::Option<&[crate::model::ResourceTag]> {
        self.resource_tags.as_deref()
    }
    /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RuleStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRuleOutput");
        formatter.field("identifier", &self.identifier);
        formatter.field("description", &self.description);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("retention_period", &self.retention_period);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetRuleOutput`](crate::output::GetRuleOutput)
pub mod get_rule_output {
    /// A builder for [`GetRuleOutput`](crate::output::GetRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        pub(crate) status: std::option::Option<crate::model::RuleStatus>,
    }
    impl Builder {
        /// <p>The unique ID of the retention rule.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The unique ID of the retention rule.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The description assigned to the retention rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description assigned to the retention rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The resource type retained by the retention rule. Currently, only Amazon EBS snapshots are supported.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type retained by the retention rule. Currently, only Amazon EBS snapshots are supported.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Information about the period for which the retention rule retains resources.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>Information about the period for which the retention rule retains resources.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The resource tags used to identify resources that are to be retained by the retention rule.</p>
        pub fn resource_tags(mut self, input: impl Into<crate::model::ResourceTag>) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input.into());
            self.resource_tags = Some(v);
            self
        }
        /// <p>The resource tags used to identify resources that are to be retained by the retention rule.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
        pub fn status(mut self, input: crate::model::RuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::RuleStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRuleOutput`](crate::output::GetRuleOutput)
        pub fn build(self) -> crate::output::GetRuleOutput {
            crate::output::GetRuleOutput {
                identifier: self.identifier,
                description: self.description,
                resource_type: self.resource_type,
                retention_period: self.retention_period,
                resource_tags: self.resource_tags,
                status: self.status,
            }
        }
    }
}
impl GetRuleOutput {
    /// Creates a new builder-style object to manufacture [`GetRuleOutput`](crate::output::GetRuleOutput)
    pub fn builder() -> crate::output::get_rule_output::Builder {
        crate::output::get_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleOutput {}
impl std::fmt::Debug for DeleteRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
pub mod delete_rule_output {
    /// A builder for [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
        pub fn build(self) -> crate::output::DeleteRuleOutput {
            crate::output::DeleteRuleOutput {}
        }
    }
}
impl DeleteRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    pub fn builder() -> crate::output::delete_rule_output::Builder {
        crate::output::delete_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleOutput {
    /// <p>The unique identifier of the retention rule.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>The retention rule description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags assigned to the retention rule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The resource type retained by the retention rule.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Information about the resource tags used to identify resources that are retained by the retention
    /// rule.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
    /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
    pub status: std::option::Option<crate::model::RuleStatus>,
}
impl CreateRuleOutput {
    /// <p>The unique identifier of the retention rule.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>The retention rule description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags assigned to the retention rule.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The resource type retained by the retention rule.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Information about the resource tags used to identify resources that are retained by the retention
    /// rule.</p>
    pub fn resource_tags(&self) -> std::option::Option<&[crate::model::ResourceTag]> {
        self.resource_tags.as_deref()
    }
    /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RuleStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CreateRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleOutput");
        formatter.field("identifier", &self.identifier);
        formatter.field("retention_period", &self.retention_period);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateRuleOutput`](crate::output::CreateRuleOutput)
pub mod create_rule_output {
    /// A builder for [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        pub(crate) status: std::option::Option<crate::model::RuleStatus>,
    }
    impl Builder {
        /// <p>The unique identifier of the retention rule.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the retention rule.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>Information about the retention period for which a retention rule is to retain resources.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>The retention rule description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The retention rule description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the retention rule.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags assigned to the retention rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The resource type retained by the retention rule.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type retained by the retention rule.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>Information about the resource tags used to identify resources that are retained by the retention
        /// rule.</p>
        pub fn resource_tags(mut self, input: impl Into<crate::model::ResourceTag>) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input.into());
            self.resource_tags = Some(v);
            self
        }
        /// <p>Information about the resource tags used to identify resources that are retained by the retention
        /// rule.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTag>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
        pub fn status(mut self, input: crate::model::RuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::RuleStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleOutput`](crate::output::CreateRuleOutput)
        pub fn build(self) -> crate::output::CreateRuleOutput {
            crate::output::CreateRuleOutput {
                identifier: self.identifier,
                retention_period: self.retention_period,
                description: self.description,
                tags: self.tags,
                resource_type: self.resource_type,
                resource_tags: self.resource_tags,
                status: self.status,
            }
        }
    }
}
impl CreateRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    pub fn builder() -> crate::output::create_rule_output::Builder {
        crate::output::create_rule_output::Builder::default()
    }
}
