// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Resource Access Manager
///
/// Client for invoking operations on AWS Resource Access Manager. Each operation on AWS Resource Access Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ram::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ram::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ram::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptResourceShareInvitation`](crate::client::fluent_builders::AcceptResourceShareInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_invitation_arn(impl Into<String>)`](crate::client::fluent_builders::AcceptResourceShareInvitation::resource_share_invitation_arn) / [`set_resource_share_invitation_arn(Option<String>)`](crate::client::fluent_builders::AcceptResourceShareInvitation::set_resource_share_invitation_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to accept.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AcceptResourceShareInvitation::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AcceptResourceShareInvitation::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    /// - On success, responds with [`AcceptResourceShareInvitationOutput`](crate::output::AcceptResourceShareInvitationOutput) with field(s):
    ///   - [`resource_share_invitation(Option<ResourceShareInvitation>)`](crate::output::AcceptResourceShareInvitationOutput::resource_share_invitation): <p>An object that contains information about the specified invitation.</p>
    ///   - [`client_token(Option<String>)`](crate::output::AcceptResourceShareInvitationOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<AcceptResourceShareInvitationError>`](crate::error::AcceptResourceShareInvitationError)
    pub fn accept_resource_share_invitation(
        &self,
    ) -> fluent_builders::AcceptResourceShareInvitation {
        fluent_builders::AcceptResourceShareInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateResourceShare`](crate::client::fluent_builders::AssociateResourceShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateResourceShare::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::AssociateResourceShare::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add principals or resources to.</p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::AssociateResourceShare::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateResourceShare::set_resource_arns): <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources that you want to share. This can be <code>null</code> if you want to add only principals.</p>
    ///   - [`principals(Vec<String>)`](crate::client::fluent_builders::AssociateResourceShare::principals) / [`set_principals(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateResourceShare::set_principals): <p>Specifies a list of principals to whom you want to the resource share. This can be <code>null</code> if you want to add only resources.</p>  <p>What the principals can do with the resources in the share is determined by the RAM permissions that you associate with the resource share. See <code>AssociateResourceSharePermission</code>.</p>  <p>You can include the following values:</p>  <ul>   <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>   <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>   <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>   <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>   <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>  </ul> <note>   <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>  </note>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateResourceShare::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateResourceShare::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    /// - On success, responds with [`AssociateResourceShareOutput`](crate::output::AssociateResourceShareOutput) with field(s):
    ///   - [`resource_share_associations(Option<Vec<ResourceShareAssociation>>)`](crate::output::AssociateResourceShareOutput::resource_share_associations): <p>An array of objects that contain information about the associations.</p>
    ///   - [`client_token(Option<String>)`](crate::output::AssociateResourceShareOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<AssociateResourceShareError>`](crate::error::AssociateResourceShareError)
    pub fn associate_resource_share(&self) -> fluent_builders::AssociateResourceShare {
        fluent_builders::AssociateResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateResourceSharePermission`](crate::client::fluent_builders::AssociateResourceSharePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateResourceSharePermission::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::AssociateResourceSharePermission::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to which you want to add or replace permissions.</p>
    ///   - [`permission_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateResourceSharePermission::permission_arn) / [`set_permission_arn(Option<String>)`](crate::client::fluent_builders::AssociateResourceSharePermission::set_permission_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission to associate with the resource share. To find the ARN for a permission, use either the <code>ListPermissions</code> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>
    ///   - [`replace(bool)`](crate::client::fluent_builders::AssociateResourceSharePermission::replace) / [`set_replace(Option<bool>)`](crate::client::fluent_builders::AssociateResourceSharePermission::set_replace): <p>Specifies whether the specified permission should replace or add to the existing permission associated with the resource share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to add the permission to the current permission. The default value is <code>false</code>.</p> <note>   <p>A resource share can have only one permission per resource type. If a resource share already has a permission for the specified resource type and you don't set <code>replace</code> to <code>true</code> then the operation returns an error. This helps prevent accidental overwriting of a permission.</p>  </note>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateResourceSharePermission::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateResourceSharePermission::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    ///   - [`permission_version(i32)`](crate::client::fluent_builders::AssociateResourceSharePermission::permission_version) / [`set_permission_version(Option<i32>)`](crate::client::fluent_builders::AssociateResourceSharePermission::set_permission_version): <p>Specifies the version of the RAM permission to associate with the resource share. If you don't specify this parameter, the operation uses the version designated as the default. You can use the <code>ListPermissionVersions</code> operation to discover the available versions of a permission.</p>
    /// - On success, responds with [`AssociateResourceSharePermissionOutput`](crate::output::AssociateResourceSharePermissionOutput) with field(s):
    ///   - [`return_value(Option<bool>)`](crate::output::AssociateResourceSharePermissionOutput::return_value): <p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>
    ///   - [`client_token(Option<String>)`](crate::output::AssociateResourceSharePermissionOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<AssociateResourceSharePermissionError>`](crate::error::AssociateResourceSharePermissionError)
    pub fn associate_resource_share_permission(
        &self,
    ) -> fluent_builders::AssociateResourceSharePermission {
        fluent_builders::AssociateResourceSharePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourceShare`](crate::client::fluent_builders::CreateResourceShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateResourceShare::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateResourceShare::set_name): <p>Specifies the name of the resource share.</p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::CreateResourceShare::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateResourceShare::set_resource_arns): <p>Specifies a list of one or more ARNs of the resources to associate with the resource share.</p>
    ///   - [`principals(Vec<String>)`](crate::client::fluent_builders::CreateResourceShare::principals) / [`set_principals(Option<Vec<String>>)`](crate::client::fluent_builders::CreateResourceShare::set_principals): <p>Specifies a list of one or more principals to associate with the resource share.</p>  <p>You can include the following values:</p>  <ul>   <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>   <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>   <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>   <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>   <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>  </ul> <note>   <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateResourceShare::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateResourceShare::set_tags): <p>Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.</p>
    ///   - [`allow_external_principals(bool)`](crate::client::fluent_builders::CreateResourceShare::allow_external_principals) / [`set_allow_external_principals(Option<bool>)`](crate::client::fluent_builders::CreateResourceShare::set_allow_external_principals): <p>Specifies whether principals outside your organization in Organizations can be associated with a resource share. A value of <code>true</code> lets you share with individual Amazon Web Services accounts that are <i>not</i> in your organization. A value of <code>false</code> only has meaning if your account is a member of an Amazon Web Services Organization. The default value is <code>true</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateResourceShare::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateResourceShare::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    ///   - [`permission_arns(Vec<String>)`](crate::client::fluent_builders::CreateResourceShare::permission_arns) / [`set_permission_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateResourceShare::set_permission_arns): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.</p>
    /// - On success, responds with [`CreateResourceShareOutput`](crate::output::CreateResourceShareOutput) with field(s):
    ///   - [`resource_share(Option<ResourceShare>)`](crate::output::CreateResourceShareOutput::resource_share): <p>An object with information about the new resource share.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateResourceShareOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<CreateResourceShareError>`](crate::error::CreateResourceShareError)
    pub fn create_resource_share(&self) -> fluent_builders::CreateResourceShare {
        fluent_builders::CreateResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourceShare`](crate::client::fluent_builders::DeleteResourceShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceShare::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::DeleteResourceShare::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceShare::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteResourceShare::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    /// - On success, responds with [`DeleteResourceShareOutput`](crate::output::DeleteResourceShareOutput) with field(s):
    ///   - [`return_value(Option<bool>)`](crate::output::DeleteResourceShareOutput::return_value): <p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>
    ///   - [`client_token(Option<String>)`](crate::output::DeleteResourceShareOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<DeleteResourceShareError>`](crate::error::DeleteResourceShareError)
    pub fn delete_resource_share(&self) -> fluent_builders::DeleteResourceShare {
        fluent_builders::DeleteResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateResourceShare`](crate::client::fluent_builders::DisassociateResourceShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateResourceShare::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::DisassociateResourceShare::set_resource_share_arn): <p>Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove resources from.</p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::DisassociateResourceShare::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateResourceShare::set_resource_arns): <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> for one or more resources that you want to remove from the resource share. After the operation runs, these resources are no longer shared with principals outside of the Amazon Web Services account that created the resources.</p>
    ///   - [`principals(Vec<String>)`](crate::client::fluent_builders::DisassociateResourceShare::principals) / [`set_principals(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateResourceShare::set_principals): <p>Specifies a list of one or more principals that no longer are to have access to the resources in this resource share.</p>  <p>You can include the following values:</p>  <ul>   <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>   <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>   <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>   <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>   <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>  </ul> <note>   <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>  </note>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateResourceShare::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DisassociateResourceShare::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    /// - On success, responds with [`DisassociateResourceShareOutput`](crate::output::DisassociateResourceShareOutput) with field(s):
    ///   - [`resource_share_associations(Option<Vec<ResourceShareAssociation>>)`](crate::output::DisassociateResourceShareOutput::resource_share_associations): <p>An array of objects that contain information about the updated associations for this resource share.</p>
    ///   - [`client_token(Option<String>)`](crate::output::DisassociateResourceShareOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<DisassociateResourceShareError>`](crate::error::DisassociateResourceShareError)
    pub fn disassociate_resource_share(&self) -> fluent_builders::DisassociateResourceShare {
        fluent_builders::DisassociateResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateResourceSharePermission`](crate::client::fluent_builders::DisassociateResourceSharePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateResourceSharePermission::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::DisassociateResourceSharePermission::set_resource_share_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share from which you want to disassociate a permission.</p>
    ///   - [`permission_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateResourceSharePermission::permission_arn) / [`set_permission_arn(Option<String>)`](crate::client::fluent_builders::DisassociateResourceSharePermission::set_permission_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission to disassociate from the resource share. Changes to permissions take effect immediately.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateResourceSharePermission::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DisassociateResourceSharePermission::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    /// - On success, responds with [`DisassociateResourceSharePermissionOutput`](crate::output::DisassociateResourceSharePermissionOutput) with field(s):
    ///   - [`return_value(Option<bool>)`](crate::output::DisassociateResourceSharePermissionOutput::return_value): <p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>
    ///   - [`client_token(Option<String>)`](crate::output::DisassociateResourceSharePermissionOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<DisassociateResourceSharePermissionError>`](crate::error::DisassociateResourceSharePermissionError)
    pub fn disassociate_resource_share_permission(
        &self,
    ) -> fluent_builders::DisassociateResourceSharePermission {
        fluent_builders::DisassociateResourceSharePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableSharingWithAwsOrganization`](crate::client::fluent_builders::EnableSharingWithAwsOrganization) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::EnableSharingWithAwsOrganization::send) it.

    /// - On success, responds with [`EnableSharingWithAwsOrganizationOutput`](crate::output::EnableSharingWithAwsOrganizationOutput) with field(s):
    ///   - [`return_value(Option<bool>)`](crate::output::EnableSharingWithAwsOrganizationOutput::return_value): <p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>
    /// - On failure, responds with [`SdkError<EnableSharingWithAwsOrganizationError>`](crate::error::EnableSharingWithAwsOrganizationError)
    pub fn enable_sharing_with_aws_organization(
        &self,
    ) -> fluent_builders::EnableSharingWithAwsOrganization {
        fluent_builders::EnableSharingWithAwsOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPermission`](crate::client::fluent_builders::GetPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`permission_arn(impl Into<String>)`](crate::client::fluent_builders::GetPermission::permission_arn) / [`set_permission_arn(Option<String>)`](crate::client::fluent_builders::GetPermission::set_permission_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission whose contents you want to retrieve. To find the ARN for a permission, use either the <code>ListPermissions</code> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>
    ///   - [`permission_version(i32)`](crate::client::fluent_builders::GetPermission::permission_version) / [`set_permission_version(Option<i32>)`](crate::client::fluent_builders::GetPermission::set_permission_version): <p>Specifies identifier for the version of the RAM permission to retrieve. If you don't specify this parameter, the operation retrieves the default version.</p>
    /// - On success, responds with [`GetPermissionOutput`](crate::output::GetPermissionOutput) with field(s):
    ///   - [`permission(Option<ResourceSharePermissionDetail>)`](crate::output::GetPermissionOutput::permission): <p>An object that contains information about the permission.</p>
    /// - On failure, responds with [`SdkError<GetPermissionError>`](crate::error::GetPermissionError)
    pub fn get_permission(&self) -> fluent_builders::GetPermission {
        fluent_builders::GetPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourcePolicies`](crate::client::fluent_builders::GetResourcePolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetResourcePolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::GetResourcePolicies::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetResourcePolicies::set_resource_arns): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources whose policies you want to retrieve.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::GetResourcePolicies::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::GetResourcePolicies::set_principal): <p>Specifies the principal.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetResourcePolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetResourcePolicies::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetResourcePolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetResourcePolicies::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput) with field(s):
    ///   - [`policies(Option<Vec<String>>)`](crate::output::GetResourcePoliciesOutput::policies): <p>An array of resource policy documents in JSON format.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetResourcePoliciesOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<GetResourcePoliciesError>`](crate::error::GetResourcePoliciesError)
    pub fn get_resource_policies(&self) -> fluent_builders::GetResourcePolicies {
        fluent_builders::GetResourcePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceShareAssociations`](crate::client::fluent_builders::GetResourceShareAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetResourceShareAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_type(ResourceShareAssociationType)`](crate::client::fluent_builders::GetResourceShareAssociations::association_type) / [`set_association_type(Option<ResourceShareAssociationType>)`](crate::client::fluent_builders::GetResourceShareAssociations::set_association_type): <p>Specifies whether you want to retrieve the associations that involve a specified resource or principal.</p>  <ul>   <li> <p> <code>PRINCIPAL</code> – list the principals that are associated with the specified resource share.</p> </li>   <li> <p> <code>RESOURCE</code> – list the resources that are associated with the specified resource share.</p> </li>  </ul>
    ///   - [`resource_share_arns(Vec<String>)`](crate::client::fluent_builders::GetResourceShareAssociations::resource_share_arns) / [`set_resource_share_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetResourceShareAssociations::set_resource_share_arns): <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share whose associations you want to retrieve.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetResourceShareAssociations::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetResourceShareAssociations::set_resource_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource whose resource shares you want to retrieve.</p>  <p>You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::GetResourceShareAssociations::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::GetResourceShareAssociations::set_principal): <p>Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon Web Services account ID, an organization ID, an organizational unit ID, or the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an individual IAM user or role.</p>  <p>You cannot specify this parameter if the association type is <code>RESOURCE</code>.</p>
    ///   - [`association_status(ResourceShareAssociationStatus)`](crate::client::fluent_builders::GetResourceShareAssociations::association_status) / [`set_association_status(Option<ResourceShareAssociationStatus>)`](crate::client::fluent_builders::GetResourceShareAssociations::set_association_status): <p>Specifies that you want to retrieve only associations with this status.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetResourceShareAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetResourceShareAssociations::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetResourceShareAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetResourceShareAssociations::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`GetResourceShareAssociationsOutput`](crate::output::GetResourceShareAssociationsOutput) with field(s):
    ///   - [`resource_share_associations(Option<Vec<ResourceShareAssociation>>)`](crate::output::GetResourceShareAssociationsOutput::resource_share_associations): <p>An array of objects that contain the details about the associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetResourceShareAssociationsOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<GetResourceShareAssociationsError>`](crate::error::GetResourceShareAssociationsError)
    pub fn get_resource_share_associations(&self) -> fluent_builders::GetResourceShareAssociations {
        fluent_builders::GetResourceShareAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceShareInvitations`](crate::client::fluent_builders::GetResourceShareInvitations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetResourceShareInvitations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_invitation_arns(Vec<String>)`](crate::client::fluent_builders::GetResourceShareInvitations::resource_share_invitation_arns) / [`set_resource_share_invitation_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetResourceShareInvitations::set_resource_share_invitation_arns): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share invitations you want information about.</p>
    ///   - [`resource_share_arns(Vec<String>)`](crate::client::fluent_builders::GetResourceShareInvitations::resource_share_arns) / [`set_resource_share_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetResourceShareInvitations::set_resource_share_arns): <p>Specifies that you want details about invitations only for the resource shares described by this list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetResourceShareInvitations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetResourceShareInvitations::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetResourceShareInvitations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetResourceShareInvitations::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`GetResourceShareInvitationsOutput`](crate::output::GetResourceShareInvitationsOutput) with field(s):
    ///   - [`resource_share_invitations(Option<Vec<ResourceShareInvitation>>)`](crate::output::GetResourceShareInvitationsOutput::resource_share_invitations): <p>An array of objects that contain the details about the invitations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetResourceShareInvitationsOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<GetResourceShareInvitationsError>`](crate::error::GetResourceShareInvitationsError)
    pub fn get_resource_share_invitations(&self) -> fluent_builders::GetResourceShareInvitations {
        fluent_builders::GetResourceShareInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceShares`](crate::client::fluent_builders::GetResourceShares) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetResourceShares::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arns(Vec<String>)`](crate::client::fluent_builders::GetResourceShares::resource_share_arns) / [`set_resource_share_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GetResourceShares::set_resource_share_arns): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of individual resource shares that you want information about.</p>
    ///   - [`resource_share_status(ResourceShareStatus)`](crate::client::fluent_builders::GetResourceShares::resource_share_status) / [`set_resource_share_status(Option<ResourceShareStatus>)`](crate::client::fluent_builders::GetResourceShares::set_resource_share_status): <p>Specifies that you want to retrieve details of only those resource shares that have this status.</p>
    ///   - [`resource_owner(ResourceOwner)`](crate::client::fluent_builders::GetResourceShares::resource_owner) / [`set_resource_owner(Option<ResourceOwner>)`](crate::client::fluent_builders::GetResourceShares::set_resource_owner): <p>Specifies that you want to retrieve details of only those resource shares that match the following:</p>  <ul>   <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>   <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>  </ul>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetResourceShares::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetResourceShares::set_name): <p>Specifies the name of an individual resource share that you want to retrieve details about.</p>
    ///   - [`tag_filters(Vec<TagFilter>)`](crate::client::fluent_builders::GetResourceShares::tag_filters) / [`set_tag_filters(Option<Vec<TagFilter>>)`](crate::client::fluent_builders::GetResourceShares::set_tag_filters): <p>Specifies that you want to retrieve details of only those resource shares that match the specified tag keys and values.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetResourceShares::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetResourceShares::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetResourceShares::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetResourceShares::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    ///   - [`permission_arn(impl Into<String>)`](crate::client::fluent_builders::GetResourceShares::permission_arn) / [`set_permission_arn(Option<String>)`](crate::client::fluent_builders::GetResourceShares::set_permission_arn): <p>Specifies that you want to retrieve details of only those resource shares that use the RAM permission with this <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>
    /// - On success, responds with [`GetResourceSharesOutput`](crate::output::GetResourceSharesOutput) with field(s):
    ///   - [`resource_shares(Option<Vec<ResourceShare>>)`](crate::output::GetResourceSharesOutput::resource_shares): <p>An array of objects that contain the information about the resource shares.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetResourceSharesOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<GetResourceSharesError>`](crate::error::GetResourceSharesError)
    pub fn get_resource_shares(&self) -> fluent_builders::GetResourceShares {
        fluent_builders::GetResourceShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPendingInvitationResources`](crate::client::fluent_builders::ListPendingInvitationResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPendingInvitationResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_invitation_arn(impl Into<String>)`](crate::client::fluent_builders::ListPendingInvitationResources::resource_share_invitation_arn) / [`set_resource_share_invitation_arn(Option<String>)`](crate::client::fluent_builders::ListPendingInvitationResources::set_resource_share_invitation_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation. You can use <code>GetResourceShareInvitations</code> to find the ARN of the invitation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPendingInvitationResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPendingInvitationResources::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPendingInvitationResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPendingInvitationResources::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    ///   - [`resource_region_scope(ResourceRegionScopeFilter)`](crate::client::fluent_builders::ListPendingInvitationResources::resource_region_scope) / [`set_resource_region_scope(Option<ResourceRegionScopeFilter>)`](crate::client::fluent_builders::ListPendingInvitationResources::set_resource_region_scope): <p>Specifies that you want the results to include only resources that have the specified scope.</p>  <ul>   <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>   <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>   <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>  </ul>  <p>The default value is <code>ALL</code>.</p>
    /// - On success, responds with [`ListPendingInvitationResourcesOutput`](crate::output::ListPendingInvitationResourcesOutput) with field(s):
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::ListPendingInvitationResourcesOutput::resources): <p>An array of objects that contain the information about the resources included the specified resource share.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPendingInvitationResourcesOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<ListPendingInvitationResourcesError>`](crate::error::ListPendingInvitationResourcesError)
    pub fn list_pending_invitation_resources(
        &self,
    ) -> fluent_builders::ListPendingInvitationResources {
        fluent_builders::ListPendingInvitationResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissions`](crate::client::fluent_builders::ListPermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_resource_type): <p>Specifies that you want to list permissions for only the specified resource type. For example, to list only permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>. You can use the <code>ListResourceTypes</code> operation to get the specific string required.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissions::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListPermissionsOutput`](crate::output::ListPermissionsOutput) with field(s):
    ///   - [`permissions(Option<Vec<ResourceSharePermissionSummary>>)`](crate::output::ListPermissionsOutput::permissions): <p>An array of objects with information about the permissions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionsOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<ListPermissionsError>`](crate::error::ListPermissionsError)
    pub fn list_permissions(&self) -> fluent_builders::ListPermissions {
        fluent_builders::ListPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissionVersions`](crate::client::fluent_builders::ListPermissionVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissionVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`permission_arn(impl Into<String>)`](crate::client::fluent_builders::ListPermissionVersions::permission_arn) / [`set_permission_arn(Option<String>)`](crate::client::fluent_builders::ListPermissionVersions::set_permission_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission whose versions you want to list. You can use the <code>permissionVersion</code> parameter on the <code>AssociateResourceSharePermission</code> operation to specify a non-default version to attach.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissionVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissionVersions::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissionVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissionVersions::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListPermissionVersionsOutput`](crate::output::ListPermissionVersionsOutput) with field(s):
    ///   - [`permissions(Option<Vec<ResourceSharePermissionSummary>>)`](crate::output::ListPermissionVersionsOutput::permissions): <p>An array of objects that contain details for each of the available versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionVersionsOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<ListPermissionVersionsError>`](crate::error::ListPermissionVersionsError)
    pub fn list_permission_versions(&self) -> fluent_builders::ListPermissionVersions {
        fluent_builders::ListPermissionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPrincipals`](crate::client::fluent_builders::ListPrincipals) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPrincipals::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_owner(ResourceOwner)`](crate::client::fluent_builders::ListPrincipals::resource_owner) / [`set_resource_owner(Option<ResourceOwner>)`](crate::client::fluent_builders::ListPrincipals::set_resource_owner): <p>Specifies that you want to list information for only resource shares that match the following:</p>  <ul>   <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>   <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>  </ul>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListPrincipals::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListPrincipals::set_resource_arn): <p>Specifies that you want to list principal information for the resource share with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>
    ///   - [`principals(Vec<String>)`](crate::client::fluent_builders::ListPrincipals::principals) / [`set_principals(Option<Vec<String>>)`](crate::client::fluent_builders::ListPrincipals::set_principals): <p>Specifies that you want to list information for only the listed principals.</p>  <p>You can include the following values:</p>  <ul>   <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>   <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>   <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>   <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>   <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>  </ul> <note>   <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>  </note>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::ListPrincipals::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::ListPrincipals::set_resource_type): <p>Specifies that you want to list information for only principals associated with resource shares that include the specified resource type.</p>  <p>For a list of valid values, query the <code>ListResourceTypes</code> operation.</p>
    ///   - [`resource_share_arns(Vec<String>)`](crate::client::fluent_builders::ListPrincipals::resource_share_arns) / [`set_resource_share_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListPrincipals::set_resource_share_arns): <p>Specifies that you want to list information for only principals associated with the resource shares specified by a list the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPrincipals::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPrincipals::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPrincipals::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPrincipals::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListPrincipalsOutput`](crate::output::ListPrincipalsOutput) with field(s):
    ///   - [`principals(Option<Vec<Principal>>)`](crate::output::ListPrincipalsOutput::principals): <p>An array of objects that contain the details about the principals.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPrincipalsOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<ListPrincipalsError>`](crate::error::ListPrincipalsError)
    pub fn list_principals(&self) -> fluent_builders::ListPrincipals {
        fluent_builders::ListPrincipals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResources`](crate::client::fluent_builders::ListResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_owner(ResourceOwner)`](crate::client::fluent_builders::ListResources::resource_owner) / [`set_resource_owner(Option<ResourceOwner>)`](crate::client::fluent_builders::ListResources::set_resource_owner): <p>Specifies that you want to list only the resource shares that match the following:</p>  <ul>   <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>   <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>  </ul>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::ListResources::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::ListResources::set_principal): <p>Specifies that you want to list only the resource shares that are associated with the specified principal.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::ListResources::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::ListResources::set_resource_type): <p>Specifies that you want to list only the resource shares that include resources of the specified resource type.</p>  <p>For valid values, query the <code>ListResourceTypes</code> operation.</p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::ListResources::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListResources::set_resource_arns): <p>Specifies that you want to list only the resource shares that include resources with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
    ///   - [`resource_share_arns(Vec<String>)`](crate::client::fluent_builders::ListResources::resource_share_arns) / [`set_resource_share_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListResources::set_resource_share_arns): <p>Specifies that you want to list only resources in the resource shares identified by the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResources::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResources::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    ///   - [`resource_region_scope(ResourceRegionScopeFilter)`](crate::client::fluent_builders::ListResources::resource_region_scope) / [`set_resource_region_scope(Option<ResourceRegionScopeFilter>)`](crate::client::fluent_builders::ListResources::set_resource_region_scope): <p>Specifies that you want the results to include only resources that have the specified scope.</p>  <ul>   <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>   <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>   <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>  </ul>  <p>The default value is <code>ALL</code>.</p>
    /// - On success, responds with [`ListResourcesOutput`](crate::output::ListResourcesOutput) with field(s):
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::ListResourcesOutput::resources): <p>An array of objects that contain information about the resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourcesOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<ListResourcesError>`](crate::error::ListResourcesError)
    pub fn list_resources(&self) -> fluent_builders::ListResources {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceSharePermissions`](crate::client::fluent_builders::ListResourceSharePermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceSharePermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::ListResourceSharePermissions::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::ListResourceSharePermissions::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share for which you want to retrieve the associated permissions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceSharePermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceSharePermissions::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceSharePermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourceSharePermissions::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    /// - On success, responds with [`ListResourceSharePermissionsOutput`](crate::output::ListResourceSharePermissionsOutput) with field(s):
    ///   - [`permissions(Option<Vec<ResourceSharePermissionSummary>>)`](crate::output::ListResourceSharePermissionsOutput::permissions): <p>An array of objects that describe the permissions associated with the resource share.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceSharePermissionsOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<ListResourceSharePermissionsError>`](crate::error::ListResourceSharePermissionsError)
    pub fn list_resource_share_permissions(&self) -> fluent_builders::ListResourceSharePermissions {
        fluent_builders::ListResourceSharePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceTypes`](crate::client::fluent_builders::ListResourceTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceTypes::set_next_token): <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourceTypes::set_max_results): <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    ///   - [`resource_region_scope(ResourceRegionScopeFilter)`](crate::client::fluent_builders::ListResourceTypes::resource_region_scope) / [`set_resource_region_scope(Option<ResourceRegionScopeFilter>)`](crate::client::fluent_builders::ListResourceTypes::set_resource_region_scope): <p>Specifies that you want the results to include only resources that have the specified scope.</p>  <ul>   <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>   <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>   <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>  </ul>  <p>The default value is <code>ALL</code>.</p>
    /// - On success, responds with [`ListResourceTypesOutput`](crate::output::ListResourceTypesOutput) with field(s):
    ///   - [`resource_types(Option<Vec<ServiceNameAndResourceType>>)`](crate::output::ListResourceTypesOutput::resource_types): <p>An array of objects that contain information about the resource types that can be shared using RAM.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceTypesOutput::next_token): <p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>
    /// - On failure, responds with [`SdkError<ListResourceTypesError>`](crate::error::ListResourceTypesError)
    pub fn list_resource_types(&self) -> fluent_builders::ListResourceTypes {
        fluent_builders::ListResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PromoteResourceShareCreatedFromPolicy`](crate::client::fluent_builders::PromoteResourceShareCreatedFromPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::PromoteResourceShareCreatedFromPolicy::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::PromoteResourceShareCreatedFromPolicy::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to promote.</p>
    /// - On success, responds with [`PromoteResourceShareCreatedFromPolicyOutput`](crate::output::PromoteResourceShareCreatedFromPolicyOutput) with field(s):
    ///   - [`return_value(Option<bool>)`](crate::output::PromoteResourceShareCreatedFromPolicyOutput::return_value): <p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>
    /// - On failure, responds with [`SdkError<PromoteResourceShareCreatedFromPolicyError>`](crate::error::PromoteResourceShareCreatedFromPolicyError)
    pub fn promote_resource_share_created_from_policy(
        &self,
    ) -> fluent_builders::PromoteResourceShareCreatedFromPolicy {
        fluent_builders::PromoteResourceShareCreatedFromPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectResourceShareInvitation`](crate::client::fluent_builders::RejectResourceShareInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_invitation_arn(impl Into<String>)`](crate::client::fluent_builders::RejectResourceShareInvitation::resource_share_invitation_arn) / [`set_resource_share_invitation_arn(Option<String>)`](crate::client::fluent_builders::RejectResourceShareInvitation::set_resource_share_invitation_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to reject.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::RejectResourceShareInvitation::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::RejectResourceShareInvitation::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    /// - On success, responds with [`RejectResourceShareInvitationOutput`](crate::output::RejectResourceShareInvitationOutput) with field(s):
    ///   - [`resource_share_invitation(Option<ResourceShareInvitation>)`](crate::output::RejectResourceShareInvitationOutput::resource_share_invitation): <p>An object that contains the details about the rejected invitation.</p>
    ///   - [`client_token(Option<String>)`](crate::output::RejectResourceShareInvitationOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<RejectResourceShareInvitationError>`](crate::error::RejectResourceShareInvitationError)
    pub fn reject_resource_share_invitation(
        &self,
    ) -> fluent_builders::RejectResourceShareInvitation {
        fluent_builders::RejectResourceShareInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of one or more tag key and value pairs. The tag key must be present and not be an empty string. The tag value must be present but can be an empty string.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove tags from. The tags are removed from the resource share, not the resources in the resource share.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Specifies a list of one or more tag keys that you want to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourceShare`](crate::client::fluent_builders::UpdateResourceShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_share_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceShare::resource_share_arn) / [`set_resource_share_arn(Option<String>)`](crate::client::fluent_builders::UpdateResourceShare::set_resource_share_arn): <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to modify.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceShare::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateResourceShare::set_name): <p>If specified, the new name that you want to attach to the resource share.</p>
    ///   - [`allow_external_principals(bool)`](crate::client::fluent_builders::UpdateResourceShare::allow_external_principals) / [`set_allow_external_principals(Option<bool>)`](crate::client::fluent_builders::UpdateResourceShare::set_allow_external_principals): <p>Specifies whether principals outside your organization in Organizations can be associated with a resource share.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceShare::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateResourceShare::set_client_token): <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>  <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
    /// - On success, responds with [`UpdateResourceShareOutput`](crate::output::UpdateResourceShareOutput) with field(s):
    ///   - [`resource_share(Option<ResourceShare>)`](crate::output::UpdateResourceShareOutput::resource_share): <p>Information about the resource share.</p>
    ///   - [`client_token(Option<String>)`](crate::output::UpdateResourceShareOutput::client_token): <p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>
    /// - On failure, responds with [`SdkError<UpdateResourceShareError>`](crate::error::UpdateResourceShareError)
    pub fn update_resource_share(&self) -> fluent_builders::UpdateResourceShare {
        fluent_builders::UpdateResourceShare::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptResourceShareInvitation`.
    ///
    /// <p>Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the invitation, the resources included in the resource share are available to interact with in the relevant Amazon Web Services Management Consoles and tools.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptResourceShareInvitation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_resource_share_invitation_input::Builder,
    }
    impl AcceptResourceShareInvitation {
        /// Creates a new `AcceptResourceShareInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptResourceShareInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptResourceShareInvitationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to accept.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to accept.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arn(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResourceShare`.
    ///
    /// <p>Adds the specified list of principals and list of resources to a resource share. Principals that already have access to this resource share immediately receive access to the added resources. Newly added principals immediately receive access to the resources shared in this resource share. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateResourceShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_resource_share_input::Builder,
    }
    impl AssociateResourceShare {
        /// Creates a new `AssociateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResourceShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add principals or resources to.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add principals or resources to.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources that you want to share. This can be <code>null</code> if you want to add only principals.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources that you want to share. This can be <code>null</code> if you want to add only principals.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>Specifies a list of principals to whom you want to the resource share. This can be <code>null</code> if you want to add only resources.</p>
        /// <p>What the principals can do with the resources in the share is determined by the RAM permissions that you associate with the resource share. See <code>AssociateResourceSharePermission</code>.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(input.into());
            self
        }
        /// <p>Specifies a list of principals to whom you want to the resource share. This can be <code>null</code> if you want to add only resources.</p>
        /// <p>What the principals can do with the resources in the share is determined by the RAM permissions that you associate with the resource share. See <code>AssociateResourceSharePermission</code>.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResourceSharePermission`.
    ///
    /// <p>Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one permission associated with each resource type in the resource share. You can add a new RAM permission only if there are currently no resources of that resource type currently in the resource share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateResourceSharePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_resource_share_permission_input::Builder,
    }
    impl AssociateResourceSharePermission {
        /// Creates a new `AssociateResourceSharePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResourceSharePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResourceSharePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to which you want to add or replace permissions.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to which you want to add or replace permissions.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission to associate with the resource share. To find the ARN for a permission, use either the <code>ListPermissions</code> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission to associate with the resource share. To find the ARN for a permission, use either the <code>ListPermissions</code> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
        /// <p>Specifies whether the specified permission should replace or add to the existing permission associated with the resource share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to add the permission to the current permission. The default value is <code>false</code>.</p> <note>
        /// <p>A resource share can have only one permission per resource type. If a resource share already has a permission for the specified resource type and you don't set <code>replace</code> to <code>true</code> then the operation returns an error. This helps prevent accidental overwriting of a permission.</p>
        /// </note>
        pub fn replace(mut self, input: bool) -> Self {
            self.inner = self.inner.replace(input);
            self
        }
        /// <p>Specifies whether the specified permission should replace or add to the existing permission associated with the resource share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to add the permission to the current permission. The default value is <code>false</code>.</p> <note>
        /// <p>A resource share can have only one permission per resource type. If a resource share already has a permission for the specified resource type and you don't set <code>replace</code> to <code>true</code> then the operation returns an error. This helps prevent accidental overwriting of a permission.</p>
        /// </note>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Specifies the version of the RAM permission to associate with the resource share. If you don't specify this parameter, the operation uses the version designated as the default. You can use the <code>ListPermissionVersions</code> operation to discover the available versions of a permission.</p>
        pub fn permission_version(mut self, input: i32) -> Self {
            self.inner = self.inner.permission_version(input);
            self
        }
        /// <p>Specifies the version of the RAM permission to associate with the resource share. If you don't specify this parameter, the operation uses the version designated as the default. You can use the <code>ListPermissionVersions</code> operation to discover the available versions of a permission.</p>
        pub fn set_permission_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_permission_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceShare`.
    ///
    /// <p>Creates a resource share. You can provide a list of the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> for the resources that you want to share, a list of principals you want to share the resources with, and the permissions to grant those principals.</p> <note>
    /// <p>Sharing a resource makes it available for use by principals outside of the Amazon Web Services account that created the resource. Sharing doesn't change any permissions or quotas that apply to the resource in the account that created it.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourceShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resource_share_input::Builder,
    }
    impl CreateResourceShare {
        /// Creates a new `CreateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the resource share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Specifies the name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>Specifies a list of one or more ARNs of the resources to associate with the resource share.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>Specifies a list of one or more ARNs of the resources to associate with the resource share.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>Specifies a list of one or more principals to associate with the resource share.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(input.into());
            self
        }
        /// <p>Specifies a list of one or more principals to associate with the resource share.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether principals outside your organization in Organizations can be associated with a resource share. A value of <code>true</code> lets you share with individual Amazon Web Services accounts that are <i>not</i> in your organization. A value of <code>false</code> only has meaning if your account is a member of an Amazon Web Services Organization. The default value is <code>true</code>.</p>
        pub fn allow_external_principals(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_external_principals(input);
            self
        }
        /// <p>Specifies whether principals outside your organization in Organizations can be associated with a resource share. A value of <code>true</code> lets you share with individual Amazon Web Services accounts that are <i>not</i> in your organization. A value of <code>false</code> only has meaning if your account is a member of an Amazon Web Services Organization. The default value is <code>true</code>.</p>
        pub fn set_allow_external_principals(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_external_principals(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `permissionArns`.
        ///
        /// To override the contents of this collection use [`set_permission_arns`](Self::set_permission_arns).
        ///
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.</p>
        pub fn permission_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arns(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.</p>
        pub fn set_permission_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permission_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceShare`.
    ///
    /// <p>Deletes the specified resource share. This doesn't delete any of the resources that were associated with the resource share; it only stops the sharing of those resources outside of the Amazon Web Services account that created them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourceShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_share_input::Builder,
    }
    impl DeleteResourceShare {
        /// Creates a new `DeleteResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to delete.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to delete.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResourceShare`.
    ///
    /// <p>Disassociates the specified principals or resources from the specified resource share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateResourceShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_resource_share_input::Builder,
    }
    impl DisassociateResourceShare {
        /// Creates a new `DisassociateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateResourceShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove resources from.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove resources from.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> for one or more resources that you want to remove from the resource share. After the operation runs, these resources are no longer shared with principals outside of the Amazon Web Services account that created the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> for one or more resources that you want to remove from the resource share. After the operation runs, these resources are no longer shared with principals outside of the Amazon Web Services account that created the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>Specifies a list of one or more principals that no longer are to have access to the resources in this resource share.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(input.into());
            self
        }
        /// <p>Specifies a list of one or more principals that no longer are to have access to the resources in this resource share.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResourceSharePermission`.
    ///
    /// <p>Disassociates an RAM permission from a resource share. Permission changes take effect immediately. You can remove a RAM permission from a resource share only if there are currently no resources of the relevant resource type currently attached to the resource share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateResourceSharePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_resource_share_permission_input::Builder,
    }
    impl DisassociateResourceSharePermission {
        /// Creates a new `DisassociateResourceSharePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResourceSharePermissionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateResourceSharePermissionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share from which you want to disassociate a permission.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share from which you want to disassociate a permission.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission to disassociate from the resource share. Changes to permissions take effect immediately.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission to disassociate from the resource share. Changes to permissions take effect immediately.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSharingWithAwsOrganization`.
    ///
    /// <p>Enables resource sharing within your organization in Organizations. Calling this operation enables RAM to retrieve information about the organization and its structure. This lets you share resources with all of the accounts in an organization by specifying the organization's ID, or all of the accounts in an organizational unit (OU) by specifying the OU's ID. Until you enable sharing within the organization, you can specify only individual Amazon Web Services accounts, or for supported resource types, IAM users and roles.</p>
    /// <p>You must call this operation from an IAM user or role in the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableSharingWithAwsOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_sharing_with_aws_organization_input::Builder,
    }
    impl EnableSharingWithAwsOrganization {
        /// Creates a new `EnableSharingWithAwsOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSharingWithAwsOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableSharingWithAwsOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPermission`.
    ///
    /// <p>Gets the contents of an RAM permission in JSON format.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_permission_input::Builder,
    }
    impl GetPermission {
        /// Creates a new `GetPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission whose contents you want to retrieve. To find the ARN for a permission, use either the <code>ListPermissions</code> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission whose contents you want to retrieve. To find the ARN for a permission, use either the <code>ListPermissions</code> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
        /// <p>Specifies identifier for the version of the RAM permission to retrieve. If you don't specify this parameter, the operation retrieves the default version.</p>
        pub fn permission_version(mut self, input: i32) -> Self {
            self.inner = self.inner.permission_version(input);
            self
        }
        /// <p>Specifies identifier for the version of the RAM permission to retrieve. If you don't specify this parameter, the operation retrieves the default version.</p>
        pub fn set_permission_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_permission_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicies`.
    ///
    /// <p>Retrieves the resource policies for the specified resources that you own and have shared.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourcePolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_policies_input::Builder,
    }
    impl GetResourcePolicies {
        /// Creates a new `GetResourcePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetResourcePoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetResourcePoliciesPaginator {
            crate::paginator::GetResourcePoliciesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources whose policies you want to retrieve.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources whose policies you want to retrieve.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p>Specifies the principal.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>Specifies the principal.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceShareAssociations`.
    ///
    /// <p>Retrieves the resource and principal associations for resource shares that you own.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceShareAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_share_associations_input::Builder,
    }
    impl GetResourceShareAssociations {
        /// Creates a new `GetResourceShareAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceShareAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceShareAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetResourceShareAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetResourceShareAssociationsPaginator {
            crate::paginator::GetResourceShareAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies whether you want to retrieve the associations that involve a specified resource or principal.</p>
        /// <ul>
        /// <li> <p> <code>PRINCIPAL</code> – list the principals that are associated with the specified resource share.</p> </li>
        /// <li> <p> <code>RESOURCE</code> – list the resources that are associated with the specified resource share.</p> </li>
        /// </ul>
        pub fn association_type(
            mut self,
            input: crate::model::ResourceShareAssociationType,
        ) -> Self {
            self.inner = self.inner.association_type(input);
            self
        }
        /// <p>Specifies whether you want to retrieve the associations that involve a specified resource or principal.</p>
        /// <ul>
        /// <li> <p> <code>PRINCIPAL</code> – list the principals that are associated with the specified resource share.</p> </li>
        /// <li> <p> <code>RESOURCE</code> – list the resources that are associated with the specified resource share.</p> </li>
        /// </ul>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationType>,
        ) -> Self {
            self.inner = self.inner.set_association_type(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share whose associations you want to retrieve.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(input.into());
            self
        }
        /// <p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share whose associations you want to retrieve.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource whose resource shares you want to retrieve.</p>
        /// <p>You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource whose resource shares you want to retrieve.</p>
        /// <p>You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon Web Services account ID, an organization ID, an organizational unit ID, or the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an individual IAM user or role.</p>
        /// <p>You cannot specify this parameter if the association type is <code>RESOURCE</code>.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon Web Services account ID, an organization ID, an organizational unit ID, or the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an individual IAM user or role.</p>
        /// <p>You cannot specify this parameter if the association type is <code>RESOURCE</code>.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>Specifies that you want to retrieve only associations with this status.</p>
        pub fn association_status(
            mut self,
            input: crate::model::ResourceShareAssociationStatus,
        ) -> Self {
            self.inner = self.inner.association_status(input);
            self
        }
        /// <p>Specifies that you want to retrieve only associations with this status.</p>
        pub fn set_association_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationStatus>,
        ) -> Self {
            self.inner = self.inner.set_association_status(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceShareInvitations`.
    ///
    /// <p>Retrieves details about invitations that you have received for resource shares.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceShareInvitations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_share_invitations_input::Builder,
    }
    impl GetResourceShareInvitations {
        /// Creates a new `GetResourceShareInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceShareInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceShareInvitationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetResourceShareInvitationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetResourceShareInvitationsPaginator {
            crate::paginator::GetResourceShareInvitationsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `resourceShareInvitationArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_invitation_arns`](Self::set_resource_share_invitation_arns).
        ///
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share invitations you want information about.</p>
        pub fn resource_share_invitation_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arns(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share invitations you want information about.</p>
        pub fn set_resource_share_invitation_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arns(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>Specifies that you want details about invitations only for the resource shares described by this list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> </p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(input.into());
            self
        }
        /// <p>Specifies that you want details about invitations only for the resource shares described by this list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> </p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceShares`.
    ///
    /// <p>Retrieves details about the resource shares that you own or that are shared with you.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceShares {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_shares_input::Builder,
    }
    impl GetResourceShares {
        /// Creates a new `GetResourceShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceSharesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetResourceSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetResourceSharesPaginator {
            crate::paginator::GetResourceSharesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of individual resource shares that you want information about.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of individual resource shares that you want information about.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>Specifies that you want to retrieve details of only those resource shares that have this status.</p>
        pub fn resource_share_status(mut self, input: crate::model::ResourceShareStatus) -> Self {
            self.inner = self.inner.resource_share_status(input);
            self
        }
        /// <p>Specifies that you want to retrieve details of only those resource shares that have this status.</p>
        pub fn set_resource_share_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareStatus>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_status(input);
            self
        }
        /// <p>Specifies that you want to retrieve details of only those resource shares that match the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>
        /// <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>
        /// </ul>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.inner = self.inner.resource_owner(input);
            self
        }
        /// <p>Specifies that you want to retrieve details of only those resource shares that match the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>
        /// <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>
        /// </ul>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>Specifies the name of an individual resource share that you want to retrieve details about.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Specifies the name of an individual resource share that you want to retrieve details about.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `tagFilters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>Specifies that you want to retrieve details of only those resource shares that match the specified tag keys and values.</p>
        pub fn tag_filters(mut self, input: crate::model::TagFilter) -> Self {
            self.inner = self.inner.tag_filters(input);
            self
        }
        /// <p>Specifies that you want to retrieve details of only those resource shares that match the specified tag keys and values.</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_tag_filters(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies that you want to retrieve details of only those resource shares that use the RAM permission with this <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(input.into());
            self
        }
        /// <p>Specifies that you want to retrieve details of only those resource shares that use the RAM permission with this <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPendingInvitationResources`.
    ///
    /// <p>Lists the resources in a resource share that is shared with you but for which the invitation is still <code>PENDING</code>. That means that you haven't accepted or rejected the invitation and the invitation hasn't expired.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPendingInvitationResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pending_invitation_resources_input::Builder,
    }
    impl ListPendingInvitationResources {
        /// Creates a new `ListPendingInvitationResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPendingInvitationResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPendingInvitationResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPendingInvitationResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPendingInvitationResourcesPaginator {
            crate::paginator::ListPendingInvitationResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation. You can use <code>GetResourceShareInvitations</code> to find the ARN of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation. You can use <code>GetResourceShareInvitations</code> to find the ARN of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arn(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies that you want the results to include only resources that have the specified scope.</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>
        /// <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>
        /// <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>
        /// </ul>
        /// <p>The default value is <code>ALL</code>.</p>
        pub fn resource_region_scope(
            mut self,
            input: crate::model::ResourceRegionScopeFilter,
        ) -> Self {
            self.inner = self.inner.resource_region_scope(input);
            self
        }
        /// <p>Specifies that you want the results to include only resources that have the specified scope.</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>
        /// <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>
        /// <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>
        /// </ul>
        /// <p>The default value is <code>ALL</code>.</p>
        pub fn set_resource_region_scope(
            mut self,
            input: std::option::Option<crate::model::ResourceRegionScopeFilter>,
        ) -> Self {
            self.inner = self.inner.set_resource_region_scope(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissions`.
    ///
    /// <p>Retrieves a list of available RAM permissions that you can use for the supported resource types. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_permissions_input::Builder,
    }
    impl ListPermissions {
        /// Creates a new `ListPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPermissionsPaginator {
            crate::paginator::ListPermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies that you want to list permissions for only the specified resource type. For example, to list only permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>. You can use the <code>ListResourceTypes</code> operation to get the specific string required.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>Specifies that you want to list permissions for only the specified resource type. For example, to list only permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>. You can use the <code>ListResourceTypes</code> operation to get the specific string required.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissionVersions`.
    ///
    /// <p>Lists the available versions of the specified RAM permission.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissionVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_permission_versions_input::Builder,
    }
    impl ListPermissionVersions {
        /// Creates a new `ListPermissionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPermissionVersionsPaginator {
            crate::paginator::ListPermissionVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission whose versions you want to list. You can use the <code>permissionVersion</code> parameter on the <code>AssociateResourceSharePermission</code> operation to specify a non-default version to attach.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission whose versions you want to list. You can use the <code>permissionVersion</code> parameter on the <code>AssociateResourceSharePermission</code> operation to specify a non-default version to attach.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrincipals`.
    ///
    /// <p>Lists the principals that you are sharing resources with or that are sharing resources with you.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPrincipals {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_principals_input::Builder,
    }
    impl ListPrincipals {
        /// Creates a new `ListPrincipals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPrincipalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPrincipalsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPrincipalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPrincipalsPaginator {
            crate::paginator::ListPrincipalsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies that you want to list information for only resource shares that match the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>
        /// <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>
        /// </ul>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.inner = self.inner.resource_owner(input);
            self
        }
        /// <p>Specifies that you want to list information for only resource shares that match the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>
        /// <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>
        /// </ul>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>Specifies that you want to list principal information for the resource share with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Specifies that you want to list principal information for the resource share with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>Specifies that you want to list information for only the listed principals.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(input.into());
            self
        }
        /// <p>Specifies that you want to list information for only the listed principals.</p>
        /// <p>You can include the following values:</p>
        /// <ul>
        /// <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li>
        /// <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li>
        /// <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li>
        /// <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li>
        /// <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li>
        /// </ul> <note>
        /// <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>Specifies that you want to list information for only principals associated with resource shares that include the specified resource type.</p>
        /// <p>For a list of valid values, query the <code>ListResourceTypes</code> operation.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>Specifies that you want to list information for only principals associated with resource shares that include the specified resource type.</p>
        /// <p>For a list of valid values, query the <code>ListResourceTypes</code> operation.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>Specifies that you want to list information for only principals associated with the resource shares specified by a list the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(input.into());
            self
        }
        /// <p>Specifies that you want to list information for only principals associated with the resource shares specified by a list the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Lists the resources that you added to a resource shares or the resources that are shared with you.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl ListResources {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourcesPaginator {
            crate::paginator::ListResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies that you want to list only the resource shares that match the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>
        /// <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>
        /// </ul>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.inner = self.inner.resource_owner(input);
            self
        }
        /// <p>Specifies that you want to list only the resource shares that match the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>SELF</code> </b> – resources that you are sharing</p> </li>
        /// <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with you</p> </li>
        /// </ul>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>Specifies that you want to list only the resource shares that are associated with the specified principal.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>Specifies that you want to list only the resource shares that are associated with the specified principal.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>Specifies that you want to list only the resource shares that include resources of the specified resource type.</p>
        /// <p>For valid values, query the <code>ListResourceTypes</code> operation.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>Specifies that you want to list only the resource shares that include resources of the specified resource type.</p>
        /// <p>For valid values, query the <code>ListResourceTypes</code> operation.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>Specifies that you want to list only the resource shares that include resources with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>Specifies that you want to list only the resource shares that include resources with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>Specifies that you want to list only resources in the resource shares identified by the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(input.into());
            self
        }
        /// <p>Specifies that you want to list only resources in the resource shares identified by the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies that you want the results to include only resources that have the specified scope.</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>
        /// <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>
        /// <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>
        /// </ul>
        /// <p>The default value is <code>ALL</code>.</p>
        pub fn resource_region_scope(
            mut self,
            input: crate::model::ResourceRegionScopeFilter,
        ) -> Self {
            self.inner = self.inner.resource_region_scope(input);
            self
        }
        /// <p>Specifies that you want the results to include only resources that have the specified scope.</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>
        /// <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>
        /// <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>
        /// </ul>
        /// <p>The default value is <code>ALL</code>.</p>
        pub fn set_resource_region_scope(
            mut self,
            input: std::option::Option<crate::model::ResourceRegionScopeFilter>,
        ) -> Self {
            self.inner = self.inner.set_resource_region_scope(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceSharePermissions`.
    ///
    /// <p>Lists the RAM permissions that are associated with a resource share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceSharePermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_share_permissions_input::Builder,
    }
    impl ListResourceSharePermissions {
        /// Creates a new `ListResourceSharePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceSharePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceSharePermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceSharePermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceSharePermissionsPaginator {
            crate::paginator::ListResourceSharePermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share for which you want to retrieve the associated permissions.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share for which you want to retrieve the associated permissions.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceTypes`.
    ///
    /// <p>Lists the resource types that can be shared by RAM.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_types_input::Builder,
    }
    impl ListResourceTypes {
        /// Creates a new `ListResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceTypesPaginator {
            crate::paginator::ListResourceTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies that you want the results to include only resources that have the specified scope.</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>
        /// <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>
        /// <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>
        /// </ul>
        /// <p>The default value is <code>ALL</code>.</p>
        pub fn resource_region_scope(
            mut self,
            input: crate::model::ResourceRegionScopeFilter,
        ) -> Self {
            self.inner = self.inner.resource_region_scope(input);
            self
        }
        /// <p>Specifies that you want the results to include only resources that have the specified scope.</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li>
        /// <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li>
        /// <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li>
        /// </ul>
        /// <p>The default value is <code>ALL</code>.</p>
        pub fn set_resource_region_scope(
            mut self,
            input: std::option::Option<crate::model::ResourceRegionScopeFilter>,
        ) -> Self {
            self.inner = self.inner.set_resource_region_scope(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PromoteResourceShareCreatedFromPolicy`.
    ///
    /// <p>When you attach a resource-based permission policy to a resource, it automatically creates a resource share. However, resource shares created this way are visible only to the resource share owner, and the resource share can't be modified in RAM.</p>
    /// <p>You can use this operation to promote the resource share to a full RAM resource share. When you promote a resource share, you can then manage the resource share in RAM and it becomes visible to all of the principals you shared it with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PromoteResourceShareCreatedFromPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::promote_resource_share_created_from_policy_input::Builder,
    }
    impl PromoteResourceShareCreatedFromPolicy {
        /// Creates a new `PromoteResourceShareCreatedFromPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PromoteResourceShareCreatedFromPolicyOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PromoteResourceShareCreatedFromPolicyError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to promote.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to promote.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectResourceShareInvitation`.
    ///
    /// <p>Rejects an invitation to a resource share from another Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectResourceShareInvitation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_resource_share_invitation_input::Builder,
    }
    impl RejectResourceShareInvitation {
        /// Creates a new `RejectResourceShareInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectResourceShareInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectResourceShareInvitationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to reject.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to reject.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arn(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tag keys and values to the specified resource share. The tags are attached only to the resource share, not to the resources that are in the resource share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add tags to.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add tags to.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of one or more tag key and value pairs. The tag key must be present and not be an empty string. The tag value must be present but can be an empty string.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of one or more tag key and value pairs. The tag key must be present and not be an empty string. The tag value must be present but can be an empty string.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tag key and value pairs from the specified resource share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove tags from. The tags are removed from the resource share, not the resources in the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove tags from. The tags are removed from the resource share, not the resources in the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Specifies a list of one or more tag keys that you want to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Specifies a list of one or more tag keys that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceShare`.
    ///
    /// <p>Modifies some of the properties of the specified resource share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResourceShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resource_share_input::Builder,
    }
    impl UpdateResourceShare {
        /// Creates a new `UpdateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to modify.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(input.into());
            self
        }
        /// <p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to modify.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>If specified, the new name that you want to attach to the resource share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>If specified, the new name that you want to attach to the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether principals outside your organization in Organizations can be associated with a resource share.</p>
        pub fn allow_external_principals(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_external_principals(input);
            self
        }
        /// <p>Specifies whether principals outside your organization in Organizations can be associated with a resource share.</p>
        pub fn set_allow_external_principals(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_external_principals(input);
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
        /// <p>If you don't provide this value, then Amazon Web Services generates a random one for you.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
