// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The client token input parameter was matched one used with a previous call to the operation, but at least one of the other input parameters is different from the previous call.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>The client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The specified value for <code>MaxResults</code> is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The specified value for <code>NextToken</code> is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource type is not valid.</p>
    InvalidResourceTypeException(crate::error::InvalidResourceTypeException),
    /// <p>The requested state transition is not valid.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>A required input parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified Amazon Resource Name (ARN) was not found.</p>
    ResourceArnNotFoundException(crate::error::ResourceArnNotFoundException),
    /// <p>The specified invitation was already accepted.</p>
    ResourceShareInvitationAlreadyAcceptedException(
        crate::error::ResourceShareInvitationAlreadyAcceptedException,
    ),
    /// <p>The specified invitation was already rejected.</p>
    ResourceShareInvitationAlreadyRejectedException(
        crate::error::ResourceShareInvitationAlreadyRejectedException,
    ),
    /// <p>The specified Amazon Resource Name (ARN) for an invitation was not found.</p>
    ResourceShareInvitationArnNotFoundException(
        crate::error::ResourceShareInvitationArnNotFoundException,
    ),
    /// <p>The specified invitation is expired.</p>
    ResourceShareInvitationExpiredException(crate::error::ResourceShareInvitationExpiredException),
    /// <p>This request would exceed the limit for resource shares for your account.</p>
    ResourceShareLimitExceededException(crate::error::ResourceShareLimitExceededException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>This request would exceed the limit for tags for your account.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>The specified tag key is a reserved word and can't be used.</p>
    TagPolicyViolationException(crate::error::TagPolicyViolationException),
    /// <p>You exceeded the rate at which you are allowed to perform this operation. Please try again later.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::IdempotentParameterMismatchException(inner) => inner.fmt(f),
            Error::InvalidClientTokenException(inner) => inner.fmt(f),
            Error::InvalidMaxResultsException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidResourceTypeException(inner) => inner.fmt(f),
            Error::InvalidStateTransitionException(inner) => inner.fmt(f),
            Error::MalformedArnException(inner) => inner.fmt(f),
            Error::MissingRequiredParameterException(inner) => inner.fmt(f),
            Error::OperationNotPermittedException(inner) => inner.fmt(f),
            Error::ResourceArnNotFoundException(inner) => inner.fmt(f),
            Error::ResourceShareInvitationAlreadyAcceptedException(inner) => inner.fmt(f),
            Error::ResourceShareInvitationAlreadyRejectedException(inner) => inner.fmt(f),
            Error::ResourceShareInvitationArnNotFoundException(inner) => inner.fmt(f),
            Error::ResourceShareInvitationExpiredException(inner) => inner.fmt(f),
            Error::ResourceShareLimitExceededException(inner) => inner.fmt(f),
            Error::ServerInternalException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::TagLimitExceededException(inner) => inner.fmt(f),
            Error::TagPolicyViolationException(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::UnknownResourceException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AcceptResourceShareInvitationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AcceptResourceShareInvitationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AcceptResourceShareInvitationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(inner) => Error::ResourceShareInvitationAlreadyAcceptedException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(inner) => Error::ResourceShareInvitationAlreadyRejectedException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(inner) => Error::ResourceShareInvitationArnNotFoundException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(inner) => Error::ResourceShareInvitationExpiredException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::AcceptResourceShareInvitationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateResourceShareError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateResourceShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateResourceShareErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::AssociateResourceShareErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::AssociateResourceShareErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::AssociateResourceShareErrorKind::InvalidStateTransitionException(inner) => Error::InvalidStateTransitionException(inner),
                crate::error::AssociateResourceShareErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::AssociateResourceShareErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::AssociateResourceShareErrorKind::ResourceShareLimitExceededException(inner) => Error::ResourceShareLimitExceededException(inner),
                crate::error::AssociateResourceShareErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::AssociateResourceShareErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::AssociateResourceShareErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::AssociateResourceShareErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::AssociateResourceShareErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AssociateResourceSharePermissionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AssociateResourceSharePermissionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateResourceSharePermissionErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::AssociateResourceSharePermissionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::AssociateResourceSharePermissionErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::AssociateResourceSharePermissionErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::AssociateResourceSharePermissionErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::AssociateResourceSharePermissionErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::AssociateResourceSharePermissionErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::AssociateResourceSharePermissionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResourceShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateResourceShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateResourceShareErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateResourceShareErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::CreateResourceShareErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateResourceShareErrorKind::InvalidStateTransitionException(inner) => Error::InvalidStateTransitionException(inner),
                crate::error::CreateResourceShareErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::CreateResourceShareErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::CreateResourceShareErrorKind::ResourceShareLimitExceededException(inner) => Error::ResourceShareLimitExceededException(inner),
                crate::error::CreateResourceShareErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::CreateResourceShareErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CreateResourceShareErrorKind::TagPolicyViolationException(inner) => Error::TagPolicyViolationException(inner),
                crate::error::CreateResourceShareErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::CreateResourceShareErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResourceShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResourceShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteResourceShareErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::DeleteResourceShareErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::DeleteResourceShareErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteResourceShareErrorKind::InvalidStateTransitionException(inner) => Error::InvalidStateTransitionException(inner),
                crate::error::DeleteResourceShareErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::DeleteResourceShareErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::DeleteResourceShareErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::DeleteResourceShareErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteResourceShareErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::DeleteResourceShareErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateResourceShareError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateResourceShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateResourceShareErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::DisassociateResourceShareErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::DisassociateResourceShareErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DisassociateResourceShareErrorKind::InvalidStateTransitionException(inner) => Error::InvalidStateTransitionException(inner),
                crate::error::DisassociateResourceShareErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::DisassociateResourceShareErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::DisassociateResourceShareErrorKind::ResourceShareLimitExceededException(inner) => Error::ResourceShareLimitExceededException(inner),
                crate::error::DisassociateResourceShareErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::DisassociateResourceShareErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DisassociateResourceShareErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::DisassociateResourceShareErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DisassociateResourceSharePermissionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateResourceSharePermissionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateResourceSharePermissionErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::InvalidStateTransitionException(inner) => Error::InvalidStateTransitionException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::DisassociateResourceSharePermissionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::EnableSharingWithAwsOrganizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::EnableSharingWithAwsOrganizationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::EnableSharingWithAwsOrganizationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::EnableSharingWithAwsOrganizationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::EnableSharingWithAwsOrganizationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::EnableSharingWithAwsOrganizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPermissionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPermissionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPermissionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetPermissionErrorKind::MalformedArnException(inner) => {
                    Error::MalformedArnException(inner)
                }
                crate::error::GetPermissionErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::GetPermissionErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetPermissionErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetPermissionErrorKind::UnknownResourceException(inner) => {
                    Error::UnknownResourceException(inner)
                }
                crate::error::GetPermissionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResourcePoliciesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::MalformedArnException(inner) => {
                    Error::MalformedArnException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::ResourceArnNotFoundException(inner) => {
                    Error::ResourceArnNotFoundException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourceShareAssociationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourceShareAssociationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetResourceShareAssociationsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetResourceShareAssociationsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetResourceShareAssociationsErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::GetResourceShareAssociationsErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::GetResourceShareAssociationsErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::GetResourceShareAssociationsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::GetResourceShareAssociationsErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::GetResourceShareAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourceShareInvitationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourceShareInvitationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetResourceShareInvitationsErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::ResourceShareInvitationArnNotFoundException(inner) => Error::ResourceShareInvitationArnNotFoundException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::GetResourceShareInvitationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourceSharesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourceSharesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResourceSharesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::GetResourceSharesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetResourceSharesErrorKind::MalformedArnException(inner) => {
                    Error::MalformedArnException(inner)
                }
                crate::error::GetResourceSharesErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetResourceSharesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetResourceSharesErrorKind::UnknownResourceException(inner) => {
                    Error::UnknownResourceException(inner)
                }
                crate::error::GetResourceSharesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListPendingInvitationResourcesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListPendingInvitationResourcesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListPendingInvitationResourcesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::ResourceShareInvitationAlreadyRejectedException(inner) => Error::ResourceShareInvitationAlreadyRejectedException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::ResourceShareInvitationArnNotFoundException(inner) => Error::ResourceShareInvitationArnNotFoundException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::ResourceShareInvitationExpiredException(inner) => Error::ResourceShareInvitationExpiredException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListPendingInvitationResourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPermissionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListPermissionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPermissionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListPermissionsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListPermissionsErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::ListPermissionsErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListPermissionsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPrincipalsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListPrincipalsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPrincipalsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListPrincipalsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListPrincipalsErrorKind::MalformedArnException(inner) => {
                    Error::MalformedArnException(inner)
                }
                crate::error::ListPrincipalsErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListPrincipalsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListPrincipalsErrorKind::UnknownResourceException(inner) => {
                    Error::UnknownResourceException(inner)
                }
                crate::error::ListPrincipalsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourcesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListResourcesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourcesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListResourcesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListResourcesErrorKind::InvalidResourceTypeException(inner) => {
                    Error::InvalidResourceTypeException(inner)
                }
                crate::error::ListResourcesErrorKind::MalformedArnException(inner) => {
                    Error::MalformedArnException(inner)
                }
                crate::error::ListResourcesErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListResourcesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListResourcesErrorKind::UnknownResourceException(inner) => {
                    Error::UnknownResourceException(inner)
                }
                crate::error::ListResourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourceSharePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResourceSharePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListResourceSharePermissionsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListResourceSharePermissionsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListResourceSharePermissionsErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::ListResourceSharePermissionsErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::ListResourceSharePermissionsErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListResourceSharePermissionsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListResourceSharePermissionsErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::ListResourceSharePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourceTypesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResourceTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourceTypesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListResourceTypesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListResourceTypesErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListResourceTypesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListResourceTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::PromoteResourceShareCreatedFromPolicyError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PromoteResourceShareCreatedFromPolicyError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::ResourceShareLimitExceededException(inner) => Error::ResourceShareLimitExceededException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::PromoteResourceShareCreatedFromPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RejectResourceShareInvitationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RejectResourceShareInvitationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RejectResourceShareInvitationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(inner) => Error::ResourceShareInvitationAlreadyAcceptedException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(inner) => Error::ResourceShareInvitationAlreadyRejectedException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(inner) => Error::ResourceShareInvitationArnNotFoundException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(inner) => Error::ResourceShareInvitationExpiredException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::RejectResourceShareInvitationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::TagResourceErrorKind::MalformedArnException(inner) => {
                    Error::MalformedArnException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceArnNotFoundException(inner) => {
                    Error::ResourceArnNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::TagResourceErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::TagResourceErrorKind::TagLimitExceededException(inner) => {
                    Error::TagLimitExceededException(inner)
                }
                crate::error::TagResourceErrorKind::TagPolicyViolationException(inner) => {
                    Error::TagPolicyViolationException(inner)
                }
                crate::error::TagResourceErrorKind::UnknownResourceException(inner) => {
                    Error::UnknownResourceException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UntagResourceErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::UntagResourceErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResourceShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateResourceShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateResourceShareErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::UpdateResourceShareErrorKind::InvalidClientTokenException(inner) => Error::InvalidClientTokenException(inner),
                crate::error::UpdateResourceShareErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::UpdateResourceShareErrorKind::MalformedArnException(inner) => Error::MalformedArnException(inner),
                crate::error::UpdateResourceShareErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::UpdateResourceShareErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::UpdateResourceShareErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::UpdateResourceShareErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::UpdateResourceShareErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::UpdateResourceShareErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
