// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceShareOutput {
    /// <p>Information about the resource share.</p>
    pub resource_share: std::option::Option<crate::model::ResourceShare>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateResourceShareOutput {
    /// <p>Information about the resource share.</p>
    pub fn resource_share(&self) -> std::option::Option<&crate::model::ResourceShare> {
        self.resource_share.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateResourceShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceShareOutput");
        formatter.field("resource_share", &self.resource_share);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`UpdateResourceShareOutput`](crate::output::UpdateResourceShareOutput)
pub mod update_resource_share_output {
    /// A builder for [`UpdateResourceShareOutput`](crate::output::UpdateResourceShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share: std::option::Option<crate::model::ResourceShare>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the resource share.</p>
        pub fn resource_share(mut self, input: crate::model::ResourceShare) -> Self {
            self.resource_share = Some(input);
            self
        }
        /// <p>Information about the resource share.</p>
        pub fn set_resource_share(
            mut self,
            input: std::option::Option<crate::model::ResourceShare>,
        ) -> Self {
            self.resource_share = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceShareOutput`](crate::output::UpdateResourceShareOutput)
        pub fn build(self) -> crate::output::UpdateResourceShareOutput {
            crate::output::UpdateResourceShareOutput {
                resource_share: self.resource_share,
                client_token: self.client_token,
            }
        }
    }
}
impl UpdateResourceShareOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResourceShareOutput`](crate::output::UpdateResourceShareOutput)
    pub fn builder() -> crate::output::update_resource_share_output::Builder {
        crate::output::update_resource_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectResourceShareInvitationOutput {
    /// <p>Information about the invitation.</p>
    pub resource_share_invitation: std::option::Option<crate::model::ResourceShareInvitation>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl RejectResourceShareInvitationOutput {
    /// <p>Information about the invitation.</p>
    pub fn resource_share_invitation(
        &self,
    ) -> std::option::Option<&crate::model::ResourceShareInvitation> {
        self.resource_share_invitation.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for RejectResourceShareInvitationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectResourceShareInvitationOutput");
        formatter.field("resource_share_invitation", &self.resource_share_invitation);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`RejectResourceShareInvitationOutput`](crate::output::RejectResourceShareInvitationOutput)
pub mod reject_resource_share_invitation_output {
    /// A builder for [`RejectResourceShareInvitationOutput`](crate::output::RejectResourceShareInvitationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitation:
            std::option::Option<crate::model::ResourceShareInvitation>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the invitation.</p>
        pub fn resource_share_invitation(
            mut self,
            input: crate::model::ResourceShareInvitation,
        ) -> Self {
            self.resource_share_invitation = Some(input);
            self
        }
        /// <p>Information about the invitation.</p>
        pub fn set_resource_share_invitation(
            mut self,
            input: std::option::Option<crate::model::ResourceShareInvitation>,
        ) -> Self {
            self.resource_share_invitation = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectResourceShareInvitationOutput`](crate::output::RejectResourceShareInvitationOutput)
        pub fn build(self) -> crate::output::RejectResourceShareInvitationOutput {
            crate::output::RejectResourceShareInvitationOutput {
                resource_share_invitation: self.resource_share_invitation,
                client_token: self.client_token,
            }
        }
    }
}
impl RejectResourceShareInvitationOutput {
    /// Creates a new builder-style object to manufacture [`RejectResourceShareInvitationOutput`](crate::output::RejectResourceShareInvitationOutput)
    pub fn builder() -> crate::output::reject_resource_share_invitation_output::Builder {
        crate::output::reject_resource_share_invitation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromoteResourceShareCreatedFromPolicyOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub return_value: std::option::Option<bool>,
}
impl PromoteResourceShareCreatedFromPolicyOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub fn return_value(&self) -> std::option::Option<bool> {
        self.return_value
    }
}
impl std::fmt::Debug for PromoteResourceShareCreatedFromPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromoteResourceShareCreatedFromPolicyOutput");
        formatter.field("return_value", &self.return_value);
        formatter.finish()
    }
}
/// See [`PromoteResourceShareCreatedFromPolicyOutput`](crate::output::PromoteResourceShareCreatedFromPolicyOutput)
pub mod promote_resource_share_created_from_policy_output {
    /// A builder for [`PromoteResourceShareCreatedFromPolicyOutput`](crate::output::PromoteResourceShareCreatedFromPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the request succeeded.</p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p>Indicates whether the request succeeded.</p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PromoteResourceShareCreatedFromPolicyOutput`](crate::output::PromoteResourceShareCreatedFromPolicyOutput)
        pub fn build(self) -> crate::output::PromoteResourceShareCreatedFromPolicyOutput {
            crate::output::PromoteResourceShareCreatedFromPolicyOutput {
                return_value: self.return_value,
            }
        }
    }
}
impl PromoteResourceShareCreatedFromPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PromoteResourceShareCreatedFromPolicyOutput`](crate::output::PromoteResourceShareCreatedFromPolicyOutput)
    pub fn builder() -> crate::output::promote_resource_share_created_from_policy_output::Builder {
        crate::output::promote_resource_share_created_from_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceTypesOutput {
    /// <p>The shareable resource types supported by RAM.</p>
    pub resource_types:
        std::option::Option<std::vec::Vec<crate::model::ServiceNameAndResourceType>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourceTypesOutput {
    /// <p>The shareable resource types supported by RAM.</p>
    pub fn resource_types(
        &self,
    ) -> std::option::Option<&[crate::model::ServiceNameAndResourceType]> {
        self.resource_types.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourceTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceTypesOutput");
        formatter.field("resource_types", &self.resource_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourceTypesOutput`](crate::output::ListResourceTypesOutput)
pub mod list_resource_types_output {
    /// A builder for [`ListResourceTypesOutput`](crate::output::ListResourceTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_types:
            std::option::Option<std::vec::Vec<crate::model::ServiceNameAndResourceType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The shareable resource types supported by RAM.</p>
        pub fn resource_types(
            mut self,
            input: impl Into<crate::model::ServiceNameAndResourceType>,
        ) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>The shareable resource types supported by RAM.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceNameAndResourceType>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceTypesOutput`](crate::output::ListResourceTypesOutput)
        pub fn build(self) -> crate::output::ListResourceTypesOutput {
            crate::output::ListResourceTypesOutput {
                resource_types: self.resource_types,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourceTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceTypesOutput`](crate::output::ListResourceTypesOutput)
    pub fn builder() -> crate::output::list_resource_types_output::Builder {
        crate::output::list_resource_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceSharePermissionsOutput {
    /// <p>The permissions associated with the resource share.</p>
    pub permissions:
        std::option::Option<std::vec::Vec<crate::model::ResourceSharePermissionSummary>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourceSharePermissionsOutput {
    /// <p>The permissions associated with the resource share.</p>
    pub fn permissions(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceSharePermissionSummary]> {
        self.permissions.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourceSharePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceSharePermissionsOutput");
        formatter.field("permissions", &self.permissions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourceSharePermissionsOutput`](crate::output::ListResourceSharePermissionsOutput)
pub mod list_resource_share_permissions_output {
    /// A builder for [`ListResourceSharePermissionsOutput`](crate::output::ListResourceSharePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourceSharePermissionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions associated with the resource share.</p>
        pub fn permissions(
            mut self,
            input: impl Into<crate::model::ResourceSharePermissionSummary>,
        ) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions associated with the resource share.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceSharePermissionSummary>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceSharePermissionsOutput`](crate::output::ListResourceSharePermissionsOutput)
        pub fn build(self) -> crate::output::ListResourceSharePermissionsOutput {
            crate::output::ListResourceSharePermissionsOutput {
                permissions: self.permissions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourceSharePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceSharePermissionsOutput`](crate::output::ListResourceSharePermissionsOutput)
    pub fn builder() -> crate::output::list_resource_share_permissions_output::Builder {
        crate::output::list_resource_share_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesOutput {
    /// <p>Information about the resources.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourcesOutput {
    /// <p>Information about the resources.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesOutput");
        formatter.field("resources", &self.resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourcesOutput`](crate::output::ListResourcesOutput)
pub mod list_resources_output {
    /// A builder for [`ListResourcesOutput`](crate::output::ListResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Information about the resources.</p>
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>Information about the resources.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesOutput`](crate::output::ListResourcesOutput)
        pub fn build(self) -> crate::output::ListResourcesOutput {
            crate::output::ListResourcesOutput {
                resources: self.resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListResourcesOutput`](crate::output::ListResourcesOutput)
    pub fn builder() -> crate::output::list_resources_output::Builder {
        crate::output::list_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPrincipalsOutput {
    /// <p>The principals.</p>
    pub principals: std::option::Option<std::vec::Vec<crate::model::Principal>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPrincipalsOutput {
    /// <p>The principals.</p>
    pub fn principals(&self) -> std::option::Option<&[crate::model::Principal]> {
        self.principals.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPrincipalsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPrincipalsOutput");
        formatter.field("principals", &self.principals);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPrincipalsOutput`](crate::output::ListPrincipalsOutput)
pub mod list_principals_output {
    /// A builder for [`ListPrincipalsOutput`](crate::output::ListPrincipalsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principals: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals.</p>
        pub fn principals(mut self, input: impl Into<crate::model::Principal>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPrincipalsOutput`](crate::output::ListPrincipalsOutput)
        pub fn build(self) -> crate::output::ListPrincipalsOutput {
            crate::output::ListPrincipalsOutput {
                principals: self.principals,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPrincipalsOutput {
    /// Creates a new builder-style object to manufacture [`ListPrincipalsOutput`](crate::output::ListPrincipalsOutput)
    pub fn builder() -> crate::output::list_principals_output::Builder {
        crate::output::list_principals_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionsOutput {
    /// <p>Information about the permissions.</p>
    pub permissions:
        std::option::Option<std::vec::Vec<crate::model::ResourceSharePermissionSummary>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPermissionsOutput {
    /// <p>Information about the permissions.</p>
    pub fn permissions(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceSharePermissionSummary]> {
        self.permissions.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionsOutput");
        formatter.field("permissions", &self.permissions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
pub mod list_permissions_output {
    /// A builder for [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourceSharePermissionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Information about the permissions.</p>
        pub fn permissions(
            mut self,
            input: impl Into<crate::model::ResourceSharePermissionSummary>,
        ) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>Information about the permissions.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceSharePermissionSummary>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
        pub fn build(self) -> crate::output::ListPermissionsOutput {
            crate::output::ListPermissionsOutput {
                permissions: self.permissions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
    pub fn builder() -> crate::output::list_permissions_output::Builder {
        crate::output::list_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPendingInvitationResourcesOutput {
    /// <p>Information about the resources included the resource share.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPendingInvitationResourcesOutput {
    /// <p>Information about the resources included the resource share.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPendingInvitationResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPendingInvitationResourcesOutput");
        formatter.field("resources", &self.resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPendingInvitationResourcesOutput`](crate::output::ListPendingInvitationResourcesOutput)
pub mod list_pending_invitation_resources_output {
    /// A builder for [`ListPendingInvitationResourcesOutput`](crate::output::ListPendingInvitationResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Information about the resources included the resource share.</p>
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>Information about the resources included the resource share.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPendingInvitationResourcesOutput`](crate::output::ListPendingInvitationResourcesOutput)
        pub fn build(self) -> crate::output::ListPendingInvitationResourcesOutput {
            crate::output::ListPendingInvitationResourcesOutput {
                resources: self.resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPendingInvitationResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListPendingInvitationResourcesOutput`](crate::output::ListPendingInvitationResourcesOutput)
    pub fn builder() -> crate::output::list_pending_invitation_resources_output::Builder {
        crate::output::list_pending_invitation_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceSharesOutput {
    /// <p>Information about the resource shares.</p>
    pub resource_shares: std::option::Option<std::vec::Vec<crate::model::ResourceShare>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourceSharesOutput {
    /// <p>Information about the resource shares.</p>
    pub fn resource_shares(&self) -> std::option::Option<&[crate::model::ResourceShare]> {
        self.resource_shares.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourceSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceSharesOutput");
        formatter.field("resource_shares", &self.resource_shares);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetResourceSharesOutput`](crate::output::GetResourceSharesOutput)
pub mod get_resource_shares_output {
    /// A builder for [`GetResourceSharesOutput`](crate::output::GetResourceSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_shares: std::option::Option<std::vec::Vec<crate::model::ResourceShare>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_shares`.
        ///
        /// To override the contents of this collection use [`set_resource_shares`](Self::set_resource_shares).
        ///
        /// <p>Information about the resource shares.</p>
        pub fn resource_shares(mut self, input: impl Into<crate::model::ResourceShare>) -> Self {
            let mut v = self.resource_shares.unwrap_or_default();
            v.push(input.into());
            self.resource_shares = Some(v);
            self
        }
        /// <p>Information about the resource shares.</p>
        pub fn set_resource_shares(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceShare>>,
        ) -> Self {
            self.resource_shares = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceSharesOutput`](crate::output::GetResourceSharesOutput)
        pub fn build(self) -> crate::output::GetResourceSharesOutput {
            crate::output::GetResourceSharesOutput {
                resource_shares: self.resource_shares,
                next_token: self.next_token,
            }
        }
    }
}
impl GetResourceSharesOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceSharesOutput`](crate::output::GetResourceSharesOutput)
    pub fn builder() -> crate::output::get_resource_shares_output::Builder {
        crate::output::get_resource_shares_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceShareInvitationsOutput {
    /// <p>Information about the invitations.</p>
    pub resource_share_invitations:
        std::option::Option<std::vec::Vec<crate::model::ResourceShareInvitation>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourceShareInvitationsOutput {
    /// <p>Information about the invitations.</p>
    pub fn resource_share_invitations(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceShareInvitation]> {
        self.resource_share_invitations.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourceShareInvitationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceShareInvitationsOutput");
        formatter.field(
            "resource_share_invitations",
            &self.resource_share_invitations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetResourceShareInvitationsOutput`](crate::output::GetResourceShareInvitationsOutput)
pub mod get_resource_share_invitations_output {
    /// A builder for [`GetResourceShareInvitationsOutput`](crate::output::GetResourceShareInvitationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitations:
            std::option::Option<std::vec::Vec<crate::model::ResourceShareInvitation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_share_invitations`.
        ///
        /// To override the contents of this collection use [`set_resource_share_invitations`](Self::set_resource_share_invitations).
        ///
        /// <p>Information about the invitations.</p>
        pub fn resource_share_invitations(
            mut self,
            input: impl Into<crate::model::ResourceShareInvitation>,
        ) -> Self {
            let mut v = self.resource_share_invitations.unwrap_or_default();
            v.push(input.into());
            self.resource_share_invitations = Some(v);
            self
        }
        /// <p>Information about the invitations.</p>
        pub fn set_resource_share_invitations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceShareInvitation>>,
        ) -> Self {
            self.resource_share_invitations = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceShareInvitationsOutput`](crate::output::GetResourceShareInvitationsOutput)
        pub fn build(self) -> crate::output::GetResourceShareInvitationsOutput {
            crate::output::GetResourceShareInvitationsOutput {
                resource_share_invitations: self.resource_share_invitations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetResourceShareInvitationsOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceShareInvitationsOutput`](crate::output::GetResourceShareInvitationsOutput)
    pub fn builder() -> crate::output::get_resource_share_invitations_output::Builder {
        crate::output::get_resource_share_invitations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceShareAssociationsOutput {
    /// <p>Information about the associations.</p>
    pub resource_share_associations:
        std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourceShareAssociationsOutput {
    /// <p>Information about the associations.</p>
    pub fn resource_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceShareAssociation]> {
        self.resource_share_associations.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourceShareAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceShareAssociationsOutput");
        formatter.field(
            "resource_share_associations",
            &self.resource_share_associations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetResourceShareAssociationsOutput`](crate::output::GetResourceShareAssociationsOutput)
pub mod get_resource_share_associations_output {
    /// A builder for [`GetResourceShareAssociationsOutput`](crate::output::GetResourceShareAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_associations:
            std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_share_associations`.
        ///
        /// To override the contents of this collection use [`set_resource_share_associations`](Self::set_resource_share_associations).
        ///
        /// <p>Information about the associations.</p>
        pub fn resource_share_associations(
            mut self,
            input: impl Into<crate::model::ResourceShareAssociation>,
        ) -> Self {
            let mut v = self.resource_share_associations.unwrap_or_default();
            v.push(input.into());
            self.resource_share_associations = Some(v);
            self
        }
        /// <p>Information about the associations.</p>
        pub fn set_resource_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        ) -> Self {
            self.resource_share_associations = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceShareAssociationsOutput`](crate::output::GetResourceShareAssociationsOutput)
        pub fn build(self) -> crate::output::GetResourceShareAssociationsOutput {
            crate::output::GetResourceShareAssociationsOutput {
                resource_share_associations: self.resource_share_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetResourceShareAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceShareAssociationsOutput`](crate::output::GetResourceShareAssociationsOutput)
    pub fn builder() -> crate::output::get_resource_share_associations_output::Builder {
        crate::output::get_resource_share_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePoliciesOutput {
    /// <p>A key policy document, in JSON format.</p>
    pub policies: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetResourcePoliciesOutput {
    /// <p>A key policy document, in JSON format.</p>
    pub fn policies(&self) -> std::option::Option<&[std::string::String]> {
        self.policies.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetResourcePoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePoliciesOutput");
        formatter.field("policies", &self.policies);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
pub mod get_resource_policies_output {
    /// A builder for [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>A key policy document, in JSON format.</p>
        pub fn policies(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>A key policy document, in JSON format.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
        pub fn build(self) -> crate::output::GetResourcePoliciesOutput {
            crate::output::GetResourcePoliciesOutput {
                policies: self.policies,
                next_token: self.next_token,
            }
        }
    }
}
impl GetResourcePoliciesOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
    pub fn builder() -> crate::output::get_resource_policies_output::Builder {
        crate::output::get_resource_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPermissionOutput {
    /// <p>Information about the permission.</p>
    pub permission: std::option::Option<crate::model::ResourceSharePermissionDetail>,
}
impl GetPermissionOutput {
    /// <p>Information about the permission.</p>
    pub fn permission(&self) -> std::option::Option<&crate::model::ResourceSharePermissionDetail> {
        self.permission.as_ref()
    }
}
impl std::fmt::Debug for GetPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPermissionOutput");
        formatter.field("permission", &self.permission);
        formatter.finish()
    }
}
/// See [`GetPermissionOutput`](crate::output::GetPermissionOutput)
pub mod get_permission_output {
    /// A builder for [`GetPermissionOutput`](crate::output::GetPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission: std::option::Option<crate::model::ResourceSharePermissionDetail>,
    }
    impl Builder {
        /// <p>Information about the permission.</p>
        pub fn permission(mut self, input: crate::model::ResourceSharePermissionDetail) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>Information about the permission.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::ResourceSharePermissionDetail>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPermissionOutput`](crate::output::GetPermissionOutput)
        pub fn build(self) -> crate::output::GetPermissionOutput {
            crate::output::GetPermissionOutput {
                permission: self.permission,
            }
        }
    }
}
impl GetPermissionOutput {
    /// Creates a new builder-style object to manufacture [`GetPermissionOutput`](crate::output::GetPermissionOutput)
    pub fn builder() -> crate::output::get_permission_output::Builder {
        crate::output::get_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSharingWithAwsOrganizationOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub return_value: std::option::Option<bool>,
}
impl EnableSharingWithAwsOrganizationOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub fn return_value(&self) -> std::option::Option<bool> {
        self.return_value
    }
}
impl std::fmt::Debug for EnableSharingWithAwsOrganizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSharingWithAwsOrganizationOutput");
        formatter.field("return_value", &self.return_value);
        formatter.finish()
    }
}
/// See [`EnableSharingWithAwsOrganizationOutput`](crate::output::EnableSharingWithAwsOrganizationOutput)
pub mod enable_sharing_with_aws_organization_output {
    /// A builder for [`EnableSharingWithAwsOrganizationOutput`](crate::output::EnableSharingWithAwsOrganizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the request succeeded.</p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p>Indicates whether the request succeeded.</p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableSharingWithAwsOrganizationOutput`](crate::output::EnableSharingWithAwsOrganizationOutput)
        pub fn build(self) -> crate::output::EnableSharingWithAwsOrganizationOutput {
            crate::output::EnableSharingWithAwsOrganizationOutput {
                return_value: self.return_value,
            }
        }
    }
}
impl EnableSharingWithAwsOrganizationOutput {
    /// Creates a new builder-style object to manufacture [`EnableSharingWithAwsOrganizationOutput`](crate::output::EnableSharingWithAwsOrganizationOutput)
    pub fn builder() -> crate::output::enable_sharing_with_aws_organization_output::Builder {
        crate::output::enable_sharing_with_aws_organization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResourceSharePermissionOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub return_value: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisassociateResourceSharePermissionOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub fn return_value(&self) -> std::option::Option<bool> {
        self.return_value
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateResourceSharePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResourceSharePermissionOutput");
        formatter.field("return_value", &self.return_value);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`DisassociateResourceSharePermissionOutput`](crate::output::DisassociateResourceSharePermissionOutput)
pub mod disassociate_resource_share_permission_output {
    /// A builder for [`DisassociateResourceSharePermissionOutput`](crate::output::DisassociateResourceSharePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the request succeeded.</p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p>Indicates whether the request succeeded.</p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResourceSharePermissionOutput`](crate::output::DisassociateResourceSharePermissionOutput)
        pub fn build(self) -> crate::output::DisassociateResourceSharePermissionOutput {
            crate::output::DisassociateResourceSharePermissionOutput {
                return_value: self.return_value,
                client_token: self.client_token,
            }
        }
    }
}
impl DisassociateResourceSharePermissionOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateResourceSharePermissionOutput`](crate::output::DisassociateResourceSharePermissionOutput)
    pub fn builder() -> crate::output::disassociate_resource_share_permission_output::Builder {
        crate::output::disassociate_resource_share_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResourceShareOutput {
    /// <p>Information about the associations.</p>
    pub resource_share_associations:
        std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisassociateResourceShareOutput {
    /// <p>Information about the associations.</p>
    pub fn resource_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceShareAssociation]> {
        self.resource_share_associations.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateResourceShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResourceShareOutput");
        formatter.field(
            "resource_share_associations",
            &self.resource_share_associations,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`DisassociateResourceShareOutput`](crate::output::DisassociateResourceShareOutput)
pub mod disassociate_resource_share_output {
    /// A builder for [`DisassociateResourceShareOutput`](crate::output::DisassociateResourceShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_associations:
            std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_share_associations`.
        ///
        /// To override the contents of this collection use [`set_resource_share_associations`](Self::set_resource_share_associations).
        ///
        /// <p>Information about the associations.</p>
        pub fn resource_share_associations(
            mut self,
            input: impl Into<crate::model::ResourceShareAssociation>,
        ) -> Self {
            let mut v = self.resource_share_associations.unwrap_or_default();
            v.push(input.into());
            self.resource_share_associations = Some(v);
            self
        }
        /// <p>Information about the associations.</p>
        pub fn set_resource_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        ) -> Self {
            self.resource_share_associations = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResourceShareOutput`](crate::output::DisassociateResourceShareOutput)
        pub fn build(self) -> crate::output::DisassociateResourceShareOutput {
            crate::output::DisassociateResourceShareOutput {
                resource_share_associations: self.resource_share_associations,
                client_token: self.client_token,
            }
        }
    }
}
impl DisassociateResourceShareOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateResourceShareOutput`](crate::output::DisassociateResourceShareOutput)
    pub fn builder() -> crate::output::disassociate_resource_share_output::Builder {
        crate::output::disassociate_resource_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceShareOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub return_value: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteResourceShareOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub fn return_value(&self) -> std::option::Option<bool> {
        self.return_value
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourceShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceShareOutput");
        formatter.field("return_value", &self.return_value);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`DeleteResourceShareOutput`](crate::output::DeleteResourceShareOutput)
pub mod delete_resource_share_output {
    /// A builder for [`DeleteResourceShareOutput`](crate::output::DeleteResourceShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the request succeeded.</p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p>Indicates whether the request succeeded.</p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceShareOutput`](crate::output::DeleteResourceShareOutput)
        pub fn build(self) -> crate::output::DeleteResourceShareOutput {
            crate::output::DeleteResourceShareOutput {
                return_value: self.return_value,
                client_token: self.client_token,
            }
        }
    }
}
impl DeleteResourceShareOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourceShareOutput`](crate::output::DeleteResourceShareOutput)
    pub fn builder() -> crate::output::delete_resource_share_output::Builder {
        crate::output::delete_resource_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceShareOutput {
    /// <p>Information about the resource share.</p>
    pub resource_share: std::option::Option<crate::model::ResourceShare>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateResourceShareOutput {
    /// <p>Information about the resource share.</p>
    pub fn resource_share(&self) -> std::option::Option<&crate::model::ResourceShare> {
        self.resource_share.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateResourceShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceShareOutput");
        formatter.field("resource_share", &self.resource_share);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`CreateResourceShareOutput`](crate::output::CreateResourceShareOutput)
pub mod create_resource_share_output {
    /// A builder for [`CreateResourceShareOutput`](crate::output::CreateResourceShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share: std::option::Option<crate::model::ResourceShare>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the resource share.</p>
        pub fn resource_share(mut self, input: crate::model::ResourceShare) -> Self {
            self.resource_share = Some(input);
            self
        }
        /// <p>Information about the resource share.</p>
        pub fn set_resource_share(
            mut self,
            input: std::option::Option<crate::model::ResourceShare>,
        ) -> Self {
            self.resource_share = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceShareOutput`](crate::output::CreateResourceShareOutput)
        pub fn build(self) -> crate::output::CreateResourceShareOutput {
            crate::output::CreateResourceShareOutput {
                resource_share: self.resource_share,
                client_token: self.client_token,
            }
        }
    }
}
impl CreateResourceShareOutput {
    /// Creates a new builder-style object to manufacture [`CreateResourceShareOutput`](crate::output::CreateResourceShareOutput)
    pub fn builder() -> crate::output::create_resource_share_output::Builder {
        crate::output::create_resource_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResourceSharePermissionOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub return_value: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AssociateResourceSharePermissionOutput {
    /// <p>Indicates whether the request succeeded.</p>
    pub fn return_value(&self) -> std::option::Option<bool> {
        self.return_value
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateResourceSharePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResourceSharePermissionOutput");
        formatter.field("return_value", &self.return_value);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`AssociateResourceSharePermissionOutput`](crate::output::AssociateResourceSharePermissionOutput)
pub mod associate_resource_share_permission_output {
    /// A builder for [`AssociateResourceSharePermissionOutput`](crate::output::AssociateResourceSharePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the request succeeded.</p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p>Indicates whether the request succeeded.</p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResourceSharePermissionOutput`](crate::output::AssociateResourceSharePermissionOutput)
        pub fn build(self) -> crate::output::AssociateResourceSharePermissionOutput {
            crate::output::AssociateResourceSharePermissionOutput {
                return_value: self.return_value,
                client_token: self.client_token,
            }
        }
    }
}
impl AssociateResourceSharePermissionOutput {
    /// Creates a new builder-style object to manufacture [`AssociateResourceSharePermissionOutput`](crate::output::AssociateResourceSharePermissionOutput)
    pub fn builder() -> crate::output::associate_resource_share_permission_output::Builder {
        crate::output::associate_resource_share_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResourceShareOutput {
    /// <p>Information about the associations.</p>
    pub resource_share_associations:
        std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AssociateResourceShareOutput {
    /// <p>Information about the associations.</p>
    pub fn resource_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceShareAssociation]> {
        self.resource_share_associations.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateResourceShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResourceShareOutput");
        formatter.field(
            "resource_share_associations",
            &self.resource_share_associations,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`AssociateResourceShareOutput`](crate::output::AssociateResourceShareOutput)
pub mod associate_resource_share_output {
    /// A builder for [`AssociateResourceShareOutput`](crate::output::AssociateResourceShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_associations:
            std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_share_associations`.
        ///
        /// To override the contents of this collection use [`set_resource_share_associations`](Self::set_resource_share_associations).
        ///
        /// <p>Information about the associations.</p>
        pub fn resource_share_associations(
            mut self,
            input: impl Into<crate::model::ResourceShareAssociation>,
        ) -> Self {
            let mut v = self.resource_share_associations.unwrap_or_default();
            v.push(input.into());
            self.resource_share_associations = Some(v);
            self
        }
        /// <p>Information about the associations.</p>
        pub fn set_resource_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        ) -> Self {
            self.resource_share_associations = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResourceShareOutput`](crate::output::AssociateResourceShareOutput)
        pub fn build(self) -> crate::output::AssociateResourceShareOutput {
            crate::output::AssociateResourceShareOutput {
                resource_share_associations: self.resource_share_associations,
                client_token: self.client_token,
            }
        }
    }
}
impl AssociateResourceShareOutput {
    /// Creates a new builder-style object to manufacture [`AssociateResourceShareOutput`](crate::output::AssociateResourceShareOutput)
    pub fn builder() -> crate::output::associate_resource_share_output::Builder {
        crate::output::associate_resource_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptResourceShareInvitationOutput {
    /// <p>Information about the invitation.</p>
    pub resource_share_invitation: std::option::Option<crate::model::ResourceShareInvitation>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AcceptResourceShareInvitationOutput {
    /// <p>Information about the invitation.</p>
    pub fn resource_share_invitation(
        &self,
    ) -> std::option::Option<&crate::model::ResourceShareInvitation> {
        self.resource_share_invitation.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AcceptResourceShareInvitationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptResourceShareInvitationOutput");
        formatter.field("resource_share_invitation", &self.resource_share_invitation);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
/// See [`AcceptResourceShareInvitationOutput`](crate::output::AcceptResourceShareInvitationOutput)
pub mod accept_resource_share_invitation_output {
    /// A builder for [`AcceptResourceShareInvitationOutput`](crate::output::AcceptResourceShareInvitationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitation:
            std::option::Option<crate::model::ResourceShareInvitation>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the invitation.</p>
        pub fn resource_share_invitation(
            mut self,
            input: crate::model::ResourceShareInvitation,
        ) -> Self {
            self.resource_share_invitation = Some(input);
            self
        }
        /// <p>Information about the invitation.</p>
        pub fn set_resource_share_invitation(
            mut self,
            input: std::option::Option<crate::model::ResourceShareInvitation>,
        ) -> Self {
            self.resource_share_invitation = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptResourceShareInvitationOutput`](crate::output::AcceptResourceShareInvitationOutput)
        pub fn build(self) -> crate::output::AcceptResourceShareInvitationOutput {
            crate::output::AcceptResourceShareInvitationOutput {
                resource_share_invitation: self.resource_share_invitation,
                client_token: self.client_token,
            }
        }
    }
}
impl AcceptResourceShareInvitationOutput {
    /// Creates a new builder-style object to manufacture [`AcceptResourceShareInvitationOutput`](crate::output::AcceptResourceShareInvitationOutput)
    pub fn builder() -> crate::output::accept_resource_share_invitation_output::Builder {
        crate::output::accept_resource_share_invitation_output::Builder::default()
    }
}
