// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptResourceShareInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptResourceShareInvitationError {
    /// Kind of error that occurred.
    pub kind: AcceptResourceShareInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptResourceShareInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptResourceShareInvitationErrorKind {
    /// <p>A client token input parameter was reused with an operation, but at least one of the
    /// other input parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The invitation was already accepted.</p>
    ResourceShareInvitationAlreadyAcceptedException(
        crate::error::ResourceShareInvitationAlreadyAcceptedException,
    ),
    /// <p>The invitation was already rejected.</p>
    ResourceShareInvitationAlreadyRejectedException(
        crate::error::ResourceShareInvitationAlreadyRejectedException,
    ),
    /// <p>The Amazon Resource Name (ARN) for an invitation was not found.</p>
    ResourceShareInvitationArnNotFoundException(
        crate::error::ResourceShareInvitationArnNotFoundException,
    ),
    /// <p>The invitation is expired.</p>
    ResourceShareInvitationExpiredException(crate::error::ResourceShareInvitationExpiredException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptResourceShareInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptResourceShareInvitationErrorKind::IdempotentParameterMismatchException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::InvalidClientTokenException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::MalformedArnException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::OperationNotPermittedException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::ServerInternalException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::ServiceUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            AcceptResourceShareInvitationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptResourceShareInvitationError {
    fn code(&self) -> Option<&str> {
        AcceptResourceShareInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptResourceShareInvitationError {
    /// Creates a new `AcceptResourceShareInvitationError`.
    pub fn new(
        kind: AcceptResourceShareInvitationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptResourceShareInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptResourceShareInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptResourceShareInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptResourceShareInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException`.
    pub fn is_resource_share_invitation_already_accepted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException`.
    pub fn is_resource_share_invitation_already_rejected_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException`.
    pub fn is_resource_share_invitation_arn_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException`.
    pub fn is_resource_share_invitation_expired_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptResourceShareInvitationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptResourceShareInvitationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for AcceptResourceShareInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptResourceShareInvitationErrorKind::IdempotentParameterMismatchException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::InvalidClientTokenException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::MalformedArnException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::OperationNotPermittedException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::ServerInternalException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::ServiceUnavailableException(_inner) =>
            Some(_inner)
            ,
            AcceptResourceShareInvitationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AssociateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateResourceShareError {
    /// Kind of error that occurred.
    pub kind: AssociateResourceShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateResourceShareErrorKind {
    /// <p>A client token input parameter was reused with an operation, but at least one of the
    /// other input parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The requested state transition is not valid.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The requested resource share exceeds the limit for your account.</p>
    ResourceShareLimitExceededException(crate::error::ResourceShareLimitExceededException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateResourceShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceShareErrorKind::InvalidClientTokenException(_inner) => _inner.fmt(f),
            AssociateResourceShareErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateResourceShareErrorKind::InvalidStateTransitionException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceShareErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            AssociateResourceShareErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceShareErrorKind::ResourceShareLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceShareErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            AssociateResourceShareErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AssociateResourceShareErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            AssociateResourceShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateResourceShareError {
    fn code(&self) -> Option<&str> {
        AssociateResourceShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateResourceShareError {
    /// Creates a new `AssociateResourceShareError`.
    pub fn new(kind: AssociateResourceShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateResourceShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateResourceShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateResourceShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateResourceShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::ResourceShareLimitExceededException`.
    pub fn is_resource_share_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::ResourceShareLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceShareErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceShareErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for AssociateResourceShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            AssociateResourceShareErrorKind::InvalidClientTokenException(_inner) => Some(_inner),
            AssociateResourceShareErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateResourceShareErrorKind::InvalidStateTransitionException(_inner) => {
                Some(_inner)
            }
            AssociateResourceShareErrorKind::MalformedArnException(_inner) => Some(_inner),
            AssociateResourceShareErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            AssociateResourceShareErrorKind::ResourceShareLimitExceededException(_inner) => {
                Some(_inner)
            }
            AssociateResourceShareErrorKind::ServerInternalException(_inner) => Some(_inner),
            AssociateResourceShareErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AssociateResourceShareErrorKind::UnknownResourceException(_inner) => Some(_inner),
            AssociateResourceShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateResourceSharePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateResourceSharePermissionError {
    /// Kind of error that occurred.
    pub kind: AssociateResourceSharePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateResourceSharePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateResourceSharePermissionErrorKind {
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateResourceSharePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateResourceSharePermissionErrorKind::InvalidClientTokenException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceSharePermissionErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceSharePermissionErrorKind::MalformedArnException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceSharePermissionErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceSharePermissionErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceSharePermissionErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceSharePermissionErrorKind::UnknownResourceException(_inner) => {
                _inner.fmt(f)
            }
            AssociateResourceSharePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateResourceSharePermissionError {
    fn code(&self) -> Option<&str> {
        AssociateResourceSharePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateResourceSharePermissionError {
    /// Creates a new `AssociateResourceSharePermissionError`.
    pub fn new(
        kind: AssociateResourceSharePermissionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateResourceSharePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateResourceSharePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateResourceSharePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateResourceSharePermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateResourceSharePermissionErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceSharePermissionErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceSharePermissionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceSharePermissionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceSharePermissionErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceSharePermissionErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceSharePermissionErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceSharePermissionErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceSharePermissionErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceSharePermissionErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceSharePermissionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceSharePermissionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateResourceSharePermissionErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateResourceSharePermissionErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for AssociateResourceSharePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateResourceSharePermissionErrorKind::InvalidClientTokenException(_inner) => {
                Some(_inner)
            }
            AssociateResourceSharePermissionErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            AssociateResourceSharePermissionErrorKind::MalformedArnException(_inner) => {
                Some(_inner)
            }
            AssociateResourceSharePermissionErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            AssociateResourceSharePermissionErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            AssociateResourceSharePermissionErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            AssociateResourceSharePermissionErrorKind::UnknownResourceException(_inner) => {
                Some(_inner)
            }
            AssociateResourceSharePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceShareError {
    /// Kind of error that occurred.
    pub kind: CreateResourceShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceShareErrorKind {
    /// <p>A client token input parameter was reused with an operation, but at least one of the
    /// other input parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The requested state transition is not valid.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The requested resource share exceeds the limit for your account.</p>
    ResourceShareLimitExceededException(crate::error::ResourceShareLimitExceededException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The specified tag is a reserved word and cannot be used.</p>
    TagPolicyViolationException(crate::error::TagPolicyViolationException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourceShareErrorKind::InvalidClientTokenException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::InvalidStateTransitionException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::ResourceShareLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourceShareErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::TagPolicyViolationException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            CreateResourceShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceShareError {
    fn code(&self) -> Option<&str> {
        CreateResourceShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceShareError {
    /// Creates a new `CreateResourceShareError`.
    pub fn new(kind: CreateResourceShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::ResourceShareLimitExceededException`.
    pub fn is_resource_share_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::ResourceShareLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::TagPolicyViolationException`.
    pub fn is_tag_policy_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::TagPolicyViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceShareErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceShareErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for CreateResourceShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateResourceShareErrorKind::InvalidClientTokenException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::InvalidStateTransitionException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::MalformedArnException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::ResourceShareLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateResourceShareErrorKind::ServerInternalException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::TagPolicyViolationException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::UnknownResourceException(_inner) => Some(_inner),
            CreateResourceShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceShareError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceShareErrorKind {
    /// <p>A client token input parameter was reused with an operation, but at least one of the
    /// other input parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The requested state transition is not valid.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            DeleteResourceShareErrorKind::InvalidClientTokenException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::InvalidStateTransitionException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            DeleteResourceShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceShareError {
    fn code(&self) -> Option<&str> {
        DeleteResourceShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceShareError {
    /// Creates a new `DeleteResourceShareError`.
    pub fn new(kind: DeleteResourceShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceShareErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceShareErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for DeleteResourceShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            DeleteResourceShareErrorKind::InvalidClientTokenException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::InvalidStateTransitionException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::MalformedArnException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::ServerInternalException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::UnknownResourceException(_inner) => Some(_inner),
            DeleteResourceShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateResourceShareError {
    /// Kind of error that occurred.
    pub kind: DisassociateResourceShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateResourceShareErrorKind {
    /// <p>A client token input parameter was reused with an operation, but at least one of the
    /// other input parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The requested state transition is not valid.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The requested resource share exceeds the limit for your account.</p>
    ResourceShareLimitExceededException(crate::error::ResourceShareLimitExceededException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateResourceShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceShareErrorKind::InvalidClientTokenException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceShareErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateResourceShareErrorKind::InvalidStateTransitionException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceShareErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            DisassociateResourceShareErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceShareErrorKind::ResourceShareLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceShareErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            DisassociateResourceShareErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceShareErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            DisassociateResourceShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateResourceShareError {
    fn code(&self) -> Option<&str> {
        DisassociateResourceShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateResourceShareError {
    /// Creates a new `DisassociateResourceShareError`.
    pub fn new(kind: DisassociateResourceShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateResourceShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateResourceShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateResourceShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateResourceShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::ResourceShareLimitExceededException`.
    pub fn is_resource_share_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::ResourceShareLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceShareErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceShareErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for DisassociateResourceShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceShareErrorKind::InvalidClientTokenException(_inner) => Some(_inner),
            DisassociateResourceShareErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateResourceShareErrorKind::InvalidStateTransitionException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceShareErrorKind::MalformedArnException(_inner) => Some(_inner),
            DisassociateResourceShareErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceShareErrorKind::ResourceShareLimitExceededException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceShareErrorKind::ServerInternalException(_inner) => Some(_inner),
            DisassociateResourceShareErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DisassociateResourceShareErrorKind::UnknownResourceException(_inner) => Some(_inner),
            DisassociateResourceShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateResourceSharePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateResourceSharePermissionError {
    /// Kind of error that occurred.
    pub kind: DisassociateResourceSharePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateResourceSharePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateResourceSharePermissionErrorKind {
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The requested state transition is not valid.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateResourceSharePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateResourceSharePermissionErrorKind::InvalidClientTokenException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceSharePermissionErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceSharePermissionErrorKind::InvalidStateTransitionException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateResourceSharePermissionErrorKind::MalformedArnException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceSharePermissionErrorKind::OperationNotPermittedException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateResourceSharePermissionErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceSharePermissionErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceSharePermissionErrorKind::UnknownResourceException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateResourceSharePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateResourceSharePermissionError {
    fn code(&self) -> Option<&str> {
        DisassociateResourceSharePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateResourceSharePermissionError {
    /// Creates a new `DisassociateResourceSharePermissionError`.
    pub fn new(
        kind: DisassociateResourceSharePermissionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateResourceSharePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateResourceSharePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateResourceSharePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateResourceSharePermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateResourceSharePermissionErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateResourceSharePermissionErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for DisassociateResourceSharePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateResourceSharePermissionErrorKind::InvalidClientTokenException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceSharePermissionErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceSharePermissionErrorKind::InvalidStateTransitionException(
                _inner,
            ) => Some(_inner),
            DisassociateResourceSharePermissionErrorKind::MalformedArnException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceSharePermissionErrorKind::OperationNotPermittedException(
                _inner,
            ) => Some(_inner),
            DisassociateResourceSharePermissionErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceSharePermissionErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceSharePermissionErrorKind::UnknownResourceException(_inner) => {
                Some(_inner)
            }
            DisassociateResourceSharePermissionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `EnableSharingWithAwsOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableSharingWithAwsOrganizationError {
    /// Kind of error that occurred.
    pub kind: EnableSharingWithAwsOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableSharingWithAwsOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableSharingWithAwsOrganizationErrorKind {
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableSharingWithAwsOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableSharingWithAwsOrganizationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            EnableSharingWithAwsOrganizationErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            EnableSharingWithAwsOrganizationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            EnableSharingWithAwsOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableSharingWithAwsOrganizationError {
    fn code(&self) -> Option<&str> {
        EnableSharingWithAwsOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableSharingWithAwsOrganizationError {
    /// Creates a new `EnableSharingWithAwsOrganizationError`.
    pub fn new(
        kind: EnableSharingWithAwsOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableSharingWithAwsOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableSharingWithAwsOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableSharingWithAwsOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableSharingWithAwsOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableSharingWithAwsOrganizationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableSharingWithAwsOrganizationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSharingWithAwsOrganizationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableSharingWithAwsOrganizationErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSharingWithAwsOrganizationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableSharingWithAwsOrganizationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for EnableSharingWithAwsOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableSharingWithAwsOrganizationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            EnableSharingWithAwsOrganizationErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            EnableSharingWithAwsOrganizationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            EnableSharingWithAwsOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPermissionError {
    /// Kind of error that occurred.
    pub kind: GetPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPermissionErrorKind {
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPermissionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetPermissionErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            GetPermissionErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetPermissionErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetPermissionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPermissionErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            GetPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPermissionError {
    fn code(&self) -> Option<&str> {
        GetPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPermissionError {
    /// Creates a new `GetPermissionError`.
    pub fn new(kind: GetPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPermissionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPermissionErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(&self.kind, GetPermissionErrorKind::MalformedArnException(_))
    }
    /// Returns `true` if the error kind is `GetPermissionErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPermissionErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPermissionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPermissionErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for GetPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPermissionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetPermissionErrorKind::MalformedArnException(_inner) => Some(_inner),
            GetPermissionErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetPermissionErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetPermissionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPermissionErrorKind::UnknownResourceException(_inner) => Some(_inner),
            GetPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePoliciesError {
    /// Kind of error that occurred.
    pub kind: GetResourcePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePoliciesErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>An Amazon Resource Name (ARN) was not found.</p>
    ResourceArnNotFoundException(crate::error::ResourceArnNotFoundException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePoliciesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::ResourceArnNotFoundException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePoliciesError {
    fn code(&self) -> Option<&str> {
        GetResourcePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePoliciesError {
    /// Creates a new `GetResourcePoliciesError`.
    pub fn new(kind: GetResourcePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::ResourceArnNotFoundException`.
    pub fn is_resource_arn_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::ResourceArnNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetResourcePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePoliciesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::MalformedArnException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::ResourceArnNotFoundException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceShareAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceShareAssociationsError {
    /// Kind of error that occurred.
    pub kind: GetResourceShareAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceShareAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceShareAssociationsErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceShareAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceShareAssociationsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareAssociationsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareAssociationsErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            GetResourceShareAssociationsErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareAssociationsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetResourceShareAssociationsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareAssociationsErrorKind::UnknownResourceException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceShareAssociationsError {
    fn code(&self) -> Option<&str> {
        GetResourceShareAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceShareAssociationsError {
    /// Creates a new `GetResourceShareAssociationsError`.
    pub fn new(kind: GetResourceShareAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceShareAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceShareAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceShareAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceShareAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceShareAssociationsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareAssociationsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareAssociationsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareAssociationsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareAssociationsErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareAssociationsErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareAssociationsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareAssociationsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareAssociationsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareAssociationsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareAssociationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareAssociationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareAssociationsErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareAssociationsErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for GetResourceShareAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceShareAssociationsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetResourceShareAssociationsErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetResourceShareAssociationsErrorKind::MalformedArnException(_inner) => Some(_inner),
            GetResourceShareAssociationsErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            GetResourceShareAssociationsErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetResourceShareAssociationsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetResourceShareAssociationsErrorKind::UnknownResourceException(_inner) => Some(_inner),
            GetResourceShareAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceShareInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceShareInvitationsError {
    /// Kind of error that occurred.
    pub kind: GetResourceShareInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceShareInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceShareInvitationsErrorKind {
    /// <p>The specified value for MaxResults is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The Amazon Resource Name (ARN) for an invitation was not found.</p>
    ResourceShareInvitationArnNotFoundException(
        crate::error::ResourceShareInvitationArnNotFoundException,
    ),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceShareInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceShareInvitationsErrorKind::InvalidMaxResultsException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareInvitationsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareInvitationsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareInvitationsErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            GetResourceShareInvitationsErrorKind::ResourceShareInvitationArnNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            GetResourceShareInvitationsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetResourceShareInvitationsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetResourceShareInvitationsErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            GetResourceShareInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceShareInvitationsError {
    fn code(&self) -> Option<&str> {
        GetResourceShareInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceShareInvitationsError {
    /// Creates a new `GetResourceShareInvitationsError`.
    pub fn new(kind: GetResourceShareInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceShareInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceShareInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceShareInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceShareInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::ResourceShareInvitationArnNotFoundException`.
    pub fn is_resource_share_invitation_arn_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::ResourceShareInvitationArnNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceShareInvitationsErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceShareInvitationsErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for GetResourceShareInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceShareInvitationsErrorKind::InvalidMaxResultsException(_inner) => {
                Some(_inner)
            }
            GetResourceShareInvitationsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetResourceShareInvitationsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetResourceShareInvitationsErrorKind::MalformedArnException(_inner) => Some(_inner),
            GetResourceShareInvitationsErrorKind::ResourceShareInvitationArnNotFoundException(
                _inner,
            ) => Some(_inner),
            GetResourceShareInvitationsErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetResourceShareInvitationsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            GetResourceShareInvitationsErrorKind::UnknownResourceException(_inner) => Some(_inner),
            GetResourceShareInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceSharesError {
    /// Kind of error that occurred.
    pub kind: GetResourceSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceSharesErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceSharesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetResourceSharesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetResourceSharesErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            GetResourceSharesErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetResourceSharesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetResourceSharesErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            GetResourceSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceSharesError {
    fn code(&self) -> Option<&str> {
        GetResourceSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceSharesError {
    /// Creates a new `GetResourceSharesError`.
    pub fn new(kind: GetResourceSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceSharesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSharesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSharesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSharesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSharesErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSharesErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSharesErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSharesErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSharesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSharesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSharesErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSharesErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for GetResourceSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceSharesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetResourceSharesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetResourceSharesErrorKind::MalformedArnException(_inner) => Some(_inner),
            GetResourceSharesErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetResourceSharesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetResourceSharesErrorKind::UnknownResourceException(_inner) => Some(_inner),
            GetResourceSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPendingInvitationResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPendingInvitationResourcesError {
    /// Kind of error that occurred.
    pub kind: ListPendingInvitationResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPendingInvitationResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPendingInvitationResourcesErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>A required input parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>The invitation was already rejected.</p>
    ResourceShareInvitationAlreadyRejectedException(
        crate::error::ResourceShareInvitationAlreadyRejectedException,
    ),
    /// <p>The Amazon Resource Name (ARN) for an invitation was not found.</p>
    ResourceShareInvitationArnNotFoundException(
        crate::error::ResourceShareInvitationArnNotFoundException,
    ),
    /// <p>The invitation is expired.</p>
    ResourceShareInvitationExpiredException(crate::error::ResourceShareInvitationExpiredException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPendingInvitationResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPendingInvitationResourcesErrorKind::InvalidNextTokenException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::InvalidParameterException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::MalformedArnException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::MissingRequiredParameterException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationAlreadyRejectedException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationArnNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationExpiredException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::ServerInternalException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::ServiceUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            ListPendingInvitationResourcesErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPendingInvitationResourcesError {
    fn code(&self) -> Option<&str> {
        ListPendingInvitationResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPendingInvitationResourcesError {
    /// Creates a new `ListPendingInvitationResourcesError`.
    pub fn new(
        kind: ListPendingInvitationResourcesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPendingInvitationResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPendingInvitationResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPendingInvitationResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPendingInvitationResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::ResourceShareInvitationAlreadyRejectedException`.
    pub fn is_resource_share_invitation_already_rejected_exception(&self) -> bool {
        matches!(&self.kind, ListPendingInvitationResourcesErrorKind::ResourceShareInvitationAlreadyRejectedException(_))
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::ResourceShareInvitationArnNotFoundException`.
    pub fn is_resource_share_invitation_arn_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationArnNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::ResourceShareInvitationExpiredException`.
    pub fn is_resource_share_invitation_expired_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationExpiredException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPendingInvitationResourcesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPendingInvitationResourcesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListPendingInvitationResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPendingInvitationResourcesErrorKind::InvalidNextTokenException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::InvalidParameterException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::MalformedArnException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::MissingRequiredParameterException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationAlreadyRejectedException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationArnNotFoundException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::ResourceShareInvitationExpiredException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::ServerInternalException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::ServiceUnavailableException(_inner) =>
            Some(_inner)
            ,
            ListPendingInvitationResourcesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionsError {
    /// Kind of error that occurred.
    pub kind: ListPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionsErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionsError {
    fn code(&self) -> Option<&str> {
        ListPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPermissionsError {
    /// Creates a new `ListPermissionsError`.
    pub fn new(kind: ListPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPermissionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListPermissionsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ListPermissionsErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListPermissionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPrincipals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPrincipalsError {
    /// Kind of error that occurred.
    pub kind: ListPrincipalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPrincipals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPrincipalsErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPrincipalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPrincipalsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListPrincipalsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListPrincipalsErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            ListPrincipalsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListPrincipalsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPrincipalsErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            ListPrincipalsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPrincipalsError {
    fn code(&self) -> Option<&str> {
        ListPrincipalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPrincipalsError {
    /// Creates a new `ListPrincipalsError`.
    pub fn new(kind: ListPrincipalsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPrincipalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPrincipalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPrincipalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPrincipalsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPrincipalsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalsErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalsErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalsErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for ListPrincipalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPrincipalsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListPrincipalsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListPrincipalsErrorKind::MalformedArnException(_inner) => Some(_inner),
            ListPrincipalsErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListPrincipalsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPrincipalsErrorKind::UnknownResourceException(_inner) => Some(_inner),
            ListPrincipalsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesError {
    /// Kind of error that occurred.
    pub kind: ListResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource type is not valid.</p>
    InvalidResourceTypeException(crate::error::InvalidResourceTypeException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::InvalidResourceTypeException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            ListResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesError {
    fn code(&self) -> Option<&str> {
        ListResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesError {
    /// Creates a new `ListResourcesError`.
    pub fn new(kind: ListResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::InvalidResourceTypeException`.
    pub fn is_invalid_resource_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::InvalidResourceTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(&self.kind, ListResourcesErrorKind::MalformedArnException(_))
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for ListResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListResourcesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListResourcesErrorKind::InvalidResourceTypeException(_inner) => Some(_inner),
            ListResourcesErrorKind::MalformedArnException(_inner) => Some(_inner),
            ListResourcesErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListResourcesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListResourcesErrorKind::UnknownResourceException(_inner) => Some(_inner),
            ListResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceSharePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceSharePermissionsError {
    /// Kind of error that occurred.
    pub kind: ListResourceSharePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceSharePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceSharePermissionsErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceSharePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceSharePermissionsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListResourceSharePermissionsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListResourceSharePermissionsErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            ListResourceSharePermissionsErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            ListResourceSharePermissionsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListResourceSharePermissionsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListResourceSharePermissionsErrorKind::UnknownResourceException(_inner) => {
                _inner.fmt(f)
            }
            ListResourceSharePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceSharePermissionsError {
    fn code(&self) -> Option<&str> {
        ListResourceSharePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceSharePermissionsError {
    /// Creates a new `ListResourceSharePermissionsError`.
    pub fn new(kind: ListResourceSharePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceSharePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceSharePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceSharePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceSharePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceSharePermissionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSharePermissionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSharePermissionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSharePermissionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSharePermissionsErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSharePermissionsErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSharePermissionsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSharePermissionsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSharePermissionsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSharePermissionsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSharePermissionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSharePermissionsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSharePermissionsErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSharePermissionsErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for ListResourceSharePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceSharePermissionsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            ListResourceSharePermissionsErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListResourceSharePermissionsErrorKind::MalformedArnException(_inner) => Some(_inner),
            ListResourceSharePermissionsErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            ListResourceSharePermissionsErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListResourceSharePermissionsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ListResourceSharePermissionsErrorKind::UnknownResourceException(_inner) => Some(_inner),
            ListResourceSharePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceTypesError {
    /// Kind of error that occurred.
    pub kind: ListResourceTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceTypesErrorKind {
    /// <p>The specified value for NextToken is not valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceTypesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListResourceTypesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListResourceTypesErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListResourceTypesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListResourceTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceTypesError {
    fn code(&self) -> Option<&str> {
        ListResourceTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceTypesError {
    /// Creates a new `ListResourceTypesError`.
    pub fn new(kind: ListResourceTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceTypesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceTypesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceTypesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceTypesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceTypesErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceTypesErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceTypesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceTypesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListResourceTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceTypesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListResourceTypesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListResourceTypesErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListResourceTypesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListResourceTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PromoteResourceShareCreatedFromPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PromoteResourceShareCreatedFromPolicyError {
    /// Kind of error that occurred.
    pub kind: PromoteResourceShareCreatedFromPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PromoteResourceShareCreatedFromPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PromoteResourceShareCreatedFromPolicyErrorKind {
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>A required input parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The requested resource share exceeds the limit for your account.</p>
    ResourceShareLimitExceededException(crate::error::ResourceShareLimitExceededException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PromoteResourceShareCreatedFromPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PromoteResourceShareCreatedFromPolicyErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::MalformedArnException(_inner) => {
                _inner.fmt(f)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::MissingRequiredParameterException(
                _inner,
            ) => _inner.fmt(f),
            PromoteResourceShareCreatedFromPolicyErrorKind::OperationNotPermittedException(
                _inner,
            ) => _inner.fmt(f),
            PromoteResourceShareCreatedFromPolicyErrorKind::ResourceShareLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            PromoteResourceShareCreatedFromPolicyErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::UnknownResourceException(_inner) => {
                _inner.fmt(f)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PromoteResourceShareCreatedFromPolicyError {
    fn code(&self) -> Option<&str> {
        PromoteResourceShareCreatedFromPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PromoteResourceShareCreatedFromPolicyError {
    /// Creates a new `PromoteResourceShareCreatedFromPolicyError`.
    pub fn new(
        kind: PromoteResourceShareCreatedFromPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PromoteResourceShareCreatedFromPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PromoteResourceShareCreatedFromPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PromoteResourceShareCreatedFromPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PromoteResourceShareCreatedFromPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::ResourceShareLimitExceededException`.
    pub fn is_resource_share_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::ResourceShareLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteResourceShareCreatedFromPolicyErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            PromoteResourceShareCreatedFromPolicyErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for PromoteResourceShareCreatedFromPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PromoteResourceShareCreatedFromPolicyErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::MalformedArnException(_inner) => {
                Some(_inner)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::MissingRequiredParameterException(
                _inner,
            ) => Some(_inner),
            PromoteResourceShareCreatedFromPolicyErrorKind::OperationNotPermittedException(
                _inner,
            ) => Some(_inner),
            PromoteResourceShareCreatedFromPolicyErrorKind::ResourceShareLimitExceededException(
                _inner,
            ) => Some(_inner),
            PromoteResourceShareCreatedFromPolicyErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::UnknownResourceException(_inner) => {
                Some(_inner)
            }
            PromoteResourceShareCreatedFromPolicyErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RejectResourceShareInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectResourceShareInvitationError {
    /// Kind of error that occurred.
    pub kind: RejectResourceShareInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectResourceShareInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectResourceShareInvitationErrorKind {
    /// <p>A client token input parameter was reused with an operation, but at least one of the
    /// other input parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The invitation was already accepted.</p>
    ResourceShareInvitationAlreadyAcceptedException(
        crate::error::ResourceShareInvitationAlreadyAcceptedException,
    ),
    /// <p>The invitation was already rejected.</p>
    ResourceShareInvitationAlreadyRejectedException(
        crate::error::ResourceShareInvitationAlreadyRejectedException,
    ),
    /// <p>The Amazon Resource Name (ARN) for an invitation was not found.</p>
    ResourceShareInvitationArnNotFoundException(
        crate::error::ResourceShareInvitationArnNotFoundException,
    ),
    /// <p>The invitation is expired.</p>
    ResourceShareInvitationExpiredException(crate::error::ResourceShareInvitationExpiredException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectResourceShareInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectResourceShareInvitationErrorKind::IdempotentParameterMismatchException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::InvalidClientTokenException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::MalformedArnException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::OperationNotPermittedException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::ServerInternalException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::ServiceUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            RejectResourceShareInvitationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectResourceShareInvitationError {
    fn code(&self) -> Option<&str> {
        RejectResourceShareInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectResourceShareInvitationError {
    /// Creates a new `RejectResourceShareInvitationError`.
    pub fn new(
        kind: RejectResourceShareInvitationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectResourceShareInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectResourceShareInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectResourceShareInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectResourceShareInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException`.
    pub fn is_resource_share_invitation_already_accepted_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException`.
    pub fn is_resource_share_invitation_already_rejected_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException`.
    pub fn is_resource_share_invitation_arn_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException`.
    pub fn is_resource_share_invitation_expired_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectResourceShareInvitationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectResourceShareInvitationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for RejectResourceShareInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectResourceShareInvitationErrorKind::IdempotentParameterMismatchException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::InvalidClientTokenException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::MalformedArnException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::OperationNotPermittedException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyAcceptedException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationAlreadyRejectedException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationArnNotFoundException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::ResourceShareInvitationExpiredException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::ServerInternalException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::ServiceUnavailableException(_inner) =>
            Some(_inner)
            ,
            RejectResourceShareInvitationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>An Amazon Resource Name (ARN) was not found.</p>
    ResourceArnNotFoundException(crate::error::ResourceArnNotFoundException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The requested tags exceed the limit for your account.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>The specified tag is a reserved word and cannot be used.</p>
    TagPolicyViolationException(crate::error::TagPolicyViolationException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceArnNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagLimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagPolicyViolationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::MalformedArnException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceArnNotFoundException`.
    pub fn is_resource_arn_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceArnNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagLimitExceededException`.
    pub fn is_tag_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagPolicyViolationException`.
    pub fn is_tag_policy_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagPolicyViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::MalformedArnException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceArnNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServerInternalException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TagResourceErrorKind::TagLimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::TagPolicyViolationException(_inner) => Some(_inner),
            TagResourceErrorKind::UnknownResourceException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServerInternalException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceShareError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResourceShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceShareErrorKind {
    /// <p>A client token input parameter was reused with an operation, but at least one of the
    /// other input parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>A client token is not valid.</p>
    InvalidClientTokenException(crate::error::InvalidClientTokenException),
    /// <p>A parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
    MalformedArnException(crate::error::MalformedArnException),
    /// <p>A required input parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>The requested operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The service could not respond to the request due to an internal problem.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>A specified resource was not found.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            UpdateResourceShareErrorKind::InvalidClientTokenException(_inner) => _inner.fmt(f),
            UpdateResourceShareErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateResourceShareErrorKind::MalformedArnException(_inner) => _inner.fmt(f),
            UpdateResourceShareErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateResourceShareErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateResourceShareErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            UpdateResourceShareErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateResourceShareErrorKind::UnknownResourceException(_inner) => _inner.fmt(f),
            UpdateResourceShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceShareError {
    fn code(&self) -> Option<&str> {
        UpdateResourceShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceShareError {
    /// Creates a new `UpdateResourceShareError`.
    pub fn new(kind: UpdateResourceShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::InvalidClientTokenException`.
    pub fn is_invalid_client_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::InvalidClientTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::MalformedArnException`.
    pub fn is_malformed_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::MalformedArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceShareErrorKind::UnknownResourceException`.
    pub fn is_unknown_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceShareErrorKind::UnknownResourceException(_)
        )
    }
}
impl std::error::Error for UpdateResourceShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceShareErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            UpdateResourceShareErrorKind::InvalidClientTokenException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::MalformedArnException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::ServerInternalException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::UnknownResourceException(_inner) => Some(_inner),
            UpdateResourceShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>A specified resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnknownResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnknownResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnknownResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnknownResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnknownResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnknownResourceException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnknownResourceException {}
/// See [`UnknownResourceException`](crate::error::UnknownResourceException)
pub mod unknown_resource_exception {
    /// A builder for [`UnknownResourceException`](crate::error::UnknownResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnknownResourceException`](crate::error::UnknownResourceException)
        pub fn build(self) -> crate::error::UnknownResourceException {
            crate::error::UnknownResourceException {
                message: self.message,
            }
        }
    }
}
impl UnknownResourceException {
    /// Creates a new builder-style object to manufacture [`UnknownResourceException`](crate::error::UnknownResourceException)
    pub fn builder() -> crate::error::unknown_resource_exception::Builder {
        crate::error::unknown_resource_exception::Builder::default()
    }
}

/// <p>The service is not available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>The service could not respond to the request due to an internal problem.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerInternalException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerInternalException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerInternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerInternalException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerInternalException {}
/// See [`ServerInternalException`](crate::error::ServerInternalException)
pub mod server_internal_exception {
    /// A builder for [`ServerInternalException`](crate::error::ServerInternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerInternalException`](crate::error::ServerInternalException)
        pub fn build(self) -> crate::error::ServerInternalException {
            crate::error::ServerInternalException {
                message: self.message,
            }
        }
    }
}
impl ServerInternalException {
    /// Creates a new builder-style object to manufacture [`ServerInternalException`](crate::error::ServerInternalException)
    pub fn builder() -> crate::error::server_internal_exception::Builder {
        crate::error::server_internal_exception::Builder::default()
    }
}

/// <p>The requested operation is not permitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotPermittedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotPermittedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotPermittedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotPermittedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotPermittedException {}
/// See [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
pub mod operation_not_permitted_exception {
    /// A builder for [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
        pub fn build(self) -> crate::error::OperationNotPermittedException {
            crate::error::OperationNotPermittedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotPermittedException {
    /// Creates a new builder-style object to manufacture [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    pub fn builder() -> crate::error::operation_not_permitted_exception::Builder {
        crate::error::operation_not_permitted_exception::Builder::default()
    }
}

/// <p>A required input parameter is missing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingRequiredParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingRequiredParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingRequiredParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingRequiredParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingRequiredParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingRequiredParameterException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingRequiredParameterException {}
/// See [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
pub mod missing_required_parameter_exception {
    /// A builder for [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
        pub fn build(self) -> crate::error::MissingRequiredParameterException {
            crate::error::MissingRequiredParameterException {
                message: self.message,
            }
        }
    }
}
impl MissingRequiredParameterException {
    /// Creates a new builder-style object to manufacture [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
    pub fn builder() -> crate::error::missing_required_parameter_exception::Builder {
        crate::error::missing_required_parameter_exception::Builder::default()
    }
}

/// <p>The format of an Amazon Resource Name (ARN) is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedArnException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedArnException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedArnException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedArnException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedArnException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedArnException {}
/// See [`MalformedArnException`](crate::error::MalformedArnException)
pub mod malformed_arn_exception {
    /// A builder for [`MalformedArnException`](crate::error::MalformedArnException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedArnException`](crate::error::MalformedArnException)
        pub fn build(self) -> crate::error::MalformedArnException {
            crate::error::MalformedArnException {
                message: self.message,
            }
        }
    }
}
impl MalformedArnException {
    /// Creates a new builder-style object to manufacture [`MalformedArnException`](crate::error::MalformedArnException)
    pub fn builder() -> crate::error::malformed_arn_exception::Builder {
        crate::error::malformed_arn_exception::Builder::default()
    }
}

/// <p>A parameter is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>A client token is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClientTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClientTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClientTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClientTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClientTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClientTokenException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClientTokenException {}
/// See [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
pub mod invalid_client_token_exception {
    /// A builder for [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
        pub fn build(self) -> crate::error::InvalidClientTokenException {
            crate::error::InvalidClientTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidClientTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidClientTokenException`](crate::error::InvalidClientTokenException)
    pub fn builder() -> crate::error::invalid_client_token_exception::Builder {
        crate::error::invalid_client_token_exception::Builder::default()
    }
}

/// <p>A client token input parameter was reused with an operation, but at least one of the
/// other input parameters is different from the previous call to the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotentParameterMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotentParameterMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdempotentParameterMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotentParameterMismatchException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotentParameterMismatchException {}
/// See [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
pub mod idempotent_parameter_mismatch_exception {
    /// A builder for [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
        pub fn build(self) -> crate::error::IdempotentParameterMismatchException {
            crate::error::IdempotentParameterMismatchException {
                message: self.message,
            }
        }
    }
}
impl IdempotentParameterMismatchException {
    /// Creates a new builder-style object to manufacture [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    pub fn builder() -> crate::error::idempotent_parameter_mismatch_exception::Builder {
        crate::error::idempotent_parameter_mismatch_exception::Builder::default()
    }
}

/// <p>The specified tag is a reserved word and cannot be used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagPolicyViolationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagPolicyViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagPolicyViolationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagPolicyViolationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagPolicyViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagPolicyViolationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagPolicyViolationException {}
/// See [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
pub mod tag_policy_violation_exception {
    /// A builder for [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
        pub fn build(self) -> crate::error::TagPolicyViolationException {
            crate::error::TagPolicyViolationException {
                message: self.message,
            }
        }
    }
}
impl TagPolicyViolationException {
    /// Creates a new builder-style object to manufacture [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
    pub fn builder() -> crate::error::tag_policy_violation_exception::Builder {
        crate::error::tag_policy_violation_exception::Builder::default()
    }
}

/// <p>The requested tags exceed the limit for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagLimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagLimitExceededException {}
/// See [`TagLimitExceededException`](crate::error::TagLimitExceededException)
pub mod tag_limit_exceeded_exception {
    /// A builder for [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagLimitExceededException`](crate::error::TagLimitExceededException)
        pub fn build(self) -> crate::error::TagLimitExceededException {
            crate::error::TagLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TagLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    pub fn builder() -> crate::error::tag_limit_exceeded_exception::Builder {
        crate::error::tag_limit_exceeded_exception::Builder::default()
    }
}

/// <p>An Amazon Resource Name (ARN) was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceArnNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceArnNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceArnNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceArnNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceArnNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceArnNotFoundException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceArnNotFoundException {}
/// See [`ResourceArnNotFoundException`](crate::error::ResourceArnNotFoundException)
pub mod resource_arn_not_found_exception {
    /// A builder for [`ResourceArnNotFoundException`](crate::error::ResourceArnNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceArnNotFoundException`](crate::error::ResourceArnNotFoundException)
        pub fn build(self) -> crate::error::ResourceArnNotFoundException {
            crate::error::ResourceArnNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceArnNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceArnNotFoundException`](crate::error::ResourceArnNotFoundException)
    pub fn builder() -> crate::error::resource_arn_not_found_exception::Builder {
        crate::error::resource_arn_not_found_exception::Builder::default()
    }
}

/// <p>The invitation is expired.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShareInvitationExpiredException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceShareInvitationExpiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShareInvitationExpiredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceShareInvitationExpiredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceShareInvitationExpiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceShareInvitationExpiredException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceShareInvitationExpiredException {}
/// See [`ResourceShareInvitationExpiredException`](crate::error::ResourceShareInvitationExpiredException)
pub mod resource_share_invitation_expired_exception {
    /// A builder for [`ResourceShareInvitationExpiredException`](crate::error::ResourceShareInvitationExpiredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShareInvitationExpiredException`](crate::error::ResourceShareInvitationExpiredException)
        pub fn build(self) -> crate::error::ResourceShareInvitationExpiredException {
            crate::error::ResourceShareInvitationExpiredException {
                message: self.message,
            }
        }
    }
}
impl ResourceShareInvitationExpiredException {
    /// Creates a new builder-style object to manufacture [`ResourceShareInvitationExpiredException`](crate::error::ResourceShareInvitationExpiredException)
    pub fn builder() -> crate::error::resource_share_invitation_expired_exception::Builder {
        crate::error::resource_share_invitation_expired_exception::Builder::default()
    }
}

/// <p>The Amazon Resource Name (ARN) for an invitation was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShareInvitationArnNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceShareInvitationArnNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShareInvitationArnNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceShareInvitationArnNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceShareInvitationArnNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceShareInvitationArnNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceShareInvitationArnNotFoundException {}
/// See [`ResourceShareInvitationArnNotFoundException`](crate::error::ResourceShareInvitationArnNotFoundException)
pub mod resource_share_invitation_arn_not_found_exception {
    /// A builder for [`ResourceShareInvitationArnNotFoundException`](crate::error::ResourceShareInvitationArnNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShareInvitationArnNotFoundException`](crate::error::ResourceShareInvitationArnNotFoundException)
        pub fn build(self) -> crate::error::ResourceShareInvitationArnNotFoundException {
            crate::error::ResourceShareInvitationArnNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceShareInvitationArnNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceShareInvitationArnNotFoundException`](crate::error::ResourceShareInvitationArnNotFoundException)
    pub fn builder() -> crate::error::resource_share_invitation_arn_not_found_exception::Builder {
        crate::error::resource_share_invitation_arn_not_found_exception::Builder::default()
    }
}

/// <p>The invitation was already rejected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShareInvitationAlreadyRejectedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceShareInvitationAlreadyRejectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShareInvitationAlreadyRejectedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceShareInvitationAlreadyRejectedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceShareInvitationAlreadyRejectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceShareInvitationAlreadyRejectedException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceShareInvitationAlreadyRejectedException {}
/// See [`ResourceShareInvitationAlreadyRejectedException`](crate::error::ResourceShareInvitationAlreadyRejectedException)
pub mod resource_share_invitation_already_rejected_exception {
    /// A builder for [`ResourceShareInvitationAlreadyRejectedException`](crate::error::ResourceShareInvitationAlreadyRejectedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShareInvitationAlreadyRejectedException`](crate::error::ResourceShareInvitationAlreadyRejectedException)
        pub fn build(self) -> crate::error::ResourceShareInvitationAlreadyRejectedException {
            crate::error::ResourceShareInvitationAlreadyRejectedException {
                message: self.message,
            }
        }
    }
}
impl ResourceShareInvitationAlreadyRejectedException {
    /// Creates a new builder-style object to manufacture [`ResourceShareInvitationAlreadyRejectedException`](crate::error::ResourceShareInvitationAlreadyRejectedException)
    pub fn builder() -> crate::error::resource_share_invitation_already_rejected_exception::Builder
    {
        crate::error::resource_share_invitation_already_rejected_exception::Builder::default()
    }
}

/// <p>The invitation was already accepted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShareInvitationAlreadyAcceptedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceShareInvitationAlreadyAcceptedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShareInvitationAlreadyAcceptedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceShareInvitationAlreadyAcceptedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceShareInvitationAlreadyAcceptedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceShareInvitationAlreadyAcceptedException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceShareInvitationAlreadyAcceptedException {}
/// See [`ResourceShareInvitationAlreadyAcceptedException`](crate::error::ResourceShareInvitationAlreadyAcceptedException)
pub mod resource_share_invitation_already_accepted_exception {
    /// A builder for [`ResourceShareInvitationAlreadyAcceptedException`](crate::error::ResourceShareInvitationAlreadyAcceptedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShareInvitationAlreadyAcceptedException`](crate::error::ResourceShareInvitationAlreadyAcceptedException)
        pub fn build(self) -> crate::error::ResourceShareInvitationAlreadyAcceptedException {
            crate::error::ResourceShareInvitationAlreadyAcceptedException {
                message: self.message,
            }
        }
    }
}
impl ResourceShareInvitationAlreadyAcceptedException {
    /// Creates a new builder-style object to manufacture [`ResourceShareInvitationAlreadyAcceptedException`](crate::error::ResourceShareInvitationAlreadyAcceptedException)
    pub fn builder() -> crate::error::resource_share_invitation_already_accepted_exception::Builder
    {
        crate::error::resource_share_invitation_already_accepted_exception::Builder::default()
    }
}

/// <p>The requested resource share exceeds the limit for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShareLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceShareLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShareLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceShareLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceShareLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceShareLimitExceededException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceShareLimitExceededException {}
/// See [`ResourceShareLimitExceededException`](crate::error::ResourceShareLimitExceededException)
pub mod resource_share_limit_exceeded_exception {
    /// A builder for [`ResourceShareLimitExceededException`](crate::error::ResourceShareLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShareLimitExceededException`](crate::error::ResourceShareLimitExceededException)
        pub fn build(self) -> crate::error::ResourceShareLimitExceededException {
            crate::error::ResourceShareLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceShareLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceShareLimitExceededException`](crate::error::ResourceShareLimitExceededException)
    pub fn builder() -> crate::error::resource_share_limit_exceeded_exception::Builder {
        crate::error::resource_share_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified value for NextToken is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The specified resource type is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceTypeException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceTypeException {}
/// See [`InvalidResourceTypeException`](crate::error::InvalidResourceTypeException)
pub mod invalid_resource_type_exception {
    /// A builder for [`InvalidResourceTypeException`](crate::error::InvalidResourceTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceTypeException`](crate::error::InvalidResourceTypeException)
        pub fn build(self) -> crate::error::InvalidResourceTypeException {
            crate::error::InvalidResourceTypeException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceTypeException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceTypeException`](crate::error::InvalidResourceTypeException)
    pub fn builder() -> crate::error::invalid_resource_type_exception::Builder {
        crate::error::invalid_resource_type_exception::Builder::default()
    }
}

/// <p>The specified value for MaxResults is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidMaxResultsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidMaxResultsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidMaxResultsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidMaxResultsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidMaxResultsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidMaxResultsException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidMaxResultsException {}
/// See [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
pub mod invalid_max_results_exception {
    /// A builder for [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
        pub fn build(self) -> crate::error::InvalidMaxResultsException {
            crate::error::InvalidMaxResultsException {
                message: self.message,
            }
        }
    }
}
impl InvalidMaxResultsException {
    /// Creates a new builder-style object to manufacture [`InvalidMaxResultsException`](crate::error::InvalidMaxResultsException)
    pub fn builder() -> crate::error::invalid_max_results_exception::Builder {
        crate::error::invalid_max_results_exception::Builder::default()
    }
}

/// <p>The requested state transition is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateTransitionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateTransitionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateTransitionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateTransitionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateTransitionException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateTransitionException {}
/// See [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
pub mod invalid_state_transition_exception {
    /// A builder for [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
        pub fn build(self) -> crate::error::InvalidStateTransitionException {
            crate::error::InvalidStateTransitionException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateTransitionException {
    /// Creates a new builder-style object to manufacture [`InvalidStateTransitionException`](crate::error::InvalidStateTransitionException)
    pub fn builder() -> crate::error::invalid_state_transition_exception::Builder {
        crate::error::invalid_state_transition_exception::Builder::default()
    }
}
