// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Resource Access Manager
///
/// Client for invoking operations on AWS Resource Access Manager. Each operation on AWS Resource Access Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ram::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ram::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ram::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptResourceShareInvitation` operation.
    ///
    /// See [`AcceptResourceShareInvitation`](crate::client::fluent_builders::AcceptResourceShareInvitation) for more information about the
    /// operation and its arguments.
    pub fn accept_resource_share_invitation(
        &self,
    ) -> fluent_builders::AcceptResourceShareInvitation<C, M, R> {
        fluent_builders::AcceptResourceShareInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateResourceShare` operation.
    ///
    /// See [`AssociateResourceShare`](crate::client::fluent_builders::AssociateResourceShare) for more information about the
    /// operation and its arguments.
    pub fn associate_resource_share(&self) -> fluent_builders::AssociateResourceShare<C, M, R> {
        fluent_builders::AssociateResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateResourceSharePermission` operation.
    ///
    /// See [`AssociateResourceSharePermission`](crate::client::fluent_builders::AssociateResourceSharePermission) for more information about the
    /// operation and its arguments.
    pub fn associate_resource_share_permission(
        &self,
    ) -> fluent_builders::AssociateResourceSharePermission<C, M, R> {
        fluent_builders::AssociateResourceSharePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourceShare` operation.
    ///
    /// See [`CreateResourceShare`](crate::client::fluent_builders::CreateResourceShare) for more information about the
    /// operation and its arguments.
    pub fn create_resource_share(&self) -> fluent_builders::CreateResourceShare<C, M, R> {
        fluent_builders::CreateResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourceShare` operation.
    ///
    /// See [`DeleteResourceShare`](crate::client::fluent_builders::DeleteResourceShare) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_share(&self) -> fluent_builders::DeleteResourceShare<C, M, R> {
        fluent_builders::DeleteResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateResourceShare` operation.
    ///
    /// See [`DisassociateResourceShare`](crate::client::fluent_builders::DisassociateResourceShare) for more information about the
    /// operation and its arguments.
    pub fn disassociate_resource_share(
        &self,
    ) -> fluent_builders::DisassociateResourceShare<C, M, R> {
        fluent_builders::DisassociateResourceShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateResourceSharePermission` operation.
    ///
    /// See [`DisassociateResourceSharePermission`](crate::client::fluent_builders::DisassociateResourceSharePermission) for more information about the
    /// operation and its arguments.
    pub fn disassociate_resource_share_permission(
        &self,
    ) -> fluent_builders::DisassociateResourceSharePermission<C, M, R> {
        fluent_builders::DisassociateResourceSharePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableSharingWithAwsOrganization` operation.
    ///
    /// See [`EnableSharingWithAwsOrganization`](crate::client::fluent_builders::EnableSharingWithAwsOrganization) for more information about the
    /// operation and its arguments.
    pub fn enable_sharing_with_aws_organization(
        &self,
    ) -> fluent_builders::EnableSharingWithAwsOrganization<C, M, R> {
        fluent_builders::EnableSharingWithAwsOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPermission` operation.
    ///
    /// See [`GetPermission`](crate::client::fluent_builders::GetPermission) for more information about the
    /// operation and its arguments.
    pub fn get_permission(&self) -> fluent_builders::GetPermission<C, M, R> {
        fluent_builders::GetPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourcePolicies` operation.
    ///
    /// See [`GetResourcePolicies`](crate::client::fluent_builders::GetResourcePolicies) for more information about the
    /// operation and its arguments.
    pub fn get_resource_policies(&self) -> fluent_builders::GetResourcePolicies<C, M, R> {
        fluent_builders::GetResourcePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceShareAssociations` operation.
    ///
    /// See [`GetResourceShareAssociations`](crate::client::fluent_builders::GetResourceShareAssociations) for more information about the
    /// operation and its arguments.
    pub fn get_resource_share_associations(
        &self,
    ) -> fluent_builders::GetResourceShareAssociations<C, M, R> {
        fluent_builders::GetResourceShareAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceShareInvitations` operation.
    ///
    /// See [`GetResourceShareInvitations`](crate::client::fluent_builders::GetResourceShareInvitations) for more information about the
    /// operation and its arguments.
    pub fn get_resource_share_invitations(
        &self,
    ) -> fluent_builders::GetResourceShareInvitations<C, M, R> {
        fluent_builders::GetResourceShareInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceShares` operation.
    ///
    /// See [`GetResourceShares`](crate::client::fluent_builders::GetResourceShares) for more information about the
    /// operation and its arguments.
    pub fn get_resource_shares(&self) -> fluent_builders::GetResourceShares<C, M, R> {
        fluent_builders::GetResourceShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPendingInvitationResources` operation.
    ///
    /// See [`ListPendingInvitationResources`](crate::client::fluent_builders::ListPendingInvitationResources) for more information about the
    /// operation and its arguments.
    pub fn list_pending_invitation_resources(
        &self,
    ) -> fluent_builders::ListPendingInvitationResources<C, M, R> {
        fluent_builders::ListPendingInvitationResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPermissions` operation.
    ///
    /// See [`ListPermissions`](crate::client::fluent_builders::ListPermissions) for more information about the
    /// operation and its arguments.
    pub fn list_permissions(&self) -> fluent_builders::ListPermissions<C, M, R> {
        fluent_builders::ListPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPrincipals` operation.
    ///
    /// See [`ListPrincipals`](crate::client::fluent_builders::ListPrincipals) for more information about the
    /// operation and its arguments.
    pub fn list_principals(&self) -> fluent_builders::ListPrincipals<C, M, R> {
        fluent_builders::ListPrincipals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResources` operation.
    ///
    /// See [`ListResources`](crate::client::fluent_builders::ListResources) for more information about the
    /// operation and its arguments.
    pub fn list_resources(&self) -> fluent_builders::ListResources<C, M, R> {
        fluent_builders::ListResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceSharePermissions` operation.
    ///
    /// See [`ListResourceSharePermissions`](crate::client::fluent_builders::ListResourceSharePermissions) for more information about the
    /// operation and its arguments.
    pub fn list_resource_share_permissions(
        &self,
    ) -> fluent_builders::ListResourceSharePermissions<C, M, R> {
        fluent_builders::ListResourceSharePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceTypes` operation.
    ///
    /// See [`ListResourceTypes`](crate::client::fluent_builders::ListResourceTypes) for more information about the
    /// operation and its arguments.
    pub fn list_resource_types(&self) -> fluent_builders::ListResourceTypes<C, M, R> {
        fluent_builders::ListResourceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PromoteResourceShareCreatedFromPolicy` operation.
    ///
    /// See [`PromoteResourceShareCreatedFromPolicy`](crate::client::fluent_builders::PromoteResourceShareCreatedFromPolicy) for more information about the
    /// operation and its arguments.
    pub fn promote_resource_share_created_from_policy(
        &self,
    ) -> fluent_builders::PromoteResourceShareCreatedFromPolicy<C, M, R> {
        fluent_builders::PromoteResourceShareCreatedFromPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectResourceShareInvitation` operation.
    ///
    /// See [`RejectResourceShareInvitation`](crate::client::fluent_builders::RejectResourceShareInvitation) for more information about the
    /// operation and its arguments.
    pub fn reject_resource_share_invitation(
        &self,
    ) -> fluent_builders::RejectResourceShareInvitation<C, M, R> {
        fluent_builders::RejectResourceShareInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResourceShare` operation.
    ///
    /// See [`UpdateResourceShare`](crate::client::fluent_builders::UpdateResourceShare) for more information about the
    /// operation and its arguments.
    pub fn update_resource_share(&self) -> fluent_builders::UpdateResourceShare<C, M, R> {
        fluent_builders::UpdateResourceShare::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptResourceShareInvitation`.
    ///
    /// <p>Accepts an invitation to a resource share from another Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptResourceShareInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_resource_share_invitation_input::Builder,
    }
    impl<C, M, R> AcceptResourceShareInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptResourceShareInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptResourceShareInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptResourceShareInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptResourceShareInvitationInputOperationOutputAlias,
                crate::output::AcceptResourceShareInvitationOutput,
                crate::error::AcceptResourceShareInvitationError,
                crate::input::AcceptResourceShareInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arn(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResourceShare`.
    ///
    /// <p>Associates the specified resource share with the specified principals and resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateResourceShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_resource_share_input::Builder,
    }
    impl<C, M, R> AssociateResourceShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResourceShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateResourceShareInputOperationOutputAlias,
                crate::output::AssociateResourceShareOutput,
                crate::error::AssociateResourceShareError,
                crate::input::AssociateResourceShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(inp);
            self
        }
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResourceSharePermission`.
    ///
    /// <p>Associates a permission with a resource share.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateResourceSharePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_resource_share_permission_input::Builder,
    }
    impl<C, M, R> AssociateResourceSharePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateResourceSharePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResourceSharePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResourceSharePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateResourceSharePermissionInputOperationOutputAlias,
                crate::output::AssociateResourceSharePermissionOutput,
                crate::error::AssociateResourceSharePermissionError,
                crate::input::AssociateResourceSharePermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission to associate with the
        /// resource share.</p>
        pub fn permission_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission to associate with the
        /// resource share.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
        /// <p>Indicates whether the permission should replace the permissions that are currently
        /// associated with the resource share. Use <code>true</code> to replace the current permissions. Use
        /// <code>false</code> to add the permission to the current permission.</p>
        pub fn replace(mut self, inp: bool) -> Self {
            self.inner = self.inner.replace(inp);
            self
        }
        /// <p>Indicates whether the permission should replace the permissions that are currently
        /// associated with the resource share. Use <code>true</code> to replace the current permissions. Use
        /// <code>false</code> to add the permission to the current permission.</p>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The version of the RAM permissions to associate with the resource share.</p>
        pub fn permission_version(mut self, inp: i32) -> Self {
            self.inner = self.inner.permission_version(inp);
            self
        }
        /// <p>The version of the RAM permissions to associate with the resource share.</p>
        pub fn set_permission_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_permission_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceShare`.
    ///
    /// <p>Creates a resource share. You must provide a list of the Amazon Resource Names (ARNs) for the
    /// resources you want to share. You must also specify who you want to share the resources
    /// with, and the permissions that you grant them.</p>
    /// <note>
    /// <p>Sharing a resource makes it available for use by principals outside of the
    /// Amazon Web Services account that created the resource. Sharing doesn't change any permissions or
    /// quotas that apply to the resource in the account that created it.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateResourceShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_share_input::Builder,
    }
    impl<C, M, R> CreateResourceShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceShareInputOperationOutputAlias,
                crate::output::CreateResourceShareOutput,
                crate::error::CreateResourceShareError,
                crate::input::CreateResourceShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource share.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The ARNs of the resources to associate with the resource share.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The ARNs of the resources to associate with the resource share.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(inp);
            self
        }
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn allow_external_principals(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_external_principals(inp);
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn set_allow_external_principals(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_external_principals(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `permissionArns`.
        ///
        /// To override the contents of this collection use [`set_permission_arns`](Self::set_permission_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the permissions to associate with the resource share. If you
        /// do not specify an ARN for the permission, RAM automatically attaches the default
        /// version of the permission for each resource type. Only one permission can be associated
        /// with each resource type in a resource share.</p>
        pub fn permission_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the permissions to associate with the resource share. If you
        /// do not specify an ARN for the permission, RAM automatically attaches the default
        /// version of the permission for each resource type. Only one permission can be associated
        /// with each resource type in a resource share.</p>
        pub fn set_permission_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permission_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceShare`.
    ///
    /// <p>Deletes the specified resource share.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourceShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_share_input::Builder,
    }
    impl<C, M, R> DeleteResourceShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceShareInputOperationOutputAlias,
                crate::output::DeleteResourceShareOutput,
                crate::error::DeleteResourceShareError,
                crate::input::DeleteResourceShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResourceShare`.
    ///
    /// <p>Disassociates the specified principals or resources from the specified resource share.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateResourceShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_resource_share_input::Builder,
    }
    impl<C, M, R> DisassociateResourceShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateResourceShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateResourceShareInputOperationOutputAlias,
                crate::output::DisassociateResourceShareOutput,
                crate::error::DisassociateResourceShareError,
                crate::input::DisassociateResourceShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals.</p>
        pub fn principals(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(inp);
            self
        }
        /// <p>The principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResourceSharePermission`.
    ///
    /// <p>Disassociates an RAM permission from a resource share.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateResourceSharePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_resource_share_permission_input::Builder,
    }
    impl<C, M, R> DisassociateResourceSharePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateResourceSharePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResourceSharePermissionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateResourceSharePermissionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateResourceSharePermissionInputOperationOutputAlias,
                crate::output::DisassociateResourceSharePermissionOutput,
                crate::error::DisassociateResourceSharePermissionError,
                crate::input::DisassociateResourceSharePermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission to disassociate from the resource share.</p>
        pub fn permission_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission to disassociate from the resource share.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSharingWithAwsOrganization`.
    ///
    /// <p>Enables resource sharing within your organization in Organizations.</p>
    /// <p>The caller must be the master account for the organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableSharingWithAwsOrganization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_sharing_with_aws_organization_input::Builder,
    }
    impl<C, M, R> EnableSharingWithAwsOrganization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableSharingWithAwsOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSharingWithAwsOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableSharingWithAwsOrganizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableSharingWithAwsOrganizationInputOperationOutputAlias,
                crate::output::EnableSharingWithAwsOrganizationOutput,
                crate::error::EnableSharingWithAwsOrganizationError,
                crate::input::EnableSharingWithAwsOrganizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPermission`.
    ///
    /// <p>Gets the contents of an RAM permission in JSON format.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_permission_input::Builder,
    }
    impl<C, M, R> GetPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPermissionInputOperationOutputAlias,
                crate::output::GetPermissionOutput,
                crate::error::GetPermissionError,
                crate::input::GetPermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn permission_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn permission_version(mut self, inp: i32) -> Self {
            self.inner = self.inner.permission_version(inp);
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn set_permission_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_permission_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicies`.
    ///
    /// <p>Gets the policies for the specified resources that you own and have shared.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourcePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policies_input::Builder,
    }
    impl<C, M, R> GetResourcePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePoliciesInputOperationOutputAlias,
                crate::output::GetResourcePoliciesOutput,
                crate::error::GetResourcePoliciesError,
                crate::input::GetResourcePoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p>The principal.</p>
        pub fn principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>The principal.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceShareAssociations`.
    ///
    /// <p>Gets the resources or principals for the resource shares that you own.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourceShareAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_share_associations_input::Builder,
    }
    impl<C, M, R> GetResourceShareAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceShareAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceShareAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceShareAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceShareAssociationsInputOperationOutputAlias,
                crate::output::GetResourceShareAssociationsOutput,
                crate::error::GetResourceShareAssociationsError,
                crate::input::GetResourceShareAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The association type. Specify <code>PRINCIPAL</code> to list the principals that are
        /// associated with the specified resource share. Specify <code>RESOURCE</code> to list the resources
        /// that are associated with the specified resource share.</p>
        pub fn association_type(mut self, inp: crate::model::ResourceShareAssociationType) -> Self {
            self.inner = self.inner.association_type(inp);
            self
        }
        /// <p>The association type. Specify <code>PRINCIPAL</code> to list the principals that are
        /// associated with the specified resource share. Specify <code>RESOURCE</code> to list the resources
        /// that are associated with the specified resource share.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationType>,
        ) -> Self {
            self.inner = self.inner.set_association_type(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter if
        /// the association type is <code>PRINCIPAL</code>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter if
        /// the association type is <code>PRINCIPAL</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The principal. You cannot specify this parameter if the association type is
        /// <code>RESOURCE</code>.</p>
        pub fn principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>The principal. You cannot specify this parameter if the association type is
        /// <code>RESOURCE</code>.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The association status.</p>
        pub fn association_status(
            mut self,
            inp: crate::model::ResourceShareAssociationStatus,
        ) -> Self {
            self.inner = self.inner.association_status(inp);
            self
        }
        /// <p>The association status.</p>
        pub fn set_association_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationStatus>,
        ) -> Self {
            self.inner = self.inner.set_association_status(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceShareInvitations`.
    ///
    /// <p>Gets the invitations that you have received for resource shares.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourceShareInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_share_invitations_input::Builder,
    }
    impl<C, M, R> GetResourceShareInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceShareInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceShareInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceShareInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceShareInvitationsInputOperationOutputAlias,
                crate::output::GetResourceShareInvitationsOutput,
                crate::error::GetResourceShareInvitationsError,
                crate::input::GetResourceShareInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceShareInvitationArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_invitation_arns`](Self::set_resource_share_invitation_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the invitations.</p>
        pub fn resource_share_invitation_arns(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the invitations.</p>
        pub fn set_resource_share_invitation_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arns(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceShares`.
    ///
    /// <p>Gets the resource shares that you own or the resource shares that are shared with you.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourceShares<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_shares_input::Builder,
    }
    impl<C, M, R> GetResourceShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceSharesInputOperationOutputAlias,
                crate::output::GetResourceSharesOutput,
                crate::error::GetResourceSharesError,
                crate::input::GetResourceSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resource shares.</p>
        pub fn resource_share_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>The status of the resource share.</p>
        pub fn resource_share_status(mut self, inp: crate::model::ResourceShareStatus) -> Self {
            self.inner = self.inner.resource_share_status(inp);
            self
        }
        /// <p>The status of the resource share.</p>
        pub fn set_resource_share_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareStatus>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_status(input);
            self
        }
        /// <p>The type of owner.</p>
        pub fn resource_owner(mut self, inp: crate::model::ResourceOwner) -> Self {
            self.inner = self.inner.resource_owner(inp);
            self
        }
        /// <p>The type of owner.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `tagFilters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>One or more tag filters.</p>
        pub fn tag_filters(mut self, inp: impl Into<crate::model::TagFilter>) -> Self {
            self.inner = self.inner.tag_filters(inp);
            self
        }
        /// <p>One or more tag filters.</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.inner = self.inner.set_tag_filters(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission that is associated with the
        /// resource share.</p>
        pub fn permission_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permission_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission that is associated with the
        /// resource share.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permission_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPendingInvitationResources`.
    ///
    /// <p>Lists the resources in a resource share that is shared with you but that the invitation is still
    /// pending for.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPendingInvitationResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pending_invitation_resources_input::Builder,
    }
    impl<C, M, R> ListPendingInvitationResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPendingInvitationResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPendingInvitationResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPendingInvitationResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPendingInvitationResourcesInputOperationOutputAlias,
                crate::output::ListPendingInvitationResourcesOutput,
                crate::error::ListPendingInvitationResourcesError,
                crate::input::ListPendingInvitationResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arn(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissions`.
    ///
    /// <p>Lists the RAM permissions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_permissions_input::Builder,
    }
    impl<C, M, R> ListPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPermissionsInputOperationOutputAlias,
                crate::output::ListPermissionsOutput,
                crate::error::ListPermissionsError,
                crate::input::ListPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the resource type for which to list permissions. For example, to list only
        /// permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>.</p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>Specifies the resource type for which to list permissions. For example, to list only
        /// permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrincipals`.
    ///
    /// <p>Lists the principals that you have shared resources with or that have shared resources
    /// with you.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPrincipals<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_principals_input::Builder,
    }
    impl<C, M, R> ListPrincipals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPrincipals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPrincipalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPrincipalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPrincipalsInputOperationOutputAlias,
                crate::output::ListPrincipalsOutput,
                crate::error::ListPrincipalsError,
                crate::input::ListPrincipalsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of owner.</p>
        pub fn resource_owner(mut self, inp: crate::model::ResourceOwner) -> Self {
            self.inner = self.inner.resource_owner(inp);
            self
        }
        /// <p>The type of owner.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals.</p>
        pub fn principals(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(inp);
            self
        }
        /// <p>The principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResources`.
    ///
    /// <p>Lists the resources that you added to a resource shares or the resources that are shared with
    /// you.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_input::Builder,
    }
    impl<C, M, R> ListResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesInputOperationOutputAlias,
                crate::output::ListResourcesOutput,
                crate::error::ListResourcesError,
                crate::input::ListResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of owner.</p>
        pub fn resource_owner(mut self, inp: crate::model::ResourceOwner) -> Self {
            self.inner = self.inner.resource_owner(inp);
            self
        }
        /// <p>The type of owner.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The principal.</p>
        pub fn principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>The principal.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `resourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// Appends an item to `resourceShareArns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arns(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceSharePermissions`.
    ///
    /// <p>Lists the RAM permissions that are associated with a resource share.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourceSharePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_share_permissions_input::Builder,
    }
    impl<C, M, R> ListResourceSharePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceSharePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceSharePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceSharePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceSharePermissionsInputOperationOutputAlias,
                crate::output::ListResourceSharePermissionsOutput,
                crate::error::ListResourceSharePermissionsError,
                crate::input::ListResourceSharePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceTypes`.
    ///
    /// <p>Lists the shareable resource types supported by RAM.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourceTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_types_input::Builder,
    }
    impl<C, M, R> ListResourceTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceTypesInputOperationOutputAlias,
                crate::output::ListResourceTypesOutput,
                crate::error::ListResourceTypesError,
                crate::input::ListResourceTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PromoteResourceShareCreatedFromPolicy`.
    ///
    /// <p>Resource shares that were created by attaching a policy to a resource are visible only
    /// to the resource share owner, and the resource share cannot be modified in RAM.</p>
    ///
    /// <p>Use this API action to promote the resource share. When you promote the resource
    /// share, it becomes:</p>
    /// <ul>
    /// <li>
    /// <p>Visible to all principals that it is shared with.</p>
    /// </li>
    /// <li>
    /// <p>Modifiable in RAM.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PromoteResourceShareCreatedFromPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::promote_resource_share_created_from_policy_input::Builder,
    }
    impl<C, M, R> PromoteResourceShareCreatedFromPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PromoteResourceShareCreatedFromPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PromoteResourceShareCreatedFromPolicyOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PromoteResourceShareCreatedFromPolicyError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PromoteResourceShareCreatedFromPolicyInputOperationOutputAlias,
                crate::output::PromoteResourceShareCreatedFromPolicyOutput,
                crate::error::PromoteResourceShareCreatedFromPolicyError,
                crate::input::PromoteResourceShareCreatedFromPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share to promote.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share to promote.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectResourceShareInvitation`.
    ///
    /// <p>Rejects an invitation to a resource share from another Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectResourceShareInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_resource_share_invitation_input::Builder,
    }
    impl<C, M, R> RejectResourceShareInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectResourceShareInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectResourceShareInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectResourceShareInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectResourceShareInvitationInputOperationOutputAlias,
                crate::output::RejectResourceShareInvitationOutput,
                crate::error::RejectResourceShareInvitationError,
                crate::input::RejectResourceShareInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_share_invitation_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_invitation_arn(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource share that you own.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource share that you own.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the tags to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceShare`.
    ///
    /// <p>Updates the specified resource share that you own.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResourceShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_share_input::Builder,
    }
    impl<C, M, R> UpdateResourceShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceShareInputOperationOutputAlias,
                crate::output::UpdateResourceShareOutput,
                crate::error::UpdateResourceShareError,
                crate::input::UpdateResourceShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_arn(input);
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn allow_external_principals(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_external_principals(inp);
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn set_allow_external_principals(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_external_principals(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
