// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a resource share.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShare {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource share.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the resource share.</p>
    pub owning_account_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether principals outside your organization in Organizations can be associated
    /// with a resource share.</p>
    pub allow_external_principals: std::option::Option<bool>,
    /// <p>The status of the resource share.</p>
    pub status: std::option::Option<crate::model::ResourceShareStatus>,
    /// <p>A message about the status of the resource share.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The tags for the resource share.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The time when the resource share was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the resource share was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates how the resource share was created. Possible values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an
    /// Amazon Web Services Identity and Access Management (Amazon Web Services IAM) policy attached to a resource.
    /// These resource shares are visible only to the Amazon Web Services account that created it. They cannot
    /// be modified in RAM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being
    /// promoted. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STANDARD</code> - Indicates that the resource share was created in RAM using the
    /// console or APIs. These resource shares are visible to all principals. They can
    /// be modified in RAM.</p>
    /// </li>
    /// </ul>
    pub feature_set: std::option::Option<crate::model::ResourceShareFeatureSet>,
}
impl ResourceShare {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The name of the resource share.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the resource share.</p>
    pub fn owning_account_id(&self) -> std::option::Option<&str> {
        self.owning_account_id.as_deref()
    }
    /// <p>Indicates whether principals outside your organization in Organizations can be associated
    /// with a resource share.</p>
    pub fn allow_external_principals(&self) -> std::option::Option<bool> {
        self.allow_external_principals
    }
    /// <p>The status of the resource share.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceShareStatus> {
        self.status.as_ref()
    }
    /// <p>A message about the status of the resource share.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The tags for the resource share.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The time when the resource share was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time when the resource share was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>Indicates how the resource share was created. Possible values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an
    /// Amazon Web Services Identity and Access Management (Amazon Web Services IAM) policy attached to a resource.
    /// These resource shares are visible only to the Amazon Web Services account that created it. They cannot
    /// be modified in RAM.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being
    /// promoted. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STANDARD</code> - Indicates that the resource share was created in RAM using the
    /// console or APIs. These resource shares are visible to all principals. They can
    /// be modified in RAM.</p>
    /// </li>
    /// </ul>
    pub fn feature_set(&self) -> std::option::Option<&crate::model::ResourceShareFeatureSet> {
        self.feature_set.as_ref()
    }
}
impl std::fmt::Debug for ResourceShare {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShare");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("name", &self.name);
        formatter.field("owning_account_id", &self.owning_account_id);
        formatter.field("allow_external_principals", &self.allow_external_principals);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("tags", &self.tags);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("feature_set", &self.feature_set);
        formatter.finish()
    }
}
/// See [`ResourceShare`](crate::model::ResourceShare)
pub mod resource_share {
    /// A builder for [`ResourceShare`](crate::model::ResourceShare)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owning_account_id: std::option::Option<std::string::String>,
        pub(crate) allow_external_principals: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::ResourceShareStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) feature_set: std::option::Option<crate::model::ResourceShareFeatureSet>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the resource share.</p>
        pub fn owning_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owning_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the resource share.</p>
        pub fn set_owning_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owning_account_id = input;
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn allow_external_principals(mut self, input: bool) -> Self {
            self.allow_external_principals = Some(input);
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn set_allow_external_principals(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_external_principals = input;
            self
        }
        /// <p>The status of the resource share.</p>
        pub fn status(mut self, input: crate::model::ResourceShareStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the resource share.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message about the status of the resource share.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message about the status of the resource share.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource share.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the resource share.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The time when the resource share was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the resource share was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time when the resource share was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time when the resource share was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Indicates how the resource share was created. Possible values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an
        /// Amazon Web Services Identity and Access Management (Amazon Web Services IAM) policy attached to a resource.
        /// These resource shares are visible only to the Amazon Web Services account that created it. They cannot
        /// be modified in RAM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being
        /// promoted. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code> - Indicates that the resource share was created in RAM using the
        /// console or APIs. These resource shares are visible to all principals. They can
        /// be modified in RAM.</p>
        /// </li>
        /// </ul>
        pub fn feature_set(mut self, input: crate::model::ResourceShareFeatureSet) -> Self {
            self.feature_set = Some(input);
            self
        }
        /// <p>Indicates how the resource share was created. Possible values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an
        /// Amazon Web Services Identity and Access Management (Amazon Web Services IAM) policy attached to a resource.
        /// These resource shares are visible only to the Amazon Web Services account that created it. They cannot
        /// be modified in RAM.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being
        /// promoted. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code> - Indicates that the resource share was created in RAM using the
        /// console or APIs. These resource shares are visible to all principals. They can
        /// be modified in RAM.</p>
        /// </li>
        /// </ul>
        pub fn set_feature_set(
            mut self,
            input: std::option::Option<crate::model::ResourceShareFeatureSet>,
        ) -> Self {
            self.feature_set = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShare`](crate::model::ResourceShare)
        pub fn build(self) -> crate::model::ResourceShare {
            crate::model::ResourceShare {
                resource_share_arn: self.resource_share_arn,
                name: self.name,
                owning_account_id: self.owning_account_id,
                allow_external_principals: self.allow_external_principals,
                status: self.status,
                status_message: self.status_message,
                tags: self.tags,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                feature_set: self.feature_set,
            }
        }
    }
}
impl ResourceShare {
    /// Creates a new builder-style object to manufacture [`ResourceShare`](crate::model::ResourceShare)
    pub fn builder() -> crate::model::resource_share::Builder {
        crate::model::resource_share::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceShareFeatureSet {
    #[allow(missing_docs)] // documentation missing in model
    CreatedFromPolicy,
    #[allow(missing_docs)] // documentation missing in model
    PromotingToStandard,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceShareFeatureSet {
    fn from(s: &str) -> Self {
        match s {
            "CREATED_FROM_POLICY" => ResourceShareFeatureSet::CreatedFromPolicy,
            "PROMOTING_TO_STANDARD" => ResourceShareFeatureSet::PromotingToStandard,
            "STANDARD" => ResourceShareFeatureSet::Standard,
            other => ResourceShareFeatureSet::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceShareFeatureSet {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceShareFeatureSet::from(s))
    }
}
impl ResourceShareFeatureSet {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceShareFeatureSet::CreatedFromPolicy => "CREATED_FROM_POLICY",
            ResourceShareFeatureSet::PromotingToStandard => "PROMOTING_TO_STANDARD",
            ResourceShareFeatureSet::Standard => "STANDARD",
            ResourceShareFeatureSet::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED_FROM_POLICY", "PROMOTING_TO_STANDARD", "STANDARD"]
    }
}
impl AsRef<str> for ResourceShareFeatureSet {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceShareStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceShareStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ResourceShareStatus::Active,
            "DELETED" => ResourceShareStatus::Deleted,
            "DELETING" => ResourceShareStatus::Deleting,
            "FAILED" => ResourceShareStatus::Failed,
            "PENDING" => ResourceShareStatus::Pending,
            other => ResourceShareStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceShareStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceShareStatus::from(s))
    }
}
impl ResourceShareStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceShareStatus::Active => "ACTIVE",
            ResourceShareStatus::Deleted => "DELETED",
            ResourceShareStatus::Deleting => "DELETING",
            ResourceShareStatus::Failed => "FAILED",
            ResourceShareStatus::Pending => "PENDING",
            ResourceShareStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "DELETING", "FAILED", "PENDING"]
    }
}
impl AsRef<str> for ResourceShareStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an invitation to join a resource share.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShareInvitation {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub resource_share_invitation_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource share.</p>
    pub resource_share_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that sent the invitation.</p>
    pub sender_account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that received the invitation.</p>
    pub receiver_account_id: std::option::Option<std::string::String>,
    /// <p>The date and time when the invitation was sent.</p>
    pub invitation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the invitation.</p>
    pub status: std::option::Option<crate::model::ResourceShareInvitationStatus>,
    /// <p>To view the resources associated with a pending resource share invitation, use <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
    /// ListPendingInvitationResources</a>.</p>
    pub resource_share_associations:
        std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM user or IAM role that received the
    /// invitation.</p>
    pub receiver_arn: std::option::Option<std::string::String>,
}
impl ResourceShareInvitation {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub fn resource_share_invitation_arn(&self) -> std::option::Option<&str> {
        self.resource_share_invitation_arn.as_deref()
    }
    /// <p>The name of the resource share.</p>
    pub fn resource_share_name(&self) -> std::option::Option<&str> {
        self.resource_share_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that sent the invitation.</p>
    pub fn sender_account_id(&self) -> std::option::Option<&str> {
        self.sender_account_id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that received the invitation.</p>
    pub fn receiver_account_id(&self) -> std::option::Option<&str> {
        self.receiver_account_id.as_deref()
    }
    /// <p>The date and time when the invitation was sent.</p>
    pub fn invitation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.invitation_timestamp.as_ref()
    }
    /// <p>The status of the invitation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceShareInvitationStatus> {
        self.status.as_ref()
    }
    /// <p>To view the resources associated with a pending resource share invitation, use <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
    /// ListPendingInvitationResources</a>.</p>
    pub fn resource_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceShareAssociation]> {
        self.resource_share_associations.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM user or IAM role that received the
    /// invitation.</p>
    pub fn receiver_arn(&self) -> std::option::Option<&str> {
        self.receiver_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceShareInvitation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShareInvitation");
        formatter.field(
            "resource_share_invitation_arn",
            &self.resource_share_invitation_arn,
        );
        formatter.field("resource_share_name", &self.resource_share_name);
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("sender_account_id", &self.sender_account_id);
        formatter.field("receiver_account_id", &self.receiver_account_id);
        formatter.field("invitation_timestamp", &self.invitation_timestamp);
        formatter.field("status", &self.status);
        formatter.field(
            "resource_share_associations",
            &self.resource_share_associations,
        );
        formatter.field("receiver_arn", &self.receiver_arn);
        formatter.finish()
    }
}
/// See [`ResourceShareInvitation`](crate::model::ResourceShareInvitation)
pub mod resource_share_invitation {
    /// A builder for [`ResourceShareInvitation`](crate::model::ResourceShareInvitation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitation_arn: std::option::Option<std::string::String>,
        pub(crate) resource_share_name: std::option::Option<std::string::String>,
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) sender_account_id: std::option::Option<std::string::String>,
        pub(crate) receiver_account_id: std::option::Option<std::string::String>,
        pub(crate) invitation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ResourceShareInvitationStatus>,
        pub(crate) resource_share_associations:
            std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        pub(crate) receiver_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = input;
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn resource_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_name = Some(input.into());
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_resource_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that sent the invitation.</p>
        pub fn sender_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that sent the invitation.</p>
        pub fn set_sender_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sender_account_id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that received the invitation.</p>
        pub fn receiver_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.receiver_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that received the invitation.</p>
        pub fn set_receiver_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.receiver_account_id = input;
            self
        }
        /// <p>The date and time when the invitation was sent.</p>
        pub fn invitation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.invitation_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the invitation was sent.</p>
        pub fn set_invitation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.invitation_timestamp = input;
            self
        }
        /// <p>The status of the invitation.</p>
        pub fn status(mut self, input: crate::model::ResourceShareInvitationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the invitation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareInvitationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `resource_share_associations`.
        ///
        /// To override the contents of this collection use [`set_resource_share_associations`](Self::set_resource_share_associations).
        ///
        /// <p>To view the resources associated with a pending resource share invitation, use <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
        /// ListPendingInvitationResources</a>.</p>
        pub fn resource_share_associations(
            mut self,
            input: impl Into<crate::model::ResourceShareAssociation>,
        ) -> Self {
            let mut v = self.resource_share_associations.unwrap_or_default();
            v.push(input.into());
            self.resource_share_associations = Some(v);
            self
        }
        /// <p>To view the resources associated with a pending resource share invitation, use <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_ListPendingInvitationResources.html">
        /// ListPendingInvitationResources</a>.</p>
        pub fn set_resource_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceShareAssociation>>,
        ) -> Self {
            self.resource_share_associations = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user or IAM role that received the
        /// invitation.</p>
        pub fn receiver_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.receiver_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM user or IAM role that received the
        /// invitation.</p>
        pub fn set_receiver_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.receiver_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShareInvitation`](crate::model::ResourceShareInvitation)
        pub fn build(self) -> crate::model::ResourceShareInvitation {
            crate::model::ResourceShareInvitation {
                resource_share_invitation_arn: self.resource_share_invitation_arn,
                resource_share_name: self.resource_share_name,
                resource_share_arn: self.resource_share_arn,
                sender_account_id: self.sender_account_id,
                receiver_account_id: self.receiver_account_id,
                invitation_timestamp: self.invitation_timestamp,
                status: self.status,
                resource_share_associations: self.resource_share_associations,
                receiver_arn: self.receiver_arn,
            }
        }
    }
}
impl ResourceShareInvitation {
    /// Creates a new builder-style object to manufacture [`ResourceShareInvitation`](crate::model::ResourceShareInvitation)
    pub fn builder() -> crate::model::resource_share_invitation::Builder {
        crate::model::resource_share_invitation::Builder::default()
    }
}

/// <p>Describes an association with a resource share.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceShareAssociation {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource share.</p>
    pub resource_share_name: std::option::Option<std::string::String>,
    /// <p>The associated entity. For resource associations, this is the Amazon Resource Name
    /// (ARN) of the resource. For principal associations, this is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>An Amazon Web Services account ID</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organization in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organizational unit (OU) in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM role</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM user</p>
    /// </li>
    /// </ul>
    pub associated_entity: std::option::Option<std::string::String>,
    /// <p>The association type.</p>
    pub association_type: std::option::Option<crate::model::ResourceShareAssociationType>,
    /// <p>The status of the association.</p>
    pub status: std::option::Option<crate::model::ResourceShareAssociationStatus>,
    /// <p>A message about the status of the association.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The time when the association was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the association was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
    /// Amazon Web Services account that owns the resource share.</p>
    pub external: std::option::Option<bool>,
}
impl ResourceShareAssociation {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The name of the resource share.</p>
    pub fn resource_share_name(&self) -> std::option::Option<&str> {
        self.resource_share_name.as_deref()
    }
    /// <p>The associated entity. For resource associations, this is the Amazon Resource Name
    /// (ARN) of the resource. For principal associations, this is one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>An Amazon Web Services account ID</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organization in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organizational unit (OU) in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM role</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM user</p>
    /// </li>
    /// </ul>
    pub fn associated_entity(&self) -> std::option::Option<&str> {
        self.associated_entity.as_deref()
    }
    /// <p>The association type.</p>
    pub fn association_type(
        &self,
    ) -> std::option::Option<&crate::model::ResourceShareAssociationType> {
        self.association_type.as_ref()
    }
    /// <p>The status of the association.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceShareAssociationStatus> {
        self.status.as_ref()
    }
    /// <p>A message about the status of the association.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The time when the association was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time when the association was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
    /// Amazon Web Services account that owns the resource share.</p>
    pub fn external(&self) -> std::option::Option<bool> {
        self.external
    }
}
impl std::fmt::Debug for ResourceShareAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceShareAssociation");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("resource_share_name", &self.resource_share_name);
        formatter.field("associated_entity", &self.associated_entity);
        formatter.field("association_type", &self.association_type);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("external", &self.external);
        formatter.finish()
    }
}
/// See [`ResourceShareAssociation`](crate::model::ResourceShareAssociation)
pub mod resource_share_association {
    /// A builder for [`ResourceShareAssociation`](crate::model::ResourceShareAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) resource_share_name: std::option::Option<std::string::String>,
        pub(crate) associated_entity: std::option::Option<std::string::String>,
        pub(crate) association_type:
            std::option::Option<crate::model::ResourceShareAssociationType>,
        pub(crate) status: std::option::Option<crate::model::ResourceShareAssociationStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) external: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn resource_share_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_name = Some(input.into());
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_resource_share_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_name = input;
            self
        }
        /// <p>The associated entity. For resource associations, this is the Amazon Resource Name
        /// (ARN) of the resource. For principal associations, this is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        pub fn associated_entity(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_entity = Some(input.into());
            self
        }
        /// <p>The associated entity. For resource associations, this is the Amazon Resource Name
        /// (ARN) of the resource. For principal associations, this is one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        pub fn set_associated_entity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_entity = input;
            self
        }
        /// <p>The association type.</p>
        pub fn association_type(
            mut self,
            input: crate::model::ResourceShareAssociationType,
        ) -> Self {
            self.association_type = Some(input);
            self
        }
        /// <p>The association type.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationType>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// <p>The status of the association.</p>
        pub fn status(mut self, input: crate::model::ResourceShareAssociationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the association.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message about the status of the association.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message about the status of the association.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The time when the association was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the association was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time when the association was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time when the association was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
        /// Amazon Web Services account that owns the resource share.</p>
        pub fn external(mut self, input: bool) -> Self {
            self.external = Some(input);
            self
        }
        /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
        /// Amazon Web Services account that owns the resource share.</p>
        pub fn set_external(mut self, input: std::option::Option<bool>) -> Self {
            self.external = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceShareAssociation`](crate::model::ResourceShareAssociation)
        pub fn build(self) -> crate::model::ResourceShareAssociation {
            crate::model::ResourceShareAssociation {
                resource_share_arn: self.resource_share_arn,
                resource_share_name: self.resource_share_name,
                associated_entity: self.associated_entity,
                association_type: self.association_type,
                status: self.status,
                status_message: self.status_message,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                external: self.external,
            }
        }
    }
}
impl ResourceShareAssociation {
    /// Creates a new builder-style object to manufacture [`ResourceShareAssociation`](crate::model::ResourceShareAssociation)
    pub fn builder() -> crate::model::resource_share_association::Builder {
        crate::model::resource_share_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceShareAssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Associated,
    #[allow(missing_docs)] // documentation missing in model
    Associating,
    #[allow(missing_docs)] // documentation missing in model
    Disassociated,
    #[allow(missing_docs)] // documentation missing in model
    Disassociating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceShareAssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ASSOCIATED" => ResourceShareAssociationStatus::Associated,
            "ASSOCIATING" => ResourceShareAssociationStatus::Associating,
            "DISASSOCIATED" => ResourceShareAssociationStatus::Disassociated,
            "DISASSOCIATING" => ResourceShareAssociationStatus::Disassociating,
            "FAILED" => ResourceShareAssociationStatus::Failed,
            other => ResourceShareAssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceShareAssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceShareAssociationStatus::from(s))
    }
}
impl ResourceShareAssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceShareAssociationStatus::Associated => "ASSOCIATED",
            ResourceShareAssociationStatus::Associating => "ASSOCIATING",
            ResourceShareAssociationStatus::Disassociated => "DISASSOCIATED",
            ResourceShareAssociationStatus::Disassociating => "DISASSOCIATING",
            ResourceShareAssociationStatus::Failed => "FAILED",
            ResourceShareAssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSOCIATED",
            "ASSOCIATING",
            "DISASSOCIATED",
            "DISASSOCIATING",
            "FAILED",
        ]
    }
}
impl AsRef<str> for ResourceShareAssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceShareAssociationType {
    #[allow(missing_docs)] // documentation missing in model
    Principal,
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceShareAssociationType {
    fn from(s: &str) -> Self {
        match s {
            "PRINCIPAL" => ResourceShareAssociationType::Principal,
            "RESOURCE" => ResourceShareAssociationType::Resource,
            other => ResourceShareAssociationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceShareAssociationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceShareAssociationType::from(s))
    }
}
impl ResourceShareAssociationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceShareAssociationType::Principal => "PRINCIPAL",
            ResourceShareAssociationType::Resource => "RESOURCE",
            ResourceShareAssociationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRINCIPAL", "RESOURCE"]
    }
}
impl AsRef<str> for ResourceShareAssociationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceShareInvitationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Accepted,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceShareInvitationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPTED" => ResourceShareInvitationStatus::Accepted,
            "EXPIRED" => ResourceShareInvitationStatus::Expired,
            "PENDING" => ResourceShareInvitationStatus::Pending,
            "REJECTED" => ResourceShareInvitationStatus::Rejected,
            other => ResourceShareInvitationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceShareInvitationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceShareInvitationStatus::from(s))
    }
}
impl ResourceShareInvitationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceShareInvitationStatus::Accepted => "ACCEPTED",
            ResourceShareInvitationStatus::Expired => "EXPIRED",
            ResourceShareInvitationStatus::Pending => "PENDING",
            ResourceShareInvitationStatus::Rejected => "REJECTED",
            ResourceShareInvitationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPTED", "EXPIRED", "PENDING", "REJECTED"]
    }
}
impl AsRef<str> for ResourceShareInvitationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the shareable resource types and the Amazon Web Services services to which they
/// belong.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNameAndResourceType {
    /// <p>The shareable resource types.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Web Services services to which the resources belong.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl ServiceNameAndResourceType {
    /// <p>The shareable resource types.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The name of the Amazon Web Services services to which the resources belong.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
}
impl std::fmt::Debug for ServiceNameAndResourceType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNameAndResourceType");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}
/// See [`ServiceNameAndResourceType`](crate::model::ServiceNameAndResourceType)
pub mod service_name_and_resource_type {
    /// A builder for [`ServiceNameAndResourceType`](crate::model::ServiceNameAndResourceType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The shareable resource types.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The shareable resource types.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The name of the Amazon Web Services services to which the resources belong.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services services to which the resources belong.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNameAndResourceType`](crate::model::ServiceNameAndResourceType)
        pub fn build(self) -> crate::model::ServiceNameAndResourceType {
            crate::model::ServiceNameAndResourceType {
                resource_type: self.resource_type,
                service_name: self.service_name,
            }
        }
    }
}
impl ServiceNameAndResourceType {
    /// Creates a new builder-style object to manufacture [`ServiceNameAndResourceType`](crate::model::ServiceNameAndResourceType)
    pub fn builder() -> crate::model::service_name_and_resource_type::Builder {
        crate::model::service_name_and_resource_type::Builder::default()
    }
}

/// <p>Information about a permission that is associated with a resource share.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSharePermissionSummary {
    /// <p>The Amazon Resource Name (ARN) of the permission.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The identifier for the version of the permission.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// permission.</p>
    pub default_version: std::option::Option<bool>,
    /// <p>The name of the permission.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of resource to which the permission applies.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The current status of the permission.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time when the permission was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the permission was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// resource type.</p>
    pub is_resource_type_default: std::option::Option<bool>,
}
impl ResourceSharePermissionSummary {
    /// <p>The Amazon Resource Name (ARN) of the permission.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The identifier for the version of the permission.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// permission.</p>
    pub fn default_version(&self) -> std::option::Option<bool> {
        self.default_version
    }
    /// <p>The name of the permission.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of resource to which the permission applies.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The current status of the permission.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time when the permission was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time when the permission was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// resource type.</p>
    pub fn is_resource_type_default(&self) -> std::option::Option<bool> {
        self.is_resource_type_default
    }
}
impl std::fmt::Debug for ResourceSharePermissionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSharePermissionSummary");
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("default_version", &self.default_version);
        formatter.field("name", &self.name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("is_resource_type_default", &self.is_resource_type_default);
        formatter.finish()
    }
}
/// See [`ResourceSharePermissionSummary`](crate::model::ResourceSharePermissionSummary)
pub mod resource_share_permission_summary {
    /// A builder for [`ResourceSharePermissionSummary`](crate::model::ResourceSharePermissionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) default_version: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) is_resource_type_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// permission.</p>
        pub fn default_version(mut self, input: bool) -> Self {
            self.default_version = Some(input);
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// permission.</p>
        pub fn set_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.default_version = input;
            self
        }
        /// <p>The name of the permission.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the permission.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of resource to which the permission applies.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource to which the permission applies.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The current status of the permission.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the permission.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the permission was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time when the permission was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time when the permission was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time when the permission was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// resource type.</p>
        pub fn is_resource_type_default(mut self, input: bool) -> Self {
            self.is_resource_type_default = Some(input);
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// resource type.</p>
        pub fn set_is_resource_type_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_resource_type_default = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSharePermissionSummary`](crate::model::ResourceSharePermissionSummary)
        pub fn build(self) -> crate::model::ResourceSharePermissionSummary {
            crate::model::ResourceSharePermissionSummary {
                arn: self.arn,
                version: self.version,
                default_version: self.default_version,
                name: self.name,
                resource_type: self.resource_type,
                status: self.status,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                is_resource_type_default: self.is_resource_type_default,
            }
        }
    }
}
impl ResourceSharePermissionSummary {
    /// Creates a new builder-style object to manufacture [`ResourceSharePermissionSummary`](crate::model::ResourceSharePermissionSummary)
    pub fn builder() -> crate::model::resource_share_permission_summary::Builder {
        crate::model::resource_share_permission_summary::Builder::default()
    }
}

/// <p>Describes a resource associated with a resource share.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource group. This value is returned only if
    /// the resource is a resource group.</p>
    pub resource_group_arn: std::option::Option<std::string::String>,
    /// <p>The status of the resource.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>A message about the status of the resource.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The time when the resource was associated with the resource share.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the association was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Resource {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The resource type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource group. This value is returned only if
    /// the resource is a resource group.</p>
    pub fn resource_group_arn(&self) -> std::option::Option<&str> {
        self.resource_group_arn.as_deref()
    }
    /// <p>The status of the resource.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>A message about the status of the resource.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The time when the resource was associated with the resource share.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time when the association was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("resource_group_arn", &self.resource_group_arn);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) resource_group_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource group. This value is returned only if
        /// the resource is a resource group.</p>
        pub fn resource_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource group. This value is returned only if
        /// the resource is a resource group.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_arn = input;
            self
        }
        /// <p>The status of the resource.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the resource.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message about the status of the resource.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message about the status of the resource.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The time when the resource was associated with the resource share.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the resource was associated with the resource share.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time when the association was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time when the association was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                arn: self.arn,
                r#type: self.r#type,
                resource_share_arn: self.resource_share_arn,
                resource_group_arn: self.resource_group_arn,
                status: self.status,
                status_message: self.status_message,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    #[allow(missing_docs)] // documentation missing in model
    ZonalResourceInaccessible,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ResourceStatus::Available,
            "LIMIT_EXCEEDED" => ResourceStatus::LimitExceeded,
            "PENDING" => ResourceStatus::Pending,
            "UNAVAILABLE" => ResourceStatus::Unavailable,
            "ZONAL_RESOURCE_INACCESSIBLE" => ResourceStatus::ZonalResourceInaccessible,
            other => ResourceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceStatus::from(s))
    }
}
impl ResourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceStatus::Available => "AVAILABLE",
            ResourceStatus::LimitExceeded => "LIMIT_EXCEEDED",
            ResourceStatus::Pending => "PENDING",
            ResourceStatus::Unavailable => "UNAVAILABLE",
            ResourceStatus::ZonalResourceInaccessible => "ZONAL_RESOURCE_INACCESSIBLE",
            ResourceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "LIMIT_EXCEEDED",
            "PENDING",
            "UNAVAILABLE",
            "ZONAL_RESOURCE_INACCESSIBLE",
        ]
    }
}
impl AsRef<str> for ResourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `ResourceOwner::Self` has been renamed to `::SelfValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceOwner {
    #[allow(missing_docs)] // documentation missing in model
    OtherAccounts,
    /// _Note: `::Self` has been renamed to `::SelfValue`._
    SelfValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceOwner {
    fn from(s: &str) -> Self {
        match s {
            "OTHER-ACCOUNTS" => ResourceOwner::OtherAccounts,
            "SELF" => ResourceOwner::SelfValue,
            other => ResourceOwner::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceOwner {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceOwner::from(s))
    }
}
impl ResourceOwner {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceOwner::OtherAccounts => "OTHER-ACCOUNTS",
            ResourceOwner::SelfValue => "SELF",
            ResourceOwner::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OTHER-ACCOUNTS", "SELF"]
    }
}
impl AsRef<str> for ResourceOwner {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a principal for use with Resource Access Manager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Principal {
    /// <p>The ID of the principal.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The time when the principal was associated with the resource share.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the association was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
    /// Amazon Web Services account that owns the resource share.</p>
    pub external: std::option::Option<bool>,
}
impl Principal {
    /// <p>The ID of the principal.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The time when the principal was associated with the resource share.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time when the association was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
    /// Amazon Web Services account that owns the resource share.</p>
    pub fn external(&self) -> std::option::Option<bool> {
        self.external
    }
}
impl std::fmt::Debug for Principal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Principal");
        formatter.field("id", &self.id);
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("external", &self.external);
        formatter.finish()
    }
}
/// See [`Principal`](crate::model::Principal)
pub mod principal {
    /// A builder for [`Principal`](crate::model::Principal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) external: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the principal.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the principal.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The time when the principal was associated with the resource share.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the principal was associated with the resource share.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time when the association was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time when the association was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
        /// Amazon Web Services account that owns the resource share.</p>
        pub fn external(mut self, input: bool) -> Self {
            self.external = Some(input);
            self
        }
        /// <p>Indicates whether the principal belongs to the same organization in Organizations as the
        /// Amazon Web Services account that owns the resource share.</p>
        pub fn set_external(mut self, input: std::option::Option<bool>) -> Self {
            self.external = input;
            self
        }
        /// Consumes the builder and constructs a [`Principal`](crate::model::Principal)
        pub fn build(self) -> crate::model::Principal {
            crate::model::Principal {
                id: self.id,
                resource_share_arn: self.resource_share_arn,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                external: self.external,
            }
        }
    }
}
impl Principal {
    /// Creates a new builder-style object to manufacture [`Principal`](crate::model::Principal)
    pub fn builder() -> crate::model::principal::Builder {
        crate::model::principal::Builder::default()
    }
}

/// <p>Used to filter information based on tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagFilter {
    /// <p>The tag key.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>The tag values.</p>
    pub tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl TagFilter {
    /// <p>The tag key.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>The tag values.</p>
    pub fn tag_values(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for TagFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagFilter");
        formatter.field("tag_key", &self.tag_key);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`TagFilter`](crate::model::TagFilter)
pub mod tag_filter {
    /// A builder for [`TagFilter`](crate::model::TagFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The tag values.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>The tag values.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagFilter`](crate::model::TagFilter)
        pub fn build(self) -> crate::model::TagFilter {
            crate::model::TagFilter {
                tag_key: self.tag_key,
                tag_values: self.tag_values,
            }
        }
    }
}
impl TagFilter {
    /// Creates a new builder-style object to manufacture [`TagFilter`](crate::model::TagFilter)
    pub fn builder() -> crate::model::tag_filter::Builder {
        crate::model::tag_filter::Builder::default()
    }
}

/// <p>Information about an RAM permission.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSharePermissionDetail {
    /// <p>The Amazon Resource Name (ARN) of the permission.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The identifier for the version of the permission.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// permission.</p>
    pub default_version: std::option::Option<bool>,
    /// <p>The name of the permission.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The resource type to which the permission applies.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The permission's effect and actions in JSON format. The <code>effect</code> indicates
    /// whether the actions are allowed or denied. The <code>actions</code> list the API actions
    /// to which the principal is granted or denied access.</p>
    pub permission: std::option::Option<std::string::String>,
    /// <p>The date and time when the permission was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the permission was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// resource type.</p>
    pub is_resource_type_default: std::option::Option<bool>,
}
impl ResourceSharePermissionDetail {
    /// <p>The Amazon Resource Name (ARN) of the permission.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The identifier for the version of the permission.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// permission.</p>
    pub fn default_version(&self) -> std::option::Option<bool> {
        self.default_version
    }
    /// <p>The name of the permission.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The resource type to which the permission applies.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The permission's effect and actions in JSON format. The <code>effect</code> indicates
    /// whether the actions are allowed or denied. The <code>actions</code> list the API actions
    /// to which the principal is granted or denied access.</p>
    pub fn permission(&self) -> std::option::Option<&str> {
        self.permission.as_deref()
    }
    /// <p>The date and time when the permission was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time when the permission was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>Specifies whether the version of the permission is set to the default version for this
    /// resource type.</p>
    pub fn is_resource_type_default(&self) -> std::option::Option<bool> {
        self.is_resource_type_default
    }
}
impl std::fmt::Debug for ResourceSharePermissionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSharePermissionDetail");
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("default_version", &self.default_version);
        formatter.field("name", &self.name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("permission", &self.permission);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("is_resource_type_default", &self.is_resource_type_default);
        formatter.finish()
    }
}
/// See [`ResourceSharePermissionDetail`](crate::model::ResourceSharePermissionDetail)
pub mod resource_share_permission_detail {
    /// A builder for [`ResourceSharePermissionDetail`](crate::model::ResourceSharePermissionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) default_version: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) permission: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) is_resource_type_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// permission.</p>
        pub fn default_version(mut self, input: bool) -> Self {
            self.default_version = Some(input);
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// permission.</p>
        pub fn set_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.default_version = input;
            self
        }
        /// <p>The name of the permission.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the permission.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The resource type to which the permission applies.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type to which the permission applies.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The permission's effect and actions in JSON format. The <code>effect</code> indicates
        /// whether the actions are allowed or denied. The <code>actions</code> list the API actions
        /// to which the principal is granted or denied access.</p>
        pub fn permission(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission = Some(input.into());
            self
        }
        /// <p>The permission's effect and actions in JSON format. The <code>effect</code> indicates
        /// whether the actions are allowed or denied. The <code>actions</code> list the API actions
        /// to which the principal is granted or denied access.</p>
        pub fn set_permission(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.permission = input;
            self
        }
        /// <p>The date and time when the permission was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time when the permission was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time when the permission was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time when the permission was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// resource type.</p>
        pub fn is_resource_type_default(mut self, input: bool) -> Self {
            self.is_resource_type_default = Some(input);
            self
        }
        /// <p>Specifies whether the version of the permission is set to the default version for this
        /// resource type.</p>
        pub fn set_is_resource_type_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_resource_type_default = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSharePermissionDetail`](crate::model::ResourceSharePermissionDetail)
        pub fn build(self) -> crate::model::ResourceSharePermissionDetail {
            crate::model::ResourceSharePermissionDetail {
                arn: self.arn,
                version: self.version,
                default_version: self.default_version,
                name: self.name,
                resource_type: self.resource_type,
                permission: self.permission,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                is_resource_type_default: self.is_resource_type_default,
            }
        }
    }
}
impl ResourceSharePermissionDetail {
    /// Creates a new builder-style object to manufacture [`ResourceSharePermissionDetail`](crate::model::ResourceSharePermissionDetail)
    pub fn builder() -> crate::model::resource_share_permission_detail::Builder {
        crate::model::resource_share_permission_detail::Builder::default()
    }
}
