// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptResourceShareInvitationInput`](crate::input::AcceptResourceShareInvitationInput)
pub mod accept_resource_share_invitation_input {
    /// A builder for [`AcceptResourceShareInvitationInput`](crate::input::AcceptResourceShareInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitation_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptResourceShareInvitationInput`](crate::input::AcceptResourceShareInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptResourceShareInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptResourceShareInvitationInput {
                resource_share_invitation_arn: self.resource_share_invitation_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptResourceShareInvitationInputOperationOutputAlias =
    crate::operation::AcceptResourceShareInvitation;
#[doc(hidden)]
pub type AcceptResourceShareInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptResourceShareInvitationInput {
    /// Consumes the builder and constructs an Operation<[`AcceptResourceShareInvitation`](crate::operation::AcceptResourceShareInvitation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptResourceShareInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptResourceShareInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/acceptresourceshareinvitation").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptResourceShareInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptResourceShareInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_resource_share_invitation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptResourceShareInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptResourceShareInvitation",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptResourceShareInvitationInput`](crate::input::AcceptResourceShareInvitationInput)
    pub fn builder() -> crate::input::accept_resource_share_invitation_input::Builder {
        crate::input::accept_resource_share_invitation_input::Builder::default()
    }
}

/// See [`AssociateResourceShareInput`](crate::input::AssociateResourceShareInput)
pub mod associate_resource_share_input {
    /// A builder for [`AssociateResourceShareInput`](crate::input::AssociateResourceShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResourceShareInput`](crate::input::AssociateResourceShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateResourceShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateResourceShareInput {
                resource_share_arn: self.resource_share_arn,
                resource_arns: self.resource_arns,
                principals: self.principals,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateResourceShareInputOperationOutputAlias = crate::operation::AssociateResourceShare;
#[doc(hidden)]
pub type AssociateResourceShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateResourceShareInput {
    /// Consumes the builder and constructs an Operation<[`AssociateResourceShare`](crate::operation::AssociateResourceShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateResourceShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateResourceShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/associateresourceshare").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateResourceShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateResourceShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_resource_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateResourceShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateResourceShare",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateResourceShareInput`](crate::input::AssociateResourceShareInput)
    pub fn builder() -> crate::input::associate_resource_share_input::Builder {
        crate::input::associate_resource_share_input::Builder::default()
    }
}

/// See [`AssociateResourceSharePermissionInput`](crate::input::AssociateResourceSharePermissionInput)
pub mod associate_resource_share_permission_input {
    /// A builder for [`AssociateResourceSharePermissionInput`](crate::input::AssociateResourceSharePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) permission_arn: std::option::Option<std::string::String>,
        pub(crate) replace: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) permission_version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission to associate with the
        /// resource share.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission to associate with the
        /// resource share.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_arn = input;
            self
        }
        /// <p>Indicates whether the permission should replace the permissions that are currently
        /// associated with the resource share. Use <code>true</code> to replace the current permissions. Use
        /// <code>false</code> to add the permission to the current permission.</p>
        pub fn replace(mut self, input: bool) -> Self {
            self.replace = Some(input);
            self
        }
        /// <p>Indicates whether the permission should replace the permissions that are currently
        /// associated with the resource share. Use <code>true</code> to replace the current permissions. Use
        /// <code>false</code> to add the permission to the current permission.</p>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.replace = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The version of the RAM permissions to associate with the resource share.</p>
        pub fn permission_version(mut self, input: i32) -> Self {
            self.permission_version = Some(input);
            self
        }
        /// <p>The version of the RAM permissions to associate with the resource share.</p>
        pub fn set_permission_version(mut self, input: std::option::Option<i32>) -> Self {
            self.permission_version = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResourceSharePermissionInput`](crate::input::AssociateResourceSharePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateResourceSharePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateResourceSharePermissionInput {
                resource_share_arn: self.resource_share_arn,
                permission_arn: self.permission_arn,
                replace: self.replace,
                client_token: self.client_token,
                permission_version: self.permission_version,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateResourceSharePermissionInputOperationOutputAlias =
    crate::operation::AssociateResourceSharePermission;
#[doc(hidden)]
pub type AssociateResourceSharePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateResourceSharePermissionInput {
    /// Consumes the builder and constructs an Operation<[`AssociateResourceSharePermission`](crate::operation::AssociateResourceSharePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateResourceSharePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateResourceSharePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/associateresourcesharepermission").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateResourceSharePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateResourceSharePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_resource_share_permission(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateResourceSharePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateResourceSharePermission",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateResourceSharePermissionInput`](crate::input::AssociateResourceSharePermissionInput)
    pub fn builder() -> crate::input::associate_resource_share_permission_input::Builder {
        crate::input::associate_resource_share_permission_input::Builder::default()
    }
}

/// See [`CreateResourceShareInput`](crate::input::CreateResourceShareInput)
pub mod create_resource_share_input {
    /// A builder for [`CreateResourceShareInput`](crate::input::CreateResourceShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) allow_external_principals: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) permission_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the resource share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The ARNs of the resources to associate with the resource share.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The ARNs of the resources to associate with the resource share.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The principals to associate with the resource share. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>An Amazon Web Services account ID</p>
        /// </li>
        /// <li>
        /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an organizational unit (OU) in Organizations</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM role</p>
        /// </li>
        /// <li>
        /// <p>An ARN of an IAM user</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
        /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn allow_external_principals(mut self, input: bool) -> Self {
            self.allow_external_principals = Some(input);
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn set_allow_external_principals(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_external_principals = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `permission_arns`.
        ///
        /// To override the contents of this collection use [`set_permission_arns`](Self::set_permission_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the permissions to associate with the resource share. If you
        /// do not specify an ARN for the permission, RAM automatically attaches the default
        /// version of the permission for each resource type. Only one permission can be associated
        /// with each resource type in a resource share.</p>
        pub fn permission_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.permission_arns.unwrap_or_default();
            v.push(input.into());
            self.permission_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the permissions to associate with the resource share. If you
        /// do not specify an ARN for the permission, RAM automatically attaches the default
        /// version of the permission for each resource type. Only one permission can be associated
        /// with each resource type in a resource share.</p>
        pub fn set_permission_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.permission_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceShareInput`](crate::input::CreateResourceShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceShareInput {
                name: self.name,
                resource_arns: self.resource_arns,
                principals: self.principals,
                tags: self.tags,
                allow_external_principals: self.allow_external_principals,
                client_token: self.client_token,
                permission_arns: self.permission_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceShareInputOperationOutputAlias = crate::operation::CreateResourceShare;
#[doc(hidden)]
pub type CreateResourceShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResourceShareInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourceShare`](crate::operation::CreateResourceShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourceShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createresourceshare").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resource_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourceShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourceShare",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceShareInput`](crate::input::CreateResourceShareInput)
    pub fn builder() -> crate::input::create_resource_share_input::Builder {
        crate::input::create_resource_share_input::Builder::default()
    }
}

/// See [`DeleteResourceShareInput`](crate::input::DeleteResourceShareInput)
pub mod delete_resource_share_input {
    /// A builder for [`DeleteResourceShareInput`](crate::input::DeleteResourceShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceShareInput`](crate::input::DeleteResourceShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceShareInput {
                resource_share_arn: self.resource_share_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceShareInputOperationOutputAlias = crate::operation::DeleteResourceShare;
#[doc(hidden)]
pub type DeleteResourceShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResourceShareInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourceShare`](crate::operation::DeleteResourceShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourceShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourceShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteresourceshare").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeleteResourceShareInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_1) = &_input.resource_share_arn {
                query.push_kv(
                    "resourceShareArn",
                    &aws_smithy_http::query::fmt_string(&inner_1),
                );
            }
            if let Some(inner_2) = &_input.client_token {
                query.push_kv("clientToken", &aws_smithy_http::query::fmt_string(&inner_2));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourceShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourceShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourceShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourceShare",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceShareInput`](crate::input::DeleteResourceShareInput)
    pub fn builder() -> crate::input::delete_resource_share_input::Builder {
        crate::input::delete_resource_share_input::Builder::default()
    }
}

/// See [`DisassociateResourceShareInput`](crate::input::DisassociateResourceShareInput)
pub mod disassociate_resource_share_input {
    /// A builder for [`DisassociateResourceShareInput`](crate::input::DisassociateResourceShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResourceShareInput`](crate::input::DisassociateResourceShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateResourceShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateResourceShareInput {
                resource_share_arn: self.resource_share_arn,
                resource_arns: self.resource_arns,
                principals: self.principals,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateResourceShareInputOperationOutputAlias =
    crate::operation::DisassociateResourceShare;
#[doc(hidden)]
pub type DisassociateResourceShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateResourceShareInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateResourceShare`](crate::operation::DisassociateResourceShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateResourceShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateResourceShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/disassociateresourceshare").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateResourceShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateResourceShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_resource_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateResourceShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateResourceShare",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateResourceShareInput`](crate::input::DisassociateResourceShareInput)
    pub fn builder() -> crate::input::disassociate_resource_share_input::Builder {
        crate::input::disassociate_resource_share_input::Builder::default()
    }
}

/// See [`DisassociateResourceSharePermissionInput`](crate::input::DisassociateResourceSharePermissionInput)
pub mod disassociate_resource_share_permission_input {
    /// A builder for [`DisassociateResourceSharePermissionInput`](crate::input::DisassociateResourceSharePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) permission_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission to disassociate from the resource share.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission to disassociate from the resource share.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_arn = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResourceSharePermissionInput`](crate::input::DisassociateResourceSharePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateResourceSharePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateResourceSharePermissionInput {
                resource_share_arn: self.resource_share_arn,
                permission_arn: self.permission_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateResourceSharePermissionInputOperationOutputAlias =
    crate::operation::DisassociateResourceSharePermission;
#[doc(hidden)]
pub type DisassociateResourceSharePermissionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateResourceSharePermissionInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateResourceSharePermission`](crate::operation::DisassociateResourceSharePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateResourceSharePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateResourceSharePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/disassociateresourcesharepermission")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateResourceSharePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateResourceSharePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_resource_share_permission(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateResourceSharePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateResourceSharePermission",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateResourceSharePermissionInput`](crate::input::DisassociateResourceSharePermissionInput)
    pub fn builder() -> crate::input::disassociate_resource_share_permission_input::Builder {
        crate::input::disassociate_resource_share_permission_input::Builder::default()
    }
}

/// See [`EnableSharingWithAwsOrganizationInput`](crate::input::EnableSharingWithAwsOrganizationInput)
pub mod enable_sharing_with_aws_organization_input {
    /// A builder for [`EnableSharingWithAwsOrganizationInput`](crate::input::EnableSharingWithAwsOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableSharingWithAwsOrganizationInput`](crate::input::EnableSharingWithAwsOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableSharingWithAwsOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableSharingWithAwsOrganizationInput {})
        }
    }
}
#[doc(hidden)]
pub type EnableSharingWithAwsOrganizationInputOperationOutputAlias =
    crate::operation::EnableSharingWithAwsOrganization;
#[doc(hidden)]
pub type EnableSharingWithAwsOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableSharingWithAwsOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`EnableSharingWithAwsOrganization`](crate::operation::EnableSharingWithAwsOrganization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableSharingWithAwsOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableSharingWithAwsOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/enablesharingwithawsorganization").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableSharingWithAwsOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableSharingWithAwsOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableSharingWithAwsOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableSharingWithAwsOrganization",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableSharingWithAwsOrganizationInput`](crate::input::EnableSharingWithAwsOrganizationInput)
    pub fn builder() -> crate::input::enable_sharing_with_aws_organization_input::Builder {
        crate::input::enable_sharing_with_aws_organization_input::Builder::default()
    }
}

/// See [`GetPermissionInput`](crate::input::GetPermissionInput)
pub mod get_permission_input {
    /// A builder for [`GetPermissionInput`](crate::input::GetPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_arn: std::option::Option<std::string::String>,
        pub(crate) permission_version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the permission.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_arn = input;
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn permission_version(mut self, input: i32) -> Self {
            self.permission_version = Some(input);
            self
        }
        /// <p>The identifier for the version of the permission.</p>
        pub fn set_permission_version(mut self, input: std::option::Option<i32>) -> Self {
            self.permission_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPermissionInput`](crate::input::GetPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPermissionInput {
                permission_arn: self.permission_arn,
                permission_version: self.permission_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPermissionInputOperationOutputAlias = crate::operation::GetPermission;
#[doc(hidden)]
pub type GetPermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPermissionInput {
    /// Consumes the builder and constructs an Operation<[`GetPermission`](crate::operation::GetPermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getpermission").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_permission(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPermission",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPermissionInput`](crate::input::GetPermissionInput)
    pub fn builder() -> crate::input::get_permission_input::Builder {
        crate::input::get_permission_input::Builder::default()
    }
}

/// See [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
pub mod get_resource_policies_input {
    /// A builder for [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// <p>The principal.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The principal.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourcePoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourcePoliciesInput {
                resource_arns: self.resource_arns,
                principal: self.principal,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourcePoliciesInputOperationOutputAlias = crate::operation::GetResourcePolicies;
#[doc(hidden)]
pub type GetResourcePoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourcePoliciesInput {
    /// Consumes the builder and constructs an Operation<[`GetResourcePolicies`](crate::operation::GetResourcePolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourcePolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourcePoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getresourcepolicies").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourcePoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourcePoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resource_policies(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourcePolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourcePolicies",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
    pub fn builder() -> crate::input::get_resource_policies_input::Builder {
        crate::input::get_resource_policies_input::Builder::default()
    }
}

/// See [`GetResourceShareAssociationsInput`](crate::input::GetResourceShareAssociationsInput)
pub mod get_resource_share_associations_input {
    /// A builder for [`GetResourceShareAssociationsInput`](crate::input::GetResourceShareAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_type:
            std::option::Option<crate::model::ResourceShareAssociationType>,
        pub(crate) resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) association_status:
            std::option::Option<crate::model::ResourceShareAssociationStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The association type. Specify <code>PRINCIPAL</code> to list the principals that are
        /// associated with the specified resource share. Specify <code>RESOURCE</code> to list the resources
        /// that are associated with the specified resource share.</p>
        pub fn association_type(
            mut self,
            input: crate::model::ResourceShareAssociationType,
        ) -> Self {
            self.association_type = Some(input);
            self
        }
        /// <p>The association type. Specify <code>PRINCIPAL</code> to list the principals that are
        /// associated with the specified resource share. Specify <code>RESOURCE</code> to list the resources
        /// that are associated with the specified resource share.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationType>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// Appends an item to `resource_share_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_share_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_share_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_share_arns = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter if
        /// the association type is <code>PRINCIPAL</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter if
        /// the association type is <code>PRINCIPAL</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The principal. You cannot specify this parameter if the association type is
        /// <code>RESOURCE</code>.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The principal. You cannot specify this parameter if the association type is
        /// <code>RESOURCE</code>.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>The association status.</p>
        pub fn association_status(
            mut self,
            input: crate::model::ResourceShareAssociationStatus,
        ) -> Self {
            self.association_status = Some(input);
            self
        }
        /// <p>The association status.</p>
        pub fn set_association_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareAssociationStatus>,
        ) -> Self {
            self.association_status = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceShareAssociationsInput`](crate::input::GetResourceShareAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceShareAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceShareAssociationsInput {
                association_type: self.association_type,
                resource_share_arns: self.resource_share_arns,
                resource_arn: self.resource_arn,
                principal: self.principal,
                association_status: self.association_status,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceShareAssociationsInputOperationOutputAlias =
    crate::operation::GetResourceShareAssociations;
#[doc(hidden)]
pub type GetResourceShareAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourceShareAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceShareAssociations`](crate::operation::GetResourceShareAssociations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceShareAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceShareAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getresourceshareassociations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceShareAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceShareAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resource_share_associations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceShareAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceShareAssociations",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceShareAssociationsInput`](crate::input::GetResourceShareAssociationsInput)
    pub fn builder() -> crate::input::get_resource_share_associations_input::Builder {
        crate::input::get_resource_share_associations_input::Builder::default()
    }
}

/// See [`GetResourceShareInvitationsInput`](crate::input::GetResourceShareInvitationsInput)
pub mod get_resource_share_invitations_input {
    /// A builder for [`GetResourceShareInvitationsInput`](crate::input::GetResourceShareInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitation_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `resource_share_invitation_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_invitation_arns`](Self::set_resource_share_invitation_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the invitations.</p>
        pub fn resource_share_invitation_arns(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.resource_share_invitation_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_share_invitation_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the invitations.</p>
        pub fn set_resource_share_invitation_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_share_invitation_arns = input;
            self
        }
        /// Appends an item to `resource_share_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_share_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_share_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_share_arns = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceShareInvitationsInput`](crate::input::GetResourceShareInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceShareInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceShareInvitationsInput {
                resource_share_invitation_arns: self.resource_share_invitation_arns,
                resource_share_arns: self.resource_share_arns,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceShareInvitationsInputOperationOutputAlias =
    crate::operation::GetResourceShareInvitations;
#[doc(hidden)]
pub type GetResourceShareInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourceShareInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceShareInvitations`](crate::operation::GetResourceShareInvitations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceShareInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceShareInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getresourceshareinvitations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceShareInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceShareInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resource_share_invitations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceShareInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceShareInvitations",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceShareInvitationsInput`](crate::input::GetResourceShareInvitationsInput)
    pub fn builder() -> crate::input::get_resource_share_invitations_input::Builder {
        crate::input::get_resource_share_invitations_input::Builder::default()
    }
}

/// See [`GetResourceSharesInput`](crate::input::GetResourceSharesInput)
pub mod get_resource_shares_input {
    /// A builder for [`GetResourceSharesInput`](crate::input::GetResourceSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_share_status: std::option::Option<crate::model::ResourceShareStatus>,
        pub(crate) resource_owner: std::option::Option<crate::model::ResourceOwner>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tag_filters: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) permission_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_share_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resource shares.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_share_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_share_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_share_arns = input;
            self
        }
        /// <p>The status of the resource share.</p>
        pub fn resource_share_status(mut self, input: crate::model::ResourceShareStatus) -> Self {
            self.resource_share_status = Some(input);
            self
        }
        /// <p>The status of the resource share.</p>
        pub fn set_resource_share_status(
            mut self,
            input: std::option::Option<crate::model::ResourceShareStatus>,
        ) -> Self {
            self.resource_share_status = input;
            self
        }
        /// <p>The type of owner.</p>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.resource_owner = Some(input);
            self
        }
        /// <p>The type of owner.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tag_filters`.
        ///
        /// To override the contents of this collection use [`set_tag_filters`](Self::set_tag_filters).
        ///
        /// <p>One or more tag filters.</p>
        pub fn tag_filters(mut self, input: impl Into<crate::model::TagFilter>) -> Self {
            let mut v = self.tag_filters.unwrap_or_default();
            v.push(input.into());
            self.tag_filters = Some(v);
            self
        }
        /// <p>One or more tag filters.</p>
        pub fn set_tag_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
        ) -> Self {
            self.tag_filters = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission that is associated with the
        /// resource share.</p>
        pub fn permission_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permission_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RAM permission that is associated with the
        /// resource share.</p>
        pub fn set_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permission_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceSharesInput`](crate::input::GetResourceSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceSharesInput {
                resource_share_arns: self.resource_share_arns,
                resource_share_status: self.resource_share_status,
                resource_owner: self.resource_owner,
                name: self.name,
                tag_filters: self.tag_filters,
                next_token: self.next_token,
                max_results: self.max_results,
                permission_arn: self.permission_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceSharesInputOperationOutputAlias = crate::operation::GetResourceShares;
#[doc(hidden)]
pub type GetResourceSharesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourceSharesInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceShares`](crate::operation::GetResourceShares)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceShares,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getresourceshares").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resource_shares(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceShares",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceSharesInput`](crate::input::GetResourceSharesInput)
    pub fn builder() -> crate::input::get_resource_shares_input::Builder {
        crate::input::get_resource_shares_input::Builder::default()
    }
}

/// See [`ListPendingInvitationResourcesInput`](crate::input::ListPendingInvitationResourcesInput)
pub mod list_pending_invitation_resources_input {
    /// A builder for [`ListPendingInvitationResourcesInput`](crate::input::ListPendingInvitationResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitation_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPendingInvitationResourcesInput`](crate::input::ListPendingInvitationResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPendingInvitationResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPendingInvitationResourcesInput {
                resource_share_invitation_arn: self.resource_share_invitation_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPendingInvitationResourcesInputOperationOutputAlias =
    crate::operation::ListPendingInvitationResources;
#[doc(hidden)]
pub type ListPendingInvitationResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPendingInvitationResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListPendingInvitationResources`](crate::operation::ListPendingInvitationResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPendingInvitationResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPendingInvitationResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listpendinginvitationresources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPendingInvitationResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPendingInvitationResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_pending_invitation_resources(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPendingInvitationResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPendingInvitationResources",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPendingInvitationResourcesInput`](crate::input::ListPendingInvitationResourcesInput)
    pub fn builder() -> crate::input::list_pending_invitation_resources_input::Builder {
        crate::input::list_pending_invitation_resources_input::Builder::default()
    }
}

/// See [`ListPermissionsInput`](crate::input::ListPermissionsInput)
pub mod list_permissions_input {
    /// A builder for [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the resource type for which to list permissions. For example, to list only
        /// permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Specifies the resource type for which to list permissions. For example, to list only
        /// permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionsInput`](crate::input::ListPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionsInput {
                resource_type: self.resource_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionsInputOperationOutputAlias = crate::operation::ListPermissions;
#[doc(hidden)]
pub type ListPermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissions`](crate::operation::ListPermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listpermissions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_permissions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissions",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    pub fn builder() -> crate::input::list_permissions_input::Builder {
        crate::input::list_permissions_input::Builder::default()
    }
}

/// See [`ListPrincipalsInput`](crate::input::ListPrincipalsInput)
pub mod list_principals_input {
    /// A builder for [`ListPrincipalsInput`](crate::input::ListPrincipalsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_owner: std::option::Option<crate::model::ResourceOwner>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of owner.</p>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.resource_owner = Some(input);
            self
        }
        /// <p>The type of owner.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_share_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_share_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_share_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_share_arns = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPrincipalsInput`](crate::input::ListPrincipalsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPrincipalsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPrincipalsInput {
                resource_owner: self.resource_owner,
                resource_arn: self.resource_arn,
                principals: self.principals,
                resource_type: self.resource_type,
                resource_share_arns: self.resource_share_arns,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPrincipalsInputOperationOutputAlias = crate::operation::ListPrincipals;
#[doc(hidden)]
pub type ListPrincipalsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPrincipalsInput {
    /// Consumes the builder and constructs an Operation<[`ListPrincipals`](crate::operation::ListPrincipals)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPrincipals,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPrincipalsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listprincipals").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPrincipalsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPrincipalsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_principals(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPrincipals::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPrincipals",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPrincipalsInput`](crate::input::ListPrincipalsInput)
    pub fn builder() -> crate::input::list_principals_input::Builder {
        crate::input::list_principals_input::Builder::default()
    }
}

/// See [`ListResourcesInput`](crate::input::ListResourcesInput)
pub mod list_resources_input {
    /// A builder for [`ListResourcesInput`](crate::input::ListResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_owner: std::option::Option<crate::model::ResourceOwner>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of owner.</p>
        pub fn resource_owner(mut self, input: crate::model::ResourceOwner) -> Self {
            self.resource_owner = Some(input);
            self
        }
        /// <p>The type of owner.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<crate::model::ResourceOwner>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The principal.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The principal.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
        /// </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Appends an item to `resource_share_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_share_arns`](Self::set_resource_share_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn resource_share_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_share_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_share_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
        pub fn set_resource_share_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_share_arns = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourcesInput`](crate::input::ListResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourcesInput {
                resource_owner: self.resource_owner,
                principal: self.principal,
                resource_type: self.resource_type,
                resource_arns: self.resource_arns,
                resource_share_arns: self.resource_share_arns,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourcesInputOperationOutputAlias = crate::operation::ListResources;
#[doc(hidden)]
pub type ListResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListResources`](crate::operation::ListResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listresources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_resources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResources",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourcesInput`](crate::input::ListResourcesInput)
    pub fn builder() -> crate::input::list_resources_input::Builder {
        crate::input::list_resources_input::Builder::default()
    }
}

/// See [`ListResourceSharePermissionsInput`](crate::input::ListResourceSharePermissionsInput)
pub mod list_resource_share_permissions_input {
    /// A builder for [`ListResourceSharePermissionsInput`](crate::input::ListResourceSharePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceSharePermissionsInput`](crate::input::ListResourceSharePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceSharePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceSharePermissionsInput {
                resource_share_arn: self.resource_share_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceSharePermissionsInputOperationOutputAlias =
    crate::operation::ListResourceSharePermissions;
#[doc(hidden)]
pub type ListResourceSharePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceSharePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceSharePermissions`](crate::operation::ListResourceSharePermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceSharePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceSharePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listresourcesharepermissions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceSharePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceSharePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resource_share_permissions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceSharePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceSharePermissions",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceSharePermissionsInput`](crate::input::ListResourceSharePermissionsInput)
    pub fn builder() -> crate::input::list_resource_share_permissions_input::Builder {
        crate::input::list_resource_share_permissions_input::Builder::default()
    }
}

/// See [`ListResourceTypesInput`](crate::input::ListResourceTypesInput)
pub mod list_resource_types_input {
    /// A builder for [`ListResourceTypesInput`](crate::input::ListResourceTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call.
        /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceTypesInput`](crate::input::ListResourceTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceTypesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceTypesInputOperationOutputAlias = crate::operation::ListResourceTypes;
#[doc(hidden)]
pub type ListResourceTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceTypes`](crate::operation::ListResourceTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listresourcetypes").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resource_types(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceTypes",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceTypesInput`](crate::input::ListResourceTypesInput)
    pub fn builder() -> crate::input::list_resource_types_input::Builder {
        crate::input::list_resource_types_input::Builder::default()
    }
}

/// See [`PromoteResourceShareCreatedFromPolicyInput`](crate::input::PromoteResourceShareCreatedFromPolicyInput)
pub mod promote_resource_share_created_from_policy_input {
    /// A builder for [`PromoteResourceShareCreatedFromPolicyInput`](crate::input::PromoteResourceShareCreatedFromPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share to promote.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share to promote.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PromoteResourceShareCreatedFromPolicyInput`](crate::input::PromoteResourceShareCreatedFromPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PromoteResourceShareCreatedFromPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PromoteResourceShareCreatedFromPolicyInput {
                resource_share_arn: self.resource_share_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PromoteResourceShareCreatedFromPolicyInputOperationOutputAlias =
    crate::operation::PromoteResourceShareCreatedFromPolicy;
#[doc(hidden)]
pub type PromoteResourceShareCreatedFromPolicyInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl PromoteResourceShareCreatedFromPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PromoteResourceShareCreatedFromPolicy`](crate::operation::PromoteResourceShareCreatedFromPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PromoteResourceShareCreatedFromPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PromoteResourceShareCreatedFromPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/promoteresourcesharecreatedfrompolicy")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::PromoteResourceShareCreatedFromPolicyInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.resource_share_arn {
                query.push_kv(
                    "resourceShareArn",
                    &aws_smithy_http::query::fmt_string(&inner_3),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PromoteResourceShareCreatedFromPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PromoteResourceShareCreatedFromPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PromoteResourceShareCreatedFromPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PromoteResourceShareCreatedFromPolicy",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PromoteResourceShareCreatedFromPolicyInput`](crate::input::PromoteResourceShareCreatedFromPolicyInput)
    pub fn builder() -> crate::input::promote_resource_share_created_from_policy_input::Builder {
        crate::input::promote_resource_share_created_from_policy_input::Builder::default()
    }
}

/// See [`RejectResourceShareInvitationInput`](crate::input::RejectResourceShareInvitationInput)
pub mod reject_resource_share_invitation_input {
    /// A builder for [`RejectResourceShareInvitationInput`](crate::input::RejectResourceShareInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_invitation_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn resource_share_invitation_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
        pub fn set_resource_share_invitation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_invitation_arn = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectResourceShareInvitationInput`](crate::input::RejectResourceShareInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectResourceShareInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectResourceShareInvitationInput {
                resource_share_invitation_arn: self.resource_share_invitation_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectResourceShareInvitationInputOperationOutputAlias =
    crate::operation::RejectResourceShareInvitation;
#[doc(hidden)]
pub type RejectResourceShareInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RejectResourceShareInvitationInput {
    /// Consumes the builder and constructs an Operation<[`RejectResourceShareInvitation`](crate::operation::RejectResourceShareInvitation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectResourceShareInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectResourceShareInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/rejectresourceshareinvitation").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectResourceShareInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectResourceShareInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reject_resource_share_invitation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectResourceShareInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectResourceShareInvitation",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectResourceShareInvitationInput`](crate::input::RejectResourceShareInvitationInput)
    pub fn builder() -> crate::input::reject_resource_share_invitation_input::Builder {
        crate::input::reject_resource_share_invitation_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_share_arn: self.resource_share_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/tagresource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_share_arn: self.resource_share_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/untagresource").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateResourceShareInput`](crate::input::UpdateResourceShareInput)
pub mod update_resource_share_input {
    /// A builder for [`UpdateResourceShareInput`](crate::input::UpdateResourceShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_share_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) allow_external_principals: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn resource_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
        pub fn set_resource_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_share_arn = input;
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn allow_external_principals(mut self, input: bool) -> Self {
            self.allow_external_principals = Some(input);
            self
        }
        /// <p>Indicates whether principals outside your organization in Organizations can be associated
        /// with a resource share.</p>
        pub fn set_allow_external_principals(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_external_principals = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceShareInput`](crate::input::UpdateResourceShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceShareInput {
                resource_share_arn: self.resource_share_arn,
                name: self.name,
                allow_external_principals: self.allow_external_principals,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceShareInputOperationOutputAlias = crate::operation::UpdateResourceShare;
#[doc(hidden)]
pub type UpdateResourceShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResourceShareInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResourceShare`](crate::operation::UpdateResourceShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResourceShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResourceShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateresourceshare").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResourceShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResourceShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resource_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResourceShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResourceShare",
            "ram",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceShareInput`](crate::input::UpdateResourceShareInput)
    pub fn builder() -> crate::input::update_resource_share_input::Builder {
        crate::input::update_resource_share_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource share.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates whether principals outside your organization in Organizations can be associated
    /// with a resource share.</p>
    pub allow_external_principals: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The name of the resource share.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Indicates whether principals outside your organization in Organizations can be associated
    /// with a resource share.</p>
    pub fn allow_external_principals(&self) -> std::option::Option<bool> {
        self.allow_external_principals
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateResourceShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceShareInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("name", &self.name);
        formatter.field("allow_external_principals", &self.allow_external_principals);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys of the tags to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The tag keys of the tags to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>One or more tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectResourceShareInvitationInput {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub resource_share_invitation_arn: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl RejectResourceShareInvitationInput {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub fn resource_share_invitation_arn(&self) -> std::option::Option<&str> {
        self.resource_share_invitation_arn.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for RejectResourceShareInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectResourceShareInvitationInput");
        formatter.field(
            "resource_share_invitation_arn",
            &self.resource_share_invitation_arn,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromoteResourceShareCreatedFromPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share to promote.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
}
impl PromoteResourceShareCreatedFromPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share to promote.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
}
impl std::fmt::Debug for PromoteResourceShareCreatedFromPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromoteResourceShareCreatedFromPolicyInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceTypesInput {
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListResourceTypesInput {
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListResourceTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceTypesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceSharePermissionsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListResourceSharePermissionsInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListResourceSharePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceSharePermissionsInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourcesInput {
    /// <p>The type of owner.</p>
    pub resource_owner: std::option::Option<crate::model::ResourceOwner>,
    /// <p>The principal.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
    /// </p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListResourcesInput {
    /// <p>The type of owner.</p>
    pub fn resource_owner(&self) -> std::option::Option<&crate::model::ResourceOwner> {
        self.resource_owner.as_ref()
    }
    /// <p>The principal.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>The resource type.</p>
    /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
    /// </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub fn resource_share_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_share_arns.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourcesInput");
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("principal", &self.principal);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("resource_share_arns", &self.resource_share_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPrincipalsInput {
    /// <p>The type of owner.</p>
    pub resource_owner: std::option::Option<crate::model::ResourceOwner>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The principals.</p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The resource type.</p>
    /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
    /// </p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPrincipalsInput {
    /// <p>The type of owner.</p>
    pub fn resource_owner(&self) -> std::option::Option<&crate::model::ResourceOwner> {
        self.resource_owner.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The principals.</p>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>The resource type.</p>
    /// <p>Valid values: <code>acm-pca:CertificateAuthority</code> | <code>appmesh:Mesh</code> | <code>codebuild:Project</code> | <code>codebuild:ReportGroup</code> | <code>ec2:CapacityReservation</code> | <code>ec2:DedicatedHost</code> | <code>ec2:LocalGatewayRouteTable</code> | <code>ec2:PrefixList</code> | <code>ec2:Subnet</code> | <code>ec2:TrafficMirrorTarget</code> | <code>ec2:TransitGateway</code> | <code>imagebuilder:Component</code> | <code>imagebuilder:Image</code> | <code>imagebuilder:ImageRecipe</code> | <code>imagebuilder:ContainerRecipe</code> | <code>glue:Catalog</code> | <code>glue:Database</code> | <code>glue:Table</code> | <code>license-manager:LicenseConfiguration</code> I <code>network-firewall:FirewallPolicy</code> | <code>network-firewall:StatefulRuleGroup</code> | <code>network-firewall:StatelessRuleGroup</code> | <code>outposts:Outpost</code> | <code>resource-groups:Group</code> | <code>rds:Cluster</code> | <code>route53resolver:FirewallRuleGroup</code> |<code>route53resolver:ResolverQueryLogConfig</code> | <code>route53resolver:ResolverRule</code> | <code>s3-outposts:Outpost</code> | <code>ssm-contacts:Contact</code> | <code>ssm-incidents:ResponsePlan</code>
    /// </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub fn resource_share_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_share_arns.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPrincipalsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPrincipalsInput");
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("principals", &self.principals);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_share_arns", &self.resource_share_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionsInput {
    /// <p>Specifies the resource type for which to list permissions. For example, to list only
    /// permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPermissionsInput {
    /// <p>Specifies the resource type for which to list permissions. For example, to list only
    /// permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionsInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPendingInvitationResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub resource_share_invitation_arn: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPendingInvitationResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub fn resource_share_invitation_arn(&self) -> std::option::Option<&str> {
        self.resource_share_invitation_arn.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPendingInvitationResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPendingInvitationResourcesInput");
        formatter.field(
            "resource_share_invitation_arn",
            &self.resource_share_invitation_arn,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceSharesInput {
    /// <p>The Amazon Resource Names (ARNs) of the resource shares.</p>
    pub resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the resource share.</p>
    pub resource_share_status: std::option::Option<crate::model::ResourceShareStatus>,
    /// <p>The type of owner.</p>
    pub resource_owner: std::option::Option<crate::model::ResourceOwner>,
    /// <p>The name of the resource share.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more tag filters.</p>
    pub tag_filters: std::option::Option<std::vec::Vec<crate::model::TagFilter>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the RAM permission that is associated with the
    /// resource share.</p>
    pub permission_arn: std::option::Option<std::string::String>,
}
impl GetResourceSharesInput {
    /// <p>The Amazon Resource Names (ARNs) of the resource shares.</p>
    pub fn resource_share_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_share_arns.as_deref()
    }
    /// <p>The status of the resource share.</p>
    pub fn resource_share_status(&self) -> std::option::Option<&crate::model::ResourceShareStatus> {
        self.resource_share_status.as_ref()
    }
    /// <p>The type of owner.</p>
    pub fn resource_owner(&self) -> std::option::Option<&crate::model::ResourceOwner> {
        self.resource_owner.as_ref()
    }
    /// <p>The name of the resource share.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more tag filters.</p>
    pub fn tag_filters(&self) -> std::option::Option<&[crate::model::TagFilter]> {
        self.tag_filters.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The Amazon Resource Name (ARN) of the RAM permission that is associated with the
    /// resource share.</p>
    pub fn permission_arn(&self) -> std::option::Option<&str> {
        self.permission_arn.as_deref()
    }
}
impl std::fmt::Debug for GetResourceSharesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceSharesInput");
        formatter.field("resource_share_arns", &self.resource_share_arns);
        formatter.field("resource_share_status", &self.resource_share_status);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("name", &self.name);
        formatter.field("tag_filters", &self.tag_filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("permission_arn", &self.permission_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceShareInvitationsInput {
    /// <p>The Amazon Resource Names (ARN) of the invitations.</p>
    pub resource_share_invitation_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetResourceShareInvitationsInput {
    /// <p>The Amazon Resource Names (ARN) of the invitations.</p>
    pub fn resource_share_invitation_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_share_invitation_arns.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub fn resource_share_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_share_arns.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetResourceShareInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceShareInvitationsInput");
        formatter.field(
            "resource_share_invitation_arns",
            &self.resource_share_invitation_arns,
        );
        formatter.field("resource_share_arns", &self.resource_share_arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceShareAssociationsInput {
    /// <p>The association type. Specify <code>PRINCIPAL</code> to list the principals that are
    /// associated with the specified resource share. Specify <code>RESOURCE</code> to list the resources
    /// that are associated with the specified resource share.</p>
    pub association_type: std::option::Option<crate::model::ResourceShareAssociationType>,
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub resource_share_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter if
    /// the association type is <code>PRINCIPAL</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The principal. You cannot specify this parameter if the association type is
    /// <code>RESOURCE</code>.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>The association status.</p>
    pub association_status: std::option::Option<crate::model::ResourceShareAssociationStatus>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetResourceShareAssociationsInput {
    /// <p>The association type. Specify <code>PRINCIPAL</code> to list the principals that are
    /// associated with the specified resource share. Specify <code>RESOURCE</code> to list the resources
    /// that are associated with the specified resource share.</p>
    pub fn association_type(
        &self,
    ) -> std::option::Option<&crate::model::ResourceShareAssociationType> {
        self.association_type.as_ref()
    }
    /// <p>The Amazon Resource Names (ARN) of the resource shares.</p>
    pub fn resource_share_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_share_arns.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter if
    /// the association type is <code>PRINCIPAL</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The principal. You cannot specify this parameter if the association type is
    /// <code>RESOURCE</code>.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>The association status.</p>
    pub fn association_status(
        &self,
    ) -> std::option::Option<&crate::model::ResourceShareAssociationStatus> {
        self.association_status.as_ref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetResourceShareAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceShareAssociationsInput");
        formatter.field("association_type", &self.association_type);
        formatter.field("resource_share_arns", &self.resource_share_arns);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("principal", &self.principal);
        formatter.field("association_status", &self.association_status);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePoliciesInput {
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The principal.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetResourcePoliciesInput {
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The principal.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return with a single call.
    /// To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetResourcePoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePoliciesInput");
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("principal", &self.principal);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the permission.</p>
    pub permission_arn: std::option::Option<std::string::String>,
    /// <p>The identifier for the version of the permission.</p>
    pub permission_version: std::option::Option<i32>,
}
impl GetPermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the permission.</p>
    pub fn permission_arn(&self) -> std::option::Option<&str> {
        self.permission_arn.as_deref()
    }
    /// <p>The identifier for the version of the permission.</p>
    pub fn permission_version(&self) -> std::option::Option<i32> {
        self.permission_version
    }
}
impl std::fmt::Debug for GetPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPermissionInput");
        formatter.field("permission_arn", &self.permission_arn);
        formatter.field("permission_version", &self.permission_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSharingWithAwsOrganizationInput {}
impl std::fmt::Debug for EnableSharingWithAwsOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSharingWithAwsOrganizationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResourceSharePermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the permission to disassociate from the resource share.</p>
    pub permission_arn: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisassociateResourceSharePermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the permission to disassociate from the resource share.</p>
    pub fn permission_arn(&self) -> std::option::Option<&str> {
        self.permission_arn.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateResourceSharePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResourceSharePermissionInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("permission_arn", &self.permission_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The principals.</p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DisassociateResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The principals.</p>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DisassociateResourceShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResourceShareInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("principals", &self.principals);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourceShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceShareInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceShareInput {
    /// <p>The name of the resource share.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARNs of the resources to associate with the resource share.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The principals to associate with the resource share. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>An Amazon Web Services account ID</p>
    /// </li>
    /// <li>
    /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organizational unit (OU) in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM role</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM user</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
    /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
    /// Guide</i>.</p>
    /// </note>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Indicates whether principals outside your organization in Organizations can be associated
    /// with a resource share.</p>
    pub allow_external_principals: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the permissions to associate with the resource share. If you
    /// do not specify an ARN for the permission, RAM automatically attaches the default
    /// version of the permission for each resource type. Only one permission can be associated
    /// with each resource type in a resource share.</p>
    pub permission_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateResourceShareInput {
    /// <p>The name of the resource share.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARNs of the resources to associate with the resource share.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The principals to associate with the resource share. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>An Amazon Web Services account ID</p>
    /// </li>
    /// <li>
    /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organizational unit (OU) in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM role</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM user</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
    /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
    /// Guide</i>.</p>
    /// </note>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>One or more tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Indicates whether principals outside your organization in Organizations can be associated
    /// with a resource share.</p>
    pub fn allow_external_principals(&self) -> std::option::Option<bool> {
        self.allow_external_principals
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the permissions to associate with the resource share. If you
    /// do not specify an ARN for the permission, RAM automatically attaches the default
    /// version of the permission for each resource type. Only one permission can be associated
    /// with each resource type in a resource share.</p>
    pub fn permission_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.permission_arns.as_deref()
    }
}
impl std::fmt::Debug for CreateResourceShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceShareInput");
        formatter.field("name", &self.name);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("principals", &self.principals);
        formatter.field("tags", &self.tags);
        formatter.field("allow_external_principals", &self.allow_external_principals);
        formatter.field("client_token", &self.client_token);
        formatter.field("permission_arns", &self.permission_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResourceSharePermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the RAM permission to associate with the
    /// resource share.</p>
    pub permission_arn: std::option::Option<std::string::String>,
    /// <p>Indicates whether the permission should replace the permissions that are currently
    /// associated with the resource share. Use <code>true</code> to replace the current permissions. Use
    /// <code>false</code> to add the permission to the current permission.</p>
    pub replace: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The version of the RAM permissions to associate with the resource share.</p>
    pub permission_version: std::option::Option<i32>,
}
impl AssociateResourceSharePermissionInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the RAM permission to associate with the
    /// resource share.</p>
    pub fn permission_arn(&self) -> std::option::Option<&str> {
        self.permission_arn.as_deref()
    }
    /// <p>Indicates whether the permission should replace the permissions that are currently
    /// associated with the resource share. Use <code>true</code> to replace the current permissions. Use
    /// <code>false</code> to add the permission to the current permission.</p>
    pub fn replace(&self) -> std::option::Option<bool> {
        self.replace
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The version of the RAM permissions to associate with the resource share.</p>
    pub fn permission_version(&self) -> std::option::Option<i32> {
        self.permission_version
    }
}
impl std::fmt::Debug for AssociateResourceSharePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResourceSharePermissionInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("permission_arn", &self.permission_arn);
        formatter.field("replace", &self.replace);
        formatter.field("client_token", &self.client_token);
        formatter.field("permission_version", &self.permission_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub resource_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The principals to associate with the resource share. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>An Amazon Web Services account ID</p>
    /// </li>
    /// <li>
    /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organizational unit (OU) in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM role</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM user</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
    /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
    /// Guide</i>.</p>
    /// </note>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AssociateResourceShareInput {
    /// <p>The Amazon Resource Name (ARN) of the resource share.</p>
    pub fn resource_share_arn(&self) -> std::option::Option<&str> {
        self.resource_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the resources.</p>
    pub fn resource_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_arns.as_deref()
    }
    /// <p>The principals to associate with the resource share. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>An Amazon Web Services account ID</p>
    /// </li>
    /// <li>
    /// <p>An Amazon Resource Name (ARN) of an organization in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an organizational unit (OU) in Organizations</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM role</p>
    /// </li>
    /// <li>
    /// <p>An ARN of an IAM user</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Not all resource types can be shared with IAM roles and IAM users. For more
    /// information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and IAM users</a> in the <i>Resource Access Manager User
    /// Guide</i>.</p>
    /// </note>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AssociateResourceShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResourceShareInput");
        formatter.field("resource_share_arn", &self.resource_share_arn);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.field("principals", &self.principals);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptResourceShareInvitationInput {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub resource_share_invitation_arn: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl AcceptResourceShareInvitationInput {
    /// <p>The Amazon Resource Name (ARN) of the invitation.</p>
    pub fn resource_share_invitation_arn(&self) -> std::option::Option<&str> {
        self.resource_share_invitation_arn.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for AcceptResourceShareInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptResourceShareInvitationInput");
        formatter.field(
            "resource_share_invitation_arn",
            &self.resource_share_invitation_arn,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
