// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelIngestion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_ingestion`](crate::client::Client::cancel_ingestion).
///
/// See [`crate::client::fluent_builders::CancelIngestion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelIngestion {
    _private: (),
}
impl CancelIngestion {
    /// Creates a new builder-style object to manufacture [`CancelIngestionInput`](crate::input::CancelIngestionInput)
    pub fn builder() -> crate::input::cancel_ingestion_input::Builder {
        crate::input::cancel_ingestion_input::Builder::default()
    }
    /// Creates a new `CancelIngestion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelIngestion {
    type Output = std::result::Result<
        crate::output::CancelIngestionOutput,
        crate::error::CancelIngestionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_ingestion_error(response)
        } else {
            crate::operation_deser::parse_cancel_ingestion_response(response)
        }
    }
}

/// Operation shape for `CreateAccountCustomization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_account_customization`](crate::client::Client::create_account_customization).
///
/// See [`crate::client::fluent_builders::CreateAccountCustomization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccountCustomization {
    _private: (),
}
impl CreateAccountCustomization {
    /// Creates a new builder-style object to manufacture [`CreateAccountCustomizationInput`](crate::input::CreateAccountCustomizationInput)
    pub fn builder() -> crate::input::create_account_customization_input::Builder {
        crate::input::create_account_customization_input::Builder::default()
    }
    /// Creates a new `CreateAccountCustomization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccountCustomization {
    type Output = std::result::Result<
        crate::output::CreateAccountCustomizationOutput,
        crate::error::CreateAccountCustomizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_account_customization_error(response)
        } else {
            crate::operation_deser::parse_create_account_customization_response(response)
        }
    }
}

/// Operation shape for `CreateAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_analysis`](crate::client::Client::create_analysis).
///
/// See [`crate::client::fluent_builders::CreateAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAnalysis {
    _private: (),
}
impl CreateAnalysis {
    /// Creates a new builder-style object to manufacture [`CreateAnalysisInput`](crate::input::CreateAnalysisInput)
    pub fn builder() -> crate::input::create_analysis_input::Builder {
        crate::input::create_analysis_input::Builder::default()
    }
    /// Creates a new `CreateAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAnalysis {
    type Output =
        std::result::Result<crate::output::CreateAnalysisOutput, crate::error::CreateAnalysisError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_analysis_error(response)
        } else {
            crate::operation_deser::parse_create_analysis_response(response)
        }
    }
}

/// Operation shape for `CreateDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dashboard`](crate::client::Client::create_dashboard).
///
/// See [`crate::client::fluent_builders::CreateDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDashboard {
    _private: (),
}
impl CreateDashboard {
    /// Creates a new builder-style object to manufacture [`CreateDashboardInput`](crate::input::CreateDashboardInput)
    pub fn builder() -> crate::input::create_dashboard_input::Builder {
        crate::input::create_dashboard_input::Builder::default()
    }
    /// Creates a new `CreateDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDashboard {
    type Output = std::result::Result<
        crate::output::CreateDashboardOutput,
        crate::error::CreateDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dashboard_error(response)
        } else {
            crate::operation_deser::parse_create_dashboard_response(response)
        }
    }
}

/// Operation shape for `CreateDataSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_set`](crate::client::Client::create_data_set).
///
/// See [`crate::client::fluent_builders::CreateDataSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataSet {
    _private: (),
}
impl CreateDataSet {
    /// Creates a new builder-style object to manufacture [`CreateDataSetInput`](crate::input::CreateDataSetInput)
    pub fn builder() -> crate::input::create_data_set_input::Builder {
        crate::input::create_data_set_input::Builder::default()
    }
    /// Creates a new `CreateDataSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataSet {
    type Output =
        std::result::Result<crate::output::CreateDataSetOutput, crate::error::CreateDataSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_set_error(response)
        } else {
            crate::operation_deser::parse_create_data_set_response(response)
        }
    }
}

/// Operation shape for `CreateDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_source`](crate::client::Client::create_data_source).
///
/// See [`crate::client::fluent_builders::CreateDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataSource {
    _private: (),
}
impl CreateDataSource {
    /// Creates a new builder-style object to manufacture [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    pub fn builder() -> crate::input::create_data_source_input::Builder {
        crate::input::create_data_source_input::Builder::default()
    }
    /// Creates a new `CreateDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataSource {
    type Output = std::result::Result<
        crate::output::CreateDataSourceOutput,
        crate::error::CreateDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_source_error(response)
        } else {
            crate::operation_deser::parse_create_data_source_response(response)
        }
    }
}

/// Operation shape for `CreateFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_folder`](crate::client::Client::create_folder).
///
/// See [`crate::client::fluent_builders::CreateFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFolder {
    _private: (),
}
impl CreateFolder {
    /// Creates a new builder-style object to manufacture [`CreateFolderInput`](crate::input::CreateFolderInput)
    pub fn builder() -> crate::input::create_folder_input::Builder {
        crate::input::create_folder_input::Builder::default()
    }
    /// Creates a new `CreateFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFolder {
    type Output =
        std::result::Result<crate::output::CreateFolderOutput, crate::error::CreateFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_folder_error(response)
        } else {
            crate::operation_deser::parse_create_folder_response(response)
        }
    }
}

/// Operation shape for `CreateFolderMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_folder_membership`](crate::client::Client::create_folder_membership).
///
/// See [`crate::client::fluent_builders::CreateFolderMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFolderMembership {
    _private: (),
}
impl CreateFolderMembership {
    /// Creates a new builder-style object to manufacture [`CreateFolderMembershipInput`](crate::input::CreateFolderMembershipInput)
    pub fn builder() -> crate::input::create_folder_membership_input::Builder {
        crate::input::create_folder_membership_input::Builder::default()
    }
    /// Creates a new `CreateFolderMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFolderMembership {
    type Output = std::result::Result<
        crate::output::CreateFolderMembershipOutput,
        crate::error::CreateFolderMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_folder_membership_error(response)
        } else {
            crate::operation_deser::parse_create_folder_membership_response(response)
        }
    }
}

/// Operation shape for `CreateGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_group`](crate::client::Client::create_group).
///
/// See [`crate::client::fluent_builders::CreateGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGroup {
    _private: (),
}
impl CreateGroup {
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
    /// Creates a new `CreateGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGroup {
    type Output =
        std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_group_error(response)
        } else {
            crate::operation_deser::parse_create_group_response(response)
        }
    }
}

/// Operation shape for `CreateGroupMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_group_membership`](crate::client::Client::create_group_membership).
///
/// See [`crate::client::fluent_builders::CreateGroupMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGroupMembership {
    _private: (),
}
impl CreateGroupMembership {
    /// Creates a new builder-style object to manufacture [`CreateGroupMembershipInput`](crate::input::CreateGroupMembershipInput)
    pub fn builder() -> crate::input::create_group_membership_input::Builder {
        crate::input::create_group_membership_input::Builder::default()
    }
    /// Creates a new `CreateGroupMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGroupMembership {
    type Output = std::result::Result<
        crate::output::CreateGroupMembershipOutput,
        crate::error::CreateGroupMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_group_membership_error(response)
        } else {
            crate::operation_deser::parse_create_group_membership_response(response)
        }
    }
}

/// Operation shape for `CreateIAMPolicyAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_iam_policy_assignment`](crate::client::Client::create_iam_policy_assignment).
///
/// See [`crate::client::fluent_builders::CreateIAMPolicyAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIAMPolicyAssignment {
    _private: (),
}
impl CreateIAMPolicyAssignment {
    /// Creates a new builder-style object to manufacture [`CreateIamPolicyAssignmentInput`](crate::input::CreateIamPolicyAssignmentInput)
    pub fn builder() -> crate::input::create_iam_policy_assignment_input::Builder {
        crate::input::create_iam_policy_assignment_input::Builder::default()
    }
    /// Creates a new `CreateIAMPolicyAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIAMPolicyAssignment {
    type Output = std::result::Result<
        crate::output::CreateIamPolicyAssignmentOutput,
        crate::error::CreateIAMPolicyAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_iam_policy_assignment_error(response)
        } else {
            crate::operation_deser::parse_create_iam_policy_assignment_response(response)
        }
    }
}

/// Operation shape for `CreateIngestion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ingestion`](crate::client::Client::create_ingestion).
///
/// See [`crate::client::fluent_builders::CreateIngestion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIngestion {
    _private: (),
}
impl CreateIngestion {
    /// Creates a new builder-style object to manufacture [`CreateIngestionInput`](crate::input::CreateIngestionInput)
    pub fn builder() -> crate::input::create_ingestion_input::Builder {
        crate::input::create_ingestion_input::Builder::default()
    }
    /// Creates a new `CreateIngestion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIngestion {
    type Output = std::result::Result<
        crate::output::CreateIngestionOutput,
        crate::error::CreateIngestionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ingestion_error(response)
        } else {
            crate::operation_deser::parse_create_ingestion_response(response)
        }
    }
}

/// Operation shape for `CreateNamespace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_namespace`](crate::client::Client::create_namespace).
///
/// See [`crate::client::fluent_builders::CreateNamespace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNamespace {
    _private: (),
}
impl CreateNamespace {
    /// Creates a new builder-style object to manufacture [`CreateNamespaceInput`](crate::input::CreateNamespaceInput)
    pub fn builder() -> crate::input::create_namespace_input::Builder {
        crate::input::create_namespace_input::Builder::default()
    }
    /// Creates a new `CreateNamespace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNamespace {
    type Output = std::result::Result<
        crate::output::CreateNamespaceOutput,
        crate::error::CreateNamespaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_namespace_error(response)
        } else {
            crate::operation_deser::parse_create_namespace_response(response)
        }
    }
}

/// Operation shape for `CreateTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_template`](crate::client::Client::create_template).
///
/// See [`crate::client::fluent_builders::CreateTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTemplate {
    _private: (),
}
impl CreateTemplate {
    /// Creates a new builder-style object to manufacture [`CreateTemplateInput`](crate::input::CreateTemplateInput)
    pub fn builder() -> crate::input::create_template_input::Builder {
        crate::input::create_template_input::Builder::default()
    }
    /// Creates a new `CreateTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTemplate {
    type Output =
        std::result::Result<crate::output::CreateTemplateOutput, crate::error::CreateTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_template_error(response)
        } else {
            crate::operation_deser::parse_create_template_response(response)
        }
    }
}

/// Operation shape for `CreateTemplateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_template_alias`](crate::client::Client::create_template_alias).
///
/// See [`crate::client::fluent_builders::CreateTemplateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTemplateAlias {
    _private: (),
}
impl CreateTemplateAlias {
    /// Creates a new builder-style object to manufacture [`CreateTemplateAliasInput`](crate::input::CreateTemplateAliasInput)
    pub fn builder() -> crate::input::create_template_alias_input::Builder {
        crate::input::create_template_alias_input::Builder::default()
    }
    /// Creates a new `CreateTemplateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTemplateAlias {
    type Output = std::result::Result<
        crate::output::CreateTemplateAliasOutput,
        crate::error::CreateTemplateAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_template_alias_error(response)
        } else {
            crate::operation_deser::parse_create_template_alias_response(response)
        }
    }
}

/// Operation shape for `CreateTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_theme`](crate::client::Client::create_theme).
///
/// See [`crate::client::fluent_builders::CreateTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTheme {
    _private: (),
}
impl CreateTheme {
    /// Creates a new builder-style object to manufacture [`CreateThemeInput`](crate::input::CreateThemeInput)
    pub fn builder() -> crate::input::create_theme_input::Builder {
        crate::input::create_theme_input::Builder::default()
    }
    /// Creates a new `CreateTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTheme {
    type Output =
        std::result::Result<crate::output::CreateThemeOutput, crate::error::CreateThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_theme_error(response)
        } else {
            crate::operation_deser::parse_create_theme_response(response)
        }
    }
}

/// Operation shape for `CreateThemeAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_theme_alias`](crate::client::Client::create_theme_alias).
///
/// See [`crate::client::fluent_builders::CreateThemeAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateThemeAlias {
    _private: (),
}
impl CreateThemeAlias {
    /// Creates a new builder-style object to manufacture [`CreateThemeAliasInput`](crate::input::CreateThemeAliasInput)
    pub fn builder() -> crate::input::create_theme_alias_input::Builder {
        crate::input::create_theme_alias_input::Builder::default()
    }
    /// Creates a new `CreateThemeAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateThemeAlias {
    type Output = std::result::Result<
        crate::output::CreateThemeAliasOutput,
        crate::error::CreateThemeAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_theme_alias_error(response)
        } else {
            crate::operation_deser::parse_create_theme_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteAccountCustomization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_account_customization`](crate::client::Client::delete_account_customization).
///
/// See [`crate::client::fluent_builders::DeleteAccountCustomization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccountCustomization {
    _private: (),
}
impl DeleteAccountCustomization {
    /// Creates a new builder-style object to manufacture [`DeleteAccountCustomizationInput`](crate::input::DeleteAccountCustomizationInput)
    pub fn builder() -> crate::input::delete_account_customization_input::Builder {
        crate::input::delete_account_customization_input::Builder::default()
    }
    /// Creates a new `DeleteAccountCustomization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccountCustomization {
    type Output = std::result::Result<
        crate::output::DeleteAccountCustomizationOutput,
        crate::error::DeleteAccountCustomizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_account_customization_error(response)
        } else {
            crate::operation_deser::parse_delete_account_customization_response(response)
        }
    }
}

/// Operation shape for `DeleteAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_analysis`](crate::client::Client::delete_analysis).
///
/// See [`crate::client::fluent_builders::DeleteAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAnalysis {
    _private: (),
}
impl DeleteAnalysis {
    /// Creates a new builder-style object to manufacture [`DeleteAnalysisInput`](crate::input::DeleteAnalysisInput)
    pub fn builder() -> crate::input::delete_analysis_input::Builder {
        crate::input::delete_analysis_input::Builder::default()
    }
    /// Creates a new `DeleteAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAnalysis {
    type Output =
        std::result::Result<crate::output::DeleteAnalysisOutput, crate::error::DeleteAnalysisError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_analysis_error(response)
        } else {
            crate::operation_deser::parse_delete_analysis_response(response)
        }
    }
}

/// Operation shape for `DeleteDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dashboard`](crate::client::Client::delete_dashboard).
///
/// See [`crate::client::fluent_builders::DeleteDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDashboard {
    _private: (),
}
impl DeleteDashboard {
    /// Creates a new builder-style object to manufacture [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
    pub fn builder() -> crate::input::delete_dashboard_input::Builder {
        crate::input::delete_dashboard_input::Builder::default()
    }
    /// Creates a new `DeleteDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDashboard {
    type Output = std::result::Result<
        crate::output::DeleteDashboardOutput,
        crate::error::DeleteDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dashboard_error(response)
        } else {
            crate::operation_deser::parse_delete_dashboard_response(response)
        }
    }
}

/// Operation shape for `DeleteDataSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_data_set`](crate::client::Client::delete_data_set).
///
/// See [`crate::client::fluent_builders::DeleteDataSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataSet {
    _private: (),
}
impl DeleteDataSet {
    /// Creates a new builder-style object to manufacture [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
    pub fn builder() -> crate::input::delete_data_set_input::Builder {
        crate::input::delete_data_set_input::Builder::default()
    }
    /// Creates a new `DeleteDataSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataSet {
    type Output =
        std::result::Result<crate::output::DeleteDataSetOutput, crate::error::DeleteDataSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_data_set_error(response)
        } else {
            crate::operation_deser::parse_delete_data_set_response(response)
        }
    }
}

/// Operation shape for `DeleteDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_data_source`](crate::client::Client::delete_data_source).
///
/// See [`crate::client::fluent_builders::DeleteDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataSource {
    _private: (),
}
impl DeleteDataSource {
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    pub fn builder() -> crate::input::delete_data_source_input::Builder {
        crate::input::delete_data_source_input::Builder::default()
    }
    /// Creates a new `DeleteDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataSource {
    type Output = std::result::Result<
        crate::output::DeleteDataSourceOutput,
        crate::error::DeleteDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_data_source_error(response)
        } else {
            crate::operation_deser::parse_delete_data_source_response(response)
        }
    }
}

/// Operation shape for `DeleteFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_folder`](crate::client::Client::delete_folder).
///
/// See [`crate::client::fluent_builders::DeleteFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFolder {
    _private: (),
}
impl DeleteFolder {
    /// Creates a new builder-style object to manufacture [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    pub fn builder() -> crate::input::delete_folder_input::Builder {
        crate::input::delete_folder_input::Builder::default()
    }
    /// Creates a new `DeleteFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFolder {
    type Output =
        std::result::Result<crate::output::DeleteFolderOutput, crate::error::DeleteFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_folder_error(response)
        } else {
            crate::operation_deser::parse_delete_folder_response(response)
        }
    }
}

/// Operation shape for `DeleteFolderMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_folder_membership`](crate::client::Client::delete_folder_membership).
///
/// See [`crate::client::fluent_builders::DeleteFolderMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFolderMembership {
    _private: (),
}
impl DeleteFolderMembership {
    /// Creates a new builder-style object to manufacture [`DeleteFolderMembershipInput`](crate::input::DeleteFolderMembershipInput)
    pub fn builder() -> crate::input::delete_folder_membership_input::Builder {
        crate::input::delete_folder_membership_input::Builder::default()
    }
    /// Creates a new `DeleteFolderMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFolderMembership {
    type Output = std::result::Result<
        crate::output::DeleteFolderMembershipOutput,
        crate::error::DeleteFolderMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_folder_membership_error(response)
        } else {
            crate::operation_deser::parse_delete_folder_membership_response(response)
        }
    }
}

/// Operation shape for `DeleteGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_group`](crate::client::Client::delete_group).
///
/// See [`crate::client::fluent_builders::DeleteGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGroup {
    _private: (),
}
impl DeleteGroup {
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
    /// Creates a new `DeleteGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGroup {
    type Output =
        std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_group_error(response)
        } else {
            crate::operation_deser::parse_delete_group_response(response)
        }
    }
}

/// Operation shape for `DeleteGroupMembership`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_group_membership`](crate::client::Client::delete_group_membership).
///
/// See [`crate::client::fluent_builders::DeleteGroupMembership`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGroupMembership {
    _private: (),
}
impl DeleteGroupMembership {
    /// Creates a new builder-style object to manufacture [`DeleteGroupMembershipInput`](crate::input::DeleteGroupMembershipInput)
    pub fn builder() -> crate::input::delete_group_membership_input::Builder {
        crate::input::delete_group_membership_input::Builder::default()
    }
    /// Creates a new `DeleteGroupMembership` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGroupMembership {
    type Output = std::result::Result<
        crate::output::DeleteGroupMembershipOutput,
        crate::error::DeleteGroupMembershipError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_group_membership_error(response)
        } else {
            crate::operation_deser::parse_delete_group_membership_response(response)
        }
    }
}

/// Operation shape for `DeleteIAMPolicyAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_iam_policy_assignment`](crate::client::Client::delete_iam_policy_assignment).
///
/// See [`crate::client::fluent_builders::DeleteIAMPolicyAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIAMPolicyAssignment {
    _private: (),
}
impl DeleteIAMPolicyAssignment {
    /// Creates a new builder-style object to manufacture [`DeleteIamPolicyAssignmentInput`](crate::input::DeleteIamPolicyAssignmentInput)
    pub fn builder() -> crate::input::delete_iam_policy_assignment_input::Builder {
        crate::input::delete_iam_policy_assignment_input::Builder::default()
    }
    /// Creates a new `DeleteIAMPolicyAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIAMPolicyAssignment {
    type Output = std::result::Result<
        crate::output::DeleteIamPolicyAssignmentOutput,
        crate::error::DeleteIAMPolicyAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_iam_policy_assignment_error(response)
        } else {
            crate::operation_deser::parse_delete_iam_policy_assignment_response(response)
        }
    }
}

/// Operation shape for `DeleteNamespace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_namespace`](crate::client::Client::delete_namespace).
///
/// See [`crate::client::fluent_builders::DeleteNamespace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNamespace {
    _private: (),
}
impl DeleteNamespace {
    /// Creates a new builder-style object to manufacture [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
    pub fn builder() -> crate::input::delete_namespace_input::Builder {
        crate::input::delete_namespace_input::Builder::default()
    }
    /// Creates a new `DeleteNamespace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNamespace {
    type Output = std::result::Result<
        crate::output::DeleteNamespaceOutput,
        crate::error::DeleteNamespaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_namespace_error(response)
        } else {
            crate::operation_deser::parse_delete_namespace_response(response)
        }
    }
}

/// Operation shape for `DeleteTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_template`](crate::client::Client::delete_template).
///
/// See [`crate::client::fluent_builders::DeleteTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTemplate {
    _private: (),
}
impl DeleteTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
    pub fn builder() -> crate::input::delete_template_input::Builder {
        crate::input::delete_template_input::Builder::default()
    }
    /// Creates a new `DeleteTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTemplate {
    type Output =
        std::result::Result<crate::output::DeleteTemplateOutput, crate::error::DeleteTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_template_error(response)
        } else {
            crate::operation_deser::parse_delete_template_response(response)
        }
    }
}

/// Operation shape for `DeleteTemplateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_template_alias`](crate::client::Client::delete_template_alias).
///
/// See [`crate::client::fluent_builders::DeleteTemplateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTemplateAlias {
    _private: (),
}
impl DeleteTemplateAlias {
    /// Creates a new builder-style object to manufacture [`DeleteTemplateAliasInput`](crate::input::DeleteTemplateAliasInput)
    pub fn builder() -> crate::input::delete_template_alias_input::Builder {
        crate::input::delete_template_alias_input::Builder::default()
    }
    /// Creates a new `DeleteTemplateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTemplateAlias {
    type Output = std::result::Result<
        crate::output::DeleteTemplateAliasOutput,
        crate::error::DeleteTemplateAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_template_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_template_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_theme`](crate::client::Client::delete_theme).
///
/// See [`crate::client::fluent_builders::DeleteTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTheme {
    _private: (),
}
impl DeleteTheme {
    /// Creates a new builder-style object to manufacture [`DeleteThemeInput`](crate::input::DeleteThemeInput)
    pub fn builder() -> crate::input::delete_theme_input::Builder {
        crate::input::delete_theme_input::Builder::default()
    }
    /// Creates a new `DeleteTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTheme {
    type Output =
        std::result::Result<crate::output::DeleteThemeOutput, crate::error::DeleteThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_theme_error(response)
        } else {
            crate::operation_deser::parse_delete_theme_response(response)
        }
    }
}

/// Operation shape for `DeleteThemeAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_theme_alias`](crate::client::Client::delete_theme_alias).
///
/// See [`crate::client::fluent_builders::DeleteThemeAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteThemeAlias {
    _private: (),
}
impl DeleteThemeAlias {
    /// Creates a new builder-style object to manufacture [`DeleteThemeAliasInput`](crate::input::DeleteThemeAliasInput)
    pub fn builder() -> crate::input::delete_theme_alias_input::Builder {
        crate::input::delete_theme_alias_input::Builder::default()
    }
    /// Creates a new `DeleteThemeAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteThemeAlias {
    type Output = std::result::Result<
        crate::output::DeleteThemeAliasOutput,
        crate::error::DeleteThemeAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_theme_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_theme_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DeleteUserByPrincipalId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_by_principal_id`](crate::client::Client::delete_user_by_principal_id).
///
/// See [`crate::client::fluent_builders::DeleteUserByPrincipalId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserByPrincipalId {
    _private: (),
}
impl DeleteUserByPrincipalId {
    /// Creates a new builder-style object to manufacture [`DeleteUserByPrincipalIdInput`](crate::input::DeleteUserByPrincipalIdInput)
    pub fn builder() -> crate::input::delete_user_by_principal_id_input::Builder {
        crate::input::delete_user_by_principal_id_input::Builder::default()
    }
    /// Creates a new `DeleteUserByPrincipalId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserByPrincipalId {
    type Output = std::result::Result<
        crate::output::DeleteUserByPrincipalIdOutput,
        crate::error::DeleteUserByPrincipalIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_by_principal_id_error(response)
        } else {
            crate::operation_deser::parse_delete_user_by_principal_id_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountCustomization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_customization`](crate::client::Client::describe_account_customization).
///
/// See [`crate::client::fluent_builders::DescribeAccountCustomization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountCustomization {
    _private: (),
}
impl DescribeAccountCustomization {
    /// Creates a new builder-style object to manufacture [`DescribeAccountCustomizationInput`](crate::input::DescribeAccountCustomizationInput)
    pub fn builder() -> crate::input::describe_account_customization_input::Builder {
        crate::input::describe_account_customization_input::Builder::default()
    }
    /// Creates a new `DescribeAccountCustomization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountCustomization {
    type Output = std::result::Result<
        crate::output::DescribeAccountCustomizationOutput,
        crate::error::DescribeAccountCustomizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_customization_error(response)
        } else {
            crate::operation_deser::parse_describe_account_customization_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_settings`](crate::client::Client::describe_account_settings).
///
/// See [`crate::client::fluent_builders::DescribeAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountSettings {
    _private: (),
}
impl DescribeAccountSettings {
    /// Creates a new builder-style object to manufacture [`DescribeAccountSettingsInput`](crate::input::DescribeAccountSettingsInput)
    pub fn builder() -> crate::input::describe_account_settings_input::Builder {
        crate::input::describe_account_settings_input::Builder::default()
    }
    /// Creates a new `DescribeAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountSettings {
    type Output = std::result::Result<
        crate::output::DescribeAccountSettingsOutput,
        crate::error::DescribeAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_account_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_analysis`](crate::client::Client::describe_analysis).
///
/// See [`crate::client::fluent_builders::DescribeAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAnalysis {
    _private: (),
}
impl DescribeAnalysis {
    /// Creates a new builder-style object to manufacture [`DescribeAnalysisInput`](crate::input::DescribeAnalysisInput)
    pub fn builder() -> crate::input::describe_analysis_input::Builder {
        crate::input::describe_analysis_input::Builder::default()
    }
    /// Creates a new `DescribeAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAnalysis {
    type Output = std::result::Result<
        crate::output::DescribeAnalysisOutput,
        crate::error::DescribeAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_analysis_error(response)
        } else {
            crate::operation_deser::parse_describe_analysis_response(response)
        }
    }
}

/// Operation shape for `DescribeAnalysisPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_analysis_permissions`](crate::client::Client::describe_analysis_permissions).
///
/// See [`crate::client::fluent_builders::DescribeAnalysisPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAnalysisPermissions {
    _private: (),
}
impl DescribeAnalysisPermissions {
    /// Creates a new builder-style object to manufacture [`DescribeAnalysisPermissionsInput`](crate::input::DescribeAnalysisPermissionsInput)
    pub fn builder() -> crate::input::describe_analysis_permissions_input::Builder {
        crate::input::describe_analysis_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeAnalysisPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAnalysisPermissions {
    type Output = std::result::Result<
        crate::output::DescribeAnalysisPermissionsOutput,
        crate::error::DescribeAnalysisPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_analysis_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_analysis_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dashboard`](crate::client::Client::describe_dashboard).
///
/// See [`crate::client::fluent_builders::DescribeDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDashboard {
    _private: (),
}
impl DescribeDashboard {
    /// Creates a new builder-style object to manufacture [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
    pub fn builder() -> crate::input::describe_dashboard_input::Builder {
        crate::input::describe_dashboard_input::Builder::default()
    }
    /// Creates a new `DescribeDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDashboard {
    type Output = std::result::Result<
        crate::output::DescribeDashboardOutput,
        crate::error::DescribeDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dashboard_error(response)
        } else {
            crate::operation_deser::parse_describe_dashboard_response(response)
        }
    }
}

/// Operation shape for `DescribeDashboardPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dashboard_permissions`](crate::client::Client::describe_dashboard_permissions).
///
/// See [`crate::client::fluent_builders::DescribeDashboardPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDashboardPermissions {
    _private: (),
}
impl DescribeDashboardPermissions {
    /// Creates a new builder-style object to manufacture [`DescribeDashboardPermissionsInput`](crate::input::DescribeDashboardPermissionsInput)
    pub fn builder() -> crate::input::describe_dashboard_permissions_input::Builder {
        crate::input::describe_dashboard_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeDashboardPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDashboardPermissions {
    type Output = std::result::Result<
        crate::output::DescribeDashboardPermissionsOutput,
        crate::error::DescribeDashboardPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dashboard_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_dashboard_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeDataSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_set`](crate::client::Client::describe_data_set).
///
/// See [`crate::client::fluent_builders::DescribeDataSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataSet {
    _private: (),
}
impl DescribeDataSet {
    /// Creates a new builder-style object to manufacture [`DescribeDataSetInput`](crate::input::DescribeDataSetInput)
    pub fn builder() -> crate::input::describe_data_set_input::Builder {
        crate::input::describe_data_set_input::Builder::default()
    }
    /// Creates a new `DescribeDataSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataSet {
    type Output = std::result::Result<
        crate::output::DescribeDataSetOutput,
        crate::error::DescribeDataSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_set_error(response)
        } else {
            crate::operation_deser::parse_describe_data_set_response(response)
        }
    }
}

/// Operation shape for `DescribeDataSetPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_set_permissions`](crate::client::Client::describe_data_set_permissions).
///
/// See [`crate::client::fluent_builders::DescribeDataSetPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataSetPermissions {
    _private: (),
}
impl DescribeDataSetPermissions {
    /// Creates a new builder-style object to manufacture [`DescribeDataSetPermissionsInput`](crate::input::DescribeDataSetPermissionsInput)
    pub fn builder() -> crate::input::describe_data_set_permissions_input::Builder {
        crate::input::describe_data_set_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeDataSetPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataSetPermissions {
    type Output = std::result::Result<
        crate::output::DescribeDataSetPermissionsOutput,
        crate::error::DescribeDataSetPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_set_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_data_set_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_source`](crate::client::Client::describe_data_source).
///
/// See [`crate::client::fluent_builders::DescribeDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataSource {
    _private: (),
}
impl DescribeDataSource {
    /// Creates a new builder-style object to manufacture [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
    pub fn builder() -> crate::input::describe_data_source_input::Builder {
        crate::input::describe_data_source_input::Builder::default()
    }
    /// Creates a new `DescribeDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataSource {
    type Output = std::result::Result<
        crate::output::DescribeDataSourceOutput,
        crate::error::DescribeDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_source_error(response)
        } else {
            crate::operation_deser::parse_describe_data_source_response(response)
        }
    }
}

/// Operation shape for `DescribeDataSourcePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_source_permissions`](crate::client::Client::describe_data_source_permissions).
///
/// See [`crate::client::fluent_builders::DescribeDataSourcePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataSourcePermissions {
    _private: (),
}
impl DescribeDataSourcePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeDataSourcePermissionsInput`](crate::input::DescribeDataSourcePermissionsInput)
    pub fn builder() -> crate::input::describe_data_source_permissions_input::Builder {
        crate::input::describe_data_source_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeDataSourcePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataSourcePermissions {
    type Output = std::result::Result<
        crate::output::DescribeDataSourcePermissionsOutput,
        crate::error::DescribeDataSourcePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_source_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_data_source_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_folder`](crate::client::Client::describe_folder).
///
/// See [`crate::client::fluent_builders::DescribeFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFolder {
    _private: (),
}
impl DescribeFolder {
    /// Creates a new builder-style object to manufacture [`DescribeFolderInput`](crate::input::DescribeFolderInput)
    pub fn builder() -> crate::input::describe_folder_input::Builder {
        crate::input::describe_folder_input::Builder::default()
    }
    /// Creates a new `DescribeFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFolder {
    type Output =
        std::result::Result<crate::output::DescribeFolderOutput, crate::error::DescribeFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_folder_error(response)
        } else {
            crate::operation_deser::parse_describe_folder_response(response)
        }
    }
}

/// Operation shape for `DescribeFolderPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_folder_permissions`](crate::client::Client::describe_folder_permissions).
///
/// See [`crate::client::fluent_builders::DescribeFolderPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFolderPermissions {
    _private: (),
}
impl DescribeFolderPermissions {
    /// Creates a new builder-style object to manufacture [`DescribeFolderPermissionsInput`](crate::input::DescribeFolderPermissionsInput)
    pub fn builder() -> crate::input::describe_folder_permissions_input::Builder {
        crate::input::describe_folder_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeFolderPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFolderPermissions {
    type Output = std::result::Result<
        crate::output::DescribeFolderPermissionsOutput,
        crate::error::DescribeFolderPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_folder_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_folder_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeFolderResolvedPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_folder_resolved_permissions`](crate::client::Client::describe_folder_resolved_permissions).
///
/// See [`crate::client::fluent_builders::DescribeFolderResolvedPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFolderResolvedPermissions {
    _private: (),
}
impl DescribeFolderResolvedPermissions {
    /// Creates a new builder-style object to manufacture [`DescribeFolderResolvedPermissionsInput`](crate::input::DescribeFolderResolvedPermissionsInput)
    pub fn builder() -> crate::input::describe_folder_resolved_permissions_input::Builder {
        crate::input::describe_folder_resolved_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeFolderResolvedPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFolderResolvedPermissions {
    type Output = std::result::Result<
        crate::output::DescribeFolderResolvedPermissionsOutput,
        crate::error::DescribeFolderResolvedPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_folder_resolved_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_folder_resolved_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_group`](crate::client::Client::describe_group).
///
/// See [`crate::client::fluent_builders::DescribeGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGroup {
    _private: (),
}
impl DescribeGroup {
    /// Creates a new builder-style object to manufacture [`DescribeGroupInput`](crate::input::DescribeGroupInput)
    pub fn builder() -> crate::input::describe_group_input::Builder {
        crate::input::describe_group_input::Builder::default()
    }
    /// Creates a new `DescribeGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGroup {
    type Output =
        std::result::Result<crate::output::DescribeGroupOutput, crate::error::DescribeGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_group_error(response)
        } else {
            crate::operation_deser::parse_describe_group_response(response)
        }
    }
}

/// Operation shape for `DescribeIAMPolicyAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_iam_policy_assignment`](crate::client::Client::describe_iam_policy_assignment).
///
/// See [`crate::client::fluent_builders::DescribeIAMPolicyAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIAMPolicyAssignment {
    _private: (),
}
impl DescribeIAMPolicyAssignment {
    /// Creates a new builder-style object to manufacture [`DescribeIamPolicyAssignmentInput`](crate::input::DescribeIamPolicyAssignmentInput)
    pub fn builder() -> crate::input::describe_iam_policy_assignment_input::Builder {
        crate::input::describe_iam_policy_assignment_input::Builder::default()
    }
    /// Creates a new `DescribeIAMPolicyAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIAMPolicyAssignment {
    type Output = std::result::Result<
        crate::output::DescribeIamPolicyAssignmentOutput,
        crate::error::DescribeIAMPolicyAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_iam_policy_assignment_error(response)
        } else {
            crate::operation_deser::parse_describe_iam_policy_assignment_response(response)
        }
    }
}

/// Operation shape for `DescribeIngestion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ingestion`](crate::client::Client::describe_ingestion).
///
/// See [`crate::client::fluent_builders::DescribeIngestion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIngestion {
    _private: (),
}
impl DescribeIngestion {
    /// Creates a new builder-style object to manufacture [`DescribeIngestionInput`](crate::input::DescribeIngestionInput)
    pub fn builder() -> crate::input::describe_ingestion_input::Builder {
        crate::input::describe_ingestion_input::Builder::default()
    }
    /// Creates a new `DescribeIngestion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIngestion {
    type Output = std::result::Result<
        crate::output::DescribeIngestionOutput,
        crate::error::DescribeIngestionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ingestion_error(response)
        } else {
            crate::operation_deser::parse_describe_ingestion_response(response)
        }
    }
}

/// Operation shape for `DescribeIpRestriction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ip_restriction`](crate::client::Client::describe_ip_restriction).
///
/// See [`crate::client::fluent_builders::DescribeIpRestriction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIpRestriction {
    _private: (),
}
impl DescribeIpRestriction {
    /// Creates a new builder-style object to manufacture [`DescribeIpRestrictionInput`](crate::input::DescribeIpRestrictionInput)
    pub fn builder() -> crate::input::describe_ip_restriction_input::Builder {
        crate::input::describe_ip_restriction_input::Builder::default()
    }
    /// Creates a new `DescribeIpRestriction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIpRestriction {
    type Output = std::result::Result<
        crate::output::DescribeIpRestrictionOutput,
        crate::error::DescribeIpRestrictionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ip_restriction_error(response)
        } else {
            crate::operation_deser::parse_describe_ip_restriction_response(response)
        }
    }
}

/// Operation shape for `DescribeNamespace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_namespace`](crate::client::Client::describe_namespace).
///
/// See [`crate::client::fluent_builders::DescribeNamespace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNamespace {
    _private: (),
}
impl DescribeNamespace {
    /// Creates a new builder-style object to manufacture [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
    pub fn builder() -> crate::input::describe_namespace_input::Builder {
        crate::input::describe_namespace_input::Builder::default()
    }
    /// Creates a new `DescribeNamespace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNamespace {
    type Output = std::result::Result<
        crate::output::DescribeNamespaceOutput,
        crate::error::DescribeNamespaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_namespace_error(response)
        } else {
            crate::operation_deser::parse_describe_namespace_response(response)
        }
    }
}

/// Operation shape for `DescribeTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_template`](crate::client::Client::describe_template).
///
/// See [`crate::client::fluent_builders::DescribeTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTemplate {
    _private: (),
}
impl DescribeTemplate {
    /// Creates a new builder-style object to manufacture [`DescribeTemplateInput`](crate::input::DescribeTemplateInput)
    pub fn builder() -> crate::input::describe_template_input::Builder {
        crate::input::describe_template_input::Builder::default()
    }
    /// Creates a new `DescribeTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTemplate {
    type Output = std::result::Result<
        crate::output::DescribeTemplateOutput,
        crate::error::DescribeTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_template_error(response)
        } else {
            crate::operation_deser::parse_describe_template_response(response)
        }
    }
}

/// Operation shape for `DescribeTemplateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_template_alias`](crate::client::Client::describe_template_alias).
///
/// See [`crate::client::fluent_builders::DescribeTemplateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTemplateAlias {
    _private: (),
}
impl DescribeTemplateAlias {
    /// Creates a new builder-style object to manufacture [`DescribeTemplateAliasInput`](crate::input::DescribeTemplateAliasInput)
    pub fn builder() -> crate::input::describe_template_alias_input::Builder {
        crate::input::describe_template_alias_input::Builder::default()
    }
    /// Creates a new `DescribeTemplateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTemplateAlias {
    type Output = std::result::Result<
        crate::output::DescribeTemplateAliasOutput,
        crate::error::DescribeTemplateAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_template_alias_error(response)
        } else {
            crate::operation_deser::parse_describe_template_alias_response(response)
        }
    }
}

/// Operation shape for `DescribeTemplatePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_template_permissions`](crate::client::Client::describe_template_permissions).
///
/// See [`crate::client::fluent_builders::DescribeTemplatePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTemplatePermissions {
    _private: (),
}
impl DescribeTemplatePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeTemplatePermissionsInput`](crate::input::DescribeTemplatePermissionsInput)
    pub fn builder() -> crate::input::describe_template_permissions_input::Builder {
        crate::input::describe_template_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeTemplatePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTemplatePermissions {
    type Output = std::result::Result<
        crate::output::DescribeTemplatePermissionsOutput,
        crate::error::DescribeTemplatePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_template_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_template_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_theme`](crate::client::Client::describe_theme).
///
/// See [`crate::client::fluent_builders::DescribeTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTheme {
    _private: (),
}
impl DescribeTheme {
    /// Creates a new builder-style object to manufacture [`DescribeThemeInput`](crate::input::DescribeThemeInput)
    pub fn builder() -> crate::input::describe_theme_input::Builder {
        crate::input::describe_theme_input::Builder::default()
    }
    /// Creates a new `DescribeTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTheme {
    type Output =
        std::result::Result<crate::output::DescribeThemeOutput, crate::error::DescribeThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_theme_error(response)
        } else {
            crate::operation_deser::parse_describe_theme_response(response)
        }
    }
}

/// Operation shape for `DescribeThemeAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_theme_alias`](crate::client::Client::describe_theme_alias).
///
/// See [`crate::client::fluent_builders::DescribeThemeAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeThemeAlias {
    _private: (),
}
impl DescribeThemeAlias {
    /// Creates a new builder-style object to manufacture [`DescribeThemeAliasInput`](crate::input::DescribeThemeAliasInput)
    pub fn builder() -> crate::input::describe_theme_alias_input::Builder {
        crate::input::describe_theme_alias_input::Builder::default()
    }
    /// Creates a new `DescribeThemeAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeThemeAlias {
    type Output = std::result::Result<
        crate::output::DescribeThemeAliasOutput,
        crate::error::DescribeThemeAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_theme_alias_error(response)
        } else {
            crate::operation_deser::parse_describe_theme_alias_response(response)
        }
    }
}

/// Operation shape for `DescribeThemePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_theme_permissions`](crate::client::Client::describe_theme_permissions).
///
/// See [`crate::client::fluent_builders::DescribeThemePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeThemePermissions {
    _private: (),
}
impl DescribeThemePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeThemePermissionsInput`](crate::input::DescribeThemePermissionsInput)
    pub fn builder() -> crate::input::describe_theme_permissions_input::Builder {
        crate::input::describe_theme_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeThemePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeThemePermissions {
    type Output = std::result::Result<
        crate::output::DescribeThemePermissionsOutput,
        crate::error::DescribeThemePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_theme_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_theme_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user`](crate::client::Client::describe_user).
///
/// See [`crate::client::fluent_builders::DescribeUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUser {
    _private: (),
}
impl DescribeUser {
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
    /// Creates a new `DescribeUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUser {
    type Output =
        std::result::Result<crate::output::DescribeUserOutput, crate::error::DescribeUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_error(response)
        } else {
            crate::operation_deser::parse_describe_user_response(response)
        }
    }
}

/// Operation shape for `GenerateEmbedUrlForAnonymousUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_embed_url_for_anonymous_user`](crate::client::Client::generate_embed_url_for_anonymous_user).
///
/// See [`crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateEmbedUrlForAnonymousUser {
    _private: (),
}
impl GenerateEmbedUrlForAnonymousUser {
    /// Creates a new builder-style object to manufacture [`GenerateEmbedUrlForAnonymousUserInput`](crate::input::GenerateEmbedUrlForAnonymousUserInput)
    pub fn builder() -> crate::input::generate_embed_url_for_anonymous_user_input::Builder {
        crate::input::generate_embed_url_for_anonymous_user_input::Builder::default()
    }
    /// Creates a new `GenerateEmbedUrlForAnonymousUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateEmbedUrlForAnonymousUser {
    type Output = std::result::Result<
        crate::output::GenerateEmbedUrlForAnonymousUserOutput,
        crate::error::GenerateEmbedUrlForAnonymousUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_embed_url_for_anonymous_user_error(response)
        } else {
            crate::operation_deser::parse_generate_embed_url_for_anonymous_user_response(response)
        }
    }
}

/// Operation shape for `GenerateEmbedUrlForRegisteredUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_embed_url_for_registered_user`](crate::client::Client::generate_embed_url_for_registered_user).
///
/// See [`crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateEmbedUrlForRegisteredUser {
    _private: (),
}
impl GenerateEmbedUrlForRegisteredUser {
    /// Creates a new builder-style object to manufacture [`GenerateEmbedUrlForRegisteredUserInput`](crate::input::GenerateEmbedUrlForRegisteredUserInput)
    pub fn builder() -> crate::input::generate_embed_url_for_registered_user_input::Builder {
        crate::input::generate_embed_url_for_registered_user_input::Builder::default()
    }
    /// Creates a new `GenerateEmbedUrlForRegisteredUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateEmbedUrlForRegisteredUser {
    type Output = std::result::Result<
        crate::output::GenerateEmbedUrlForRegisteredUserOutput,
        crate::error::GenerateEmbedUrlForRegisteredUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_embed_url_for_registered_user_error(response)
        } else {
            crate::operation_deser::parse_generate_embed_url_for_registered_user_response(response)
        }
    }
}

/// Operation shape for `GetDashboardEmbedUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dashboard_embed_url`](crate::client::Client::get_dashboard_embed_url).
///
/// See [`crate::client::fluent_builders::GetDashboardEmbedUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDashboardEmbedUrl {
    _private: (),
}
impl GetDashboardEmbedUrl {
    /// Creates a new builder-style object to manufacture [`GetDashboardEmbedUrlInput`](crate::input::GetDashboardEmbedUrlInput)
    pub fn builder() -> crate::input::get_dashboard_embed_url_input::Builder {
        crate::input::get_dashboard_embed_url_input::Builder::default()
    }
    /// Creates a new `GetDashboardEmbedUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDashboardEmbedUrl {
    type Output = std::result::Result<
        crate::output::GetDashboardEmbedUrlOutput,
        crate::error::GetDashboardEmbedUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dashboard_embed_url_error(response)
        } else {
            crate::operation_deser::parse_get_dashboard_embed_url_response(response)
        }
    }
}

/// Operation shape for `GetSessionEmbedUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_session_embed_url`](crate::client::Client::get_session_embed_url).
///
/// See [`crate::client::fluent_builders::GetSessionEmbedUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSessionEmbedUrl {
    _private: (),
}
impl GetSessionEmbedUrl {
    /// Creates a new builder-style object to manufacture [`GetSessionEmbedUrlInput`](crate::input::GetSessionEmbedUrlInput)
    pub fn builder() -> crate::input::get_session_embed_url_input::Builder {
        crate::input::get_session_embed_url_input::Builder::default()
    }
    /// Creates a new `GetSessionEmbedUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSessionEmbedUrl {
    type Output = std::result::Result<
        crate::output::GetSessionEmbedUrlOutput,
        crate::error::GetSessionEmbedUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_session_embed_url_error(response)
        } else {
            crate::operation_deser::parse_get_session_embed_url_response(response)
        }
    }
}

/// Operation shape for `ListAnalyses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_analyses`](crate::client::Client::list_analyses).
///
/// See [`crate::client::fluent_builders::ListAnalyses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnalyses {
    _private: (),
}
impl ListAnalyses {
    /// Creates a new builder-style object to manufacture [`ListAnalysesInput`](crate::input::ListAnalysesInput)
    pub fn builder() -> crate::input::list_analyses_input::Builder {
        crate::input::list_analyses_input::Builder::default()
    }
    /// Creates a new `ListAnalyses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnalyses {
    type Output =
        std::result::Result<crate::output::ListAnalysesOutput, crate::error::ListAnalysesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_analyses_error(response)
        } else {
            crate::operation_deser::parse_list_analyses_response(response)
        }
    }
}

/// Operation shape for `ListDashboards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dashboards`](crate::client::Client::list_dashboards).
///
/// See [`crate::client::fluent_builders::ListDashboards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDashboards {
    _private: (),
}
impl ListDashboards {
    /// Creates a new builder-style object to manufacture [`ListDashboardsInput`](crate::input::ListDashboardsInput)
    pub fn builder() -> crate::input::list_dashboards_input::Builder {
        crate::input::list_dashboards_input::Builder::default()
    }
    /// Creates a new `ListDashboards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDashboards {
    type Output =
        std::result::Result<crate::output::ListDashboardsOutput, crate::error::ListDashboardsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dashboards_error(response)
        } else {
            crate::operation_deser::parse_list_dashboards_response(response)
        }
    }
}

/// Operation shape for `ListDashboardVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dashboard_versions`](crate::client::Client::list_dashboard_versions).
///
/// See [`crate::client::fluent_builders::ListDashboardVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDashboardVersions {
    _private: (),
}
impl ListDashboardVersions {
    /// Creates a new builder-style object to manufacture [`ListDashboardVersionsInput`](crate::input::ListDashboardVersionsInput)
    pub fn builder() -> crate::input::list_dashboard_versions_input::Builder {
        crate::input::list_dashboard_versions_input::Builder::default()
    }
    /// Creates a new `ListDashboardVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDashboardVersions {
    type Output = std::result::Result<
        crate::output::ListDashboardVersionsOutput,
        crate::error::ListDashboardVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dashboard_versions_error(response)
        } else {
            crate::operation_deser::parse_list_dashboard_versions_response(response)
        }
    }
}

/// Operation shape for `ListDataSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_sets`](crate::client::Client::list_data_sets).
///
/// See [`crate::client::fluent_builders::ListDataSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataSets {
    _private: (),
}
impl ListDataSets {
    /// Creates a new builder-style object to manufacture [`ListDataSetsInput`](crate::input::ListDataSetsInput)
    pub fn builder() -> crate::input::list_data_sets_input::Builder {
        crate::input::list_data_sets_input::Builder::default()
    }
    /// Creates a new `ListDataSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataSets {
    type Output =
        std::result::Result<crate::output::ListDataSetsOutput, crate::error::ListDataSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_sets_error(response)
        } else {
            crate::operation_deser::parse_list_data_sets_response(response)
        }
    }
}

/// Operation shape for `ListDataSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_sources`](crate::client::Client::list_data_sources).
///
/// See [`crate::client::fluent_builders::ListDataSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataSources {
    _private: (),
}
impl ListDataSources {
    /// Creates a new builder-style object to manufacture [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    pub fn builder() -> crate::input::list_data_sources_input::Builder {
        crate::input::list_data_sources_input::Builder::default()
    }
    /// Creates a new `ListDataSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataSources {
    type Output = std::result::Result<
        crate::output::ListDataSourcesOutput,
        crate::error::ListDataSourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_sources_error(response)
        } else {
            crate::operation_deser::parse_list_data_sources_response(response)
        }
    }
}

/// Operation shape for `ListFolderMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_folder_members`](crate::client::Client::list_folder_members).
///
/// See [`crate::client::fluent_builders::ListFolderMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFolderMembers {
    _private: (),
}
impl ListFolderMembers {
    /// Creates a new builder-style object to manufacture [`ListFolderMembersInput`](crate::input::ListFolderMembersInput)
    pub fn builder() -> crate::input::list_folder_members_input::Builder {
        crate::input::list_folder_members_input::Builder::default()
    }
    /// Creates a new `ListFolderMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFolderMembers {
    type Output = std::result::Result<
        crate::output::ListFolderMembersOutput,
        crate::error::ListFolderMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_folder_members_error(response)
        } else {
            crate::operation_deser::parse_list_folder_members_response(response)
        }
    }
}

/// Operation shape for `ListFolders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_folders`](crate::client::Client::list_folders).
///
/// See [`crate::client::fluent_builders::ListFolders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFolders {
    _private: (),
}
impl ListFolders {
    /// Creates a new builder-style object to manufacture [`ListFoldersInput`](crate::input::ListFoldersInput)
    pub fn builder() -> crate::input::list_folders_input::Builder {
        crate::input::list_folders_input::Builder::default()
    }
    /// Creates a new `ListFolders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFolders {
    type Output =
        std::result::Result<crate::output::ListFoldersOutput, crate::error::ListFoldersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_folders_error(response)
        } else {
            crate::operation_deser::parse_list_folders_response(response)
        }
    }
}

/// Operation shape for `ListGroupMemberships`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_group_memberships`](crate::client::Client::list_group_memberships).
///
/// See [`crate::client::fluent_builders::ListGroupMemberships`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroupMemberships {
    _private: (),
}
impl ListGroupMemberships {
    /// Creates a new builder-style object to manufacture [`ListGroupMembershipsInput`](crate::input::ListGroupMembershipsInput)
    pub fn builder() -> crate::input::list_group_memberships_input::Builder {
        crate::input::list_group_memberships_input::Builder::default()
    }
    /// Creates a new `ListGroupMemberships` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroupMemberships {
    type Output = std::result::Result<
        crate::output::ListGroupMembershipsOutput,
        crate::error::ListGroupMembershipsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_group_memberships_error(response)
        } else {
            crate::operation_deser::parse_list_group_memberships_response(response)
        }
    }
}

/// Operation shape for `ListGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_groups`](crate::client::Client::list_groups).
///
/// See [`crate::client::fluent_builders::ListGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroups {
    _private: (),
}
impl ListGroups {
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
    /// Creates a new `ListGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroups {
    type Output =
        std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_groups_error(response)
        } else {
            crate::operation_deser::parse_list_groups_response(response)
        }
    }
}

/// Operation shape for `ListIAMPolicyAssignments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_iam_policy_assignments`](crate::client::Client::list_iam_policy_assignments).
///
/// See [`crate::client::fluent_builders::ListIAMPolicyAssignments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIAMPolicyAssignments {
    _private: (),
}
impl ListIAMPolicyAssignments {
    /// Creates a new builder-style object to manufacture [`ListIamPolicyAssignmentsInput`](crate::input::ListIamPolicyAssignmentsInput)
    pub fn builder() -> crate::input::list_iam_policy_assignments_input::Builder {
        crate::input::list_iam_policy_assignments_input::Builder::default()
    }
    /// Creates a new `ListIAMPolicyAssignments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIAMPolicyAssignments {
    type Output = std::result::Result<
        crate::output::ListIamPolicyAssignmentsOutput,
        crate::error::ListIAMPolicyAssignmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_iam_policy_assignments_error(response)
        } else {
            crate::operation_deser::parse_list_iam_policy_assignments_response(response)
        }
    }
}

/// Operation shape for `ListIAMPolicyAssignmentsForUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_iam_policy_assignments_for_user`](crate::client::Client::list_iam_policy_assignments_for_user).
///
/// See [`crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIAMPolicyAssignmentsForUser {
    _private: (),
}
impl ListIAMPolicyAssignmentsForUser {
    /// Creates a new builder-style object to manufacture [`ListIamPolicyAssignmentsForUserInput`](crate::input::ListIamPolicyAssignmentsForUserInput)
    pub fn builder() -> crate::input::list_iam_policy_assignments_for_user_input::Builder {
        crate::input::list_iam_policy_assignments_for_user_input::Builder::default()
    }
    /// Creates a new `ListIAMPolicyAssignmentsForUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIAMPolicyAssignmentsForUser {
    type Output = std::result::Result<
        crate::output::ListIamPolicyAssignmentsForUserOutput,
        crate::error::ListIAMPolicyAssignmentsForUserError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_iam_policy_assignments_for_user_error(response)
        } else {
            crate::operation_deser::parse_list_iam_policy_assignments_for_user_response(response)
        }
    }
}

/// Operation shape for `ListIngestions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ingestions`](crate::client::Client::list_ingestions).
///
/// See [`crate::client::fluent_builders::ListIngestions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIngestions {
    _private: (),
}
impl ListIngestions {
    /// Creates a new builder-style object to manufacture [`ListIngestionsInput`](crate::input::ListIngestionsInput)
    pub fn builder() -> crate::input::list_ingestions_input::Builder {
        crate::input::list_ingestions_input::Builder::default()
    }
    /// Creates a new `ListIngestions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIngestions {
    type Output =
        std::result::Result<crate::output::ListIngestionsOutput, crate::error::ListIngestionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ingestions_error(response)
        } else {
            crate::operation_deser::parse_list_ingestions_response(response)
        }
    }
}

/// Operation shape for `ListNamespaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_namespaces`](crate::client::Client::list_namespaces).
///
/// See [`crate::client::fluent_builders::ListNamespaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNamespaces {
    _private: (),
}
impl ListNamespaces {
    /// Creates a new builder-style object to manufacture [`ListNamespacesInput`](crate::input::ListNamespacesInput)
    pub fn builder() -> crate::input::list_namespaces_input::Builder {
        crate::input::list_namespaces_input::Builder::default()
    }
    /// Creates a new `ListNamespaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNamespaces {
    type Output =
        std::result::Result<crate::output::ListNamespacesOutput, crate::error::ListNamespacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_namespaces_error(response)
        } else {
            crate::operation_deser::parse_list_namespaces_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTemplateAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_template_aliases`](crate::client::Client::list_template_aliases).
///
/// See [`crate::client::fluent_builders::ListTemplateAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTemplateAliases {
    _private: (),
}
impl ListTemplateAliases {
    /// Creates a new builder-style object to manufacture [`ListTemplateAliasesInput`](crate::input::ListTemplateAliasesInput)
    pub fn builder() -> crate::input::list_template_aliases_input::Builder {
        crate::input::list_template_aliases_input::Builder::default()
    }
    /// Creates a new `ListTemplateAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTemplateAliases {
    type Output = std::result::Result<
        crate::output::ListTemplateAliasesOutput,
        crate::error::ListTemplateAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_template_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_template_aliases_response(response)
        }
    }
}

/// Operation shape for `ListTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_templates`](crate::client::Client::list_templates).
///
/// See [`crate::client::fluent_builders::ListTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTemplates {
    _private: (),
}
impl ListTemplates {
    /// Creates a new builder-style object to manufacture [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    pub fn builder() -> crate::input::list_templates_input::Builder {
        crate::input::list_templates_input::Builder::default()
    }
    /// Creates a new `ListTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTemplates {
    type Output =
        std::result::Result<crate::output::ListTemplatesOutput, crate::error::ListTemplatesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_templates_error(response)
        } else {
            crate::operation_deser::parse_list_templates_response(response)
        }
    }
}

/// Operation shape for `ListTemplateVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_template_versions`](crate::client::Client::list_template_versions).
///
/// See [`crate::client::fluent_builders::ListTemplateVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTemplateVersions {
    _private: (),
}
impl ListTemplateVersions {
    /// Creates a new builder-style object to manufacture [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
    pub fn builder() -> crate::input::list_template_versions_input::Builder {
        crate::input::list_template_versions_input::Builder::default()
    }
    /// Creates a new `ListTemplateVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTemplateVersions {
    type Output = std::result::Result<
        crate::output::ListTemplateVersionsOutput,
        crate::error::ListTemplateVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_template_versions_error(response)
        } else {
            crate::operation_deser::parse_list_template_versions_response(response)
        }
    }
}

/// Operation shape for `ListThemeAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_theme_aliases`](crate::client::Client::list_theme_aliases).
///
/// See [`crate::client::fluent_builders::ListThemeAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThemeAliases {
    _private: (),
}
impl ListThemeAliases {
    /// Creates a new builder-style object to manufacture [`ListThemeAliasesInput`](crate::input::ListThemeAliasesInput)
    pub fn builder() -> crate::input::list_theme_aliases_input::Builder {
        crate::input::list_theme_aliases_input::Builder::default()
    }
    /// Creates a new `ListThemeAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThemeAliases {
    type Output = std::result::Result<
        crate::output::ListThemeAliasesOutput,
        crate::error::ListThemeAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_theme_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_theme_aliases_response(response)
        }
    }
}

/// Operation shape for `ListThemes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_themes`](crate::client::Client::list_themes).
///
/// See [`crate::client::fluent_builders::ListThemes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThemes {
    _private: (),
}
impl ListThemes {
    /// Creates a new builder-style object to manufacture [`ListThemesInput`](crate::input::ListThemesInput)
    pub fn builder() -> crate::input::list_themes_input::Builder {
        crate::input::list_themes_input::Builder::default()
    }
    /// Creates a new `ListThemes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThemes {
    type Output =
        std::result::Result<crate::output::ListThemesOutput, crate::error::ListThemesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_themes_error(response)
        } else {
            crate::operation_deser::parse_list_themes_response(response)
        }
    }
}

/// Operation shape for `ListThemeVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_theme_versions`](crate::client::Client::list_theme_versions).
///
/// See [`crate::client::fluent_builders::ListThemeVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThemeVersions {
    _private: (),
}
impl ListThemeVersions {
    /// Creates a new builder-style object to manufacture [`ListThemeVersionsInput`](crate::input::ListThemeVersionsInput)
    pub fn builder() -> crate::input::list_theme_versions_input::Builder {
        crate::input::list_theme_versions_input::Builder::default()
    }
    /// Creates a new `ListThemeVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThemeVersions {
    type Output = std::result::Result<
        crate::output::ListThemeVersionsOutput,
        crate::error::ListThemeVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_theme_versions_error(response)
        } else {
            crate::operation_deser::parse_list_theme_versions_response(response)
        }
    }
}

/// Operation shape for `ListUserGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_user_groups`](crate::client::Client::list_user_groups).
///
/// See [`crate::client::fluent_builders::ListUserGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUserGroups {
    _private: (),
}
impl ListUserGroups {
    /// Creates a new builder-style object to manufacture [`ListUserGroupsInput`](crate::input::ListUserGroupsInput)
    pub fn builder() -> crate::input::list_user_groups_input::Builder {
        crate::input::list_user_groups_input::Builder::default()
    }
    /// Creates a new `ListUserGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUserGroups {
    type Output =
        std::result::Result<crate::output::ListUserGroupsOutput, crate::error::ListUserGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_user_groups_error(response)
        } else {
            crate::operation_deser::parse_list_user_groups_response(response)
        }
    }
}

/// Operation shape for `ListUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users`](crate::client::Client::list_users).
///
/// See [`crate::client::fluent_builders::ListUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsers {
    _private: (),
}
impl ListUsers {
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
    /// Creates a new `ListUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsers {
    type Output = std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_error(response)
        } else {
            crate::operation_deser::parse_list_users_response(response)
        }
    }
}

/// Operation shape for `RegisterUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_user`](crate::client::Client::register_user).
///
/// See [`crate::client::fluent_builders::RegisterUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterUser {
    _private: (),
}
impl RegisterUser {
    /// Creates a new builder-style object to manufacture [`RegisterUserInput`](crate::input::RegisterUserInput)
    pub fn builder() -> crate::input::register_user_input::Builder {
        crate::input::register_user_input::Builder::default()
    }
    /// Creates a new `RegisterUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterUser {
    type Output =
        std::result::Result<crate::output::RegisterUserOutput, crate::error::RegisterUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_user_error(response)
        } else {
            crate::operation_deser::parse_register_user_response(response)
        }
    }
}

/// Operation shape for `RestoreAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_analysis`](crate::client::Client::restore_analysis).
///
/// See [`crate::client::fluent_builders::RestoreAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreAnalysis {
    _private: (),
}
impl RestoreAnalysis {
    /// Creates a new builder-style object to manufacture [`RestoreAnalysisInput`](crate::input::RestoreAnalysisInput)
    pub fn builder() -> crate::input::restore_analysis_input::Builder {
        crate::input::restore_analysis_input::Builder::default()
    }
    /// Creates a new `RestoreAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreAnalysis {
    type Output = std::result::Result<
        crate::output::RestoreAnalysisOutput,
        crate::error::RestoreAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_analysis_error(response)
        } else {
            crate::operation_deser::parse_restore_analysis_response(response)
        }
    }
}

/// Operation shape for `SearchAnalyses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_analyses`](crate::client::Client::search_analyses).
///
/// See [`crate::client::fluent_builders::SearchAnalyses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchAnalyses {
    _private: (),
}
impl SearchAnalyses {
    /// Creates a new builder-style object to manufacture [`SearchAnalysesInput`](crate::input::SearchAnalysesInput)
    pub fn builder() -> crate::input::search_analyses_input::Builder {
        crate::input::search_analyses_input::Builder::default()
    }
    /// Creates a new `SearchAnalyses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchAnalyses {
    type Output =
        std::result::Result<crate::output::SearchAnalysesOutput, crate::error::SearchAnalysesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_analyses_error(response)
        } else {
            crate::operation_deser::parse_search_analyses_response(response)
        }
    }
}

/// Operation shape for `SearchDashboards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_dashboards`](crate::client::Client::search_dashboards).
///
/// See [`crate::client::fluent_builders::SearchDashboards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchDashboards {
    _private: (),
}
impl SearchDashboards {
    /// Creates a new builder-style object to manufacture [`SearchDashboardsInput`](crate::input::SearchDashboardsInput)
    pub fn builder() -> crate::input::search_dashboards_input::Builder {
        crate::input::search_dashboards_input::Builder::default()
    }
    /// Creates a new `SearchDashboards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchDashboards {
    type Output = std::result::Result<
        crate::output::SearchDashboardsOutput,
        crate::error::SearchDashboardsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_dashboards_error(response)
        } else {
            crate::operation_deser::parse_search_dashboards_response(response)
        }
    }
}

/// Operation shape for `SearchFolders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_folders`](crate::client::Client::search_folders).
///
/// See [`crate::client::fluent_builders::SearchFolders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchFolders {
    _private: (),
}
impl SearchFolders {
    /// Creates a new builder-style object to manufacture [`SearchFoldersInput`](crate::input::SearchFoldersInput)
    pub fn builder() -> crate::input::search_folders_input::Builder {
        crate::input::search_folders_input::Builder::default()
    }
    /// Creates a new `SearchFolders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchFolders {
    type Output =
        std::result::Result<crate::output::SearchFoldersOutput, crate::error::SearchFoldersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_folders_error(response)
        } else {
            crate::operation_deser::parse_search_folders_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccountCustomization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account_customization`](crate::client::Client::update_account_customization).
///
/// See [`crate::client::fluent_builders::UpdateAccountCustomization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccountCustomization {
    _private: (),
}
impl UpdateAccountCustomization {
    /// Creates a new builder-style object to manufacture [`UpdateAccountCustomizationInput`](crate::input::UpdateAccountCustomizationInput)
    pub fn builder() -> crate::input::update_account_customization_input::Builder {
        crate::input::update_account_customization_input::Builder::default()
    }
    /// Creates a new `UpdateAccountCustomization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccountCustomization {
    type Output = std::result::Result<
        crate::output::UpdateAccountCustomizationOutput,
        crate::error::UpdateAccountCustomizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_account_customization_error(response)
        } else {
            crate::operation_deser::parse_update_account_customization_response(response)
        }
    }
}

/// Operation shape for `UpdateAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account_settings`](crate::client::Client::update_account_settings).
///
/// See [`crate::client::fluent_builders::UpdateAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccountSettings {
    _private: (),
}
impl UpdateAccountSettings {
    /// Creates a new builder-style object to manufacture [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
    pub fn builder() -> crate::input::update_account_settings_input::Builder {
        crate::input::update_account_settings_input::Builder::default()
    }
    /// Creates a new `UpdateAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccountSettings {
    type Output = std::result::Result<
        crate::output::UpdateAccountSettingsOutput,
        crate::error::UpdateAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_account_settings_error(response)
        } else {
            crate::operation_deser::parse_update_account_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_analysis`](crate::client::Client::update_analysis).
///
/// See [`crate::client::fluent_builders::UpdateAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAnalysis {
    _private: (),
}
impl UpdateAnalysis {
    /// Creates a new builder-style object to manufacture [`UpdateAnalysisInput`](crate::input::UpdateAnalysisInput)
    pub fn builder() -> crate::input::update_analysis_input::Builder {
        crate::input::update_analysis_input::Builder::default()
    }
    /// Creates a new `UpdateAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAnalysis {
    type Output =
        std::result::Result<crate::output::UpdateAnalysisOutput, crate::error::UpdateAnalysisError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_analysis_error(response)
        } else {
            crate::operation_deser::parse_update_analysis_response(response)
        }
    }
}

/// Operation shape for `UpdateAnalysisPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_analysis_permissions`](crate::client::Client::update_analysis_permissions).
///
/// See [`crate::client::fluent_builders::UpdateAnalysisPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAnalysisPermissions {
    _private: (),
}
impl UpdateAnalysisPermissions {
    /// Creates a new builder-style object to manufacture [`UpdateAnalysisPermissionsInput`](crate::input::UpdateAnalysisPermissionsInput)
    pub fn builder() -> crate::input::update_analysis_permissions_input::Builder {
        crate::input::update_analysis_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateAnalysisPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAnalysisPermissions {
    type Output = std::result::Result<
        crate::output::UpdateAnalysisPermissionsOutput,
        crate::error::UpdateAnalysisPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_analysis_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_analysis_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dashboard`](crate::client::Client::update_dashboard).
///
/// See [`crate::client::fluent_builders::UpdateDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDashboard {
    _private: (),
}
impl UpdateDashboard {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
    pub fn builder() -> crate::input::update_dashboard_input::Builder {
        crate::input::update_dashboard_input::Builder::default()
    }
    /// Creates a new `UpdateDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDashboard {
    type Output = std::result::Result<
        crate::output::UpdateDashboardOutput,
        crate::error::UpdateDashboardError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dashboard_error(response)
        } else {
            crate::operation_deser::parse_update_dashboard_response(response)
        }
    }
}

/// Operation shape for `UpdateDashboardPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dashboard_permissions`](crate::client::Client::update_dashboard_permissions).
///
/// See [`crate::client::fluent_builders::UpdateDashboardPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDashboardPermissions {
    _private: (),
}
impl UpdateDashboardPermissions {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardPermissionsInput`](crate::input::UpdateDashboardPermissionsInput)
    pub fn builder() -> crate::input::update_dashboard_permissions_input::Builder {
        crate::input::update_dashboard_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateDashboardPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDashboardPermissions {
    type Output = std::result::Result<
        crate::output::UpdateDashboardPermissionsOutput,
        crate::error::UpdateDashboardPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dashboard_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_dashboard_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateDashboardPublishedVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dashboard_published_version`](crate::client::Client::update_dashboard_published_version).
///
/// See [`crate::client::fluent_builders::UpdateDashboardPublishedVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDashboardPublishedVersion {
    _private: (),
}
impl UpdateDashboardPublishedVersion {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardPublishedVersionInput`](crate::input::UpdateDashboardPublishedVersionInput)
    pub fn builder() -> crate::input::update_dashboard_published_version_input::Builder {
        crate::input::update_dashboard_published_version_input::Builder::default()
    }
    /// Creates a new `UpdateDashboardPublishedVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDashboardPublishedVersion {
    type Output = std::result::Result<
        crate::output::UpdateDashboardPublishedVersionOutput,
        crate::error::UpdateDashboardPublishedVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dashboard_published_version_error(response)
        } else {
            crate::operation_deser::parse_update_dashboard_published_version_response(response)
        }
    }
}

/// Operation shape for `UpdateDataSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_set`](crate::client::Client::update_data_set).
///
/// See [`crate::client::fluent_builders::UpdateDataSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataSet {
    _private: (),
}
impl UpdateDataSet {
    /// Creates a new builder-style object to manufacture [`UpdateDataSetInput`](crate::input::UpdateDataSetInput)
    pub fn builder() -> crate::input::update_data_set_input::Builder {
        crate::input::update_data_set_input::Builder::default()
    }
    /// Creates a new `UpdateDataSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataSet {
    type Output =
        std::result::Result<crate::output::UpdateDataSetOutput, crate::error::UpdateDataSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_set_error(response)
        } else {
            crate::operation_deser::parse_update_data_set_response(response)
        }
    }
}

/// Operation shape for `UpdateDataSetPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_set_permissions`](crate::client::Client::update_data_set_permissions).
///
/// See [`crate::client::fluent_builders::UpdateDataSetPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataSetPermissions {
    _private: (),
}
impl UpdateDataSetPermissions {
    /// Creates a new builder-style object to manufacture [`UpdateDataSetPermissionsInput`](crate::input::UpdateDataSetPermissionsInput)
    pub fn builder() -> crate::input::update_data_set_permissions_input::Builder {
        crate::input::update_data_set_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateDataSetPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataSetPermissions {
    type Output = std::result::Result<
        crate::output::UpdateDataSetPermissionsOutput,
        crate::error::UpdateDataSetPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_set_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_data_set_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_source`](crate::client::Client::update_data_source).
///
/// See [`crate::client::fluent_builders::UpdateDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataSource {
    _private: (),
}
impl UpdateDataSource {
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    pub fn builder() -> crate::input::update_data_source_input::Builder {
        crate::input::update_data_source_input::Builder::default()
    }
    /// Creates a new `UpdateDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataSource {
    type Output = std::result::Result<
        crate::output::UpdateDataSourceOutput,
        crate::error::UpdateDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_source_error(response)
        } else {
            crate::operation_deser::parse_update_data_source_response(response)
        }
    }
}

/// Operation shape for `UpdateDataSourcePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_source_permissions`](crate::client::Client::update_data_source_permissions).
///
/// See [`crate::client::fluent_builders::UpdateDataSourcePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataSourcePermissions {
    _private: (),
}
impl UpdateDataSourcePermissions {
    /// Creates a new builder-style object to manufacture [`UpdateDataSourcePermissionsInput`](crate::input::UpdateDataSourcePermissionsInput)
    pub fn builder() -> crate::input::update_data_source_permissions_input::Builder {
        crate::input::update_data_source_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateDataSourcePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataSourcePermissions {
    type Output = std::result::Result<
        crate::output::UpdateDataSourcePermissionsOutput,
        crate::error::UpdateDataSourcePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_source_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_data_source_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_folder`](crate::client::Client::update_folder).
///
/// See [`crate::client::fluent_builders::UpdateFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFolder {
    _private: (),
}
impl UpdateFolder {
    /// Creates a new builder-style object to manufacture [`UpdateFolderInput`](crate::input::UpdateFolderInput)
    pub fn builder() -> crate::input::update_folder_input::Builder {
        crate::input::update_folder_input::Builder::default()
    }
    /// Creates a new `UpdateFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFolder {
    type Output =
        std::result::Result<crate::output::UpdateFolderOutput, crate::error::UpdateFolderError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_folder_error(response)
        } else {
            crate::operation_deser::parse_update_folder_response(response)
        }
    }
}

/// Operation shape for `UpdateFolderPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_folder_permissions`](crate::client::Client::update_folder_permissions).
///
/// See [`crate::client::fluent_builders::UpdateFolderPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFolderPermissions {
    _private: (),
}
impl UpdateFolderPermissions {
    /// Creates a new builder-style object to manufacture [`UpdateFolderPermissionsInput`](crate::input::UpdateFolderPermissionsInput)
    pub fn builder() -> crate::input::update_folder_permissions_input::Builder {
        crate::input::update_folder_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateFolderPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFolderPermissions {
    type Output = std::result::Result<
        crate::output::UpdateFolderPermissionsOutput,
        crate::error::UpdateFolderPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_folder_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_folder_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_group`](crate::client::Client::update_group).
///
/// See [`crate::client::fluent_builders::UpdateGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGroup {
    _private: (),
}
impl UpdateGroup {
    /// Creates a new builder-style object to manufacture [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    pub fn builder() -> crate::input::update_group_input::Builder {
        crate::input::update_group_input::Builder::default()
    }
    /// Creates a new `UpdateGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGroup {
    type Output =
        std::result::Result<crate::output::UpdateGroupOutput, crate::error::UpdateGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_group_error(response)
        } else {
            crate::operation_deser::parse_update_group_response(response)
        }
    }
}

/// Operation shape for `UpdateIAMPolicyAssignment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_iam_policy_assignment`](crate::client::Client::update_iam_policy_assignment).
///
/// See [`crate::client::fluent_builders::UpdateIAMPolicyAssignment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIAMPolicyAssignment {
    _private: (),
}
impl UpdateIAMPolicyAssignment {
    /// Creates a new builder-style object to manufacture [`UpdateIamPolicyAssignmentInput`](crate::input::UpdateIamPolicyAssignmentInput)
    pub fn builder() -> crate::input::update_iam_policy_assignment_input::Builder {
        crate::input::update_iam_policy_assignment_input::Builder::default()
    }
    /// Creates a new `UpdateIAMPolicyAssignment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIAMPolicyAssignment {
    type Output = std::result::Result<
        crate::output::UpdateIamPolicyAssignmentOutput,
        crate::error::UpdateIAMPolicyAssignmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_iam_policy_assignment_error(response)
        } else {
            crate::operation_deser::parse_update_iam_policy_assignment_response(response)
        }
    }
}

/// Operation shape for `UpdateIpRestriction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ip_restriction`](crate::client::Client::update_ip_restriction).
///
/// See [`crate::client::fluent_builders::UpdateIpRestriction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIpRestriction {
    _private: (),
}
impl UpdateIpRestriction {
    /// Creates a new builder-style object to manufacture [`UpdateIpRestrictionInput`](crate::input::UpdateIpRestrictionInput)
    pub fn builder() -> crate::input::update_ip_restriction_input::Builder {
        crate::input::update_ip_restriction_input::Builder::default()
    }
    /// Creates a new `UpdateIpRestriction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIpRestriction {
    type Output = std::result::Result<
        crate::output::UpdateIpRestrictionOutput,
        crate::error::UpdateIpRestrictionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ip_restriction_error(response)
        } else {
            crate::operation_deser::parse_update_ip_restriction_response(response)
        }
    }
}

/// Operation shape for `UpdateTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_template`](crate::client::Client::update_template).
///
/// See [`crate::client::fluent_builders::UpdateTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTemplate {
    _private: (),
}
impl UpdateTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateInput`](crate::input::UpdateTemplateInput)
    pub fn builder() -> crate::input::update_template_input::Builder {
        crate::input::update_template_input::Builder::default()
    }
    /// Creates a new `UpdateTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTemplate {
    type Output =
        std::result::Result<crate::output::UpdateTemplateOutput, crate::error::UpdateTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_template_error(response)
        } else {
            crate::operation_deser::parse_update_template_response(response)
        }
    }
}

/// Operation shape for `UpdateTemplateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_template_alias`](crate::client::Client::update_template_alias).
///
/// See [`crate::client::fluent_builders::UpdateTemplateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTemplateAlias {
    _private: (),
}
impl UpdateTemplateAlias {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateAliasInput`](crate::input::UpdateTemplateAliasInput)
    pub fn builder() -> crate::input::update_template_alias_input::Builder {
        crate::input::update_template_alias_input::Builder::default()
    }
    /// Creates a new `UpdateTemplateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTemplateAlias {
    type Output = std::result::Result<
        crate::output::UpdateTemplateAliasOutput,
        crate::error::UpdateTemplateAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_template_alias_error(response)
        } else {
            crate::operation_deser::parse_update_template_alias_response(response)
        }
    }
}

/// Operation shape for `UpdateTemplatePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_template_permissions`](crate::client::Client::update_template_permissions).
///
/// See [`crate::client::fluent_builders::UpdateTemplatePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTemplatePermissions {
    _private: (),
}
impl UpdateTemplatePermissions {
    /// Creates a new builder-style object to manufacture [`UpdateTemplatePermissionsInput`](crate::input::UpdateTemplatePermissionsInput)
    pub fn builder() -> crate::input::update_template_permissions_input::Builder {
        crate::input::update_template_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateTemplatePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTemplatePermissions {
    type Output = std::result::Result<
        crate::output::UpdateTemplatePermissionsOutput,
        crate::error::UpdateTemplatePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_template_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_template_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateTheme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_theme`](crate::client::Client::update_theme).
///
/// See [`crate::client::fluent_builders::UpdateTheme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTheme {
    _private: (),
}
impl UpdateTheme {
    /// Creates a new builder-style object to manufacture [`UpdateThemeInput`](crate::input::UpdateThemeInput)
    pub fn builder() -> crate::input::update_theme_input::Builder {
        crate::input::update_theme_input::Builder::default()
    }
    /// Creates a new `UpdateTheme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTheme {
    type Output =
        std::result::Result<crate::output::UpdateThemeOutput, crate::error::UpdateThemeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_theme_error(response)
        } else {
            crate::operation_deser::parse_update_theme_response(response)
        }
    }
}

/// Operation shape for `UpdateThemeAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_theme_alias`](crate::client::Client::update_theme_alias).
///
/// See [`crate::client::fluent_builders::UpdateThemeAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThemeAlias {
    _private: (),
}
impl UpdateThemeAlias {
    /// Creates a new builder-style object to manufacture [`UpdateThemeAliasInput`](crate::input::UpdateThemeAliasInput)
    pub fn builder() -> crate::input::update_theme_alias_input::Builder {
        crate::input::update_theme_alias_input::Builder::default()
    }
    /// Creates a new `UpdateThemeAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThemeAlias {
    type Output = std::result::Result<
        crate::output::UpdateThemeAliasOutput,
        crate::error::UpdateThemeAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_theme_alias_error(response)
        } else {
            crate::operation_deser::parse_update_theme_alias_response(response)
        }
    }
}

/// Operation shape for `UpdateThemePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_theme_permissions`](crate::client::Client::update_theme_permissions).
///
/// See [`crate::client::fluent_builders::UpdateThemePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThemePermissions {
    _private: (),
}
impl UpdateThemePermissions {
    /// Creates a new builder-style object to manufacture [`UpdateThemePermissionsInput`](crate::input::UpdateThemePermissionsInput)
    pub fn builder() -> crate::input::update_theme_permissions_input::Builder {
        crate::input::update_theme_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateThemePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThemePermissions {
    type Output = std::result::Result<
        crate::output::UpdateThemePermissionsOutput,
        crate::error::UpdateThemePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_theme_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_theme_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user`](crate::client::Client::update_user).
///
/// See [`crate::client::fluent_builders::UpdateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUser {
    _private: (),
}
impl UpdateUser {
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
    /// Creates a new `UpdateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUser {
    type Output =
        std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_error(response)
        } else {
            crate::operation_deser::parse_update_user_response(response)
        }
    }
}
