// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelIngestion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelIngestionError {
    /// Kind of error that occurred.
    pub kind: CancelIngestionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelIngestion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelIngestionErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelIngestionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelIngestionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelIngestionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CancelIngestionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CancelIngestionErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CancelIngestionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelIngestionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelIngestionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelIngestionError {
    fn code(&self) -> Option<&str> {
        CancelIngestionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelIngestionError {
    /// Creates a new `CancelIngestionError`.
    pub fn new(kind: CancelIngestionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelIngestionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelIngestionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelIngestionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelIngestionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelIngestionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelIngestionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelIngestionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelIngestionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelIngestionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelIngestionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelIngestionErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelIngestionErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelIngestionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelIngestionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelIngestionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CancelIngestionErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CancelIngestionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelIngestionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelIngestionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CancelIngestionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CancelIngestionErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CancelIngestionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelIngestionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelIngestionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccountCustomizationError {
    /// Kind of error that occurred.
    pub kind: CreateAccountCustomizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccountCustomizationErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccountCustomizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccountCustomizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAccountCustomizationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAccountCustomizationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CreateAccountCustomizationErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateAccountCustomizationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAccountCustomizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccountCustomizationError {
    fn code(&self) -> Option<&str> {
        CreateAccountCustomizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccountCustomizationError {
    /// Creates a new `CreateAccountCustomizationError`.
    pub fn new(kind: CreateAccountCustomizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccountCustomizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccountCustomizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccountCustomizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccountCustomizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountCustomizationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountCustomizationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateAccountCustomizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccountCustomizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAccountCustomizationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAccountCustomizationErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            CreateAccountCustomizationErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateAccountCustomizationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAccountCustomizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAnalysisError {
    /// Kind of error that occurred.
    pub kind: CreateAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAnalysisErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAnalysisErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAnalysisErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAnalysisErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateAnalysisErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateAnalysisErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAnalysisErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAnalysisError {
    fn code(&self) -> Option<&str> {
        CreateAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAnalysisError {
    /// Creates a new `CreateAnalysisError`.
    pub fn new(kind: CreateAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAnalysisErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateAnalysisErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateAnalysisErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnalysisErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnalysisErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnalysisErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnalysisErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnalysisErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnalysisErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnalysisErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateAnalysisErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateAnalysisErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnalysisErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAnalysisErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAnalysisErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAnalysisErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateAnalysisErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateAnalysisErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAnalysisErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDashboardError {
    /// Kind of error that occurred.
    pub kind: CreateDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDashboardErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDashboardErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDashboardError {
    fn code(&self) -> Option<&str> {
        CreateDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDashboardError {
    /// Creates a new `CreateDashboardError`.
    pub fn new(kind: CreateDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDashboardErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDashboardErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDashboardErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDashboardErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDashboardErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDashboardErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDashboardErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDashboardErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDashboardErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDashboardErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateDashboardErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDashboardErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSetError {
    /// Kind of error that occurred.
    pub kind: CreateDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSetErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSetError {
    fn code(&self) -> Option<&str> {
        CreateDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSetError {
    /// Creates a new `CreateDataSetError`.
    pub fn new(kind: CreateDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDataSetErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSetErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDataSetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDataSetErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDataSetErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateDataSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDataSetErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateDataSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDataSetErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSourceError {
    /// Kind of error that occurred.
    pub kind: CreateDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSourceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSourceError {
    fn code(&self) -> Option<&str> {
        CreateDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSourceError {
    /// Creates a new `CreateDataSourceError`.
    pub fn new(kind: CreateDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFolderError {
    /// Kind of error that occurred.
    pub kind: CreateFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFolderErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFolderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFolderError {
    fn code(&self) -> Option<&str> {
        CreateFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFolderError {
    /// Creates a new `CreateFolderError`.
    pub fn new(kind: CreateFolderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFolderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateFolderErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateFolderErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateFolderErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateFolderErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateFolderErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFolderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFolderErrorKind::ConflictException(_inner) => Some(_inner),
            CreateFolderErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateFolderErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateFolderErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFolderErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateFolderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFolderErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFolderErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateFolderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFolderMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFolderMembershipError {
    /// Kind of error that occurred.
    pub kind: CreateFolderMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFolderMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFolderMembershipErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFolderMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFolderMembershipErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFolderMembershipErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateFolderMembershipErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CreateFolderMembershipErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFolderMembershipErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateFolderMembershipErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFolderMembershipErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFolderMembershipErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            CreateFolderMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFolderMembershipError {
    fn code(&self) -> Option<&str> {
        CreateFolderMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFolderMembershipError {
    /// Creates a new `CreateFolderMembershipError`.
    pub fn new(kind: CreateFolderMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFolderMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFolderMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFolderMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFolderMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFolderMembershipErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFolderMembershipErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateFolderMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFolderMembershipErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFolderMembershipErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateFolderMembershipErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateFolderMembershipErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFolderMembershipErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateFolderMembershipErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFolderMembershipErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFolderMembershipErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            CreateFolderMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGroupErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGroupError {
    fn code(&self) -> Option<&str> {
        CreateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGroupError {
    /// Creates a new `CreateGroupError`.
    pub fn new(kind: CreateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::ResourceExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGroupErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            CreateGroupErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateGroupErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            CreateGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGroupMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGroupMembershipError {
    /// Kind of error that occurred.
    pub kind: CreateGroupMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGroupMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGroupMembershipErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGroupMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGroupMembershipErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateGroupMembershipErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateGroupMembershipErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateGroupMembershipErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            CreateGroupMembershipErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateGroupMembershipErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            CreateGroupMembershipErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateGroupMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGroupMembershipError {
    fn code(&self) -> Option<&str> {
        CreateGroupMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGroupMembershipError {
    /// Creates a new `CreateGroupMembershipError`.
    pub fn new(kind: CreateGroupMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGroupMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGroupMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGroupMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGroupMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGroupMembershipErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupMembershipErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupMembershipErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupMembershipErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupMembershipErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupMembershipErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupMembershipErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupMembershipErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupMembershipErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupMembershipErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupMembershipErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupMembershipErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupMembershipErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupMembershipErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateGroupMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGroupMembershipErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateGroupMembershipErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateGroupMembershipErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateGroupMembershipErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            CreateGroupMembershipErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateGroupMembershipErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            CreateGroupMembershipErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateGroupMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIAMPolicyAssignmentError {
    /// Kind of error that occurred.
    pub kind: CreateIAMPolicyAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIAMPolicyAssignmentErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource is already in a state that indicates an operation is happening that must complete before a new update can be applied.</p>
    ConcurrentUpdatingException(crate::error::ConcurrentUpdatingException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIAMPolicyAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_inner) => {
                _inner.fmt(f)
            }
            CreateIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CreateIAMPolicyAssignmentErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateIAMPolicyAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIAMPolicyAssignmentError {
    fn code(&self) -> Option<&str> {
        CreateIAMPolicyAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIAMPolicyAssignmentError {
    /// Creates a new `CreateIAMPolicyAssignmentError`.
    pub fn new(kind: CreateIAMPolicyAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIAMPolicyAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIAMPolicyAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIAMPolicyAssignmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIAMPolicyAssignmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException`.
    pub fn is_concurrent_updating_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIAMPolicyAssignmentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIAMPolicyAssignmentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIAMPolicyAssignmentErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIAMPolicyAssignmentErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIAMPolicyAssignmentErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIAMPolicyAssignmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIAMPolicyAssignmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIAMPolicyAssignmentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateIAMPolicyAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_inner) => Some(_inner),
            CreateIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            CreateIAMPolicyAssignmentErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateIAMPolicyAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIngestion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIngestionError {
    /// Kind of error that occurred.
    pub kind: CreateIngestionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIngestion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIngestionErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIngestionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIngestionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateIngestionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateIngestionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateIngestionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateIngestionErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateIngestionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateIngestionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateIngestionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIngestionError {
    fn code(&self) -> Option<&str> {
        CreateIngestionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIngestionError {
    /// Creates a new `CreateIngestionError`.
    pub fn new(kind: CreateIngestionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIngestionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIngestionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIngestionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIngestionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIngestionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIngestionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIngestionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIngestionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIngestionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIngestionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIngestionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIngestionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIngestionErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIngestionErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIngestionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIngestionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIngestionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateIngestionErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateIngestionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIngestionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateIngestionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateIngestionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateIngestionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateIngestionErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateIngestionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateIngestionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateIngestionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNamespaceError {
    /// Kind of error that occurred.
    pub kind: CreateNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNamespaceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNamespaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNamespaceError {
    fn code(&self) -> Option<&str> {
        CreateNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNamespaceError {
    /// Creates a new `CreateNamespaceError`.
    pub fn new(kind: CreateNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateNamespaceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamespaceErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNamespaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateNamespaceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNamespaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTemplateErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTemplateError {
    fn code(&self) -> Option<&str> {
        CreateTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTemplateError {
    /// Creates a new `CreateTemplateError`.
    pub fn new(kind: CreateTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateTemplateErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateTemplateErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            CreateTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateTemplateErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateTemplateErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateTemplateErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateTemplateErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTemplateAliasError {
    /// Kind of error that occurred.
    pub kind: CreateTemplateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTemplateAliasErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTemplateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTemplateAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateTemplateAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateTemplateAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateTemplateAliasErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateTemplateAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateTemplateAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateTemplateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTemplateAliasError {
    fn code(&self) -> Option<&str> {
        CreateTemplateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTemplateAliasError {
    /// Creates a new `CreateTemplateAliasError`.
    pub fn new(kind: CreateTemplateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTemplateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTemplateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTemplateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTemplateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTemplateAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateAliasErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateAliasErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateAliasErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateAliasErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateTemplateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTemplateAliasErrorKind::ConflictException(_inner) => Some(_inner),
            CreateTemplateAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateTemplateAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateTemplateAliasErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateTemplateAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateTemplateAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateTemplateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateThemeError {
    /// Kind of error that occurred.
    pub kind: CreateThemeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateThemeErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateThemeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateThemeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateThemeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateThemeError {
    fn code(&self) -> Option<&str> {
        CreateThemeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateThemeError {
    /// Creates a new `CreateThemeError`.
    pub fn new(kind: CreateThemeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateThemeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateThemeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateThemeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateThemeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateThemeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateThemeErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateThemeErrorKind::ResourceExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateThemeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateThemeErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateThemeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateThemeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateThemeErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateThemeErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateThemeErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateThemeErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateThemeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateThemeErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateThemeErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateThemeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateThemeAliasError {
    /// Kind of error that occurred.
    pub kind: CreateThemeAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateThemeAliasErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateThemeAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateThemeAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            CreateThemeAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateThemeAliasError {
    fn code(&self) -> Option<&str> {
        CreateThemeAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateThemeAliasError {
    /// Creates a new `CreateThemeAliasError`.
    pub fn new(kind: CreateThemeAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateThemeAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateThemeAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateThemeAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateThemeAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateThemeAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeAliasErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeAliasErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThemeAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThemeAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for CreateThemeAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateThemeAliasErrorKind::ConflictException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            CreateThemeAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccountCustomizationError {
    /// Kind of error that occurred.
    pub kind: DeleteAccountCustomizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccountCustomizationErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccountCustomizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccountCustomizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAccountCustomizationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAccountCustomizationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAccountCustomizationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAccountCustomizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccountCustomizationError {
    fn code(&self) -> Option<&str> {
        DeleteAccountCustomizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccountCustomizationError {
    /// Creates a new `DeleteAccountCustomizationError`.
    pub fn new(kind: DeleteAccountCustomizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccountCustomizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccountCustomizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccountCustomizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccountCustomizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccountCustomizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountCustomizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountCustomizationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountCustomizationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountCustomizationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountCustomizationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountCustomizationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountCustomizationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountCustomizationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountCustomizationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountCustomizationErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountCustomizationErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountCustomizationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountCustomizationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteAccountCustomizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccountCustomizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAccountCustomizationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAccountCustomizationErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteAccountCustomizationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAccountCustomizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAnalysisError {
    /// Kind of error that occurred.
    pub kind: DeleteAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAnalysisErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAnalysisErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAnalysisErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAnalysisErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteAnalysisErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAnalysisErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DeleteAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAnalysisError {
    fn code(&self) -> Option<&str> {
        DeleteAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAnalysisError {
    /// Creates a new `DeleteAnalysisError`.
    pub fn new(kind: DeleteAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAnalysisErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteAnalysisErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteAnalysisErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnalysisErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnalysisErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteAnalysisErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteAnalysisErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnalysisErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAnalysisErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAnalysisErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAnalysisErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteAnalysisErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAnalysisErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DeleteAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDashboardError {
    /// Kind of error that occurred.
    pub kind: DeleteDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDashboardErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDashboardErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DeleteDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDashboardError {
    fn code(&self) -> Option<&str> {
        DeleteDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDashboardError {
    /// Creates a new `DeleteDashboardError`.
    pub fn new(kind: DeleteDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDashboardErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDashboardErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDashboardErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDashboardErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDashboardErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteDashboardErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDashboardErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DeleteDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataSetError {
    /// Kind of error that occurred.
    pub kind: DeleteDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataSetErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataSetError {
    fn code(&self) -> Option<&str> {
        DeleteDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataSetError {
    /// Creates a new `DeleteDataSetError`.
    pub fn new(kind: DeleteDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSetErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataSourceError {
    /// Kind of error that occurred.
    pub kind: DeleteDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataSourceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataSourceError {
    fn code(&self) -> Option<&str> {
        DeleteDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataSourceError {
    /// Creates a new `DeleteDataSourceError`.
    pub fn new(kind: DeleteDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFolderError {
    /// Kind of error that occurred.
    pub kind: DeleteFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFolderErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFolderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DeleteFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFolderError {
    fn code(&self) -> Option<&str> {
        DeleteFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFolderError {
    /// Creates a new `DeleteFolderError`.
    pub fn new(kind: DeleteFolderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFolderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteFolderErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteFolderErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteFolderErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteFolderErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFolderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFolderErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteFolderErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteFolderErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteFolderErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DeleteFolderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFolderErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFolderErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DeleteFolderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFolderMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFolderMembershipError {
    /// Kind of error that occurred.
    pub kind: DeleteFolderMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFolderMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFolderMembershipErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFolderMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFolderMembershipErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFolderMembershipErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteFolderMembershipErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFolderMembershipErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFolderMembershipErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFolderMembershipErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFolderMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFolderMembershipError {
    fn code(&self) -> Option<&str> {
        DeleteFolderMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFolderMembershipError {
    /// Creates a new `DeleteFolderMembershipError`.
    pub fn new(kind: DeleteFolderMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFolderMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFolderMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFolderMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFolderMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFolderMembershipErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderMembershipErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderMembershipErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderMembershipErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderMembershipErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderMembershipErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderMembershipErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderMembershipErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderMembershipErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderMembershipErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFolderMembershipErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFolderMembershipErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteFolderMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFolderMembershipErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFolderMembershipErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteFolderMembershipErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteFolderMembershipErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFolderMembershipErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFolderMembershipErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            DeleteFolderMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupError {
    /// Creates a new `DeleteGroupError`.
    pub fn new(kind: DeleteGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteGroupErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DeleteGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteGroupErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DeleteGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroupMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupMembershipError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupMembershipErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroupMembership` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupMembershipErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupMembershipError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupMembershipErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteGroupMembershipErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteGroupMembershipErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteGroupMembershipErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DeleteGroupMembershipErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteGroupMembershipErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DeleteGroupMembershipErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteGroupMembershipErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupMembershipError {
    fn code(&self) -> Option<&str> {
        DeleteGroupMembershipError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupMembershipError {
    /// Creates a new `DeleteGroupMembershipError`.
    pub fn new(kind: DeleteGroupMembershipErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupMembershipError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupMembershipErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupMembershipError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupMembershipErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGroupMembershipErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupMembershipErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupMembershipErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupMembershipErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupMembershipErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupMembershipErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupMembershipErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupMembershipErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupMembershipErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupMembershipErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupMembershipErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupMembershipErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupMembershipErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupMembershipErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteGroupMembershipError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupMembershipErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteGroupMembershipErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteGroupMembershipErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteGroupMembershipErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DeleteGroupMembershipErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteGroupMembershipErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DeleteGroupMembershipErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteGroupMembershipErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIAMPolicyAssignmentError {
    /// Kind of error that occurred.
    pub kind: DeleteIAMPolicyAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIAMPolicyAssignmentErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource is already in a state that indicates an operation is happening that must complete before a new update can be applied.</p>
    ConcurrentUpdatingException(crate::error::ConcurrentUpdatingException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIAMPolicyAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteIAMPolicyAssignmentErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            DeleteIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteIAMPolicyAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIAMPolicyAssignmentError {
    fn code(&self) -> Option<&str> {
        DeleteIAMPolicyAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIAMPolicyAssignmentError {
    /// Creates a new `DeleteIAMPolicyAssignmentError`.
    pub fn new(kind: DeleteIAMPolicyAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIAMPolicyAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIAMPolicyAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIAMPolicyAssignmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIAMPolicyAssignmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException`.
    pub fn is_concurrent_updating_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIAMPolicyAssignmentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIAMPolicyAssignmentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIAMPolicyAssignmentErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIAMPolicyAssignmentErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIAMPolicyAssignmentErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIAMPolicyAssignmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIAMPolicyAssignmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIAMPolicyAssignmentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteIAMPolicyAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_inner) => Some(_inner),
            DeleteIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteIAMPolicyAssignmentErrorKind::ResourceExistsException(_inner) => Some(_inner),
            DeleteIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteIAMPolicyAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNamespaceError {
    /// Kind of error that occurred.
    pub kind: DeleteNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNamespaceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNamespaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNamespaceError {
    fn code(&self) -> Option<&str> {
        DeleteNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNamespaceError {
    /// Creates a new `DeleteNamespaceError`.
    pub fn new(kind: DeleteNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamespaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamespaceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamespaceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamespaceErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamespaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamespaceErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNamespaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteNamespaceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNamespaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTemplateErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteTemplateErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteTemplateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteTemplateErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DeleteTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTemplateError {
    /// Creates a new `DeleteTemplateError`.
    pub fn new(kind: DeleteTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteTemplateErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteTemplateErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteTemplateErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteTemplateErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteTemplateErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DeleteTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTemplateAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteTemplateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTemplateAliasErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTemplateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTemplateAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteTemplateAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteTemplateAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTemplateAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DeleteTemplateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTemplateAliasError {
    fn code(&self) -> Option<&str> {
        DeleteTemplateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTemplateAliasError {
    /// Creates a new `DeleteTemplateAliasError`.
    pub fn new(kind: DeleteTemplateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTemplateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTemplateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTemplateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTemplateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTemplateAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateAliasErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteTemplateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTemplateAliasErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteTemplateAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteTemplateAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTemplateAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DeleteTemplateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThemeError {
    /// Kind of error that occurred.
    pub kind: DeleteThemeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThemeErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThemeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThemeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteThemeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteThemeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteThemeErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteThemeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteThemeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteThemeErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DeleteThemeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThemeError {
    fn code(&self) -> Option<&str> {
        DeleteThemeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThemeError {
    /// Creates a new `DeleteThemeError`.
    pub fn new(kind: DeleteThemeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThemeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThemeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThemeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThemeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThemeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteThemeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteThemeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteThemeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteThemeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThemeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThemeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThemeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteThemeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteThemeErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteThemeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThemeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteThemeErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteThemeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteThemeErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteThemeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteThemeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteThemeErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DeleteThemeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThemeAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteThemeAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThemeAliasErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThemeAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThemeAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteThemeAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteThemeAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteThemeAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteThemeAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DeleteThemeAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThemeAliasError {
    fn code(&self) -> Option<&str> {
        DeleteThemeAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThemeAliasError {
    /// Creates a new `DeleteThemeAliasError`.
    pub fn new(kind: DeleteThemeAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThemeAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThemeAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThemeAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThemeAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThemeAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteThemeAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteThemeAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThemeAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThemeAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThemeAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThemeAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThemeAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DeleteThemeAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThemeAliasErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteThemeAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteThemeAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteThemeAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteThemeAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DeleteThemeAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteUserErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteUserErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteUserErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DeleteUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserByPrincipalId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserByPrincipalIdError {
    /// Kind of error that occurred.
    pub kind: DeleteUserByPrincipalIdErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserByPrincipalId` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserByPrincipalIdErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserByPrincipalIdError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserByPrincipalIdErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteUserByPrincipalIdErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteUserByPrincipalIdErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteUserByPrincipalIdErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DeleteUserByPrincipalIdErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserByPrincipalIdErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DeleteUserByPrincipalIdErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteUserByPrincipalIdErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserByPrincipalIdError {
    fn code(&self) -> Option<&str> {
        DeleteUserByPrincipalIdError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserByPrincipalIdError {
    /// Creates a new `DeleteUserByPrincipalIdError`.
    pub fn new(kind: DeleteUserByPrincipalIdErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserByPrincipalIdError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserByPrincipalIdErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserByPrincipalIdError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserByPrincipalIdErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserByPrincipalIdErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserByPrincipalIdErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserByPrincipalIdErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserByPrincipalIdErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserByPrincipalIdErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserByPrincipalIdErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserByPrincipalIdErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserByPrincipalIdErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserByPrincipalIdErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserByPrincipalIdErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserByPrincipalIdErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserByPrincipalIdErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserByPrincipalIdErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserByPrincipalIdErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteUserByPrincipalIdError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserByPrincipalIdErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteUserByPrincipalIdErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteUserByPrincipalIdErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteUserByPrincipalIdErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DeleteUserByPrincipalIdErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserByPrincipalIdErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DeleteUserByPrincipalIdErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteUserByPrincipalIdErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountCustomizationError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountCustomizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountCustomizationErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountCustomizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountCustomizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountCustomizationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountCustomizationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAccountCustomizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountCustomizationError {
    fn code(&self) -> Option<&str> {
        DescribeAccountCustomizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountCustomizationError {
    /// Creates a new `DescribeAccountCustomizationError`.
    pub fn new(kind: DescribeAccountCustomizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountCustomizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountCustomizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountCustomizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountCustomizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountCustomizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountCustomizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountCustomizationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountCustomizationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountCustomizationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountCustomizationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountCustomizationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountCustomizationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountCustomizationErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountCustomizationErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountCustomizationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountCustomizationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAccountCustomizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountCustomizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountCustomizationErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribeAccountCustomizationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccountCustomizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountSettingsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAccountSettingsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAccountSettingsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAccountSettingsErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAccountSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountSettingsError {
    /// Creates a new `DescribeAccountSettingsError`.
    pub fn new(kind: DescribeAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountSettingsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountSettingsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountSettingsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountSettingsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountSettingsErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountSettingsErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountSettingsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAccountSettingsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAccountSettingsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeAccountSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAccountSettingsErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DescribeAccountSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAnalysisError {
    /// Kind of error that occurred.
    pub kind: DescribeAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAnalysisErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAnalysisErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAnalysisErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAnalysisErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeAnalysisErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAnalysisErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DescribeAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAnalysisError {
    fn code(&self) -> Option<&str> {
        DescribeAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAnalysisError {
    /// Creates a new `DescribeAnalysisError`.
    pub fn new(kind: DescribeAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAnalysisErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAnalysisErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAnalysisErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAnalysisErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeAnalysisErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAnalysisErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DescribeAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAnalysisPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAnalysisPermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeAnalysisPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAnalysisPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAnalysisPermissionsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAnalysisPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAnalysisPermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAnalysisPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnalysisPermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnalysisPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAnalysisPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnalysisPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAnalysisPermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeAnalysisPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAnalysisPermissionsError {
    /// Creates a new `DescribeAnalysisPermissionsError`.
    pub fn new(kind: DescribeAnalysisPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAnalysisPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAnalysisPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAnalysisPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAnalysisPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAnalysisPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnalysisPermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnalysisPermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeAnalysisPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAnalysisPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAnalysisPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeAnalysisPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAnalysisPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAnalysisPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            DescribeAnalysisPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDashboardError {
    /// Kind of error that occurred.
    pub kind: DescribeDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDashboardErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDashboardErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DescribeDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDashboardError {
    fn code(&self) -> Option<&str> {
        DescribeDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDashboardError {
    /// Creates a new `DescribeDashboardError`.
    pub fn new(kind: DescribeDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDashboardErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDashboardErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDashboardErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DescribeDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDashboardPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDashboardPermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeDashboardPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDashboardPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDashboardPermissionsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDashboardPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDashboardPermissionsErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDashboardPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDashboardPermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDashboardPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDashboardPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDashboardPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDashboardPermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeDashboardPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDashboardPermissionsError {
    /// Creates a new `DescribeDashboardPermissionsError`.
    pub fn new(kind: DescribeDashboardPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDashboardPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDashboardPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDashboardPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDashboardPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDashboardPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDashboardPermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDashboardPermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeDashboardPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDashboardPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDashboardPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeDashboardPermissionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeDashboardPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDashboardPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            DescribeDashboardPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSetError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSetErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDataSetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDataSetErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeDataSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSetError {
    fn code(&self) -> Option<&str> {
        DescribeDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSetError {
    /// Creates a new `DescribeDataSetError`.
    pub fn new(kind: DescribeDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeDataSetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDataSetErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDataSetErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeDataSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSetPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSetPermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSetPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSetPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSetPermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSetPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSetPermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDataSetPermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDataSetPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataSetPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDataSetPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDataSetPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSetPermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeDataSetPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSetPermissionsError {
    /// Creates a new `DescribeDataSetPermissionsError`.
    pub fn new(kind: DescribeDataSetPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSetPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSetPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSetPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSetPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSetPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSetPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSetPermissionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDataSetPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSetPermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDataSetPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDataSetPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeDataSetPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDataSetPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDataSetPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSourceError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSourceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSourceError {
    fn code(&self) -> Option<&str> {
        DescribeDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSourceError {
    /// Creates a new `DescribeDataSourceError`.
    pub fn new(kind: DescribeDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSourcePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSourcePermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSourcePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSourcePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSourcePermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSourcePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSourcePermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDataSourcePermissionsErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataSourcePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataSourcePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDataSourcePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDataSourcePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSourcePermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeDataSourcePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSourcePermissionsError {
    /// Creates a new `DescribeDataSourcePermissionsError`.
    pub fn new(
        kind: DescribeDataSourcePermissionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSourcePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSourcePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSourcePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSourcePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSourcePermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourcePermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourcePermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourcePermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourcePermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourcePermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourcePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourcePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourcePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourcePermissionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDataSourcePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSourcePermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDataSourcePermissionsErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeDataSourcePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeDataSourcePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeDataSourcePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDataSourcePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFolderError {
    /// Kind of error that occurred.
    pub kind: DescribeFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFolderErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFolderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeFolderErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeFolderErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeFolderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFolderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFolderErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DescribeFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFolderError {
    fn code(&self) -> Option<&str> {
        DescribeFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFolderError {
    /// Creates a new `DescribeFolderError`.
    pub fn new(kind: DescribeFolderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFolderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeFolderErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeFolderErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFolderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeFolderErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeFolderErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeFolderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFolderErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFolderErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DescribeFolderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFolderPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFolderPermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeFolderPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFolderPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFolderPermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFolderPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFolderPermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeFolderPermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeFolderPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFolderPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFolderPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFolderPermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeFolderPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFolderPermissionsError {
    /// Creates a new `DescribeFolderPermissionsError`.
    pub fn new(kind: DescribeFolderPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFolderPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFolderPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFolderPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFolderPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFolderPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderPermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderPermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeFolderPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFolderPermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeFolderPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeFolderPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeFolderPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFolderPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFolderPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            DescribeFolderPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFolderResolvedPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFolderResolvedPermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeFolderResolvedPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFolderResolvedPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFolderResolvedPermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFolderResolvedPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFolderResolvedPermissionsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderResolvedPermissionsErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderResolvedPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderResolvedPermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderResolvedPermissionsErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderResolvedPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFolderResolvedPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFolderResolvedPermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeFolderResolvedPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFolderResolvedPermissionsError {
    /// Creates a new `DescribeFolderResolvedPermissionsError`.
    pub fn new(
        kind: DescribeFolderResolvedPermissionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFolderResolvedPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFolderResolvedPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFolderResolvedPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFolderResolvedPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFolderResolvedPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderResolvedPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderResolvedPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderResolvedPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderResolvedPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderResolvedPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderResolvedPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderResolvedPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderResolvedPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderResolvedPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFolderResolvedPermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFolderResolvedPermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeFolderResolvedPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFolderResolvedPermissionsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeFolderResolvedPermissionsErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeFolderResolvedPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeFolderResolvedPermissionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeFolderResolvedPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFolderResolvedPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            DescribeFolderResolvedPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGroupErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGroupError {
    fn code(&self) -> Option<&str> {
        DescribeGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGroupError {
    /// Creates a new `DescribeGroupError`.
    pub fn new(kind: DescribeGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeGroupErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGroupErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeGroupErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeGroupErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DescribeGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeGroupErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DescribeGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIAMPolicyAssignmentError {
    /// Kind of error that occurred.
    pub kind: DescribeIAMPolicyAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIAMPolicyAssignmentErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIAMPolicyAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeIAMPolicyAssignmentErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeIAMPolicyAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIAMPolicyAssignmentError {
    fn code(&self) -> Option<&str> {
        DescribeIAMPolicyAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIAMPolicyAssignmentError {
    /// Creates a new `DescribeIAMPolicyAssignmentError`.
    pub fn new(kind: DescribeIAMPolicyAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIAMPolicyAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIAMPolicyAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIAMPolicyAssignmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIAMPolicyAssignmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIAMPolicyAssignmentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIAMPolicyAssignmentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIAMPolicyAssignmentErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIAMPolicyAssignmentErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIAMPolicyAssignmentErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIAMPolicyAssignmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIAMPolicyAssignmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIAMPolicyAssignmentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeIAMPolicyAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeIAMPolicyAssignmentErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeIAMPolicyAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIngestion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIngestionError {
    /// Kind of error that occurred.
    pub kind: DescribeIngestionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIngestion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIngestionErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIngestionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIngestionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeIngestionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeIngestionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeIngestionErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            DescribeIngestionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeIngestionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeIngestionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIngestionError {
    fn code(&self) -> Option<&str> {
        DescribeIngestionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIngestionError {
    /// Creates a new `DescribeIngestionError`.
    pub fn new(kind: DescribeIngestionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIngestionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIngestionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIngestionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIngestionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIngestionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIngestionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIngestionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIngestionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIngestionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIngestionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIngestionErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIngestionErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIngestionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIngestionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIngestionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIngestionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeIngestionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIngestionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeIngestionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeIngestionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeIngestionErrorKind::ResourceExistsException(_inner) => Some(_inner),
            DescribeIngestionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIngestionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeIngestionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIpRestriction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIpRestrictionError {
    /// Kind of error that occurred.
    pub kind: DescribeIpRestrictionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIpRestriction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIpRestrictionErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIpRestrictionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIpRestrictionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeIpRestrictionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeIpRestrictionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeIpRestrictionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeIpRestrictionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeIpRestrictionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIpRestrictionError {
    fn code(&self) -> Option<&str> {
        DescribeIpRestrictionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIpRestrictionError {
    /// Creates a new `DescribeIpRestrictionError`.
    pub fn new(kind: DescribeIpRestrictionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIpRestrictionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIpRestrictionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIpRestrictionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIpRestrictionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIpRestrictionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIpRestrictionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIpRestrictionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIpRestrictionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIpRestrictionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIpRestrictionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIpRestrictionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIpRestrictionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIpRestrictionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIpRestrictionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeIpRestrictionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIpRestrictionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeIpRestrictionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeIpRestrictionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeIpRestrictionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIpRestrictionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeIpRestrictionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNamespaceError {
    /// Kind of error that occurred.
    pub kind: DescribeNamespaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNamespace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNamespaceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNamespaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeNamespaceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeNamespaceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeNamespaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeNamespaceErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DescribeNamespaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeNamespaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNamespaceError {
    fn code(&self) -> Option<&str> {
        DescribeNamespaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNamespaceError {
    /// Creates a new `DescribeNamespaceError`.
    pub fn new(kind: DescribeNamespaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNamespaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNamespaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNamespaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNamespaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNamespaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNamespaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNamespaceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNamespaceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNamespaceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNamespaceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNamespaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNamespaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNamespaceErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNamespaceErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNamespaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNamespaceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeNamespaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNamespaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeNamespaceErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeNamespaceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeNamespaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeNamespaceErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DescribeNamespaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeNamespaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTemplateError {
    /// Kind of error that occurred.
    pub kind: DescribeTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTemplateErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DescribeTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTemplateError {
    fn code(&self) -> Option<&str> {
        DescribeTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTemplateError {
    /// Creates a new `DescribeTemplateError`.
    pub fn new(kind: DescribeTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::ResourceExistsException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DescribeTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTemplateAliasError {
    /// Kind of error that occurred.
    pub kind: DescribeTemplateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTemplateAliasErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTemplateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTemplateAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeTemplateAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTemplateAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTemplateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTemplateAliasError {
    fn code(&self) -> Option<&str> {
        DescribeTemplateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTemplateAliasError {
    /// Creates a new `DescribeTemplateAliasError`.
    pub fn new(kind: DescribeTemplateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTemplateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTemplateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTemplateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTemplateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTemplateAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplateAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplateAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeTemplateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTemplateAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeTemplateAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTemplateAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DescribeTemplateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTemplatePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTemplatePermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeTemplatePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTemplatePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTemplatePermissionsErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTemplatePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTemplatePermissionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeTemplatePermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeTemplatePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTemplatePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTemplatePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeTemplatePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTemplatePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTemplatePermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeTemplatePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTemplatePermissionsError {
    /// Creates a new `DescribeTemplatePermissionsError`.
    pub fn new(kind: DescribeTemplatePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTemplatePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTemplatePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTemplatePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTemplatePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTemplatePermissionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplatePermissionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplatePermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplatePermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplatePermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplatePermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplatePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplatePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplatePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplatePermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTemplatePermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTemplatePermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeTemplatePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTemplatePermissionsErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeTemplatePermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeTemplatePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeTemplatePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTemplatePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeTemplatePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            DescribeTemplatePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThemeError {
    /// Kind of error that occurred.
    pub kind: DescribeThemeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThemeErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThemeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThemeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeThemeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeThemeErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeThemeErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            DescribeThemeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeThemeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThemeErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DescribeThemeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThemeError {
    fn code(&self) -> Option<&str> {
        DescribeThemeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThemeError {
    /// Creates a new `DescribeThemeError`.
    pub fn new(kind: DescribeThemeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThemeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThemeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThemeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThemeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThemeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeThemeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribeThemeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeThemeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeThemeErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeThemeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThemeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeThemeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeThemeErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeThemeErrorKind::ResourceExistsException(_inner) => Some(_inner),
            DescribeThemeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeThemeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThemeErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DescribeThemeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThemeAliasError {
    /// Kind of error that occurred.
    pub kind: DescribeThemeAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThemeAliasErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThemeAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThemeAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeThemeAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeThemeAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeThemeAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeThemeAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            DescribeThemeAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThemeAliasError {
    fn code(&self) -> Option<&str> {
        DescribeThemeAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThemeAliasError {
    /// Creates a new `DescribeThemeAliasError`.
    pub fn new(kind: DescribeThemeAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThemeAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThemeAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThemeAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThemeAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThemeAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeAliasErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemeAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemeAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeThemeAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThemeAliasErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeThemeAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeThemeAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeThemeAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeThemeAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            DescribeThemeAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeThemePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThemePermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeThemePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeThemePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThemePermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThemePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThemePermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeThemePermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeThemePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeThemePermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeThemePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThemePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            DescribeThemePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThemePermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeThemePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThemePermissionsError {
    /// Creates a new `DescribeThemePermissionsError`.
    pub fn new(kind: DescribeThemePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThemePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThemePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThemePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThemePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThemePermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemePermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemePermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemePermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemePermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemePermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemePermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThemePermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThemePermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for DescribeThemePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThemePermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeThemePermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeThemePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeThemePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeThemePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThemePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            DescribeThemePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserError {
    /// Kind of error that occurred.
    pub kind: DescribeUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserError {
    fn code(&self) -> Option<&str> {
        DescribeUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserError {
    /// Creates a new `DescribeUserError`.
    pub fn new(kind: DescribeUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeUserErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeUserErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DescribeUserErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            DescribeUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            DescribeUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateEmbedUrlForAnonymousUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateEmbedUrlForAnonymousUserError {
    /// Kind of error that occurred.
    pub kind: GenerateEmbedUrlForAnonymousUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateEmbedUrlForAnonymousUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateEmbedUrlForAnonymousUserErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be 15-600 minutes.</p>
    SessionLifetimeInMinutesInvalidException(
        crate::error::SessionLifetimeInMinutesInvalidException,
    ),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an embedding operation in Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
    /// <p>After capacity pricing is added, you can use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code> API operation with the <code>--identity-type ANONYMOUS</code> option.</p>
    UnsupportedPricingPlanException(crate::error::UnsupportedPricingPlanException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateEmbedUrlForAnonymousUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateEmbedUrlForAnonymousUserErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::SessionLifetimeInMinutesInvalidException(
                _inner,
            ) => _inner.fmt(f),
            GenerateEmbedUrlForAnonymousUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedPricingPlanException(_inner) => {
                _inner.fmt(f)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateEmbedUrlForAnonymousUserError {
    fn code(&self) -> Option<&str> {
        GenerateEmbedUrlForAnonymousUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateEmbedUrlForAnonymousUserError {
    /// Creates a new `GenerateEmbedUrlForAnonymousUserError`.
    pub fn new(
        kind: GenerateEmbedUrlForAnonymousUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateEmbedUrlForAnonymousUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateEmbedUrlForAnonymousUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateEmbedUrlForAnonymousUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateEmbedUrlForAnonymousUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::SessionLifetimeInMinutesInvalidException`.
    pub fn is_session_lifetime_in_minutes_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::SessionLifetimeInMinutesInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedPricingPlanException`.
    pub fn is_unsupported_pricing_plan_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedPricingPlanException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for GenerateEmbedUrlForAnonymousUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateEmbedUrlForAnonymousUserErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::SessionLifetimeInMinutesInvalidException(
                _inner,
            ) => Some(_inner),
            GenerateEmbedUrlForAnonymousUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedPricingPlanException(_inner) => {
                Some(_inner)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            GenerateEmbedUrlForAnonymousUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateEmbedUrlForRegisteredUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateEmbedUrlForRegisteredUserError {
    /// Kind of error that occurred.
    pub kind: GenerateEmbedUrlForRegisteredUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateEmbedUrlForRegisteredUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateEmbedUrlForRegisteredUserErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The user with the provided name isn't found. This error can happen in any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>
    QuickSightUserNotFoundException(crate::error::QuickSightUserNotFoundException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be 15-600 minutes.</p>
    SessionLifetimeInMinutesInvalidException(
        crate::error::SessionLifetimeInMinutesInvalidException,
    ),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an embedding operation in Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
    /// <p>After capacity pricing is added, you can use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code> API operation with the <code>--identity-type ANONYMOUS</code> option.</p>
    UnsupportedPricingPlanException(crate::error::UnsupportedPricingPlanException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateEmbedUrlForRegisteredUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateEmbedUrlForRegisteredUserErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::InternalFailureException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::QuickSightUserNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::SessionLifetimeInMinutesInvalidException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::ThrottlingException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedPricingPlanException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedUserEditionException(_inner) =>
            _inner.fmt(f)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateEmbedUrlForRegisteredUserError {
    fn code(&self) -> Option<&str> {
        GenerateEmbedUrlForRegisteredUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateEmbedUrlForRegisteredUserError {
    /// Creates a new `GenerateEmbedUrlForRegisteredUserError`.
    pub fn new(
        kind: GenerateEmbedUrlForRegisteredUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateEmbedUrlForRegisteredUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateEmbedUrlForRegisteredUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateEmbedUrlForRegisteredUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateEmbedUrlForRegisteredUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::QuickSightUserNotFoundException`.
    pub fn is_quick_sight_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::QuickSightUserNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::SessionLifetimeInMinutesInvalidException`.
    pub fn is_session_lifetime_in_minutes_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::SessionLifetimeInMinutesInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedPricingPlanException`.
    pub fn is_unsupported_pricing_plan_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedPricingPlanException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for GenerateEmbedUrlForRegisteredUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateEmbedUrlForRegisteredUserErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::InternalFailureException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::QuickSightUserNotFoundException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::SessionLifetimeInMinutesInvalidException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::ThrottlingException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedPricingPlanException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedUserEditionException(_inner) =>
            Some(_inner)
            ,
            GenerateEmbedUrlForRegisteredUserErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetDashboardEmbedUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDashboardEmbedUrlError {
    /// Kind of error that occurred.
    pub kind: GetDashboardEmbedUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDashboardEmbedUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDashboardEmbedUrlErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The domain specified isn't on the allow list. All domains for embedded dashboards must be added to the approved list by an Amazon QuickSight admin.</p>
    DomainNotWhitelistedException(crate::error::DomainNotWhitelistedException),
    /// <p>The identity type specified isn't supported. Supported identity types include <code>IAM</code> and <code>QUICKSIGHT</code>.</p>
    IdentityTypeNotSupportedException(crate::error::IdentityTypeNotSupportedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The user with the provided name isn't found. This error can happen in any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>
    QuickSightUserNotFoundException(crate::error::QuickSightUserNotFoundException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be 15-600 minutes.</p>
    SessionLifetimeInMinutesInvalidException(
        crate::error::SessionLifetimeInMinutesInvalidException,
    ),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an embedding operation in Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
    /// <p>After capacity pricing is added, you can use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code> API operation with the <code>--identity-type ANONYMOUS</code> option.</p>
    UnsupportedPricingPlanException(crate::error::UnsupportedPricingPlanException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDashboardEmbedUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDashboardEmbedUrlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::DomainNotWhitelistedException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::IdentityTypeNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            GetDashboardEmbedUrlErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::QuickSightUserNotFoundException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(_inner) => {
                _inner.fmt(f)
            }
            GetDashboardEmbedUrlErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::UnsupportedPricingPlanException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            GetDashboardEmbedUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDashboardEmbedUrlError {
    fn code(&self) -> Option<&str> {
        GetDashboardEmbedUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDashboardEmbedUrlError {
    /// Creates a new `GetDashboardEmbedUrlError`.
    pub fn new(kind: GetDashboardEmbedUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDashboardEmbedUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDashboardEmbedUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDashboardEmbedUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDashboardEmbedUrlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::DomainNotWhitelistedException`.
    pub fn is_domain_not_whitelisted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::DomainNotWhitelistedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::IdentityTypeNotSupportedException`.
    pub fn is_identity_type_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::IdentityTypeNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::QuickSightUserNotFoundException`.
    pub fn is_quick_sight_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::QuickSightUserNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException`.
    pub fn is_session_lifetime_in_minutes_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::UnsupportedPricingPlanException`.
    pub fn is_unsupported_pricing_plan_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::UnsupportedPricingPlanException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDashboardEmbedUrlErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardEmbedUrlErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for GetDashboardEmbedUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDashboardEmbedUrlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::DomainNotWhitelistedException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::IdentityTypeNotSupportedException(_inner) => {
                Some(_inner)
            }
            GetDashboardEmbedUrlErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::QuickSightUserNotFoundException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::ResourceExistsException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(_inner) => {
                Some(_inner)
            }
            GetDashboardEmbedUrlErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::UnsupportedPricingPlanException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            GetDashboardEmbedUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSessionEmbedUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSessionEmbedUrlError {
    /// Kind of error that occurred.
    pub kind: GetSessionEmbedUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSessionEmbedUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSessionEmbedUrlErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The user with the provided name isn't found. This error can happen in any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>
    QuickSightUserNotFoundException(crate::error::QuickSightUserNotFoundException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be 15-600 minutes.</p>
    SessionLifetimeInMinutesInvalidException(
        crate::error::SessionLifetimeInMinutesInvalidException,
    ),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSessionEmbedUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSessionEmbedUrlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::QuickSightUserNotFoundException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(_inner) => {
                _inner.fmt(f)
            }
            GetSessionEmbedUrlErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            GetSessionEmbedUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSessionEmbedUrlError {
    fn code(&self) -> Option<&str> {
        GetSessionEmbedUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSessionEmbedUrlError {
    /// Creates a new `GetSessionEmbedUrlError`.
    pub fn new(kind: GetSessionEmbedUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSessionEmbedUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSessionEmbedUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSessionEmbedUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSessionEmbedUrlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::QuickSightUserNotFoundException`.
    pub fn is_quick_sight_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::QuickSightUserNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException`.
    pub fn is_session_lifetime_in_minutes_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionEmbedUrlErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionEmbedUrlErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for GetSessionEmbedUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSessionEmbedUrlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::QuickSightUserNotFoundException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::ResourceExistsException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(_inner) => {
                Some(_inner)
            }
            GetSessionEmbedUrlErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            GetSessionEmbedUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAnalyses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAnalysesError {
    /// Kind of error that occurred.
    pub kind: ListAnalysesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAnalyses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAnalysesErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAnalysesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAnalysesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAnalysesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListAnalysesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAnalysesErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListAnalysesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAnalysesError {
    fn code(&self) -> Option<&str> {
        ListAnalysesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAnalysesError {
    /// Creates a new `ListAnalysesError`.
    pub fn new(kind: ListAnalysesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAnalysesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAnalysesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAnalysesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAnalysesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAnalysesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnalysesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnalysesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnalysesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnalysesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAnalysesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListAnalysesErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnalysesErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListAnalysesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAnalysesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAnalysesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListAnalysesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAnalysesErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListAnalysesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDashboardsError {
    /// Kind of error that occurred.
    pub kind: ListDashboardsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDashboardsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDashboardsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDashboardsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDashboardsError {
    fn code(&self) -> Option<&str> {
        ListDashboardsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDashboardsError {
    /// Creates a new `ListDashboardsError`.
    pub fn new(kind: ListDashboardsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDashboardsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDashboardsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDashboardsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDashboardsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDashboardsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDashboardsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDashboardsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDashboardsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDashboardsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListDashboardsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDashboardsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDashboardsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDashboardsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDashboardsErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListDashboardsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDashboardVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDashboardVersionsError {
    /// Kind of error that occurred.
    pub kind: ListDashboardVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDashboardVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDashboardVersionsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDashboardVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDashboardVersionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDashboardVersionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDashboardVersionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListDashboardVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDashboardVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDashboardVersionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            ListDashboardVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDashboardVersionsError {
    fn code(&self) -> Option<&str> {
        ListDashboardVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDashboardVersionsError {
    /// Creates a new `ListDashboardVersionsError`.
    pub fn new(kind: ListDashboardVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDashboardVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDashboardVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDashboardVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDashboardVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDashboardVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDashboardVersionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardVersionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDashboardVersionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardVersionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDashboardVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDashboardVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDashboardVersionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardVersionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListDashboardVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDashboardVersionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDashboardVersionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDashboardVersionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListDashboardVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDashboardVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDashboardVersionsErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListDashboardVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataSetsError {
    /// Kind of error that occurred.
    pub kind: ListDataSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataSetsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataSetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataSetsError {
    fn code(&self) -> Option<&str> {
        ListDataSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataSetsError {
    /// Creates a new `ListDataSetsError`.
    pub fn new(kind: ListDataSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListDataSetsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSetsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDataSetsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDataSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataSetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDataSetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDataSetsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDataSetsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListDataSetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataSourcesError {
    /// Kind of error that occurred.
    pub kind: ListDataSourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataSourcesErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataSourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataSourcesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataSourcesError {
    fn code(&self) -> Option<&str> {
        ListDataSourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataSourcesError {
    /// Creates a new `ListDataSourcesError`.
    pub fn new(kind: ListDataSourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataSourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataSourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataSourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataSourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataSourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDataSourcesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDataSourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataSourcesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFolderMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFolderMembersError {
    /// Kind of error that occurred.
    pub kind: ListFolderMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFolderMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFolderMembersErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFolderMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFolderMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFolderMembersErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListFolderMembersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListFolderMembersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListFolderMembersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFolderMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFolderMembersErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListFolderMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFolderMembersError {
    fn code(&self) -> Option<&str> {
        ListFolderMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFolderMembersError {
    /// Creates a new `ListFolderMembersError`.
    pub fn new(kind: ListFolderMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFolderMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFolderMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFolderMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFolderMembersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFolderMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFolderMembersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFolderMembersErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFolderMembersErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFolderMembersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFolderMembersErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFolderMembersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFolderMembersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFolderMembersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFolderMembersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFolderMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFolderMembersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFolderMembersErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFolderMembersErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListFolderMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFolderMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFolderMembersErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListFolderMembersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListFolderMembersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListFolderMembersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFolderMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFolderMembersErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListFolderMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFolders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFoldersError {
    /// Kind of error that occurred.
    pub kind: ListFoldersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFolders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFoldersErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFoldersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFoldersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFoldersErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListFoldersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListFoldersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListFoldersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFoldersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFoldersErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListFoldersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFoldersError {
    fn code(&self) -> Option<&str> {
        ListFoldersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFoldersError {
    /// Creates a new `ListFoldersError`.
    pub fn new(kind: ListFoldersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFoldersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFoldersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFoldersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFoldersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFoldersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListFoldersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListFoldersErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFoldersErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFoldersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFoldersErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFoldersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFoldersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFoldersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFoldersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFoldersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFoldersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListFoldersErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFoldersErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListFoldersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFoldersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFoldersErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListFoldersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListFoldersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListFoldersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFoldersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFoldersErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListFoldersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroupMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupMembershipsError {
    /// Kind of error that occurred.
    pub kind: ListGroupMembershipsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroupMemberships` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupMembershipsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupMembershipsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupMembershipsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListGroupMembershipsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupMembershipsError {
    fn code(&self) -> Option<&str> {
        ListGroupMembershipsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupMembershipsError {
    /// Creates a new `ListGroupMembershipsError`.
    pub fn new(kind: ListGroupMembershipsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupMembershipsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupMembershipsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupMembershipsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupMembershipsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupMembershipsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupMembershipsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListGroupMembershipsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupMembershipsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListGroupMembershipsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupsError {
    /// Kind of error that occurred.
    pub kind: ListGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupsError {
    fn code(&self) -> Option<&str> {
        ListGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupsError {
    /// Creates a new `ListGroupsError`.
    pub fn new(kind: ListGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListGroupsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListGroupsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListGroupsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListGroupsErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            ListGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListGroupsErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ListGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIAMPolicyAssignments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIAMPolicyAssignmentsError {
    /// Kind of error that occurred.
    pub kind: ListIAMPolicyAssignmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIAMPolicyAssignments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIAMPolicyAssignmentsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIAMPolicyAssignmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIAMPolicyAssignmentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIAMPolicyAssignmentsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListIAMPolicyAssignmentsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListIAMPolicyAssignmentsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListIAMPolicyAssignmentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListIAMPolicyAssignmentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIAMPolicyAssignmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIAMPolicyAssignmentsError {
    fn code(&self) -> Option<&str> {
        ListIAMPolicyAssignmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIAMPolicyAssignmentsError {
    /// Creates a new `ListIAMPolicyAssignmentsError`.
    pub fn new(kind: ListIAMPolicyAssignmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIAMPolicyAssignmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIAMPolicyAssignmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIAMPolicyAssignmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIAMPolicyAssignmentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListIAMPolicyAssignmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIAMPolicyAssignmentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIAMPolicyAssignmentsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListIAMPolicyAssignmentsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListIAMPolicyAssignmentsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListIAMPolicyAssignmentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIAMPolicyAssignmentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIAMPolicyAssignmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIAMPolicyAssignmentsForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIAMPolicyAssignmentsForUserError {
    /// Kind of error that occurred.
    pub kind: ListIAMPolicyAssignmentsForUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIAMPolicyAssignmentsForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIAMPolicyAssignmentsForUserErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource is already in a state that indicates an operation is happening that must complete before a new update can be applied.</p>
    ConcurrentUpdatingException(crate::error::ConcurrentUpdatingException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIAMPolicyAssignmentsForUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIAMPolicyAssignmentsForUserErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::ConcurrentUpdatingException(_inner) => {
                _inner.fmt(f)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::ResourceExistsException(_inner) => {
                _inner.fmt(f)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIAMPolicyAssignmentsForUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIAMPolicyAssignmentsForUserError {
    fn code(&self) -> Option<&str> {
        ListIAMPolicyAssignmentsForUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIAMPolicyAssignmentsForUserError {
    /// Creates a new `ListIAMPolicyAssignmentsForUserError`.
    pub fn new(
        kind: ListIAMPolicyAssignmentsForUserErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIAMPolicyAssignmentsForUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIAMPolicyAssignmentsForUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIAMPolicyAssignmentsForUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIAMPolicyAssignmentsForUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsForUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsForUserErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsForUserErrorKind::ConcurrentUpdatingException`.
    pub fn is_concurrent_updating_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsForUserErrorKind::ConcurrentUpdatingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsForUserErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsForUserErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsForUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsForUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsForUserErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsForUserErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsForUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsForUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIAMPolicyAssignmentsForUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIAMPolicyAssignmentsForUserErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListIAMPolicyAssignmentsForUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIAMPolicyAssignmentsForUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIAMPolicyAssignmentsForUserErrorKind::ConcurrentUpdatingException(_inner) => {
                Some(_inner)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::ResourceExistsException(_inner) => {
                Some(_inner)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListIAMPolicyAssignmentsForUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIAMPolicyAssignmentsForUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIngestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIngestionsError {
    /// Kind of error that occurred.
    pub kind: ListIngestionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIngestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIngestionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIngestionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIngestionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIngestionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListIngestionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListIngestionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListIngestionsErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            ListIngestionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListIngestionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIngestionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIngestionsError {
    fn code(&self) -> Option<&str> {
        ListIngestionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIngestionsError {
    /// Creates a new `ListIngestionsError`.
    pub fn new(kind: ListIngestionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIngestionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIngestionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIngestionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIngestionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIngestionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIngestionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIngestionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIngestionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIngestionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIngestionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIngestionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIngestionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIngestionsErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIngestionsErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIngestionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIngestionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIngestionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListIngestionsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListIngestionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIngestionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIngestionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListIngestionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListIngestionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListIngestionsErrorKind::ResourceExistsException(_inner) => Some(_inner),
            ListIngestionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIngestionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIngestionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNamespaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNamespacesError {
    /// Kind of error that occurred.
    pub kind: ListNamespacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNamespaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNamespacesErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNamespacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNamespacesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListNamespacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNamespacesError {
    fn code(&self) -> Option<&str> {
        ListNamespacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNamespacesError {
    /// Creates a new `ListNamespacesError`.
    pub fn new(kind: ListNamespacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNamespacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNamespacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNamespacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNamespacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamespacesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamespacesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamespacesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamespacesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamespacesErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamespacesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamespacesErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNamespacesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListNamespacesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListNamespacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNamespacesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNamespacesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListNamespacesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListNamespacesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListNamespacesErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            ListNamespacesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListNamespacesErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ListNamespacesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNamespacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTemplateAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTemplateAliasesError {
    /// Kind of error that occurred.
    pub kind: ListTemplateAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTemplateAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTemplateAliasesErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTemplateAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTemplateAliasesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTemplateAliasesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTemplateAliasesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTemplateAliasesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTemplateAliasesErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListTemplateAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTemplateAliasesError {
    fn code(&self) -> Option<&str> {
        ListTemplateAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTemplateAliasesError {
    /// Creates a new `ListTemplateAliasesError`.
    pub fn new(kind: ListTemplateAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTemplateAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTemplateAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTemplateAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTemplateAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTemplateAliasesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateAliasesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateAliasesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateAliasesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateAliasesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateAliasesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateAliasesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateAliasesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateAliasesErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateAliasesErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListTemplateAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTemplateAliasesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTemplateAliasesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTemplateAliasesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTemplateAliasesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTemplateAliasesErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListTemplateAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTemplatesErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTemplatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTemplatesError {
    fn code(&self) -> Option<&str> {
        ListTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTemplatesError {
    /// Creates a new `ListTemplatesError`.
    pub fn new(kind: ListTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListTemplatesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListTemplatesErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplatesErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTemplatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTemplatesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTemplatesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTemplatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTemplatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTemplatesErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTemplateVersionsError {
    /// Kind of error that occurred.
    pub kind: ListTemplateVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTemplateVersionsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTemplateVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTemplateVersionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListTemplateVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTemplateVersionsError {
    fn code(&self) -> Option<&str> {
        ListTemplateVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTemplateVersionsError {
    /// Creates a new `ListTemplateVersionsError`.
    pub fn new(kind: ListTemplateVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTemplateVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTemplateVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTemplateVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTemplateVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTemplateVersionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTemplateVersionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListTemplateVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTemplateVersionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListTemplateVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListThemeAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListThemeAliasesError {
    /// Kind of error that occurred.
    pub kind: ListThemeAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListThemeAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListThemeAliasesErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListThemeAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListThemeAliasesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListThemeAliasesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListThemeAliasesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListThemeAliasesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListThemeAliasesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListThemeAliasesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListThemeAliasesErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListThemeAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListThemeAliasesError {
    fn code(&self) -> Option<&str> {
        ListThemeAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListThemeAliasesError {
    /// Creates a new `ListThemeAliasesError`.
    pub fn new(kind: ListThemeAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListThemeAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListThemeAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListThemeAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListThemeAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListThemeAliasesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListThemeAliasesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListThemeAliasesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeAliasesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeAliasesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeAliasesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeAliasesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeAliasesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeAliasesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeAliasesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeAliasesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeAliasesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeAliasesErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeAliasesErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListThemeAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListThemeAliasesErrorKind::ConflictException(_inner) => Some(_inner),
            ListThemeAliasesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListThemeAliasesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListThemeAliasesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListThemeAliasesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListThemeAliasesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListThemeAliasesErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListThemeAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListThemes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListThemesError {
    /// Kind of error that occurred.
    pub kind: ListThemesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListThemes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListThemesErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListThemesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListThemesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListThemesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListThemesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListThemesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListThemesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListThemesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListThemesErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListThemesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListThemesError {
    fn code(&self) -> Option<&str> {
        ListThemesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListThemesError {
    /// Creates a new `ListThemesError`.
    pub fn new(kind: ListThemesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListThemesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListThemesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListThemesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListThemesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListThemesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListThemesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListThemesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListThemesErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `ListThemesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListThemesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListThemesErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemesErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListThemesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListThemesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListThemesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListThemesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListThemesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListThemesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListThemesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListThemesErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListThemesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListThemeVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListThemeVersionsError {
    /// Kind of error that occurred.
    pub kind: ListThemeVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListThemeVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListThemeVersionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListThemeVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListThemeVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListThemeVersionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListThemeVersionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListThemeVersionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListThemeVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListThemeVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListThemeVersionsErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            ListThemeVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListThemeVersionsError {
    fn code(&self) -> Option<&str> {
        ListThemeVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListThemeVersionsError {
    /// Creates a new `ListThemeVersionsError`.
    pub fn new(kind: ListThemeVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListThemeVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListThemeVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListThemeVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListThemeVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListThemeVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeVersionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeVersionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeVersionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeVersionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThemeVersionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThemeVersionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for ListThemeVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListThemeVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListThemeVersionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListThemeVersionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListThemeVersionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListThemeVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListThemeVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListThemeVersionsErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            ListThemeVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserGroupsError {
    /// Kind of error that occurred.
    pub kind: ListUserGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserGroupsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListUserGroupsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListUserGroupsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListUserGroupsErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            ListUserGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUserGroupsErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ListUserGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUserGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserGroupsError {
    fn code(&self) -> Option<&str> {
        ListUserGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserGroupsError {
    /// Creates a new `ListUserGroupsError`.
    pub fn new(kind: ListUserGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserGroupsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserGroupsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserGroupsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserGroupsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserGroupsErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserGroupsErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserGroupsErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserGroupsErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListUserGroupsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListUserGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListUserGroupsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListUserGroupsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListUserGroupsErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            ListUserGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUserGroupsErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ListUserGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUserGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InvalidNextTokenException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListUsersErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListUsersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListUsersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListUsersErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUsersErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            ListUsersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterUserError {
    /// Kind of error that occurred.
    pub kind: RegisterUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterUserErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RegisterUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterUserError {
    fn code(&self) -> Option<&str> {
        RegisterUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterUserError {
    /// Creates a new `RegisterUserError`.
    pub fn new(kind: RegisterUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, RegisterUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterUserErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, RegisterUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterUserErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterUserErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterUserErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, RegisterUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for RegisterUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterUserErrorKind::InternalFailureException(_inner) => Some(_inner),
            RegisterUserErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            RegisterUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            RegisterUserErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            RegisterUserErrorKind::ResourceExistsException(_inner) => Some(_inner),
            RegisterUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RegisterUserErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            RegisterUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            RegisterUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreAnalysisError {
    /// Kind of error that occurred.
    pub kind: RestoreAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreAnalysisErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreAnalysisErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RestoreAnalysisErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            RestoreAnalysisErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            RestoreAnalysisErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RestoreAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RestoreAnalysisErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            RestoreAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreAnalysisError {
    fn code(&self) -> Option<&str> {
        RestoreAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreAnalysisError {
    /// Creates a new `RestoreAnalysisError`.
    pub fn new(kind: RestoreAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreAnalysisErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, RestoreAnalysisErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `RestoreAnalysisErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreAnalysisErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreAnalysisErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreAnalysisErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreAnalysisErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreAnalysisErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, RestoreAnalysisErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `RestoreAnalysisErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreAnalysisErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for RestoreAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreAnalysisErrorKind::ConflictException(_inner) => Some(_inner),
            RestoreAnalysisErrorKind::InternalFailureException(_inner) => Some(_inner),
            RestoreAnalysisErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            RestoreAnalysisErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RestoreAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            RestoreAnalysisErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            RestoreAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchAnalyses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchAnalysesError {
    /// Kind of error that occurred.
    pub kind: SearchAnalysesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchAnalyses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchAnalysesErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchAnalysesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchAnalysesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            SearchAnalysesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            SearchAnalysesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            SearchAnalysesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SearchAnalysesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SearchAnalysesErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            SearchAnalysesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchAnalysesError {
    fn code(&self) -> Option<&str> {
        SearchAnalysesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchAnalysesError {
    /// Creates a new `SearchAnalysesError`.
    pub fn new(kind: SearchAnalysesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchAnalysesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchAnalysesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchAnalysesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchAnalysesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SearchAnalysesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchAnalysesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchAnalysesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchAnalysesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchAnalysesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchAnalysesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchAnalysesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchAnalysesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchAnalysesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SearchAnalysesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SearchAnalysesErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchAnalysesErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for SearchAnalysesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchAnalysesErrorKind::InternalFailureException(_inner) => Some(_inner),
            SearchAnalysesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            SearchAnalysesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            SearchAnalysesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SearchAnalysesErrorKind::ThrottlingException(_inner) => Some(_inner),
            SearchAnalysesErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            SearchAnalysesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchDashboardsError {
    /// Kind of error that occurred.
    pub kind: SearchDashboardsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchDashboardsErrorKind {
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchDashboardsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchDashboardsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            SearchDashboardsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            SearchDashboardsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            SearchDashboardsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SearchDashboardsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SearchDashboardsErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            SearchDashboardsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchDashboardsError {
    fn code(&self) -> Option<&str> {
        SearchDashboardsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchDashboardsError {
    /// Creates a new `SearchDashboardsError`.
    pub fn new(kind: SearchDashboardsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchDashboardsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchDashboardsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchDashboardsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchDashboardsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SearchDashboardsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDashboardsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchDashboardsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDashboardsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchDashboardsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDashboardsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchDashboardsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDashboardsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchDashboardsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDashboardsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchDashboardsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchDashboardsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for SearchDashboardsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchDashboardsErrorKind::InternalFailureException(_inner) => Some(_inner),
            SearchDashboardsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            SearchDashboardsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            SearchDashboardsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SearchDashboardsErrorKind::ThrottlingException(_inner) => Some(_inner),
            SearchDashboardsErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            SearchDashboardsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchFolders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchFoldersError {
    /// Kind of error that occurred.
    pub kind: SearchFoldersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchFolders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchFoldersErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchFoldersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchFoldersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SearchFoldersErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            SearchFoldersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            SearchFoldersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            SearchFoldersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SearchFoldersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SearchFoldersErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            SearchFoldersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchFoldersError {
    fn code(&self) -> Option<&str> {
        SearchFoldersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchFoldersError {
    /// Creates a new `SearchFoldersError`.
    pub fn new(kind: SearchFoldersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchFoldersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchFoldersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchFoldersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchFoldersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SearchFoldersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, SearchFoldersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `SearchFoldersErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchFoldersErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchFoldersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchFoldersErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchFoldersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchFoldersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchFoldersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchFoldersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchFoldersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SearchFoldersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SearchFoldersErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchFoldersErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for SearchFoldersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchFoldersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SearchFoldersErrorKind::InternalFailureException(_inner) => Some(_inner),
            SearchFoldersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            SearchFoldersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            SearchFoldersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SearchFoldersErrorKind::ThrottlingException(_inner) => Some(_inner),
            SearchFoldersErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            SearchFoldersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccountCustomizationError {
    /// Kind of error that occurred.
    pub kind: UpdateAccountCustomizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccountCustomization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccountCustomizationErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccountCustomizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccountCustomizationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAccountCustomizationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAccountCustomizationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAccountCustomizationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAccountCustomizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccountCustomizationError {
    fn code(&self) -> Option<&str> {
        UpdateAccountCustomizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccountCustomizationError {
    /// Creates a new `UpdateAccountCustomizationError`.
    pub fn new(kind: UpdateAccountCustomizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccountCustomizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccountCustomizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccountCustomizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccountCustomizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAccountCustomizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountCustomizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountCustomizationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountCustomizationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountCustomizationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountCustomizationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountCustomizationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountCustomizationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountCustomizationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountCustomizationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountCustomizationErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountCustomizationErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountCustomizationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountCustomizationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateAccountCustomizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccountCustomizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAccountCustomizationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAccountCustomizationErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAccountCustomizationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateAccountCustomizationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAccountCustomizationErrorKind::ResourceUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateAccountCustomizationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAccountCustomizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccountSettingsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccountSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccountSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccountSettingsError {
    /// Creates a new `UpdateAccountSettingsError`.
    pub fn new(kind: UpdateAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccountSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAnalysisError {
    /// Kind of error that occurred.
    pub kind: UpdateAnalysisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAnalysis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAnalysisErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAnalysisErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAnalysisErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAnalysisErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateAnalysisErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateAnalysisErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAnalysisErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAnalysisErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateAnalysisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAnalysisError {
    fn code(&self) -> Option<&str> {
        UpdateAnalysisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAnalysisError {
    /// Creates a new `UpdateAnalysisError`.
    pub fn new(kind: UpdateAnalysisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAnalysisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAnalysisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAnalysisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAnalysisErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAnalysisErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateAnalysisErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateAnalysisErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateAnalysisErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateAnalysisErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateAnalysisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAnalysisErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAnalysisErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAnalysisErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateAnalysisErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateAnalysisErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAnalysisErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAnalysisErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateAnalysisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAnalysisPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAnalysisPermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateAnalysisPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAnalysisPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAnalysisPermissionsErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAnalysisPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAnalysisPermissionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAnalysisPermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateAnalysisPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAnalysisPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAnalysisPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAnalysisPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAnalysisPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAnalysisPermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateAnalysisPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAnalysisPermissionsError {
    /// Creates a new `UpdateAnalysisPermissionsError`.
    pub fn new(kind: UpdateAnalysisPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAnalysisPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAnalysisPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAnalysisPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAnalysisPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAnalysisPermissionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisPermissionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnalysisPermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnalysisPermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateAnalysisPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAnalysisPermissionsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAnalysisPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateAnalysisPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateAnalysisPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAnalysisPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAnalysisPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            UpdateAnalysisPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDashboardError {
    /// Kind of error that occurred.
    pub kind: UpdateDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDashboardErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDashboardErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDashboardError {
    fn code(&self) -> Option<&str> {
        UpdateDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDashboardError {
    /// Creates a new `UpdateDashboardError`.
    pub fn new(kind: UpdateDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDashboardErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDashboardErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDashboardErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateDashboardErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDashboardErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateDashboardErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDashboardErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDashboardPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDashboardPermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateDashboardPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDashboardPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDashboardPermissionsErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDashboardPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDashboardPermissionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDashboardPermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDashboardPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDashboardPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDashboardPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDashboardPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDashboardPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDashboardPermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateDashboardPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDashboardPermissionsError {
    /// Creates a new `UpdateDashboardPermissionsError`.
    pub fn new(kind: UpdateDashboardPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDashboardPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDashboardPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDashboardPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDashboardPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDashboardPermissionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPermissionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateDashboardPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDashboardPermissionsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDashboardPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDashboardPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateDashboardPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDashboardPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDashboardPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            UpdateDashboardPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDashboardPublishedVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDashboardPublishedVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateDashboardPublishedVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDashboardPublishedVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDashboardPublishedVersionErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDashboardPublishedVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDashboardPublishedVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDashboardPublishedVersionErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDashboardPublishedVersionErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDashboardPublishedVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDashboardPublishedVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDashboardPublishedVersionErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDashboardPublishedVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDashboardPublishedVersionError {
    fn code(&self) -> Option<&str> {
        UpdateDashboardPublishedVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDashboardPublishedVersionError {
    /// Creates a new `UpdateDashboardPublishedVersionError`.
    pub fn new(
        kind: UpdateDashboardPublishedVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDashboardPublishedVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDashboardPublishedVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDashboardPublishedVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDashboardPublishedVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDashboardPublishedVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPublishedVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPublishedVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPublishedVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPublishedVersionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPublishedVersionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPublishedVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPublishedVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPublishedVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPublishedVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDashboardPublishedVersionErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDashboardPublishedVersionErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateDashboardPublishedVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDashboardPublishedVersionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDashboardPublishedVersionErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            UpdateDashboardPublishedVersionErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateDashboardPublishedVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateDashboardPublishedVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDashboardPublishedVersionErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            UpdateDashboardPublishedVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSetError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSetErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateDataSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSetError {
    fn code(&self) -> Option<&str> {
        UpdateDataSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSetError {
    /// Creates a new `UpdateDataSetError`.
    pub fn new(kind: UpdateDataSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateDataSetErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateDataSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateDataSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSetPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSetPermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSetPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSetPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSetPermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSetPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSetPermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDataSetPermissionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDataSetPermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDataSetPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDataSetPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataSetPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDataSetPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSetPermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateDataSetPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSetPermissionsError {
    /// Creates a new `UpdateDataSetPermissionsError`.
    pub fn new(kind: UpdateDataSetPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSetPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSetPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSetPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSetPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataSetPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetPermissionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetPermissionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSetPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSetPermissionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateDataSetPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSetPermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDataSetPermissionsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDataSetPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDataSetPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateDataSetPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataSetPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDataSetPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSourceError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSourceErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSourceError {
    fn code(&self) -> Option<&str> {
        UpdateDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSourceError {
    /// Creates a new `UpdateDataSourceError`.
    pub fn new(kind: UpdateDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSourcePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSourcePermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSourcePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSourcePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSourcePermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSourcePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSourcePermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDataSourcePermissionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDataSourcePermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDataSourcePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDataSourcePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDataSourcePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDataSourcePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSourcePermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateDataSourcePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSourcePermissionsError {
    /// Creates a new `UpdateDataSourcePermissionsError`.
    pub fn new(kind: UpdateDataSourcePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSourcePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSourcePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSourcePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSourcePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataSourcePermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourcePermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourcePermissionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourcePermissionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourcePermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourcePermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourcePermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourcePermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourcePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourcePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourcePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourcePermissionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateDataSourcePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSourcePermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDataSourcePermissionsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDataSourcePermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDataSourcePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateDataSourcePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataSourcePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDataSourcePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFolderError {
    /// Kind of error that occurred.
    pub kind: UpdateFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFolderErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFolderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFolderError {
    fn code(&self) -> Option<&str> {
        UpdateFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFolderError {
    /// Creates a new `UpdateFolderError`.
    pub fn new(kind: UpdateFolderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFolderErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateFolderErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateFolderErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateFolderErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateFolderErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFolderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateFolderErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFolderErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateFolderErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateFolderErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateFolderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFolderErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFolderErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateFolderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFolderPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFolderPermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateFolderPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFolderPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFolderPermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFolderPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFolderPermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateFolderPermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateFolderPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFolderPermissionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateFolderPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFolderPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFolderPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFolderPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFolderPermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateFolderPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFolderPermissionsError {
    /// Creates a new `UpdateFolderPermissionsError`.
    pub fn new(kind: UpdateFolderPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFolderPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFolderPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFolderPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFolderPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFolderPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderPermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderPermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderPermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderPermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderPermissionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderPermissionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFolderPermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFolderPermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateFolderPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFolderPermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateFolderPermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateFolderPermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateFolderPermissionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateFolderPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFolderPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFolderPermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            UpdateFolderPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGroupErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGroupError {
    fn code(&self) -> Option<&str> {
        UpdateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGroupError {
    /// Creates a new `UpdateGroupError`.
    pub fn new(kind: UpdateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateGroupErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateGroupErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            UpdateGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateGroupErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            UpdateGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIAMPolicyAssignmentError {
    /// Kind of error that occurred.
    pub kind: UpdateIAMPolicyAssignmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIAMPolicyAssignment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIAMPolicyAssignmentErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource is already in a state that indicates an operation is happening that must complete before a new update can be applied.</p>
    ConcurrentUpdatingException(crate::error::ConcurrentUpdatingException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIAMPolicyAssignmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateIAMPolicyAssignmentErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateIAMPolicyAssignmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIAMPolicyAssignmentError {
    fn code(&self) -> Option<&str> {
        UpdateIAMPolicyAssignmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIAMPolicyAssignmentError {
    /// Creates a new `UpdateIAMPolicyAssignmentError`.
    pub fn new(kind: UpdateIAMPolicyAssignmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIAMPolicyAssignmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIAMPolicyAssignmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIAMPolicyAssignmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIAMPolicyAssignmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIAMPolicyAssignmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException`.
    pub fn is_concurrent_updating_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIAMPolicyAssignmentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIAMPolicyAssignmentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIAMPolicyAssignmentErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIAMPolicyAssignmentErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIAMPolicyAssignmentErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIAMPolicyAssignmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIAMPolicyAssignmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIAMPolicyAssignmentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateIAMPolicyAssignmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIAMPolicyAssignmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(_inner) => Some(_inner),
            UpdateIAMPolicyAssignmentErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateIAMPolicyAssignmentErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateIAMPolicyAssignmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateIAMPolicyAssignmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIpRestriction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIpRestrictionError {
    /// Kind of error that occurred.
    pub kind: UpdateIpRestrictionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIpRestriction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIpRestrictionErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIpRestrictionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIpRestrictionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateIpRestrictionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateIpRestrictionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateIpRestrictionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateIpRestrictionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateIpRestrictionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateIpRestrictionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIpRestrictionError {
    fn code(&self) -> Option<&str> {
        UpdateIpRestrictionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIpRestrictionError {
    /// Creates a new `UpdateIpRestrictionError`.
    pub fn new(kind: UpdateIpRestrictionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIpRestrictionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIpRestrictionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIpRestrictionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIpRestrictionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIpRestrictionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIpRestrictionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIpRestrictionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIpRestrictionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIpRestrictionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIpRestrictionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIpRestrictionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIpRestrictionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIpRestrictionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIpRestrictionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIpRestrictionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIpRestrictionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateIpRestrictionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIpRestrictionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateIpRestrictionErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateIpRestrictionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateIpRestrictionErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateIpRestrictionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateIpRestrictionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateIpRestrictionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTemplateErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTemplateError {
    /// Creates a new `UpdateTemplateError`.
    pub fn new(kind: UpdateTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateTemplateErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateTemplateErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTemplateAliasError {
    /// Kind of error that occurred.
    pub kind: UpdateTemplateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTemplateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTemplateAliasErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTemplateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTemplateAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateTemplateAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateTemplateAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTemplateAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateTemplateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTemplateAliasError {
    fn code(&self) -> Option<&str> {
        UpdateTemplateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTemplateAliasError {
    /// Creates a new `UpdateTemplateAliasError`.
    pub fn new(kind: UpdateTemplateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTemplateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTemplateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTemplateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTemplateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTemplateAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateAliasErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateTemplateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTemplateAliasErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateTemplateAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateTemplateAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTemplateAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateTemplateAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateTemplateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTemplatePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTemplatePermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateTemplatePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTemplatePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTemplatePermissionsErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTemplatePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTemplatePermissionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateTemplatePermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateTemplatePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTemplatePermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTemplatePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateTemplatePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTemplatePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTemplatePermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateTemplatePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTemplatePermissionsError {
    /// Creates a new `UpdateTemplatePermissionsError`.
    pub fn new(kind: UpdateTemplatePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTemplatePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTemplatePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTemplatePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTemplatePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTemplatePermissionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplatePermissionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplatePermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplatePermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplatePermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplatePermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplatePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplatePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplatePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplatePermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplatePermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplatePermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateTemplatePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTemplatePermissionsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateTemplatePermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateTemplatePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateTemplatePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTemplatePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateTemplatePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            UpdateTemplatePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateThemeError {
    /// Kind of error that occurred.
    pub kind: UpdateThemeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTheme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateThemeErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateThemeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateThemeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateThemeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateThemeError {
    fn code(&self) -> Option<&str> {
        UpdateThemeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateThemeError {
    /// Creates a new `UpdateThemeError`.
    pub fn new(kind: UpdateThemeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateThemeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateThemeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateThemeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateThemeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateThemeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateThemeErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(&self.kind, UpdateThemeErrorKind::ResourceExistsException(_))
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateThemeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateThemeErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateThemeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateThemeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateThemeErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateThemeErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateThemeErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateThemeErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateThemeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateThemeErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateThemeErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateThemeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateThemeAliasError {
    /// Kind of error that occurred.
    pub kind: UpdateThemeAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateThemeAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateThemeAliasErrorKind {
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateThemeAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateThemeAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateThemeAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateThemeAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateThemeAliasErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateThemeAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateThemeAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => _inner.fmt(f),
            UpdateThemeAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateThemeAliasError {
    fn code(&self) -> Option<&str> {
        UpdateThemeAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateThemeAliasError {
    /// Creates a new `UpdateThemeAliasError`.
    pub fn new(kind: UpdateThemeAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateThemeAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateThemeAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateThemeAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateThemeAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateThemeAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateThemeAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateThemeAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeAliasErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeAliasErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemeAliasErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemeAliasErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateThemeAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateThemeAliasErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateThemeAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateThemeAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateThemeAliasErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateThemeAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateThemeAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateThemeAliasErrorKind::UnsupportedUserEditionException(_inner) => Some(_inner),
            UpdateThemeAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateThemePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateThemePermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateThemePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateThemePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateThemePermissionsErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateThemePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateThemePermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateThemePermissionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateThemePermissionsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateThemePermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateThemePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateThemePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateThemePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateThemePermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateThemePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateThemePermissionsError {
    /// Creates a new `UpdateThemePermissionsError`.
    pub fn new(kind: UpdateThemePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateThemePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateThemePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateThemePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateThemePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateThemePermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemePermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemePermissionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemePermissionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemePermissionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemePermissionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemePermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThemePermissionsErrorKind::UnsupportedUserEditionException`.
    pub fn is_unsupported_user_edition_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThemePermissionsErrorKind::UnsupportedUserEditionException(_)
        )
    }
}
impl std::error::Error for UpdateThemePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateThemePermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateThemePermissionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateThemePermissionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateThemePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateThemePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateThemePermissionsErrorKind::UnsupportedUserEditionException(_inner) => {
                Some(_inner)
            }
            UpdateThemePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserError {
    /// Kind of error that occurred.
    pub kind: UpdateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserErrorKind {
    /// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::PreconditionNotMetException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ResourceUnavailableException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserError {
    fn code(&self) -> Option<&str> {
        UpdateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserError {
    /// Creates a new `UpdateUserError`.
    pub fn new(kind: UpdateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::PreconditionNotMetException`.
    pub fn is_precondition_not_met_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::PreconditionNotMetException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ResourceUnavailableException`.
    pub fn is_resource_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::ResourceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateUserErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateUserErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateUserErrorKind::PreconditionNotMetException(_inner) => Some(_inner),
            UpdateUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserErrorKind::ResourceUnavailableException(_inner) => Some(_inner),
            UpdateUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Access is throttled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>This resource is currently unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource type for this request.</p>
    pub resource_type: std::option::Option<crate::model::ExceptionResourceType>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ResourceUnavailableException {
    /// <p>The resource type for this request.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ExceptionResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceUnavailableException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ResourceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceUnavailableException {}
/// See [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
pub mod resource_unavailable_exception {
    /// A builder for [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ExceptionResourceType>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The resource type for this request.</p>
        pub fn resource_type(mut self, input: crate::model::ExceptionResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type for this request.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ExceptionResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
        pub fn build(self) -> crate::error::ResourceUnavailableException {
            crate::error::ResourceUnavailableException {
                message: self.message,
                resource_type: self.resource_type,
                request_id: self.request_id,
            }
        }
    }
}
impl ResourceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ResourceUnavailableException`](crate::error::ResourceUnavailableException)
    pub fn builder() -> crate::error::resource_unavailable_exception::Builder {
        crate::error::resource_unavailable_exception::Builder::default()
    }
}

/// <p>One or more resources can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource type for this request.</p>
    pub resource_type: std::option::Option<crate::model::ExceptionResourceType>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The resource type for this request.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ExceptionResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ExceptionResourceType>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The resource type for this request.</p>
        pub fn resource_type(mut self, input: crate::model::ExceptionResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type for this request.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ExceptionResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_type: self.resource_type,
                request_id: self.request_id,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>One or more preconditions aren't met.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionNotMetException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl PreconditionNotMetException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for PreconditionNotMetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionNotMetException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl PreconditionNotMetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionNotMetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionNotMetException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionNotMetException {}
/// See [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
pub mod precondition_not_met_exception {
    /// A builder for [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
        pub fn build(self) -> crate::error::PreconditionNotMetException {
            crate::error::PreconditionNotMetException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl PreconditionNotMetException {
    /// Creates a new builder-style object to manufacture [`PreconditionNotMetException`](crate::error::PreconditionNotMetException)
    pub fn builder() -> crate::error::precondition_not_met_exception::Builder {
        crate::error::precondition_not_met_exception::Builder::default()
    }
}

/// <p>One or more parameters has a value that isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidParameterValueException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>An internal failure occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InternalFailureException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p>You don't have access to this item. The provided credentials couldn't be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl AccessDeniedException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedUserEditionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UnsupportedUserEditionException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedUserEditionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedUserEditionException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl UnsupportedUserEditionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedUserEditionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedUserEditionException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedUserEditionException {}
/// See [`UnsupportedUserEditionException`](crate::error::UnsupportedUserEditionException)
pub mod unsupported_user_edition_exception {
    /// A builder for [`UnsupportedUserEditionException`](crate::error::UnsupportedUserEditionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedUserEditionException`](crate::error::UnsupportedUserEditionException)
        pub fn build(self) -> crate::error::UnsupportedUserEditionException {
            crate::error::UnsupportedUserEditionException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl UnsupportedUserEditionException {
    /// Creates a new builder-style object to manufacture [`UnsupportedUserEditionException`](crate::error::UnsupportedUserEditionException)
    pub fn builder() -> crate::error::unsupported_user_edition_exception::Builder {
        crate::error::unsupported_user_edition_exception::Builder::default()
    }
}

/// <p>The resource specified already exists. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource type for this request.</p>
    pub resource_type: std::option::Option<crate::model::ExceptionResourceType>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ResourceExistsException {
    /// <p>The resource type for this request.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ExceptionResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceExistsException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ResourceExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceExistsException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceExistsException {}
/// See [`ResourceExistsException`](crate::error::ResourceExistsException)
pub mod resource_exists_exception {
    /// A builder for [`ResourceExistsException`](crate::error::ResourceExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ExceptionResourceType>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The resource type for this request.</p>
        pub fn resource_type(mut self, input: crate::model::ExceptionResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type for this request.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ExceptionResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceExistsException`](crate::error::ResourceExistsException)
        pub fn build(self) -> crate::error::ResourceExistsException {
            crate::error::ResourceExistsException {
                message: self.message,
                resource_type: self.resource_type,
                request_id: self.request_id,
            }
        }
    }
}
impl ResourceExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceExistsException`](crate::error::ResourceExistsException)
    pub fn builder() -> crate::error::resource_exists_exception::Builder {
        crate::error::resource_exists_exception::Builder::default()
    }
}

/// <p>Updating or deleting a resource can cause an inconsistent state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>A limit is exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Limit exceeded.</p>
    pub resource_type: std::option::Option<crate::model::ExceptionResourceType>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl LimitExceededException {
    /// <p>Limit exceeded.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ExceptionResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ExceptionResourceType>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Limit exceeded.</p>
        pub fn resource_type(mut self, input: crate::model::ExceptionResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Limit exceeded.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ExceptionResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
                resource_type: self.resource_type,
                request_id: self.request_id,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>A resource is already in a state that indicates an operation is happening that must complete before a new update can be applied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentUpdatingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub request_id: std::option::Option<std::string::String>,
}
impl ConcurrentUpdatingException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ConcurrentUpdatingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentUpdatingException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl ConcurrentUpdatingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentUpdatingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentUpdatingException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentUpdatingException {}
/// See [`ConcurrentUpdatingException`](crate::error::ConcurrentUpdatingException)
pub mod concurrent_updating_exception {
    /// A builder for [`ConcurrentUpdatingException`](crate::error::ConcurrentUpdatingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentUpdatingException`](crate::error::ConcurrentUpdatingException)
        pub fn build(self) -> crate::error::ConcurrentUpdatingException {
            crate::error::ConcurrentUpdatingException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl ConcurrentUpdatingException {
    /// Creates a new builder-style object to manufacture [`ConcurrentUpdatingException`](crate::error::ConcurrentUpdatingException)
    pub fn builder() -> crate::error::concurrent_updating_exception::Builder {
        crate::error::concurrent_updating_exception::Builder::default()
    }
}

/// <p>The <code>NextToken</code> value isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl InvalidNextTokenException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be 15-600 minutes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionLifetimeInMinutesInvalidException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl SessionLifetimeInMinutesInvalidException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for SessionLifetimeInMinutesInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionLifetimeInMinutesInvalidException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl SessionLifetimeInMinutesInvalidException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SessionLifetimeInMinutesInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SessionLifetimeInMinutesInvalidException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for SessionLifetimeInMinutesInvalidException {}
/// See [`SessionLifetimeInMinutesInvalidException`](crate::error::SessionLifetimeInMinutesInvalidException)
pub mod session_lifetime_in_minutes_invalid_exception {
    /// A builder for [`SessionLifetimeInMinutesInvalidException`](crate::error::SessionLifetimeInMinutesInvalidException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionLifetimeInMinutesInvalidException`](crate::error::SessionLifetimeInMinutesInvalidException)
        pub fn build(self) -> crate::error::SessionLifetimeInMinutesInvalidException {
            crate::error::SessionLifetimeInMinutesInvalidException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl SessionLifetimeInMinutesInvalidException {
    /// Creates a new builder-style object to manufacture [`SessionLifetimeInMinutesInvalidException`](crate::error::SessionLifetimeInMinutesInvalidException)
    pub fn builder() -> crate::error::session_lifetime_in_minutes_invalid_exception::Builder {
        crate::error::session_lifetime_in_minutes_invalid_exception::Builder::default()
    }
}

/// <p>The user with the provided name isn't found. This error can happen in any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuickSightUserNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl QuickSightUserNotFoundException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for QuickSightUserNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuickSightUserNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl QuickSightUserNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QuickSightUserNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QuickSightUserNotFoundException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for QuickSightUserNotFoundException {}
/// See [`QuickSightUserNotFoundException`](crate::error::QuickSightUserNotFoundException)
pub mod quick_sight_user_not_found_exception {
    /// A builder for [`QuickSightUserNotFoundException`](crate::error::QuickSightUserNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`QuickSightUserNotFoundException`](crate::error::QuickSightUserNotFoundException)
        pub fn build(self) -> crate::error::QuickSightUserNotFoundException {
            crate::error::QuickSightUserNotFoundException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl QuickSightUserNotFoundException {
    /// Creates a new builder-style object to manufacture [`QuickSightUserNotFoundException`](crate::error::QuickSightUserNotFoundException)
    pub fn builder() -> crate::error::quick_sight_user_not_found_exception::Builder {
        crate::error::quick_sight_user_not_found_exception::Builder::default()
    }
}

/// <p>This error indicates that you are calling an embedding operation in Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
/// <p>After capacity pricing is added, you can use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code> API operation with the <code>--identity-type ANONYMOUS</code> option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedPricingPlanException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UnsupportedPricingPlanException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedPricingPlanException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedPricingPlanException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl UnsupportedPricingPlanException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedPricingPlanException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedPricingPlanException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedPricingPlanException {}
/// See [`UnsupportedPricingPlanException`](crate::error::UnsupportedPricingPlanException)
pub mod unsupported_pricing_plan_exception {
    /// A builder for [`UnsupportedPricingPlanException`](crate::error::UnsupportedPricingPlanException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedPricingPlanException`](crate::error::UnsupportedPricingPlanException)
        pub fn build(self) -> crate::error::UnsupportedPricingPlanException {
            crate::error::UnsupportedPricingPlanException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl UnsupportedPricingPlanException {
    /// Creates a new builder-style object to manufacture [`UnsupportedPricingPlanException`](crate::error::UnsupportedPricingPlanException)
    pub fn builder() -> crate::error::unsupported_pricing_plan_exception::Builder {
        crate::error::unsupported_pricing_plan_exception::Builder::default()
    }
}

/// <p>The identity type specified isn't supported. Supported identity types include <code>IAM</code> and <code>QUICKSIGHT</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityTypeNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl IdentityTypeNotSupportedException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for IdentityTypeNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityTypeNotSupportedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl IdentityTypeNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdentityTypeNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdentityTypeNotSupportedException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdentityTypeNotSupportedException {}
/// See [`IdentityTypeNotSupportedException`](crate::error::IdentityTypeNotSupportedException)
pub mod identity_type_not_supported_exception {
    /// A builder for [`IdentityTypeNotSupportedException`](crate::error::IdentityTypeNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityTypeNotSupportedException`](crate::error::IdentityTypeNotSupportedException)
        pub fn build(self) -> crate::error::IdentityTypeNotSupportedException {
            crate::error::IdentityTypeNotSupportedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl IdentityTypeNotSupportedException {
    /// Creates a new builder-style object to manufacture [`IdentityTypeNotSupportedException`](crate::error::IdentityTypeNotSupportedException)
    pub fn builder() -> crate::error::identity_type_not_supported_exception::Builder {
        crate::error::identity_type_not_supported_exception::Builder::default()
    }
}

/// <p>The domain specified isn't on the allow list. All domains for embedded dashboards must be added to the approved list by an Amazon QuickSight admin.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainNotWhitelistedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DomainNotWhitelistedException {
    /// <p>The Amazon Web Services request ID for this request.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DomainNotWhitelistedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainNotWhitelistedException");
        formatter.field("message", &self.message);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
impl DomainNotWhitelistedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DomainNotWhitelistedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DomainNotWhitelistedException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for DomainNotWhitelistedException {}
/// See [`DomainNotWhitelistedException`](crate::error::DomainNotWhitelistedException)
pub mod domain_not_whitelisted_exception {
    /// A builder for [`DomainNotWhitelistedException`](crate::error::DomainNotWhitelistedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainNotWhitelistedException`](crate::error::DomainNotWhitelistedException)
        pub fn build(self) -> crate::error::DomainNotWhitelistedException {
            crate::error::DomainNotWhitelistedException {
                message: self.message,
                request_id: self.request_id,
            }
        }
    }
}
impl DomainNotWhitelistedException {
    /// Creates a new builder-style object to manufacture [`DomainNotWhitelistedException`](crate::error::DomainNotWhitelistedException)
    pub fn builder() -> crate::error::domain_not_whitelisted_exception::Builder {
        crate::error::domain_not_whitelisted_exception::Builder::default()
    }
}
