// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon QuickSight
///
/// Client for invoking operations on Amazon QuickSight. Each operation on Amazon QuickSight is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_quicksight::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_quicksight::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_quicksight::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CancelIngestion`](crate::client::fluent_builders::CancelIngestion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CancelIngestion::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CancelIngestion::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::CancelIngestion::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::CancelIngestion::set_data_set_id): <p>The ID of the dataset used in the ingestion.</p>
    ///   - [`ingestion_id(impl Into<String>)`](crate::client::fluent_builders::CancelIngestion::ingestion_id) / [`set_ingestion_id(Option<String>)`](crate::client::fluent_builders::CancelIngestion::set_ingestion_id): <p>An ID for the ingestion.</p>
    /// - On success, responds with [`CancelIngestionOutput`](crate::output::CancelIngestionOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CancelIngestionOutput::arn): <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
    ///   - [`ingestion_id(Option<String>)`](crate::output::CancelIngestionOutput::ingestion_id): <p>An ID for the ingestion.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CancelIngestionOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CancelIngestionOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CancelIngestionError>`](crate::error::CancelIngestionError)
    pub fn cancel_ingestion(&self) -> fluent_builders::CancelIngestion<C, M, R> {
        fluent_builders::CancelIngestion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccountCustomization`](crate::client::fluent_builders::CreateAccountCustomization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccountCustomization::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateAccountCustomization::set_aws_account_id): <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::CreateAccountCustomization::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::CreateAccountCustomization::set_namespace): <p>The Amazon QuickSight namespace that you want to add customizations to.</p>
    ///   - [`account_customization(AccountCustomization)`](crate::client::fluent_builders::CreateAccountCustomization::account_customization) / [`set_account_customization(Option<AccountCustomization>)`](crate::client::fluent_builders::CreateAccountCustomization::set_account_customization): <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. You can add these to an Amazon Web Services account and a QuickSight namespace. </p>  <p>For example, you can add a default theme by setting <code>AccountCustomization</code> to the midnight theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by specifying <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAccountCustomization::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAccountCustomization::set_tags): <p>A list of the tags that you want to attach to this resource.</p>
    /// - On success, responds with [`CreateAccountCustomizationOutput`](crate::output::CreateAccountCustomizationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateAccountCustomizationOutput::arn): <p>The Amazon Resource Name (ARN) for the customization that you created for this Amazon Web Services account.</p>
    ///   - [`aws_account_id(Option<String>)`](crate::output::CreateAccountCustomizationOutput::aws_account_id): <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
    ///   - [`namespace(Option<String>)`](crate::output::CreateAccountCustomizationOutput::namespace): <p>The namespace associated with the customization you're creating. </p>
    ///   - [`account_customization(Option<AccountCustomization>)`](crate::output::CreateAccountCustomizationOutput::account_customization): <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. </p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateAccountCustomizationOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateAccountCustomizationOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateAccountCustomizationError>`](crate::error::CreateAccountCustomizationError)
    pub fn create_account_customization(
        &self,
    ) -> fluent_builders::CreateAccountCustomization<C, M, R> {
        fluent_builders::CreateAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAnalysis`](crate::client::fluent_builders::CreateAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateAnalysis::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateAnalysis::set_aws_account_id): <p>The ID of the Amazon Web Services account where you are creating an analysis.</p>
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::CreateAnalysis::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::CreateAnalysis::set_analysis_id): <p>The ID for the analysis that you're creating. This ID displays in the URL of the analysis.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAnalysis::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAnalysis::set_name): <p>A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console. </p>
    ///   - [`parameters(Parameters)`](crate::client::fluent_builders::CreateAnalysis::parameters) / [`set_parameters(Option<Parameters>)`](crate::client::fluent_builders::CreateAnalysis::set_parameters): <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
    ///   - [`permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::CreateAnalysis::permissions) / [`set_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::CreateAnalysis::set_permissions): <p>A structure that describes the principals and the resource-level permissions on an analysis. You can use the <code>Permissions</code> structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). </p>  <p>To specify no permissions, omit <code>Permissions</code>.</p>
    ///   - [`source_entity(AnalysisSourceEntity)`](crate::client::fluent_builders::CreateAnalysis::source_entity) / [`set_source_entity(Option<AnalysisSourceEntity>)`](crate::client::fluent_builders::CreateAnalysis::set_source_entity): <p>A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.</p>
    ///   - [`theme_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAnalysis::theme_arn) / [`set_theme_arn(Option<String>)`](crate::client::fluent_builders::CreateAnalysis::set_theme_arn): <p>The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAnalysis::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAnalysis::set_tags): <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.</p>
    /// - On success, responds with [`CreateAnalysisOutput`](crate::output::CreateAnalysisOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateAnalysisOutput::arn): <p>The ARN for the analysis.</p>
    ///   - [`analysis_id(Option<String>)`](crate::output::CreateAnalysisOutput::analysis_id): <p>The ID of the analysis.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::CreateAnalysisOutput::creation_status): <p>The status of the creation of the analysis. </p>
    ///   - [`status(i32)`](crate::output::CreateAnalysisOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateAnalysisOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<CreateAnalysisError>`](crate::error::CreateAnalysisError)
    pub fn create_analysis(&self) -> fluent_builders::CreateAnalysis<C, M, R> {
        fluent_builders::CreateAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDashboard`](crate::client::fluent_builders::CreateDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_aws_account_id): <p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_dashboard_id): <p>The ID for the dashboard, also added to the IAM policy.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_name): <p>The display name of the dashboard.</p>
    ///   - [`parameters(Parameters)`](crate::client::fluent_builders::CreateDashboard::parameters) / [`set_parameters(Option<Parameters>)`](crate::client::fluent_builders::CreateDashboard::set_parameters): <p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>
    ///   - [`permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::CreateDashboard::permissions) / [`set_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::CreateDashboard::set_permissions): <p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN. </p>  <p>To specify no permissions, omit the permissions list.</p>
    ///   - [`source_entity(DashboardSourceEntity)`](crate::client::fluent_builders::CreateDashboard::source_entity) / [`set_source_entity(Option<DashboardSourceEntity>)`](crate::client::fluent_builders::CreateDashboard::set_source_entity): <p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>  <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDashboard::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDashboard::set_tags): <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_version_description): <p>A description for the first version of the dashboard being created.</p>
    ///   - [`dashboard_publish_options(DashboardPublishOptions)`](crate::client::fluent_builders::CreateDashboard::dashboard_publish_options) / [`set_dashboard_publish_options(Option<DashboardPublishOptions>)`](crate::client::fluent_builders::CreateDashboard::set_dashboard_publish_options): <p>Options for publishing the dashboard when you create it:</p>  <ul>   <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>   <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>   <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>  </ul>
    ///   - [`theme_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDashboard::theme_arn) / [`set_theme_arn(Option<String>)`](crate::client::fluent_builders::CreateDashboard::set_theme_arn): <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
    /// - On success, responds with [`CreateDashboardOutput`](crate::output::CreateDashboardOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateDashboardOutput::arn): <p>The ARN of the dashboard.</p>
    ///   - [`version_arn(Option<String>)`](crate::output::CreateDashboardOutput::version_arn): <p>The ARN of the dashboard, including the version number of the first version that is created.</p>
    ///   - [`dashboard_id(Option<String>)`](crate::output::CreateDashboardOutput::dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::CreateDashboardOutput::creation_status): <p>The status of the dashboard creation request.</p>
    ///   - [`status(i32)`](crate::output::CreateDashboardOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateDashboardOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<CreateDashboardError>`](crate::error::CreateDashboardError)
    pub fn create_dashboard(&self) -> fluent_builders::CreateDashboard<C, M, R> {
        fluent_builders::CreateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataSet`](crate::client::fluent_builders::CreateDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSet::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateDataSet::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSet::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::CreateDataSet::set_data_set_id): <p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDataSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDataSet::set_name): <p>The display name for the dataset.</p>
    ///   - [`physical_table_map(HashMap<String, PhysicalTable>)`](crate::client::fluent_builders::CreateDataSet::physical_table_map) / [`set_physical_table_map(Option<HashMap<String, PhysicalTable>>)`](crate::client::fluent_builders::CreateDataSet::set_physical_table_map): <p>Declares the physical tables that are available in the underlying data sources.</p>
    ///   - [`logical_table_map(HashMap<String, LogicalTable>)`](crate::client::fluent_builders::CreateDataSet::logical_table_map) / [`set_logical_table_map(Option<HashMap<String, LogicalTable>>)`](crate::client::fluent_builders::CreateDataSet::set_logical_table_map): <p>Configures the combination and transformation of the data from the physical tables.</p>
    ///   - [`import_mode(DataSetImportMode)`](crate::client::fluent_builders::CreateDataSet::import_mode) / [`set_import_mode(Option<DataSetImportMode>)`](crate::client::fluent_builders::CreateDataSet::set_import_mode): <p>Indicates whether you want to import the data into SPICE.</p>
    ///   - [`column_groups(Vec<ColumnGroup>)`](crate::client::fluent_builders::CreateDataSet::column_groups) / [`set_column_groups(Option<Vec<ColumnGroup>>)`](crate::client::fluent_builders::CreateDataSet::set_column_groups): <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
    ///   - [`field_folders(HashMap<String, FieldFolder>)`](crate::client::fluent_builders::CreateDataSet::field_folders) / [`set_field_folders(Option<HashMap<String, FieldFolder>>)`](crate::client::fluent_builders::CreateDataSet::set_field_folders): <p>The folder that contains fields and nested subfolders for your dataset.</p>
    ///   - [`permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::CreateDataSet::permissions) / [`set_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::CreateDataSet::set_permissions): <p>A list of resource permissions on the dataset.</p>
    ///   - [`row_level_permission_data_set(RowLevelPermissionDataSet)`](crate::client::fluent_builders::CreateDataSet::row_level_permission_data_set) / [`set_row_level_permission_data_set(Option<RowLevelPermissionDataSet>)`](crate::client::fluent_builders::CreateDataSet::set_row_level_permission_data_set): <p>The row-level security configuration for the data that you want to create.</p>
    ///   - [`row_level_permission_tag_configuration(RowLevelPermissionTagConfiguration)`](crate::client::fluent_builders::CreateDataSet::row_level_permission_tag_configuration) / [`set_row_level_permission_tag_configuration(Option<RowLevelPermissionTagConfiguration>)`](crate::client::fluent_builders::CreateDataSet::set_row_level_permission_tag_configuration): <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
    ///   - [`column_level_permission_rules(Vec<ColumnLevelPermissionRule>)`](crate::client::fluent_builders::CreateDataSet::column_level_permission_rules) / [`set_column_level_permission_rules(Option<Vec<ColumnLevelPermissionRule>>)`](crate::client::fluent_builders::CreateDataSet::set_column_level_permission_rules): <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDataSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDataSet::set_tags): <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
    ///   - [`data_set_usage_configuration(DataSetUsageConfiguration)`](crate::client::fluent_builders::CreateDataSet::data_set_usage_configuration) / [`set_data_set_usage_configuration(Option<DataSetUsageConfiguration>)`](crate::client::fluent_builders::CreateDataSet::set_data_set_usage_configuration): <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
    /// - On success, responds with [`CreateDataSetOutput`](crate::output::CreateDataSetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateDataSetOutput::arn): <p>The Amazon Resource Name (ARN) of the dataset.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::CreateDataSetOutput::data_set_id): <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`ingestion_arn(Option<String>)`](crate::output::CreateDataSetOutput::ingestion_arn): <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    ///   - [`ingestion_id(Option<String>)`](crate::output::CreateDataSetOutput::ingestion_id): <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateDataSetOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateDataSetOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateDataSetError>`](crate::error::CreateDataSetError)
    pub fn create_data_set(&self) -> fluent_builders::CreateDataSet<C, M, R> {
        fluent_builders::CreateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataSource`](crate::client::fluent_builders::CreateDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSource::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateDataSource::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSource::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::CreateDataSource::set_data_source_id): <p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDataSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDataSource::set_name): <p>A display name for the data source.</p>
    ///   - [`r#type(DataSourceType)`](crate::client::fluent_builders::CreateDataSource::r#type) / [`set_type(Option<DataSourceType>)`](crate::client::fluent_builders::CreateDataSource::set_type): <p>The type of the data source. To return a list of all data sources, use <code>ListDataSources</code>.</p>  <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>
    ///   - [`data_source_parameters(DataSourceParameters)`](crate::client::fluent_builders::CreateDataSource::data_source_parameters) / [`set_data_source_parameters(Option<DataSourceParameters>)`](crate::client::fluent_builders::CreateDataSource::set_data_source_parameters): <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
    ///   - [`credentials(DataSourceCredentials)`](crate::client::fluent_builders::CreateDataSource::credentials) / [`set_credentials(Option<DataSourceCredentials>)`](crate::client::fluent_builders::CreateDataSource::set_credentials): <p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
    ///   - [`permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::CreateDataSource::permissions) / [`set_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::CreateDataSource::set_permissions): <p>A list of resource permissions on the data source.</p>
    ///   - [`vpc_connection_properties(VpcConnectionProperties)`](crate::client::fluent_builders::CreateDataSource::vpc_connection_properties) / [`set_vpc_connection_properties(Option<VpcConnectionProperties>)`](crate::client::fluent_builders::CreateDataSource::set_vpc_connection_properties): <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
    ///   - [`ssl_properties(SslProperties)`](crate::client::fluent_builders::CreateDataSource::ssl_properties) / [`set_ssl_properties(Option<SslProperties>)`](crate::client::fluent_builders::CreateDataSource::set_ssl_properties): <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDataSource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDataSource::set_tags): <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>
    /// - On success, responds with [`CreateDataSourceOutput`](crate::output::CreateDataSourceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateDataSourceOutput::arn): <p>The Amazon Resource Name (ARN) of the data source.</p>
    ///   - [`data_source_id(Option<String>)`](crate::output::CreateDataSourceOutput::data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::CreateDataSourceOutput::creation_status): <p>The status of creating the data source.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateDataSourceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateDataSourceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateDataSourceError>`](crate::error::CreateDataSourceError)
    pub fn create_data_source(&self) -> fluent_builders::CreateDataSource<C, M, R> {
        fluent_builders::CreateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFolder`](crate::client::fluent_builders::CreateFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateFolder::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateFolder::set_aws_account_id): <p>The ID for the Amazon Web Services account where you want to create the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::CreateFolder::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::CreateFolder::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFolder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFolder::set_name): <p>The name of the folder.</p>
    ///   - [`folder_type(FolderType)`](crate::client::fluent_builders::CreateFolder::folder_type) / [`set_folder_type(Option<FolderType>)`](crate::client::fluent_builders::CreateFolder::set_folder_type): <p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>
    ///   - [`parent_folder_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFolder::parent_folder_arn) / [`set_parent_folder_arn(Option<String>)`](crate::client::fluent_builders::CreateFolder::set_parent_folder_arn): <p>The Amazon Resource Name (ARN) for the parent folder.</p>  <p> <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>
    ///   - [`permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::CreateFolder::permissions) / [`set_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::CreateFolder::set_permissions): <p>A structure that describes the principals and the resource-level permissions of a folder.</p>  <p>To specify no permissions, omit <code>Permissions</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFolder::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFolder::set_tags): <p>Tags for the folder.</p>
    /// - On success, responds with [`CreateFolderOutput`](crate::output::CreateFolderOutput) with field(s):
    ///   - [`status(i32)`](crate::output::CreateFolderOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateFolderOutput::arn): <p>The Amazon Resource Name (ARN) for the newly created folder.</p>
    ///   - [`folder_id(Option<String>)`](crate::output::CreateFolderOutput::folder_id): <p>The folder ID for the newly created folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateFolderOutput::request_id): <p>The request ID for the newly created folder.</p>
    /// - On failure, responds with [`SdkError<CreateFolderError>`](crate::error::CreateFolderError)
    pub fn create_folder(&self) -> fluent_builders::CreateFolder<C, M, R> {
        fluent_builders::CreateFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFolderMembership`](crate::client::fluent_builders::CreateFolderMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateFolderMembership::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateFolderMembership::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::CreateFolderMembership::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::CreateFolderMembership::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::CreateFolderMembership::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::CreateFolderMembership::set_member_id): <p>The ID of the asset (the dashboard, analysis, or dataset).</p>
    ///   - [`member_type(MemberType)`](crate::client::fluent_builders::CreateFolderMembership::member_type) / [`set_member_type(Option<MemberType>)`](crate::client::fluent_builders::CreateFolderMembership::set_member_type): <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>
    /// - On success, responds with [`CreateFolderMembershipOutput`](crate::output::CreateFolderMembershipOutput) with field(s):
    ///   - [`status(i32)`](crate::output::CreateFolderMembershipOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`folder_member(Option<FolderMember>)`](crate::output::CreateFolderMembershipOutput::folder_member): <p>Information about the member in the folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateFolderMembershipOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<CreateFolderMembershipError>`](crate::error::CreateFolderMembershipError)
    pub fn create_folder_membership(&self) -> fluent_builders::CreateFolderMembership<C, M, R> {
        fluent_builders::CreateFolderMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGroup`](crate::client::fluent_builders::CreateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_group_name): <p>A name for the group that you want to create.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_description): <p>A description for the group that you want to create.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`CreateGroupOutput`](crate::output::CreateGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::CreateGroupOutput::group): <p>The name of the group.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateGroupOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateGroupOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateGroupError>`](crate::error::CreateGroupError)
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGroupMembership`](crate::client::fluent_builders::CreateGroupMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_name(impl Into<String>)`](crate::client::fluent_builders::CreateGroupMembership::member_name) / [`set_member_name(Option<String>)`](crate::client::fluent_builders::CreateGroupMembership::set_member_name): <p>The name of the user that you want to add to the group membership.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreateGroupMembership::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreateGroupMembership::set_group_name): <p>The name of the group that you want to add the user to.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateGroupMembership::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateGroupMembership::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::CreateGroupMembership::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::CreateGroupMembership::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`CreateGroupMembershipOutput`](crate::output::CreateGroupMembershipOutput) with field(s):
    ///   - [`group_member(Option<GroupMember>)`](crate::output::CreateGroupMembershipOutput::group_member): <p>The group member.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateGroupMembershipOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateGroupMembershipOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateGroupMembershipError>`](crate::error::CreateGroupMembershipError)
    pub fn create_group_membership(&self) -> fluent_builders::CreateGroupMembership<C, M, R> {
        fluent_builders::CreateGroupMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIAMPolicyAssignment`](crate::client::fluent_builders::CreateIAMPolicyAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::set_aws_account_id): <p>The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.</p>
    ///   - [`assignment_name(impl Into<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::assignment_name) / [`set_assignment_name(Option<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::set_assignment_name): <p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>
    ///   - [`assignment_status(AssignmentStatus)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::assignment_status) / [`set_assignment_status(Option<AssignmentStatus>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::set_assignment_status): <p>The status of the assignment. Possible values are as follows:</p>  <ul>   <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>   <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>   <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>  </ul>
    ///   - [`policy_arn(impl Into<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::policy_arn) / [`set_policy_arn(Option<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::set_policy_arn): <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
    ///   - [`identities(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::identities) / [`set_identities(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::set_identities): <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::CreateIAMPolicyAssignment::set_namespace): <p>The namespace that contains the assignment.</p>
    /// - On success, responds with [`CreateIamPolicyAssignmentOutput`](crate::output::CreateIamPolicyAssignmentOutput) with field(s):
    ///   - [`assignment_name(Option<String>)`](crate::output::CreateIamPolicyAssignmentOutput::assignment_name): <p>The name of the assignment. This name must be unique within the Amazon Web Services account.</p>
    ///   - [`assignment_id(Option<String>)`](crate::output::CreateIamPolicyAssignmentOutput::assignment_id): <p>The ID for the assignment.</p>
    ///   - [`assignment_status(Option<AssignmentStatus>)`](crate::output::CreateIamPolicyAssignmentOutput::assignment_status): <p>The status of the assignment. Possible values are as follows:</p>  <ul>   <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>   <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>   <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>  </ul>
    ///   - [`policy_arn(Option<String>)`](crate::output::CreateIamPolicyAssignmentOutput::policy_arn): <p>The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this assignment.</p>
    ///   - [`identities(Option<HashMap<String, Vec<String>>>)`](crate::output::CreateIamPolicyAssignmentOutput::identities): <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateIamPolicyAssignmentOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateIamPolicyAssignmentOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateIAMPolicyAssignmentError>`](crate::error::CreateIAMPolicyAssignmentError)
    pub fn create_iam_policy_assignment(
        &self,
    ) -> fluent_builders::CreateIAMPolicyAssignment<C, M, R> {
        fluent_builders::CreateIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIngestion`](crate::client::fluent_builders::CreateIngestion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::CreateIngestion::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::CreateIngestion::set_data_set_id): <p>The ID of the dataset used in the ingestion.</p>
    ///   - [`ingestion_id(impl Into<String>)`](crate::client::fluent_builders::CreateIngestion::ingestion_id) / [`set_ingestion_id(Option<String>)`](crate::client::fluent_builders::CreateIngestion::set_ingestion_id): <p>An ID for the ingestion.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateIngestion::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateIngestion::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`ingestion_type(IngestionType)`](crate::client::fluent_builders::CreateIngestion::ingestion_type) / [`set_ingestion_type(Option<IngestionType>)`](crate::client::fluent_builders::CreateIngestion::set_ingestion_type): <p>The type of ingestion that you want to create.</p>
    /// - On success, responds with [`CreateIngestionOutput`](crate::output::CreateIngestionOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateIngestionOutput::arn): <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
    ///   - [`ingestion_id(Option<String>)`](crate::output::CreateIngestionOutput::ingestion_id): <p>An ID for the ingestion.</p>
    ///   - [`ingestion_status(Option<IngestionStatus>)`](crate::output::CreateIngestionOutput::ingestion_status): <p>The ingestion status.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateIngestionOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateIngestionOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateIngestionError>`](crate::error::CreateIngestionError)
    pub fn create_ingestion(&self) -> fluent_builders::CreateIngestion<C, M, R> {
        fluent_builders::CreateIngestion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNamespace`](crate::client::fluent_builders::CreateNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateNamespace::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateNamespace::set_aws_account_id): <p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::CreateNamespace::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::CreateNamespace::set_namespace): <p>The name that you want to use to describe the new namespace.</p>
    ///   - [`identity_store(IdentityStore)`](crate::client::fluent_builders::CreateNamespace::identity_store) / [`set_identity_store(Option<IdentityStore>)`](crate::client::fluent_builders::CreateNamespace::set_identity_store): <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateNamespace::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateNamespace::set_tags): <p>The tags that you want to associate with the namespace that you're creating.</p>
    /// - On success, responds with [`CreateNamespaceOutput`](crate::output::CreateNamespaceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateNamespaceOutput::arn): <p>The ARN of the Amazon QuickSight namespace you created. </p>
    ///   - [`name(Option<String>)`](crate::output::CreateNamespaceOutput::name): <p>The name of the new namespace that you created.</p>
    ///   - [`capacity_region(Option<String>)`](crate::output::CreateNamespaceOutput::capacity_region): <p>The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>
    ///   - [`creation_status(Option<NamespaceStatus>)`](crate::output::CreateNamespaceOutput::creation_status): <p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up tasks.</p>
    ///   - [`identity_store(Option<IdentityStore>)`](crate::output::CreateNamespaceOutput::identity_store): <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateNamespaceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::CreateNamespaceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateNamespaceError>`](crate::error::CreateNamespaceError)
    pub fn create_namespace(&self) -> fluent_builders::CreateNamespace<C, M, R> {
        fluent_builders::CreateNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTemplate`](crate::client::fluent_builders::CreateTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateTemplate::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateTemplate::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::CreateTemplate::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::CreateTemplate::set_template_id): <p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateTemplate::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateTemplate::set_name): <p>A display name for the template.</p>
    ///   - [`permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::CreateTemplate::permissions) / [`set_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::CreateTemplate::set_permissions): <p>A list of resource permissions to be set on the template. </p>
    ///   - [`source_entity(TemplateSourceEntity)`](crate::client::fluent_builders::CreateTemplate::source_entity) / [`set_source_entity(Option<TemplateSourceEntity>)`](crate::client::fluent_builders::CreateTemplate::set_source_entity): <p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>  <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTemplate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTemplate::set_tags): <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::CreateTemplate::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::CreateTemplate::set_version_description): <p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
    /// - On success, responds with [`CreateTemplateOutput`](crate::output::CreateTemplateOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateTemplateOutput::arn): <p>The ARN for the template.</p>
    ///   - [`version_arn(Option<String>)`](crate::output::CreateTemplateOutput::version_arn): <p>The ARN for the template, including the version information of the first version.</p>
    ///   - [`template_id(Option<String>)`](crate::output::CreateTemplateOutput::template_id): <p>The ID of the template.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::CreateTemplateOutput::creation_status): <p>The template creation status.</p>
    ///   - [`status(i32)`](crate::output::CreateTemplateOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateTemplateOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<CreateTemplateError>`](crate::error::CreateTemplateError)
    pub fn create_template(&self) -> fluent_builders::CreateTemplate<C, M, R> {
        fluent_builders::CreateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTemplateAlias`](crate::client::fluent_builders::CreateTemplateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateTemplateAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateTemplateAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::CreateTemplateAlias::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::CreateTemplateAlias::set_template_id): <p>An ID for the template.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::CreateTemplateAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::CreateTemplateAlias::set_alias_name): <p>The name that you want to give to the template alias that you're creating. Don't start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
    ///   - [`template_version_number(i64)`](crate::client::fluent_builders::CreateTemplateAlias::template_version_number) / [`set_template_version_number(Option<i64>)`](crate::client::fluent_builders::CreateTemplateAlias::set_template_version_number): <p>The version number of the template.</p>
    /// - On success, responds with [`CreateTemplateAliasOutput`](crate::output::CreateTemplateAliasOutput) with field(s):
    ///   - [`template_alias(Option<TemplateAlias>)`](crate::output::CreateTemplateAliasOutput::template_alias): <p>Information about the template alias.</p>
    ///   - [`status(i32)`](crate::output::CreateTemplateAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateTemplateAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<CreateTemplateAliasError>`](crate::error::CreateTemplateAliasError)
    pub fn create_template_alias(&self) -> fluent_builders::CreateTemplateAlias<C, M, R> {
        fluent_builders::CreateTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTheme`](crate::client::fluent_builders::CreateTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_aws_account_id): <p>The ID of the Amazon Web Services account where you want to store the new theme. </p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_theme_id): <p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_name): <p>A display name for the theme.</p>
    ///   - [`base_theme_id(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::base_theme_id) / [`set_base_theme_id(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_base_theme_id): <p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within an analysis. </p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::CreateTheme::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::CreateTheme::set_version_description): <p>A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>
    ///   - [`configuration(ThemeConfiguration)`](crate::client::fluent_builders::CreateTheme::configuration) / [`set_configuration(Option<ThemeConfiguration>)`](crate::client::fluent_builders::CreateTheme::set_configuration): <p>The theme configuration, which contains the theme display properties.</p>
    ///   - [`permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::CreateTheme::permissions) / [`set_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::CreateTheme::set_permissions): <p>A valid grouping of resource permissions to apply to the new theme. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTheme::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTheme::set_tags): <p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>
    /// - On success, responds with [`CreateThemeOutput`](crate::output::CreateThemeOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateThemeOutput::arn): <p>The Amazon Resource Name (ARN) for the theme.</p>
    ///   - [`version_arn(Option<String>)`](crate::output::CreateThemeOutput::version_arn): <p>The Amazon Resource Name (ARN) for the new theme.</p>
    ///   - [`theme_id(Option<String>)`](crate::output::CreateThemeOutput::theme_id): <p>The ID of the theme.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::CreateThemeOutput::creation_status): <p>The theme creation status.</p>
    ///   - [`status(i32)`](crate::output::CreateThemeOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateThemeOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<CreateThemeError>`](crate::error::CreateThemeError)
    pub fn create_theme(&self) -> fluent_builders::CreateTheme<C, M, R> {
        fluent_builders::CreateTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateThemeAlias`](crate::client::fluent_builders::CreateThemeAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateThemeAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateThemeAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::CreateThemeAlias::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::CreateThemeAlias::set_theme_id): <p>An ID for the theme alias.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::CreateThemeAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::CreateThemeAlias::set_alias_name): <p>The name that you want to give to the theme alias that you are creating. The alias name can't begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
    ///   - [`theme_version_number(i64)`](crate::client::fluent_builders::CreateThemeAlias::theme_version_number) / [`set_theme_version_number(Option<i64>)`](crate::client::fluent_builders::CreateThemeAlias::set_theme_version_number): <p>The version number of the theme.</p>
    /// - On success, responds with [`CreateThemeAliasOutput`](crate::output::CreateThemeAliasOutput) with field(s):
    ///   - [`theme_alias(Option<ThemeAlias>)`](crate::output::CreateThemeAliasOutput::theme_alias): <p>Information about the theme alias.</p>
    ///   - [`status(i32)`](crate::output::CreateThemeAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::CreateThemeAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<CreateThemeAliasError>`](crate::error::CreateThemeAliasError)
    pub fn create_theme_alias(&self) -> fluent_builders::CreateThemeAlias<C, M, R> {
        fluent_builders::CreateThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccountCustomization`](crate::client::fluent_builders::DeleteAccountCustomization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccountCustomization::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteAccountCustomization::set_aws_account_id): <p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in this Amazon Web Services Region.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeleteAccountCustomization::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeleteAccountCustomization::set_namespace): <p>The Amazon QuickSight namespace that you're deleting the customizations from.</p>
    /// - On success, responds with [`DeleteAccountCustomizationOutput`](crate::output::DeleteAccountCustomizationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteAccountCustomizationOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteAccountCustomizationOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteAccountCustomizationError>`](crate::error::DeleteAccountCustomizationError)
    pub fn delete_account_customization(
        &self,
    ) -> fluent_builders::DeleteAccountCustomization<C, M, R> {
        fluent_builders::DeleteAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAnalysis`](crate::client::fluent_builders::DeleteAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAnalysis::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteAnalysis::set_aws_account_id): <p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAnalysis::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::DeleteAnalysis::set_analysis_id): <p>The ID of the analysis that you're deleting.</p>
    ///   - [`recovery_window_in_days(i64)`](crate::client::fluent_builders::DeleteAnalysis::recovery_window_in_days) / [`set_recovery_window_in_days(Option<i64>)`](crate::client::fluent_builders::DeleteAnalysis::set_recovery_window_in_days): <p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can't use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is 30.</p>
    ///   - [`force_delete_without_recovery(bool)`](crate::client::fluent_builders::DeleteAnalysis::force_delete_without_recovery) / [`set_force_delete_without_recovery(bool)`](crate::client::fluent_builders::DeleteAnalysis::set_force_delete_without_recovery): <p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after it's deleted. </p>
    /// - On success, responds with [`DeleteAnalysisOutput`](crate::output::DeleteAnalysisOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DeleteAnalysisOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteAnalysisOutput::arn): <p>The Amazon Resource Name (ARN) of the deleted analysis.</p>
    ///   - [`analysis_id(Option<String>)`](crate::output::DeleteAnalysisOutput::analysis_id): <p>The ID of the deleted analysis.</p>
    ///   - [`deletion_time(Option<DateTime>)`](crate::output::DeleteAnalysisOutput::deletion_time): <p>The date and time that the analysis is scheduled to be deleted.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteAnalysisOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DeleteAnalysisError>`](crate::error::DeleteAnalysisError)
    pub fn delete_analysis(&self) -> fluent_builders::DeleteAnalysis<C, M, R> {
        fluent_builders::DeleteAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDashboard`](crate::client::fluent_builders::DeleteDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDashboard::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteDashboard::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboard that you're deleting.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDashboard::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::DeleteDashboard::set_dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::DeleteDashboard::version_number) / [`set_version_number(Option<i64>)`](crate::client::fluent_builders::DeleteDashboard::set_version_number): <p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>
    /// - On success, responds with [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DeleteDashboardOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteDashboardOutput::arn): <p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>
    ///   - [`dashboard_id(Option<String>)`](crate::output::DeleteDashboardOutput::dashboard_id): <p>The ID of the dashboard.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteDashboardOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DeleteDashboardError>`](crate::error::DeleteDashboardError)
    pub fn delete_dashboard(&self) -> fluent_builders::DeleteDashboard<C, M, R> {
        fluent_builders::DeleteDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataSet`](crate::client::fluent_builders::DeleteDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSet::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteDataSet::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSet::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::DeleteDataSet::set_data_set_id): <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    /// - On success, responds with [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteDataSetOutput::arn): <p>The Amazon Resource Name (ARN) of the dataset.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::DeleteDataSetOutput::data_set_id): <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteDataSetOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteDataSetOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteDataSetError>`](crate::error::DeleteDataSetError)
    pub fn delete_data_set(&self) -> fluent_builders::DeleteDataSet<C, M, R> {
        fluent_builders::DeleteDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataSource`](crate::client::fluent_builders::DeleteDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSource::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteDataSource::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSource::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::DeleteDataSource::set_data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    /// - On success, responds with [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteDataSourceOutput::arn): <p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>
    ///   - [`data_source_id(Option<String>)`](crate::output::DeleteDataSourceOutput::data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteDataSourceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteDataSourceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteDataSourceError>`](crate::error::DeleteDataSourceError)
    pub fn delete_data_source(&self) -> fluent_builders::DeleteDataSource<C, M, R> {
        fluent_builders::DeleteDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFolder`](crate::client::fluent_builders::DeleteFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFolder::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteFolder::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFolder::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DeleteFolder::set_folder_id): <p>The ID of the folder.</p>
    /// - On success, responds with [`DeleteFolderOutput`](crate::output::DeleteFolderOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DeleteFolderOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteFolderOutput::arn): <p>The Amazon Resource Name of the deleted folder.</p>
    ///   - [`folder_id(Option<String>)`](crate::output::DeleteFolderOutput::folder_id): <p>The ID of the folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteFolderOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DeleteFolderError>`](crate::error::DeleteFolderError)
    pub fn delete_folder(&self) -> fluent_builders::DeleteFolder<C, M, R> {
        fluent_builders::DeleteFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFolderMembership`](crate::client::fluent_builders::DeleteFolderMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFolderMembership::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteFolderMembership::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFolderMembership::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DeleteFolderMembership::set_folder_id): <p>The Folder ID.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFolderMembership::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::DeleteFolderMembership::set_member_id): <p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>
    ///   - [`member_type(MemberType)`](crate::client::fluent_builders::DeleteFolderMembership::member_type) / [`set_member_type(Option<MemberType>)`](crate::client::fluent_builders::DeleteFolderMembership::set_member_type): <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code> </p>
    /// - On success, responds with [`DeleteFolderMembershipOutput`](crate::output::DeleteFolderMembershipOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DeleteFolderMembershipOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteFolderMembershipOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DeleteFolderMembershipError>`](crate::error::DeleteFolderMembershipError)
    pub fn delete_folder_membership(&self) -> fluent_builders::DeleteFolderMembership<C, M, R> {
        fluent_builders::DeleteFolderMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_group_name): <p>The name of the group that you want to delete.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`DeleteGroupOutput`](crate::output::DeleteGroupOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteGroupOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteGroupOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteGroupError>`](crate::error::DeleteGroupError)
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGroupMembership`](crate::client::fluent_builders::DeleteGroupMembership) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGroupMembership::member_name) / [`set_member_name(Option<String>)`](crate::client::fluent_builders::DeleteGroupMembership::set_member_name): <p>The name of the user that you want to delete from the group membership.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGroupMembership::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DeleteGroupMembership::set_group_name): <p>The name of the group that you want to delete the user from.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGroupMembership::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteGroupMembership::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeleteGroupMembership::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeleteGroupMembership::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`DeleteGroupMembershipOutput`](crate::output::DeleteGroupMembershipOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteGroupMembershipOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteGroupMembershipOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteGroupMembershipError>`](crate::error::DeleteGroupMembershipError)
    pub fn delete_group_membership(&self) -> fluent_builders::DeleteGroupMembership<C, M, R> {
        fluent_builders::DeleteGroupMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIAMPolicyAssignment`](crate::client::fluent_builders::DeleteIAMPolicyAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIAMPolicyAssignment::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteIAMPolicyAssignment::set_aws_account_id): <p>The Amazon Web Services account ID where you want to delete the IAM policy assignment.</p>
    ///   - [`assignment_name(impl Into<String>)`](crate::client::fluent_builders::DeleteIAMPolicyAssignment::assignment_name) / [`set_assignment_name(Option<String>)`](crate::client::fluent_builders::DeleteIAMPolicyAssignment::set_assignment_name): <p>The name of the assignment. </p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeleteIAMPolicyAssignment::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeleteIAMPolicyAssignment::set_namespace): <p>The namespace that contains the assignment.</p>
    /// - On success, responds with [`DeleteIamPolicyAssignmentOutput`](crate::output::DeleteIamPolicyAssignmentOutput) with field(s):
    ///   - [`assignment_name(Option<String>)`](crate::output::DeleteIamPolicyAssignmentOutput::assignment_name): <p>The name of the assignment. </p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteIamPolicyAssignmentOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteIamPolicyAssignmentOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteIAMPolicyAssignmentError>`](crate::error::DeleteIAMPolicyAssignmentError)
    pub fn delete_iam_policy_assignment(
        &self,
    ) -> fluent_builders::DeleteIAMPolicyAssignment<C, M, R> {
        fluent_builders::DeleteIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNamespace`](crate::client::fluent_builders::DeleteNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNamespace::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteNamespace::set_aws_account_id): <p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeleteNamespace::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeleteNamespace::set_namespace): <p>The namespace that you want to delete.</p>
    /// - On success, responds with [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteNamespaceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteNamespaceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteNamespaceError>`](crate::error::DeleteNamespaceError)
    pub fn delete_namespace(&self) -> fluent_builders::DeleteNamespace<C, M, R> {
        fluent_builders::DeleteNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTemplate`](crate::client::fluent_builders::DeleteTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTemplate::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteTemplate::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template that you're deleting.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTemplate::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::DeleteTemplate::set_template_id): <p>An ID for the template you want to delete.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::DeleteTemplate::version_number) / [`set_version_number(Option<i64>)`](crate::client::fluent_builders::DeleteTemplate::set_version_number): <p>Specifies the version of the template that you want to delete. If you don't provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>
    /// - On success, responds with [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteTemplateOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteTemplateOutput::arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`template_id(Option<String>)`](crate::output::DeleteTemplateOutput::template_id): <p>An ID for the template.</p>
    ///   - [`status(i32)`](crate::output::DeleteTemplateOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteTemplateError>`](crate::error::DeleteTemplateError)
    pub fn delete_template(&self) -> fluent_builders::DeleteTemplate<C, M, R> {
        fluent_builders::DeleteTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTemplateAlias`](crate::client::fluent_builders::DeleteTemplateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTemplateAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteTemplateAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the item to delete.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTemplateAlias::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::DeleteTemplateAlias::set_template_id): <p>The ID for the template that the specified alias is for.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTemplateAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DeleteTemplateAlias::set_alias_name): <p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>
    /// - On success, responds with [`DeleteTemplateAliasOutput`](crate::output::DeleteTemplateAliasOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DeleteTemplateAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`template_id(Option<String>)`](crate::output::DeleteTemplateAliasOutput::template_id): <p>An ID for the template associated with the deletion.</p>
    ///   - [`alias_name(Option<String>)`](crate::output::DeleteTemplateAliasOutput::alias_name): <p>The name for the template alias.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteTemplateAliasOutput::arn): <p>The Amazon Resource Name (ARN) of the template you want to delete.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteTemplateAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DeleteTemplateAliasError>`](crate::error::DeleteTemplateAliasError)
    pub fn delete_template_alias(&self) -> fluent_builders::DeleteTemplateAlias<C, M, R> {
        fluent_builders::DeleteTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTheme`](crate::client::fluent_builders::DeleteTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTheme::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteTheme::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme that you're deleting.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTheme::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::DeleteTheme::set_theme_id): <p>An ID for the theme that you want to delete.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::DeleteTheme::version_number) / [`set_version_number(Option<i64>)`](crate::client::fluent_builders::DeleteTheme::set_version_number): <p>The version of the theme that you want to delete. </p>  <p> <b>Note:</b> If you don't provide a version number, you're using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>
    /// - On success, responds with [`DeleteThemeOutput`](crate::output::DeleteThemeOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteThemeOutput::arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteThemeOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteThemeOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`theme_id(Option<String>)`](crate::output::DeleteThemeOutput::theme_id): <p>An ID for the theme.</p>
    /// - On failure, responds with [`SdkError<DeleteThemeError>`](crate::error::DeleteThemeError)
    pub fn delete_theme(&self) -> fluent_builders::DeleteTheme<C, M, R> {
        fluent_builders::DeleteTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteThemeAlias`](crate::client::fluent_builders::DeleteThemeAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteThemeAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteThemeAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::DeleteThemeAlias::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::DeleteThemeAlias::set_theme_id): <p>The ID for the theme that the specified alias is for.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DeleteThemeAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DeleteThemeAlias::set_alias_name): <p>The unique name for the theme alias to delete.</p>
    /// - On success, responds with [`DeleteThemeAliasOutput`](crate::output::DeleteThemeAliasOutput) with field(s):
    ///   - [`alias_name(Option<String>)`](crate::output::DeleteThemeAliasOutput::alias_name): <p>The name for the theme alias.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteThemeAliasOutput::arn): <p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DeleteThemeAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteThemeAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`theme_id(Option<String>)`](crate::output::DeleteThemeAliasOutput::theme_id): <p>An ID for the theme associated with the deletion.</p>
    /// - On failure, responds with [`SdkError<DeleteThemeAliasError>`](crate::error::DeleteThemeAliasError)
    pub fn delete_theme_alias(&self) -> fluent_builders::DeleteThemeAlias<C, M, R> {
        fluent_builders::DeleteThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_name): <p>The name of the user that you want to delete.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_aws_account_id): <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteUserOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteUserOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserByPrincipalId`](crate::client::fluent_builders::DeleteUserByPrincipalId) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`principal_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserByPrincipalId::principal_id) / [`set_principal_id(Option<String>)`](crate::client::fluent_builders::DeleteUserByPrincipalId::set_principal_id): <p>The principal ID of the user.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserByPrincipalId::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DeleteUserByPrincipalId::set_aws_account_id): <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeleteUserByPrincipalId::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeleteUserByPrincipalId::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`DeleteUserByPrincipalIdOutput`](crate::output::DeleteUserByPrincipalIdOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteUserByPrincipalIdOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DeleteUserByPrincipalIdOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteUserByPrincipalIdError>`](crate::error::DeleteUserByPrincipalIdError)
    pub fn delete_user_by_principal_id(&self) -> fluent_builders::DeleteUserByPrincipalId<C, M, R> {
        fluent_builders::DeleteUserByPrincipalId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountCustomization`](crate::client::fluent_builders::DescribeAccountCustomization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountCustomization::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeAccountCustomization::set_aws_account_id): <p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations for.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountCustomization::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DescribeAccountCustomization::set_namespace): <p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations for.</p>
    ///   - [`resolved(bool)`](crate::client::fluent_builders::DescribeAccountCustomization::resolved) / [`set_resolved(bool)`](crate::client::fluent_builders::DescribeAccountCustomization::set_resolved): <p>The <code>Resolved</code> flag works with the other parameters to determine which view of Amazon QuickSight customizations is returned. You can add this flag to your command to use the same view that Amazon QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations that are configured at different levels. </p>
    /// - On success, responds with [`DescribeAccountCustomizationOutput`](crate::output::DescribeAccountCustomizationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeAccountCustomizationOutput::arn): <p>The Amazon Resource Name (ARN) of the customization that's associated with this Amazon Web Services account.</p>
    ///   - [`aws_account_id(Option<String>)`](crate::output::DescribeAccountCustomizationOutput::aws_account_id): <p>The ID for the Amazon Web Services account that you're describing.</p>
    ///   - [`namespace(Option<String>)`](crate::output::DescribeAccountCustomizationOutput::namespace): <p>The Amazon QuickSight namespace that you're describing. </p>
    ///   - [`account_customization(Option<AccountCustomization>)`](crate::output::DescribeAccountCustomizationOutput::account_customization): <p>The Amazon QuickSight customizations that exist in the current Amazon Web Services Region. </p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeAccountCustomizationOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeAccountCustomizationOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountCustomizationError>`](crate::error::DescribeAccountCustomizationError)
    pub fn describe_account_customization(
        &self,
    ) -> fluent_builders::DescribeAccountCustomization<C, M, R> {
        fluent_builders::DescribeAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountSettings`](crate::client::fluent_builders::DescribeAccountSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountSettings::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeAccountSettings::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>
    /// - On success, responds with [`DescribeAccountSettingsOutput`](crate::output::DescribeAccountSettingsOutput) with field(s):
    ///   - [`account_settings(Option<AccountSettings>)`](crate::output::DescribeAccountSettingsOutput::account_settings): <p>The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the Amazon QuickSight subscription. In the QuickSight console, the Amazon QuickSight subscription is sometimes referred to as a QuickSight "account" even though it's technically not an account by itself. Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region where you use it.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeAccountSettingsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeAccountSettingsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountSettingsError>`](crate::error::DescribeAccountSettingsError)
    pub fn describe_account_settings(&self) -> fluent_builders::DescribeAccountSettings<C, M, R> {
        fluent_builders::DescribeAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAnalysis`](crate::client::fluent_builders::DescribeAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAnalysis::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeAnalysis::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAnalysis::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::DescribeAnalysis::set_analysis_id): <p>The ID of the analysis that you're describing. The ID is part of the URL of the analysis.</p>
    /// - On success, responds with [`DescribeAnalysisOutput`](crate::output::DescribeAnalysisOutput) with field(s):
    ///   - [`analysis(Option<Analysis>)`](crate::output::DescribeAnalysisOutput::analysis): <p>A metadata structure that contains summary information for the analysis that you're describing.</p>
    ///   - [`status(i32)`](crate::output::DescribeAnalysisOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeAnalysisOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeAnalysisError>`](crate::error::DescribeAnalysisError)
    pub fn describe_analysis(&self) -> fluent_builders::DescribeAnalysis<C, M, R> {
        fluent_builders::DescribeAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAnalysisPermissions`](crate::client::fluent_builders::DescribeAnalysisPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAnalysisPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeAnalysisPermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're describing. You must be using the Amazon Web Services account that the analysis is in.</p>
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAnalysisPermissions::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::DescribeAnalysisPermissions::set_analysis_id): <p>The ID of the analysis whose permissions you're describing. The ID is part of the analysis URL.</p>
    /// - On success, responds with [`DescribeAnalysisPermissionsOutput`](crate::output::DescribeAnalysisPermissionsOutput) with field(s):
    ///   - [`analysis_id(Option<String>)`](crate::output::DescribeAnalysisPermissionsOutput::analysis_id): <p>The ID of the analysis whose permissions you're describing.</p>
    ///   - [`analysis_arn(Option<String>)`](crate::output::DescribeAnalysisPermissionsOutput::analysis_arn): <p>The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeAnalysisPermissionsOutput::permissions): <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
    ///   - [`status(i32)`](crate::output::DescribeAnalysisPermissionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeAnalysisPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeAnalysisPermissionsError>`](crate::error::DescribeAnalysisPermissionsError)
    pub fn describe_analysis_permissions(
        &self,
    ) -> fluent_builders::DescribeAnalysisPermissions<C, M, R> {
        fluent_builders::DescribeAnalysisPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDashboard`](crate::client::fluent_builders::DescribeDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDashboard::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeDashboard::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDashboard::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::DescribeDashboard::set_dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::DescribeDashboard::version_number) / [`set_version_number(Option<i64>)`](crate::client::fluent_builders::DescribeDashboard::set_version_number): <p>The version number for the dashboard. If a version number isn't passed, the latest published dashboard version is described. </p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDashboard::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DescribeDashboard::set_alias_name): <p>The alias name.</p>
    /// - On success, responds with [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput) with field(s):
    ///   - [`dashboard(Option<Dashboard>)`](crate::output::DescribeDashboardOutput::dashboard): <p>Information about the dashboard.</p>
    ///   - [`status(i32)`](crate::output::DescribeDashboardOutput::status): <p>The HTTP status of this request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeDashboardOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeDashboardError>`](crate::error::DescribeDashboardError)
    pub fn describe_dashboard(&self) -> fluent_builders::DescribeDashboard<C, M, R> {
        fluent_builders::DescribeDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDashboardPermissions`](crate::client::fluent_builders::DescribeDashboardPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDashboardPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeDashboardPermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing permissions for.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDashboardPermissions::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::DescribeDashboardPermissions::set_dashboard_id): <p>The ID for the dashboard, also added to the IAM policy.</p>
    /// - On success, responds with [`DescribeDashboardPermissionsOutput`](crate::output::DescribeDashboardPermissionsOutput) with field(s):
    ///   - [`dashboard_id(Option<String>)`](crate::output::DescribeDashboardPermissionsOutput::dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`dashboard_arn(Option<String>)`](crate::output::DescribeDashboardPermissionsOutput::dashboard_arn): <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeDashboardPermissionsOutput::permissions): <p>A structure that contains the permissions for the dashboard.</p>
    ///   - [`status(i32)`](crate::output::DescribeDashboardPermissionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeDashboardPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`link_sharing_configuration(Option<LinkSharingConfiguration>)`](crate::output::DescribeDashboardPermissionsOutput::link_sharing_configuration): <p>A structure that contains the configuration of a shareable link that grants access to the dashboard. Your users can use the link to view and interact with the dashboard, if the dashboard has been shared with them. For more information about sharing dashboards, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.</p>
    /// - On failure, responds with [`SdkError<DescribeDashboardPermissionsError>`](crate::error::DescribeDashboardPermissionsError)
    pub fn describe_dashboard_permissions(
        &self,
    ) -> fluent_builders::DescribeDashboardPermissions<C, M, R> {
        fluent_builders::DescribeDashboardPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataSet`](crate::client::fluent_builders::DescribeDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSet::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSet::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSet::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSet::set_data_set_id): <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    /// - On success, responds with [`DescribeDataSetOutput`](crate::output::DescribeDataSetOutput) with field(s):
    ///   - [`data_set(Option<DataSet>)`](crate::output::DescribeDataSetOutput::data_set): <p>Information on the dataset.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeDataSetOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeDataSetOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeDataSetError>`](crate::error::DescribeDataSetError)
    pub fn describe_data_set(&self) -> fluent_builders::DescribeDataSet<C, M, R> {
        fluent_builders::DescribeDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataSetPermissions`](crate::client::fluent_builders::DescribeDataSetPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSetPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSetPermissions::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSetPermissions::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSetPermissions::set_data_set_id): <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    /// - On success, responds with [`DescribeDataSetPermissionsOutput`](crate::output::DescribeDataSetPermissionsOutput) with field(s):
    ///   - [`data_set_arn(Option<String>)`](crate::output::DescribeDataSetPermissionsOutput::data_set_arn): <p>The Amazon Resource Name (ARN) of the dataset.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::DescribeDataSetPermissionsOutput::data_set_id): <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeDataSetPermissionsOutput::permissions): <p>A list of resource permissions on the dataset.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeDataSetPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeDataSetPermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeDataSetPermissionsError>`](crate::error::DescribeDataSetPermissionsError)
    pub fn describe_data_set_permissions(
        &self,
    ) -> fluent_builders::DescribeDataSetPermissions<C, M, R> {
        fluent_builders::DescribeDataSetPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataSource`](crate::client::fluent_builders::DescribeDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSource::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSource::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSource::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSource::set_data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    /// - On success, responds with [`DescribeDataSourceOutput`](crate::output::DescribeDataSourceOutput) with field(s):
    ///   - [`data_source(Option<DataSource>)`](crate::output::DescribeDataSourceOutput::data_source): <p>The information on the data source.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeDataSourceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeDataSourceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeDataSourceError>`](crate::error::DescribeDataSourceError)
    pub fn describe_data_source(&self) -> fluent_builders::DescribeDataSource<C, M, R> {
        fluent_builders::DescribeDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataSourcePermissions`](crate::client::fluent_builders::DescribeDataSourcePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSourcePermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSourcePermissions::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSourcePermissions::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::DescribeDataSourcePermissions::set_data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    /// - On success, responds with [`DescribeDataSourcePermissionsOutput`](crate::output::DescribeDataSourcePermissionsOutput) with field(s):
    ///   - [`data_source_arn(Option<String>)`](crate::output::DescribeDataSourcePermissionsOutput::data_source_arn): <p>The Amazon Resource Name (ARN) of the data source.</p>
    ///   - [`data_source_id(Option<String>)`](crate::output::DescribeDataSourcePermissionsOutput::data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeDataSourcePermissionsOutput::permissions): <p>A list of resource permissions on the data source.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeDataSourcePermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeDataSourcePermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeDataSourcePermissionsError>`](crate::error::DescribeDataSourcePermissionsError)
    pub fn describe_data_source_permissions(
        &self,
    ) -> fluent_builders::DescribeDataSourcePermissions<C, M, R> {
        fluent_builders::DescribeDataSourcePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFolder`](crate::client::fluent_builders::DescribeFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFolder::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeFolder::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFolder::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DescribeFolder::set_folder_id): <p>The ID of the folder.</p>
    /// - On success, responds with [`DescribeFolderOutput`](crate::output::DescribeFolderOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DescribeFolderOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`folder(Option<Folder>)`](crate::output::DescribeFolderOutput::folder): <p>Information about the folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeFolderOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeFolderError>`](crate::error::DescribeFolderError)
    pub fn describe_folder(&self) -> fluent_builders::DescribeFolder<C, M, R> {
        fluent_builders::DescribeFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFolderPermissions`](crate::client::fluent_builders::DescribeFolderPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeFolderPermissions::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderPermissions::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DescribeFolderPermissions::set_folder_id): <p>The ID of the folder.</p>
    /// - On success, responds with [`DescribeFolderPermissionsOutput`](crate::output::DescribeFolderPermissionsOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DescribeFolderPermissionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`folder_id(Option<String>)`](crate::output::DescribeFolderPermissionsOutput::folder_id): <p>The ID of the folder.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeFolderPermissionsOutput::arn): <p>The Amazon Resource Name (ARN) for the folder.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeFolderPermissionsOutput::permissions): <p>Information about the permissions on the folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeFolderPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeFolderPermissionsError>`](crate::error::DescribeFolderPermissionsError)
    pub fn describe_folder_permissions(
        &self,
    ) -> fluent_builders::DescribeFolderPermissions<C, M, R> {
        fluent_builders::DescribeFolderPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFolderResolvedPermissions`](crate::client::fluent_builders::DescribeFolderResolvedPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderResolvedPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeFolderResolvedPermissions::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFolderResolvedPermissions::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::DescribeFolderResolvedPermissions::set_folder_id): <p>The ID of the folder.</p>
    /// - On success, responds with [`DescribeFolderResolvedPermissionsOutput`](crate::output::DescribeFolderResolvedPermissionsOutput) with field(s):
    ///   - [`status(i32)`](crate::output::DescribeFolderResolvedPermissionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`folder_id(Option<String>)`](crate::output::DescribeFolderResolvedPermissionsOutput::folder_id): <p>The ID of the folder.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeFolderResolvedPermissionsOutput::arn): <p>The Amazon Resource Name (ARN) of the folder.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeFolderResolvedPermissionsOutput::permissions): <p>Information about the permissions for the folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeFolderResolvedPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeFolderResolvedPermissionsError>`](crate::error::DescribeFolderResolvedPermissionsError)
    pub fn describe_folder_resolved_permissions(
        &self,
    ) -> fluent_builders::DescribeFolderResolvedPermissions<C, M, R> {
        fluent_builders::DescribeFolderResolvedPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGroup`](crate::client::fluent_builders::DescribeGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DescribeGroup::set_group_name): <p>The name of the group that you want to describe.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeGroup::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeGroup::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DescribeGroup::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DescribeGroup::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`DescribeGroupOutput`](crate::output::DescribeGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::DescribeGroupOutput::group): <p>The name of the group.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeGroupOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeGroupOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeGroupError>`](crate::error::DescribeGroupError)
    pub fn describe_group(&self) -> fluent_builders::DescribeGroup<C, M, R> {
        fluent_builders::DescribeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIAMPolicyAssignment`](crate::client::fluent_builders::DescribeIAMPolicyAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIAMPolicyAssignment::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeIAMPolicyAssignment::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>
    ///   - [`assignment_name(impl Into<String>)`](crate::client::fluent_builders::DescribeIAMPolicyAssignment::assignment_name) / [`set_assignment_name(Option<String>)`](crate::client::fluent_builders::DescribeIAMPolicyAssignment::set_assignment_name): <p>The name of the assignment, also called a rule.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DescribeIAMPolicyAssignment::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DescribeIAMPolicyAssignment::set_namespace): <p>The namespace that contains the assignment.</p>
    /// - On success, responds with [`DescribeIamPolicyAssignmentOutput`](crate::output::DescribeIamPolicyAssignmentOutput) with field(s):
    ///   - [`iam_policy_assignment(Option<IamPolicyAssignment>)`](crate::output::DescribeIamPolicyAssignmentOutput::iam_policy_assignment): <p>Information describing the IAM policy assignment.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeIamPolicyAssignmentOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeIamPolicyAssignmentOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeIAMPolicyAssignmentError>`](crate::error::DescribeIAMPolicyAssignmentError)
    pub fn describe_iam_policy_assignment(
        &self,
    ) -> fluent_builders::DescribeIAMPolicyAssignment<C, M, R> {
        fluent_builders::DescribeIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIngestion`](crate::client::fluent_builders::DescribeIngestion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIngestion::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeIngestion::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIngestion::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::DescribeIngestion::set_data_set_id): <p>The ID of the dataset used in the ingestion.</p>
    ///   - [`ingestion_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIngestion::ingestion_id) / [`set_ingestion_id(Option<String>)`](crate::client::fluent_builders::DescribeIngestion::set_ingestion_id): <p>An ID for the ingestion.</p>
    /// - On success, responds with [`DescribeIngestionOutput`](crate::output::DescribeIngestionOutput) with field(s):
    ///   - [`ingestion(Option<Ingestion>)`](crate::output::DescribeIngestionOutput::ingestion): <p>Information about the ingestion.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeIngestionOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeIngestionOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeIngestionError>`](crate::error::DescribeIngestionError)
    pub fn describe_ingestion(&self) -> fluent_builders::DescribeIngestion<C, M, R> {
        fluent_builders::DescribeIngestion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIpRestriction`](crate::client::fluent_builders::DescribeIpRestriction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIpRestriction::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeIpRestriction::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    /// - On success, responds with [`DescribeIpRestrictionOutput`](crate::output::DescribeIpRestrictionOutput) with field(s):
    ///   - [`aws_account_id(Option<String>)`](crate::output::DescribeIpRestrictionOutput::aws_account_id): <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    ///   - [`ip_restriction_rule_map(Option<HashMap<String, String>>)`](crate::output::DescribeIpRestrictionOutput::ip_restriction_rule_map): <p>A map that describes the IP rules with CIDR range and description.</p>
    ///   - [`enabled(Option<bool>)`](crate::output::DescribeIpRestrictionOutput::enabled): <p>A value that specifies whether IP rules are turned on.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeIpRestrictionOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeIpRestrictionOutput::status): <p>The HTTP status of the request. </p>
    /// - On failure, responds with [`SdkError<DescribeIpRestrictionError>`](crate::error::DescribeIpRestrictionError)
    pub fn describe_ip_restriction(&self) -> fluent_builders::DescribeIpRestriction<C, M, R> {
        fluent_builders::DescribeIpRestriction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNamespace`](crate::client::fluent_builders::DescribeNamespace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeNamespace::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeNamespace::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DescribeNamespace::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DescribeNamespace::set_namespace): <p>The namespace that you want to describe.</p>
    /// - On success, responds with [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput) with field(s):
    ///   - [`namespace(Option<NamespaceInfoV2>)`](crate::output::DescribeNamespaceOutput::namespace): <p>The information about the namespace that you're describing. The response includes the namespace ARN, name, Amazon Web Services Region, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API operation lists the namespace error types and messages associated with the creation process.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeNamespaceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeNamespaceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeNamespaceError>`](crate::error::DescribeNamespaceError)
    pub fn describe_namespace(&self) -> fluent_builders::DescribeNamespace<C, M, R> {
        fluent_builders::DescribeNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTemplate`](crate::client::fluent_builders::DescribeTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplate::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeTemplate::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplate::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::DescribeTemplate::set_template_id): <p>The ID for the template.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::DescribeTemplate::version_number) / [`set_version_number(Option<i64>)`](crate::client::fluent_builders::DescribeTemplate::set_version_number): <p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the template is described.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplate::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DescribeTemplate::set_alias_name): <p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
    /// - On success, responds with [`DescribeTemplateOutput`](crate::output::DescribeTemplateOutput) with field(s):
    ///   - [`template(Option<Template>)`](crate::output::DescribeTemplateOutput::template): <p>The template structure for the object you want to describe.</p>
    ///   - [`status(i32)`](crate::output::DescribeTemplateOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeTemplateOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeTemplateError>`](crate::error::DescribeTemplateError)
    pub fn describe_template(&self) -> fluent_builders::DescribeTemplate<C, M, R> {
        fluent_builders::DescribeTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTemplateAlias`](crate::client::fluent_builders::DescribeTemplateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplateAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeTemplateAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template alias that you're describing.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplateAlias::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::DescribeTemplateAlias::set_template_id): <p>The ID for the template.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplateAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DescribeTemplateAlias::set_alias_name): <p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
    /// - On success, responds with [`DescribeTemplateAliasOutput`](crate::output::DescribeTemplateAliasOutput) with field(s):
    ///   - [`template_alias(Option<TemplateAlias>)`](crate::output::DescribeTemplateAliasOutput::template_alias): <p>Information about the template alias.</p>
    ///   - [`status(i32)`](crate::output::DescribeTemplateAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeTemplateAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeTemplateAliasError>`](crate::error::DescribeTemplateAliasError)
    pub fn describe_template_alias(&self) -> fluent_builders::DescribeTemplateAlias<C, M, R> {
        fluent_builders::DescribeTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTemplatePermissions`](crate::client::fluent_builders::DescribeTemplatePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplatePermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeTemplatePermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTemplatePermissions::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::DescribeTemplatePermissions::set_template_id): <p>The ID for the template.</p>
    /// - On success, responds with [`DescribeTemplatePermissionsOutput`](crate::output::DescribeTemplatePermissionsOutput) with field(s):
    ///   - [`template_id(Option<String>)`](crate::output::DescribeTemplatePermissionsOutput::template_id): <p>The ID for the template.</p>
    ///   - [`template_arn(Option<String>)`](crate::output::DescribeTemplatePermissionsOutput::template_arn): <p>The Amazon Resource Name (ARN) of the template.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeTemplatePermissionsOutput::permissions): <p>A list of resource permissions to be set on the template. </p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeTemplatePermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeTemplatePermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeTemplatePermissionsError>`](crate::error::DescribeTemplatePermissionsError)
    pub fn describe_template_permissions(
        &self,
    ) -> fluent_builders::DescribeTemplatePermissions<C, M, R> {
        fluent_builders::DescribeTemplatePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTheme`](crate::client::fluent_builders::DescribeTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTheme::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeTheme::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTheme::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::DescribeTheme::set_theme_id): <p>The ID for the theme.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::DescribeTheme::version_number) / [`set_version_number(Option<i64>)`](crate::client::fluent_builders::DescribeTheme::set_version_number): <p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the theme is described.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTheme::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DescribeTheme::set_alias_name): <p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to themes.</p>
    /// - On success, responds with [`DescribeThemeOutput`](crate::output::DescribeThemeOutput) with field(s):
    ///   - [`theme(Option<Theme>)`](crate::output::DescribeThemeOutput::theme): <p>The information about the theme that you are describing.</p>
    ///   - [`status(i32)`](crate::output::DescribeThemeOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeThemeOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeThemeError>`](crate::error::DescribeThemeError)
    pub fn describe_theme(&self) -> fluent_builders::DescribeTheme<C, M, R> {
        fluent_builders::DescribeTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeThemeAlias`](crate::client::fluent_builders::DescribeThemeAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeThemeAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeThemeAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme alias that you're describing.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::DescribeThemeAlias::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::DescribeThemeAlias::set_theme_id): <p>The ID for the theme.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::DescribeThemeAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::DescribeThemeAlias::set_alias_name): <p>The name of the theme alias that you want to describe.</p>
    /// - On success, responds with [`DescribeThemeAliasOutput`](crate::output::DescribeThemeAliasOutput) with field(s):
    ///   - [`theme_alias(Option<ThemeAlias>)`](crate::output::DescribeThemeAliasOutput::theme_alias): <p>Information about the theme alias.</p>
    ///   - [`status(i32)`](crate::output::DescribeThemeAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeThemeAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeThemeAliasError>`](crate::error::DescribeThemeAliasError)
    pub fn describe_theme_alias(&self) -> fluent_builders::DescribeThemeAlias<C, M, R> {
        fluent_builders::DescribeThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeThemePermissions`](crate::client::fluent_builders::DescribeThemePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeThemePermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeThemePermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::DescribeThemePermissions::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::DescribeThemePermissions::set_theme_id): <p>The ID for the theme that you want to describe permissions for.</p>
    /// - On success, responds with [`DescribeThemePermissionsOutput`](crate::output::DescribeThemePermissionsOutput) with field(s):
    ///   - [`theme_id(Option<String>)`](crate::output::DescribeThemePermissionsOutput::theme_id): <p>The ID for the theme.</p>
    ///   - [`theme_arn(Option<String>)`](crate::output::DescribeThemePermissionsOutput::theme_arn): <p>The Amazon Resource Name (ARN) of the theme.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::DescribeThemePermissionsOutput::permissions): <p>A list of resource permissions set on the theme. </p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeThemePermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeThemePermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeThemePermissionsError>`](crate::error::DescribeThemePermissionsError)
    pub fn describe_theme_permissions(&self) -> fluent_builders::DescribeThemePermissions<C, M, R> {
        fluent_builders::DescribeThemePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUser`](crate::client::fluent_builders::DescribeUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_user_name): <p>The name of the user that you want to describe.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_aws_account_id): <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`DescribeUserOutput`](crate::output::DescribeUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::DescribeUserOutput::user): <p>The user name.</p>
    ///   - [`request_id(Option<String>)`](crate::output::DescribeUserOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::DescribeUserOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<DescribeUserError>`](crate::error::DescribeUserError)
    pub fn describe_user(&self) -> fluent_builders::DescribeUser<C, M, R> {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateEmbedUrlForAnonymousUser`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
    ///   - [`session_lifetime_in_minutes(i64)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::session_lifetime_in_minutes) / [`set_session_lifetime_in_minutes(Option<i64>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::set_session_lifetime_in_minutes): <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::set_namespace): <p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>
    ///   - [`session_tags(Vec<SessionTag>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::session_tags) / [`set_session_tags(Option<Vec<SessionTag>>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::set_session_tags): <p>The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p>  <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>
    ///   - [`authorized_resource_arns(Vec<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::authorized_resource_arns) / [`set_authorized_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::set_authorized_resource_arns): <p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>
    ///   - [`experience_configuration(AnonymousUserEmbeddingExperienceConfiguration)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::experience_configuration) / [`set_experience_configuration(Option<AnonymousUserEmbeddingExperienceConfiguration>)`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser::set_experience_configuration): <p>The configuration of the experience you are embedding.</p>
    /// - On success, responds with [`GenerateEmbedUrlForAnonymousUserOutput`](crate::output::GenerateEmbedUrlForAnonymousUserOutput) with field(s):
    ///   - [`embed_url(Option<String>)`](crate::output::GenerateEmbedUrlForAnonymousUserOutput::embed_url): <p>The embed URL for the dashboard.</p>
    ///   - [`status(i32)`](crate::output::GenerateEmbedUrlForAnonymousUserOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::GenerateEmbedUrlForAnonymousUserOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<GenerateEmbedUrlForAnonymousUserError>`](crate::error::GenerateEmbedUrlForAnonymousUserError)
    pub fn generate_embed_url_for_anonymous_user(
        &self,
    ) -> fluent_builders::GenerateEmbedUrlForAnonymousUser<C, M, R> {
        fluent_builders::GenerateEmbedUrlForAnonymousUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateEmbedUrlForRegisteredUser`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
    ///   - [`session_lifetime_in_minutes(i64)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::session_lifetime_in_minutes) / [`set_session_lifetime_in_minutes(Option<i64>)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::set_session_lifetime_in_minutes): <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::set_user_arn): <p>The Amazon Resource Name for the registered user.</p>
    ///   - [`experience_configuration(RegisteredUserEmbeddingExperienceConfiguration)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::experience_configuration) / [`set_experience_configuration(Option<RegisteredUserEmbeddingExperienceConfiguration>)`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser::set_experience_configuration): <p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards or the entire Amazon QuickSight console.</p>
    /// - On success, responds with [`GenerateEmbedUrlForRegisteredUserOutput`](crate::output::GenerateEmbedUrlForRegisteredUserOutput) with field(s):
    ///   - [`embed_url(Option<String>)`](crate::output::GenerateEmbedUrlForRegisteredUserOutput::embed_url): <p>The embed URL for the Amazon QuickSight dashboard or console.</p>
    ///   - [`status(i32)`](crate::output::GenerateEmbedUrlForRegisteredUserOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::GenerateEmbedUrlForRegisteredUserOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<GenerateEmbedUrlForRegisteredUserError>`](crate::error::GenerateEmbedUrlForRegisteredUserError)
    pub fn generate_embed_url_for_registered_user(
        &self,
    ) -> fluent_builders::GenerateEmbedUrlForRegisteredUser<C, M, R> {
        fluent_builders::GenerateEmbedUrlForRegisteredUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDashboardEmbedUrl`](crate::client::fluent_builders::GetDashboardEmbedUrl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_dashboard_id): <p>The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.</p>
    ///   - [`identity_type(EmbeddingIdentityType)`](crate::client::fluent_builders::GetDashboardEmbedUrl::identity_type) / [`set_identity_type(Option<EmbeddingIdentityType>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_identity_type): <p>The authentication method that the user uses to sign in.</p>
    ///   - [`session_lifetime_in_minutes(i64)`](crate::client::fluent_builders::GetDashboardEmbedUrl::session_lifetime_in_minutes) / [`set_session_lifetime_in_minutes(Option<i64>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_session_lifetime_in_minutes): <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
    ///   - [`undo_redo_disabled(bool)`](crate::client::fluent_builders::GetDashboardEmbedUrl::undo_redo_disabled) / [`set_undo_redo_disabled(bool)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_undo_redo_disabled): <p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>
    ///   - [`reset_disabled(bool)`](crate::client::fluent_builders::GetDashboardEmbedUrl::reset_disabled) / [`set_reset_disabled(bool)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_reset_disabled): <p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>
    ///   - [`state_persistence_enabled(bool)`](crate::client::fluent_builders::GetDashboardEmbedUrl::state_persistence_enabled) / [`set_state_persistence_enabled(bool)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_state_persistence_enabled): <p>Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_user_arn): <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p>  <ul>   <li> <p>Active Directory (AD) users or group members</p> </li>   <li> <p>Invited nonfederated users</p> </li>   <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li>  </ul>  <p>Omit this parameter for users in the third group – IAM users and IAM role-based sessions.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_namespace): <p>The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace, set <code>Namespace = default</code>.</p>
    ///   - [`additional_dashboard_ids(Vec<String>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::additional_dashboard_ids) / [`set_additional_dashboard_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetDashboardEmbedUrl::set_additional_dashboard_ids): <p>A list of one or more dashboard IDs that you want to add to a session that includes anonymous users. The <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> for this to work, because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "<code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can access all three dashboards. </p>
    /// - On success, responds with [`GetDashboardEmbedUrlOutput`](crate::output::GetDashboardEmbedUrlOutput) with field(s):
    ///   - [`embed_url(Option<String>)`](crate::output::GetDashboardEmbedUrlOutput::embed_url): <p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
    ///   - [`status(i32)`](crate::output::GetDashboardEmbedUrlOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::GetDashboardEmbedUrlOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<GetDashboardEmbedUrlError>`](crate::error::GetDashboardEmbedUrlError)
    pub fn get_dashboard_embed_url(&self) -> fluent_builders::GetDashboardEmbedUrl<C, M, R> {
        fluent_builders::GetDashboardEmbedUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSessionEmbedUrl`](crate::client::fluent_builders::GetSessionEmbedUrl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::GetSessionEmbedUrl::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::GetSessionEmbedUrl::set_aws_account_id): <p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>
    ///   - [`entry_point(impl Into<String>)`](crate::client::fluent_builders::GetSessionEmbedUrl::entry_point) / [`set_entry_point(Option<String>)`](crate::client::fluent_builders::GetSessionEmbedUrl::set_entry_point): <p>The URL you use to access the embedded session. The entry point URL is constrained to the following paths:</p>  <ul>   <li> <p> <code>/start</code> </p> </li>   <li> <p> <code>/start/analyses</code> </p> </li>   <li> <p> <code>/start/dashboards</code> </p> </li>   <li> <p> <code>/start/favorites</code> </p> </li>   <li> <p> <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p> </li>   <li> <p> <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p> </li>  </ul>
    ///   - [`session_lifetime_in_minutes(i64)`](crate::client::fluent_builders::GetSessionEmbedUrl::session_lifetime_in_minutes) / [`set_session_lifetime_in_minutes(Option<i64>)`](crate::client::fluent_builders::GetSessionEmbedUrl::set_session_lifetime_in_minutes): <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
    ///   - [`user_arn(impl Into<String>)`](crate::client::fluent_builders::GetSessionEmbedUrl::user_arn) / [`set_user_arn(Option<String>)`](crate::client::fluent_builders::GetSessionEmbedUrl::set_user_arn): <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:</p>  <ol>   <li> <p>Active Directory (AD) users or group members</p> </li>   <li> <p>Invited nonfederated users</p> </li>   <li> <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation</p> </li>  </ol>  <p>Omit this parameter for users in the third group, IAM users and IAM role-based sessions.</p>
    /// - On success, responds with [`GetSessionEmbedUrlOutput`](crate::output::GetSessionEmbedUrlOutput) with field(s):
    ///   - [`embed_url(Option<String>)`](crate::output::GetSessionEmbedUrlOutput::embed_url): <p>A single-use URL that you can put into your server-side web page to embed your Amazon QuickSight session. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
    ///   - [`status(i32)`](crate::output::GetSessionEmbedUrlOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::GetSessionEmbedUrlOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<GetSessionEmbedUrlError>`](crate::error::GetSessionEmbedUrlError)
    pub fn get_session_embed_url(&self) -> fluent_builders::GetSessionEmbedUrl<C, M, R> {
        fluent_builders::GetSessionEmbedUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAnalyses`](crate::client::fluent_builders::ListAnalyses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAnalyses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListAnalyses::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListAnalyses::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the analyses.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAnalyses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAnalyses::set_next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAnalyses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAnalyses::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListAnalysesOutput`](crate::output::ListAnalysesOutput) with field(s):
    ///   - [`analysis_summary_list(Option<Vec<AnalysisSummary>>)`](crate::output::ListAnalysesOutput::analysis_summary_list): <p>Metadata describing each of the analyses that are listed.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAnalysesOutput::next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`status(i32)`](crate::output::ListAnalysesOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListAnalysesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListAnalysesError>`](crate::error::ListAnalysesError)
    pub fn list_analyses(&self) -> fluent_builders::ListAnalyses<C, M, R> {
        fluent_builders::ListAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDashboards`](crate::client::fluent_builders::ListDashboards) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDashboards::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListDashboards::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListDashboards::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboards that you're listing.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDashboards::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDashboards::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDashboards::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDashboards::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListDashboardsOutput`](crate::output::ListDashboardsOutput) with field(s):
    ///   - [`dashboard_summary_list(Option<Vec<DashboardSummary>>)`](crate::output::ListDashboardsOutput::dashboard_summary_list): <p>A structure that contains all of the dashboards in your Amazon Web Services account. This structure provides basic information about the dashboards.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDashboardsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::ListDashboardsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListDashboardsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListDashboardsError>`](crate::error::ListDashboardsError)
    pub fn list_dashboards(&self) -> fluent_builders::ListDashboards<C, M, R> {
        fluent_builders::ListDashboards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDashboardVersions`](crate::client::fluent_builders::ListDashboardVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDashboardVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListDashboardVersions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListDashboardVersions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboard that you're listing versions for.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::ListDashboardVersions::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::ListDashboardVersions::set_dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDashboardVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDashboardVersions::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDashboardVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDashboardVersions::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListDashboardVersionsOutput`](crate::output::ListDashboardVersionsOutput) with field(s):
    ///   - [`dashboard_version_summary_list(Option<Vec<DashboardVersionSummary>>)`](crate::output::ListDashboardVersionsOutput::dashboard_version_summary_list): <p>A structure that contains information about each version of the dashboard.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDashboardVersionsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::ListDashboardVersionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListDashboardVersionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListDashboardVersionsError>`](crate::error::ListDashboardVersionsError)
    pub fn list_dashboard_versions(&self) -> fluent_builders::ListDashboardVersions<C, M, R> {
        fluent_builders::ListDashboardVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataSets`](crate::client::fluent_builders::ListDataSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDataSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListDataSets::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListDataSets::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataSets::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataSets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDataSets::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListDataSetsOutput`](crate::output::ListDataSetsOutput) with field(s):
    ///   - [`data_set_summaries(Option<Vec<DataSetSummary>>)`](crate::output::ListDataSetsOutput::data_set_summaries): <p>The list of dataset summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDataSetsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListDataSetsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListDataSetsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListDataSetsError>`](crate::error::ListDataSetsError)
    pub fn list_data_sets(&self) -> fluent_builders::ListDataSets<C, M, R> {
        fluent_builders::ListDataSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataSources`](crate::client::fluent_builders::ListDataSources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDataSources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListDataSources::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListDataSources::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataSources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataSources::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataSources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDataSources::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListDataSourcesOutput`](crate::output::ListDataSourcesOutput) with field(s):
    ///   - [`data_sources(Option<Vec<DataSource>>)`](crate::output::ListDataSourcesOutput::data_sources): <p>A list of data sources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDataSourcesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListDataSourcesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListDataSourcesOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListDataSourcesError>`](crate::error::ListDataSourcesError)
    pub fn list_data_sources(&self) -> fluent_builders::ListDataSources<C, M, R> {
        fluent_builders::ListDataSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFolderMembers`](crate::client::fluent_builders::ListFolderMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListFolderMembers::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListFolderMembers::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::ListFolderMembers::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::ListFolderMembers::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFolderMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFolderMembers::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFolderMembers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFolderMembers::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListFolderMembersOutput`](crate::output::ListFolderMembersOutput) with field(s):
    ///   - [`status(i32)`](crate::output::ListFolderMembersOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`folder_member_list(Option<Vec<MemberIdArnPair>>)`](crate::output::ListFolderMembersOutput::folder_member_list): <p>A structure that contains all of the folder members (dashboards, analyses, and datasets) in the folder.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFolderMembersOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListFolderMembersOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListFolderMembersError>`](crate::error::ListFolderMembersError)
    pub fn list_folder_members(&self) -> fluent_builders::ListFolderMembers<C, M, R> {
        fluent_builders::ListFolderMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFolders`](crate::client::fluent_builders::ListFolders) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListFolders::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListFolders::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFolders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFolders::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFolders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFolders::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListFoldersOutput`](crate::output::ListFoldersOutput) with field(s):
    ///   - [`status(i32)`](crate::output::ListFoldersOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`folder_summary_list(Option<Vec<FolderSummary>>)`](crate::output::ListFoldersOutput::folder_summary_list): <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFoldersOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListFoldersOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListFoldersError>`](crate::error::ListFoldersError)
    pub fn list_folders(&self) -> fluent_builders::ListFolders<C, M, R> {
        fluent_builders::ListFolders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroupMemberships`](crate::client::fluent_builders::ListGroupMemberships) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::ListGroupMemberships::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::ListGroupMemberships::set_group_name): <p>The name of the group that you want to see a membership list of.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroupMemberships::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroupMemberships::set_next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGroupMemberships::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGroupMemberships::set_max_results): <p>The maximum number of results to return from this request.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListGroupMemberships::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListGroupMemberships::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListGroupMemberships::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListGroupMemberships::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`ListGroupMembershipsOutput`](crate::output::ListGroupMembershipsOutput) with field(s):
    ///   - [`group_member_list(Option<Vec<GroupMember>>)`](crate::output::ListGroupMembershipsOutput::group_member_list): <p>The list of the members of the group.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGroupMembershipsOutput::next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListGroupMembershipsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListGroupMembershipsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListGroupMembershipsError>`](crate::error::ListGroupMembershipsError)
    pub fn list_group_memberships(&self) -> fluent_builders::ListGroupMemberships<C, M, R> {
        fluent_builders::ListGroupMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroups`](crate::client::fluent_builders::ListGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListGroups::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListGroups::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroups::set_next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGroups::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListGroups::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListGroups::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`ListGroupsOutput`](crate::output::ListGroupsOutput) with field(s):
    ///   - [`group_list(Option<Vec<Group>>)`](crate::output::ListGroupsOutput::group_list): <p>The list of the groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGroupsOutput::next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListGroupsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListGroupsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListGroupsError>`](crate::error::ListGroupsError)
    pub fn list_groups(&self) -> fluent_builders::ListGroups<C, M, R> {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIAMPolicyAssignments`](crate::client::fluent_builders::ListIAMPolicyAssignments) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains these IAM policy assignments.</p>
    ///   - [`assignment_status(AssignmentStatus)`](crate::client::fluent_builders::ListIAMPolicyAssignments::assignment_status) / [`set_assignment_status(Option<AssignmentStatus>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::set_assignment_status): <p>The status of the assignments.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::set_namespace): <p>The namespace for the assignments.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIAMPolicyAssignments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIAMPolicyAssignments::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListIamPolicyAssignmentsOutput`](crate::output::ListIamPolicyAssignmentsOutput) with field(s):
    ///   - [`iam_policy_assignments(Option<Vec<IamPolicyAssignmentSummary>>)`](crate::output::ListIamPolicyAssignmentsOutput::iam_policy_assignments): <p>Information describing the IAM policy assignments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIamPolicyAssignmentsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListIamPolicyAssignmentsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListIamPolicyAssignmentsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListIAMPolicyAssignmentsError>`](crate::error::ListIAMPolicyAssignmentsError)
    pub fn list_iam_policy_assignments(
        &self,
    ) -> fluent_builders::ListIAMPolicyAssignments<C, M, R> {
        fluent_builders::ListIAMPolicyAssignments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIAMPolicyAssignmentsForUser`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the assignments.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::set_user_name): <p>The name of the user.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::set_max_results): <p>The maximum number of results to be returned per request.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser::set_namespace): <p>The namespace of the assignment.</p>
    /// - On success, responds with [`ListIamPolicyAssignmentsForUserOutput`](crate::output::ListIamPolicyAssignmentsForUserOutput) with field(s):
    ///   - [`active_assignments(Option<Vec<ActiveIamPolicyAssignment>>)`](crate::output::ListIamPolicyAssignmentsForUserOutput::active_assignments): <p>The active assignments for this user.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListIamPolicyAssignmentsForUserOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIamPolicyAssignmentsForUserOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::ListIamPolicyAssignmentsForUserOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListIAMPolicyAssignmentsForUserError>`](crate::error::ListIAMPolicyAssignmentsForUserError)
    pub fn list_iam_policy_assignments_for_user(
        &self,
    ) -> fluent_builders::ListIAMPolicyAssignmentsForUser<C, M, R> {
        fluent_builders::ListIAMPolicyAssignmentsForUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIngestions`](crate::client::fluent_builders::ListIngestions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIngestions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::ListIngestions::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::ListIngestions::set_data_set_id): <p>The ID of the dataset used in the ingestion.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIngestions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIngestions::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListIngestions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListIngestions::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIngestions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIngestions::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListIngestionsOutput`](crate::output::ListIngestionsOutput) with field(s):
    ///   - [`ingestions(Option<Vec<Ingestion>>)`](crate::output::ListIngestionsOutput::ingestions): <p>A list of the ingestions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIngestionsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListIngestionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListIngestionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListIngestionsError>`](crate::error::ListIngestionsError)
    pub fn list_ingestions(&self) -> fluent_builders::ListIngestions<C, M, R> {
        fluent_builders::ListIngestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNamespaces`](crate::client::fluent_builders::ListNamespaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNamespaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListNamespaces::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListNamespaces::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNamespaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNamespaces::set_next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNamespaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNamespaces::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`ListNamespacesOutput`](crate::output::ListNamespacesOutput) with field(s):
    ///   - [`namespaces(Option<Vec<NamespaceInfoV2>>)`](crate::output::ListNamespacesOutput::namespaces): <p>The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNamespacesOutput::next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListNamespacesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListNamespacesOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListNamespacesError>`](crate::error::ListNamespacesError)
    pub fn list_namespaces(&self) -> fluent_builders::ListNamespaces<C, M, R> {
        fluent_builders::ListNamespaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListTagsForResourceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListTagsForResourceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTemplateAliases`](crate::client::fluent_builders::ListTemplateAliases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTemplateAliases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListTemplateAliases::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListTemplateAliases::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template aliases that you're listing.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::ListTemplateAliases::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::ListTemplateAliases::set_template_id): <p>The ID for the template.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTemplateAliases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTemplateAliases::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTemplateAliases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTemplateAliases::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListTemplateAliasesOutput`](crate::output::ListTemplateAliasesOutput) with field(s):
    ///   - [`template_alias_list(Option<Vec<TemplateAlias>>)`](crate::output::ListTemplateAliasesOutput::template_alias_list): <p>A structure containing the list of the template's aliases.</p>
    ///   - [`status(i32)`](crate::output::ListTemplateAliasesOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListTemplateAliasesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTemplateAliasesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListTemplateAliasesError>`](crate::error::ListTemplateAliasesError)
    pub fn list_template_aliases(&self) -> fluent_builders::ListTemplateAliases<C, M, R> {
        fluent_builders::ListTemplateAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTemplates`](crate::client::fluent_builders::ListTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListTemplates::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListTemplates::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTemplates::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTemplates::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListTemplatesOutput`](crate::output::ListTemplatesOutput) with field(s):
    ///   - [`template_summary_list(Option<Vec<TemplateSummary>>)`](crate::output::ListTemplatesOutput::template_summary_list): <p>A structure containing information about the templates in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTemplatesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::ListTemplatesOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListTemplatesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListTemplatesError>`](crate::error::ListTemplatesError)
    pub fn list_templates(&self) -> fluent_builders::ListTemplates<C, M, R> {
        fluent_builders::ListTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTemplateVersions`](crate::client::fluent_builders::ListTemplateVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTemplateVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListTemplateVersions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListTemplateVersions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::ListTemplateVersions::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::ListTemplateVersions::set_template_id): <p>The ID for the template.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTemplateVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTemplateVersions::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTemplateVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTemplateVersions::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListTemplateVersionsOutput`](crate::output::ListTemplateVersionsOutput) with field(s):
    ///   - [`template_version_summary_list(Option<Vec<TemplateVersionSummary>>)`](crate::output::ListTemplateVersionsOutput::template_version_summary_list): <p>A structure containing a list of all the versions of the specified template.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTemplateVersionsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::ListTemplateVersionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListTemplateVersionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListTemplateVersionsError>`](crate::error::ListTemplateVersionsError)
    pub fn list_template_versions(&self) -> fluent_builders::ListTemplateVersions<C, M, R> {
        fluent_builders::ListTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThemeAliases`](crate::client::fluent_builders::ListThemeAliases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListThemeAliases::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListThemeAliases::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme aliases that you're listing.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::ListThemeAliases::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::ListThemeAliases::set_theme_id): <p>The ID for the theme.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThemeAliases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThemeAliases::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThemeAliases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThemeAliases::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListThemeAliasesOutput`](crate::output::ListThemeAliasesOutput) with field(s):
    ///   - [`theme_alias_list(Option<Vec<ThemeAlias>>)`](crate::output::ListThemeAliasesOutput::theme_alias_list): <p>A structure containing the list of the theme's aliases.</p>
    ///   - [`status(i32)`](crate::output::ListThemeAliasesOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListThemeAliasesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThemeAliasesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListThemeAliasesError>`](crate::error::ListThemeAliasesError)
    pub fn list_theme_aliases(&self) -> fluent_builders::ListThemeAliases<C, M, R> {
        fluent_builders::ListThemeAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThemes`](crate::client::fluent_builders::ListThemes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThemes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListThemes::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListThemes::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThemes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThemes::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThemes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThemes::set_max_results): <p>The maximum number of results to be returned per request.</p>
    ///   - [`r#type(ThemeType)`](crate::client::fluent_builders::ListThemes::r#type) / [`set_type(Option<ThemeType>)`](crate::client::fluent_builders::ListThemes::set_type): <p>The type of themes that you want to list. Valid options include the following:</p>  <ul>   <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li>   <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li>   <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p> </li>  </ul>
    /// - On success, responds with [`ListThemesOutput`](crate::output::ListThemesOutput) with field(s):
    ///   - [`theme_summary_list(Option<Vec<ThemeSummary>>)`](crate::output::ListThemesOutput::theme_summary_list): <p>Information about the themes in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThemesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::ListThemesOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListThemesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListThemesError>`](crate::error::ListThemesError)
    pub fn list_themes(&self) -> fluent_builders::ListThemes<C, M, R> {
        fluent_builders::ListThemes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThemeVersions`](crate::client::fluent_builders::ListThemeVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThemeVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListThemeVersions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListThemeVersions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::ListThemeVersions::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::ListThemeVersions::set_theme_id): <p>The ID for the theme.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThemeVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThemeVersions::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThemeVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThemeVersions::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListThemeVersionsOutput`](crate::output::ListThemeVersionsOutput) with field(s):
    ///   - [`theme_version_summary_list(Option<Vec<ThemeVersionSummary>>)`](crate::output::ListThemeVersionsOutput::theme_version_summary_list): <p>A structure containing a list of all the versions of the specified theme.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThemeVersionsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::ListThemeVersionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListThemeVersionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<ListThemeVersionsError>`](crate::error::ListThemeVersionsError)
    pub fn list_theme_versions(&self) -> fluent_builders::ListThemeVersions<C, M, R> {
        fluent_builders::ListThemeVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUserGroups`](crate::client::fluent_builders::ListUserGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::ListUserGroups::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::ListUserGroups::set_user_name): <p>The Amazon QuickSight user name that you want to list group memberships for.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListUserGroups::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListUserGroups::set_aws_account_id): <p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListUserGroups::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListUserGroups::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUserGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUserGroups::set_next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUserGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUserGroups::set_max_results): <p>The maximum number of results to return from this request.</p>
    /// - On success, responds with [`ListUserGroupsOutput`](crate::output::ListUserGroupsOutput) with field(s):
    ///   - [`group_list(Option<Vec<Group>>)`](crate::output::ListUserGroupsOutput::group_list): <p>The list of groups the user is a member of.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUserGroupsOutput::next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListUserGroupsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListUserGroupsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListUserGroupsError>`](crate::error::ListUserGroupsError)
    pub fn list_user_groups(&self) -> fluent_builders::ListUserGroups<C, M, R> {
        fluent_builders::ListUserGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsers`](crate::client::fluent_builders::ListUsers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::ListUsers::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::ListUsers::set_aws_account_id): <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsers::set_next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUsers::set_max_results): <p>The maximum number of results to return from this request.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListUsers::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListUsers::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`ListUsersOutput`](crate::output::ListUsersOutput) with field(s):
    ///   - [`user_list(Option<Vec<User>>)`](crate::output::ListUsersOutput::user_list): <p>The list of users.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUsersOutput::next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::ListUsersOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::ListUsersOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<ListUsersError>`](crate::error::ListUsersError)
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterUser`](crate::client::fluent_builders::RegisterUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::RegisterUser::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::RegisterUser::set_identity_type): <p>Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:</p>  <ul>   <li> <p> <code>IAM</code>: A user whose identity maps to an existing IAM user or role. </p> </li>   <li> <p> <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight. </p> </li>  </ul>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_email): <p>The email address of the user that you want to register.</p>
    ///   - [`user_role(UserRole)`](crate::client::fluent_builders::RegisterUser::user_role) / [`set_user_role(Option<UserRole>)`](crate::client::fluent_builders::RegisterUser::set_user_role): <p>The Amazon QuickSight role for the user. The user role can be one of the following:</p>  <ul>   <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>   <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>   <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>   <li> <p> <code>RESTRICTED_READER</code>: This role isn't currently available for use.</p> </li>   <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.</p> </li>  </ul>
    ///   - [`iam_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::iam_arn) / [`set_iam_arn(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_iam_arn): <p>The ARN of the IAM user or role that you are registering with Amazon QuickSight. </p>
    ///   - [`session_name(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::session_name) / [`set_session_name(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_session_name): <p>You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>CLI Reference.</i> </p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_aws_account_id): <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_user_name): <p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>
    ///   - [`custom_permissions_name(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::custom_permissions_name) / [`set_custom_permissions_name(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_custom_permissions_name): <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>  <ul>   <li> <p>Create and update data sources</p> </li>   <li> <p>Create and update datasets</p> </li>   <li> <p>Create and update email reports</p> </li>   <li> <p>Subscribe to email reports</p> </li>  </ul>  <p>To add custom permissions to an existing user, use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> instead.</p>  <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>  <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>  <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
    ///   - [`external_login_federation_provider_type(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::external_login_federation_provider_type) / [`set_external_login_federation_provider_type(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_external_login_federation_provider_type): <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>  <ul>   <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>   <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>  </ul>
    ///   - [`custom_federation_provider_url(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::custom_federation_provider_url) / [`set_custom_federation_provider_url(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_custom_federation_provider_url): <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
    ///   - [`external_login_id(impl Into<String>)`](crate::client::fluent_builders::RegisterUser::external_login_id) / [`set_external_login_id(Option<String>)`](crate::client::fluent_builders::RegisterUser::set_external_login_id): <p>The identity ID for a user in the external login provider.</p>
    /// - On success, responds with [`RegisterUserOutput`](crate::output::RegisterUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::RegisterUserOutput::user): <p>The user's user name.</p>
    ///   - [`user_invitation_url(Option<String>)`](crate::output::RegisterUserOutput::user_invitation_url): <p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>
    ///   - [`request_id(Option<String>)`](crate::output::RegisterUserOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::RegisterUserOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<RegisterUserError>`](crate::error::RegisterUserError)
    pub fn register_user(&self) -> fluent_builders::RegisterUser<C, M, R> {
        fluent_builders::RegisterUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreAnalysis`](crate::client::fluent_builders::RestoreAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::RestoreAnalysis::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::RestoreAnalysis::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the analysis.</p>
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::RestoreAnalysis::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::RestoreAnalysis::set_analysis_id): <p>The ID of the analysis that you're restoring.</p>
    /// - On success, responds with [`RestoreAnalysisOutput`](crate::output::RestoreAnalysisOutput) with field(s):
    ///   - [`status(i32)`](crate::output::RestoreAnalysisOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`arn(Option<String>)`](crate::output::RestoreAnalysisOutput::arn): <p>The Amazon Resource Name (ARN) of the analysis that you're restoring.</p>
    ///   - [`analysis_id(Option<String>)`](crate::output::RestoreAnalysisOutput::analysis_id): <p>The ID of the analysis that you're restoring. </p>
    ///   - [`request_id(Option<String>)`](crate::output::RestoreAnalysisOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<RestoreAnalysisError>`](crate::error::RestoreAnalysisError)
    pub fn restore_analysis(&self) -> fluent_builders::RestoreAnalysis<C, M, R> {
        fluent_builders::RestoreAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchAnalyses`](crate::client::fluent_builders::SearchAnalyses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchAnalyses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::SearchAnalyses::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::SearchAnalyses::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the analyses that you're searching for.</p>
    ///   - [`filters(Vec<AnalysisSearchFilter>)`](crate::client::fluent_builders::SearchAnalyses::filters) / [`set_filters(Option<Vec<AnalysisSearchFilter>>)`](crate::client::fluent_builders::SearchAnalyses::set_filters): <p>The structure for the search filters that you want to apply to your search. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchAnalyses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchAnalyses::set_next_token): <p>A pagination token that can be used in a subsequent request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchAnalyses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchAnalyses::set_max_results): <p>The maximum number of results to return.</p>
    /// - On success, responds with [`SearchAnalysesOutput`](crate::output::SearchAnalysesOutput) with field(s):
    ///   - [`analysis_summary_list(Option<Vec<AnalysisSummary>>)`](crate::output::SearchAnalysesOutput::analysis_summary_list): <p>Metadata describing the analyses that you searched for.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchAnalysesOutput::next_token): <p>A pagination token that can be used in a subsequent request. </p>
    ///   - [`status(i32)`](crate::output::SearchAnalysesOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::SearchAnalysesOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<SearchAnalysesError>`](crate::error::SearchAnalysesError)
    pub fn search_analyses(&self) -> fluent_builders::SearchAnalyses<C, M, R> {
        fluent_builders::SearchAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchDashboards`](crate::client::fluent_builders::SearchDashboards) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchDashboards::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::SearchDashboards::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::SearchDashboards::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the user whose dashboards you're searching for. </p>
    ///   - [`filters(Vec<DashboardSearchFilter>)`](crate::client::fluent_builders::SearchDashboards::filters) / [`set_filters(Option<Vec<DashboardSearchFilter>>)`](crate::client::fluent_builders::SearchDashboards::set_filters): <p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchDashboards::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchDashboards::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchDashboards::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchDashboards::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`SearchDashboardsOutput`](crate::output::SearchDashboardsOutput) with field(s):
    ///   - [`dashboard_summary_list(Option<Vec<DashboardSummary>>)`](crate::output::SearchDashboardsOutput::dashboard_summary_list): <p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchDashboardsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`status(i32)`](crate::output::SearchDashboardsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::SearchDashboardsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<SearchDashboardsError>`](crate::error::SearchDashboardsError)
    pub fn search_dashboards(&self) -> fluent_builders::SearchDashboards<C, M, R> {
        fluent_builders::SearchDashboards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchFolders`](crate::client::fluent_builders::SearchFolders) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::SearchFolders::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::SearchFolders::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder.</p>
    ///   - [`filters(Vec<FolderSearchFilter>)`](crate::client::fluent_builders::SearchFolders::filters) / [`set_filters(Option<Vec<FolderSearchFilter>>)`](crate::client::fluent_builders::SearchFolders::set_filters): <p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchFolders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchFolders::set_next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchFolders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchFolders::set_max_results): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`SearchFoldersOutput`](crate::output::SearchFoldersOutput) with field(s):
    ///   - [`status(i32)`](crate::output::SearchFoldersOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`folder_summary_list(Option<Vec<FolderSummary>>)`](crate::output::SearchFoldersOutput::folder_summary_list): <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchFoldersOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`request_id(Option<String>)`](crate::output::SearchFoldersOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<SearchFoldersError>`](crate::error::SearchFoldersError)
    pub fn search_folders(&self) -> fluent_builders::SearchFolders<C, M, R> {
        fluent_builders::SearchFolders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::TagResourceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::TagResourceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::UntagResourceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UntagResourceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccountCustomization`](crate::client::fluent_builders::UpdateAccountCustomization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAccountCustomization::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateAccountCustomization::set_aws_account_id): <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::UpdateAccountCustomization::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::UpdateAccountCustomization::set_namespace): <p>The namespace that you want to update Amazon QuickSight customizations for.</p>
    ///   - [`account_customization(AccountCustomization)`](crate::client::fluent_builders::UpdateAccountCustomization::account_customization) / [`set_account_customization(Option<AccountCustomization>)`](crate::client::fluent_builders::UpdateAccountCustomization::set_account_customization): <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
    /// - On success, responds with [`UpdateAccountCustomizationOutput`](crate::output::UpdateAccountCustomizationOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateAccountCustomizationOutput::arn): <p>The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.</p>
    ///   - [`aws_account_id(Option<String>)`](crate::output::UpdateAccountCustomizationOutput::aws_account_id): <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
    ///   - [`namespace(Option<String>)`](crate::output::UpdateAccountCustomizationOutput::namespace): <p>The namespace associated with the customization that you're updating.</p>
    ///   - [`account_customization(Option<AccountCustomization>)`](crate::output::UpdateAccountCustomizationOutput::account_customization): <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateAccountCustomizationOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateAccountCustomizationOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateAccountCustomizationError>`](crate::error::UpdateAccountCustomizationError)
    pub fn update_account_customization(
        &self,
    ) -> fluent_builders::UpdateAccountCustomization<C, M, R> {
        fluent_builders::UpdateAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccountSettings`](crate::client::fluent_builders::UpdateAccountSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAccountSettings::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateAccountSettings::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.</p>
    ///   - [`default_namespace(impl Into<String>)`](crate::client::fluent_builders::UpdateAccountSettings::default_namespace) / [`set_default_namespace(Option<String>)`](crate::client::fluent_builders::UpdateAccountSettings::set_default_namespace): <p>The default namespace for this Amazon Web Services account. Currently, the default is <code>default</code>. Identity and Access Management (IAM) users that register for the first time with Amazon QuickSight provide an email that becomes associated with the default namespace.</p>
    ///   - [`notification_email(impl Into<String>)`](crate::client::fluent_builders::UpdateAccountSettings::notification_email) / [`set_notification_email(Option<String>)`](crate::client::fluent_builders::UpdateAccountSettings::set_notification_email): <p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>
    /// - On success, responds with [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::UpdateAccountSettingsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateAccountSettingsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateAccountSettingsError>`](crate::error::UpdateAccountSettingsError)
    pub fn update_account_settings(&self) -> fluent_builders::UpdateAccountSettings<C, M, R> {
        fluent_builders::UpdateAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAnalysis`](crate::client::fluent_builders::UpdateAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAnalysis::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateAnalysis::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the analysis that you're updating.</p>
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAnalysis::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::UpdateAnalysis::set_analysis_id): <p>The ID for the analysis that you're updating. This ID displays in the URL of the analysis.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAnalysis::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAnalysis::set_name): <p>A descriptive name for the analysis that you're updating. This name displays for the analysis in the Amazon QuickSight console.</p>
    ///   - [`parameters(Parameters)`](crate::client::fluent_builders::UpdateAnalysis::parameters) / [`set_parameters(Option<Parameters>)`](crate::client::fluent_builders::UpdateAnalysis::set_parameters): <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
    ///   - [`source_entity(AnalysisSourceEntity)`](crate::client::fluent_builders::UpdateAnalysis::source_entity) / [`set_source_entity(Option<AnalysisSourceEntity>)`](crate::client::fluent_builders::UpdateAnalysis::set_source_entity): <p>A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.</p>
    ///   - [`theme_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAnalysis::theme_arn) / [`set_theme_arn(Option<String>)`](crate::client::fluent_builders::UpdateAnalysis::set_theme_arn): <p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
    /// - On success, responds with [`UpdateAnalysisOutput`](crate::output::UpdateAnalysisOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateAnalysisOutput::arn): <p>The ARN of the analysis that you're updating.</p>
    ///   - [`analysis_id(Option<String>)`](crate::output::UpdateAnalysisOutput::analysis_id): <p>The ID of the analysis.</p>
    ///   - [`update_status(Option<ResourceStatus>)`](crate::output::UpdateAnalysisOutput::update_status): <p>The update status of the last update that was made to the analysis.</p>
    ///   - [`status(i32)`](crate::output::UpdateAnalysisOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateAnalysisOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateAnalysisError>`](crate::error::UpdateAnalysisError)
    pub fn update_analysis(&self) -> fluent_builders::UpdateAnalysis<C, M, R> {
        fluent_builders::UpdateAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAnalysisPermissions`](crate::client::fluent_builders::UpdateAnalysisPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're updating. You must be using the Amazon Web Services account that the analysis is in.</p>
    ///   - [`analysis_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::analysis_id) / [`set_analysis_id(Option<String>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::set_analysis_id): <p>The ID of the analysis whose permissions you're updating. The ID is part of the analysis URL.</p>
    ///   - [`grant_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::grant_permissions) / [`set_grant_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::set_grant_permissions): <p>A structure that describes the permissions to add and the principal to add them to.</p>
    ///   - [`revoke_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::revoke_permissions) / [`set_revoke_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateAnalysisPermissions::set_revoke_permissions): <p>A structure that describes the permissions to remove and the principal to remove them from.</p>
    /// - On success, responds with [`UpdateAnalysisPermissionsOutput`](crate::output::UpdateAnalysisPermissionsOutput) with field(s):
    ///   - [`analysis_arn(Option<String>)`](crate::output::UpdateAnalysisPermissionsOutput::analysis_arn): <p>The Amazon Resource Name (ARN) of the analysis that you updated.</p>
    ///   - [`analysis_id(Option<String>)`](crate::output::UpdateAnalysisPermissionsOutput::analysis_id): <p>The ID of the analysis that you updated permissions for.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::UpdateAnalysisPermissionsOutput::permissions): <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateAnalysisPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateAnalysisPermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateAnalysisPermissionsError>`](crate::error::UpdateAnalysisPermissionsError)
    pub fn update_analysis_permissions(
        &self,
    ) -> fluent_builders::UpdateAnalysisPermissions<C, M, R> {
        fluent_builders::UpdateAnalysisPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDashboard`](crate::client::fluent_builders::UpdateDashboard) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_name): <p>The display name of the dashboard.</p>
    ///   - [`source_entity(DashboardSourceEntity)`](crate::client::fluent_builders::UpdateDashboard::source_entity) / [`set_source_entity(Option<DashboardSourceEntity>)`](crate::client::fluent_builders::UpdateDashboard::set_source_entity): <p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>  <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
    ///   - [`parameters(Parameters)`](crate::client::fluent_builders::UpdateDashboard::parameters) / [`set_parameters(Option<Parameters>)`](crate::client::fluent_builders::UpdateDashboard::set_parameters): <p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_version_description): <p>A description for the first version of the dashboard being created.</p>
    ///   - [`dashboard_publish_options(DashboardPublishOptions)`](crate::client::fluent_builders::UpdateDashboard::dashboard_publish_options) / [`set_dashboard_publish_options(Option<DashboardPublishOptions>)`](crate::client::fluent_builders::UpdateDashboard::set_dashboard_publish_options): <p>Options for publishing the dashboard when you create it:</p>  <ul>   <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>   <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>   <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>  </ul>
    ///   - [`theme_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboard::theme_arn) / [`set_theme_arn(Option<String>)`](crate::client::fluent_builders::UpdateDashboard::set_theme_arn): <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
    /// - On success, responds with [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateDashboardOutput::arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`version_arn(Option<String>)`](crate::output::UpdateDashboardOutput::version_arn): <p>The ARN of the dashboard, including the version number.</p>
    ///   - [`dashboard_id(Option<String>)`](crate::output::UpdateDashboardOutput::dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::UpdateDashboardOutput::creation_status): <p>The creation status of the request.</p>
    ///   - [`status(i32)`](crate::output::UpdateDashboardOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDashboardOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateDashboardError>`](crate::error::UpdateDashboardError)
    pub fn update_dashboard(&self) -> fluent_builders::UpdateDashboard<C, M, R> {
        fluent_builders::UpdateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDashboardPermissions`](crate::client::fluent_builders::UpdateDashboardPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboardPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateDashboardPermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboardPermissions::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::UpdateDashboardPermissions::set_dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`grant_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDashboardPermissions::grant_permissions) / [`set_grant_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDashboardPermissions::set_grant_permissions): <p>The permissions that you want to grant on this resource.</p>
    ///   - [`revoke_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDashboardPermissions::revoke_permissions) / [`set_revoke_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDashboardPermissions::set_revoke_permissions): <p>The permissions that you want to revoke from this resource.</p>
    ///   - [`grant_link_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDashboardPermissions::grant_link_permissions) / [`set_grant_link_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDashboardPermissions::set_grant_link_permissions): <p>Grants link permissions to all users in a defined namespace.</p>
    ///   - [`revoke_link_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDashboardPermissions::revoke_link_permissions) / [`set_revoke_link_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDashboardPermissions::set_revoke_link_permissions): <p>Revokes link permissions from all users in a defined namespace.</p>
    /// - On success, responds with [`UpdateDashboardPermissionsOutput`](crate::output::UpdateDashboardPermissionsOutput) with field(s):
    ///   - [`dashboard_arn(Option<String>)`](crate::output::UpdateDashboardPermissionsOutput::dashboard_arn): <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    ///   - [`dashboard_id(Option<String>)`](crate::output::UpdateDashboardPermissionsOutput::dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::UpdateDashboardPermissionsOutput::permissions): <p>Information about the permissions on the dashboard.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDashboardPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateDashboardPermissionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`link_sharing_configuration(Option<LinkSharingConfiguration>)`](crate::output::UpdateDashboardPermissionsOutput::link_sharing_configuration): <p>Updates the permissions of a shared link to an Amazon QuickSight dashboard.</p>
    /// - On failure, responds with [`SdkError<UpdateDashboardPermissionsError>`](crate::error::UpdateDashboardPermissionsError)
    pub fn update_dashboard_permissions(
        &self,
    ) -> fluent_builders::UpdateDashboardPermissions<C, M, R> {
        fluent_builders::UpdateDashboardPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDashboardPublishedVersion`](crate::client::fluent_builders::UpdateDashboardPublishedVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboardPublishedVersion::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateDashboardPublishedVersion::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
    ///   - [`dashboard_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDashboardPublishedVersion::dashboard_id) / [`set_dashboard_id(Option<String>)`](crate::client::fluent_builders::UpdateDashboardPublishedVersion::set_dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::UpdateDashboardPublishedVersion::version_number) / [`set_version_number(Option<i64>)`](crate::client::fluent_builders::UpdateDashboardPublishedVersion::set_version_number): <p>The version number of the dashboard.</p>
    /// - On success, responds with [`UpdateDashboardPublishedVersionOutput`](crate::output::UpdateDashboardPublishedVersionOutput) with field(s):
    ///   - [`dashboard_id(Option<String>)`](crate::output::UpdateDashboardPublishedVersionOutput::dashboard_id): <p>The ID for the dashboard.</p>
    ///   - [`dashboard_arn(Option<String>)`](crate::output::UpdateDashboardPublishedVersionOutput::dashboard_arn): <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    ///   - [`status(i32)`](crate::output::UpdateDashboardPublishedVersionOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDashboardPublishedVersionOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateDashboardPublishedVersionError>`](crate::error::UpdateDashboardPublishedVersionError)
    pub fn update_dashboard_published_version(
        &self,
    ) -> fluent_builders::UpdateDashboardPublishedVersion<C, M, R> {
        fluent_builders::UpdateDashboardPublishedVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataSet`](crate::client::fluent_builders::UpdateDataSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSet::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSet::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSet::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSet::set_data_set_id): <p>The ID for the dataset that you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDataSet::set_name): <p>The display name for the dataset.</p>
    ///   - [`physical_table_map(HashMap<String, PhysicalTable>)`](crate::client::fluent_builders::UpdateDataSet::physical_table_map) / [`set_physical_table_map(Option<HashMap<String, PhysicalTable>>)`](crate::client::fluent_builders::UpdateDataSet::set_physical_table_map): <p>Declares the physical tables that are available in the underlying data sources.</p>
    ///   - [`logical_table_map(HashMap<String, LogicalTable>)`](crate::client::fluent_builders::UpdateDataSet::logical_table_map) / [`set_logical_table_map(Option<HashMap<String, LogicalTable>>)`](crate::client::fluent_builders::UpdateDataSet::set_logical_table_map): <p>Configures the combination and transformation of the data from the physical tables.</p>
    ///   - [`import_mode(DataSetImportMode)`](crate::client::fluent_builders::UpdateDataSet::import_mode) / [`set_import_mode(Option<DataSetImportMode>)`](crate::client::fluent_builders::UpdateDataSet::set_import_mode): <p>Indicates whether you want to import the data into SPICE.</p>
    ///   - [`column_groups(Vec<ColumnGroup>)`](crate::client::fluent_builders::UpdateDataSet::column_groups) / [`set_column_groups(Option<Vec<ColumnGroup>>)`](crate::client::fluent_builders::UpdateDataSet::set_column_groups): <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
    ///   - [`field_folders(HashMap<String, FieldFolder>)`](crate::client::fluent_builders::UpdateDataSet::field_folders) / [`set_field_folders(Option<HashMap<String, FieldFolder>>)`](crate::client::fluent_builders::UpdateDataSet::set_field_folders): <p>The folder that contains fields and nested subfolders for your dataset.</p>
    ///   - [`row_level_permission_data_set(RowLevelPermissionDataSet)`](crate::client::fluent_builders::UpdateDataSet::row_level_permission_data_set) / [`set_row_level_permission_data_set(Option<RowLevelPermissionDataSet>)`](crate::client::fluent_builders::UpdateDataSet::set_row_level_permission_data_set): <p>The row-level security configuration for the data you want to create.</p>
    ///   - [`row_level_permission_tag_configuration(RowLevelPermissionTagConfiguration)`](crate::client::fluent_builders::UpdateDataSet::row_level_permission_tag_configuration) / [`set_row_level_permission_tag_configuration(Option<RowLevelPermissionTagConfiguration>)`](crate::client::fluent_builders::UpdateDataSet::set_row_level_permission_tag_configuration): <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
    ///   - [`column_level_permission_rules(Vec<ColumnLevelPermissionRule>)`](crate::client::fluent_builders::UpdateDataSet::column_level_permission_rules) / [`set_column_level_permission_rules(Option<Vec<ColumnLevelPermissionRule>>)`](crate::client::fluent_builders::UpdateDataSet::set_column_level_permission_rules): <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
    ///   - [`data_set_usage_configuration(DataSetUsageConfiguration)`](crate::client::fluent_builders::UpdateDataSet::data_set_usage_configuration) / [`set_data_set_usage_configuration(Option<DataSetUsageConfiguration>)`](crate::client::fluent_builders::UpdateDataSet::set_data_set_usage_configuration): <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
    /// - On success, responds with [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateDataSetOutput::arn): <p>The Amazon Resource Name (ARN) of the dataset.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::UpdateDataSetOutput::data_set_id): <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`ingestion_arn(Option<String>)`](crate::output::UpdateDataSetOutput::ingestion_arn): <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    ///   - [`ingestion_id(Option<String>)`](crate::output::UpdateDataSetOutput::ingestion_id): <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDataSetOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateDataSetOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateDataSetError>`](crate::error::UpdateDataSetError)
    pub fn update_data_set(&self) -> fluent_builders::UpdateDataSet<C, M, R> {
        fluent_builders::UpdateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataSetPermissions`](crate::client::fluent_builders::UpdateDataSetPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSetPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSetPermissions::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSetPermissions::data_set_id) / [`set_data_set_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSetPermissions::set_data_set_id): <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`grant_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDataSetPermissions::grant_permissions) / [`set_grant_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDataSetPermissions::set_grant_permissions): <p>The resource permissions that you want to grant to the dataset.</p>
    ///   - [`revoke_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDataSetPermissions::revoke_permissions) / [`set_revoke_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDataSetPermissions::set_revoke_permissions): <p>The resource permissions that you want to revoke from the dataset.</p>
    /// - On success, responds with [`UpdateDataSetPermissionsOutput`](crate::output::UpdateDataSetPermissionsOutput) with field(s):
    ///   - [`data_set_arn(Option<String>)`](crate::output::UpdateDataSetPermissionsOutput::data_set_arn): <p>The Amazon Resource Name (ARN) of the dataset.</p>
    ///   - [`data_set_id(Option<String>)`](crate::output::UpdateDataSetPermissionsOutput::data_set_id): <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDataSetPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateDataSetPermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateDataSetPermissionsError>`](crate::error::UpdateDataSetPermissionsError)
    pub fn update_data_set_permissions(
        &self,
    ) -> fluent_builders::UpdateDataSetPermissions<C, M, R> {
        fluent_builders::UpdateDataSetPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataSource`](crate::client::fluent_builders::UpdateDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_name): <p>A display name for the data source.</p>
    ///   - [`data_source_parameters(DataSourceParameters)`](crate::client::fluent_builders::UpdateDataSource::data_source_parameters) / [`set_data_source_parameters(Option<DataSourceParameters>)`](crate::client::fluent_builders::UpdateDataSource::set_data_source_parameters): <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
    ///   - [`credentials(DataSourceCredentials)`](crate::client::fluent_builders::UpdateDataSource::credentials) / [`set_credentials(Option<DataSourceCredentials>)`](crate::client::fluent_builders::UpdateDataSource::set_credentials): <p>The credentials that Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
    ///   - [`vpc_connection_properties(VpcConnectionProperties)`](crate::client::fluent_builders::UpdateDataSource::vpc_connection_properties) / [`set_vpc_connection_properties(Option<VpcConnectionProperties>)`](crate::client::fluent_builders::UpdateDataSource::set_vpc_connection_properties): <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
    ///   - [`ssl_properties(SslProperties)`](crate::client::fluent_builders::UpdateDataSource::ssl_properties) / [`set_ssl_properties(Option<SslProperties>)`](crate::client::fluent_builders::UpdateDataSource::set_ssl_properties): <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
    /// - On success, responds with [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateDataSourceOutput::arn): <p>The Amazon Resource Name (ARN) of the data source.</p>
    ///   - [`data_source_id(Option<String>)`](crate::output::UpdateDataSourceOutput::data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`update_status(Option<ResourceStatus>)`](crate::output::UpdateDataSourceOutput::update_status): <p>The update status of the data source's last update.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDataSourceOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateDataSourceOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateDataSourceError>`](crate::error::UpdateDataSourceError)
    pub fn update_data_source(&self) -> fluent_builders::UpdateDataSource<C, M, R> {
        fluent_builders::UpdateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataSourcePermissions`](crate::client::fluent_builders::UpdateDataSourcePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::set_data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
    ///   - [`grant_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::grant_permissions) / [`set_grant_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::set_grant_permissions): <p>A list of resource permissions that you want to grant on the data source.</p>
    ///   - [`revoke_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::revoke_permissions) / [`set_revoke_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateDataSourcePermissions::set_revoke_permissions): <p>A list of resource permissions that you want to revoke on the data source.</p>
    /// - On success, responds with [`UpdateDataSourcePermissionsOutput`](crate::output::UpdateDataSourcePermissionsOutput) with field(s):
    ///   - [`data_source_arn(Option<String>)`](crate::output::UpdateDataSourcePermissionsOutput::data_source_arn): <p>The Amazon Resource Name (ARN) of the data source.</p>
    ///   - [`data_source_id(Option<String>)`](crate::output::UpdateDataSourcePermissionsOutput::data_source_id): <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDataSourcePermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateDataSourcePermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateDataSourcePermissionsError>`](crate::error::UpdateDataSourcePermissionsError)
    pub fn update_data_source_permissions(
        &self,
    ) -> fluent_builders::UpdateDataSourcePermissions<C, M, R> {
        fluent_builders::UpdateDataSourcePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFolder`](crate::client::fluent_builders::UpdateFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFolder::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateFolder::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder to update.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFolder::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::UpdateFolder::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFolder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFolder::set_name): <p>The name of the folder.</p>
    /// - On success, responds with [`UpdateFolderOutput`](crate::output::UpdateFolderOutput) with field(s):
    ///   - [`status(i32)`](crate::output::UpdateFolderOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateFolderOutput::arn): <p>The Amazon Resource Name (ARN) of the folder.</p>
    ///   - [`folder_id(Option<String>)`](crate::output::UpdateFolderOutput::folder_id): <p>The ID of the folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateFolderOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateFolderError>`](crate::error::UpdateFolderError)
    pub fn update_folder(&self) -> fluent_builders::UpdateFolder<C, M, R> {
        fluent_builders::UpdateFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFolderPermissions`](crate::client::fluent_builders::UpdateFolderPermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFolderPermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateFolderPermissions::set_aws_account_id): <p>The ID for the Amazon Web Services account that contains the folder to update.</p>
    ///   - [`folder_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFolderPermissions::folder_id) / [`set_folder_id(Option<String>)`](crate::client::fluent_builders::UpdateFolderPermissions::set_folder_id): <p>The ID of the folder.</p>
    ///   - [`grant_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateFolderPermissions::grant_permissions) / [`set_grant_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateFolderPermissions::set_grant_permissions): <p>The permissions that you want to grant on a resource.</p>
    ///   - [`revoke_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateFolderPermissions::revoke_permissions) / [`set_revoke_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateFolderPermissions::set_revoke_permissions): <p>The permissions that you want to revoke from a resource.</p>
    /// - On success, responds with [`UpdateFolderPermissionsOutput`](crate::output::UpdateFolderPermissionsOutput) with field(s):
    ///   - [`status(i32)`](crate::output::UpdateFolderPermissionsOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateFolderPermissionsOutput::arn): <p>The Amazon Resource Name (ARN) of the folder.</p>
    ///   - [`folder_id(Option<String>)`](crate::output::UpdateFolderPermissionsOutput::folder_id): <p>The ID of the folder.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::UpdateFolderPermissionsOutput::permissions): <p>Information about the permissions for the folder.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateFolderPermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateFolderPermissionsError>`](crate::error::UpdateFolderPermissionsError)
    pub fn update_folder_permissions(&self) -> fluent_builders::UpdateFolderPermissions<C, M, R> {
        fluent_builders::UpdateFolderPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_group_name): <p>The name of the group that you want to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_description): <p>The description for the group that you want to update.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_aws_account_id): <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    /// - On success, responds with [`UpdateGroupOutput`](crate::output::UpdateGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::UpdateGroupOutput::group): <p>The name of the group.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateGroupOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateGroupOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateGroupError>`](crate::error::UpdateGroupError)
    pub fn update_group(&self) -> fluent_builders::UpdateGroup<C, M, R> {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIAMPolicyAssignment`](crate::client::fluent_builders::UpdateIAMPolicyAssignment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the IAM policy assignment. </p>
    ///   - [`assignment_name(impl Into<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::assignment_name) / [`set_assignment_name(Option<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::set_assignment_name): <p>The name of the assignment, also called a rule. This name must be unique within an Amazon Web Services account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::set_namespace): <p>The namespace of the assignment.</p>
    ///   - [`assignment_status(AssignmentStatus)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::assignment_status) / [`set_assignment_status(Option<AssignmentStatus>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::set_assignment_status): <p>The status of the assignment. Possible values are as follows:</p>  <ul>   <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>   <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>   <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>  </ul>
    ///   - [`policy_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::policy_arn) / [`set_policy_arn(Option<String>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::set_policy_arn): <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
    ///   - [`identities(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::identities) / [`set_identities(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::UpdateIAMPolicyAssignment::set_identities): <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
    /// - On success, responds with [`UpdateIamPolicyAssignmentOutput`](crate::output::UpdateIamPolicyAssignmentOutput) with field(s):
    ///   - [`assignment_name(Option<String>)`](crate::output::UpdateIamPolicyAssignmentOutput::assignment_name): <p>The name of the assignment or rule.</p>
    ///   - [`assignment_id(Option<String>)`](crate::output::UpdateIamPolicyAssignmentOutput::assignment_id): <p>The ID of the assignment.</p>
    ///   - [`policy_arn(Option<String>)`](crate::output::UpdateIamPolicyAssignmentOutput::policy_arn): <p>The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.</p>
    ///   - [`identities(Option<HashMap<String, Vec<String>>>)`](crate::output::UpdateIamPolicyAssignmentOutput::identities): <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
    ///   - [`assignment_status(Option<AssignmentStatus>)`](crate::output::UpdateIamPolicyAssignmentOutput::assignment_status): <p>The status of the assignment. Possible values are as follows:</p>  <ul>   <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>   <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>   <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>  </ul>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateIamPolicyAssignmentOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateIamPolicyAssignmentOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateIAMPolicyAssignmentError>`](crate::error::UpdateIAMPolicyAssignmentError)
    pub fn update_iam_policy_assignment(
        &self,
    ) -> fluent_builders::UpdateIAMPolicyAssignment<C, M, R> {
        fluent_builders::UpdateIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIpRestriction`](crate::client::fluent_builders::UpdateIpRestriction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIpRestriction::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateIpRestriction::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    ///   - [`ip_restriction_rule_map(HashMap<String, String>)`](crate::client::fluent_builders::UpdateIpRestriction::ip_restriction_rule_map) / [`set_ip_restriction_rule_map(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateIpRestriction::set_ip_restriction_rule_map): <p>A map that describes the updated IP rules with CIDR ranges and descriptions.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateIpRestriction::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateIpRestriction::set_enabled): <p>A value that specifies whether IP rules are turned on.</p>
    /// - On success, responds with [`UpdateIpRestrictionOutput`](crate::output::UpdateIpRestrictionOutput) with field(s):
    ///   - [`aws_account_id(Option<String>)`](crate::output::UpdateIpRestrictionOutput::aws_account_id): <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateIpRestrictionOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateIpRestrictionOutput::status): <p>The HTTP status of the request. </p>
    /// - On failure, responds with [`SdkError<UpdateIpRestrictionError>`](crate::error::UpdateIpRestrictionError)
    pub fn update_ip_restriction(&self) -> fluent_builders::UpdateIpRestriction<C, M, R> {
        fluent_builders::UpdateIpRestriction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTemplate`](crate::client::fluent_builders::UpdateTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplate::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateTemplate::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template that you're updating.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplate::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::UpdateTemplate::set_template_id): <p>The ID for the template.</p>
    ///   - [`source_entity(TemplateSourceEntity)`](crate::client::fluent_builders::UpdateTemplate::source_entity) / [`set_source_entity(Option<TemplateSourceEntity>)`](crate::client::fluent_builders::UpdateTemplate::set_source_entity): <p>The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p>  <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplate::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::UpdateTemplate::set_version_description): <p>A description of the current template version that is being updated. Every time you call <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplate::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateTemplate::set_name): <p>The name for the template.</p>
    /// - On success, responds with [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput) with field(s):
    ///   - [`template_id(Option<String>)`](crate::output::UpdateTemplateOutput::template_id): <p>The ID for the template.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateTemplateOutput::arn): <p>The Amazon Resource Name (ARN) for the template.</p>
    ///   - [`version_arn(Option<String>)`](crate::output::UpdateTemplateOutput::version_arn): <p>The ARN for the template, including the version information of the first version.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::UpdateTemplateOutput::creation_status): <p>The creation status of the template.</p>
    ///   - [`status(i32)`](crate::output::UpdateTemplateOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateTemplateOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateTemplateError>`](crate::error::UpdateTemplateError)
    pub fn update_template(&self) -> fluent_builders::UpdateTemplate<C, M, R> {
        fluent_builders::UpdateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTemplateAlias`](crate::client::fluent_builders::UpdateTemplateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplateAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateTemplateAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template alias that you're updating.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplateAlias::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::UpdateTemplateAlias::set_template_id): <p>The ID for the template.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplateAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::UpdateTemplateAlias::set_alias_name): <p>The alias of the template that you want to update. If you name a specific alias, you update the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
    ///   - [`template_version_number(i64)`](crate::client::fluent_builders::UpdateTemplateAlias::template_version_number) / [`set_template_version_number(Option<i64>)`](crate::client::fluent_builders::UpdateTemplateAlias::set_template_version_number): <p>The version number of the template.</p>
    /// - On success, responds with [`UpdateTemplateAliasOutput`](crate::output::UpdateTemplateAliasOutput) with field(s):
    ///   - [`template_alias(Option<TemplateAlias>)`](crate::output::UpdateTemplateAliasOutput::template_alias): <p>The template alias.</p>
    ///   - [`status(i32)`](crate::output::UpdateTemplateAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateTemplateAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateTemplateAliasError>`](crate::error::UpdateTemplateAliasError)
    pub fn update_template_alias(&self) -> fluent_builders::UpdateTemplateAlias<C, M, R> {
        fluent_builders::UpdateTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTemplatePermissions`](crate::client::fluent_builders::UpdateTemplatePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplatePermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateTemplatePermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the template.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTemplatePermissions::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::UpdateTemplatePermissions::set_template_id): <p>The ID for the template.</p>
    ///   - [`grant_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateTemplatePermissions::grant_permissions) / [`set_grant_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateTemplatePermissions::set_grant_permissions): <p>A list of resource permissions to be granted on the template. </p>
    ///   - [`revoke_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateTemplatePermissions::revoke_permissions) / [`set_revoke_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateTemplatePermissions::set_revoke_permissions): <p>A list of resource permissions to be revoked from the template. </p>
    /// - On success, responds with [`UpdateTemplatePermissionsOutput`](crate::output::UpdateTemplatePermissionsOutput) with field(s):
    ///   - [`template_id(Option<String>)`](crate::output::UpdateTemplatePermissionsOutput::template_id): <p>The ID for the template.</p>
    ///   - [`template_arn(Option<String>)`](crate::output::UpdateTemplatePermissionsOutput::template_arn): <p>The Amazon Resource Name (ARN) of the template.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::UpdateTemplatePermissionsOutput::permissions): <p>A list of resource permissions to be set on the template.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateTemplatePermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateTemplatePermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateTemplatePermissionsError>`](crate::error::UpdateTemplatePermissionsError)
    pub fn update_template_permissions(
        &self,
    ) -> fluent_builders::UpdateTemplatePermissions<C, M, R> {
        fluent_builders::UpdateTemplatePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTheme`](crate::client::fluent_builders::UpdateTheme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme that you're updating.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_theme_id): <p>The ID for the theme.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_name): <p>The name for the theme.</p>
    ///   - [`base_theme_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::base_theme_id) / [`set_base_theme_id(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_base_theme_id): <p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.</p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::UpdateTheme::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::UpdateTheme::set_version_description): <p>A description of the theme version that you're updating Every time that you call <code>UpdateTheme</code>, you create a new version of the theme. Each version of the theme maintains a description of the version in <code>VersionDescription</code>.</p>
    ///   - [`configuration(ThemeConfiguration)`](crate::client::fluent_builders::UpdateTheme::configuration) / [`set_configuration(Option<ThemeConfiguration>)`](crate::client::fluent_builders::UpdateTheme::set_configuration): <p>The theme configuration, which contains the theme display properties.</p>
    /// - On success, responds with [`UpdateThemeOutput`](crate::output::UpdateThemeOutput) with field(s):
    ///   - [`theme_id(Option<String>)`](crate::output::UpdateThemeOutput::theme_id): <p>The ID for the theme.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateThemeOutput::arn): <p>The Amazon Resource Name (ARN) for the theme.</p>
    ///   - [`version_arn(Option<String>)`](crate::output::UpdateThemeOutput::version_arn): <p>The Amazon Resource Name (ARN) for the new version of the theme.</p>
    ///   - [`creation_status(Option<ResourceStatus>)`](crate::output::UpdateThemeOutput::creation_status): <p>The creation status of the theme.</p>
    ///   - [`status(i32)`](crate::output::UpdateThemeOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateThemeOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateThemeError>`](crate::error::UpdateThemeError)
    pub fn update_theme(&self) -> fluent_builders::UpdateTheme<C, M, R> {
        fluent_builders::UpdateTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateThemeAlias`](crate::client::fluent_builders::UpdateThemeAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateThemeAlias::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateThemeAlias::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme alias that you're updating.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::UpdateThemeAlias::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::UpdateThemeAlias::set_theme_id): <p>The ID for the theme.</p>
    ///   - [`alias_name(impl Into<String>)`](crate::client::fluent_builders::UpdateThemeAlias::alias_name) / [`set_alias_name(Option<String>)`](crate::client::fluent_builders::UpdateThemeAlias::set_alias_name): <p>The name of the theme alias that you want to update.</p>
    ///   - [`theme_version_number(i64)`](crate::client::fluent_builders::UpdateThemeAlias::theme_version_number) / [`set_theme_version_number(Option<i64>)`](crate::client::fluent_builders::UpdateThemeAlias::set_theme_version_number): <p>The version number of the theme that the alias should reference.</p>
    /// - On success, responds with [`UpdateThemeAliasOutput`](crate::output::UpdateThemeAliasOutput) with field(s):
    ///   - [`theme_alias(Option<ThemeAlias>)`](crate::output::UpdateThemeAliasOutput::theme_alias): <p>Information about the theme alias.</p>
    ///   - [`status(i32)`](crate::output::UpdateThemeAliasOutput::status): <p>The HTTP status of the request.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateThemeAliasOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    /// - On failure, responds with [`SdkError<UpdateThemeAliasError>`](crate::error::UpdateThemeAliasError)
    pub fn update_theme_alias(&self) -> fluent_builders::UpdateThemeAlias<C, M, R> {
        fluent_builders::UpdateThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateThemePermissions`](crate::client::fluent_builders::UpdateThemePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateThemePermissions::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateThemePermissions::set_aws_account_id): <p>The ID of the Amazon Web Services account that contains the theme.</p>
    ///   - [`theme_id(impl Into<String>)`](crate::client::fluent_builders::UpdateThemePermissions::theme_id) / [`set_theme_id(Option<String>)`](crate::client::fluent_builders::UpdateThemePermissions::set_theme_id): <p>The ID for the theme.</p>
    ///   - [`grant_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateThemePermissions::grant_permissions) / [`set_grant_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateThemePermissions::set_grant_permissions): <p>A list of resource permissions to be granted for the theme.</p>
    ///   - [`revoke_permissions(Vec<ResourcePermission>)`](crate::client::fluent_builders::UpdateThemePermissions::revoke_permissions) / [`set_revoke_permissions(Option<Vec<ResourcePermission>>)`](crate::client::fluent_builders::UpdateThemePermissions::set_revoke_permissions): <p>A list of resource permissions to be revoked from the theme.</p>
    /// - On success, responds with [`UpdateThemePermissionsOutput`](crate::output::UpdateThemePermissionsOutput) with field(s):
    ///   - [`theme_id(Option<String>)`](crate::output::UpdateThemePermissionsOutput::theme_id): <p>The ID for the theme.</p>
    ///   - [`theme_arn(Option<String>)`](crate::output::UpdateThemePermissionsOutput::theme_arn): <p>The Amazon Resource Name (ARN) of the theme.</p>
    ///   - [`permissions(Option<Vec<ResourcePermission>>)`](crate::output::UpdateThemePermissionsOutput::permissions): <p>The resulting list of resource permissions for the theme.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateThemePermissionsOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateThemePermissionsOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateThemePermissionsError>`](crate::error::UpdateThemePermissionsError)
    pub fn update_theme_permissions(&self) -> fluent_builders::UpdateThemePermissions<C, M, R> {
        fluent_builders::UpdateThemePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUser`](crate::client::fluent_builders::UpdateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_user_name): <p>The Amazon QuickSight user name that you want to update.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_aws_account_id): <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_namespace): <p>The namespace. Currently, you should set this to <code>default</code>.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_email): <p>The email address of the user that you want to update.</p>
    ///   - [`role(UserRole)`](crate::client::fluent_builders::UpdateUser::role) / [`set_role(Option<UserRole>)`](crate::client::fluent_builders::UpdateUser::set_role): <p>The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:</p>  <ul>   <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>   <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>   <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>  </ul>  <p>The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with permissions.</p>
    ///   - [`custom_permissions_name(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::custom_permissions_name) / [`set_custom_permissions_name(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_custom_permissions_name): <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>  <ul>   <li> <p>Create and update data sources</p> </li>   <li> <p>Create and update datasets</p> </li>   <li> <p>Create and update email reports</p> </li>   <li> <p>Subscribe to email reports</p> </li>  </ul>  <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>  <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>  <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
    ///   - [`unapply_custom_permissions(bool)`](crate::client::fluent_builders::UpdateUser::unapply_custom_permissions) / [`set_unapply_custom_permissions(bool)`](crate::client::fluent_builders::UpdateUser::set_unapply_custom_permissions): <p>A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn't accept any other value.</p>
    ///   - [`external_login_federation_provider_type(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::external_login_federation_provider_type) / [`set_external_login_federation_provider_type(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_external_login_federation_provider_type): <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>  <ul>   <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>   <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>   <li> <p> <code>NONE</code>: This clears all the previously saved external login information for a user. Use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code> API operation to check the external login information.</p> </li>  </ul>
    ///   - [`custom_federation_provider_url(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::custom_federation_provider_url) / [`set_custom_federation_provider_url(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_custom_federation_provider_url): <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
    ///   - [`external_login_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::external_login_id) / [`set_external_login_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_external_login_id): <p>The identity ID for a user in the external login provider.</p>
    /// - On success, responds with [`UpdateUserOutput`](crate::output::UpdateUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::UpdateUserOutput::user): <p>The Amazon QuickSight user.</p>
    ///   - [`request_id(Option<String>)`](crate::output::UpdateUserOutput::request_id): <p>The Amazon Web Services request ID for this operation.</p>
    ///   - [`status(i32)`](crate::output::UpdateUserOutput::status): <p>The HTTP status of the request.</p>
    /// - On failure, responds with [`SdkError<UpdateUserError>`](crate::error::UpdateUserError)
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelIngestion`.
    ///
    /// <p>Cancels an ongoing ingestion of data into SPICE.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelIngestion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_ingestion_input::Builder,
    }
    impl<C, M, R> CancelIngestion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelIngestion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelIngestionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelIngestionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelIngestionInputOperationOutputAlias,
                crate::output::CancelIngestionOutput,
                crate::error::CancelIngestionError,
                crate::input::CancelIngestionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingestion_id(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ingestion_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccountCustomization`.
    ///
    /// <p>Creates Amazon QuickSight customizations the current Amazon Web Services Region. Currently, you can add a custom default theme by using the <code>CreateAccountCustomization</code> or <code>UpdateAccountCustomization</code> API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide.</i> </p>
    /// <p>You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation.</p>
    /// <p>Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> </code> API operation. To share the theme, grant permissions by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> </code> API operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_account_customization_input::Builder,
    }
    impl<C, M, R> CreateAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccountCustomizationInputOperationOutputAlias,
                crate::output::CreateAccountCustomizationOutput,
                crate::error::CreateAccountCustomizationError,
                crate::input::CreateAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to add customizations to.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to add customizations to.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. You can add these to an Amazon Web Services account and a QuickSight namespace. </p>
        /// <p>For example, you can add a default theme by setting <code>AccountCustomization</code> to the midnight theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by specifying <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>. </p>
        pub fn account_customization(mut self, input: crate::model::AccountCustomization) -> Self {
            self.inner = self.inner.account_customization(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. You can add these to an Amazon Web Services account and a QuickSight namespace. </p>
        /// <p>For example, you can add a default theme by setting <code>AccountCustomization</code> to the midnight theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by specifying <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.inner = self.inner.set_account_customization(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags that you want to attach to this resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tags that you want to attach to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAnalysis`.
    ///
    /// <p>Creates an analysis in Amazon QuickSight.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_analysis_input::Builder,
    }
    impl<C, M, R> CreateAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAnalysisInputOperationOutputAlias,
                crate::output::CreateAnalysisOutput,
                crate::error::CreateAnalysisError,
                crate::input::CreateAnalysisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you are creating an analysis.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you are creating an analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the analysis that you're creating. This ID displays in the URL of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID for the analysis that you're creating. This ID displays in the URL of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis. You can use the <code>Permissions</code> structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). </p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis. You can use the <code>Permissions</code> structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). </p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn source_entity(mut self, input: crate::model::AnalysisSourceEntity) -> Self {
            self.inner = self.inner.source_entity(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::AnalysisSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(input.into());
            self
        }
        /// <p>The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDashboard`.
    ///
    /// <p>Creates a dashboard from a template. To first create a template, see the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation.</p>
    /// <p>A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dashboard_input::Builder,
    }
    impl<C, M, R> CreateDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDashboardInputOperationOutputAlias,
                crate::output::CreateDashboardOutput,
                crate::error::CreateDashboardError,
                crate::input::CreateDashboardInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN. </p>
        /// <p>To specify no permissions, omit the permissions list.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN. </p>
        /// <p>To specify no permissions, omit the permissions list.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, input: crate::model::DashboardSourceEntity) -> Self {
            self.inner = self.inner.source_entity(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::DashboardSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn dashboard_publish_options(
            mut self,
            input: crate::model::DashboardPublishOptions,
        ) -> Self {
            self.inner = self.inner.dashboard_publish_options(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn set_dashboard_publish_options(
            mut self,
            input: std::option::Option<crate::model::DashboardPublishOptions>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_publish_options(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSet`.
    ///
    /// <p>Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_set_input::Builder,
    }
    impl<C, M, R> CreateDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSetInputOperationOutputAlias,
                crate::output::CreateDataSetOutput,
                crate::error::CreateDataSetError,
                crate::input::CreateDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `PhysicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_physical_table_map`](Self::set_physical_table_map).
        ///
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn physical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PhysicalTable,
        ) -> Self {
            self.inner = self.inner.physical_table_map(k.into(), v);
            self
        }
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn set_physical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_physical_table_map(input);
            self
        }
        /// Adds a key-value pair to `LogicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_logical_table_map`](Self::set_logical_table_map).
        ///
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn logical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::LogicalTable,
        ) -> Self {
            self.inner = self.inner.logical_table_map(k.into(), v);
            self
        }
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn set_logical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logical_table_map(input);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn import_mode(mut self, input: crate::model::DataSetImportMode) -> Self {
            self.inner = self.inner.import_mode(input);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn set_import_mode(
            mut self,
            input: std::option::Option<crate::model::DataSetImportMode>,
        ) -> Self {
            self.inner = self.inner.set_import_mode(input);
            self
        }
        /// Appends an item to `ColumnGroups`.
        ///
        /// To override the contents of this collection use [`set_column_groups`](Self::set_column_groups).
        ///
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn column_groups(mut self, input: crate::model::ColumnGroup) -> Self {
            self.inner = self.inner.column_groups(input);
            self
        }
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn set_column_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        ) -> Self {
            self.inner = self.inner.set_column_groups(input);
            self
        }
        /// Adds a key-value pair to `FieldFolders`.
        ///
        /// To override the contents of this collection use [`set_field_folders`](Self::set_field_folders).
        ///
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn field_folders(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FieldFolder,
        ) -> Self {
            self.inner = self.inner.field_folders(k.into(), v);
            self
        }
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn set_field_folders(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
            >,
        ) -> Self {
            self.inner = self.inner.set_field_folders(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The row-level security configuration for the data that you want to create.</p>
        pub fn row_level_permission_data_set(
            mut self,
            input: crate::model::RowLevelPermissionDataSet,
        ) -> Self {
            self.inner = self.inner.row_level_permission_data_set(input);
            self
        }
        /// <p>The row-level security configuration for the data that you want to create.</p>
        pub fn set_row_level_permission_data_set(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionDataSet>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_data_set(input);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn row_level_permission_tag_configuration(
            mut self,
            input: crate::model::RowLevelPermissionTagConfiguration,
        ) -> Self {
            self.inner = self.inner.row_level_permission_tag_configuration(input);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn set_row_level_permission_tag_configuration(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_tag_configuration(input);
            self
        }
        /// Appends an item to `ColumnLevelPermissionRules`.
        ///
        /// To override the contents of this collection use [`set_column_level_permission_rules`](Self::set_column_level_permission_rules).
        ///
        /// <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
        pub fn column_level_permission_rules(
            mut self,
            input: crate::model::ColumnLevelPermissionRule,
        ) -> Self {
            self.inner = self.inner.column_level_permission_rules(input);
            self
        }
        /// <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
        pub fn set_column_level_permission_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        ) -> Self {
            self.inner = self.inner.set_column_level_permission_rules(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn data_set_usage_configuration(
            mut self,
            input: crate::model::DataSetUsageConfiguration,
        ) -> Self {
            self.inner = self.inner.data_set_usage_configuration(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn set_data_set_usage_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSetUsageConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_set_usage_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSource`.
    ///
    /// <p>Creates a data source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_source_input::Builder,
    }
    impl<C, M, R> CreateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSourceInputOperationOutputAlias,
                crate::output::CreateDataSourceOutput,
                crate::error::CreateDataSourceError,
                crate::input::CreateDataSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the data source. To return a list of all data sources, use <code>ListDataSources</code>.</p>
        /// <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the data source. To return a list of all data sources, use <code>ListDataSources</code>.</p>
        /// <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn data_source_parameters(mut self, input: crate::model::DataSourceParameters) -> Self {
            self.inner = self.inner.data_source_parameters(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn set_data_source_parameters(
            mut self,
            input: std::option::Option<crate::model::DataSourceParameters>,
        ) -> Self {
            self.inner = self.inner.set_data_source_parameters(input);
            self
        }
        /// <p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
        pub fn credentials(mut self, input: crate::model::DataSourceCredentials) -> Self {
            self.inner = self.inner.credentials(input);
            self
        }
        /// <p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::DataSourceCredentials>,
        ) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the data source.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>A list of resource permissions on the data source.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn vpc_connection_properties(
            mut self,
            input: crate::model::VpcConnectionProperties,
        ) -> Self {
            self.inner = self.inner.vpc_connection_properties(input);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn set_vpc_connection_properties(
            mut self,
            input: std::option::Option<crate::model::VpcConnectionProperties>,
        ) -> Self {
            self.inner = self.inner.set_vpc_connection_properties(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn ssl_properties(mut self, input: crate::model::SslProperties) -> Self {
            self.inner = self.inner.ssl_properties(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn set_ssl_properties(
            mut self,
            input: std::option::Option<crate::model::SslProperties>,
        ) -> Self {
            self.inner = self.inner.set_ssl_properties(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFolder`.
    ///
    /// <p>Creates an empty shared folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_folder_input::Builder,
    }
    impl<C, M, R> CreateFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFolderInputOperationOutputAlias,
                crate::output::CreateFolderOutput,
                crate::error::CreateFolderError,
                crate::input::CreateFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account where you want to create the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account where you want to create the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>
        pub fn folder_type(mut self, input: crate::model::FolderType) -> Self {
            self.inner = self.inner.folder_type(input);
            self
        }
        /// <p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>
        pub fn set_folder_type(
            mut self,
            input: std::option::Option<crate::model::FolderType>,
        ) -> Self {
            self.inner = self.inner.set_folder_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the parent folder.</p>
        /// <p> <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>
        pub fn parent_folder_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_folder_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the parent folder.</p>
        /// <p> <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>
        pub fn set_parent_folder_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_folder_arn(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions of a folder.</p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions of a folder.</p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the folder.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags for the folder.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFolderMembership`.
    ///
    /// <p>Adds an asset, such as a dashboard, analysis, or dataset into a folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFolderMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_folder_membership_input::Builder,
    }
    impl<C, M, R> CreateFolderMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFolderMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFolderMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFolderMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFolderMembershipInputOperationOutputAlias,
                crate::output::CreateFolderMembershipOutput,
                crate::error::CreateFolderMembershipError,
                crate::input::CreateFolderMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>
        pub fn member_type(mut self, input: crate::model::MemberType) -> Self {
            self.inner = self.inner.member_type(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.inner = self.inner.set_member_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates an Amazon QuickSight group.</p>
    /// <p>The permissions resource is <code>arn:aws:quicksight:us-east-1:<i>
    /// <relevant-aws-account-id></relevant-aws-account-id></i>:group/default/<i>
    /// <group-name></group-name></i> </code>.</p>
    /// <p>The response is a group object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the group that you want to create.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>A name for the group that you want to create.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>A description for the group that you want to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the group that you want to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroupMembership`.
    ///
    /// <p>Adds an Amazon QuickSight user to an Amazon QuickSight group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGroupMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_membership_input::Builder,
    }
    impl<C, M, R> CreateGroupMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroupMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupMembershipInputOperationOutputAlias,
                crate::output::CreateGroupMembershipOutput,
                crate::error::CreateGroupMembershipError,
                crate::input::CreateGroupMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to add to the group membership.</p>
        pub fn member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_name(input.into());
            self
        }
        /// <p>The name of the user that you want to add to the group membership.</p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_name(input);
            self
        }
        /// <p>The name of the group that you want to add the user to.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group that you want to add the user to.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIAMPolicyAssignment`.
    ///
    /// <p>Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> CreateIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::CreateIamPolicyAssignmentOutput,
                crate::error::CreateIAMPolicyAssignmentError,
                crate::input::CreateIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(input.into());
            self
        }
        /// <p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.inner = self.inner.assignment_status(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_assignment_status(input);
            self
        }
        /// <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Adds a key-value pair to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identities(k.into(), v);
            self
        }
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIngestion`.
    ///
    /// <p>Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.</p>
    /// <p>Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIngestion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ingestion_input::Builder,
    }
    impl<C, M, R> CreateIngestion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIngestion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIngestionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIngestionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIngestionInputOperationOutputAlias,
                crate::output::CreateIngestionOutput,
                crate::error::CreateIngestionError,
                crate::input::CreateIngestionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingestion_id(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ingestion_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The type of ingestion that you want to create.</p>
        pub fn ingestion_type(mut self, input: crate::model::IngestionType) -> Self {
            self.inner = self.inner.ingestion_type(input);
            self
        }
        /// <p>The type of ingestion that you want to create.</p>
        pub fn set_ingestion_type(
            mut self,
            input: std::option::Option<crate::model::IngestionType>,
        ) -> Self {
            self.inner = self.inner.set_ingestion_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNamespace`.
    ///
    /// <p>(Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.</p>
    /// <p>A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web Services Support. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_namespace_input::Builder,
    }
    impl<C, M, R> CreateNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNamespaceInputOperationOutputAlias,
                crate::output::CreateNamespaceOutput,
                crate::error::CreateNamespaceError,
                crate::input::CreateNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name that you want to use to describe the new namespace.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The name that you want to use to describe the new namespace.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn identity_store(mut self, input: crate::model::IdentityStore) -> Self {
            self.inner = self.inner.identity_store(input);
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn set_identity_store(
            mut self,
            input: std::option::Option<crate::model::IdentityStore>,
        ) -> Self {
            self.inner = self.inner.set_identity_store(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to associate with the namespace that you're creating.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags that you want to associate with the namespace that you're creating.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTemplate`.
    ///
    /// <p>Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.</p>
    /// <p>A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_template_input::Builder,
    }
    impl<C, M, R> CreateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTemplateInputOperationOutputAlias,
                crate::output::CreateTemplateOutput,
                crate::error::CreateTemplateError,
                crate::input::CreateTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>A display name for the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A display name for the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, input: crate::model::TemplateSourceEntity) -> Self {
            self.inner = self.inner.source_entity(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::TemplateSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTemplateAlias`.
    ///
    /// <p>Creates a template alias for a template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_template_alias_input::Builder,
    }
    impl<C, M, R> CreateTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTemplateAliasInputOperationOutputAlias,
                crate::output::CreateTemplateAliasOutput,
                crate::error::CreateTemplateAliasError,
                crate::input::CreateTemplateAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>An ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The name that you want to give to the template alias that you're creating. Don't start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The name that you want to give to the template alias that you're creating. Don't start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn template_version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.template_version_number(input);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn set_template_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_template_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTheme`.
    ///
    /// <p>Creates a theme.</p>
    /// <p>A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_theme_input::Builder,
    }
    impl<C, M, R> CreateTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThemeInputOperationOutputAlias,
                crate::output::CreateThemeOutput,
                crate::error::CreateThemeError,
                crate::input::CreateThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to store the new theme. </p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to store the new theme. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>A display name for the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A display name for the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within an analysis. </p>
        pub fn base_theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_theme_id(input.into());
            self
        }
        /// <p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within an analysis. </p>
        pub fn set_base_theme_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_base_theme_id(input);
            self
        }
        /// <p>A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn configuration(mut self, input: crate::model::ThemeConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ThemeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A valid grouping of resource permissions to apply to the new theme. </p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.permissions(input);
            self
        }
        /// <p>A valid grouping of resource permissions to apply to the new theme. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThemeAlias`.
    ///
    /// <p>Creates a theme alias for a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_theme_alias_input::Builder,
    }
    impl<C, M, R> CreateThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThemeAliasInputOperationOutputAlias,
                crate::output::CreateThemeAliasOutput,
                crate::error::CreateThemeAliasError,
                crate::input::CreateThemeAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the theme alias.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>An ID for the theme alias.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name that you want to give to the theme alias that you are creating. The alias name can't begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The name that you want to give to the theme alias that you are creating. The alias name can't begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the theme.</p>
        pub fn theme_version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.theme_version_number(input);
            self
        }
        /// <p>The version number of the theme.</p>
        pub fn set_theme_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_theme_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountCustomization`.
    ///
    /// <p>Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_customization_input::Builder,
    }
    impl<C, M, R> DeleteAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountCustomizationInputOperationOutputAlias,
                crate::output::DeleteAccountCustomizationOutput,
                crate::error::DeleteAccountCustomizationError,
                crate::input::DeleteAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in this Amazon Web Services Region.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in this Amazon Web Services Region.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that you're deleting the customizations from.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that you're deleting the customizations from.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAnalysis`.
    ///
    /// <p>Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.</p>
    /// <p>At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it's deleted, so you can describe it but you can't make a template from it.</p>
    /// <p>An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_analysis_input::Builder,
    }
    impl<C, M, R> DeleteAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAnalysisInputOperationOutputAlias,
                crate::output::DeleteAnalysisOutput,
                crate::error::DeleteAnalysisError,
                crate::input::DeleteAnalysisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis that you're deleting.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID of the analysis that you're deleting.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can't use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is 30.</p>
        pub fn recovery_window_in_days(mut self, input: i64) -> Self {
            self.inner = self.inner.recovery_window_in_days(input);
            self
        }
        /// <p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can't use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is 30.</p>
        pub fn set_recovery_window_in_days(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_recovery_window_in_days(input);
            self
        }
        /// <p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after it's deleted. </p>
        pub fn force_delete_without_recovery(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete_without_recovery(input);
            self
        }
        /// <p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after it's deleted. </p>
        pub fn set_force_delete_without_recovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_delete_without_recovery(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDashboard`.
    ///
    /// <p>Deletes a dashboard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dashboard_input::Builder,
    }
    impl<C, M, R> DeleteDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDashboardInputOperationOutputAlias,
                crate::output::DeleteDashboardOutput,
                crate::error::DeleteDashboardError,
                crate::input::DeleteDashboardInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're deleting.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSet`.
    ///
    /// <p>Deletes a dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_set_input::Builder,
    }
    impl<C, M, R> DeleteDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSetInputOperationOutputAlias,
                crate::output::DeleteDataSetOutput,
                crate::error::DeleteDataSetError,
                crate::input::DeleteDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSource`.
    ///
    /// <p>Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_source_input::Builder,
    }
    impl<C, M, R> DeleteDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSourceInputOperationOutputAlias,
                crate::output::DeleteDataSourceOutput,
                crate::error::DeleteDataSourceError,
                crate::input::DeleteDataSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFolder`.
    ///
    /// <p>Deletes an empty folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_folder_input::Builder,
    }
    impl<C, M, R> DeleteFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFolderInputOperationOutputAlias,
                crate::output::DeleteFolderOutput,
                crate::error::DeleteFolderError,
                crate::input::DeleteFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFolderMembership`.
    ///
    /// <p>Removes an asset, such as a dashboard, analysis, or dataset, from a folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFolderMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_folder_membership_input::Builder,
    }
    impl<C, M, R> DeleteFolderMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFolderMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFolderMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFolderMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFolderMembershipInputOperationOutputAlias,
                crate::output::DeleteFolderMembershipOutput,
                crate::error::DeleteFolderMembershipError,
                crate::input::DeleteFolderMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Folder ID.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The Folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code> </p>
        pub fn member_type(mut self, input: crate::model::MemberType) -> Self {
            self.inner = self.inner.member_type(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code> </p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.inner = self.inner.set_member_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Removes a user group from Amazon QuickSight. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to delete.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group that you want to delete.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroupMembership`.
    ///
    /// <p>Removes a user from a group so that the user is no longer a member of the group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGroupMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_membership_input::Builder,
    }
    impl<C, M, R> DeleteGroupMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroupMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupMembershipInputOperationOutputAlias,
                crate::output::DeleteGroupMembershipOutput,
                crate::error::DeleteGroupMembershipError,
                crate::input::DeleteGroupMembershipInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to delete from the group membership.</p>
        pub fn member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_name(input.into());
            self
        }
        /// <p>The name of the user that you want to delete from the group membership.</p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_name(input);
            self
        }
        /// <p>The name of the group that you want to delete the user from.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group that you want to delete the user from.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIAMPolicyAssignment`.
    ///
    /// <p>Deletes an existing IAM policy assignment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> DeleteIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::DeleteIamPolicyAssignmentOutput,
                crate::error::DeleteIAMPolicyAssignmentError,
                crate::input::DeleteIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID where you want to delete the IAM policy assignment.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID where you want to delete the IAM policy assignment.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment. </p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(input.into());
            self
        }
        /// <p>The name of the assignment. </p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNamespace`.
    ///
    /// <p>Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_namespace_input::Builder,
    }
    impl<C, M, R> DeleteNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNamespaceInputOperationOutputAlias,
                crate::output::DeleteNamespaceOutput,
                crate::error::DeleteNamespaceError,
                crate::input::DeleteNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace that you want to delete.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace that you want to delete.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTemplate`.
    ///
    /// <p>Deletes a template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_template_input::Builder,
    }
    impl<C, M, R> DeleteTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTemplateInputOperationOutputAlias,
                crate::output::DeleteTemplateOutput,
                crate::error::DeleteTemplateError,
                crate::input::DeleteTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're deleting.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the template you want to delete.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>An ID for the template you want to delete.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>Specifies the version of the template that you want to delete. If you don't provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>Specifies the version of the template that you want to delete. If you don't provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTemplateAlias`.
    ///
    /// <p>Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_template_alias_input::Builder,
    }
    impl<C, M, R> DeleteTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTemplateAliasInputOperationOutputAlias,
                crate::output::DeleteTemplateAliasOutput,
                crate::error::DeleteTemplateAliasError,
                crate::input::DeleteTemplateAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the item to delete.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the item to delete.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template that the specified alias is for.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template that the specified alias is for.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTheme`.
    ///
    /// <p>Deletes a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_theme_input::Builder,
    }
    impl<C, M, R> DeleteTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThemeInputOperationOutputAlias,
                crate::output::DeleteThemeOutput,
                crate::error::DeleteThemeError,
                crate::input::DeleteThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're deleting.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the theme that you want to delete.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>An ID for the theme that you want to delete.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The version of the theme that you want to delete. </p>
        /// <p> <b>Note:</b> If you don't provide a version number, you're using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version of the theme that you want to delete. </p>
        /// <p> <b>Note:</b> If you don't provide a version number, you're using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThemeAlias`.
    ///
    /// <p>Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_theme_alias_input::Builder,
    }
    impl<C, M, R> DeleteThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThemeAliasInputOperationOutputAlias,
                crate::output::DeleteThemeAliasOutput,
                crate::error::DeleteThemeAliasError,
                crate::input::DeleteThemeAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme that the specified alias is for.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme that the specified alias is for.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The unique name for the theme alias to delete.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The unique name for the theme alias to delete.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to delete.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user that you want to delete.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserByPrincipalId`.
    ///
    /// <p>Deletes a user identified by its principal ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserByPrincipalId<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_by_principal_id_input::Builder,
    }
    impl<C, M, R> DeleteUserByPrincipalId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserByPrincipalId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserByPrincipalIdOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserByPrincipalIdError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserByPrincipalIdInputOperationOutputAlias,
                crate::output::DeleteUserByPrincipalIdOutput,
                crate::error::DeleteUserByPrincipalIdError,
                crate::input::DeleteUserByPrincipalIdInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The principal ID of the user.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(input.into());
            self
        }
        /// <p>The principal ID of the user.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountCustomization`.
    ///
    /// <p>Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the <code>Resolved</code> flag included. </p>
    /// <p>To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved. </p>
    /// <ul>
    /// <li> <p> <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region. </p> </li>
    /// <li> <p> <code>Amazon Web Services Region</code> - In each Amazon Web Services Region where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace. </p> <p>To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using the CLI, you can use one of the following options:</p>
    /// <ul>
    /// <li> <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line options</a>. </p> </li>
    /// <li> <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>. </p> </li>
    /// <li> <p>Run <code>aws configure</code> to change your default Amazon Web Services Region. Use Enter to key the same settings for your keys. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the CLI</a>.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>Namespace</code> - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.</p> </li>
    /// <li> <p> <code>Applied customizations</code> - Within an Amazon Web Services Region, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the <code>CreateAccountCustomization</code> command in each Amazon Web Services Region where you want to apply the same customizations. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_customization_input::Builder,
    }
    impl<C, M, R> DescribeAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountCustomizationInputOperationOutputAlias,
                crate::output::DescribeAccountCustomizationOutput,
                crate::error::DescribeAccountCustomizationError,
                crate::input::DescribeAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations for.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations for.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The <code>Resolved</code> flag works with the other parameters to determine which view of Amazon QuickSight customizations is returned. You can add this flag to your command to use the same view that Amazon QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations that are configured at different levels. </p>
        pub fn resolved(mut self, input: bool) -> Self {
            self.inner = self.inner.resolved(input);
            self
        }
        /// <p>The <code>Resolved</code> flag works with the other parameters to determine which view of Amazon QuickSight customizations is returned. You can add this flag to your command to use the same view that Amazon QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations that are configured at different levels. </p>
        pub fn set_resolved(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_resolved(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountSettings`.
    ///
    /// <p>Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_settings_input::Builder,
    }
    impl<C, M, R> DescribeAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountSettingsInputOperationOutputAlias,
                crate::output::DescribeAccountSettingsOutput,
                crate::error::DescribeAccountSettingsError,
                crate::input::DescribeAccountSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnalysis`.
    ///
    /// <p>Provides a summary of the metadata for an analysis.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_analysis_input::Builder,
    }
    impl<C, M, R> DescribeAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAnalysisInputOperationOutputAlias,
                crate::output::DescribeAnalysisOutput,
                crate::error::DescribeAnalysisError,
                crate::input::DescribeAnalysisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis that you're describing. The ID is part of the URL of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID of the analysis that you're describing. The ID is part of the URL of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnalysisPermissions`.
    ///
    /// <p>Provides the read and write permissions for an analysis.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAnalysisPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_analysis_permissions_input::Builder,
    }
    impl<C, M, R> DescribeAnalysisPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAnalysisPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnalysisPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAnalysisPermissionsInputOperationOutputAlias,
                crate::output::DescribeAnalysisPermissionsOutput,
                crate::error::DescribeAnalysisPermissionsError,
                crate::input::DescribeAnalysisPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're describing. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're describing. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis whose permissions you're describing. The ID is part of the analysis URL.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID of the analysis whose permissions you're describing. The ID is part of the analysis URL.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDashboard`.
    ///
    /// <p>Provides a summary for a dashboard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dashboard_input::Builder,
    }
    impl<C, M, R> DescribeDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDashboardInputOperationOutputAlias,
                crate::output::DescribeDashboardOutput,
                crate::error::DescribeDashboardError,
                crate::input::DescribeDashboardInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The version number for the dashboard. If a version number isn't passed, the latest published dashboard version is described. </p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number for the dashboard. If a version number isn't passed, the latest published dashboard version is described. </p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The alias name.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The alias name.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDashboardPermissions`.
    ///
    /// <p>Describes read and write permissions for a dashboard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDashboardPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dashboard_permissions_input::Builder,
    }
    impl<C, M, R> DescribeDashboardPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDashboardPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDashboardPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDashboardPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDashboardPermissionsInputOperationOutputAlias,
                crate::output::DescribeDashboardPermissionsOutput,
                crate::error::DescribeDashboardPermissionsError,
                crate::input::DescribeDashboardPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing permissions for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing permissions for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSet`.
    ///
    /// <p>Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_set_input::Builder,
    }
    impl<C, M, R> DescribeDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSetInputOperationOutputAlias,
                crate::output::DescribeDataSetOutput,
                crate::error::DescribeDataSetError,
                crate::input::DescribeDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSetPermissions`.
    ///
    /// <p>Describes the permissions on a dataset.</p>
    /// <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataSetPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_set_permissions_input::Builder,
    }
    impl<C, M, R> DescribeDataSetPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSetPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSetPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSetPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSetPermissionsInputOperationOutputAlias,
                crate::output::DescribeDataSetPermissionsOutput,
                crate::error::DescribeDataSetPermissionsError,
                crate::input::DescribeDataSetPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSource`.
    ///
    /// <p>Describes a data source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_source_input::Builder,
    }
    impl<C, M, R> DescribeDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSourceInputOperationOutputAlias,
                crate::output::DescribeDataSourceOutput,
                crate::error::DescribeDataSourceError,
                crate::input::DescribeDataSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSourcePermissions`.
    ///
    /// <p>Describes the resource permissions for a data source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataSourcePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_source_permissions_input::Builder,
    }
    impl<C, M, R> DescribeDataSourcePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSourcePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSourcePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSourcePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSourcePermissionsInputOperationOutputAlias,
                crate::output::DescribeDataSourcePermissionsOutput,
                crate::error::DescribeDataSourcePermissionsError,
                crate::input::DescribeDataSourcePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFolder`.
    ///
    /// <p>Describes a folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_folder_input::Builder,
    }
    impl<C, M, R> DescribeFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFolderInputOperationOutputAlias,
                crate::output::DescribeFolderOutput,
                crate::error::DescribeFolderError,
                crate::input::DescribeFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFolderPermissions`.
    ///
    /// <p>Describes permissions for a folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFolderPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_folder_permissions_input::Builder,
    }
    impl<C, M, R> DescribeFolderPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFolderPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFolderPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFolderPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFolderPermissionsInputOperationOutputAlias,
                crate::output::DescribeFolderPermissionsOutput,
                crate::error::DescribeFolderPermissionsError,
                crate::input::DescribeFolderPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFolderResolvedPermissions`.
    ///
    /// <p>Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFolderResolvedPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_folder_resolved_permissions_input::Builder,
    }
    impl<C, M, R> DescribeFolderResolvedPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFolderResolvedPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFolderResolvedPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFolderResolvedPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFolderResolvedPermissionsInputOperationOutputAlias,
                crate::output::DescribeFolderResolvedPermissionsOutput,
                crate::error::DescribeFolderResolvedPermissionsError,
                crate::input::DescribeFolderResolvedPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGroup`.
    ///
    /// <p>Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_group_input::Builder,
    }
    impl<C, M, R> DescribeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGroupInputOperationOutputAlias,
                crate::output::DescribeGroupOutput,
                crate::error::DescribeGroupError,
                crate::input::DescribeGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to describe.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group that you want to describe.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIAMPolicyAssignment`.
    ///
    /// <p>Describes an existing IAM policy assignment, as specified by the assignment name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> DescribeIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::DescribeIamPolicyAssignmentOutput,
                crate::error::DescribeIAMPolicyAssignmentError,
                crate::input::DescribeIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment, also called a rule.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(input.into());
            self
        }
        /// <p>The name of the assignment, also called a rule.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIngestion`.
    ///
    /// <p>Describes a SPICE ingestion.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIngestion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ingestion_input::Builder,
    }
    impl<C, M, R> DescribeIngestion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIngestion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIngestionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIngestionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIngestionInputOperationOutputAlias,
                crate::output::DescribeIngestionOutput,
                crate::error::DescribeIngestionError,
                crate::input::DescribeIngestionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingestion_id(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ingestion_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIpRestriction`.
    ///
    /// <p>Provides a summary and status of IP rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIpRestriction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ip_restriction_input::Builder,
    }
    impl<C, M, R> DescribeIpRestriction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIpRestriction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIpRestrictionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIpRestrictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIpRestrictionInputOperationOutputAlias,
                crate::output::DescribeIpRestrictionOutput,
                crate::error::DescribeIpRestrictionError,
                crate::input::DescribeIpRestrictionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNamespace`.
    ///
    /// <p>Describes the current namespace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_namespace_input::Builder,
    }
    impl<C, M, R> DescribeNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNamespaceInputOperationOutputAlias,
                crate::output::DescribeNamespaceOutput,
                crate::error::DescribeNamespaceError,
                crate::input::DescribeNamespaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace that you want to describe.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace that you want to describe.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTemplate`.
    ///
    /// <p>Describes a template's metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_template_input::Builder,
    }
    impl<C, M, R> DescribeTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTemplateInputOperationOutputAlias,
                crate::output::DescribeTemplateOutput,
                crate::error::DescribeTemplateError,
                crate::input::DescribeTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the template is described.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the template is described.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTemplateAlias`.
    ///
    /// <p>Describes the template alias for a template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_template_alias_input::Builder,
    }
    impl<C, M, R> DescribeTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTemplateAliasInputOperationOutputAlias,
                crate::output::DescribeTemplateAliasOutput,
                crate::error::DescribeTemplateAliasError,
                crate::input::DescribeTemplateAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTemplatePermissions`.
    ///
    /// <p>Describes read and write permissions on a template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTemplatePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_template_permissions_input::Builder,
    }
    impl<C, M, R> DescribeTemplatePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTemplatePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTemplatePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTemplatePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTemplatePermissionsInputOperationOutputAlias,
                crate::output::DescribeTemplatePermissionsOutput,
                crate::error::DescribeTemplatePermissionsError,
                crate::input::DescribeTemplatePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTheme`.
    ///
    /// <p>Describes a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_theme_input::Builder,
    }
    impl<C, M, R> DescribeTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThemeInputOperationOutputAlias,
                crate::output::DescribeThemeOutput,
                crate::error::DescribeThemeError,
                crate::input::DescribeThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the theme is described.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the theme is described.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to themes.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to themes.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThemeAlias`.
    ///
    /// <p>Describes the alias for a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_theme_alias_input::Builder,
    }
    impl<C, M, R> DescribeThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThemeAliasInputOperationOutputAlias,
                crate::output::DescribeThemeAliasOutput,
                crate::error::DescribeThemeAliasError,
                crate::input::DescribeThemeAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name of the theme alias that you want to describe.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The name of the theme alias that you want to describe.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThemePermissions`.
    ///
    /// <p>Describes the read and write permissions for a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThemePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_theme_permissions_input::Builder,
    }
    impl<C, M, R> DescribeThemePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThemePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThemePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThemePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThemePermissionsInputOperationOutputAlias,
                crate::output::DescribeThemePermissionsOutput,
                crate::error::DescribeThemePermissionsError,
                crate::input::DescribeThemePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme that you want to describe permissions for.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme that you want to describe permissions for.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Returns information about a user, given the user name. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl<C, M, R> DescribeUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserInputOperationOutputAlias,
                crate::output::DescribeUserOutput,
                crate::error::DescribeUserError,
                crate::input::DescribeUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to describe.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user that you want to describe.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateEmbedUrlForAnonymousUser`.
    ///
    /// <p>Generates an embed URL that you can use to embed an Amazon QuickSight dashboard in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.</p>
    /// <p>The following rules apply to the generated URL:</p>
    /// <ul>
    /// <li> <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p> </li>
    /// <li> <p>The URL validity period should not be confused with the actual session lifetime that can be customized using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code> parameter.</p> <p>The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).</p> </li>
    /// <li> <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User Guide</i>.</p>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateEmbedUrlForAnonymousUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_embed_url_for_anonymous_user_input::Builder,
    }
    impl<C, M, R> GenerateEmbedUrlForAnonymousUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateEmbedUrlForAnonymousUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateEmbedUrlForAnonymousUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateEmbedUrlForAnonymousUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateEmbedUrlForAnonymousUserInputOperationOutputAlias,
                crate::output::GenerateEmbedUrlForAnonymousUserOutput,
                crate::error::GenerateEmbedUrlForAnonymousUserError,
                crate::input::GenerateEmbedUrlForAnonymousUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// Appends an item to `SessionTags`.
        ///
        /// To override the contents of this collection use [`set_session_tags`](Self::set_session_tags).
        ///
        /// <p>The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p>
        /// <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>
        pub fn session_tags(mut self, input: crate::model::SessionTag) -> Self {
            self.inner = self.inner.session_tags(input);
            self
        }
        /// <p>The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p>
        /// <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>
        pub fn set_session_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SessionTag>>,
        ) -> Self {
            self.inner = self.inner.set_session_tags(input);
            self
        }
        /// Appends an item to `AuthorizedResourceArns`.
        ///
        /// To override the contents of this collection use [`set_authorized_resource_arns`](Self::set_authorized_resource_arns).
        ///
        /// <p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>
        pub fn authorized_resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorized_resource_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>
        pub fn set_authorized_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorized_resource_arns(input);
            self
        }
        /// <p>The configuration of the experience you are embedding.</p>
        pub fn experience_configuration(
            mut self,
            input: crate::model::AnonymousUserEmbeddingExperienceConfiguration,
        ) -> Self {
            self.inner = self.inner.experience_configuration(input);
            self
        }
        /// <p>The configuration of the experience you are embedding.</p>
        pub fn set_experience_configuration(
            mut self,
            input: std::option::Option<crate::model::AnonymousUserEmbeddingExperienceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_experience_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateEmbedUrlForRegisteredUser`.
    ///
    /// <p>Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.</p>
    /// <p>The following rules apply to the generated URL:</p>
    /// <ul>
    /// <li> <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p> </li>
    /// <li> <p>The URL validity period should not be confused with the actual session lifetime that can be customized using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code> parameter.</p> <p>The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).</p> </li>
    /// <li> <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User Guide</i>.</p>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateEmbedUrlForRegisteredUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_embed_url_for_registered_user_input::Builder,
    }
    impl<C, M, R> GenerateEmbedUrlForRegisteredUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateEmbedUrlForRegisteredUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateEmbedUrlForRegisteredUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateEmbedUrlForRegisteredUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateEmbedUrlForRegisteredUserInputOperationOutputAlias,
                crate::output::GenerateEmbedUrlForRegisteredUserOutput,
                crate::error::GenerateEmbedUrlForRegisteredUserError,
                crate::input::GenerateEmbedUrlForRegisteredUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>The Amazon Resource Name for the registered user.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name for the registered user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards or the entire Amazon QuickSight console.</p>
        pub fn experience_configuration(
            mut self,
            input: crate::model::RegisteredUserEmbeddingExperienceConfiguration,
        ) -> Self {
            self.inner = self.inner.experience_configuration(input);
            self
        }
        /// <p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards or the entire Amazon QuickSight console.</p>
        pub fn set_experience_configuration(
            mut self,
            input: std::option::Option<
                crate::model::RegisteredUserEmbeddingExperienceConfiguration,
            >,
        ) -> Self {
            self.inner = self.inner.set_experience_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDashboardEmbedUrl`.
    ///
    /// <p>Generates a session URL and authorization code that you can use to embed an Amazon Amazon QuickSight read-only dashboard in your web server code. Before you use this command, make sure that you have configured the dashboards and permissions. </p>
    /// <p>Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user's browser. The following rules apply to the combination of URL and authorization code:</p>
    /// <ul>
    /// <li> <p>They must be used together.</p> </li>
    /// <li> <p>They can be used one time only.</p> </li>
    /// <li> <p>They are valid for 5 minutes after you run this command.</p> </li>
    /// <li> <p>The resulting user session is valid for 10 hours.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html">Embedding Analytics Using GetDashboardEmbedUrl</a> in the <i>Amazon QuickSight User Guide</i>.</p>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDashboardEmbedUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dashboard_embed_url_input::Builder,
    }
    impl<C, M, R> GetDashboardEmbedUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDashboardEmbedUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDashboardEmbedUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDashboardEmbedUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDashboardEmbedUrlInputOperationOutputAlias,
                crate::output::GetDashboardEmbedUrlOutput,
                crate::error::GetDashboardEmbedUrlError,
                crate::input::GetDashboardEmbedUrlInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The authentication method that the user uses to sign in.</p>
        pub fn identity_type(mut self, input: crate::model::EmbeddingIdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>The authentication method that the user uses to sign in.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::EmbeddingIdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>
        pub fn undo_redo_disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.undo_redo_disabled(input);
            self
        }
        /// <p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>
        pub fn set_undo_redo_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_undo_redo_disabled(input);
            self
        }
        /// <p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>
        pub fn reset_disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.reset_disabled(input);
            self
        }
        /// <p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>
        pub fn set_reset_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_disabled(input);
            self
        }
        /// <p>Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.</p>
        pub fn state_persistence_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.state_persistence_enabled(input);
            self
        }
        /// <p>Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.</p>
        pub fn set_state_persistence_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_state_persistence_enabled(input);
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p>
        /// <ul>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li>
        /// </ul>
        /// <p>Omit this parameter for users in the third group – IAM users and IAM role-based sessions.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p>
        /// <ul>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li>
        /// </ul>
        /// <p>Omit this parameter for users in the third group – IAM users and IAM role-based sessions.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace, set <code>Namespace = default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace, set <code>Namespace = default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// Appends an item to `AdditionalDashboardIds`.
        ///
        /// To override the contents of this collection use [`set_additional_dashboard_ids`](Self::set_additional_dashboard_ids).
        ///
        /// <p>A list of one or more dashboard IDs that you want to add to a session that includes anonymous users. The <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> for this to work, because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "<code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can access all three dashboards. </p>
        pub fn additional_dashboard_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_dashboard_ids(input.into());
            self
        }
        /// <p>A list of one or more dashboard IDs that you want to add to a session that includes anonymous users. The <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> for this to work, because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "<code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can access all three dashboards. </p>
        pub fn set_additional_dashboard_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_additional_dashboard_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSessionEmbedUrl`.
    ///
    /// <p>Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use <code>GetSessionEmbedUrl</code> where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> API operation. Use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code> API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the <i>Amazon QuickSight User Guide</i>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedding Analytics</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSessionEmbedUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_session_embed_url_input::Builder,
    }
    impl<C, M, R> GetSessionEmbedUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSessionEmbedUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSessionEmbedUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSessionEmbedUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSessionEmbedUrlInputOperationOutputAlias,
                crate::output::GetSessionEmbedUrlOutput,
                crate::error::GetSessionEmbedUrlError,
                crate::input::GetSessionEmbedUrlInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The URL you use to access the embedded session. The entry point URL is constrained to the following paths:</p>
        /// <ul>
        /// <li> <p> <code>/start</code> </p> </li>
        /// <li> <p> <code>/start/analyses</code> </p> </li>
        /// <li> <p> <code>/start/dashboards</code> </p> </li>
        /// <li> <p> <code>/start/favorites</code> </p> </li>
        /// <li> <p> <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p> </li>
        /// <li> <p> <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p> </li>
        /// </ul>
        pub fn entry_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entry_point(input.into());
            self
        }
        /// <p>The URL you use to access the embedded session. The entry point URL is constrained to the following paths:</p>
        /// <ul>
        /// <li> <p> <code>/start</code> </p> </li>
        /// <li> <p> <code>/start/analyses</code> </p> </li>
        /// <li> <p> <code>/start/dashboards</code> </p> </li>
        /// <li> <p> <code>/start/favorites</code> </p> </li>
        /// <li> <p> <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p> </li>
        /// <li> <p> <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p> </li>
        /// </ul>
        pub fn set_entry_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entry_point(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:</p>
        /// <ol>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation</p> </li>
        /// </ol>
        /// <p>Omit this parameter for users in the third group, IAM users and IAM role-based sessions.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(input.into());
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:</p>
        /// <ol>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation</p> </li>
        /// </ol>
        /// <p>Omit this parameter for users in the third group, IAM users and IAM role-based sessions.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnalyses`.
    ///
    /// <p>Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAnalyses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_analyses_input::Builder,
    }
    impl<C, M, R> ListAnalyses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnalyses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnalysesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnalysesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnalysesInputOperationOutputAlias,
                crate::output::ListAnalysesOutput,
                crate::error::ListAnalysesError,
                crate::input::ListAnalysesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAnalysesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAnalysesPaginator<C, M, R> {
            crate::paginator::ListAnalysesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDashboards`.
    ///
    /// <p>Lists dashboards in an Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDashboards<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dashboards_input::Builder,
    }
    impl<C, M, R> ListDashboards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDashboards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDashboardsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDashboardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDashboardsInputOperationOutputAlias,
                crate::output::ListDashboardsOutput,
                crate::error::ListDashboardsError,
                crate::input::ListDashboardsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDashboardsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDashboardsPaginator<C, M, R> {
            crate::paginator::ListDashboardsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboards that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboards that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDashboardVersions`.
    ///
    /// <p>Lists all the versions of the dashboards in the Amazon QuickSight subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDashboardVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dashboard_versions_input::Builder,
    }
    impl<C, M, R> ListDashboardVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDashboardVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDashboardVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDashboardVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDashboardVersionsInputOperationOutputAlias,
                crate::output::ListDashboardVersionsOutput,
                crate::error::ListDashboardVersionsError,
                crate::input::ListDashboardVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDashboardVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDashboardVersionsPaginator<C, M, R> {
            crate::paginator::ListDashboardVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're listing versions for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're listing versions for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSets`.
    ///
    /// <p>Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.</p>
    /// <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_sets_input::Builder,
    }
    impl<C, M, R> ListDataSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSetsInputOperationOutputAlias,
                crate::output::ListDataSetsOutput,
                crate::error::ListDataSetsError,
                crate::input::ListDataSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataSetsPaginator<C, M, R> {
            crate::paginator::ListDataSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSources`.
    ///
    /// <p>Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataSources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_sources_input::Builder,
    }
    impl<C, M, R> ListDataSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSourcesInputOperationOutputAlias,
                crate::output::ListDataSourcesOutput,
                crate::error::ListDataSourcesError,
                crate::input::ListDataSourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataSourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataSourcesPaginator<C, M, R> {
            crate::paginator::ListDataSourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFolderMembers`.
    ///
    /// <p>List all assets (<code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>) in a folder. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFolderMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_folder_members_input::Builder,
    }
    impl<C, M, R> ListFolderMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFolderMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFolderMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFolderMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFolderMembersInputOperationOutputAlias,
                crate::output::ListFolderMembersOutput,
                crate::error::ListFolderMembersError,
                crate::input::ListFolderMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFolders`.
    ///
    /// <p>Lists all folders in an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFolders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_folders_input::Builder,
    }
    impl<C, M, R> ListFolders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFolders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFoldersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFoldersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFoldersInputOperationOutputAlias,
                crate::output::ListFoldersOutput,
                crate::error::ListFoldersError,
                crate::input::ListFoldersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupMemberships`.
    ///
    /// <p>Lists member users in a group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroupMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_group_memberships_input::Builder,
    }
    impl<C, M, R> ListGroupMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupMembershipsInputOperationOutputAlias,
                crate::output::ListGroupMembershipsOutput,
                crate::error::ListGroupMembershipsError,
                crate::input::ListGroupMembershipsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to see a membership list of.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group that you want to see a membership list of.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Lists all user groups in Amazon QuickSight. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl<C, M, R> ListGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsInputOperationOutputAlias,
                crate::output::ListGroupsOutput,
                crate::error::ListGroupsError,
                crate::input::ListGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIAMPolicyAssignments`.
    ///
    /// <p>Lists IAM policy assignments in the current Amazon QuickSight account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIAMPolicyAssignments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_iam_policy_assignments_input::Builder,
    }
    impl<C, M, R> ListIAMPolicyAssignments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIAMPolicyAssignments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIamPolicyAssignmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIAMPolicyAssignmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIamPolicyAssignmentsInputOperationOutputAlias,
                crate::output::ListIamPolicyAssignmentsOutput,
                crate::error::ListIAMPolicyAssignmentsError,
                crate::input::ListIamPolicyAssignmentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains these IAM policy assignments.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains these IAM policy assignments.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The status of the assignments.</p>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.inner = self.inner.assignment_status(input);
            self
        }
        /// <p>The status of the assignments.</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_assignment_status(input);
            self
        }
        /// <p>The namespace for the assignments.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace for the assignments.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIAMPolicyAssignmentsForUser`.
    ///
    /// <p>Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIAMPolicyAssignmentsForUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_iam_policy_assignments_for_user_input::Builder,
    }
    impl<C, M, R> ListIAMPolicyAssignmentsForUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIAMPolicyAssignmentsForUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIamPolicyAssignmentsForUserOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIAMPolicyAssignmentsForUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIamPolicyAssignmentsForUserInputOperationOutputAlias,
                crate::output::ListIamPolicyAssignmentsForUserOutput,
                crate::error::ListIAMPolicyAssignmentsForUserError,
                crate::input::ListIamPolicyAssignmentsForUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignments.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignments.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIngestions`.
    ///
    /// <p>Lists the history of SPICE ingestions for a dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIngestions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ingestions_input::Builder,
    }
    impl<C, M, R> ListIngestions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIngestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIngestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIngestionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIngestionsInputOperationOutputAlias,
                crate::output::ListIngestionsOutput,
                crate::error::ListIngestionsError,
                crate::input::ListIngestionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIngestionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIngestionsPaginator<C, M, R> {
            crate::paginator::ListIngestionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNamespaces`.
    ///
    /// <p>Lists the namespaces for the specified Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNamespaces<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_namespaces_input::Builder,
    }
    impl<C, M, R> ListNamespaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNamespaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNamespacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNamespacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNamespacesInputOperationOutputAlias,
                crate::output::ListNamespacesOutput,
                crate::error::ListNamespacesError,
                crate::input::ListNamespacesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNamespacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNamespacesPaginator<C, M, R> {
            crate::paginator::ListNamespacesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags assigned to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplateAliases`.
    ///
    /// <p>Lists all the aliases of a template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTemplateAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_template_aliases_input::Builder,
    }
    impl<C, M, R> ListTemplateAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplateAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplateAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplateAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplateAliasesInputOperationOutputAlias,
                crate::output::ListTemplateAliasesOutput,
                crate::error::ListTemplateAliasesError,
                crate::input::ListTemplateAliasesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTemplateAliasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTemplateAliasesPaginator<C, M, R> {
            crate::paginator::ListTemplateAliasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the template aliases that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template aliases that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplates`.
    ///
    /// <p>Lists all the templates in the current Amazon QuickSight account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_templates_input::Builder,
    }
    impl<C, M, R> ListTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplatesInputOperationOutputAlias,
                crate::output::ListTemplatesOutput,
                crate::error::ListTemplatesError,
                crate::input::ListTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTemplatesPaginator<C, M, R> {
            crate::paginator::ListTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplateVersions`.
    ///
    /// <p>Lists all the versions of the templates in the current Amazon QuickSight account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTemplateVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_template_versions_input::Builder,
    }
    impl<C, M, R> ListTemplateVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplateVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplateVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplateVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplateVersionsInputOperationOutputAlias,
                crate::output::ListTemplateVersionsOutput,
                crate::error::ListTemplateVersionsError,
                crate::input::ListTemplateVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTemplateVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTemplateVersionsPaginator<C, M, R> {
            crate::paginator::ListTemplateVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemeAliases`.
    ///
    /// <p>Lists all the aliases of a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThemeAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_theme_aliases_input::Builder,
    }
    impl<C, M, R> ListThemeAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThemeAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemeAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemeAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThemeAliasesInputOperationOutputAlias,
                crate::output::ListThemeAliasesOutput,
                crate::error::ListThemeAliasesError,
                crate::input::ListThemeAliasesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme aliases that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme aliases that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemes`.
    ///
    /// <p>Lists all the themes in the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThemes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_themes_input::Builder,
    }
    impl<C, M, R> ListThemes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThemes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThemesInputOperationOutputAlias,
                crate::output::ListThemesOutput,
                crate::error::ListThemesError,
                crate::input::ListThemesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThemesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThemesPaginator<C, M, R> {
            crate::paginator::ListThemesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The type of themes that you want to list. Valid options include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li>
        /// <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li>
        /// <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ThemeType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of themes that you want to list. Valid options include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li>
        /// <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li>
        /// <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ThemeType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemeVersions`.
    ///
    /// <p>Lists all the versions of the themes in the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThemeVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_theme_versions_input::Builder,
    }
    impl<C, M, R> ListThemeVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThemeVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemeVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemeVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThemeVersionsInputOperationOutputAlias,
                crate::output::ListThemeVersionsOutput,
                crate::error::ListThemeVersionsError,
                crate::input::ListThemeVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThemeVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThemeVersionsPaginator<C, M, R> {
            crate::paginator::ListThemeVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserGroups`.
    ///
    /// <p>Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUserGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_groups_input::Builder,
    }
    impl<C, M, R> ListUserGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserGroupsInputOperationOutputAlias,
                crate::output::ListUserGroupsOutput,
                crate::error::ListUserGroupsError,
                crate::input::ListUserGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon QuickSight user name that you want to list group memberships for.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The Amazon QuickSight user name that you want to list group memberships for.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Returns a list of all of the Amazon QuickSight users belonging to this account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterUser`.
    ///
    /// <p>Creates an Amazon QuickSight user, whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_user_input::Builder,
    }
    impl<C, M, R> RegisterUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterUserOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterUserInputOperationOutputAlias,
                crate::output::RegisterUserOutput,
                crate::error::RegisterUserError,
                crate::input::RegisterUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:</p>
        /// <ul>
        /// <li> <p> <code>IAM</code>: A user whose identity maps to an existing IAM user or role. </p> </li>
        /// <li> <p> <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight. </p> </li>
        /// </ul>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:</p>
        /// <ul>
        /// <li> <p> <code>IAM</code>: A user whose identity maps to an existing IAM user or role. </p> </li>
        /// <li> <p> <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight. </p> </li>
        /// </ul>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The email address of the user that you want to register.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the user that you want to register.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>
        /// <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>
        /// <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>
        /// <li> <p> <code>RESTRICTED_READER</code>: This role isn't currently available for use.</p> </li>
        /// <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.</p> </li>
        /// </ul>
        pub fn user_role(mut self, input: crate::model::UserRole) -> Self {
            self.inner = self.inner.user_role(input);
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>
        /// <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>
        /// <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>
        /// <li> <p> <code>RESTRICTED_READER</code>: This role isn't currently available for use.</p> </li>
        /// <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.</p> </li>
        /// </ul>
        pub fn set_user_role(mut self, input: std::option::Option<crate::model::UserRole>) -> Self {
            self.inner = self.inner.set_user_role(input);
            self
        }
        /// <p>The ARN of the IAM user or role that you are registering with Amazon QuickSight. </p>
        pub fn iam_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM user or role that you are registering with Amazon QuickSight. </p>
        pub fn set_iam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_arn(input);
            self
        }
        /// <p>You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>CLI Reference.</i> </p>
        pub fn session_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_name(input.into());
            self
        }
        /// <p>You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>CLI Reference.</i> </p>
        pub fn set_session_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>
        /// <ul>
        /// <li> <p>Create and update data sources</p> </li>
        /// <li> <p>Create and update datasets</p> </li>
        /// <li> <p>Create and update email reports</p> </li>
        /// <li> <p>Subscribe to email reports</p> </li>
        /// </ul>
        /// <p>To add custom permissions to an existing user, use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> instead.</p>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn custom_permissions_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_permissions_name(input.into());
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>
        /// <ul>
        /// <li> <p>Create and update data sources</p> </li>
        /// <li> <p>Create and update datasets</p> </li>
        /// <li> <p>Create and update email reports</p> </li>
        /// <li> <p>Subscribe to email reports</p> </li>
        /// </ul>
        /// <p>To add custom permissions to an existing user, use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> instead.</p>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn set_custom_permissions_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_permissions_name(input);
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>
        /// <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>
        /// </ul>
        pub fn external_login_federation_provider_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .external_login_federation_provider_type(input.into());
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>
        /// <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>
        /// </ul>
        pub fn set_external_login_federation_provider_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_external_login_federation_provider_type(input);
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn custom_federation_provider_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.custom_federation_provider_url(input.into());
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn set_custom_federation_provider_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_federation_provider_url(input);
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn external_login_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_login_id(input.into());
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn set_external_login_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_login_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreAnalysis`.
    ///
    /// <p>Restores an analysis.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_analysis_input::Builder,
    }
    impl<C, M, R> RestoreAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreAnalysisInputOperationOutputAlias,
                crate::output::RestoreAnalysisOutput,
                crate::error::RestoreAnalysisError,
                crate::input::RestoreAnalysisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis that you're restoring.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID of the analysis that you're restoring.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchAnalyses`.
    ///
    /// <p>Searches for analyses that belong to the user specified in the filter.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchAnalyses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_analyses_input::Builder,
    }
    impl<C, M, R> SearchAnalyses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchAnalyses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchAnalysesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchAnalysesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchAnalysesInputOperationOutputAlias,
                crate::output::SearchAnalysesOutput,
                crate::error::SearchAnalysesError,
                crate::input::SearchAnalysesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchAnalysesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchAnalysesPaginator<C, M, R> {
            crate::paginator::SearchAnalysesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses that you're searching for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses that you're searching for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The structure for the search filters that you want to apply to your search. </p>
        pub fn filters(mut self, input: crate::model::AnalysisSearchFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The structure for the search filters that you want to apply to your search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisSearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchDashboards`.
    ///
    /// <p>Searches for dashboards that belong to a user. </p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchDashboards<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_dashboards_input::Builder,
    }
    impl<C, M, R> SearchDashboards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchDashboards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchDashboardsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchDashboardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchDashboardsInputOperationOutputAlias,
                crate::output::SearchDashboardsOutput,
                crate::error::SearchDashboardsError,
                crate::input::SearchDashboardsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchDashboardsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchDashboardsPaginator<C, M, R> {
            crate::paginator::SearchDashboardsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Amazon Web Services account that contains the user whose dashboards you're searching for. </p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the user whose dashboards you're searching for. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>
        pub fn filters(mut self, input: crate::model::DashboardSearchFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardSearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFolders`.
    ///
    /// <p>Searches the subfolders in a folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchFolders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_folders_input::Builder,
    }
    impl<C, M, R> SearchFolders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchFolders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFoldersOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFoldersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchFoldersInputOperationOutputAlias,
                crate::output::SearchFoldersOutput,
                crate::error::SearchFoldersError,
                crate::input::SearchFoldersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>
        pub fn filters(mut self, input: crate::model::FolderSearchFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderSearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource. </p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, and template. </p>
    /// <p>Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except for the following:</p>
    /// <ul>
    /// <li> <p>You can't use tags to track costs for Amazon QuickSight. This isn't possible because you can't tag the resources that Amazon QuickSight costs are based on, for example Amazon QuickSight storage capacity (SPICE), number of users, type of users, and usage metrics.</p> </li>
    /// <li> <p>Amazon QuickSight doesn't currently support the tag editor for Resource Groups.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag or tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountCustomization`.
    ///
    /// <p>Updates Amazon QuickSight customizations the current Amazon Web Services Region. Currently, the only customization you can use is a theme.</p>
    /// <p>You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the <code>DescribeAccountCustomization</code> API operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_customization_input::Builder,
    }
    impl<C, M, R> UpdateAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountCustomizationInputOperationOutputAlias,
                crate::output::UpdateAccountCustomizationOutput,
                crate::error::UpdateAccountCustomizationError,
                crate::input::UpdateAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace that you want to update Amazon QuickSight customizations for.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace that you want to update Amazon QuickSight customizations for.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn account_customization(mut self, input: crate::model::AccountCustomization) -> Self {
            self.inner = self.inner.account_customization(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.inner = self.inner.set_account_customization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountSettings`.
    ///
    /// <p>Updates the Amazon QuickSight settings in your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_settings_input::Builder,
    }
    impl<C, M, R> UpdateAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountSettingsInputOperationOutputAlias,
                crate::output::UpdateAccountSettingsOutput,
                crate::error::UpdateAccountSettingsError,
                crate::input::UpdateAccountSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The default namespace for this Amazon Web Services account. Currently, the default is <code>default</code>. Identity and Access Management (IAM) users that register for the first time with Amazon QuickSight provide an email that becomes associated with the default namespace.</p>
        pub fn default_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_namespace(input.into());
            self
        }
        /// <p>The default namespace for this Amazon Web Services account. Currently, the default is <code>default</code>. Identity and Access Management (IAM) users that register for the first time with Amazon QuickSight provide an email that becomes associated with the default namespace.</p>
        pub fn set_default_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_namespace(input);
            self
        }
        /// <p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>
        pub fn notification_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_email(input.into());
            self
        }
        /// <p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>
        pub fn set_notification_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnalysis`.
    ///
    /// <p>Updates an analysis in Amazon QuickSight</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_analysis_input::Builder,
    }
    impl<C, M, R> UpdateAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnalysisInputOperationOutputAlias,
                crate::output::UpdateAnalysisOutput,
                crate::error::UpdateAnalysisError,
                crate::input::UpdateAnalysisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the analysis that you're updating. This ID displays in the URL of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID for the analysis that you're updating. This ID displays in the URL of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>A descriptive name for the analysis that you're updating. This name displays for the analysis in the Amazon QuickSight console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A descriptive name for the analysis that you're updating. This name displays for the analysis in the Amazon QuickSight console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn source_entity(mut self, input: crate::model::AnalysisSourceEntity) -> Self {
            self.inner = self.inner.source_entity(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::AnalysisSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnalysisPermissions`.
    ///
    /// <p>Updates the read and write permissions for an analysis.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAnalysisPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_analysis_permissions_input::Builder,
    }
    impl<C, M, R> UpdateAnalysisPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnalysisPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnalysisPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnalysisPermissionsInputOperationOutputAlias,
                crate::output::UpdateAnalysisPermissionsOutput,
                crate::error::UpdateAnalysisPermissionsError,
                crate::input::UpdateAnalysisPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're updating. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're updating. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis whose permissions you're updating. The ID is part of the analysis URL.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(input.into());
            self
        }
        /// <p>The ID of the analysis whose permissions you're updating. The ID is part of the analysis URL.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A structure that describes the permissions to add and the principal to add them to.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_permissions(input);
            self
        }
        /// <p>A structure that describes the permissions to add and the principal to add them to.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A structure that describes the permissions to remove and the principal to remove them from.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_permissions(input);
            self
        }
        /// <p>A structure that describes the permissions to remove and the principal to remove them from.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboard`.
    ///
    /// <p>Updates a dashboard in an Amazon Web Services account.</p> <note>
    /// <p>Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> </code> API operation.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dashboard_input::Builder,
    }
    impl<C, M, R> UpdateDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDashboardInputOperationOutputAlias,
                crate::output::UpdateDashboardOutput,
                crate::error::UpdateDashboardError,
                crate::input::UpdateDashboardInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, input: crate::model::DashboardSourceEntity) -> Self {
            self.inner = self.inner.source_entity(input);
            self
        }
        /// <p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::DashboardSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn dashboard_publish_options(
            mut self,
            input: crate::model::DashboardPublishOptions,
        ) -> Self {
            self.inner = self.inner.dashboard_publish_options(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn set_dashboard_publish_options(
            mut self,
            input: std::option::Option<crate::model::DashboardPublishOptions>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_publish_options(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboardPermissions`.
    ///
    /// <p>Updates read and write permissions on a dashboard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDashboardPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dashboard_permissions_input::Builder,
    }
    impl<C, M, R> UpdateDashboardPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDashboardPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDashboardPermissionsInputOperationOutputAlias,
                crate::output::UpdateDashboardPermissionsOutput,
                crate::error::UpdateDashboardPermissionsError,
                crate::input::UpdateDashboardPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>The permissions that you want to grant on this resource.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_permissions(input);
            self
        }
        /// <p>The permissions that you want to grant on this resource.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>The permissions that you want to revoke from this resource.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_permissions(input);
            self
        }
        /// <p>The permissions that you want to revoke from this resource.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
        /// Appends an item to `GrantLinkPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_link_permissions`](Self::set_grant_link_permissions).
        ///
        /// <p>Grants link permissions to all users in a defined namespace.</p>
        pub fn grant_link_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_link_permissions(input);
            self
        }
        /// <p>Grants link permissions to all users in a defined namespace.</p>
        pub fn set_grant_link_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_link_permissions(input);
            self
        }
        /// Appends an item to `RevokeLinkPermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_link_permissions`](Self::set_revoke_link_permissions).
        ///
        /// <p>Revokes link permissions from all users in a defined namespace.</p>
        pub fn revoke_link_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_link_permissions(input);
            self
        }
        /// <p>Revokes link permissions from all users in a defined namespace.</p>
        pub fn set_revoke_link_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_link_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboardPublishedVersion`.
    ///
    /// <p>Updates the published version of a dashboard.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDashboardPublishedVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dashboard_published_version_input::Builder,
    }
    impl<C, M, R> UpdateDashboardPublishedVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDashboardPublishedVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardPublishedVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardPublishedVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDashboardPublishedVersionInputOperationOutputAlias,
                crate::output::UpdateDashboardPublishedVersionOutput,
                crate::error::UpdateDashboardPublishedVersionError,
                crate::input::UpdateDashboardPublishedVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The version number of the dashboard.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number of the dashboard.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSet`.
    ///
    /// <p>Updates a dataset. This operation doesn't support datasets that include uploaded files as a source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_set_input::Builder,
    }
    impl<C, M, R> UpdateDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSetInputOperationOutputAlias,
                crate::output::UpdateDataSetOutput,
                crate::error::UpdateDataSetError,
                crate::input::UpdateDataSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `PhysicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_physical_table_map`](Self::set_physical_table_map).
        ///
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn physical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PhysicalTable,
        ) -> Self {
            self.inner = self.inner.physical_table_map(k.into(), v);
            self
        }
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn set_physical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_physical_table_map(input);
            self
        }
        /// Adds a key-value pair to `LogicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_logical_table_map`](Self::set_logical_table_map).
        ///
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn logical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::LogicalTable,
        ) -> Self {
            self.inner = self.inner.logical_table_map(k.into(), v);
            self
        }
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn set_logical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logical_table_map(input);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn import_mode(mut self, input: crate::model::DataSetImportMode) -> Self {
            self.inner = self.inner.import_mode(input);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn set_import_mode(
            mut self,
            input: std::option::Option<crate::model::DataSetImportMode>,
        ) -> Self {
            self.inner = self.inner.set_import_mode(input);
            self
        }
        /// Appends an item to `ColumnGroups`.
        ///
        /// To override the contents of this collection use [`set_column_groups`](Self::set_column_groups).
        ///
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn column_groups(mut self, input: crate::model::ColumnGroup) -> Self {
            self.inner = self.inner.column_groups(input);
            self
        }
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn set_column_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        ) -> Self {
            self.inner = self.inner.set_column_groups(input);
            self
        }
        /// Adds a key-value pair to `FieldFolders`.
        ///
        /// To override the contents of this collection use [`set_field_folders`](Self::set_field_folders).
        ///
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn field_folders(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FieldFolder,
        ) -> Self {
            self.inner = self.inner.field_folders(k.into(), v);
            self
        }
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn set_field_folders(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
            >,
        ) -> Self {
            self.inner = self.inner.set_field_folders(input);
            self
        }
        /// <p>The row-level security configuration for the data you want to create.</p>
        pub fn row_level_permission_data_set(
            mut self,
            input: crate::model::RowLevelPermissionDataSet,
        ) -> Self {
            self.inner = self.inner.row_level_permission_data_set(input);
            self
        }
        /// <p>The row-level security configuration for the data you want to create.</p>
        pub fn set_row_level_permission_data_set(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionDataSet>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_data_set(input);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn row_level_permission_tag_configuration(
            mut self,
            input: crate::model::RowLevelPermissionTagConfiguration,
        ) -> Self {
            self.inner = self.inner.row_level_permission_tag_configuration(input);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn set_row_level_permission_tag_configuration(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_tag_configuration(input);
            self
        }
        /// Appends an item to `ColumnLevelPermissionRules`.
        ///
        /// To override the contents of this collection use [`set_column_level_permission_rules`](Self::set_column_level_permission_rules).
        ///
        /// <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
        pub fn column_level_permission_rules(
            mut self,
            input: crate::model::ColumnLevelPermissionRule,
        ) -> Self {
            self.inner = self.inner.column_level_permission_rules(input);
            self
        }
        /// <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
        pub fn set_column_level_permission_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        ) -> Self {
            self.inner = self.inner.set_column_level_permission_rules(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn data_set_usage_configuration(
            mut self,
            input: crate::model::DataSetUsageConfiguration,
        ) -> Self {
            self.inner = self.inner.data_set_usage_configuration(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn set_data_set_usage_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSetUsageConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_set_usage_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSetPermissions`.
    ///
    /// <p>Updates the permissions on a dataset.</p>
    /// <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSetPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_set_permissions_input::Builder,
    }
    impl<C, M, R> UpdateDataSetPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSetPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSetPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSetPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSetPermissionsInputOperationOutputAlias,
                crate::output::UpdateDataSetPermissionsOutput,
                crate::error::UpdateDataSetPermissionsError,
                crate::input::UpdateDataSetPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(input.into());
            self
        }
        /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>The resource permissions that you want to grant to the dataset.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_permissions(input);
            self
        }
        /// <p>The resource permissions that you want to grant to the dataset.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>The resource permissions that you want to revoke from the dataset.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_permissions(input);
            self
        }
        /// <p>The resource permissions that you want to revoke from the dataset.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSource`.
    ///
    /// <p>Updates a data source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_source_input::Builder,
    }
    impl<C, M, R> UpdateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSourceInputOperationOutputAlias,
                crate::output::UpdateDataSourceOutput,
                crate::error::UpdateDataSourceError,
                crate::input::UpdateDataSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn data_source_parameters(mut self, input: crate::model::DataSourceParameters) -> Self {
            self.inner = self.inner.data_source_parameters(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn set_data_source_parameters(
            mut self,
            input: std::option::Option<crate::model::DataSourceParameters>,
        ) -> Self {
            self.inner = self.inner.set_data_source_parameters(input);
            self
        }
        /// <p>The credentials that Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
        pub fn credentials(mut self, input: crate::model::DataSourceCredentials) -> Self {
            self.inner = self.inner.credentials(input);
            self
        }
        /// <p>The credentials that Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::DataSourceCredentials>,
        ) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn vpc_connection_properties(
            mut self,
            input: crate::model::VpcConnectionProperties,
        ) -> Self {
            self.inner = self.inner.vpc_connection_properties(input);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn set_vpc_connection_properties(
            mut self,
            input: std::option::Option<crate::model::VpcConnectionProperties>,
        ) -> Self {
            self.inner = self.inner.set_vpc_connection_properties(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn ssl_properties(mut self, input: crate::model::SslProperties) -> Self {
            self.inner = self.inner.ssl_properties(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn set_ssl_properties(
            mut self,
            input: std::option::Option<crate::model::SslProperties>,
        ) -> Self {
            self.inner = self.inner.set_ssl_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSourcePermissions`.
    ///
    /// <p>Updates the permissions to a data source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSourcePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_source_permissions_input::Builder,
    }
    impl<C, M, R> UpdateDataSourcePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSourcePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourcePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourcePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSourcePermissionsInputOperationOutputAlias,
                crate::output::UpdateDataSourcePermissionsOutput,
                crate::error::UpdateDataSourcePermissionsError,
                crate::input::UpdateDataSourcePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A list of resource permissions that you want to grant on the data source.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_permissions(input);
            self
        }
        /// <p>A list of resource permissions that you want to grant on the data source.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A list of resource permissions that you want to revoke on the data source.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_permissions(input);
            self
        }
        /// <p>A list of resource permissions that you want to revoke on the data source.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFolder`.
    ///
    /// <p>Updates the name of a folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_folder_input::Builder,
    }
    impl<C, M, R> UpdateFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFolderInputOperationOutputAlias,
                crate::output::UpdateFolderOutput,
                crate::error::UpdateFolderError,
                crate::input::UpdateFolderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder to update.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder to update.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFolderPermissions`.
    ///
    /// <p>Updates permissions of a folder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFolderPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_folder_permissions_input::Builder,
    }
    impl<C, M, R> UpdateFolderPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFolderPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFolderPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFolderPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFolderPermissionsInputOperationOutputAlias,
                crate::output::UpdateFolderPermissionsOutput,
                crate::error::UpdateFolderPermissionsError,
                crate::input::UpdateFolderPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder to update.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder to update.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>The permissions that you want to grant on a resource.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_permissions(input);
            self
        }
        /// <p>The permissions that you want to grant on a resource.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>The permissions that you want to revoke from a resource.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_permissions(input);
            self
        }
        /// <p>The permissions that you want to revoke from a resource.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// <p>Changes a group description. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_input::Builder,
    }
    impl<C, M, R> UpdateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupInputOperationOutputAlias,
                crate::output::UpdateGroupOutput,
                crate::error::UpdateGroupError,
                crate::input::UpdateGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to update.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the group that you want to update.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The description for the group that you want to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the group that you want to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIAMPolicyAssignment`.
    ///
    /// <p>Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in <code>Identities</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> UpdateIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::UpdateIamPolicyAssignmentOutput,
                crate::error::UpdateIAMPolicyAssignmentError,
                crate::input::UpdateIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the IAM policy assignment. </p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the IAM policy assignment. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment, also called a rule. This name must be unique within an Amazon Web Services account.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(input.into());
            self
        }
        /// <p>The name of the assignment, also called a rule. This name must be unique within an Amazon Web Services account.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.inner = self.inner.assignment_status(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_assignment_status(input);
            self
        }
        /// <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Adds a key-value pair to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.identities(k.into(), v);
            self
        }
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIpRestriction`.
    ///
    /// <p>Updates the content and status of IP rules. To use this operation, you need to provide the entire map of rules. You can use the <code>DescribeIpRestriction</code> operation to get the current rule map.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIpRestriction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ip_restriction_input::Builder,
    }
    impl<C, M, R> UpdateIpRestriction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIpRestriction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIpRestrictionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIpRestrictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIpRestrictionInputOperationOutputAlias,
                crate::output::UpdateIpRestrictionOutput,
                crate::error::UpdateIpRestrictionError,
                crate::input::UpdateIpRestrictionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Adds a key-value pair to `IpRestrictionRuleMap`.
        ///
        /// To override the contents of this collection use [`set_ip_restriction_rule_map`](Self::set_ip_restriction_rule_map).
        ///
        /// <p>A map that describes the updated IP rules with CIDR ranges and descriptions.</p>
        pub fn ip_restriction_rule_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.ip_restriction_rule_map(k.into(), v.into());
            self
        }
        /// <p>A map that describes the updated IP rules with CIDR ranges and descriptions.</p>
        pub fn set_ip_restriction_rule_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_ip_restriction_rule_map(input);
            self
        }
        /// <p>A value that specifies whether IP rules are turned on.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>A value that specifies whether IP rules are turned on.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplate`.
    ///
    /// <p>Updates a template from an existing Amazon QuickSight analysis or another template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_input::Builder,
    }
    impl<C, M, R> UpdateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateInputOperationOutputAlias,
                crate::output::UpdateTemplateOutput,
                crate::error::UpdateTemplateError,
                crate::input::UpdateTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, input: crate::model::TemplateSourceEntity) -> Self {
            self.inner = self.inner.source_entity(input);
            self
        }
        /// <p>The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::TemplateSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>A description of the current template version that is being updated. Every time you call <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description of the current template version that is being updated. Every time you call <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The name for the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplateAlias`.
    ///
    /// <p>Updates the template alias of a template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_alias_input::Builder,
    }
    impl<C, M, R> UpdateTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateAliasInputOperationOutputAlias,
                crate::output::UpdateTemplateAliasOutput,
                crate::error::UpdateTemplateAliasError,
                crate::input::UpdateTemplateAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The alias of the template that you want to update. If you name a specific alias, you update the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The alias of the template that you want to update. If you name a specific alias, you update the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn template_version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.template_version_number(input);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn set_template_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_template_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplatePermissions`.
    ///
    /// <p>Updates the resource permissions for a template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTemplatePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_permissions_input::Builder,
    }
    impl<C, M, R> UpdateTemplatePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplatePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplatePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplatePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplatePermissionsInputOperationOutputAlias,
                crate::output::UpdateTemplatePermissionsOutput,
                crate::error::UpdateTemplatePermissionsError,
                crate::input::UpdateTemplatePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A list of resource permissions to be granted on the template. </p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_permissions(input);
            self
        }
        /// <p>A list of resource permissions to be granted on the template. </p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A list of resource permissions to be revoked from the template. </p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_permissions(input);
            self
        }
        /// <p>A list of resource permissions to be revoked from the template. </p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTheme`.
    ///
    /// <p>Updates a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_theme_input::Builder,
    }
    impl<C, M, R> UpdateTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThemeInputOperationOutputAlias,
                crate::output::UpdateThemeOutput,
                crate::error::UpdateThemeError,
                crate::input::UpdateThemeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name for the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.</p>
        pub fn base_theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_theme_id(input.into());
            self
        }
        /// <p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.</p>
        pub fn set_base_theme_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_base_theme_id(input);
            self
        }
        /// <p>A description of the theme version that you're updating Every time that you call <code>UpdateTheme</code>, you create a new version of the theme. Each version of the theme maintains a description of the version in <code>VersionDescription</code>.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description of the theme version that you're updating Every time that you call <code>UpdateTheme</code>, you create a new version of the theme. Each version of the theme maintains a description of the version in <code>VersionDescription</code>.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn configuration(mut self, input: crate::model::ThemeConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ThemeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateThemeAlias`.
    ///
    /// <p>Updates an alias of a theme.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_theme_alias_input::Builder,
    }
    impl<C, M, R> UpdateThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThemeAliasInputOperationOutputAlias,
                crate::output::UpdateThemeAliasOutput,
                crate::error::UpdateThemeAliasError,
                crate::input::UpdateThemeAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name of the theme alias that you want to update.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(input.into());
            self
        }
        /// <p>The name of the theme alias that you want to update.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the theme that the alias should reference.</p>
        pub fn theme_version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.theme_version_number(input);
            self
        }
        /// <p>The version number of the theme that the alias should reference.</p>
        pub fn set_theme_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_theme_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateThemePermissions`.
    ///
    /// <p>Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example <code>"quicksight:DescribeTheme"</code>.</p>
    /// <p>Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions: </p>
    /// <ul>
    /// <li> <p>User</p>
    /// <ul>
    /// <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li>
    /// <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li>
    /// <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li>
    /// <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Owner</p>
    /// <ul>
    /// <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li>
    /// <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li>
    /// <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li>
    /// <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li>
    /// <li> <p> <code>"quicksight:DeleteTheme"</code> </p> </li>
    /// <li> <p> <code>"quicksight:UpdateTheme"</code> </p> </li>
    /// <li> <p> <code>"quicksight:CreateThemeAlias"</code> </p> </li>
    /// <li> <p> <code>"quicksight:DeleteThemeAlias"</code> </p> </li>
    /// <li> <p> <code>"quicksight:UpdateThemeAlias"</code> </p> </li>
    /// <li> <p> <code>"quicksight:UpdateThemePermissions"</code> </p> </li>
    /// <li> <p> <code>"quicksight:DescribeThemePermissions"</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>To specify no permissions, omit the permissions list.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateThemePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_theme_permissions_input::Builder,
    }
    impl<C, M, R> UpdateThemePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateThemePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThemePermissionsInputOperationOutputAlias,
                crate::output::UpdateThemePermissionsOutput,
                crate::error::UpdateThemePermissionsError,
                crate::input::UpdateThemePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A list of resource permissions to be granted for the theme.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.grant_permissions(input);
            self
        }
        /// <p>A list of resource permissions to be granted for the theme.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A list of resource permissions to be revoked from the theme.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            self.inner = self.inner.revoke_permissions(input);
            self
        }
        /// <p>A list of resource permissions to be revoked from the theme.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Updates an Amazon QuickSight user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_input::Builder,
    }
    impl<C, M, R> UpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserInputOperationOutputAlias,
                crate::output::UpdateUserOutput,
                crate::error::UpdateUserError,
                crate::input::UpdateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon QuickSight user name that you want to update.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The Amazon QuickSight user name that you want to update.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The email address of the user that you want to update.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the user that you want to update.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:</p>
        /// <ul>
        /// <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>
        /// <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>
        /// <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>
        /// </ul>
        /// <p>The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with permissions.</p>
        pub fn role(mut self, input: crate::model::UserRole) -> Self {
            self.inner = self.inner.role(input);
            self
        }
        /// <p>The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:</p>
        /// <ul>
        /// <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>
        /// <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>
        /// <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>
        /// </ul>
        /// <p>The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with permissions.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::UserRole>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>
        /// <ul>
        /// <li> <p>Create and update data sources</p> </li>
        /// <li> <p>Create and update datasets</p> </li>
        /// <li> <p>Create and update email reports</p> </li>
        /// <li> <p>Subscribe to email reports</p> </li>
        /// </ul>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn custom_permissions_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_permissions_name(input.into());
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>
        /// <ul>
        /// <li> <p>Create and update data sources</p> </li>
        /// <li> <p>Create and update datasets</p> </li>
        /// <li> <p>Create and update email reports</p> </li>
        /// <li> <p>Subscribe to email reports</p> </li>
        /// </ul>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn set_custom_permissions_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_permissions_name(input);
            self
        }
        /// <p>A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn't accept any other value.</p>
        pub fn unapply_custom_permissions(mut self, input: bool) -> Self {
            self.inner = self.inner.unapply_custom_permissions(input);
            self
        }
        /// <p>A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn't accept any other value.</p>
        pub fn set_unapply_custom_permissions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_unapply_custom_permissions(input);
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>
        /// <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>
        /// <li> <p> <code>NONE</code>: This clears all the previously saved external login information for a user. Use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code> API operation to check the external login information.</p> </li>
        /// </ul>
        pub fn external_login_federation_provider_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .external_login_federation_provider_type(input.into());
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>
        /// <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>
        /// <li> <p> <code>NONE</code>: This clears all the previously saved external login information for a user. Use the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> </code> API operation to check the external login information.</p> </li>
        /// </ul>
        pub fn set_external_login_federation_provider_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_external_login_federation_provider_type(input);
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn custom_federation_provider_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.custom_federation_provider_url(input.into());
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn set_custom_federation_provider_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_federation_provider_url(input);
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn external_login_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_login_id(input.into());
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn set_external_login_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_login_id(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
