// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelIngestionInput`](crate::input::CancelIngestionInput)
pub mod cancel_ingestion_input {
    /// A builder for [`CancelIngestionInput`](crate::input::CancelIngestionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelIngestionInput`](crate::input::CancelIngestionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelIngestionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelIngestionInput {
                aws_account_id: self.aws_account_id,
                data_set_id: self.data_set_id,
                ingestion_id: self.ingestion_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelIngestionInputOperationOutputAlias = crate::operation::CancelIngestion;
#[doc(hidden)]
pub type CancelIngestionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelIngestionInput {
    /// Consumes the builder and constructs an Operation<[`CancelIngestion`](crate::operation::CancelIngestion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelIngestion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelIngestionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.aws_account_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_1, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.data_set_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_2, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.ingestion_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ingestion_id",
                        details: "cannot be empty or unset",
                    })?;
            let ingestion_id = aws_smithy_http::label::fmt_string(input_3, false);
            if ingestion_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ingestion_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
                AwsAccountId = aws_account_id,
                DataSetId = data_set_id,
                IngestionId = ingestion_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelIngestionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelIngestionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelIngestion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelIngestion",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelIngestionInput`](crate::input::CancelIngestionInput)
    pub fn builder() -> crate::input::cancel_ingestion_input::Builder {
        crate::input::cancel_ingestion_input::Builder::default()
    }
}

/// See [`CreateAccountCustomizationInput`](crate::input::CreateAccountCustomizationInput)
pub mod create_account_customization_input {
    /// A builder for [`CreateAccountCustomizationInput`](crate::input::CreateAccountCustomizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) account_customization: std::option::Option<crate::model::AccountCustomization>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to add customizations to.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to add customizations to.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. You can add these to an Amazon Web Services account and a QuickSight namespace. </p>
        /// <p>For example, you can add a default theme by setting <code>AccountCustomization</code> to the midnight theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by specifying <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>. </p>
        pub fn account_customization(mut self, input: crate::model::AccountCustomization) -> Self {
            self.account_customization = Some(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. You can add these to an Amazon Web Services account and a QuickSight namespace. </p>
        /// <p>For example, you can add a default theme by setting <code>AccountCustomization</code> to the midnight theme: <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by specifying <code>"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }</code>. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.account_customization = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags that you want to attach to this resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tags that you want to attach to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountCustomizationInput`](crate::input::CreateAccountCustomizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccountCustomizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccountCustomizationInput {
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                account_customization: self.account_customization,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccountCustomizationInputOperationOutputAlias =
    crate::operation::CreateAccountCustomization;
#[doc(hidden)]
pub type CreateAccountCustomizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAccountCustomizationInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccountCustomization`](crate::operation::CreateAccountCustomization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccountCustomization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccountCustomizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.aws_account_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_4, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/customizations",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::CreateAccountCustomizationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_5));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccountCustomizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccountCustomizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_account_customization(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccountCustomization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccountCustomization",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccountCustomizationInput`](crate::input::CreateAccountCustomizationInput)
    pub fn builder() -> crate::input::create_account_customization_input::Builder {
        crate::input::create_account_customization_input::Builder::default()
    }
}

/// See [`CreateAnalysisInput`](crate::input::CreateAnalysisInput)
pub mod create_analysis_input {
    /// A builder for [`CreateAnalysisInput`](crate::input::CreateAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<crate::model::Parameters>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) source_entity: std::option::Option<crate::model::AnalysisSourceEntity>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account where you are creating an analysis.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you are creating an analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the analysis that you're creating. This ID displays in the URL of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID for the analysis that you're creating. This ID displays in the URL of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis. You can use the <code>Permissions</code> structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). </p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis. You can use the <code>Permissions</code> structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN). </p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn source_entity(mut self, input: crate::model::AnalysisSourceEntity) -> Self {
            self.source_entity = Some(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::AnalysisSourceEntity>,
        ) -> Self {
            self.source_entity = input;
            self
        }
        /// <p>The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnalysisInput`](crate::input::CreateAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAnalysisInput {
                aws_account_id: self.aws_account_id,
                analysis_id: self.analysis_id,
                name: self.name,
                parameters: self.parameters,
                permissions: self.permissions,
                source_entity: self.source_entity,
                theme_arn: self.theme_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAnalysisInputOperationOutputAlias = crate::operation::CreateAnalysis;
#[doc(hidden)]
pub type CreateAnalysisInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`CreateAnalysis`](crate::operation::CreateAnalysis)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAnalysis,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.aws_account_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_6, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.analysis_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_7, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
                AwsAccountId = aws_account_id,
                AnalysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_analysis(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAnalysis",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAnalysisInput`](crate::input::CreateAnalysisInput)
    pub fn builder() -> crate::input::create_analysis_input::Builder {
        crate::input::create_analysis_input::Builder::default()
    }
}

/// See [`CreateDashboardInput`](crate::input::CreateDashboardInput)
pub mod create_dashboard_input {
    /// A builder for [`CreateDashboardInput`](crate::input::CreateDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<crate::model::Parameters>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) source_entity: std::option::Option<crate::model::DashboardSourceEntity>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) version_description: std::option::Option<std::string::String>,
        pub(crate) dashboard_publish_options:
            std::option::Option<crate::model::DashboardPublishOptions>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN. </p>
        /// <p>To specify no permissions, omit the permissions list.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN. </p>
        /// <p>To specify no permissions, omit the permissions list.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, input: crate::model::DashboardSourceEntity) -> Self {
            self.source_entity = Some(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::DashboardSourceEntity>,
        ) -> Self {
            self.source_entity = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_description = Some(input.into());
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_description = input;
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn dashboard_publish_options(
            mut self,
            input: crate::model::DashboardPublishOptions,
        ) -> Self {
            self.dashboard_publish_options = Some(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn set_dashboard_publish_options(
            mut self,
            input: std::option::Option<crate::model::DashboardPublishOptions>,
        ) -> Self {
            self.dashboard_publish_options = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDashboardInput`](crate::input::CreateDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDashboardInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
                name: self.name,
                parameters: self.parameters,
                permissions: self.permissions,
                source_entity: self.source_entity,
                tags: self.tags,
                version_description: self.version_description,
                dashboard_publish_options: self.dashboard_publish_options,
                theme_arn: self.theme_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDashboardInputOperationOutputAlias = crate::operation::CreateDashboard;
#[doc(hidden)]
pub type CreateDashboardInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDashboardInput {
    /// Consumes the builder and constructs an Operation<[`CreateDashboard`](crate::operation::CreateDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDashboard,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.aws_account_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_8, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.dashboard_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_9, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_dashboard(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDashboard",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDashboardInput`](crate::input::CreateDashboardInput)
    pub fn builder() -> crate::input::create_dashboard_input::Builder {
        crate::input::create_dashboard_input::Builder::default()
    }
}

/// See [`CreateDataSetInput`](crate::input::CreateDataSetInput)
pub mod create_data_set_input {
    /// A builder for [`CreateDataSetInput`](crate::input::CreateDataSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) physical_table_map: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
        >,
        pub(crate) logical_table_map: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
        >,
        pub(crate) import_mode: std::option::Option<crate::model::DataSetImportMode>,
        pub(crate) column_groups: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        pub(crate) field_folders: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
        >,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) row_level_permission_data_set:
            std::option::Option<crate::model::RowLevelPermissionDataSet>,
        pub(crate) row_level_permission_tag_configuration:
            std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        pub(crate) column_level_permission_rules:
            std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) data_set_usage_configuration:
            std::option::Option<crate::model::DataSetUsageConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `physical_table_map`.
        ///
        /// To override the contents of this collection use [`set_physical_table_map`](Self::set_physical_table_map).
        ///
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn physical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::PhysicalTable,
        ) -> Self {
            let mut hash_map = self.physical_table_map.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.physical_table_map = Some(hash_map);
            self
        }
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn set_physical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
            >,
        ) -> Self {
            self.physical_table_map = input;
            self
        }
        /// Adds a key-value pair to `logical_table_map`.
        ///
        /// To override the contents of this collection use [`set_logical_table_map`](Self::set_logical_table_map).
        ///
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn logical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::LogicalTable,
        ) -> Self {
            let mut hash_map = self.logical_table_map.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.logical_table_map = Some(hash_map);
            self
        }
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn set_logical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
            >,
        ) -> Self {
            self.logical_table_map = input;
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn import_mode(mut self, input: crate::model::DataSetImportMode) -> Self {
            self.import_mode = Some(input);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn set_import_mode(
            mut self,
            input: std::option::Option<crate::model::DataSetImportMode>,
        ) -> Self {
            self.import_mode = input;
            self
        }
        /// Appends an item to `column_groups`.
        ///
        /// To override the contents of this collection use [`set_column_groups`](Self::set_column_groups).
        ///
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn column_groups(mut self, input: crate::model::ColumnGroup) -> Self {
            let mut v = self.column_groups.unwrap_or_default();
            v.push(input);
            self.column_groups = Some(v);
            self
        }
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn set_column_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        ) -> Self {
            self.column_groups = input;
            self
        }
        /// Adds a key-value pair to `field_folders`.
        ///
        /// To override the contents of this collection use [`set_field_folders`](Self::set_field_folders).
        ///
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn field_folders(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::FieldFolder,
        ) -> Self {
            let mut hash_map = self.field_folders.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.field_folders = Some(hash_map);
            self
        }
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn set_field_folders(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
            >,
        ) -> Self {
            self.field_folders = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The row-level security configuration for the data that you want to create.</p>
        pub fn row_level_permission_data_set(
            mut self,
            input: crate::model::RowLevelPermissionDataSet,
        ) -> Self {
            self.row_level_permission_data_set = Some(input);
            self
        }
        /// <p>The row-level security configuration for the data that you want to create.</p>
        pub fn set_row_level_permission_data_set(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionDataSet>,
        ) -> Self {
            self.row_level_permission_data_set = input;
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn row_level_permission_tag_configuration(
            mut self,
            input: crate::model::RowLevelPermissionTagConfiguration,
        ) -> Self {
            self.row_level_permission_tag_configuration = Some(input);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn set_row_level_permission_tag_configuration(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        ) -> Self {
            self.row_level_permission_tag_configuration = input;
            self
        }
        /// Appends an item to `column_level_permission_rules`.
        ///
        /// To override the contents of this collection use [`set_column_level_permission_rules`](Self::set_column_level_permission_rules).
        ///
        /// <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
        pub fn column_level_permission_rules(
            mut self,
            input: crate::model::ColumnLevelPermissionRule,
        ) -> Self {
            let mut v = self.column_level_permission_rules.unwrap_or_default();
            v.push(input);
            self.column_level_permission_rules = Some(v);
            self
        }
        /// <p>A set of one or more definitions of a <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>.</p>
        pub fn set_column_level_permission_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        ) -> Self {
            self.column_level_permission_rules = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn data_set_usage_configuration(
            mut self,
            input: crate::model::DataSetUsageConfiguration,
        ) -> Self {
            self.data_set_usage_configuration = Some(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn set_data_set_usage_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSetUsageConfiguration>,
        ) -> Self {
            self.data_set_usage_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSetInput`](crate::input::CreateDataSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSetInput {
                aws_account_id: self.aws_account_id,
                data_set_id: self.data_set_id,
                name: self.name,
                physical_table_map: self.physical_table_map,
                logical_table_map: self.logical_table_map,
                import_mode: self.import_mode,
                column_groups: self.column_groups,
                field_folders: self.field_folders,
                permissions: self.permissions,
                row_level_permission_data_set: self.row_level_permission_data_set,
                row_level_permission_tag_configuration: self.row_level_permission_tag_configuration,
                column_level_permission_rules: self.column_level_permission_rules,
                tags: self.tags,
                data_set_usage_configuration: self.data_set_usage_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSetInputOperationOutputAlias = crate::operation::CreateDataSet;
#[doc(hidden)]
pub type CreateDataSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDataSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataSet`](crate::operation::CreateDataSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.aws_account_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_10, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSet",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSetInput`](crate::input::CreateDataSetInput)
    pub fn builder() -> crate::input::create_data_set_input::Builder {
        crate::input::create_data_set_input::Builder::default()
    }
}

/// See [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
pub mod create_data_source_input {
    /// A builder for [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) data_source_parameters: std::option::Option<crate::model::DataSourceParameters>,
        pub(crate) credentials: std::option::Option<crate::model::DataSourceCredentials>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) vpc_connection_properties:
            std::option::Option<crate::model::VpcConnectionProperties>,
        pub(crate) ssl_properties: std::option::Option<crate::model::SslProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the data source. To return a list of all data sources, use <code>ListDataSources</code>.</p>
        /// <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the data source. To return a list of all data sources, use <code>ListDataSources</code>.</p>
        /// <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn data_source_parameters(mut self, input: crate::model::DataSourceParameters) -> Self {
            self.data_source_parameters = Some(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn set_data_source_parameters(
            mut self,
            input: std::option::Option<crate::model::DataSourceParameters>,
        ) -> Self {
            self.data_source_parameters = input;
            self
        }
        /// <p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
        pub fn credentials(mut self, input: crate::model::DataSourceCredentials) -> Self {
            self.credentials = Some(input);
            self
        }
        /// <p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::DataSourceCredentials>,
        ) -> Self {
            self.credentials = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the data source.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions on the data source.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn vpc_connection_properties(
            mut self,
            input: crate::model::VpcConnectionProperties,
        ) -> Self {
            self.vpc_connection_properties = Some(input);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn set_vpc_connection_properties(
            mut self,
            input: std::option::Option<crate::model::VpcConnectionProperties>,
        ) -> Self {
            self.vpc_connection_properties = input;
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn ssl_properties(mut self, input: crate::model::SslProperties) -> Self {
            self.ssl_properties = Some(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn set_ssl_properties(
            mut self,
            input: std::option::Option<crate::model::SslProperties>,
        ) -> Self {
            self.ssl_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSourceInput {
                aws_account_id: self.aws_account_id,
                data_source_id: self.data_source_id,
                name: self.name,
                r#type: self.r#type,
                data_source_parameters: self.data_source_parameters,
                credentials: self.credentials,
                permissions: self.permissions,
                vpc_connection_properties: self.vpc_connection_properties,
                ssl_properties: self.ssl_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSourceInputOperationOutputAlias = crate::operation::CreateDataSource;
#[doc(hidden)]
pub type CreateDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataSource`](crate::operation::CreateDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.aws_account_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_11, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sources",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSource",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    pub fn builder() -> crate::input::create_data_source_input::Builder {
        crate::input::create_data_source_input::Builder::default()
    }
}

/// See [`CreateFolderInput`](crate::input::CreateFolderInput)
pub mod create_folder_input {
    /// A builder for [`CreateFolderInput`](crate::input::CreateFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) folder_type: std::option::Option<crate::model::FolderType>,
        pub(crate) parent_folder_arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account where you want to create the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account where you want to create the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>
        pub fn folder_type(mut self, input: crate::model::FolderType) -> Self {
            self.folder_type = Some(input);
            self
        }
        /// <p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>
        pub fn set_folder_type(
            mut self,
            input: std::option::Option<crate::model::FolderType>,
        ) -> Self {
            self.folder_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the parent folder.</p>
        /// <p> <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>
        pub fn parent_folder_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_folder_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the parent folder.</p>
        /// <p> <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>
        pub fn set_parent_folder_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_folder_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions of a folder.</p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions of a folder.</p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the folder.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags for the folder.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFolderInput`](crate::input::CreateFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFolderInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
                name: self.name,
                folder_type: self.folder_type,
                parent_folder_arn: self.parent_folder_arn,
                permissions: self.permissions,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFolderInputOperationOutputAlias = crate::operation::CreateFolder;
#[doc(hidden)]
pub type CreateFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFolderInput {
    /// Consumes the builder and constructs an Operation<[`CreateFolder`](crate::operation::CreateFolder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.aws_account_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_12, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.folder_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_13, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}",
                AwsAccountId = aws_account_id,
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_folder(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFolder",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFolderInput`](crate::input::CreateFolderInput)
    pub fn builder() -> crate::input::create_folder_input::Builder {
        crate::input::create_folder_input::Builder::default()
    }
}

/// See [`CreateFolderMembershipInput`](crate::input::CreateFolderMembershipInput)
pub mod create_folder_membership_input {
    /// A builder for [`CreateFolderMembershipInput`](crate::input::CreateFolderMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) member_type: std::option::Option<crate::model::MemberType>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset).</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>
        pub fn member_type(mut self, input: crate::model::MemberType) -> Self {
            self.member_type = Some(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.member_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFolderMembershipInput`](crate::input::CreateFolderMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFolderMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFolderMembershipInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
                member_id: self.member_id,
                member_type: self.member_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFolderMembershipInputOperationOutputAlias = crate::operation::CreateFolderMembership;
#[doc(hidden)]
pub type CreateFolderMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFolderMembershipInput {
    /// Consumes the builder and constructs an Operation<[`CreateFolderMembership`](crate::operation::CreateFolderMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFolderMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFolderMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.aws_account_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_14, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.folder_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_15, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.member_type;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_type",
                        details: "cannot be empty or unset",
                    })?;
            let member_type = aws_smithy_http::label::fmt_string(input_16, false);
            if member_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_type",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.member_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    })?;
            let member_id = aws_smithy_http::label::fmt_string(input_17, false);
            if member_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
                AwsAccountId = aws_account_id,
                FolderId = folder_id,
                MemberType = member_type,
                MemberId = member_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFolderMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFolderMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFolderMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFolderMembership",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFolderMembershipInput`](crate::input::CreateFolderMembershipInput)
    pub fn builder() -> crate::input::create_folder_membership_input::Builder {
        crate::input::create_folder_membership_input::Builder::default()
    }
}

/// See [`CreateGroupInput`](crate::input::CreateGroupInput)
pub mod create_group_input {
    /// A builder for [`CreateGroupInput`](crate::input::CreateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name for the group that you want to create.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>A name for the group that you want to create.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>A description for the group that you want to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the group that you want to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupInput`](crate::input::CreateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupInput {
                group_name: self.group_name,
                description: self.description,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupInputOperationOutputAlias = crate::operation::CreateGroup;
#[doc(hidden)]
pub type CreateGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroup`](crate::operation::CreateGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.aws_account_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_18, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.namespace;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_19, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroup",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
}

/// See [`CreateGroupMembershipInput`](crate::input::CreateGroupMembershipInput)
pub mod create_group_membership_input {
    /// A builder for [`CreateGroupMembershipInput`](crate::input::CreateGroupMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_name: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user that you want to add to the group membership.</p>
        pub fn member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_name = Some(input.into());
            self
        }
        /// <p>The name of the user that you want to add to the group membership.</p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_name = input;
            self
        }
        /// <p>The name of the group that you want to add the user to.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group that you want to add the user to.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupMembershipInput`](crate::input::CreateGroupMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupMembershipInput {
                member_name: self.member_name,
                group_name: self.group_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupMembershipInputOperationOutputAlias = crate::operation::CreateGroupMembership;
#[doc(hidden)]
pub type CreateGroupMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGroupMembershipInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroupMembership`](crate::operation::CreateGroupMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroupMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.aws_account_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_20, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.namespace;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_21, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.group_name;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_name",
                        details: "cannot be empty or unset",
                    })?;
            let group_name = aws_smithy_http::label::fmt_string(input_22, false);
            if group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.member_name;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_name",
                        details: "cannot be empty or unset",
                    })?;
            let member_name = aws_smithy_http::label::fmt_string(input_23, false);
            if member_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}", AwsAccountId = aws_account_id, Namespace = namespace, GroupName = group_name, MemberName = member_name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroupMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroupMembership",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupMembershipInput`](crate::input::CreateGroupMembershipInput)
    pub fn builder() -> crate::input::create_group_membership_input::Builder {
        crate::input::create_group_membership_input::Builder::default()
    }
}

/// See [`CreateIamPolicyAssignmentInput`](crate::input::CreateIamPolicyAssignmentInput)
pub mod create_iam_policy_assignment_input {
    /// A builder for [`CreateIamPolicyAssignmentInput`](crate::input::CreateIamPolicyAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatus>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) identities: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Adds a key-value pair to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identities.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.identities = Some(hash_map);
            self
        }
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.identities = input;
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIamPolicyAssignmentInput`](crate::input::CreateIamPolicyAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIamPolicyAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIamPolicyAssignmentInput {
                aws_account_id: self.aws_account_id,
                assignment_name: self.assignment_name,
                assignment_status: self.assignment_status,
                policy_arn: self.policy_arn,
                identities: self.identities,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIamPolicyAssignmentInputOperationOutputAlias =
    crate::operation::CreateIAMPolicyAssignment;
#[doc(hidden)]
pub type CreateIamPolicyAssignmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIamPolicyAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateIAMPolicyAssignment`](crate::operation::CreateIAMPolicyAssignment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIAMPolicyAssignment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIamPolicyAssignmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.aws_account_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_24, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_25 = &_input.namespace;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_25, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIamPolicyAssignmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIamPolicyAssignmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_iam_policy_assignment(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIAMPolicyAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIAMPolicyAssignment",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIamPolicyAssignmentInput`](crate::input::CreateIamPolicyAssignmentInput)
    pub fn builder() -> crate::input::create_iam_policy_assignment_input::Builder {
        crate::input::create_iam_policy_assignment_input::Builder::default()
    }
}

/// See [`CreateIngestionInput`](crate::input::CreateIngestionInput)
pub mod create_ingestion_input {
    /// A builder for [`CreateIngestionInput`](crate::input::CreateIngestionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_type: std::option::Option<crate::model::IngestionType>,
    }
    impl Builder {
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The type of ingestion that you want to create.</p>
        pub fn ingestion_type(mut self, input: crate::model::IngestionType) -> Self {
            self.ingestion_type = Some(input);
            self
        }
        /// <p>The type of ingestion that you want to create.</p>
        pub fn set_ingestion_type(
            mut self,
            input: std::option::Option<crate::model::IngestionType>,
        ) -> Self {
            self.ingestion_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIngestionInput`](crate::input::CreateIngestionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIngestionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIngestionInput {
                data_set_id: self.data_set_id,
                ingestion_id: self.ingestion_id,
                aws_account_id: self.aws_account_id,
                ingestion_type: self.ingestion_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIngestionInputOperationOutputAlias = crate::operation::CreateIngestion;
#[doc(hidden)]
pub type CreateIngestionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIngestionInput {
    /// Consumes the builder and constructs an Operation<[`CreateIngestion`](crate::operation::CreateIngestion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIngestion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIngestionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.aws_account_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_26, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_27 = &_input.data_set_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_27, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.ingestion_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ingestion_id",
                        details: "cannot be empty or unset",
                    })?;
            let ingestion_id = aws_smithy_http::label::fmt_string(input_28, false);
            if ingestion_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ingestion_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
                AwsAccountId = aws_account_id,
                DataSetId = data_set_id,
                IngestionId = ingestion_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIngestionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIngestionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_ingestion(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIngestion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIngestion",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIngestionInput`](crate::input::CreateIngestionInput)
    pub fn builder() -> crate::input::create_ingestion_input::Builder {
        crate::input::create_ingestion_input::Builder::default()
    }
}

/// See [`CreateNamespaceInput`](crate::input::CreateNamespaceInput)
pub mod create_namespace_input {
    /// A builder for [`CreateNamespaceInput`](crate::input::CreateNamespaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) identity_store: std::option::Option<crate::model::IdentityStore>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The name that you want to use to describe the new namespace.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The name that you want to use to describe the new namespace.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn identity_store(mut self, input: crate::model::IdentityStore) -> Self {
            self.identity_store = Some(input);
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn set_identity_store(
            mut self,
            input: std::option::Option<crate::model::IdentityStore>,
        ) -> Self {
            self.identity_store = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to associate with the namespace that you're creating.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags that you want to associate with the namespace that you're creating.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNamespaceInput`](crate::input::CreateNamespaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNamespaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNamespaceInput {
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                identity_store: self.identity_store,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNamespaceInputOperationOutputAlias = crate::operation::CreateNamespace;
#[doc(hidden)]
pub type CreateNamespaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNamespaceInput {
    /// Consumes the builder and constructs an Operation<[`CreateNamespace`](crate::operation::CreateNamespace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNamespace,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNamespaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.aws_account_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_29, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNamespaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNamespaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_namespace(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNamespace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNamespace",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNamespaceInput`](crate::input::CreateNamespaceInput)
    pub fn builder() -> crate::input::create_namespace_input::Builder {
        crate::input::create_namespace_input::Builder::default()
    }
}

/// See [`CreateTemplateInput`](crate::input::CreateTemplateInput)
pub mod create_template_input {
    /// A builder for [`CreateTemplateInput`](crate::input::CreateTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) source_entity: std::option::Option<crate::model::TemplateSourceEntity>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) version_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>A display name for the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, input: crate::model::TemplateSourceEntity) -> Self {
            self.source_entity = Some(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::TemplateSourceEntity>,
        ) -> Self {
            self.source_entity = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_description = Some(input.into());
            self
        }
        /// <p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTemplateInput`](crate::input::CreateTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTemplateInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                name: self.name,
                permissions: self.permissions,
                source_entity: self.source_entity,
                tags: self.tags,
                version_description: self.version_description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTemplateInputOperationOutputAlias = crate::operation::CreateTemplate;
#[doc(hidden)]
pub type CreateTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateTemplate`](crate::operation::CreateTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.aws_account_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_30, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.template_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_31, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}",
                AwsAccountId = aws_account_id,
                TemplateId = template_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTemplate",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTemplateInput`](crate::input::CreateTemplateInput)
    pub fn builder() -> crate::input::create_template_input::Builder {
        crate::input::create_template_input::Builder::default()
    }
}

/// See [`CreateTemplateAliasInput`](crate::input::CreateTemplateAliasInput)
pub mod create_template_alias_input {
    /// A builder for [`CreateTemplateAliasInput`](crate::input::CreateTemplateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
        pub(crate) template_version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>An ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The name that you want to give to the template alias that you're creating. Don't start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The name that you want to give to the template alias that you're creating. Don't start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// <p>The version number of the template.</p>
        pub fn template_version_number(mut self, input: i64) -> Self {
            self.template_version_number = Some(input);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn set_template_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.template_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTemplateAliasInput`](crate::input::CreateTemplateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTemplateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTemplateAliasInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                alias_name: self.alias_name,
                template_version_number: self.template_version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTemplateAliasInputOperationOutputAlias = crate::operation::CreateTemplateAlias;
#[doc(hidden)]
pub type CreateTemplateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTemplateAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateTemplateAlias`](crate::operation::CreateTemplateAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTemplateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTemplateAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.aws_account_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_32, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.template_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_33, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_34 = &_input.alias_name;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alias_name",
                        details: "cannot be empty or unset",
                    })?;
            let alias_name = aws_smithy_http::label::fmt_string(input_34, false);
            if alias_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alias_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
                AwsAccountId = aws_account_id,
                TemplateId = template_id,
                AliasName = alias_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTemplateAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTemplateAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_template_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTemplateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTemplateAlias",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTemplateAliasInput`](crate::input::CreateTemplateAliasInput)
    pub fn builder() -> crate::input::create_template_alias_input::Builder {
        crate::input::create_template_alias_input::Builder::default()
    }
}

/// See [`CreateThemeInput`](crate::input::CreateThemeInput)
pub mod create_theme_input {
    /// A builder for [`CreateThemeInput`](crate::input::CreateThemeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) base_theme_id: std::option::Option<std::string::String>,
        pub(crate) version_description: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ThemeConfiguration>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account where you want to store the new theme. </p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to store the new theme. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>A display name for the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within an analysis. </p>
        pub fn base_theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_theme_id = Some(input.into());
            self
        }
        /// <p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within an analysis. </p>
        pub fn set_base_theme_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_theme_id = input;
            self
        }
        /// <p>A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_description = Some(input.into());
            self
        }
        /// <p>A description of the first version of the theme that you're creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_description = input;
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn configuration(mut self, input: crate::model::ThemeConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ThemeConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A valid grouping of resource permissions to apply to the new theme. </p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A valid grouping of resource permissions to apply to the new theme. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThemeInput`](crate::input::CreateThemeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThemeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThemeInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                name: self.name,
                base_theme_id: self.base_theme_id,
                version_description: self.version_description,
                configuration: self.configuration,
                permissions: self.permissions,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThemeInputOperationOutputAlias = crate::operation::CreateTheme;
#[doc(hidden)]
pub type CreateThemeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThemeInput {
    /// Consumes the builder and constructs an Operation<[`CreateTheme`](crate::operation::CreateTheme)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTheme,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateThemeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.aws_account_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_35, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_36 = &_input.theme_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_36, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateThemeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateThemeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_theme(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTheme::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTheme",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateThemeInput`](crate::input::CreateThemeInput)
    pub fn builder() -> crate::input::create_theme_input::Builder {
        crate::input::create_theme_input::Builder::default()
    }
}

/// See [`CreateThemeAliasInput`](crate::input::CreateThemeAliasInput)
pub mod create_theme_alias_input {
    /// A builder for [`CreateThemeAliasInput`](crate::input::CreateThemeAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
        pub(crate) theme_version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the theme alias.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>An ID for the theme alias.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The name that you want to give to the theme alias that you are creating. The alias name can't begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The name that you want to give to the theme alias that you are creating. The alias name can't begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// <p>The version number of the theme.</p>
        pub fn theme_version_number(mut self, input: i64) -> Self {
            self.theme_version_number = Some(input);
            self
        }
        /// <p>The version number of the theme.</p>
        pub fn set_theme_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.theme_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThemeAliasInput`](crate::input::CreateThemeAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThemeAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThemeAliasInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                alias_name: self.alias_name,
                theme_version_number: self.theme_version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThemeAliasInputOperationOutputAlias = crate::operation::CreateThemeAlias;
#[doc(hidden)]
pub type CreateThemeAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThemeAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateThemeAlias`](crate::operation::CreateThemeAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateThemeAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateThemeAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.aws_account_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_37, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_38 = &_input.theme_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_38, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_39 = &_input.alias_name;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alias_name",
                        details: "cannot be empty or unset",
                    })?;
            let alias_name = aws_smithy_http::label::fmt_string(input_39, false);
            if alias_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alias_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id,
                AliasName = alias_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateThemeAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateThemeAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_theme_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateThemeAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateThemeAlias",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateThemeAliasInput`](crate::input::CreateThemeAliasInput)
    pub fn builder() -> crate::input::create_theme_alias_input::Builder {
        crate::input::create_theme_alias_input::Builder::default()
    }
}

/// See [`DeleteAccountCustomizationInput`](crate::input::DeleteAccountCustomizationInput)
pub mod delete_account_customization_input {
    /// A builder for [`DeleteAccountCustomizationInput`](crate::input::DeleteAccountCustomizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in this Amazon Web Services Region.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in this Amazon Web Services Region.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Amazon QuickSight namespace that you're deleting the customizations from.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that you're deleting the customizations from.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountCustomizationInput`](crate::input::DeleteAccountCustomizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccountCustomizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccountCustomizationInput {
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccountCustomizationInputOperationOutputAlias =
    crate::operation::DeleteAccountCustomization;
#[doc(hidden)]
pub type DeleteAccountCustomizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccountCustomizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccountCustomization`](crate::operation::DeleteAccountCustomization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccountCustomization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccountCustomizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.aws_account_id;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_40, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/customizations",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteAccountCustomizationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_41));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccountCustomizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccountCustomizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccountCustomization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccountCustomization",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccountCustomizationInput`](crate::input::DeleteAccountCustomizationInput)
    pub fn builder() -> crate::input::delete_account_customization_input::Builder {
        crate::input::delete_account_customization_input::Builder::default()
    }
}

/// See [`DeleteAnalysisInput`](crate::input::DeleteAnalysisInput)
pub mod delete_analysis_input {
    /// A builder for [`DeleteAnalysisInput`](crate::input::DeleteAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) recovery_window_in_days: std::option::Option<i64>,
        pub(crate) force_delete_without_recovery: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the analysis that you're deleting.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis that you're deleting.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can't use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is 30.</p>
        pub fn recovery_window_in_days(mut self, input: i64) -> Self {
            self.recovery_window_in_days = Some(input);
            self
        }
        /// <p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. You can't use this parameter with the <code>ForceDeleteWithoutRecovery</code> option in the same API call. The default value is 30.</p>
        pub fn set_recovery_window_in_days(mut self, input: std::option::Option<i64>) -> Self {
            self.recovery_window_in_days = input;
            self
        }
        /// <p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after it's deleted. </p>
        pub fn force_delete_without_recovery(mut self, input: bool) -> Self {
            self.force_delete_without_recovery = Some(input);
            self
        }
        /// <p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option. You can't restore an analysis after it's deleted. </p>
        pub fn set_force_delete_without_recovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.force_delete_without_recovery = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAnalysisInput`](crate::input::DeleteAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAnalysisInput {
                aws_account_id: self.aws_account_id,
                analysis_id: self.analysis_id,
                recovery_window_in_days: self.recovery_window_in_days,
                force_delete_without_recovery: self
                    .force_delete_without_recovery
                    .unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAnalysisInputOperationOutputAlias = crate::operation::DeleteAnalysis;
#[doc(hidden)]
pub type DeleteAnalysisInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAnalysis`](crate::operation::DeleteAnalysis)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAnalysis,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.aws_account_id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_42, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_43 = &_input.analysis_id;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_43, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
                AwsAccountId = aws_account_id,
                AnalysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteAnalysisInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_44) = &_input.recovery_window_in_days {
                query.push_kv(
                    "recovery-window-in-days",
                    aws_smithy_types::primitive::Encoder::from(*inner_44).encode(),
                );
            }
            if _input.force_delete_without_recovery {
                query.push_kv(
                    "force-delete-without-recovery",
                    aws_smithy_types::primitive::Encoder::from(
                        _input.force_delete_without_recovery,
                    )
                    .encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAnalysis",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAnalysisInput`](crate::input::DeleteAnalysisInput)
    pub fn builder() -> crate::input::delete_analysis_input::Builder {
        crate::input::delete_analysis_input::Builder::default()
    }
}

/// See [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
pub mod delete_dashboard_input {
    /// A builder for [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're deleting.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDashboardInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
                version_number: self.version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDashboardInputOperationOutputAlias = crate::operation::DeleteDashboard;
#[doc(hidden)]
pub type DeleteDashboardInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDashboardInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDashboard`](crate::operation::DeleteDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDashboard,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.aws_account_id;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_45, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_46 = &_input.dashboard_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_46, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteDashboardInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_47) = &_input.version_number {
                query.push_kv(
                    "version-number",
                    aws_smithy_types::primitive::Encoder::from(*inner_47).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDashboard",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDashboardInput`](crate::input::DeleteDashboardInput)
    pub fn builder() -> crate::input::delete_dashboard_input::Builder {
        crate::input::delete_dashboard_input::Builder::default()
    }
}

/// See [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
pub mod delete_data_set_input {
    /// A builder for [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataSetInput {
                aws_account_id: self.aws_account_id,
                data_set_id: self.data_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataSetInputOperationOutputAlias = crate::operation::DeleteDataSet;
#[doc(hidden)]
pub type DeleteDataSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDataSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataSet`](crate::operation::DeleteDataSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.aws_account_id;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_48, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_49 = &_input.data_set_id;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_49, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
                AwsAccountId = aws_account_id,
                DataSetId = data_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataSet",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataSetInput`](crate::input::DeleteDataSetInput)
    pub fn builder() -> crate::input::delete_data_set_input::Builder {
        crate::input::delete_data_set_input::Builder::default()
    }
}

/// See [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
pub mod delete_data_source_input {
    /// A builder for [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataSourceInput {
                aws_account_id: self.aws_account_id,
                data_source_id: self.data_source_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataSourceInputOperationOutputAlias = crate::operation::DeleteDataSource;
#[doc(hidden)]
pub type DeleteDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataSource`](crate::operation::DeleteDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.aws_account_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_50, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_51 = &_input.data_source_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_source_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_source_id = aws_smithy_http::label::fmt_string(input_51, false);
            if data_source_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_source_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
                AwsAccountId = aws_account_id,
                DataSourceId = data_source_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataSource",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    pub fn builder() -> crate::input::delete_data_source_input::Builder {
        crate::input::delete_data_source_input::Builder::default()
    }
}

/// See [`DeleteFolderInput`](crate::input::DeleteFolderInput)
pub mod delete_folder_input {
    /// A builder for [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderInput`](crate::input::DeleteFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFolderInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFolderInputOperationOutputAlias = crate::operation::DeleteFolder;
#[doc(hidden)]
pub type DeleteFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFolderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFolder`](crate::operation::DeleteFolder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.aws_account_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_52, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_53 = &_input.folder_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_53, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}",
                AwsAccountId = aws_account_id,
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFolder",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFolderInput`](crate::input::DeleteFolderInput)
    pub fn builder() -> crate::input::delete_folder_input::Builder {
        crate::input::delete_folder_input::Builder::default()
    }
}

/// See [`DeleteFolderMembershipInput`](crate::input::DeleteFolderMembershipInput)
pub mod delete_folder_membership_input {
    /// A builder for [`DeleteFolderMembershipInput`](crate::input::DeleteFolderMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) member_type: std::option::Option<crate::model::MemberType>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Folder ID.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The Folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code> </p>
        pub fn member_type(mut self, input: crate::model::MemberType) -> Self {
            self.member_type = Some(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code> </p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.member_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderMembershipInput`](crate::input::DeleteFolderMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFolderMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFolderMembershipInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
                member_id: self.member_id,
                member_type: self.member_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFolderMembershipInputOperationOutputAlias = crate::operation::DeleteFolderMembership;
#[doc(hidden)]
pub type DeleteFolderMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFolderMembershipInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFolderMembership`](crate::operation::DeleteFolderMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFolderMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFolderMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.aws_account_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_54, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_55 = &_input.folder_id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_55, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_56 = &_input.member_type;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_type",
                        details: "cannot be empty or unset",
                    })?;
            let member_type = aws_smithy_http::label::fmt_string(input_56, false);
            if member_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_type",
                    details: "cannot be empty or unset",
                });
            }
            let input_57 = &_input.member_id;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    })?;
            let member_id = aws_smithy_http::label::fmt_string(input_57, false);
            if member_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
                AwsAccountId = aws_account_id,
                FolderId = folder_id,
                MemberType = member_type,
                MemberId = member_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFolderMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFolderMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFolderMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFolderMembership",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFolderMembershipInput`](crate::input::DeleteFolderMembershipInput)
    pub fn builder() -> crate::input::delete_folder_membership_input::Builder {
        crate::input::delete_folder_membership_input::Builder::default()
    }
}

/// See [`DeleteGroupInput`](crate::input::DeleteGroupInput)
pub mod delete_group_input {
    /// A builder for [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group that you want to delete.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group that you want to delete.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupInput`](crate::input::DeleteGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupInput {
                group_name: self.group_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupInputOperationOutputAlias = crate::operation::DeleteGroup;
#[doc(hidden)]
pub type DeleteGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroup`](crate::operation::DeleteGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.aws_account_id;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_58, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_59 = &_input.namespace;
            let input_59 =
                input_59
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_59, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_60 = &_input.group_name;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_name",
                        details: "cannot be empty or unset",
                    })?;
            let group_name = aws_smithy_http::label::fmt_string(input_60, false);
            if group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
                AwsAccountId = aws_account_id,
                Namespace = namespace,
                GroupName = group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroup",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
}

/// See [`DeleteGroupMembershipInput`](crate::input::DeleteGroupMembershipInput)
pub mod delete_group_membership_input {
    /// A builder for [`DeleteGroupMembershipInput`](crate::input::DeleteGroupMembershipInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_name: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user that you want to delete from the group membership.</p>
        pub fn member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_name = Some(input.into());
            self
        }
        /// <p>The name of the user that you want to delete from the group membership.</p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_name = input;
            self
        }
        /// <p>The name of the group that you want to delete the user from.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group that you want to delete the user from.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupMembershipInput`](crate::input::DeleteGroupMembershipInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupMembershipInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupMembershipInput {
                member_name: self.member_name,
                group_name: self.group_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupMembershipInputOperationOutputAlias = crate::operation::DeleteGroupMembership;
#[doc(hidden)]
pub type DeleteGroupMembershipInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGroupMembershipInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroupMembership`](crate::operation::DeleteGroupMembership)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroupMembership,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupMembershipInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.aws_account_id;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_61, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_62 = &_input.namespace;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_62, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_63 = &_input.group_name;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_name",
                        details: "cannot be empty or unset",
                    })?;
            let group_name = aws_smithy_http::label::fmt_string(input_63, false);
            if group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_64 = &_input.member_name;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_name",
                        details: "cannot be empty or unset",
                    })?;
            let member_name = aws_smithy_http::label::fmt_string(input_64, false);
            if member_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "member_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}", AwsAccountId = aws_account_id, Namespace = namespace, GroupName = group_name, MemberName = member_name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupMembershipInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupMembershipInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroupMembership::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroupMembership",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupMembershipInput`](crate::input::DeleteGroupMembershipInput)
    pub fn builder() -> crate::input::delete_group_membership_input::Builder {
        crate::input::delete_group_membership_input::Builder::default()
    }
}

/// See [`DeleteIamPolicyAssignmentInput`](crate::input::DeleteIamPolicyAssignmentInput)
pub mod delete_iam_policy_assignment_input {
    /// A builder for [`DeleteIamPolicyAssignmentInput`](crate::input::DeleteIamPolicyAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID where you want to delete the IAM policy assignment.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID where you want to delete the IAM policy assignment.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The name of the assignment. </p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>The name of the assignment. </p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIamPolicyAssignmentInput`](crate::input::DeleteIamPolicyAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIamPolicyAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIamPolicyAssignmentInput {
                aws_account_id: self.aws_account_id,
                assignment_name: self.assignment_name,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIamPolicyAssignmentInputOperationOutputAlias =
    crate::operation::DeleteIAMPolicyAssignment;
#[doc(hidden)]
pub type DeleteIamPolicyAssignmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIamPolicyAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIAMPolicyAssignment`](crate::operation::DeleteIAMPolicyAssignment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIAMPolicyAssignment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIamPolicyAssignmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.aws_account_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_65, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_66 = &_input.namespace;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_66, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_67 = &_input.assignment_name;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assignment_name",
                        details: "cannot be empty or unset",
                    })?;
            let assignment_name = aws_smithy_http::label::fmt_string(input_67, false);
            if assignment_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assignment_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}", AwsAccountId = aws_account_id, Namespace = namespace, AssignmentName = assignment_name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIamPolicyAssignmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIamPolicyAssignmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIAMPolicyAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIAMPolicyAssignment",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIamPolicyAssignmentInput`](crate::input::DeleteIamPolicyAssignmentInput)
    pub fn builder() -> crate::input::delete_iam_policy_assignment_input::Builder {
        crate::input::delete_iam_policy_assignment_input::Builder::default()
    }
}

/// See [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
pub mod delete_namespace_input {
    /// A builder for [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace that you want to delete.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace that you want to delete.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNamespaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNamespaceInput {
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNamespaceInputOperationOutputAlias = crate::operation::DeleteNamespace;
#[doc(hidden)]
pub type DeleteNamespaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteNamespaceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNamespace`](crate::operation::DeleteNamespace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNamespace,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNamespaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_68 = &_input.aws_account_id;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_68, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_69 = &_input.namespace;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_69, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNamespaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNamespaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNamespace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNamespace",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNamespaceInput`](crate::input::DeleteNamespaceInput)
    pub fn builder() -> crate::input::delete_namespace_input::Builder {
        crate::input::delete_namespace_input::Builder::default()
    }
}

/// See [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
pub mod delete_template_input {
    /// A builder for [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the template that you're deleting.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the template you want to delete.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>An ID for the template you want to delete.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>Specifies the version of the template that you want to delete. If you don't provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>Specifies the version of the template that you want to delete. If you don't provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTemplateInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                version_number: self.version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTemplateInputOperationOutputAlias = crate::operation::DeleteTemplate;
#[doc(hidden)]
pub type DeleteTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTemplate`](crate::operation::DeleteTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.aws_account_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_70, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_71 = &_input.template_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_71, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}",
                AwsAccountId = aws_account_id,
                TemplateId = template_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteTemplateInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_72) = &_input.version_number {
                query.push_kv(
                    "version-number",
                    aws_smithy_types::primitive::Encoder::from(*inner_72).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTemplate",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
    pub fn builder() -> crate::input::delete_template_input::Builder {
        crate::input::delete_template_input::Builder::default()
    }
}

/// See [`DeleteTemplateAliasInput`](crate::input::DeleteTemplateAliasInput)
pub mod delete_template_alias_input {
    /// A builder for [`DeleteTemplateAliasInput`](crate::input::DeleteTemplateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the item to delete.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the item to delete.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the template that the specified alias is for.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template that the specified alias is for.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTemplateAliasInput`](crate::input::DeleteTemplateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTemplateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTemplateAliasInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                alias_name: self.alias_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTemplateAliasInputOperationOutputAlias = crate::operation::DeleteTemplateAlias;
#[doc(hidden)]
pub type DeleteTemplateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTemplateAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTemplateAlias`](crate::operation::DeleteTemplateAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTemplateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTemplateAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_73 = &_input.aws_account_id;
            let input_73 =
                input_73
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_73, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_74 = &_input.template_id;
            let input_74 =
                input_74
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_74, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_75 = &_input.alias_name;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alias_name",
                        details: "cannot be empty or unset",
                    })?;
            let alias_name = aws_smithy_http::label::fmt_string(input_75, false);
            if alias_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alias_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
                AwsAccountId = aws_account_id,
                TemplateId = template_id,
                AliasName = alias_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTemplateAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTemplateAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTemplateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTemplateAlias",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTemplateAliasInput`](crate::input::DeleteTemplateAliasInput)
    pub fn builder() -> crate::input::delete_template_alias_input::Builder {
        crate::input::delete_template_alias_input::Builder::default()
    }
}

/// See [`DeleteThemeInput`](crate::input::DeleteThemeInput)
pub mod delete_theme_input {
    /// A builder for [`DeleteThemeInput`](crate::input::DeleteThemeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're deleting.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>An ID for the theme that you want to delete.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>An ID for the theme that you want to delete.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The version of the theme that you want to delete. </p>
        /// <p> <b>Note:</b> If you don't provide a version number, you're using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version of the theme that you want to delete. </p>
        /// <p> <b>Note:</b> If you don't provide a version number, you're using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThemeInput`](crate::input::DeleteThemeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThemeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThemeInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                version_number: self.version_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThemeInputOperationOutputAlias = crate::operation::DeleteTheme;
#[doc(hidden)]
pub type DeleteThemeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThemeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTheme`](crate::operation::DeleteTheme)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTheme,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteThemeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.aws_account_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_76, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_77 = &_input.theme_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_77, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteThemeInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_78) = &_input.version_number {
                query.push_kv(
                    "version-number",
                    aws_smithy_types::primitive::Encoder::from(*inner_78).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteThemeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteThemeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTheme::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTheme",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteThemeInput`](crate::input::DeleteThemeInput)
    pub fn builder() -> crate::input::delete_theme_input::Builder {
        crate::input::delete_theme_input::Builder::default()
    }
}

/// See [`DeleteThemeAliasInput`](crate::input::DeleteThemeAliasInput)
pub mod delete_theme_alias_input {
    /// A builder for [`DeleteThemeAliasInput`](crate::input::DeleteThemeAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the theme that the specified alias is for.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme that the specified alias is for.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The unique name for the theme alias to delete.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The unique name for the theme alias to delete.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThemeAliasInput`](crate::input::DeleteThemeAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThemeAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThemeAliasInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                alias_name: self.alias_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThemeAliasInputOperationOutputAlias = crate::operation::DeleteThemeAlias;
#[doc(hidden)]
pub type DeleteThemeAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThemeAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteThemeAlias`](crate::operation::DeleteThemeAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteThemeAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteThemeAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.aws_account_id;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_79, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_80 = &_input.theme_id;
            let input_80 =
                input_80
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_80, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_81 = &_input.alias_name;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alias_name",
                        details: "cannot be empty or unset",
                    })?;
            let alias_name = aws_smithy_http::label::fmt_string(input_81, false);
            if alias_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alias_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id,
                AliasName = alias_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteThemeAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteThemeAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteThemeAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteThemeAlias",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteThemeAliasInput`](crate::input::DeleteThemeAliasInput)
    pub fn builder() -> crate::input::delete_theme_alias_input::Builder {
        crate::input::delete_theme_alias_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user that you want to delete.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user that you want to delete.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                user_name: self.user_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_82 = &_input.aws_account_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_82, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_83 = &_input.namespace;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_83, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_84 = &_input.user_name;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_name",
                        details: "cannot be empty or unset",
                    })?;
            let user_name = aws_smithy_http::label::fmt_string(input_84, false);
            if user_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
                AwsAccountId = aws_account_id,
                Namespace = namespace,
                UserName = user_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DeleteUserByPrincipalIdInput`](crate::input::DeleteUserByPrincipalIdInput)
pub mod delete_user_by_principal_id_input {
    /// A builder for [`DeleteUserByPrincipalIdInput`](crate::input::DeleteUserByPrincipalIdInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The principal ID of the user.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID of the user.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserByPrincipalIdInput`](crate::input::DeleteUserByPrincipalIdInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserByPrincipalIdInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserByPrincipalIdInput {
                principal_id: self.principal_id,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserByPrincipalIdInputOperationOutputAlias =
    crate::operation::DeleteUserByPrincipalId;
#[doc(hidden)]
pub type DeleteUserByPrincipalIdInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserByPrincipalIdInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserByPrincipalId`](crate::operation::DeleteUserByPrincipalId)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserByPrincipalId,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserByPrincipalIdInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.aws_account_id;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_85, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_86 = &_input.namespace;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_86, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_87 = &_input.principal_id;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "principal_id",
                        details: "cannot be empty or unset",
                    })?;
            let principal_id = aws_smithy_http::label::fmt_string(input_87, false);
            if principal_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "principal_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
                AwsAccountId = aws_account_id,
                Namespace = namespace,
                PrincipalId = principal_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserByPrincipalIdInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserByPrincipalIdInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserByPrincipalId::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserByPrincipalId",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserByPrincipalIdInput`](crate::input::DeleteUserByPrincipalIdInput)
    pub fn builder() -> crate::input::delete_user_by_principal_id_input::Builder {
        crate::input::delete_user_by_principal_id_input::Builder::default()
    }
}

/// See [`DescribeAccountCustomizationInput`](crate::input::DescribeAccountCustomizationInput)
pub mod describe_account_customization_input {
    /// A builder for [`DescribeAccountCustomizationInput`](crate::input::DescribeAccountCustomizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) resolved: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations for.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations for.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The <code>Resolved</code> flag works with the other parameters to determine which view of Amazon QuickSight customizations is returned. You can add this flag to your command to use the same view that Amazon QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations that are configured at different levels. </p>
        pub fn resolved(mut self, input: bool) -> Self {
            self.resolved = Some(input);
            self
        }
        /// <p>The <code>Resolved</code> flag works with the other parameters to determine which view of Amazon QuickSight customizations is returned. You can add this flag to your command to use the same view that Amazon QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations that are configured at different levels. </p>
        pub fn set_resolved(mut self, input: std::option::Option<bool>) -> Self {
            self.resolved = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountCustomizationInput`](crate::input::DescribeAccountCustomizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountCustomizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountCustomizationInput {
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                resolved: self.resolved.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountCustomizationInputOperationOutputAlias =
    crate::operation::DescribeAccountCustomization;
#[doc(hidden)]
pub type DescribeAccountCustomizationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountCustomizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountCustomization`](crate::operation::DescribeAccountCustomization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountCustomization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountCustomizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.aws_account_id;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_88, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/customizations",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeAccountCustomizationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_89) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_89));
            }
            if _input.resolved {
                query.push_kv(
                    "resolved",
                    aws_smithy_types::primitive::Encoder::from(_input.resolved).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountCustomizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountCustomizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountCustomization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountCustomization",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountCustomizationInput`](crate::input::DescribeAccountCustomizationInput)
    pub fn builder() -> crate::input::describe_account_customization_input::Builder {
        crate::input::describe_account_customization_input::Builder::default()
    }
}

/// See [`DescribeAccountSettingsInput`](crate::input::DescribeAccountSettingsInput)
pub mod describe_account_settings_input {
    /// A builder for [`DescribeAccountSettingsInput`](crate::input::DescribeAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountSettingsInput`](crate::input::DescribeAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountSettingsInput {
                aws_account_id: self.aws_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountSettingsInputOperationOutputAlias =
    crate::operation::DescribeAccountSettings;
#[doc(hidden)]
pub type DescribeAccountSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountSettings`](crate::operation::DescribeAccountSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_90 = &_input.aws_account_id;
            let input_90 =
                input_90
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_90, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/settings",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountSettings",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountSettingsInput`](crate::input::DescribeAccountSettingsInput)
    pub fn builder() -> crate::input::describe_account_settings_input::Builder {
        crate::input::describe_account_settings_input::Builder::default()
    }
}

/// See [`DescribeAnalysisInput`](crate::input::DescribeAnalysisInput)
pub mod describe_analysis_input {
    /// A builder for [`DescribeAnalysisInput`](crate::input::DescribeAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the analysis that you're describing. The ID is part of the URL of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis that you're describing. The ID is part of the URL of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnalysisInput`](crate::input::DescribeAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAnalysisInput {
                aws_account_id: self.aws_account_id,
                analysis_id: self.analysis_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAnalysisInputOperationOutputAlias = crate::operation::DescribeAnalysis;
#[doc(hidden)]
pub type DescribeAnalysisInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAnalysis`](crate::operation::DescribeAnalysis)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAnalysis,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_91 = &_input.aws_account_id;
            let input_91 =
                input_91
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_91, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_92 = &_input.analysis_id;
            let input_92 =
                input_92
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_92, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
                AwsAccountId = aws_account_id,
                AnalysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAnalysis",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAnalysisInput`](crate::input::DescribeAnalysisInput)
    pub fn builder() -> crate::input::describe_analysis_input::Builder {
        crate::input::describe_analysis_input::Builder::default()
    }
}

/// See [`DescribeAnalysisPermissionsInput`](crate::input::DescribeAnalysisPermissionsInput)
pub mod describe_analysis_permissions_input {
    /// A builder for [`DescribeAnalysisPermissionsInput`](crate::input::DescribeAnalysisPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're describing. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're describing. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the analysis whose permissions you're describing. The ID is part of the analysis URL.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis whose permissions you're describing. The ID is part of the analysis URL.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnalysisPermissionsInput`](crate::input::DescribeAnalysisPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAnalysisPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAnalysisPermissionsInput {
                aws_account_id: self.aws_account_id,
                analysis_id: self.analysis_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAnalysisPermissionsInputOperationOutputAlias =
    crate::operation::DescribeAnalysisPermissions;
#[doc(hidden)]
pub type DescribeAnalysisPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAnalysisPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAnalysisPermissions`](crate::operation::DescribeAnalysisPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAnalysisPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAnalysisPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_93 = &_input.aws_account_id;
            let input_93 =
                input_93
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_93, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_94 = &_input.analysis_id;
            let input_94 =
                input_94
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_94, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
                AwsAccountId = aws_account_id,
                AnalysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAnalysisPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAnalysisPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAnalysisPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAnalysisPermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAnalysisPermissionsInput`](crate::input::DescribeAnalysisPermissionsInput)
    pub fn builder() -> crate::input::describe_analysis_permissions_input::Builder {
        crate::input::describe_analysis_permissions_input::Builder::default()
    }
}

/// See [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
pub mod describe_dashboard_input {
    /// A builder for [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The version number for the dashboard. If a version number isn't passed, the latest published dashboard version is described. </p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number for the dashboard. If a version number isn't passed, the latest published dashboard version is described. </p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The alias name.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The alias name.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDashboardInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
                version_number: self.version_number,
                alias_name: self.alias_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDashboardInputOperationOutputAlias = crate::operation::DescribeDashboard;
#[doc(hidden)]
pub type DescribeDashboardInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDashboardInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDashboard`](crate::operation::DescribeDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDashboard,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_95 = &_input.aws_account_id;
            let input_95 =
                input_95
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_95, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_96 = &_input.dashboard_id;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_96, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeDashboardInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_97) = &_input.version_number {
                query.push_kv(
                    "version-number",
                    aws_smithy_types::primitive::Encoder::from(*inner_97).encode(),
                );
            }
            if let Some(inner_98) = &_input.alias_name {
                query.push_kv("alias-name", &aws_smithy_http::query::fmt_string(&inner_98));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDashboard",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDashboardInput`](crate::input::DescribeDashboardInput)
    pub fn builder() -> crate::input::describe_dashboard_input::Builder {
        crate::input::describe_dashboard_input::Builder::default()
    }
}

/// See [`DescribeDashboardPermissionsInput`](crate::input::DescribeDashboardPermissionsInput)
pub mod describe_dashboard_permissions_input {
    /// A builder for [`DescribeDashboardPermissionsInput`](crate::input::DescribeDashboardPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing permissions for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing permissions for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard, also added to the IAM policy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDashboardPermissionsInput`](crate::input::DescribeDashboardPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDashboardPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDashboardPermissionsInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDashboardPermissionsInputOperationOutputAlias =
    crate::operation::DescribeDashboardPermissions;
#[doc(hidden)]
pub type DescribeDashboardPermissionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDashboardPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDashboardPermissions`](crate::operation::DescribeDashboardPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDashboardPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDashboardPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_99 = &_input.aws_account_id;
            let input_99 =
                input_99
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_99, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_100 = &_input.dashboard_id;
            let input_100 =
                input_100
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_100, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDashboardPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDashboardPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDashboardPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDashboardPermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDashboardPermissionsInput`](crate::input::DescribeDashboardPermissionsInput)
    pub fn builder() -> crate::input::describe_dashboard_permissions_input::Builder {
        crate::input::describe_dashboard_permissions_input::Builder::default()
    }
}

/// See [`DescribeDataSetInput`](crate::input::DescribeDataSetInput)
pub mod describe_data_set_input {
    /// A builder for [`DescribeDataSetInput`](crate::input::DescribeDataSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSetInput`](crate::input::DescribeDataSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSetInput {
                aws_account_id: self.aws_account_id,
                data_set_id: self.data_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSetInputOperationOutputAlias = crate::operation::DescribeDataSet;
#[doc(hidden)]
pub type DescribeDataSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDataSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSet`](crate::operation::DescribeDataSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_101 = &_input.aws_account_id;
            let input_101 =
                input_101
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_101, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_102 = &_input.data_set_id;
            let input_102 =
                input_102
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_102, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
                AwsAccountId = aws_account_id,
                DataSetId = data_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSet",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSetInput`](crate::input::DescribeDataSetInput)
    pub fn builder() -> crate::input::describe_data_set_input::Builder {
        crate::input::describe_data_set_input::Builder::default()
    }
}

/// See [`DescribeDataSetPermissionsInput`](crate::input::DescribeDataSetPermissionsInput)
pub mod describe_data_set_permissions_input {
    /// A builder for [`DescribeDataSetPermissionsInput`](crate::input::DescribeDataSetPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSetPermissionsInput`](crate::input::DescribeDataSetPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSetPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSetPermissionsInput {
                aws_account_id: self.aws_account_id,
                data_set_id: self.data_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSetPermissionsInputOperationOutputAlias =
    crate::operation::DescribeDataSetPermissions;
#[doc(hidden)]
pub type DescribeDataSetPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDataSetPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSetPermissions`](crate::operation::DescribeDataSetPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSetPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSetPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_103 = &_input.aws_account_id;
            let input_103 =
                input_103
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_103, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_104 = &_input.data_set_id;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_104, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
                AwsAccountId = aws_account_id,
                DataSetId = data_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSetPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSetPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSetPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSetPermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSetPermissionsInput`](crate::input::DescribeDataSetPermissionsInput)
    pub fn builder() -> crate::input::describe_data_set_permissions_input::Builder {
        crate::input::describe_data_set_permissions_input::Builder::default()
    }
}

/// See [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
pub mod describe_data_source_input {
    /// A builder for [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSourceInput {
                aws_account_id: self.aws_account_id,
                data_source_id: self.data_source_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSourceInputOperationOutputAlias = crate::operation::DescribeDataSource;
#[doc(hidden)]
pub type DescribeDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSource`](crate::operation::DescribeDataSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_105 = &_input.aws_account_id;
            let input_105 =
                input_105
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_105, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_106 = &_input.data_source_id;
            let input_106 =
                input_106
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_source_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_source_id = aws_smithy_http::label::fmt_string(input_106, false);
            if data_source_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_source_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
                AwsAccountId = aws_account_id,
                DataSourceId = data_source_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSource",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSourceInput`](crate::input::DescribeDataSourceInput)
    pub fn builder() -> crate::input::describe_data_source_input::Builder {
        crate::input::describe_data_source_input::Builder::default()
    }
}

/// See [`DescribeDataSourcePermissionsInput`](crate::input::DescribeDataSourcePermissionsInput)
pub mod describe_data_source_permissions_input {
    /// A builder for [`DescribeDataSourcePermissionsInput`](crate::input::DescribeDataSourcePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSourcePermissionsInput`](crate::input::DescribeDataSourcePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSourcePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSourcePermissionsInput {
                aws_account_id: self.aws_account_id,
                data_source_id: self.data_source_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSourcePermissionsInputOperationOutputAlias =
    crate::operation::DescribeDataSourcePermissions;
#[doc(hidden)]
pub type DescribeDataSourcePermissionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDataSourcePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSourcePermissions`](crate::operation::DescribeDataSourcePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSourcePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSourcePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_107 = &_input.aws_account_id;
            let input_107 =
                input_107
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_107, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_108 = &_input.data_source_id;
            let input_108 =
                input_108
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_source_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_source_id = aws_smithy_http::label::fmt_string(input_108, false);
            if data_source_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_source_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
                AwsAccountId = aws_account_id,
                DataSourceId = data_source_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSourcePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSourcePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSourcePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSourcePermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSourcePermissionsInput`](crate::input::DescribeDataSourcePermissionsInput)
    pub fn builder() -> crate::input::describe_data_source_permissions_input::Builder {
        crate::input::describe_data_source_permissions_input::Builder::default()
    }
}

/// See [`DescribeFolderInput`](crate::input::DescribeFolderInput)
pub mod describe_folder_input {
    /// A builder for [`DescribeFolderInput`](crate::input::DescribeFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderInput`](crate::input::DescribeFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFolderInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFolderInputOperationOutputAlias = crate::operation::DescribeFolder;
#[doc(hidden)]
pub type DescribeFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFolderInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFolder`](crate::operation::DescribeFolder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_109 = &_input.aws_account_id;
            let input_109 =
                input_109
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_109, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_110 = &_input.folder_id;
            let input_110 =
                input_110
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_110, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}",
                AwsAccountId = aws_account_id,
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFolder",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFolderInput`](crate::input::DescribeFolderInput)
    pub fn builder() -> crate::input::describe_folder_input::Builder {
        crate::input::describe_folder_input::Builder::default()
    }
}

/// See [`DescribeFolderPermissionsInput`](crate::input::DescribeFolderPermissionsInput)
pub mod describe_folder_permissions_input {
    /// A builder for [`DescribeFolderPermissionsInput`](crate::input::DescribeFolderPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderPermissionsInput`](crate::input::DescribeFolderPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFolderPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFolderPermissionsInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFolderPermissionsInputOperationOutputAlias =
    crate::operation::DescribeFolderPermissions;
#[doc(hidden)]
pub type DescribeFolderPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFolderPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFolderPermissions`](crate::operation::DescribeFolderPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFolderPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFolderPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_111 = &_input.aws_account_id;
            let input_111 =
                input_111
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_111, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_112 = &_input.folder_id;
            let input_112 =
                input_112
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_112, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
                AwsAccountId = aws_account_id,
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFolderPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFolderPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFolderPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFolderPermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFolderPermissionsInput`](crate::input::DescribeFolderPermissionsInput)
    pub fn builder() -> crate::input::describe_folder_permissions_input::Builder {
        crate::input::describe_folder_permissions_input::Builder::default()
    }
}

/// See [`DescribeFolderResolvedPermissionsInput`](crate::input::DescribeFolderResolvedPermissionsInput)
pub mod describe_folder_resolved_permissions_input {
    /// A builder for [`DescribeFolderResolvedPermissionsInput`](crate::input::DescribeFolderResolvedPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderResolvedPermissionsInput`](crate::input::DescribeFolderResolvedPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFolderResolvedPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFolderResolvedPermissionsInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFolderResolvedPermissionsInputOperationOutputAlias =
    crate::operation::DescribeFolderResolvedPermissions;
#[doc(hidden)]
pub type DescribeFolderResolvedPermissionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFolderResolvedPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFolderResolvedPermissions`](crate::operation::DescribeFolderResolvedPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFolderResolvedPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFolderResolvedPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_113 = &_input.aws_account_id;
            let input_113 =
                input_113
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_113, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_114 = &_input.folder_id;
            let input_114 =
                input_114
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_114, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}/resolved-permissions",
                AwsAccountId = aws_account_id,
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFolderResolvedPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFolderResolvedPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFolderResolvedPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFolderResolvedPermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFolderResolvedPermissionsInput`](crate::input::DescribeFolderResolvedPermissionsInput)
    pub fn builder() -> crate::input::describe_folder_resolved_permissions_input::Builder {
        crate::input::describe_folder_resolved_permissions_input::Builder::default()
    }
}

/// See [`DescribeGroupInput`](crate::input::DescribeGroupInput)
pub mod describe_group_input {
    /// A builder for [`DescribeGroupInput`](crate::input::DescribeGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group that you want to describe.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group that you want to describe.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGroupInput`](crate::input::DescribeGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGroupInput {
                group_name: self.group_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGroupInputOperationOutputAlias = crate::operation::DescribeGroup;
#[doc(hidden)]
pub type DescribeGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGroup`](crate::operation::DescribeGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_115 = &_input.aws_account_id;
            let input_115 =
                input_115
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_115, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_116 = &_input.namespace;
            let input_116 =
                input_116
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_116, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_117 = &_input.group_name;
            let input_117 =
                input_117
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_name",
                        details: "cannot be empty or unset",
                    })?;
            let group_name = aws_smithy_http::label::fmt_string(input_117, false);
            if group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
                AwsAccountId = aws_account_id,
                Namespace = namespace,
                GroupName = group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGroup",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGroupInput`](crate::input::DescribeGroupInput)
    pub fn builder() -> crate::input::describe_group_input::Builder {
        crate::input::describe_group_input::Builder::default()
    }
}

/// See [`DescribeIamPolicyAssignmentInput`](crate::input::DescribeIamPolicyAssignmentInput)
pub mod describe_iam_policy_assignment_input {
    /// A builder for [`DescribeIamPolicyAssignmentInput`](crate::input::DescribeIamPolicyAssignmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The name of the assignment, also called a rule.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>The name of the assignment, also called a rule.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIamPolicyAssignmentInput`](crate::input::DescribeIamPolicyAssignmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIamPolicyAssignmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIamPolicyAssignmentInput {
                aws_account_id: self.aws_account_id,
                assignment_name: self.assignment_name,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIamPolicyAssignmentInputOperationOutputAlias =
    crate::operation::DescribeIAMPolicyAssignment;
#[doc(hidden)]
pub type DescribeIamPolicyAssignmentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeIamPolicyAssignmentInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIAMPolicyAssignment`](crate::operation::DescribeIAMPolicyAssignment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIAMPolicyAssignment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIamPolicyAssignmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_118 = &_input.aws_account_id;
            let input_118 =
                input_118
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_118, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_119 = &_input.namespace;
            let input_119 =
                input_119
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_119, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_120 = &_input.assignment_name;
            let input_120 =
                input_120
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assignment_name",
                        details: "cannot be empty or unset",
                    })?;
            let assignment_name = aws_smithy_http::label::fmt_string(input_120, false);
            if assignment_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assignment_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}", AwsAccountId = aws_account_id, Namespace = namespace, AssignmentName = assignment_name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIamPolicyAssignmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIamPolicyAssignmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIAMPolicyAssignment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIAMPolicyAssignment",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIamPolicyAssignmentInput`](crate::input::DescribeIamPolicyAssignmentInput)
    pub fn builder() -> crate::input::describe_iam_policy_assignment_input::Builder {
        crate::input::describe_iam_policy_assignment_input::Builder::default()
    }
}

/// See [`DescribeIngestionInput`](crate::input::DescribeIngestionInput)
pub mod describe_ingestion_input {
    /// A builder for [`DescribeIngestionInput`](crate::input::DescribeIngestionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIngestionInput`](crate::input::DescribeIngestionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIngestionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIngestionInput {
                aws_account_id: self.aws_account_id,
                data_set_id: self.data_set_id,
                ingestion_id: self.ingestion_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIngestionInputOperationOutputAlias = crate::operation::DescribeIngestion;
#[doc(hidden)]
pub type DescribeIngestionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeIngestionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIngestion`](crate::operation::DescribeIngestion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIngestion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIngestionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_121 = &_input.aws_account_id;
            let input_121 =
                input_121
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_121, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_122 = &_input.data_set_id;
            let input_122 =
                input_122
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_122, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_123 = &_input.ingestion_id;
            let input_123 =
                input_123
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ingestion_id",
                        details: "cannot be empty or unset",
                    })?;
            let ingestion_id = aws_smithy_http::label::fmt_string(input_123, false);
            if ingestion_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ingestion_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
                AwsAccountId = aws_account_id,
                DataSetId = data_set_id,
                IngestionId = ingestion_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIngestionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIngestionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIngestion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIngestion",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIngestionInput`](crate::input::DescribeIngestionInput)
    pub fn builder() -> crate::input::describe_ingestion_input::Builder {
        crate::input::describe_ingestion_input::Builder::default()
    }
}

/// See [`DescribeIpRestrictionInput`](crate::input::DescribeIpRestrictionInput)
pub mod describe_ip_restriction_input {
    /// A builder for [`DescribeIpRestrictionInput`](crate::input::DescribeIpRestrictionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIpRestrictionInput`](crate::input::DescribeIpRestrictionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIpRestrictionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIpRestrictionInput {
                aws_account_id: self.aws_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIpRestrictionInputOperationOutputAlias = crate::operation::DescribeIpRestriction;
#[doc(hidden)]
pub type DescribeIpRestrictionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeIpRestrictionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIpRestriction`](crate::operation::DescribeIpRestriction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIpRestriction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIpRestrictionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_124 = &_input.aws_account_id;
            let input_124 =
                input_124
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_124, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/ip-restriction",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIpRestrictionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIpRestrictionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIpRestriction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIpRestriction",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIpRestrictionInput`](crate::input::DescribeIpRestrictionInput)
    pub fn builder() -> crate::input::describe_ip_restriction_input::Builder {
        crate::input::describe_ip_restriction_input::Builder::default()
    }
}

/// See [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
pub mod describe_namespace_input {
    /// A builder for [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace that you want to describe.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace that you want to describe.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNamespaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNamespaceInput {
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNamespaceInputOperationOutputAlias = crate::operation::DescribeNamespace;
#[doc(hidden)]
pub type DescribeNamespaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeNamespaceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNamespace`](crate::operation::DescribeNamespace)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNamespace,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNamespaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_125 = &_input.aws_account_id;
            let input_125 =
                input_125
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_125, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_126 = &_input.namespace;
            let input_126 =
                input_126
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_126, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNamespaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNamespaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNamespace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNamespace",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNamespaceInput`](crate::input::DescribeNamespaceInput)
    pub fn builder() -> crate::input::describe_namespace_input::Builder {
        crate::input::describe_namespace_input::Builder::default()
    }
}

/// See [`DescribeTemplateInput`](crate::input::DescribeTemplateInput)
pub mod describe_template_input {
    /// A builder for [`DescribeTemplateInput`](crate::input::DescribeTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the template is described.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the template is described.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTemplateInput`](crate::input::DescribeTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTemplateInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                version_number: self.version_number,
                alias_name: self.alias_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTemplateInputOperationOutputAlias = crate::operation::DescribeTemplate;
#[doc(hidden)]
pub type DescribeTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTemplate`](crate::operation::DescribeTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_127 = &_input.aws_account_id;
            let input_127 =
                input_127
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_127, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_128 = &_input.template_id;
            let input_128 =
                input_128
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_128, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}",
                AwsAccountId = aws_account_id,
                TemplateId = template_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeTemplateInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_129) = &_input.version_number {
                query.push_kv(
                    "version-number",
                    aws_smithy_types::primitive::Encoder::from(*inner_129).encode(),
                );
            }
            if let Some(inner_130) = &_input.alias_name {
                query.push_kv(
                    "alias-name",
                    &aws_smithy_http::query::fmt_string(&inner_130),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTemplate",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTemplateInput`](crate::input::DescribeTemplateInput)
    pub fn builder() -> crate::input::describe_template_input::Builder {
        crate::input::describe_template_input::Builder::default()
    }
}

/// See [`DescribeTemplateAliasInput`](crate::input::DescribeTemplateAliasInput)
pub mod describe_template_alias_input {
    /// A builder for [`DescribeTemplateAliasInput`](crate::input::DescribeTemplateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTemplateAliasInput`](crate::input::DescribeTemplateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTemplateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTemplateAliasInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                alias_name: self.alias_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTemplateAliasInputOperationOutputAlias = crate::operation::DescribeTemplateAlias;
#[doc(hidden)]
pub type DescribeTemplateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTemplateAliasInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTemplateAlias`](crate::operation::DescribeTemplateAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTemplateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTemplateAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_131 = &_input.aws_account_id;
            let input_131 =
                input_131
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_131, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_132 = &_input.template_id;
            let input_132 =
                input_132
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_132, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_133 = &_input.alias_name;
            let input_133 =
                input_133
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alias_name",
                        details: "cannot be empty or unset",
                    })?;
            let alias_name = aws_smithy_http::label::fmt_string(input_133, false);
            if alias_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alias_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
                AwsAccountId = aws_account_id,
                TemplateId = template_id,
                AliasName = alias_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTemplateAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTemplateAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTemplateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTemplateAlias",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTemplateAliasInput`](crate::input::DescribeTemplateAliasInput)
    pub fn builder() -> crate::input::describe_template_alias_input::Builder {
        crate::input::describe_template_alias_input::Builder::default()
    }
}

/// See [`DescribeTemplatePermissionsInput`](crate::input::DescribeTemplatePermissionsInput)
pub mod describe_template_permissions_input {
    /// A builder for [`DescribeTemplatePermissionsInput`](crate::input::DescribeTemplatePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTemplatePermissionsInput`](crate::input::DescribeTemplatePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTemplatePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTemplatePermissionsInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTemplatePermissionsInputOperationOutputAlias =
    crate::operation::DescribeTemplatePermissions;
#[doc(hidden)]
pub type DescribeTemplatePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTemplatePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTemplatePermissions`](crate::operation::DescribeTemplatePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTemplatePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTemplatePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_134 = &_input.aws_account_id;
            let input_134 =
                input_134
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_134, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_135 = &_input.template_id;
            let input_135 =
                input_135
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_135, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
                AwsAccountId = aws_account_id,
                TemplateId = template_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTemplatePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTemplatePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTemplatePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTemplatePermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTemplatePermissionsInput`](crate::input::DescribeTemplatePermissionsInput)
    pub fn builder() -> crate::input::describe_template_permissions_input::Builder {
        crate::input::describe_template_permissions_input::Builder::default()
    }
}

/// See [`DescribeThemeInput`](crate::input::DescribeThemeInput)
pub mod describe_theme_input {
    /// A builder for [`DescribeThemeInput`](crate::input::DescribeThemeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the theme is described.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn't provided, the latest version of the theme is described.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to themes.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn't apply to themes.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThemeInput`](crate::input::DescribeThemeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThemeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThemeInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                version_number: self.version_number,
                alias_name: self.alias_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThemeInputOperationOutputAlias = crate::operation::DescribeTheme;
#[doc(hidden)]
pub type DescribeThemeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThemeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTheme`](crate::operation::DescribeTheme)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTheme,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeThemeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_136 = &_input.aws_account_id;
            let input_136 =
                input_136
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_136, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_137 = &_input.theme_id;
            let input_137 =
                input_137
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_137, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeThemeInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_138) = &_input.version_number {
                query.push_kv(
                    "version-number",
                    aws_smithy_types::primitive::Encoder::from(*inner_138).encode(),
                );
            }
            if let Some(inner_139) = &_input.alias_name {
                query.push_kv(
                    "alias-name",
                    &aws_smithy_http::query::fmt_string(&inner_139),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeThemeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeThemeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTheme::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTheme",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeThemeInput`](crate::input::DescribeThemeInput)
    pub fn builder() -> crate::input::describe_theme_input::Builder {
        crate::input::describe_theme_input::Builder::default()
    }
}

/// See [`DescribeThemeAliasInput`](crate::input::DescribeThemeAliasInput)
pub mod describe_theme_alias_input {
    /// A builder for [`DescribeThemeAliasInput`](crate::input::DescribeThemeAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The name of the theme alias that you want to describe.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The name of the theme alias that you want to describe.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThemeAliasInput`](crate::input::DescribeThemeAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThemeAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThemeAliasInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                alias_name: self.alias_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThemeAliasInputOperationOutputAlias = crate::operation::DescribeThemeAlias;
#[doc(hidden)]
pub type DescribeThemeAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThemeAliasInput {
    /// Consumes the builder and constructs an Operation<[`DescribeThemeAlias`](crate::operation::DescribeThemeAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeThemeAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeThemeAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_140 = &_input.aws_account_id;
            let input_140 =
                input_140
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_140, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_141 = &_input.theme_id;
            let input_141 =
                input_141
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_141, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_142 = &_input.alias_name;
            let input_142 =
                input_142
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "alias_name",
                        details: "cannot be empty or unset",
                    })?;
            let alias_name = aws_smithy_http::label::fmt_string(input_142, false);
            if alias_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "alias_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id,
                AliasName = alias_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeThemeAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeThemeAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeThemeAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeThemeAlias",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeThemeAliasInput`](crate::input::DescribeThemeAliasInput)
    pub fn builder() -> crate::input::describe_theme_alias_input::Builder {
        crate::input::describe_theme_alias_input::Builder::default()
    }
}

/// See [`DescribeThemePermissionsInput`](crate::input::DescribeThemePermissionsInput)
pub mod describe_theme_permissions_input {
    /// A builder for [`DescribeThemePermissionsInput`](crate::input::DescribeThemePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the theme that you want to describe permissions for.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme that you want to describe permissions for.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThemePermissionsInput`](crate::input::DescribeThemePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThemePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThemePermissionsInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThemePermissionsInputOperationOutputAlias =
    crate::operation::DescribeThemePermissions;
#[doc(hidden)]
pub type DescribeThemePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThemePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeThemePermissions`](crate::operation::DescribeThemePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeThemePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeThemePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_143 = &_input.aws_account_id;
            let input_143 =
                input_143
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_143, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_144 = &_input.theme_id;
            let input_144 =
                input_144
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_144, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeThemePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeThemePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeThemePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeThemePermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeThemePermissionsInput`](crate::input::DescribeThemePermissionsInput)
    pub fn builder() -> crate::input::describe_theme_permissions_input::Builder {
        crate::input::describe_theme_permissions_input::Builder::default()
    }
}

/// See [`DescribeUserInput`](crate::input::DescribeUserInput)
pub mod describe_user_input {
    /// A builder for [`DescribeUserInput`](crate::input::DescribeUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user that you want to describe.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user that you want to describe.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserInput`](crate::input::DescribeUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserInput {
                user_name: self.user_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserInputOperationOutputAlias = crate::operation::DescribeUser;
#[doc(hidden)]
pub type DescribeUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUser`](crate::operation::DescribeUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_145 = &_input.aws_account_id;
            let input_145 =
                input_145
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_145, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_146 = &_input.namespace;
            let input_146 =
                input_146
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_146, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_147 = &_input.user_name;
            let input_147 =
                input_147
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_name",
                        details: "cannot be empty or unset",
                    })?;
            let user_name = aws_smithy_http::label::fmt_string(input_147, false);
            if user_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
                AwsAccountId = aws_account_id,
                Namespace = namespace,
                UserName = user_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUser",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
}

/// See [`GenerateEmbedUrlForAnonymousUserInput`](crate::input::GenerateEmbedUrlForAnonymousUserInput)
pub mod generate_embed_url_for_anonymous_user_input {
    /// A builder for [`GenerateEmbedUrlForAnonymousUserInput`](crate::input::GenerateEmbedUrlForAnonymousUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) session_lifetime_in_minutes: std::option::Option<i64>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) session_tags: std::option::Option<std::vec::Vec<crate::model::SessionTag>>,
        pub(crate) authorized_resource_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) experience_configuration:
            std::option::Option<crate::model::AnonymousUserEmbeddingExperienceConfiguration>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.session_lifetime_in_minutes = Some(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.session_lifetime_in_minutes = input;
            self
        }
        /// <p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `session_tags`.
        ///
        /// To override the contents of this collection use [`set_session_tags`](Self::set_session_tags).
        ///
        /// <p>The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p>
        /// <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>
        pub fn session_tags(mut self, input: crate::model::SessionTag) -> Self {
            let mut v = self.session_tags.unwrap_or_default();
            v.push(input);
            self.session_tags = Some(v);
            self
        }
        /// <p>The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p>
        /// <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>
        pub fn set_session_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SessionTag>>,
        ) -> Self {
            self.session_tags = input;
            self
        }
        /// Appends an item to `authorized_resource_arns`.
        ///
        /// To override the contents of this collection use [`set_authorized_resource_arns`](Self::set_authorized_resource_arns).
        ///
        /// <p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>
        pub fn authorized_resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.authorized_resource_arns.unwrap_or_default();
            v.push(input.into());
            self.authorized_resource_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>
        pub fn set_authorized_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.authorized_resource_arns = input;
            self
        }
        /// <p>The configuration of the experience you are embedding.</p>
        pub fn experience_configuration(
            mut self,
            input: crate::model::AnonymousUserEmbeddingExperienceConfiguration,
        ) -> Self {
            self.experience_configuration = Some(input);
            self
        }
        /// <p>The configuration of the experience you are embedding.</p>
        pub fn set_experience_configuration(
            mut self,
            input: std::option::Option<crate::model::AnonymousUserEmbeddingExperienceConfiguration>,
        ) -> Self {
            self.experience_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateEmbedUrlForAnonymousUserInput`](crate::input::GenerateEmbedUrlForAnonymousUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateEmbedUrlForAnonymousUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateEmbedUrlForAnonymousUserInput {
                aws_account_id: self.aws_account_id,
                session_lifetime_in_minutes: self.session_lifetime_in_minutes,
                namespace: self.namespace,
                session_tags: self.session_tags,
                authorized_resource_arns: self.authorized_resource_arns,
                experience_configuration: self.experience_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateEmbedUrlForAnonymousUserInputOperationOutputAlias =
    crate::operation::GenerateEmbedUrlForAnonymousUser;
#[doc(hidden)]
pub type GenerateEmbedUrlForAnonymousUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GenerateEmbedUrlForAnonymousUserInput {
    /// Consumes the builder and constructs an Operation<[`GenerateEmbedUrlForAnonymousUser`](crate::operation::GenerateEmbedUrlForAnonymousUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateEmbedUrlForAnonymousUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateEmbedUrlForAnonymousUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_148 = &_input.aws_account_id;
            let input_148 =
                input_148
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_148, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/embed-url/anonymous-user",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateEmbedUrlForAnonymousUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateEmbedUrlForAnonymousUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_embed_url_for_anonymous_user(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateEmbedUrlForAnonymousUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateEmbedUrlForAnonymousUser",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateEmbedUrlForAnonymousUserInput`](crate::input::GenerateEmbedUrlForAnonymousUserInput)
    pub fn builder() -> crate::input::generate_embed_url_for_anonymous_user_input::Builder {
        crate::input::generate_embed_url_for_anonymous_user_input::Builder::default()
    }
}

/// See [`GenerateEmbedUrlForRegisteredUserInput`](crate::input::GenerateEmbedUrlForRegisteredUserInput)
pub mod generate_embed_url_for_registered_user_input {
    /// A builder for [`GenerateEmbedUrlForRegisteredUserInput`](crate::input::GenerateEmbedUrlForRegisteredUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) session_lifetime_in_minutes: std::option::Option<i64>,
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) experience_configuration:
            std::option::Option<crate::model::RegisteredUserEmbeddingExperienceConfiguration>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.session_lifetime_in_minutes = Some(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.session_lifetime_in_minutes = input;
            self
        }
        /// <p>The Amazon Resource Name for the registered user.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name for the registered user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards or the entire Amazon QuickSight console.</p>
        pub fn experience_configuration(
            mut self,
            input: crate::model::RegisteredUserEmbeddingExperienceConfiguration,
        ) -> Self {
            self.experience_configuration = Some(input);
            self
        }
        /// <p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards or the entire Amazon QuickSight console.</p>
        pub fn set_experience_configuration(
            mut self,
            input: std::option::Option<
                crate::model::RegisteredUserEmbeddingExperienceConfiguration,
            >,
        ) -> Self {
            self.experience_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateEmbedUrlForRegisteredUserInput`](crate::input::GenerateEmbedUrlForRegisteredUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateEmbedUrlForRegisteredUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateEmbedUrlForRegisteredUserInput {
                aws_account_id: self.aws_account_id,
                session_lifetime_in_minutes: self.session_lifetime_in_minutes,
                user_arn: self.user_arn,
                experience_configuration: self.experience_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateEmbedUrlForRegisteredUserInputOperationOutputAlias =
    crate::operation::GenerateEmbedUrlForRegisteredUser;
#[doc(hidden)]
pub type GenerateEmbedUrlForRegisteredUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GenerateEmbedUrlForRegisteredUserInput {
    /// Consumes the builder and constructs an Operation<[`GenerateEmbedUrlForRegisteredUser`](crate::operation::GenerateEmbedUrlForRegisteredUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateEmbedUrlForRegisteredUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateEmbedUrlForRegisteredUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_149 = &_input.aws_account_id;
            let input_149 =
                input_149
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_149, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/embed-url/registered-user",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateEmbedUrlForRegisteredUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateEmbedUrlForRegisteredUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_embed_url_for_registered_user(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateEmbedUrlForRegisteredUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateEmbedUrlForRegisteredUser",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateEmbedUrlForRegisteredUserInput`](crate::input::GenerateEmbedUrlForRegisteredUserInput)
    pub fn builder() -> crate::input::generate_embed_url_for_registered_user_input::Builder {
        crate::input::generate_embed_url_for_registered_user_input::Builder::default()
    }
}

/// See [`GetDashboardEmbedUrlInput`](crate::input::GetDashboardEmbedUrlInput)
pub mod get_dashboard_embed_url_input {
    /// A builder for [`GetDashboardEmbedUrlInput`](crate::input::GetDashboardEmbedUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) identity_type: std::option::Option<crate::model::EmbeddingIdentityType>,
        pub(crate) session_lifetime_in_minutes: std::option::Option<i64>,
        pub(crate) undo_redo_disabled: std::option::Option<bool>,
        pub(crate) reset_disabled: std::option::Option<bool>,
        pub(crate) state_persistence_enabled: std::option::Option<bool>,
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) additional_dashboard_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The authentication method that the user uses to sign in.</p>
        pub fn identity_type(mut self, input: crate::model::EmbeddingIdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>The authentication method that the user uses to sign in.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::EmbeddingIdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.session_lifetime_in_minutes = Some(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.session_lifetime_in_minutes = input;
            self
        }
        /// <p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>
        pub fn undo_redo_disabled(mut self, input: bool) -> Self {
            self.undo_redo_disabled = Some(input);
            self
        }
        /// <p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>
        pub fn set_undo_redo_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.undo_redo_disabled = input;
            self
        }
        /// <p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>
        pub fn reset_disabled(mut self, input: bool) -> Self {
            self.reset_disabled = Some(input);
            self
        }
        /// <p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>
        pub fn set_reset_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.reset_disabled = input;
            self
        }
        /// <p>Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.</p>
        pub fn state_persistence_enabled(mut self, input: bool) -> Self {
            self.state_persistence_enabled = Some(input);
            self
        }
        /// <p>Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is <code>FALSE</code>.</p>
        pub fn set_state_persistence_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.state_persistence_enabled = input;
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p>
        /// <ul>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li>
        /// </ul>
        /// <p>Omit this parameter for users in the third group – IAM users and IAM role-based sessions.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p>
        /// <ul>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li>
        /// </ul>
        /// <p>Omit this parameter for users in the third group – IAM users and IAM role-based sessions.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace, set <code>Namespace = default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace, set <code>Namespace = default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `additional_dashboard_ids`.
        ///
        /// To override the contents of this collection use [`set_additional_dashboard_ids`](Self::set_additional_dashboard_ids).
        ///
        /// <p>A list of one or more dashboard IDs that you want to add to a session that includes anonymous users. The <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> for this to work, because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "<code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can access all three dashboards. </p>
        pub fn additional_dashboard_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.additional_dashboard_ids.unwrap_or_default();
            v.push(input.into());
            self.additional_dashboard_ids = Some(v);
            self
        }
        /// <p>A list of one or more dashboard IDs that you want to add to a session that includes anonymous users. The <code>IdentityType</code> parameter must be set to <code>ANONYMOUS</code> for this to work, because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "<code>--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session can access all three dashboards. </p>
        pub fn set_additional_dashboard_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_dashboard_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDashboardEmbedUrlInput`](crate::input::GetDashboardEmbedUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDashboardEmbedUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDashboardEmbedUrlInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
                identity_type: self.identity_type,
                session_lifetime_in_minutes: self.session_lifetime_in_minutes,
                undo_redo_disabled: self.undo_redo_disabled.unwrap_or_default(),
                reset_disabled: self.reset_disabled.unwrap_or_default(),
                state_persistence_enabled: self.state_persistence_enabled.unwrap_or_default(),
                user_arn: self.user_arn,
                namespace: self.namespace,
                additional_dashboard_ids: self.additional_dashboard_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDashboardEmbedUrlInputOperationOutputAlias = crate::operation::GetDashboardEmbedUrl;
#[doc(hidden)]
pub type GetDashboardEmbedUrlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDashboardEmbedUrlInput {
    /// Consumes the builder and constructs an Operation<[`GetDashboardEmbedUrl`](crate::operation::GetDashboardEmbedUrl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDashboardEmbedUrl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDashboardEmbedUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_150 = &_input.aws_account_id;
            let input_150 =
                input_150
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_150, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_151 = &_input.dashboard_id;
            let input_151 =
                input_151
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_151, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetDashboardEmbedUrlInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_152) = &_input.identity_type {
                query.push_kv(
                    "creds-type",
                    &aws_smithy_http::query::fmt_string(&inner_152),
                );
            }
            if let Some(inner_153) = &_input.session_lifetime_in_minutes {
                query.push_kv(
                    "session-lifetime",
                    aws_smithy_types::primitive::Encoder::from(*inner_153).encode(),
                );
            }
            if _input.undo_redo_disabled {
                query.push_kv(
                    "undo-redo-disabled",
                    aws_smithy_types::primitive::Encoder::from(_input.undo_redo_disabled).encode(),
                );
            }
            if _input.reset_disabled {
                query.push_kv(
                    "reset-disabled",
                    aws_smithy_types::primitive::Encoder::from(_input.reset_disabled).encode(),
                );
            }
            if _input.state_persistence_enabled {
                query.push_kv(
                    "state-persistence-enabled",
                    aws_smithy_types::primitive::Encoder::from(_input.state_persistence_enabled)
                        .encode(),
                );
            }
            if let Some(inner_154) = &_input.user_arn {
                query.push_kv("user-arn", &aws_smithy_http::query::fmt_string(&inner_154));
            }
            if let Some(inner_155) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_155));
            }
            if let Some(inner_156) = &_input.additional_dashboard_ids {
                for inner_157 in inner_156 {
                    query.push_kv(
                        "additional-dashboard-ids",
                        &aws_smithy_http::query::fmt_string(&inner_157),
                    );
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDashboardEmbedUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDashboardEmbedUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDashboardEmbedUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDashboardEmbedUrl",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDashboardEmbedUrlInput`](crate::input::GetDashboardEmbedUrlInput)
    pub fn builder() -> crate::input::get_dashboard_embed_url_input::Builder {
        crate::input::get_dashboard_embed_url_input::Builder::default()
    }
}

/// See [`GetSessionEmbedUrlInput`](crate::input::GetSessionEmbedUrlInput)
pub mod get_session_embed_url_input {
    /// A builder for [`GetSessionEmbedUrlInput`](crate::input::GetSessionEmbedUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) entry_point: std::option::Option<std::string::String>,
        pub(crate) session_lifetime_in_minutes: std::option::Option<i64>,
        pub(crate) user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The URL you use to access the embedded session. The entry point URL is constrained to the following paths:</p>
        /// <ul>
        /// <li> <p> <code>/start</code> </p> </li>
        /// <li> <p> <code>/start/analyses</code> </p> </li>
        /// <li> <p> <code>/start/dashboards</code> </p> </li>
        /// <li> <p> <code>/start/favorites</code> </p> </li>
        /// <li> <p> <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p> </li>
        /// <li> <p> <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p> </li>
        /// </ul>
        pub fn entry_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_point = Some(input.into());
            self
        }
        /// <p>The URL you use to access the embedded session. The entry point URL is constrained to the following paths:</p>
        /// <ul>
        /// <li> <p> <code>/start</code> </p> </li>
        /// <li> <p> <code>/start/analyses</code> </p> </li>
        /// <li> <p> <code>/start/dashboards</code> </p> </li>
        /// <li> <p> <code>/start/favorites</code> </p> </li>
        /// <li> <p> <code>/dashboards/<i>DashboardId</i> </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p> </li>
        /// <li> <p> <code>/analyses/<i>AnalysisId</i> </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p> </li>
        /// </ul>
        pub fn set_entry_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_point = input;
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn session_lifetime_in_minutes(mut self, input: i64) -> Self {
            self.session_lifetime_in_minutes = Some(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.session_lifetime_in_minutes = input;
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:</p>
        /// <ol>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation</p> </li>
        /// </ol>
        /// <p>Omit this parameter for users in the third group, IAM users and IAM role-based sessions.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:</p>
        /// <ol>
        /// <li> <p>Active Directory (AD) users or group members</p> </li>
        /// <li> <p>Invited nonfederated users</p> </li>
        /// <li> <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation</p> </li>
        /// </ol>
        /// <p>Omit this parameter for users in the third group, IAM users and IAM role-based sessions.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionEmbedUrlInput`](crate::input::GetSessionEmbedUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSessionEmbedUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSessionEmbedUrlInput {
                aws_account_id: self.aws_account_id,
                entry_point: self.entry_point,
                session_lifetime_in_minutes: self.session_lifetime_in_minutes,
                user_arn: self.user_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSessionEmbedUrlInputOperationOutputAlias = crate::operation::GetSessionEmbedUrl;
#[doc(hidden)]
pub type GetSessionEmbedUrlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSessionEmbedUrlInput {
    /// Consumes the builder and constructs an Operation<[`GetSessionEmbedUrl`](crate::operation::GetSessionEmbedUrl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSessionEmbedUrl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSessionEmbedUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_158 = &_input.aws_account_id;
            let input_158 =
                input_158
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_158, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/session-embed-url",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetSessionEmbedUrlInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_159) = &_input.entry_point {
                query.push_kv(
                    "entry-point",
                    &aws_smithy_http::query::fmt_string(&inner_159),
                );
            }
            if let Some(inner_160) = &_input.session_lifetime_in_minutes {
                query.push_kv(
                    "session-lifetime",
                    aws_smithy_types::primitive::Encoder::from(*inner_160).encode(),
                );
            }
            if let Some(inner_161) = &_input.user_arn {
                query.push_kv("user-arn", &aws_smithy_http::query::fmt_string(&inner_161));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSessionEmbedUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSessionEmbedUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSessionEmbedUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSessionEmbedUrl",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSessionEmbedUrlInput`](crate::input::GetSessionEmbedUrlInput)
    pub fn builder() -> crate::input::get_session_embed_url_input::Builder {
        crate::input::get_session_embed_url_input::Builder::default()
    }
}

/// See [`ListAnalysesInput`](crate::input::ListAnalysesInput)
pub mod list_analyses_input {
    /// A builder for [`ListAnalysesInput`](crate::input::ListAnalysesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the analyses.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnalysesInput`](crate::input::ListAnalysesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnalysesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnalysesInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnalysesInputOperationOutputAlias = crate::operation::ListAnalyses;
#[doc(hidden)]
pub type ListAnalysesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAnalysesInput {
    /// Consumes the builder and constructs an Operation<[`ListAnalyses`](crate::operation::ListAnalyses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnalyses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAnalysesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_162 = &_input.aws_account_id;
            let input_162 =
                input_162
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_162, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/analyses",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAnalysesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_163) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_163),
                );
            }
            if let Some(inner_164) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_164).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAnalysesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAnalysesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnalyses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnalyses",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAnalysesInput`](crate::input::ListAnalysesInput)
    pub fn builder() -> crate::input::list_analyses_input::Builder {
        crate::input::list_analyses_input::Builder::default()
    }
}

/// See [`ListDashboardsInput`](crate::input::ListDashboardsInput)
pub mod list_dashboards_input {
    /// A builder for [`ListDashboardsInput`](crate::input::ListDashboardsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the dashboards that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboards that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDashboardsInput`](crate::input::ListDashboardsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDashboardsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDashboardsInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDashboardsInputOperationOutputAlias = crate::operation::ListDashboards;
#[doc(hidden)]
pub type ListDashboardsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDashboardsInput {
    /// Consumes the builder and constructs an Operation<[`ListDashboards`](crate::operation::ListDashboards)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDashboards,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDashboardsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_165 = &_input.aws_account_id;
            let input_165 =
                input_165
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_165, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDashboardsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_166) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_166),
                );
            }
            if let Some(inner_167) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_167).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDashboardsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDashboardsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDashboards::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDashboards",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDashboardsInput`](crate::input::ListDashboardsInput)
    pub fn builder() -> crate::input::list_dashboards_input::Builder {
        crate::input::list_dashboards_input::Builder::default()
    }
}

/// See [`ListDashboardVersionsInput`](crate::input::ListDashboardVersionsInput)
pub mod list_dashboard_versions_input {
    /// A builder for [`ListDashboardVersionsInput`](crate::input::ListDashboardVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're listing versions for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're listing versions for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDashboardVersionsInput`](crate::input::ListDashboardVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDashboardVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDashboardVersionsInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDashboardVersionsInputOperationOutputAlias = crate::operation::ListDashboardVersions;
#[doc(hidden)]
pub type ListDashboardVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDashboardVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDashboardVersions`](crate::operation::ListDashboardVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDashboardVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDashboardVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_168 = &_input.aws_account_id;
            let input_168 =
                input_168
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_168, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_169 = &_input.dashboard_id;
            let input_169 =
                input_169
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_169, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDashboardVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_170) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_170),
                );
            }
            if let Some(inner_171) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_171).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDashboardVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDashboardVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDashboardVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDashboardVersions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDashboardVersionsInput`](crate::input::ListDashboardVersionsInput)
    pub fn builder() -> crate::input::list_dashboard_versions_input::Builder {
        crate::input::list_dashboard_versions_input::Builder::default()
    }
}

/// See [`ListDataSetsInput`](crate::input::ListDataSetsInput)
pub mod list_data_sets_input {
    /// A builder for [`ListDataSetsInput`](crate::input::ListDataSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSetsInput`](crate::input::ListDataSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataSetsInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataSetsInputOperationOutputAlias = crate::operation::ListDataSets;
#[doc(hidden)]
pub type ListDataSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListDataSets`](crate::operation::ListDataSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_172 = &_input.aws_account_id;
            let input_172 =
                input_172
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_172, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDataSetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_173) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_173),
                );
            }
            if let Some(inner_174) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_174).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataSets",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataSetsInput`](crate::input::ListDataSetsInput)
    pub fn builder() -> crate::input::list_data_sets_input::Builder {
        crate::input::list_data_sets_input::Builder::default()
    }
}

/// See [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
pub mod list_data_sources_input {
    /// A builder for [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataSourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataSourcesInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataSourcesInputOperationOutputAlias = crate::operation::ListDataSources;
#[doc(hidden)]
pub type ListDataSourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataSourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListDataSources`](crate::operation::ListDataSources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataSources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataSourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_175 = &_input.aws_account_id;
            let input_175 =
                input_175
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_175, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sources",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDataSourcesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_176) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_176),
                );
            }
            if let Some(inner_177) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_177).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataSourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataSourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataSources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataSources",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    pub fn builder() -> crate::input::list_data_sources_input::Builder {
        crate::input::list_data_sources_input::Builder::default()
    }
}

/// See [`ListFolderMembersInput`](crate::input::ListFolderMembersInput)
pub mod list_folder_members_input {
    /// A builder for [`ListFolderMembersInput`](crate::input::ListFolderMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFolderMembersInput`](crate::input::ListFolderMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFolderMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFolderMembersInput {
                aws_account_id: self.aws_account_id,
                folder_id: self.folder_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFolderMembersInputOperationOutputAlias = crate::operation::ListFolderMembers;
#[doc(hidden)]
pub type ListFolderMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFolderMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListFolderMembers`](crate::operation::ListFolderMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFolderMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFolderMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_178 = &_input.aws_account_id;
            let input_178 =
                input_178
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_178, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_179 = &_input.folder_id;
            let input_179 =
                input_179
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let folder_id = aws_smithy_http::label::fmt_string(input_179, false);
            if folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders/{FolderId}/members",
                AwsAccountId = aws_account_id,
                FolderId = folder_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFolderMembersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_180) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_180),
                );
            }
            if let Some(inner_181) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_181).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFolderMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFolderMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFolderMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFolderMembers",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFolderMembersInput`](crate::input::ListFolderMembersInput)
    pub fn builder() -> crate::input::list_folder_members_input::Builder {
        crate::input::list_folder_members_input::Builder::default()
    }
}

/// See [`ListFoldersInput`](crate::input::ListFoldersInput)
pub mod list_folders_input {
    /// A builder for [`ListFoldersInput`](crate::input::ListFoldersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFoldersInput`](crate::input::ListFoldersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFoldersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFoldersInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFoldersInputOperationOutputAlias = crate::operation::ListFolders;
#[doc(hidden)]
pub type ListFoldersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFoldersInput {
    /// Consumes the builder and constructs an Operation<[`ListFolders`](crate::operation::ListFolders)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFolders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFoldersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_182 = &_input.aws_account_id;
            let input_182 =
                input_182
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_182, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/folders",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFoldersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_183) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_183),
                );
            }
            if let Some(inner_184) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_184).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFoldersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFoldersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFolders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFolders",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFoldersInput`](crate::input::ListFoldersInput)
    pub fn builder() -> crate::input::list_folders_input::Builder {
        crate::input::list_folders_input::Builder::default()
    }
}

/// See [`ListGroupMembershipsInput`](crate::input::ListGroupMembershipsInput)
pub mod list_group_memberships_input {
    /// A builder for [`ListGroupMembershipsInput`](crate::input::ListGroupMembershipsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group that you want to see a membership list of.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group that you want to see a membership list of.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupMembershipsInput`](crate::input::ListGroupMembershipsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupMembershipsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupMembershipsInput {
                group_name: self.group_name,
                next_token: self.next_token,
                max_results: self.max_results,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupMembershipsInputOperationOutputAlias = crate::operation::ListGroupMemberships;
#[doc(hidden)]
pub type ListGroupMembershipsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGroupMembershipsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupMemberships`](crate::operation::ListGroupMemberships)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupMemberships,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupMembershipsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_185 = &_input.aws_account_id;
            let input_185 =
                input_185
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_185, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_186 = &_input.namespace;
            let input_186 =
                input_186
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_186, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_187 = &_input.group_name;
            let input_187 =
                input_187
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_name",
                        details: "cannot be empty or unset",
                    })?;
            let group_name = aws_smithy_http::label::fmt_string(input_187, false);
            if group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
                AwsAccountId = aws_account_id,
                Namespace = namespace,
                GroupName = group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListGroupMembershipsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_188) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_188),
                );
            }
            if let Some(inner_189) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_189).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupMembershipsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupMembershipsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupMemberships::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupMemberships",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupMembershipsInput`](crate::input::ListGroupMembershipsInput)
    pub fn builder() -> crate::input::list_group_memberships_input::Builder {
        crate::input::list_group_memberships_input::Builder::default()
    }
}

/// See [`ListGroupsInput`](crate::input::ListGroupsInput)
pub mod list_groups_input {
    /// A builder for [`ListGroupsInput`](crate::input::ListGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsInput`](crate::input::ListGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsInputOperationOutputAlias = crate::operation::ListGroups;
#[doc(hidden)]
pub type ListGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroups`](crate::operation::ListGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_190 = &_input.aws_account_id;
            let input_190 =
                input_190
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_190, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_191 = &_input.namespace;
            let input_191 =
                input_191
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_191, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListGroupsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_192) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_192),
                );
            }
            if let Some(inner_193) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_193).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroups",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
}

/// See [`ListIamPolicyAssignmentsInput`](crate::input::ListIamPolicyAssignmentsInput)
pub mod list_iam_policy_assignments_input {
    /// A builder for [`ListIamPolicyAssignmentsInput`](crate::input::ListIamPolicyAssignmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatus>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains these IAM policy assignments.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains these IAM policy assignments.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The status of the assignments.</p>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p>The status of the assignments.</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// <p>The namespace for the assignments.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace for the assignments.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIamPolicyAssignmentsInput`](crate::input::ListIamPolicyAssignmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIamPolicyAssignmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIamPolicyAssignmentsInput {
                aws_account_id: self.aws_account_id,
                assignment_status: self.assignment_status,
                namespace: self.namespace,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIamPolicyAssignmentsInputOperationOutputAlias =
    crate::operation::ListIAMPolicyAssignments;
#[doc(hidden)]
pub type ListIamPolicyAssignmentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIamPolicyAssignmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListIAMPolicyAssignments`](crate::operation::ListIAMPolicyAssignments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIAMPolicyAssignments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIamPolicyAssignmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_194 = &_input.aws_account_id;
            let input_194 =
                input_194
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_194, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_195 = &_input.namespace;
            let input_195 =
                input_195
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_195, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListIamPolicyAssignmentsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_196) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_196),
                );
            }
            if let Some(inner_197) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_197).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIamPolicyAssignmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIamPolicyAssignmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_iam_policy_assignments(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIAMPolicyAssignments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIAMPolicyAssignments",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIamPolicyAssignmentsInput`](crate::input::ListIamPolicyAssignmentsInput)
    pub fn builder() -> crate::input::list_iam_policy_assignments_input::Builder {
        crate::input::list_iam_policy_assignments_input::Builder::default()
    }
}

/// See [`ListIamPolicyAssignmentsForUserInput`](crate::input::ListIamPolicyAssignmentsForUserInput)
pub mod list_iam_policy_assignments_for_user_input {
    /// A builder for [`ListIamPolicyAssignmentsForUserInput`](crate::input::ListIamPolicyAssignmentsForUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the assignments.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignments.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The name of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIamPolicyAssignmentsForUserInput`](crate::input::ListIamPolicyAssignmentsForUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIamPolicyAssignmentsForUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIamPolicyAssignmentsForUserInput {
                aws_account_id: self.aws_account_id,
                user_name: self.user_name,
                next_token: self.next_token,
                max_results: self.max_results,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIamPolicyAssignmentsForUserInputOperationOutputAlias =
    crate::operation::ListIAMPolicyAssignmentsForUser;
#[doc(hidden)]
pub type ListIamPolicyAssignmentsForUserInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListIamPolicyAssignmentsForUserInput {
    /// Consumes the builder and constructs an Operation<[`ListIAMPolicyAssignmentsForUser`](crate::operation::ListIAMPolicyAssignmentsForUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIAMPolicyAssignmentsForUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIamPolicyAssignmentsForUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_198 = &_input.aws_account_id;
            let input_198 =
                input_198
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_198, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_199 = &_input.namespace;
            let input_199 =
                input_199
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_199, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_200 = &_input.user_name;
            let input_200 =
                input_200
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_name",
                        details: "cannot be empty or unset",
                    })?;
            let user_name = aws_smithy_http::label::fmt_string(input_200, false);
            if user_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments", AwsAccountId = aws_account_id, Namespace = namespace, UserName = user_name).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListIamPolicyAssignmentsForUserInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_201) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_201),
                );
            }
            if let Some(inner_202) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_202).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIamPolicyAssignmentsForUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIamPolicyAssignmentsForUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIAMPolicyAssignmentsForUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIAMPolicyAssignmentsForUser",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIamPolicyAssignmentsForUserInput`](crate::input::ListIamPolicyAssignmentsForUserInput)
    pub fn builder() -> crate::input::list_iam_policy_assignments_for_user_input::Builder {
        crate::input::list_iam_policy_assignments_for_user_input::Builder::default()
    }
}

/// See [`ListIngestionsInput`](crate::input::ListIngestionsInput)
pub mod list_ingestions_input {
    /// A builder for [`ListIngestionsInput`](crate::input::ListIngestionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIngestionsInput`](crate::input::ListIngestionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIngestionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIngestionsInput {
                data_set_id: self.data_set_id,
                next_token: self.next_token,
                aws_account_id: self.aws_account_id,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIngestionsInputOperationOutputAlias = crate::operation::ListIngestions;
#[doc(hidden)]
pub type ListIngestionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIngestionsInput {
    /// Consumes the builder and constructs an Operation<[`ListIngestions`](crate::operation::ListIngestions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIngestions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIngestionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_203 = &_input.aws_account_id;
            let input_203 =
                input_203
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_203, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_204 = &_input.data_set_id;
            let input_204 =
                input_204
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "data_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let data_set_id = aws_smithy_http::label::fmt_string(input_204, false);
            if data_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "data_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions",
                AwsAccountId = aws_account_id,
                DataSetId = data_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListIngestionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_205) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_205),
                );
            }
            if let Some(inner_206) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_206).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIngestionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIngestionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIngestions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIngestions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIngestionsInput`](crate::input::ListIngestionsInput)
    pub fn builder() -> crate::input::list_ingestions_input::Builder {
        crate::input::list_ingestions_input::Builder::default()
    }
}

/// See [`ListNamespacesInput`](crate::input::ListNamespacesInput)
pub mod list_namespaces_input {
    /// A builder for [`ListNamespacesInput`](crate::input::ListNamespacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNamespacesInput`](crate::input::ListNamespacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNamespacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNamespacesInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNamespacesInputOperationOutputAlias = crate::operation::ListNamespaces;
#[doc(hidden)]
pub type ListNamespacesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListNamespacesInput {
    /// Consumes the builder and constructs an Operation<[`ListNamespaces`](crate::operation::ListNamespaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNamespaces,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNamespacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_207 = &_input.aws_account_id;
            let input_207 =
                input_207
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_207, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListNamespacesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_208) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_208),
                );
            }
            if let Some(inner_209) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_209).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNamespacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNamespacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNamespaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNamespaces",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNamespacesInput`](crate::input::ListNamespacesInput)
    pub fn builder() -> crate::input::list_namespaces_input::Builder {
        crate::input::list_namespaces_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_210 = &_input.resource_arn;
            let input_210 =
                input_210
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_210, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resources/{ResourceArn}/tags",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTemplateAliasesInput`](crate::input::ListTemplateAliasesInput)
pub mod list_template_aliases_input {
    /// A builder for [`ListTemplateAliasesInput`](crate::input::ListTemplateAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the template aliases that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template aliases that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplateAliasesInput`](crate::input::ListTemplateAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTemplateAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTemplateAliasesInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTemplateAliasesInputOperationOutputAlias = crate::operation::ListTemplateAliases;
#[doc(hidden)]
pub type ListTemplateAliasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTemplateAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListTemplateAliases`](crate::operation::ListTemplateAliases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTemplateAliases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTemplateAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_211 = &_input.aws_account_id;
            let input_211 =
                input_211
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_211, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_212 = &_input.template_id;
            let input_212 =
                input_212
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_212, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases",
                AwsAccountId = aws_account_id,
                TemplateId = template_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTemplateAliasesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_213) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_213),
                );
            }
            if let Some(inner_214) = &_input.max_results {
                query.push_kv(
                    "max-result",
                    aws_smithy_types::primitive::Encoder::from(*inner_214).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTemplateAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTemplateAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTemplateAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTemplateAliases",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTemplateAliasesInput`](crate::input::ListTemplateAliasesInput)
    pub fn builder() -> crate::input::list_template_aliases_input::Builder {
        crate::input::list_template_aliases_input::Builder::default()
    }
}

/// See [`ListTemplatesInput`](crate::input::ListTemplatesInput)
pub mod list_templates_input {
    /// A builder for [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplatesInput`](crate::input::ListTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTemplatesInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTemplatesInputOperationOutputAlias = crate::operation::ListTemplates;
#[doc(hidden)]
pub type ListTemplatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListTemplates`](crate::operation::ListTemplates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_215 = &_input.aws_account_id;
            let input_215 =
                input_215
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_215, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTemplatesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_216) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_216),
                );
            }
            if let Some(inner_217) = &_input.max_results {
                query.push_kv(
                    "max-result",
                    aws_smithy_types::primitive::Encoder::from(*inner_217).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTemplates",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    pub fn builder() -> crate::input::list_templates_input::Builder {
        crate::input::list_templates_input::Builder::default()
    }
}

/// See [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
pub mod list_template_versions_input {
    /// A builder for [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTemplateVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTemplateVersionsInput {
                aws_account_id: self.aws_account_id,
                template_id: self.template_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTemplateVersionsInputOperationOutputAlias = crate::operation::ListTemplateVersions;
#[doc(hidden)]
pub type ListTemplateVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTemplateVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTemplateVersions`](crate::operation::ListTemplateVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTemplateVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTemplateVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_218 = &_input.aws_account_id;
            let input_218 =
                input_218
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_218, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_219 = &_input.template_id;
            let input_219 =
                input_219
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    })?;
            let template_id = aws_smithy_http::label::fmt_string(input_219, false);
            if template_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "template_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/templates/{TemplateId}/versions",
                AwsAccountId = aws_account_id,
                TemplateId = template_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTemplateVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_220) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_220),
                );
            }
            if let Some(inner_221) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_221).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTemplateVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTemplateVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTemplateVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTemplateVersions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTemplateVersionsInput`](crate::input::ListTemplateVersionsInput)
    pub fn builder() -> crate::input::list_template_versions_input::Builder {
        crate::input::list_template_versions_input::Builder::default()
    }
}

/// See [`ListThemeAliasesInput`](crate::input::ListThemeAliasesInput)
pub mod list_theme_aliases_input {
    /// A builder for [`ListThemeAliasesInput`](crate::input::ListThemeAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the theme aliases that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme aliases that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemeAliasesInput`](crate::input::ListThemeAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListThemeAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListThemeAliasesInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListThemeAliasesInputOperationOutputAlias = crate::operation::ListThemeAliases;
#[doc(hidden)]
pub type ListThemeAliasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListThemeAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListThemeAliases`](crate::operation::ListThemeAliases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListThemeAliases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListThemeAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_222 = &_input.aws_account_id;
            let input_222 =
                input_222
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_222, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_223 = &_input.theme_id;
            let input_223 =
                input_223
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_223, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListThemeAliasesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_224) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_224),
                );
            }
            if let Some(inner_225) = &_input.max_results {
                query.push_kv(
                    "max-result",
                    aws_smithy_types::primitive::Encoder::from(*inner_225).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListThemeAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListThemeAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListThemeAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListThemeAliases",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListThemeAliasesInput`](crate::input::ListThemeAliasesInput)
    pub fn builder() -> crate::input::list_theme_aliases_input::Builder {
        crate::input::list_theme_aliases_input::Builder::default()
    }
}

/// See [`ListThemesInput`](crate::input::ListThemesInput)
pub mod list_themes_input {
    /// A builder for [`ListThemesInput`](crate::input::ListThemesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::ThemeType>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The type of themes that you want to list. Valid options include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li>
        /// <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li>
        /// <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ThemeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of themes that you want to list. Valid options include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li>
        /// <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li>
        /// <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ThemeType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemesInput`](crate::input::ListThemesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListThemesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListThemesInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListThemesInputOperationOutputAlias = crate::operation::ListThemes;
#[doc(hidden)]
pub type ListThemesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListThemesInput {
    /// Consumes the builder and constructs an Operation<[`ListThemes`](crate::operation::ListThemes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListThemes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListThemesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_226 = &_input.aws_account_id;
            let input_226 =
                input_226
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_226, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListThemesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_227) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_227),
                );
            }
            if let Some(inner_228) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_228).encode(),
                );
            }
            if let Some(inner_229) = &_input.r#type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_229));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListThemesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListThemesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListThemes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListThemes",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListThemesInput`](crate::input::ListThemesInput)
    pub fn builder() -> crate::input::list_themes_input::Builder {
        crate::input::list_themes_input::Builder::default()
    }
}

/// See [`ListThemeVersionsInput`](crate::input::ListThemeVersionsInput)
pub mod list_theme_versions_input {
    /// A builder for [`ListThemeVersionsInput`](crate::input::ListThemeVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemeVersionsInput`](crate::input::ListThemeVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListThemeVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListThemeVersionsInput {
                aws_account_id: self.aws_account_id,
                theme_id: self.theme_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListThemeVersionsInputOperationOutputAlias = crate::operation::ListThemeVersions;
#[doc(hidden)]
pub type ListThemeVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListThemeVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListThemeVersions`](crate::operation::ListThemeVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListThemeVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListThemeVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_230 = &_input.aws_account_id;
            let input_230 =
                input_230
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_230, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_231 = &_input.theme_id;
            let input_231 =
                input_231
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "theme_id",
                        details: "cannot be empty or unset",
                    })?;
            let theme_id = aws_smithy_http::label::fmt_string(input_231, false);
            if theme_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "theme_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/themes/{ThemeId}/versions",
                AwsAccountId = aws_account_id,
                ThemeId = theme_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListThemeVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_232) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_232),
                );
            }
            if let Some(inner_233) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_233).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListThemeVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListThemeVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListThemeVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListThemeVersions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListThemeVersionsInput`](crate::input::ListThemeVersionsInput)
    pub fn builder() -> crate::input::list_theme_versions_input::Builder {
        crate::input::list_theme_versions_input::Builder::default()
    }
}

/// See [`ListUserGroupsInput`](crate::input::ListUserGroupsInput)
pub mod list_user_groups_input {
    /// A builder for [`ListUserGroupsInput`](crate::input::ListUserGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon QuickSight user name that you want to list group memberships for.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight user name that you want to list group memberships for.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserGroupsInput`](crate::input::ListUserGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserGroupsInput {
                user_name: self.user_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserGroupsInputOperationOutputAlias = crate::operation::ListUserGroups;
#[doc(hidden)]
pub type ListUserGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUserGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListUserGroups`](crate::operation::ListUserGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_234 = &_input.aws_account_id;
            let input_234 =
                input_234
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_234, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_235 = &_input.namespace;
            let input_235 =
                input_235
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_235, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            let input_236 = &_input.user_name;
            let input_236 =
                input_236
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_name",
                        details: "cannot be empty or unset",
                    })?;
            let user_name = aws_smithy_http::label::fmt_string(input_236, false);
            if user_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
                AwsAccountId = aws_account_id,
                Namespace = namespace,
                UserName = user_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListUserGroupsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_237) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_237),
                );
            }
            if let Some(inner_238) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_238).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserGroups",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserGroupsInput`](crate::input::ListUserGroupsInput)
    pub fn builder() -> crate::input::list_user_groups_input::Builder {
        crate::input::list_user_groups_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                aws_account_id: self.aws_account_id,
                next_token: self.next_token,
                max_results: self.max_results,
                namespace: self.namespace,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_239 = &_input.aws_account_id;
            let input_239 =
                input_239
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_239, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_240 = &_input.namespace;
            let input_240 =
                input_240
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_240, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListUsersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_241) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_241),
                );
            }
            if let Some(inner_242) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    aws_smithy_types::primitive::Encoder::from(*inner_242).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListUsers",
                    "quicksight",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`RegisterUserInput`](crate::input::RegisterUserInput)
pub mod register_user_input {
    /// A builder for [`RegisterUserInput`](crate::input::RegisterUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) user_role: std::option::Option<crate::model::UserRole>,
        pub(crate) iam_arn: std::option::Option<std::string::String>,
        pub(crate) session_name: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) custom_permissions_name: std::option::Option<std::string::String>,
        pub(crate) external_login_federation_provider_type:
            std::option::Option<std::string::String>,
        pub(crate) custom_federation_provider_url: std::option::Option<std::string::String>,
        pub(crate) external_login_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:</p>
        /// <ul>
        /// <li> <p> <code>IAM</code>: A user whose identity maps to an existing IAM user or role. </p> </li>
        /// <li> <p> <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight. </p> </li>
        /// </ul>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:</p>
        /// <ul>
        /// <li> <p> <code>IAM</code>: A user whose identity maps to an existing IAM user or role. </p> </li>
        /// <li> <p> <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight. </p> </li>
        /// </ul>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The email address of the user that you want to register.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the user that you want to register.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>
        /// <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>
        /// <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>
        /// <li> <p> <code>RESTRICTED_READER</code>: This role isn't currently available for use.</p> </li>
        /// <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.</p> </li>
        /// </ul>
        pub fn user_role(mut self, input: crate::model::UserRole) -> Self {
            self.user_role = Some(input);
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li>
        /// <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li>
        /// <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li>
        /// <li> <p> <code>RESTRICTED_READER</code>: This role isn't currently available for use.</p> </li>
        /// <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.</p> </li>
        /// </ul>
        pub fn set_user_role(mut self, input: std::option::Option<crate::model::UserRole>) -> Self {
            self.user_role = input;
            self
        }
        /// <p>The ARN of the IAM user or role that you are registering with Amazon QuickSight. </p>
        pub fn iam_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM user or role that you are registering with Amazon QuickSight. </p>
        pub fn set_iam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_arn = input;
            self
        }
        /// <p>You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>CLI Reference.</i> </p>
        pub fn session_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_name = Some(input.into());
            self
        }
        /// <p>You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>CLI Reference.</i> </p>
        pub fn set_session_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_name = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>
        /// <ul>
        /// <li> <p>Create and update data sources</p> </li>
        /// <li> <p>Create and update datasets</p> </li>
        /// <li> <p>Create and update email reports</p> </li>
        /// <li> <p>Subscribe to email reports</p> </li>
        /// </ul>
        /// <p>To add custom permissions to an existing user, use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> instead.</p>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn custom_permissions_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_permissions_name = Some(input.into());
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:</p>
        /// <ul>
        /// <li> <p>Create and update data sources</p> </li>
        /// <li> <p>Create and update datasets</p> </li>
        /// <li> <p>Create and update email reports</p> </li>
        /// <li> <p>Subscribe to email reports</p> </li>
        /// </ul>
        /// <p>To add custom permissions to an existing user, use <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code> instead.</p>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of permissions to a QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn set_custom_permissions_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_permissions_name = input;
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>
        /// <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>
        /// </ul>
        pub fn external_login_federation_provider_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.external_login_federation_provider_type = Some(input.into());
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p> </li>
        /// <li> <p> <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p> </li>
        /// </ul>
        pub fn set_external_login_federation_provider_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_login_federation_provider_type = input;
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn custom_federation_provider_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_federation_provider_url = Some(input.into());
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn set_custom_federation_provider_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_federation_provider_url = input;
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn external_login_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_login_id = Some(input.into());
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn set_external_login_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_login_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterUserInput`](crate::input::RegisterUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterUserInput {
                identity_type: self.identity_type,
                email: self.email,
                user_role: self.user_role,
                iam_arn: self.iam_arn,
                session_name: self.session_name,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                user_name: self.user_name,
                custom_permissions_name: self.custom_permissions_name,
                external_login_federation_provider_type: self
                    .external_login_federation_provider_type,
                custom_federation_provider_url: self.custom_federation_provider_url,
                external_login_id: self.external_login_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterUserInputOperationOutputAlias = crate::operation::RegisterUser;
#[doc(hidden)]
pub type RegisterUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterUserInput {
    /// Consumes the builder and constructs an Operation<[`RegisterUser`](crate::operation::RegisterUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_243 = &_input.aws_account_id;
            let input_243 =
                input_243
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_243, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_244 = &_input.namespace;
            let input_244 =
                input_244
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "namespace",
                        details: "cannot be empty or unset",
                    })?;
            let namespace = aws_smithy_http::label::fmt_string(input_244, false);
            if namespace.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "namespace",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
                AwsAccountId = aws_account_id,
                Namespace = namespace
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_register_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterUser",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterUserInput`](crate::input::RegisterUserInput)
    pub fn builder() -> crate::input::register_user_input::Builder {
        crate::input::register_user_input::Builder::default()
    }
}

/// See [`RestoreAnalysisInput`](crate::input::RestoreAnalysisInput)
pub mod restore_analysis_input {
    /// A builder for [`RestoreAnalysisInput`](crate::input::RestoreAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the analysis.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the analysis that you're restoring.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis that you're restoring.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreAnalysisInput`](crate::input::RestoreAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreAnalysisInput {
                aws_account_id: self.aws_account_id,
                analysis_id: self.analysis_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreAnalysisInputOperationOutputAlias = crate::operation::RestoreAnalysis;
#[doc(hidden)]
pub type RestoreAnalysisInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RestoreAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`RestoreAnalysis`](crate::operation::RestoreAnalysis)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreAnalysis,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_245 = &_input.aws_account_id;
            let input_245 =
                input_245
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_245, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_246 = &_input.analysis_id;
            let input_246 =
                input_246
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_246, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/restore/analyses/{AnalysisId}",
                AwsAccountId = aws_account_id,
                AnalysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreAnalysis",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreAnalysisInput`](crate::input::RestoreAnalysisInput)
    pub fn builder() -> crate::input::restore_analysis_input::Builder {
        crate::input::restore_analysis_input::Builder::default()
    }
}

/// See [`SearchAnalysesInput`](crate::input::SearchAnalysesInput)
pub mod search_analyses_input {
    /// A builder for [`SearchAnalysesInput`](crate::input::SearchAnalysesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::AnalysisSearchFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the analyses that you're searching for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses that you're searching for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The structure for the search filters that you want to apply to your search. </p>
        pub fn filters(mut self, input: crate::model::AnalysisSearchFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The structure for the search filters that you want to apply to your search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisSearchFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchAnalysesInput`](crate::input::SearchAnalysesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchAnalysesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchAnalysesInput {
                aws_account_id: self.aws_account_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchAnalysesInputOperationOutputAlias = crate::operation::SearchAnalyses;
#[doc(hidden)]
pub type SearchAnalysesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchAnalysesInput {
    /// Consumes the builder and constructs an Operation<[`SearchAnalyses`](crate::operation::SearchAnalyses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchAnalyses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchAnalysesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_247 = &_input.aws_account_id;
            let input_247 =
                input_247
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_247, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/search/analyses",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchAnalysesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchAnalysesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_analyses(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchAnalyses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchAnalyses",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchAnalysesInput`](crate::input::SearchAnalysesInput)
    pub fn builder() -> crate::input::search_analyses_input::Builder {
        crate::input::search_analyses_input::Builder::default()
    }
}

/// See [`SearchDashboardsInput`](crate::input::SearchDashboardsInput)
pub mod search_dashboards_input {
    /// A builder for [`SearchDashboardsInput`](crate::input::SearchDashboardsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::DashboardSearchFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the user whose dashboards you're searching for. </p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the user whose dashboards you're searching for. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>
        pub fn filters(mut self, input: crate::model::DashboardSearchFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardSearchFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchDashboardsInput`](crate::input::SearchDashboardsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchDashboardsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchDashboardsInput {
                aws_account_id: self.aws_account_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchDashboardsInputOperationOutputAlias = crate::operation::SearchDashboards;
#[doc(hidden)]
pub type SearchDashboardsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchDashboardsInput {
    /// Consumes the builder and constructs an Operation<[`SearchDashboards`](crate::operation::SearchDashboards)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchDashboards,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchDashboardsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_248 = &_input.aws_account_id;
            let input_248 =
                input_248
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_248, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/search/dashboards",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchDashboardsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchDashboardsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_dashboards(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchDashboards::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchDashboards",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchDashboardsInput`](crate::input::SearchDashboardsInput)
    pub fn builder() -> crate::input::search_dashboards_input::Builder {
        crate::input::search_dashboards_input::Builder::default()
    }
}

/// See [`SearchFoldersInput`](crate::input::SearchFoldersInput)
pub mod search_folders_input {
    /// A builder for [`SearchFoldersInput`](crate::input::SearchFoldersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::FolderSearchFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>
        pub fn filters(mut self, input: crate::model::FolderSearchFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderSearchFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchFoldersInput`](crate::input::SearchFoldersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchFoldersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchFoldersInput {
                aws_account_id: self.aws_account_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchFoldersInputOperationOutputAlias = crate::operation::SearchFolders;
#[doc(hidden)]
pub type SearchFoldersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchFoldersInput {
    /// Consumes the builder and constructs an Operation<[`SearchFolders`](crate::operation::SearchFolders)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchFolders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchFoldersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_249 = &_input.aws_account_id;
            let input_249 =
                input_249
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_249, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/search/folders",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchFoldersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchFoldersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_search_folders(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchFolders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchFolders",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchFoldersInput`](crate::input::SearchFoldersInput)
    pub fn builder() -> crate::input::search_folders_input::Builder {
        crate::input::search_folders_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_250 = &_input.resource_arn;
            let input_250 =
                input_250
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_250, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resources/{ResourceArn}/tags",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_251 = &_input.resource_arn;
            let input_251 =
                input_251
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_251, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resources/{ResourceArn}/tags",
                ResourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_252) = &_input.tag_keys {
                for inner_253 in inner_252 {
                    query.push_kv("keys", &aws_smithy_http::query::fmt_string(&inner_253));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAccountCustomizationInput`](crate::input::UpdateAccountCustomizationInput)
pub mod update_account_customization_input {
    /// A builder for [`UpdateAccountCustomizationInput`](crate::input::UpdateAccountCustomizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) account_customization: std::option::Option<crate::model::AccountCustomization>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace that you want to update Amazon QuickSight customizations for.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace that you want to update Amazon QuickSight customizations for.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn account_customization(mut self, input: crate::model::AccountCustomization) -> Self {
            self.account_customization = Some(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.account_customization = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountCustomizationInput`](crate::input::UpdateAccountCustomizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAccountCustomizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAccountCustomizationInput {
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                account_customization: self.account_customization,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAccountCustomizationInputOperationOutputAlias =
    crate::operation::UpdateAccountCustomization;
#[doc(hidden)]
pub type UpdateAccountCustomizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAccountCustomizationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccountCustomization`](crate::operation::UpdateAccountCustomization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccountCustomization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAccountCustomizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_254 = &_input.aws_account_id;
            let input_254 =
                input_254
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_254, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/customizations",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UpdateAccountCustomizationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_255) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_255));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAccountCustomizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAccountCustomizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_account_customization(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccountCustomization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccountCustomization",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAccountCustomizationInput`](crate::input::UpdateAccountCustomizationInput)
    pub fn builder() -> crate::input::update_account_customization_input::Builder {
        crate::input::update_account_customization_input::Builder::default()
    }
}

/// See [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
pub mod update_account_settings_input {
    /// A builder for [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) default_namespace: std::option::Option<std::string::String>,
        pub(crate) notification_email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The default namespace for this Amazon Web Services account. Currently, the default is <code>default</code>. Identity and Access Management (IAM) users that register for the first time with Amazon QuickSight provide an email that becomes associated with the default namespace.</p>
        pub fn default_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_namespace = Some(input.into());
            self
        }
        /// <p>The default namespace for this Amazon Web Services account. Currently, the default is <code>default</code>. Identity and Access Management (IAM) users that register for the first time with Amazon QuickSight provide an email that becomes associated with the default namespace.</p>
        pub fn set_default_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_namespace = input;
            self
        }
        /// <p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>
        pub fn notification_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_email = Some(input.into());
            self
        }
        /// <p>The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.</p>
        pub fn set_notification_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_email = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAccountSettingsInput {
                aws_account_id: self.aws_account_id,
                default_namespace: self.default_namespace,
                notification_email: self.notification_email,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAccountSettingsInputOperationOutputAlias = crate::operation::UpdateAccountSettings;
#[doc(hidden)]
pub type UpdateAccountSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccountSettings`](crate::operation::UpdateAccountSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccountSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAccountSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_256 = &_input.aws_account_id;
            let input_256 =
                input_256
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_256, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/settings",
                AwsAccountId = aws_account_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAccountSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAccountSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_account_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccountSettings",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
    pub fn builder() -> crate::input::update_account_settings_input::Builder {
        crate::input::update_account_settings_input::Builder::default()
    }
}

/// See [`UpdateAnalysisInput`](crate::input::UpdateAnalysisInput)
pub mod update_analysis_input {
    /// A builder for [`UpdateAnalysisInput`](crate::input::UpdateAnalysisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<crate::model::Parameters>,
        pub(crate) source_entity: std::option::Option<crate::model::AnalysisSourceEntity>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the analysis that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the analysis that you're updating. This ID displays in the URL of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID for the analysis that you're updating. This ID displays in the URL of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>A descriptive name for the analysis that you're updating. This name displays for the analysis in the Amazon QuickSight console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A descriptive name for the analysis that you're updating. This name displays for the analysis in the Amazon QuickSight console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn source_entity(mut self, input: crate::model::AnalysisSourceEntity) -> Self {
            self.source_entity = Some(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.</p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::AnalysisSourceEntity>,
        ) -> Self {
            self.source_entity = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnalysisInput`](crate::input::UpdateAnalysisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAnalysisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAnalysisInput {
                aws_account_id: self.aws_account_id,
                analysis_id: self.analysis_id,
                name: self.name,
                parameters: self.parameters,
                source_entity: self.source_entity,
                theme_arn: self.theme_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAnalysisInputOperationOutputAlias = crate::operation::UpdateAnalysis;
#[doc(hidden)]
pub type UpdateAnalysisInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAnalysisInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAnalysis`](crate::operation::UpdateAnalysis)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAnalysis,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAnalysisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_257 = &_input.aws_account_id;
            let input_257 =
                input_257
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_257, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_258 = &_input.analysis_id;
            let input_258 =
                input_258
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_258, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
                AwsAccountId = aws_account_id,
                AnalysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAnalysisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAnalysisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_analysis(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAnalysis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAnalysis",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAnalysisInput`](crate::input::UpdateAnalysisInput)
    pub fn builder() -> crate::input::update_analysis_input::Builder {
        crate::input::update_analysis_input::Builder::default()
    }
}

/// See [`UpdateAnalysisPermissionsInput`](crate::input::UpdateAnalysisPermissionsInput)
pub mod update_analysis_permissions_input {
    /// A builder for [`UpdateAnalysisPermissionsInput`](crate::input::UpdateAnalysisPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) grant_permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) revoke_permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're updating. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're updating. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID of the analysis whose permissions you're updating. The ID is part of the analysis URL.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis whose permissions you're updating. The ID is part of the analysis URL.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// Appends an item to `grant_permissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A structure that describes the permissions to add and the principal to add them to.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.grant_permissions.unwrap_or_default();
            v.push(input);
            self.grant_permissions = Some(v);
            self
        }
        /// <p>A structure that describes the permissions to add and the principal to add them to.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.grant_permissions = input;
            self
        }
        /// Appends an item to `revoke_permissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A structure that describes the permissions to remove and the principal to remove them from.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.revoke_permissions.unwrap_or_default();
            v.push(input);
            self.revoke_permissions = Some(v);
            self
        }
        /// <p>A structure that describes the permissions to remove and the principal to remove them from.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.revoke_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnalysisPermissionsInput`](crate::input::UpdateAnalysisPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAnalysisPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAnalysisPermissionsInput {
                aws_account_id: self.aws_account_id,
                analysis_id: self.analysis_id,
                grant_permissions: self.grant_permissions,
                revoke_permissions: self.revoke_permissions,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAnalysisPermissionsInputOperationOutputAlias =
    crate::operation::UpdateAnalysisPermissions;
#[doc(hidden)]
pub type UpdateAnalysisPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAnalysisPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAnalysisPermissions`](crate::operation::UpdateAnalysisPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAnalysisPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAnalysisPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_259 = &_input.aws_account_id;
            let input_259 =
                input_259
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_259, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_260 = &_input.analysis_id;
            let input_260 =
                input_260
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "analysis_id",
                        details: "cannot be empty or unset",
                    })?;
            let analysis_id = aws_smithy_http::label::fmt_string(input_260, false);
            if analysis_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "analysis_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
                AwsAccountId = aws_account_id,
                AnalysisId = analysis_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAnalysisPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAnalysisPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_analysis_permissions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAnalysisPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAnalysisPermissions",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAnalysisPermissionsInput`](crate::input::UpdateAnalysisPermissionsInput)
    pub fn builder() -> crate::input::update_analysis_permissions_input::Builder {
        crate::input::update_analysis_permissions_input::Builder::default()
    }
}

/// See [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
pub mod update_dashboard_input {
    /// A builder for [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_entity: std::option::Option<crate::model::DashboardSourceEntity>,
        pub(crate) parameters: std::option::Option<crate::model::Parameters>,
        pub(crate) version_description: std::option::Option<std::string::String>,
        pub(crate) dashboard_publish_options:
            std::option::Option<crate::model::DashboardPublishOptions>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, input: crate::model::DashboardSourceEntity) -> Self {
            self.source_entity = Some(input);
            self
        }
        /// <p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::DashboardSourceEntity>,
        ) -> Self {
            self.source_entity = input;
            self
        }
        /// <p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>
        pub fn parameters(mut self, input: crate::model::Parameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_description = Some(input.into());
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_description = input;
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn dashboard_publish_options(
            mut self,
            input: crate::model::DashboardPublishOptions,
        ) -> Self {
            self.dashboard_publish_options = Some(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li>
        /// <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li>
        /// </ul>
        pub fn set_dashboard_publish_options(
            mut self,
            input: std::option::Option<crate::model::DashboardPublishOptions>,
        ) -> Self {
            self.dashboard_publish_options = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDashboardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDashboardInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
                name: self.name,
                source_entity: self.source_entity,
                parameters: self.parameters,
                version_description: self.version_description,
                dashboard_publish_options: self.dashboard_publish_options,
                theme_arn: self.theme_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDashboardInputOperationOutputAlias = crate::operation::UpdateDashboard;
#[doc(hidden)]
pub type UpdateDashboardInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDashboardInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDashboard`](crate::operation::UpdateDashboard)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDashboard,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDashboardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_261 = &_input.aws_account_id;
            let input_261 =
                input_261
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_261, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_262 = &_input.dashboard_id;
            let input_262 =
                input_262
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_262, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDashboardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDashboardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_dashboard(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDashboard::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDashboard",
            "quicksight",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDashboardInput`](crate::input::UpdateDashboardInput)
    pub fn builder() -> crate::input::update_dashboard_input::Builder {
        crate::input::update_dashboard_input::Builder::default()
    }
}

/// See [`UpdateDashboardPermissionsInput`](crate::input::UpdateDashboardPermissionsInput)
pub mod update_dashboard_permissions_input {
    /// A builder for [`UpdateDashboardPermissionsInput`](crate::input::UpdateDashboardPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) grant_permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) revoke_permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) grant_link_permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) revoke_link_permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// Appends an item to `grant_permissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>The permissions that you want to grant on this resource.</p>
        pub fn grant_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.grant_permissions.unwrap_or_default();
            v.push(input);
            self.grant_permissions = Some(v);
            self
        }
        /// <p>The permissions that you want to grant on this resource.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.grant_permissions = input;
            self
        }
        /// Appends an item to `revoke_permissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>The permissions that you want to revoke from this resource.</p>
        pub fn revoke_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.revoke_permissions.unwrap_or_default();
            v.push(input);
            self.revoke_permissions = Some(v);
            self
        }
        /// <p>The permissions that you want to revoke from this resource.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.revoke_permissions = input;
            self
        }
        /// Appends an item to `grant_link_permissions`.
        ///
        /// To override the contents of this collection use [`set_grant_link_permissions`](Self::set_grant_link_permissions).
        ///
        /// <p>Grants link permissions to all users in a defined namespace.</p>
        pub fn grant_link_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.grant_link_permissions.unwrap_or_default();
            v.push(input);
            self.grant_link_permissions = Some(v);
            self
        }
        /// <p>Grants link permissions to all users in a defined namespace.</p>
        pub fn set_grant_link_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.grant_link_permissions = input;
            self
        }
        /// Appends an item to `revoke_link_permissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_link_permissions`](Self::set_revoke_link_permissions).
        ///
        /// <p>Revokes link permissions from all users in a defined namespace.</p>
        pub fn revoke_link_permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.revoke_link_permissions.unwrap_or_default();
            v.push(input);
            self.revoke_link_permissions = Some(v);
            self
        }
        /// <p>Revokes link permissions from all users in a defined namespace.</p>
        pub fn set_revoke_link_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.revoke_link_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDashboardPermissionsInput`](crate::input::UpdateDashboardPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDashboardPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDashboardPermissionsInput {
                aws_account_id: self.aws_account_id,
                dashboard_id: self.dashboard_id,
                grant_permissions: self.grant_permissions,
                revoke_permissions: self.revoke_permissions,
                grant_link_permissions: self.grant_link_permissions,
                revoke_link_permissions: self.revoke_link_permissions,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDashboardPermissionsInputOperationOutputAlias =
    crate::operation::UpdateDashboardPermissions;
#[doc(hidden)]
pub type UpdateDashboardPermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDashboardPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDashboardPermissions`](crate::operation::UpdateDashboardPermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDashboardPermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDashboardPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_263 = &_input.aws_account_id;
            let input_263 =
                input_263
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "aws_account_id",
                        details: "cannot be empty or unset",
                    })?;
            let aws_account_id = aws_smithy_http::label::fmt_string(input_263, false);
            if aws_account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "aws_account_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_264 = &_input.dashboard_id;
            let input_264 =
                input_264
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dashboard_id",
                        details: "cannot be empty or unset",
                    })?;
            let dashboard_id = aws_smithy_http::label::fmt_string(input_264, false);
            if dashboard_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dashboard_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
                AwsAccountId = aws_account_id,
                DashboardId = dashboard_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDashboardPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDashboardPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_dashboard_permissions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal: