// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserOutput {
    /// <p>The Amazon QuickSight user.</p>
    pub user: std::option::Option<crate::model::User>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateUserOutput {
    /// <p>The Amazon QuickSight user.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::User> {
        self.user.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserOutput");
        formatter.field("user", &self.user);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateUserOutput`](crate::output::UpdateUserOutput)
pub mod update_user_output {
    /// A builder for [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon QuickSight user.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The Amazon QuickSight user.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserOutput`](crate::output::UpdateUserOutput)
        pub fn build(self) -> crate::output::UpdateUserOutput {
            crate::output::UpdateUserOutput {
                user: self.user,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateUserOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    pub fn builder() -> crate::output::update_user_output::Builder {
        crate::output::update_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThemePermissionsOutput {
    /// <p>The ID for the theme.</p>
    pub theme_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the theme.</p>
    pub theme_arn: std::option::Option<std::string::String>,
    /// <p>The resulting list of resource permissions for the theme.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateThemePermissionsOutput {
    /// <p>The ID for the theme.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the theme.</p>
    pub fn theme_arn(&self) -> std::option::Option<&str> {
        self.theme_arn.as_deref()
    }
    /// <p>The resulting list of resource permissions for the theme.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateThemePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThemePermissionsOutput");
        formatter.field("theme_id", &self.theme_id);
        formatter.field("theme_arn", &self.theme_arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateThemePermissionsOutput`](crate::output::UpdateThemePermissionsOutput)
pub mod update_theme_permissions_output {
    /// A builder for [`UpdateThemePermissionsOutput`](crate::output::UpdateThemePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The resulting list of resource permissions for the theme.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>The resulting list of resource permissions for the theme.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThemePermissionsOutput`](crate::output::UpdateThemePermissionsOutput)
        pub fn build(self) -> crate::output::UpdateThemePermissionsOutput {
            crate::output::UpdateThemePermissionsOutput {
                theme_id: self.theme_id,
                theme_arn: self.theme_arn,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateThemePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateThemePermissionsOutput`](crate::output::UpdateThemePermissionsOutput)
    pub fn builder() -> crate::output::update_theme_permissions_output::Builder {
        crate::output::update_theme_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThemeAliasOutput {
    /// <p>Information about the theme alias.</p>
    pub theme_alias: std::option::Option<crate::model::ThemeAlias>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateThemeAliasOutput {
    /// <p>Information about the theme alias.</p>
    pub fn theme_alias(&self) -> std::option::Option<&crate::model::ThemeAlias> {
        self.theme_alias.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateThemeAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThemeAliasOutput");
        formatter.field("theme_alias", &self.theme_alias);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateThemeAliasOutput`](crate::output::UpdateThemeAliasOutput)
pub mod update_theme_alias_output {
    /// A builder for [`UpdateThemeAliasOutput`](crate::output::UpdateThemeAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_alias: std::option::Option<crate::model::ThemeAlias>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the theme alias.</p>
        pub fn theme_alias(mut self, input: crate::model::ThemeAlias) -> Self {
            self.theme_alias = Some(input);
            self
        }
        /// <p>Information about the theme alias.</p>
        pub fn set_theme_alias(
            mut self,
            input: std::option::Option<crate::model::ThemeAlias>,
        ) -> Self {
            self.theme_alias = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThemeAliasOutput`](crate::output::UpdateThemeAliasOutput)
        pub fn build(self) -> crate::output::UpdateThemeAliasOutput {
            crate::output::UpdateThemeAliasOutput {
                theme_alias: self.theme_alias,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateThemeAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateThemeAliasOutput`](crate::output::UpdateThemeAliasOutput)
    pub fn builder() -> crate::output::update_theme_alias_output::Builder {
        crate::output::update_theme_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThemeOutput {
    /// <p>The ID for the theme.</p>
    pub theme_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the theme.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the new version of the theme.</p>
    pub version_arn: std::option::Option<std::string::String>,
    /// <p>The creation status of the theme.</p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateThemeOutput {
    /// <p>The ID for the theme.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the theme.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the new version of the theme.</p>
    pub fn version_arn(&self) -> std::option::Option<&str> {
        self.version_arn.as_deref()
    }
    /// <p>The creation status of the theme.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThemeOutput");
        formatter.field("theme_id", &self.theme_id);
        formatter.field("arn", &self.arn);
        formatter.field("version_arn", &self.version_arn);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
pub mod update_theme_output {
    /// A builder for [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_arn: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the new version of the theme.</p>
        pub fn version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the new version of the theme.</p>
        pub fn set_version_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_arn = input;
            self
        }
        /// <p>The creation status of the theme.</p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The creation status of the theme.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
        pub fn build(self) -> crate::output::UpdateThemeOutput {
            crate::output::UpdateThemeOutput {
                theme_id: self.theme_id,
                arn: self.arn,
                version_arn: self.version_arn,
                creation_status: self.creation_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateThemeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateThemeOutput`](crate::output::UpdateThemeOutput)
    pub fn builder() -> crate::output::update_theme_output::Builder {
        crate::output::update_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTemplatePermissionsOutput {
    /// <p>The ID for the template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>A list of resource permissions to be set on the template.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateTemplatePermissionsOutput {
    /// <p>The ID for the template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>A list of resource permissions to be set on the template.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateTemplatePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTemplatePermissionsOutput");
        formatter.field("template_id", &self.template_id);
        formatter.field("template_arn", &self.template_arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateTemplatePermissionsOutput`](crate::output::UpdateTemplatePermissionsOutput)
pub mod update_template_permissions_output {
    /// A builder for [`UpdateTemplatePermissionsOutput`](crate::output::UpdateTemplatePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions to be set on the template.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions to be set on the template.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTemplatePermissionsOutput`](crate::output::UpdateTemplatePermissionsOutput)
        pub fn build(self) -> crate::output::UpdateTemplatePermissionsOutput {
            crate::output::UpdateTemplatePermissionsOutput {
                template_id: self.template_id,
                template_arn: self.template_arn,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateTemplatePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTemplatePermissionsOutput`](crate::output::UpdateTemplatePermissionsOutput)
    pub fn builder() -> crate::output::update_template_permissions_output::Builder {
        crate::output::update_template_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTemplateAliasOutput {
    /// <p>The template alias.</p>
    pub template_alias: std::option::Option<crate::model::TemplateAlias>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateTemplateAliasOutput {
    /// <p>The template alias.</p>
    pub fn template_alias(&self) -> std::option::Option<&crate::model::TemplateAlias> {
        self.template_alias.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateTemplateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTemplateAliasOutput");
        formatter.field("template_alias", &self.template_alias);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateTemplateAliasOutput`](crate::output::UpdateTemplateAliasOutput)
pub mod update_template_alias_output {
    /// A builder for [`UpdateTemplateAliasOutput`](crate::output::UpdateTemplateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_alias: std::option::Option<crate::model::TemplateAlias>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The template alias.</p>
        pub fn template_alias(mut self, input: crate::model::TemplateAlias) -> Self {
            self.template_alias = Some(input);
            self
        }
        /// <p>The template alias.</p>
        pub fn set_template_alias(
            mut self,
            input: std::option::Option<crate::model::TemplateAlias>,
        ) -> Self {
            self.template_alias = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTemplateAliasOutput`](crate::output::UpdateTemplateAliasOutput)
        pub fn build(self) -> crate::output::UpdateTemplateAliasOutput {
            crate::output::UpdateTemplateAliasOutput {
                template_alias: self.template_alias,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateTemplateAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateAliasOutput`](crate::output::UpdateTemplateAliasOutput)
    pub fn builder() -> crate::output::update_template_alias_output::Builder {
        crate::output::update_template_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTemplateOutput {
    /// <p>The ID for the template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN for the template, including the version information of the first version.</p>
    pub version_arn: std::option::Option<std::string::String>,
    /// <p>The creation status of the template.</p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateTemplateOutput {
    /// <p>The ID for the template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN for the template, including the version information of the first version.</p>
    pub fn version_arn(&self) -> std::option::Option<&str> {
        self.version_arn.as_deref()
    }
    /// <p>The creation status of the template.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTemplateOutput");
        formatter.field("template_id", &self.template_id);
        formatter.field("arn", &self.arn);
        formatter.field("version_arn", &self.version_arn);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
pub mod update_template_output {
    /// A builder for [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_arn: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN for the template, including the version information of the first version.</p>
        pub fn version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the template, including the version information of the first version.</p>
        pub fn set_version_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_arn = input;
            self
        }
        /// <p>The creation status of the template.</p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The creation status of the template.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
        pub fn build(self) -> crate::output::UpdateTemplateOutput {
            crate::output::UpdateTemplateOutput {
                template_id: self.template_id,
                arn: self.arn,
                version_arn: self.version_arn,
                creation_status: self.creation_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
    pub fn builder() -> crate::output::update_template_output::Builder {
        crate::output::update_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIpRestrictionOutput {
    /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request. </p>
    pub status: i32,
}
impl UpdateIpRestrictionOutput {
    /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request. </p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateIpRestrictionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIpRestrictionOutput");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateIpRestrictionOutput`](crate::output::UpdateIpRestrictionOutput)
pub mod update_ip_restriction_output {
    /// A builder for [`UpdateIpRestrictionOutput`](crate::output::UpdateIpRestrictionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request. </p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request. </p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIpRestrictionOutput`](crate::output::UpdateIpRestrictionOutput)
        pub fn build(self) -> crate::output::UpdateIpRestrictionOutput {
            crate::output::UpdateIpRestrictionOutput {
                aws_account_id: self.aws_account_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateIpRestrictionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIpRestrictionOutput`](crate::output::UpdateIpRestrictionOutput)
    pub fn builder() -> crate::output::update_ip_restriction_output::Builder {
        crate::output::update_ip_restriction_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIamPolicyAssignmentOutput {
    /// <p>The name of the assignment or rule.</p>
    pub assignment_name: std::option::Option<std::string::String>,
    /// <p>The ID of the assignment.</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
    pub identities: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The status of the assignment. Possible values are as follows:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
    /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
    /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
    /// </ul>
    pub assignment_status: std::option::Option<crate::model::AssignmentStatus>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateIamPolicyAssignmentOutput {
    /// <p>The name of the assignment or rule.</p>
    pub fn assignment_name(&self) -> std::option::Option<&str> {
        self.assignment_name.as_deref()
    }
    /// <p>The ID of the assignment.</p>
    pub fn assignment_id(&self) -> std::option::Option<&str> {
        self.assignment_id.as_deref()
    }
    /// <p>The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
    pub fn identities(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.identities.as_ref()
    }
    /// <p>The status of the assignment. Possible values are as follows:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
    /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
    /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
    /// </ul>
    pub fn assignment_status(&self) -> std::option::Option<&crate::model::AssignmentStatus> {
        self.assignment_status.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateIamPolicyAssignmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIamPolicyAssignmentOutput");
        formatter.field("assignment_name", &self.assignment_name);
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("identities", &self.identities);
        formatter.field("assignment_status", &self.assignment_status);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateIamPolicyAssignmentOutput`](crate::output::UpdateIamPolicyAssignmentOutput)
pub mod update_iam_policy_assignment_output {
    /// A builder for [`UpdateIamPolicyAssignmentOutput`](crate::output::UpdateIamPolicyAssignmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) identities: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatus>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the assignment or rule.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>The name of the assignment or rule.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The ID of the assignment.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>The ID of the assignment.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Adds a key-value pair to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identities.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.identities = Some(hash_map);
            self
        }
        /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.identities = input;
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIamPolicyAssignmentOutput`](crate::output::UpdateIamPolicyAssignmentOutput)
        pub fn build(self) -> crate::output::UpdateIamPolicyAssignmentOutput {
            crate::output::UpdateIamPolicyAssignmentOutput {
                assignment_name: self.assignment_name,
                assignment_id: self.assignment_id,
                policy_arn: self.policy_arn,
                identities: self.identities,
                assignment_status: self.assignment_status,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateIamPolicyAssignmentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIamPolicyAssignmentOutput`](crate::output::UpdateIamPolicyAssignmentOutput)
    pub fn builder() -> crate::output::update_iam_policy_assignment_output::Builder {
        crate::output::update_iam_policy_assignment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupOutput {
    /// <p>The name of the group.</p>
    pub group: std::option::Option<crate::model::Group>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateGroupOutput {
    /// <p>The name of the group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::Group> {
        self.group.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupOutput");
        formatter.field("group", &self.group);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
pub mod update_group_output {
    /// A builder for [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
        pub fn build(self) -> crate::output::UpdateGroupOutput {
            crate::output::UpdateGroupOutput {
                group: self.group,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    pub fn builder() -> crate::output::update_group_output::Builder {
        crate::output::update_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFolderPermissionsOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Resource Name (ARN) of the folder.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>Information about the permissions for the folder.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateFolderPermissionsOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Resource Name (ARN) of the folder.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>Information about the permissions for the folder.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateFolderPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFolderPermissionsOutput");
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("folder_id", &self.folder_id);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateFolderPermissionsOutput`](crate::output::UpdateFolderPermissionsOutput)
pub mod update_folder_permissions_output {
    /// A builder for [`UpdateFolderPermissionsOutput`](crate::output::UpdateFolderPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the folder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the folder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Information about the permissions for the folder.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>Information about the permissions for the folder.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFolderPermissionsOutput`](crate::output::UpdateFolderPermissionsOutput)
        pub fn build(self) -> crate::output::UpdateFolderPermissionsOutput {
            crate::output::UpdateFolderPermissionsOutput {
                status: self.status.unwrap_or_default(),
                arn: self.arn,
                folder_id: self.folder_id,
                permissions: self.permissions,
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateFolderPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFolderPermissionsOutput`](crate::output::UpdateFolderPermissionsOutput)
    pub fn builder() -> crate::output::update_folder_permissions_output::Builder {
        crate::output::update_folder_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Resource Name (ARN) of the folder.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Resource Name (ARN) of the folder.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFolderOutput");
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("folder_id", &self.folder_id);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
pub mod update_folder_output {
    /// A builder for [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the folder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the folder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
        pub fn build(self) -> crate::output::UpdateFolderOutput {
            crate::output::UpdateFolderOutput {
                status: self.status.unwrap_or_default(),
                arn: self.arn,
                folder_id: self.folder_id,
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateFolderOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFolderOutput`](crate::output::UpdateFolderOutput)
    pub fn builder() -> crate::output::update_folder_output::Builder {
        crate::output::update_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSourcePermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub data_source_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateDataSourcePermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub fn data_source_arn(&self) -> std::option::Option<&str> {
        self.data_source_arn.as_deref()
    }
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateDataSourcePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSourcePermissionsOutput");
        formatter.field("data_source_arn", &self.data_source_arn);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateDataSourcePermissionsOutput`](crate::output::UpdateDataSourcePermissionsOutput)
pub mod update_data_source_permissions_output {
    /// A builder for [`UpdateDataSourcePermissionsOutput`](crate::output::UpdateDataSourcePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_arn: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn data_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn set_data_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_arn = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSourcePermissionsOutput`](crate::output::UpdateDataSourcePermissionsOutput)
        pub fn build(self) -> crate::output::UpdateDataSourcePermissionsOutput {
            crate::output::UpdateDataSourcePermissionsOutput {
                data_source_arn: self.data_source_arn,
                data_source_id: self.data_source_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateDataSourcePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDataSourcePermissionsOutput`](crate::output::UpdateDataSourcePermissionsOutput)
    pub fn builder() -> crate::output::update_data_source_permissions_output::Builder {
        crate::output::update_data_source_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The update status of the data source's last update.</p>
    pub update_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateDataSourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The update status of the data source's last update.</p>
    pub fn update_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.update_status.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSourceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("update_status", &self.update_status);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
pub mod update_data_source_output {
    /// A builder for [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) update_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The update status of the data source's last update.</p>
        pub fn update_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.update_status = Some(input);
            self
        }
        /// <p>The update status of the data source's last update.</p>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
        pub fn build(self) -> crate::output::UpdateDataSourceOutput {
            crate::output::UpdateDataSourceOutput {
                arn: self.arn,
                data_source_id: self.data_source_id,
                update_status: self.update_status,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
    pub fn builder() -> crate::output::update_data_source_output::Builder {
        crate::output::update_data_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSetPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub data_set_arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateDataSetPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn data_set_arn(&self) -> std::option::Option<&str> {
        self.data_set_arn.as_deref()
    }
    /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateDataSetPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSetPermissionsOutput");
        formatter.field("data_set_arn", &self.data_set_arn);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateDataSetPermissionsOutput`](crate::output::UpdateDataSetPermissionsOutput)
pub mod update_data_set_permissions_output {
    /// A builder for [`UpdateDataSetPermissionsOutput`](crate::output::UpdateDataSetPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_arn: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn data_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_data_set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_arn = input;
            self
        }
        /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSetPermissionsOutput`](crate::output::UpdateDataSetPermissionsOutput)
        pub fn build(self) -> crate::output::UpdateDataSetPermissionsOutput {
            crate::output::UpdateDataSetPermissionsOutput {
                data_set_arn: self.data_set_arn,
                data_set_id: self.data_set_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateDataSetPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDataSetPermissionsOutput`](crate::output::UpdateDataSetPermissionsOutput)
    pub fn builder() -> crate::output::update_data_set_permissions_output::Builder {
        crate::output::update_data_set_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub ingestion_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub ingestion_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateDataSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub fn ingestion_arn(&self) -> std::option::Option<&str> {
        self.ingestion_arn.as_deref()
    }
    /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub fn ingestion_id(&self) -> std::option::Option<&str> {
        self.ingestion_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("ingestion_arn", &self.ingestion_arn);
        formatter.field("ingestion_id", &self.ingestion_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
pub mod update_data_set_output {
    /// A builder for [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_arn: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn ingestion_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn set_ingestion_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ingestion_arn = input;
            self
        }
        /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
        pub fn build(self) -> crate::output::UpdateDataSetOutput {
            crate::output::UpdateDataSetOutput {
                arn: self.arn,
                data_set_id: self.data_set_id,
                ingestion_arn: self.ingestion_arn,
                ingestion_id: self.ingestion_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateDataSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDataSetOutput`](crate::output::UpdateDataSetOutput)
    pub fn builder() -> crate::output::update_data_set_output::Builder {
        crate::output::update_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDashboardPublishedVersionOutput {
    /// <p>The ID for the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub dashboard_arn: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateDashboardPublishedVersionOutput {
    /// <p>The ID for the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub fn dashboard_arn(&self) -> std::option::Option<&str> {
        self.dashboard_arn.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDashboardPublishedVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDashboardPublishedVersionOutput");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("dashboard_arn", &self.dashboard_arn);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateDashboardPublishedVersionOutput`](crate::output::UpdateDashboardPublishedVersionOutput)
pub mod update_dashboard_published_version_output {
    /// A builder for [`UpdateDashboardPublishedVersionOutput`](crate::output::UpdateDashboardPublishedVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn dashboard_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn set_dashboard_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_arn = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDashboardPublishedVersionOutput`](crate::output::UpdateDashboardPublishedVersionOutput)
        pub fn build(self) -> crate::output::UpdateDashboardPublishedVersionOutput {
            crate::output::UpdateDashboardPublishedVersionOutput {
                dashboard_id: self.dashboard_id,
                dashboard_arn: self.dashboard_arn,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateDashboardPublishedVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardPublishedVersionOutput`](crate::output::UpdateDashboardPublishedVersionOutput)
    pub fn builder() -> crate::output::update_dashboard_published_version_output::Builder {
        crate::output::update_dashboard_published_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDashboardPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub dashboard_arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>Information about the permissions on the dashboard.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>Updates the permissions of a shared link to an Amazon QuickSight dashboard.</p>
    pub link_sharing_configuration: std::option::Option<crate::model::LinkSharingConfiguration>,
}
impl UpdateDashboardPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub fn dashboard_arn(&self) -> std::option::Option<&str> {
        self.dashboard_arn.as_deref()
    }
    /// <p>The ID for the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>Information about the permissions on the dashboard.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>Updates the permissions of a shared link to an Amazon QuickSight dashboard.</p>
    pub fn link_sharing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LinkSharingConfiguration> {
        self.link_sharing_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateDashboardPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDashboardPermissionsOutput");
        formatter.field("dashboard_arn", &self.dashboard_arn);
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.field(
            "link_sharing_configuration",
            &self.link_sharing_configuration,
        );
        formatter.finish()
    }
}
/// See [`UpdateDashboardPermissionsOutput`](crate::output::UpdateDashboardPermissionsOutput)
pub mod update_dashboard_permissions_output {
    /// A builder for [`UpdateDashboardPermissionsOutput`](crate::output::UpdateDashboardPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_arn: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) link_sharing_configuration:
            std::option::Option<crate::model::LinkSharingConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn dashboard_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn set_dashboard_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_arn = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Information about the permissions on the dashboard.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>Information about the permissions on the dashboard.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>Updates the permissions of a shared link to an Amazon QuickSight dashboard.</p>
        pub fn link_sharing_configuration(
            mut self,
            input: crate::model::LinkSharingConfiguration,
        ) -> Self {
            self.link_sharing_configuration = Some(input);
            self
        }
        /// <p>Updates the permissions of a shared link to an Amazon QuickSight dashboard.</p>
        pub fn set_link_sharing_configuration(
            mut self,
            input: std::option::Option<crate::model::LinkSharingConfiguration>,
        ) -> Self {
            self.link_sharing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDashboardPermissionsOutput`](crate::output::UpdateDashboardPermissionsOutput)
        pub fn build(self) -> crate::output::UpdateDashboardPermissionsOutput {
            crate::output::UpdateDashboardPermissionsOutput {
                dashboard_arn: self.dashboard_arn,
                dashboard_id: self.dashboard_id,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
                link_sharing_configuration: self.link_sharing_configuration,
            }
        }
    }
}
impl UpdateDashboardPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardPermissionsOutput`](crate::output::UpdateDashboardPermissionsOutput)
    pub fn builder() -> crate::output::update_dashboard_permissions_output::Builder {
        crate::output::update_dashboard_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDashboardOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the dashboard, including the version number.</p>
    pub version_arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The creation status of the request.</p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateDashboardOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN of the dashboard, including the version number.</p>
    pub fn version_arn(&self) -> std::option::Option<&str> {
        self.version_arn.as_deref()
    }
    /// <p>The ID for the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The creation status of the request.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDashboardOutput");
        formatter.field("arn", &self.arn);
        formatter.field("version_arn", &self.version_arn);
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
pub mod update_dashboard_output {
    /// A builder for [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_arn: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN of the dashboard, including the version number.</p>
        pub fn version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dashboard, including the version number.</p>
        pub fn set_version_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_arn = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The creation status of the request.</p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The creation status of the request.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
        pub fn build(self) -> crate::output::UpdateDashboardOutput {
            crate::output::UpdateDashboardOutput {
                arn: self.arn,
                version_arn: self.version_arn,
                dashboard_id: self.dashboard_id,
                creation_status: self.creation_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateDashboardOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDashboardOutput`](crate::output::UpdateDashboardOutput)
    pub fn builder() -> crate::output::update_dashboard_output::Builder {
        crate::output::update_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnalysisPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the analysis that you updated.</p>
    pub analysis_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the analysis that you updated permissions for.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateAnalysisPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the analysis that you updated.</p>
    pub fn analysis_arn(&self) -> std::option::Option<&str> {
        self.analysis_arn.as_deref()
    }
    /// <p>The ID of the analysis that you updated permissions for.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateAnalysisPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnalysisPermissionsOutput");
        formatter.field("analysis_arn", &self.analysis_arn);
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateAnalysisPermissionsOutput`](crate::output::UpdateAnalysisPermissionsOutput)
pub mod update_analysis_permissions_output {
    /// A builder for [`UpdateAnalysisPermissionsOutput`](crate::output::UpdateAnalysisPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_arn: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the analysis that you updated.</p>
        pub fn analysis_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the analysis that you updated.</p>
        pub fn set_analysis_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_arn = input;
            self
        }
        /// <p>The ID of the analysis that you updated permissions for.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis that you updated permissions for.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnalysisPermissionsOutput`](crate::output::UpdateAnalysisPermissionsOutput)
        pub fn build(self) -> crate::output::UpdateAnalysisPermissionsOutput {
            crate::output::UpdateAnalysisPermissionsOutput {
                analysis_arn: self.analysis_arn,
                analysis_id: self.analysis_id,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateAnalysisPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAnalysisPermissionsOutput`](crate::output::UpdateAnalysisPermissionsOutput)
    pub fn builder() -> crate::output::update_analysis_permissions_output::Builder {
        crate::output::update_analysis_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnalysisOutput {
    /// <p>The ARN of the analysis that you're updating.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the analysis.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The update status of the last update that was made to the analysis.</p>
    pub update_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl UpdateAnalysisOutput {
    /// <p>The ARN of the analysis that you're updating.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the analysis.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The update status of the last update that was made to the analysis.</p>
    pub fn update_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.update_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnalysisOutput");
        formatter.field("arn", &self.arn);
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("update_status", &self.update_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`UpdateAnalysisOutput`](crate::output::UpdateAnalysisOutput)
pub mod update_analysis_output {
    /// A builder for [`UpdateAnalysisOutput`](crate::output::UpdateAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) update_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the analysis that you're updating.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the analysis that you're updating.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The update status of the last update that was made to the analysis.</p>
        pub fn update_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.update_status = Some(input);
            self
        }
        /// <p>The update status of the last update that was made to the analysis.</p>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnalysisOutput`](crate::output::UpdateAnalysisOutput)
        pub fn build(self) -> crate::output::UpdateAnalysisOutput {
            crate::output::UpdateAnalysisOutput {
                arn: self.arn,
                analysis_id: self.analysis_id,
                update_status: self.update_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl UpdateAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAnalysisOutput`](crate::output::UpdateAnalysisOutput)
    pub fn builder() -> crate::output::update_analysis_output::Builder {
        crate::output::update_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountSettingsOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateAccountSettingsOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateAccountSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountSettingsOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
pub mod update_account_settings_output {
    /// A builder for [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
        pub fn build(self) -> crate::output::UpdateAccountSettingsOutput {
            crate::output::UpdateAccountSettingsOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateAccountSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
    pub fn builder() -> crate::output::update_account_settings_output::Builder {
        crate::output::update_account_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountCustomizationOutput {
    /// <p>The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The namespace associated with the customization that you're updating.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
    pub account_customization: std::option::Option<crate::model::AccountCustomization>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UpdateAccountCustomizationOutput {
    /// <p>The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The namespace associated with the customization that you're updating.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
    pub fn account_customization(
        &self,
    ) -> std::option::Option<&crate::model::AccountCustomization> {
        self.account_customization.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UpdateAccountCustomizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountCustomizationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("namespace", &self.namespace);
        formatter.field("account_customization", &self.account_customization);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateAccountCustomizationOutput`](crate::output::UpdateAccountCustomizationOutput)
pub mod update_account_customization_output {
    /// A builder for [`UpdateAccountCustomizationOutput`](crate::output::UpdateAccountCustomizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) account_customization: std::option::Option<crate::model::AccountCustomization>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace associated with the customization that you're updating.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace associated with the customization that you're updating.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn account_customization(mut self, input: crate::model::AccountCustomization) -> Self {
            self.account_customization = Some(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.account_customization = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountCustomizationOutput`](crate::output::UpdateAccountCustomizationOutput)
        pub fn build(self) -> crate::output::UpdateAccountCustomizationOutput {
            crate::output::UpdateAccountCustomizationOutput {
                arn: self.arn,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                account_customization: self.account_customization,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UpdateAccountCustomizationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccountCustomizationOutput`](crate::output::UpdateAccountCustomizationOutput)
    pub fn builder() -> crate::output::update_account_customization_output::Builder {
        crate::output::update_account_customization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl UntagResourceOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl TagResourceOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchGroupsOutput {
    /// <p>A list of groups in a specified namespace that match the filters you set in your <code>SearchGroups</code> request.</p>
    pub group_list: std::option::Option<std::vec::Vec<crate::model::Group>>,
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl SearchGroupsOutput {
    /// <p>A list of groups in a specified namespace that match the filters you set in your <code>SearchGroups</code> request.</p>
    pub fn group_list(&self) -> std::option::Option<&[crate::model::Group]> {
        self.group_list.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for SearchGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchGroupsOutput");
        formatter.field("group_list", &self.group_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SearchGroupsOutput`](crate::output::SearchGroupsOutput)
pub mod search_groups_output {
    /// A builder for [`SearchGroupsOutput`](crate::output::SearchGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_list: std::option::Option<std::vec::Vec<crate::model::Group>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `group_list`.
        ///
        /// To override the contents of this collection use [`set_group_list`](Self::set_group_list).
        ///
        /// <p>A list of groups in a specified namespace that match the filters you set in your <code>SearchGroups</code> request.</p>
        pub fn group_list(mut self, input: crate::model::Group) -> Self {
            let mut v = self.group_list.unwrap_or_default();
            v.push(input);
            self.group_list = Some(v);
            self
        }
        /// <p>A list of groups in a specified namespace that match the filters you set in your <code>SearchGroups</code> request.</p>
        pub fn set_group_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.group_list = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchGroupsOutput`](crate::output::SearchGroupsOutput)
        pub fn build(self) -> crate::output::SearchGroupsOutput {
            crate::output::SearchGroupsOutput {
                group_list: self.group_list,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl SearchGroupsOutput {
    /// Creates a new builder-style object to manufacture [`SearchGroupsOutput`](crate::output::SearchGroupsOutput)
    pub fn builder() -> crate::output::search_groups_output::Builder {
        crate::output::search_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchFoldersOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
    pub folder_summary_list: std::option::Option<std::vec::Vec<crate::model::FolderSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl SearchFoldersOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
    pub fn folder_summary_list(&self) -> std::option::Option<&[crate::model::FolderSummary]> {
        self.folder_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for SearchFoldersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchFoldersOutput");
        formatter.field("status", &self.status);
        formatter.field("folder_summary_list", &self.folder_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`SearchFoldersOutput`](crate::output::SearchFoldersOutput)
pub mod search_folders_output {
    /// A builder for [`SearchFoldersOutput`](crate::output::SearchFoldersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) folder_summary_list:
            std::option::Option<std::vec::Vec<crate::model::FolderSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `folder_summary_list`.
        ///
        /// To override the contents of this collection use [`set_folder_summary_list`](Self::set_folder_summary_list).
        ///
        /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
        pub fn folder_summary_list(mut self, input: crate::model::FolderSummary) -> Self {
            let mut v = self.folder_summary_list.unwrap_or_default();
            v.push(input);
            self.folder_summary_list = Some(v);
            self
        }
        /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
        pub fn set_folder_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderSummary>>,
        ) -> Self {
            self.folder_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchFoldersOutput`](crate::output::SearchFoldersOutput)
        pub fn build(self) -> crate::output::SearchFoldersOutput {
            crate::output::SearchFoldersOutput {
                status: self.status.unwrap_or_default(),
                folder_summary_list: self.folder_summary_list,
                next_token: self.next_token,
                request_id: self.request_id,
            }
        }
    }
}
impl SearchFoldersOutput {
    /// Creates a new builder-style object to manufacture [`SearchFoldersOutput`](crate::output::SearchFoldersOutput)
    pub fn builder() -> crate::output::search_folders_output::Builder {
        crate::output::search_folders_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchDashboardsOutput {
    /// <p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>
    pub dashboard_summary_list: std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl SearchDashboardsOutput {
    /// <p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>
    pub fn dashboard_summary_list(&self) -> std::option::Option<&[crate::model::DashboardSummary]> {
        self.dashboard_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for SearchDashboardsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchDashboardsOutput");
        formatter.field("dashboard_summary_list", &self.dashboard_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`SearchDashboardsOutput`](crate::output::SearchDashboardsOutput)
pub mod search_dashboards_output {
    /// A builder for [`SearchDashboardsOutput`](crate::output::SearchDashboardsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_summary_list:
            std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dashboard_summary_list`.
        ///
        /// To override the contents of this collection use [`set_dashboard_summary_list`](Self::set_dashboard_summary_list).
        ///
        /// <p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>
        pub fn dashboard_summary_list(mut self, input: crate::model::DashboardSummary) -> Self {
            let mut v = self.dashboard_summary_list.unwrap_or_default();
            v.push(input);
            self.dashboard_summary_list = Some(v);
            self
        }
        /// <p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>
        pub fn set_dashboard_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
        ) -> Self {
            self.dashboard_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchDashboardsOutput`](crate::output::SearchDashboardsOutput)
        pub fn build(self) -> crate::output::SearchDashboardsOutput {
            crate::output::SearchDashboardsOutput {
                dashboard_summary_list: self.dashboard_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl SearchDashboardsOutput {
    /// Creates a new builder-style object to manufacture [`SearchDashboardsOutput`](crate::output::SearchDashboardsOutput)
    pub fn builder() -> crate::output::search_dashboards_output::Builder {
        crate::output::search_dashboards_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchAnalysesOutput {
    /// <p>Metadata describing the analyses that you searched for.</p>
    pub analysis_summary_list: std::option::Option<std::vec::Vec<crate::model::AnalysisSummary>>,
    /// <p>A pagination token that can be used in a subsequent request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl SearchAnalysesOutput {
    /// <p>Metadata describing the analyses that you searched for.</p>
    pub fn analysis_summary_list(&self) -> std::option::Option<&[crate::model::AnalysisSummary]> {
        self.analysis_summary_list.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for SearchAnalysesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchAnalysesOutput");
        formatter.field("analysis_summary_list", &self.analysis_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`SearchAnalysesOutput`](crate::output::SearchAnalysesOutput)
pub mod search_analyses_output {
    /// A builder for [`SearchAnalysesOutput`](crate::output::SearchAnalysesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_summary_list:
            std::option::Option<std::vec::Vec<crate::model::AnalysisSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `analysis_summary_list`.
        ///
        /// To override the contents of this collection use [`set_analysis_summary_list`](Self::set_analysis_summary_list).
        ///
        /// <p>Metadata describing the analyses that you searched for.</p>
        pub fn analysis_summary_list(mut self, input: crate::model::AnalysisSummary) -> Self {
            let mut v = self.analysis_summary_list.unwrap_or_default();
            v.push(input);
            self.analysis_summary_list = Some(v);
            self
        }
        /// <p>Metadata describing the analyses that you searched for.</p>
        pub fn set_analysis_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisSummary>>,
        ) -> Self {
            self.analysis_summary_list = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchAnalysesOutput`](crate::output::SearchAnalysesOutput)
        pub fn build(self) -> crate::output::SearchAnalysesOutput {
            crate::output::SearchAnalysesOutput {
                analysis_summary_list: self.analysis_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl SearchAnalysesOutput {
    /// Creates a new builder-style object to manufacture [`SearchAnalysesOutput`](crate::output::SearchAnalysesOutput)
    pub fn builder() -> crate::output::search_analyses_output::Builder {
        crate::output::search_analyses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreAnalysisOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Resource Name (ARN) of the analysis that you're restoring.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the analysis that you're restoring. </p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl RestoreAnalysisOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Resource Name (ARN) of the analysis that you're restoring.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the analysis that you're restoring. </p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for RestoreAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreAnalysisOutput");
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`RestoreAnalysisOutput`](crate::output::RestoreAnalysisOutput)
pub mod restore_analysis_output {
    /// A builder for [`RestoreAnalysisOutput`](crate::output::RestoreAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the analysis that you're restoring.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the analysis that you're restoring.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the analysis that you're restoring. </p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis that you're restoring. </p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreAnalysisOutput`](crate::output::RestoreAnalysisOutput)
        pub fn build(self) -> crate::output::RestoreAnalysisOutput {
            crate::output::RestoreAnalysisOutput {
                status: self.status.unwrap_or_default(),
                arn: self.arn,
                analysis_id: self.analysis_id,
                request_id: self.request_id,
            }
        }
    }
}
impl RestoreAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`RestoreAnalysisOutput`](crate::output::RestoreAnalysisOutput)
    pub fn builder() -> crate::output::restore_analysis_output::Builder {
        crate::output::restore_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterUserOutput {
    /// <p>The user's user name.</p>
    pub user: std::option::Option<crate::model::User>,
    /// <p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>
    pub user_invitation_url: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl RegisterUserOutput {
    /// <p>The user's user name.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::User> {
        self.user.as_ref()
    }
    /// <p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>
    pub fn user_invitation_url(&self) -> std::option::Option<&str> {
        self.user_invitation_url.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for RegisterUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterUserOutput");
        formatter.field("user", &self.user);
        formatter.field("user_invitation_url", &self.user_invitation_url);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RegisterUserOutput`](crate::output::RegisterUserOutput)
pub mod register_user_output {
    /// A builder for [`RegisterUserOutput`](crate::output::RegisterUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
        pub(crate) user_invitation_url: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The user's user name.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The user's user name.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// <p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn user_invitation_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_invitation_url = Some(input.into());
            self
        }
        /// <p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn set_user_invitation_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_invitation_url = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterUserOutput`](crate::output::RegisterUserOutput)
        pub fn build(self) -> crate::output::RegisterUserOutput {
            crate::output::RegisterUserOutput {
                user: self.user,
                user_invitation_url: self.user_invitation_url,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl RegisterUserOutput {
    /// Creates a new builder-style object to manufacture [`RegisterUserOutput`](crate::output::RegisterUserOutput)
    pub fn builder() -> crate::output::register_user_output::Builder {
        crate::output::register_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersOutput {
    /// <p>The list of users.</p>
    pub user_list: std::option::Option<std::vec::Vec<crate::model::User>>,
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListUsersOutput {
    /// <p>The list of users.</p>
    pub fn user_list(&self) -> std::option::Option<&[crate::model::User]> {
        self.user_list.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersOutput");
        formatter.field("user_list", &self.user_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListUsersOutput`](crate::output::ListUsersOutput)
pub mod list_users_output {
    /// A builder for [`ListUsersOutput`](crate::output::ListUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_list: std::option::Option<std::vec::Vec<crate::model::User>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `user_list`.
        ///
        /// To override the contents of this collection use [`set_user_list`](Self::set_user_list).
        ///
        /// <p>The list of users.</p>
        pub fn user_list(mut self, input: crate::model::User) -> Self {
            let mut v = self.user_list.unwrap_or_default();
            v.push(input);
            self.user_list = Some(v);
            self
        }
        /// <p>The list of users.</p>
        pub fn set_user_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.user_list = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersOutput`](crate::output::ListUsersOutput)
        pub fn build(self) -> crate::output::ListUsersOutput {
            crate::output::ListUsersOutput {
                user_list: self.user_list,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListUsersOutput {
    /// Creates a new builder-style object to manufacture [`ListUsersOutput`](crate::output::ListUsersOutput)
    pub fn builder() -> crate::output::list_users_output::Builder {
        crate::output::list_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserGroupsOutput {
    /// <p>The list of groups the user is a member of.</p>
    pub group_list: std::option::Option<std::vec::Vec<crate::model::Group>>,
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListUserGroupsOutput {
    /// <p>The list of groups the user is a member of.</p>
    pub fn group_list(&self) -> std::option::Option<&[crate::model::Group]> {
        self.group_list.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListUserGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserGroupsOutput");
        formatter.field("group_list", &self.group_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListUserGroupsOutput`](crate::output::ListUserGroupsOutput)
pub mod list_user_groups_output {
    /// A builder for [`ListUserGroupsOutput`](crate::output::ListUserGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_list: std::option::Option<std::vec::Vec<crate::model::Group>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `group_list`.
        ///
        /// To override the contents of this collection use [`set_group_list`](Self::set_group_list).
        ///
        /// <p>The list of groups the user is a member of.</p>
        pub fn group_list(mut self, input: crate::model::Group) -> Self {
            let mut v = self.group_list.unwrap_or_default();
            v.push(input);
            self.group_list = Some(v);
            self
        }
        /// <p>The list of groups the user is a member of.</p>
        pub fn set_group_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.group_list = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserGroupsOutput`](crate::output::ListUserGroupsOutput)
        pub fn build(self) -> crate::output::ListUserGroupsOutput {
            crate::output::ListUserGroupsOutput {
                group_list: self.group_list,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListUserGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListUserGroupsOutput`](crate::output::ListUserGroupsOutput)
    pub fn builder() -> crate::output::list_user_groups_output::Builder {
        crate::output::list_user_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThemeVersionsOutput {
    /// <p>A structure containing a list of all the versions of the specified theme.</p>
    pub theme_version_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ThemeVersionSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListThemeVersionsOutput {
    /// <p>A structure containing a list of all the versions of the specified theme.</p>
    pub fn theme_version_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::ThemeVersionSummary]> {
        self.theme_version_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListThemeVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThemeVersionsOutput");
        formatter.field(
            "theme_version_summary_list",
            &self.theme_version_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListThemeVersionsOutput`](crate::output::ListThemeVersionsOutput)
pub mod list_theme_versions_output {
    /// A builder for [`ListThemeVersionsOutput`](crate::output::ListThemeVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_version_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ThemeVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `theme_version_summary_list`.
        ///
        /// To override the contents of this collection use [`set_theme_version_summary_list`](Self::set_theme_version_summary_list).
        ///
        /// <p>A structure containing a list of all the versions of the specified theme.</p>
        pub fn theme_version_summary_list(
            mut self,
            input: crate::model::ThemeVersionSummary,
        ) -> Self {
            let mut v = self.theme_version_summary_list.unwrap_or_default();
            v.push(input);
            self.theme_version_summary_list = Some(v);
            self
        }
        /// <p>A structure containing a list of all the versions of the specified theme.</p>
        pub fn set_theme_version_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeVersionSummary>>,
        ) -> Self {
            self.theme_version_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemeVersionsOutput`](crate::output::ListThemeVersionsOutput)
        pub fn build(self) -> crate::output::ListThemeVersionsOutput {
            crate::output::ListThemeVersionsOutput {
                theme_version_summary_list: self.theme_version_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl ListThemeVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListThemeVersionsOutput`](crate::output::ListThemeVersionsOutput)
    pub fn builder() -> crate::output::list_theme_versions_output::Builder {
        crate::output::list_theme_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThemesOutput {
    /// <p>Information about the themes in the list.</p>
    pub theme_summary_list: std::option::Option<std::vec::Vec<crate::model::ThemeSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListThemesOutput {
    /// <p>Information about the themes in the list.</p>
    pub fn theme_summary_list(&self) -> std::option::Option<&[crate::model::ThemeSummary]> {
        self.theme_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListThemesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThemesOutput");
        formatter.field("theme_summary_list", &self.theme_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListThemesOutput`](crate::output::ListThemesOutput)
pub mod list_themes_output {
    /// A builder for [`ListThemesOutput`](crate::output::ListThemesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ThemeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `theme_summary_list`.
        ///
        /// To override the contents of this collection use [`set_theme_summary_list`](Self::set_theme_summary_list).
        ///
        /// <p>Information about the themes in the list.</p>
        pub fn theme_summary_list(mut self, input: crate::model::ThemeSummary) -> Self {
            let mut v = self.theme_summary_list.unwrap_or_default();
            v.push(input);
            self.theme_summary_list = Some(v);
            self
        }
        /// <p>Information about the themes in the list.</p>
        pub fn set_theme_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeSummary>>,
        ) -> Self {
            self.theme_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemesOutput`](crate::output::ListThemesOutput)
        pub fn build(self) -> crate::output::ListThemesOutput {
            crate::output::ListThemesOutput {
                theme_summary_list: self.theme_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl ListThemesOutput {
    /// Creates a new builder-style object to manufacture [`ListThemesOutput`](crate::output::ListThemesOutput)
    pub fn builder() -> crate::output::list_themes_output::Builder {
        crate::output::list_themes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThemeAliasesOutput {
    /// <p>A structure containing the list of the theme's aliases.</p>
    pub theme_alias_list: std::option::Option<std::vec::Vec<crate::model::ThemeAlias>>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThemeAliasesOutput {
    /// <p>A structure containing the list of the theme's aliases.</p>
    pub fn theme_alias_list(&self) -> std::option::Option<&[crate::model::ThemeAlias]> {
        self.theme_alias_list.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThemeAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThemeAliasesOutput");
        formatter.field("theme_alias_list", &self.theme_alias_list);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThemeAliasesOutput`](crate::output::ListThemeAliasesOutput)
pub mod list_theme_aliases_output {
    /// A builder for [`ListThemeAliasesOutput`](crate::output::ListThemeAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_alias_list: std::option::Option<std::vec::Vec<crate::model::ThemeAlias>>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `theme_alias_list`.
        ///
        /// To override the contents of this collection use [`set_theme_alias_list`](Self::set_theme_alias_list).
        ///
        /// <p>A structure containing the list of the theme's aliases.</p>
        pub fn theme_alias_list(mut self, input: crate::model::ThemeAlias) -> Self {
            let mut v = self.theme_alias_list.unwrap_or_default();
            v.push(input);
            self.theme_alias_list = Some(v);
            self
        }
        /// <p>A structure containing the list of the theme's aliases.</p>
        pub fn set_theme_alias_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeAlias>>,
        ) -> Self {
            self.theme_alias_list = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThemeAliasesOutput`](crate::output::ListThemeAliasesOutput)
        pub fn build(self) -> crate::output::ListThemeAliasesOutput {
            crate::output::ListThemeAliasesOutput {
                theme_alias_list: self.theme_alias_list,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThemeAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListThemeAliasesOutput`](crate::output::ListThemeAliasesOutput)
    pub fn builder() -> crate::output::list_theme_aliases_output::Builder {
        crate::output::list_theme_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTemplateVersionsOutput {
    /// <p>A structure containing a list of all the versions of the specified template.</p>
    pub template_version_summary_list:
        std::option::Option<std::vec::Vec<crate::model::TemplateVersionSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListTemplateVersionsOutput {
    /// <p>A structure containing a list of all the versions of the specified template.</p>
    pub fn template_version_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::TemplateVersionSummary]> {
        self.template_version_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListTemplateVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTemplateVersionsOutput");
        formatter.field(
            "template_version_summary_list",
            &self.template_version_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListTemplateVersionsOutput`](crate::output::ListTemplateVersionsOutput)
pub mod list_template_versions_output {
    /// A builder for [`ListTemplateVersionsOutput`](crate::output::ListTemplateVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_version_summary_list:
            std::option::Option<std::vec::Vec<crate::model::TemplateVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `template_version_summary_list`.
        ///
        /// To override the contents of this collection use [`set_template_version_summary_list`](Self::set_template_version_summary_list).
        ///
        /// <p>A structure containing a list of all the versions of the specified template.</p>
        pub fn template_version_summary_list(
            mut self,
            input: crate::model::TemplateVersionSummary,
        ) -> Self {
            let mut v = self.template_version_summary_list.unwrap_or_default();
            v.push(input);
            self.template_version_summary_list = Some(v);
            self
        }
        /// <p>A structure containing a list of all the versions of the specified template.</p>
        pub fn set_template_version_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TemplateVersionSummary>>,
        ) -> Self {
            self.template_version_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplateVersionsOutput`](crate::output::ListTemplateVersionsOutput)
        pub fn build(self) -> crate::output::ListTemplateVersionsOutput {
            crate::output::ListTemplateVersionsOutput {
                template_version_summary_list: self.template_version_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl ListTemplateVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListTemplateVersionsOutput`](crate::output::ListTemplateVersionsOutput)
    pub fn builder() -> crate::output::list_template_versions_output::Builder {
        crate::output::list_template_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTemplatesOutput {
    /// <p>A structure containing information about the templates in the list.</p>
    pub template_summary_list: std::option::Option<std::vec::Vec<crate::model::TemplateSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListTemplatesOutput {
    /// <p>A structure containing information about the templates in the list.</p>
    pub fn template_summary_list(&self) -> std::option::Option<&[crate::model::TemplateSummary]> {
        self.template_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTemplatesOutput");
        formatter.field("template_summary_list", &self.template_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
pub mod list_templates_output {
    /// A builder for [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_summary_list:
            std::option::Option<std::vec::Vec<crate::model::TemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `template_summary_list`.
        ///
        /// To override the contents of this collection use [`set_template_summary_list`](Self::set_template_summary_list).
        ///
        /// <p>A structure containing information about the templates in the list.</p>
        pub fn template_summary_list(mut self, input: crate::model::TemplateSummary) -> Self {
            let mut v = self.template_summary_list.unwrap_or_default();
            v.push(input);
            self.template_summary_list = Some(v);
            self
        }
        /// <p>A structure containing information about the templates in the list.</p>
        pub fn set_template_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TemplateSummary>>,
        ) -> Self {
            self.template_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
        pub fn build(self) -> crate::output::ListTemplatesOutput {
            crate::output::ListTemplatesOutput {
                template_summary_list: self.template_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl ListTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
    pub fn builder() -> crate::output::list_templates_output::Builder {
        crate::output::list_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTemplateAliasesOutput {
    /// <p>A structure containing the list of the template's aliases.</p>
    pub template_alias_list: std::option::Option<std::vec::Vec<crate::model::TemplateAlias>>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTemplateAliasesOutput {
    /// <p>A structure containing the list of the template's aliases.</p>
    pub fn template_alias_list(&self) -> std::option::Option<&[crate::model::TemplateAlias]> {
        self.template_alias_list.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTemplateAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTemplateAliasesOutput");
        formatter.field("template_alias_list", &self.template_alias_list);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTemplateAliasesOutput`](crate::output::ListTemplateAliasesOutput)
pub mod list_template_aliases_output {
    /// A builder for [`ListTemplateAliasesOutput`](crate::output::ListTemplateAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_alias_list:
            std::option::Option<std::vec::Vec<crate::model::TemplateAlias>>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `template_alias_list`.
        ///
        /// To override the contents of this collection use [`set_template_alias_list`](Self::set_template_alias_list).
        ///
        /// <p>A structure containing the list of the template's aliases.</p>
        pub fn template_alias_list(mut self, input: crate::model::TemplateAlias) -> Self {
            let mut v = self.template_alias_list.unwrap_or_default();
            v.push(input);
            self.template_alias_list = Some(v);
            self
        }
        /// <p>A structure containing the list of the template's aliases.</p>
        pub fn set_template_alias_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TemplateAlias>>,
        ) -> Self {
            self.template_alias_list = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplateAliasesOutput`](crate::output::ListTemplateAliasesOutput)
        pub fn build(self) -> crate::output::ListTemplateAliasesOutput {
            crate::output::ListTemplateAliasesOutput {
                template_alias_list: self.template_alias_list,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTemplateAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListTemplateAliasesOutput`](crate::output::ListTemplateAliasesOutput)
    pub fn builder() -> crate::output::list_template_aliases_output::Builder {
        crate::output::list_template_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListTagsForResourceOutput {
    /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNamespacesOutput {
    /// <p>The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.</p>
    pub namespaces: std::option::Option<std::vec::Vec<crate::model::NamespaceInfoV2>>,
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListNamespacesOutput {
    /// <p>The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.</p>
    pub fn namespaces(&self) -> std::option::Option<&[crate::model::NamespaceInfoV2]> {
        self.namespaces.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListNamespacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNamespacesOutput");
        formatter.field("namespaces", &self.namespaces);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
pub mod list_namespaces_output {
    /// A builder for [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespaces: std::option::Option<std::vec::Vec<crate::model::NamespaceInfoV2>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `namespaces`.
        ///
        /// To override the contents of this collection use [`set_namespaces`](Self::set_namespaces).
        ///
        /// <p>The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.</p>
        pub fn namespaces(mut self, input: crate::model::NamespaceInfoV2) -> Self {
            let mut v = self.namespaces.unwrap_or_default();
            v.push(input);
            self.namespaces = Some(v);
            self
        }
        /// <p>The information about the namespaces in this Amazon Web Services account. The response includes the namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.</p>
        pub fn set_namespaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NamespaceInfoV2>>,
        ) -> Self {
            self.namespaces = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
        pub fn build(self) -> crate::output::ListNamespacesOutput {
            crate::output::ListNamespacesOutput {
                namespaces: self.namespaces,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListNamespacesOutput {
    /// Creates a new builder-style object to manufacture [`ListNamespacesOutput`](crate::output::ListNamespacesOutput)
    pub fn builder() -> crate::output::list_namespaces_output::Builder {
        crate::output::list_namespaces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIngestionsOutput {
    /// <p>A list of the ingestions.</p>
    pub ingestions: std::option::Option<std::vec::Vec<crate::model::Ingestion>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListIngestionsOutput {
    /// <p>A list of the ingestions.</p>
    pub fn ingestions(&self) -> std::option::Option<&[crate::model::Ingestion]> {
        self.ingestions.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListIngestionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIngestionsOutput");
        formatter.field("ingestions", &self.ingestions);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListIngestionsOutput`](crate::output::ListIngestionsOutput)
pub mod list_ingestions_output {
    /// A builder for [`ListIngestionsOutput`](crate::output::ListIngestionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ingestions: std::option::Option<std::vec::Vec<crate::model::Ingestion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `ingestions`.
        ///
        /// To override the contents of this collection use [`set_ingestions`](Self::set_ingestions).
        ///
        /// <p>A list of the ingestions.</p>
        pub fn ingestions(mut self, input: crate::model::Ingestion) -> Self {
            let mut v = self.ingestions.unwrap_or_default();
            v.push(input);
            self.ingestions = Some(v);
            self
        }
        /// <p>A list of the ingestions.</p>
        pub fn set_ingestions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ingestion>>,
        ) -> Self {
            self.ingestions = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIngestionsOutput`](crate::output::ListIngestionsOutput)
        pub fn build(self) -> crate::output::ListIngestionsOutput {
            crate::output::ListIngestionsOutput {
                ingestions: self.ingestions,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListIngestionsOutput {
    /// Creates a new builder-style object to manufacture [`ListIngestionsOutput`](crate::output::ListIngestionsOutput)
    pub fn builder() -> crate::output::list_ingestions_output::Builder {
        crate::output::list_ingestions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIamPolicyAssignmentsForUserOutput {
    /// <p>The active assignments for this user.</p>
    pub active_assignments:
        std::option::Option<std::vec::Vec<crate::model::ActiveIamPolicyAssignment>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListIamPolicyAssignmentsForUserOutput {
    /// <p>The active assignments for this user.</p>
    pub fn active_assignments(
        &self,
    ) -> std::option::Option<&[crate::model::ActiveIamPolicyAssignment]> {
        self.active_assignments.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListIamPolicyAssignmentsForUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIamPolicyAssignmentsForUserOutput");
        formatter.field("active_assignments", &self.active_assignments);
        formatter.field("request_id", &self.request_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListIamPolicyAssignmentsForUserOutput`](crate::output::ListIamPolicyAssignmentsForUserOutput)
pub mod list_iam_policy_assignments_for_user_output {
    /// A builder for [`ListIamPolicyAssignmentsForUserOutput`](crate::output::ListIamPolicyAssignmentsForUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_assignments:
            std::option::Option<std::vec::Vec<crate::model::ActiveIamPolicyAssignment>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `active_assignments`.
        ///
        /// To override the contents of this collection use [`set_active_assignments`](Self::set_active_assignments).
        ///
        /// <p>The active assignments for this user.</p>
        pub fn active_assignments(
            mut self,
            input: crate::model::ActiveIamPolicyAssignment,
        ) -> Self {
            let mut v = self.active_assignments.unwrap_or_default();
            v.push(input);
            self.active_assignments = Some(v);
            self
        }
        /// <p>The active assignments for this user.</p>
        pub fn set_active_assignments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveIamPolicyAssignment>>,
        ) -> Self {
            self.active_assignments = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIamPolicyAssignmentsForUserOutput`](crate::output::ListIamPolicyAssignmentsForUserOutput)
        pub fn build(self) -> crate::output::ListIamPolicyAssignmentsForUserOutput {
            crate::output::ListIamPolicyAssignmentsForUserOutput {
                active_assignments: self.active_assignments,
                request_id: self.request_id,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListIamPolicyAssignmentsForUserOutput {
    /// Creates a new builder-style object to manufacture [`ListIamPolicyAssignmentsForUserOutput`](crate::output::ListIamPolicyAssignmentsForUserOutput)
    pub fn builder() -> crate::output::list_iam_policy_assignments_for_user_output::Builder {
        crate::output::list_iam_policy_assignments_for_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIamPolicyAssignmentsOutput {
    /// <p>Information describing the IAM policy assignments.</p>
    pub iam_policy_assignments:
        std::option::Option<std::vec::Vec<crate::model::IamPolicyAssignmentSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListIamPolicyAssignmentsOutput {
    /// <p>Information describing the IAM policy assignments.</p>
    pub fn iam_policy_assignments(
        &self,
    ) -> std::option::Option<&[crate::model::IamPolicyAssignmentSummary]> {
        self.iam_policy_assignments.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListIamPolicyAssignmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIamPolicyAssignmentsOutput");
        formatter.field("iam_policy_assignments", &self.iam_policy_assignments);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListIamPolicyAssignmentsOutput`](crate::output::ListIamPolicyAssignmentsOutput)
pub mod list_iam_policy_assignments_output {
    /// A builder for [`ListIamPolicyAssignmentsOutput`](crate::output::ListIamPolicyAssignmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_policy_assignments:
            std::option::Option<std::vec::Vec<crate::model::IamPolicyAssignmentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `iam_policy_assignments`.
        ///
        /// To override the contents of this collection use [`set_iam_policy_assignments`](Self::set_iam_policy_assignments).
        ///
        /// <p>Information describing the IAM policy assignments.</p>
        pub fn iam_policy_assignments(
            mut self,
            input: crate::model::IamPolicyAssignmentSummary,
        ) -> Self {
            let mut v = self.iam_policy_assignments.unwrap_or_default();
            v.push(input);
            self.iam_policy_assignments = Some(v);
            self
        }
        /// <p>Information describing the IAM policy assignments.</p>
        pub fn set_iam_policy_assignments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IamPolicyAssignmentSummary>>,
        ) -> Self {
            self.iam_policy_assignments = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIamPolicyAssignmentsOutput`](crate::output::ListIamPolicyAssignmentsOutput)
        pub fn build(self) -> crate::output::ListIamPolicyAssignmentsOutput {
            crate::output::ListIamPolicyAssignmentsOutput {
                iam_policy_assignments: self.iam_policy_assignments,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListIamPolicyAssignmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListIamPolicyAssignmentsOutput`](crate::output::ListIamPolicyAssignmentsOutput)
    pub fn builder() -> crate::output::list_iam_policy_assignments_output::Builder {
        crate::output::list_iam_policy_assignments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsOutput {
    /// <p>The list of the groups.</p>
    pub group_list: std::option::Option<std::vec::Vec<crate::model::Group>>,
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListGroupsOutput {
    /// <p>The list of the groups.</p>
    pub fn group_list(&self) -> std::option::Option<&[crate::model::Group]> {
        self.group_list.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsOutput");
        formatter.field("group_list", &self.group_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListGroupsOutput`](crate::output::ListGroupsOutput)
pub mod list_groups_output {
    /// A builder for [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_list: std::option::Option<std::vec::Vec<crate::model::Group>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `group_list`.
        ///
        /// To override the contents of this collection use [`set_group_list`](Self::set_group_list).
        ///
        /// <p>The list of the groups.</p>
        pub fn group_list(mut self, input: crate::model::Group) -> Self {
            let mut v = self.group_list.unwrap_or_default();
            v.push(input);
            self.group_list = Some(v);
            self
        }
        /// <p>The list of the groups.</p>
        pub fn set_group_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.group_list = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsOutput`](crate::output::ListGroupsOutput)
        pub fn build(self) -> crate::output::ListGroupsOutput {
            crate::output::ListGroupsOutput {
                group_list: self.group_list,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    pub fn builder() -> crate::output::list_groups_output::Builder {
        crate::output::list_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupMembershipsOutput {
    /// <p>The list of the members of the group.</p>
    pub group_member_list: std::option::Option<std::vec::Vec<crate::model::GroupMember>>,
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListGroupMembershipsOutput {
    /// <p>The list of the members of the group.</p>
    pub fn group_member_list(&self) -> std::option::Option<&[crate::model::GroupMember]> {
        self.group_member_list.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListGroupMembershipsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupMembershipsOutput");
        formatter.field("group_member_list", &self.group_member_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListGroupMembershipsOutput`](crate::output::ListGroupMembershipsOutput)
pub mod list_group_memberships_output {
    /// A builder for [`ListGroupMembershipsOutput`](crate::output::ListGroupMembershipsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_member_list: std::option::Option<std::vec::Vec<crate::model::GroupMember>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `group_member_list`.
        ///
        /// To override the contents of this collection use [`set_group_member_list`](Self::set_group_member_list).
        ///
        /// <p>The list of the members of the group.</p>
        pub fn group_member_list(mut self, input: crate::model::GroupMember) -> Self {
            let mut v = self.group_member_list.unwrap_or_default();
            v.push(input);
            self.group_member_list = Some(v);
            self
        }
        /// <p>The list of the members of the group.</p>
        pub fn set_group_member_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupMember>>,
        ) -> Self {
            self.group_member_list = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupMembershipsOutput`](crate::output::ListGroupMembershipsOutput)
        pub fn build(self) -> crate::output::ListGroupMembershipsOutput {
            crate::output::ListGroupMembershipsOutput {
                group_member_list: self.group_member_list,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListGroupMembershipsOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupMembershipsOutput`](crate::output::ListGroupMembershipsOutput)
    pub fn builder() -> crate::output::list_group_memberships_output::Builder {
        crate::output::list_group_memberships_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFoldersOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
    pub folder_summary_list: std::option::Option<std::vec::Vec<crate::model::FolderSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListFoldersOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
    pub fn folder_summary_list(&self) -> std::option::Option<&[crate::model::FolderSummary]> {
        self.folder_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListFoldersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFoldersOutput");
        formatter.field("status", &self.status);
        formatter.field("folder_summary_list", &self.folder_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListFoldersOutput`](crate::output::ListFoldersOutput)
pub mod list_folders_output {
    /// A builder for [`ListFoldersOutput`](crate::output::ListFoldersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) folder_summary_list:
            std::option::Option<std::vec::Vec<crate::model::FolderSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `folder_summary_list`.
        ///
        /// To override the contents of this collection use [`set_folder_summary_list`](Self::set_folder_summary_list).
        ///
        /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
        pub fn folder_summary_list(mut self, input: crate::model::FolderSummary) -> Self {
            let mut v = self.folder_summary_list.unwrap_or_default();
            v.push(input);
            self.folder_summary_list = Some(v);
            self
        }
        /// <p>A structure that contains all of the folders in the Amazon Web Services account. This structure provides basic information about the folders.</p>
        pub fn set_folder_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderSummary>>,
        ) -> Self {
            self.folder_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFoldersOutput`](crate::output::ListFoldersOutput)
        pub fn build(self) -> crate::output::ListFoldersOutput {
            crate::output::ListFoldersOutput {
                status: self.status.unwrap_or_default(),
                folder_summary_list: self.folder_summary_list,
                next_token: self.next_token,
                request_id: self.request_id,
            }
        }
    }
}
impl ListFoldersOutput {
    /// Creates a new builder-style object to manufacture [`ListFoldersOutput`](crate::output::ListFoldersOutput)
    pub fn builder() -> crate::output::list_folders_output::Builder {
        crate::output::list_folders_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFolderMembersOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>A structure that contains all of the folder members (dashboards, analyses, and datasets) in the folder.</p>
    pub folder_member_list: std::option::Option<std::vec::Vec<crate::model::MemberIdArnPair>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListFolderMembersOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>A structure that contains all of the folder members (dashboards, analyses, and datasets) in the folder.</p>
    pub fn folder_member_list(&self) -> std::option::Option<&[crate::model::MemberIdArnPair]> {
        self.folder_member_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListFolderMembersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFolderMembersOutput");
        formatter.field("status", &self.status);
        formatter.field("folder_member_list", &self.folder_member_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListFolderMembersOutput`](crate::output::ListFolderMembersOutput)
pub mod list_folder_members_output {
    /// A builder for [`ListFolderMembersOutput`](crate::output::ListFolderMembersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) folder_member_list:
            std::option::Option<std::vec::Vec<crate::model::MemberIdArnPair>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `folder_member_list`.
        ///
        /// To override the contents of this collection use [`set_folder_member_list`](Self::set_folder_member_list).
        ///
        /// <p>A structure that contains all of the folder members (dashboards, analyses, and datasets) in the folder.</p>
        pub fn folder_member_list(mut self, input: crate::model::MemberIdArnPair) -> Self {
            let mut v = self.folder_member_list.unwrap_or_default();
            v.push(input);
            self.folder_member_list = Some(v);
            self
        }
        /// <p>A structure that contains all of the folder members (dashboards, analyses, and datasets) in the folder.</p>
        pub fn set_folder_member_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MemberIdArnPair>>,
        ) -> Self {
            self.folder_member_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFolderMembersOutput`](crate::output::ListFolderMembersOutput)
        pub fn build(self) -> crate::output::ListFolderMembersOutput {
            crate::output::ListFolderMembersOutput {
                status: self.status.unwrap_or_default(),
                folder_member_list: self.folder_member_list,
                next_token: self.next_token,
                request_id: self.request_id,
            }
        }
    }
}
impl ListFolderMembersOutput {
    /// Creates a new builder-style object to manufacture [`ListFolderMembersOutput`](crate::output::ListFolderMembersOutput)
    pub fn builder() -> crate::output::list_folder_members_output::Builder {
        crate::output::list_folder_members_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSourcesOutput {
    /// <p>A list of data sources.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListDataSourcesOutput {
    /// <p>A list of data sources.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.data_sources.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListDataSourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSourcesOutput");
        formatter.field("data_sources", &self.data_sources);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListDataSourcesOutput`](crate::output::ListDataSourcesOutput)
pub mod list_data_sources_output {
    /// A builder for [`ListDataSourcesOutput`](crate::output::ListDataSourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>A list of data sources.</p>
        pub fn data_sources(mut self, input: crate::model::DataSource) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input);
            self.data_sources = Some(v);
            self
        }
        /// <p>A list of data sources.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSourcesOutput`](crate::output::ListDataSourcesOutput)
        pub fn build(self) -> crate::output::ListDataSourcesOutput {
            crate::output::ListDataSourcesOutput {
                data_sources: self.data_sources,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListDataSourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListDataSourcesOutput`](crate::output::ListDataSourcesOutput)
    pub fn builder() -> crate::output::list_data_sources_output::Builder {
        crate::output::list_data_sources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSetsOutput {
    /// <p>The list of dataset summaries.</p>
    pub data_set_summaries: std::option::Option<std::vec::Vec<crate::model::DataSetSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl ListDataSetsOutput {
    /// <p>The list of dataset summaries.</p>
    pub fn data_set_summaries(&self) -> std::option::Option<&[crate::model::DataSetSummary]> {
        self.data_set_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for ListDataSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSetsOutput");
        formatter.field("data_set_summaries", &self.data_set_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
pub mod list_data_sets_output {
    /// A builder for [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_summaries:
            std::option::Option<std::vec::Vec<crate::model::DataSetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `data_set_summaries`.
        ///
        /// To override the contents of this collection use [`set_data_set_summaries`](Self::set_data_set_summaries).
        ///
        /// <p>The list of dataset summaries.</p>
        pub fn data_set_summaries(mut self, input: crate::model::DataSetSummary) -> Self {
            let mut v = self.data_set_summaries.unwrap_or_default();
            v.push(input);
            self.data_set_summaries = Some(v);
            self
        }
        /// <p>The list of dataset summaries.</p>
        pub fn set_data_set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSetSummary>>,
        ) -> Self {
            self.data_set_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
        pub fn build(self) -> crate::output::ListDataSetsOutput {
            crate::output::ListDataSetsOutput {
                data_set_summaries: self.data_set_summaries,
                next_token: self.next_token,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl ListDataSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDataSetsOutput`](crate::output::ListDataSetsOutput)
    pub fn builder() -> crate::output::list_data_sets_output::Builder {
        crate::output::list_data_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDashboardVersionsOutput {
    /// <p>A structure that contains information about each version of the dashboard.</p>
    pub dashboard_version_summary_list:
        std::option::Option<std::vec::Vec<crate::model::DashboardVersionSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListDashboardVersionsOutput {
    /// <p>A structure that contains information about each version of the dashboard.</p>
    pub fn dashboard_version_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::DashboardVersionSummary]> {
        self.dashboard_version_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListDashboardVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDashboardVersionsOutput");
        formatter.field(
            "dashboard_version_summary_list",
            &self.dashboard_version_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListDashboardVersionsOutput`](crate::output::ListDashboardVersionsOutput)
pub mod list_dashboard_versions_output {
    /// A builder for [`ListDashboardVersionsOutput`](crate::output::ListDashboardVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_version_summary_list:
            std::option::Option<std::vec::Vec<crate::model::DashboardVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dashboard_version_summary_list`.
        ///
        /// To override the contents of this collection use [`set_dashboard_version_summary_list`](Self::set_dashboard_version_summary_list).
        ///
        /// <p>A structure that contains information about each version of the dashboard.</p>
        pub fn dashboard_version_summary_list(
            mut self,
            input: crate::model::DashboardVersionSummary,
        ) -> Self {
            let mut v = self.dashboard_version_summary_list.unwrap_or_default();
            v.push(input);
            self.dashboard_version_summary_list = Some(v);
            self
        }
        /// <p>A structure that contains information about each version of the dashboard.</p>
        pub fn set_dashboard_version_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardVersionSummary>>,
        ) -> Self {
            self.dashboard_version_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDashboardVersionsOutput`](crate::output::ListDashboardVersionsOutput)
        pub fn build(self) -> crate::output::ListDashboardVersionsOutput {
            crate::output::ListDashboardVersionsOutput {
                dashboard_version_summary_list: self.dashboard_version_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl ListDashboardVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDashboardVersionsOutput`](crate::output::ListDashboardVersionsOutput)
    pub fn builder() -> crate::output::list_dashboard_versions_output::Builder {
        crate::output::list_dashboard_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDashboardsOutput {
    /// <p>A structure that contains all of the dashboards in your Amazon Web Services account. This structure provides basic information about the dashboards.</p>
    pub dashboard_summary_list: std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListDashboardsOutput {
    /// <p>A structure that contains all of the dashboards in your Amazon Web Services account. This structure provides basic information about the dashboards.</p>
    pub fn dashboard_summary_list(&self) -> std::option::Option<&[crate::model::DashboardSummary]> {
        self.dashboard_summary_list.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListDashboardsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDashboardsOutput");
        formatter.field("dashboard_summary_list", &self.dashboard_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
pub mod list_dashboards_output {
    /// A builder for [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_summary_list:
            std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dashboard_summary_list`.
        ///
        /// To override the contents of this collection use [`set_dashboard_summary_list`](Self::set_dashboard_summary_list).
        ///
        /// <p>A structure that contains all of the dashboards in your Amazon Web Services account. This structure provides basic information about the dashboards.</p>
        pub fn dashboard_summary_list(mut self, input: crate::model::DashboardSummary) -> Self {
            let mut v = self.dashboard_summary_list.unwrap_or_default();
            v.push(input);
            self.dashboard_summary_list = Some(v);
            self
        }
        /// <p>A structure that contains all of the dashboards in your Amazon Web Services account. This structure provides basic information about the dashboards.</p>
        pub fn set_dashboard_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardSummary>>,
        ) -> Self {
            self.dashboard_summary_list = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
        pub fn build(self) -> crate::output::ListDashboardsOutput {
            crate::output::ListDashboardsOutput {
                dashboard_summary_list: self.dashboard_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl ListDashboardsOutput {
    /// Creates a new builder-style object to manufacture [`ListDashboardsOutput`](crate::output::ListDashboardsOutput)
    pub fn builder() -> crate::output::list_dashboards_output::Builder {
        crate::output::list_dashboards_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnalysesOutput {
    /// <p>Metadata describing each of the analyses that are listed.</p>
    pub analysis_summary_list: std::option::Option<std::vec::Vec<crate::model::AnalysisSummary>>,
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl ListAnalysesOutput {
    /// <p>Metadata describing each of the analyses that are listed.</p>
    pub fn analysis_summary_list(&self) -> std::option::Option<&[crate::model::AnalysisSummary]> {
        self.analysis_summary_list.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for ListAnalysesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnalysesOutput");
        formatter.field("analysis_summary_list", &self.analysis_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`ListAnalysesOutput`](crate::output::ListAnalysesOutput)
pub mod list_analyses_output {
    /// A builder for [`ListAnalysesOutput`](crate::output::ListAnalysesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_summary_list:
            std::option::Option<std::vec::Vec<crate::model::AnalysisSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `analysis_summary_list`.
        ///
        /// To override the contents of this collection use [`set_analysis_summary_list`](Self::set_analysis_summary_list).
        ///
        /// <p>Metadata describing each of the analyses that are listed.</p>
        pub fn analysis_summary_list(mut self, input: crate::model::AnalysisSummary) -> Self {
            let mut v = self.analysis_summary_list.unwrap_or_default();
            v.push(input);
            self.analysis_summary_list = Some(v);
            self
        }
        /// <p>Metadata describing each of the analyses that are listed.</p>
        pub fn set_analysis_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisSummary>>,
        ) -> Self {
            self.analysis_summary_list = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnalysesOutput`](crate::output::ListAnalysesOutput)
        pub fn build(self) -> crate::output::ListAnalysesOutput {
            crate::output::ListAnalysesOutput {
                analysis_summary_list: self.analysis_summary_list,
                next_token: self.next_token,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl ListAnalysesOutput {
    /// Creates a new builder-style object to manufacture [`ListAnalysesOutput`](crate::output::ListAnalysesOutput)
    pub fn builder() -> crate::output::list_analyses_output::Builder {
        crate::output::list_analyses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSessionEmbedUrlOutput {
    /// <p>A single-use URL that you can put into your server-side web page to embed your Amazon QuickSight session. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
    pub embed_url: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl GetSessionEmbedUrlOutput {
    /// <p>A single-use URL that you can put into your server-side web page to embed your Amazon QuickSight session. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
    pub fn embed_url(&self) -> std::option::Option<&str> {
        self.embed_url.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for GetSessionEmbedUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionEmbedUrlOutput");
        formatter.field("embed_url", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`GetSessionEmbedUrlOutput`](crate::output::GetSessionEmbedUrlOutput)
pub mod get_session_embed_url_output {
    /// A builder for [`GetSessionEmbedUrlOutput`](crate::output::GetSessionEmbedUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) embed_url: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A single-use URL that you can put into your server-side web page to embed your Amazon QuickSight session. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
        pub fn embed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.embed_url = Some(input.into());
            self
        }
        /// <p>A single-use URL that you can put into your server-side web page to embed your Amazon QuickSight session. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
        pub fn set_embed_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.embed_url = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionEmbedUrlOutput`](crate::output::GetSessionEmbedUrlOutput)
        pub fn build(self) -> crate::output::GetSessionEmbedUrlOutput {
            crate::output::GetSessionEmbedUrlOutput {
                embed_url: self.embed_url,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl GetSessionEmbedUrlOutput {
    /// Creates a new builder-style object to manufacture [`GetSessionEmbedUrlOutput`](crate::output::GetSessionEmbedUrlOutput)
    pub fn builder() -> crate::output::get_session_embed_url_output::Builder {
        crate::output::get_session_embed_url_output::Builder::default()
    }
}

/// <p>Output returned from the <code>GetDashboardEmbedUrl</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDashboardEmbedUrlOutput {
    /// <p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
    pub embed_url: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl GetDashboardEmbedUrlOutput {
    /// <p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
    pub fn embed_url(&self) -> std::option::Option<&str> {
        self.embed_url.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for GetDashboardEmbedUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDashboardEmbedUrlOutput");
        formatter.field("embed_url", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`GetDashboardEmbedUrlOutput`](crate::output::GetDashboardEmbedUrlOutput)
pub mod get_dashboard_embed_url_output {
    /// A builder for [`GetDashboardEmbedUrlOutput`](crate::output::GetDashboardEmbedUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) embed_url: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
        pub fn embed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.embed_url = Some(input.into());
            self
        }
        /// <p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API operation provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>
        pub fn set_embed_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.embed_url = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDashboardEmbedUrlOutput`](crate::output::GetDashboardEmbedUrlOutput)
        pub fn build(self) -> crate::output::GetDashboardEmbedUrlOutput {
            crate::output::GetDashboardEmbedUrlOutput {
                embed_url: self.embed_url,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl GetDashboardEmbedUrlOutput {
    /// Creates a new builder-style object to manufacture [`GetDashboardEmbedUrlOutput`](crate::output::GetDashboardEmbedUrlOutput)
    pub fn builder() -> crate::output::get_dashboard_embed_url_output::Builder {
        crate::output::get_dashboard_embed_url_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateEmbedUrlForRegisteredUserOutput {
    /// <p>The embed URL for the Amazon QuickSight dashboard or console.</p>
    pub embed_url: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl GenerateEmbedUrlForRegisteredUserOutput {
    /// <p>The embed URL for the Amazon QuickSight dashboard or console.</p>
    pub fn embed_url(&self) -> std::option::Option<&str> {
        self.embed_url.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for GenerateEmbedUrlForRegisteredUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateEmbedUrlForRegisteredUserOutput");
        formatter.field("embed_url", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`GenerateEmbedUrlForRegisteredUserOutput`](crate::output::GenerateEmbedUrlForRegisteredUserOutput)
pub mod generate_embed_url_for_registered_user_output {
    /// A builder for [`GenerateEmbedUrlForRegisteredUserOutput`](crate::output::GenerateEmbedUrlForRegisteredUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) embed_url: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The embed URL for the Amazon QuickSight dashboard or console.</p>
        pub fn embed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.embed_url = Some(input.into());
            self
        }
        /// <p>The embed URL for the Amazon QuickSight dashboard or console.</p>
        pub fn set_embed_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.embed_url = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateEmbedUrlForRegisteredUserOutput`](crate::output::GenerateEmbedUrlForRegisteredUserOutput)
        pub fn build(self) -> crate::output::GenerateEmbedUrlForRegisteredUserOutput {
            crate::output::GenerateEmbedUrlForRegisteredUserOutput {
                embed_url: self.embed_url,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl GenerateEmbedUrlForRegisteredUserOutput {
    /// Creates a new builder-style object to manufacture [`GenerateEmbedUrlForRegisteredUserOutput`](crate::output::GenerateEmbedUrlForRegisteredUserOutput)
    pub fn builder() -> crate::output::generate_embed_url_for_registered_user_output::Builder {
        crate::output::generate_embed_url_for_registered_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateEmbedUrlForAnonymousUserOutput {
    /// <p>The embed URL for the dashboard.</p>
    pub embed_url: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl GenerateEmbedUrlForAnonymousUserOutput {
    /// <p>The embed URL for the dashboard.</p>
    pub fn embed_url(&self) -> std::option::Option<&str> {
        self.embed_url.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for GenerateEmbedUrlForAnonymousUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateEmbedUrlForAnonymousUserOutput");
        formatter.field("embed_url", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`GenerateEmbedUrlForAnonymousUserOutput`](crate::output::GenerateEmbedUrlForAnonymousUserOutput)
pub mod generate_embed_url_for_anonymous_user_output {
    /// A builder for [`GenerateEmbedUrlForAnonymousUserOutput`](crate::output::GenerateEmbedUrlForAnonymousUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) embed_url: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The embed URL for the dashboard.</p>
        pub fn embed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.embed_url = Some(input.into());
            self
        }
        /// <p>The embed URL for the dashboard.</p>
        pub fn set_embed_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.embed_url = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateEmbedUrlForAnonymousUserOutput`](crate::output::GenerateEmbedUrlForAnonymousUserOutput)
        pub fn build(self) -> crate::output::GenerateEmbedUrlForAnonymousUserOutput {
            crate::output::GenerateEmbedUrlForAnonymousUserOutput {
                embed_url: self.embed_url,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl GenerateEmbedUrlForAnonymousUserOutput {
    /// Creates a new builder-style object to manufacture [`GenerateEmbedUrlForAnonymousUserOutput`](crate::output::GenerateEmbedUrlForAnonymousUserOutput)
    pub fn builder() -> crate::output::generate_embed_url_for_anonymous_user_output::Builder {
        crate::output::generate_embed_url_for_anonymous_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserOutput {
    /// <p>The user name.</p>
    pub user: std::option::Option<crate::model::User>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeUserOutput {
    /// <p>The user name.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::User> {
        self.user.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserOutput");
        formatter.field("user", &self.user);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeUserOutput`](crate::output::DescribeUserOutput)
pub mod describe_user_output {
    /// A builder for [`DescribeUserOutput`](crate::output::DescribeUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The user name.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The user name.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserOutput`](crate::output::DescribeUserOutput)
        pub fn build(self) -> crate::output::DescribeUserOutput {
            crate::output::DescribeUserOutput {
                user: self.user,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeUserOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserOutput`](crate::output::DescribeUserOutput)
    pub fn builder() -> crate::output::describe_user_output::Builder {
        crate::output::describe_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThemePermissionsOutput {
    /// <p>The ID for the theme.</p>
    pub theme_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the theme.</p>
    pub theme_arn: std::option::Option<std::string::String>,
    /// <p>A list of resource permissions set on the theme. </p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeThemePermissionsOutput {
    /// <p>The ID for the theme.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the theme.</p>
    pub fn theme_arn(&self) -> std::option::Option<&str> {
        self.theme_arn.as_deref()
    }
    /// <p>A list of resource permissions set on the theme. </p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeThemePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThemePermissionsOutput");
        formatter.field("theme_id", &self.theme_id);
        formatter.field("theme_arn", &self.theme_arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeThemePermissionsOutput`](crate::output::DescribeThemePermissionsOutput)
pub mod describe_theme_permissions_output {
    /// A builder for [`DescribeThemePermissionsOutput`](crate::output::DescribeThemePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions set on the theme. </p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions set on the theme. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThemePermissionsOutput`](crate::output::DescribeThemePermissionsOutput)
        pub fn build(self) -> crate::output::DescribeThemePermissionsOutput {
            crate::output::DescribeThemePermissionsOutput {
                theme_id: self.theme_id,
                theme_arn: self.theme_arn,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeThemePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeThemePermissionsOutput`](crate::output::DescribeThemePermissionsOutput)
    pub fn builder() -> crate::output::describe_theme_permissions_output::Builder {
        crate::output::describe_theme_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThemeAliasOutput {
    /// <p>Information about the theme alias.</p>
    pub theme_alias: std::option::Option<crate::model::ThemeAlias>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeThemeAliasOutput {
    /// <p>Information about the theme alias.</p>
    pub fn theme_alias(&self) -> std::option::Option<&crate::model::ThemeAlias> {
        self.theme_alias.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeThemeAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThemeAliasOutput");
        formatter.field("theme_alias", &self.theme_alias);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeThemeAliasOutput`](crate::output::DescribeThemeAliasOutput)
pub mod describe_theme_alias_output {
    /// A builder for [`DescribeThemeAliasOutput`](crate::output::DescribeThemeAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_alias: std::option::Option<crate::model::ThemeAlias>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the theme alias.</p>
        pub fn theme_alias(mut self, input: crate::model::ThemeAlias) -> Self {
            self.theme_alias = Some(input);
            self
        }
        /// <p>Information about the theme alias.</p>
        pub fn set_theme_alias(
            mut self,
            input: std::option::Option<crate::model::ThemeAlias>,
        ) -> Self {
            self.theme_alias = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThemeAliasOutput`](crate::output::DescribeThemeAliasOutput)
        pub fn build(self) -> crate::output::DescribeThemeAliasOutput {
            crate::output::DescribeThemeAliasOutput {
                theme_alias: self.theme_alias,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeThemeAliasOutput {
    /// Creates a new builder-style object to manufacture [`DescribeThemeAliasOutput`](crate::output::DescribeThemeAliasOutput)
    pub fn builder() -> crate::output::describe_theme_alias_output::Builder {
        crate::output::describe_theme_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThemeOutput {
    /// <p>The information about the theme that you are describing.</p>
    pub theme: std::option::Option<crate::model::Theme>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeThemeOutput {
    /// <p>The information about the theme that you are describing.</p>
    pub fn theme(&self) -> std::option::Option<&crate::model::Theme> {
        self.theme.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThemeOutput");
        formatter.field("theme", &self.theme);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeThemeOutput`](crate::output::DescribeThemeOutput)
pub mod describe_theme_output {
    /// A builder for [`DescribeThemeOutput`](crate::output::DescribeThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme: std::option::Option<crate::model::Theme>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The information about the theme that you are describing.</p>
        pub fn theme(mut self, input: crate::model::Theme) -> Self {
            self.theme = Some(input);
            self
        }
        /// <p>The information about the theme that you are describing.</p>
        pub fn set_theme(mut self, input: std::option::Option<crate::model::Theme>) -> Self {
            self.theme = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThemeOutput`](crate::output::DescribeThemeOutput)
        pub fn build(self) -> crate::output::DescribeThemeOutput {
            crate::output::DescribeThemeOutput {
                theme: self.theme,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeThemeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeThemeOutput`](crate::output::DescribeThemeOutput)
    pub fn builder() -> crate::output::describe_theme_output::Builder {
        crate::output::describe_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTemplatePermissionsOutput {
    /// <p>The ID for the template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>A list of resource permissions to be set on the template. </p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeTemplatePermissionsOutput {
    /// <p>The ID for the template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>A list of resource permissions to be set on the template. </p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeTemplatePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTemplatePermissionsOutput");
        formatter.field("template_id", &self.template_id);
        formatter.field("template_arn", &self.template_arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeTemplatePermissionsOutput`](crate::output::DescribeTemplatePermissionsOutput)
pub mod describe_template_permissions_output {
    /// A builder for [`DescribeTemplatePermissionsOutput`](crate::output::DescribeTemplatePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTemplatePermissionsOutput`](crate::output::DescribeTemplatePermissionsOutput)
        pub fn build(self) -> crate::output::DescribeTemplatePermissionsOutput {
            crate::output::DescribeTemplatePermissionsOutput {
                template_id: self.template_id,
                template_arn: self.template_arn,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeTemplatePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTemplatePermissionsOutput`](crate::output::DescribeTemplatePermissionsOutput)
    pub fn builder() -> crate::output::describe_template_permissions_output::Builder {
        crate::output::describe_template_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTemplateAliasOutput {
    /// <p>Information about the template alias.</p>
    pub template_alias: std::option::Option<crate::model::TemplateAlias>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeTemplateAliasOutput {
    /// <p>Information about the template alias.</p>
    pub fn template_alias(&self) -> std::option::Option<&crate::model::TemplateAlias> {
        self.template_alias.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTemplateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTemplateAliasOutput");
        formatter.field("template_alias", &self.template_alias);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeTemplateAliasOutput`](crate::output::DescribeTemplateAliasOutput)
pub mod describe_template_alias_output {
    /// A builder for [`DescribeTemplateAliasOutput`](crate::output::DescribeTemplateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_alias: std::option::Option<crate::model::TemplateAlias>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the template alias.</p>
        pub fn template_alias(mut self, input: crate::model::TemplateAlias) -> Self {
            self.template_alias = Some(input);
            self
        }
        /// <p>Information about the template alias.</p>
        pub fn set_template_alias(
            mut self,
            input: std::option::Option<crate::model::TemplateAlias>,
        ) -> Self {
            self.template_alias = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTemplateAliasOutput`](crate::output::DescribeTemplateAliasOutput)
        pub fn build(self) -> crate::output::DescribeTemplateAliasOutput {
            crate::output::DescribeTemplateAliasOutput {
                template_alias: self.template_alias,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeTemplateAliasOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTemplateAliasOutput`](crate::output::DescribeTemplateAliasOutput)
    pub fn builder() -> crate::output::describe_template_alias_output::Builder {
        crate::output::describe_template_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTemplateOutput {
    /// <p>The template structure for the object you want to describe.</p>
    pub template: std::option::Option<crate::model::Template>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeTemplateOutput {
    /// <p>The template structure for the object you want to describe.</p>
    pub fn template(&self) -> std::option::Option<&crate::model::Template> {
        self.template.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTemplateOutput");
        formatter.field("template", &self.template);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeTemplateOutput`](crate::output::DescribeTemplateOutput)
pub mod describe_template_output {
    /// A builder for [`DescribeTemplateOutput`](crate::output::DescribeTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<crate::model::Template>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The template structure for the object you want to describe.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.template = Some(input);
            self
        }
        /// <p>The template structure for the object you want to describe.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.template = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTemplateOutput`](crate::output::DescribeTemplateOutput)
        pub fn build(self) -> crate::output::DescribeTemplateOutput {
            crate::output::DescribeTemplateOutput {
                template: self.template,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTemplateOutput`](crate::output::DescribeTemplateOutput)
    pub fn builder() -> crate::output::describe_template_output::Builder {
        crate::output::describe_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNamespaceOutput {
    /// <p>The information about the namespace that you're describing. The response includes the namespace ARN, name, Amazon Web Services Region, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API operation lists the namespace error types and messages associated with the creation process.</p>
    pub namespace: std::option::Option<crate::model::NamespaceInfoV2>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeNamespaceOutput {
    /// <p>The information about the namespace that you're describing. The response includes the namespace ARN, name, Amazon Web Services Region, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API operation lists the namespace error types and messages associated with the creation process.</p>
    pub fn namespace(&self) -> std::option::Option<&crate::model::NamespaceInfoV2> {
        self.namespace.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNamespaceOutput");
        formatter.field("namespace", &self.namespace);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
pub mod describe_namespace_output {
    /// A builder for [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<crate::model::NamespaceInfoV2>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The information about the namespace that you're describing. The response includes the namespace ARN, name, Amazon Web Services Region, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API operation lists the namespace error types and messages associated with the creation process.</p>
        pub fn namespace(mut self, input: crate::model::NamespaceInfoV2) -> Self {
            self.namespace = Some(input);
            self
        }
        /// <p>The information about the namespace that you're describing. The response includes the namespace ARN, name, Amazon Web Services Region, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API operation lists the namespace error types and messages associated with the creation process.</p>
        pub fn set_namespace(
            mut self,
            input: std::option::Option<crate::model::NamespaceInfoV2>,
        ) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
        pub fn build(self) -> crate::output::DescribeNamespaceOutput {
            crate::output::DescribeNamespaceOutput {
                namespace: self.namespace,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNamespaceOutput`](crate::output::DescribeNamespaceOutput)
    pub fn builder() -> crate::output::describe_namespace_output::Builder {
        crate::output::describe_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIpRestrictionOutput {
    /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>A map that describes the IP rules with CIDR range and description.</p>
    pub ip_restriction_rule_map:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A value that specifies whether IP rules are turned on.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request. </p>
    pub status: i32,
}
impl DescribeIpRestrictionOutput {
    /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>A map that describes the IP rules with CIDR range and description.</p>
    pub fn ip_restriction_rule_map(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.ip_restriction_rule_map.as_ref()
    }
    /// <p>A value that specifies whether IP rules are turned on.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request. </p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeIpRestrictionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIpRestrictionOutput");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("ip_restriction_rule_map", &self.ip_restriction_rule_map);
        formatter.field("enabled", &self.enabled);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeIpRestrictionOutput`](crate::output::DescribeIpRestrictionOutput)
pub mod describe_ip_restriction_output {
    /// A builder for [`DescribeIpRestrictionOutput`](crate::output::DescribeIpRestrictionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) ip_restriction_rule_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the IP rules.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Adds a key-value pair to `ip_restriction_rule_map`.
        ///
        /// To override the contents of this collection use [`set_ip_restriction_rule_map`](Self::set_ip_restriction_rule_map).
        ///
        /// <p>A map that describes the IP rules with CIDR range and description.</p>
        pub fn ip_restriction_rule_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.ip_restriction_rule_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.ip_restriction_rule_map = Some(hash_map);
            self
        }
        /// <p>A map that describes the IP rules with CIDR range and description.</p>
        pub fn set_ip_restriction_rule_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.ip_restriction_rule_map = input;
            self
        }
        /// <p>A value that specifies whether IP rules are turned on.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A value that specifies whether IP rules are turned on.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request. </p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request. </p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIpRestrictionOutput`](crate::output::DescribeIpRestrictionOutput)
        pub fn build(self) -> crate::output::DescribeIpRestrictionOutput {
            crate::output::DescribeIpRestrictionOutput {
                aws_account_id: self.aws_account_id,
                ip_restriction_rule_map: self.ip_restriction_rule_map,
                enabled: self.enabled,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeIpRestrictionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIpRestrictionOutput`](crate::output::DescribeIpRestrictionOutput)
    pub fn builder() -> crate::output::describe_ip_restriction_output::Builder {
        crate::output::describe_ip_restriction_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIngestionOutput {
    /// <p>Information about the ingestion.</p>
    pub ingestion: std::option::Option<crate::model::Ingestion>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeIngestionOutput {
    /// <p>Information about the ingestion.</p>
    pub fn ingestion(&self) -> std::option::Option<&crate::model::Ingestion> {
        self.ingestion.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeIngestionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIngestionOutput");
        formatter.field("ingestion", &self.ingestion);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeIngestionOutput`](crate::output::DescribeIngestionOutput)
pub mod describe_ingestion_output {
    /// A builder for [`DescribeIngestionOutput`](crate::output::DescribeIngestionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ingestion: std::option::Option<crate::model::Ingestion>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Information about the ingestion.</p>
        pub fn ingestion(mut self, input: crate::model::Ingestion) -> Self {
            self.ingestion = Some(input);
            self
        }
        /// <p>Information about the ingestion.</p>
        pub fn set_ingestion(
            mut self,
            input: std::option::Option<crate::model::Ingestion>,
        ) -> Self {
            self.ingestion = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIngestionOutput`](crate::output::DescribeIngestionOutput)
        pub fn build(self) -> crate::output::DescribeIngestionOutput {
            crate::output::DescribeIngestionOutput {
                ingestion: self.ingestion,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeIngestionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIngestionOutput`](crate::output::DescribeIngestionOutput)
    pub fn builder() -> crate::output::describe_ingestion_output::Builder {
        crate::output::describe_ingestion_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIamPolicyAssignmentOutput {
    /// <p>Information describing the IAM policy assignment.</p>
    pub iam_policy_assignment: std::option::Option<crate::model::IamPolicyAssignment>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeIamPolicyAssignmentOutput {
    /// <p>Information describing the IAM policy assignment.</p>
    pub fn iam_policy_assignment(&self) -> std::option::Option<&crate::model::IamPolicyAssignment> {
        self.iam_policy_assignment.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeIamPolicyAssignmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIamPolicyAssignmentOutput");
        formatter.field("iam_policy_assignment", &self.iam_policy_assignment);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeIamPolicyAssignmentOutput`](crate::output::DescribeIamPolicyAssignmentOutput)
pub mod describe_iam_policy_assignment_output {
    /// A builder for [`DescribeIamPolicyAssignmentOutput`](crate::output::DescribeIamPolicyAssignmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_policy_assignment: std::option::Option<crate::model::IamPolicyAssignment>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Information describing the IAM policy assignment.</p>
        pub fn iam_policy_assignment(mut self, input: crate::model::IamPolicyAssignment) -> Self {
            self.iam_policy_assignment = Some(input);
            self
        }
        /// <p>Information describing the IAM policy assignment.</p>
        pub fn set_iam_policy_assignment(
            mut self,
            input: std::option::Option<crate::model::IamPolicyAssignment>,
        ) -> Self {
            self.iam_policy_assignment = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIamPolicyAssignmentOutput`](crate::output::DescribeIamPolicyAssignmentOutput)
        pub fn build(self) -> crate::output::DescribeIamPolicyAssignmentOutput {
            crate::output::DescribeIamPolicyAssignmentOutput {
                iam_policy_assignment: self.iam_policy_assignment,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeIamPolicyAssignmentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIamPolicyAssignmentOutput`](crate::output::DescribeIamPolicyAssignmentOutput)
    pub fn builder() -> crate::output::describe_iam_policy_assignment_output::Builder {
        crate::output::describe_iam_policy_assignment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGroupMembershipOutput {
    /// <p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups can't be members of another group. .</p>
    pub group_member: std::option::Option<crate::model::GroupMember>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeGroupMembershipOutput {
    /// <p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups can't be members of another group. .</p>
    pub fn group_member(&self) -> std::option::Option<&crate::model::GroupMember> {
        self.group_member.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeGroupMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGroupMembershipOutput");
        formatter.field("group_member", &self.group_member);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeGroupMembershipOutput`](crate::output::DescribeGroupMembershipOutput)
pub mod describe_group_membership_output {
    /// A builder for [`DescribeGroupMembershipOutput`](crate::output::DescribeGroupMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_member: std::option::Option<crate::model::GroupMember>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups can't be members of another group. .</p>
        pub fn group_member(mut self, input: crate::model::GroupMember) -> Self {
            self.group_member = Some(input);
            self
        }
        /// <p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups can't be members of another group. .</p>
        pub fn set_group_member(
            mut self,
            input: std::option::Option<crate::model::GroupMember>,
        ) -> Self {
            self.group_member = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGroupMembershipOutput`](crate::output::DescribeGroupMembershipOutput)
        pub fn build(self) -> crate::output::DescribeGroupMembershipOutput {
            crate::output::DescribeGroupMembershipOutput {
                group_member: self.group_member,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeGroupMembershipOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGroupMembershipOutput`](crate::output::DescribeGroupMembershipOutput)
    pub fn builder() -> crate::output::describe_group_membership_output::Builder {
        crate::output::describe_group_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGroupOutput {
    /// <p>The name of the group.</p>
    pub group: std::option::Option<crate::model::Group>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeGroupOutput {
    /// <p>The name of the group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::Group> {
        self.group.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGroupOutput");
        formatter.field("group", &self.group);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeGroupOutput`](crate::output::DescribeGroupOutput)
pub mod describe_group_output {
    /// A builder for [`DescribeGroupOutput`](crate::output::DescribeGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGroupOutput`](crate::output::DescribeGroupOutput)
        pub fn build(self) -> crate::output::DescribeGroupOutput {
            crate::output::DescribeGroupOutput {
                group: self.group,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGroupOutput`](crate::output::DescribeGroupOutput)
    pub fn builder() -> crate::output::describe_group_output::Builder {
        crate::output::describe_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFolderResolvedPermissionsOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the folder.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Information about the permissions for the folder.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeFolderResolvedPermissionsOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the folder.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Information about the permissions for the folder.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFolderResolvedPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFolderResolvedPermissionsOutput");
        formatter.field("status", &self.status);
        formatter.field("folder_id", &self.folder_id);
        formatter.field("arn", &self.arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeFolderResolvedPermissionsOutput`](crate::output::DescribeFolderResolvedPermissionsOutput)
pub mod describe_folder_resolved_permissions_output {
    /// A builder for [`DescribeFolderResolvedPermissionsOutput`](crate::output::DescribeFolderResolvedPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the folder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the folder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Information about the permissions for the folder.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>Information about the permissions for the folder.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderResolvedPermissionsOutput`](crate::output::DescribeFolderResolvedPermissionsOutput)
        pub fn build(self) -> crate::output::DescribeFolderResolvedPermissionsOutput {
            crate::output::DescribeFolderResolvedPermissionsOutput {
                status: self.status.unwrap_or_default(),
                folder_id: self.folder_id,
                arn: self.arn,
                permissions: self.permissions,
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeFolderResolvedPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFolderResolvedPermissionsOutput`](crate::output::DescribeFolderResolvedPermissionsOutput)
    pub fn builder() -> crate::output::describe_folder_resolved_permissions_output::Builder {
        crate::output::describe_folder_resolved_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFolderPermissionsOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the folder.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Information about the permissions on the folder.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeFolderPermissionsOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the folder.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Information about the permissions on the folder.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFolderPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFolderPermissionsOutput");
        formatter.field("status", &self.status);
        formatter.field("folder_id", &self.folder_id);
        formatter.field("arn", &self.arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeFolderPermissionsOutput`](crate::output::DescribeFolderPermissionsOutput)
pub mod describe_folder_permissions_output {
    /// A builder for [`DescribeFolderPermissionsOutput`](crate::output::DescribeFolderPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the folder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the folder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Information about the permissions on the folder.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>Information about the permissions on the folder.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderPermissionsOutput`](crate::output::DescribeFolderPermissionsOutput)
        pub fn build(self) -> crate::output::DescribeFolderPermissionsOutput {
            crate::output::DescribeFolderPermissionsOutput {
                status: self.status.unwrap_or_default(),
                folder_id: self.folder_id,
                arn: self.arn,
                permissions: self.permissions,
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeFolderPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFolderPermissionsOutput`](crate::output::DescribeFolderPermissionsOutput)
    pub fn builder() -> crate::output::describe_folder_permissions_output::Builder {
        crate::output::describe_folder_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>Information about the folder.</p>
    pub folder: std::option::Option<crate::model::Folder>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>Information about the folder.</p>
    pub fn folder(&self) -> std::option::Option<&crate::model::Folder> {
        self.folder.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFolderOutput");
        formatter.field("status", &self.status);
        formatter.field("folder", &self.folder);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeFolderOutput`](crate::output::DescribeFolderOutput)
pub mod describe_folder_output {
    /// A builder for [`DescribeFolderOutput`](crate::output::DescribeFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) folder: std::option::Option<crate::model::Folder>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about the folder.</p>
        pub fn folder(mut self, input: crate::model::Folder) -> Self {
            self.folder = Some(input);
            self
        }
        /// <p>Information about the folder.</p>
        pub fn set_folder(mut self, input: std::option::Option<crate::model::Folder>) -> Self {
            self.folder = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFolderOutput`](crate::output::DescribeFolderOutput)
        pub fn build(self) -> crate::output::DescribeFolderOutput {
            crate::output::DescribeFolderOutput {
                status: self.status.unwrap_or_default(),
                folder: self.folder,
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeFolderOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFolderOutput`](crate::output::DescribeFolderOutput)
    pub fn builder() -> crate::output::describe_folder_output::Builder {
        crate::output::describe_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSourcePermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub data_source_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>A list of resource permissions on the data source.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeDataSourcePermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub fn data_source_arn(&self) -> std::option::Option<&str> {
        self.data_source_arn.as_deref()
    }
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>A list of resource permissions on the data source.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeDataSourcePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSourcePermissionsOutput");
        formatter.field("data_source_arn", &self.data_source_arn);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeDataSourcePermissionsOutput`](crate::output::DescribeDataSourcePermissionsOutput)
pub mod describe_data_source_permissions_output {
    /// A builder for [`DescribeDataSourcePermissionsOutput`](crate::output::DescribeDataSourcePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_arn: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn data_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn set_data_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_arn = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the data source.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions on the data source.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSourcePermissionsOutput`](crate::output::DescribeDataSourcePermissionsOutput)
        pub fn build(self) -> crate::output::DescribeDataSourcePermissionsOutput {
            crate::output::DescribeDataSourcePermissionsOutput {
                data_source_arn: self.data_source_arn,
                data_source_id: self.data_source_id,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeDataSourcePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSourcePermissionsOutput`](crate::output::DescribeDataSourcePermissionsOutput)
    pub fn builder() -> crate::output::describe_data_source_permissions_output::Builder {
        crate::output::describe_data_source_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSourceOutput {
    /// <p>The information on the data source.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeDataSourceOutput {
    /// <p>The information on the data source.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::DataSource> {
        self.data_source.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSourceOutput");
        formatter.field("data_source", &self.data_source);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeDataSourceOutput`](crate::output::DescribeDataSourceOutput)
pub mod describe_data_source_output {
    /// A builder for [`DescribeDataSourceOutput`](crate::output::DescribeDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The information on the data source.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The information on the data source.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSourceOutput`](crate::output::DescribeDataSourceOutput)
        pub fn build(self) -> crate::output::DescribeDataSourceOutput {
            crate::output::DescribeDataSourceOutput {
                data_source: self.data_source,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSourceOutput`](crate::output::DescribeDataSourceOutput)
    pub fn builder() -> crate::output::describe_data_source_output::Builder {
        crate::output::describe_data_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSetPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub data_set_arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>A list of resource permissions on the dataset.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeDataSetPermissionsOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn data_set_arn(&self) -> std::option::Option<&str> {
        self.data_set_arn.as_deref()
    }
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>A list of resource permissions on the dataset.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeDataSetPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSetPermissionsOutput");
        formatter.field("data_set_arn", &self.data_set_arn);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("permissions", &self.permissions);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeDataSetPermissionsOutput`](crate::output::DescribeDataSetPermissionsOutput)
pub mod describe_data_set_permissions_output {
    /// A builder for [`DescribeDataSetPermissionsOutput`](crate::output::DescribeDataSetPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_arn: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn data_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_data_set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_arn = input;
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSetPermissionsOutput`](crate::output::DescribeDataSetPermissionsOutput)
        pub fn build(self) -> crate::output::DescribeDataSetPermissionsOutput {
            crate::output::DescribeDataSetPermissionsOutput {
                data_set_arn: self.data_set_arn,
                data_set_id: self.data_set_id,
                permissions: self.permissions,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeDataSetPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSetPermissionsOutput`](crate::output::DescribeDataSetPermissionsOutput)
    pub fn builder() -> crate::output::describe_data_set_permissions_output::Builder {
        crate::output::describe_data_set_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSetOutput {
    /// <p>Information on the dataset.</p>
    pub data_set: std::option::Option<crate::model::DataSet>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeDataSetOutput {
    /// <p>Information on the dataset.</p>
    pub fn data_set(&self) -> std::option::Option<&crate::model::DataSet> {
        self.data_set.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSetOutput");
        formatter.field("data_set", &self.data_set);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeDataSetOutput`](crate::output::DescribeDataSetOutput)
pub mod describe_data_set_output {
    /// A builder for [`DescribeDataSetOutput`](crate::output::DescribeDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set: std::option::Option<crate::model::DataSet>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Information on the dataset.</p>
        pub fn data_set(mut self, input: crate::model::DataSet) -> Self {
            self.data_set = Some(input);
            self
        }
        /// <p>Information on the dataset.</p>
        pub fn set_data_set(mut self, input: std::option::Option<crate::model::DataSet>) -> Self {
            self.data_set = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSetOutput`](crate::output::DescribeDataSetOutput)
        pub fn build(self) -> crate::output::DescribeDataSetOutput {
            crate::output::DescribeDataSetOutput {
                data_set: self.data_set,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeDataSetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSetOutput`](crate::output::DescribeDataSetOutput)
    pub fn builder() -> crate::output::describe_data_set_output::Builder {
        crate::output::describe_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDashboardPermissionsOutput {
    /// <p>The ID for the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub dashboard_arn: std::option::Option<std::string::String>,
    /// <p>A structure that contains the permissions for the dashboard.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>A structure that contains the configuration of a shareable link that grants access to the dashboard. Your users can use the link to view and interact with the dashboard, if the dashboard has been shared with them. For more information about sharing dashboards, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.</p>
    pub link_sharing_configuration: std::option::Option<crate::model::LinkSharingConfiguration>,
}
impl DescribeDashboardPermissionsOutput {
    /// <p>The ID for the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub fn dashboard_arn(&self) -> std::option::Option<&str> {
        self.dashboard_arn.as_deref()
    }
    /// <p>A structure that contains the permissions for the dashboard.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>A structure that contains the configuration of a shareable link that grants access to the dashboard. Your users can use the link to view and interact with the dashboard, if the dashboard has been shared with them. For more information about sharing dashboards, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.</p>
    pub fn link_sharing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LinkSharingConfiguration> {
        self.link_sharing_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribeDashboardPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDashboardPermissionsOutput");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("dashboard_arn", &self.dashboard_arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "link_sharing_configuration",
            &self.link_sharing_configuration,
        );
        formatter.finish()
    }
}
/// See [`DescribeDashboardPermissionsOutput`](crate::output::DescribeDashboardPermissionsOutput)
pub mod describe_dashboard_permissions_output {
    /// A builder for [`DescribeDashboardPermissionsOutput`](crate::output::DescribeDashboardPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) dashboard_arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) link_sharing_configuration:
            std::option::Option<crate::model::LinkSharingConfiguration>,
    }
    impl Builder {
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn dashboard_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn set_dashboard_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that contains the permissions for the dashboard.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A structure that contains the permissions for the dashboard.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>A structure that contains the configuration of a shareable link that grants access to the dashboard. Your users can use the link to view and interact with the dashboard, if the dashboard has been shared with them. For more information about sharing dashboards, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.</p>
        pub fn link_sharing_configuration(
            mut self,
            input: crate::model::LinkSharingConfiguration,
        ) -> Self {
            self.link_sharing_configuration = Some(input);
            self
        }
        /// <p>A structure that contains the configuration of a shareable link that grants access to the dashboard. Your users can use the link to view and interact with the dashboard, if the dashboard has been shared with them. For more information about sharing dashboards, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.</p>
        pub fn set_link_sharing_configuration(
            mut self,
            input: std::option::Option<crate::model::LinkSharingConfiguration>,
        ) -> Self {
            self.link_sharing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDashboardPermissionsOutput`](crate::output::DescribeDashboardPermissionsOutput)
        pub fn build(self) -> crate::output::DescribeDashboardPermissionsOutput {
            crate::output::DescribeDashboardPermissionsOutput {
                dashboard_id: self.dashboard_id,
                dashboard_arn: self.dashboard_arn,
                permissions: self.permissions,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
                link_sharing_configuration: self.link_sharing_configuration,
            }
        }
    }
}
impl DescribeDashboardPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDashboardPermissionsOutput`](crate::output::DescribeDashboardPermissionsOutput)
    pub fn builder() -> crate::output::describe_dashboard_permissions_output::Builder {
        crate::output::describe_dashboard_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDashboardOutput {
    /// <p>Information about the dashboard.</p>
    pub dashboard: std::option::Option<crate::model::Dashboard>,
    /// <p>The HTTP status of this request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeDashboardOutput {
    /// <p>Information about the dashboard.</p>
    pub fn dashboard(&self) -> std::option::Option<&crate::model::Dashboard> {
        self.dashboard.as_ref()
    }
    /// <p>The HTTP status of this request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDashboardOutput");
        formatter.field("dashboard", &self.dashboard);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
pub mod describe_dashboard_output {
    /// A builder for [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard: std::option::Option<crate::model::Dashboard>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the dashboard.</p>
        pub fn dashboard(mut self, input: crate::model::Dashboard) -> Self {
            self.dashboard = Some(input);
            self
        }
        /// <p>Information about the dashboard.</p>
        pub fn set_dashboard(
            mut self,
            input: std::option::Option<crate::model::Dashboard>,
        ) -> Self {
            self.dashboard = input;
            self
        }
        /// <p>The HTTP status of this request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of this request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
        pub fn build(self) -> crate::output::DescribeDashboardOutput {
            crate::output::DescribeDashboardOutput {
                dashboard: self.dashboard,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeDashboardOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDashboardOutput`](crate::output::DescribeDashboardOutput)
    pub fn builder() -> crate::output::describe_dashboard_output::Builder {
        crate::output::describe_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnalysisPermissionsOutput {
    /// <p>The ID of the analysis whose permissions you're describing.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.</p>
    pub analysis_arn: std::option::Option<std::string::String>,
    /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeAnalysisPermissionsOutput {
    /// <p>The ID of the analysis whose permissions you're describing.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.</p>
    pub fn analysis_arn(&self) -> std::option::Option<&str> {
        self.analysis_arn.as_deref()
    }
    /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::ResourcePermission]> {
        self.permissions.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAnalysisPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnalysisPermissionsOutput");
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("analysis_arn", &self.analysis_arn);
        formatter.field("permissions", &self.permissions);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeAnalysisPermissionsOutput`](crate::output::DescribeAnalysisPermissionsOutput)
pub mod describe_analysis_permissions_output {
    /// A builder for [`DescribeAnalysisPermissionsOutput`](crate::output::DescribeAnalysisPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) analysis_arn: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the analysis whose permissions you're describing.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis whose permissions you're describing.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.</p>
        pub fn analysis_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.</p>
        pub fn set_analysis_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_arn = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
        pub fn permissions(mut self, input: crate::model::ResourcePermission) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input);
            self.permissions = Some(v);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions on an analysis.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnalysisPermissionsOutput`](crate::output::DescribeAnalysisPermissionsOutput)
        pub fn build(self) -> crate::output::DescribeAnalysisPermissionsOutput {
            crate::output::DescribeAnalysisPermissionsOutput {
                analysis_id: self.analysis_id,
                analysis_arn: self.analysis_arn,
                permissions: self.permissions,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeAnalysisPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAnalysisPermissionsOutput`](crate::output::DescribeAnalysisPermissionsOutput)
    pub fn builder() -> crate::output::describe_analysis_permissions_output::Builder {
        crate::output::describe_analysis_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnalysisOutput {
    /// <p>A metadata structure that contains summary information for the analysis that you're describing.</p>
    pub analysis: std::option::Option<crate::model::Analysis>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DescribeAnalysisOutput {
    /// <p>A metadata structure that contains summary information for the analysis that you're describing.</p>
    pub fn analysis(&self) -> std::option::Option<&crate::model::Analysis> {
        self.analysis.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnalysisOutput");
        formatter.field("analysis", &self.analysis);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DescribeAnalysisOutput`](crate::output::DescribeAnalysisOutput)
pub mod describe_analysis_output {
    /// A builder for [`DescribeAnalysisOutput`](crate::output::DescribeAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis: std::option::Option<crate::model::Analysis>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A metadata structure that contains summary information for the analysis that you're describing.</p>
        pub fn analysis(mut self, input: crate::model::Analysis) -> Self {
            self.analysis = Some(input);
            self
        }
        /// <p>A metadata structure that contains summary information for the analysis that you're describing.</p>
        pub fn set_analysis(mut self, input: std::option::Option<crate::model::Analysis>) -> Self {
            self.analysis = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnalysisOutput`](crate::output::DescribeAnalysisOutput)
        pub fn build(self) -> crate::output::DescribeAnalysisOutput {
            crate::output::DescribeAnalysisOutput {
                analysis: self.analysis,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DescribeAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAnalysisOutput`](crate::output::DescribeAnalysisOutput)
    pub fn builder() -> crate::output::describe_analysis_output::Builder {
        crate::output::describe_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountSettingsOutput {
    /// <p>The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the Amazon QuickSight subscription. In the QuickSight console, the Amazon QuickSight subscription is sometimes referred to as a QuickSight "account" even though it's technically not an account by itself. Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region where you use it.</p>
    pub account_settings: std::option::Option<crate::model::AccountSettings>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeAccountSettingsOutput {
    /// <p>The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the Amazon QuickSight subscription. In the QuickSight console, the Amazon QuickSight subscription is sometimes referred to as a QuickSight "account" even though it's technically not an account by itself. Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region where you use it.</p>
    pub fn account_settings(&self) -> std::option::Option<&crate::model::AccountSettings> {
        self.account_settings.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeAccountSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountSettingsOutput");
        formatter.field("account_settings", &self.account_settings);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeAccountSettingsOutput`](crate::output::DescribeAccountSettingsOutput)
pub mod describe_account_settings_output {
    /// A builder for [`DescribeAccountSettingsOutput`](crate::output::DescribeAccountSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_settings: std::option::Option<crate::model::AccountSettings>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the Amazon QuickSight subscription. In the QuickSight console, the Amazon QuickSight subscription is sometimes referred to as a QuickSight "account" even though it's technically not an account by itself. Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region where you use it.</p>
        pub fn account_settings(mut self, input: crate::model::AccountSettings) -> Self {
            self.account_settings = Some(input);
            self
        }
        /// <p>The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the Amazon QuickSight subscription. In the QuickSight console, the Amazon QuickSight subscription is sometimes referred to as a QuickSight "account" even though it's technically not an account by itself. Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region where you use it.</p>
        pub fn set_account_settings(
            mut self,
            input: std::option::Option<crate::model::AccountSettings>,
        ) -> Self {
            self.account_settings = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountSettingsOutput`](crate::output::DescribeAccountSettingsOutput)
        pub fn build(self) -> crate::output::DescribeAccountSettingsOutput {
            crate::output::DescribeAccountSettingsOutput {
                account_settings: self.account_settings,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeAccountSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountSettingsOutput`](crate::output::DescribeAccountSettingsOutput)
    pub fn builder() -> crate::output::describe_account_settings_output::Builder {
        crate::output::describe_account_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountCustomizationOutput {
    /// <p>The Amazon Resource Name (ARN) of the customization that's associated with this Amazon Web Services account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID for the Amazon Web Services account that you're describing.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight namespace that you're describing. </p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight customizations that exist in the current Amazon Web Services Region. </p>
    pub account_customization: std::option::Option<crate::model::AccountCustomization>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DescribeAccountCustomizationOutput {
    /// <p>The Amazon Resource Name (ARN) of the customization that's associated with this Amazon Web Services account.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID for the Amazon Web Services account that you're describing.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The Amazon QuickSight namespace that you're describing. </p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The Amazon QuickSight customizations that exist in the current Amazon Web Services Region. </p>
    pub fn account_customization(
        &self,
    ) -> std::option::Option<&crate::model::AccountCustomization> {
        self.account_customization.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DescribeAccountCustomizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountCustomizationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("namespace", &self.namespace);
        formatter.field("account_customization", &self.account_customization);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeAccountCustomizationOutput`](crate::output::DescribeAccountCustomizationOutput)
pub mod describe_account_customization_output {
    /// A builder for [`DescribeAccountCustomizationOutput`](crate::output::DescribeAccountCustomizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) account_customization: std::option::Option<crate::model::AccountCustomization>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the customization that's associated with this Amazon Web Services account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customization that's associated with this Amazon Web Services account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that you're describing.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Amazon QuickSight namespace that you're describing. </p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight namespace that you're describing. </p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon QuickSight customizations that exist in the current Amazon Web Services Region. </p>
        pub fn account_customization(mut self, input: crate::model::AccountCustomization) -> Self {
            self.account_customization = Some(input);
            self
        }
        /// <p>The Amazon QuickSight customizations that exist in the current Amazon Web Services Region. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.account_customization = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountCustomizationOutput`](crate::output::DescribeAccountCustomizationOutput)
        pub fn build(self) -> crate::output::DescribeAccountCustomizationOutput {
            crate::output::DescribeAccountCustomizationOutput {
                arn: self.arn,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                account_customization: self.account_customization,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DescribeAccountCustomizationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountCustomizationOutput`](crate::output::DescribeAccountCustomizationOutput)
    pub fn builder() -> crate::output::describe_account_customization_output::Builder {
        crate::output::describe_account_customization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserByPrincipalIdOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteUserByPrincipalIdOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteUserByPrincipalIdOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserByPrincipalIdOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteUserByPrincipalIdOutput`](crate::output::DeleteUserByPrincipalIdOutput)
pub mod delete_user_by_principal_id_output {
    /// A builder for [`DeleteUserByPrincipalIdOutput`](crate::output::DeleteUserByPrincipalIdOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserByPrincipalIdOutput`](crate::output::DeleteUserByPrincipalIdOutput)
        pub fn build(self) -> crate::output::DeleteUserByPrincipalIdOutput {
            crate::output::DeleteUserByPrincipalIdOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteUserByPrincipalIdOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserByPrincipalIdOutput`](crate::output::DeleteUserByPrincipalIdOutput)
    pub fn builder() -> crate::output::delete_user_by_principal_id_output::Builder {
        crate::output::delete_user_by_principal_id_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteUserOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThemeAliasOutput {
    /// <p>The name for the theme alias.</p>
    pub alias_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>An ID for the theme associated with the deletion.</p>
    pub theme_id: std::option::Option<std::string::String>,
}
impl DeleteThemeAliasOutput {
    /// <p>The name for the theme alias.</p>
    pub fn alias_name(&self) -> std::option::Option<&str> {
        self.alias_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>An ID for the theme associated with the deletion.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteThemeAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThemeAliasOutput");
        formatter.field("alias_name", &self.alias_name);
        formatter.field("arn", &self.arn);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.field("theme_id", &self.theme_id);
        formatter.finish()
    }
}
/// See [`DeleteThemeAliasOutput`](crate::output::DeleteThemeAliasOutput)
pub mod delete_theme_alias_output {
    /// A builder for [`DeleteThemeAliasOutput`](crate::output::DeleteThemeAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the theme alias.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The name for the theme alias.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>An ID for the theme associated with the deletion.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>An ID for the theme associated with the deletion.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThemeAliasOutput`](crate::output::DeleteThemeAliasOutput)
        pub fn build(self) -> crate::output::DeleteThemeAliasOutput {
            crate::output::DeleteThemeAliasOutput {
                alias_name: self.alias_name,
                arn: self.arn,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
                theme_id: self.theme_id,
            }
        }
    }
}
impl DeleteThemeAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteThemeAliasOutput`](crate::output::DeleteThemeAliasOutput)
    pub fn builder() -> crate::output::delete_theme_alias_output::Builder {
        crate::output::delete_theme_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThemeOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>An ID for the theme.</p>
    pub theme_id: std::option::Option<std::string::String>,
}
impl DeleteThemeOutput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>An ID for the theme.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThemeOutput");
        formatter.field("arn", &self.arn);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.field("theme_id", &self.theme_id);
        formatter.finish()
    }
}
/// See [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
pub mod delete_theme_output {
    /// A builder for [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>An ID for the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>An ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
        pub fn build(self) -> crate::output::DeleteThemeOutput {
            crate::output::DeleteThemeOutput {
                arn: self.arn,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
                theme_id: self.theme_id,
            }
        }
    }
}
impl DeleteThemeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteThemeOutput`](crate::output::DeleteThemeOutput)
    pub fn builder() -> crate::output::delete_theme_output::Builder {
        crate::output::delete_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTemplateAliasOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>An ID for the template associated with the deletion.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The name for the template alias.</p>
    pub alias_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the template you want to delete.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DeleteTemplateAliasOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>An ID for the template associated with the deletion.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The name for the template alias.</p>
    pub fn alias_name(&self) -> std::option::Option<&str> {
        self.alias_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the template you want to delete.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteTemplateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTemplateAliasOutput");
        formatter.field("status", &self.status);
        formatter.field("template_id", &self.template_id);
        formatter.field("alias_name", &self.alias_name);
        formatter.field("arn", &self.arn);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DeleteTemplateAliasOutput`](crate::output::DeleteTemplateAliasOutput)
pub mod delete_template_alias_output {
    /// A builder for [`DeleteTemplateAliasOutput`](crate::output::DeleteTemplateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>An ID for the template associated with the deletion.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>An ID for the template associated with the deletion.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The name for the template alias.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The name for the template alias.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template you want to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template you want to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTemplateAliasOutput`](crate::output::DeleteTemplateAliasOutput)
        pub fn build(self) -> crate::output::DeleteTemplateAliasOutput {
            crate::output::DeleteTemplateAliasOutput {
                status: self.status.unwrap_or_default(),
                template_id: self.template_id,
                alias_name: self.alias_name,
                arn: self.arn,
                request_id: self.request_id,
            }
        }
    }
}
impl DeleteTemplateAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTemplateAliasOutput`](crate::output::DeleteTemplateAliasOutput)
    pub fn builder() -> crate::output::delete_template_alias_output::Builder {
        crate::output::delete_template_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTemplateOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An ID for the template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteTemplateOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An ID for the template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTemplateOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("arn", &self.arn);
        formatter.field("template_id", &self.template_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
pub mod delete_template_output {
    /// A builder for [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An ID for the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>An ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
        pub fn build(self) -> crate::output::DeleteTemplateOutput {
            crate::output::DeleteTemplateOutput {
                request_id: self.request_id,
                arn: self.arn,
                template_id: self.template_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
    pub fn builder() -> crate::output::delete_template_output::Builder {
        crate::output::delete_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNamespaceOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteNamespaceOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNamespaceOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
pub mod delete_namespace_output {
    /// A builder for [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
        pub fn build(self) -> crate::output::DeleteNamespaceOutput {
            crate::output::DeleteNamespaceOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteNamespaceOutput`](crate::output::DeleteNamespaceOutput)
    pub fn builder() -> crate::output::delete_namespace_output::Builder {
        crate::output::delete_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIamPolicyAssignmentOutput {
    /// <p>The name of the assignment. </p>
    pub assignment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteIamPolicyAssignmentOutput {
    /// <p>The name of the assignment. </p>
    pub fn assignment_name(&self) -> std::option::Option<&str> {
        self.assignment_name.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteIamPolicyAssignmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIamPolicyAssignmentOutput");
        formatter.field("assignment_name", &self.assignment_name);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteIamPolicyAssignmentOutput`](crate::output::DeleteIamPolicyAssignmentOutput)
pub mod delete_iam_policy_assignment_output {
    /// A builder for [`DeleteIamPolicyAssignmentOutput`](crate::output::DeleteIamPolicyAssignmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the assignment. </p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>The name of the assignment. </p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIamPolicyAssignmentOutput`](crate::output::DeleteIamPolicyAssignmentOutput)
        pub fn build(self) -> crate::output::DeleteIamPolicyAssignmentOutput {
            crate::output::DeleteIamPolicyAssignmentOutput {
                assignment_name: self.assignment_name,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteIamPolicyAssignmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIamPolicyAssignmentOutput`](crate::output::DeleteIamPolicyAssignmentOutput)
    pub fn builder() -> crate::output::delete_iam_policy_assignment_output::Builder {
        crate::output::delete_iam_policy_assignment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupMembershipOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteGroupMembershipOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteGroupMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupMembershipOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteGroupMembershipOutput`](crate::output::DeleteGroupMembershipOutput)
pub mod delete_group_membership_output {
    /// A builder for [`DeleteGroupMembershipOutput`](crate::output::DeleteGroupMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupMembershipOutput`](crate::output::DeleteGroupMembershipOutput)
        pub fn build(self) -> crate::output::DeleteGroupMembershipOutput {
            crate::output::DeleteGroupMembershipOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteGroupMembershipOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGroupMembershipOutput`](crate::output::DeleteGroupMembershipOutput)
    pub fn builder() -> crate::output::delete_group_membership_output::Builder {
        crate::output::delete_group_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteGroupOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
pub mod delete_group_output {
    /// A builder for [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
        pub fn build(self) -> crate::output::DeleteGroupOutput {
            crate::output::DeleteGroupOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    pub fn builder() -> crate::output::delete_group_output::Builder {
        crate::output::delete_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderMembershipOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DeleteFolderMembershipOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFolderMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderMembershipOutput");
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DeleteFolderMembershipOutput`](crate::output::DeleteFolderMembershipOutput)
pub mod delete_folder_membership_output {
    /// A builder for [`DeleteFolderMembershipOutput`](crate::output::DeleteFolderMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderMembershipOutput`](crate::output::DeleteFolderMembershipOutput)
        pub fn build(self) -> crate::output::DeleteFolderMembershipOutput {
            crate::output::DeleteFolderMembershipOutput {
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl DeleteFolderMembershipOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFolderMembershipOutput`](crate::output::DeleteFolderMembershipOutput)
    pub fn builder() -> crate::output::delete_folder_membership_output::Builder {
        crate::output::delete_folder_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Resource Name of the deleted folder.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DeleteFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Resource Name of the deleted folder.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFolderOutput");
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("folder_id", &self.folder_id);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
pub mod delete_folder_output {
    /// A builder for [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name of the deleted folder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the deleted folder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The ID of the folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
        pub fn build(self) -> crate::output::DeleteFolderOutput {
            crate::output::DeleteFolderOutput {
                status: self.status.unwrap_or_default(),
                arn: self.arn,
                folder_id: self.folder_id,
                request_id: self.request_id,
            }
        }
    }
}
impl DeleteFolderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFolderOutput`](crate::output::DeleteFolderOutput)
    pub fn builder() -> crate::output::delete_folder_output::Builder {
        crate::output::delete_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteDataSourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSourceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
pub mod delete_data_source_output {
    /// A builder for [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
        pub fn build(self) -> crate::output::DeleteDataSourceOutput {
            crate::output::DeleteDataSourceOutput {
                arn: self.arn,
                data_source_id: self.data_source_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
    pub fn builder() -> crate::output::delete_data_source_output::Builder {
        crate::output::delete_data_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteDataSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
pub mod delete_data_set_output {
    /// A builder for [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
        pub fn build(self) -> crate::output::DeleteDataSetOutput {
            crate::output::DeleteDataSetOutput {
                arn: self.arn,
                data_set_id: self.data_set_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteDataSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDataSetOutput`](crate::output::DeleteDataSetOutput)
    pub fn builder() -> crate::output::delete_data_set_output::Builder {
        crate::output::delete_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDashboardOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DeleteDashboardOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDashboardOutput");
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
pub mod delete_dashboard_output {
    /// A builder for [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID of the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
        pub fn build(self) -> crate::output::DeleteDashboardOutput {
            crate::output::DeleteDashboardOutput {
                status: self.status.unwrap_or_default(),
                arn: self.arn,
                dashboard_id: self.dashboard_id,
                request_id: self.request_id,
            }
        }
    }
}
impl DeleteDashboardOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDashboardOutput`](crate::output::DeleteDashboardOutput)
    pub fn builder() -> crate::output::delete_dashboard_output::Builder {
        crate::output::delete_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnalysisOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Resource Name (ARN) of the deleted analysis.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the deleted analysis.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the analysis is scheduled to be deleted.</p>
    pub deletion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl DeleteAnalysisOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Resource Name (ARN) of the deleted analysis.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the deleted analysis.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The date and time that the analysis is scheduled to be deleted.</p>
    pub fn deletion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deletion_time.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnalysisOutput");
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("deletion_time", &self.deletion_time);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`DeleteAnalysisOutput`](crate::output::DeleteAnalysisOutput)
pub mod delete_analysis_output {
    /// A builder for [`DeleteAnalysisOutput`](crate::output::DeleteAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) deletion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted analysis.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted analysis.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the deleted analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the deleted analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The date and time that the analysis is scheduled to be deleted.</p>
        pub fn deletion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deletion_time = Some(input);
            self
        }
        /// <p>The date and time that the analysis is scheduled to be deleted.</p>
        pub fn set_deletion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deletion_time = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAnalysisOutput`](crate::output::DeleteAnalysisOutput)
        pub fn build(self) -> crate::output::DeleteAnalysisOutput {
            crate::output::DeleteAnalysisOutput {
                status: self.status.unwrap_or_default(),
                arn: self.arn,
                analysis_id: self.analysis_id,
                deletion_time: self.deletion_time,
                request_id: self.request_id,
            }
        }
    }
}
impl DeleteAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAnalysisOutput`](crate::output::DeleteAnalysisOutput)
    pub fn builder() -> crate::output::delete_analysis_output::Builder {
        crate::output::delete_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccountCustomizationOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl DeleteAccountCustomizationOutput {
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for DeleteAccountCustomizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccountCustomizationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteAccountCustomizationOutput`](crate::output::DeleteAccountCustomizationOutput)
pub mod delete_account_customization_output {
    /// A builder for [`DeleteAccountCustomizationOutput`](crate::output::DeleteAccountCustomizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountCustomizationOutput`](crate::output::DeleteAccountCustomizationOutput)
        pub fn build(self) -> crate::output::DeleteAccountCustomizationOutput {
            crate::output::DeleteAccountCustomizationOutput {
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl DeleteAccountCustomizationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccountCustomizationOutput`](crate::output::DeleteAccountCustomizationOutput)
    pub fn builder() -> crate::output::delete_account_customization_output::Builder {
        crate::output::delete_account_customization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThemeAliasOutput {
    /// <p>Information about the theme alias.</p>
    pub theme_alias: std::option::Option<crate::model::ThemeAlias>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateThemeAliasOutput {
    /// <p>Information about the theme alias.</p>
    pub fn theme_alias(&self) -> std::option::Option<&crate::model::ThemeAlias> {
        self.theme_alias.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateThemeAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThemeAliasOutput");
        formatter.field("theme_alias", &self.theme_alias);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateThemeAliasOutput`](crate::output::CreateThemeAliasOutput)
pub mod create_theme_alias_output {
    /// A builder for [`CreateThemeAliasOutput`](crate::output::CreateThemeAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) theme_alias: std::option::Option<crate::model::ThemeAlias>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the theme alias.</p>
        pub fn theme_alias(mut self, input: crate::model::ThemeAlias) -> Self {
            self.theme_alias = Some(input);
            self
        }
        /// <p>Information about the theme alias.</p>
        pub fn set_theme_alias(
            mut self,
            input: std::option::Option<crate::model::ThemeAlias>,
        ) -> Self {
            self.theme_alias = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThemeAliasOutput`](crate::output::CreateThemeAliasOutput)
        pub fn build(self) -> crate::output::CreateThemeAliasOutput {
            crate::output::CreateThemeAliasOutput {
                theme_alias: self.theme_alias,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl CreateThemeAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateThemeAliasOutput`](crate::output::CreateThemeAliasOutput)
    pub fn builder() -> crate::output::create_theme_alias_output::Builder {
        crate::output::create_theme_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThemeOutput {
    /// <p>The Amazon Resource Name (ARN) for the theme.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the new theme.</p>
    pub version_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the theme.</p>
    pub theme_id: std::option::Option<std::string::String>,
    /// <p>The theme creation status.</p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateThemeOutput {
    /// <p>The Amazon Resource Name (ARN) for the theme.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the new theme.</p>
    pub fn version_arn(&self) -> std::option::Option<&str> {
        self.version_arn.as_deref()
    }
    /// <p>The ID of the theme.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
    /// <p>The theme creation status.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateThemeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThemeOutput");
        formatter.field("arn", &self.arn);
        formatter.field("version_arn", &self.version_arn);
        formatter.field("theme_id", &self.theme_id);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateThemeOutput`](crate::output::CreateThemeOutput)
pub mod create_theme_output {
    /// A builder for [`CreateThemeOutput`](crate::output::CreateThemeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_arn: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the theme.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the new theme.</p>
        pub fn version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the new theme.</p>
        pub fn set_version_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_arn = input;
            self
        }
        /// <p>The ID of the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID of the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The theme creation status.</p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The theme creation status.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThemeOutput`](crate::output::CreateThemeOutput)
        pub fn build(self) -> crate::output::CreateThemeOutput {
            crate::output::CreateThemeOutput {
                arn: self.arn,
                version_arn: self.version_arn,
                theme_id: self.theme_id,
                creation_status: self.creation_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl CreateThemeOutput {
    /// Creates a new builder-style object to manufacture [`CreateThemeOutput`](crate::output::CreateThemeOutput)
    pub fn builder() -> crate::output::create_theme_output::Builder {
        crate::output::create_theme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTemplateAliasOutput {
    /// <p>Information about the template alias.</p>
    pub template_alias: std::option::Option<crate::model::TemplateAlias>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateTemplateAliasOutput {
    /// <p>Information about the template alias.</p>
    pub fn template_alias(&self) -> std::option::Option<&crate::model::TemplateAlias> {
        self.template_alias.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateTemplateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTemplateAliasOutput");
        formatter.field("template_alias", &self.template_alias);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateTemplateAliasOutput`](crate::output::CreateTemplateAliasOutput)
pub mod create_template_alias_output {
    /// A builder for [`CreateTemplateAliasOutput`](crate::output::CreateTemplateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_alias: std::option::Option<crate::model::TemplateAlias>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the template alias.</p>
        pub fn template_alias(mut self, input: crate::model::TemplateAlias) -> Self {
            self.template_alias = Some(input);
            self
        }
        /// <p>Information about the template alias.</p>
        pub fn set_template_alias(
            mut self,
            input: std::option::Option<crate::model::TemplateAlias>,
        ) -> Self {
            self.template_alias = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTemplateAliasOutput`](crate::output::CreateTemplateAliasOutput)
        pub fn build(self) -> crate::output::CreateTemplateAliasOutput {
            crate::output::CreateTemplateAliasOutput {
                template_alias: self.template_alias,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl CreateTemplateAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateTemplateAliasOutput`](crate::output::CreateTemplateAliasOutput)
    pub fn builder() -> crate::output::create_template_alias_output::Builder {
        crate::output::create_template_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTemplateOutput {
    /// <p>The ARN for the template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN for the template, including the version information of the first version.</p>
    pub version_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The template creation status.</p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateTemplateOutput {
    /// <p>The ARN for the template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN for the template, including the version information of the first version.</p>
    pub fn version_arn(&self) -> std::option::Option<&str> {
        self.version_arn.as_deref()
    }
    /// <p>The ID of the template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The template creation status.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTemplateOutput");
        formatter.field("arn", &self.arn);
        formatter.field("version_arn", &self.version_arn);
        formatter.field("template_id", &self.template_id);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
pub mod create_template_output {
    /// A builder for [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_arn: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN for the template, including the version information of the first version.</p>
        pub fn version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the template, including the version information of the first version.</p>
        pub fn set_version_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_arn = input;
            self
        }
        /// <p>The ID of the template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID of the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The template creation status.</p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The template creation status.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
        pub fn build(self) -> crate::output::CreateTemplateOutput {
            crate::output::CreateTemplateOutput {
                arn: self.arn,
                version_arn: self.version_arn,
                template_id: self.template_id,
                creation_status: self.creation_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl CreateTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
    pub fn builder() -> crate::output::create_template_output::Builder {
        crate::output::create_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNamespaceOutput {
    /// <p>The ARN of the Amazon QuickSight namespace you created. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the new namespace that you created.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>
    pub capacity_region: std::option::Option<std::string::String>,
    /// <p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up tasks.</p>
    pub creation_status: std::option::Option<crate::model::NamespaceStatus>,
    /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
    pub identity_store: std::option::Option<crate::model::IdentityStore>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateNamespaceOutput {
    /// <p>The ARN of the Amazon QuickSight namespace you created. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the new namespace that you created.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>
    pub fn capacity_region(&self) -> std::option::Option<&str> {
        self.capacity_region.as_deref()
    }
    /// <p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up tasks.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::NamespaceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
    pub fn identity_store(&self) -> std::option::Option<&crate::model::IdentityStore> {
        self.identity_store.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateNamespaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNamespaceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("capacity_region", &self.capacity_region);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("identity_store", &self.identity_store);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateNamespaceOutput`](crate::output::CreateNamespaceOutput)
pub mod create_namespace_output {
    /// A builder for [`CreateNamespaceOutput`](crate::output::CreateNamespaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) capacity_region: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::NamespaceStatus>,
        pub(crate) identity_store: std::option::Option<crate::model::IdentityStore>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the Amazon QuickSight namespace you created. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon QuickSight namespace you created. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the new namespace that you created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new namespace that you created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>
        pub fn capacity_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region; that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>
        pub fn set_capacity_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_region = input;
            self
        }
        /// <p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up tasks.</p>
        pub fn creation_status(mut self, input: crate::model::NamespaceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up tasks.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::NamespaceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn identity_store(mut self, input: crate::model::IdentityStore) -> Self {
            self.identity_store = Some(input);
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn set_identity_store(
            mut self,
            input: std::option::Option<crate::model::IdentityStore>,
        ) -> Self {
            self.identity_store = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNamespaceOutput`](crate::output::CreateNamespaceOutput)
        pub fn build(self) -> crate::output::CreateNamespaceOutput {
            crate::output::CreateNamespaceOutput {
                arn: self.arn,
                name: self.name,
                capacity_region: self.capacity_region,
                creation_status: self.creation_status,
                identity_store: self.identity_store,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateNamespaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateNamespaceOutput`](crate::output::CreateNamespaceOutput)
    pub fn builder() -> crate::output::create_namespace_output::Builder {
        crate::output::create_namespace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIngestionOutput {
    /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An ID for the ingestion.</p>
    pub ingestion_id: std::option::Option<std::string::String>,
    /// <p>The ingestion status.</p>
    pub ingestion_status: std::option::Option<crate::model::IngestionStatus>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateIngestionOutput {
    /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An ID for the ingestion.</p>
    pub fn ingestion_id(&self) -> std::option::Option<&str> {
        self.ingestion_id.as_deref()
    }
    /// <p>The ingestion status.</p>
    pub fn ingestion_status(&self) -> std::option::Option<&crate::model::IngestionStatus> {
        self.ingestion_status.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateIngestionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIngestionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("ingestion_id", &self.ingestion_id);
        formatter.field("ingestion_status", &self.ingestion_status);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateIngestionOutput`](crate::output::CreateIngestionOutput)
pub mod create_ingestion_output {
    /// A builder for [`CreateIngestionOutput`](crate::output::CreateIngestionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_status: std::option::Option<crate::model::IngestionStatus>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// <p>The ingestion status.</p>
        pub fn ingestion_status(mut self, input: crate::model::IngestionStatus) -> Self {
            self.ingestion_status = Some(input);
            self
        }
        /// <p>The ingestion status.</p>
        pub fn set_ingestion_status(
            mut self,
            input: std::option::Option<crate::model::IngestionStatus>,
        ) -> Self {
            self.ingestion_status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIngestionOutput`](crate::output::CreateIngestionOutput)
        pub fn build(self) -> crate::output::CreateIngestionOutput {
            crate::output::CreateIngestionOutput {
                arn: self.arn,
                ingestion_id: self.ingestion_id,
                ingestion_status: self.ingestion_status,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateIngestionOutput {
    /// Creates a new builder-style object to manufacture [`CreateIngestionOutput`](crate::output::CreateIngestionOutput)
    pub fn builder() -> crate::output::create_ingestion_output::Builder {
        crate::output::create_ingestion_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIamPolicyAssignmentOutput {
    /// <p>The name of the assignment. This name must be unique within the Amazon Web Services account.</p>
    pub assignment_name: std::option::Option<std::string::String>,
    /// <p>The ID for the assignment.</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>The status of the assignment. Possible values are as follows:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
    /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
    /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
    /// </ul>
    pub assignment_status: std::option::Option<crate::model::AssignmentStatus>,
    /// <p>The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this assignment.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
    pub identities: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateIamPolicyAssignmentOutput {
    /// <p>The name of the assignment. This name must be unique within the Amazon Web Services account.</p>
    pub fn assignment_name(&self) -> std::option::Option<&str> {
        self.assignment_name.as_deref()
    }
    /// <p>The ID for the assignment.</p>
    pub fn assignment_id(&self) -> std::option::Option<&str> {
        self.assignment_id.as_deref()
    }
    /// <p>The status of the assignment. Possible values are as follows:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
    /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
    /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
    /// </ul>
    pub fn assignment_status(&self) -> std::option::Option<&crate::model::AssignmentStatus> {
        self.assignment_status.as_ref()
    }
    /// <p>The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this assignment.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
    pub fn identities(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.identities.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateIamPolicyAssignmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIamPolicyAssignmentOutput");
        formatter.field("assignment_name", &self.assignment_name);
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("assignment_status", &self.assignment_status);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("identities", &self.identities);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateIamPolicyAssignmentOutput`](crate::output::CreateIamPolicyAssignmentOutput)
pub mod create_iam_policy_assignment_output {
    /// A builder for [`CreateIamPolicyAssignmentOutput`](crate::output::CreateIamPolicyAssignmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatus>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) identities: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the assignment. This name must be unique within the Amazon Web Services account.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>The name of the assignment. This name must be unique within the Amazon Web Services account.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The ID for the assignment.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>The ID for the assignment.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li>
        /// <li> <p> <code>DISABLED</code> - This assignment isn't used when creating the data source.</p> </li>
        /// <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.</p> </li>
        /// </ul>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// <p>The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM policy that is applied to the Amazon QuickSight users and groups specified in this assignment.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Adds a key-value pair to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.identities.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.identities = Some(hash_map);
            self
        }
        /// <p>The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.identities = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIamPolicyAssignmentOutput`](crate::output::CreateIamPolicyAssignmentOutput)
        pub fn build(self) -> crate::output::CreateIamPolicyAssignmentOutput {
            crate::output::CreateIamPolicyAssignmentOutput {
                assignment_name: self.assignment_name,
                assignment_id: self.assignment_id,
                assignment_status: self.assignment_status,
                policy_arn: self.policy_arn,
                identities: self.identities,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateIamPolicyAssignmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateIamPolicyAssignmentOutput`](crate::output::CreateIamPolicyAssignmentOutput)
    pub fn builder() -> crate::output::create_iam_policy_assignment_output::Builder {
        crate::output::create_iam_policy_assignment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupMembershipOutput {
    /// <p>The group member.</p>
    pub group_member: std::option::Option<crate::model::GroupMember>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateGroupMembershipOutput {
    /// <p>The group member.</p>
    pub fn group_member(&self) -> std::option::Option<&crate::model::GroupMember> {
        self.group_member.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateGroupMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupMembershipOutput");
        formatter.field("group_member", &self.group_member);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateGroupMembershipOutput`](crate::output::CreateGroupMembershipOutput)
pub mod create_group_membership_output {
    /// A builder for [`CreateGroupMembershipOutput`](crate::output::CreateGroupMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_member: std::option::Option<crate::model::GroupMember>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The group member.</p>
        pub fn group_member(mut self, input: crate::model::GroupMember) -> Self {
            self.group_member = Some(input);
            self
        }
        /// <p>The group member.</p>
        pub fn set_group_member(
            mut self,
            input: std::option::Option<crate::model::GroupMember>,
        ) -> Self {
            self.group_member = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupMembershipOutput`](crate::output::CreateGroupMembershipOutput)
        pub fn build(self) -> crate::output::CreateGroupMembershipOutput {
            crate::output::CreateGroupMembershipOutput {
                group_member: self.group_member,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateGroupMembershipOutput {
    /// Creates a new builder-style object to manufacture [`CreateGroupMembershipOutput`](crate::output::CreateGroupMembershipOutput)
    pub fn builder() -> crate::output::create_group_membership_output::Builder {
        crate::output::create_group_membership_output::Builder::default()
    }
}

/// <p>The response object for this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupOutput {
    /// <p>The name of the group.</p>
    pub group: std::option::Option<crate::model::Group>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateGroupOutput {
    /// <p>The name of the group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::Group> {
        self.group.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupOutput");
        formatter.field("group", &self.group);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateGroupOutput`](crate::output::CreateGroupOutput)
pub mod create_group_output {
    /// A builder for [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupOutput`](crate::output::CreateGroupOutput)
        pub fn build(self) -> crate::output::CreateGroupOutput {
            crate::output::CreateGroupOutput {
                group: self.group,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    pub fn builder() -> crate::output::create_group_output::Builder {
        crate::output::create_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFolderMembershipOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>Information about the member in the folder.</p>
    pub folder_member: std::option::Option<crate::model::FolderMember>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateFolderMembershipOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>Information about the member in the folder.</p>
    pub fn folder_member(&self) -> std::option::Option<&crate::model::FolderMember> {
        self.folder_member.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateFolderMembershipOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFolderMembershipOutput");
        formatter.field("status", &self.status);
        formatter.field("folder_member", &self.folder_member);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateFolderMembershipOutput`](crate::output::CreateFolderMembershipOutput)
pub mod create_folder_membership_output {
    /// A builder for [`CreateFolderMembershipOutput`](crate::output::CreateFolderMembershipOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) folder_member: std::option::Option<crate::model::FolderMember>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about the member in the folder.</p>
        pub fn folder_member(mut self, input: crate::model::FolderMember) -> Self {
            self.folder_member = Some(input);
            self
        }
        /// <p>Information about the member in the folder.</p>
        pub fn set_folder_member(
            mut self,
            input: std::option::Option<crate::model::FolderMember>,
        ) -> Self {
            self.folder_member = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFolderMembershipOutput`](crate::output::CreateFolderMembershipOutput)
        pub fn build(self) -> crate::output::CreateFolderMembershipOutput {
            crate::output::CreateFolderMembershipOutput {
                status: self.status.unwrap_or_default(),
                folder_member: self.folder_member,
                request_id: self.request_id,
            }
        }
    }
}
impl CreateFolderMembershipOutput {
    /// Creates a new builder-style object to manufacture [`CreateFolderMembershipOutput`](crate::output::CreateFolderMembershipOutput)
    pub fn builder() -> crate::output::create_folder_membership_output::Builder {
        crate::output::create_folder_membership_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Resource Name (ARN) for the newly created folder.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The folder ID for the newly created folder.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The request ID for the newly created folder.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateFolderOutput {
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Resource Name (ARN) for the newly created folder.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The folder ID for the newly created folder.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The request ID for the newly created folder.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFolderOutput");
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("folder_id", &self.folder_id);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateFolderOutput`](crate::output::CreateFolderOutput)
pub mod create_folder_output {
    /// A builder for [`CreateFolderOutput`](crate::output::CreateFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the newly created folder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the newly created folder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The folder ID for the newly created folder.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The folder ID for the newly created folder.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The request ID for the newly created folder.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID for the newly created folder.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFolderOutput`](crate::output::CreateFolderOutput)
        pub fn build(self) -> crate::output::CreateFolderOutput {
            crate::output::CreateFolderOutput {
                status: self.status.unwrap_or_default(),
                arn: self.arn,
                folder_id: self.folder_id,
                request_id: self.request_id,
            }
        }
    }
}
impl CreateFolderOutput {
    /// Creates a new builder-style object to manufacture [`CreateFolderOutput`](crate::output::CreateFolderOutput)
    pub fn builder() -> crate::output::create_folder_output::Builder {
        crate::output::create_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The status of creating the data source.</p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateDataSourceOutput {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The status of creating the data source.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateDataSourceOutput`](crate::output::CreateDataSourceOutput)
pub mod create_data_source_output {
    /// A builder for [`CreateDataSourceOutput`](crate::output::CreateDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The status of creating the data source.</p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The status of creating the data source.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceOutput`](crate::output::CreateDataSourceOutput)
        pub fn build(self) -> crate::output::CreateDataSourceOutput {
            crate::output::CreateDataSourceOutput {
                arn: self.arn,
                data_source_id: self.data_source_id,
                creation_status: self.creation_status,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataSourceOutput`](crate::output::CreateDataSourceOutput)
    pub fn builder() -> crate::output::create_data_source_output::Builder {
        crate::output::create_data_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub ingestion_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub ingestion_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateDataSetOutput {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub fn ingestion_arn(&self) -> std::option::Option<&str> {
        self.ingestion_arn.as_deref()
    }
    /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
    pub fn ingestion_id(&self) -> std::option::Option<&str> {
        self.ingestion_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateDataSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("ingestion_arn", &self.ingestion_arn);
        formatter.field("ingestion_id", &self.ingestion_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
pub mod create_data_set_output {
    /// A builder for [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_arn: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn ingestion_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn set_ingestion_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ingestion_arn = input;
            self
        }
        /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
        pub fn build(self) -> crate::output::CreateDataSetOutput {
            crate::output::CreateDataSetOutput {
                arn: self.arn,
                data_set_id: self.data_set_id,
                ingestion_arn: self.ingestion_arn,
                ingestion_id: self.ingestion_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateDataSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataSetOutput`](crate::output::CreateDataSetOutput)
    pub fn builder() -> crate::output::create_data_set_output::Builder {
        crate::output::create_data_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDashboardOutput {
    /// <p>The ARN of the dashboard.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the dashboard, including the version number of the first version that is created.</p>
    pub version_arn: std::option::Option<std::string::String>,
    /// <p>The ID for the dashboard.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The status of the dashboard creation request.</p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateDashboardOutput {
    /// <p>The ARN of the dashboard.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN of the dashboard, including the version number of the first version that is created.</p>
    pub fn version_arn(&self) -> std::option::Option<&str> {
        self.version_arn.as_deref()
    }
    /// <p>The ID for the dashboard.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The status of the dashboard creation request.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateDashboardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDashboardOutput");
        formatter.field("arn", &self.arn);
        formatter.field("version_arn", &self.version_arn);
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
pub mod create_dashboard_output {
    /// A builder for [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_arn: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the dashboard.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dashboard.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN of the dashboard, including the version number of the first version that is created.</p>
        pub fn version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dashboard, including the version number of the first version that is created.</p>
        pub fn set_version_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_arn = input;
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The status of the dashboard creation request.</p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The status of the dashboard creation request.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
        pub fn build(self) -> crate::output::CreateDashboardOutput {
            crate::output::CreateDashboardOutput {
                arn: self.arn,
                version_arn: self.version_arn,
                dashboard_id: self.dashboard_id,
                creation_status: self.creation_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl CreateDashboardOutput {
    /// Creates a new builder-style object to manufacture [`CreateDashboardOutput`](crate::output::CreateDashboardOutput)
    pub fn builder() -> crate::output::create_dashboard_output::Builder {
        crate::output::create_dashboard_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnalysisOutput {
    /// <p>The ARN for the analysis.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the analysis.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The status of the creation of the analysis. </p>
    pub creation_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl CreateAnalysisOutput {
    /// <p>The ARN for the analysis.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the analysis.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The status of the creation of the analysis. </p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for CreateAnalysisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnalysisOutput");
        formatter.field("arn", &self.arn);
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("status", &self.status);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`CreateAnalysisOutput`](crate::output::CreateAnalysisOutput)
pub mod create_analysis_output {
    /// A builder for [`CreateAnalysisOutput`](crate::output::CreateAnalysisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) status: std::option::Option<i32>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the analysis.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the analysis.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The status of the creation of the analysis. </p>
        pub fn creation_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The status of the creation of the analysis. </p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnalysisOutput`](crate::output::CreateAnalysisOutput)
        pub fn build(self) -> crate::output::CreateAnalysisOutput {
            crate::output::CreateAnalysisOutput {
                arn: self.arn,
                analysis_id: self.analysis_id,
                creation_status: self.creation_status,
                status: self.status.unwrap_or_default(),
                request_id: self.request_id,
            }
        }
    }
}
impl CreateAnalysisOutput {
    /// Creates a new builder-style object to manufacture [`CreateAnalysisOutput`](crate::output::CreateAnalysisOutput)
    pub fn builder() -> crate::output::create_analysis_output::Builder {
        crate::output::create_analysis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccountCustomizationOutput {
    /// <p>The Amazon Resource Name (ARN) for the customization that you created for this Amazon Web Services account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The namespace associated with the customization you're creating. </p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. </p>
    pub account_customization: std::option::Option<crate::model::AccountCustomization>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CreateAccountCustomizationOutput {
    /// <p>The Amazon Resource Name (ARN) for the customization that you created for this Amazon Web Services account.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The namespace associated with the customization you're creating. </p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. </p>
    pub fn account_customization(
        &self,
    ) -> std::option::Option<&crate::model::AccountCustomization> {
        self.account_customization.as_ref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CreateAccountCustomizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccountCustomizationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("namespace", &self.namespace);
        formatter.field("account_customization", &self.account_customization);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateAccountCustomizationOutput`](crate::output::CreateAccountCustomizationOutput)
pub mod create_account_customization_output {
    /// A builder for [`CreateAccountCustomizationOutput`](crate::output::CreateAccountCustomizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) account_customization: std::option::Option<crate::model::AccountCustomization>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the customization that you created for this Amazon Web Services account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the customization that you created for this Amazon Web Services account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The namespace associated with the customization you're creating. </p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace associated with the customization you're creating. </p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. </p>
        pub fn account_customization(mut self, input: crate::model::AccountCustomization) -> Self {
            self.account_customization = Some(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.account_customization = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountCustomizationOutput`](crate::output::CreateAccountCustomizationOutput)
        pub fn build(self) -> crate::output::CreateAccountCustomizationOutput {
            crate::output::CreateAccountCustomizationOutput {
                arn: self.arn,
                aws_account_id: self.aws_account_id,
                namespace: self.namespace,
                account_customization: self.account_customization,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CreateAccountCustomizationOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccountCustomizationOutput`](crate::output::CreateAccountCustomizationOutput)
    pub fn builder() -> crate::output::create_account_customization_output::Builder {
        crate::output::create_account_customization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelIngestionOutput {
    /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An ID for the ingestion.</p>
    pub ingestion_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The HTTP status of the request.</p>
    pub status: i32,
}
impl CancelIngestionOutput {
    /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An ID for the ingestion.</p>
    pub fn ingestion_id(&self) -> std::option::Option<&str> {
        self.ingestion_id.as_deref()
    }
    /// <p>The Amazon Web Services request ID for this operation.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for CancelIngestionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelIngestionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("ingestion_id", &self.ingestion_id);
        formatter.field("request_id", &self.request_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CancelIngestionOutput`](crate::output::CancelIngestionOutput)
pub mod cancel_ingestion_output {
    /// A builder for [`CancelIngestionOutput`](crate::output::CancelIngestionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the data ingestion.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services request ID for this operation.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelIngestionOutput`](crate::output::CancelIngestionOutput)
        pub fn build(self) -> crate::output::CancelIngestionOutput {
            crate::output::CancelIngestionOutput {
                arn: self.arn,
                ingestion_id: self.ingestion_id,
                request_id: self.request_id,
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl CancelIngestionOutput {
    /// Creates a new builder-style object to manufacture [`CancelIngestionOutput`](crate::output::CancelIngestionOutput)
    pub fn builder() -> crate::output::cancel_ingestion_output::Builder {
        crate::output::cancel_ingestion_output::Builder::default()
    }
}
