// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExceptionResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AccountSettings,
    #[allow(missing_docs)] // documentation missing in model
    DataSet,
    #[allow(missing_docs)] // documentation missing in model
    DataSource,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    IampolicyAssignment,
    #[allow(missing_docs)] // documentation missing in model
    Ingestion,
    #[allow(missing_docs)] // documentation missing in model
    Namespace,
    #[allow(missing_docs)] // documentation missing in model
    User,
    #[allow(missing_docs)] // documentation missing in model
    VpcConnection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExceptionResourceType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_SETTINGS" => ExceptionResourceType::AccountSettings,
            "DATA_SET" => ExceptionResourceType::DataSet,
            "DATA_SOURCE" => ExceptionResourceType::DataSource,
            "GROUP" => ExceptionResourceType::Group,
            "IAMPOLICY_ASSIGNMENT" => ExceptionResourceType::IampolicyAssignment,
            "INGESTION" => ExceptionResourceType::Ingestion,
            "NAMESPACE" => ExceptionResourceType::Namespace,
            "USER" => ExceptionResourceType::User,
            "VPC_CONNECTION" => ExceptionResourceType::VpcConnection,
            other => ExceptionResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExceptionResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExceptionResourceType::from(s))
    }
}
impl ExceptionResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExceptionResourceType::AccountSettings => "ACCOUNT_SETTINGS",
            ExceptionResourceType::DataSet => "DATA_SET",
            ExceptionResourceType::DataSource => "DATA_SOURCE",
            ExceptionResourceType::Group => "GROUP",
            ExceptionResourceType::IampolicyAssignment => "IAMPOLICY_ASSIGNMENT",
            ExceptionResourceType::Ingestion => "INGESTION",
            ExceptionResourceType::Namespace => "NAMESPACE",
            ExceptionResourceType::User => "USER",
            ExceptionResourceType::VpcConnection => "VPC_CONNECTION",
            ExceptionResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_SETTINGS",
            "DATA_SET",
            "DATA_SOURCE",
            "GROUP",
            "IAMPOLICY_ASSIGNMENT",
            "INGESTION",
            "NAMESPACE",
            "USER",
            "VPC_CONNECTION",
        ]
    }
}
impl AsRef<str> for ExceptionResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A registered user of Amazon QuickSight. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The Amazon Resource Name (ARN) for the user.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The user's user name.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The user's email address.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight role for the user. The user role can be one of the
    /// following:.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>READER</code>: A user who has read-only access to dashboards.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses,
    /// and dashboards.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon
    /// Amazon QuickSight settings.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESTRICTED_READER</code>: This role isn't currently available for
    /// use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for
    /// use.</p>
    /// </li>
    /// </ul>
    pub role: std::option::Option<crate::model::UserRole>,
    /// <p>The type of identity authentication used by the user.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The active status of user. When you create an Amazon QuickSight user that’s not an IAM
    /// user or an Active Directory user, that user is inactive until they sign in and provide a
    /// password.</p>
    pub active: bool,
    /// <p>The principal ID of the user.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The custom permissions profile associated with this user.</p>
    pub custom_permissions_name: std::option::Option<std::string::String>,
    /// <p>The type of supported external login provider that provides identity to let the user
    /// federate into Amazon QuickSight with an associated IAMrole. The type can be one of the following.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.</p>
    /// </li>
    /// </ul>
    pub external_login_federation_provider_type: std::option::Option<std::string::String>,
    /// <p>The URL of the external login provider.</p>
    pub external_login_federation_provider_url: std::option::Option<std::string::String>,
    /// <p>The identity ID for the user in the external login provider.</p>
    pub external_login_id: std::option::Option<std::string::String>,
}
impl User {
    /// <p>The Amazon Resource Name (ARN) for the user.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The user's user name.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The user's email address.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The Amazon QuickSight role for the user. The user role can be one of the
    /// following:.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>READER</code>: A user who has read-only access to dashboards.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses,
    /// and dashboards.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon
    /// Amazon QuickSight settings.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESTRICTED_READER</code>: This role isn't currently available for
    /// use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for
    /// use.</p>
    /// </li>
    /// </ul>
    pub fn role(&self) -> std::option::Option<&crate::model::UserRole> {
        self.role.as_ref()
    }
    /// <p>The type of identity authentication used by the user.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
    /// <p>The active status of user. When you create an Amazon QuickSight user that’s not an IAM
    /// user or an Active Directory user, that user is inactive until they sign in and provide a
    /// password.</p>
    pub fn active(&self) -> bool {
        self.active
    }
    /// <p>The principal ID of the user.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The custom permissions profile associated with this user.</p>
    pub fn custom_permissions_name(&self) -> std::option::Option<&str> {
        self.custom_permissions_name.as_deref()
    }
    /// <p>The type of supported external login provider that provides identity to let the user
    /// federate into Amazon QuickSight with an associated IAMrole. The type can be one of the following.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.</p>
    /// </li>
    /// </ul>
    pub fn external_login_federation_provider_type(&self) -> std::option::Option<&str> {
        self.external_login_federation_provider_type.as_deref()
    }
    /// <p>The URL of the external login provider.</p>
    pub fn external_login_federation_provider_url(&self) -> std::option::Option<&str> {
        self.external_login_federation_provider_url.as_deref()
    }
    /// <p>The identity ID for the user in the external login provider.</p>
    pub fn external_login_id(&self) -> std::option::Option<&str> {
        self.external_login_id.as_deref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("arn", &self.arn);
        formatter.field("user_name", &self.user_name);
        formatter.field("email", &self.email);
        formatter.field("role", &self.role);
        formatter.field("identity_type", &self.identity_type);
        formatter.field("active", &self.active);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("custom_permissions_name", &self.custom_permissions_name);
        formatter.field(
            "external_login_federation_provider_type",
            &self.external_login_federation_provider_type,
        );
        formatter.field(
            "external_login_federation_provider_url",
            &self.external_login_federation_provider_url,
        );
        formatter.field("external_login_id", &self.external_login_id);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<crate::model::UserRole>,
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) active: std::option::Option<bool>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) custom_permissions_name: std::option::Option<std::string::String>,
        pub(crate) external_login_federation_provider_type:
            std::option::Option<std::string::String>,
        pub(crate) external_login_federation_provider_url: std::option::Option<std::string::String>,
        pub(crate) external_login_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the user.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the user.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The user's user name.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user's user name.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The user's email address.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The user's email address.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the
        /// following:.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>READER</code>: A user who has read-only access to dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses,
        /// and dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon
        /// Amazon QuickSight settings.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_READER</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn role(mut self, input: crate::model::UserRole) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the
        /// following:.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>READER</code>: A user who has read-only access to dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses,
        /// and dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon
        /// Amazon QuickSight settings.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_READER</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn set_role(mut self, input: std::option::Option<crate::model::UserRole>) -> Self {
            self.role = input;
            self
        }
        /// <p>The type of identity authentication used by the user.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>The type of identity authentication used by the user.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The active status of user. When you create an Amazon QuickSight user that’s not an IAM
        /// user or an Active Directory user, that user is inactive until they sign in and provide a
        /// password.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>The active status of user. When you create an Amazon QuickSight user that’s not an IAM
        /// user or an Active Directory user, that user is inactive until they sign in and provide a
        /// password.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// <p>The principal ID of the user.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID of the user.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The custom permissions profile associated with this user.</p>
        pub fn custom_permissions_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_permissions_name = Some(input.into());
            self
        }
        /// <p>The custom permissions profile associated with this user.</p>
        pub fn set_custom_permissions_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_permissions_name = input;
            self
        }
        /// <p>The type of supported external login provider that provides identity to let the user
        /// federate into Amazon QuickSight with an associated IAMrole. The type can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.</p>
        /// </li>
        /// </ul>
        pub fn external_login_federation_provider_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.external_login_federation_provider_type = Some(input.into());
            self
        }
        /// <p>The type of supported external login provider that provides identity to let the user
        /// federate into Amazon QuickSight with an associated IAMrole. The type can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.</p>
        /// </li>
        /// </ul>
        pub fn set_external_login_federation_provider_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_login_federation_provider_type = input;
            self
        }
        /// <p>The URL of the external login provider.</p>
        pub fn external_login_federation_provider_url(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.external_login_federation_provider_url = Some(input.into());
            self
        }
        /// <p>The URL of the external login provider.</p>
        pub fn set_external_login_federation_provider_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_login_federation_provider_url = input;
            self
        }
        /// <p>The identity ID for the user in the external login provider.</p>
        pub fn external_login_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_login_id = Some(input.into());
            self
        }
        /// <p>The identity ID for the user in the external login provider.</p>
        pub fn set_external_login_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_login_id = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                arn: self.arn,
                user_name: self.user_name,
                email: self.email,
                role: self.role,
                identity_type: self.identity_type,
                active: self.active.unwrap_or_default(),
                principal_id: self.principal_id,
                custom_permissions_name: self.custom_permissions_name,
                external_login_federation_provider_type: self
                    .external_login_federation_provider_type,
                external_login_federation_provider_url: self.external_login_federation_provider_url,
                external_login_id: self.external_login_id,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityType {
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    #[allow(missing_docs)] // documentation missing in model
    Quicksight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityType {
    fn from(s: &str) -> Self {
        match s {
            "IAM" => IdentityType::Iam,
            "QUICKSIGHT" => IdentityType::Quicksight,
            other => IdentityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityType::from(s))
    }
}
impl IdentityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityType::Iam => "IAM",
            IdentityType::Quicksight => "QUICKSIGHT",
            IdentityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IAM", "QUICKSIGHT"]
    }
}
impl AsRef<str> for IdentityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserRole {
    #[allow(missing_docs)] // documentation missing in model
    Admin,
    #[allow(missing_docs)] // documentation missing in model
    Author,
    #[allow(missing_docs)] // documentation missing in model
    Reader,
    #[allow(missing_docs)] // documentation missing in model
    RestrictedAuthor,
    #[allow(missing_docs)] // documentation missing in model
    RestrictedReader,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserRole {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN" => UserRole::Admin,
            "AUTHOR" => UserRole::Author,
            "READER" => UserRole::Reader,
            "RESTRICTED_AUTHOR" => UserRole::RestrictedAuthor,
            "RESTRICTED_READER" => UserRole::RestrictedReader,
            other => UserRole::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserRole {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserRole::from(s))
    }
}
impl UserRole {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserRole::Admin => "ADMIN",
            UserRole::Author => "AUTHOR",
            UserRole::Reader => "READER",
            UserRole::RestrictedAuthor => "RESTRICTED_AUTHOR",
            UserRole::RestrictedReader => "RESTRICTED_READER",
            UserRole::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADMIN",
            "AUTHOR",
            "READER",
            "RESTRICTED_AUTHOR",
            "RESTRICTED_READER",
        ]
    }
}
impl AsRef<str> for UserRole {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Permission for the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePermission {
    /// <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
    /// </li>
    /// <li>
    /// <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
    /// </li>
    /// <li>
    /// <p>The ARN of an Amazon Web Services account root: This is an IAMARN rather than a Amazon QuickSight
    /// ARN. Use this option only to share resources (templates) across Amazon Web Services accounts.
    /// (This is less common.) </p>
    /// </li>
    /// </ul>
    pub principal: std::option::Option<std::string::String>,
    /// <p>The IAMaction to grant or revoke permissions on.</p>
    pub actions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ResourcePermission {
    /// <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
    /// </li>
    /// <li>
    /// <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
    /// </li>
    /// <li>
    /// <p>The ARN of an Amazon Web Services account root: This is an IAMARN rather than a Amazon QuickSight
    /// ARN. Use this option only to share resources (templates) across Amazon Web Services accounts.
    /// (This is less common.) </p>
    /// </li>
    /// </ul>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>The IAMaction to grant or revoke permissions on.</p>
    pub fn actions(&self) -> std::option::Option<&[std::string::String]> {
        self.actions.as_deref()
    }
}
impl std::fmt::Debug for ResourcePermission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePermission");
        formatter.field("principal", &self.principal);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`ResourcePermission`](crate::model::ResourcePermission)
pub mod resource_permission {
    /// A builder for [`ResourcePermission`](crate::model::ResourcePermission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
        /// </li>
        /// <li>
        /// <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
        /// </li>
        /// <li>
        /// <p>The ARN of an Amazon Web Services account root: This is an IAMARN rather than a Amazon QuickSight
        /// ARN. Use this option only to share resources (templates) across Amazon Web Services accounts.
        /// (This is less common.) </p>
        /// </li>
        /// </ul>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal. This can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</p>
        /// </li>
        /// <li>
        /// <p>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</p>
        /// </li>
        /// <li>
        /// <p>The ARN of an Amazon Web Services account root: This is an IAMARN rather than a Amazon QuickSight
        /// ARN. Use this option only to share resources (templates) across Amazon Web Services accounts.
        /// (This is less common.) </p>
        /// </li>
        /// </ul>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The IAMaction to grant or revoke permissions on.</p>
        pub fn actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The IAMaction to grant or revoke permissions on.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePermission`](crate::model::ResourcePermission)
        pub fn build(self) -> crate::model::ResourcePermission {
            crate::model::ResourcePermission {
                principal: self.principal,
                actions: self.actions,
            }
        }
    }
}
impl ResourcePermission {
    /// Creates a new builder-style object to manufacture [`ResourcePermission`](crate::model::ResourcePermission)
    pub fn builder() -> crate::model::resource_permission::Builder {
        crate::model::resource_permission::Builder::default()
    }
}

/// <p>An alias for a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeAlias {
    /// <p>The Amazon Resource Name (ARN) of the theme alias.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The display name of the theme alias.</p>
    pub alias_name: std::option::Option<std::string::String>,
    /// <p>The version number of the theme alias.</p>
    pub theme_version_number: std::option::Option<i64>,
}
impl ThemeAlias {
    /// <p>The Amazon Resource Name (ARN) of the theme alias.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The display name of the theme alias.</p>
    pub fn alias_name(&self) -> std::option::Option<&str> {
        self.alias_name.as_deref()
    }
    /// <p>The version number of the theme alias.</p>
    pub fn theme_version_number(&self) -> std::option::Option<i64> {
        self.theme_version_number
    }
}
impl std::fmt::Debug for ThemeAlias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeAlias");
        formatter.field("arn", &self.arn);
        formatter.field("alias_name", &self.alias_name);
        formatter.field("theme_version_number", &self.theme_version_number);
        formatter.finish()
    }
}
/// See [`ThemeAlias`](crate::model::ThemeAlias)
pub mod theme_alias {
    /// A builder for [`ThemeAlias`](crate::model::ThemeAlias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) alias_name: std::option::Option<std::string::String>,
        pub(crate) theme_version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the theme alias.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme alias.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The display name of the theme alias.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The display name of the theme alias.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// <p>The version number of the theme alias.</p>
        pub fn theme_version_number(mut self, input: i64) -> Self {
            self.theme_version_number = Some(input);
            self
        }
        /// <p>The version number of the theme alias.</p>
        pub fn set_theme_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.theme_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeAlias`](crate::model::ThemeAlias)
        pub fn build(self) -> crate::model::ThemeAlias {
            crate::model::ThemeAlias {
                arn: self.arn,
                alias_name: self.alias_name,
                theme_version_number: self.theme_version_number,
            }
        }
    }
}
impl ThemeAlias {
    /// Creates a new builder-style object to manufacture [`ThemeAlias`](crate::model::ThemeAlias)
    pub fn builder() -> crate::model::theme_alias::Builder {
        crate::model::theme_alias::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreationFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreationSuccessful,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateSuccessful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATION_FAILED" => ResourceStatus::CreationFailed,
            "CREATION_IN_PROGRESS" => ResourceStatus::CreationInProgress,
            "CREATION_SUCCESSFUL" => ResourceStatus::CreationSuccessful,
            "DELETED" => ResourceStatus::Deleted,
            "UPDATE_FAILED" => ResourceStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => ResourceStatus::UpdateInProgress,
            "UPDATE_SUCCESSFUL" => ResourceStatus::UpdateSuccessful,
            other => ResourceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceStatus::from(s))
    }
}
impl ResourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceStatus::CreationFailed => "CREATION_FAILED",
            ResourceStatus::CreationInProgress => "CREATION_IN_PROGRESS",
            ResourceStatus::CreationSuccessful => "CREATION_SUCCESSFUL",
            ResourceStatus::Deleted => "DELETED",
            ResourceStatus::UpdateFailed => "UPDATE_FAILED",
            ResourceStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            ResourceStatus::UpdateSuccessful => "UPDATE_SUCCESSFUL",
            ResourceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATION_FAILED",
            "CREATION_IN_PROGRESS",
            "CREATION_SUCCESSFUL",
            "DELETED",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
            "UPDATE_SUCCESSFUL",
        ]
    }
}
impl AsRef<str> for ResourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The theme configuration. This configuration contains all of the display properties for
/// a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeConfiguration {
    /// <p>Color properties that apply to chart data colors.</p>
    pub data_color_palette: std::option::Option<crate::model::DataColorPalette>,
    /// <p>Color properties that apply to the UI and to charts, excluding the colors that apply
    /// to data. </p>
    pub ui_color_palette: std::option::Option<crate::model::UiColorPalette>,
    /// <p>Display options related to sheets.</p>
    pub sheet: std::option::Option<crate::model::SheetStyle>,
}
impl ThemeConfiguration {
    /// <p>Color properties that apply to chart data colors.</p>
    pub fn data_color_palette(&self) -> std::option::Option<&crate::model::DataColorPalette> {
        self.data_color_palette.as_ref()
    }
    /// <p>Color properties that apply to the UI and to charts, excluding the colors that apply
    /// to data. </p>
    pub fn ui_color_palette(&self) -> std::option::Option<&crate::model::UiColorPalette> {
        self.ui_color_palette.as_ref()
    }
    /// <p>Display options related to sheets.</p>
    pub fn sheet(&self) -> std::option::Option<&crate::model::SheetStyle> {
        self.sheet.as_ref()
    }
}
impl std::fmt::Debug for ThemeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeConfiguration");
        formatter.field("data_color_palette", &self.data_color_palette);
        formatter.field("ui_color_palette", &self.ui_color_palette);
        formatter.field("sheet", &self.sheet);
        formatter.finish()
    }
}
/// See [`ThemeConfiguration`](crate::model::ThemeConfiguration)
pub mod theme_configuration {
    /// A builder for [`ThemeConfiguration`](crate::model::ThemeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_color_palette: std::option::Option<crate::model::DataColorPalette>,
        pub(crate) ui_color_palette: std::option::Option<crate::model::UiColorPalette>,
        pub(crate) sheet: std::option::Option<crate::model::SheetStyle>,
    }
    impl Builder {
        /// <p>Color properties that apply to chart data colors.</p>
        pub fn data_color_palette(mut self, input: crate::model::DataColorPalette) -> Self {
            self.data_color_palette = Some(input);
            self
        }
        /// <p>Color properties that apply to chart data colors.</p>
        pub fn set_data_color_palette(
            mut self,
            input: std::option::Option<crate::model::DataColorPalette>,
        ) -> Self {
            self.data_color_palette = input;
            self
        }
        /// <p>Color properties that apply to the UI and to charts, excluding the colors that apply
        /// to data. </p>
        pub fn ui_color_palette(mut self, input: crate::model::UiColorPalette) -> Self {
            self.ui_color_palette = Some(input);
            self
        }
        /// <p>Color properties that apply to the UI and to charts, excluding the colors that apply
        /// to data. </p>
        pub fn set_ui_color_palette(
            mut self,
            input: std::option::Option<crate::model::UiColorPalette>,
        ) -> Self {
            self.ui_color_palette = input;
            self
        }
        /// <p>Display options related to sheets.</p>
        pub fn sheet(mut self, input: crate::model::SheetStyle) -> Self {
            self.sheet = Some(input);
            self
        }
        /// <p>Display options related to sheets.</p>
        pub fn set_sheet(mut self, input: std::option::Option<crate::model::SheetStyle>) -> Self {
            self.sheet = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeConfiguration`](crate::model::ThemeConfiguration)
        pub fn build(self) -> crate::model::ThemeConfiguration {
            crate::model::ThemeConfiguration {
                data_color_palette: self.data_color_palette,
                ui_color_palette: self.ui_color_palette,
                sheet: self.sheet,
            }
        }
    }
}
impl ThemeConfiguration {
    /// Creates a new builder-style object to manufacture [`ThemeConfiguration`](crate::model::ThemeConfiguration)
    pub fn builder() -> crate::model::theme_configuration::Builder {
        crate::model::theme_configuration::Builder::default()
    }
}

/// <p>The theme display options for sheets. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SheetStyle {
    /// <p>The display options for tiles.</p>
    pub tile: std::option::Option<crate::model::TileStyle>,
    /// <p>The layout options for tiles.</p>
    pub tile_layout: std::option::Option<crate::model::TileLayoutStyle>,
}
impl SheetStyle {
    /// <p>The display options for tiles.</p>
    pub fn tile(&self) -> std::option::Option<&crate::model::TileStyle> {
        self.tile.as_ref()
    }
    /// <p>The layout options for tiles.</p>
    pub fn tile_layout(&self) -> std::option::Option<&crate::model::TileLayoutStyle> {
        self.tile_layout.as_ref()
    }
}
impl std::fmt::Debug for SheetStyle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SheetStyle");
        formatter.field("tile", &self.tile);
        formatter.field("tile_layout", &self.tile_layout);
        formatter.finish()
    }
}
/// See [`SheetStyle`](crate::model::SheetStyle)
pub mod sheet_style {
    /// A builder for [`SheetStyle`](crate::model::SheetStyle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tile: std::option::Option<crate::model::TileStyle>,
        pub(crate) tile_layout: std::option::Option<crate::model::TileLayoutStyle>,
    }
    impl Builder {
        /// <p>The display options for tiles.</p>
        pub fn tile(mut self, input: crate::model::TileStyle) -> Self {
            self.tile = Some(input);
            self
        }
        /// <p>The display options for tiles.</p>
        pub fn set_tile(mut self, input: std::option::Option<crate::model::TileStyle>) -> Self {
            self.tile = input;
            self
        }
        /// <p>The layout options for tiles.</p>
        pub fn tile_layout(mut self, input: crate::model::TileLayoutStyle) -> Self {
            self.tile_layout = Some(input);
            self
        }
        /// <p>The layout options for tiles.</p>
        pub fn set_tile_layout(
            mut self,
            input: std::option::Option<crate::model::TileLayoutStyle>,
        ) -> Self {
            self.tile_layout = input;
            self
        }
        /// Consumes the builder and constructs a [`SheetStyle`](crate::model::SheetStyle)
        pub fn build(self) -> crate::model::SheetStyle {
            crate::model::SheetStyle {
                tile: self.tile,
                tile_layout: self.tile_layout,
            }
        }
    }
}
impl SheetStyle {
    /// Creates a new builder-style object to manufacture [`SheetStyle`](crate::model::SheetStyle)
    pub fn builder() -> crate::model::sheet_style::Builder {
        crate::model::sheet_style::Builder::default()
    }
}

/// <p>The display options for the layout of tiles on a sheet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TileLayoutStyle {
    /// <p>The gutter settings that apply between tiles. </p>
    pub gutter: std::option::Option<crate::model::GutterStyle>,
    /// <p>The margin settings that apply around the outside edge of sheets.</p>
    pub margin: std::option::Option<crate::model::MarginStyle>,
}
impl TileLayoutStyle {
    /// <p>The gutter settings that apply between tiles. </p>
    pub fn gutter(&self) -> std::option::Option<&crate::model::GutterStyle> {
        self.gutter.as_ref()
    }
    /// <p>The margin settings that apply around the outside edge of sheets.</p>
    pub fn margin(&self) -> std::option::Option<&crate::model::MarginStyle> {
        self.margin.as_ref()
    }
}
impl std::fmt::Debug for TileLayoutStyle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TileLayoutStyle");
        formatter.field("gutter", &self.gutter);
        formatter.field("margin", &self.margin);
        formatter.finish()
    }
}
/// See [`TileLayoutStyle`](crate::model::TileLayoutStyle)
pub mod tile_layout_style {
    /// A builder for [`TileLayoutStyle`](crate::model::TileLayoutStyle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gutter: std::option::Option<crate::model::GutterStyle>,
        pub(crate) margin: std::option::Option<crate::model::MarginStyle>,
    }
    impl Builder {
        /// <p>The gutter settings that apply between tiles. </p>
        pub fn gutter(mut self, input: crate::model::GutterStyle) -> Self {
            self.gutter = Some(input);
            self
        }
        /// <p>The gutter settings that apply between tiles. </p>
        pub fn set_gutter(mut self, input: std::option::Option<crate::model::GutterStyle>) -> Self {
            self.gutter = input;
            self
        }
        /// <p>The margin settings that apply around the outside edge of sheets.</p>
        pub fn margin(mut self, input: crate::model::MarginStyle) -> Self {
            self.margin = Some(input);
            self
        }
        /// <p>The margin settings that apply around the outside edge of sheets.</p>
        pub fn set_margin(mut self, input: std::option::Option<crate::model::MarginStyle>) -> Self {
            self.margin = input;
            self
        }
        /// Consumes the builder and constructs a [`TileLayoutStyle`](crate::model::TileLayoutStyle)
        pub fn build(self) -> crate::model::TileLayoutStyle {
            crate::model::TileLayoutStyle {
                gutter: self.gutter,
                margin: self.margin,
            }
        }
    }
}
impl TileLayoutStyle {
    /// Creates a new builder-style object to manufacture [`TileLayoutStyle`](crate::model::TileLayoutStyle)
    pub fn builder() -> crate::model::tile_layout_style::Builder {
        crate::model::tile_layout_style::Builder::default()
    }
}

/// <p>The display options for margins around the outside edge of sheets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarginStyle {
    /// <p>This Boolean value controls whether to display sheet margins.</p>
    pub show: std::option::Option<bool>,
}
impl MarginStyle {
    /// <p>This Boolean value controls whether to display sheet margins.</p>
    pub fn show(&self) -> std::option::Option<bool> {
        self.show
    }
}
impl std::fmt::Debug for MarginStyle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarginStyle");
        formatter.field("show", &self.show);
        formatter.finish()
    }
}
/// See [`MarginStyle`](crate::model::MarginStyle)
pub mod margin_style {
    /// A builder for [`MarginStyle`](crate::model::MarginStyle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) show: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>This Boolean value controls whether to display sheet margins.</p>
        pub fn show(mut self, input: bool) -> Self {
            self.show = Some(input);
            self
        }
        /// <p>This Boolean value controls whether to display sheet margins.</p>
        pub fn set_show(mut self, input: std::option::Option<bool>) -> Self {
            self.show = input;
            self
        }
        /// Consumes the builder and constructs a [`MarginStyle`](crate::model::MarginStyle)
        pub fn build(self) -> crate::model::MarginStyle {
            crate::model::MarginStyle { show: self.show }
        }
    }
}
impl MarginStyle {
    /// Creates a new builder-style object to manufacture [`MarginStyle`](crate::model::MarginStyle)
    pub fn builder() -> crate::model::margin_style::Builder {
        crate::model::margin_style::Builder::default()
    }
}

/// <p>The display options for gutter spacing between tiles on a sheet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GutterStyle {
    /// <p>This Boolean value controls whether to display a gutter space between sheet tiles.
    /// </p>
    pub show: std::option::Option<bool>,
}
impl GutterStyle {
    /// <p>This Boolean value controls whether to display a gutter space between sheet tiles.
    /// </p>
    pub fn show(&self) -> std::option::Option<bool> {
        self.show
    }
}
impl std::fmt::Debug for GutterStyle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GutterStyle");
        formatter.field("show", &self.show);
        formatter.finish()
    }
}
/// See [`GutterStyle`](crate::model::GutterStyle)
pub mod gutter_style {
    /// A builder for [`GutterStyle`](crate::model::GutterStyle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) show: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>This Boolean value controls whether to display a gutter space between sheet tiles.
        /// </p>
        pub fn show(mut self, input: bool) -> Self {
            self.show = Some(input);
            self
        }
        /// <p>This Boolean value controls whether to display a gutter space between sheet tiles.
        /// </p>
        pub fn set_show(mut self, input: std::option::Option<bool>) -> Self {
            self.show = input;
            self
        }
        /// Consumes the builder and constructs a [`GutterStyle`](crate::model::GutterStyle)
        pub fn build(self) -> crate::model::GutterStyle {
            crate::model::GutterStyle { show: self.show }
        }
    }
}
impl GutterStyle {
    /// Creates a new builder-style object to manufacture [`GutterStyle`](crate::model::GutterStyle)
    pub fn builder() -> crate::model::gutter_style::Builder {
        crate::model::gutter_style::Builder::default()
    }
}

/// <p>Display options related to tiles on a sheet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TileStyle {
    /// <p>The border around a tile.</p>
    pub border: std::option::Option<crate::model::BorderStyle>,
}
impl TileStyle {
    /// <p>The border around a tile.</p>
    pub fn border(&self) -> std::option::Option<&crate::model::BorderStyle> {
        self.border.as_ref()
    }
}
impl std::fmt::Debug for TileStyle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TileStyle");
        formatter.field("border", &self.border);
        formatter.finish()
    }
}
/// See [`TileStyle`](crate::model::TileStyle)
pub mod tile_style {
    /// A builder for [`TileStyle`](crate::model::TileStyle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) border: std::option::Option<crate::model::BorderStyle>,
    }
    impl Builder {
        /// <p>The border around a tile.</p>
        pub fn border(mut self, input: crate::model::BorderStyle) -> Self {
            self.border = Some(input);
            self
        }
        /// <p>The border around a tile.</p>
        pub fn set_border(mut self, input: std::option::Option<crate::model::BorderStyle>) -> Self {
            self.border = input;
            self
        }
        /// Consumes the builder and constructs a [`TileStyle`](crate::model::TileStyle)
        pub fn build(self) -> crate::model::TileStyle {
            crate::model::TileStyle {
                border: self.border,
            }
        }
    }
}
impl TileStyle {
    /// Creates a new builder-style object to manufacture [`TileStyle`](crate::model::TileStyle)
    pub fn builder() -> crate::model::tile_style::Builder {
        crate::model::tile_style::Builder::default()
    }
}

/// <p>The display options for tile borders for visuals.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BorderStyle {
    /// <p>The option to enable display of borders for visuals.</p>
    pub show: std::option::Option<bool>,
}
impl BorderStyle {
    /// <p>The option to enable display of borders for visuals.</p>
    pub fn show(&self) -> std::option::Option<bool> {
        self.show
    }
}
impl std::fmt::Debug for BorderStyle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BorderStyle");
        formatter.field("show", &self.show);
        formatter.finish()
    }
}
/// See [`BorderStyle`](crate::model::BorderStyle)
pub mod border_style {
    /// A builder for [`BorderStyle`](crate::model::BorderStyle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) show: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The option to enable display of borders for visuals.</p>
        pub fn show(mut self, input: bool) -> Self {
            self.show = Some(input);
            self
        }
        /// <p>The option to enable display of borders for visuals.</p>
        pub fn set_show(mut self, input: std::option::Option<bool>) -> Self {
            self.show = input;
            self
        }
        /// Consumes the builder and constructs a [`BorderStyle`](crate::model::BorderStyle)
        pub fn build(self) -> crate::model::BorderStyle {
            crate::model::BorderStyle { show: self.show }
        }
    }
}
impl BorderStyle {
    /// Creates a new builder-style object to manufacture [`BorderStyle`](crate::model::BorderStyle)
    pub fn builder() -> crate::model::border_style::Builder {
        crate::model::border_style::Builder::default()
    }
}

/// <p>The theme colors that apply to UI and to charts, excluding data colors. The colors
/// description is a hexadecimal color code that consists of six alphanumerical characters,
/// prefixed with <code>#</code>, for example #37BFF5. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User
/// Guide.</i>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UiColorPalette {
    /// <p>The color of text and other foreground elements that appear over the primary
    /// background regions, such as grid lines, borders, table banding, icons, and so on.</p>
    pub primary_foreground: std::option::Option<std::string::String>,
    /// <p>The background color that applies to visuals and other high emphasis UI.</p>
    pub primary_background: std::option::Option<std::string::String>,
    /// <p>The foreground color that applies to any sheet title, sheet control text, or UI that
    /// appears over the secondary background.</p>
    pub secondary_foreground: std::option::Option<std::string::String>,
    /// <p>The background color that applies to the sheet background and sheet controls.</p>
    pub secondary_background: std::option::Option<std::string::String>,
    /// <p>This color is that applies to selected states and buttons.</p>
    pub accent: std::option::Option<std::string::String>,
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// accent color.</p>
    pub accent_foreground: std::option::Option<std::string::String>,
    /// <p>The color that applies to error messages.</p>
    pub danger: std::option::Option<std::string::String>,
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// error color.</p>
    pub danger_foreground: std::option::Option<std::string::String>,
    /// <p>This color that applies to warning and informational messages.</p>
    pub warning: std::option::Option<std::string::String>,
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// warning color.</p>
    pub warning_foreground: std::option::Option<std::string::String>,
    /// <p>The color that applies to success messages, for example the check mark for a
    /// successful download.</p>
    pub success: std::option::Option<std::string::String>,
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// success color.</p>
    pub success_foreground: std::option::Option<std::string::String>,
    /// <p>The color that applies to the names of fields that are identified as
    /// dimensions.</p>
    pub dimension: std::option::Option<std::string::String>,
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// dimension color.</p>
    pub dimension_foreground: std::option::Option<std::string::String>,
    /// <p>The color that applies to the names of fields that are identified as measures.</p>
    pub measure: std::option::Option<std::string::String>,
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// measure color.</p>
    pub measure_foreground: std::option::Option<std::string::String>,
}
impl UiColorPalette {
    /// <p>The color of text and other foreground elements that appear over the primary
    /// background regions, such as grid lines, borders, table banding, icons, and so on.</p>
    pub fn primary_foreground(&self) -> std::option::Option<&str> {
        self.primary_foreground.as_deref()
    }
    /// <p>The background color that applies to visuals and other high emphasis UI.</p>
    pub fn primary_background(&self) -> std::option::Option<&str> {
        self.primary_background.as_deref()
    }
    /// <p>The foreground color that applies to any sheet title, sheet control text, or UI that
    /// appears over the secondary background.</p>
    pub fn secondary_foreground(&self) -> std::option::Option<&str> {
        self.secondary_foreground.as_deref()
    }
    /// <p>The background color that applies to the sheet background and sheet controls.</p>
    pub fn secondary_background(&self) -> std::option::Option<&str> {
        self.secondary_background.as_deref()
    }
    /// <p>This color is that applies to selected states and buttons.</p>
    pub fn accent(&self) -> std::option::Option<&str> {
        self.accent.as_deref()
    }
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// accent color.</p>
    pub fn accent_foreground(&self) -> std::option::Option<&str> {
        self.accent_foreground.as_deref()
    }
    /// <p>The color that applies to error messages.</p>
    pub fn danger(&self) -> std::option::Option<&str> {
        self.danger.as_deref()
    }
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// error color.</p>
    pub fn danger_foreground(&self) -> std::option::Option<&str> {
        self.danger_foreground.as_deref()
    }
    /// <p>This color that applies to warning and informational messages.</p>
    pub fn warning(&self) -> std::option::Option<&str> {
        self.warning.as_deref()
    }
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// warning color.</p>
    pub fn warning_foreground(&self) -> std::option::Option<&str> {
        self.warning_foreground.as_deref()
    }
    /// <p>The color that applies to success messages, for example the check mark for a
    /// successful download.</p>
    pub fn success(&self) -> std::option::Option<&str> {
        self.success.as_deref()
    }
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// success color.</p>
    pub fn success_foreground(&self) -> std::option::Option<&str> {
        self.success_foreground.as_deref()
    }
    /// <p>The color that applies to the names of fields that are identified as
    /// dimensions.</p>
    pub fn dimension(&self) -> std::option::Option<&str> {
        self.dimension.as_deref()
    }
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// dimension color.</p>
    pub fn dimension_foreground(&self) -> std::option::Option<&str> {
        self.dimension_foreground.as_deref()
    }
    /// <p>The color that applies to the names of fields that are identified as measures.</p>
    pub fn measure(&self) -> std::option::Option<&str> {
        self.measure.as_deref()
    }
    /// <p>The foreground color that applies to any text or other elements that appear over the
    /// measure color.</p>
    pub fn measure_foreground(&self) -> std::option::Option<&str> {
        self.measure_foreground.as_deref()
    }
}
impl std::fmt::Debug for UiColorPalette {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UiColorPalette");
        formatter.field("primary_foreground", &self.primary_foreground);
        formatter.field("primary_background", &self.primary_background);
        formatter.field("secondary_foreground", &self.secondary_foreground);
        formatter.field("secondary_background", &self.secondary_background);
        formatter.field("accent", &self.accent);
        formatter.field("accent_foreground", &self.accent_foreground);
        formatter.field("danger", &self.danger);
        formatter.field("danger_foreground", &self.danger_foreground);
        formatter.field("warning", &self.warning);
        formatter.field("warning_foreground", &self.warning_foreground);
        formatter.field("success", &self.success);
        formatter.field("success_foreground", &self.success_foreground);
        formatter.field("dimension", &self.dimension);
        formatter.field("dimension_foreground", &self.dimension_foreground);
        formatter.field("measure", &self.measure);
        formatter.field("measure_foreground", &self.measure_foreground);
        formatter.finish()
    }
}
/// See [`UiColorPalette`](crate::model::UiColorPalette)
pub mod ui_color_palette {
    /// A builder for [`UiColorPalette`](crate::model::UiColorPalette)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary_foreground: std::option::Option<std::string::String>,
        pub(crate) primary_background: std::option::Option<std::string::String>,
        pub(crate) secondary_foreground: std::option::Option<std::string::String>,
        pub(crate) secondary_background: std::option::Option<std::string::String>,
        pub(crate) accent: std::option::Option<std::string::String>,
        pub(crate) accent_foreground: std::option::Option<std::string::String>,
        pub(crate) danger: std::option::Option<std::string::String>,
        pub(crate) danger_foreground: std::option::Option<std::string::String>,
        pub(crate) warning: std::option::Option<std::string::String>,
        pub(crate) warning_foreground: std::option::Option<std::string::String>,
        pub(crate) success: std::option::Option<std::string::String>,
        pub(crate) success_foreground: std::option::Option<std::string::String>,
        pub(crate) dimension: std::option::Option<std::string::String>,
        pub(crate) dimension_foreground: std::option::Option<std::string::String>,
        pub(crate) measure: std::option::Option<std::string::String>,
        pub(crate) measure_foreground: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The color of text and other foreground elements that appear over the primary
        /// background regions, such as grid lines, borders, table banding, icons, and so on.</p>
        pub fn primary_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_foreground = Some(input.into());
            self
        }
        /// <p>The color of text and other foreground elements that appear over the primary
        /// background regions, such as grid lines, borders, table banding, icons, and so on.</p>
        pub fn set_primary_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_foreground = input;
            self
        }
        /// <p>The background color that applies to visuals and other high emphasis UI.</p>
        pub fn primary_background(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_background = Some(input.into());
            self
        }
        /// <p>The background color that applies to visuals and other high emphasis UI.</p>
        pub fn set_primary_background(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_background = input;
            self
        }
        /// <p>The foreground color that applies to any sheet title, sheet control text, or UI that
        /// appears over the secondary background.</p>
        pub fn secondary_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.secondary_foreground = Some(input.into());
            self
        }
        /// <p>The foreground color that applies to any sheet title, sheet control text, or UI that
        /// appears over the secondary background.</p>
        pub fn set_secondary_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secondary_foreground = input;
            self
        }
        /// <p>The background color that applies to the sheet background and sheet controls.</p>
        pub fn secondary_background(mut self, input: impl Into<std::string::String>) -> Self {
            self.secondary_background = Some(input.into());
            self
        }
        /// <p>The background color that applies to the sheet background and sheet controls.</p>
        pub fn set_secondary_background(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secondary_background = input;
            self
        }
        /// <p>This color is that applies to selected states and buttons.</p>
        pub fn accent(mut self, input: impl Into<std::string::String>) -> Self {
            self.accent = Some(input.into());
            self
        }
        /// <p>This color is that applies to selected states and buttons.</p>
        pub fn set_accent(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accent = input;
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// accent color.</p>
        pub fn accent_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.accent_foreground = Some(input.into());
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// accent color.</p>
        pub fn set_accent_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accent_foreground = input;
            self
        }
        /// <p>The color that applies to error messages.</p>
        pub fn danger(mut self, input: impl Into<std::string::String>) -> Self {
            self.danger = Some(input.into());
            self
        }
        /// <p>The color that applies to error messages.</p>
        pub fn set_danger(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.danger = input;
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// error color.</p>
        pub fn danger_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.danger_foreground = Some(input.into());
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// error color.</p>
        pub fn set_danger_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.danger_foreground = input;
            self
        }
        /// <p>This color that applies to warning and informational messages.</p>
        pub fn warning(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning = Some(input.into());
            self
        }
        /// <p>This color that applies to warning and informational messages.</p>
        pub fn set_warning(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warning = input;
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// warning color.</p>
        pub fn warning_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning_foreground = Some(input.into());
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// warning color.</p>
        pub fn set_warning_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.warning_foreground = input;
            self
        }
        /// <p>The color that applies to success messages, for example the check mark for a
        /// successful download.</p>
        pub fn success(mut self, input: impl Into<std::string::String>) -> Self {
            self.success = Some(input.into());
            self
        }
        /// <p>The color that applies to success messages, for example the check mark for a
        /// successful download.</p>
        pub fn set_success(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.success = input;
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// success color.</p>
        pub fn success_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_foreground = Some(input.into());
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// success color.</p>
        pub fn set_success_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_foreground = input;
            self
        }
        /// <p>The color that applies to the names of fields that are identified as
        /// dimensions.</p>
        pub fn dimension(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension = Some(input.into());
            self
        }
        /// <p>The color that applies to the names of fields that are identified as
        /// dimensions.</p>
        pub fn set_dimension(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dimension = input;
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// dimension color.</p>
        pub fn dimension_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_foreground = Some(input.into());
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// dimension color.</p>
        pub fn set_dimension_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_foreground = input;
            self
        }
        /// <p>The color that applies to the names of fields that are identified as measures.</p>
        pub fn measure(mut self, input: impl Into<std::string::String>) -> Self {
            self.measure = Some(input.into());
            self
        }
        /// <p>The color that applies to the names of fields that are identified as measures.</p>
        pub fn set_measure(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.measure = input;
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// measure color.</p>
        pub fn measure_foreground(mut self, input: impl Into<std::string::String>) -> Self {
            self.measure_foreground = Some(input.into());
            self
        }
        /// <p>The foreground color that applies to any text or other elements that appear over the
        /// measure color.</p>
        pub fn set_measure_foreground(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.measure_foreground = input;
            self
        }
        /// Consumes the builder and constructs a [`UiColorPalette`](crate::model::UiColorPalette)
        pub fn build(self) -> crate::model::UiColorPalette {
            crate::model::UiColorPalette {
                primary_foreground: self.primary_foreground,
                primary_background: self.primary_background,
                secondary_foreground: self.secondary_foreground,
                secondary_background: self.secondary_background,
                accent: self.accent,
                accent_foreground: self.accent_foreground,
                danger: self.danger,
                danger_foreground: self.danger_foreground,
                warning: self.warning,
                warning_foreground: self.warning_foreground,
                success: self.success,
                success_foreground: self.success_foreground,
                dimension: self.dimension,
                dimension_foreground: self.dimension_foreground,
                measure: self.measure,
                measure_foreground: self.measure_foreground,
            }
        }
    }
}
impl UiColorPalette {
    /// Creates a new builder-style object to manufacture [`UiColorPalette`](crate::model::UiColorPalette)
    pub fn builder() -> crate::model::ui_color_palette::Builder {
        crate::model::ui_color_palette::Builder::default()
    }
}

/// <p>The theme colors that are used for data colors in charts. The colors description is a
/// hexadecimal color code that consists of six alphanumerical characters, prefixed with
/// <code>#</code>, for example #37BFF5. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataColorPalette {
    /// <p>The hexadecimal codes for the colors.</p>
    pub colors: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>
    pub min_max_gradient: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The hexadecimal code of a color that applies to charts where a lack of data is
    /// highlighted.</p>
    pub empty_fill_color: std::option::Option<std::string::String>,
}
impl DataColorPalette {
    /// <p>The hexadecimal codes for the colors.</p>
    pub fn colors(&self) -> std::option::Option<&[std::string::String]> {
        self.colors.as_deref()
    }
    /// <p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>
    pub fn min_max_gradient(&self) -> std::option::Option<&[std::string::String]> {
        self.min_max_gradient.as_deref()
    }
    /// <p>The hexadecimal code of a color that applies to charts where a lack of data is
    /// highlighted.</p>
    pub fn empty_fill_color(&self) -> std::option::Option<&str> {
        self.empty_fill_color.as_deref()
    }
}
impl std::fmt::Debug for DataColorPalette {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataColorPalette");
        formatter.field("colors", &self.colors);
        formatter.field("min_max_gradient", &self.min_max_gradient);
        formatter.field("empty_fill_color", &self.empty_fill_color);
        formatter.finish()
    }
}
/// See [`DataColorPalette`](crate::model::DataColorPalette)
pub mod data_color_palette {
    /// A builder for [`DataColorPalette`](crate::model::DataColorPalette)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) colors: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) min_max_gradient: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) empty_fill_color: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `colors`.
        ///
        /// To override the contents of this collection use [`set_colors`](Self::set_colors).
        ///
        /// <p>The hexadecimal codes for the colors.</p>
        pub fn colors(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.colors.unwrap_or_default();
            v.push(input.into());
            self.colors = Some(v);
            self
        }
        /// <p>The hexadecimal codes for the colors.</p>
        pub fn set_colors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.colors = input;
            self
        }
        /// Appends an item to `min_max_gradient`.
        ///
        /// To override the contents of this collection use [`set_min_max_gradient`](Self::set_min_max_gradient).
        ///
        /// <p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>
        pub fn min_max_gradient(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.min_max_gradient.unwrap_or_default();
            v.push(input.into());
            self.min_max_gradient = Some(v);
            self
        }
        /// <p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>
        pub fn set_min_max_gradient(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.min_max_gradient = input;
            self
        }
        /// <p>The hexadecimal code of a color that applies to charts where a lack of data is
        /// highlighted.</p>
        pub fn empty_fill_color(mut self, input: impl Into<std::string::String>) -> Self {
            self.empty_fill_color = Some(input.into());
            self
        }
        /// <p>The hexadecimal code of a color that applies to charts where a lack of data is
        /// highlighted.</p>
        pub fn set_empty_fill_color(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.empty_fill_color = input;
            self
        }
        /// Consumes the builder and constructs a [`DataColorPalette`](crate::model::DataColorPalette)
        pub fn build(self) -> crate::model::DataColorPalette {
            crate::model::DataColorPalette {
                colors: self.colors,
                min_max_gradient: self.min_max_gradient,
                empty_fill_color: self.empty_fill_color,
            }
        }
    }
}
impl DataColorPalette {
    /// Creates a new builder-style object to manufacture [`DataColorPalette`](crate::model::DataColorPalette)
    pub fn builder() -> crate::model::data_color_palette::Builder {
        crate::model::data_color_palette::Builder::default()
    }
}

/// <p>The template alias.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateAlias {
    /// <p>The display name of the template alias.</p>
    pub alias_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the template alias.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version number of the template alias.</p>
    pub template_version_number: std::option::Option<i64>,
}
impl TemplateAlias {
    /// <p>The display name of the template alias.</p>
    pub fn alias_name(&self) -> std::option::Option<&str> {
        self.alias_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the template alias.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version number of the template alias.</p>
    pub fn template_version_number(&self) -> std::option::Option<i64> {
        self.template_version_number
    }
}
impl std::fmt::Debug for TemplateAlias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateAlias");
        formatter.field("alias_name", &self.alias_name);
        formatter.field("arn", &self.arn);
        formatter.field("template_version_number", &self.template_version_number);
        formatter.finish()
    }
}
/// See [`TemplateAlias`](crate::model::TemplateAlias)
pub mod template_alias {
    /// A builder for [`TemplateAlias`](crate::model::TemplateAlias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template_version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The display name of the template alias.</p>
        pub fn alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_name = Some(input.into());
            self
        }
        /// <p>The display name of the template alias.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template alias.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template alias.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version number of the template alias.</p>
        pub fn template_version_number(mut self, input: i64) -> Self {
            self.template_version_number = Some(input);
            self
        }
        /// <p>The version number of the template alias.</p>
        pub fn set_template_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.template_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateAlias`](crate::model::TemplateAlias)
        pub fn build(self) -> crate::model::TemplateAlias {
            crate::model::TemplateAlias {
                alias_name: self.alias_name,
                arn: self.arn,
                template_version_number: self.template_version_number,
            }
        }
    }
}
impl TemplateAlias {
    /// Creates a new builder-style object to manufacture [`TemplateAlias`](crate::model::TemplateAlias)
    pub fn builder() -> crate::model::template_alias::Builder {
        crate::model::template_alias::Builder::default()
    }
}

/// <p>The source entity of the template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateSourceEntity {
    /// <p>The source analysis, if it is based on an analysis.</p>
    pub source_analysis: std::option::Option<crate::model::TemplateSourceAnalysis>,
    /// <p>The source template, if it is based on an template.</p>
    pub source_template: std::option::Option<crate::model::TemplateSourceTemplate>,
}
impl TemplateSourceEntity {
    /// <p>The source analysis, if it is based on an analysis.</p>
    pub fn source_analysis(&self) -> std::option::Option<&crate::model::TemplateSourceAnalysis> {
        self.source_analysis.as_ref()
    }
    /// <p>The source template, if it is based on an template.</p>
    pub fn source_template(&self) -> std::option::Option<&crate::model::TemplateSourceTemplate> {
        self.source_template.as_ref()
    }
}
impl std::fmt::Debug for TemplateSourceEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateSourceEntity");
        formatter.field("source_analysis", &self.source_analysis);
        formatter.field("source_template", &self.source_template);
        formatter.finish()
    }
}
/// See [`TemplateSourceEntity`](crate::model::TemplateSourceEntity)
pub mod template_source_entity {
    /// A builder for [`TemplateSourceEntity`](crate::model::TemplateSourceEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_analysis: std::option::Option<crate::model::TemplateSourceAnalysis>,
        pub(crate) source_template: std::option::Option<crate::model::TemplateSourceTemplate>,
    }
    impl Builder {
        /// <p>The source analysis, if it is based on an analysis.</p>
        pub fn source_analysis(mut self, input: crate::model::TemplateSourceAnalysis) -> Self {
            self.source_analysis = Some(input);
            self
        }
        /// <p>The source analysis, if it is based on an analysis.</p>
        pub fn set_source_analysis(
            mut self,
            input: std::option::Option<crate::model::TemplateSourceAnalysis>,
        ) -> Self {
            self.source_analysis = input;
            self
        }
        /// <p>The source template, if it is based on an template.</p>
        pub fn source_template(mut self, input: crate::model::TemplateSourceTemplate) -> Self {
            self.source_template = Some(input);
            self
        }
        /// <p>The source template, if it is based on an template.</p>
        pub fn set_source_template(
            mut self,
            input: std::option::Option<crate::model::TemplateSourceTemplate>,
        ) -> Self {
            self.source_template = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateSourceEntity`](crate::model::TemplateSourceEntity)
        pub fn build(self) -> crate::model::TemplateSourceEntity {
            crate::model::TemplateSourceEntity {
                source_analysis: self.source_analysis,
                source_template: self.source_template,
            }
        }
    }
}
impl TemplateSourceEntity {
    /// Creates a new builder-style object to manufacture [`TemplateSourceEntity`](crate::model::TemplateSourceEntity)
    pub fn builder() -> crate::model::template_source_entity::Builder {
        crate::model::template_source_entity::Builder::default()
    }
}

/// <p>The source template of the template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateSourceTemplate {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl TemplateSourceTemplate {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for TemplateSourceTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateSourceTemplate");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`TemplateSourceTemplate`](crate::model::TemplateSourceTemplate)
pub mod template_source_template {
    /// A builder for [`TemplateSourceTemplate`](crate::model::TemplateSourceTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateSourceTemplate`](crate::model::TemplateSourceTemplate)
        pub fn build(self) -> crate::model::TemplateSourceTemplate {
            crate::model::TemplateSourceTemplate { arn: self.arn }
        }
    }
}
impl TemplateSourceTemplate {
    /// Creates a new builder-style object to manufacture [`TemplateSourceTemplate`](crate::model::TemplateSourceTemplate)
    pub fn builder() -> crate::model::template_source_template::Builder {
        crate::model::template_source_template::Builder::default()
    }
}

/// <p>The source analysis of the template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateSourceAnalysis {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A structure containing information about the dataset references used as placeholders
    /// in the template.</p>
    pub data_set_references: std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
}
impl TemplateSourceAnalysis {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A structure containing information about the dataset references used as placeholders
    /// in the template.</p>
    pub fn data_set_references(&self) -> std::option::Option<&[crate::model::DataSetReference]> {
        self.data_set_references.as_deref()
    }
}
impl std::fmt::Debug for TemplateSourceAnalysis {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateSourceAnalysis");
        formatter.field("arn", &self.arn);
        formatter.field("data_set_references", &self.data_set_references);
        formatter.finish()
    }
}
/// See [`TemplateSourceAnalysis`](crate::model::TemplateSourceAnalysis)
pub mod template_source_analysis {
    /// A builder for [`TemplateSourceAnalysis`](crate::model::TemplateSourceAnalysis)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_set_references:
            std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `data_set_references`.
        ///
        /// To override the contents of this collection use [`set_data_set_references`](Self::set_data_set_references).
        ///
        /// <p>A structure containing information about the dataset references used as placeholders
        /// in the template.</p>
        pub fn data_set_references(
            mut self,
            input: impl Into<crate::model::DataSetReference>,
        ) -> Self {
            let mut v = self.data_set_references.unwrap_or_default();
            v.push(input.into());
            self.data_set_references = Some(v);
            self
        }
        /// <p>A structure containing information about the dataset references used as placeholders
        /// in the template.</p>
        pub fn set_data_set_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
        ) -> Self {
            self.data_set_references = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateSourceAnalysis`](crate::model::TemplateSourceAnalysis)
        pub fn build(self) -> crate::model::TemplateSourceAnalysis {
            crate::model::TemplateSourceAnalysis {
                arn: self.arn,
                data_set_references: self.data_set_references,
            }
        }
    }
}
impl TemplateSourceAnalysis {
    /// Creates a new builder-style object to manufacture [`TemplateSourceAnalysis`](crate::model::TemplateSourceAnalysis)
    pub fn builder() -> crate::model::template_source_analysis::Builder {
        crate::model::template_source_analysis::Builder::default()
    }
}

/// <p>Dataset reference.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSetReference {
    /// <p>Dataset placeholder.</p>
    pub data_set_placeholder: std::option::Option<std::string::String>,
    /// <p>Dataset Amazon Resource Name (ARN).</p>
    pub data_set_arn: std::option::Option<std::string::String>,
}
impl DataSetReference {
    /// <p>Dataset placeholder.</p>
    pub fn data_set_placeholder(&self) -> std::option::Option<&str> {
        self.data_set_placeholder.as_deref()
    }
    /// <p>Dataset Amazon Resource Name (ARN).</p>
    pub fn data_set_arn(&self) -> std::option::Option<&str> {
        self.data_set_arn.as_deref()
    }
}
impl std::fmt::Debug for DataSetReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSetReference");
        formatter.field("data_set_placeholder", &self.data_set_placeholder);
        formatter.field("data_set_arn", &self.data_set_arn);
        formatter.finish()
    }
}
/// See [`DataSetReference`](crate::model::DataSetReference)
pub mod data_set_reference {
    /// A builder for [`DataSetReference`](crate::model::DataSetReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_placeholder: std::option::Option<std::string::String>,
        pub(crate) data_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Dataset placeholder.</p>
        pub fn data_set_placeholder(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_placeholder = Some(input.into());
            self
        }
        /// <p>Dataset placeholder.</p>
        pub fn set_data_set_placeholder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_set_placeholder = input;
            self
        }
        /// <p>Dataset Amazon Resource Name (ARN).</p>
        pub fn data_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_arn = Some(input.into());
            self
        }
        /// <p>Dataset Amazon Resource Name (ARN).</p>
        pub fn set_data_set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSetReference`](crate::model::DataSetReference)
        pub fn build(self) -> crate::model::DataSetReference {
            crate::model::DataSetReference {
                data_set_placeholder: self.data_set_placeholder,
                data_set_arn: self.data_set_arn,
            }
        }
    }
}
impl DataSetReference {
    /// Creates a new builder-style object to manufacture [`DataSetReference`](crate::model::DataSetReference)
    pub fn builder() -> crate::model::data_set_reference::Builder {
        crate::model::data_set_reference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssignmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssignmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AssignmentStatus::Disabled,
            "DRAFT" => AssignmentStatus::Draft,
            "ENABLED" => AssignmentStatus::Enabled,
            other => AssignmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssignmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssignmentStatus::from(s))
    }
}
impl AssignmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssignmentStatus::Disabled => "DISABLED",
            AssignmentStatus::Draft => "DRAFT",
            AssignmentStatus::Enabled => "ENABLED",
            AssignmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "DRAFT", "ENABLED"]
    }
}
impl AsRef<str> for AssignmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A <i>group</i> in Amazon QuickSight consists of a set of users. You can
/// use groups to make it easier to manage access and security. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Group {
    /// <p>The Amazon Resource Name (ARN) for the group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The group description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The principal ID of the group.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl Group {
    /// <p>The Amazon Resource Name (ARN) for the group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The group description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The principal ID of the group.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for Group {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Group");
        formatter.field("arn", &self.arn);
        formatter.field("group_name", &self.group_name);
        formatter.field("description", &self.description);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}
/// See [`Group`](crate::model::Group)
pub mod group {
    /// A builder for [`Group`](crate::model::Group)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The group description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The group description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The principal ID of the group.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID of the group.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Group`](crate::model::Group)
        pub fn build(self) -> crate::model::Group {
            crate::model::Group {
                arn: self.arn,
                group_name: self.group_name,
                description: self.description,
                principal_id: self.principal_id,
            }
        }
    }
}
impl Group {
    /// Creates a new builder-style object to manufacture [`Group`](crate::model::Group)
    pub fn builder() -> crate::model::group::Builder {
        crate::model::group::Builder::default()
    }
}

/// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your
/// underlying data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SslProperties {
    /// <p>A Boolean option to control whether SSL should be disabled.</p>
    pub disable_ssl: bool,
}
impl SslProperties {
    /// <p>A Boolean option to control whether SSL should be disabled.</p>
    pub fn disable_ssl(&self) -> bool {
        self.disable_ssl
    }
}
impl std::fmt::Debug for SslProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SslProperties");
        formatter.field("disable_ssl", &self.disable_ssl);
        formatter.finish()
    }
}
/// See [`SslProperties`](crate::model::SslProperties)
pub mod ssl_properties {
    /// A builder for [`SslProperties`](crate::model::SslProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disable_ssl: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A Boolean option to control whether SSL should be disabled.</p>
        pub fn disable_ssl(mut self, input: bool) -> Self {
            self.disable_ssl = Some(input);
            self
        }
        /// <p>A Boolean option to control whether SSL should be disabled.</p>
        pub fn set_disable_ssl(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_ssl = input;
            self
        }
        /// Consumes the builder and constructs a [`SslProperties`](crate::model::SslProperties)
        pub fn build(self) -> crate::model::SslProperties {
            crate::model::SslProperties {
                disable_ssl: self.disable_ssl.unwrap_or_default(),
            }
        }
    }
}
impl SslProperties {
    /// Creates a new builder-style object to manufacture [`SslProperties`](crate::model::SslProperties)
    pub fn builder() -> crate::model::ssl_properties::Builder {
        crate::model::ssl_properties::Builder::default()
    }
}

/// <p>VPC connection properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConnectionProperties {
    /// <p>The Amazon Resource Name (ARN) for the VPC connection.</p>
    pub vpc_connection_arn: std::option::Option<std::string::String>,
}
impl VpcConnectionProperties {
    /// <p>The Amazon Resource Name (ARN) for the VPC connection.</p>
    pub fn vpc_connection_arn(&self) -> std::option::Option<&str> {
        self.vpc_connection_arn.as_deref()
    }
}
impl std::fmt::Debug for VpcConnectionProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConnectionProperties");
        formatter.field("vpc_connection_arn", &self.vpc_connection_arn);
        formatter.finish()
    }
}
/// See [`VpcConnectionProperties`](crate::model::VpcConnectionProperties)
pub mod vpc_connection_properties {
    /// A builder for [`VpcConnectionProperties`](crate::model::VpcConnectionProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_connection_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the VPC connection.</p>
        pub fn vpc_connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the VPC connection.</p>
        pub fn set_vpc_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_connection_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConnectionProperties`](crate::model::VpcConnectionProperties)
        pub fn build(self) -> crate::model::VpcConnectionProperties {
            crate::model::VpcConnectionProperties {
                vpc_connection_arn: self.vpc_connection_arn,
            }
        }
    }
}
impl VpcConnectionProperties {
    /// Creates a new builder-style object to manufacture [`VpcConnectionProperties`](crate::model::VpcConnectionProperties)
    pub fn builder() -> crate::model::vpc_connection_properties::Builder {
        crate::model::vpc_connection_properties::Builder::default()
    }
}

/// <p>Data source credentials. This is a variant type structure. For this structure to be
/// valid, only one of the attributes can be non-null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceCredentials {
    /// <p>Credential pair. For more information, see <a>CredentialPair</a>.</p>
    pub credential_pair: std::option::Option<crate::model::CredentialPair>,
    /// <p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you
    /// want to use. When <code>CopySourceArn</code> is not null, the credential pair from the
    /// data source in the ARN is used as the credentials for the
    /// <code>DataSourceCredentials</code> structure.</p>
    pub copy_source_arn: std::option::Option<std::string::String>,
}
impl DataSourceCredentials {
    /// <p>Credential pair. For more information, see <a>CredentialPair</a>.</p>
    pub fn credential_pair(&self) -> std::option::Option<&crate::model::CredentialPair> {
        self.credential_pair.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you
    /// want to use. When <code>CopySourceArn</code> is not null, the credential pair from the
    /// data source in the ARN is used as the credentials for the
    /// <code>DataSourceCredentials</code> structure.</p>
    pub fn copy_source_arn(&self) -> std::option::Option<&str> {
        self.copy_source_arn.as_deref()
    }
}
impl std::fmt::Debug for DataSourceCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceCredentials");
        formatter.field("credential_pair", &self.credential_pair);
        formatter.field("copy_source_arn", &self.copy_source_arn);
        formatter.finish()
    }
}
/// See [`DataSourceCredentials`](crate::model::DataSourceCredentials)
pub mod data_source_credentials {
    /// A builder for [`DataSourceCredentials`](crate::model::DataSourceCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credential_pair: std::option::Option<crate::model::CredentialPair>,
        pub(crate) copy_source_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Credential pair. For more information, see <a>CredentialPair</a>.</p>
        pub fn credential_pair(mut self, input: crate::model::CredentialPair) -> Self {
            self.credential_pair = Some(input);
            self
        }
        /// <p>Credential pair. For more information, see <a>CredentialPair</a>.</p>
        pub fn set_credential_pair(
            mut self,
            input: std::option::Option<crate::model::CredentialPair>,
        ) -> Self {
            self.credential_pair = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you
        /// want to use. When <code>CopySourceArn</code> is not null, the credential pair from the
        /// data source in the ARN is used as the credentials for the
        /// <code>DataSourceCredentials</code> structure.</p>
        pub fn copy_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you
        /// want to use. When <code>CopySourceArn</code> is not null, the credential pair from the
        /// data source in the ARN is used as the credentials for the
        /// <code>DataSourceCredentials</code> structure.</p>
        pub fn set_copy_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceCredentials`](crate::model::DataSourceCredentials)
        pub fn build(self) -> crate::model::DataSourceCredentials {
            crate::model::DataSourceCredentials {
                credential_pair: self.credential_pair,
                copy_source_arn: self.copy_source_arn,
            }
        }
    }
}
impl DataSourceCredentials {
    /// Creates a new builder-style object to manufacture [`DataSourceCredentials`](crate::model::DataSourceCredentials)
    pub fn builder() -> crate::model::data_source_credentials::Builder {
        crate::model::data_source_credentials::Builder::default()
    }
}

/// <p>The combination of user name and password that are used as credentials.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CredentialPair {
    /// <p>User name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>Password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>A set of alternate data source parameters that you want to share for these
    /// credentials. The credentials are applied in tandem with the data source parameters when
    /// you copy a data source by using a create or update request. The API operation compares
    /// the <code>DataSourceParameters</code> structure that's in the request with the
    /// structures in the <code>AlternateDataSourceParameters</code> allow list. If the
    /// structures are an exact match, the request is allowed to use the new data source with
    /// the existing credentials. If the <code>AlternateDataSourceParameters</code> list is
    /// null, the <code>DataSourceParameters</code> originally used with these
    /// <code>Credentials</code> is automatically allowed.</p>
    pub alternate_data_source_parameters:
        std::option::Option<std::vec::Vec<crate::model::DataSourceParameters>>,
}
impl CredentialPair {
    /// <p>User name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>Password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>A set of alternate data source parameters that you want to share for these
    /// credentials. The credentials are applied in tandem with the data source parameters when
    /// you copy a data source by using a create or update request. The API operation compares
    /// the <code>DataSourceParameters</code> structure that's in the request with the
    /// structures in the <code>AlternateDataSourceParameters</code> allow list. If the
    /// structures are an exact match, the request is allowed to use the new data source with
    /// the existing credentials. If the <code>AlternateDataSourceParameters</code> list is
    /// null, the <code>DataSourceParameters</code> originally used with these
    /// <code>Credentials</code> is automatically allowed.</p>
    pub fn alternate_data_source_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceParameters]> {
        self.alternate_data_source_parameters.as_deref()
    }
}
impl std::fmt::Debug for CredentialPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CredentialPair");
        formatter.field("username", &self.username);
        formatter.field("password", &self.password);
        formatter.field(
            "alternate_data_source_parameters",
            &self.alternate_data_source_parameters,
        );
        formatter.finish()
    }
}
/// See [`CredentialPair`](crate::model::CredentialPair)
pub mod credential_pair {
    /// A builder for [`CredentialPair`](crate::model::CredentialPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) alternate_data_source_parameters:
            std::option::Option<std::vec::Vec<crate::model::DataSourceParameters>>,
    }
    impl Builder {
        /// <p>User name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>User name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>Password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Appends an item to `alternate_data_source_parameters`.
        ///
        /// To override the contents of this collection use [`set_alternate_data_source_parameters`](Self::set_alternate_data_source_parameters).
        ///
        /// <p>A set of alternate data source parameters that you want to share for these
        /// credentials. The credentials are applied in tandem with the data source parameters when
        /// you copy a data source by using a create or update request. The API operation compares
        /// the <code>DataSourceParameters</code> structure that's in the request with the
        /// structures in the <code>AlternateDataSourceParameters</code> allow list. If the
        /// structures are an exact match, the request is allowed to use the new data source with
        /// the existing credentials. If the <code>AlternateDataSourceParameters</code> list is
        /// null, the <code>DataSourceParameters</code> originally used with these
        /// <code>Credentials</code> is automatically allowed.</p>
        pub fn alternate_data_source_parameters(
            mut self,
            input: impl Into<crate::model::DataSourceParameters>,
        ) -> Self {
            let mut v = self.alternate_data_source_parameters.unwrap_or_default();
            v.push(input.into());
            self.alternate_data_source_parameters = Some(v);
            self
        }
        /// <p>A set of alternate data source parameters that you want to share for these
        /// credentials. The credentials are applied in tandem with the data source parameters when
        /// you copy a data source by using a create or update request. The API operation compares
        /// the <code>DataSourceParameters</code> structure that's in the request with the
        /// structures in the <code>AlternateDataSourceParameters</code> allow list. If the
        /// structures are an exact match, the request is allowed to use the new data source with
        /// the existing credentials. If the <code>AlternateDataSourceParameters</code> list is
        /// null, the <code>DataSourceParameters</code> originally used with these
        /// <code>Credentials</code> is automatically allowed.</p>
        pub fn set_alternate_data_source_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceParameters>>,
        ) -> Self {
            self.alternate_data_source_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CredentialPair`](crate::model::CredentialPair)
        pub fn build(self) -> crate::model::CredentialPair {
            crate::model::CredentialPair {
                username: self.username,
                password: self.password,
                alternate_data_source_parameters: self.alternate_data_source_parameters,
            }
        }
    }
}
impl CredentialPair {
    /// Creates a new builder-style object to manufacture [`CredentialPair`](crate::model::CredentialPair)
    pub fn builder() -> crate::model::credential_pair::Builder {
        crate::model::credential_pair::Builder::default()
    }
}

/// <p>The parameters that Amazon QuickSight uses to connect to your underlying data source.
/// This is a variant type structure. For this structure to be valid, only one of the
/// attributes can be non-null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum DataSourceParameters {
    /// <p>The parameters for OpenSearch.</p>
    AmazonElasticsearchParameters(crate::model::AmazonElasticsearchParameters),
    #[allow(missing_docs)] // documentation missing in model
    AmazonOpenSearchParameters(crate::model::AmazonOpenSearchParameters),
    /// <p>The parameters for Amazon Athena.</p>
    AthenaParameters(crate::model::AthenaParameters),
    /// <p>The parameters for Amazon Aurora MySQL.</p>
    AuroraParameters(crate::model::AuroraParameters),
    /// <p>The parameters for Amazon Aurora.</p>
    AuroraPostgreSqlParameters(crate::model::AuroraPostgreSqlParameters),
    /// <p>The parameters for IoT Analytics.</p>
    AwsIotAnalyticsParameters(crate::model::AwsIotAnalyticsParameters),
    /// <p>The parameters for Jira.</p>
    JiraParameters(crate::model::JiraParameters),
    /// <p>The parameters for MariaDB.</p>
    MariaDbParameters(crate::model::MariaDbParameters),
    /// <p>The parameters for MySQL.</p>
    MySqlParameters(crate::model::MySqlParameters),
    /// <p>The parameters for Oracle.</p>
    OracleParameters(crate::model::OracleParameters),
    /// <p>The parameters for PostgreSQL.</p>
    PostgreSqlParameters(crate::model::PostgreSqlParameters),
    /// <p>The parameters for Presto.</p>
    PrestoParameters(crate::model::PrestoParameters),
    /// <p>The parameters for Amazon RDS.</p>
    RdsParameters(crate::model::RdsParameters),
    /// <p>The parameters for Amazon Redshift.</p>
    RedshiftParameters(crate::model::RedshiftParameters),
    /// <p>The parameters for S3.</p>
    S3Parameters(crate::model::S3Parameters),
    /// <p>The parameters for ServiceNow.</p>
    ServiceNowParameters(crate::model::ServiceNowParameters),
    /// <p>The parameters for Snowflake.</p>
    SnowflakeParameters(crate::model::SnowflakeParameters),
    /// <p>The parameters for Spark.</p>
    SparkParameters(crate::model::SparkParameters),
    /// <p>The parameters for SQL Server.</p>
    SqlServerParameters(crate::model::SqlServerParameters),
    /// <p>The parameters for Teradata.</p>
    TeradataParameters(crate::model::TeradataParameters),
    /// <p>The parameters for Twitter.</p>
    TwitterParameters(crate::model::TwitterParameters),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl DataSourceParameters {
    /// Tries to convert the enum instance into [`AmazonElasticsearchParameters`](crate::model::DataSourceParameters::AmazonElasticsearchParameters), extracting the inner [`AmazonElasticsearchParameters`](crate::model::AmazonElasticsearchParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_amazon_elasticsearch_parameters(
        &self,
    ) -> std::result::Result<&crate::model::AmazonElasticsearchParameters, &Self> {
        if let DataSourceParameters::AmazonElasticsearchParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AmazonElasticsearchParameters`](crate::model::DataSourceParameters::AmazonElasticsearchParameters).
    pub fn is_amazon_elasticsearch_parameters(&self) -> bool {
        self.as_amazon_elasticsearch_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`AmazonOpenSearchParameters`](crate::model::DataSourceParameters::AmazonOpenSearchParameters), extracting the inner [`AmazonOpenSearchParameters`](crate::model::AmazonOpenSearchParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_amazon_open_search_parameters(
        &self,
    ) -> std::result::Result<&crate::model::AmazonOpenSearchParameters, &Self> {
        if let DataSourceParameters::AmazonOpenSearchParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AmazonOpenSearchParameters`](crate::model::DataSourceParameters::AmazonOpenSearchParameters).
    pub fn is_amazon_open_search_parameters(&self) -> bool {
        self.as_amazon_open_search_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`AthenaParameters`](crate::model::DataSourceParameters::AthenaParameters), extracting the inner [`AthenaParameters`](crate::model::AthenaParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_athena_parameters(
        &self,
    ) -> std::result::Result<&crate::model::AthenaParameters, &Self> {
        if let DataSourceParameters::AthenaParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AthenaParameters`](crate::model::DataSourceParameters::AthenaParameters).
    pub fn is_athena_parameters(&self) -> bool {
        self.as_athena_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`AuroraParameters`](crate::model::DataSourceParameters::AuroraParameters), extracting the inner [`AuroraParameters`](crate::model::AuroraParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aurora_parameters(
        &self,
    ) -> std::result::Result<&crate::model::AuroraParameters, &Self> {
        if let DataSourceParameters::AuroraParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AuroraParameters`](crate::model::DataSourceParameters::AuroraParameters).
    pub fn is_aurora_parameters(&self) -> bool {
        self.as_aurora_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`AuroraPostgreSqlParameters`](crate::model::DataSourceParameters::AuroraPostgreSqlParameters), extracting the inner [`AuroraPostgreSqlParameters`](crate::model::AuroraPostgreSqlParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aurora_postgre_sql_parameters(
        &self,
    ) -> std::result::Result<&crate::model::AuroraPostgreSqlParameters, &Self> {
        if let DataSourceParameters::AuroraPostgreSqlParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AuroraPostgreSqlParameters`](crate::model::DataSourceParameters::AuroraPostgreSqlParameters).
    pub fn is_aurora_postgre_sql_parameters(&self) -> bool {
        self.as_aurora_postgre_sql_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`AwsIotAnalyticsParameters`](crate::model::DataSourceParameters::AwsIotAnalyticsParameters), extracting the inner [`AwsIotAnalyticsParameters`](crate::model::AwsIotAnalyticsParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aws_iot_analytics_parameters(
        &self,
    ) -> std::result::Result<&crate::model::AwsIotAnalyticsParameters, &Self> {
        if let DataSourceParameters::AwsIotAnalyticsParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AwsIotAnalyticsParameters`](crate::model::DataSourceParameters::AwsIotAnalyticsParameters).
    pub fn is_aws_iot_analytics_parameters(&self) -> bool {
        self.as_aws_iot_analytics_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`JiraParameters`](crate::model::DataSourceParameters::JiraParameters), extracting the inner [`JiraParameters`](crate::model::JiraParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_jira_parameters(&self) -> std::result::Result<&crate::model::JiraParameters, &Self> {
        if let DataSourceParameters::JiraParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`JiraParameters`](crate::model::DataSourceParameters::JiraParameters).
    pub fn is_jira_parameters(&self) -> bool {
        self.as_jira_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`MariaDbParameters`](crate::model::DataSourceParameters::MariaDbParameters), extracting the inner [`MariaDbParameters`](crate::model::MariaDbParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_maria_db_parameters(
        &self,
    ) -> std::result::Result<&crate::model::MariaDbParameters, &Self> {
        if let DataSourceParameters::MariaDbParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`MariaDbParameters`](crate::model::DataSourceParameters::MariaDbParameters).
    pub fn is_maria_db_parameters(&self) -> bool {
        self.as_maria_db_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`MySqlParameters`](crate::model::DataSourceParameters::MySqlParameters), extracting the inner [`MySqlParameters`](crate::model::MySqlParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_my_sql_parameters(
        &self,
    ) -> std::result::Result<&crate::model::MySqlParameters, &Self> {
        if let DataSourceParameters::MySqlParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`MySqlParameters`](crate::model::DataSourceParameters::MySqlParameters).
    pub fn is_my_sql_parameters(&self) -> bool {
        self.as_my_sql_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`OracleParameters`](crate::model::DataSourceParameters::OracleParameters), extracting the inner [`OracleParameters`](crate::model::OracleParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_oracle_parameters(
        &self,
    ) -> std::result::Result<&crate::model::OracleParameters, &Self> {
        if let DataSourceParameters::OracleParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`OracleParameters`](crate::model::DataSourceParameters::OracleParameters).
    pub fn is_oracle_parameters(&self) -> bool {
        self.as_oracle_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`PostgreSqlParameters`](crate::model::DataSourceParameters::PostgreSqlParameters), extracting the inner [`PostgreSqlParameters`](crate::model::PostgreSqlParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_postgre_sql_parameters(
        &self,
    ) -> std::result::Result<&crate::model::PostgreSqlParameters, &Self> {
        if let DataSourceParameters::PostgreSqlParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`PostgreSqlParameters`](crate::model::DataSourceParameters::PostgreSqlParameters).
    pub fn is_postgre_sql_parameters(&self) -> bool {
        self.as_postgre_sql_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`PrestoParameters`](crate::model::DataSourceParameters::PrestoParameters), extracting the inner [`PrestoParameters`](crate::model::PrestoParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_presto_parameters(
        &self,
    ) -> std::result::Result<&crate::model::PrestoParameters, &Self> {
        if let DataSourceParameters::PrestoParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`PrestoParameters`](crate::model::DataSourceParameters::PrestoParameters).
    pub fn is_presto_parameters(&self) -> bool {
        self.as_presto_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`RdsParameters`](crate::model::DataSourceParameters::RdsParameters), extracting the inner [`RdsParameters`](crate::model::RdsParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_rds_parameters(&self) -> std::result::Result<&crate::model::RdsParameters, &Self> {
        if let DataSourceParameters::RdsParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`RdsParameters`](crate::model::DataSourceParameters::RdsParameters).
    pub fn is_rds_parameters(&self) -> bool {
        self.as_rds_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`RedshiftParameters`](crate::model::DataSourceParameters::RedshiftParameters), extracting the inner [`RedshiftParameters`](crate::model::RedshiftParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_redshift_parameters(
        &self,
    ) -> std::result::Result<&crate::model::RedshiftParameters, &Self> {
        if let DataSourceParameters::RedshiftParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`RedshiftParameters`](crate::model::DataSourceParameters::RedshiftParameters).
    pub fn is_redshift_parameters(&self) -> bool {
        self.as_redshift_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`S3Parameters`](crate::model::DataSourceParameters::S3Parameters), extracting the inner [`S3Parameters`](crate::model::S3Parameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_parameters(&self) -> std::result::Result<&crate::model::S3Parameters, &Self> {
        if let DataSourceParameters::S3Parameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`S3Parameters`](crate::model::DataSourceParameters::S3Parameters).
    pub fn is_s3_parameters(&self) -> bool {
        self.as_s3_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`ServiceNowParameters`](crate::model::DataSourceParameters::ServiceNowParameters), extracting the inner [`ServiceNowParameters`](crate::model::ServiceNowParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_service_now_parameters(
        &self,
    ) -> std::result::Result<&crate::model::ServiceNowParameters, &Self> {
        if let DataSourceParameters::ServiceNowParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ServiceNowParameters`](crate::model::DataSourceParameters::ServiceNowParameters).
    pub fn is_service_now_parameters(&self) -> bool {
        self.as_service_now_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`SnowflakeParameters`](crate::model::DataSourceParameters::SnowflakeParameters), extracting the inner [`SnowflakeParameters`](crate::model::SnowflakeParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_snowflake_parameters(
        &self,
    ) -> std::result::Result<&crate::model::SnowflakeParameters, &Self> {
        if let DataSourceParameters::SnowflakeParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SnowflakeParameters`](crate::model::DataSourceParameters::SnowflakeParameters).
    pub fn is_snowflake_parameters(&self) -> bool {
        self.as_snowflake_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`SparkParameters`](crate::model::DataSourceParameters::SparkParameters), extracting the inner [`SparkParameters`](crate::model::SparkParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_spark_parameters(
        &self,
    ) -> std::result::Result<&crate::model::SparkParameters, &Self> {
        if let DataSourceParameters::SparkParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SparkParameters`](crate::model::DataSourceParameters::SparkParameters).
    pub fn is_spark_parameters(&self) -> bool {
        self.as_spark_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`SqlServerParameters`](crate::model::DataSourceParameters::SqlServerParameters), extracting the inner [`SqlServerParameters`](crate::model::SqlServerParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_sql_server_parameters(
        &self,
    ) -> std::result::Result<&crate::model::SqlServerParameters, &Self> {
        if let DataSourceParameters::SqlServerParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`SqlServerParameters`](crate::model::DataSourceParameters::SqlServerParameters).
    pub fn is_sql_server_parameters(&self) -> bool {
        self.as_sql_server_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`TeradataParameters`](crate::model::DataSourceParameters::TeradataParameters), extracting the inner [`TeradataParameters`](crate::model::TeradataParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_teradata_parameters(
        &self,
    ) -> std::result::Result<&crate::model::TeradataParameters, &Self> {
        if let DataSourceParameters::TeradataParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`TeradataParameters`](crate::model::DataSourceParameters::TeradataParameters).
    pub fn is_teradata_parameters(&self) -> bool {
        self.as_teradata_parameters().is_ok()
    }
    /// Tries to convert the enum instance into [`TwitterParameters`](crate::model::DataSourceParameters::TwitterParameters), extracting the inner [`TwitterParameters`](crate::model::TwitterParameters).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_twitter_parameters(
        &self,
    ) -> std::result::Result<&crate::model::TwitterParameters, &Self> {
        if let DataSourceParameters::TwitterParameters(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`TwitterParameters`](crate::model::DataSourceParameters::TwitterParameters).
    pub fn is_twitter_parameters(&self) -> bool {
        self.as_twitter_parameters().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonOpenSearchParameters {
    #[allow(missing_docs)] // documentation missing in model
    pub domain: std::option::Option<std::string::String>,
}
impl AmazonOpenSearchParameters {
    #[allow(missing_docs)] // documentation missing in model
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
}
impl std::fmt::Debug for AmazonOpenSearchParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonOpenSearchParameters");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`AmazonOpenSearchParameters`](crate::model::AmazonOpenSearchParameters)
pub mod amazon_open_search_parameters {
    /// A builder for [`AmazonOpenSearchParameters`](crate::model::AmazonOpenSearchParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonOpenSearchParameters`](crate::model::AmazonOpenSearchParameters)
        pub fn build(self) -> crate::model::AmazonOpenSearchParameters {
            crate::model::AmazonOpenSearchParameters {
                domain: self.domain,
            }
        }
    }
}
impl AmazonOpenSearchParameters {
    /// Creates a new builder-style object to manufacture [`AmazonOpenSearchParameters`](crate::model::AmazonOpenSearchParameters)
    pub fn builder() -> crate::model::amazon_open_search_parameters::Builder {
        crate::model::amazon_open_search_parameters::Builder::default()
    }
}

/// <p>The parameters for Twitter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TwitterParameters {
    /// <p>Twitter query string.</p>
    pub query: std::option::Option<std::string::String>,
    /// <p>Maximum number of rows to query Twitter.</p>
    pub max_rows: i32,
}
impl TwitterParameters {
    /// <p>Twitter query string.</p>
    pub fn query(&self) -> std::option::Option<&str> {
        self.query.as_deref()
    }
    /// <p>Maximum number of rows to query Twitter.</p>
    pub fn max_rows(&self) -> i32 {
        self.max_rows
    }
}
impl std::fmt::Debug for TwitterParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TwitterParameters");
        formatter.field("query", &self.query);
        formatter.field("max_rows", &self.max_rows);
        formatter.finish()
    }
}
/// See [`TwitterParameters`](crate::model::TwitterParameters)
pub mod twitter_parameters {
    /// A builder for [`TwitterParameters`](crate::model::TwitterParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query: std::option::Option<std::string::String>,
        pub(crate) max_rows: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Twitter query string.</p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.query = Some(input.into());
            self
        }
        /// <p>Twitter query string.</p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query = input;
            self
        }
        /// <p>Maximum number of rows to query Twitter.</p>
        pub fn max_rows(mut self, input: i32) -> Self {
            self.max_rows = Some(input);
            self
        }
        /// <p>Maximum number of rows to query Twitter.</p>
        pub fn set_max_rows(mut self, input: std::option::Option<i32>) -> Self {
            self.max_rows = input;
            self
        }
        /// Consumes the builder and constructs a [`TwitterParameters`](crate::model::TwitterParameters)
        pub fn build(self) -> crate::model::TwitterParameters {
            crate::model::TwitterParameters {
                query: self.query,
                max_rows: self.max_rows.unwrap_or_default(),
            }
        }
    }
}
impl TwitterParameters {
    /// Creates a new builder-style object to manufacture [`TwitterParameters`](crate::model::TwitterParameters)
    pub fn builder() -> crate::model::twitter_parameters::Builder {
        crate::model::twitter_parameters::Builder::default()
    }
}

/// <p>The parameters for Teradata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TeradataParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl TeradataParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for TeradataParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TeradataParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`TeradataParameters`](crate::model::TeradataParameters)
pub mod teradata_parameters {
    /// A builder for [`TeradataParameters`](crate::model::TeradataParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`TeradataParameters`](crate::model::TeradataParameters)
        pub fn build(self) -> crate::model::TeradataParameters {
            crate::model::TeradataParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl TeradataParameters {
    /// Creates a new builder-style object to manufacture [`TeradataParameters`](crate::model::TeradataParameters)
    pub fn builder() -> crate::model::teradata_parameters::Builder {
        crate::model::teradata_parameters::Builder::default()
    }
}

/// <p>The parameters for SQL Server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlServerParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl SqlServerParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for SqlServerParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlServerParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`SqlServerParameters`](crate::model::SqlServerParameters)
pub mod sql_server_parameters {
    /// A builder for [`SqlServerParameters`](crate::model::SqlServerParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlServerParameters`](crate::model::SqlServerParameters)
        pub fn build(self) -> crate::model::SqlServerParameters {
            crate::model::SqlServerParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl SqlServerParameters {
    /// Creates a new builder-style object to manufacture [`SqlServerParameters`](crate::model::SqlServerParameters)
    pub fn builder() -> crate::model::sql_server_parameters::Builder {
        crate::model::sql_server_parameters::Builder::default()
    }
}

/// <p>The parameters for Spark.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SparkParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
}
impl SparkParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
}
impl std::fmt::Debug for SparkParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SparkParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`SparkParameters`](crate::model::SparkParameters)
pub mod spark_parameters {
    /// A builder for [`SparkParameters`](crate::model::SparkParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`SparkParameters`](crate::model::SparkParameters)
        pub fn build(self) -> crate::model::SparkParameters {
            crate::model::SparkParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
            }
        }
    }
}
impl SparkParameters {
    /// Creates a new builder-style object to manufacture [`SparkParameters`](crate::model::SparkParameters)
    pub fn builder() -> crate::model::spark_parameters::Builder {
        crate::model::spark_parameters::Builder::default()
    }
}

/// <p>The parameters for Snowflake.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnowflakeParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>Warehouse.</p>
    pub warehouse: std::option::Option<std::string::String>,
}
impl SnowflakeParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>Warehouse.</p>
    pub fn warehouse(&self) -> std::option::Option<&str> {
        self.warehouse.as_deref()
    }
}
impl std::fmt::Debug for SnowflakeParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnowflakeParameters");
        formatter.field("host", &self.host);
        formatter.field("database", &self.database);
        formatter.field("warehouse", &self.warehouse);
        formatter.finish()
    }
}
/// See [`SnowflakeParameters`](crate::model::SnowflakeParameters)
pub mod snowflake_parameters {
    /// A builder for [`SnowflakeParameters`](crate::model::SnowflakeParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) warehouse: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>Warehouse.</p>
        pub fn warehouse(mut self, input: impl Into<std::string::String>) -> Self {
            self.warehouse = Some(input.into());
            self
        }
        /// <p>Warehouse.</p>
        pub fn set_warehouse(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.warehouse = input;
            self
        }
        /// Consumes the builder and constructs a [`SnowflakeParameters`](crate::model::SnowflakeParameters)
        pub fn build(self) -> crate::model::SnowflakeParameters {
            crate::model::SnowflakeParameters {
                host: self.host,
                database: self.database,
                warehouse: self.warehouse,
            }
        }
    }
}
impl SnowflakeParameters {
    /// Creates a new builder-style object to manufacture [`SnowflakeParameters`](crate::model::SnowflakeParameters)
    pub fn builder() -> crate::model::snowflake_parameters::Builder {
        crate::model::snowflake_parameters::Builder::default()
    }
}

/// <p>The parameters for ServiceNow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowParameters {
    /// <p>URL of the base site.</p>
    pub site_base_url: std::option::Option<std::string::String>,
}
impl ServiceNowParameters {
    /// <p>URL of the base site.</p>
    pub fn site_base_url(&self) -> std::option::Option<&str> {
        self.site_base_url.as_deref()
    }
}
impl std::fmt::Debug for ServiceNowParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowParameters");
        formatter.field("site_base_url", &self.site_base_url);
        formatter.finish()
    }
}
/// See [`ServiceNowParameters`](crate::model::ServiceNowParameters)
pub mod service_now_parameters {
    /// A builder for [`ServiceNowParameters`](crate::model::ServiceNowParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_base_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>URL of the base site.</p>
        pub fn site_base_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_base_url = Some(input.into());
            self
        }
        /// <p>URL of the base site.</p>
        pub fn set_site_base_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.site_base_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowParameters`](crate::model::ServiceNowParameters)
        pub fn build(self) -> crate::model::ServiceNowParameters {
            crate::model::ServiceNowParameters {
                site_base_url: self.site_base_url,
            }
        }
    }
}
impl ServiceNowParameters {
    /// Creates a new builder-style object to manufacture [`ServiceNowParameters`](crate::model::ServiceNowParameters)
    pub fn builder() -> crate::model::service_now_parameters::Builder {
        crate::model::service_now_parameters::Builder::default()
    }
}

/// <p>The parameters for S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Parameters {
    /// <p>Location of the Amazon S3 manifest file. This is NULL if the manifest file was
    /// uploaded into Amazon QuickSight.</p>
    pub manifest_file_location: std::option::Option<crate::model::ManifestFileLocation>,
}
impl S3Parameters {
    /// <p>Location of the Amazon S3 manifest file. This is NULL if the manifest file was
    /// uploaded into Amazon QuickSight.</p>
    pub fn manifest_file_location(
        &self,
    ) -> std::option::Option<&crate::model::ManifestFileLocation> {
        self.manifest_file_location.as_ref()
    }
}
impl std::fmt::Debug for S3Parameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Parameters");
        formatter.field("manifest_file_location", &self.manifest_file_location);
        formatter.finish()
    }
}
/// See [`S3Parameters`](crate::model::S3Parameters)
pub mod s3_parameters {
    /// A builder for [`S3Parameters`](crate::model::S3Parameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) manifest_file_location: std::option::Option<crate::model::ManifestFileLocation>,
    }
    impl Builder {
        /// <p>Location of the Amazon S3 manifest file. This is NULL if the manifest file was
        /// uploaded into Amazon QuickSight.</p>
        pub fn manifest_file_location(mut self, input: crate::model::ManifestFileLocation) -> Self {
            self.manifest_file_location = Some(input);
            self
        }
        /// <p>Location of the Amazon S3 manifest file. This is NULL if the manifest file was
        /// uploaded into Amazon QuickSight.</p>
        pub fn set_manifest_file_location(
            mut self,
            input: std::option::Option<crate::model::ManifestFileLocation>,
        ) -> Self {
            self.manifest_file_location = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Parameters`](crate::model::S3Parameters)
        pub fn build(self) -> crate::model::S3Parameters {
            crate::model::S3Parameters {
                manifest_file_location: self.manifest_file_location,
            }
        }
    }
}
impl S3Parameters {
    /// Creates a new builder-style object to manufacture [`S3Parameters`](crate::model::S3Parameters)
    pub fn builder() -> crate::model::s3_parameters::Builder {
        crate::model::s3_parameters::Builder::default()
    }
}

/// <p>Amazon S3 manifest file location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManifestFileLocation {
    /// <p>Amazon S3 bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Amazon S3 key that identifies an object.</p>
    pub key: std::option::Option<std::string::String>,
}
impl ManifestFileLocation {
    /// <p>Amazon S3 bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Amazon S3 key that identifies an object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for ManifestFileLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManifestFileLocation");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`ManifestFileLocation`](crate::model::ManifestFileLocation)
pub mod manifest_file_location {
    /// A builder for [`ManifestFileLocation`](crate::model::ManifestFileLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon S3 bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Amazon S3 bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Amazon S3 key that identifies an object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Amazon S3 key that identifies an object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`ManifestFileLocation`](crate::model::ManifestFileLocation)
        pub fn build(self) -> crate::model::ManifestFileLocation {
            crate::model::ManifestFileLocation {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl ManifestFileLocation {
    /// Creates a new builder-style object to manufacture [`ManifestFileLocation`](crate::model::ManifestFileLocation)
    pub fn builder() -> crate::model::manifest_file_location::Builder {
        crate::model::manifest_file_location::Builder::default()
    }
}

/// <p>The parameters for Amazon Redshift. The <code>ClusterId</code> field can be blank if
/// <code>Host</code> and <code>Port</code> are both set. The <code>Host</code> and
/// <code>Port</code> fields can be blank if the <code>ClusterId</code> field is set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftParameters {
    /// <p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are
    /// provided.</p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl RedshiftParameters {
    /// <p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are
    /// provided.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for RedshiftParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}
/// See [`RedshiftParameters`](crate::model::RedshiftParameters)
pub mod redshift_parameters {
    /// A builder for [`RedshiftParameters`](crate::model::RedshiftParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are
        /// provided.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are
        /// provided.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftParameters`](crate::model::RedshiftParameters)
        pub fn build(self) -> crate::model::RedshiftParameters {
            crate::model::RedshiftParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
                cluster_id: self.cluster_id,
            }
        }
    }
}
impl RedshiftParameters {
    /// Creates a new builder-style object to manufacture [`RedshiftParameters`](crate::model::RedshiftParameters)
    pub fn builder() -> crate::model::redshift_parameters::Builder {
        crate::model::redshift_parameters::Builder::default()
    }
}

/// <p>The parameters for Amazon RDS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RdsParameters {
    /// <p>Instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl RdsParameters {
    /// <p>Instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for RdsParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RdsParameters");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`RdsParameters`](crate::model::RdsParameters)
pub mod rds_parameters {
    /// A builder for [`RdsParameters`](crate::model::RdsParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>Instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`RdsParameters`](crate::model::RdsParameters)
        pub fn build(self) -> crate::model::RdsParameters {
            crate::model::RdsParameters {
                instance_id: self.instance_id,
                database: self.database,
            }
        }
    }
}
impl RdsParameters {
    /// Creates a new builder-style object to manufacture [`RdsParameters`](crate::model::RdsParameters)
    pub fn builder() -> crate::model::rds_parameters::Builder {
        crate::model::rds_parameters::Builder::default()
    }
}

/// <p>The parameters for Presto.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrestoParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Catalog.</p>
    pub catalog: std::option::Option<std::string::String>,
}
impl PrestoParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Catalog.</p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
}
impl std::fmt::Debug for PrestoParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrestoParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("catalog", &self.catalog);
        formatter.finish()
    }
}
/// See [`PrestoParameters`](crate::model::PrestoParameters)
pub mod presto_parameters {
    /// A builder for [`PrestoParameters`](crate::model::PrestoParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) catalog: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Catalog.</p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>Catalog.</p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// Consumes the builder and constructs a [`PrestoParameters`](crate::model::PrestoParameters)
        pub fn build(self) -> crate::model::PrestoParameters {
            crate::model::PrestoParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                catalog: self.catalog,
            }
        }
    }
}
impl PrestoParameters {
    /// Creates a new builder-style object to manufacture [`PrestoParameters`](crate::model::PrestoParameters)
    pub fn builder() -> crate::model::presto_parameters::Builder {
        crate::model::presto_parameters::Builder::default()
    }
}

/// <p>The parameters for PostgreSQL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostgreSqlParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl PostgreSqlParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for PostgreSqlParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostgreSqlParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`PostgreSqlParameters`](crate::model::PostgreSqlParameters)
pub mod postgre_sql_parameters {
    /// A builder for [`PostgreSqlParameters`](crate::model::PostgreSqlParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`PostgreSqlParameters`](crate::model::PostgreSqlParameters)
        pub fn build(self) -> crate::model::PostgreSqlParameters {
            crate::model::PostgreSqlParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl PostgreSqlParameters {
    /// Creates a new builder-style object to manufacture [`PostgreSqlParameters`](crate::model::PostgreSqlParameters)
    pub fn builder() -> crate::model::postgre_sql_parameters::Builder {
        crate::model::postgre_sql_parameters::Builder::default()
    }
}

/// <p>The parameters for Oracle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OracleParameters {
    /// <p>An Oracle host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl OracleParameters {
    /// <p>An Oracle host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for OracleParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OracleParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`OracleParameters`](crate::model::OracleParameters)
pub mod oracle_parameters {
    /// A builder for [`OracleParameters`](crate::model::OracleParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Oracle host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>An Oracle host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`OracleParameters`](crate::model::OracleParameters)
        pub fn build(self) -> crate::model::OracleParameters {
            crate::model::OracleParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl OracleParameters {
    /// Creates a new builder-style object to manufacture [`OracleParameters`](crate::model::OracleParameters)
    pub fn builder() -> crate::model::oracle_parameters::Builder {
        crate::model::oracle_parameters::Builder::default()
    }
}

/// <p>The parameters for MySQL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MySqlParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl MySqlParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for MySqlParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MySqlParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`MySqlParameters`](crate::model::MySqlParameters)
pub mod my_sql_parameters {
    /// A builder for [`MySqlParameters`](crate::model::MySqlParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`MySqlParameters`](crate::model::MySqlParameters)
        pub fn build(self) -> crate::model::MySqlParameters {
            crate::model::MySqlParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl MySqlParameters {
    /// Creates a new builder-style object to manufacture [`MySqlParameters`](crate::model::MySqlParameters)
    pub fn builder() -> crate::model::my_sql_parameters::Builder {
        crate::model::my_sql_parameters::Builder::default()
    }
}

/// <p>The parameters for MariaDB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MariaDbParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl MariaDbParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for MariaDbParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MariaDbParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`MariaDbParameters`](crate::model::MariaDbParameters)
pub mod maria_db_parameters {
    /// A builder for [`MariaDbParameters`](crate::model::MariaDbParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`MariaDbParameters`](crate::model::MariaDbParameters)
        pub fn build(self) -> crate::model::MariaDbParameters {
            crate::model::MariaDbParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl MariaDbParameters {
    /// Creates a new builder-style object to manufacture [`MariaDbParameters`](crate::model::MariaDbParameters)
    pub fn builder() -> crate::model::maria_db_parameters::Builder {
        crate::model::maria_db_parameters::Builder::default()
    }
}

/// <p>The parameters for Jira.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JiraParameters {
    /// <p>The base URL of the Jira site.</p>
    pub site_base_url: std::option::Option<std::string::String>,
}
impl JiraParameters {
    /// <p>The base URL of the Jira site.</p>
    pub fn site_base_url(&self) -> std::option::Option<&str> {
        self.site_base_url.as_deref()
    }
}
impl std::fmt::Debug for JiraParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JiraParameters");
        formatter.field("site_base_url", &self.site_base_url);
        formatter.finish()
    }
}
/// See [`JiraParameters`](crate::model::JiraParameters)
pub mod jira_parameters {
    /// A builder for [`JiraParameters`](crate::model::JiraParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) site_base_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The base URL of the Jira site.</p>
        pub fn site_base_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.site_base_url = Some(input.into());
            self
        }
        /// <p>The base URL of the Jira site.</p>
        pub fn set_site_base_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.site_base_url = input;
            self
        }
        /// Consumes the builder and constructs a [`JiraParameters`](crate::model::JiraParameters)
        pub fn build(self) -> crate::model::JiraParameters {
            crate::model::JiraParameters {
                site_base_url: self.site_base_url,
            }
        }
    }
}
impl JiraParameters {
    /// Creates a new builder-style object to manufacture [`JiraParameters`](crate::model::JiraParameters)
    pub fn builder() -> crate::model::jira_parameters::Builder {
        crate::model::jira_parameters::Builder::default()
    }
}

/// <p>The parameters for IoT Analytics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsIotAnalyticsParameters {
    /// <p>Dataset name.</p>
    pub data_set_name: std::option::Option<std::string::String>,
}
impl AwsIotAnalyticsParameters {
    /// <p>Dataset name.</p>
    pub fn data_set_name(&self) -> std::option::Option<&str> {
        self.data_set_name.as_deref()
    }
}
impl std::fmt::Debug for AwsIotAnalyticsParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsIotAnalyticsParameters");
        formatter.field("data_set_name", &self.data_set_name);
        formatter.finish()
    }
}
/// See [`AwsIotAnalyticsParameters`](crate::model::AwsIotAnalyticsParameters)
pub mod aws_iot_analytics_parameters {
    /// A builder for [`AwsIotAnalyticsParameters`](crate::model::AwsIotAnalyticsParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Dataset name.</p>
        pub fn data_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_name = Some(input.into());
            self
        }
        /// <p>Dataset name.</p>
        pub fn set_data_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsIotAnalyticsParameters`](crate::model::AwsIotAnalyticsParameters)
        pub fn build(self) -> crate::model::AwsIotAnalyticsParameters {
            crate::model::AwsIotAnalyticsParameters {
                data_set_name: self.data_set_name,
            }
        }
    }
}
impl AwsIotAnalyticsParameters {
    /// Creates a new builder-style object to manufacture [`AwsIotAnalyticsParameters`](crate::model::AwsIotAnalyticsParameters)
    pub fn builder() -> crate::model::aws_iot_analytics_parameters::Builder {
        crate::model::aws_iot_analytics_parameters::Builder::default()
    }
}

/// <p>Parameters for Amazon Aurora PostgreSQL-Compatible Edition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuroraPostgreSqlParameters {
    /// <p>The Amazon Aurora PostgreSQL-Compatible host to connect to.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>The port that Amazon Aurora PostgreSQL is listening on.</p>
    pub port: i32,
    /// <p>The Amazon Aurora PostgreSQL database to connect to.</p>
    pub database: std::option::Option<std::string::String>,
}
impl AuroraPostgreSqlParameters {
    /// <p>The Amazon Aurora PostgreSQL-Compatible host to connect to.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>The port that Amazon Aurora PostgreSQL is listening on.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The Amazon Aurora PostgreSQL database to connect to.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for AuroraPostgreSqlParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuroraPostgreSqlParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`AuroraPostgreSqlParameters`](crate::model::AuroraPostgreSqlParameters)
pub mod aurora_postgre_sql_parameters {
    /// A builder for [`AuroraPostgreSqlParameters`](crate::model::AuroraPostgreSqlParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Aurora PostgreSQL-Compatible host to connect to.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>The Amazon Aurora PostgreSQL-Compatible host to connect to.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>The port that Amazon Aurora PostgreSQL is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port that Amazon Aurora PostgreSQL is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The Amazon Aurora PostgreSQL database to connect to.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The Amazon Aurora PostgreSQL database to connect to.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`AuroraPostgreSqlParameters`](crate::model::AuroraPostgreSqlParameters)
        pub fn build(self) -> crate::model::AuroraPostgreSqlParameters {
            crate::model::AuroraPostgreSqlParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl AuroraPostgreSqlParameters {
    /// Creates a new builder-style object to manufacture [`AuroraPostgreSqlParameters`](crate::model::AuroraPostgreSqlParameters)
    pub fn builder() -> crate::model::aurora_postgre_sql_parameters::Builder {
        crate::model::aurora_postgre_sql_parameters::Builder::default()
    }
}

/// <p>Parameters for Amazon Aurora.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuroraParameters {
    /// <p>Host.</p>
    pub host: std::option::Option<std::string::String>,
    /// <p>Port.</p>
    pub port: i32,
    /// <p>Database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl AuroraParameters {
    /// <p>Host.</p>
    pub fn host(&self) -> std::option::Option<&str> {
        self.host.as_deref()
    }
    /// <p>Port.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for AuroraParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuroraParameters");
        formatter.field("host", &self.host);
        formatter.field("port", &self.port);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`AuroraParameters`](crate::model::AuroraParameters)
pub mod aurora_parameters {
    /// A builder for [`AuroraParameters`](crate::model::AuroraParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Host.</p>
        pub fn host(mut self, input: impl Into<std::string::String>) -> Self {
            self.host = Some(input.into());
            self
        }
        /// <p>Host.</p>
        pub fn set_host(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host = input;
            self
        }
        /// <p>Port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>Database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`AuroraParameters`](crate::model::AuroraParameters)
        pub fn build(self) -> crate::model::AuroraParameters {
            crate::model::AuroraParameters {
                host: self.host,
                port: self.port.unwrap_or_default(),
                database: self.database,
            }
        }
    }
}
impl AuroraParameters {
    /// Creates a new builder-style object to manufacture [`AuroraParameters`](crate::model::AuroraParameters)
    pub fn builder() -> crate::model::aurora_parameters::Builder {
        crate::model::aurora_parameters::Builder::default()
    }
}

/// <p>Parameters for Amazon Athena.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AthenaParameters {
    /// <p>The workgroup that Amazon Athena uses.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl AthenaParameters {
    /// <p>The workgroup that Amazon Athena uses.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for AthenaParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AthenaParameters");
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}
/// See [`AthenaParameters`](crate::model::AthenaParameters)
pub mod athena_parameters {
    /// A builder for [`AthenaParameters`](crate::model::AthenaParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The workgroup that Amazon Athena uses.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The workgroup that Amazon Athena uses.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`AthenaParameters`](crate::model::AthenaParameters)
        pub fn build(self) -> crate::model::AthenaParameters {
            crate::model::AthenaParameters {
                work_group: self.work_group,
            }
        }
    }
}
impl AthenaParameters {
    /// Creates a new builder-style object to manufacture [`AthenaParameters`](crate::model::AthenaParameters)
    pub fn builder() -> crate::model::athena_parameters::Builder {
        crate::model::athena_parameters::Builder::default()
    }
}

/// <p>The parameters for OpenSearch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmazonElasticsearchParameters {
    /// <p>The OpenSearch domain.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl AmazonElasticsearchParameters {
    /// <p>The OpenSearch domain.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
}
impl std::fmt::Debug for AmazonElasticsearchParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmazonElasticsearchParameters");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`AmazonElasticsearchParameters`](crate::model::AmazonElasticsearchParameters)
pub mod amazon_elasticsearch_parameters {
    /// A builder for [`AmazonElasticsearchParameters`](crate::model::AmazonElasticsearchParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The OpenSearch domain.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The OpenSearch domain.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`AmazonElasticsearchParameters`](crate::model::AmazonElasticsearchParameters)
        pub fn build(self) -> crate::model::AmazonElasticsearchParameters {
            crate::model::AmazonElasticsearchParameters {
                domain: self.domain,
            }
        }
    }
}
impl AmazonElasticsearchParameters {
    /// Creates a new builder-style object to manufacture [`AmazonElasticsearchParameters`](crate::model::AmazonElasticsearchParameters)
    pub fn builder() -> crate::model::amazon_elasticsearch_parameters::Builder {
        crate::model::amazon_elasticsearch_parameters::Builder::default()
    }
}

/// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSetUsageConfiguration {
    /// <p>An option that controls whether a child dataset of a direct query can use this dataset as a source.</p>
    pub disable_use_as_direct_query_source: bool,
    /// <p>An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.</p>
    pub disable_use_as_imported_source: bool,
}
impl DataSetUsageConfiguration {
    /// <p>An option that controls whether a child dataset of a direct query can use this dataset as a source.</p>
    pub fn disable_use_as_direct_query_source(&self) -> bool {
        self.disable_use_as_direct_query_source
    }
    /// <p>An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.</p>
    pub fn disable_use_as_imported_source(&self) -> bool {
        self.disable_use_as_imported_source
    }
}
impl std::fmt::Debug for DataSetUsageConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSetUsageConfiguration");
        formatter.field(
            "disable_use_as_direct_query_source",
            &self.disable_use_as_direct_query_source,
        );
        formatter.field(
            "disable_use_as_imported_source",
            &self.disable_use_as_imported_source,
        );
        formatter.finish()
    }
}
/// See [`DataSetUsageConfiguration`](crate::model::DataSetUsageConfiguration)
pub mod data_set_usage_configuration {
    /// A builder for [`DataSetUsageConfiguration`](crate::model::DataSetUsageConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disable_use_as_direct_query_source: std::option::Option<bool>,
        pub(crate) disable_use_as_imported_source: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An option that controls whether a child dataset of a direct query can use this dataset as a source.</p>
        pub fn disable_use_as_direct_query_source(mut self, input: bool) -> Self {
            self.disable_use_as_direct_query_source = Some(input);
            self
        }
        /// <p>An option that controls whether a child dataset of a direct query can use this dataset as a source.</p>
        pub fn set_disable_use_as_direct_query_source(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_use_as_direct_query_source = input;
            self
        }
        /// <p>An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.</p>
        pub fn disable_use_as_imported_source(mut self, input: bool) -> Self {
            self.disable_use_as_imported_source = Some(input);
            self
        }
        /// <p>An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.</p>
        pub fn set_disable_use_as_imported_source(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.disable_use_as_imported_source = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSetUsageConfiguration`](crate::model::DataSetUsageConfiguration)
        pub fn build(self) -> crate::model::DataSetUsageConfiguration {
            crate::model::DataSetUsageConfiguration {
                disable_use_as_direct_query_source: self
                    .disable_use_as_direct_query_source
                    .unwrap_or_default(),
                disable_use_as_imported_source: self
                    .disable_use_as_imported_source
                    .unwrap_or_default(),
            }
        }
    }
}
impl DataSetUsageConfiguration {
    /// Creates a new builder-style object to manufacture [`DataSetUsageConfiguration`](crate::model::DataSetUsageConfiguration)
    pub fn builder() -> crate::model::data_set_usage_configuration::Builder {
        crate::model::data_set_usage_configuration::Builder::default()
    }
}

/// <p>A rule defined to grant access on one or more restricted columns.
/// Each dataset can have multiple rules.
/// To create a restricted column, you add it to one or more rules.
/// Each rule must contain at least one column and at least one user or group.
/// To be able to see a restricted column, a user or group needs to be added
/// to a rule for that column.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnLevelPermissionRule {
    /// <p>An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.</p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of column names.</p>
    pub column_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ColumnLevelPermissionRule {
    /// <p>An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.</p>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>An array of column names.</p>
    pub fn column_names(&self) -> std::option::Option<&[std::string::String]> {
        self.column_names.as_deref()
    }
}
impl std::fmt::Debug for ColumnLevelPermissionRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnLevelPermissionRule");
        formatter.field("principals", &self.principals);
        formatter.field("column_names", &self.column_names);
        formatter.finish()
    }
}
/// See [`ColumnLevelPermissionRule`](crate::model::ColumnLevelPermissionRule)
pub mod column_level_permission_rule {
    /// A builder for [`ColumnLevelPermissionRule`](crate::model::ColumnLevelPermissionRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) column_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// Appends an item to `column_names`.
        ///
        /// To override the contents of this collection use [`set_column_names`](Self::set_column_names).
        ///
        /// <p>An array of column names.</p>
        pub fn column_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.column_names.unwrap_or_default();
            v.push(input.into());
            self.column_names = Some(v);
            self
        }
        /// <p>An array of column names.</p>
        pub fn set_column_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.column_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnLevelPermissionRule`](crate::model::ColumnLevelPermissionRule)
        pub fn build(self) -> crate::model::ColumnLevelPermissionRule {
            crate::model::ColumnLevelPermissionRule {
                principals: self.principals,
                column_names: self.column_names,
            }
        }
    }
}
impl ColumnLevelPermissionRule {
    /// Creates a new builder-style object to manufacture [`ColumnLevelPermissionRule`](crate::model::ColumnLevelPermissionRule)
    pub fn builder() -> crate::model::column_level_permission_rule::Builder {
        crate::model::column_level_permission_rule::Builder::default()
    }
}

/// <p>The configuration of tags on a dataset to set row-level security. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RowLevelPermissionTagConfiguration {
    /// <p>The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.</p>
    pub tag_rules: std::option::Option<std::vec::Vec<crate::model::RowLevelPermissionTagRule>>,
}
impl RowLevelPermissionTagConfiguration {
    /// <p>The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.</p>
    pub fn tag_rules(&self) -> std::option::Option<&[crate::model::RowLevelPermissionTagRule]> {
        self.tag_rules.as_deref()
    }
}
impl std::fmt::Debug for RowLevelPermissionTagConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RowLevelPermissionTagConfiguration");
        formatter.field("status", &self.status);
        formatter.field("tag_rules", &self.tag_rules);
        formatter.finish()
    }
}
/// See [`RowLevelPermissionTagConfiguration`](crate::model::RowLevelPermissionTagConfiguration)
pub mod row_level_permission_tag_configuration {
    /// A builder for [`RowLevelPermissionTagConfiguration`](crate::model::RowLevelPermissionTagConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) tag_rules:
            std::option::Option<std::vec::Vec<crate::model::RowLevelPermissionTagRule>>,
    }
    impl Builder {
        /// <p>The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `tag_rules`.
        ///
        /// To override the contents of this collection use [`set_tag_rules`](Self::set_tag_rules).
        ///
        /// <p>A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.</p>
        pub fn tag_rules(
            mut self,
            input: impl Into<crate::model::RowLevelPermissionTagRule>,
        ) -> Self {
            let mut v = self.tag_rules.unwrap_or_default();
            v.push(input.into());
            self.tag_rules = Some(v);
            self
        }
        /// <p>A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.</p>
        pub fn set_tag_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RowLevelPermissionTagRule>>,
        ) -> Self {
            self.tag_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`RowLevelPermissionTagConfiguration`](crate::model::RowLevelPermissionTagConfiguration)
        pub fn build(self) -> crate::model::RowLevelPermissionTagConfiguration {
            crate::model::RowLevelPermissionTagConfiguration {
                status: self.status,
                tag_rules: self.tag_rules,
            }
        }
    }
}
impl RowLevelPermissionTagConfiguration {
    /// Creates a new builder-style object to manufacture [`RowLevelPermissionTagConfiguration`](crate::model::RowLevelPermissionTagConfiguration)
    pub fn builder() -> crate::model::row_level_permission_tag_configuration::Builder {
        crate::model::row_level_permission_tag_configuration::Builder::default()
    }
}

/// <p>A set of rules associated with a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RowLevelPermissionTagRule {
    /// <p>The unique key for a tag.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>The column name that a tag key is assigned to.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>A string that you want to use to delimit the values when you pass the values at run time. For example, you can delimit the values with a comma.</p>
    pub tag_multi_value_delimiter: std::option::Option<std::string::String>,
    /// <p>A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one. For example, you can use an asterisk as your match all value.</p>
    pub match_all_value: std::option::Option<std::string::String>,
}
impl RowLevelPermissionTagRule {
    /// <p>The unique key for a tag.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>The column name that a tag key is assigned to.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>A string that you want to use to delimit the values when you pass the values at run time. For example, you can delimit the values with a comma.</p>
    pub fn tag_multi_value_delimiter(&self) -> std::option::Option<&str> {
        self.tag_multi_value_delimiter.as_deref()
    }
    /// <p>A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one. For example, you can use an asterisk as your match all value.</p>
    pub fn match_all_value(&self) -> std::option::Option<&str> {
        self.match_all_value.as_deref()
    }
}
impl std::fmt::Debug for RowLevelPermissionTagRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RowLevelPermissionTagRule");
        formatter.field("tag_key", &self.tag_key);
        formatter.field("column_name", &self.column_name);
        formatter.field("tag_multi_value_delimiter", &self.tag_multi_value_delimiter);
        formatter.field("match_all_value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`RowLevelPermissionTagRule`](crate::model::RowLevelPermissionTagRule)
pub mod row_level_permission_tag_rule {
    /// A builder for [`RowLevelPermissionTagRule`](crate::model::RowLevelPermissionTagRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) tag_multi_value_delimiter: std::option::Option<std::string::String>,
        pub(crate) match_all_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique key for a tag.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The unique key for a tag.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// <p>The column name that a tag key is assigned to.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The column name that a tag key is assigned to.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>A string that you want to use to delimit the values when you pass the values at run time. For example, you can delimit the values with a comma.</p>
        pub fn tag_multi_value_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_multi_value_delimiter = Some(input.into());
            self
        }
        /// <p>A string that you want to use to delimit the values when you pass the values at run time. For example, you can delimit the values with a comma.</p>
        pub fn set_tag_multi_value_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tag_multi_value_delimiter = input;
            self
        }
        /// <p>A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one. For example, you can use an asterisk as your match all value.</p>
        pub fn match_all_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.match_all_value = Some(input.into());
            self
        }
        /// <p>A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one. For example, you can use an asterisk as your match all value.</p>
        pub fn set_match_all_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.match_all_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RowLevelPermissionTagRule`](crate::model::RowLevelPermissionTagRule)
        pub fn build(self) -> crate::model::RowLevelPermissionTagRule {
            crate::model::RowLevelPermissionTagRule {
                tag_key: self.tag_key,
                column_name: self.column_name,
                tag_multi_value_delimiter: self.tag_multi_value_delimiter,
                match_all_value: self.match_all_value,
            }
        }
    }
}
impl RowLevelPermissionTagRule {
    /// Creates a new builder-style object to manufacture [`RowLevelPermissionTagRule`](crate::model::RowLevelPermissionTagRule)
    pub fn builder() -> crate::model::row_level_permission_tag_rule::Builder {
        crate::model::row_level_permission_tag_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Status::Disabled,
            "ENABLED" => Status::Enabled,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Disabled => "DISABLED",
            Status::Enabled => "ENABLED",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a dataset that contains permissions for row-level security (RLS).
/// The permissions dataset maps fields to users or groups. For more information, see
/// <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User
/// Guide</i>.</p>
/// <p>The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is
/// not supported for new RLS datasets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RowLevelPermissionDataSet {
    /// <p>The namespace associated with the dataset that contains permissions for RLS.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code>
    /// is included for backward compatibility only.</p>
    pub permission_policy: std::option::Option<crate::model::RowLevelPermissionPolicy>,
    /// <p>The user or group rules associated with the dataset that contains permissions for RLS.</p>
    /// <p>By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.</p>
    pub format_version: std::option::Option<crate::model::RowLevelPermissionFormatVersion>,
    /// <p>The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl RowLevelPermissionDataSet {
    /// <p>The namespace associated with the dataset that contains permissions for RLS.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code>
    /// is included for backward compatibility only.</p>
    pub fn permission_policy(
        &self,
    ) -> std::option::Option<&crate::model::RowLevelPermissionPolicy> {
        self.permission_policy.as_ref()
    }
    /// <p>The user or group rules associated with the dataset that contains permissions for RLS.</p>
    /// <p>By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.</p>
    pub fn format_version(
        &self,
    ) -> std::option::Option<&crate::model::RowLevelPermissionFormatVersion> {
        self.format_version.as_ref()
    }
    /// <p>The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for RowLevelPermissionDataSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RowLevelPermissionDataSet");
        formatter.field("namespace", &self.namespace);
        formatter.field("arn", &self.arn);
        formatter.field("permission_policy", &self.permission_policy);
        formatter.field("format_version", &self.format_version);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RowLevelPermissionDataSet`](crate::model::RowLevelPermissionDataSet)
pub mod row_level_permission_data_set {
    /// A builder for [`RowLevelPermissionDataSet`](crate::model::RowLevelPermissionDataSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) permission_policy: std::option::Option<crate::model::RowLevelPermissionPolicy>,
        pub(crate) format_version:
            std::option::Option<crate::model::RowLevelPermissionFormatVersion>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>The namespace associated with the dataset that contains permissions for RLS.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace associated with the dataset that contains permissions for RLS.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code>
        /// is included for backward compatibility only.</p>
        pub fn permission_policy(mut self, input: crate::model::RowLevelPermissionPolicy) -> Self {
            self.permission_policy = Some(input);
            self
        }
        /// <p>The type of permissions to use when interpreting the permissions for RLS. <code>DENY_ACCESS</code>
        /// is included for backward compatibility only.</p>
        pub fn set_permission_policy(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionPolicy>,
        ) -> Self {
            self.permission_policy = input;
            self
        }
        /// <p>The user or group rules associated with the dataset that contains permissions for RLS.</p>
        /// <p>By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.</p>
        pub fn format_version(
            mut self,
            input: crate::model::RowLevelPermissionFormatVersion,
        ) -> Self {
            self.format_version = Some(input);
            self
        }
        /// <p>The user or group rules associated with the dataset that contains permissions for RLS.</p>
        /// <p>By default, <code>FormatVersion</code> is <code>VERSION_1</code>. When <code>FormatVersion</code> is <code>VERSION_1</code>, <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code>, <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.</p>
        pub fn set_format_version(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionFormatVersion>,
        ) -> Self {
            self.format_version = input;
            self
        }
        /// <p>The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the row-level security permission dataset. If enabled, the status is <code>ENABLED</code>. If disabled, the status is <code>DISABLED</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RowLevelPermissionDataSet`](crate::model::RowLevelPermissionDataSet)
        pub fn build(self) -> crate::model::RowLevelPermissionDataSet {
            crate::model::RowLevelPermissionDataSet {
                namespace: self.namespace,
                arn: self.arn,
                permission_policy: self.permission_policy,
                format_version: self.format_version,
                status: self.status,
            }
        }
    }
}
impl RowLevelPermissionDataSet {
    /// Creates a new builder-style object to manufacture [`RowLevelPermissionDataSet`](crate::model::RowLevelPermissionDataSet)
    pub fn builder() -> crate::model::row_level_permission_data_set::Builder {
        crate::model::row_level_permission_data_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RowLevelPermissionFormatVersion {
    #[allow(missing_docs)] // documentation missing in model
    Version1,
    #[allow(missing_docs)] // documentation missing in model
    Version2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RowLevelPermissionFormatVersion {
    fn from(s: &str) -> Self {
        match s {
            "VERSION_1" => RowLevelPermissionFormatVersion::Version1,
            "VERSION_2" => RowLevelPermissionFormatVersion::Version2,
            other => RowLevelPermissionFormatVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RowLevelPermissionFormatVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RowLevelPermissionFormatVersion::from(s))
    }
}
impl RowLevelPermissionFormatVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RowLevelPermissionFormatVersion::Version1 => "VERSION_1",
            RowLevelPermissionFormatVersion::Version2 => "VERSION_2",
            RowLevelPermissionFormatVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VERSION_1", "VERSION_2"]
    }
}
impl AsRef<str> for RowLevelPermissionFormatVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RowLevelPermissionPolicy {
    #[allow(missing_docs)] // documentation missing in model
    DenyAccess,
    #[allow(missing_docs)] // documentation missing in model
    GrantAccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RowLevelPermissionPolicy {
    fn from(s: &str) -> Self {
        match s {
            "DENY_ACCESS" => RowLevelPermissionPolicy::DenyAccess,
            "GRANT_ACCESS" => RowLevelPermissionPolicy::GrantAccess,
            other => RowLevelPermissionPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RowLevelPermissionPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RowLevelPermissionPolicy::from(s))
    }
}
impl RowLevelPermissionPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RowLevelPermissionPolicy::DenyAccess => "DENY_ACCESS",
            RowLevelPermissionPolicy::GrantAccess => "GRANT_ACCESS",
            RowLevelPermissionPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DENY_ACCESS", "GRANT_ACCESS"]
    }
}
impl AsRef<str> for RowLevelPermissionPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A FieldFolder element is a folder that contains fields and nested subfolders.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldFolder {
    /// <p>The description for a field folder.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A folder has a list of columns. A column can only be in one folder.</p>
    pub columns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl FieldFolder {
    /// <p>The description for a field folder.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A folder has a list of columns. A column can only be in one folder.</p>
    pub fn columns(&self) -> std::option::Option<&[std::string::String]> {
        self.columns.as_deref()
    }
}
impl std::fmt::Debug for FieldFolder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldFolder");
        formatter.field("description", &self.description);
        formatter.field("columns", &self.columns);
        formatter.finish()
    }
}
/// See [`FieldFolder`](crate::model::FieldFolder)
pub mod field_folder {
    /// A builder for [`FieldFolder`](crate::model::FieldFolder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) columns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The description for a field folder.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for a field folder.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>A folder has a list of columns. A column can only be in one folder.</p>
        pub fn columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input.into());
            self.columns = Some(v);
            self
        }
        /// <p>A folder has a list of columns. A column can only be in one folder.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldFolder`](crate::model::FieldFolder)
        pub fn build(self) -> crate::model::FieldFolder {
            crate::model::FieldFolder {
                description: self.description,
                columns: self.columns,
            }
        }
    }
}
impl FieldFolder {
    /// Creates a new builder-style object to manufacture [`FieldFolder`](crate::model::FieldFolder)
    pub fn builder() -> crate::model::field_folder::Builder {
        crate::model::field_folder::Builder::default()
    }
}

/// <p>Groupings of columns that work together in certain Amazon QuickSight features. This is
/// a variant type structure. For this structure to be valid, only one of the attributes can
/// be non-null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnGroup {
    /// <p>Geospatial column group that denotes a hierarchy.</p>
    pub geo_spatial_column_group: std::option::Option<crate::model::GeoSpatialColumnGroup>,
}
impl ColumnGroup {
    /// <p>Geospatial column group that denotes a hierarchy.</p>
    pub fn geo_spatial_column_group(
        &self,
    ) -> std::option::Option<&crate::model::GeoSpatialColumnGroup> {
        self.geo_spatial_column_group.as_ref()
    }
}
impl std::fmt::Debug for ColumnGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnGroup");
        formatter.field("geo_spatial_column_group", &self.geo_spatial_column_group);
        formatter.finish()
    }
}
/// See [`ColumnGroup`](crate::model::ColumnGroup)
pub mod column_group {
    /// A builder for [`ColumnGroup`](crate::model::ColumnGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_spatial_column_group:
            std::option::Option<crate::model::GeoSpatialColumnGroup>,
    }
    impl Builder {
        /// <p>Geospatial column group that denotes a hierarchy.</p>
        pub fn geo_spatial_column_group(
            mut self,
            input: crate::model::GeoSpatialColumnGroup,
        ) -> Self {
            self.geo_spatial_column_group = Some(input);
            self
        }
        /// <p>Geospatial column group that denotes a hierarchy.</p>
        pub fn set_geo_spatial_column_group(
            mut self,
            input: std::option::Option<crate::model::GeoSpatialColumnGroup>,
        ) -> Self {
            self.geo_spatial_column_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnGroup`](crate::model::ColumnGroup)
        pub fn build(self) -> crate::model::ColumnGroup {
            crate::model::ColumnGroup {
                geo_spatial_column_group: self.geo_spatial_column_group,
            }
        }
    }
}
impl ColumnGroup {
    /// Creates a new builder-style object to manufacture [`ColumnGroup`](crate::model::ColumnGroup)
    pub fn builder() -> crate::model::column_group::Builder {
        crate::model::column_group::Builder::default()
    }
}

/// <p>Geospatial column group that denotes a hierarchy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoSpatialColumnGroup {
    /// <p>A display name for the hierarchy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Country code.</p>
    pub country_code: std::option::Option<crate::model::GeoSpatialCountryCode>,
    /// <p>Columns in this hierarchy.</p>
    pub columns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GeoSpatialColumnGroup {
    /// <p>A display name for the hierarchy.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Country code.</p>
    pub fn country_code(&self) -> std::option::Option<&crate::model::GeoSpatialCountryCode> {
        self.country_code.as_ref()
    }
    /// <p>Columns in this hierarchy.</p>
    pub fn columns(&self) -> std::option::Option<&[std::string::String]> {
        self.columns.as_deref()
    }
}
impl std::fmt::Debug for GeoSpatialColumnGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoSpatialColumnGroup");
        formatter.field("name", &self.name);
        formatter.field("country_code", &self.country_code);
        formatter.field("columns", &self.columns);
        formatter.finish()
    }
}
/// See [`GeoSpatialColumnGroup`](crate::model::GeoSpatialColumnGroup)
pub mod geo_spatial_column_group {
    /// A builder for [`GeoSpatialColumnGroup`](crate::model::GeoSpatialColumnGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) country_code: std::option::Option<crate::model::GeoSpatialCountryCode>,
        pub(crate) columns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A display name for the hierarchy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the hierarchy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Country code.</p>
        pub fn country_code(mut self, input: crate::model::GeoSpatialCountryCode) -> Self {
            self.country_code = Some(input);
            self
        }
        /// <p>Country code.</p>
        pub fn set_country_code(
            mut self,
            input: std::option::Option<crate::model::GeoSpatialCountryCode>,
        ) -> Self {
            self.country_code = input;
            self
        }
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>Columns in this hierarchy.</p>
        pub fn columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input.into());
            self.columns = Some(v);
            self
        }
        /// <p>Columns in this hierarchy.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoSpatialColumnGroup`](crate::model::GeoSpatialColumnGroup)
        pub fn build(self) -> crate::model::GeoSpatialColumnGroup {
            crate::model::GeoSpatialColumnGroup {
                name: self.name,
                country_code: self.country_code,
                columns: self.columns,
            }
        }
    }
}
impl GeoSpatialColumnGroup {
    /// Creates a new builder-style object to manufacture [`GeoSpatialColumnGroup`](crate::model::GeoSpatialColumnGroup)
    pub fn builder() -> crate::model::geo_spatial_column_group::Builder {
        crate::model::geo_spatial_column_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeoSpatialCountryCode {
    #[allow(missing_docs)] // documentation missing in model
    Us,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeoSpatialCountryCode {
    fn from(s: &str) -> Self {
        match s {
            "US" => GeoSpatialCountryCode::Us,
            other => GeoSpatialCountryCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeoSpatialCountryCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeoSpatialCountryCode::from(s))
    }
}
impl GeoSpatialCountryCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeoSpatialCountryCode::Us => "US",
            GeoSpatialCountryCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["US"]
    }
}
impl AsRef<str> for GeoSpatialCountryCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSetImportMode {
    #[allow(missing_docs)] // documentation missing in model
    DirectQuery,
    #[allow(missing_docs)] // documentation missing in model
    Spice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSetImportMode {
    fn from(s: &str) -> Self {
        match s {
            "DIRECT_QUERY" => DataSetImportMode::DirectQuery,
            "SPICE" => DataSetImportMode::Spice,
            other => DataSetImportMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSetImportMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSetImportMode::from(s))
    }
}
impl DataSetImportMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSetImportMode::DirectQuery => "DIRECT_QUERY",
            DataSetImportMode::Spice => "SPICE",
            DataSetImportMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DIRECT_QUERY", "SPICE"]
    }
}
impl AsRef<str> for DataSetImportMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A <i>logical table</i> is a unit that joins and that data
/// transformations operate on. A logical table has a source, which can be either a physical
/// table or result of a join. When a logical table points to a physical table, the logical
/// table acts as a mutable copy of that physical table through transform operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogicalTable {
    /// <p>A display name for the logical table.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>Transform operations that act on this logical table.</p>
    pub data_transforms: std::option::Option<std::vec::Vec<crate::model::TransformOperation>>,
    /// <p>Source of this logical table.</p>
    pub source: std::option::Option<crate::model::LogicalTableSource>,
}
impl LogicalTable {
    /// <p>A display name for the logical table.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>Transform operations that act on this logical table.</p>
    pub fn data_transforms(&self) -> std::option::Option<&[crate::model::TransformOperation]> {
        self.data_transforms.as_deref()
    }
    /// <p>Source of this logical table.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::LogicalTableSource> {
        self.source.as_ref()
    }
}
impl std::fmt::Debug for LogicalTable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogicalTable");
        formatter.field("alias", &self.alias);
        formatter.field("data_transforms", &self.data_transforms);
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`LogicalTable`](crate::model::LogicalTable)
pub mod logical_table {
    /// A builder for [`LogicalTable`](crate::model::LogicalTable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) data_transforms:
            std::option::Option<std::vec::Vec<crate::model::TransformOperation>>,
        pub(crate) source: std::option::Option<crate::model::LogicalTableSource>,
    }
    impl Builder {
        /// <p>A display name for the logical table.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>A display name for the logical table.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Appends an item to `data_transforms`.
        ///
        /// To override the contents of this collection use [`set_data_transforms`](Self::set_data_transforms).
        ///
        /// <p>Transform operations that act on this logical table.</p>
        pub fn data_transforms(
            mut self,
            input: impl Into<crate::model::TransformOperation>,
        ) -> Self {
            let mut v = self.data_transforms.unwrap_or_default();
            v.push(input.into());
            self.data_transforms = Some(v);
            self
        }
        /// <p>Transform operations that act on this logical table.</p>
        pub fn set_data_transforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransformOperation>>,
        ) -> Self {
            self.data_transforms = input;
            self
        }
        /// <p>Source of this logical table.</p>
        pub fn source(mut self, input: crate::model::LogicalTableSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>Source of this logical table.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::LogicalTableSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`LogicalTable`](crate::model::LogicalTable)
        pub fn build(self) -> crate::model::LogicalTable {
            crate::model::LogicalTable {
                alias: self.alias,
                data_transforms: self.data_transforms,
                source: self.source,
            }
        }
    }
}
impl LogicalTable {
    /// Creates a new builder-style object to manufacture [`LogicalTable`](crate::model::LogicalTable)
    pub fn builder() -> crate::model::logical_table::Builder {
        crate::model::logical_table::Builder::default()
    }
}

/// <p>Information about the source of a logical table. This is a variant type structure. For
/// this structure to be valid, only one of the attributes can be non-null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogicalTableSource {
    /// <p>Specifies the result of a join of two logical tables.</p>
    pub join_instruction: std::option::Option<crate::model::JoinInstruction>,
    /// <p>Physical table ID.</p>
    pub physical_table_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Number (ARN) of the parent dataset.</p>
    pub data_set_arn: std::option::Option<std::string::String>,
}
impl LogicalTableSource {
    /// <p>Specifies the result of a join of two logical tables.</p>
    pub fn join_instruction(&self) -> std::option::Option<&crate::model::JoinInstruction> {
        self.join_instruction.as_ref()
    }
    /// <p>Physical table ID.</p>
    pub fn physical_table_id(&self) -> std::option::Option<&str> {
        self.physical_table_id.as_deref()
    }
    /// <p>The Amazon Resource Number (ARN) of the parent dataset.</p>
    pub fn data_set_arn(&self) -> std::option::Option<&str> {
        self.data_set_arn.as_deref()
    }
}
impl std::fmt::Debug for LogicalTableSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogicalTableSource");
        formatter.field("join_instruction", &self.join_instruction);
        formatter.field("physical_table_id", &self.physical_table_id);
        formatter.field("data_set_arn", &self.data_set_arn);
        formatter.finish()
    }
}
/// See [`LogicalTableSource`](crate::model::LogicalTableSource)
pub mod logical_table_source {
    /// A builder for [`LogicalTableSource`](crate::model::LogicalTableSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) join_instruction: std::option::Option<crate::model::JoinInstruction>,
        pub(crate) physical_table_id: std::option::Option<std::string::String>,
        pub(crate) data_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the result of a join of two logical tables.</p>
        pub fn join_instruction(mut self, input: crate::model::JoinInstruction) -> Self {
            self.join_instruction = Some(input);
            self
        }
        /// <p>Specifies the result of a join of two logical tables.</p>
        pub fn set_join_instruction(
            mut self,
            input: std::option::Option<crate::model::JoinInstruction>,
        ) -> Self {
            self.join_instruction = input;
            self
        }
        /// <p>Physical table ID.</p>
        pub fn physical_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.physical_table_id = Some(input.into());
            self
        }
        /// <p>Physical table ID.</p>
        pub fn set_physical_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_table_id = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the parent dataset.</p>
        pub fn data_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the parent dataset.</p>
        pub fn set_data_set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LogicalTableSource`](crate::model::LogicalTableSource)
        pub fn build(self) -> crate::model::LogicalTableSource {
            crate::model::LogicalTableSource {
                join_instruction: self.join_instruction,
                physical_table_id: self.physical_table_id,
                data_set_arn: self.data_set_arn,
            }
        }
    }
}
impl LogicalTableSource {
    /// Creates a new builder-style object to manufacture [`LogicalTableSource`](crate::model::LogicalTableSource)
    pub fn builder() -> crate::model::logical_table_source::Builder {
        crate::model::logical_table_source::Builder::default()
    }
}

/// <p>The instructions associated with a join. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JoinInstruction {
    /// <p>The operand on the left side of a join.</p>
    pub left_operand: std::option::Option<std::string::String>,
    /// <p>The operand on the right side of a join.</p>
    pub right_operand: std::option::Option<std::string::String>,
    /// <p>Join key properties of the left operand.</p>
    pub left_join_key_properties: std::option::Option<crate::model::JoinKeyProperties>,
    /// <p>Join key properties of the right operand.</p>
    pub right_join_key_properties: std::option::Option<crate::model::JoinKeyProperties>,
    /// <p>The type of join that it is.</p>
    pub r#type: std::option::Option<crate::model::JoinType>,
    /// <p>The join instructions provided in the <code>ON</code> clause of a join.</p>
    pub on_clause: std::option::Option<std::string::String>,
}
impl JoinInstruction {
    /// <p>The operand on the left side of a join.</p>
    pub fn left_operand(&self) -> std::option::Option<&str> {
        self.left_operand.as_deref()
    }
    /// <p>The operand on the right side of a join.</p>
    pub fn right_operand(&self) -> std::option::Option<&str> {
        self.right_operand.as_deref()
    }
    /// <p>Join key properties of the left operand.</p>
    pub fn left_join_key_properties(
        &self,
    ) -> std::option::Option<&crate::model::JoinKeyProperties> {
        self.left_join_key_properties.as_ref()
    }
    /// <p>Join key properties of the right operand.</p>
    pub fn right_join_key_properties(
        &self,
    ) -> std::option::Option<&crate::model::JoinKeyProperties> {
        self.right_join_key_properties.as_ref()
    }
    /// <p>The type of join that it is.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::JoinType> {
        self.r#type.as_ref()
    }
    /// <p>The join instructions provided in the <code>ON</code> clause of a join.</p>
    pub fn on_clause(&self) -> std::option::Option<&str> {
        self.on_clause.as_deref()
    }
}
impl std::fmt::Debug for JoinInstruction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JoinInstruction");
        formatter.field("left_operand", &self.left_operand);
        formatter.field("right_operand", &self.right_operand);
        formatter.field("left_join_key_properties", &self.left_join_key_properties);
        formatter.field("right_join_key_properties", &self.right_join_key_properties);
        formatter.field("r#type", &self.r#type);
        formatter.field("on_clause", &self.on_clause);
        formatter.finish()
    }
}
/// See [`JoinInstruction`](crate::model::JoinInstruction)
pub mod join_instruction {
    /// A builder for [`JoinInstruction`](crate::model::JoinInstruction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) left_operand: std::option::Option<std::string::String>,
        pub(crate) right_operand: std::option::Option<std::string::String>,
        pub(crate) left_join_key_properties: std::option::Option<crate::model::JoinKeyProperties>,
        pub(crate) right_join_key_properties: std::option::Option<crate::model::JoinKeyProperties>,
        pub(crate) r#type: std::option::Option<crate::model::JoinType>,
        pub(crate) on_clause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The operand on the left side of a join.</p>
        pub fn left_operand(mut self, input: impl Into<std::string::String>) -> Self {
            self.left_operand = Some(input.into());
            self
        }
        /// <p>The operand on the left side of a join.</p>
        pub fn set_left_operand(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.left_operand = input;
            self
        }
        /// <p>The operand on the right side of a join.</p>
        pub fn right_operand(mut self, input: impl Into<std::string::String>) -> Self {
            self.right_operand = Some(input.into());
            self
        }
        /// <p>The operand on the right side of a join.</p>
        pub fn set_right_operand(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.right_operand = input;
            self
        }
        /// <p>Join key properties of the left operand.</p>
        pub fn left_join_key_properties(mut self, input: crate::model::JoinKeyProperties) -> Self {
            self.left_join_key_properties = Some(input);
            self
        }
        /// <p>Join key properties of the left operand.</p>
        pub fn set_left_join_key_properties(
            mut self,
            input: std::option::Option<crate::model::JoinKeyProperties>,
        ) -> Self {
            self.left_join_key_properties = input;
            self
        }
        /// <p>Join key properties of the right operand.</p>
        pub fn right_join_key_properties(mut self, input: crate::model::JoinKeyProperties) -> Self {
            self.right_join_key_properties = Some(input);
            self
        }
        /// <p>Join key properties of the right operand.</p>
        pub fn set_right_join_key_properties(
            mut self,
            input: std::option::Option<crate::model::JoinKeyProperties>,
        ) -> Self {
            self.right_join_key_properties = input;
            self
        }
        /// <p>The type of join that it is.</p>
        pub fn r#type(mut self, input: crate::model::JoinType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of join that it is.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::JoinType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The join instructions provided in the <code>ON</code> clause of a join.</p>
        pub fn on_clause(mut self, input: impl Into<std::string::String>) -> Self {
            self.on_clause = Some(input.into());
            self
        }
        /// <p>The join instructions provided in the <code>ON</code> clause of a join.</p>
        pub fn set_on_clause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.on_clause = input;
            self
        }
        /// Consumes the builder and constructs a [`JoinInstruction`](crate::model::JoinInstruction)
        pub fn build(self) -> crate::model::JoinInstruction {
            crate::model::JoinInstruction {
                left_operand: self.left_operand,
                right_operand: self.right_operand,
                left_join_key_properties: self.left_join_key_properties,
                right_join_key_properties: self.right_join_key_properties,
                r#type: self.r#type,
                on_clause: self.on_clause,
            }
        }
    }
}
impl JoinInstruction {
    /// Creates a new builder-style object to manufacture [`JoinInstruction`](crate::model::JoinInstruction)
    pub fn builder() -> crate::model::join_instruction::Builder {
        crate::model::join_instruction::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JoinType {
    #[allow(missing_docs)] // documentation missing in model
    Inner,
    #[allow(missing_docs)] // documentation missing in model
    Left,
    #[allow(missing_docs)] // documentation missing in model
    Outer,
    #[allow(missing_docs)] // documentation missing in model
    Right,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JoinType {
    fn from(s: &str) -> Self {
        match s {
            "INNER" => JoinType::Inner,
            "LEFT" => JoinType::Left,
            "OUTER" => JoinType::Outer,
            "RIGHT" => JoinType::Right,
            other => JoinType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JoinType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JoinType::from(s))
    }
}
impl JoinType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JoinType::Inner => "INNER",
            JoinType::Left => "LEFT",
            JoinType::Outer => "OUTER",
            JoinType::Right => "RIGHT",
            JoinType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INNER", "LEFT", "OUTER", "RIGHT"]
    }
}
impl AsRef<str> for JoinType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Properties associated with the columns participating in a join.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JoinKeyProperties {
    /// <p>A value that indicates that a row in a table is uniquely identified by the columns in
    /// a join key. This is used by Amazon QuickSight to optimize query performance.</p>
    pub unique_key: std::option::Option<bool>,
}
impl JoinKeyProperties {
    /// <p>A value that indicates that a row in a table is uniquely identified by the columns in
    /// a join key. This is used by Amazon QuickSight to optimize query performance.</p>
    pub fn unique_key(&self) -> std::option::Option<bool> {
        self.unique_key
    }
}
impl std::fmt::Debug for JoinKeyProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JoinKeyProperties");
        formatter.field("unique_key", &self.unique_key);
        formatter.finish()
    }
}
/// See [`JoinKeyProperties`](crate::model::JoinKeyProperties)
pub mod join_key_properties {
    /// A builder for [`JoinKeyProperties`](crate::model::JoinKeyProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unique_key: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that indicates that a row in a table is uniquely identified by the columns in
        /// a join key. This is used by Amazon QuickSight to optimize query performance.</p>
        pub fn unique_key(mut self, input: bool) -> Self {
            self.unique_key = Some(input);
            self
        }
        /// <p>A value that indicates that a row in a table is uniquely identified by the columns in
        /// a join key. This is used by Amazon QuickSight to optimize query performance.</p>
        pub fn set_unique_key(mut self, input: std::option::Option<bool>) -> Self {
            self.unique_key = input;
            self
        }
        /// Consumes the builder and constructs a [`JoinKeyProperties`](crate::model::JoinKeyProperties)
        pub fn build(self) -> crate::model::JoinKeyProperties {
            crate::model::JoinKeyProperties {
                unique_key: self.unique_key,
            }
        }
    }
}
impl JoinKeyProperties {
    /// Creates a new builder-style object to manufacture [`JoinKeyProperties`](crate::model::JoinKeyProperties)
    pub fn builder() -> crate::model::join_key_properties::Builder {
        crate::model::join_key_properties::Builder::default()
    }
}

/// <p>A data transformation on a logical table. This is a variant type structure. For this
/// structure to be valid, only one of the attributes can be non-null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum TransformOperation {
    /// <p>A transform operation that casts a column to a different type.</p>
    CastColumnTypeOperation(crate::model::CastColumnTypeOperation),
    /// <p>An operation that creates calculated columns. Columns created in one such operation
    /// form a lexical closure.</p>
    CreateColumnsOperation(crate::model::CreateColumnsOperation),
    /// <p>An operation that filters rows based on some condition.</p>
    FilterOperation(crate::model::FilterOperation),
    /// <p>An operation that projects columns. Operations that come after a projection can only
    /// refer to projected columns.</p>
    ProjectOperation(crate::model::ProjectOperation),
    /// <p>An operation that renames a column.</p>
    RenameColumnOperation(crate::model::RenameColumnOperation),
    /// <p>An operation that tags a column with additional information.</p>
    TagColumnOperation(crate::model::TagColumnOperation),
    /// <p>A transform operation that removes tags associated with a column.</p>
    UntagColumnOperation(crate::model::UntagColumnOperation),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl TransformOperation {
    /// Tries to convert the enum instance into [`CastColumnTypeOperation`](crate::model::TransformOperation::CastColumnTypeOperation), extracting the inner [`CastColumnTypeOperation`](crate::model::CastColumnTypeOperation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_cast_column_type_operation(
        &self,
    ) -> std::result::Result<&crate::model::CastColumnTypeOperation, &Self> {
        if let TransformOperation::CastColumnTypeOperation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`CastColumnTypeOperation`](crate::model::TransformOperation::CastColumnTypeOperation).
    pub fn is_cast_column_type_operation(&self) -> bool {
        self.as_cast_column_type_operation().is_ok()
    }
    /// Tries to convert the enum instance into [`CreateColumnsOperation`](crate::model::TransformOperation::CreateColumnsOperation), extracting the inner [`CreateColumnsOperation`](crate::model::CreateColumnsOperation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_create_columns_operation(
        &self,
    ) -> std::result::Result<&crate::model::CreateColumnsOperation, &Self> {
        if let TransformOperation::CreateColumnsOperation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`CreateColumnsOperation`](crate::model::TransformOperation::CreateColumnsOperation).
    pub fn is_create_columns_operation(&self) -> bool {
        self.as_create_columns_operation().is_ok()
    }
    /// Tries to convert the enum instance into [`FilterOperation`](crate::model::TransformOperation::FilterOperation), extracting the inner [`FilterOperation`](crate::model::FilterOperation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_filter_operation(
        &self,
    ) -> std::result::Result<&crate::model::FilterOperation, &Self> {
        if let TransformOperation::FilterOperation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`FilterOperation`](crate::model::TransformOperation::FilterOperation).
    pub fn is_filter_operation(&self) -> bool {
        self.as_filter_operation().is_ok()
    }
    /// Tries to convert the enum instance into [`ProjectOperation`](crate::model::TransformOperation::ProjectOperation), extracting the inner [`ProjectOperation`](crate::model::ProjectOperation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_project_operation(
        &self,
    ) -> std::result::Result<&crate::model::ProjectOperation, &Self> {
        if let TransformOperation::ProjectOperation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ProjectOperation`](crate::model::TransformOperation::ProjectOperation).
    pub fn is_project_operation(&self) -> bool {
        self.as_project_operation().is_ok()
    }
    /// Tries to convert the enum instance into [`RenameColumnOperation`](crate::model::TransformOperation::RenameColumnOperation), extracting the inner [`RenameColumnOperation`](crate::model::RenameColumnOperation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_rename_column_operation(
        &self,
    ) -> std::result::Result<&crate::model::RenameColumnOperation, &Self> {
        if let TransformOperation::RenameColumnOperation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`RenameColumnOperation`](crate::model::TransformOperation::RenameColumnOperation).
    pub fn is_rename_column_operation(&self) -> bool {
        self.as_rename_column_operation().is_ok()
    }
    /// Tries to convert the enum instance into [`TagColumnOperation`](crate::model::TransformOperation::TagColumnOperation), extracting the inner [`TagColumnOperation`](crate::model::TagColumnOperation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tag_column_operation(
        &self,
    ) -> std::result::Result<&crate::model::TagColumnOperation, &Self> {
        if let TransformOperation::TagColumnOperation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`TagColumnOperation`](crate::model::TransformOperation::TagColumnOperation).
    pub fn is_tag_column_operation(&self) -> bool {
        self.as_tag_column_operation().is_ok()
    }
    /// Tries to convert the enum instance into [`UntagColumnOperation`](crate::model::TransformOperation::UntagColumnOperation), extracting the inner [`UntagColumnOperation`](crate::model::UntagColumnOperation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_untag_column_operation(
        &self,
    ) -> std::result::Result<&crate::model::UntagColumnOperation, &Self> {
        if let TransformOperation::UntagColumnOperation(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`UntagColumnOperation`](crate::model::TransformOperation::UntagColumnOperation).
    pub fn is_untag_column_operation(&self) -> bool {
        self.as_untag_column_operation().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A transform operation that removes tags associated with a column.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagColumnOperation {
    /// <p>The column that this operation acts on.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>The column tags to remove from this column.</p>
    pub tag_names: std::option::Option<std::vec::Vec<crate::model::ColumnTagName>>,
}
impl UntagColumnOperation {
    /// <p>The column that this operation acts on.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>The column tags to remove from this column.</p>
    pub fn tag_names(&self) -> std::option::Option<&[crate::model::ColumnTagName]> {
        self.tag_names.as_deref()
    }
}
impl std::fmt::Debug for UntagColumnOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagColumnOperation");
        formatter.field("column_name", &self.column_name);
        formatter.field("tag_names", &self.tag_names);
        formatter.finish()
    }
}
/// See [`UntagColumnOperation`](crate::model::UntagColumnOperation)
pub mod untag_column_operation {
    /// A builder for [`UntagColumnOperation`](crate::model::UntagColumnOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) tag_names: std::option::Option<std::vec::Vec<crate::model::ColumnTagName>>,
    }
    impl Builder {
        /// <p>The column that this operation acts on.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The column that this operation acts on.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// Appends an item to `tag_names`.
        ///
        /// To override the contents of this collection use [`set_tag_names`](Self::set_tag_names).
        ///
        /// <p>The column tags to remove from this column.</p>
        pub fn tag_names(mut self, input: impl Into<crate::model::ColumnTagName>) -> Self {
            let mut v = self.tag_names.unwrap_or_default();
            v.push(input.into());
            self.tag_names = Some(v);
            self
        }
        /// <p>The column tags to remove from this column.</p>
        pub fn set_tag_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnTagName>>,
        ) -> Self {
            self.tag_names = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagColumnOperation`](crate::model::UntagColumnOperation)
        pub fn build(self) -> crate::model::UntagColumnOperation {
            crate::model::UntagColumnOperation {
                column_name: self.column_name,
                tag_names: self.tag_names,
            }
        }
    }
}
impl UntagColumnOperation {
    /// Creates a new builder-style object to manufacture [`UntagColumnOperation`](crate::model::UntagColumnOperation)
    pub fn builder() -> crate::model::untag_column_operation::Builder {
        crate::model::untag_column_operation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ColumnTagName {
    #[allow(missing_docs)] // documentation missing in model
    ColumnDescription,
    #[allow(missing_docs)] // documentation missing in model
    ColumnGeographicRole,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ColumnTagName {
    fn from(s: &str) -> Self {
        match s {
            "COLUMN_DESCRIPTION" => ColumnTagName::ColumnDescription,
            "COLUMN_GEOGRAPHIC_ROLE" => ColumnTagName::ColumnGeographicRole,
            other => ColumnTagName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ColumnTagName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ColumnTagName::from(s))
    }
}
impl ColumnTagName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ColumnTagName::ColumnDescription => "COLUMN_DESCRIPTION",
            ColumnTagName::ColumnGeographicRole => "COLUMN_GEOGRAPHIC_ROLE",
            ColumnTagName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COLUMN_DESCRIPTION", "COLUMN_GEOGRAPHIC_ROLE"]
    }
}
impl AsRef<str> for ColumnTagName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A transform operation that tags a column with additional information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagColumnOperation {
    /// <p>The column that this operation acts on.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>The dataset column tag, currently only used for geospatial type tagging.</p>
    /// <note>
    /// <p>This is not tags for the Amazon Web Services tagging feature.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::ColumnTag>>,
}
impl TagColumnOperation {
    /// <p>The column that this operation acts on.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>The dataset column tag, currently only used for geospatial type tagging.</p>
    /// <note>
    /// <p>This is not tags for the Amazon Web Services tagging feature.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::ColumnTag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagColumnOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagColumnOperation");
        formatter.field("column_name", &self.column_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TagColumnOperation`](crate::model::TagColumnOperation)
pub mod tag_column_operation {
    /// A builder for [`TagColumnOperation`](crate::model::TagColumnOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::ColumnTag>>,
    }
    impl Builder {
        /// <p>The column that this operation acts on.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The column that this operation acts on.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The dataset column tag, currently only used for geospatial type tagging.</p>
        /// <note>
        /// <p>This is not tags for the Amazon Web Services tagging feature.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::ColumnTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The dataset column tag, currently only used for geospatial type tagging.</p>
        /// <note>
        /// <p>This is not tags for the Amazon Web Services tagging feature.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagColumnOperation`](crate::model::TagColumnOperation)
        pub fn build(self) -> crate::model::TagColumnOperation {
            crate::model::TagColumnOperation {
                column_name: self.column_name,
                tags: self.tags,
            }
        }
    }
}
impl TagColumnOperation {
    /// Creates a new builder-style object to manufacture [`TagColumnOperation`](crate::model::TagColumnOperation)
    pub fn builder() -> crate::model::tag_column_operation::Builder {
        crate::model::tag_column_operation::Builder::default()
    }
}

/// <p>A tag for a column in a <a>TagColumnOperation</a> structure. This is a
/// variant type structure. For this structure to be valid, only one of the attributes can
/// be non-null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnTag {
    /// <p>A geospatial role for a column.</p>
    pub column_geographic_role: std::option::Option<crate::model::GeoSpatialDataRole>,
    /// <p>A description for a column.</p>
    pub column_description: std::option::Option<crate::model::ColumnDescription>,
}
impl ColumnTag {
    /// <p>A geospatial role for a column.</p>
    pub fn column_geographic_role(&self) -> std::option::Option<&crate::model::GeoSpatialDataRole> {
        self.column_geographic_role.as_ref()
    }
    /// <p>A description for a column.</p>
    pub fn column_description(&self) -> std::option::Option<&crate::model::ColumnDescription> {
        self.column_description.as_ref()
    }
}
impl std::fmt::Debug for ColumnTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnTag");
        formatter.field("column_geographic_role", &self.column_geographic_role);
        formatter.field("column_description", &self.column_description);
        formatter.finish()
    }
}
/// See [`ColumnTag`](crate::model::ColumnTag)
pub mod column_tag {
    /// A builder for [`ColumnTag`](crate::model::ColumnTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_geographic_role: std::option::Option<crate::model::GeoSpatialDataRole>,
        pub(crate) column_description: std::option::Option<crate::model::ColumnDescription>,
    }
    impl Builder {
        /// <p>A geospatial role for a column.</p>
        pub fn column_geographic_role(mut self, input: crate::model::GeoSpatialDataRole) -> Self {
            self.column_geographic_role = Some(input);
            self
        }
        /// <p>A geospatial role for a column.</p>
        pub fn set_column_geographic_role(
            mut self,
            input: std::option::Option<crate::model::GeoSpatialDataRole>,
        ) -> Self {
            self.column_geographic_role = input;
            self
        }
        /// <p>A description for a column.</p>
        pub fn column_description(mut self, input: crate::model::ColumnDescription) -> Self {
            self.column_description = Some(input);
            self
        }
        /// <p>A description for a column.</p>
        pub fn set_column_description(
            mut self,
            input: std::option::Option<crate::model::ColumnDescription>,
        ) -> Self {
            self.column_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnTag`](crate::model::ColumnTag)
        pub fn build(self) -> crate::model::ColumnTag {
            crate::model::ColumnTag {
                column_geographic_role: self.column_geographic_role,
                column_description: self.column_description,
            }
        }
    }
}
impl ColumnTag {
    /// Creates a new builder-style object to manufacture [`ColumnTag`](crate::model::ColumnTag)
    pub fn builder() -> crate::model::column_tag::Builder {
        crate::model::column_tag::Builder::default()
    }
}

/// <p>Metadata that contains a description for a column.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnDescription {
    /// <p>The text of a description for a column.</p>
    pub text: std::option::Option<std::string::String>,
}
impl ColumnDescription {
    /// <p>The text of a description for a column.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
}
impl std::fmt::Debug for ColumnDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnDescription");
        formatter.field("text", &self.text);
        formatter.finish()
    }
}
/// See [`ColumnDescription`](crate::model::ColumnDescription)
pub mod column_description {
    /// A builder for [`ColumnDescription`](crate::model::ColumnDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text of a description for a column.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of a description for a column.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnDescription`](crate::model::ColumnDescription)
        pub fn build(self) -> crate::model::ColumnDescription {
            crate::model::ColumnDescription { text: self.text }
        }
    }
}
impl ColumnDescription {
    /// Creates a new builder-style object to manufacture [`ColumnDescription`](crate::model::ColumnDescription)
    pub fn builder() -> crate::model::column_description::Builder {
        crate::model::column_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeoSpatialDataRole {
    #[allow(missing_docs)] // documentation missing in model
    City,
    #[allow(missing_docs)] // documentation missing in model
    Country,
    #[allow(missing_docs)] // documentation missing in model
    County,
    #[allow(missing_docs)] // documentation missing in model
    Latitude,
    #[allow(missing_docs)] // documentation missing in model
    Longitude,
    #[allow(missing_docs)] // documentation missing in model
    Postcode,
    #[allow(missing_docs)] // documentation missing in model
    State,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeoSpatialDataRole {
    fn from(s: &str) -> Self {
        match s {
            "CITY" => GeoSpatialDataRole::City,
            "COUNTRY" => GeoSpatialDataRole::Country,
            "COUNTY" => GeoSpatialDataRole::County,
            "LATITUDE" => GeoSpatialDataRole::Latitude,
            "LONGITUDE" => GeoSpatialDataRole::Longitude,
            "POSTCODE" => GeoSpatialDataRole::Postcode,
            "STATE" => GeoSpatialDataRole::State,
            other => GeoSpatialDataRole::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeoSpatialDataRole {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeoSpatialDataRole::from(s))
    }
}
impl GeoSpatialDataRole {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeoSpatialDataRole::City => "CITY",
            GeoSpatialDataRole::Country => "COUNTRY",
            GeoSpatialDataRole::County => "COUNTY",
            GeoSpatialDataRole::Latitude => "LATITUDE",
            GeoSpatialDataRole::Longitude => "LONGITUDE",
            GeoSpatialDataRole::Postcode => "POSTCODE",
            GeoSpatialDataRole::State => "STATE",
            GeoSpatialDataRole::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CITY",
            "COUNTRY",
            "COUNTY",
            "LATITUDE",
            "LONGITUDE",
            "POSTCODE",
            "STATE",
        ]
    }
}
impl AsRef<str> for GeoSpatialDataRole {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A transform operation that casts a column to a different type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CastColumnTypeOperation {
    /// <p>Column name.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>New column data type.</p>
    pub new_column_type: std::option::Option<crate::model::ColumnDataType>,
    /// <p>When casting a column from string to datetime type, you can supply a string in a
    /// format supported by Amazon QuickSight to denote the source data format.</p>
    pub format: std::option::Option<std::string::String>,
}
impl CastColumnTypeOperation {
    /// <p>Column name.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>New column data type.</p>
    pub fn new_column_type(&self) -> std::option::Option<&crate::model::ColumnDataType> {
        self.new_column_type.as_ref()
    }
    /// <p>When casting a column from string to datetime type, you can supply a string in a
    /// format supported by Amazon QuickSight to denote the source data format.</p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
}
impl std::fmt::Debug for CastColumnTypeOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CastColumnTypeOperation");
        formatter.field("column_name", &self.column_name);
        formatter.field("new_column_type", &self.new_column_type);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}
/// See [`CastColumnTypeOperation`](crate::model::CastColumnTypeOperation)
pub mod cast_column_type_operation {
    /// A builder for [`CastColumnTypeOperation`](crate::model::CastColumnTypeOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) new_column_type: std::option::Option<crate::model::ColumnDataType>,
        pub(crate) format: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Column name.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>Column name.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>New column data type.</p>
        pub fn new_column_type(mut self, input: crate::model::ColumnDataType) -> Self {
            self.new_column_type = Some(input);
            self
        }
        /// <p>New column data type.</p>
        pub fn set_new_column_type(
            mut self,
            input: std::option::Option<crate::model::ColumnDataType>,
        ) -> Self {
            self.new_column_type = input;
            self
        }
        /// <p>When casting a column from string to datetime type, you can supply a string in a
        /// format supported by Amazon QuickSight to denote the source data format.</p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>When casting a column from string to datetime type, you can supply a string in a
        /// format supported by Amazon QuickSight to denote the source data format.</p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`CastColumnTypeOperation`](crate::model::CastColumnTypeOperation)
        pub fn build(self) -> crate::model::CastColumnTypeOperation {
            crate::model::CastColumnTypeOperation {
                column_name: self.column_name,
                new_column_type: self.new_column_type,
                format: self.format,
            }
        }
    }
}
impl CastColumnTypeOperation {
    /// Creates a new builder-style object to manufacture [`CastColumnTypeOperation`](crate::model::CastColumnTypeOperation)
    pub fn builder() -> crate::model::cast_column_type_operation::Builder {
        crate::model::cast_column_type_operation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ColumnDataType {
    #[allow(missing_docs)] // documentation missing in model
    Datetime,
    #[allow(missing_docs)] // documentation missing in model
    Decimal,
    #[allow(missing_docs)] // documentation missing in model
    Integer,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ColumnDataType {
    fn from(s: &str) -> Self {
        match s {
            "DATETIME" => ColumnDataType::Datetime,
            "DECIMAL" => ColumnDataType::Decimal,
            "INTEGER" => ColumnDataType::Integer,
            "STRING" => ColumnDataType::String,
            other => ColumnDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ColumnDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ColumnDataType::from(s))
    }
}
impl ColumnDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ColumnDataType::Datetime => "DATETIME",
            ColumnDataType::Decimal => "DECIMAL",
            ColumnDataType::Integer => "INTEGER",
            ColumnDataType::String => "STRING",
            ColumnDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DATETIME", "DECIMAL", "INTEGER", "STRING"]
    }
}
impl AsRef<str> for ColumnDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A transform operation that renames a column.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenameColumnOperation {
    /// <p>The name of the column to be renamed.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>The new name for the column.</p>
    pub new_column_name: std::option::Option<std::string::String>,
}
impl RenameColumnOperation {
    /// <p>The name of the column to be renamed.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>The new name for the column.</p>
    pub fn new_column_name(&self) -> std::option::Option<&str> {
        self.new_column_name.as_deref()
    }
}
impl std::fmt::Debug for RenameColumnOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenameColumnOperation");
        formatter.field("column_name", &self.column_name);
        formatter.field("new_column_name", &self.new_column_name);
        formatter.finish()
    }
}
/// See [`RenameColumnOperation`](crate::model::RenameColumnOperation)
pub mod rename_column_operation {
    /// A builder for [`RenameColumnOperation`](crate::model::RenameColumnOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) new_column_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column to be renamed.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The name of the column to be renamed.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>The new name for the column.</p>
        pub fn new_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_column_name = Some(input.into());
            self
        }
        /// <p>The new name for the column.</p>
        pub fn set_new_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_column_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RenameColumnOperation`](crate::model::RenameColumnOperation)
        pub fn build(self) -> crate::model::RenameColumnOperation {
            crate::model::RenameColumnOperation {
                column_name: self.column_name,
                new_column_name: self.new_column_name,
            }
        }
    }
}
impl RenameColumnOperation {
    /// Creates a new builder-style object to manufacture [`RenameColumnOperation`](crate::model::RenameColumnOperation)
    pub fn builder() -> crate::model::rename_column_operation::Builder {
        crate::model::rename_column_operation::Builder::default()
    }
}

/// <p>A transform operation that creates calculated columns. Columns created in one such
/// operation form a lexical closure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateColumnsOperation {
    /// <p>Calculated columns to create.</p>
    pub columns: std::option::Option<std::vec::Vec<crate::model::CalculatedColumn>>,
}
impl CreateColumnsOperation {
    /// <p>Calculated columns to create.</p>
    pub fn columns(&self) -> std::option::Option<&[crate::model::CalculatedColumn]> {
        self.columns.as_deref()
    }
}
impl std::fmt::Debug for CreateColumnsOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateColumnsOperation");
        formatter.field("columns", &self.columns);
        formatter.finish()
    }
}
/// See [`CreateColumnsOperation`](crate::model::CreateColumnsOperation)
pub mod create_columns_operation {
    /// A builder for [`CreateColumnsOperation`](crate::model::CreateColumnsOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) columns: std::option::Option<std::vec::Vec<crate::model::CalculatedColumn>>,
    }
    impl Builder {
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>Calculated columns to create.</p>
        pub fn columns(mut self, input: impl Into<crate::model::CalculatedColumn>) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input.into());
            self.columns = Some(v);
            self
        }
        /// <p>Calculated columns to create.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CalculatedColumn>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateColumnsOperation`](crate::model::CreateColumnsOperation)
        pub fn build(self) -> crate::model::CreateColumnsOperation {
            crate::model::CreateColumnsOperation {
                columns: self.columns,
            }
        }
    }
}
impl CreateColumnsOperation {
    /// Creates a new builder-style object to manufacture [`CreateColumnsOperation`](crate::model::CreateColumnsOperation)
    pub fn builder() -> crate::model::create_columns_operation::Builder {
        crate::model::create_columns_operation::Builder::default()
    }
}

/// <p>A calculated column for a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculatedColumn {
    /// <p>Column name.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>A unique ID to identify a calculated column. During a dataset update, if the column ID
    /// of a calculated column matches that of an existing calculated column, Amazon QuickSight
    /// preserves the existing calculated column.</p>
    pub column_id: std::option::Option<std::string::String>,
    /// <p>An expression that defines the calculated column.</p>
    pub expression: std::option::Option<std::string::String>,
}
impl CalculatedColumn {
    /// <p>Column name.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>A unique ID to identify a calculated column. During a dataset update, if the column ID
    /// of a calculated column matches that of an existing calculated column, Amazon QuickSight
    /// preserves the existing calculated column.</p>
    pub fn column_id(&self) -> std::option::Option<&str> {
        self.column_id.as_deref()
    }
    /// <p>An expression that defines the calculated column.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
}
impl std::fmt::Debug for CalculatedColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculatedColumn");
        formatter.field("column_name", &self.column_name);
        formatter.field("column_id", &self.column_id);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`CalculatedColumn`](crate::model::CalculatedColumn)
pub mod calculated_column {
    /// A builder for [`CalculatedColumn`](crate::model::CalculatedColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) column_id: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Column name.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>Column name.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>A unique ID to identify a calculated column. During a dataset update, if the column ID
        /// of a calculated column matches that of an existing calculated column, Amazon QuickSight
        /// preserves the existing calculated column.</p>
        pub fn column_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_id = Some(input.into());
            self
        }
        /// <p>A unique ID to identify a calculated column. During a dataset update, if the column ID
        /// of a calculated column matches that of an existing calculated column, Amazon QuickSight
        /// preserves the existing calculated column.</p>
        pub fn set_column_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_id = input;
            self
        }
        /// <p>An expression that defines the calculated column.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>An expression that defines the calculated column.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculatedColumn`](crate::model::CalculatedColumn)
        pub fn build(self) -> crate::model::CalculatedColumn {
            crate::model::CalculatedColumn {
                column_name: self.column_name,
                column_id: self.column_id,
                expression: self.expression,
            }
        }
    }
}
impl CalculatedColumn {
    /// Creates a new builder-style object to manufacture [`CalculatedColumn`](crate::model::CalculatedColumn)
    pub fn builder() -> crate::model::calculated_column::Builder {
        crate::model::calculated_column::Builder::default()
    }
}

/// <p>A transform operation that filters rows based on a condition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterOperation {
    /// <p>An expression that must evaluate to a Boolean value. Rows for which the expression
    /// evaluates to true are kept in the dataset.</p>
    pub condition_expression: std::option::Option<std::string::String>,
}
impl FilterOperation {
    /// <p>An expression that must evaluate to a Boolean value. Rows for which the expression
    /// evaluates to true are kept in the dataset.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
}
impl std::fmt::Debug for FilterOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterOperation");
        formatter.field("condition_expression", &self.condition_expression);
        formatter.finish()
    }
}
/// See [`FilterOperation`](crate::model::FilterOperation)
pub mod filter_operation {
    /// A builder for [`FilterOperation`](crate::model::FilterOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An expression that must evaluate to a Boolean value. Rows for which the expression
        /// evaluates to true are kept in the dataset.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>An expression that must evaluate to a Boolean value. Rows for which the expression
        /// evaluates to true are kept in the dataset.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterOperation`](crate::model::FilterOperation)
        pub fn build(self) -> crate::model::FilterOperation {
            crate::model::FilterOperation {
                condition_expression: self.condition_expression,
            }
        }
    }
}
impl FilterOperation {
    /// Creates a new builder-style object to manufacture [`FilterOperation`](crate::model::FilterOperation)
    pub fn builder() -> crate::model::filter_operation::Builder {
        crate::model::filter_operation::Builder::default()
    }
}

/// <p>A transform operation that projects columns. Operations that come after a projection
/// can only refer to projected columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectOperation {
    /// <p>Projected columns.</p>
    pub projected_columns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ProjectOperation {
    /// <p>Projected columns.</p>
    pub fn projected_columns(&self) -> std::option::Option<&[std::string::String]> {
        self.projected_columns.as_deref()
    }
}
impl std::fmt::Debug for ProjectOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectOperation");
        formatter.field("projected_columns", &self.projected_columns);
        formatter.finish()
    }
}
/// See [`ProjectOperation`](crate::model::ProjectOperation)
pub mod project_operation {
    /// A builder for [`ProjectOperation`](crate::model::ProjectOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projected_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `projected_columns`.
        ///
        /// To override the contents of this collection use [`set_projected_columns`](Self::set_projected_columns).
        ///
        /// <p>Projected columns.</p>
        pub fn projected_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.projected_columns.unwrap_or_default();
            v.push(input.into());
            self.projected_columns = Some(v);
            self
        }
        /// <p>Projected columns.</p>
        pub fn set_projected_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.projected_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectOperation`](crate::model::ProjectOperation)
        pub fn build(self) -> crate::model::ProjectOperation {
            crate::model::ProjectOperation {
                projected_columns: self.projected_columns,
            }
        }
    }
}
impl ProjectOperation {
    /// Creates a new builder-style object to manufacture [`ProjectOperation`](crate::model::ProjectOperation)
    pub fn builder() -> crate::model::project_operation::Builder {
        crate::model::project_operation::Builder::default()
    }
}

/// <p>A view of a data source that contains information about the shape of the data in the
/// underlying source. This is a variant type structure. For this structure to be valid,
/// only one of the attributes can be non-null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum PhysicalTable {
    /// <p>A physical table type built from the results of the custom SQL query.</p>
    CustomSql(crate::model::CustomSql),
    /// <p>A physical table type for relational data sources.</p>
    RelationalTable(crate::model::RelationalTable),
    /// <p>A physical table type for as S3 data source.</p>
    S3Source(crate::model::S3Source),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl PhysicalTable {
    /// Tries to convert the enum instance into [`CustomSql`](crate::model::PhysicalTable::CustomSql), extracting the inner [`CustomSql`](crate::model::CustomSql).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_custom_sql(&self) -> std::result::Result<&crate::model::CustomSql, &Self> {
        if let PhysicalTable::CustomSql(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`CustomSql`](crate::model::PhysicalTable::CustomSql).
    pub fn is_custom_sql(&self) -> bool {
        self.as_custom_sql().is_ok()
    }
    /// Tries to convert the enum instance into [`RelationalTable`](crate::model::PhysicalTable::RelationalTable), extracting the inner [`RelationalTable`](crate::model::RelationalTable).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_relational_table(
        &self,
    ) -> std::result::Result<&crate::model::RelationalTable, &Self> {
        if let PhysicalTable::RelationalTable(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`RelationalTable`](crate::model::PhysicalTable::RelationalTable).
    pub fn is_relational_table(&self) -> bool {
        self.as_relational_table().is_ok()
    }
    /// Tries to convert the enum instance into [`S3Source`](crate::model::PhysicalTable::S3Source), extracting the inner [`S3Source`](crate::model::S3Source).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_source(&self) -> std::result::Result<&crate::model::S3Source, &Self> {
        if let PhysicalTable::S3Source(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`S3Source`](crate::model::PhysicalTable::S3Source).
    pub fn is_s3_source(&self) -> bool {
        self.as_s3_source().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A physical table type for an S3 data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Source {
    /// <p>The Amazon Resource Name (ARN) for the data source.</p>
    pub data_source_arn: std::option::Option<std::string::String>,
    /// <p>Information about the format for the S3 source file or files.</p>
    pub upload_settings: std::option::Option<crate::model::UploadSettings>,
    /// <p>A physical table type for an S3 data source.</p>
    /// <note>
    /// <p>For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.</p>
    /// </note>
    pub input_columns: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
}
impl S3Source {
    /// <p>The Amazon Resource Name (ARN) for the data source.</p>
    pub fn data_source_arn(&self) -> std::option::Option<&str> {
        self.data_source_arn.as_deref()
    }
    /// <p>Information about the format for the S3 source file or files.</p>
    pub fn upload_settings(&self) -> std::option::Option<&crate::model::UploadSettings> {
        self.upload_settings.as_ref()
    }
    /// <p>A physical table type for an S3 data source.</p>
    /// <note>
    /// <p>For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.</p>
    /// </note>
    pub fn input_columns(&self) -> std::option::Option<&[crate::model::InputColumn]> {
        self.input_columns.as_deref()
    }
}
impl std::fmt::Debug for S3Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Source");
        formatter.field("data_source_arn", &self.data_source_arn);
        formatter.field("upload_settings", &self.upload_settings);
        formatter.field("input_columns", &self.input_columns);
        formatter.finish()
    }
}
/// See [`S3Source`](crate::model::S3Source)
pub mod s3_source {
    /// A builder for [`S3Source`](crate::model::S3Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_arn: std::option::Option<std::string::String>,
        pub(crate) upload_settings: std::option::Option<crate::model::UploadSettings>,
        pub(crate) input_columns: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the data source.</p>
        pub fn data_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the data source.</p>
        pub fn set_data_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_arn = input;
            self
        }
        /// <p>Information about the format for the S3 source file or files.</p>
        pub fn upload_settings(mut self, input: crate::model::UploadSettings) -> Self {
            self.upload_settings = Some(input);
            self
        }
        /// <p>Information about the format for the S3 source file or files.</p>
        pub fn set_upload_settings(
            mut self,
            input: std::option::Option<crate::model::UploadSettings>,
        ) -> Self {
            self.upload_settings = input;
            self
        }
        /// Appends an item to `input_columns`.
        ///
        /// To override the contents of this collection use [`set_input_columns`](Self::set_input_columns).
        ///
        /// <p>A physical table type for an S3 data source.</p>
        /// <note>
        /// <p>For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.</p>
        /// </note>
        pub fn input_columns(mut self, input: impl Into<crate::model::InputColumn>) -> Self {
            let mut v = self.input_columns.unwrap_or_default();
            v.push(input.into());
            self.input_columns = Some(v);
            self
        }
        /// <p>A physical table type for an S3 data source.</p>
        /// <note>
        /// <p>For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.</p>
        /// </note>
        pub fn set_input_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
        ) -> Self {
            self.input_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Source`](crate::model::S3Source)
        pub fn build(self) -> crate::model::S3Source {
            crate::model::S3Source {
                data_source_arn: self.data_source_arn,
                upload_settings: self.upload_settings,
                input_columns: self.input_columns,
            }
        }
    }
}
impl S3Source {
    /// Creates a new builder-style object to manufacture [`S3Source`](crate::model::S3Source)
    pub fn builder() -> crate::model::s3_source::Builder {
        crate::model::s3_source::Builder::default()
    }
}

/// <p>Metadata for a column that is used as the input of a transform operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputColumn {
    /// <p>The name of this column in the underlying data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the column.</p>
    pub r#type: std::option::Option<crate::model::InputColumnDataType>,
}
impl InputColumn {
    /// <p>The name of this column in the underlying data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the column.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::InputColumnDataType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for InputColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputColumn");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`InputColumn`](crate::model::InputColumn)
pub mod input_column {
    /// A builder for [`InputColumn`](crate::model::InputColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::InputColumnDataType>,
    }
    impl Builder {
        /// <p>The name of this column in the underlying data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this column in the underlying data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the column.</p>
        pub fn r#type(mut self, input: crate::model::InputColumnDataType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The data type of the column.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::InputColumnDataType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`InputColumn`](crate::model::InputColumn)
        pub fn build(self) -> crate::model::InputColumn {
            crate::model::InputColumn {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl InputColumn {
    /// Creates a new builder-style object to manufacture [`InputColumn`](crate::model::InputColumn)
    pub fn builder() -> crate::model::input_column::Builder {
        crate::model::input_column::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputColumnDataType {
    #[allow(missing_docs)] // documentation missing in model
    Bit,
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Datetime,
    #[allow(missing_docs)] // documentation missing in model
    Decimal,
    #[allow(missing_docs)] // documentation missing in model
    Integer,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputColumnDataType {
    fn from(s: &str) -> Self {
        match s {
            "BIT" => InputColumnDataType::Bit,
            "BOOLEAN" => InputColumnDataType::Boolean,
            "DATETIME" => InputColumnDataType::Datetime,
            "DECIMAL" => InputColumnDataType::Decimal,
            "INTEGER" => InputColumnDataType::Integer,
            "JSON" => InputColumnDataType::Json,
            "STRING" => InputColumnDataType::String,
            other => InputColumnDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputColumnDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputColumnDataType::from(s))
    }
}
impl InputColumnDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputColumnDataType::Bit => "BIT",
            InputColumnDataType::Boolean => "BOOLEAN",
            InputColumnDataType::Datetime => "DATETIME",
            InputColumnDataType::Decimal => "DECIMAL",
            InputColumnDataType::Integer => "INTEGER",
            InputColumnDataType::Json => "JSON",
            InputColumnDataType::String => "STRING",
            InputColumnDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BIT", "BOOLEAN", "DATETIME", "DECIMAL", "INTEGER", "JSON", "STRING",
        ]
    }
}
impl AsRef<str> for InputColumnDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the format for a source file or files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadSettings {
    /// <p>File format.</p>
    pub format: std::option::Option<crate::model::FileFormat>,
    /// <p>A row number to start reading data from.</p>
    pub start_from_row: std::option::Option<i32>,
    /// <p>Whether the file has a header row, or the files each have a header row.</p>
    pub contains_header: std::option::Option<bool>,
    /// <p>Text qualifier.</p>
    pub text_qualifier: std::option::Option<crate::model::TextQualifier>,
    /// <p>The delimiter between values in the file.</p>
    pub delimiter: std::option::Option<std::string::String>,
}
impl UploadSettings {
    /// <p>File format.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::FileFormat> {
        self.format.as_ref()
    }
    /// <p>A row number to start reading data from.</p>
    pub fn start_from_row(&self) -> std::option::Option<i32> {
        self.start_from_row
    }
    /// <p>Whether the file has a header row, or the files each have a header row.</p>
    pub fn contains_header(&self) -> std::option::Option<bool> {
        self.contains_header
    }
    /// <p>Text qualifier.</p>
    pub fn text_qualifier(&self) -> std::option::Option<&crate::model::TextQualifier> {
        self.text_qualifier.as_ref()
    }
    /// <p>The delimiter between values in the file.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
}
impl std::fmt::Debug for UploadSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadSettings");
        formatter.field("format", &self.format);
        formatter.field("start_from_row", &self.start_from_row);
        formatter.field("contains_header", &self.contains_header);
        formatter.field("text_qualifier", &self.text_qualifier);
        formatter.field("delimiter", &self.delimiter);
        formatter.finish()
    }
}
/// See [`UploadSettings`](crate::model::UploadSettings)
pub mod upload_settings {
    /// A builder for [`UploadSettings`](crate::model::UploadSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::FileFormat>,
        pub(crate) start_from_row: std::option::Option<i32>,
        pub(crate) contains_header: std::option::Option<bool>,
        pub(crate) text_qualifier: std::option::Option<crate::model::TextQualifier>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>File format.</p>
        pub fn format(mut self, input: crate::model::FileFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>File format.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::FileFormat>) -> Self {
            self.format = input;
            self
        }
        /// <p>A row number to start reading data from.</p>
        pub fn start_from_row(mut self, input: i32) -> Self {
            self.start_from_row = Some(input);
            self
        }
        /// <p>A row number to start reading data from.</p>
        pub fn set_start_from_row(mut self, input: std::option::Option<i32>) -> Self {
            self.start_from_row = input;
            self
        }
        /// <p>Whether the file has a header row, or the files each have a header row.</p>
        pub fn contains_header(mut self, input: bool) -> Self {
            self.contains_header = Some(input);
            self
        }
        /// <p>Whether the file has a header row, or the files each have a header row.</p>
        pub fn set_contains_header(mut self, input: std::option::Option<bool>) -> Self {
            self.contains_header = input;
            self
        }
        /// <p>Text qualifier.</p>
        pub fn text_qualifier(mut self, input: crate::model::TextQualifier) -> Self {
            self.text_qualifier = Some(input);
            self
        }
        /// <p>Text qualifier.</p>
        pub fn set_text_qualifier(
            mut self,
            input: std::option::Option<crate::model::TextQualifier>,
        ) -> Self {
            self.text_qualifier = input;
            self
        }
        /// <p>The delimiter between values in the file.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>The delimiter between values in the file.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadSettings`](crate::model::UploadSettings)
        pub fn build(self) -> crate::model::UploadSettings {
            crate::model::UploadSettings {
                format: self.format,
                start_from_row: self.start_from_row,
                contains_header: self.contains_header,
                text_qualifier: self.text_qualifier,
                delimiter: self.delimiter,
            }
        }
    }
}
impl UploadSettings {
    /// Creates a new builder-style object to manufacture [`UploadSettings`](crate::model::UploadSettings)
    pub fn builder() -> crate::model::upload_settings::Builder {
        crate::model::upload_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TextQualifier {
    #[allow(missing_docs)] // documentation missing in model
    DoubleQuote,
    #[allow(missing_docs)] // documentation missing in model
    SingleQuote,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TextQualifier {
    fn from(s: &str) -> Self {
        match s {
            "DOUBLE_QUOTE" => TextQualifier::DoubleQuote,
            "SINGLE_QUOTE" => TextQualifier::SingleQuote,
            other => TextQualifier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TextQualifier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TextQualifier::from(s))
    }
}
impl TextQualifier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TextQualifier::DoubleQuote => "DOUBLE_QUOTE",
            TextQualifier::SingleQuote => "SINGLE_QUOTE",
            TextQualifier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOUBLE_QUOTE", "SINGLE_QUOTE"]
    }
}
impl AsRef<str> for TextQualifier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileFormat {
    #[allow(missing_docs)] // documentation missing in model
    Clf,
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Elf,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Tsv,
    #[allow(missing_docs)] // documentation missing in model
    Xlsx,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileFormat {
    fn from(s: &str) -> Self {
        match s {
            "CLF" => FileFormat::Clf,
            "CSV" => FileFormat::Csv,
            "ELF" => FileFormat::Elf,
            "JSON" => FileFormat::Json,
            "TSV" => FileFormat::Tsv,
            "XLSX" => FileFormat::Xlsx,
            other => FileFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileFormat::from(s))
    }
}
impl FileFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileFormat::Clf => "CLF",
            FileFormat::Csv => "CSV",
            FileFormat::Elf => "ELF",
            FileFormat::Json => "JSON",
            FileFormat::Tsv => "TSV",
            FileFormat::Xlsx => "XLSX",
            FileFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLF", "CSV", "ELF", "JSON", "TSV", "XLSX"]
    }
}
impl AsRef<str> for FileFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A physical table type built from the results of the custom SQL query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomSql {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub data_source_arn: std::option::Option<std::string::String>,
    /// <p>A display name for the SQL query result.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The SQL query.</p>
    pub sql_query: std::option::Option<std::string::String>,
    /// <p>The column schema from the SQL query result set.</p>
    pub columns: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
}
impl CustomSql {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub fn data_source_arn(&self) -> std::option::Option<&str> {
        self.data_source_arn.as_deref()
    }
    /// <p>A display name for the SQL query result.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The SQL query.</p>
    pub fn sql_query(&self) -> std::option::Option<&str> {
        self.sql_query.as_deref()
    }
    /// <p>The column schema from the SQL query result set.</p>
    pub fn columns(&self) -> std::option::Option<&[crate::model::InputColumn]> {
        self.columns.as_deref()
    }
}
impl std::fmt::Debug for CustomSql {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomSql");
        formatter.field("data_source_arn", &self.data_source_arn);
        formatter.field("name", &self.name);
        formatter.field("sql_query", &self.sql_query);
        formatter.field("columns", &self.columns);
        formatter.finish()
    }
}
/// See [`CustomSql`](crate::model::CustomSql)
pub mod custom_sql {
    /// A builder for [`CustomSql`](crate::model::CustomSql)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sql_query: std::option::Option<std::string::String>,
        pub(crate) columns: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn data_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn set_data_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_arn = input;
            self
        }
        /// <p>A display name for the SQL query result.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the SQL query result.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The SQL query.</p>
        pub fn sql_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql_query = Some(input.into());
            self
        }
        /// <p>The SQL query.</p>
        pub fn set_sql_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql_query = input;
            self
        }
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>The column schema from the SQL query result set.</p>
        pub fn columns(mut self, input: impl Into<crate::model::InputColumn>) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input.into());
            self.columns = Some(v);
            self
        }
        /// <p>The column schema from the SQL query result set.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomSql`](crate::model::CustomSql)
        pub fn build(self) -> crate::model::CustomSql {
            crate::model::CustomSql {
                data_source_arn: self.data_source_arn,
                name: self.name,
                sql_query: self.sql_query,
                columns: self.columns,
            }
        }
    }
}
impl CustomSql {
    /// Creates a new builder-style object to manufacture [`CustomSql`](crate::model::CustomSql)
    pub fn builder() -> crate::model::custom_sql::Builder {
        crate::model::custom_sql::Builder::default()
    }
}

/// <p>A physical table type for relational data sources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalTable {
    /// <p>The Amazon Resource Name (ARN) for the data source.</p>
    pub data_source_arn: std::option::Option<std::string::String>,
    /// <p>The catalog associated with a table.</p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>The schema name. This name applies to certain relational database engines.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The name of the relational table.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The column schema of the table.</p>
    pub input_columns: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
}
impl RelationalTable {
    /// <p>The Amazon Resource Name (ARN) for the data source.</p>
    pub fn data_source_arn(&self) -> std::option::Option<&str> {
        self.data_source_arn.as_deref()
    }
    /// <p>The catalog associated with a table.</p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>The schema name. This name applies to certain relational database engines.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The name of the relational table.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The column schema of the table.</p>
    pub fn input_columns(&self) -> std::option::Option<&[crate::model::InputColumn]> {
        self.input_columns.as_deref()
    }
}
impl std::fmt::Debug for RelationalTable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalTable");
        formatter.field("data_source_arn", &self.data_source_arn);
        formatter.field("catalog", &self.catalog);
        formatter.field("schema", &self.schema);
        formatter.field("name", &self.name);
        formatter.field("input_columns", &self.input_columns);
        formatter.finish()
    }
}
/// See [`RelationalTable`](crate::model::RelationalTable)
pub mod relational_table {
    /// A builder for [`RelationalTable`](crate::model::RelationalTable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_arn: std::option::Option<std::string::String>,
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) input_columns: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the data source.</p>
        pub fn data_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the data source.</p>
        pub fn set_data_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_arn = input;
            self
        }
        /// <p>The catalog associated with a table.</p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>The catalog associated with a table.</p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// <p>The schema name. This name applies to certain relational database engines.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema name. This name applies to certain relational database engines.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The name of the relational table.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the relational table.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `input_columns`.
        ///
        /// To override the contents of this collection use [`set_input_columns`](Self::set_input_columns).
        ///
        /// <p>The column schema of the table.</p>
        pub fn input_columns(mut self, input: impl Into<crate::model::InputColumn>) -> Self {
            let mut v = self.input_columns.unwrap_or_default();
            v.push(input.into());
            self.input_columns = Some(v);
            self
        }
        /// <p>The column schema of the table.</p>
        pub fn set_input_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputColumn>>,
        ) -> Self {
            self.input_columns = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalTable`](crate::model::RelationalTable)
        pub fn build(self) -> crate::model::RelationalTable {
            crate::model::RelationalTable {
                data_source_arn: self.data_source_arn,
                catalog: self.catalog,
                schema: self.schema,
                name: self.name,
                input_columns: self.input_columns,
            }
        }
    }
}
impl RelationalTable {
    /// Creates a new builder-style object to manufacture [`RelationalTable`](crate::model::RelationalTable)
    pub fn builder() -> crate::model::relational_table::Builder {
        crate::model::relational_table::Builder::default()
    }
}

/// <p>Dashboard publish options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardPublishOptions {
    /// <p>Ad hoc (one-time) filtering option.</p>
    pub ad_hoc_filtering_option: std::option::Option<crate::model::AdHocFilteringOption>,
    /// <p>Export to .csv option.</p>
    pub export_to_csv_option: std::option::Option<crate::model::ExportToCsvOption>,
    /// <p>Sheet controls option.</p>
    pub sheet_controls_option: std::option::Option<crate::model::SheetControlsOption>,
}
impl DashboardPublishOptions {
    /// <p>Ad hoc (one-time) filtering option.</p>
    pub fn ad_hoc_filtering_option(
        &self,
    ) -> std::option::Option<&crate::model::AdHocFilteringOption> {
        self.ad_hoc_filtering_option.as_ref()
    }
    /// <p>Export to .csv option.</p>
    pub fn export_to_csv_option(&self) -> std::option::Option<&crate::model::ExportToCsvOption> {
        self.export_to_csv_option.as_ref()
    }
    /// <p>Sheet controls option.</p>
    pub fn sheet_controls_option(&self) -> std::option::Option<&crate::model::SheetControlsOption> {
        self.sheet_controls_option.as_ref()
    }
}
impl std::fmt::Debug for DashboardPublishOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardPublishOptions");
        formatter.field("ad_hoc_filtering_option", &self.ad_hoc_filtering_option);
        formatter.field("export_to_csv_option", &self.export_to_csv_option);
        formatter.field("sheet_controls_option", &self.sheet_controls_option);
        formatter.finish()
    }
}
/// See [`DashboardPublishOptions`](crate::model::DashboardPublishOptions)
pub mod dashboard_publish_options {
    /// A builder for [`DashboardPublishOptions`](crate::model::DashboardPublishOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ad_hoc_filtering_option: std::option::Option<crate::model::AdHocFilteringOption>,
        pub(crate) export_to_csv_option: std::option::Option<crate::model::ExportToCsvOption>,
        pub(crate) sheet_controls_option: std::option::Option<crate::model::SheetControlsOption>,
    }
    impl Builder {
        /// <p>Ad hoc (one-time) filtering option.</p>
        pub fn ad_hoc_filtering_option(
            mut self,
            input: crate::model::AdHocFilteringOption,
        ) -> Self {
            self.ad_hoc_filtering_option = Some(input);
            self
        }
        /// <p>Ad hoc (one-time) filtering option.</p>
        pub fn set_ad_hoc_filtering_option(
            mut self,
            input: std::option::Option<crate::model::AdHocFilteringOption>,
        ) -> Self {
            self.ad_hoc_filtering_option = input;
            self
        }
        /// <p>Export to .csv option.</p>
        pub fn export_to_csv_option(mut self, input: crate::model::ExportToCsvOption) -> Self {
            self.export_to_csv_option = Some(input);
            self
        }
        /// <p>Export to .csv option.</p>
        pub fn set_export_to_csv_option(
            mut self,
            input: std::option::Option<crate::model::ExportToCsvOption>,
        ) -> Self {
            self.export_to_csv_option = input;
            self
        }
        /// <p>Sheet controls option.</p>
        pub fn sheet_controls_option(mut self, input: crate::model::SheetControlsOption) -> Self {
            self.sheet_controls_option = Some(input);
            self
        }
        /// <p>Sheet controls option.</p>
        pub fn set_sheet_controls_option(
            mut self,
            input: std::option::Option<crate::model::SheetControlsOption>,
        ) -> Self {
            self.sheet_controls_option = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardPublishOptions`](crate::model::DashboardPublishOptions)
        pub fn build(self) -> crate::model::DashboardPublishOptions {
            crate::model::DashboardPublishOptions {
                ad_hoc_filtering_option: self.ad_hoc_filtering_option,
                export_to_csv_option: self.export_to_csv_option,
                sheet_controls_option: self.sheet_controls_option,
            }
        }
    }
}
impl DashboardPublishOptions {
    /// Creates a new builder-style object to manufacture [`DashboardPublishOptions`](crate::model::DashboardPublishOptions)
    pub fn builder() -> crate::model::dashboard_publish_options::Builder {
        crate::model::dashboard_publish_options::Builder::default()
    }
}

/// <p>Sheet controls option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SheetControlsOption {
    /// <p>Visibility state.</p>
    pub visibility_state: std::option::Option<crate::model::DashboardUiState>,
}
impl SheetControlsOption {
    /// <p>Visibility state.</p>
    pub fn visibility_state(&self) -> std::option::Option<&crate::model::DashboardUiState> {
        self.visibility_state.as_ref()
    }
}
impl std::fmt::Debug for SheetControlsOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SheetControlsOption");
        formatter.field("visibility_state", &self.visibility_state);
        formatter.finish()
    }
}
/// See [`SheetControlsOption`](crate::model::SheetControlsOption)
pub mod sheet_controls_option {
    /// A builder for [`SheetControlsOption`](crate::model::SheetControlsOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) visibility_state: std::option::Option<crate::model::DashboardUiState>,
    }
    impl Builder {
        /// <p>Visibility state.</p>
        pub fn visibility_state(mut self, input: crate::model::DashboardUiState) -> Self {
            self.visibility_state = Some(input);
            self
        }
        /// <p>Visibility state.</p>
        pub fn set_visibility_state(
            mut self,
            input: std::option::Option<crate::model::DashboardUiState>,
        ) -> Self {
            self.visibility_state = input;
            self
        }
        /// Consumes the builder and constructs a [`SheetControlsOption`](crate::model::SheetControlsOption)
        pub fn build(self) -> crate::model::SheetControlsOption {
            crate::model::SheetControlsOption {
                visibility_state: self.visibility_state,
            }
        }
    }
}
impl SheetControlsOption {
    /// Creates a new builder-style object to manufacture [`SheetControlsOption`](crate::model::SheetControlsOption)
    pub fn builder() -> crate::model::sheet_controls_option::Builder {
        crate::model::sheet_controls_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashboardUiState {
    #[allow(missing_docs)] // documentation missing in model
    Collapsed,
    #[allow(missing_docs)] // documentation missing in model
    Expanded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashboardUiState {
    fn from(s: &str) -> Self {
        match s {
            "COLLAPSED" => DashboardUiState::Collapsed,
            "EXPANDED" => DashboardUiState::Expanded,
            other => DashboardUiState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashboardUiState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashboardUiState::from(s))
    }
}
impl DashboardUiState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashboardUiState::Collapsed => "COLLAPSED",
            DashboardUiState::Expanded => "EXPANDED",
            DashboardUiState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COLLAPSED", "EXPANDED"]
    }
}
impl AsRef<str> for DashboardUiState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Export to .csv option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportToCsvOption {
    /// <p>Availability status.</p>
    pub availability_status: std::option::Option<crate::model::DashboardBehavior>,
}
impl ExportToCsvOption {
    /// <p>Availability status.</p>
    pub fn availability_status(&self) -> std::option::Option<&crate::model::DashboardBehavior> {
        self.availability_status.as_ref()
    }
}
impl std::fmt::Debug for ExportToCsvOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportToCsvOption");
        formatter.field("availability_status", &self.availability_status);
        formatter.finish()
    }
}
/// See [`ExportToCsvOption`](crate::model::ExportToCsvOption)
pub mod export_to_csv_option {
    /// A builder for [`ExportToCsvOption`](crate::model::ExportToCsvOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_status: std::option::Option<crate::model::DashboardBehavior>,
    }
    impl Builder {
        /// <p>Availability status.</p>
        pub fn availability_status(mut self, input: crate::model::DashboardBehavior) -> Self {
            self.availability_status = Some(input);
            self
        }
        /// <p>Availability status.</p>
        pub fn set_availability_status(
            mut self,
            input: std::option::Option<crate::model::DashboardBehavior>,
        ) -> Self {
            self.availability_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportToCsvOption`](crate::model::ExportToCsvOption)
        pub fn build(self) -> crate::model::ExportToCsvOption {
            crate::model::ExportToCsvOption {
                availability_status: self.availability_status,
            }
        }
    }
}
impl ExportToCsvOption {
    /// Creates a new builder-style object to manufacture [`ExportToCsvOption`](crate::model::ExportToCsvOption)
    pub fn builder() -> crate::model::export_to_csv_option::Builder {
        crate::model::export_to_csv_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashboardBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashboardBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DashboardBehavior::Disabled,
            "ENABLED" => DashboardBehavior::Enabled,
            other => DashboardBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashboardBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashboardBehavior::from(s))
    }
}
impl DashboardBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashboardBehavior::Disabled => "DISABLED",
            DashboardBehavior::Enabled => "ENABLED",
            DashboardBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DashboardBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Ad hoc (one-time) filtering option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdHocFilteringOption {
    /// <p>Availability status.</p>
    pub availability_status: std::option::Option<crate::model::DashboardBehavior>,
}
impl AdHocFilteringOption {
    /// <p>Availability status.</p>
    pub fn availability_status(&self) -> std::option::Option<&crate::model::DashboardBehavior> {
        self.availability_status.as_ref()
    }
}
impl std::fmt::Debug for AdHocFilteringOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdHocFilteringOption");
        formatter.field("availability_status", &self.availability_status);
        formatter.finish()
    }
}
/// See [`AdHocFilteringOption`](crate::model::AdHocFilteringOption)
pub mod ad_hoc_filtering_option {
    /// A builder for [`AdHocFilteringOption`](crate::model::AdHocFilteringOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_status: std::option::Option<crate::model::DashboardBehavior>,
    }
    impl Builder {
        /// <p>Availability status.</p>
        pub fn availability_status(mut self, input: crate::model::DashboardBehavior) -> Self {
            self.availability_status = Some(input);
            self
        }
        /// <p>Availability status.</p>
        pub fn set_availability_status(
            mut self,
            input: std::option::Option<crate::model::DashboardBehavior>,
        ) -> Self {
            self.availability_status = input;
            self
        }
        /// Consumes the builder and constructs a [`AdHocFilteringOption`](crate::model::AdHocFilteringOption)
        pub fn build(self) -> crate::model::AdHocFilteringOption {
            crate::model::AdHocFilteringOption {
                availability_status: self.availability_status,
            }
        }
    }
}
impl AdHocFilteringOption {
    /// Creates a new builder-style object to manufacture [`AdHocFilteringOption`](crate::model::AdHocFilteringOption)
    pub fn builder() -> crate::model::ad_hoc_filtering_option::Builder {
        crate::model::ad_hoc_filtering_option::Builder::default()
    }
}

/// <p>A list of Amazon QuickSight parameters and the list's override values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameters {
    /// <p>The parameters that have a data type of string.</p>
    pub string_parameters: std::option::Option<std::vec::Vec<crate::model::StringParameter>>,
    /// <p>The parameters that have a data type of integer.</p>
    pub integer_parameters: std::option::Option<std::vec::Vec<crate::model::IntegerParameter>>,
    /// <p>The parameters that have a data type of decimal.</p>
    pub decimal_parameters: std::option::Option<std::vec::Vec<crate::model::DecimalParameter>>,
    /// <p>The parameters that have a data type of date-time.</p>
    pub date_time_parameters: std::option::Option<std::vec::Vec<crate::model::DateTimeParameter>>,
}
impl Parameters {
    /// <p>The parameters that have a data type of string.</p>
    pub fn string_parameters(&self) -> std::option::Option<&[crate::model::StringParameter]> {
        self.string_parameters.as_deref()
    }
    /// <p>The parameters that have a data type of integer.</p>
    pub fn integer_parameters(&self) -> std::option::Option<&[crate::model::IntegerParameter]> {
        self.integer_parameters.as_deref()
    }
    /// <p>The parameters that have a data type of decimal.</p>
    pub fn decimal_parameters(&self) -> std::option::Option<&[crate::model::DecimalParameter]> {
        self.decimal_parameters.as_deref()
    }
    /// <p>The parameters that have a data type of date-time.</p>
    pub fn date_time_parameters(&self) -> std::option::Option<&[crate::model::DateTimeParameter]> {
        self.date_time_parameters.as_deref()
    }
}
impl std::fmt::Debug for Parameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameters");
        formatter.field("string_parameters", &self.string_parameters);
        formatter.field("integer_parameters", &self.integer_parameters);
        formatter.field("decimal_parameters", &self.decimal_parameters);
        formatter.field("date_time_parameters", &self.date_time_parameters);
        formatter.finish()
    }
}
/// See [`Parameters`](crate::model::Parameters)
pub mod parameters {
    /// A builder for [`Parameters`](crate::model::Parameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) string_parameters:
            std::option::Option<std::vec::Vec<crate::model::StringParameter>>,
        pub(crate) integer_parameters:
            std::option::Option<std::vec::Vec<crate::model::IntegerParameter>>,
        pub(crate) decimal_parameters:
            std::option::Option<std::vec::Vec<crate::model::DecimalParameter>>,
        pub(crate) date_time_parameters:
            std::option::Option<std::vec::Vec<crate::model::DateTimeParameter>>,
    }
    impl Builder {
        /// Appends an item to `string_parameters`.
        ///
        /// To override the contents of this collection use [`set_string_parameters`](Self::set_string_parameters).
        ///
        /// <p>The parameters that have a data type of string.</p>
        pub fn string_parameters(
            mut self,
            input: impl Into<crate::model::StringParameter>,
        ) -> Self {
            let mut v = self.string_parameters.unwrap_or_default();
            v.push(input.into());
            self.string_parameters = Some(v);
            self
        }
        /// <p>The parameters that have a data type of string.</p>
        pub fn set_string_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringParameter>>,
        ) -> Self {
            self.string_parameters = input;
            self
        }
        /// Appends an item to `integer_parameters`.
        ///
        /// To override the contents of this collection use [`set_integer_parameters`](Self::set_integer_parameters).
        ///
        /// <p>The parameters that have a data type of integer.</p>
        pub fn integer_parameters(
            mut self,
            input: impl Into<crate::model::IntegerParameter>,
        ) -> Self {
            let mut v = self.integer_parameters.unwrap_or_default();
            v.push(input.into());
            self.integer_parameters = Some(v);
            self
        }
        /// <p>The parameters that have a data type of integer.</p>
        pub fn set_integer_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntegerParameter>>,
        ) -> Self {
            self.integer_parameters = input;
            self
        }
        /// Appends an item to `decimal_parameters`.
        ///
        /// To override the contents of this collection use [`set_decimal_parameters`](Self::set_decimal_parameters).
        ///
        /// <p>The parameters that have a data type of decimal.</p>
        pub fn decimal_parameters(
            mut self,
            input: impl Into<crate::model::DecimalParameter>,
        ) -> Self {
            let mut v = self.decimal_parameters.unwrap_or_default();
            v.push(input.into());
            self.decimal_parameters = Some(v);
            self
        }
        /// <p>The parameters that have a data type of decimal.</p>
        pub fn set_decimal_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DecimalParameter>>,
        ) -> Self {
            self.decimal_parameters = input;
            self
        }
        /// Appends an item to `date_time_parameters`.
        ///
        /// To override the contents of this collection use [`set_date_time_parameters`](Self::set_date_time_parameters).
        ///
        /// <p>The parameters that have a data type of date-time.</p>
        pub fn date_time_parameters(
            mut self,
            input: impl Into<crate::model::DateTimeParameter>,
        ) -> Self {
            let mut v = self.date_time_parameters.unwrap_or_default();
            v.push(input.into());
            self.date_time_parameters = Some(v);
            self
        }
        /// <p>The parameters that have a data type of date-time.</p>
        pub fn set_date_time_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateTimeParameter>>,
        ) -> Self {
            self.date_time_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameters`](crate::model::Parameters)
        pub fn build(self) -> crate::model::Parameters {
            crate::model::Parameters {
                string_parameters: self.string_parameters,
                integer_parameters: self.integer_parameters,
                decimal_parameters: self.decimal_parameters,
                date_time_parameters: self.date_time_parameters,
            }
        }
    }
}
impl Parameters {
    /// Creates a new builder-style object to manufacture [`Parameters`](crate::model::Parameters)
    pub fn builder() -> crate::model::parameters::Builder {
        crate::model::parameters::Builder::default()
    }
}

/// <p>A date-time parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateTimeParameter {
    /// <p>A display name for the date-time parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The values for the date-time parameter.</p>
    pub values: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
}
impl DateTimeParameter {
    /// <p>A display name for the date-time parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The values for the date-time parameter.</p>
    pub fn values(&self) -> std::option::Option<&[aws_smithy_types::Instant]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for DateTimeParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateTimeParameter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`DateTimeParameter`](crate::model::DateTimeParameter)
pub mod date_time_parameter {
    /// A builder for [`DateTimeParameter`](crate::model::DateTimeParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
    }
    impl Builder {
        /// <p>A display name for the date-time parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the date-time parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values for the date-time parameter.</p>
        pub fn values(mut self, input: impl Into<aws_smithy_types::Instant>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values for the date-time parameter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`DateTimeParameter`](crate::model::DateTimeParameter)
        pub fn build(self) -> crate::model::DateTimeParameter {
            crate::model::DateTimeParameter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl DateTimeParameter {
    /// Creates a new builder-style object to manufacture [`DateTimeParameter`](crate::model::DateTimeParameter)
    pub fn builder() -> crate::model::date_time_parameter::Builder {
        crate::model::date_time_parameter::Builder::default()
    }
}

/// <p>A decimal parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecimalParameter {
    /// <p>A display name for the decimal parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The values for the decimal parameter.</p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
}
impl DecimalParameter {
    /// <p>A display name for the decimal parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The values for the decimal parameter.</p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for DecimalParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecimalParameter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`DecimalParameter`](crate::model::DecimalParameter)
pub mod decimal_parameter {
    /// A builder for [`DecimalParameter`](crate::model::DecimalParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// <p>A display name for the decimal parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the decimal parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values for the decimal parameter.</p>
        pub fn values(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values for the decimal parameter.</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`DecimalParameter`](crate::model::DecimalParameter)
        pub fn build(self) -> crate::model::DecimalParameter {
            crate::model::DecimalParameter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl DecimalParameter {
    /// Creates a new builder-style object to manufacture [`DecimalParameter`](crate::model::DecimalParameter)
    pub fn builder() -> crate::model::decimal_parameter::Builder {
        crate::model::decimal_parameter::Builder::default()
    }
}

/// <p>An integer parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntegerParameter {
    /// <p>The name of the integer parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The values for the integer parameter.</p>
    pub values: std::option::Option<std::vec::Vec<i64>>,
}
impl IntegerParameter {
    /// <p>The name of the integer parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The values for the integer parameter.</p>
    pub fn values(&self) -> std::option::Option<&[i64]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for IntegerParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntegerParameter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`IntegerParameter`](crate::model::IntegerParameter)
pub mod integer_parameter {
    /// A builder for [`IntegerParameter`](crate::model::IntegerParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<i64>>,
    }
    impl Builder {
        /// <p>The name of the integer parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the integer parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values for the integer parameter.</p>
        pub fn values(mut self, input: impl Into<i64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values for the integer parameter.</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<i64>>) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`IntegerParameter`](crate::model::IntegerParameter)
        pub fn build(self) -> crate::model::IntegerParameter {
            crate::model::IntegerParameter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl IntegerParameter {
    /// Creates a new builder-style object to manufacture [`IntegerParameter`](crate::model::IntegerParameter)
    pub fn builder() -> crate::model::integer_parameter::Builder {
        crate::model::integer_parameter::Builder::default()
    }
}

/// <p>A string parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StringParameter {
    /// <p>A display name for a string parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The values of a string parameter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StringParameter {
    /// <p>A display name for a string parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The values of a string parameter.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for StringParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StringParameter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`StringParameter`](crate::model::StringParameter)
pub mod string_parameter {
    /// A builder for [`StringParameter`](crate::model::StringParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A display name for a string parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for a string parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of a string parameter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of a string parameter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`StringParameter`](crate::model::StringParameter)
        pub fn build(self) -> crate::model::StringParameter {
            crate::model::StringParameter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl StringParameter {
    /// Creates a new builder-style object to manufacture [`StringParameter`](crate::model::StringParameter)
    pub fn builder() -> crate::model::string_parameter::Builder {
        crate::model::string_parameter::Builder::default()
    }
}

/// <p>Dashboard source entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardSourceEntity {
    /// <p>Source template.</p>
    pub source_template: std::option::Option<crate::model::DashboardSourceTemplate>,
}
impl DashboardSourceEntity {
    /// <p>Source template.</p>
    pub fn source_template(&self) -> std::option::Option<&crate::model::DashboardSourceTemplate> {
        self.source_template.as_ref()
    }
}
impl std::fmt::Debug for DashboardSourceEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardSourceEntity");
        formatter.field("source_template", &self.source_template);
        formatter.finish()
    }
}
/// See [`DashboardSourceEntity`](crate::model::DashboardSourceEntity)
pub mod dashboard_source_entity {
    /// A builder for [`DashboardSourceEntity`](crate::model::DashboardSourceEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_template: std::option::Option<crate::model::DashboardSourceTemplate>,
    }
    impl Builder {
        /// <p>Source template.</p>
        pub fn source_template(mut self, input: crate::model::DashboardSourceTemplate) -> Self {
            self.source_template = Some(input);
            self
        }
        /// <p>Source template.</p>
        pub fn set_source_template(
            mut self,
            input: std::option::Option<crate::model::DashboardSourceTemplate>,
        ) -> Self {
            self.source_template = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardSourceEntity`](crate::model::DashboardSourceEntity)
        pub fn build(self) -> crate::model::DashboardSourceEntity {
            crate::model::DashboardSourceEntity {
                source_template: self.source_template,
            }
        }
    }
}
impl DashboardSourceEntity {
    /// Creates a new builder-style object to manufacture [`DashboardSourceEntity`](crate::model::DashboardSourceEntity)
    pub fn builder() -> crate::model::dashboard_source_entity::Builder {
        crate::model::dashboard_source_entity::Builder::default()
    }
}

/// <p>Dashboard source template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardSourceTemplate {
    /// <p>Dataset references.</p>
    pub data_set_references: std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DashboardSourceTemplate {
    /// <p>Dataset references.</p>
    pub fn data_set_references(&self) -> std::option::Option<&[crate::model::DataSetReference]> {
        self.data_set_references.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DashboardSourceTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardSourceTemplate");
        formatter.field("data_set_references", &self.data_set_references);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DashboardSourceTemplate`](crate::model::DashboardSourceTemplate)
pub mod dashboard_source_template {
    /// A builder for [`DashboardSourceTemplate`](crate::model::DashboardSourceTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_references:
            std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `data_set_references`.
        ///
        /// To override the contents of this collection use [`set_data_set_references`](Self::set_data_set_references).
        ///
        /// <p>Dataset references.</p>
        pub fn data_set_references(
            mut self,
            input: impl Into<crate::model::DataSetReference>,
        ) -> Self {
            let mut v = self.data_set_references.unwrap_or_default();
            v.push(input.into());
            self.data_set_references = Some(v);
            self
        }
        /// <p>Dataset references.</p>
        pub fn set_data_set_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
        ) -> Self {
            self.data_set_references = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardSourceTemplate`](crate::model::DashboardSourceTemplate)
        pub fn build(self) -> crate::model::DashboardSourceTemplate {
            crate::model::DashboardSourceTemplate {
                data_set_references: self.data_set_references,
                arn: self.arn,
            }
        }
    }
}
impl DashboardSourceTemplate {
    /// Creates a new builder-style object to manufacture [`DashboardSourceTemplate`](crate::model::DashboardSourceTemplate)
    pub fn builder() -> crate::model::dashboard_source_template::Builder {
        crate::model::dashboard_source_template::Builder::default()
    }
}

/// <p>The source entity of an analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisSourceEntity {
    /// <p>The source template for the source entity of the analysis.</p>
    pub source_template: std::option::Option<crate::model::AnalysisSourceTemplate>,
}
impl AnalysisSourceEntity {
    /// <p>The source template for the source entity of the analysis.</p>
    pub fn source_template(&self) -> std::option::Option<&crate::model::AnalysisSourceTemplate> {
        self.source_template.as_ref()
    }
}
impl std::fmt::Debug for AnalysisSourceEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisSourceEntity");
        formatter.field("source_template", &self.source_template);
        formatter.finish()
    }
}
/// See [`AnalysisSourceEntity`](crate::model::AnalysisSourceEntity)
pub mod analysis_source_entity {
    /// A builder for [`AnalysisSourceEntity`](crate::model::AnalysisSourceEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_template: std::option::Option<crate::model::AnalysisSourceTemplate>,
    }
    impl Builder {
        /// <p>The source template for the source entity of the analysis.</p>
        pub fn source_template(mut self, input: crate::model::AnalysisSourceTemplate) -> Self {
            self.source_template = Some(input);
            self
        }
        /// <p>The source template for the source entity of the analysis.</p>
        pub fn set_source_template(
            mut self,
            input: std::option::Option<crate::model::AnalysisSourceTemplate>,
        ) -> Self {
            self.source_template = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisSourceEntity`](crate::model::AnalysisSourceEntity)
        pub fn build(self) -> crate::model::AnalysisSourceEntity {
            crate::model::AnalysisSourceEntity {
                source_template: self.source_template,
            }
        }
    }
}
impl AnalysisSourceEntity {
    /// Creates a new builder-style object to manufacture [`AnalysisSourceEntity`](crate::model::AnalysisSourceEntity)
    pub fn builder() -> crate::model::analysis_source_entity::Builder {
        crate::model::analysis_source_entity::Builder::default()
    }
}

/// <p>The source template of an analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisSourceTemplate {
    /// <p>The dataset references of the source template of an analysis.</p>
    pub data_set_references: std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
    /// <p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl AnalysisSourceTemplate {
    /// <p>The dataset references of the source template of an analysis.</p>
    pub fn data_set_references(&self) -> std::option::Option<&[crate::model::DataSetReference]> {
        self.data_set_references.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for AnalysisSourceTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisSourceTemplate");
        formatter.field("data_set_references", &self.data_set_references);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`AnalysisSourceTemplate`](crate::model::AnalysisSourceTemplate)
pub mod analysis_source_template {
    /// A builder for [`AnalysisSourceTemplate`](crate::model::AnalysisSourceTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_set_references:
            std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `data_set_references`.
        ///
        /// To override the contents of this collection use [`set_data_set_references`](Self::set_data_set_references).
        ///
        /// <p>The dataset references of the source template of an analysis.</p>
        pub fn data_set_references(
            mut self,
            input: impl Into<crate::model::DataSetReference>,
        ) -> Self {
            let mut v = self.data_set_references.unwrap_or_default();
            v.push(input.into());
            self.data_set_references = Some(v);
            self
        }
        /// <p>The dataset references of the source template of an analysis.</p>
        pub fn set_data_set_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSetReference>>,
        ) -> Self {
            self.data_set_references = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source template of an analysis.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisSourceTemplate`](crate::model::AnalysisSourceTemplate)
        pub fn build(self) -> crate::model::AnalysisSourceTemplate {
            crate::model::AnalysisSourceTemplate {
                data_set_references: self.data_set_references,
                arn: self.arn,
            }
        }
    }
}
impl AnalysisSourceTemplate {
    /// Creates a new builder-style object to manufacture [`AnalysisSourceTemplate`](crate::model::AnalysisSourceTemplate)
    pub fn builder() -> crate::model::analysis_source_template::Builder {
        crate::model::analysis_source_template::Builder::default()
    }
}

/// <p>The Amazon QuickSight customizations associated with your Amazon Web Services account or a Amazon QuickSight namespace in a specific Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountCustomization {
    /// <p>The default theme for this Amazon QuickSight subscription.</p>
    pub default_theme: std::option::Option<std::string::String>,
}
impl AccountCustomization {
    /// <p>The default theme for this Amazon QuickSight subscription.</p>
    pub fn default_theme(&self) -> std::option::Option<&str> {
        self.default_theme.as_deref()
    }
}
impl std::fmt::Debug for AccountCustomization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountCustomization");
        formatter.field("default_theme", &self.default_theme);
        formatter.finish()
    }
}
/// See [`AccountCustomization`](crate::model::AccountCustomization)
pub mod account_customization {
    /// A builder for [`AccountCustomization`](crate::model::AccountCustomization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_theme: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The default theme for this Amazon QuickSight subscription.</p>
        pub fn default_theme(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_theme = Some(input.into());
            self
        }
        /// <p>The default theme for this Amazon QuickSight subscription.</p>
        pub fn set_default_theme(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_theme = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountCustomization`](crate::model::AccountCustomization)
        pub fn build(self) -> crate::model::AccountCustomization {
            crate::model::AccountCustomization {
                default_theme: self.default_theme,
            }
        }
    }
}
impl AccountCustomization {
    /// Creates a new builder-style object to manufacture [`AccountCustomization`](crate::model::AccountCustomization)
    pub fn builder() -> crate::model::account_customization::Builder {
        crate::model::account_customization::Builder::default()
    }
}

/// <p>The key or keys of the key-value pairs for the resource tag or tags assigned to the
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>A summary of the folder. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FolderSummary {
    /// <p>The Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The folder ID.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The display name of the folder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of folder.</p>
    pub folder_type: std::option::Option<crate::model::FolderType>,
    /// <p>The time that the folder was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the folder was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl FolderSummary {
    /// <p>The Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The folder ID.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The display name of the folder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of folder.</p>
    pub fn folder_type(&self) -> std::option::Option<&crate::model::FolderType> {
        self.folder_type.as_ref()
    }
    /// <p>The time that the folder was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The time that the folder was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for FolderSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FolderSummary");
        formatter.field("arn", &self.arn);
        formatter.field("folder_id", &self.folder_id);
        formatter.field("name", &self.name);
        formatter.field("folder_type", &self.folder_type);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`FolderSummary`](crate::model::FolderSummary)
pub mod folder_summary {
    /// A builder for [`FolderSummary`](crate::model::FolderSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) folder_type: std::option::Option<crate::model::FolderType>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The display name of the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The display name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of folder.</p>
        pub fn folder_type(mut self, input: crate::model::FolderType) -> Self {
            self.folder_type = Some(input);
            self
        }
        /// <p>The type of folder.</p>
        pub fn set_folder_type(
            mut self,
            input: std::option::Option<crate::model::FolderType>,
        ) -> Self {
            self.folder_type = input;
            self
        }
        /// <p>The time that the folder was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that the folder was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The time that the folder was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time that the folder was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`FolderSummary`](crate::model::FolderSummary)
        pub fn build(self) -> crate::model::FolderSummary {
            crate::model::FolderSummary {
                arn: self.arn,
                folder_id: self.folder_id,
                name: self.name,
                folder_type: self.folder_type,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl FolderSummary {
    /// Creates a new builder-style object to manufacture [`FolderSummary`](crate::model::FolderSummary)
    pub fn builder() -> crate::model::folder_summary::Builder {
        crate::model::folder_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FolderType {
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FolderType {
    fn from(s: &str) -> Self {
        match s {
            "SHARED" => FolderType::Shared,
            other => FolderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FolderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FolderType::from(s))
    }
}
impl FolderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FolderType::Shared => "SHARED",
            FolderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SHARED"]
    }
}
impl AsRef<str> for FolderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Searches a folder by a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FolderSearchFilter {
    /// <p>The comparison operator that you want to use as a filter. For example, <code>"Operator": "StringEquals"</code>.</p>
    pub operator: std::option::Option<crate::model::FilterOperator>,
    /// <p>The name of the value that you want to use as a filter. For example, <code>"Name": "PARENT_FOLDER_ARN"</code>.</p>
    pub name: std::option::Option<crate::model::FolderFilterAttribute>,
    /// <p>The value of the named item (in this example, <code>PARENT_FOLDER_ARN</code>), that you want to use as a filter. For example, <code>"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"</code>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl FolderSearchFilter {
    /// <p>The comparison operator that you want to use as a filter. For example, <code>"Operator": "StringEquals"</code>.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::FilterOperator> {
        self.operator.as_ref()
    }
    /// <p>The name of the value that you want to use as a filter. For example, <code>"Name": "PARENT_FOLDER_ARN"</code>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::FolderFilterAttribute> {
        self.name.as_ref()
    }
    /// <p>The value of the named item (in this example, <code>PARENT_FOLDER_ARN</code>), that you want to use as a filter. For example, <code>"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"</code>.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for FolderSearchFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FolderSearchFilter");
        formatter.field("operator", &self.operator);
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`FolderSearchFilter`](crate::model::FolderSearchFilter)
pub mod folder_search_filter {
    /// A builder for [`FolderSearchFilter`](crate::model::FolderSearchFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operator: std::option::Option<crate::model::FilterOperator>,
        pub(crate) name: std::option::Option<crate::model::FolderFilterAttribute>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The comparison operator that you want to use as a filter. For example, <code>"Operator": "StringEquals"</code>.</p>
        pub fn operator(mut self, input: crate::model::FilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The comparison operator that you want to use as a filter. For example, <code>"Operator": "StringEquals"</code>.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::FilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// <p>The name of the value that you want to use as a filter. For example, <code>"Name": "PARENT_FOLDER_ARN"</code>.</p>
        pub fn name(mut self, input: crate::model::FolderFilterAttribute) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the value that you want to use as a filter. For example, <code>"Name": "PARENT_FOLDER_ARN"</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::FolderFilterAttribute>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the named item (in this example, <code>PARENT_FOLDER_ARN</code>), that you want to use as a filter. For example, <code>"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the named item (in this example, <code>PARENT_FOLDER_ARN</code>), that you want to use as a filter. For example, <code>"Value": "arn:aws:quicksight:us-east-1:1:folder/folderId"</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`FolderSearchFilter`](crate::model::FolderSearchFilter)
        pub fn build(self) -> crate::model::FolderSearchFilter {
            crate::model::FolderSearchFilter {
                operator: self.operator,
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl FolderSearchFilter {
    /// Creates a new builder-style object to manufacture [`FolderSearchFilter`](crate::model::FolderSearchFilter)
    pub fn builder() -> crate::model::folder_search_filter::Builder {
        crate::model::folder_search_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FolderFilterAttribute {
    #[allow(missing_docs)] // documentation missing in model
    ParentFolderArn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FolderFilterAttribute {
    fn from(s: &str) -> Self {
        match s {
            "PARENT_FOLDER_ARN" => FolderFilterAttribute::ParentFolderArn,
            other => FolderFilterAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FolderFilterAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FolderFilterAttribute::from(s))
    }
}
impl FolderFilterAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FolderFilterAttribute::ParentFolderArn => "PARENT_FOLDER_ARN",
            FolderFilterAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PARENT_FOLDER_ARN"]
    }
}
impl AsRef<str> for FolderFilterAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    StringEquals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "StringEquals" => FilterOperator::StringEquals,
            other => FilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterOperator::from(s))
    }
}
impl FilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterOperator::StringEquals => "StringEquals",
            FilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["StringEquals"]
    }
}
impl AsRef<str> for FilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Dashboard summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardSummary {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Dashboard ID.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>A display name for the dashboard.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that this dashboard was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this dashboard was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Published version number.</p>
    pub published_version_number: std::option::Option<i64>,
    /// <p>The last time that this dashboard was published.</p>
    pub last_published_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DashboardSummary {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Dashboard ID.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>A display name for the dashboard.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time that this dashboard was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The last time that this dashboard was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>Published version number.</p>
    pub fn published_version_number(&self) -> std::option::Option<i64> {
        self.published_version_number
    }
    /// <p>The last time that this dashboard was published.</p>
    pub fn last_published_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_published_time.as_ref()
    }
}
impl std::fmt::Debug for DashboardSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardSummary");
        formatter.field("arn", &self.arn);
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("name", &self.name);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("published_version_number", &self.published_version_number);
        formatter.field("last_published_time", &self.last_published_time);
        formatter.finish()
    }
}
/// See [`DashboardSummary`](crate::model::DashboardSummary)
pub mod dashboard_summary {
    /// A builder for [`DashboardSummary`](crate::model::DashboardSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) published_version_number: std::option::Option<i64>,
        pub(crate) last_published_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Dashboard ID.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>Dashboard ID.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>A display name for the dashboard.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that this dashboard was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this dashboard was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The last time that this dashboard was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that this dashboard was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Published version number.</p>
        pub fn published_version_number(mut self, input: i64) -> Self {
            self.published_version_number = Some(input);
            self
        }
        /// <p>Published version number.</p>
        pub fn set_published_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.published_version_number = input;
            self
        }
        /// <p>The last time that this dashboard was published.</p>
        pub fn last_published_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_published_time = Some(input);
            self
        }
        /// <p>The last time that this dashboard was published.</p>
        pub fn set_last_published_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_published_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardSummary`](crate::model::DashboardSummary)
        pub fn build(self) -> crate::model::DashboardSummary {
            crate::model::DashboardSummary {
                arn: self.arn,
                dashboard_id: self.dashboard_id,
                name: self.name,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                published_version_number: self.published_version_number,
                last_published_time: self.last_published_time,
            }
        }
    }
}
impl DashboardSummary {
    /// Creates a new builder-style object to manufacture [`DashboardSummary`](crate::model::DashboardSummary)
    pub fn builder() -> crate::model::dashboard_summary::Builder {
        crate::model::dashboard_summary::Builder::default()
    }
}

/// <p>A filter that you apply when searching for dashboards. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardSearchFilter {
    /// <p>The comparison operator that you want to use as a filter, for example,
    /// <code>"Operator": "StringEquals"</code>.</p>
    pub operator: std::option::Option<crate::model::FilterOperator>,
    /// <p>The name of the value that you want to use as a filter, for example, <code>"Name":
    /// "QUICKSIGHT_USER"</code>. </p>
    pub name: std::option::Option<crate::model::DashboardFilterAttribute>,
    /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
    /// to use as a filter, for example, <code>"Value":
    /// "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>. </p>
    pub value: std::option::Option<std::string::String>,
}
impl DashboardSearchFilter {
    /// <p>The comparison operator that you want to use as a filter, for example,
    /// <code>"Operator": "StringEquals"</code>.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::FilterOperator> {
        self.operator.as_ref()
    }
    /// <p>The name of the value that you want to use as a filter, for example, <code>"Name":
    /// "QUICKSIGHT_USER"</code>. </p>
    pub fn name(&self) -> std::option::Option<&crate::model::DashboardFilterAttribute> {
        self.name.as_ref()
    }
    /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
    /// to use as a filter, for example, <code>"Value":
    /// "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for DashboardSearchFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardSearchFilter");
        formatter.field("operator", &self.operator);
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DashboardSearchFilter`](crate::model::DashboardSearchFilter)
pub mod dashboard_search_filter {
    /// A builder for [`DashboardSearchFilter`](crate::model::DashboardSearchFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operator: std::option::Option<crate::model::FilterOperator>,
        pub(crate) name: std::option::Option<crate::model::DashboardFilterAttribute>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The comparison operator that you want to use as a filter, for example,
        /// <code>"Operator": "StringEquals"</code>.</p>
        pub fn operator(mut self, input: crate::model::FilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The comparison operator that you want to use as a filter, for example,
        /// <code>"Operator": "StringEquals"</code>.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::FilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// <p>The name of the value that you want to use as a filter, for example, <code>"Name":
        /// "QUICKSIGHT_USER"</code>. </p>
        pub fn name(mut self, input: crate::model::DashboardFilterAttribute) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the value that you want to use as a filter, for example, <code>"Name":
        /// "QUICKSIGHT_USER"</code>. </p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::DashboardFilterAttribute>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
        /// to use as a filter, for example, <code>"Value":
        /// "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
        /// to use as a filter, for example, <code>"Value":
        /// "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardSearchFilter`](crate::model::DashboardSearchFilter)
        pub fn build(self) -> crate::model::DashboardSearchFilter {
            crate::model::DashboardSearchFilter {
                operator: self.operator,
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl DashboardSearchFilter {
    /// Creates a new builder-style object to manufacture [`DashboardSearchFilter`](crate::model::DashboardSearchFilter)
    pub fn builder() -> crate::model::dashboard_search_filter::Builder {
        crate::model::dashboard_search_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashboardFilterAttribute {
    #[allow(missing_docs)] // documentation missing in model
    QuicksightUser,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashboardFilterAttribute {
    fn from(s: &str) -> Self {
        match s {
            "QUICKSIGHT_USER" => DashboardFilterAttribute::QuicksightUser,
            other => DashboardFilterAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashboardFilterAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashboardFilterAttribute::from(s))
    }
}
impl DashboardFilterAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashboardFilterAttribute::QuicksightUser => "QUICKSIGHT_USER",
            DashboardFilterAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["QUICKSIGHT_USER"]
    }
}
impl AsRef<str> for DashboardFilterAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The summary metadata that describes an analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisSummary {
    /// <p>The Amazon Resource Name (ARN) for the analysis.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the analysis. This ID displays in the URL.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The name of the analysis. This name is displayed in the Amazon QuickSight console.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The last known status for the analysis.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The time that the analysis was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the analysis was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl AnalysisSummary {
    /// <p>The Amazon Resource Name (ARN) for the analysis.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the analysis. This ID displays in the URL.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The name of the analysis. This name is displayed in the Amazon QuickSight console.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The last known status for the analysis.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>The time that the analysis was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The time that the analysis was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for AnalysisSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisSummary");
        formatter.field("arn", &self.arn);
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`AnalysisSummary`](crate::model::AnalysisSummary)
pub mod analysis_summary {
    /// A builder for [`AnalysisSummary`](crate::model::AnalysisSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the analysis.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the analysis.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the analysis. This ID displays in the URL.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis. This ID displays in the URL.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The name of the analysis. This name is displayed in the Amazon QuickSight console.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the analysis. This name is displayed in the Amazon QuickSight console.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The last known status for the analysis.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The last known status for the analysis.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time that the analysis was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that the analysis was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The time that the analysis was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time that the analysis was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisSummary`](crate::model::AnalysisSummary)
        pub fn build(self) -> crate::model::AnalysisSummary {
            crate::model::AnalysisSummary {
                arn: self.arn,
                analysis_id: self.analysis_id,
                name: self.name,
                status: self.status,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl AnalysisSummary {
    /// Creates a new builder-style object to manufacture [`AnalysisSummary`](crate::model::AnalysisSummary)
    pub fn builder() -> crate::model::analysis_summary::Builder {
        crate::model::analysis_summary::Builder::default()
    }
}

/// <p>A filter that you apply when searching for one or more analyses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisSearchFilter {
    /// <p>The comparison operator that you want to use as a filter, for example
    /// <code>"Operator": "StringEquals"</code>.</p>
    pub operator: std::option::Option<crate::model::FilterOperator>,
    /// <p>The name of the value that you want to use as a filter, for example <code>"Name":
    /// "QUICKSIGHT_USER"</code>.</p>
    pub name: std::option::Option<crate::model::AnalysisFilterAttribute>,
    /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
    /// to use as a filter, for example <code>"Value"</code>. An example is
    /// <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl AnalysisSearchFilter {
    /// <p>The comparison operator that you want to use as a filter, for example
    /// <code>"Operator": "StringEquals"</code>.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::FilterOperator> {
        self.operator.as_ref()
    }
    /// <p>The name of the value that you want to use as a filter, for example <code>"Name":
    /// "QUICKSIGHT_USER"</code>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::AnalysisFilterAttribute> {
        self.name.as_ref()
    }
    /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
    /// to use as a filter, for example <code>"Value"</code>. An example is
    /// <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for AnalysisSearchFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisSearchFilter");
        formatter.field("operator", &self.operator);
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AnalysisSearchFilter`](crate::model::AnalysisSearchFilter)
pub mod analysis_search_filter {
    /// A builder for [`AnalysisSearchFilter`](crate::model::AnalysisSearchFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operator: std::option::Option<crate::model::FilterOperator>,
        pub(crate) name: std::option::Option<crate::model::AnalysisFilterAttribute>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The comparison operator that you want to use as a filter, for example
        /// <code>"Operator": "StringEquals"</code>.</p>
        pub fn operator(mut self, input: crate::model::FilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The comparison operator that you want to use as a filter, for example
        /// <code>"Operator": "StringEquals"</code>.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::FilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// <p>The name of the value that you want to use as a filter, for example <code>"Name":
        /// "QUICKSIGHT_USER"</code>.</p>
        pub fn name(mut self, input: crate::model::AnalysisFilterAttribute) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the value that you want to use as a filter, for example <code>"Name":
        /// "QUICKSIGHT_USER"</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::AnalysisFilterAttribute>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
        /// to use as a filter, for example <code>"Value"</code>. An example is
        /// <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want
        /// to use as a filter, for example <code>"Value"</code>. An example is
        /// <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisSearchFilter`](crate::model::AnalysisSearchFilter)
        pub fn build(self) -> crate::model::AnalysisSearchFilter {
            crate::model::AnalysisSearchFilter {
                operator: self.operator,
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl AnalysisSearchFilter {
    /// Creates a new builder-style object to manufacture [`AnalysisSearchFilter`](crate::model::AnalysisSearchFilter)
    pub fn builder() -> crate::model::analysis_search_filter::Builder {
        crate::model::analysis_search_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalysisFilterAttribute {
    #[allow(missing_docs)] // documentation missing in model
    QuicksightUser,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalysisFilterAttribute {
    fn from(s: &str) -> Self {
        match s {
            "QUICKSIGHT_USER" => AnalysisFilterAttribute::QuicksightUser,
            other => AnalysisFilterAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalysisFilterAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalysisFilterAttribute::from(s))
    }
}
impl AnalysisFilterAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalysisFilterAttribute::QuicksightUser => "QUICKSIGHT_USER",
            AnalysisFilterAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["QUICKSIGHT_USER"]
    }
}
impl AsRef<str> for AnalysisFilterAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The theme version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeVersionSummary {
    /// <p>The version number of the theme version.</p>
    pub version_number: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the theme version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description of the theme version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time that this theme version was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the theme version.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
}
impl ThemeVersionSummary {
    /// <p>The version number of the theme version.</p>
    pub fn version_number(&self) -> std::option::Option<i64> {
        self.version_number
    }
    /// <p>The Amazon Resource Name (ARN) of the theme version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description of the theme version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time that this theme version was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The status of the theme version.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ThemeVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeVersionSummary");
        formatter.field("version_number", &self.version_number);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("created_time", &self.created_time);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ThemeVersionSummary`](crate::model::ThemeVersionSummary)
pub mod theme_version_summary {
    /// A builder for [`ThemeVersionSummary`](crate::model::ThemeVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
    }
    impl Builder {
        /// <p>The version number of the theme version.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the theme version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description of the theme version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the theme version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time that this theme version was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that this theme version was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The status of the theme version.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the theme version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeVersionSummary`](crate::model::ThemeVersionSummary)
        pub fn build(self) -> crate::model::ThemeVersionSummary {
            crate::model::ThemeVersionSummary {
                version_number: self.version_number,
                arn: self.arn,
                description: self.description,
                created_time: self.created_time,
                status: self.status,
            }
        }
    }
}
impl ThemeVersionSummary {
    /// Creates a new builder-style object to manufacture [`ThemeVersionSummary`](crate::model::ThemeVersionSummary)
    pub fn builder() -> crate::model::theme_version_summary::Builder {
        crate::model::theme_version_summary::Builder::default()
    }
}

/// <p>The theme summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeSummary {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>the display name for the theme.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the theme. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub theme_id: std::option::Option<std::string::String>,
    /// <p>The latest version number for the theme. </p>
    pub latest_version_number: std::option::Option<i64>,
    /// <p>The date and time that this theme was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last date and time that this theme was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl ThemeSummary {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>the display name for the theme.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the theme. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
    /// <p>The latest version number for the theme. </p>
    pub fn latest_version_number(&self) -> std::option::Option<i64> {
        self.latest_version_number
    }
    /// <p>The date and time that this theme was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The last date and time that this theme was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for ThemeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("theme_id", &self.theme_id);
        formatter.field("latest_version_number", &self.latest_version_number);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`ThemeSummary`](crate::model::ThemeSummary)
pub mod theme_summary {
    /// A builder for [`ThemeSummary`](crate::model::ThemeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) latest_version_number: std::option::Option<i64>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>the display name for the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>the display name for the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the theme. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The ID of the theme. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>The latest version number for the theme. </p>
        pub fn latest_version_number(mut self, input: i64) -> Self {
            self.latest_version_number = Some(input);
            self
        }
        /// <p>The latest version number for the theme. </p>
        pub fn set_latest_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.latest_version_number = input;
            self
        }
        /// <p>The date and time that this theme was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that this theme was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The last date and time that this theme was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last date and time that this theme was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeSummary`](crate::model::ThemeSummary)
        pub fn build(self) -> crate::model::ThemeSummary {
            crate::model::ThemeSummary {
                arn: self.arn,
                name: self.name,
                theme_id: self.theme_id,
                latest_version_number: self.latest_version_number,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl ThemeSummary {
    /// Creates a new builder-style object to manufacture [`ThemeSummary`](crate::model::ThemeSummary)
    pub fn builder() -> crate::model::theme_summary::Builder {
        crate::model::theme_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThemeType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Quicksight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThemeType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ThemeType::All,
            "CUSTOM" => ThemeType::Custom,
            "QUICKSIGHT" => ThemeType::Quicksight,
            other => ThemeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThemeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThemeType::from(s))
    }
}
impl ThemeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThemeType::All => "ALL",
            ThemeType::Custom => "CUSTOM",
            ThemeType::Quicksight => "QUICKSIGHT",
            ThemeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CUSTOM", "QUICKSIGHT"]
    }
}
impl AsRef<str> for ThemeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The template version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateVersionSummary {
    /// <p>The Amazon Resource Name (ARN) of the template version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version number of the template version.</p>
    pub version_number: std::option::Option<i64>,
    /// <p>The time that this template version was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the template version.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The description of the template version.</p>
    pub description: std::option::Option<std::string::String>,
}
impl TemplateVersionSummary {
    /// <p>The Amazon Resource Name (ARN) of the template version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version number of the template version.</p>
    pub fn version_number(&self) -> std::option::Option<i64> {
        self.version_number
    }
    /// <p>The time that this template version was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The status of the template version.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>The description of the template version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for TemplateVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateVersionSummary");
        formatter.field("arn", &self.arn);
        formatter.field("version_number", &self.version_number);
        formatter.field("created_time", &self.created_time);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`TemplateVersionSummary`](crate::model::TemplateVersionSummary)
pub mod template_version_summary {
    /// A builder for [`TemplateVersionSummary`](crate::model::TemplateVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the template version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version number of the template version.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the template version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The time that this template version was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this template version was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The status of the template version.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the template version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the template version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the template version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateVersionSummary`](crate::model::TemplateVersionSummary)
        pub fn build(self) -> crate::model::TemplateVersionSummary {
            crate::model::TemplateVersionSummary {
                arn: self.arn,
                version_number: self.version_number,
                created_time: self.created_time,
                status: self.status,
                description: self.description,
            }
        }
    }
}
impl TemplateVersionSummary {
    /// Creates a new builder-style object to manufacture [`TemplateVersionSummary`](crate::model::TemplateVersionSummary)
    pub fn builder() -> crate::model::template_version_summary::Builder {
        crate::model::template_version_summary::Builder::default()
    }
}

/// <p>The template summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateSummary {
    /// <p>A summary of a template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the template. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>A display name for the template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A structure containing a list of version numbers for the template summary.</p>
    pub latest_version_number: std::option::Option<i64>,
    /// <p>The last time that this template was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this template was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl TemplateSummary {
    /// <p>A summary of a template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the template. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>A display name for the template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A structure containing a list of version numbers for the template summary.</p>
    pub fn latest_version_number(&self) -> std::option::Option<i64> {
        self.latest_version_number
    }
    /// <p>The last time that this template was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The last time that this template was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for TemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateSummary");
        formatter.field("arn", &self.arn);
        formatter.field("template_id", &self.template_id);
        formatter.field("name", &self.name);
        formatter.field("latest_version_number", &self.latest_version_number);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`TemplateSummary`](crate::model::TemplateSummary)
pub mod template_summary {
    /// A builder for [`TemplateSummary`](crate::model::TemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) latest_version_number: std::option::Option<i64>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A summary of a template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>A summary of a template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the template. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID of the template. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>A display name for the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A structure containing a list of version numbers for the template summary.</p>
        pub fn latest_version_number(mut self, input: i64) -> Self {
            self.latest_version_number = Some(input);
            self
        }
        /// <p>A structure containing a list of version numbers for the template summary.</p>
        pub fn set_latest_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.latest_version_number = input;
            self
        }
        /// <p>The last time that this template was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The last time that this template was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The last time that this template was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that this template was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateSummary`](crate::model::TemplateSummary)
        pub fn build(self) -> crate::model::TemplateSummary {
            crate::model::TemplateSummary {
                arn: self.arn,
                template_id: self.template_id,
                name: self.name,
                latest_version_number: self.latest_version_number,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl TemplateSummary {
    /// Creates a new builder-style object to manufacture [`TemplateSummary`](crate::model::TemplateSummary)
    pub fn builder() -> crate::model::template_summary::Builder {
        crate::model::template_summary::Builder::default()
    }
}

/// <p>The error type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamespaceInfoV2 {
    /// <p>The name of the error.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The namespace ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The namespace Amazon Web Services Region.</p>
    pub capacity_region: std::option::Option<std::string::String>,
    /// <p>The creation status of a namespace that is not yet completely created.</p>
    pub creation_status: std::option::Option<crate::model::NamespaceStatus>,
    /// <p>The identity store used for the namespace.</p>
    pub identity_store: std::option::Option<crate::model::IdentityStore>,
    /// <p>An error that occurred when the namespace was created.</p>
    pub namespace_error: std::option::Option<crate::model::NamespaceError>,
}
impl NamespaceInfoV2 {
    /// <p>The name of the error.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The namespace ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The namespace Amazon Web Services Region.</p>
    pub fn capacity_region(&self) -> std::option::Option<&str> {
        self.capacity_region.as_deref()
    }
    /// <p>The creation status of a namespace that is not yet completely created.</p>
    pub fn creation_status(&self) -> std::option::Option<&crate::model::NamespaceStatus> {
        self.creation_status.as_ref()
    }
    /// <p>The identity store used for the namespace.</p>
    pub fn identity_store(&self) -> std::option::Option<&crate::model::IdentityStore> {
        self.identity_store.as_ref()
    }
    /// <p>An error that occurred when the namespace was created.</p>
    pub fn namespace_error(&self) -> std::option::Option<&crate::model::NamespaceError> {
        self.namespace_error.as_ref()
    }
}
impl std::fmt::Debug for NamespaceInfoV2 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamespaceInfoV2");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("capacity_region", &self.capacity_region);
        formatter.field("creation_status", &self.creation_status);
        formatter.field("identity_store", &self.identity_store);
        formatter.field("namespace_error", &self.namespace_error);
        formatter.finish()
    }
}
/// See [`NamespaceInfoV2`](crate::model::NamespaceInfoV2)
pub mod namespace_info_v2 {
    /// A builder for [`NamespaceInfoV2`](crate::model::NamespaceInfoV2)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) capacity_region: std::option::Option<std::string::String>,
        pub(crate) creation_status: std::option::Option<crate::model::NamespaceStatus>,
        pub(crate) identity_store: std::option::Option<crate::model::IdentityStore>,
        pub(crate) namespace_error: std::option::Option<crate::model::NamespaceError>,
    }
    impl Builder {
        /// <p>The name of the error.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the error.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The namespace ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The namespace ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The namespace Amazon Web Services Region.</p>
        pub fn capacity_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_region = Some(input.into());
            self
        }
        /// <p>The namespace Amazon Web Services Region.</p>
        pub fn set_capacity_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_region = input;
            self
        }
        /// <p>The creation status of a namespace that is not yet completely created.</p>
        pub fn creation_status(mut self, input: crate::model::NamespaceStatus) -> Self {
            self.creation_status = Some(input);
            self
        }
        /// <p>The creation status of a namespace that is not yet completely created.</p>
        pub fn set_creation_status(
            mut self,
            input: std::option::Option<crate::model::NamespaceStatus>,
        ) -> Self {
            self.creation_status = input;
            self
        }
        /// <p>The identity store used for the namespace.</p>
        pub fn identity_store(mut self, input: crate::model::IdentityStore) -> Self {
            self.identity_store = Some(input);
            self
        }
        /// <p>The identity store used for the namespace.</p>
        pub fn set_identity_store(
            mut self,
            input: std::option::Option<crate::model::IdentityStore>,
        ) -> Self {
            self.identity_store = input;
            self
        }
        /// <p>An error that occurred when the namespace was created.</p>
        pub fn namespace_error(mut self, input: crate::model::NamespaceError) -> Self {
            self.namespace_error = Some(input);
            self
        }
        /// <p>An error that occurred when the namespace was created.</p>
        pub fn set_namespace_error(
            mut self,
            input: std::option::Option<crate::model::NamespaceError>,
        ) -> Self {
            self.namespace_error = input;
            self
        }
        /// Consumes the builder and constructs a [`NamespaceInfoV2`](crate::model::NamespaceInfoV2)
        pub fn build(self) -> crate::model::NamespaceInfoV2 {
            crate::model::NamespaceInfoV2 {
                name: self.name,
                arn: self.arn,
                capacity_region: self.capacity_region,
                creation_status: self.creation_status,
                identity_store: self.identity_store,
                namespace_error: self.namespace_error,
            }
        }
    }
}
impl NamespaceInfoV2 {
    /// Creates a new builder-style object to manufacture [`NamespaceInfoV2`](crate::model::NamespaceInfoV2)
    pub fn builder() -> crate::model::namespace_info_v2::Builder {
        crate::model::namespace_info_v2::Builder::default()
    }
}

/// <p>Errors that occur during namespace creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamespaceError {
    /// <p>The error type.</p>
    pub r#type: std::option::Option<crate::model::NamespaceErrorType>,
    /// <p>The message for the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl NamespaceError {
    /// <p>The error type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NamespaceErrorType> {
        self.r#type.as_ref()
    }
    /// <p>The message for the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for NamespaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamespaceError");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`NamespaceError`](crate::model::NamespaceError)
pub mod namespace_error {
    /// A builder for [`NamespaceError`](crate::model::NamespaceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::NamespaceErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error type.</p>
        pub fn r#type(mut self, input: crate::model::NamespaceErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The error type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NamespaceErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The message for the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NamespaceError`](crate::model::NamespaceError)
        pub fn build(self) -> crate::model::NamespaceError {
            crate::model::NamespaceError {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl NamespaceError {
    /// Creates a new builder-style object to manufacture [`NamespaceError`](crate::model::NamespaceError)
    pub fn builder() -> crate::model::namespace_error::Builder {
        crate::model::namespace_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NamespaceErrorType {
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    PermissionDenied,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NamespaceErrorType {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_SERVICE_ERROR" => NamespaceErrorType::InternalServiceError,
            "PERMISSION_DENIED" => NamespaceErrorType::PermissionDenied,
            other => NamespaceErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NamespaceErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NamespaceErrorType::from(s))
    }
}
impl NamespaceErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NamespaceErrorType::InternalServiceError => "INTERNAL_SERVICE_ERROR",
            NamespaceErrorType::PermissionDenied => "PERMISSION_DENIED",
            NamespaceErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_SERVICE_ERROR", "PERMISSION_DENIED"]
    }
}
impl AsRef<str> for NamespaceErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityStore {
    #[allow(missing_docs)] // documentation missing in model
    Quicksight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityStore {
    fn from(s: &str) -> Self {
        match s {
            "QUICKSIGHT" => IdentityStore::Quicksight,
            other => IdentityStore::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityStore {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityStore::from(s))
    }
}
impl IdentityStore {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityStore::Quicksight => "QUICKSIGHT",
            IdentityStore::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["QUICKSIGHT"]
    }
}
impl AsRef<str> for IdentityStore {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NamespaceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    NonRetryableFailure,
    #[allow(missing_docs)] // documentation missing in model
    RetryableFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NamespaceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => NamespaceStatus::Created,
            "CREATING" => NamespaceStatus::Creating,
            "DELETING" => NamespaceStatus::Deleting,
            "NON_RETRYABLE_FAILURE" => NamespaceStatus::NonRetryableFailure,
            "RETRYABLE_FAILURE" => NamespaceStatus::RetryableFailure,
            other => NamespaceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NamespaceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NamespaceStatus::from(s))
    }
}
impl NamespaceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NamespaceStatus::Created => "CREATED",
            NamespaceStatus::Creating => "CREATING",
            NamespaceStatus::Deleting => "DELETING",
            NamespaceStatus::NonRetryableFailure => "NON_RETRYABLE_FAILURE",
            NamespaceStatus::RetryableFailure => "RETRYABLE_FAILURE",
            NamespaceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATED",
            "CREATING",
            "DELETING",
            "NON_RETRYABLE_FAILURE",
            "RETRYABLE_FAILURE",
        ]
    }
}
impl AsRef<str> for NamespaceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the SPICE ingestion for a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ingestion {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Ingestion ID.</p>
    pub ingestion_id: std::option::Option<std::string::String>,
    /// <p>Ingestion status.</p>
    pub ingestion_status: std::option::Option<crate::model::IngestionStatus>,
    /// <p>Error information for this ingestion.</p>
    pub error_info: std::option::Option<crate::model::ErrorInfo>,
    /// <p>Information about rows for a data set SPICE ingestion.</p>
    pub row_info: std::option::Option<crate::model::RowInfo>,
    /// <p>Information about a queued dataset SPICE ingestion.</p>
    pub queue_info: std::option::Option<crate::model::QueueInfo>,
    /// <p>The time that this ingestion started.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that this ingestion took, measured in seconds.</p>
    pub ingestion_time_in_seconds: std::option::Option<i64>,
    /// <p>The size of the data ingested, in bytes.</p>
    pub ingestion_size_in_bytes: std::option::Option<i64>,
    /// <p>Event source for this ingestion.</p>
    pub request_source: std::option::Option<crate::model::IngestionRequestSource>,
    /// <p>Type of this ingestion.</p>
    pub request_type: std::option::Option<crate::model::IngestionRequestType>,
}
impl Ingestion {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Ingestion ID.</p>
    pub fn ingestion_id(&self) -> std::option::Option<&str> {
        self.ingestion_id.as_deref()
    }
    /// <p>Ingestion status.</p>
    pub fn ingestion_status(&self) -> std::option::Option<&crate::model::IngestionStatus> {
        self.ingestion_status.as_ref()
    }
    /// <p>Error information for this ingestion.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::ErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p>Information about rows for a data set SPICE ingestion.</p>
    pub fn row_info(&self) -> std::option::Option<&crate::model::RowInfo> {
        self.row_info.as_ref()
    }
    /// <p>Information about a queued dataset SPICE ingestion.</p>
    pub fn queue_info(&self) -> std::option::Option<&crate::model::QueueInfo> {
        self.queue_info.as_ref()
    }
    /// <p>The time that this ingestion started.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The time that this ingestion took, measured in seconds.</p>
    pub fn ingestion_time_in_seconds(&self) -> std::option::Option<i64> {
        self.ingestion_time_in_seconds
    }
    /// <p>The size of the data ingested, in bytes.</p>
    pub fn ingestion_size_in_bytes(&self) -> std::option::Option<i64> {
        self.ingestion_size_in_bytes
    }
    /// <p>Event source for this ingestion.</p>
    pub fn request_source(&self) -> std::option::Option<&crate::model::IngestionRequestSource> {
        self.request_source.as_ref()
    }
    /// <p>Type of this ingestion.</p>
    pub fn request_type(&self) -> std::option::Option<&crate::model::IngestionRequestType> {
        self.request_type.as_ref()
    }
}
impl std::fmt::Debug for Ingestion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ingestion");
        formatter.field("arn", &self.arn);
        formatter.field("ingestion_id", &self.ingestion_id);
        formatter.field("ingestion_status", &self.ingestion_status);
        formatter.field("error_info", &self.error_info);
        formatter.field("row_info", &self.row_info);
        formatter.field("queue_info", &self.queue_info);
        formatter.field("created_time", &self.created_time);
        formatter.field("ingestion_time_in_seconds", &self.ingestion_time_in_seconds);
        formatter.field("ingestion_size_in_bytes", &self.ingestion_size_in_bytes);
        formatter.field("request_source", &self.request_source);
        formatter.field("request_type", &self.request_type);
        formatter.finish()
    }
}
/// See [`Ingestion`](crate::model::Ingestion)
pub mod ingestion {
    /// A builder for [`Ingestion`](crate::model::Ingestion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) ingestion_id: std::option::Option<std::string::String>,
        pub(crate) ingestion_status: std::option::Option<crate::model::IngestionStatus>,
        pub(crate) error_info: std::option::Option<crate::model::ErrorInfo>,
        pub(crate) row_info: std::option::Option<crate::model::RowInfo>,
        pub(crate) queue_info: std::option::Option<crate::model::QueueInfo>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ingestion_time_in_seconds: std::option::Option<i64>,
        pub(crate) ingestion_size_in_bytes: std::option::Option<i64>,
        pub(crate) request_source: std::option::Option<crate::model::IngestionRequestSource>,
        pub(crate) request_type: std::option::Option<crate::model::IngestionRequestType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Ingestion ID.</p>
        pub fn ingestion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingestion_id = Some(input.into());
            self
        }
        /// <p>Ingestion ID.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingestion_id = input;
            self
        }
        /// <p>Ingestion status.</p>
        pub fn ingestion_status(mut self, input: crate::model::IngestionStatus) -> Self {
            self.ingestion_status = Some(input);
            self
        }
        /// <p>Ingestion status.</p>
        pub fn set_ingestion_status(
            mut self,
            input: std::option::Option<crate::model::IngestionStatus>,
        ) -> Self {
            self.ingestion_status = input;
            self
        }
        /// <p>Error information for this ingestion.</p>
        pub fn error_info(mut self, input: crate::model::ErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>Error information for this ingestion.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::ErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// <p>Information about rows for a data set SPICE ingestion.</p>
        pub fn row_info(mut self, input: crate::model::RowInfo) -> Self {
            self.row_info = Some(input);
            self
        }
        /// <p>Information about rows for a data set SPICE ingestion.</p>
        pub fn set_row_info(mut self, input: std::option::Option<crate::model::RowInfo>) -> Self {
            self.row_info = input;
            self
        }
        /// <p>Information about a queued dataset SPICE ingestion.</p>
        pub fn queue_info(mut self, input: crate::model::QueueInfo) -> Self {
            self.queue_info = Some(input);
            self
        }
        /// <p>Information about a queued dataset SPICE ingestion.</p>
        pub fn set_queue_info(
            mut self,
            input: std::option::Option<crate::model::QueueInfo>,
        ) -> Self {
            self.queue_info = input;
            self
        }
        /// <p>The time that this ingestion started.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this ingestion started.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The time that this ingestion took, measured in seconds.</p>
        pub fn ingestion_time_in_seconds(mut self, input: i64) -> Self {
            self.ingestion_time_in_seconds = Some(input);
            self
        }
        /// <p>The time that this ingestion took, measured in seconds.</p>
        pub fn set_ingestion_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.ingestion_time_in_seconds = input;
            self
        }
        /// <p>The size of the data ingested, in bytes.</p>
        pub fn ingestion_size_in_bytes(mut self, input: i64) -> Self {
            self.ingestion_size_in_bytes = Some(input);
            self
        }
        /// <p>The size of the data ingested, in bytes.</p>
        pub fn set_ingestion_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.ingestion_size_in_bytes = input;
            self
        }
        /// <p>Event source for this ingestion.</p>
        pub fn request_source(mut self, input: crate::model::IngestionRequestSource) -> Self {
            self.request_source = Some(input);
            self
        }
        /// <p>Event source for this ingestion.</p>
        pub fn set_request_source(
            mut self,
            input: std::option::Option<crate::model::IngestionRequestSource>,
        ) -> Self {
            self.request_source = input;
            self
        }
        /// <p>Type of this ingestion.</p>
        pub fn request_type(mut self, input: crate::model::IngestionRequestType) -> Self {
            self.request_type = Some(input);
            self
        }
        /// <p>Type of this ingestion.</p>
        pub fn set_request_type(
            mut self,
            input: std::option::Option<crate::model::IngestionRequestType>,
        ) -> Self {
            self.request_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Ingestion`](crate::model::Ingestion)
        pub fn build(self) -> crate::model::Ingestion {
            crate::model::Ingestion {
                arn: self.arn,
                ingestion_id: self.ingestion_id,
                ingestion_status: self.ingestion_status,
                error_info: self.error_info,
                row_info: self.row_info,
                queue_info: self.queue_info,
                created_time: self.created_time,
                ingestion_time_in_seconds: self.ingestion_time_in_seconds,
                ingestion_size_in_bytes: self.ingestion_size_in_bytes,
                request_source: self.request_source,
                request_type: self.request_type,
            }
        }
    }
}
impl Ingestion {
    /// Creates a new builder-style object to manufacture [`Ingestion`](crate::model::Ingestion)
    pub fn builder() -> crate::model::ingestion::Builder {
        crate::model::ingestion::Builder::default()
    }
}

/// This defines the type of ingestion request. This is returned as part of create ingestion response.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IngestionRequestType {
    #[allow(missing_docs)] // documentation missing in model
    Edit,
    #[allow(missing_docs)] // documentation missing in model
    FullRefresh,
    #[allow(missing_docs)] // documentation missing in model
    IncrementalRefresh,
    #[allow(missing_docs)] // documentation missing in model
    InitialIngestion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IngestionRequestType {
    fn from(s: &str) -> Self {
        match s {
            "EDIT" => IngestionRequestType::Edit,
            "FULL_REFRESH" => IngestionRequestType::FullRefresh,
            "INCREMENTAL_REFRESH" => IngestionRequestType::IncrementalRefresh,
            "INITIAL_INGESTION" => IngestionRequestType::InitialIngestion,
            other => IngestionRequestType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IngestionRequestType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IngestionRequestType::from(s))
    }
}
impl IngestionRequestType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IngestionRequestType::Edit => "EDIT",
            IngestionRequestType::FullRefresh => "FULL_REFRESH",
            IngestionRequestType::IncrementalRefresh => "INCREMENTAL_REFRESH",
            IngestionRequestType::InitialIngestion => "INITIAL_INGESTION",
            IngestionRequestType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EDIT",
            "FULL_REFRESH",
            "INCREMENTAL_REFRESH",
            "INITIAL_INGESTION",
        ]
    }
}
impl AsRef<str> for IngestionRequestType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IngestionRequestSource {
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IngestionRequestSource {
    fn from(s: &str) -> Self {
        match s {
            "MANUAL" => IngestionRequestSource::Manual,
            "SCHEDULED" => IngestionRequestSource::Scheduled,
            other => IngestionRequestSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IngestionRequestSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IngestionRequestSource::from(s))
    }
}
impl IngestionRequestSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IngestionRequestSource::Manual => "MANUAL",
            IngestionRequestSource::Scheduled => "SCHEDULED",
            IngestionRequestSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MANUAL", "SCHEDULED"]
    }
}
impl AsRef<str> for IngestionRequestSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a queued dataset SPICE ingestion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueInfo {
    /// <p>The ID of the queued ingestion.</p>
    pub waiting_on_ingestion: std::option::Option<std::string::String>,
    /// <p>The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing
    /// ingestion to complete.</p>
    pub queued_ingestion: std::option::Option<std::string::String>,
}
impl QueueInfo {
    /// <p>The ID of the queued ingestion.</p>
    pub fn waiting_on_ingestion(&self) -> std::option::Option<&str> {
        self.waiting_on_ingestion.as_deref()
    }
    /// <p>The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing
    /// ingestion to complete.</p>
    pub fn queued_ingestion(&self) -> std::option::Option<&str> {
        self.queued_ingestion.as_deref()
    }
}
impl std::fmt::Debug for QueueInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueInfo");
        formatter.field("waiting_on_ingestion", &self.waiting_on_ingestion);
        formatter.field("queued_ingestion", &self.queued_ingestion);
        formatter.finish()
    }
}
/// See [`QueueInfo`](crate::model::QueueInfo)
pub mod queue_info {
    /// A builder for [`QueueInfo`](crate::model::QueueInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) waiting_on_ingestion: std::option::Option<std::string::String>,
        pub(crate) queued_ingestion: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the queued ingestion.</p>
        pub fn waiting_on_ingestion(mut self, input: impl Into<std::string::String>) -> Self {
            self.waiting_on_ingestion = Some(input.into());
            self
        }
        /// <p>The ID of the queued ingestion.</p>
        pub fn set_waiting_on_ingestion(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.waiting_on_ingestion = input;
            self
        }
        /// <p>The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing
        /// ingestion to complete.</p>
        pub fn queued_ingestion(mut self, input: impl Into<std::string::String>) -> Self {
            self.queued_ingestion = Some(input.into());
            self
        }
        /// <p>The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing
        /// ingestion to complete.</p>
        pub fn set_queued_ingestion(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.queued_ingestion = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueInfo`](crate::model::QueueInfo)
        pub fn build(self) -> crate::model::QueueInfo {
            crate::model::QueueInfo {
                waiting_on_ingestion: self.waiting_on_ingestion,
                queued_ingestion: self.queued_ingestion,
            }
        }
    }
}
impl QueueInfo {
    /// Creates a new builder-style object to manufacture [`QueueInfo`](crate::model::QueueInfo)
    pub fn builder() -> crate::model::queue_info::Builder {
        crate::model::queue_info::Builder::default()
    }
}

/// <p>Information about rows for a data set SPICE ingestion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RowInfo {
    /// <p>The number of rows that were ingested.</p>
    pub rows_ingested: std::option::Option<i64>,
    /// <p>The number of rows that were not ingested.</p>
    pub rows_dropped: std::option::Option<i64>,
    /// <p>The total number of rows in the dataset.</p>
    pub total_rows_in_dataset: std::option::Option<i64>,
}
impl RowInfo {
    /// <p>The number of rows that were ingested.</p>
    pub fn rows_ingested(&self) -> std::option::Option<i64> {
        self.rows_ingested
    }
    /// <p>The number of rows that were not ingested.</p>
    pub fn rows_dropped(&self) -> std::option::Option<i64> {
        self.rows_dropped
    }
    /// <p>The total number of rows in the dataset.</p>
    pub fn total_rows_in_dataset(&self) -> std::option::Option<i64> {
        self.total_rows_in_dataset
    }
}
impl std::fmt::Debug for RowInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RowInfo");
        formatter.field("rows_ingested", &self.rows_ingested);
        formatter.field("rows_dropped", &self.rows_dropped);
        formatter.field("total_rows_in_dataset", &self.total_rows_in_dataset);
        formatter.finish()
    }
}
/// See [`RowInfo`](crate::model::RowInfo)
pub mod row_info {
    /// A builder for [`RowInfo`](crate::model::RowInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rows_ingested: std::option::Option<i64>,
        pub(crate) rows_dropped: std::option::Option<i64>,
        pub(crate) total_rows_in_dataset: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of rows that were ingested.</p>
        pub fn rows_ingested(mut self, input: i64) -> Self {
            self.rows_ingested = Some(input);
            self
        }
        /// <p>The number of rows that were ingested.</p>
        pub fn set_rows_ingested(mut self, input: std::option::Option<i64>) -> Self {
            self.rows_ingested = input;
            self
        }
        /// <p>The number of rows that were not ingested.</p>
        pub fn rows_dropped(mut self, input: i64) -> Self {
            self.rows_dropped = Some(input);
            self
        }
        /// <p>The number of rows that were not ingested.</p>
        pub fn set_rows_dropped(mut self, input: std::option::Option<i64>) -> Self {
            self.rows_dropped = input;
            self
        }
        /// <p>The total number of rows in the dataset.</p>
        pub fn total_rows_in_dataset(mut self, input: i64) -> Self {
            self.total_rows_in_dataset = Some(input);
            self
        }
        /// <p>The total number of rows in the dataset.</p>
        pub fn set_total_rows_in_dataset(mut self, input: std::option::Option<i64>) -> Self {
            self.total_rows_in_dataset = input;
            self
        }
        /// Consumes the builder and constructs a [`RowInfo`](crate::model::RowInfo)
        pub fn build(self) -> crate::model::RowInfo {
            crate::model::RowInfo {
                rows_ingested: self.rows_ingested,
                rows_dropped: self.rows_dropped,
                total_rows_in_dataset: self.total_rows_in_dataset,
            }
        }
    }
}
impl RowInfo {
    /// Creates a new builder-style object to manufacture [`RowInfo`](crate::model::RowInfo)
    pub fn builder() -> crate::model::row_info::Builder {
        crate::model::row_info::Builder::default()
    }
}

/// <p>Error information for the SPICE ingestion of a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorInfo {
    /// <p>Error type.</p>
    pub r#type: std::option::Option<crate::model::IngestionErrorType>,
    /// <p>Error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ErrorInfo {
    /// <p>Error type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::IngestionErrorType> {
        self.r#type.as_ref()
    }
    /// <p>Error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorInfo");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ErrorInfo`](crate::model::ErrorInfo)
pub mod error_info {
    /// A builder for [`ErrorInfo`](crate::model::ErrorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::IngestionErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error type.</p>
        pub fn r#type(mut self, input: crate::model::IngestionErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Error type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IngestionErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorInfo`](crate::model::ErrorInfo)
        pub fn build(self) -> crate::model::ErrorInfo {
            crate::model::ErrorInfo {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ErrorInfo {
    /// Creates a new builder-style object to manufacture [`ErrorInfo`](crate::model::ErrorInfo)
    pub fn builder() -> crate::model::error_info::Builder {
        crate::model::error_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IngestionErrorType {
    #[allow(missing_docs)] // documentation missing in model
    AccountCapacityLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ConnectionFailure,
    #[allow(missing_docs)] // documentation missing in model
    CursorNotEnabled,
    #[allow(missing_docs)] // documentation missing in model
    CustomerError,
    #[allow(missing_docs)] // documentation missing in model
    DataSetDeleted,
    #[allow(missing_docs)] // documentation missing in model
    DataSetNotSpice,
    #[allow(missing_docs)] // documentation missing in model
    DataSetSizeLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    DataSourceAuthFailed,
    #[allow(missing_docs)] // documentation missing in model
    DataSourceConnectionFailed,
    #[allow(missing_docs)] // documentation missing in model
    DataSourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    DataToleranceException,
    #[allow(missing_docs)] // documentation missing in model
    ElasticsearchCursorNotEnabled,
    #[allow(missing_docs)] // documentation missing in model
    FailureToAssumeRole,
    #[allow(missing_docs)] // documentation missing in model
    FailureToProcessJsonFile,
    #[allow(missing_docs)] // documentation missing in model
    IamRoleNotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    IngestionCanceled,
    #[allow(missing_docs)] // documentation missing in model
    IngestionSuperseded,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidDataprepSyntax,
    #[allow(missing_docs)] // documentation missing in model
    InvalidDataSourceConfig,
    #[allow(missing_docs)] // documentation missing in model
    InvalidDateFormat,
    #[allow(missing_docs)] // documentation missing in model
    IotDataSetFileEmpty,
    #[allow(missing_docs)] // documentation missing in model
    IotFileNotFound,
    #[allow(missing_docs)] // documentation missing in model
    OauthTokenFailure,
    #[allow(missing_docs)] // documentation missing in model
    PasswordAuthenticationFailure,
    #[allow(missing_docs)] // documentation missing in model
    PermissionDenied,
    #[allow(missing_docs)] // documentation missing in model
    PermissionNotFound,
    #[allow(missing_docs)] // documentation missing in model
    QueryTimeout,
    #[allow(missing_docs)] // documentation missing in model
    RefreshSuppressedByEdit,
    #[allow(missing_docs)] // documentation missing in model
    RowSizeLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    S3FileInaccessible,
    #[allow(missing_docs)] // documentation missing in model
    S3ManifestError,
    #[allow(missing_docs)] // documentation missing in model
    S3UploadedFileDeleted,
    #[allow(missing_docs)] // documentation missing in model
    SourceApiLimitExceededFailure,
    #[allow(missing_docs)] // documentation missing in model
    SourceResourceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    SpiceTableNotFound,
    #[allow(missing_docs)] // documentation missing in model
    SqlException,
    #[allow(missing_docs)] // documentation missing in model
    SqlInvalidParameterValue,
    #[allow(missing_docs)] // documentation missing in model
    SqlNumericOverflow,
    #[allow(missing_docs)] // documentation missing in model
    SqlSchemaMismatchError,
    #[allow(missing_docs)] // documentation missing in model
    SqlTableNotFound,
    #[allow(missing_docs)] // documentation missing in model
    SslCertificateValidationFailure,
    #[allow(missing_docs)] // documentation missing in model
    UnresolvableHost,
    #[allow(missing_docs)] // documentation missing in model
    UnroutableHost,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IngestionErrorType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_CAPACITY_LIMIT_EXCEEDED" => IngestionErrorType::AccountCapacityLimitExceeded,
            "CONNECTION_FAILURE" => IngestionErrorType::ConnectionFailure,
            "CURSOR_NOT_ENABLED" => IngestionErrorType::CursorNotEnabled,
            "CUSTOMER_ERROR" => IngestionErrorType::CustomerError,
            "DATA_SET_DELETED" => IngestionErrorType::DataSetDeleted,
            "DATA_SET_NOT_SPICE" => IngestionErrorType::DataSetNotSpice,
            "DATA_SET_SIZE_LIMIT_EXCEEDED" => IngestionErrorType::DataSetSizeLimitExceeded,
            "DATA_SOURCE_AUTH_FAILED" => IngestionErrorType::DataSourceAuthFailed,
            "DATA_SOURCE_CONNECTION_FAILED" => IngestionErrorType::DataSourceConnectionFailed,
            "DATA_SOURCE_NOT_FOUND" => IngestionErrorType::DataSourceNotFound,
            "DATA_TOLERANCE_EXCEPTION" => IngestionErrorType::DataToleranceException,
            "ELASTICSEARCH_CURSOR_NOT_ENABLED" => IngestionErrorType::ElasticsearchCursorNotEnabled,
            "FAILURE_TO_ASSUME_ROLE" => IngestionErrorType::FailureToAssumeRole,
            "FAILURE_TO_PROCESS_JSON_FILE" => IngestionErrorType::FailureToProcessJsonFile,
            "IAM_ROLE_NOT_AVAILABLE" => IngestionErrorType::IamRoleNotAvailable,
            "INGESTION_CANCELED" => IngestionErrorType::IngestionCanceled,
            "INGESTION_SUPERSEDED" => IngestionErrorType::IngestionSuperseded,
            "INTERNAL_SERVICE_ERROR" => IngestionErrorType::InternalServiceError,
            "INVALID_DATAPREP_SYNTAX" => IngestionErrorType::InvalidDataprepSyntax,
            "INVALID_DATA_SOURCE_CONFIG" => IngestionErrorType::InvalidDataSourceConfig,
            "INVALID_DATE_FORMAT" => IngestionErrorType::InvalidDateFormat,
            "IOT_DATA_SET_FILE_EMPTY" => IngestionErrorType::IotDataSetFileEmpty,
            "IOT_FILE_NOT_FOUND" => IngestionErrorType::IotFileNotFound,
            "OAUTH_TOKEN_FAILURE" => IngestionErrorType::OauthTokenFailure,
            "PASSWORD_AUTHENTICATION_FAILURE" => IngestionErrorType::PasswordAuthenticationFailure,
            "PERMISSION_DENIED" => IngestionErrorType::PermissionDenied,
            "PERMISSION_NOT_FOUND" => IngestionErrorType::PermissionNotFound,
            "QUERY_TIMEOUT" => IngestionErrorType::QueryTimeout,
            "REFRESH_SUPPRESSED_BY_EDIT" => IngestionErrorType::RefreshSuppressedByEdit,
            "ROW_SIZE_LIMIT_EXCEEDED" => IngestionErrorType::RowSizeLimitExceeded,
            "S3_FILE_INACCESSIBLE" => IngestionErrorType::S3FileInaccessible,
            "S3_MANIFEST_ERROR" => IngestionErrorType::S3ManifestError,
            "S3_UPLOADED_FILE_DELETED" => IngestionErrorType::S3UploadedFileDeleted,
            "SOURCE_API_LIMIT_EXCEEDED_FAILURE" => {
                IngestionErrorType::SourceApiLimitExceededFailure
            }
            "SOURCE_RESOURCE_LIMIT_EXCEEDED" => IngestionErrorType::SourceResourceLimitExceeded,
            "SPICE_TABLE_NOT_FOUND" => IngestionErrorType::SpiceTableNotFound,
            "SQL_EXCEPTION" => IngestionErrorType::SqlException,
            "SQL_INVALID_PARAMETER_VALUE" => IngestionErrorType::SqlInvalidParameterValue,
            "SQL_NUMERIC_OVERFLOW" => IngestionErrorType::SqlNumericOverflow,
            "SQL_SCHEMA_MISMATCH_ERROR" => IngestionErrorType::SqlSchemaMismatchError,
            "SQL_TABLE_NOT_FOUND" => IngestionErrorType::SqlTableNotFound,
            "SSL_CERTIFICATE_VALIDATION_FAILURE" => {
                IngestionErrorType::SslCertificateValidationFailure
            }
            "UNRESOLVABLE_HOST" => IngestionErrorType::UnresolvableHost,
            "UNROUTABLE_HOST" => IngestionErrorType::UnroutableHost,
            other => IngestionErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IngestionErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IngestionErrorType::from(s))
    }
}
impl IngestionErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IngestionErrorType::AccountCapacityLimitExceeded => "ACCOUNT_CAPACITY_LIMIT_EXCEEDED",
            IngestionErrorType::ConnectionFailure => "CONNECTION_FAILURE",
            IngestionErrorType::CursorNotEnabled => "CURSOR_NOT_ENABLED",
            IngestionErrorType::CustomerError => "CUSTOMER_ERROR",
            IngestionErrorType::DataSetDeleted => "DATA_SET_DELETED",
            IngestionErrorType::DataSetNotSpice => "DATA_SET_NOT_SPICE",
            IngestionErrorType::DataSetSizeLimitExceeded => "DATA_SET_SIZE_LIMIT_EXCEEDED",
            IngestionErrorType::DataSourceAuthFailed => "DATA_SOURCE_AUTH_FAILED",
            IngestionErrorType::DataSourceConnectionFailed => "DATA_SOURCE_CONNECTION_FAILED",
            IngestionErrorType::DataSourceNotFound => "DATA_SOURCE_NOT_FOUND",
            IngestionErrorType::DataToleranceException => "DATA_TOLERANCE_EXCEPTION",
            IngestionErrorType::ElasticsearchCursorNotEnabled => "ELASTICSEARCH_CURSOR_NOT_ENABLED",
            IngestionErrorType::FailureToAssumeRole => "FAILURE_TO_ASSUME_ROLE",
            IngestionErrorType::FailureToProcessJsonFile => "FAILURE_TO_PROCESS_JSON_FILE",
            IngestionErrorType::IamRoleNotAvailable => "IAM_ROLE_NOT_AVAILABLE",
            IngestionErrorType::IngestionCanceled => "INGESTION_CANCELED",
            IngestionErrorType::IngestionSuperseded => "INGESTION_SUPERSEDED",
            IngestionErrorType::InternalServiceError => "INTERNAL_SERVICE_ERROR",
            IngestionErrorType::InvalidDataprepSyntax => "INVALID_DATAPREP_SYNTAX",
            IngestionErrorType::InvalidDataSourceConfig => "INVALID_DATA_SOURCE_CONFIG",
            IngestionErrorType::InvalidDateFormat => "INVALID_DATE_FORMAT",
            IngestionErrorType::IotDataSetFileEmpty => "IOT_DATA_SET_FILE_EMPTY",
            IngestionErrorType::IotFileNotFound => "IOT_FILE_NOT_FOUND",
            IngestionErrorType::OauthTokenFailure => "OAUTH_TOKEN_FAILURE",
            IngestionErrorType::PasswordAuthenticationFailure => "PASSWORD_AUTHENTICATION_FAILURE",
            IngestionErrorType::PermissionDenied => "PERMISSION_DENIED",
            IngestionErrorType::PermissionNotFound => "PERMISSION_NOT_FOUND",
            IngestionErrorType::QueryTimeout => "QUERY_TIMEOUT",
            IngestionErrorType::RefreshSuppressedByEdit => "REFRESH_SUPPRESSED_BY_EDIT",
            IngestionErrorType::RowSizeLimitExceeded => "ROW_SIZE_LIMIT_EXCEEDED",
            IngestionErrorType::S3FileInaccessible => "S3_FILE_INACCESSIBLE",
            IngestionErrorType::S3ManifestError => "S3_MANIFEST_ERROR",
            IngestionErrorType::S3UploadedFileDeleted => "S3_UPLOADED_FILE_DELETED",
            IngestionErrorType::SourceApiLimitExceededFailure => {
                "SOURCE_API_LIMIT_EXCEEDED_FAILURE"
            }
            IngestionErrorType::SourceResourceLimitExceeded => "SOURCE_RESOURCE_LIMIT_EXCEEDED",
            IngestionErrorType::SpiceTableNotFound => "SPICE_TABLE_NOT_FOUND",
            IngestionErrorType::SqlException => "SQL_EXCEPTION",
            IngestionErrorType::SqlInvalidParameterValue => "SQL_INVALID_PARAMETER_VALUE",
            IngestionErrorType::SqlNumericOverflow => "SQL_NUMERIC_OVERFLOW",
            IngestionErrorType::SqlSchemaMismatchError => "SQL_SCHEMA_MISMATCH_ERROR",
            IngestionErrorType::SqlTableNotFound => "SQL_TABLE_NOT_FOUND",
            IngestionErrorType::SslCertificateValidationFailure => {
                "SSL_CERTIFICATE_VALIDATION_FAILURE"
            }
            IngestionErrorType::UnresolvableHost => "UNRESOLVABLE_HOST",
            IngestionErrorType::UnroutableHost => "UNROUTABLE_HOST",
            IngestionErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_CAPACITY_LIMIT_EXCEEDED",
            "CONNECTION_FAILURE",
            "CURSOR_NOT_ENABLED",
            "CUSTOMER_ERROR",
            "DATA_SET_DELETED",
            "DATA_SET_NOT_SPICE",
            "DATA_SET_SIZE_LIMIT_EXCEEDED",
            "DATA_SOURCE_AUTH_FAILED",
            "DATA_SOURCE_CONNECTION_FAILED",
            "DATA_SOURCE_NOT_FOUND",
            "DATA_TOLERANCE_EXCEPTION",
            "ELASTICSEARCH_CURSOR_NOT_ENABLED",
            "FAILURE_TO_ASSUME_ROLE",
            "FAILURE_TO_PROCESS_JSON_FILE",
            "IAM_ROLE_NOT_AVAILABLE",
            "INGESTION_CANCELED",
            "INGESTION_SUPERSEDED",
            "INTERNAL_SERVICE_ERROR",
            "INVALID_DATAPREP_SYNTAX",
            "INVALID_DATA_SOURCE_CONFIG",
            "INVALID_DATE_FORMAT",
            "IOT_DATA_SET_FILE_EMPTY",
            "IOT_FILE_NOT_FOUND",
            "OAUTH_TOKEN_FAILURE",
            "PASSWORD_AUTHENTICATION_FAILURE",
            "PERMISSION_DENIED",
            "PERMISSION_NOT_FOUND",
            "QUERY_TIMEOUT",
            "REFRESH_SUPPRESSED_BY_EDIT",
            "ROW_SIZE_LIMIT_EXCEEDED",
            "S3_FILE_INACCESSIBLE",
            "S3_MANIFEST_ERROR",
            "S3_UPLOADED_FILE_DELETED",
            "SOURCE_API_LIMIT_EXCEEDED_FAILURE",
            "SOURCE_RESOURCE_LIMIT_EXCEEDED",
            "SPICE_TABLE_NOT_FOUND",
            "SQL_EXCEPTION",
            "SQL_INVALID_PARAMETER_VALUE",
            "SQL_NUMERIC_OVERFLOW",
            "SQL_SCHEMA_MISMATCH_ERROR",
            "SQL_TABLE_NOT_FOUND",
            "SSL_CERTIFICATE_VALIDATION_FAILURE",
            "UNRESOLVABLE_HOST",
            "UNROUTABLE_HOST",
        ]
    }
}
impl AsRef<str> for IngestionErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IngestionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initialized,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IngestionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => IngestionStatus::Cancelled,
            "COMPLETED" => IngestionStatus::Completed,
            "FAILED" => IngestionStatus::Failed,
            "INITIALIZED" => IngestionStatus::Initialized,
            "QUEUED" => IngestionStatus::Queued,
            "RUNNING" => IngestionStatus::Running,
            other => IngestionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IngestionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IngestionStatus::from(s))
    }
}
impl IngestionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IngestionStatus::Cancelled => "CANCELLED",
            IngestionStatus::Completed => "COMPLETED",
            IngestionStatus::Failed => "FAILED",
            IngestionStatus::Initialized => "INITIALIZED",
            IngestionStatus::Queued => "QUEUED",
            IngestionStatus::Running => "RUNNING",
            IngestionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "COMPLETED",
            "FAILED",
            "INITIALIZED",
            "QUEUED",
            "RUNNING",
        ]
    }
}
impl AsRef<str> for IngestionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The active Identity and Access Management (IAM) policy assignment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveIamPolicyAssignment {
    /// <p>A name for the IAMpolicy assignment.</p>
    pub assignment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub policy_arn: std::option::Option<std::string::String>,
}
impl ActiveIamPolicyAssignment {
    /// <p>A name for the IAMpolicy assignment.</p>
    pub fn assignment_name(&self) -> std::option::Option<&str> {
        self.assignment_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
}
impl std::fmt::Debug for ActiveIamPolicyAssignment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveIamPolicyAssignment");
        formatter.field("assignment_name", &self.assignment_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.finish()
    }
}
/// See [`ActiveIamPolicyAssignment`](crate::model::ActiveIamPolicyAssignment)
pub mod active_iam_policy_assignment {
    /// A builder for [`ActiveIamPolicyAssignment`](crate::model::ActiveIamPolicyAssignment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A name for the IAMpolicy assignment.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>A name for the IAMpolicy assignment.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveIamPolicyAssignment`](crate::model::ActiveIamPolicyAssignment)
        pub fn build(self) -> crate::model::ActiveIamPolicyAssignment {
            crate::model::ActiveIamPolicyAssignment {
                assignment_name: self.assignment_name,
                policy_arn: self.policy_arn,
            }
        }
    }
}
impl ActiveIamPolicyAssignment {
    /// Creates a new builder-style object to manufacture [`ActiveIamPolicyAssignment`](crate::model::ActiveIamPolicyAssignment)
    pub fn builder() -> crate::model::active_iam_policy_assignment::Builder {
        crate::model::active_iam_policy_assignment::Builder::default()
    }
}

/// <p>IAMpolicy assignment summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamPolicyAssignmentSummary {
    /// <p>Assignment name.</p>
    pub assignment_name: std::option::Option<std::string::String>,
    /// <p>Assignment status.</p>
    pub assignment_status: std::option::Option<crate::model::AssignmentStatus>,
}
impl IamPolicyAssignmentSummary {
    /// <p>Assignment name.</p>
    pub fn assignment_name(&self) -> std::option::Option<&str> {
        self.assignment_name.as_deref()
    }
    /// <p>Assignment status.</p>
    pub fn assignment_status(&self) -> std::option::Option<&crate::model::AssignmentStatus> {
        self.assignment_status.as_ref()
    }
}
impl std::fmt::Debug for IamPolicyAssignmentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamPolicyAssignmentSummary");
        formatter.field("assignment_name", &self.assignment_name);
        formatter.field("assignment_status", &self.assignment_status);
        formatter.finish()
    }
}
/// See [`IamPolicyAssignmentSummary`](crate::model::IamPolicyAssignmentSummary)
pub mod iam_policy_assignment_summary {
    /// A builder for [`IamPolicyAssignmentSummary`](crate::model::IamPolicyAssignmentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatus>,
    }
    impl Builder {
        /// <p>Assignment name.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>Assignment name.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>Assignment status.</p>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p>Assignment status.</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// Consumes the builder and constructs a [`IamPolicyAssignmentSummary`](crate::model::IamPolicyAssignmentSummary)
        pub fn build(self) -> crate::model::IamPolicyAssignmentSummary {
            crate::model::IamPolicyAssignmentSummary {
                assignment_name: self.assignment_name,
                assignment_status: self.assignment_status,
            }
        }
    }
}
impl IamPolicyAssignmentSummary {
    /// Creates a new builder-style object to manufacture [`IamPolicyAssignmentSummary`](crate::model::IamPolicyAssignmentSummary)
    pub fn builder() -> crate::model::iam_policy_assignment_summary::Builder {
        crate::model::iam_policy_assignment_summary::Builder::default()
    }
}

/// <p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups
/// can't be members of another group. .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupMember {
    /// <p>The Amazon Resource Name (ARN) for the group member (user).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the group member (user).</p>
    pub member_name: std::option::Option<std::string::String>,
}
impl GroupMember {
    /// <p>The Amazon Resource Name (ARN) for the group member (user).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the group member (user).</p>
    pub fn member_name(&self) -> std::option::Option<&str> {
        self.member_name.as_deref()
    }
}
impl std::fmt::Debug for GroupMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupMember");
        formatter.field("arn", &self.arn);
        formatter.field("member_name", &self.member_name);
        formatter.finish()
    }
}
/// See [`GroupMember`](crate::model::GroupMember)
pub mod group_member {
    /// A builder for [`GroupMember`](crate::model::GroupMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) member_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the group member (user).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the group member (user).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the group member (user).</p>
        pub fn member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_name = Some(input.into());
            self
        }
        /// <p>The name of the group member (user).</p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupMember`](crate::model::GroupMember)
        pub fn build(self) -> crate::model::GroupMember {
            crate::model::GroupMember {
                arn: self.arn,
                member_name: self.member_name,
            }
        }
    }
}
impl GroupMember {
    /// Creates a new builder-style object to manufacture [`GroupMember`](crate::model::GroupMember)
    pub fn builder() -> crate::model::group_member::Builder {
        crate::model::group_member::Builder::default()
    }
}

/// <p>An object that consists of the member Amazon Resource Name (ARN) and member ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberIdArnPair {
    /// <p>The ID of the member.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the member.</p>
    pub member_arn: std::option::Option<std::string::String>,
}
impl MemberIdArnPair {
    /// <p>The ID of the member.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the member.</p>
    pub fn member_arn(&self) -> std::option::Option<&str> {
        self.member_arn.as_deref()
    }
}
impl std::fmt::Debug for MemberIdArnPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberIdArnPair");
        formatter.field("member_id", &self.member_id);
        formatter.field("member_arn", &self.member_arn);
        formatter.finish()
    }
}
/// See [`MemberIdArnPair`](crate::model::MemberIdArnPair)
pub mod member_id_arn_pair {
    /// A builder for [`MemberIdArnPair`](crate::model::MemberIdArnPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) member_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the member.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The ID of the member.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the member.</p>
        pub fn member_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the member.</p>
        pub fn set_member_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberIdArnPair`](crate::model::MemberIdArnPair)
        pub fn build(self) -> crate::model::MemberIdArnPair {
            crate::model::MemberIdArnPair {
                member_id: self.member_id,
                member_arn: self.member_arn,
            }
        }
    }
}
impl MemberIdArnPair {
    /// Creates a new builder-style object to manufacture [`MemberIdArnPair`](crate::model::MemberIdArnPair)
    pub fn builder() -> crate::model::member_id_arn_pair::Builder {
        crate::model::member_id_arn_pair::Builder::default()
    }
}

/// <p>The structure of a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSource {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each
    /// Amazon Web Services account.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>A display name for the data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the data source. This type indicates which database engine the data source
    /// connects to.</p>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The HTTP status of the request.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The time that this data source was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this data source was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source. This
    /// is a variant type structure. For this structure to be valid, only one of the attributes
    /// can be non-null.</p>
    pub data_source_parameters: std::option::Option<crate::model::DataSourceParameters>,
    /// <p>A set of alternate data source parameters that you want to share for the credentials
    /// stored with this data source. The credentials are applied in tandem with the data source
    /// parameters when you copy a data source by using a create or update request. The API
    /// operation compares the <code>DataSourceParameters</code> structure that's in the request
    /// with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the
    /// structures are an exact match, the request is allowed to use the credentials from this
    /// existing data source. If the <code>AlternateDataSourceParameters</code> list is null,
    /// the <code>Credentials</code> originally used with this <code>DataSourceParameters</code>
    /// are automatically allowed.</p>
    pub alternate_data_source_parameters:
        std::option::Option<std::vec::Vec<crate::model::DataSourceParameters>>,
    /// <p>The VPC connection information. You need to use this parameter only when you want
    /// Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
    pub vpc_connection_properties: std::option::Option<crate::model::VpcConnectionProperties>,
    /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your
    /// underlying source.</p>
    pub ssl_properties: std::option::Option<crate::model::SslProperties>,
    /// <p>Error information from the last update or the creation of the data source.</p>
    pub error_info: std::option::Option<crate::model::DataSourceErrorInfo>,
}
impl DataSource {
    /// <p>The Amazon Resource Name (ARN) of the data source.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each
    /// Amazon Web Services account.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>A display name for the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the data source. This type indicates which database engine the data source
    /// connects to.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>The time that this data source was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The last time that this data source was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source. This
    /// is a variant type structure. For this structure to be valid, only one of the attributes
    /// can be non-null.</p>
    pub fn data_source_parameters(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceParameters> {
        self.data_source_parameters.as_ref()
    }
    /// <p>A set of alternate data source parameters that you want to share for the credentials
    /// stored with this data source. The credentials are applied in tandem with the data source
    /// parameters when you copy a data source by using a create or update request. The API
    /// operation compares the <code>DataSourceParameters</code> structure that's in the request
    /// with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the
    /// structures are an exact match, the request is allowed to use the credentials from this
    /// existing data source. If the <code>AlternateDataSourceParameters</code> list is null,
    /// the <code>Credentials</code> originally used with this <code>DataSourceParameters</code>
    /// are automatically allowed.</p>
    pub fn alternate_data_source_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::DataSourceParameters]> {
        self.alternate_data_source_parameters.as_deref()
    }
    /// <p>The VPC connection information. You need to use this parameter only when you want
    /// Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
    pub fn vpc_connection_properties(
        &self,
    ) -> std::option::Option<&crate::model::VpcConnectionProperties> {
        self.vpc_connection_properties.as_ref()
    }
    /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your
    /// underlying source.</p>
    pub fn ssl_properties(&self) -> std::option::Option<&crate::model::SslProperties> {
        self.ssl_properties.as_ref()
    }
    /// <p>Error information from the last update or the creation of the data source.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::DataSourceErrorInfo> {
        self.error_info.as_ref()
    }
}
impl std::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSource");
        formatter.field("arn", &self.arn);
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("data_source_parameters", &self.data_source_parameters);
        formatter.field(
            "alternate_data_source_parameters",
            &self.alternate_data_source_parameters,
        );
        formatter.field("vpc_connection_properties", &self.vpc_connection_properties);
        formatter.field("ssl_properties", &self.ssl_properties);
        formatter.field("error_info", &self.error_info);
        formatter.finish()
    }
}
/// See [`DataSource`](crate::model::DataSource)
pub mod data_source {
    /// A builder for [`DataSource`](crate::model::DataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_source_parameters: std::option::Option<crate::model::DataSourceParameters>,
        pub(crate) alternate_data_source_parameters:
            std::option::Option<std::vec::Vec<crate::model::DataSourceParameters>>,
        pub(crate) vpc_connection_properties:
            std::option::Option<crate::model::VpcConnectionProperties>,
        pub(crate) ssl_properties: std::option::Option<crate::model::SslProperties>,
        pub(crate) error_info: std::option::Option<crate::model::DataSourceErrorInfo>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the data source.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each
        /// Amazon Web Services account.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each
        /// Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the data source. This type indicates which database engine the data source
        /// connects to.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the data source. This type indicates which database engine the data source
        /// connects to.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time that this data source was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this data source was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The last time that this data source was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that this data source was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source. This
        /// is a variant type structure. For this structure to be valid, only one of the attributes
        /// can be non-null.</p>
        pub fn data_source_parameters(mut self, input: crate::model::DataSourceParameters) -> Self {
            self.data_source_parameters = Some(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source. This
        /// is a variant type structure. For this structure to be valid, only one of the attributes
        /// can be non-null.</p>
        pub fn set_data_source_parameters(
            mut self,
            input: std::option::Option<crate::model::DataSourceParameters>,
        ) -> Self {
            self.data_source_parameters = input;
            self
        }
        /// Appends an item to `alternate_data_source_parameters`.
        ///
        /// To override the contents of this collection use [`set_alternate_data_source_parameters`](Self::set_alternate_data_source_parameters).
        ///
        /// <p>A set of alternate data source parameters that you want to share for the credentials
        /// stored with this data source. The credentials are applied in tandem with the data source
        /// parameters when you copy a data source by using a create or update request. The API
        /// operation compares the <code>DataSourceParameters</code> structure that's in the request
        /// with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the
        /// structures are an exact match, the request is allowed to use the credentials from this
        /// existing data source. If the <code>AlternateDataSourceParameters</code> list is null,
        /// the <code>Credentials</code> originally used with this <code>DataSourceParameters</code>
        /// are automatically allowed.</p>
        pub fn alternate_data_source_parameters(
            mut self,
            input: impl Into<crate::model::DataSourceParameters>,
        ) -> Self {
            let mut v = self.alternate_data_source_parameters.unwrap_or_default();
            v.push(input.into());
            self.alternate_data_source_parameters = Some(v);
            self
        }
        /// <p>A set of alternate data source parameters that you want to share for the credentials
        /// stored with this data source. The credentials are applied in tandem with the data source
        /// parameters when you copy a data source by using a create or update request. The API
        /// operation compares the <code>DataSourceParameters</code> structure that's in the request
        /// with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the
        /// structures are an exact match, the request is allowed to use the credentials from this
        /// existing data source. If the <code>AlternateDataSourceParameters</code> list is null,
        /// the <code>Credentials</code> originally used with this <code>DataSourceParameters</code>
        /// are automatically allowed.</p>
        pub fn set_alternate_data_source_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceParameters>>,
        ) -> Self {
            self.alternate_data_source_parameters = input;
            self
        }
        /// <p>The VPC connection information. You need to use this parameter only when you want
        /// Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn vpc_connection_properties(
            mut self,
            input: crate::model::VpcConnectionProperties,
        ) -> Self {
            self.vpc_connection_properties = Some(input);
            self
        }
        /// <p>The VPC connection information. You need to use this parameter only when you want
        /// Amazon QuickSight to use a VPC connection when connecting to your underlying source.</p>
        pub fn set_vpc_connection_properties(
            mut self,
            input: std::option::Option<crate::model::VpcConnectionProperties>,
        ) -> Self {
            self.vpc_connection_properties = input;
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your
        /// underlying source.</p>
        pub fn ssl_properties(mut self, input: crate::model::SslProperties) -> Self {
            self.ssl_properties = Some(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your
        /// underlying source.</p>
        pub fn set_ssl_properties(
            mut self,
            input: std::option::Option<crate::model::SslProperties>,
        ) -> Self {
            self.ssl_properties = input;
            self
        }
        /// <p>Error information from the last update or the creation of the data source.</p>
        pub fn error_info(mut self, input: crate::model::DataSourceErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>Error information from the last update or the creation of the data source.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::DataSourceErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSource`](crate::model::DataSource)
        pub fn build(self) -> crate::model::DataSource {
            crate::model::DataSource {
                arn: self.arn,
                data_source_id: self.data_source_id,
                name: self.name,
                r#type: self.r#type,
                status: self.status,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                data_source_parameters: self.data_source_parameters,
                alternate_data_source_parameters: self.alternate_data_source_parameters,
                vpc_connection_properties: self.vpc_connection_properties,
                ssl_properties: self.ssl_properties,
                error_info: self.error_info,
            }
        }
    }
}
impl DataSource {
    /// Creates a new builder-style object to manufacture [`DataSource`](crate::model::DataSource)
    pub fn builder() -> crate::model::data_source::Builder {
        crate::model::data_source::Builder::default()
    }
}

/// <p>Error information for the data source creation or update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceErrorInfo {
    /// <p>Error type.</p>
    pub r#type: std::option::Option<crate::model::DataSourceErrorInfoType>,
    /// <p>Error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DataSourceErrorInfo {
    /// <p>Error type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceErrorInfoType> {
        self.r#type.as_ref()
    }
    /// <p>Error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DataSourceErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceErrorInfo");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DataSourceErrorInfo`](crate::model::DataSourceErrorInfo)
pub mod data_source_error_info {
    /// A builder for [`DataSourceErrorInfo`](crate::model::DataSourceErrorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DataSourceErrorInfoType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error type.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceErrorInfoType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Error type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceErrorInfoType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceErrorInfo`](crate::model::DataSourceErrorInfo)
        pub fn build(self) -> crate::model::DataSourceErrorInfo {
            crate::model::DataSourceErrorInfo {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl DataSourceErrorInfo {
    /// Creates a new builder-style object to manufacture [`DataSourceErrorInfo`](crate::model::DataSourceErrorInfo)
    pub fn builder() -> crate::model::data_source_error_info::Builder {
        crate::model::data_source_error_info::Builder::default()
    }
}

/// _Note: `DataSourceErrorInfoType::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceErrorInfoType {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    Conflict,
    #[allow(missing_docs)] // documentation missing in model
    CopySourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    EngineVersionNotSupported,
    #[allow(missing_docs)] // documentation missing in model
    GenericSqlFailure,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    UnknownHost,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceErrorInfoType {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => DataSourceErrorInfoType::AccessDenied,
            "CONFLICT" => DataSourceErrorInfoType::Conflict,
            "COPY_SOURCE_NOT_FOUND" => DataSourceErrorInfoType::CopySourceNotFound,
            "ENGINE_VERSION_NOT_SUPPORTED" => DataSourceErrorInfoType::EngineVersionNotSupported,
            "GENERIC_SQL_FAILURE" => DataSourceErrorInfoType::GenericSqlFailure,
            "TIMEOUT" => DataSourceErrorInfoType::Timeout,
            "UNKNOWN" => DataSourceErrorInfoType::UnknownValue,
            "UNKNOWN_HOST" => DataSourceErrorInfoType::UnknownHost,
            other => DataSourceErrorInfoType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceErrorInfoType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceErrorInfoType::from(s))
    }
}
impl DataSourceErrorInfoType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceErrorInfoType::AccessDenied => "ACCESS_DENIED",
            DataSourceErrorInfoType::Conflict => "CONFLICT",
            DataSourceErrorInfoType::CopySourceNotFound => "COPY_SOURCE_NOT_FOUND",
            DataSourceErrorInfoType::EngineVersionNotSupported => "ENGINE_VERSION_NOT_SUPPORTED",
            DataSourceErrorInfoType::GenericSqlFailure => "GENERIC_SQL_FAILURE",
            DataSourceErrorInfoType::Timeout => "TIMEOUT",
            DataSourceErrorInfoType::UnknownValue => "UNKNOWN",
            DataSourceErrorInfoType::UnknownHost => "UNKNOWN_HOST",
            DataSourceErrorInfoType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "CONFLICT",
            "COPY_SOURCE_NOT_FOUND",
            "ENGINE_VERSION_NOT_SUPPORTED",
            "GENERIC_SQL_FAILURE",
            "TIMEOUT",
            "UNKNOWN",
            "UNKNOWN_HOST",
        ]
    }
}
impl AsRef<str> for DataSourceErrorInfoType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceType {
    #[allow(missing_docs)] // documentation missing in model
    AdobeAnalytics,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    AmazonOpensearch,
    #[allow(missing_docs)] // documentation missing in model
    Athena,
    #[allow(missing_docs)] // documentation missing in model
    Aurora,
    #[allow(missing_docs)] // documentation missing in model
    AuroraPostgresql,
    #[allow(missing_docs)] // documentation missing in model
    AwsIotAnalytics,
    #[allow(missing_docs)] // documentation missing in model
    Github,
    #[allow(missing_docs)] // documentation missing in model
    Jira,
    #[allow(missing_docs)] // documentation missing in model
    Mariadb,
    #[allow(missing_docs)] // documentation missing in model
    Mysql,
    #[allow(missing_docs)] // documentation missing in model
    Oracle,
    #[allow(missing_docs)] // documentation missing in model
    Postgresql,
    #[allow(missing_docs)] // documentation missing in model
    Presto,
    #[allow(missing_docs)] // documentation missing in model
    Redshift,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    Salesforce,
    #[allow(missing_docs)] // documentation missing in model
    Servicenow,
    #[allow(missing_docs)] // documentation missing in model
    Snowflake,
    #[allow(missing_docs)] // documentation missing in model
    Spark,
    #[allow(missing_docs)] // documentation missing in model
    Sqlserver,
    #[allow(missing_docs)] // documentation missing in model
    Teradata,
    #[allow(missing_docs)] // documentation missing in model
    Timestream,
    #[allow(missing_docs)] // documentation missing in model
    Twitter,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceType {
    fn from(s: &str) -> Self {
        match s {
            "ADOBE_ANALYTICS" => DataSourceType::AdobeAnalytics,
            "AMAZON_ELASTICSEARCH" => DataSourceType::AmazonElasticsearch,
            "AMAZON_OPENSEARCH" => DataSourceType::AmazonOpensearch,
            "ATHENA" => DataSourceType::Athena,
            "AURORA" => DataSourceType::Aurora,
            "AURORA_POSTGRESQL" => DataSourceType::AuroraPostgresql,
            "AWS_IOT_ANALYTICS" => DataSourceType::AwsIotAnalytics,
            "GITHUB" => DataSourceType::Github,
            "JIRA" => DataSourceType::Jira,
            "MARIADB" => DataSourceType::Mariadb,
            "MYSQL" => DataSourceType::Mysql,
            "ORACLE" => DataSourceType::Oracle,
            "POSTGRESQL" => DataSourceType::Postgresql,
            "PRESTO" => DataSourceType::Presto,
            "REDSHIFT" => DataSourceType::Redshift,
            "S3" => DataSourceType::S3,
            "SALESFORCE" => DataSourceType::Salesforce,
            "SERVICENOW" => DataSourceType::Servicenow,
            "SNOWFLAKE" => DataSourceType::Snowflake,
            "SPARK" => DataSourceType::Spark,
            "SQLSERVER" => DataSourceType::Sqlserver,
            "TERADATA" => DataSourceType::Teradata,
            "TIMESTREAM" => DataSourceType::Timestream,
            "TWITTER" => DataSourceType::Twitter,
            other => DataSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceType::from(s))
    }
}
impl DataSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceType::AdobeAnalytics => "ADOBE_ANALYTICS",
            DataSourceType::AmazonElasticsearch => "AMAZON_ELASTICSEARCH",
            DataSourceType::AmazonOpensearch => "AMAZON_OPENSEARCH",
            DataSourceType::Athena => "ATHENA",
            DataSourceType::Aurora => "AURORA",
            DataSourceType::AuroraPostgresql => "AURORA_POSTGRESQL",
            DataSourceType::AwsIotAnalytics => "AWS_IOT_ANALYTICS",
            DataSourceType::Github => "GITHUB",
            DataSourceType::Jira => "JIRA",
            DataSourceType::Mariadb => "MARIADB",
            DataSourceType::Mysql => "MYSQL",
            DataSourceType::Oracle => "ORACLE",
            DataSourceType::Postgresql => "POSTGRESQL",
            DataSourceType::Presto => "PRESTO",
            DataSourceType::Redshift => "REDSHIFT",
            DataSourceType::S3 => "S3",
            DataSourceType::Salesforce => "SALESFORCE",
            DataSourceType::Servicenow => "SERVICENOW",
            DataSourceType::Snowflake => "SNOWFLAKE",
            DataSourceType::Spark => "SPARK",
            DataSourceType::Sqlserver => "SQLSERVER",
            DataSourceType::Teradata => "TERADATA",
            DataSourceType::Timestream => "TIMESTREAM",
            DataSourceType::Twitter => "TWITTER",
            DataSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADOBE_ANALYTICS",
            "AMAZON_ELASTICSEARCH",
            "AMAZON_OPENSEARCH",
            "ATHENA",
            "AURORA",
            "AURORA_POSTGRESQL",
            "AWS_IOT_ANALYTICS",
            "GITHUB",
            "JIRA",
            "MARIADB",
            "MYSQL",
            "ORACLE",
            "POSTGRESQL",
            "PRESTO",
            "REDSHIFT",
            "S3",
            "SALESFORCE",
            "SERVICENOW",
            "SNOWFLAKE",
            "SPARK",
            "SQLSERVER",
            "TERADATA",
            "TIMESTREAM",
            "TWITTER",
        ]
    }
}
impl AsRef<str> for DataSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Dataset summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSetSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the dataset.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>A display name for the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that this dataset was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this dataset was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A value that indicates whether you want to import the data into SPICE.</p>
    pub import_mode: std::option::Option<crate::model::DataSetImportMode>,
    /// <p>The row-level security configuration for the dataset.</p>
    pub row_level_permission_data_set: std::option::Option<crate::model::RowLevelPermissionDataSet>,
    /// <p>Whether or not the row level permission tags are applied.</p>
    pub row_level_permission_tag_configuration_applied: bool,
    /// <p>A value that indicates if the dataset has column level permission configured.</p>
    pub column_level_permission_rules_applied: bool,
}
impl DataSetSummary {
    /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the dataset.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>A display name for the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time that this dataset was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The last time that this dataset was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>A value that indicates whether you want to import the data into SPICE.</p>
    pub fn import_mode(&self) -> std::option::Option<&crate::model::DataSetImportMode> {
        self.import_mode.as_ref()
    }
    /// <p>The row-level security configuration for the dataset.</p>
    pub fn row_level_permission_data_set(
        &self,
    ) -> std::option::Option<&crate::model::RowLevelPermissionDataSet> {
        self.row_level_permission_data_set.as_ref()
    }
    /// <p>Whether or not the row level permission tags are applied.</p>
    pub fn row_level_permission_tag_configuration_applied(&self) -> bool {
        self.row_level_permission_tag_configuration_applied
    }
    /// <p>A value that indicates if the dataset has column level permission configured.</p>
    pub fn column_level_permission_rules_applied(&self) -> bool {
        self.column_level_permission_rules_applied
    }
}
impl std::fmt::Debug for DataSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSetSummary");
        formatter.field("arn", &self.arn);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("name", &self.name);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("import_mode", &self.import_mode);
        formatter.field(
            "row_level_permission_data_set",
            &self.row_level_permission_data_set,
        );
        formatter.field(
            "row_level_permission_tag_configuration_applied",
            &self.row_level_permission_tag_configuration_applied,
        );
        formatter.field(
            "column_level_permission_rules_applied",
            &self.column_level_permission_rules_applied,
        );
        formatter.finish()
    }
}
/// See [`DataSetSummary`](crate::model::DataSetSummary)
pub mod data_set_summary {
    /// A builder for [`DataSetSummary`](crate::model::DataSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) import_mode: std::option::Option<crate::model::DataSetImportMode>,
        pub(crate) row_level_permission_data_set:
            std::option::Option<crate::model::RowLevelPermissionDataSet>,
        pub(crate) row_level_permission_tag_configuration_applied: std::option::Option<bool>,
        pub(crate) column_level_permission_rules_applied: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the dataset.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the dataset.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>A display name for the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that this dataset was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this dataset was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The last time that this dataset was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that this dataset was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>A value that indicates whether you want to import the data into SPICE.</p>
        pub fn import_mode(mut self, input: crate::model::DataSetImportMode) -> Self {
            self.import_mode = Some(input);
            self
        }
        /// <p>A value that indicates whether you want to import the data into SPICE.</p>
        pub fn set_import_mode(
            mut self,
            input: std::option::Option<crate::model::DataSetImportMode>,
        ) -> Self {
            self.import_mode = input;
            self
        }
        /// <p>The row-level security configuration for the dataset.</p>
        pub fn row_level_permission_data_set(
            mut self,
            input: crate::model::RowLevelPermissionDataSet,
        ) -> Self {
            self.row_level_permission_data_set = Some(input);
            self
        }
        /// <p>The row-level security configuration for the dataset.</p>
        pub fn set_row_level_permission_data_set(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionDataSet>,
        ) -> Self {
            self.row_level_permission_data_set = input;
            self
        }
        /// <p>Whether or not the row level permission tags are applied.</p>
        pub fn row_level_permission_tag_configuration_applied(mut self, input: bool) -> Self {
            self.row_level_permission_tag_configuration_applied = Some(input);
            self
        }
        /// <p>Whether or not the row level permission tags are applied.</p>
        pub fn set_row_level_permission_tag_configuration_applied(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.row_level_permission_tag_configuration_applied = input;
            self
        }
        /// <p>A value that indicates if the dataset has column level permission configured.</p>
        pub fn column_level_permission_rules_applied(mut self, input: bool) -> Self {
            self.column_level_permission_rules_applied = Some(input);
            self
        }
        /// <p>A value that indicates if the dataset has column level permission configured.</p>
        pub fn set_column_level_permission_rules_applied(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.column_level_permission_rules_applied = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSetSummary`](crate::model::DataSetSummary)
        pub fn build(self) -> crate::model::DataSetSummary {
            crate::model::DataSetSummary {
                arn: self.arn,
                data_set_id: self.data_set_id,
                name: self.name,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                import_mode: self.import_mode,
                row_level_permission_data_set: self.row_level_permission_data_set,
                row_level_permission_tag_configuration_applied: self
                    .row_level_permission_tag_configuration_applied
                    .unwrap_or_default(),
                column_level_permission_rules_applied: self
                    .column_level_permission_rules_applied
                    .unwrap_or_default(),
            }
        }
    }
}
impl DataSetSummary {
    /// Creates a new builder-style object to manufacture [`DataSetSummary`](crate::model::DataSetSummary)
    pub fn builder() -> crate::model::data_set_summary::Builder {
        crate::model::data_set_summary::Builder::default()
    }
}

/// <p>Dashboard version summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardVersionSummary {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time that this dashboard version was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Version number.</p>
    pub version_number: std::option::Option<i64>,
    /// <p>The HTTP status of the request.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>Source entity ARN.</p>
    pub source_entity_arn: std::option::Option<std::string::String>,
    /// <p>Description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl DashboardVersionSummary {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time that this dashboard version was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>Version number.</p>
    pub fn version_number(&self) -> std::option::Option<i64> {
        self.version_number
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>Source entity ARN.</p>
    pub fn source_entity_arn(&self) -> std::option::Option<&str> {
        self.source_entity_arn.as_deref()
    }
    /// <p>Description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for DashboardVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardVersionSummary");
        formatter.field("arn", &self.arn);
        formatter.field("created_time", &self.created_time);
        formatter.field("version_number", &self.version_number);
        formatter.field("status", &self.status);
        formatter.field("source_entity_arn", &self.source_entity_arn);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`DashboardVersionSummary`](crate::model::DashboardVersionSummary)
pub mod dashboard_version_summary {
    /// A builder for [`DashboardVersionSummary`](crate::model::DashboardVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) source_entity_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time that this dashboard version was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this dashboard version was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>Version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Source entity ARN.</p>
        pub fn source_entity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_entity_arn = Some(input.into());
            self
        }
        /// <p>Source entity ARN.</p>
        pub fn set_source_entity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_entity_arn = input;
            self
        }
        /// <p>Description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardVersionSummary`](crate::model::DashboardVersionSummary)
        pub fn build(self) -> crate::model::DashboardVersionSummary {
            crate::model::DashboardVersionSummary {
                arn: self.arn,
                created_time: self.created_time,
                version_number: self.version_number,
                status: self.status,
                source_entity_arn: self.source_entity_arn,
                description: self.description,
            }
        }
    }
}
impl DashboardVersionSummary {
    /// Creates a new builder-style object to manufacture [`DashboardVersionSummary`](crate::model::DashboardVersionSummary)
    pub fn builder() -> crate::model::dashboard_version_summary::Builder {
        crate::model::dashboard_version_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EmbeddingIdentityType {
    #[allow(missing_docs)] // documentation missing in model
    Anonymous,
    #[allow(missing_docs)] // documentation missing in model
    Iam,
    #[allow(missing_docs)] // documentation missing in model
    Quicksight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EmbeddingIdentityType {
    fn from(s: &str) -> Self {
        match s {
            "ANONYMOUS" => EmbeddingIdentityType::Anonymous,
            "IAM" => EmbeddingIdentityType::Iam,
            "QUICKSIGHT" => EmbeddingIdentityType::Quicksight,
            other => EmbeddingIdentityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EmbeddingIdentityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EmbeddingIdentityType::from(s))
    }
}
impl EmbeddingIdentityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EmbeddingIdentityType::Anonymous => "ANONYMOUS",
            EmbeddingIdentityType::Iam => "IAM",
            EmbeddingIdentityType::Quicksight => "QUICKSIGHT",
            EmbeddingIdentityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ANONYMOUS", "IAM", "QUICKSIGHT"]
    }
}
impl AsRef<str> for EmbeddingIdentityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The type of experience you want to embed. For registered users, you can embed an Amazon QuickSight dashboard or the Amazon QuickSight console.</p>
/// <note>
/// <p>Exactly one of the experience configurations is required. You can choose <code>Dashboard</code> or <code>QuickSightConsole</code>. You cannot choose more than one experience configuraton.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisteredUserEmbeddingExperienceConfiguration {
    /// <p>The configuration details for providing a dashboard embedding experience.</p>
    pub dashboard: std::option::Option<crate::model::RegisteredUserDashboardEmbeddingConfiguration>,
    /// <p>The configuration details for providing an Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User
    /// Guide</i>.</p>
    /// <p>Use <code>GenerateEmbedUrlForRegisteredUser</code> where
    /// you want to provide an authoring portal that allows users to create data sources,
    /// datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console
    /// needs to belong to the author or admin security cohort. If you want to restrict permissions
    /// to some of these features, add a custom permissions profile to the user with the
    /// <code>
    /// <a>UpdateUser</a>
    /// </code> API operation. Use <code>
    /// <a>RegisterUser</a>
    /// </code> API operation to add a new user with a custom permission profile attached. For more
    /// information, see the following sections in the <i>Amazon QuickSight User
    /// Guide</i>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html">Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    pub quick_sight_console:
        std::option::Option<crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration>,
    /// <p>The configuration details for embedding the Q search bar.</p>
    /// <p>For more information about embedding the Q search bar, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.</p>
    pub q_search_bar:
        std::option::Option<crate::model::RegisteredUserQSearchBarEmbeddingConfiguration>,
}
impl RegisteredUserEmbeddingExperienceConfiguration {
    /// <p>The configuration details for providing a dashboard embedding experience.</p>
    pub fn dashboard(
        &self,
    ) -> std::option::Option<&crate::model::RegisteredUserDashboardEmbeddingConfiguration> {
        self.dashboard.as_ref()
    }
    /// <p>The configuration details for providing an Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User
    /// Guide</i>.</p>
    /// <p>Use <code>GenerateEmbedUrlForRegisteredUser</code> where
    /// you want to provide an authoring portal that allows users to create data sources,
    /// datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console
    /// needs to belong to the author or admin security cohort. If you want to restrict permissions
    /// to some of these features, add a custom permissions profile to the user with the
    /// <code>
    /// <a>UpdateUser</a>
    /// </code> API operation. Use <code>
    /// <a>RegisterUser</a>
    /// </code> API operation to add a new user with a custom permission profile attached. For more
    /// information, see the following sections in the <i>Amazon QuickSight User
    /// Guide</i>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html">Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    pub fn quick_sight_console(
        &self,
    ) -> std::option::Option<&crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration>
    {
        self.quick_sight_console.as_ref()
    }
    /// <p>The configuration details for embedding the Q search bar.</p>
    /// <p>For more information about embedding the Q search bar, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.</p>
    pub fn q_search_bar(
        &self,
    ) -> std::option::Option<&crate::model::RegisteredUserQSearchBarEmbeddingConfiguration> {
        self.q_search_bar.as_ref()
    }
}
impl std::fmt::Debug for RegisteredUserEmbeddingExperienceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisteredUserEmbeddingExperienceConfiguration");
        formatter.field("dashboard", &self.dashboard);
        formatter.field("quick_sight_console", &self.quick_sight_console);
        formatter.field("q_search_bar", &self.q_search_bar);
        formatter.finish()
    }
}
/// See [`RegisteredUserEmbeddingExperienceConfiguration`](crate::model::RegisteredUserEmbeddingExperienceConfiguration)
pub mod registered_user_embedding_experience_configuration {
    /// A builder for [`RegisteredUserEmbeddingExperienceConfiguration`](crate::model::RegisteredUserEmbeddingExperienceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard:
            std::option::Option<crate::model::RegisteredUserDashboardEmbeddingConfiguration>,
        pub(crate) quick_sight_console: std::option::Option<
            crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration,
        >,
        pub(crate) q_search_bar:
            std::option::Option<crate::model::RegisteredUserQSearchBarEmbeddingConfiguration>,
    }
    impl Builder {
        /// <p>The configuration details for providing a dashboard embedding experience.</p>
        pub fn dashboard(
            mut self,
            input: crate::model::RegisteredUserDashboardEmbeddingConfiguration,
        ) -> Self {
            self.dashboard = Some(input);
            self
        }
        /// <p>The configuration details for providing a dashboard embedding experience.</p>
        pub fn set_dashboard(
            mut self,
            input: std::option::Option<crate::model::RegisteredUserDashboardEmbeddingConfiguration>,
        ) -> Self {
            self.dashboard = input;
            self
        }
        /// <p>The configuration details for providing an Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User
        /// Guide</i>.</p>
        /// <p>Use <code>GenerateEmbedUrlForRegisteredUser</code> where
        /// you want to provide an authoring portal that allows users to create data sources,
        /// datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console
        /// needs to belong to the author or admin security cohort. If you want to restrict permissions
        /// to some of these features, add a custom permissions profile to the user with the
        /// <code>
        /// <a>UpdateUser</a>
        /// </code> API operation. Use <code>
        /// <a>RegisterUser</a>
        /// </code> API operation to add a new user with a custom permission profile attached. For more
        /// information, see the following sections in the <i>Amazon QuickSight User
        /// Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html">Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
        pub fn quick_sight_console(
            mut self,
            input: crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration,
        ) -> Self {
            self.quick_sight_console = Some(input);
            self
        }
        /// <p>The configuration details for providing an Amazon QuickSight console embedding experience. This can be used along with custom permissions to restrict access to certain features. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User
        /// Guide</i>.</p>
        /// <p>Use <code>GenerateEmbedUrlForRegisteredUser</code> where
        /// you want to provide an authoring portal that allows users to create data sources,
        /// datasets, analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console
        /// needs to belong to the author or admin security cohort. If you want to restrict permissions
        /// to some of these features, add a custom permissions profile to the user with the
        /// <code>
        /// <a>UpdateUser</a>
        /// </code> API operation. Use <code>
        /// <a>RegisterUser</a>
        /// </code> API operation to add a new user with a custom permission profile attached. For more
        /// information, see the following sections in the <i>Amazon QuickSight User
        /// Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html">Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
        pub fn set_quick_sight_console(
            mut self,
            input: std::option::Option<
                crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration,
            >,
        ) -> Self {
            self.quick_sight_console = input;
            self
        }
        /// <p>The configuration details for embedding the Q search bar.</p>
        /// <p>For more information about embedding the Q search bar, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.</p>
        pub fn q_search_bar(
            mut self,
            input: crate::model::RegisteredUserQSearchBarEmbeddingConfiguration,
        ) -> Self {
            self.q_search_bar = Some(input);
            self
        }
        /// <p>The configuration details for embedding the Q search bar.</p>
        /// <p>For more information about embedding the Q search bar, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.</p>
        pub fn set_q_search_bar(
            mut self,
            input: std::option::Option<
                crate::model::RegisteredUserQSearchBarEmbeddingConfiguration,
            >,
        ) -> Self {
            self.q_search_bar = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisteredUserEmbeddingExperienceConfiguration`](crate::model::RegisteredUserEmbeddingExperienceConfiguration)
        pub fn build(self) -> crate::model::RegisteredUserEmbeddingExperienceConfiguration {
            crate::model::RegisteredUserEmbeddingExperienceConfiguration {
                dashboard: self.dashboard,
                quick_sight_console: self.quick_sight_console,
                q_search_bar: self.q_search_bar,
            }
        }
    }
}
impl RegisteredUserEmbeddingExperienceConfiguration {
    /// Creates a new builder-style object to manufacture [`RegisteredUserEmbeddingExperienceConfiguration`](crate::model::RegisteredUserEmbeddingExperienceConfiguration)
    pub fn builder() -> crate::model::registered_user_embedding_experience_configuration::Builder {
        crate::model::registered_user_embedding_experience_configuration::Builder::default()
    }
}

/// <p>Information about the Q search bar embedding experience.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisteredUserQSearchBarEmbeddingConfiguration {
    /// <p>The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a topic ID by navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is in the URL for the topic that you open.</p>
    /// <p>If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your readers. When you select an initial topic, you can specify whether or not readers are allowed to select other topics from the available ones in the list.</p>
    pub initial_topic_id: std::option::Option<std::string::String>,
}
impl RegisteredUserQSearchBarEmbeddingConfiguration {
    /// <p>The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a topic ID by navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is in the URL for the topic that you open.</p>
    /// <p>If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your readers. When you select an initial topic, you can specify whether or not readers are allowed to select other topics from the available ones in the list.</p>
    pub fn initial_topic_id(&self) -> std::option::Option<&str> {
        self.initial_topic_id.as_deref()
    }
}
impl std::fmt::Debug for RegisteredUserQSearchBarEmbeddingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisteredUserQSearchBarEmbeddingConfiguration");
        formatter.field("initial_topic_id", &self.initial_topic_id);
        formatter.finish()
    }
}
/// See [`RegisteredUserQSearchBarEmbeddingConfiguration`](crate::model::RegisteredUserQSearchBarEmbeddingConfiguration)
pub mod registered_user_q_search_bar_embedding_configuration {
    /// A builder for [`RegisteredUserQSearchBarEmbeddingConfiguration`](crate::model::RegisteredUserQSearchBarEmbeddingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_topic_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a topic ID by navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is in the URL for the topic that you open.</p>
        /// <p>If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your readers. When you select an initial topic, you can specify whether or not readers are allowed to select other topics from the available ones in the list.</p>
        pub fn initial_topic_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_topic_id = Some(input.into());
            self
        }
        /// <p>The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a topic ID by navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is in the URL for the topic that you open.</p>
        /// <p>If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your readers. When you select an initial topic, you can specify whether or not readers are allowed to select other topics from the available ones in the list.</p>
        pub fn set_initial_topic_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_topic_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisteredUserQSearchBarEmbeddingConfiguration`](crate::model::RegisteredUserQSearchBarEmbeddingConfiguration)
        pub fn build(self) -> crate::model::RegisteredUserQSearchBarEmbeddingConfiguration {
            crate::model::RegisteredUserQSearchBarEmbeddingConfiguration {
                initial_topic_id: self.initial_topic_id,
            }
        }
    }
}
impl RegisteredUserQSearchBarEmbeddingConfiguration {
    /// Creates a new builder-style object to manufacture [`RegisteredUserQSearchBarEmbeddingConfiguration`](crate::model::RegisteredUserQSearchBarEmbeddingConfiguration)
    pub fn builder() -> crate::model::registered_user_q_search_bar_embedding_configuration::Builder
    {
        crate::model::registered_user_q_search_bar_embedding_configuration::Builder::default()
    }
}

/// <p>Information about the Amazon QuickSight console that you want to embed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisteredUserQuickSightConsoleEmbeddingConfiguration {
    /// <p>The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p>
    /// <p>The entry point URL is constrained to the following paths:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>/start</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/start/analyses</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/start/dashboards</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/start/favorites</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight console URL of the dashboard.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console URL of the analysis.</p>
    /// </li>
    /// </ul>
    pub initial_path: std::option::Option<std::string::String>,
}
impl RegisteredUserQuickSightConsoleEmbeddingConfiguration {
    /// <p>The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p>
    /// <p>The entry point URL is constrained to the following paths:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>/start</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/start/analyses</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/start/dashboards</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/start/favorites</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight console URL of the dashboard.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console URL of the analysis.</p>
    /// </li>
    /// </ul>
    pub fn initial_path(&self) -> std::option::Option<&str> {
        self.initial_path.as_deref()
    }
}
impl std::fmt::Debug for RegisteredUserQuickSightConsoleEmbeddingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisteredUserQuickSightConsoleEmbeddingConfiguration");
        formatter.field("initial_path", &self.initial_path);
        formatter.finish()
    }
}
/// See [`RegisteredUserQuickSightConsoleEmbeddingConfiguration`](crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration)
pub mod registered_user_quick_sight_console_embedding_configuration {
    /// A builder for [`RegisteredUserQuickSightConsoleEmbeddingConfiguration`](crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p>
        /// <p>The entry point URL is constrained to the following paths:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/start</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/analyses</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/dashboards</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/favorites</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight console URL of the dashboard.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console URL of the analysis.</p>
        /// </li>
        /// </ul>
        pub fn initial_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_path = Some(input.into());
            self
        }
        /// <p>The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p>
        /// <p>The entry point URL is constrained to the following paths:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/start</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/analyses</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/dashboards</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/favorites</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight console URL of the dashboard.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console URL of the analysis.</p>
        /// </li>
        /// </ul>
        pub fn set_initial_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.initial_path = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisteredUserQuickSightConsoleEmbeddingConfiguration`](crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration)
        pub fn build(self) -> crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration {
            crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration {
                initial_path: self.initial_path,
            }
        }
    }
}
impl RegisteredUserQuickSightConsoleEmbeddingConfiguration {
    /// Creates a new builder-style object to manufacture [`RegisteredUserQuickSightConsoleEmbeddingConfiguration`](crate::model::RegisteredUserQuickSightConsoleEmbeddingConfiguration)
    pub fn builder(
    ) -> crate::model::registered_user_quick_sight_console_embedding_configuration::Builder {
        crate::model::registered_user_quick_sight_console_embedding_configuration::Builder::default(
        )
    }
}

/// <p>Information about the dashboard you want to embed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisteredUserDashboardEmbeddingConfiguration {
    /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to view it.</p>
    /// <p>If the user does not have permission to view this dashboard, they see a permissions error message.</p>
    pub initial_dashboard_id: std::option::Option<std::string::String>,
}
impl RegisteredUserDashboardEmbeddingConfiguration {
    /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to view it.</p>
    /// <p>If the user does not have permission to view this dashboard, they see a permissions error message.</p>
    pub fn initial_dashboard_id(&self) -> std::option::Option<&str> {
        self.initial_dashboard_id.as_deref()
    }
}
impl std::fmt::Debug for RegisteredUserDashboardEmbeddingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisteredUserDashboardEmbeddingConfiguration");
        formatter.field("initial_dashboard_id", &self.initial_dashboard_id);
        formatter.finish()
    }
}
/// See [`RegisteredUserDashboardEmbeddingConfiguration`](crate::model::RegisteredUserDashboardEmbeddingConfiguration)
pub mod registered_user_dashboard_embedding_configuration {
    /// A builder for [`RegisteredUserDashboardEmbeddingConfiguration`](crate::model::RegisteredUserDashboardEmbeddingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_dashboard_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to view it.</p>
        /// <p>If the user does not have permission to view this dashboard, they see a permissions error message.</p>
        pub fn initial_dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_dashboard_id = Some(input.into());
            self
        }
        /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to view it.</p>
        /// <p>If the user does not have permission to view this dashboard, they see a permissions error message.</p>
        pub fn set_initial_dashboard_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_dashboard_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisteredUserDashboardEmbeddingConfiguration`](crate::model::RegisteredUserDashboardEmbeddingConfiguration)
        pub fn build(self) -> crate::model::RegisteredUserDashboardEmbeddingConfiguration {
            crate::model::RegisteredUserDashboardEmbeddingConfiguration {
                initial_dashboard_id: self.initial_dashboard_id,
            }
        }
    }
}
impl RegisteredUserDashboardEmbeddingConfiguration {
    /// Creates a new builder-style object to manufacture [`RegisteredUserDashboardEmbeddingConfiguration`](crate::model::RegisteredUserDashboardEmbeddingConfiguration)
    pub fn builder() -> crate::model::registered_user_dashboard_embedding_configuration::Builder {
        crate::model::registered_user_dashboard_embedding_configuration::Builder::default()
    }
}

/// <p>The type of experience you want to embed. For anonymous users, you can embed an Amazon QuickSight dashboard.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnonymousUserEmbeddingExperienceConfiguration {
    /// <p>The type of embedding experience. In this case, an Amazon QuickSight dashboard.</p>
    pub dashboard: std::option::Option<crate::model::AnonymousUserDashboardEmbeddingConfiguration>,
}
impl AnonymousUserEmbeddingExperienceConfiguration {
    /// <p>The type of embedding experience. In this case, an Amazon QuickSight dashboard.</p>
    pub fn dashboard(
        &self,
    ) -> std::option::Option<&crate::model::AnonymousUserDashboardEmbeddingConfiguration> {
        self.dashboard.as_ref()
    }
}
impl std::fmt::Debug for AnonymousUserEmbeddingExperienceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnonymousUserEmbeddingExperienceConfiguration");
        formatter.field("dashboard", &self.dashboard);
        formatter.finish()
    }
}
/// See [`AnonymousUserEmbeddingExperienceConfiguration`](crate::model::AnonymousUserEmbeddingExperienceConfiguration)
pub mod anonymous_user_embedding_experience_configuration {
    /// A builder for [`AnonymousUserEmbeddingExperienceConfiguration`](crate::model::AnonymousUserEmbeddingExperienceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard:
            std::option::Option<crate::model::AnonymousUserDashboardEmbeddingConfiguration>,
    }
    impl Builder {
        /// <p>The type of embedding experience. In this case, an Amazon QuickSight dashboard.</p>
        pub fn dashboard(
            mut self,
            input: crate::model::AnonymousUserDashboardEmbeddingConfiguration,
        ) -> Self {
            self.dashboard = Some(input);
            self
        }
        /// <p>The type of embedding experience. In this case, an Amazon QuickSight dashboard.</p>
        pub fn set_dashboard(
            mut self,
            input: std::option::Option<crate::model::AnonymousUserDashboardEmbeddingConfiguration>,
        ) -> Self {
            self.dashboard = input;
            self
        }
        /// Consumes the builder and constructs a [`AnonymousUserEmbeddingExperienceConfiguration`](crate::model::AnonymousUserEmbeddingExperienceConfiguration)
        pub fn build(self) -> crate::model::AnonymousUserEmbeddingExperienceConfiguration {
            crate::model::AnonymousUserEmbeddingExperienceConfiguration {
                dashboard: self.dashboard,
            }
        }
    }
}
impl AnonymousUserEmbeddingExperienceConfiguration {
    /// Creates a new builder-style object to manufacture [`AnonymousUserEmbeddingExperienceConfiguration`](crate::model::AnonymousUserEmbeddingExperienceConfiguration)
    pub fn builder() -> crate::model::anonymous_user_embedding_experience_configuration::Builder {
        crate::model::anonymous_user_embedding_experience_configuration::Builder::default()
    }
}

/// <p>Information about the dashboard that you want to embed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnonymousUserDashboardEmbeddingConfiguration {
    /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p>
    /// <p>The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>
    pub initial_dashboard_id: std::option::Option<std::string::String>,
}
impl AnonymousUserDashboardEmbeddingConfiguration {
    /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p>
    /// <p>The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>
    pub fn initial_dashboard_id(&self) -> std::option::Option<&str> {
        self.initial_dashboard_id.as_deref()
    }
}
impl std::fmt::Debug for AnonymousUserDashboardEmbeddingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnonymousUserDashboardEmbeddingConfiguration");
        formatter.field("initial_dashboard_id", &self.initial_dashboard_id);
        formatter.finish()
    }
}
/// See [`AnonymousUserDashboardEmbeddingConfiguration`](crate::model::AnonymousUserDashboardEmbeddingConfiguration)
pub mod anonymous_user_dashboard_embedding_configuration {
    /// A builder for [`AnonymousUserDashboardEmbeddingConfiguration`](crate::model::AnonymousUserDashboardEmbeddingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_dashboard_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p>
        /// <p>The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>
        pub fn initial_dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_dashboard_id = Some(input.into());
            self
        }
        /// <p>The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.</p>
        /// <p>The Amazon Resource Name (ARN) of this dashboard must be included in the <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with <code>InvalidParameterValueException</code>.</p>
        pub fn set_initial_dashboard_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_dashboard_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AnonymousUserDashboardEmbeddingConfiguration`](crate::model::AnonymousUserDashboardEmbeddingConfiguration)
        pub fn build(self) -> crate::model::AnonymousUserDashboardEmbeddingConfiguration {
            crate::model::AnonymousUserDashboardEmbeddingConfiguration {
                initial_dashboard_id: self.initial_dashboard_id,
            }
        }
    }
}
impl AnonymousUserDashboardEmbeddingConfiguration {
    /// Creates a new builder-style object to manufacture [`AnonymousUserDashboardEmbeddingConfiguration`](crate::model::AnonymousUserDashboardEmbeddingConfiguration)
    pub fn builder() -> crate::model::anonymous_user_dashboard_embedding_configuration::Builder {
        crate::model::anonymous_user_dashboard_embedding_configuration::Builder::default()
    }
}

/// <p>The key-value pair used for the row-level security tags feature.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionTag {
    /// <p>The key for the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value that you want to assign the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl SessionTag {
    /// <p>The key for the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value that you want to assign the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SessionTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionTag");
        formatter.field("key", &self.key);
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`SessionTag`](crate::model::SessionTag)
pub mod session_tag {
    /// A builder for [`SessionTag`](crate::model::SessionTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value that you want to assign the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value that you want to assign the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionTag`](crate::model::SessionTag)
        pub fn build(self) -> crate::model::SessionTag {
            crate::model::SessionTag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl SessionTag {
    /// Creates a new builder-style object to manufacture [`SessionTag`](crate::model::SessionTag)
    pub fn builder() -> crate::model::session_tag::Builder {
        crate::model::session_tag::Builder::default()
    }
}

/// <p>Summary information about a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Theme {
    /// <p>The Amazon Resource Name (ARN) of the theme.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name that the user gives to the theme.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier that the user gives to the theme.</p>
    pub theme_id: std::option::Option<std::string::String>,
    /// <p>A version of a theme.</p>
    pub version: std::option::Option<crate::model::ThemeVersion>,
    /// <p>The date and time that the theme was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the theme was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of theme, based on how it was created. Valid values include:
    /// <code>QUICKSIGHT</code> and <code>CUSTOM</code>.</p>
    pub r#type: std::option::Option<crate::model::ThemeType>,
}
impl Theme {
    /// <p>The Amazon Resource Name (ARN) of the theme.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name that the user gives to the theme.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier that the user gives to the theme.</p>
    pub fn theme_id(&self) -> std::option::Option<&str> {
        self.theme_id.as_deref()
    }
    /// <p>A version of a theme.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::ThemeVersion> {
        self.version.as_ref()
    }
    /// <p>The date and time that the theme was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the theme was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>The type of theme, based on how it was created. Valid values include:
    /// <code>QUICKSIGHT</code> and <code>CUSTOM</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ThemeType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Theme {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Theme");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("theme_id", &self.theme_id);
        formatter.field("version", &self.version);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Theme`](crate::model::Theme)
pub mod theme {
    /// A builder for [`Theme`](crate::model::Theme)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) theme_id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<crate::model::ThemeVersion>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) r#type: std::option::Option<crate::model::ThemeType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the theme.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name that the user gives to the theme.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that the user gives to the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier that the user gives to the theme.</p>
        pub fn theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_id = Some(input.into());
            self
        }
        /// <p>The identifier that the user gives to the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_id = input;
            self
        }
        /// <p>A version of a theme.</p>
        pub fn version(mut self, input: crate::model::ThemeVersion) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>A version of a theme.</p>
        pub fn set_version(
            mut self,
            input: std::option::Option<crate::model::ThemeVersion>,
        ) -> Self {
            self.version = input;
            self
        }
        /// <p>The date and time that the theme was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the theme was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the theme was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The date and time that the theme was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The type of theme, based on how it was created. Valid values include:
        /// <code>QUICKSIGHT</code> and <code>CUSTOM</code>.</p>
        pub fn r#type(mut self, input: crate::model::ThemeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of theme, based on how it was created. Valid values include:
        /// <code>QUICKSIGHT</code> and <code>CUSTOM</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ThemeType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Theme`](crate::model::Theme)
        pub fn build(self) -> crate::model::Theme {
            crate::model::Theme {
                arn: self.arn,
                name: self.name,
                theme_id: self.theme_id,
                version: self.version,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                r#type: self.r#type,
            }
        }
    }
}
impl Theme {
    /// Creates a new builder-style object to manufacture [`Theme`](crate::model::Theme)
    pub fn builder() -> crate::model::theme::Builder {
        crate::model::theme::Builder::default()
    }
}

/// <p>A version of a theme.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeVersion {
    /// <p>The version number of the theme.</p>
    pub version_number: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description of the theme.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All
    /// themes initially inherit from a default Amazon QuickSight theme.</p>
    pub base_theme_id: std::option::Option<std::string::String>,
    /// <p>The date and time that this theme version was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The theme configuration, which contains all the theme display properties.</p>
    pub configuration: std::option::Option<crate::model::ThemeConfiguration>,
    /// <p>Errors associated with the theme.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::ThemeError>>,
    /// <p>The status of the theme version.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
}
impl ThemeVersion {
    /// <p>The version number of the theme.</p>
    pub fn version_number(&self) -> std::option::Option<i64> {
        self.version_number
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description of the theme.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All
    /// themes initially inherit from a default Amazon QuickSight theme.</p>
    pub fn base_theme_id(&self) -> std::option::Option<&str> {
        self.base_theme_id.as_deref()
    }
    /// <p>The date and time that this theme version was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The theme configuration, which contains all the theme display properties.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ThemeConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>Errors associated with the theme.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::ThemeError]> {
        self.errors.as_deref()
    }
    /// <p>The status of the theme version.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ThemeVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeVersion");
        formatter.field("version_number", &self.version_number);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("base_theme_id", &self.base_theme_id);
        formatter.field("created_time", &self.created_time);
        formatter.field("configuration", &self.configuration);
        formatter.field("errors", &self.errors);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ThemeVersion`](crate::model::ThemeVersion)
pub mod theme_version {
    /// A builder for [`ThemeVersion`](crate::model::ThemeVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) base_theme_id: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) configuration: std::option::Option<crate::model::ThemeConfiguration>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::ThemeError>>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
    }
    impl Builder {
        /// <p>The version number of the theme.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the theme.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description of the theme.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the theme.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All
        /// themes initially inherit from a default Amazon QuickSight theme.</p>
        pub fn base_theme_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_theme_id = Some(input.into());
            self
        }
        /// <p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All
        /// themes initially inherit from a default Amazon QuickSight theme.</p>
        pub fn set_base_theme_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_theme_id = input;
            self
        }
        /// <p>The date and time that this theme version was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that this theme version was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The theme configuration, which contains all the theme display properties.</p>
        pub fn configuration(mut self, input: crate::model::ThemeConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The theme configuration, which contains all the theme display properties.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ThemeConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Errors associated with the theme.</p>
        pub fn errors(mut self, input: impl Into<crate::model::ThemeError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Errors associated with the theme.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThemeError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// <p>The status of the theme version.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the theme version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeVersion`](crate::model::ThemeVersion)
        pub fn build(self) -> crate::model::ThemeVersion {
            crate::model::ThemeVersion {
                version_number: self.version_number,
                arn: self.arn,
                description: self.description,
                base_theme_id: self.base_theme_id,
                created_time: self.created_time,
                configuration: self.configuration,
                errors: self.errors,
                status: self.status,
            }
        }
    }
}
impl ThemeVersion {
    /// Creates a new builder-style object to manufacture [`ThemeVersion`](crate::model::ThemeVersion)
    pub fn builder() -> crate::model::theme_version::Builder {
        crate::model::theme_version::Builder::default()
    }
}

/// <p>Theme error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThemeError {
    /// <p>The type of error.</p>
    pub r#type: std::option::Option<crate::model::ThemeErrorType>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ThemeError {
    /// <p>The type of error.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ThemeErrorType> {
        self.r#type.as_ref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ThemeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThemeError");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ThemeError`](crate::model::ThemeError)
pub mod theme_error {
    /// A builder for [`ThemeError`](crate::model::ThemeError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ThemeErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of error.</p>
        pub fn r#type(mut self, input: crate::model::ThemeErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of error.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ThemeErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThemeError`](crate::model::ThemeError)
        pub fn build(self) -> crate::model::ThemeError {
            crate::model::ThemeError {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ThemeError {
    /// Creates a new builder-style object to manufacture [`ThemeError`](crate::model::ThemeError)
    pub fn builder() -> crate::model::theme_error::Builder {
        crate::model::theme_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThemeErrorType {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThemeErrorType {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_FAILURE" => ThemeErrorType::InternalFailure,
            other => ThemeErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThemeErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThemeErrorType::from(s))
    }
}
impl ThemeErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThemeErrorType::InternalFailure => "INTERNAL_FAILURE",
            ThemeErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_FAILURE"]
    }
}
impl AsRef<str> for ThemeErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A template object. A <i>template</i> is an entity in Amazon QuickSight that
/// encapsulates the metadata required to create an analysis and that you can use to create
/// a dashboard. A template adds a layer of abstraction by using placeholders to replace the
/// dataset associated with an analysis. You can use templates to create dashboards by
/// replacing dataset placeholders with datasets that follow the same schema that was used
/// to create the source analysis and template.</p>
/// <p>You can share templates across Amazon Web Services accounts by allowing users in other Amazon Web Services accounts to
/// create a template or a dashboard from an existing template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Template {
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The display name of the template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A structure describing the versions of the template.</p>
    pub version: std::option::Option<crate::model::TemplateVersion>,
    /// <p>The ID for the template. This is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>Time when this was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Time when this was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Template {
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The display name of the template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A structure describing the versions of the template.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::TemplateVersion> {
        self.version.as_ref()
    }
    /// <p>The ID for the template. This is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>Time when this was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>Time when this was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for Template {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Template");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("template_id", &self.template_id);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`Template`](crate::model::Template)
pub mod template {
    /// A builder for [`Template`](crate::model::Template)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<crate::model::TemplateVersion>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The display name of the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The display name of the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A structure describing the versions of the template.</p>
        pub fn version(mut self, input: crate::model::TemplateVersion) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>A structure describing the versions of the template.</p>
        pub fn set_version(
            mut self,
            input: std::option::Option<crate::model::TemplateVersion>,
        ) -> Self {
            self.version = input;
            self
        }
        /// <p>The ID for the template. This is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>The ID for the template. This is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>Time when this was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>Time when this was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>Time when this was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>Time when this was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Template`](crate::model::Template)
        pub fn build(self) -> crate::model::Template {
            crate::model::Template {
                arn: self.arn,
                name: self.name,
                version: self.version,
                template_id: self.template_id,
                last_updated_time: self.last_updated_time,
                created_time: self.created_time,
            }
        }
    }
}
impl Template {
    /// Creates a new builder-style object to manufacture [`Template`](crate::model::Template)
    pub fn builder() -> crate::model::template::Builder {
        crate::model::template::Builder::default()
    }
}

/// <p>A version of a template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateVersion {
    /// <p>The time that this template version was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Errors associated with this template version.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::TemplateError>>,
    /// <p>The version number of the template version.</p>
    pub version_number: std::option::Option<i64>,
    /// <p>The HTTP status of the request.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>Schema of the dataset identified by the placeholder. Any dashboard created from this
    /// template should be bound to new datasets matching the same schema described through this
    /// API operation.</p>
    pub data_set_configurations:
        std::option::Option<std::vec::Vec<crate::model::DataSetConfiguration>>,
    /// <p>The description of the template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this
    /// template.</p>
    pub source_entity_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the theme associated with this version of the template.</p>
    pub theme_arn: std::option::Option<std::string::String>,
    /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
    pub sheets: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
}
impl TemplateVersion {
    /// <p>The time that this template version was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>Errors associated with this template version.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::TemplateError]> {
        self.errors.as_deref()
    }
    /// <p>The version number of the template version.</p>
    pub fn version_number(&self) -> std::option::Option<i64> {
        self.version_number
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>Schema of the dataset identified by the placeholder. Any dashboard created from this
    /// template should be bound to new datasets matching the same schema described through this
    /// API operation.</p>
    pub fn data_set_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DataSetConfiguration]> {
        self.data_set_configurations.as_deref()
    }
    /// <p>The description of the template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this
    /// template.</p>
    pub fn source_entity_arn(&self) -> std::option::Option<&str> {
        self.source_entity_arn.as_deref()
    }
    /// <p>The ARN of the theme associated with this version of the template.</p>
    pub fn theme_arn(&self) -> std::option::Option<&str> {
        self.theme_arn.as_deref()
    }
    /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
    pub fn sheets(&self) -> std::option::Option<&[crate::model::Sheet]> {
        self.sheets.as_deref()
    }
}
impl std::fmt::Debug for TemplateVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateVersion");
        formatter.field("created_time", &self.created_time);
        formatter.field("errors", &self.errors);
        formatter.field("version_number", &self.version_number);
        formatter.field("status", &self.status);
        formatter.field("data_set_configurations", &self.data_set_configurations);
        formatter.field("description", &self.description);
        formatter.field("source_entity_arn", &self.source_entity_arn);
        formatter.field("theme_arn", &self.theme_arn);
        formatter.field("sheets", &self.sheets);
        formatter.finish()
    }
}
/// See [`TemplateVersion`](crate::model::TemplateVersion)
pub mod template_version {
    /// A builder for [`TemplateVersion`](crate::model::TemplateVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::TemplateError>>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) data_set_configurations:
            std::option::Option<std::vec::Vec<crate::model::DataSetConfiguration>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source_entity_arn: std::option::Option<std::string::String>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
        pub(crate) sheets: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
    }
    impl Builder {
        /// <p>The time that this template version was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this template version was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Errors associated with this template version.</p>
        pub fn errors(mut self, input: impl Into<crate::model::TemplateError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Errors associated with this template version.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TemplateError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// <p>The version number of the template version.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the template version.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `data_set_configurations`.
        ///
        /// To override the contents of this collection use [`set_data_set_configurations`](Self::set_data_set_configurations).
        ///
        /// <p>Schema of the dataset identified by the placeholder. Any dashboard created from this
        /// template should be bound to new datasets matching the same schema described through this
        /// API operation.</p>
        pub fn data_set_configurations(
            mut self,
            input: impl Into<crate::model::DataSetConfiguration>,
        ) -> Self {
            let mut v = self.data_set_configurations.unwrap_or_default();
            v.push(input.into());
            self.data_set_configurations = Some(v);
            self
        }
        /// <p>Schema of the dataset identified by the placeholder. Any dashboard created from this
        /// template should be bound to new datasets matching the same schema described through this
        /// API operation.</p>
        pub fn set_data_set_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSetConfiguration>>,
        ) -> Self {
            self.data_set_configurations = input;
            self
        }
        /// <p>The description of the template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this
        /// template.</p>
        pub fn source_entity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_entity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an analysis or template that was used to create this
        /// template.</p>
        pub fn set_source_entity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_entity_arn = input;
            self
        }
        /// <p>The ARN of the theme associated with this version of the template.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the theme associated with this version of the template.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Appends an item to `sheets`.
        ///
        /// To override the contents of this collection use [`set_sheets`](Self::set_sheets).
        ///
        /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        pub fn sheets(mut self, input: impl Into<crate::model::Sheet>) -> Self {
            let mut v = self.sheets.unwrap_or_default();
            v.push(input.into());
            self.sheets = Some(v);
            self
        }
        /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        pub fn set_sheets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
        ) -> Self {
            self.sheets = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateVersion`](crate::model::TemplateVersion)
        pub fn build(self) -> crate::model::TemplateVersion {
            crate::model::TemplateVersion {
                created_time: self.created_time,
                errors: self.errors,
                version_number: self.version_number,
                status: self.status,
                data_set_configurations: self.data_set_configurations,
                description: self.description,
                source_entity_arn: self.source_entity_arn,
                theme_arn: self.theme_arn,
                sheets: self.sheets,
            }
        }
    }
}
impl TemplateVersion {
    /// Creates a new builder-style object to manufacture [`TemplateVersion`](crate::model::TemplateVersion)
    pub fn builder() -> crate::model::template_version::Builder {
        crate::model::template_version::Builder::default()
    }
}

/// <p>A <i>sheet</i>, which is an object that contains a set of visuals that
/// are viewed together on one page in Amazon QuickSight. Every analysis and dashboard
/// contains at least one sheet. Each sheet contains at least one visualization widget, for
/// example a chart, pivot table, or narrative insight. Sheets can be associated with other
/// components, such as controls, filters, and so on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sheet {
    /// <p>The unique identifier associated with a sheet.</p>
    pub sheet_id: std::option::Option<std::string::String>,
    /// <p>The name of a sheet. This name is displayed on the sheet's tab in the Amazon QuickSight
    /// console.</p>
    pub name: std::option::Option<std::string::String>,
}
impl Sheet {
    /// <p>The unique identifier associated with a sheet.</p>
    pub fn sheet_id(&self) -> std::option::Option<&str> {
        self.sheet_id.as_deref()
    }
    /// <p>The name of a sheet. This name is displayed on the sheet's tab in the Amazon QuickSight
    /// console.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for Sheet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sheet");
        formatter.field("sheet_id", &self.sheet_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Sheet`](crate::model::Sheet)
pub mod sheet {
    /// A builder for [`Sheet`](crate::model::Sheet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sheet_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier associated with a sheet.</p>
        pub fn sheet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sheet_id = Some(input.into());
            self
        }
        /// <p>The unique identifier associated with a sheet.</p>
        pub fn set_sheet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sheet_id = input;
            self
        }
        /// <p>The name of a sheet. This name is displayed on the sheet's tab in the Amazon QuickSight
        /// console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a sheet. This name is displayed on the sheet's tab in the Amazon QuickSight
        /// console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Sheet`](crate::model::Sheet)
        pub fn build(self) -> crate::model::Sheet {
            crate::model::Sheet {
                sheet_id: self.sheet_id,
                name: self.name,
            }
        }
    }
}
impl Sheet {
    /// Creates a new builder-style object to manufacture [`Sheet`](crate::model::Sheet)
    pub fn builder() -> crate::model::sheet::Builder {
        crate::model::sheet::Builder::default()
    }
}

/// <p>Dataset configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSetConfiguration {
    /// <p>Placeholder.</p>
    pub placeholder: std::option::Option<std::string::String>,
    /// <p>Dataset schema.</p>
    pub data_set_schema: std::option::Option<crate::model::DataSetSchema>,
    /// <p>A structure containing the list of column group schemas.</p>
    pub column_group_schema_list:
        std::option::Option<std::vec::Vec<crate::model::ColumnGroupSchema>>,
}
impl DataSetConfiguration {
    /// <p>Placeholder.</p>
    pub fn placeholder(&self) -> std::option::Option<&str> {
        self.placeholder.as_deref()
    }
    /// <p>Dataset schema.</p>
    pub fn data_set_schema(&self) -> std::option::Option<&crate::model::DataSetSchema> {
        self.data_set_schema.as_ref()
    }
    /// <p>A structure containing the list of column group schemas.</p>
    pub fn column_group_schema_list(
        &self,
    ) -> std::option::Option<&[crate::model::ColumnGroupSchema]> {
        self.column_group_schema_list.as_deref()
    }
}
impl std::fmt::Debug for DataSetConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSetConfiguration");
        formatter.field("placeholder", &self.placeholder);
        formatter.field("data_set_schema", &self.data_set_schema);
        formatter.field("column_group_schema_list", &self.column_group_schema_list);
        formatter.finish()
    }
}
/// See [`DataSetConfiguration`](crate::model::DataSetConfiguration)
pub mod data_set_configuration {
    /// A builder for [`DataSetConfiguration`](crate::model::DataSetConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placeholder: std::option::Option<std::string::String>,
        pub(crate) data_set_schema: std::option::Option<crate::model::DataSetSchema>,
        pub(crate) column_group_schema_list:
            std::option::Option<std::vec::Vec<crate::model::ColumnGroupSchema>>,
    }
    impl Builder {
        /// <p>Placeholder.</p>
        pub fn placeholder(mut self, input: impl Into<std::string::String>) -> Self {
            self.placeholder = Some(input.into());
            self
        }
        /// <p>Placeholder.</p>
        pub fn set_placeholder(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.placeholder = input;
            self
        }
        /// <p>Dataset schema.</p>
        pub fn data_set_schema(mut self, input: crate::model::DataSetSchema) -> Self {
            self.data_set_schema = Some(input);
            self
        }
        /// <p>Dataset schema.</p>
        pub fn set_data_set_schema(
            mut self,
            input: std::option::Option<crate::model::DataSetSchema>,
        ) -> Self {
            self.data_set_schema = input;
            self
        }
        /// Appends an item to `column_group_schema_list`.
        ///
        /// To override the contents of this collection use [`set_column_group_schema_list`](Self::set_column_group_schema_list).
        ///
        /// <p>A structure containing the list of column group schemas.</p>
        pub fn column_group_schema_list(
            mut self,
            input: impl Into<crate::model::ColumnGroupSchema>,
        ) -> Self {
            let mut v = self.column_group_schema_list.unwrap_or_default();
            v.push(input.into());
            self.column_group_schema_list = Some(v);
            self
        }
        /// <p>A structure containing the list of column group schemas.</p>
        pub fn set_column_group_schema_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroupSchema>>,
        ) -> Self {
            self.column_group_schema_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSetConfiguration`](crate::model::DataSetConfiguration)
        pub fn build(self) -> crate::model::DataSetConfiguration {
            crate::model::DataSetConfiguration {
                placeholder: self.placeholder,
                data_set_schema: self.data_set_schema,
                column_group_schema_list: self.column_group_schema_list,
            }
        }
    }
}
impl DataSetConfiguration {
    /// Creates a new builder-style object to manufacture [`DataSetConfiguration`](crate::model::DataSetConfiguration)
    pub fn builder() -> crate::model::data_set_configuration::Builder {
        crate::model::data_set_configuration::Builder::default()
    }
}

/// <p>The column group schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnGroupSchema {
    /// <p>The name of the column group schema.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A structure containing the list of schemas for column group columns.</p>
    pub column_group_column_schema_list:
        std::option::Option<std::vec::Vec<crate::model::ColumnGroupColumnSchema>>,
}
impl ColumnGroupSchema {
    /// <p>The name of the column group schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A structure containing the list of schemas for column group columns.</p>
    pub fn column_group_column_schema_list(
        &self,
    ) -> std::option::Option<&[crate::model::ColumnGroupColumnSchema]> {
        self.column_group_column_schema_list.as_deref()
    }
}
impl std::fmt::Debug for ColumnGroupSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnGroupSchema");
        formatter.field("name", &self.name);
        formatter.field(
            "column_group_column_schema_list",
            &self.column_group_column_schema_list,
        );
        formatter.finish()
    }
}
/// See [`ColumnGroupSchema`](crate::model::ColumnGroupSchema)
pub mod column_group_schema {
    /// A builder for [`ColumnGroupSchema`](crate::model::ColumnGroupSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) column_group_column_schema_list:
            std::option::Option<std::vec::Vec<crate::model::ColumnGroupColumnSchema>>,
    }
    impl Builder {
        /// <p>The name of the column group schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column group schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `column_group_column_schema_list`.
        ///
        /// To override the contents of this collection use [`set_column_group_column_schema_list`](Self::set_column_group_column_schema_list).
        ///
        /// <p>A structure containing the list of schemas for column group columns.</p>
        pub fn column_group_column_schema_list(
            mut self,
            input: impl Into<crate::model::ColumnGroupColumnSchema>,
        ) -> Self {
            let mut v = self.column_group_column_schema_list.unwrap_or_default();
            v.push(input.into());
            self.column_group_column_schema_list = Some(v);
            self
        }
        /// <p>A structure containing the list of schemas for column group columns.</p>
        pub fn set_column_group_column_schema_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroupColumnSchema>>,
        ) -> Self {
            self.column_group_column_schema_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnGroupSchema`](crate::model::ColumnGroupSchema)
        pub fn build(self) -> crate::model::ColumnGroupSchema {
            crate::model::ColumnGroupSchema {
                name: self.name,
                column_group_column_schema_list: self.column_group_column_schema_list,
            }
        }
    }
}
impl ColumnGroupSchema {
    /// Creates a new builder-style object to manufacture [`ColumnGroupSchema`](crate::model::ColumnGroupSchema)
    pub fn builder() -> crate::model::column_group_schema::Builder {
        crate::model::column_group_schema::Builder::default()
    }
}

/// <p>A structure describing the name, data type, and geographic role of the columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnGroupColumnSchema {
    /// <p>The name of the column group's column schema.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ColumnGroupColumnSchema {
    /// <p>The name of the column group's column schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ColumnGroupColumnSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnGroupColumnSchema");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ColumnGroupColumnSchema`](crate::model::ColumnGroupColumnSchema)
pub mod column_group_column_schema {
    /// A builder for [`ColumnGroupColumnSchema`](crate::model::ColumnGroupColumnSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column group's column schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column group's column schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnGroupColumnSchema`](crate::model::ColumnGroupColumnSchema)
        pub fn build(self) -> crate::model::ColumnGroupColumnSchema {
            crate::model::ColumnGroupColumnSchema { name: self.name }
        }
    }
}
impl ColumnGroupColumnSchema {
    /// Creates a new builder-style object to manufacture [`ColumnGroupColumnSchema`](crate::model::ColumnGroupColumnSchema)
    pub fn builder() -> crate::model::column_group_column_schema::Builder {
        crate::model::column_group_column_schema::Builder::default()
    }
}

/// <p>Dataset schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSetSchema {
    /// <p>A structure containing the list of column schemas.</p>
    pub column_schema_list: std::option::Option<std::vec::Vec<crate::model::ColumnSchema>>,
}
impl DataSetSchema {
    /// <p>A structure containing the list of column schemas.</p>
    pub fn column_schema_list(&self) -> std::option::Option<&[crate::model::ColumnSchema]> {
        self.column_schema_list.as_deref()
    }
}
impl std::fmt::Debug for DataSetSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSetSchema");
        formatter.field("column_schema_list", &self.column_schema_list);
        formatter.finish()
    }
}
/// See [`DataSetSchema`](crate::model::DataSetSchema)
pub mod data_set_schema {
    /// A builder for [`DataSetSchema`](crate::model::DataSetSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_schema_list:
            std::option::Option<std::vec::Vec<crate::model::ColumnSchema>>,
    }
    impl Builder {
        /// Appends an item to `column_schema_list`.
        ///
        /// To override the contents of this collection use [`set_column_schema_list`](Self::set_column_schema_list).
        ///
        /// <p>A structure containing the list of column schemas.</p>
        pub fn column_schema_list(mut self, input: impl Into<crate::model::ColumnSchema>) -> Self {
            let mut v = self.column_schema_list.unwrap_or_default();
            v.push(input.into());
            self.column_schema_list = Some(v);
            self
        }
        /// <p>A structure containing the list of column schemas.</p>
        pub fn set_column_schema_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnSchema>>,
        ) -> Self {
            self.column_schema_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSetSchema`](crate::model::DataSetSchema)
        pub fn build(self) -> crate::model::DataSetSchema {
            crate::model::DataSetSchema {
                column_schema_list: self.column_schema_list,
            }
        }
    }
}
impl DataSetSchema {
    /// Creates a new builder-style object to manufacture [`DataSetSchema`](crate::model::DataSetSchema)
    pub fn builder() -> crate::model::data_set_schema::Builder {
        crate::model::data_set_schema::Builder::default()
    }
}

/// <p>The column schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnSchema {
    /// <p>The name of the column schema.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the column schema.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>The geographic role of the column schema.</p>
    pub geographic_role: std::option::Option<std::string::String>,
}
impl ColumnSchema {
    /// <p>The name of the column schema.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the column schema.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>The geographic role of the column schema.</p>
    pub fn geographic_role(&self) -> std::option::Option<&str> {
        self.geographic_role.as_deref()
    }
}
impl std::fmt::Debug for ColumnSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnSchema");
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.field("geographic_role", &self.geographic_role);
        formatter.finish()
    }
}
/// See [`ColumnSchema`](crate::model::ColumnSchema)
pub mod column_schema {
    /// A builder for [`ColumnSchema`](crate::model::ColumnSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) geographic_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column schema.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column schema.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the column schema.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the column schema.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The geographic role of the column schema.</p>
        pub fn geographic_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.geographic_role = Some(input.into());
            self
        }
        /// <p>The geographic role of the column schema.</p>
        pub fn set_geographic_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.geographic_role = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnSchema`](crate::model::ColumnSchema)
        pub fn build(self) -> crate::model::ColumnSchema {
            crate::model::ColumnSchema {
                name: self.name,
                data_type: self.data_type,
                geographic_role: self.geographic_role,
            }
        }
    }
}
impl ColumnSchema {
    /// Creates a new builder-style object to manufacture [`ColumnSchema`](crate::model::ColumnSchema)
    pub fn builder() -> crate::model::column_schema::Builder {
        crate::model::column_schema::Builder::default()
    }
}

/// <p>List of errors that occurred when the template version creation failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateError {
    /// <p>Type of error.</p>
    pub r#type: std::option::Option<crate::model::TemplateErrorType>,
    /// <p>Description of the error type.</p>
    pub message: std::option::Option<std::string::String>,
}
impl TemplateError {
    /// <p>Type of error.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TemplateErrorType> {
        self.r#type.as_ref()
    }
    /// <p>Description of the error type.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for TemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateError");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`TemplateError`](crate::model::TemplateError)
pub mod template_error {
    /// A builder for [`TemplateError`](crate::model::TemplateError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::TemplateErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Type of error.</p>
        pub fn r#type(mut self, input: crate::model::TemplateErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of error.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TemplateErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Description of the error type.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error type.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateError`](crate::model::TemplateError)
        pub fn build(self) -> crate::model::TemplateError {
            crate::model::TemplateError {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl TemplateError {
    /// Creates a new builder-style object to manufacture [`TemplateError`](crate::model::TemplateError)
    pub fn builder() -> crate::model::template_error::Builder {
        crate::model::template_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemplateErrorType {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    DataSetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    SourceNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemplateErrorType {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => TemplateErrorType::AccessDenied,
            "DATA_SET_NOT_FOUND" => TemplateErrorType::DataSetNotFound,
            "INTERNAL_FAILURE" => TemplateErrorType::InternalFailure,
            "SOURCE_NOT_FOUND" => TemplateErrorType::SourceNotFound,
            other => TemplateErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemplateErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemplateErrorType::from(s))
    }
}
impl TemplateErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemplateErrorType::AccessDenied => "ACCESS_DENIED",
            TemplateErrorType::DataSetNotFound => "DATA_SET_NOT_FOUND",
            TemplateErrorType::InternalFailure => "INTERNAL_FAILURE",
            TemplateErrorType::SourceNotFound => "SOURCE_NOT_FOUND",
            TemplateErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "DATA_SET_NOT_FOUND",
            "INTERNAL_FAILURE",
            "SOURCE_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for TemplateErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An Identity and Access Management (IAM) policy assignment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamPolicyAssignment {
    /// <p>The Amazon Web Services account ID.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>Assignment ID.</p>
    pub assignment_id: std::option::Option<std::string::String>,
    /// <p>Assignment name.</p>
    pub assignment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the IAMpolicy.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>Identities.</p>
    pub identities: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>Assignment status.</p>
    pub assignment_status: std::option::Option<crate::model::AssignmentStatus>,
}
impl IamPolicyAssignment {
    /// <p>The Amazon Web Services account ID.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>Assignment ID.</p>
    pub fn assignment_id(&self) -> std::option::Option<&str> {
        self.assignment_id.as_deref()
    }
    /// <p>Assignment name.</p>
    pub fn assignment_name(&self) -> std::option::Option<&str> {
        self.assignment_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the IAMpolicy.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>Identities.</p>
    pub fn identities(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.identities.as_ref()
    }
    /// <p>Assignment status.</p>
    pub fn assignment_status(&self) -> std::option::Option<&crate::model::AssignmentStatus> {
        self.assignment_status.as_ref()
    }
}
impl std::fmt::Debug for IamPolicyAssignment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamPolicyAssignment");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("assignment_id", &self.assignment_id);
        formatter.field("assignment_name", &self.assignment_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("identities", &self.identities);
        formatter.field("assignment_status", &self.assignment_status);
        formatter.finish()
    }
}
/// See [`IamPolicyAssignment`](crate::model::IamPolicyAssignment)
pub mod iam_policy_assignment {
    /// A builder for [`IamPolicyAssignment`](crate::model::IamPolicyAssignment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) assignment_id: std::option::Option<std::string::String>,
        pub(crate) assignment_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) identities: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatus>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>Assignment ID.</p>
        pub fn assignment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_id = Some(input.into());
            self
        }
        /// <p>Assignment ID.</p>
        pub fn set_assignment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_id = input;
            self
        }
        /// <p>Assignment name.</p>
        pub fn assignment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assignment_name = Some(input.into());
            self
        }
        /// <p>Assignment name.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assignment_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAMpolicy.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAMpolicy.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Adds a key-value pair to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>Identities.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.identities.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.identities = Some(hash_map);
            self
        }
        /// <p>Identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.identities = input;
            self
        }
        /// <p>Assignment status.</p>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatus) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p>Assignment status.</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// Consumes the builder and constructs a [`IamPolicyAssignment`](crate::model::IamPolicyAssignment)
        pub fn build(self) -> crate::model::IamPolicyAssignment {
            crate::model::IamPolicyAssignment {
                aws_account_id: self.aws_account_id,
                assignment_id: self.assignment_id,
                assignment_name: self.assignment_name,
                policy_arn: self.policy_arn,
                identities: self.identities,
                assignment_status: self.assignment_status,
            }
        }
    }
}
impl IamPolicyAssignment {
    /// Creates a new builder-style object to manufacture [`IamPolicyAssignment`](crate::model::IamPolicyAssignment)
    pub fn builder() -> crate::model::iam_policy_assignment::Builder {
        crate::model::iam_policy_assignment::Builder::default()
    }
}

/// <p>A folder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Folder {
    /// <p>The folder ID.</p>
    pub folder_id: std::option::Option<std::string::String>,
    /// <p>The folder Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A display name for the folder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the folder.</p>
    pub folder_type: std::option::Option<crate::model::FolderType>,
    /// <p>An array of ancestor folder ARN strings.</p>
    pub folder_path: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the folder was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the folder was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Folder {
    /// <p>The folder ID.</p>
    pub fn folder_id(&self) -> std::option::Option<&str> {
        self.folder_id.as_deref()
    }
    /// <p>The folder Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A display name for the folder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the folder.</p>
    pub fn folder_type(&self) -> std::option::Option<&crate::model::FolderType> {
        self.folder_type.as_ref()
    }
    /// <p>An array of ancestor folder ARN strings.</p>
    pub fn folder_path(&self) -> std::option::Option<&[std::string::String]> {
        self.folder_path.as_deref()
    }
    /// <p>The time that the folder was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The time that the folder was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for Folder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Folder");
        formatter.field("folder_id", &self.folder_id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("folder_type", &self.folder_type);
        formatter.field("folder_path", &self.folder_path);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`Folder`](crate::model::Folder)
pub mod folder {
    /// A builder for [`Folder`](crate::model::Folder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) folder_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) folder_type: std::option::Option<crate::model::FolderType>,
        pub(crate) folder_path: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_id = Some(input.into());
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_id = input;
            self
        }
        /// <p>The folder Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The folder Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A display name for the folder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the folder.</p>
        pub fn folder_type(mut self, input: crate::model::FolderType) -> Self {
            self.folder_type = Some(input);
            self
        }
        /// <p>The type of the folder.</p>
        pub fn set_folder_type(
            mut self,
            input: std::option::Option<crate::model::FolderType>,
        ) -> Self {
            self.folder_type = input;
            self
        }
        /// Appends an item to `folder_path`.
        ///
        /// To override the contents of this collection use [`set_folder_path`](Self::set_folder_path).
        ///
        /// <p>An array of ancestor folder ARN strings.</p>
        pub fn folder_path(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.folder_path.unwrap_or_default();
            v.push(input.into());
            self.folder_path = Some(v);
            self
        }
        /// <p>An array of ancestor folder ARN strings.</p>
        pub fn set_folder_path(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.folder_path = input;
            self
        }
        /// <p>The time that the folder was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that the folder was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The time that the folder was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time that the folder was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Folder`](crate::model::Folder)
        pub fn build(self) -> crate::model::Folder {
            crate::model::Folder {
                folder_id: self.folder_id,
                arn: self.arn,
                name: self.name,
                folder_type: self.folder_type,
                folder_path: self.folder_path,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl Folder {
    /// Creates a new builder-style object to manufacture [`Folder`](crate::model::Folder)
    pub fn builder() -> crate::model::folder::Builder {
        crate::model::folder::Builder::default()
    }
}

/// <p>Dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSet {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the dataset.</p>
    pub data_set_id: std::option::Option<std::string::String>,
    /// <p>A display name for the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that this dataset was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this dataset was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Declares the physical tables that are available in the underlying data sources.</p>
    pub physical_table_map: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
    >,
    /// <p>Configures the combination and transformation of the data from the physical
    /// tables.</p>
    pub logical_table_map: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
    >,
    /// <p>The list of columns after all transforms. These columns are available in templates,
    /// analyses, and dashboards.</p>
    pub output_columns: std::option::Option<std::vec::Vec<crate::model::OutputColumn>>,
    /// <p>A value that indicates whether you want to import the data into SPICE.</p>
    pub import_mode: std::option::Option<crate::model::DataSetImportMode>,
    /// <p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't
    /// imported into SPICE.</p>
    pub consumed_spice_capacity_in_bytes: i64,
    /// <p>Groupings of columns that work together in certain Amazon QuickSight features.
    /// Currently, only geospatial hierarchy is supported.</p>
    pub column_groups: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
    /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
    pub field_folders: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
    >,
    /// <p>The row-level security configuration for the dataset.</p>
    pub row_level_permission_data_set: std::option::Option<crate::model::RowLevelPermissionDataSet>,
    /// <p>The element you can use to define tags for row-level security.</p>
    pub row_level_permission_tag_configuration:
        std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
    /// <p>A set of one or more definitions of a <code>
    /// <a>ColumnLevelPermissionRule</a>
    /// </code>.</p>
    pub column_level_permission_rules:
        std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
    /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
    pub data_set_usage_configuration: std::option::Option<crate::model::DataSetUsageConfiguration>,
}
impl DataSet {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the dataset.</p>
    pub fn data_set_id(&self) -> std::option::Option<&str> {
        self.data_set_id.as_deref()
    }
    /// <p>A display name for the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time that this dataset was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The last time that this dataset was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>Declares the physical tables that are available in the underlying data sources.</p>
    pub fn physical_table_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
    > {
        self.physical_table_map.as_ref()
    }
    /// <p>Configures the combination and transformation of the data from the physical
    /// tables.</p>
    pub fn logical_table_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
    > {
        self.logical_table_map.as_ref()
    }
    /// <p>The list of columns after all transforms. These columns are available in templates,
    /// analyses, and dashboards.</p>
    pub fn output_columns(&self) -> std::option::Option<&[crate::model::OutputColumn]> {
        self.output_columns.as_deref()
    }
    /// <p>A value that indicates whether you want to import the data into SPICE.</p>
    pub fn import_mode(&self) -> std::option::Option<&crate::model::DataSetImportMode> {
        self.import_mode.as_ref()
    }
    /// <p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't
    /// imported into SPICE.</p>
    pub fn consumed_spice_capacity_in_bytes(&self) -> i64 {
        self.consumed_spice_capacity_in_bytes
    }
    /// <p>Groupings of columns that work together in certain Amazon QuickSight features.
    /// Currently, only geospatial hierarchy is supported.</p>
    pub fn column_groups(&self) -> std::option::Option<&[crate::model::ColumnGroup]> {
        self.column_groups.as_deref()
    }
    /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
    pub fn field_folders(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
    > {
        self.field_folders.as_ref()
    }
    /// <p>The row-level security configuration for the dataset.</p>
    pub fn row_level_permission_data_set(
        &self,
    ) -> std::option::Option<&crate::model::RowLevelPermissionDataSet> {
        self.row_level_permission_data_set.as_ref()
    }
    /// <p>The element you can use to define tags for row-level security.</p>
    pub fn row_level_permission_tag_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RowLevelPermissionTagConfiguration> {
        self.row_level_permission_tag_configuration.as_ref()
    }
    /// <p>A set of one or more definitions of a <code>
    /// <a>ColumnLevelPermissionRule</a>
    /// </code>.</p>
    pub fn column_level_permission_rules(
        &self,
    ) -> std::option::Option<&[crate::model::ColumnLevelPermissionRule]> {
        self.column_level_permission_rules.as_deref()
    }
    /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
    pub fn data_set_usage_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataSetUsageConfiguration> {
        self.data_set_usage_configuration.as_ref()
    }
}
impl std::fmt::Debug for DataSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSet");
        formatter.field("arn", &self.arn);
        formatter.field("data_set_id", &self.data_set_id);
        formatter.field("name", &self.name);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("physical_table_map", &self.physical_table_map);
        formatter.field("logical_table_map", &self.logical_table_map);
        formatter.field("output_columns", &self.output_columns);
        formatter.field("import_mode", &self.import_mode);
        formatter.field(
            "consumed_spice_capacity_in_bytes",
            &self.consumed_spice_capacity_in_bytes,
        );
        formatter.field("column_groups", &self.column_groups);
        formatter.field("field_folders", &self.field_folders);
        formatter.field(
            "row_level_permission_data_set",
            &self.row_level_permission_data_set,
        );
        formatter.field(
            "row_level_permission_tag_configuration",
            &self.row_level_permission_tag_configuration,
        );
        formatter.field(
            "column_level_permission_rules",
            &self.column_level_permission_rules,
        );
        formatter.field(
            "data_set_usage_configuration",
            &self.data_set_usage_configuration,
        );
        formatter.finish()
    }
}
/// See [`DataSet`](crate::model::DataSet)
pub mod data_set {
    /// A builder for [`DataSet`](crate::model::DataSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) physical_table_map: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
        >,
        pub(crate) logical_table_map: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
        >,
        pub(crate) output_columns: std::option::Option<std::vec::Vec<crate::model::OutputColumn>>,
        pub(crate) import_mode: std::option::Option<crate::model::DataSetImportMode>,
        pub(crate) consumed_spice_capacity_in_bytes: std::option::Option<i64>,
        pub(crate) column_groups: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        pub(crate) field_folders: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
        >,
        pub(crate) row_level_permission_data_set:
            std::option::Option<crate::model::RowLevelPermissionDataSet>,
        pub(crate) row_level_permission_tag_configuration:
            std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        pub(crate) column_level_permission_rules:
            std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        pub(crate) data_set_usage_configuration:
            std::option::Option<crate::model::DataSetUsageConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the dataset.</p>
        pub fn data_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the dataset.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_set_id = input;
            self
        }
        /// <p>A display name for the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that this dataset was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this dataset was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The last time that this dataset was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that this dataset was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Adds a key-value pair to `physical_table_map`.
        ///
        /// To override the contents of this collection use [`set_physical_table_map`](Self::set_physical_table_map).
        ///
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn physical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PhysicalTable>,
        ) -> Self {
            let mut hash_map = self.physical_table_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.physical_table_map = Some(hash_map);
            self
        }
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn set_physical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
            >,
        ) -> Self {
            self.physical_table_map = input;
            self
        }
        /// Adds a key-value pair to `logical_table_map`.
        ///
        /// To override the contents of this collection use [`set_logical_table_map`](Self::set_logical_table_map).
        ///
        /// <p>Configures the combination and transformation of the data from the physical
        /// tables.</p>
        pub fn logical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::LogicalTable>,
        ) -> Self {
            let mut hash_map = self.logical_table_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.logical_table_map = Some(hash_map);
            self
        }
        /// <p>Configures the combination and transformation of the data from the physical
        /// tables.</p>
        pub fn set_logical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
            >,
        ) -> Self {
            self.logical_table_map = input;
            self
        }
        /// Appends an item to `output_columns`.
        ///
        /// To override the contents of this collection use [`set_output_columns`](Self::set_output_columns).
        ///
        /// <p>The list of columns after all transforms. These columns are available in templates,
        /// analyses, and dashboards.</p>
        pub fn output_columns(mut self, input: impl Into<crate::model::OutputColumn>) -> Self {
            let mut v = self.output_columns.unwrap_or_default();
            v.push(input.into());
            self.output_columns = Some(v);
            self
        }
        /// <p>The list of columns after all transforms. These columns are available in templates,
        /// analyses, and dashboards.</p>
        pub fn set_output_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputColumn>>,
        ) -> Self {
            self.output_columns = input;
            self
        }
        /// <p>A value that indicates whether you want to import the data into SPICE.</p>
        pub fn import_mode(mut self, input: crate::model::DataSetImportMode) -> Self {
            self.import_mode = Some(input);
            self
        }
        /// <p>A value that indicates whether you want to import the data into SPICE.</p>
        pub fn set_import_mode(
            mut self,
            input: std::option::Option<crate::model::DataSetImportMode>,
        ) -> Self {
            self.import_mode = input;
            self
        }
        /// <p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't
        /// imported into SPICE.</p>
        pub fn consumed_spice_capacity_in_bytes(mut self, input: i64) -> Self {
            self.consumed_spice_capacity_in_bytes = Some(input);
            self
        }
        /// <p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't
        /// imported into SPICE.</p>
        pub fn set_consumed_spice_capacity_in_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.consumed_spice_capacity_in_bytes = input;
            self
        }
        /// Appends an item to `column_groups`.
        ///
        /// To override the contents of this collection use [`set_column_groups`](Self::set_column_groups).
        ///
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features.
        /// Currently, only geospatial hierarchy is supported.</p>
        pub fn column_groups(mut self, input: impl Into<crate::model::ColumnGroup>) -> Self {
            let mut v = self.column_groups.unwrap_or_default();
            v.push(input.into());
            self.column_groups = Some(v);
            self
        }
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features.
        /// Currently, only geospatial hierarchy is supported.</p>
        pub fn set_column_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        ) -> Self {
            self.column_groups = input;
            self
        }
        /// Adds a key-value pair to `field_folders`.
        ///
        /// To override the contents of this collection use [`set_field_folders`](Self::set_field_folders).
        ///
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn field_folders(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::FieldFolder>,
        ) -> Self {
            let mut hash_map = self.field_folders.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.field_folders = Some(hash_map);
            self
        }
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn set_field_folders(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
            >,
        ) -> Self {
            self.field_folders = input;
            self
        }
        /// <p>The row-level security configuration for the dataset.</p>
        pub fn row_level_permission_data_set(
            mut self,
            input: crate::model::RowLevelPermissionDataSet,
        ) -> Self {
            self.row_level_permission_data_set = Some(input);
            self
        }
        /// <p>The row-level security configuration for the dataset.</p>
        pub fn set_row_level_permission_data_set(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionDataSet>,
        ) -> Self {
            self.row_level_permission_data_set = input;
            self
        }
        /// <p>The element you can use to define tags for row-level security.</p>
        pub fn row_level_permission_tag_configuration(
            mut self,
            input: crate::model::RowLevelPermissionTagConfiguration,
        ) -> Self {
            self.row_level_permission_tag_configuration = Some(input);
            self
        }
        /// <p>The element you can use to define tags for row-level security.</p>
        pub fn set_row_level_permission_tag_configuration(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        ) -> Self {
            self.row_level_permission_tag_configuration = input;
            self
        }
        /// Appends an item to `column_level_permission_rules`.
        ///
        /// To override the contents of this collection use [`set_column_level_permission_rules`](Self::set_column_level_permission_rules).
        ///
        /// <p>A set of one or more definitions of a <code>
        /// <a>ColumnLevelPermissionRule</a>
        /// </code>.</p>
        pub fn column_level_permission_rules(
            mut self,
            input: impl Into<crate::model::ColumnLevelPermissionRule>,
        ) -> Self {
            let mut v = self.column_level_permission_rules.unwrap_or_default();
            v.push(input.into());
            self.column_level_permission_rules = Some(v);
            self
        }
        /// <p>A set of one or more definitions of a <code>
        /// <a>ColumnLevelPermissionRule</a>
        /// </code>.</p>
        pub fn set_column_level_permission_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        ) -> Self {
            self.column_level_permission_rules = input;
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn data_set_usage_configuration(
            mut self,
            input: crate::model::DataSetUsageConfiguration,
        ) -> Self {
            self.data_set_usage_configuration = Some(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn set_data_set_usage_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSetUsageConfiguration>,
        ) -> Self {
            self.data_set_usage_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSet`](crate::model::DataSet)
        pub fn build(self) -> crate::model::DataSet {
            crate::model::DataSet {
                arn: self.arn,
                data_set_id: self.data_set_id,
                name: self.name,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                physical_table_map: self.physical_table_map,
                logical_table_map: self.logical_table_map,
                output_columns: self.output_columns,
                import_mode: self.import_mode,
                consumed_spice_capacity_in_bytes: self
                    .consumed_spice_capacity_in_bytes
                    .unwrap_or_default(),
                column_groups: self.column_groups,
                field_folders: self.field_folders,
                row_level_permission_data_set: self.row_level_permission_data_set,
                row_level_permission_tag_configuration: self.row_level_permission_tag_configuration,
                column_level_permission_rules: self.column_level_permission_rules,
                data_set_usage_configuration: self.data_set_usage_configuration,
            }
        }
    }
}
impl DataSet {
    /// Creates a new builder-style object to manufacture [`DataSet`](crate::model::DataSet)
    pub fn builder() -> crate::model::data_set::Builder {
        crate::model::data_set::Builder::default()
    }
}

/// <p>Output column.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputColumn {
    /// <p>A display name for the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description for a column.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Type.</p>
    pub r#type: std::option::Option<crate::model::ColumnDataType>,
}
impl OutputColumn {
    /// <p>A display name for the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description for a column.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ColumnDataType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for OutputColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputColumn");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`OutputColumn`](crate::model::OutputColumn)
pub mod output_column {
    /// A builder for [`OutputColumn`](crate::model::OutputColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ColumnDataType>,
    }
    impl Builder {
        /// <p>A display name for the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description for a column.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for a column.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Type.</p>
        pub fn r#type(mut self, input: crate::model::ColumnDataType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ColumnDataType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputColumn`](crate::model::OutputColumn)
        pub fn build(self) -> crate::model::OutputColumn {
            crate::model::OutputColumn {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
            }
        }
    }
}
impl OutputColumn {
    /// Creates a new builder-style object to manufacture [`OutputColumn`](crate::model::OutputColumn)
    pub fn builder() -> crate::model::output_column::Builder {
        crate::model::output_column::Builder::default()
    }
}

/// <p>Dashboard.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dashboard {
    /// <p>Dashboard ID.</p>
    pub dashboard_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A display name for the dashboard.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Version.</p>
    pub version: std::option::Option<crate::model::DashboardVersion>,
    /// <p>The time that this dataset was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this dataset was published.</p>
    pub last_published_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this dataset was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Dashboard {
    /// <p>Dashboard ID.</p>
    pub fn dashboard_id(&self) -> std::option::Option<&str> {
        self.dashboard_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A display name for the dashboard.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Version.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::DashboardVersion> {
        self.version.as_ref()
    }
    /// <p>The time that this dataset was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The last time that this dataset was published.</p>
    pub fn last_published_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_published_time.as_ref()
    }
    /// <p>The last time that this dataset was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
}
impl std::fmt::Debug for Dashboard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dashboard");
        formatter.field("dashboard_id", &self.dashboard_id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_published_time", &self.last_published_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`Dashboard`](crate::model::Dashboard)
pub mod dashboard {
    /// A builder for [`Dashboard`](crate::model::Dashboard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<crate::model::DashboardVersion>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_published_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Dashboard ID.</p>
        pub fn dashboard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_id = Some(input.into());
            self
        }
        /// <p>Dashboard ID.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dashboard_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A display name for the dashboard.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A display name for the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Version.</p>
        pub fn version(mut self, input: crate::model::DashboardVersion) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>Version.</p>
        pub fn set_version(
            mut self,
            input: std::option::Option<crate::model::DashboardVersion>,
        ) -> Self {
            self.version = input;
            self
        }
        /// <p>The time that this dataset was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this dataset was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The last time that this dataset was published.</p>
        pub fn last_published_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_published_time = Some(input);
            self
        }
        /// <p>The last time that this dataset was published.</p>
        pub fn set_last_published_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_published_time = input;
            self
        }
        /// <p>The last time that this dataset was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that this dataset was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Dashboard`](crate::model::Dashboard)
        pub fn build(self) -> crate::model::Dashboard {
            crate::model::Dashboard {
                dashboard_id: self.dashboard_id,
                arn: self.arn,
                name: self.name,
                version: self.version,
                created_time: self.created_time,
                last_published_time: self.last_published_time,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl Dashboard {
    /// Creates a new builder-style object to manufacture [`Dashboard`](crate::model::Dashboard)
    pub fn builder() -> crate::model::dashboard::Builder {
        crate::model::dashboard::Builder::default()
    }
}

/// <p>Dashboard version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardVersion {
    /// <p>The time that this dashboard version was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Errors associated with this dashboard version.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::DashboardError>>,
    /// <p>Version number for this version of the dashboard.</p>
    pub version_number: std::option::Option<i64>,
    /// <p>The HTTP status of the request.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Source entity ARN.</p>
    pub source_entity_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this
    /// version of the dashboard.</p>
    pub data_set_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the theme associated with a version of the dashboard.</p>
    pub theme_arn: std::option::Option<std::string::String>,
    /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
    pub sheets: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
}
impl DashboardVersion {
    /// <p>The time that this dashboard version was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>Errors associated with this dashboard version.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::DashboardError]> {
        self.errors.as_deref()
    }
    /// <p>Version number for this version of the dashboard.</p>
    pub fn version_number(&self) -> std::option::Option<i64> {
        self.version_number
    }
    /// <p>The HTTP status of the request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Source entity ARN.</p>
    pub fn source_entity_arn(&self) -> std::option::Option<&str> {
        self.source_entity_arn.as_deref()
    }
    /// <p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this
    /// version of the dashboard.</p>
    pub fn data_set_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.data_set_arns.as_deref()
    }
    /// <p>Description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ARN of the theme associated with a version of the dashboard.</p>
    pub fn theme_arn(&self) -> std::option::Option<&str> {
        self.theme_arn.as_deref()
    }
    /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
    pub fn sheets(&self) -> std::option::Option<&[crate::model::Sheet]> {
        self.sheets.as_deref()
    }
}
impl std::fmt::Debug for DashboardVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardVersion");
        formatter.field("created_time", &self.created_time);
        formatter.field("errors", &self.errors);
        formatter.field("version_number", &self.version_number);
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("source_entity_arn", &self.source_entity_arn);
        formatter.field("data_set_arns", &self.data_set_arns);
        formatter.field("description", &self.description);
        formatter.field("theme_arn", &self.theme_arn);
        formatter.field("sheets", &self.sheets);
        formatter.finish()
    }
}
/// See [`DashboardVersion`](crate::model::DashboardVersion)
pub mod dashboard_version {
    /// A builder for [`DashboardVersion`](crate::model::DashboardVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::DashboardError>>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) source_entity_arn: std::option::Option<std::string::String>,
        pub(crate) data_set_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
        pub(crate) sheets: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
    }
    impl Builder {
        /// <p>The time that this dashboard version was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that this dashboard version was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Errors associated with this dashboard version.</p>
        pub fn errors(mut self, input: impl Into<crate::model::DashboardError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Errors associated with this dashboard version.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// <p>Version number for this version of the dashboard.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>Version number for this version of the dashboard.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The HTTP status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Source entity ARN.</p>
        pub fn source_entity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_entity_arn = Some(input.into());
            self
        }
        /// <p>Source entity ARN.</p>
        pub fn set_source_entity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_entity_arn = input;
            self
        }
        /// Appends an item to `data_set_arns`.
        ///
        /// To override the contents of this collection use [`set_data_set_arns`](Self::set_data_set_arns).
        ///
        /// <p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this
        /// version of the dashboard.</p>
        pub fn data_set_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.data_set_arns.unwrap_or_default();
            v.push(input.into());
            self.data_set_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with this
        /// version of the dashboard.</p>
        pub fn set_data_set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.data_set_arns = input;
            self
        }
        /// <p>Description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the theme associated with a version of the dashboard.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the theme associated with a version of the dashboard.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// Appends an item to `sheets`.
        ///
        /// To override the contents of this collection use [`set_sheets`](Self::set_sheets).
        ///
        /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        pub fn sheets(mut self, input: impl Into<crate::model::Sheet>) -> Self {
            let mut v = self.sheets.unwrap_or_default();
            v.push(input.into());
            self.sheets = Some(v);
            self
        }
        /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        pub fn set_sheets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
        ) -> Self {
            self.sheets = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardVersion`](crate::model::DashboardVersion)
        pub fn build(self) -> crate::model::DashboardVersion {
            crate::model::DashboardVersion {
                created_time: self.created_time,
                errors: self.errors,
                version_number: self.version_number,
                status: self.status,
                arn: self.arn,
                source_entity_arn: self.source_entity_arn,
                data_set_arns: self.data_set_arns,
                description: self.description,
                theme_arn: self.theme_arn,
                sheets: self.sheets,
            }
        }
    }
}
impl DashboardVersion {
    /// Creates a new builder-style object to manufacture [`DashboardVersion`](crate::model::DashboardVersion)
    pub fn builder() -> crate::model::dashboard_version::Builder {
        crate::model::dashboard_version::Builder::default()
    }
}

/// <p>Dashboard error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardError {
    /// <p>Type.</p>
    pub r#type: std::option::Option<crate::model::DashboardErrorType>,
    /// <p>Message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DashboardError {
    /// <p>Type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DashboardErrorType> {
        self.r#type.as_ref()
    }
    /// <p>Message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardError");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DashboardError`](crate::model::DashboardError)
pub mod dashboard_error {
    /// A builder for [`DashboardError`](crate::model::DashboardError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DashboardErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Type.</p>
        pub fn r#type(mut self, input: crate::model::DashboardErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DashboardErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardError`](crate::model::DashboardError)
        pub fn build(self) -> crate::model::DashboardError {
            crate::model::DashboardError {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl DashboardError {
    /// Creates a new builder-style object to manufacture [`DashboardError`](crate::model::DashboardError)
    pub fn builder() -> crate::model::dashboard_error::Builder {
        crate::model::dashboard_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DashboardErrorType {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ColumnGeographicRoleMismatch,
    #[allow(missing_docs)] // documentation missing in model
    ColumnReplacementMissing,
    #[allow(missing_docs)] // documentation missing in model
    ColumnTypeMismatch,
    #[allow(missing_docs)] // documentation missing in model
    DataSetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    ParameterNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ParameterTypeInvalid,
    #[allow(missing_docs)] // documentation missing in model
    ParameterValueIncompatible,
    #[allow(missing_docs)] // documentation missing in model
    SourceNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DashboardErrorType {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => DashboardErrorType::AccessDenied,
            "COLUMN_GEOGRAPHIC_ROLE_MISMATCH" => DashboardErrorType::ColumnGeographicRoleMismatch,
            "COLUMN_REPLACEMENT_MISSING" => DashboardErrorType::ColumnReplacementMissing,
            "COLUMN_TYPE_MISMATCH" => DashboardErrorType::ColumnTypeMismatch,
            "DATA_SET_NOT_FOUND" => DashboardErrorType::DataSetNotFound,
            "INTERNAL_FAILURE" => DashboardErrorType::InternalFailure,
            "PARAMETER_NOT_FOUND" => DashboardErrorType::ParameterNotFound,
            "PARAMETER_TYPE_INVALID" => DashboardErrorType::ParameterTypeInvalid,
            "PARAMETER_VALUE_INCOMPATIBLE" => DashboardErrorType::ParameterValueIncompatible,
            "SOURCE_NOT_FOUND" => DashboardErrorType::SourceNotFound,
            other => DashboardErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DashboardErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DashboardErrorType::from(s))
    }
}
impl DashboardErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DashboardErrorType::AccessDenied => "ACCESS_DENIED",
            DashboardErrorType::ColumnGeographicRoleMismatch => "COLUMN_GEOGRAPHIC_ROLE_MISMATCH",
            DashboardErrorType::ColumnReplacementMissing => "COLUMN_REPLACEMENT_MISSING",
            DashboardErrorType::ColumnTypeMismatch => "COLUMN_TYPE_MISMATCH",
            DashboardErrorType::DataSetNotFound => "DATA_SET_NOT_FOUND",
            DashboardErrorType::InternalFailure => "INTERNAL_FAILURE",
            DashboardErrorType::ParameterNotFound => "PARAMETER_NOT_FOUND",
            DashboardErrorType::ParameterTypeInvalid => "PARAMETER_TYPE_INVALID",
            DashboardErrorType::ParameterValueIncompatible => "PARAMETER_VALUE_INCOMPATIBLE",
            DashboardErrorType::SourceNotFound => "SOURCE_NOT_FOUND",
            DashboardErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "COLUMN_GEOGRAPHIC_ROLE_MISMATCH",
            "COLUMN_REPLACEMENT_MISSING",
            "COLUMN_TYPE_MISMATCH",
            "DATA_SET_NOT_FOUND",
            "INTERNAL_FAILURE",
            "PARAMETER_NOT_FOUND",
            "PARAMETER_TYPE_INVALID",
            "PARAMETER_VALUE_INCOMPATIBLE",
            "SOURCE_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for DashboardErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata structure for an analysis in Amazon QuickSight</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Analysis {
    /// <p>The ID of the analysis.</p>
    pub analysis_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the analysis.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The descriptive name of the analysis.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Status associated with the analysis.</p>
    pub status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>Errors associated with the analysis.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::AnalysisError>>,
    /// <p>The ARNs of the datasets of the analysis.</p>
    pub data_set_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN of the theme of the analysis.</p>
    pub theme_arn: std::option::Option<std::string::String>,
    /// <p>The time that the analysis was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the analysis was last updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
    pub sheets: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
}
impl Analysis {
    /// <p>The ID of the analysis.</p>
    pub fn analysis_id(&self) -> std::option::Option<&str> {
        self.analysis_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the analysis.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The descriptive name of the analysis.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Status associated with the analysis.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.status.as_ref()
    }
    /// <p>Errors associated with the analysis.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::AnalysisError]> {
        self.errors.as_deref()
    }
    /// <p>The ARNs of the datasets of the analysis.</p>
    pub fn data_set_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.data_set_arns.as_deref()
    }
    /// <p>The ARN of the theme of the analysis.</p>
    pub fn theme_arn(&self) -> std::option::Option<&str> {
        self.theme_arn.as_deref()
    }
    /// <p>The time that the analysis was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The time that the analysis was last updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
    pub fn sheets(&self) -> std::option::Option<&[crate::model::Sheet]> {
        self.sheets.as_deref()
    }
}
impl std::fmt::Debug for Analysis {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Analysis");
        formatter.field("analysis_id", &self.analysis_id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("errors", &self.errors);
        formatter.field("data_set_arns", &self.data_set_arns);
        formatter.field("theme_arn", &self.theme_arn);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("sheets", &self.sheets);
        formatter.finish()
    }
}
/// See [`Analysis`](crate::model::Analysis)
pub mod analysis {
    /// A builder for [`Analysis`](crate::model::Analysis)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analysis_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::AnalysisError>>,
        pub(crate) data_set_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) theme_arn: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) sheets: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
    }
    impl Builder {
        /// <p>The ID of the analysis.</p>
        pub fn analysis_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.analysis_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the analysis.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the analysis.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The descriptive name of the analysis.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The descriptive name of the analysis.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Status associated with the analysis.</p>
        pub fn status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status associated with the analysis.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Errors associated with the analysis.</p>
        pub fn errors(mut self, input: impl Into<crate::model::AnalysisError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Errors associated with the analysis.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Appends an item to `data_set_arns`.
        ///
        /// To override the contents of this collection use [`set_data_set_arns`](Self::set_data_set_arns).
        ///
        /// <p>The ARNs of the datasets of the analysis.</p>
        pub fn data_set_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.data_set_arns.unwrap_or_default();
            v.push(input.into());
            self.data_set_arns = Some(v);
            self
        }
        /// <p>The ARNs of the datasets of the analysis.</p>
        pub fn set_data_set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.data_set_arns = input;
            self
        }
        /// <p>The ARN of the theme of the analysis.</p>
        pub fn theme_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.theme_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the theme of the analysis.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.theme_arn = input;
            self
        }
        /// <p>The time that the analysis was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time that the analysis was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The time that the analysis was last updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The time that the analysis was last updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Appends an item to `sheets`.
        ///
        /// To override the contents of this collection use [`set_sheets`](Self::set_sheets).
        ///
        /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        pub fn sheets(mut self, input: impl Into<crate::model::Sheet>) -> Self {
            let mut v = self.sheets.unwrap_or_default();
            v.push(input.into());
            self.sheets = Some(v);
            self
        }
        /// <p>A list of the associated sheets with the unique identifier and name of each sheet.</p>
        pub fn set_sheets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Sheet>>,
        ) -> Self {
            self.sheets = input;
            self
        }
        /// Consumes the builder and constructs a [`Analysis`](crate::model::Analysis)
        pub fn build(self) -> crate::model::Analysis {
            crate::model::Analysis {
                analysis_id: self.analysis_id,
                arn: self.arn,
                name: self.name,
                status: self.status,
                errors: self.errors,
                data_set_arns: self.data_set_arns,
                theme_arn: self.theme_arn,
                created_time: self.created_time,
                last_updated_time: self.last_updated_time,
                sheets: self.sheets,
            }
        }
    }
}
impl Analysis {
    /// Creates a new builder-style object to manufacture [`Analysis`](crate::model::Analysis)
    pub fn builder() -> crate::model::analysis::Builder {
        crate::model::analysis::Builder::default()
    }
}

/// <p>Analysis error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisError {
    /// <p>The type of the analysis error.</p>
    pub r#type: std::option::Option<crate::model::AnalysisErrorType>,
    /// <p>The message associated with the analysis error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl AnalysisError {
    /// <p>The type of the analysis error.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AnalysisErrorType> {
        self.r#type.as_ref()
    }
    /// <p>The message associated with the analysis error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for AnalysisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisError");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`AnalysisError`](crate::model::AnalysisError)
pub mod analysis_error {
    /// A builder for [`AnalysisError`](crate::model::AnalysisError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::AnalysisErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the analysis error.</p>
        pub fn r#type(mut self, input: crate::model::AnalysisErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the analysis error.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AnalysisErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The message associated with the analysis error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message associated with the analysis error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisError`](crate::model::AnalysisError)
        pub fn build(self) -> crate::model::AnalysisError {
            crate::model::AnalysisError {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl AnalysisError {
    /// Creates a new builder-style object to manufacture [`AnalysisError`](crate::model::AnalysisError)
    pub fn builder() -> crate::model::analysis_error::Builder {
        crate::model::analysis_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalysisErrorType {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ColumnGeographicRoleMismatch,
    #[allow(missing_docs)] // documentation missing in model
    ColumnReplacementMissing,
    #[allow(missing_docs)] // documentation missing in model
    ColumnTypeMismatch,
    #[allow(missing_docs)] // documentation missing in model
    DataSetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    ParameterNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ParameterTypeInvalid,
    #[allow(missing_docs)] // documentation missing in model
    ParameterValueIncompatible,
    #[allow(missing_docs)] // documentation missing in model
    SourceNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalysisErrorType {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => AnalysisErrorType::AccessDenied,
            "COLUMN_GEOGRAPHIC_ROLE_MISMATCH" => AnalysisErrorType::ColumnGeographicRoleMismatch,
            "COLUMN_REPLACEMENT_MISSING" => AnalysisErrorType::ColumnReplacementMissing,
            "COLUMN_TYPE_MISMATCH" => AnalysisErrorType::ColumnTypeMismatch,
            "DATA_SET_NOT_FOUND" => AnalysisErrorType::DataSetNotFound,
            "INTERNAL_FAILURE" => AnalysisErrorType::InternalFailure,
            "PARAMETER_NOT_FOUND" => AnalysisErrorType::ParameterNotFound,
            "PARAMETER_TYPE_INVALID" => AnalysisErrorType::ParameterTypeInvalid,
            "PARAMETER_VALUE_INCOMPATIBLE" => AnalysisErrorType::ParameterValueIncompatible,
            "SOURCE_NOT_FOUND" => AnalysisErrorType::SourceNotFound,
            other => AnalysisErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalysisErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalysisErrorType::from(s))
    }
}
impl AnalysisErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalysisErrorType::AccessDenied => "ACCESS_DENIED",
            AnalysisErrorType::ColumnGeographicRoleMismatch => "COLUMN_GEOGRAPHIC_ROLE_MISMATCH",
            AnalysisErrorType::ColumnReplacementMissing => "COLUMN_REPLACEMENT_MISSING",
            AnalysisErrorType::ColumnTypeMismatch => "COLUMN_TYPE_MISMATCH",
            AnalysisErrorType::DataSetNotFound => "DATA_SET_NOT_FOUND",
            AnalysisErrorType::InternalFailure => "INTERNAL_FAILURE",
            AnalysisErrorType::ParameterNotFound => "PARAMETER_NOT_FOUND",
            AnalysisErrorType::ParameterTypeInvalid => "PARAMETER_TYPE_INVALID",
            AnalysisErrorType::ParameterValueIncompatible => "PARAMETER_VALUE_INCOMPATIBLE",
            AnalysisErrorType::SourceNotFound => "SOURCE_NOT_FOUND",
            AnalysisErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "COLUMN_GEOGRAPHIC_ROLE_MISMATCH",
            "COLUMN_REPLACEMENT_MISSING",
            "COLUMN_TYPE_MISMATCH",
            "DATA_SET_NOT_FOUND",
            "INTERNAL_FAILURE",
            "PARAMETER_NOT_FOUND",
            "PARAMETER_TYPE_INVALID",
            "PARAMETER_VALUE_INCOMPATIBLE",
            "SOURCE_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for AnalysisErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Amazon QuickSight settings associated with your Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountSettings {
    /// <p>The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account.
    /// You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and
    /// it appears only when users sign in.</p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p>The edition of Amazon QuickSight that you're currently subscribed to:
    /// Enterprise edition or Standard edition.</p>
    pub edition: std::option::Option<crate::model::Edition>,
    /// <p>The default Amazon QuickSight namespace for your Amazon Web Services account. </p>
    pub default_namespace: std::option::Option<std::string::String>,
    /// <p>The main notification email for your Amazon QuickSight subscription.</p>
    pub notification_email: std::option::Option<std::string::String>,
}
impl AccountSettings {
    /// <p>The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account.
    /// You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and
    /// it appears only when users sign in.</p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p>The edition of Amazon QuickSight that you're currently subscribed to:
    /// Enterprise edition or Standard edition.</p>
    pub fn edition(&self) -> std::option::Option<&crate::model::Edition> {
        self.edition.as_ref()
    }
    /// <p>The default Amazon QuickSight namespace for your Amazon Web Services account. </p>
    pub fn default_namespace(&self) -> std::option::Option<&str> {
        self.default_namespace.as_deref()
    }
    /// <p>The main notification email for your Amazon QuickSight subscription.</p>
    pub fn notification_email(&self) -> std::option::Option<&str> {
        self.notification_email.as_deref()
    }
}
impl std::fmt::Debug for AccountSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountSettings");
        formatter.field("account_name", &self.account_name);
        formatter.field("edition", &self.edition);
        formatter.field("default_namespace", &self.default_namespace);
        formatter.field("notification_email", &self.notification_email);
        formatter.finish()
    }
}
/// See [`AccountSettings`](crate::model::AccountSettings)
pub mod account_settings {
    /// A builder for [`AccountSettings`](crate::model::AccountSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) edition: std::option::Option<crate::model::Edition>,
        pub(crate) default_namespace: std::option::Option<std::string::String>,
        pub(crate) notification_email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account.
        /// You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and
        /// it appears only when users sign in.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p>The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account.
        /// You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and
        /// it appears only when users sign in.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p>The edition of Amazon QuickSight that you're currently subscribed to:
        /// Enterprise edition or Standard edition.</p>
        pub fn edition(mut self, input: crate::model::Edition) -> Self {
            self.edition = Some(input);
            self
        }
        /// <p>The edition of Amazon QuickSight that you're currently subscribed to:
        /// Enterprise edition or Standard edition.</p>
        pub fn set_edition(mut self, input: std::option::Option<crate::model::Edition>) -> Self {
            self.edition = input;
            self
        }
        /// <p>The default Amazon QuickSight namespace for your Amazon Web Services account. </p>
        pub fn default_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_namespace = Some(input.into());
            self
        }
        /// <p>The default Amazon QuickSight namespace for your Amazon Web Services account. </p>
        pub fn set_default_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_namespace = input;
            self
        }
        /// <p>The main notification email for your Amazon QuickSight subscription.</p>
        pub fn notification_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_email = Some(input.into());
            self
        }
        /// <p>The main notification email for your Amazon QuickSight subscription.</p>
        pub fn set_notification_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_email = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountSettings`](crate::model::AccountSettings)
        pub fn build(self) -> crate::model::AccountSettings {
            crate::model::AccountSettings {
                account_name: self.account_name,
                edition: self.edition,
                default_namespace: self.default_namespace,
                notification_email: self.notification_email,
            }
        }
    }
}
impl AccountSettings {
    /// Creates a new builder-style object to manufacture [`AccountSettings`](crate::model::AccountSettings)
    pub fn builder() -> crate::model::account_settings::Builder {
        crate::model::account_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Edition {
    #[allow(missing_docs)] // documentation missing in model
    Enterprise,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Edition {
    fn from(s: &str) -> Self {
        match s {
            "ENTERPRISE" => Edition::Enterprise,
            "STANDARD" => Edition::Standard,
            other => Edition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Edition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Edition::from(s))
    }
}
impl Edition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Edition::Enterprise => "ENTERPRISE",
            Edition::Standard => "STANDARD",
            Edition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENTERPRISE", "STANDARD"]
    }
}
impl AsRef<str> for Edition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MemberType {
    #[allow(missing_docs)] // documentation missing in model
    Analysis,
    #[allow(missing_docs)] // documentation missing in model
    Dashboard,
    #[allow(missing_docs)] // documentation missing in model
    Dataset,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MemberType {
    fn from(s: &str) -> Self {
        match s {
            "ANALYSIS" => MemberType::Analysis,
            "DASHBOARD" => MemberType::Dashboard,
            "DATASET" => MemberType::Dataset,
            other => MemberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MemberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MemberType::from(s))
    }
}
impl MemberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MemberType::Analysis => "ANALYSIS",
            MemberType::Dashboard => "DASHBOARD",
            MemberType::Dataset => "DATASET",
            MemberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ANALYSIS", "DASHBOARD", "DATASET"]
    }
}
impl AsRef<str> for MemberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// This defines the type of ingestion user wants to trigger. This is part of create ingestion request.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IngestionType {
    #[allow(missing_docs)] // documentation missing in model
    FullRefresh,
    #[allow(missing_docs)] // documentation missing in model
    IncrementalRefresh,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IngestionType {
    fn from(s: &str) -> Self {
        match s {
            "FULL_REFRESH" => IngestionType::FullRefresh,
            "INCREMENTAL_REFRESH" => IngestionType::IncrementalRefresh,
            other => IngestionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IngestionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IngestionType::from(s))
    }
}
impl IngestionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IngestionType::FullRefresh => "FULL_REFRESH",
            IngestionType::IncrementalRefresh => "INCREMENTAL_REFRESH",
            IngestionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_REFRESH", "INCREMENTAL_REFRESH"]
    }
}
impl AsRef<str> for IngestionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An asset in a folder, such as a dashboard, analysis, or dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FolderMember {
    /// <p>The ID of the asset.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The type of the asset.</p>
    pub member_type: std::option::Option<crate::model::MemberType>,
}
impl FolderMember {
    /// <p>The ID of the asset.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The type of the asset.</p>
    pub fn member_type(&self) -> std::option::Option<&crate::model::MemberType> {
        self.member_type.as_ref()
    }
}
impl std::fmt::Debug for FolderMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FolderMember");
        formatter.field("member_id", &self.member_id);
        formatter.field("member_type", &self.member_type);
        formatter.finish()
    }
}
/// See [`FolderMember`](crate::model::FolderMember)
pub mod folder_member {
    /// A builder for [`FolderMember`](crate::model::FolderMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) member_type: std::option::Option<crate::model::MemberType>,
    }
    impl Builder {
        /// <p>The ID of the asset.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The type of the asset.</p>
        pub fn member_type(mut self, input: crate::model::MemberType) -> Self {
            self.member_type = Some(input);
            self
        }
        /// <p>The type of the asset.</p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.member_type = input;
            self
        }
        /// Consumes the builder and constructs a [`FolderMember`](crate::model::FolderMember)
        pub fn build(self) -> crate::model::FolderMember {
            crate::model::FolderMember {
                member_id: self.member_id,
                member_type: self.member_type,
            }
        }
    }
}
impl FolderMember {
    /// Creates a new builder-style object to manufacture [`FolderMember`](crate::model::FolderMember)
    pub fn builder() -> crate::model::folder_member::Builder {
        crate::model::folder_member::Builder::default()
    }
}
