// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `QuickSight_20180401`.
///
/// This client allows ergonomic access to a `QuickSight_20180401`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelIngestion` operation.
    ///
    /// See [`CancelIngestion`](crate::client::fluent_builders::CancelIngestion) for more information about the
    /// operation and its arguments.
    pub fn cancel_ingestion(&self) -> fluent_builders::CancelIngestion<C, M, R> {
        fluent_builders::CancelIngestion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccountCustomization` operation.
    ///
    /// See [`CreateAccountCustomization`](crate::client::fluent_builders::CreateAccountCustomization) for more information about the
    /// operation and its arguments.
    pub fn create_account_customization(
        &self,
    ) -> fluent_builders::CreateAccountCustomization<C, M, R> {
        fluent_builders::CreateAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAnalysis` operation.
    ///
    /// See [`CreateAnalysis`](crate::client::fluent_builders::CreateAnalysis) for more information about the
    /// operation and its arguments.
    pub fn create_analysis(&self) -> fluent_builders::CreateAnalysis<C, M, R> {
        fluent_builders::CreateAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDashboard` operation.
    ///
    /// See [`CreateDashboard`](crate::client::fluent_builders::CreateDashboard) for more information about the
    /// operation and its arguments.
    pub fn create_dashboard(&self) -> fluent_builders::CreateDashboard<C, M, R> {
        fluent_builders::CreateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSet` operation.
    ///
    /// See [`CreateDataSet`](crate::client::fluent_builders::CreateDataSet) for more information about the
    /// operation and its arguments.
    pub fn create_data_set(&self) -> fluent_builders::CreateDataSet<C, M, R> {
        fluent_builders::CreateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSource` operation.
    ///
    /// See [`CreateDataSource`](crate::client::fluent_builders::CreateDataSource) for more information about the
    /// operation and its arguments.
    pub fn create_data_source(&self) -> fluent_builders::CreateDataSource<C, M, R> {
        fluent_builders::CreateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFolder` operation.
    ///
    /// See [`CreateFolder`](crate::client::fluent_builders::CreateFolder) for more information about the
    /// operation and its arguments.
    pub fn create_folder(&self) -> fluent_builders::CreateFolder<C, M, R> {
        fluent_builders::CreateFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFolderMembership` operation.
    ///
    /// See [`CreateFolderMembership`](crate::client::fluent_builders::CreateFolderMembership) for more information about the
    /// operation and its arguments.
    pub fn create_folder_membership(&self) -> fluent_builders::CreateFolderMembership<C, M, R> {
        fluent_builders::CreateFolderMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroup` operation.
    ///
    /// See [`CreateGroup`](crate::client::fluent_builders::CreateGroup) for more information about the
    /// operation and its arguments.
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroupMembership` operation.
    ///
    /// See [`CreateGroupMembership`](crate::client::fluent_builders::CreateGroupMembership) for more information about the
    /// operation and its arguments.
    pub fn create_group_membership(&self) -> fluent_builders::CreateGroupMembership<C, M, R> {
        fluent_builders::CreateGroupMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIAMPolicyAssignment` operation.
    ///
    /// See [`CreateIAMPolicyAssignment`](crate::client::fluent_builders::CreateIAMPolicyAssignment) for more information about the
    /// operation and its arguments.
    pub fn create_iam_policy_assignment(
        &self,
    ) -> fluent_builders::CreateIAMPolicyAssignment<C, M, R> {
        fluent_builders::CreateIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIngestion` operation.
    ///
    /// See [`CreateIngestion`](crate::client::fluent_builders::CreateIngestion) for more information about the
    /// operation and its arguments.
    pub fn create_ingestion(&self) -> fluent_builders::CreateIngestion<C, M, R> {
        fluent_builders::CreateIngestion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNamespace` operation.
    ///
    /// See [`CreateNamespace`](crate::client::fluent_builders::CreateNamespace) for more information about the
    /// operation and its arguments.
    pub fn create_namespace(&self) -> fluent_builders::CreateNamespace<C, M, R> {
        fluent_builders::CreateNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTemplate` operation.
    ///
    /// See [`CreateTemplate`](crate::client::fluent_builders::CreateTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_template(&self) -> fluent_builders::CreateTemplate<C, M, R> {
        fluent_builders::CreateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTemplateAlias` operation.
    ///
    /// See [`CreateTemplateAlias`](crate::client::fluent_builders::CreateTemplateAlias) for more information about the
    /// operation and its arguments.
    pub fn create_template_alias(&self) -> fluent_builders::CreateTemplateAlias<C, M, R> {
        fluent_builders::CreateTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTheme` operation.
    ///
    /// See [`CreateTheme`](crate::client::fluent_builders::CreateTheme) for more information about the
    /// operation and its arguments.
    pub fn create_theme(&self) -> fluent_builders::CreateTheme<C, M, R> {
        fluent_builders::CreateTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateThemeAlias` operation.
    ///
    /// See [`CreateThemeAlias`](crate::client::fluent_builders::CreateThemeAlias) for more information about the
    /// operation and its arguments.
    pub fn create_theme_alias(&self) -> fluent_builders::CreateThemeAlias<C, M, R> {
        fluent_builders::CreateThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccountCustomization` operation.
    ///
    /// See [`DeleteAccountCustomization`](crate::client::fluent_builders::DeleteAccountCustomization) for more information about the
    /// operation and its arguments.
    pub fn delete_account_customization(
        &self,
    ) -> fluent_builders::DeleteAccountCustomization<C, M, R> {
        fluent_builders::DeleteAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAnalysis` operation.
    ///
    /// See [`DeleteAnalysis`](crate::client::fluent_builders::DeleteAnalysis) for more information about the
    /// operation and its arguments.
    pub fn delete_analysis(&self) -> fluent_builders::DeleteAnalysis<C, M, R> {
        fluent_builders::DeleteAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDashboard` operation.
    ///
    /// See [`DeleteDashboard`](crate::client::fluent_builders::DeleteDashboard) for more information about the
    /// operation and its arguments.
    pub fn delete_dashboard(&self) -> fluent_builders::DeleteDashboard<C, M, R> {
        fluent_builders::DeleteDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataSet` operation.
    ///
    /// See [`DeleteDataSet`](crate::client::fluent_builders::DeleteDataSet) for more information about the
    /// operation and its arguments.
    pub fn delete_data_set(&self) -> fluent_builders::DeleteDataSet<C, M, R> {
        fluent_builders::DeleteDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataSource` operation.
    ///
    /// See [`DeleteDataSource`](crate::client::fluent_builders::DeleteDataSource) for more information about the
    /// operation and its arguments.
    pub fn delete_data_source(&self) -> fluent_builders::DeleteDataSource<C, M, R> {
        fluent_builders::DeleteDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFolder` operation.
    ///
    /// See [`DeleteFolder`](crate::client::fluent_builders::DeleteFolder) for more information about the
    /// operation and its arguments.
    pub fn delete_folder(&self) -> fluent_builders::DeleteFolder<C, M, R> {
        fluent_builders::DeleteFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFolderMembership` operation.
    ///
    /// See [`DeleteFolderMembership`](crate::client::fluent_builders::DeleteFolderMembership) for more information about the
    /// operation and its arguments.
    pub fn delete_folder_membership(&self) -> fluent_builders::DeleteFolderMembership<C, M, R> {
        fluent_builders::DeleteFolderMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroup` operation.
    ///
    /// See [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroupMembership` operation.
    ///
    /// See [`DeleteGroupMembership`](crate::client::fluent_builders::DeleteGroupMembership) for more information about the
    /// operation and its arguments.
    pub fn delete_group_membership(&self) -> fluent_builders::DeleteGroupMembership<C, M, R> {
        fluent_builders::DeleteGroupMembership::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIAMPolicyAssignment` operation.
    ///
    /// See [`DeleteIAMPolicyAssignment`](crate::client::fluent_builders::DeleteIAMPolicyAssignment) for more information about the
    /// operation and its arguments.
    pub fn delete_iam_policy_assignment(
        &self,
    ) -> fluent_builders::DeleteIAMPolicyAssignment<C, M, R> {
        fluent_builders::DeleteIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNamespace` operation.
    ///
    /// See [`DeleteNamespace`](crate::client::fluent_builders::DeleteNamespace) for more information about the
    /// operation and its arguments.
    pub fn delete_namespace(&self) -> fluent_builders::DeleteNamespace<C, M, R> {
        fluent_builders::DeleteNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTemplate` operation.
    ///
    /// See [`DeleteTemplate`](crate::client::fluent_builders::DeleteTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_template(&self) -> fluent_builders::DeleteTemplate<C, M, R> {
        fluent_builders::DeleteTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTemplateAlias` operation.
    ///
    /// See [`DeleteTemplateAlias`](crate::client::fluent_builders::DeleteTemplateAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_template_alias(&self) -> fluent_builders::DeleteTemplateAlias<C, M, R> {
        fluent_builders::DeleteTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTheme` operation.
    ///
    /// See [`DeleteTheme`](crate::client::fluent_builders::DeleteTheme) for more information about the
    /// operation and its arguments.
    pub fn delete_theme(&self) -> fluent_builders::DeleteTheme<C, M, R> {
        fluent_builders::DeleteTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteThemeAlias` operation.
    ///
    /// See [`DeleteThemeAlias`](crate::client::fluent_builders::DeleteThemeAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_theme_alias(&self) -> fluent_builders::DeleteThemeAlias<C, M, R> {
        fluent_builders::DeleteThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserByPrincipalId` operation.
    ///
    /// See [`DeleteUserByPrincipalId`](crate::client::fluent_builders::DeleteUserByPrincipalId) for more information about the
    /// operation and its arguments.
    pub fn delete_user_by_principal_id(&self) -> fluent_builders::DeleteUserByPrincipalId<C, M, R> {
        fluent_builders::DeleteUserByPrincipalId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountCustomization` operation.
    ///
    /// See [`DescribeAccountCustomization`](crate::client::fluent_builders::DescribeAccountCustomization) for more information about the
    /// operation and its arguments.
    pub fn describe_account_customization(
        &self,
    ) -> fluent_builders::DescribeAccountCustomization<C, M, R> {
        fluent_builders::DescribeAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountSettings` operation.
    ///
    /// See [`DescribeAccountSettings`](crate::client::fluent_builders::DescribeAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_account_settings(&self) -> fluent_builders::DescribeAccountSettings<C, M, R> {
        fluent_builders::DescribeAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAnalysis` operation.
    ///
    /// See [`DescribeAnalysis`](crate::client::fluent_builders::DescribeAnalysis) for more information about the
    /// operation and its arguments.
    pub fn describe_analysis(&self) -> fluent_builders::DescribeAnalysis<C, M, R> {
        fluent_builders::DescribeAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAnalysisPermissions` operation.
    ///
    /// See [`DescribeAnalysisPermissions`](crate::client::fluent_builders::DescribeAnalysisPermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_analysis_permissions(
        &self,
    ) -> fluent_builders::DescribeAnalysisPermissions<C, M, R> {
        fluent_builders::DescribeAnalysisPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDashboard` operation.
    ///
    /// See [`DescribeDashboard`](crate::client::fluent_builders::DescribeDashboard) for more information about the
    /// operation and its arguments.
    pub fn describe_dashboard(&self) -> fluent_builders::DescribeDashboard<C, M, R> {
        fluent_builders::DescribeDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDashboardPermissions` operation.
    ///
    /// See [`DescribeDashboardPermissions`](crate::client::fluent_builders::DescribeDashboardPermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_dashboard_permissions(
        &self,
    ) -> fluent_builders::DescribeDashboardPermissions<C, M, R> {
        fluent_builders::DescribeDashboardPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSet` operation.
    ///
    /// See [`DescribeDataSet`](crate::client::fluent_builders::DescribeDataSet) for more information about the
    /// operation and its arguments.
    pub fn describe_data_set(&self) -> fluent_builders::DescribeDataSet<C, M, R> {
        fluent_builders::DescribeDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSetPermissions` operation.
    ///
    /// See [`DescribeDataSetPermissions`](crate::client::fluent_builders::DescribeDataSetPermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_data_set_permissions(
        &self,
    ) -> fluent_builders::DescribeDataSetPermissions<C, M, R> {
        fluent_builders::DescribeDataSetPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSource` operation.
    ///
    /// See [`DescribeDataSource`](crate::client::fluent_builders::DescribeDataSource) for more information about the
    /// operation and its arguments.
    pub fn describe_data_source(&self) -> fluent_builders::DescribeDataSource<C, M, R> {
        fluent_builders::DescribeDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSourcePermissions` operation.
    ///
    /// See [`DescribeDataSourcePermissions`](crate::client::fluent_builders::DescribeDataSourcePermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_data_source_permissions(
        &self,
    ) -> fluent_builders::DescribeDataSourcePermissions<C, M, R> {
        fluent_builders::DescribeDataSourcePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFolder` operation.
    ///
    /// See [`DescribeFolder`](crate::client::fluent_builders::DescribeFolder) for more information about the
    /// operation and its arguments.
    pub fn describe_folder(&self) -> fluent_builders::DescribeFolder<C, M, R> {
        fluent_builders::DescribeFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFolderPermissions` operation.
    ///
    /// See [`DescribeFolderPermissions`](crate::client::fluent_builders::DescribeFolderPermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_folder_permissions(
        &self,
    ) -> fluent_builders::DescribeFolderPermissions<C, M, R> {
        fluent_builders::DescribeFolderPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFolderResolvedPermissions` operation.
    ///
    /// See [`DescribeFolderResolvedPermissions`](crate::client::fluent_builders::DescribeFolderResolvedPermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_folder_resolved_permissions(
        &self,
    ) -> fluent_builders::DescribeFolderResolvedPermissions<C, M, R> {
        fluent_builders::DescribeFolderResolvedPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGroup` operation.
    ///
    /// See [`DescribeGroup`](crate::client::fluent_builders::DescribeGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_group(&self) -> fluent_builders::DescribeGroup<C, M, R> {
        fluent_builders::DescribeGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIAMPolicyAssignment` operation.
    ///
    /// See [`DescribeIAMPolicyAssignment`](crate::client::fluent_builders::DescribeIAMPolicyAssignment) for more information about the
    /// operation and its arguments.
    pub fn describe_iam_policy_assignment(
        &self,
    ) -> fluent_builders::DescribeIAMPolicyAssignment<C, M, R> {
        fluent_builders::DescribeIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIngestion` operation.
    ///
    /// See [`DescribeIngestion`](crate::client::fluent_builders::DescribeIngestion) for more information about the
    /// operation and its arguments.
    pub fn describe_ingestion(&self) -> fluent_builders::DescribeIngestion<C, M, R> {
        fluent_builders::DescribeIngestion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIpRestriction` operation.
    ///
    /// See [`DescribeIpRestriction`](crate::client::fluent_builders::DescribeIpRestriction) for more information about the
    /// operation and its arguments.
    pub fn describe_ip_restriction(&self) -> fluent_builders::DescribeIpRestriction<C, M, R> {
        fluent_builders::DescribeIpRestriction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNamespace` operation.
    ///
    /// See [`DescribeNamespace`](crate::client::fluent_builders::DescribeNamespace) for more information about the
    /// operation and its arguments.
    pub fn describe_namespace(&self) -> fluent_builders::DescribeNamespace<C, M, R> {
        fluent_builders::DescribeNamespace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTemplate` operation.
    ///
    /// See [`DescribeTemplate`](crate::client::fluent_builders::DescribeTemplate) for more information about the
    /// operation and its arguments.
    pub fn describe_template(&self) -> fluent_builders::DescribeTemplate<C, M, R> {
        fluent_builders::DescribeTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTemplateAlias` operation.
    ///
    /// See [`DescribeTemplateAlias`](crate::client::fluent_builders::DescribeTemplateAlias) for more information about the
    /// operation and its arguments.
    pub fn describe_template_alias(&self) -> fluent_builders::DescribeTemplateAlias<C, M, R> {
        fluent_builders::DescribeTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTemplatePermissions` operation.
    ///
    /// See [`DescribeTemplatePermissions`](crate::client::fluent_builders::DescribeTemplatePermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_template_permissions(
        &self,
    ) -> fluent_builders::DescribeTemplatePermissions<C, M, R> {
        fluent_builders::DescribeTemplatePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTheme` operation.
    ///
    /// See [`DescribeTheme`](crate::client::fluent_builders::DescribeTheme) for more information about the
    /// operation and its arguments.
    pub fn describe_theme(&self) -> fluent_builders::DescribeTheme<C, M, R> {
        fluent_builders::DescribeTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeThemeAlias` operation.
    ///
    /// See [`DescribeThemeAlias`](crate::client::fluent_builders::DescribeThemeAlias) for more information about the
    /// operation and its arguments.
    pub fn describe_theme_alias(&self) -> fluent_builders::DescribeThemeAlias<C, M, R> {
        fluent_builders::DescribeThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeThemePermissions` operation.
    ///
    /// See [`DescribeThemePermissions`](crate::client::fluent_builders::DescribeThemePermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_theme_permissions(&self) -> fluent_builders::DescribeThemePermissions<C, M, R> {
        fluent_builders::DescribeThemePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUser` operation.
    ///
    /// See [`DescribeUser`](crate::client::fluent_builders::DescribeUser) for more information about the
    /// operation and its arguments.
    pub fn describe_user(&self) -> fluent_builders::DescribeUser<C, M, R> {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateEmbedUrlForAnonymousUser` operation.
    ///
    /// See [`GenerateEmbedUrlForAnonymousUser`](crate::client::fluent_builders::GenerateEmbedUrlForAnonymousUser) for more information about the
    /// operation and its arguments.
    pub fn generate_embed_url_for_anonymous_user(
        &self,
    ) -> fluent_builders::GenerateEmbedUrlForAnonymousUser<C, M, R> {
        fluent_builders::GenerateEmbedUrlForAnonymousUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateEmbedUrlForRegisteredUser` operation.
    ///
    /// See [`GenerateEmbedUrlForRegisteredUser`](crate::client::fluent_builders::GenerateEmbedUrlForRegisteredUser) for more information about the
    /// operation and its arguments.
    pub fn generate_embed_url_for_registered_user(
        &self,
    ) -> fluent_builders::GenerateEmbedUrlForRegisteredUser<C, M, R> {
        fluent_builders::GenerateEmbedUrlForRegisteredUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDashboardEmbedUrl` operation.
    ///
    /// See [`GetDashboardEmbedUrl`](crate::client::fluent_builders::GetDashboardEmbedUrl) for more information about the
    /// operation and its arguments.
    pub fn get_dashboard_embed_url(&self) -> fluent_builders::GetDashboardEmbedUrl<C, M, R> {
        fluent_builders::GetDashboardEmbedUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSessionEmbedUrl` operation.
    ///
    /// See [`GetSessionEmbedUrl`](crate::client::fluent_builders::GetSessionEmbedUrl) for more information about the
    /// operation and its arguments.
    pub fn get_session_embed_url(&self) -> fluent_builders::GetSessionEmbedUrl<C, M, R> {
        fluent_builders::GetSessionEmbedUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnalyses` operation.
    ///
    /// See [`ListAnalyses`](crate::client::fluent_builders::ListAnalyses) for more information about the
    /// operation and its arguments.
    pub fn list_analyses(&self) -> fluent_builders::ListAnalyses<C, M, R> {
        fluent_builders::ListAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDashboards` operation.
    ///
    /// See [`ListDashboards`](crate::client::fluent_builders::ListDashboards) for more information about the
    /// operation and its arguments.
    pub fn list_dashboards(&self) -> fluent_builders::ListDashboards<C, M, R> {
        fluent_builders::ListDashboards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDashboardVersions` operation.
    ///
    /// See [`ListDashboardVersions`](crate::client::fluent_builders::ListDashboardVersions) for more information about the
    /// operation and its arguments.
    pub fn list_dashboard_versions(&self) -> fluent_builders::ListDashboardVersions<C, M, R> {
        fluent_builders::ListDashboardVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataSets` operation.
    ///
    /// See [`ListDataSets`](crate::client::fluent_builders::ListDataSets) for more information about the
    /// operation and its arguments.
    pub fn list_data_sets(&self) -> fluent_builders::ListDataSets<C, M, R> {
        fluent_builders::ListDataSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataSources` operation.
    ///
    /// See [`ListDataSources`](crate::client::fluent_builders::ListDataSources) for more information about the
    /// operation and its arguments.
    pub fn list_data_sources(&self) -> fluent_builders::ListDataSources<C, M, R> {
        fluent_builders::ListDataSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFolderMembers` operation.
    ///
    /// See [`ListFolderMembers`](crate::client::fluent_builders::ListFolderMembers) for more information about the
    /// operation and its arguments.
    pub fn list_folder_members(&self) -> fluent_builders::ListFolderMembers<C, M, R> {
        fluent_builders::ListFolderMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFolders` operation.
    ///
    /// See [`ListFolders`](crate::client::fluent_builders::ListFolders) for more information about the
    /// operation and its arguments.
    pub fn list_folders(&self) -> fluent_builders::ListFolders<C, M, R> {
        fluent_builders::ListFolders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupMemberships` operation.
    ///
    /// See [`ListGroupMemberships`](crate::client::fluent_builders::ListGroupMemberships) for more information about the
    /// operation and its arguments.
    pub fn list_group_memberships(&self) -> fluent_builders::ListGroupMemberships<C, M, R> {
        fluent_builders::ListGroupMemberships::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroups` operation.
    ///
    /// See [`ListGroups`](crate::client::fluent_builders::ListGroups) for more information about the
    /// operation and its arguments.
    pub fn list_groups(&self) -> fluent_builders::ListGroups<C, M, R> {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIAMPolicyAssignments` operation.
    ///
    /// See [`ListIAMPolicyAssignments`](crate::client::fluent_builders::ListIAMPolicyAssignments) for more information about the
    /// operation and its arguments.
    pub fn list_iam_policy_assignments(
        &self,
    ) -> fluent_builders::ListIAMPolicyAssignments<C, M, R> {
        fluent_builders::ListIAMPolicyAssignments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIAMPolicyAssignmentsForUser` operation.
    ///
    /// See [`ListIAMPolicyAssignmentsForUser`](crate::client::fluent_builders::ListIAMPolicyAssignmentsForUser) for more information about the
    /// operation and its arguments.
    pub fn list_iam_policy_assignments_for_user(
        &self,
    ) -> fluent_builders::ListIAMPolicyAssignmentsForUser<C, M, R> {
        fluent_builders::ListIAMPolicyAssignmentsForUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIngestions` operation.
    ///
    /// See [`ListIngestions`](crate::client::fluent_builders::ListIngestions) for more information about the
    /// operation and its arguments.
    pub fn list_ingestions(&self) -> fluent_builders::ListIngestions<C, M, R> {
        fluent_builders::ListIngestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNamespaces` operation.
    ///
    /// See [`ListNamespaces`](crate::client::fluent_builders::ListNamespaces) for more information about the
    /// operation and its arguments.
    pub fn list_namespaces(&self) -> fluent_builders::ListNamespaces<C, M, R> {
        fluent_builders::ListNamespaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTemplateAliases` operation.
    ///
    /// See [`ListTemplateAliases`](crate::client::fluent_builders::ListTemplateAliases) for more information about the
    /// operation and its arguments.
    pub fn list_template_aliases(&self) -> fluent_builders::ListTemplateAliases<C, M, R> {
        fluent_builders::ListTemplateAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTemplates` operation.
    ///
    /// See [`ListTemplates`](crate::client::fluent_builders::ListTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_templates(&self) -> fluent_builders::ListTemplates<C, M, R> {
        fluent_builders::ListTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTemplateVersions` operation.
    ///
    /// See [`ListTemplateVersions`](crate::client::fluent_builders::ListTemplateVersions) for more information about the
    /// operation and its arguments.
    pub fn list_template_versions(&self) -> fluent_builders::ListTemplateVersions<C, M, R> {
        fluent_builders::ListTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThemeAliases` operation.
    ///
    /// See [`ListThemeAliases`](crate::client::fluent_builders::ListThemeAliases) for more information about the
    /// operation and its arguments.
    pub fn list_theme_aliases(&self) -> fluent_builders::ListThemeAliases<C, M, R> {
        fluent_builders::ListThemeAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThemes` operation.
    ///
    /// See [`ListThemes`](crate::client::fluent_builders::ListThemes) for more information about the
    /// operation and its arguments.
    pub fn list_themes(&self) -> fluent_builders::ListThemes<C, M, R> {
        fluent_builders::ListThemes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThemeVersions` operation.
    ///
    /// See [`ListThemeVersions`](crate::client::fluent_builders::ListThemeVersions) for more information about the
    /// operation and its arguments.
    pub fn list_theme_versions(&self) -> fluent_builders::ListThemeVersions<C, M, R> {
        fluent_builders::ListThemeVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUserGroups` operation.
    ///
    /// See [`ListUserGroups`](crate::client::fluent_builders::ListUserGroups) for more information about the
    /// operation and its arguments.
    pub fn list_user_groups(&self) -> fluent_builders::ListUserGroups<C, M, R> {
        fluent_builders::ListUserGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsers` operation.
    ///
    /// See [`ListUsers`](crate::client::fluent_builders::ListUsers) for more information about the
    /// operation and its arguments.
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterUser` operation.
    ///
    /// See [`RegisterUser`](crate::client::fluent_builders::RegisterUser) for more information about the
    /// operation and its arguments.
    pub fn register_user(&self) -> fluent_builders::RegisterUser<C, M, R> {
        fluent_builders::RegisterUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreAnalysis` operation.
    ///
    /// See [`RestoreAnalysis`](crate::client::fluent_builders::RestoreAnalysis) for more information about the
    /// operation and its arguments.
    pub fn restore_analysis(&self) -> fluent_builders::RestoreAnalysis<C, M, R> {
        fluent_builders::RestoreAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchAnalyses` operation.
    ///
    /// See [`SearchAnalyses`](crate::client::fluent_builders::SearchAnalyses) for more information about the
    /// operation and its arguments.
    pub fn search_analyses(&self) -> fluent_builders::SearchAnalyses<C, M, R> {
        fluent_builders::SearchAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchDashboards` operation.
    ///
    /// See [`SearchDashboards`](crate::client::fluent_builders::SearchDashboards) for more information about the
    /// operation and its arguments.
    pub fn search_dashboards(&self) -> fluent_builders::SearchDashboards<C, M, R> {
        fluent_builders::SearchDashboards::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchFolders` operation.
    ///
    /// See [`SearchFolders`](crate::client::fluent_builders::SearchFolders) for more information about the
    /// operation and its arguments.
    pub fn search_folders(&self) -> fluent_builders::SearchFolders<C, M, R> {
        fluent_builders::SearchFolders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccountCustomization` operation.
    ///
    /// See [`UpdateAccountCustomization`](crate::client::fluent_builders::UpdateAccountCustomization) for more information about the
    /// operation and its arguments.
    pub fn update_account_customization(
        &self,
    ) -> fluent_builders::UpdateAccountCustomization<C, M, R> {
        fluent_builders::UpdateAccountCustomization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccountSettings` operation.
    ///
    /// See [`UpdateAccountSettings`](crate::client::fluent_builders::UpdateAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn update_account_settings(&self) -> fluent_builders::UpdateAccountSettings<C, M, R> {
        fluent_builders::UpdateAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAnalysis` operation.
    ///
    /// See [`UpdateAnalysis`](crate::client::fluent_builders::UpdateAnalysis) for more information about the
    /// operation and its arguments.
    pub fn update_analysis(&self) -> fluent_builders::UpdateAnalysis<C, M, R> {
        fluent_builders::UpdateAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAnalysisPermissions` operation.
    ///
    /// See [`UpdateAnalysisPermissions`](crate::client::fluent_builders::UpdateAnalysisPermissions) for more information about the
    /// operation and its arguments.
    pub fn update_analysis_permissions(
        &self,
    ) -> fluent_builders::UpdateAnalysisPermissions<C, M, R> {
        fluent_builders::UpdateAnalysisPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDashboard` operation.
    ///
    /// See [`UpdateDashboard`](crate::client::fluent_builders::UpdateDashboard) for more information about the
    /// operation and its arguments.
    pub fn update_dashboard(&self) -> fluent_builders::UpdateDashboard<C, M, R> {
        fluent_builders::UpdateDashboard::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDashboardPermissions` operation.
    ///
    /// See [`UpdateDashboardPermissions`](crate::client::fluent_builders::UpdateDashboardPermissions) for more information about the
    /// operation and its arguments.
    pub fn update_dashboard_permissions(
        &self,
    ) -> fluent_builders::UpdateDashboardPermissions<C, M, R> {
        fluent_builders::UpdateDashboardPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDashboardPublishedVersion` operation.
    ///
    /// See [`UpdateDashboardPublishedVersion`](crate::client::fluent_builders::UpdateDashboardPublishedVersion) for more information about the
    /// operation and its arguments.
    pub fn update_dashboard_published_version(
        &self,
    ) -> fluent_builders::UpdateDashboardPublishedVersion<C, M, R> {
        fluent_builders::UpdateDashboardPublishedVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSet` operation.
    ///
    /// See [`UpdateDataSet`](crate::client::fluent_builders::UpdateDataSet) for more information about the
    /// operation and its arguments.
    pub fn update_data_set(&self) -> fluent_builders::UpdateDataSet<C, M, R> {
        fluent_builders::UpdateDataSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSetPermissions` operation.
    ///
    /// See [`UpdateDataSetPermissions`](crate::client::fluent_builders::UpdateDataSetPermissions) for more information about the
    /// operation and its arguments.
    pub fn update_data_set_permissions(
        &self,
    ) -> fluent_builders::UpdateDataSetPermissions<C, M, R> {
        fluent_builders::UpdateDataSetPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSource` operation.
    ///
    /// See [`UpdateDataSource`](crate::client::fluent_builders::UpdateDataSource) for more information about the
    /// operation and its arguments.
    pub fn update_data_source(&self) -> fluent_builders::UpdateDataSource<C, M, R> {
        fluent_builders::UpdateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSourcePermissions` operation.
    ///
    /// See [`UpdateDataSourcePermissions`](crate::client::fluent_builders::UpdateDataSourcePermissions) for more information about the
    /// operation and its arguments.
    pub fn update_data_source_permissions(
        &self,
    ) -> fluent_builders::UpdateDataSourcePermissions<C, M, R> {
        fluent_builders::UpdateDataSourcePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFolder` operation.
    ///
    /// See [`UpdateFolder`](crate::client::fluent_builders::UpdateFolder) for more information about the
    /// operation and its arguments.
    pub fn update_folder(&self) -> fluent_builders::UpdateFolder<C, M, R> {
        fluent_builders::UpdateFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFolderPermissions` operation.
    ///
    /// See [`UpdateFolderPermissions`](crate::client::fluent_builders::UpdateFolderPermissions) for more information about the
    /// operation and its arguments.
    pub fn update_folder_permissions(&self) -> fluent_builders::UpdateFolderPermissions<C, M, R> {
        fluent_builders::UpdateFolderPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGroup` operation.
    ///
    /// See [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) for more information about the
    /// operation and its arguments.
    pub fn update_group(&self) -> fluent_builders::UpdateGroup<C, M, R> {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIAMPolicyAssignment` operation.
    ///
    /// See [`UpdateIAMPolicyAssignment`](crate::client::fluent_builders::UpdateIAMPolicyAssignment) for more information about the
    /// operation and its arguments.
    pub fn update_iam_policy_assignment(
        &self,
    ) -> fluent_builders::UpdateIAMPolicyAssignment<C, M, R> {
        fluent_builders::UpdateIAMPolicyAssignment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIpRestriction` operation.
    ///
    /// See [`UpdateIpRestriction`](crate::client::fluent_builders::UpdateIpRestriction) for more information about the
    /// operation and its arguments.
    pub fn update_ip_restriction(&self) -> fluent_builders::UpdateIpRestriction<C, M, R> {
        fluent_builders::UpdateIpRestriction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTemplate` operation.
    ///
    /// See [`UpdateTemplate`](crate::client::fluent_builders::UpdateTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_template(&self) -> fluent_builders::UpdateTemplate<C, M, R> {
        fluent_builders::UpdateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTemplateAlias` operation.
    ///
    /// See [`UpdateTemplateAlias`](crate::client::fluent_builders::UpdateTemplateAlias) for more information about the
    /// operation and its arguments.
    pub fn update_template_alias(&self) -> fluent_builders::UpdateTemplateAlias<C, M, R> {
        fluent_builders::UpdateTemplateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTemplatePermissions` operation.
    ///
    /// See [`UpdateTemplatePermissions`](crate::client::fluent_builders::UpdateTemplatePermissions) for more information about the
    /// operation and its arguments.
    pub fn update_template_permissions(
        &self,
    ) -> fluent_builders::UpdateTemplatePermissions<C, M, R> {
        fluent_builders::UpdateTemplatePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTheme` operation.
    ///
    /// See [`UpdateTheme`](crate::client::fluent_builders::UpdateTheme) for more information about the
    /// operation and its arguments.
    pub fn update_theme(&self) -> fluent_builders::UpdateTheme<C, M, R> {
        fluent_builders::UpdateTheme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThemeAlias` operation.
    ///
    /// See [`UpdateThemeAlias`](crate::client::fluent_builders::UpdateThemeAlias) for more information about the
    /// operation and its arguments.
    pub fn update_theme_alias(&self) -> fluent_builders::UpdateThemeAlias<C, M, R> {
        fluent_builders::UpdateThemeAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThemePermissions` operation.
    ///
    /// See [`UpdateThemePermissions`](crate::client::fluent_builders::UpdateThemePermissions) for more information about the
    /// operation and its arguments.
    pub fn update_theme_permissions(&self) -> fluent_builders::UpdateThemePermissions<C, M, R> {
        fluent_builders::UpdateThemePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUser` operation.
    ///
    /// See [`UpdateUser`](crate::client::fluent_builders::UpdateUser) for more information about the
    /// operation and its arguments.
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelIngestion`.
    ///
    /// <p>Cancels an ongoing ingestion of data into SPICE.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelIngestion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_ingestion_input::Builder,
    }
    impl<C, M, R> CancelIngestion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelIngestion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelIngestionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelIngestionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelIngestionInputOperationOutputAlias,
                crate::output::CancelIngestionOutput,
                crate::error::CancelIngestionError,
                crate::input::CancelIngestionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingestion_id(inp);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ingestion_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccountCustomization`.
    ///
    /// <p>Creates Amazon QuickSight customizations the current Amazon Web Services Region. Currently, you can
    /// add a custom default theme by using the <code>CreateAccountCustomization</code> or
    /// <code>UpdateAccountCustomization</code> API operation. To further customize
    /// Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Amazon QuickSight</a> in the <i>Amazon QuickSight User
    /// Guide.</i>
    /// </p>
    /// <p>You can create customizations for your Amazon Web Services account or, if you specify a namespace, for
    /// a Amazon QuickSight namespace instead. Customizations that apply to a namespace always override
    /// customizations that apply to an Amazon Web Services account. To find out which customizations apply, use
    /// the <code>DescribeAccountCustomization</code> API operation.</p>
    /// <p>Before you use the <code>CreateAccountCustomization</code> API operation to add a theme
    /// as the namespace default, make sure that you first share the theme with the namespace.
    /// If you don't share it with the namespace, the theme isn't visible to your users
    /// even if you make it the default theme.
    /// To check if the theme is shared, view the current permissions by using the
    /// <code>
    /// <a>DescribeThemePermissions</a>
    /// </code> API operation.
    /// To share the theme, grant permissions by using the
    /// <code>
    /// <a>UpdateThemePermissions</a>
    /// </code> API operation. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_account_customization_input::Builder,
    }
    impl<C, M, R> CreateAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccountCustomizationInputOperationOutputAlias,
                crate::output::CreateAccountCustomizationOutput,
                crate::error::CreateAccountCustomizationError,
                crate::input::CreateAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to customize Amazon QuickSight for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to add customizations to.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to add customizations to.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. You can add
        /// these to an Amazon Web Services account and a Amazon QuickSight namespace. </p>
        /// <p>For example, you can add a default theme by setting <code>AccountCustomization</code>
        /// to the midnight theme: <code>"AccountCustomization": { "DefaultTheme":
        /// "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by
        /// specifying <code>"AccountCustomization": { "DefaultTheme":
        /// "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639"
        /// }</code>. </p>
        pub fn account_customization(mut self, inp: crate::model::AccountCustomization) -> Self {
            self.inner = self.inner.account_customization(inp);
            self
        }
        /// <p>The Amazon QuickSight customizations you're adding in the current Amazon Web Services Region. You can add
        /// these to an Amazon Web Services account and a Amazon QuickSight namespace. </p>
        /// <p>For example, you can add a default theme by setting <code>AccountCustomization</code>
        /// to the midnight theme: <code>"AccountCustomization": { "DefaultTheme":
        /// "arn:aws:quicksight::aws:theme/MIDNIGHT" }</code>. Or, you can add a custom theme by
        /// specifying <code>"AccountCustomization": { "DefaultTheme":
        /// "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639"
        /// }</code>. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.inner = self.inner.set_account_customization(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags that you want to attach to this resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tags that you want to attach to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAnalysis`.
    ///
    /// <p>Creates an analysis in Amazon QuickSight.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_analysis_input::Builder,
    }
    impl<C, M, R> CreateAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAnalysisInputOperationOutputAlias,
                crate::output::CreateAnalysisOutput,
                crate::error::CreateAnalysisError,
                crate::input::CreateAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you are creating an analysis.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account where you are creating an analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the analysis that you're creating. This ID displays in the URL of the
        /// analysis.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID for the analysis that you're creating. This ID displays in the URL of the
        /// analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>A descriptive name for the analysis that you're creating. This name displays for the
        /// analysis in the Amazon QuickSight console. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A descriptive name for the analysis that you're creating. This name displays for the
        /// analysis in the Amazon QuickSight console. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have
        /// any parameter type, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, inp: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have
        /// any parameter type, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions on an
        /// analysis. You can use the <code>Permissions</code> structure to grant permissions by
        /// providing a list of Identity and Access Management (IAM) action information for each
        /// principal listed by Amazon Resource Name (ARN). </p>
        ///
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn permissions(mut self, inp: impl Into<crate::model::ResourcePermission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions on an
        /// analysis. You can use the <code>Permissions</code> structure to grant permissions by
        /// providing a list of Identity and Access Management (IAM) action information for each
        /// principal listed by Amazon Resource Name (ARN). </p>
        ///
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're creating. This metadata structure
        /// contains details that describe a source template and one or more datasets.</p>
        pub fn source_entity(mut self, inp: crate::model::AnalysisSourceEntity) -> Self {
            self.inner = self.inner.source_entity(inp);
            self
        }
        /// <p>A source entity to use for the analysis that you're creating. This metadata structure
        /// contains details that describe a source template and one or more datasets.</p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::AnalysisSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>The ARN for the theme to apply to the analysis that you're creating. To see the theme
        /// in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn theme_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(inp);
            self
        }
        /// <p>The ARN for the theme to apply to the analysis that you're creating. To see the theme
        /// in the Amazon QuickSight console, make sure that you have access to it.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the
        /// analysis.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the
        /// analysis.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDashboard`.
    ///
    /// <p>Creates a dashboard from a template. To first create a template, see the <code>
    /// <a>CreateTemplate</a>
    /// </code> API operation.</p>
    /// <p>A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created
    /// from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can
    /// create scheduled email reports from them. If you have the correct permissions, you can
    /// create a dashboard from a template that exists in a different Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dashboard_input::Builder,
    }
    impl<C, M, R> CreateDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDashboardInputOperationOutputAlias,
                crate::output::CreateDashboardOutput,
                crate::error::CreateDashboardError,
                crate::input::CreateDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to create the dashboard.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard, also added to the IAMpolicy.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard, also added to the IAMpolicy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameters for the creation of the dashboard, which you want to use to override
        /// the default settings. A dashboard can have any type of parameters, and some parameters
        /// might accept multiple values. </p>
        pub fn parameters(mut self, inp: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The parameters for the creation of the dashboard, which you want to use to override
        /// the default settings. A dashboard can have any type of parameters, and some parameters
        /// might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that contains the permissions of the dashboard. You can use this structure
        /// for granting permissions by providing a list of IAMaction information for each
        /// principal ARN. </p>
        ///
        /// <p>To specify no permissions, omit the permissions list.</p>
        pub fn permissions(mut self, inp: impl Into<crate::model::ResourcePermission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>A structure that contains the permissions of the dashboard. You can use this structure
        /// for granting permissions by providing a list of IAMaction information for each
        /// principal ARN. </p>
        ///
        /// <p>To specify no permissions, omit the permissions list.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the dashboard. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source. You
        /// can only create a dashboard from a template, so you use a <code>SourceTemplate</code>
        /// entity. If you need to create a dashboard from an analysis, first convert the analysis
        /// to a template by using the <a>CreateTemplate</a> API operation. For
        /// <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source
        /// template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any
        /// Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to
        /// list the replacement datasets for the placeholders listed in the original. The schema in
        /// each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, inp: crate::model::DashboardSourceEntity) -> Self {
            self.inner = self.inner.source_entity(inp);
            self
        }
        /// <p>The entity that you are using as a source when you create the dashboard. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source. You
        /// can only create a dashboard from a template, so you use a <code>SourceTemplate</code>
        /// entity. If you need to create a dashboard from an analysis, first convert the analysis
        /// to a template by using the <a>CreateTemplate</a> API operation. For
        /// <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source
        /// template. The <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any
        /// Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to
        /// list the replacement datasets for the placeholders listed in the original. The schema in
        /// each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::DashboardSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the
        /// dashboard.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the
        /// dashboard.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn version_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(inp);
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is
        /// set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the
        /// published dashboard, which can be used for ad hoc (one-time) filtering. This
        /// option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual
        /// option to export data to .CSV format isn't enabled when this is set to
        /// <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityState</code> for <code>SheetControlsOption</code> - This
        /// visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>.
        /// This option is <code>COLLAPSED</code> by default. </p>
        /// </li>
        /// </ul>
        pub fn dashboard_publish_options(
            mut self,
            inp: crate::model::DashboardPublishOptions,
        ) -> Self {
            self.inner = self.inner.dashboard_publish_options(inp);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is
        /// set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the
        /// published dashboard, which can be used for ad hoc (one-time) filtering. This
        /// option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual
        /// option to export data to .CSV format isn't enabled when this is set to
        /// <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityState</code> for <code>SheetControlsOption</code> - This
        /// visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>.
        /// This option is <code>COLLAPSED</code> by default. </p>
        /// </li>
        /// </ul>
        pub fn set_dashboard_publish_options(
            mut self,
            input: std::option::Option<crate::model::DashboardPublishOptions>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_publish_options(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If
        /// you add a value for this field, it overrides the value that is used in the source
        /// entity. The theme ARN must exist in the same Amazon Web Services account where you create the
        /// dashboard.</p>
        pub fn theme_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If
        /// you add a value for this field, it overrides the value that is used in the source
        /// entity. The theme ARN must exist in the same Amazon Web Services account where you create the
        /// dashboard.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSet`.
    ///
    /// <p>Creates a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_set_input::Builder,
    }
    impl<C, M, R> CreateDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSetInputOperationOutputAlias,
                crate::output::CreateDataSetOutput,
                crate::error::CreateDataSetError,
                crate::input::CreateDataSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>An ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `PhysicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_physical_table_map`](Self::set_physical_table_map).
        ///
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn physical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PhysicalTable>,
        ) -> Self {
            self.inner = self.inner.physical_table_map(k, v);
            self
        }
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn set_physical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_physical_table_map(input);
            self
        }
        /// Adds a key-value pair to `LogicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_logical_table_map`](Self::set_logical_table_map).
        ///
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn logical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::LogicalTable>,
        ) -> Self {
            self.inner = self.inner.logical_table_map(k, v);
            self
        }
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn set_logical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logical_table_map(input);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn import_mode(mut self, inp: crate::model::DataSetImportMode) -> Self {
            self.inner = self.inner.import_mode(inp);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn set_import_mode(
            mut self,
            input: std::option::Option<crate::model::DataSetImportMode>,
        ) -> Self {
            self.inner = self.inner.set_import_mode(input);
            self
        }
        /// Appends an item to `ColumnGroups`.
        ///
        /// To override the contents of this collection use [`set_column_groups`](Self::set_column_groups).
        ///
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn column_groups(mut self, inp: impl Into<crate::model::ColumnGroup>) -> Self {
            self.inner = self.inner.column_groups(inp);
            self
        }
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn set_column_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        ) -> Self {
            self.inner = self.inner.set_column_groups(input);
            self
        }
        /// Adds a key-value pair to `FieldFolders`.
        ///
        /// To override the contents of this collection use [`set_field_folders`](Self::set_field_folders).
        ///
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn field_folders(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::FieldFolder>,
        ) -> Self {
            self.inner = self.inner.field_folders(k, v);
            self
        }
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn set_field_folders(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
            >,
        ) -> Self {
            self.inner = self.inner.set_field_folders(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn permissions(mut self, inp: impl Into<crate::model::ResourcePermission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>A list of resource permissions on the dataset.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The row-level security configuration for the data that you want to create.</p>
        pub fn row_level_permission_data_set(
            mut self,
            inp: crate::model::RowLevelPermissionDataSet,
        ) -> Self {
            self.inner = self.inner.row_level_permission_data_set(inp);
            self
        }
        /// <p>The row-level security configuration for the data that you want to create.</p>
        pub fn set_row_level_permission_data_set(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionDataSet>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_data_set(input);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn row_level_permission_tag_configuration(
            mut self,
            inp: crate::model::RowLevelPermissionTagConfiguration,
        ) -> Self {
            self.inner = self.inner.row_level_permission_tag_configuration(inp);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn set_row_level_permission_tag_configuration(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_tag_configuration(input);
            self
        }
        /// Appends an item to `ColumnLevelPermissionRules`.
        ///
        /// To override the contents of this collection use [`set_column_level_permission_rules`](Self::set_column_level_permission_rules).
        ///
        /// <p>A set of one or more definitions of a <code>
        /// <a>ColumnLevelPermissionRule</a>
        /// </code>.</p>
        pub fn column_level_permission_rules(
            mut self,
            inp: impl Into<crate::model::ColumnLevelPermissionRule>,
        ) -> Self {
            self.inner = self.inner.column_level_permission_rules(inp);
            self
        }
        /// <p>A set of one or more definitions of a <code>
        /// <a>ColumnLevelPermissionRule</a>
        /// </code>.</p>
        pub fn set_column_level_permission_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        ) -> Self {
            self.inner = self.inner.set_column_level_permission_rules(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn data_set_usage_configuration(
            mut self,
            inp: crate::model::DataSetUsageConfiguration,
        ) -> Self {
            self.inner = self.inner.data_set_usage_configuration(inp);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn set_data_set_usage_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSetUsageConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_set_usage_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSource`.
    ///
    /// <p>Creates a data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_source_input::Builder,
    }
    impl<C, M, R> CreateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSourceInputOperationOutputAlias,
                crate::output::CreateDataSourceOutput,
                crate::error::CreateDataSourceError,
                crate::input::CreateDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the data source. To return a
        /// list of all data sources, use <code>ListDataSources</code>.</p>
        /// <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>
        pub fn r#type(mut self, inp: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the data source. To return a
        /// list of all data sources, use <code>ListDataSources</code>.</p>
        /// <p>Use <code>AMAZON_ELASTICSEARCH</code> for Amazon OpenSearch Service.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn data_source_parameters(mut self, inp: crate::model::DataSourceParameters) -> Self {
            self.inner = self.inner.data_source_parameters(inp);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn set_data_source_parameters(
            mut self,
            input: std::option::Option<crate::model::DataSourceParameters>,
        ) -> Self {
            self.inner = self.inner.set_data_source_parameters(input);
            self
        }
        /// <p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only
        /// credentials based on user name and password are supported.</p>
        pub fn credentials(mut self, inp: crate::model::DataSourceCredentials) -> Self {
            self.inner = self.inner.credentials(inp);
            self
        }
        /// <p>The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only
        /// credentials based on user name and password are supported.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::DataSourceCredentials>,
        ) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions on the data source.</p>
        pub fn permissions(mut self, inp: impl Into<crate::model::ResourcePermission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>A list of resource permissions on the data source.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to
        /// your underlying source.</p>
        pub fn vpc_connection_properties(
            mut self,
            inp: crate::model::VpcConnectionProperties,
        ) -> Self {
            self.inner = self.inner.vpc_connection_properties(inp);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to
        /// your underlying source.</p>
        pub fn set_vpc_connection_properties(
            mut self,
            input: std::option::Option<crate::model::VpcConnectionProperties>,
        ) -> Self {
            self.inner = self.inner.set_vpc_connection_properties(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn ssl_properties(mut self, inp: crate::model::SslProperties) -> Self {
            self.inner = self.inner.ssl_properties(inp);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.</p>
        pub fn set_ssl_properties(
            mut self,
            input: std::option::Option<crate::model::SslProperties>,
        ) -> Self {
            self.inner = self.inner.set_ssl_properties(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFolder`.
    ///
    /// <p>Creates an empty shared folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_folder_input::Builder,
    }
    impl<C, M, R> CreateFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFolderInputOperationOutputAlias,
                crate::output::CreateFolderOutput,
                crate::error::CreateFolderError,
                crate::input::CreateFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS Account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>
        pub fn folder_type(mut self, inp: crate::model::FolderType) -> Self {
            self.inner = self.inner.folder_type(inp);
            self
        }
        /// <p>The type of folder. By default, <code>folderType</code> is <code>SHARED</code>.</p>
        pub fn set_folder_type(
            mut self,
            input: std::option::Option<crate::model::FolderType>,
        ) -> Self {
            self.inner = self.inner.set_folder_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the parent folder.</p>
        /// <p>
        /// <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>
        pub fn parent_folder_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_folder_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the parent folder.</p>
        /// <p>
        /// <code>ParentFolderArn</code> can be null. An empty <code>parentFolderArn</code> creates a root-level folder.</p>
        pub fn set_parent_folder_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_folder_arn(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A structure that describes the principals and the resource-level permissions of a folder.</p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn permissions(mut self, inp: impl Into<crate::model::ResourcePermission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>A structure that describes the principals and the resource-level permissions of a folder.</p>
        /// <p>To specify no permissions, omit <code>Permissions</code>.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for the folder.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags for the folder.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFolderMembership`.
    ///
    /// <p>Adds an asset, such as a dashboard, analysis, or dataset into a folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFolderMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_folder_membership_input::Builder,
    }
    impl<C, M, R> CreateFolderMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFolderMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFolderMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFolderMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFolderMembershipInputOperationOutputAlias,
                crate::output::CreateFolderMembershipOutput,
                crate::error::CreateFolderMembershipError,
                crate::input::CreateFolderMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS Account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset).</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset).</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>
        pub fn member_type(mut self, inp: crate::model::MemberType) -> Self {
            self.inner = self.inner.member_type(inp);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>.</p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.inner = self.inner.set_member_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates an Amazon QuickSight group.</p>
    /// <p>The permissions resource is
    /// <code>arn:aws:quicksight:us-east-1:<i><relevant-aws-account-id></i>:group/default/<i><group-name></i>
    /// </code>.</p>
    /// <p>The response is a group object.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the group that you want to create.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>A name for the group that you want to create.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>A description for the group that you want to create.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the group that you want to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroupMembership`.
    ///
    /// <p>Adds an Amazon QuickSight user to an Amazon QuickSight group. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGroupMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_membership_input::Builder,
    }
    impl<C, M, R> CreateGroupMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroupMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupMembershipInputOperationOutputAlias,
                crate::output::CreateGroupMembershipOutput,
                crate::error::CreateGroupMembershipError,
                crate::input::CreateGroupMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to add to the group membership.</p>
        pub fn member_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_name(inp);
            self
        }
        /// <p>The name of the user that you want to add to the group membership.</p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_name(input);
            self
        }
        /// <p>The name of the group that you want to add the user to.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group that you want to add the user to.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIAMPolicyAssignment`.
    ///
    /// <p>Creates an assignment with one specified IAMpolicy, identified by its Amazon Resource Name
    /// (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight.
    /// Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces,
    /// use assignment names that are unique.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> CreateIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::CreateIamPolicyAssignmentOutput,
                crate::error::CreateIAMPolicyAssignmentError,
                crate::input::CreateIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to assign an IAMpolicy to Amazon QuickSight users or
        /// groups.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to assign an IAMpolicy to Amazon QuickSight users or
        /// groups.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>
        pub fn assignment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(inp);
            self
        }
        /// <p>The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> - Anything specified in this assignment is used when creating the data
        /// source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - This assignment isn't used when creating the data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the
        /// data source.</p>
        /// </li>
        /// </ul>
        pub fn assignment_status(mut self, inp: crate::model::AssignmentStatus) -> Self {
            self.inner = self.inner.assignment_status(inp);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> - Anything specified in this assignment is used when creating the data
        /// source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - This assignment isn't used when creating the data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the
        /// data source.</p>
        /// </li>
        /// </ul>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_assignment_status(input);
            self
        }
        /// <p>The ARN for the IAMpolicy to apply to the Amazon QuickSight users and groups
        /// specified in this assignment.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The ARN for the IAMpolicy to apply to the Amazon QuickSight users and groups
        /// specified in this assignment.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Adds a key-value pair to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.identities(k, v);
            self
        }
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIngestion`.
    ///
    /// <p>Creates and starts a new SPICE ingestion on a dataset</p>
    ///
    /// <p>Any ingestions operating on tagged datasets inherit the same tags automatically for use in
    /// access control. For an example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I create an IAM policy to control access to Amazon EC2 resources using
    /// tags?</a> in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIngestion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ingestion_input::Builder,
    }
    impl<C, M, R> CreateIngestion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIngestion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIngestionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIngestionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIngestionInputOperationOutputAlias,
                crate::output::CreateIngestionOutput,
                crate::error::CreateIngestionError,
                crate::input::CreateIngestionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingestion_id(inp);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ingestion_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The type of ingestion that you want to create.</p>
        pub fn ingestion_type(mut self, inp: crate::model::IngestionType) -> Self {
            self.inner = self.inner.ingestion_type(inp);
            self
        }
        /// <p>The type of ingestion that you want to create.</p>
        pub fn set_ingestion_type(
            mut self,
            input: std::option::Option<crate::model::IngestionType>,
        ) -> Self {
            self.inner = self.inner.set_ingestion_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNamespace`.
    ///
    /// <p>(Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.</p>
    /// <p>A namespace allows you to isolate the Amazon QuickSight users and groups that are registered
    /// for that namespace. Users that access the namespace can share assets only with other
    /// users or groups in the same namespace. They can't see users and groups in other
    /// namespaces. You can create a namespace after your Amazon Web Services account is subscribed to
    /// Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a
    /// limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with
    /// Amazon Web Services Support. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_namespace_input::Builder,
    }
    impl<C, M, R> CreateNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNamespaceInputOperationOutputAlias,
                crate::output::CreateNamespaceOutput,
                crate::error::CreateNamespaceError,
                crate::input::CreateNamespaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to create the Amazon QuickSight namespace in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name that you want to use to describe the new namespace.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The name that you want to use to describe the new namespace.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users
        /// with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn identity_store(mut self, inp: crate::model::IdentityStore) -> Self {
            self.inner = self.inner.identity_store(inp);
            self
        }
        /// <p>Specifies the type of your user identity directory. Currently, this supports users
        /// with an identity type of <code>QUICKSIGHT</code>.</p>
        pub fn set_identity_store(
            mut self,
            input: std::option::Option<crate::model::IdentityStore>,
        ) -> Self {
            self.inner = self.inner.set_identity_store(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to associate with the namespace that you're creating.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags that you want to associate with the namespace that you're creating.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTemplate`.
    ///
    /// <p>Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting
    /// template to create a dashboard.</p>
    /// <p>A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata
    /// required to create an analysis and that you can use to create s dashboard. A template adds
    /// a layer of abstraction by using placeholders to replace the dataset associated with the
    /// analysis. You can use templates to create dashboards by replacing dataset placeholders
    /// with datasets that follow the same schema that was used to create the source analysis
    /// and template.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_template_input::Builder,
    }
    impl<C, M, R> CreateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTemplateInputOperationOutputAlias,
                crate::output::CreateTemplateOutput,
                crate::error::CreateTemplateError,
                crate::input::CreateTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in
        /// each Amazon Web Services account.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in
        /// each Amazon Web Services account.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>A display name for the template.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A display name for the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn permissions(mut self, inp: impl Into<crate::model::ResourcePermission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>A list of resource permissions to be set on the template. </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The entity that you are using as a source when you create the template. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source:
        /// <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an
        /// analysis. Both of these require an Amazon Resource Name (ARN). For
        /// <code>SourceTemplate</code>, specify the ARN of the source template. For
        /// <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code>
        /// ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
        /// <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed
        /// in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, inp: crate::model::TemplateSourceEntity) -> Self {
            self.inner = self.inner.source_entity(inp);
            self
        }
        /// <p>The entity that you are using as a source when you create the template. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source:
        /// <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an
        /// analysis. Both of these require an Amazon Resource Name (ARN). For
        /// <code>SourceTemplate</code>, specify the ARN of the source template. For
        /// <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code>
        /// ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
        /// <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed
        /// in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::TemplateSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A description of the current template version being created. This API operation creates the
        /// first version of the template. Every time <code>UpdateTemplate</code> is called, a new
        /// version is created. Each version of the template maintains a description of the version
        /// in the <code>VersionDescription</code> field.</p>
        pub fn version_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(inp);
            self
        }
        /// <p>A description of the current template version being created. This API operation creates the
        /// first version of the template. Every time <code>UpdateTemplate</code> is called, a new
        /// version is created. Each version of the template maintains a description of the version
        /// in the <code>VersionDescription</code> field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTemplateAlias`.
    ///
    /// <p>Creates a template alias for a template.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_template_alias_input::Builder,
    }
    impl<C, M, R> CreateTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTemplateAliasInputOperationOutputAlias,
                crate::output::CreateTemplateAliasOutput,
                crate::error::CreateTemplateAliasError,
                crate::input::CreateTemplateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you creating an alias for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>An ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The name that you want to give to the template alias that you're creating. Don't start the
        /// alias name with the <code>$</code> character. Alias names that start with <code>$</code>
        /// are reserved by Amazon QuickSight. </p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The name that you want to give to the template alias that you're creating. Don't start the
        /// alias name with the <code>$</code> character. Alias names that start with <code>$</code>
        /// are reserved by Amazon QuickSight. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn template_version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.template_version_number(inp);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn set_template_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_template_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTheme`.
    ///
    /// <p>Creates a theme.</p>
    /// <p>A <i>theme</i> is set of configuration options for color and layout.
    /// Themes apply to analyses and dashboards. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using
    /// Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_theme_input::Builder,
    }
    impl<C, M, R> CreateTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThemeInputOperationOutputAlias,
                crate::output::CreateThemeOutput,
                crate::error::CreateThemeError,
                crate::input::CreateThemeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to store the new theme. </p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to store the new theme. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in
        /// each Amazon Web Services account.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in
        /// each Amazon Web Services account.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>A display name for the theme.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A display name for the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of
        /// the starting themes defined by Amazon QuickSight. For a list of the starting themes, use
        /// <code>ListThemes</code> or choose <b>Themes</b> from
        /// within a Amazon QuickSight analysis. </p>
        pub fn base_theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_theme_id(inp);
            self
        }
        /// <p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of
        /// the starting themes defined by Amazon QuickSight. For a list of the starting themes, use
        /// <code>ListThemes</code> or choose <b>Themes</b> from
        /// within a Amazon QuickSight analysis. </p>
        pub fn set_base_theme_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_base_theme_id(input);
            self
        }
        /// <p>A description of the first version of the theme that you're creating. Every time
        /// <code>UpdateTheme</code> is called, a new version is created. Each version of the
        /// theme has a description of the version in the <code>VersionDescription</code>
        /// field.</p>
        pub fn version_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(inp);
            self
        }
        /// <p>A description of the first version of the theme that you're creating. Every time
        /// <code>UpdateTheme</code> is called, a new version is created. Each version of the
        /// theme has a description of the version in the <code>VersionDescription</code>
        /// field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn configuration(mut self, inp: crate::model::ThemeConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ThemeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>A valid grouping of resource permissions to apply to the new theme.
        /// </p>
        pub fn permissions(mut self, inp: impl Into<crate::model::ResourcePermission>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>A valid grouping of resource permissions to apply to the new theme.
        /// </p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of the key-value pairs for the resource tag or tags that you want to add to the
        /// resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A map of the key-value pairs for the resource tag or tags that you want to add to the
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThemeAlias`.
    ///
    /// <p>Creates a theme alias for a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_theme_alias_input::Builder,
    }
    impl<C, M, R> CreateThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThemeAliasInputOperationOutputAlias,
                crate::output::CreateThemeAliasOutput,
                crate::error::CreateThemeAliasError,
                crate::input::CreateThemeAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme for the new theme alias.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the theme alias.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>An ID for the theme alias.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name that you want to give to the theme alias that you are creating. The
        /// alias name can't begin with a <code>$</code>. Alias names that start with <code>$</code>
        /// are reserved by Amazon QuickSight. </p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The name that you want to give to the theme alias that you are creating. The
        /// alias name can't begin with a <code>$</code>. Alias names that start with <code>$</code>
        /// are reserved by Amazon QuickSight. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the theme.</p>
        pub fn theme_version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.theme_version_number(inp);
            self
        }
        /// <p>The version number of the theme.</p>
        pub fn set_theme_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_theme_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountCustomization`.
    ///
    /// <p>Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified
    /// Amazon Web Services account and Amazon QuickSight namespace.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_customization_input::Builder,
    }
    impl<C, M, R> DeleteAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountCustomizationInputOperationOutputAlias,
                crate::output::DeleteAccountCustomizationOutput,
                crate::error::DeleteAccountCustomizationError,
                crate::input::DeleteAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in
        /// this Amazon Web Services Region.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete Amazon QuickSight customizations from in
        /// this Amazon Web Services Region.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that you're deleting the customizations from.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The Amazon QuickSight namespace that you're deleting the customizations from.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAnalysis`.
    ///
    /// <p>Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during
    /// which you can restore the analysis. If you don't specify a recovery window value, the
    /// operation defaults to 30 days. Amazon QuickSight attaches a <code>DeletionTime</code> stamp to
    /// the response that specifies the end of the recovery window. At the end of the recovery
    /// window, Amazon QuickSight deletes the analysis permanently.</p>
    /// <p>At any time before recovery window ends, you can use the <code>RestoreAnalysis</code>
    /// API operation to remove the <code>DeletionTime</code> stamp and cancel the deletion of
    /// the analysis. The analysis remains visible in the API until it's deleted, so you can
    /// describe it but you can't make a template from it.</p>
    /// <p>An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console.
    /// To access it in the console, restore it. Deleting an analysis doesn't delete the
    /// dashboards that you publish from it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_analysis_input::Builder,
    }
    impl<C, M, R> DeleteAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAnalysisInputOperationOutputAlias,
                crate::output::DeleteAnalysisOutput,
                crate::error::DeleteAnalysisError,
                crate::input::DeleteAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account where you want to delete an analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis that you're deleting.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID of the analysis that you're deleting.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the
        /// analysis. You can't use this parameter with the <code>ForceDeleteWithoutRecovery</code>
        /// option in the same API call. The default value is 30.</p>
        pub fn recovery_window_in_days(mut self, inp: i64) -> Self {
            self.inner = self.inner.recovery_window_in_days(inp);
            self
        }
        /// <p>A value that specifies the number of days that Amazon QuickSight waits before it deletes the
        /// analysis. You can't use this parameter with the <code>ForceDeleteWithoutRecovery</code>
        /// option in the same API call. The default value is 30.</p>
        pub fn set_recovery_window_in_days(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_recovery_window_in_days(input);
            self
        }
        /// <p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To
        /// immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option.
        /// You can't restore an analysis after it's deleted. </p>
        pub fn force_delete_without_recovery(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete_without_recovery(inp);
            self
        }
        /// <p>This option defaults to the value <code>NoForceDeleteWithoutRecovery</code>. To
        /// immediately delete the analysis, add the <code>ForceDeleteWithoutRecovery</code> option.
        /// You can't restore an analysis after it's deleted. </p>
        pub fn set_force_delete_without_recovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_force_delete_without_recovery(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDashboard`.
    ///
    /// <p>Deletes a dashboard.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dashboard_input::Builder,
    }
    impl<C, M, R> DeleteDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDashboardInputOperationOutputAlias,
                crate::output::DeleteDashboardOutput,
                crate::error::DeleteDashboardError,
                crate::input::DeleteDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// deleting.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The version number of the dashboard. If the version number property is provided, only
        /// the specified version of the dashboard is deleted.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number of the dashboard. If the version number property is provided, only
        /// the specified version of the dashboard is deleted.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSet`.
    ///
    /// <p>Deletes a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_set_input::Builder,
    }
    impl<C, M, R> DeleteDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSetInputOperationOutputAlias,
                crate::output::DeleteDataSetOutput,
                crate::error::DeleteDataSetError,
                crate::input::DeleteDataSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSource`.
    ///
    /// <p>Deletes the data source permanently. This operation breaks
    /// all the datasets that reference the deleted data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_source_input::Builder,
    }
    impl<C, M, R> DeleteDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSourceInputOperationOutputAlias,
                crate::output::DeleteDataSourceOutput,
                crate::error::DeleteDataSourceError,
                crate::input::DeleteDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFolder`.
    ///
    /// <p>Deletes an empty folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_folder_input::Builder,
    }
    impl<C, M, R> DeleteFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFolderInputOperationOutputAlias,
                crate::output::DeleteFolderOutput,
                crate::error::DeleteFolderError,
                crate::input::DeleteFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Account ID for the folder.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS Account ID for the folder.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFolderMembership`.
    ///
    /// <p>Removes an asset, such as a dashboard, analysis, or dataset, from a folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFolderMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_folder_membership_input::Builder,
    }
    impl<C, M, R> DeleteFolderMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFolderMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFolderMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFolderMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFolderMembershipInputOperationOutputAlias,
                crate::output::DeleteFolderMembershipOutput,
                crate::error::DeleteFolderMembershipError,
                crate::input::DeleteFolderMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS Account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The Folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>
        /// </p>
        pub fn member_type(mut self, inp: crate::model::MemberType) -> Self {
            self.inner = self.inner.member_type(inp);
            self
        }
        /// <p>The type of the member, including <code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>
        /// </p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MemberType>,
        ) -> Self {
            self.inner = self.inner.set_member_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Removes a user group from Amazon QuickSight. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to delete.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group that you want to delete.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroupMembership`.
    ///
    /// <p>Removes a user from a group so that the user is no longer a member of the group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroupMembership<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_membership_input::Builder,
    }
    impl<C, M, R> DeleteGroupMembership<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroupMembership`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupMembershipOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupMembershipError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupMembershipInputOperationOutputAlias,
                crate::output::DeleteGroupMembershipOutput,
                crate::error::DeleteGroupMembershipError,
                crate::input::DeleteGroupMembershipInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to delete from the group membership.</p>
        pub fn member_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_name(inp);
            self
        }
        /// <p>The name of the user that you want to delete from the group membership.</p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_name(input);
            self
        }
        /// <p>The name of the group that you want to delete the user from.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group that you want to delete the user from.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIAMPolicyAssignment`.
    ///
    /// <p>Deletes an existing IAMpolicy assignment.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> DeleteIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::DeleteIamPolicyAssignmentOutput,
                crate::error::DeleteIAMPolicyAssignmentError,
                crate::input::DeleteIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID where you want to delete the IAMpolicy assignment.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID where you want to delete the IAMpolicy assignment.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment. </p>
        pub fn assignment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(inp);
            self
        }
        /// <p>The name of the assignment. </p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNamespace`.
    ///
    /// <p>Deletes a namespace and the users and groups that are associated with the namespace.
    /// This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not
    /// deleted. To delete these assets, you use the API operations for the relevant asset. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_namespace_input::Builder,
    }
    impl<C, M, R> DeleteNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNamespaceInputOperationOutputAlias,
                crate::output::DeleteNamespaceOutput,
                crate::error::DeleteNamespaceError,
                crate::input::DeleteNamespaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to delete the Amazon QuickSight namespace from.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace that you want to delete.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace that you want to delete.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTemplate`.
    ///
    /// <p>Deletes a template.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_template_input::Builder,
    }
    impl<C, M, R> DeleteTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTemplateInputOperationOutputAlias,
                crate::output::DeleteTemplateOutput,
                crate::error::DeleteTemplateError,
                crate::input::DeleteTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're deleting.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the template you want to delete.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>An ID for the template you want to delete.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>Specifies the version of the template that you want to delete.
        /// If you don't provide a version number, <code>DeleteTemplate</code> deletes all versions of the template.
        /// </p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>Specifies the version of the template that you want to delete.
        /// If you don't provide a version number, <code>DeleteTemplate</code> deletes all versions of the template.
        /// </p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTemplateAlias`.
    ///
    /// <p>Deletes the item that the specified template alias points to. If you provide a specific
    /// alias, you delete the version of the template that the alias points to.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_template_alias_input::Builder,
    }
    impl<C, M, R> DeleteTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTemplateAliasInputOperationOutputAlias,
                crate::output::DeleteTemplateAliasOutput,
                crate::error::DeleteTemplateAliasError,
                crate::input::DeleteTemplateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the item to delete.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the item to delete.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template that the specified alias is for.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template that the specified alias is for.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The name for the template alias. To delete a specific alias, you delete the version that the
        /// alias points to. You can specify the alias name, or specify the latest version of the
        /// template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. </p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The name for the template alias. To delete a specific alias, you delete the version that the
        /// alias points to. You can specify the alias name, or specify the latest version of the
        /// template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. </p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTheme`.
    ///
    /// <p>Deletes a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_theme_input::Builder,
    }
    impl<C, M, R> DeleteTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThemeInputOperationOutputAlias,
                crate::output::DeleteThemeOutput,
                crate::error::DeleteThemeError,
                crate::input::DeleteThemeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're deleting.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're deleting.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>An ID for the theme that you want to delete.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>An ID for the theme that you want to delete.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The version of the theme that you want to delete. </p>
        /// <p>
        /// <b>Note:</b> If you don't provide a version number, you're
        /// using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version of the theme that you want to delete. </p>
        /// <p>
        /// <b>Note:</b> If you don't provide a version number, you're
        /// using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThemeAlias`.
    ///
    /// <p>Deletes the version of the theme that the specified theme alias points to.
    /// If you provide a specific alias, you delete the version of the theme
    /// that the alias points to.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_theme_alias_input::Builder,
    }
    impl<C, M, R> DeleteThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThemeAliasInputOperationOutputAlias,
                crate::output::DeleteThemeAliasOutput,
                crate::error::DeleteThemeAliasError,
                crate::input::DeleteThemeAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias to delete.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme that the specified alias is for.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme that the specified alias is for.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The unique name for the theme alias to delete.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The unique name for the theme alias to delete.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes the Amazon QuickSight user that is associated with the identity of the
    /// Identity and Access Management (IAM) user or role that's making the call. The IAM user
    /// isn't deleted as a result of this call. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to delete.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user that you want to delete.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserByPrincipalId`.
    ///
    /// <p>Deletes a user identified by its principal ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserByPrincipalId<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_by_principal_id_input::Builder,
    }
    impl<C, M, R> DeleteUserByPrincipalId<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserByPrincipalId`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserByPrincipalIdOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserByPrincipalIdError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserByPrincipalIdInputOperationOutputAlias,
                crate::output::DeleteUserByPrincipalIdOutput,
                crate::error::DeleteUserByPrincipalIdError,
                crate::input::DeleteUserByPrincipalIdInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The principal ID of the user.</p>
        pub fn principal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_id(inp);
            self
        }
        /// <p>The principal ID of the user.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal_id(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountCustomization`.
    ///
    /// <p>Describes the customizations associated with the provided Amazon Web Services account and Amazon
    /// Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which
    /// customizations to apply by running this API operation with the <code>Resolved</code> flag
    /// included. </p>
    /// <p>To determine what customizations display when you run this command, it can help to
    /// visualize the relationship of the entities involved. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy.
    /// It has the potential to use all of the Amazon Web Services Regions and AWS Services. When you
    /// subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region.
    /// That's where your free SPICE capacity is located. You can use Amazon QuickSight in any
    /// supported Amazon Web Services Region. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Amazon Web Services Region</code> - In each Amazon Web Services Region where you sign in to Amazon QuickSight
    /// at least once, Amazon QuickSight acts as a separate instance of the same service. If
    /// you have a user directory, it resides in us-east-1, which is the US East (N.
    /// Virginia). Generally speaking, these users have access to Amazon QuickSight in any
    /// Amazon Web Services Region, unless they are constrained to a namespace. </p>
    /// <p>To run the command in a different Amazon Web Services Region, you change your Region settings.
    /// If you're using the AWS CLI, you can use one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line options</a>. </p>
    /// </li>
    /// <li>
    /// <p>Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>. </p>
    /// </li>
    /// <li>
    /// <p>Run <code>aws configure</code> to change your default Amazon Web Services Region. Use
    /// Enter to key the same settings for your keys. For more information, see
    /// <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the AWS CLI</a>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Namespace</code> - A Amazon QuickSight namespace is a partition that contains
    /// users and assets (data sources, datasets, dashboards, and so on). To access
    /// assets that are in a specific namespace, users and groups must also be part of
    /// the same namespace. People who share a namespace are completely isolated from
    /// users and assets in other namespaces, even if they are in the same Amazon Web Services account
    /// and Amazon Web Services Region.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Applied customizations</code> -  Within an Amazon Web Services Region, a set of
    /// Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace.
    /// Settings that you apply to a namespace override settings that you apply to an
    /// Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in
    /// other Amazon Web Services Regions, run the <code>CreateAccountCustomization</code> command in
    /// each Amazon Web Services Region where you want to apply the same customizations. </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_customization_input::Builder,
    }
    impl<C, M, R> DescribeAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountCustomizationInputOperationOutputAlias,
                crate::output::DescribeAccountCustomizationOutput,
                crate::error::DescribeAccountCustomizationError,
                crate::input::DescribeAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations
        /// for.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to describe Amazon QuickSight customizations
        /// for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations
        /// for.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The Amazon QuickSight namespace that you want to describe Amazon QuickSight customizations
        /// for.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The <code>Resolved</code> flag works with the other parameters to determine which view
        /// of Amazon QuickSight customizations is returned. You can add this flag to your command to use
        /// the same view that Amazon QuickSight uses to identify which customizations to apply to the
        /// console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations
        /// that are configured at different levels. </p>
        pub fn resolved(mut self, inp: bool) -> Self {
            self.inner = self.inner.resolved(inp);
            self
        }
        /// <p>The <code>Resolved</code> flag works with the other parameters to determine which view
        /// of Amazon QuickSight customizations is returned. You can add this flag to your command to use
        /// the same view that Amazon QuickSight uses to identify which customizations to apply to the
        /// console. Omit this flag, or set it to <code>no-resolved</code>, to reveal customizations
        /// that are configured at different levels. </p>
        pub fn set_resolved(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_resolved(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountSettings`.
    ///
    /// <p>Describes the settings that were used when your Amazon QuickSight subscription was first
    /// created in this Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_settings_input::Builder,
    }
    impl<C, M, R> DescribeAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountSettingsInputOperationOutputAlias,
                crate::output::DescribeAccountSettingsOutput,
                crate::error::DescribeAccountSettingsError,
                crate::input::DescribeAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the settings that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnalysis`.
    ///
    /// <p>Provides a summary of the metadata for an analysis.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_analysis_input::Builder,
    }
    impl<C, M, R> DescribeAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAnalysisInputOperationOutputAlias,
                crate::output::DescribeAnalysisOutput,
                crate::error::DescribeAnalysisError,
                crate::input::DescribeAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis. You must be using the
        /// Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis. You must be using the
        /// Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis that you're describing. The ID is part of the URL of the
        /// analysis.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID of the analysis that you're describing. The ID is part of the URL of the
        /// analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnalysisPermissions`.
    ///
    /// <p>Provides the read and write permissions for an analysis.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAnalysisPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_analysis_permissions_input::Builder,
    }
    impl<C, M, R> DescribeAnalysisPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAnalysisPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnalysisPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAnalysisPermissionsInputOperationOutputAlias,
                crate::output::DescribeAnalysisPermissionsOutput,
                crate::error::DescribeAnalysisPermissionsError,
                crate::input::DescribeAnalysisPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're
        /// describing. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're
        /// describing. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis whose permissions you're describing. The ID is part of the
        /// analysis URL.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID of the analysis whose permissions you're describing. The ID is part of the
        /// analysis URL.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDashboard`.
    ///
    /// <p>Provides a summary for a dashboard.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dashboard_input::Builder,
    }
    impl<C, M, R> DescribeDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDashboardInputOperationOutputAlias,
                crate::output::DescribeDashboardOutput,
                crate::error::DescribeDashboardError,
                crate::input::DescribeDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// describing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The version number for the dashboard. If a version number isn't passed, the
        /// latest published dashboard version is described. </p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number for the dashboard. If a version number isn't passed, the
        /// latest published dashboard version is described. </p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The alias name.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The alias name.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDashboardPermissions`.
    ///
    /// <p>Describes read and write permissions for a dashboard.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDashboardPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dashboard_permissions_input::Builder,
    }
    impl<C, M, R> DescribeDashboardPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDashboardPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDashboardPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDashboardPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDashboardPermissionsInputOperationOutputAlias,
                crate::output::DescribeDashboardPermissionsOutput,
                crate::error::DescribeDashboardPermissionsError,
                crate::input::DescribeDashboardPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing
        /// permissions for.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're describing
        /// permissions for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard, also added to the IAMpolicy.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard, also added to the IAMpolicy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSet`.
    ///
    /// <p>Describes a dataset. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_set_input::Builder,
    }
    impl<C, M, R> DescribeDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSetInputOperationOutputAlias,
                crate::output::DescribeDataSetOutput,
                crate::error::DescribeDataSetError,
                crate::input::DescribeDataSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSetPermissions`.
    ///
    /// <p>Describes the permissions on a dataset.</p>
    /// <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSetPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_set_permissions_input::Builder,
    }
    impl<C, M, R> DescribeDataSetPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSetPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSetPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSetPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSetPermissionsInputOperationOutputAlias,
                crate::output::DescribeDataSetPermissionsOutput,
                crate::error::DescribeDataSetPermissionsError,
                crate::input::DescribeDataSetPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSource`.
    ///
    /// <p>Describes a data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_source_input::Builder,
    }
    impl<C, M, R> DescribeDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSourceInputOperationOutputAlias,
                crate::output::DescribeDataSourceOutput,
                crate::error::DescribeDataSourceError,
                crate::input::DescribeDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSourcePermissions`.
    ///
    /// <p>Describes the resource permissions for a data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSourcePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_source_permissions_input::Builder,
    }
    impl<C, M, R> DescribeDataSourcePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSourcePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSourcePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSourcePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSourcePermissionsInputOperationOutputAlias,
                crate::output::DescribeDataSourcePermissionsOutput,
                crate::error::DescribeDataSourcePermissionsError,
                crate::input::DescribeDataSourcePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFolder`.
    ///
    /// <p>Describes a folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_folder_input::Builder,
    }
    impl<C, M, R> DescribeFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFolderInputOperationOutputAlias,
                crate::output::DescribeFolderOutput,
                crate::error::DescribeFolderError,
                crate::input::DescribeFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFolderPermissions`.
    ///
    /// <p>Describes permissions for a folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFolderPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_folder_permissions_input::Builder,
    }
    impl<C, M, R> DescribeFolderPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFolderPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFolderPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFolderPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFolderPermissionsInputOperationOutputAlias,
                crate::output::DescribeFolderPermissionsOutput,
                crate::error::DescribeFolderPermissionsError,
                crate::input::DescribeFolderPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS Account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFolderResolvedPermissions`.
    ///
    /// <p>Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFolderResolvedPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_folder_resolved_permissions_input::Builder,
    }
    impl<C, M, R> DescribeFolderResolvedPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFolderResolvedPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFolderResolvedPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFolderResolvedPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFolderResolvedPermissionsInputOperationOutputAlias,
                crate::output::DescribeFolderResolvedPermissionsOutput,
                crate::error::DescribeFolderResolvedPermissionsError,
                crate::input::DescribeFolderResolvedPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGroup`.
    ///
    /// <p>Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN). </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_group_input::Builder,
    }
    impl<C, M, R> DescribeGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGroupInputOperationOutputAlias,
                crate::output::DescribeGroupOutput,
                crate::error::DescribeGroupError,
                crate::input::DescribeGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to describe.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group that you want to describe.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIAMPolicyAssignment`.
    ///
    /// <p>Describes an existing IAMpolicy assignment, as specified by the assignment name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> DescribeIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::DescribeIamPolicyAssignmentOutput,
                crate::error::DescribeIAMPolicyAssignmentError,
                crate::input::DescribeIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignment that you want to describe.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment, also called a rule.</p>
        pub fn assignment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(inp);
            self
        }
        /// <p>The name of the assignment, also called a rule.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace that contains the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIngestion`.
    ///
    /// <p>Describes a SPICE ingestion.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIngestion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ingestion_input::Builder,
    }
    impl<C, M, R> DescribeIngestion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIngestion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIngestionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIngestionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIngestionInputOperationOutputAlias,
                crate::output::DescribeIngestionOutput,
                crate::error::DescribeIngestionError,
                crate::input::DescribeIngestionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn ingestion_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ingestion_id(inp);
            self
        }
        /// <p>An ID for the ingestion.</p>
        pub fn set_ingestion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ingestion_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIpRestriction`.
    ///
    /// <p>Provides a summary and status of IP Rules.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIpRestriction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ip_restriction_input::Builder,
    }
    impl<C, M, R> DescribeIpRestriction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIpRestriction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIpRestrictionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIpRestrictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIpRestrictionInputOperationOutputAlias,
                crate::output::DescribeIpRestrictionOutput,
                crate::error::DescribeIpRestrictionError,
                crate::input::DescribeIpRestrictionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Your AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>Your AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNamespace`.
    ///
    /// <p>Describes the current namespace.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeNamespace<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_namespace_input::Builder,
    }
    impl<C, M, R> DescribeNamespace<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNamespace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNamespaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNamespaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNamespaceInputOperationOutputAlias,
                crate::output::DescribeNamespaceOutput,
                crate::error::DescribeNamespaceError,
                crate::input::DescribeNamespaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespace that you want to describe.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace that you want to describe.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace that you want to describe.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTemplate`.
    ///
    /// <p>Describes a template's metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_template_input::Builder,
    }
    impl<C, M, R> DescribeTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTemplateInputOperationOutputAlias,
                crate::output::DescribeTemplateOutput,
                crate::error::DescribeTemplateError,
                crate::input::DescribeTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter
        /// value isn't provided, the latest version of the template is described.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter
        /// value isn't provided, the latest version of the template is described.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The alias of the template that you want to describe. If you name a specific alias, you
        /// describe the version that the alias points to. You can specify the latest version of the
        /// template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The alias of the template that you want to describe. If you name a specific alias, you
        /// describe the version that the alias points to. You can specify the latest version of the
        /// template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTemplateAlias`.
    ///
    /// <p>Describes the template alias for a template.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_template_alias_input::Builder,
    }
    impl<C, M, R> DescribeTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTemplateAliasInputOperationOutputAlias,
                crate::output::DescribeTemplateAliasOutput,
                crate::error::DescribeTemplateAliasError,
                crate::input::DescribeTemplateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're
        /// describing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're
        /// describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The name of the template alias that you want to describe. If you name a specific alias, you
        /// describe the version that the alias points to. You can specify the latest version of the
        /// template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The name of the template alias that you want to describe. If you name a specific alias, you
        /// describe the version that the alias points to. You can specify the latest version of the
        /// template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTemplatePermissions`.
    ///
    /// <p>Describes read and write permissions on a template.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTemplatePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_template_permissions_input::Builder,
    }
    impl<C, M, R> DescribeTemplatePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTemplatePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTemplatePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTemplatePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTemplatePermissionsInputOperationOutputAlias,
                crate::output::DescribeTemplatePermissionsOutput,
                crate::error::DescribeTemplatePermissionsError,
                crate::input::DescribeTemplatePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTheme`.
    ///
    /// <p>Describes a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_theme_input::Builder,
    }
    impl<C, M, R> DescribeTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThemeInputOperationOutputAlias,
                crate::output::DescribeThemeOutput,
                crate::error::DescribeThemeError,
                crate::input::DescribeThemeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The version number for the version to describe. If a <code>VersionNumber</code> parameter
        /// value isn't provided, the latest version of the theme is described.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number for the version to describe. If a <code>VersionNumber</code> parameter
        /// value isn't provided, the latest version of the theme is described.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The alias of the theme that you want to describe. If you name a specific alias, you
        /// describe the version that the alias points to. You can specify the latest version of the
        /// theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. The keyword <code>$PUBLISHED</code> doesn't apply to themes.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The alias of the theme that you want to describe. If you name a specific alias, you
        /// describe the version that the alias points to. You can specify the latest version of the
        /// theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code>
        /// parameter. The keyword <code>$PUBLISHED</code> doesn't apply to themes.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThemeAlias`.
    ///
    /// <p>Describes the alias for a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_theme_alias_input::Builder,
    }
    impl<C, M, R> DescribeThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThemeAliasInputOperationOutputAlias,
                crate::output::DescribeThemeAliasOutput,
                crate::error::DescribeThemeAliasError,
                crate::input::DescribeThemeAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're
        /// describing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're
        /// describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name of the theme alias that you want to describe.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The name of the theme alias that you want to describe.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThemePermissions`.
    ///
    /// <p>Describes the read and write permissions for a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeThemePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_theme_permissions_input::Builder,
    }
    impl<C, M, R> DescribeThemePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThemePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThemePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThemePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThemePermissionsInputOperationOutputAlias,
                crate::output::DescribeThemePermissionsOutput,
                crate::error::DescribeThemePermissionsError,
                crate::input::DescribeThemePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're describing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme that you want to describe permissions for.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme that you want to describe permissions for.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Returns information about a user, given the user name. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl<C, M, R> DescribeUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserInputOperationOutputAlias,
                crate::output::DescribeUserOutput,
                crate::error::DescribeUserError,
                crate::input::DescribeUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user that you want to describe.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user that you want to describe.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateEmbedUrlForAnonymousUser`.
    ///
    /// <p>Generates an embed URL that you can use to embed an Amazon QuickSight dashboard in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.</p>
    /// <p>The following rules apply to the generated URL:</p>
    /// <ul>
    /// <li>
    /// <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p>
    /// </li>
    /// <li>
    /// <p>The URL validity period should not be confused with the actual session lifetime
    /// that can be customized using the <code>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a>
    /// </code> parameter.</p>
    /// <p>The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).</p>
    /// </li>
    /// <li>
    /// <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User
    /// Guide</i>.</p>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateEmbedUrlForAnonymousUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_embed_url_for_anonymous_user_input::Builder,
    }
    impl<C, M, R> GenerateEmbedUrlForAnonymousUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateEmbedUrlForAnonymousUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateEmbedUrlForAnonymousUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateEmbedUrlForAnonymousUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateEmbedUrlForAnonymousUserInputOperationOutputAlias,
                crate::output::GenerateEmbedUrlForAnonymousUserOutput,
                crate::error::GenerateEmbedUrlForAnonymousUserError,
                crate::input::GenerateEmbedUrlForAnonymousUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn session_lifetime_in_minutes(mut self, inp: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(inp);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// Appends an item to `SessionTags`.
        ///
        /// To override the contents of this collection use [`set_session_tags`](Self::set_session_tags).
        ///
        /// <p>The session tags used for row-level security. Before you use this parameter, make sure that
        /// you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p>
        /// <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>
        pub fn session_tags(mut self, inp: impl Into<crate::model::SessionTag>) -> Self {
            self.inner = self.inner.session_tags(inp);
            self
        }
        /// <p>The session tags used for row-level security. Before you use this parameter, make sure that
        /// you have configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session tags can be used to provide row-level security.</p>
        /// <p>These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security (RLS) with Tags</a>.</p>
        pub fn set_session_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SessionTag>>,
        ) -> Self {
            self.inner = self.inner.set_session_tags(input);
            self
        }
        /// Appends an item to `AuthorizedResourceArns`.
        ///
        /// To override the contents of this collection use [`set_authorized_resource_arns`](Self::set_authorized_resource_arns).
        ///
        /// <p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>
        pub fn authorized_resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorized_resource_arns(inp);
            self
        }
        /// <p>The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.</p>
        pub fn set_authorized_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_authorized_resource_arns(input);
            self
        }
        /// <p>The configuration of the experience you are embedding.</p>
        pub fn experience_configuration(
            mut self,
            inp: crate::model::AnonymousUserEmbeddingExperienceConfiguration,
        ) -> Self {
            self.inner = self.inner.experience_configuration(inp);
            self
        }
        /// <p>The configuration of the experience you are embedding.</p>
        pub fn set_experience_configuration(
            mut self,
            input: std::option::Option<crate::model::AnonymousUserEmbeddingExperienceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_experience_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateEmbedUrlForRegisteredUser`.
    ///
    /// <p>Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.</p>
    /// <p>The following rules apply to the generated URL:</p>
    /// <ul>
    /// <li>
    /// <p>It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.</p>
    /// </li>
    /// <li>
    /// <p>The URL validity period should not be confused with the actual session lifetime
    /// that can be customized using the <code>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a>
    /// </code> parameter.</p>
    /// <p>The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).</p>
    /// </li>
    /// <li>
    /// <p>You are charged only when the URL is used or there is interaction with Amazon QuickSight.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the <i>Amazon QuickSight User
    /// Guide</i>.</p>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateEmbedUrlForRegisteredUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_embed_url_for_registered_user_input::Builder,
    }
    impl<C, M, R> GenerateEmbedUrlForRegisteredUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateEmbedUrlForRegisteredUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateEmbedUrlForRegisteredUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateEmbedUrlForRegisteredUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateEmbedUrlForRegisteredUserInputOperationOutputAlias,
                crate::output::GenerateEmbedUrlForRegisteredUserOutput,
                crate::error::GenerateEmbedUrlForRegisteredUserError,
                crate::input::GenerateEmbedUrlForRegisteredUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn session_lifetime_in_minutes(mut self, inp: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(inp);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>The Amazon Resource Name for the registered user.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name for the registered user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards, the entire Amazon QuickSight console, or the Amazon QuickSight Q search bar.</p>
        pub fn experience_configuration(
            mut self,
            inp: crate::model::RegisteredUserEmbeddingExperienceConfiguration,
        ) -> Self {
            self.inner = self.inner.experience_configuration(inp);
            self
        }
        /// <p>The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards, the entire Amazon QuickSight console, or the Amazon QuickSight Q search bar.</p>
        pub fn set_experience_configuration(
            mut self,
            input: std::option::Option<
                crate::model::RegisteredUserEmbeddingExperienceConfiguration,
            >,
        ) -> Self {
            self.inner = self.inner.set_experience_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDashboardEmbedUrl`.
    ///
    /// <p>Generates a session URL and authorization code that you can use to embed an Amazon
    /// Amazon QuickSight read-only dashboard in your web server code. Before you use this command,
    /// make sure that you have configured the dashboards and permissions. </p>
    /// <p>Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not
    /// from the user's browser. The following rules apply to the combination of URL and
    /// authorization code:</p>
    /// <ul>
    /// <li>
    /// <p>They must be used together.</p>
    /// </li>
    /// <li>
    /// <p>They can be used one time only.</p>
    /// </li>
    /// <li>
    /// <p>They are valid for 5 minutes after you run this command.</p>
    /// </li>
    /// <li>
    /// <p>The resulting user session is valid for 10 hours.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html">Embedding Analytics Using GetDashboardEmbedUrl</a> in the <i>Amazon QuickSight User
    /// Guide</i>.</p>
    /// <p>For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer Portal</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDashboardEmbedUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dashboard_embed_url_input::Builder,
    }
    impl<C, M, R> GetDashboardEmbedUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDashboardEmbedUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDashboardEmbedUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDashboardEmbedUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDashboardEmbedUrlInputOperationOutputAlias,
                crate::output::GetDashboardEmbedUrlOutput,
                crate::error::GetDashboardEmbedUrlError,
                crate::input::GetDashboardEmbedUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the dashboard that you're embedding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard, also added to the Identity and Access Management (IAM)
        /// policy.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard, also added to the Identity and Access Management (IAM)
        /// policy.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The authentication method that the user uses to sign in.</p>
        pub fn identity_type(mut self, inp: crate::model::EmbeddingIdentityType) -> Self {
            self.inner = self.inner.identity_type(inp);
            self
        }
        /// <p>The authentication method that the user uses to sign in.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::EmbeddingIdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn session_lifetime_in_minutes(mut self, inp: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(inp);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables
        /// the undo/redo button.</p>
        pub fn undo_redo_disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.undo_redo_disabled(inp);
            self
        }
        /// <p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables
        /// the undo/redo button.</p>
        pub fn set_undo_redo_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_undo_redo_disabled(input);
            self
        }
        /// <p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the
        /// reset button.</p>
        pub fn reset_disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.reset_disabled(inp);
            self
        }
        /// <p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the
        /// reset button.</p>
        pub fn set_reset_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_disabled(input);
            self
        }
        /// <p>Adds persistence of state for the user session in an embedded dashboard. Persistence
        /// applies to the sheet and the parameter settings. These are control settings that the
        /// dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is
        /// set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same
        /// dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is
        /// set to FALSE, the state of the user session is not persisted. The default is
        /// <code>FALSE</code>.</p>
        pub fn state_persistence_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.state_persistence_enabled(inp);
            self
        }
        /// <p>Adds persistence of state for the user session in an embedded dashboard. Persistence
        /// applies to the sheet and the parameter settings. These are control settings that the
        /// dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is
        /// set to <code>TRUE</code>, the settings are the same when the subscriber reopens the same
        /// dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is
        /// set to FALSE, the state of the user session is not persisted. The default is
        /// <code>FALSE</code>.</p>
        pub fn set_state_persistence_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_state_persistence_enabled(input);
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type.
        /// You can use this for any Amazon QuickSight users in your account (readers, authors, or
        /// admins) authenticated as one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Active Directory (AD) users or group members</p>
        /// </li>
        /// <li>
        /// <p>Invited nonfederated users</p>
        /// </li>
        /// <li>
        /// <p>IAMusers and IAMrole-based sessions authenticated through Federated Single Sign-On using
        /// SAML, OpenID Connect, or IAMfederation.</p>
        /// </li>
        /// </ul>
        /// <p>Omit this parameter for users in the third group – IAMusers and IAM
        /// role-based sessions.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type.
        /// You can use this for any Amazon QuickSight users in your account (readers, authors, or
        /// admins) authenticated as one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Active Directory (AD) users or group members</p>
        /// </li>
        /// <li>
        /// <p>Invited nonfederated users</p>
        /// </li>
        /// <li>
        /// <p>IAMusers and IAMrole-based sessions authenticated through Federated Single Sign-On using
        /// SAML, OpenID Connect, or IAMfederation.</p>
        /// </li>
        /// </ul>
        /// <p>Omit this parameter for users in the third group – IAMusers and IAM
        /// role-based sessions.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
        /// <p>The Amazon QuickSight namespace that contains the dashboard IDs in this request.
        /// If you're not using a custom namespace, set <code>Namespace = default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The Amazon QuickSight namespace that contains the dashboard IDs in this request.
        /// If you're not using a custom namespace, set <code>Namespace = default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// Appends an item to `AdditionalDashboardIds`.
        ///
        /// To override the contents of this collection use [`set_additional_dashboard_ids`](Self::set_additional_dashboard_ids).
        ///
        /// <p>A list of one or more dashboard IDs that you want to add to a session that includes
        /// anonymous users. The <code>IdentityType</code> parameter must be set to
        /// <code>ANONYMOUS</code> for this to work, because other identity types authenticate
        /// as Amazon QuickSight or IAMusers. For example, if you set "<code>--dashboard-id dash_id1
        /// --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session
        /// can access all three dashboards. </p>
        pub fn additional_dashboard_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_dashboard_ids(inp);
            self
        }
        /// <p>A list of one or more dashboard IDs that you want to add to a session that includes
        /// anonymous users. The <code>IdentityType</code> parameter must be set to
        /// <code>ANONYMOUS</code> for this to work, because other identity types authenticate
        /// as Amazon QuickSight or IAMusers. For example, if you set "<code>--dashboard-id dash_id1
        /// --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS</code>", the session
        /// can access all three dashboards. </p>
        pub fn set_additional_dashboard_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_additional_dashboard_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSessionEmbedUrl`.
    ///
    /// <p>Generates a session URL and authorization code that you can use to embed the Amazon
    /// Amazon QuickSight console in your web server code. Use <code>GetSessionEmbedUrl</code> where
    /// you want to provide an authoring portal that allows users to create data sources,
    /// datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console
    /// need belong to the author or admin security cohort. If you want to restrict permissions
    /// to some of these features, add a custom permissions profile to the user with the
    /// <code>
    /// <a>UpdateUser</a>
    /// </code> API operation. Use <code>
    /// <a>RegisterUser</a>
    /// </code> API operation to add a new user with a custom permission profile attached. For more
    /// information, see the following sections in the <i>Amazon QuickSight User
    /// Guide</i>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedding Analytics</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html">Customizing Access to the Amazon QuickSight Console</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetSessionEmbedUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_session_embed_url_input::Builder,
    }
    impl<C, M, R> GetSessionEmbedUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSessionEmbedUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSessionEmbedUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSessionEmbedUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSessionEmbedUrlInputOperationOutputAlias,
                crate::output::GetSessionEmbedUrlOutput,
                crate::error::GetSessionEmbedUrlError,
                crate::input::GetSessionEmbedUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The URL you use to access the embedded session. The entry point URL is constrained to
        /// the following paths:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/start</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/analyses</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/dashboards</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/favorites</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/dashboards/<i>DashboardId</i>
        /// </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/analyses/<i>AnalysisId</i>
        /// </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p>
        /// </li>
        /// </ul>
        pub fn entry_point(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entry_point(inp);
            self
        }
        /// <p>The URL you use to access the embedded session. The entry point URL is constrained to
        /// the following paths:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/start</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/analyses</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/dashboards</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/start/favorites</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/dashboards/<i>DashboardId</i>
        /// </code> - where <code>DashboardId</code> is the actual ID key from the Amazon QuickSight console URL of the dashboard</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/analyses/<i>AnalysisId</i>
        /// </code> - where <code>AnalysisId</code> is the actual ID key from the Amazon QuickSight console URL of the analysis</p>
        /// </li>
        /// </ul>
        pub fn set_entry_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entry_point(input);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn session_lifetime_in_minutes(mut self, inp: i64) -> Self {
            self.inner = self.inner.session_lifetime_in_minutes(inp);
            self
        }
        /// <p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>
        pub fn set_session_lifetime_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_session_lifetime_in_minutes(input);
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type.
        /// You can use this for any type of Amazon QuickSight users in your account (readers, authors, or
        /// admins). They need to be authenticated as one of the following:</p>
        /// <ol>
        /// <li>
        /// <p>Active Directory (AD) users or group members</p>
        /// </li>
        /// <li>
        /// <p>Invited nonfederated users</p>
        /// </li>
        /// <li>
        /// <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated
        /// through Federated Single Sign-On using SAML, OpenID Connect, or IAM
        /// federation</p>
        /// </li>
        /// </ol>
        /// <p>Omit this parameter for users in the third group, IAM users and IAM role-based
        /// sessions.</p>
        pub fn user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_arn(inp);
            self
        }
        /// <p>The Amazon QuickSight user's Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type.
        /// You can use this for any type of Amazon QuickSight users in your account (readers, authors, or
        /// admins). They need to be authenticated as one of the following:</p>
        /// <ol>
        /// <li>
        /// <p>Active Directory (AD) users or group members</p>
        /// </li>
        /// <li>
        /// <p>Invited nonfederated users</p>
        /// </li>
        /// <li>
        /// <p>Identity and Access Management (IAM) users and IAM role-based sessions authenticated
        /// through Federated Single Sign-On using SAML, OpenID Connect, or IAM
        /// federation</p>
        /// </li>
        /// </ol>
        /// <p>Omit this parameter for users in the third group, IAM users and IAM role-based
        /// sessions.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnalyses`.
    ///
    /// <p>Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnalyses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_analyses_input::Builder,
    }
    impl<C, M, R> ListAnalyses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnalyses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnalysesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnalysesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnalysesInputOperationOutputAlias,
                crate::output::ListAnalysesOutput,
                crate::error::ListAnalysesError,
                crate::input::ListAnalysesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDashboards`.
    ///
    /// <p>Lists dashboards in an Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDashboards<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dashboards_input::Builder,
    }
    impl<C, M, R> ListDashboards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDashboards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDashboardsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDashboardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDashboardsInputOperationOutputAlias,
                crate::output::ListDashboardsOutput,
                crate::error::ListDashboardsError,
                crate::input::ListDashboardsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboards that you're
        /// listing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboards that you're
        /// listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDashboardVersions`.
    ///
    /// <p>Lists all the versions of the dashboards in the Amazon QuickSight subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDashboardVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dashboard_versions_input::Builder,
    }
    impl<C, M, R> ListDashboardVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDashboardVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDashboardVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDashboardVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDashboardVersionsInputOperationOutputAlias,
                crate::output::ListDashboardVersionsOutput,
                crate::error::ListDashboardVersionsError,
                crate::input::ListDashboardVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're listing versions
        /// for.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're listing versions
        /// for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSets`.
    ///
    /// <p>Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.</p>
    /// <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDataSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_sets_input::Builder,
    }
    impl<C, M, R> ListDataSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSetsInputOperationOutputAlias,
                crate::output::ListDataSetsOutput,
                crate::error::ListDataSetsError,
                crate::input::ListDataSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSources`.
    ///
    /// <p>Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDataSources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_sources_input::Builder,
    }
    impl<C, M, R> ListDataSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSourcesInputOperationOutputAlias,
                crate::output::ListDataSourcesOutput,
                crate::error::ListDataSourcesError,
                crate::input::ListDataSourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFolderMembers`.
    ///
    /// <p>List all assets (<code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>) in a folder. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFolderMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_folder_members_input::Builder,
    }
    impl<C, M, R> ListFolderMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFolderMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFolderMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFolderMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFolderMembersInputOperationOutputAlias,
                crate::output::ListFolderMembersOutput,
                crate::error::ListFolderMembersError,
                crate::input::ListFolderMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFolders`.
    ///
    /// <p>Lists all folders in an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFolders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_folders_input::Builder,
    }
    impl<C, M, R> ListFolders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFolders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFoldersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFoldersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFoldersInputOperationOutputAlias,
                crate::output::ListFoldersOutput,
                crate::error::ListFoldersError,
                crate::input::ListFoldersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupMemberships`.
    ///
    /// <p>Lists member users in a group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroupMemberships<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_group_memberships_input::Builder,
    }
    impl<C, M, R> ListGroupMemberships<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupMemberships`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupMembershipsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupMembershipsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupMembershipsInputOperationOutputAlias,
                crate::output::ListGroupMembershipsOutput,
                crate::error::ListGroupMembershipsError,
                crate::input::ListGroupMembershipsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to see a membership list of.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group that you want to see a membership list of.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Lists all user groups in Amazon QuickSight. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl<C, M, R> ListGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsInputOperationOutputAlias,
                crate::output::ListGroupsOutput,
                crate::error::ListGroupsError,
                crate::input::ListGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIAMPolicyAssignments`.
    ///
    /// <p>Lists IAMpolicy assignments in the current Amazon QuickSight account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIAMPolicyAssignments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_iam_policy_assignments_input::Builder,
    }
    impl<C, M, R> ListIAMPolicyAssignments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIAMPolicyAssignments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIamPolicyAssignmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIAMPolicyAssignmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIamPolicyAssignmentsInputOperationOutputAlias,
                crate::output::ListIamPolicyAssignmentsOutput,
                crate::error::ListIAMPolicyAssignmentsError,
                crate::input::ListIamPolicyAssignmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains these IAMpolicy assignments.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains these IAMpolicy assignments.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The status of the assignments.</p>
        pub fn assignment_status(mut self, inp: crate::model::AssignmentStatus) -> Self {
            self.inner = self.inner.assignment_status(inp);
            self
        }
        /// <p>The status of the assignments.</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_assignment_status(input);
            self
        }
        /// <p>The namespace for the assignments.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace for the assignments.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIAMPolicyAssignmentsForUser`.
    ///
    /// <p>Lists all the IAMpolicy assignments, including the Amazon Resource Names (ARNs) for the IAM
    /// policies assigned to the specified user and group or groups that the user belongs
    /// to.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIAMPolicyAssignmentsForUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_iam_policy_assignments_for_user_input::Builder,
    }
    impl<C, M, R> ListIAMPolicyAssignmentsForUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIAMPolicyAssignmentsForUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIamPolicyAssignmentsForUserOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIAMPolicyAssignmentsForUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIamPolicyAssignmentsForUserInputOperationOutputAlias,
                crate::output::ListIamPolicyAssignmentsForUserOutput,
                crate::error::ListIAMPolicyAssignmentsForUserError,
                crate::input::ListIamPolicyAssignmentsForUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignments.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the assignments.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the user.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIngestions`.
    ///
    /// <p>Lists the history of SPICE ingestions for a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIngestions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ingestions_input::Builder,
    }
    impl<C, M, R> ListIngestions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIngestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIngestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIngestionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIngestionsInputOperationOutputAlias,
                crate::output::ListIngestionsOutput,
                crate::error::ListIngestionsError,
                crate::input::ListIngestionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID of the dataset used in the ingestion.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNamespaces`.
    ///
    /// <p>Lists the namespaces for the specified Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNamespaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_namespaces_input::Builder,
    }
    impl<C, M, R> ListNamespaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNamespaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNamespacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNamespacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNamespacesInputOperationOutputAlias,
                crate::output::ListNamespacesOutput,
                crate::error::ListNamespacesError,
                crate::input::ListNamespacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags assigned to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplateAliases`.
    ///
    /// <p>Lists all the aliases of a template.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTemplateAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_template_aliases_input::Builder,
    }
    impl<C, M, R> ListTemplateAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplateAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplateAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplateAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplateAliasesInputOperationOutputAlias,
                crate::output::ListTemplateAliasesOutput,
                crate::error::ListTemplateAliasesError,
                crate::input::ListTemplateAliasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template aliases that you're listing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template aliases that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplates`.
    ///
    /// <p>Lists all the templates in the current Amazon QuickSight account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_templates_input::Builder,
    }
    impl<C, M, R> ListTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplatesInputOperationOutputAlias,
                crate::output::ListTemplatesOutput,
                crate::error::ListTemplatesError,
                crate::input::ListTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplateVersions`.
    ///
    /// <p>Lists all the versions of the templates in the current Amazon QuickSight account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTemplateVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_template_versions_input::Builder,
    }
    impl<C, M, R> ListTemplateVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplateVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplateVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplateVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplateVersionsInputOperationOutputAlias,
                crate::output::ListTemplateVersionsOutput,
                crate::error::ListTemplateVersionsError,
                crate::input::ListTemplateVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the templates that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemeAliases`.
    ///
    /// <p>Lists all the aliases of a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListThemeAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_theme_aliases_input::Builder,
    }
    impl<C, M, R> ListThemeAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThemeAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemeAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemeAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThemeAliasesInputOperationOutputAlias,
                crate::output::ListThemeAliasesOutput,
                crate::error::ListThemeAliasesError,
                crate::input::ListThemeAliasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme aliases that you're listing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme aliases that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemes`.
    ///
    /// <p>Lists all the themes in the current Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListThemes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_themes_input::Builder,
    }
    impl<C, M, R> ListThemes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThemes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThemesInputOperationOutputAlias,
                crate::output::ListThemesOutput,
                crate::error::ListThemesError,
                crate::input::ListThemesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The type of themes that you want to list. Valid options include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL (default)</code>- Display all existing themes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ThemeType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of themes that you want to list. Valid options include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL (default)</code>- Display all existing themes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>QUICKSIGHT</code> - Display only the starting themes defined by Amazon QuickSight.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ThemeType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThemeVersions`.
    ///
    /// <p>Lists all the versions of the themes in the current Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListThemeVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_theme_versions_input::Builder,
    }
    impl<C, M, R> ListThemeVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThemeVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThemeVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThemeVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThemeVersionsInputOperationOutputAlias,
                crate::output::ListThemeVersionsOutput,
                crate::error::ListThemeVersionsError,
                crate::input::ListThemeVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the themes that you're listing.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserGroups`.
    ///
    /// <p>Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUserGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_groups_input::Builder,
    }
    impl<C, M, R> ListUserGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserGroupsInputOperationOutputAlias,
                crate::output::ListUserGroupsOutput,
                crate::error::ListUserGroupsError,
                crate::input::ListUserGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon QuickSight user name that you want to list group memberships for.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The Amazon QuickSight user name that you want to list group memberships for.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account
        /// that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID that the user is in. Currently, you use the ID for the Amazon Web Services account
        /// that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Returns a list of all of the Amazon QuickSight users belonging to this account. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return from this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterUser`.
    ///
    /// <p>Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity
    /// and Access Management (IAM) identity or role specified in the request. </p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_user_input::Builder,
    }
    impl<C, M, R> RegisterUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterUserOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterUserInputOperationOutputAlias,
                crate::output::RegisterUserOutput,
                crate::error::RegisterUserError,
                crate::input::RegisterUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon QuickSight supports several ways of managing the identity of users. This
        /// parameter accepts two values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IAM</code>: A user whose identity maps to an existing IAMuser or role.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by
        /// Amazon QuickSight. </p>
        /// </li>
        /// </ul>
        pub fn identity_type(mut self, inp: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(inp);
            self
        }
        /// <p>Amazon QuickSight supports several ways of managing the identity of users. This
        /// parameter accepts two values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IAM</code>: A user whose identity maps to an existing IAMuser or role.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by
        /// Amazon QuickSight. </p>
        /// </li>
        /// </ul>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The email address of the user that you want to register.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the user that you want to register.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>READER</code>: A user who has read-only access to dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and
        /// dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight
        /// settings.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_READER</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn user_role(mut self, inp: crate::model::UserRole) -> Self {
            self.inner = self.inner.user_role(inp);
            self
        }
        /// <p>The Amazon QuickSight role for the user. The user role can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>READER</code>: A user who has read-only access to dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and
        /// dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight
        /// settings.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_READER</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for
        /// use.</p>
        /// </li>
        /// </ul>
        pub fn set_user_role(mut self, input: std::option::Option<crate::model::UserRole>) -> Self {
            self.inner = self.inner.set_user_role(input);
            self
        }
        /// <p>The ARN of the IAMuser or role that you are registering with Amazon QuickSight. </p>
        pub fn iam_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_arn(inp);
            self
        }
        /// <p>The ARN of the IAMuser or role that you are registering with Amazon QuickSight. </p>
        pub fn set_iam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_arn(input);
            self
        }
        /// <p>You need to use this parameter only when you register one or more users using an assumed
        /// IAMrole. You don't need to provide the session name for other scenarios, for example when
        /// you are registering an IAMuser or an Amazon QuickSight user. You can register multiple
        /// users using the same IAMrole if each user has a different session name. For more
        /// information on assuming IAMroles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html">
        /// <code>assume-role</code>
        /// </a> in the <i>AWS CLI Reference.</i>
        /// </p>
        pub fn session_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_name(inp);
            self
        }
        /// <p>You need to use this parameter only when you register one or more users using an assumed
        /// IAMrole. You don't need to provide the session name for other scenarios, for example when
        /// you are registering an IAMuser or an Amazon QuickSight user. You can register multiple
        /// users using the same IAMrole if each user has a different session name. For more
        /// information on assuming IAMroles, see <a href="https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html">
        /// <code>assume-role</code>
        /// </a> in the <i>AWS CLI Reference.</i>
        /// </p>
        pub fn set_session_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The Amazon QuickSight user name that you want to create for the user you are
        /// registering.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The Amazon QuickSight user name that you want to create for the user you are
        /// registering.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to
        /// assign to this user. Customized permissions allows you to control a user's access by
        /// restricting access the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>Create and update data sources</p>
        /// </li>
        /// <li>
        /// <p>Create and update datasets</p>
        /// </li>
        /// <li>
        /// <p>Create and update email reports</p>
        /// </li>
        /// <li>
        /// <p>Subscribe to email reports</p>
        /// </li>
        /// </ul>
        /// <p>To add custom permissions to an existing user, use <code>
        /// <a>UpdateUser</a>
        /// </code> instead.</p>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently,
        /// you need to create the profile names for custom permission sets by using the Amazon QuickSight
        /// console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of
        /// permissions to a Amazon QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAMpolicies. Therefore, they
        /// override the permissions typically granted by assigning Amazon QuickSight users to one of the
        /// default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn custom_permissions_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_permissions_name(inp);
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to
        /// assign to this user. Customized permissions allows you to control a user's access by
        /// restricting access the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>Create and update data sources</p>
        /// </li>
        /// <li>
        /// <p>Create and update datasets</p>
        /// </li>
        /// <li>
        /// <p>Create and update email reports</p>
        /// </li>
        /// <li>
        /// <p>Subscribe to email reports</p>
        /// </li>
        /// </ul>
        /// <p>To add custom permissions to an existing user, use <code>
        /// <a>UpdateUser</a>
        /// </code> instead.</p>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently,
        /// you need to create the profile names for custom permission sets by using the Amazon QuickSight
        /// console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of
        /// permissions to a Amazon QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAMpolicies. Therefore, they
        /// override the permissions typically granted by assigning Amazon QuickSight users to one of the
        /// default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn set_custom_permissions_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_permissions_name(input);
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p>
        /// </li>
        /// </ul>
        pub fn external_login_federation_provider_type(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.external_login_federation_provider_type(inp);
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p>
        /// </li>
        /// </ul>
        pub fn set_external_login_federation_provider_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_external_login_federation_provider_type(input);
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate
        /// into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should
        /// only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn custom_federation_provider_url(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.custom_federation_provider_url(inp);
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate
        /// into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should
        /// only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn set_custom_federation_provider_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_federation_provider_url(input);
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn external_login_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_login_id(inp);
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn set_external_login_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_login_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreAnalysis`.
    ///
    /// <p>Restores an analysis.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_analysis_input::Builder,
    }
    impl<C, M, R> RestoreAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreAnalysisInputOperationOutputAlias,
                crate::output::RestoreAnalysisOutput,
                crate::error::RestoreAnalysisError,
                crate::input::RestoreAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis that you're restoring.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID of the analysis that you're restoring.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchAnalyses`.
    ///
    /// <p>Searches for analyses that belong to the user specified in the filter.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SearchAnalyses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_analyses_input::Builder,
    }
    impl<C, M, R> SearchAnalyses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchAnalyses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchAnalysesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchAnalysesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchAnalysesInputOperationOutputAlias,
                crate::output::SearchAnalysesOutput,
                crate::error::SearchAnalysesError,
                crate::input::SearchAnalysesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses that you're searching
        /// for.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analyses that you're searching
        /// for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The structure for the search filters that you want to apply to your search. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::AnalysisSearchFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The structure for the search filters that you want to apply to your search. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisSearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token that can be used in a subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchDashboards`.
    ///
    /// <p>Searches for dashboards that belong to a user. </p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SearchDashboards<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_dashboards_input::Builder,
    }
    impl<C, M, R> SearchDashboards<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchDashboards`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchDashboardsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchDashboardsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchDashboardsInputOperationOutputAlias,
                crate::output::SearchDashboardsOutput,
                crate::error::SearchDashboardsError,
                crate::input::SearchDashboardsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the user whose dashboards you're searching
        /// for. </p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the user whose dashboards you're searching
        /// for. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the search. Currently, you can search only by user name, for
        /// example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals",
        /// "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::DashboardSearchFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to apply to the search. Currently, you can search only by user name, for
        /// example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals",
        /// "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardSearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFolders`.
    ///
    /// <p>Searches the subfolders in a folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchFolders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_folders_input::Builder,
    }
    impl<C, M, R> SearchFolders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchFolders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFoldersOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFoldersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchFoldersInputOperationOutputAlias,
                crate::output::SearchFoldersOutput,
                crate::error::SearchFoldersError,
                crate::input::SearchFoldersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::FolderSearchFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, <code>"Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ]</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FolderSearchFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource. </p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to
    /// scope user permissions, by granting a user permission to access or change only resources
    /// with certain tag values. You can use the <code>TagResource</code> operation with a
    /// resource that already has tags. If you specify a new tag key for the resource, this tag
    /// is appended to the list of tags associated with the resource. If you specify a tag key
    /// that is already associated with the resource, the new tag value that you specify
    /// replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data
    /// set, data source, dashboard, and template. </p>
    /// <p>Tagging for Amazon QuickSight works in a similar way to tagging for other AWS services, except for
    /// the following:</p>
    /// <ul>
    /// <li>
    /// <p>You can't use tags to track AWS costs for Amazon QuickSight. This restriction is because Amazon QuickSight
    /// costs are based on users and SPICE capacity, which aren't taggable
    /// resources.</p>
    /// </li>
    /// <li>
    /// <p>Amazon QuickSight doesn't currently support the Tag Editor for Resource Groups.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag or tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountCustomization`.
    ///
    /// <p>Updates Amazon QuickSight customizations the current Amazon Web Services Region. Currently, the only
    /// customization you can use is a theme.</p>
    /// <p>You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a
    /// Amazon QuickSight namespace instead. Customizations that apply to a namespace override
    /// customizations that apply to an Amazon Web Services account. To find out which customizations apply, use
    /// the <code>DescribeAccountCustomization</code> API operation. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccountCustomization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_customization_input::Builder,
    }
    impl<C, M, R> UpdateAccountCustomization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountCustomization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountCustomizationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountCustomizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountCustomizationInputOperationOutputAlias,
                crate::output::UpdateAccountCustomizationOutput,
                crate::error::UpdateAccountCustomizationError,
                crate::input::UpdateAccountCustomizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations
        /// for.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations
        /// for.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace that you want to update Amazon QuickSight customizations for.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace that you want to update Amazon QuickSight customizations for.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn account_customization(mut self, inp: crate::model::AccountCustomization) -> Self {
            self.inner = self.inner.account_customization(inp);
            self
        }
        /// <p>The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region. </p>
        pub fn set_account_customization(
            mut self,
            input: std::option::Option<crate::model::AccountCustomization>,
        ) -> Self {
            self.inner = self.inner.set_account_customization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountSettings`.
    ///
    /// <p>Updates the Amazon QuickSight settings in your Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_settings_input::Builder,
    }
    impl<C, M, R> UpdateAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountSettingsInputOperationOutputAlias,
                crate::output::UpdateAccountSettingsOutput,
                crate::error::UpdateAccountSettingsError,
                crate::input::UpdateAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to
        /// list.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to
        /// list.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The default namespace for this Amazon Web Services account. Currently, the default is
        /// <code>default</code>. Identity and Access Management (IAM) users that register
        /// for the first time with Amazon QuickSight provide an email that becomes associated with the
        /// default namespace.</p>
        pub fn default_namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_namespace(inp);
            self
        }
        /// <p>The default namespace for this Amazon Web Services account. Currently, the default is
        /// <code>default</code>. Identity and Access Management (IAM) users that register
        /// for the first time with Amazon QuickSight provide an email that becomes associated with the
        /// default namespace.</p>
        pub fn set_default_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_namespace(input);
            self
        }
        /// <p>The email address that you want Amazon QuickSight to send notifications to regarding your
        /// Amazon Web Services account or Amazon QuickSight subscription.</p>
        pub fn notification_email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_email(inp);
            self
        }
        /// <p>The email address that you want Amazon QuickSight to send notifications to regarding your
        /// Amazon Web Services account or Amazon QuickSight subscription.</p>
        pub fn set_notification_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnalysis`.
    ///
    /// <p>Updates an analysis in Amazon QuickSight</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAnalysis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_analysis_input::Builder,
    }
    impl<C, M, R> UpdateAnalysis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnalysisInputOperationOutputAlias,
                crate::output::UpdateAnalysisOutput,
                crate::error::UpdateAnalysisError,
                crate::input::UpdateAnalysisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis that you're updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the analysis that you're updating. This ID displays in the URL of the
        /// analysis.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID for the analysis that you're updating. This ID displays in the URL of the
        /// analysis.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// <p>A descriptive name for the analysis that you're updating. This name displays for the
        /// analysis in the Amazon QuickSight console.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A descriptive name for the analysis that you're updating. This name displays for the
        /// analysis in the Amazon QuickSight console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have
        /// any parameter type, and some parameters might accept multiple values. </p>
        pub fn parameters(mut self, inp: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The parameter names and override values that you want to use. An analysis can have
        /// any parameter type, and some parameters might accept multiple values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>A source entity to use for the analysis that you're updating. This metadata structure
        /// contains details that describe a source template and one or more datasets.</p>
        pub fn source_entity(mut self, inp: crate::model::AnalysisSourceEntity) -> Self {
            self.inner = self.inner.source_entity(inp);
            self
        }
        /// <p>A source entity to use for the analysis that you're updating. This metadata structure
        /// contains details that describe a source template and one or more datasets.</p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::AnalysisSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're
        /// creating. To see the theme in the Amazon QuickSight console, make sure that you have access to
        /// it.</p>
        pub fn theme_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're
        /// creating. To see the theme in the Amazon QuickSight console, make sure that you have access to
        /// it.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnalysisPermissions`.
    ///
    /// <p>Updates the read and write permissions for an analysis.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAnalysisPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_analysis_permissions_input::Builder,
    }
    impl<C, M, R> UpdateAnalysisPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnalysisPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnalysisPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnalysisPermissionsInputOperationOutputAlias,
                crate::output::UpdateAnalysisPermissionsOutput,
                crate::error::UpdateAnalysisPermissionsError,
                crate::input::UpdateAnalysisPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're
        /// updating. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the analysis whose permissions you're
        /// updating. You must be using the Amazon Web Services account that the analysis is in.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the analysis whose permissions you're updating. The ID is part of the
        /// analysis URL.</p>
        pub fn analysis_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.analysis_id(inp);
            self
        }
        /// <p>The ID of the analysis whose permissions you're updating. The ID is part of the
        /// analysis URL.</p>
        pub fn set_analysis_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_analysis_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A structure that describes the permissions to add and the principal to add them
        /// to.</p>
        pub fn grant_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.grant_permissions(inp);
            self
        }
        /// <p>A structure that describes the permissions to add and the principal to add them
        /// to.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A structure that describes the permissions to remove and the principal to remove them
        /// from.</p>
        pub fn revoke_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.revoke_permissions(inp);
            self
        }
        /// <p>A structure that describes the permissions to remove and the principal to remove them
        /// from.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboard`.
    ///
    /// <p>Updates a dashboard in an Amazon Web Services account.</p>
    /// <note>
    /// <p>Updating a Dashboard creates a new dashboard version but does not immediately publish
    /// the new version.  You can update the published version of a dashboard by
    /// using the <a>UpdateDashboardPublishedVersion</a> API operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDashboard<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dashboard_input::Builder,
    }
    impl<C, M, R> UpdateDashboard<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDashboard`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDashboardInputOperationOutputAlias,
                crate::output::UpdateDashboardOutput,
                crate::error::UpdateDashboardError,
                crate::input::UpdateDashboardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The display name of the dashboard.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The entity that you are using as a source when you update the dashboard. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source. You
        /// can only update a dashboard from a template, so you use a <code>SourceTemplate</code>
        /// entity. If you need to update a dashboard from an analysis, first convert the analysis
        /// to a template by using the <a>CreateTemplate</a> API operation. For
        /// <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source
        /// template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any
        /// Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to
        /// list the replacement datasets for the placeholders listed in the original. The schema in
        /// each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, inp: crate::model::DashboardSourceEntity) -> Self {
            self.inner = self.inner.source_entity(inp);
            self
        }
        /// <p>The entity that you are using as a source when you update the dashboard. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source. You
        /// can only update a dashboard from a template, so you use a <code>SourceTemplate</code>
        /// entity. If you need to update a dashboard from an analysis, first convert the analysis
        /// to a template by using the <a>CreateTemplate</a> API operation. For
        /// <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source
        /// template. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and any
        /// Amazon QuickSight-supported Amazon Web Services Region. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to
        /// list the replacement datasets for the placeholders listed in the original. The schema in
        /// each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::DashboardSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>A structure that contains the parameters of the dashboard. These are parameter
        /// overrides for a dashboard. A dashboard can have any type of parameters, and some
        /// parameters might accept multiple values.</p>
        pub fn parameters(mut self, inp: crate::model::Parameters) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>A structure that contains the parameters of the dashboard. These are parameter
        /// overrides for a dashboard. A dashboard can have any type of parameters, and some
        /// parameters might accept multiple values.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::Parameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn version_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(inp);
            self
        }
        /// <p>A description for the first version of the dashboard being created.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is
        /// set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the
        /// published dashboard, which can be used for ad hoc (one-time) filtering. This
        /// option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual
        /// option to export data to .CSV format isn't enabled when this is set to
        /// <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityState</code> for <code>SheetControlsOption</code> - This
        /// visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>.
        /// This option is <code>COLLAPSED</code> by default. </p>
        /// </li>
        /// </ul>
        pub fn dashboard_publish_options(
            mut self,
            inp: crate::model::DashboardPublishOptions,
        ) -> Self {
            self.inner = self.inner.dashboard_publish_options(inp);
            self
        }
        /// <p>Options for publishing the dashboard when you create it:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is
        /// set to <code>DISABLED</code>, Amazon QuickSight disables the left filter pane on the
        /// published dashboard, which can be used for ad hoc (one-time) filtering. This
        /// option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This
        /// status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual
        /// option to export data to .CSV format isn't enabled when this is set to
        /// <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityState</code> for <code>SheetControlsOption</code> - This
        /// visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>.
        /// This option is <code>COLLAPSED</code> by default. </p>
        /// </li>
        /// </ul>
        pub fn set_dashboard_publish_options(
            mut self,
            input: std::option::Option<crate::model::DashboardPublishOptions>,
        ) -> Self {
            self.inner = self.inner.set_dashboard_publish_options(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If
        /// you add a value for this field, it overrides the value that was originally associated
        /// with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the
        /// dashboard.</p>
        pub fn theme_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If
        /// you add a value for this field, it overrides the value that was originally associated
        /// with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the
        /// dashboard.</p>
        pub fn set_theme_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboardPermissions`.
    ///
    /// <p>Updates read and write permissions on a dashboard.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDashboardPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dashboard_permissions_input::Builder,
    }
    impl<C, M, R> UpdateDashboardPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDashboardPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDashboardPermissionsInputOperationOutputAlias,
                crate::output::UpdateDashboardPermissionsOutput,
                crate::error::UpdateDashboardPermissionsError,
                crate::input::UpdateDashboardPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you're
        /// updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard whose permissions you're
        /// updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>The permissions that you want to grant on this resource.</p>
        pub fn grant_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.grant_permissions(inp);
            self
        }
        /// <p>The permissions that you want to grant on this resource.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>The permissions that you want to revoke from this resource.</p>
        pub fn revoke_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.revoke_permissions(inp);
            self
        }
        /// <p>The permissions that you want to revoke from this resource.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDashboardPublishedVersion`.
    ///
    /// <p>Updates the published version of a dashboard.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDashboardPublishedVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dashboard_published_version_input::Builder,
    }
    impl<C, M, R> UpdateDashboardPublishedVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDashboardPublishedVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDashboardPublishedVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDashboardPublishedVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDashboardPublishedVersionInputOperationOutputAlias,
                crate::output::UpdateDashboardPublishedVersionOutput,
                crate::error::UpdateDashboardPublishedVersionError,
                crate::input::UpdateDashboardPublishedVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the dashboard that you're
        /// updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn dashboard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dashboard_id(inp);
            self
        }
        /// <p>The ID for the dashboard.</p>
        pub fn set_dashboard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dashboard_id(input);
            self
        }
        /// <p>The version number of the dashboard.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number of the dashboard.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSet`.
    ///
    /// <p>Updates a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_set_input::Builder,
    }
    impl<C, M, R> UpdateDataSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSetInputOperationOutputAlias,
                crate::output::UpdateDataSetOutput,
                crate::error::UpdateDataSetError,
                crate::input::UpdateDataSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset that you want to update. This ID is unique per Amazon Web Services Region for each
        /// Amazon Web Services account.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID for the dataset that you want to update. This ID is unique per Amazon Web Services Region for each
        /// Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The display name for the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `PhysicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_physical_table_map`](Self::set_physical_table_map).
        ///
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn physical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PhysicalTable>,
        ) -> Self {
            self.inner = self.inner.physical_table_map(k, v);
            self
        }
        /// <p>Declares the physical tables that are available in the underlying data sources.</p>
        pub fn set_physical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PhysicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_physical_table_map(input);
            self
        }
        /// Adds a key-value pair to `LogicalTableMap`.
        ///
        /// To override the contents of this collection use [`set_logical_table_map`](Self::set_logical_table_map).
        ///
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn logical_table_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::LogicalTable>,
        ) -> Self {
            self.inner = self.inner.logical_table_map(k, v);
            self
        }
        /// <p>Configures the combination and transformation of the data from the physical tables.</p>
        pub fn set_logical_table_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::LogicalTable>,
            >,
        ) -> Self {
            self.inner = self.inner.set_logical_table_map(input);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn import_mode(mut self, inp: crate::model::DataSetImportMode) -> Self {
            self.inner = self.inner.import_mode(inp);
            self
        }
        /// <p>Indicates whether you want to import the data into SPICE.</p>
        pub fn set_import_mode(
            mut self,
            input: std::option::Option<crate::model::DataSetImportMode>,
        ) -> Self {
            self.inner = self.inner.set_import_mode(input);
            self
        }
        /// Appends an item to `ColumnGroups`.
        ///
        /// To override the contents of this collection use [`set_column_groups`](Self::set_column_groups).
        ///
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn column_groups(mut self, inp: impl Into<crate::model::ColumnGroup>) -> Self {
            self.inner = self.inner.column_groups(inp);
            self
        }
        /// <p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>
        pub fn set_column_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnGroup>>,
        ) -> Self {
            self.inner = self.inner.set_column_groups(input);
            self
        }
        /// Adds a key-value pair to `FieldFolders`.
        ///
        /// To override the contents of this collection use [`set_field_folders`](Self::set_field_folders).
        ///
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn field_folders(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::FieldFolder>,
        ) -> Self {
            self.inner = self.inner.field_folders(k, v);
            self
        }
        /// <p>The folder that contains fields and nested subfolders for your dataset.</p>
        pub fn set_field_folders(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::FieldFolder>,
            >,
        ) -> Self {
            self.inner = self.inner.set_field_folders(input);
            self
        }
        /// <p>The row-level security configuration for the data you want to create.</p>
        pub fn row_level_permission_data_set(
            mut self,
            inp: crate::model::RowLevelPermissionDataSet,
        ) -> Self {
            self.inner = self.inner.row_level_permission_data_set(inp);
            self
        }
        /// <p>The row-level security configuration for the data you want to create.</p>
        pub fn set_row_level_permission_data_set(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionDataSet>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_data_set(input);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn row_level_permission_tag_configuration(
            mut self,
            inp: crate::model::RowLevelPermissionTagConfiguration,
        ) -> Self {
            self.inner = self.inner.row_level_permission_tag_configuration(inp);
            self
        }
        /// <p>The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only.</p>
        pub fn set_row_level_permission_tag_configuration(
            mut self,
            input: std::option::Option<crate::model::RowLevelPermissionTagConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_row_level_permission_tag_configuration(input);
            self
        }
        /// Appends an item to `ColumnLevelPermissionRules`.
        ///
        /// To override the contents of this collection use [`set_column_level_permission_rules`](Self::set_column_level_permission_rules).
        ///
        /// <p>A set of one or more definitions of a <code>
        /// <a>ColumnLevelPermissionRule</a>
        /// </code>.</p>
        pub fn column_level_permission_rules(
            mut self,
            inp: impl Into<crate::model::ColumnLevelPermissionRule>,
        ) -> Self {
            self.inner = self.inner.column_level_permission_rules(inp);
            self
        }
        /// <p>A set of one or more definitions of a <code>
        /// <a>ColumnLevelPermissionRule</a>
        /// </code>.</p>
        pub fn set_column_level_permission_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnLevelPermissionRule>>,
        ) -> Self {
            self.inner = self.inner.set_column_level_permission_rules(input);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn data_set_usage_configuration(
            mut self,
            inp: crate::model::DataSetUsageConfiguration,
        ) -> Self {
            self.inner = self.inner.data_set_usage_configuration(inp);
            self
        }
        /// <p>The usage configuration to apply to child datasets that reference this dataset as a source.</p>
        pub fn set_data_set_usage_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSetUsageConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_set_usage_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSetPermissions`.
    ///
    /// <p>Updates the permissions on a dataset.</p>
    /// <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataSetPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_set_permissions_input::Builder,
    }
    impl<C, M, R> UpdateDataSetPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSetPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSetPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSetPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSetPermissionsInputOperationOutputAlias,
                crate::output::UpdateDataSetPermissionsOutput,
                crate::error::UpdateDataSetPermissionsError,
                crate::input::UpdateDataSetPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per
        /// Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn data_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_set_id(inp);
            self
        }
        /// <p>The ID for the dataset whose permissions you want to update. This ID is unique per
        /// Amazon Web Services Region for each Amazon Web Services account.</p>
        pub fn set_data_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_set_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>The resource permissions that you want to grant to the dataset.</p>
        pub fn grant_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.grant_permissions(inp);
            self
        }
        /// <p>The resource permissions that you want to grant to the dataset.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>The resource permissions that you want to revoke from the dataset.</p>
        pub fn revoke_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.revoke_permissions(inp);
            self
        }
        /// <p>The resource permissions that you want to revoke from the dataset.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSource`.
    ///
    /// <p>Updates a data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_source_input::Builder,
    }
    impl<C, M, R> UpdateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSourceInputOperationOutputAlias,
                crate::output::UpdateDataSourceOutput,
                crate::error::UpdateDataSourceError,
                crate::input::UpdateDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A display name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn data_source_parameters(mut self, inp: crate::model::DataSourceParameters) -> Self {
            self.inner = self.inner.data_source_parameters(inp);
            self
        }
        /// <p>The parameters that Amazon QuickSight uses to connect to your underlying source.</p>
        pub fn set_data_source_parameters(
            mut self,
            input: std::option::Option<crate::model::DataSourceParameters>,
        ) -> Self {
            self.inner = self.inner.set_data_source_parameters(input);
            self
        }
        /// <p>The credentials that Amazon QuickSight that uses to connect to your underlying source. Currently,
        /// only credentials based on user name and password are supported.</p>
        pub fn credentials(mut self, inp: crate::model::DataSourceCredentials) -> Self {
            self.inner = self.inner.credentials(inp);
            self
        }
        /// <p>The credentials that Amazon QuickSight that uses to connect to your underlying source. Currently,
        /// only credentials based on user name and password are supported.</p>
        pub fn set_credentials(
            mut self,
            input: std::option::Option<crate::model::DataSourceCredentials>,
        ) -> Self {
            self.inner = self.inner.set_credentials(input);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to
        /// your underlying source.</p>
        pub fn vpc_connection_properties(
            mut self,
            inp: crate::model::VpcConnectionProperties,
        ) -> Self {
            self.inner = self.inner.vpc_connection_properties(inp);
            self
        }
        /// <p>Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to
        /// your underlying source.</p>
        pub fn set_vpc_connection_properties(
            mut self,
            input: std::option::Option<crate::model::VpcConnectionProperties>,
        ) -> Self {
            self.inner = self.inner.set_vpc_connection_properties(input);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying
        /// source.</p>
        pub fn ssl_properties(mut self, inp: crate::model::SslProperties) -> Self {
            self.inner = self.inner.ssl_properties(inp);
            self
        }
        /// <p>Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying
        /// source.</p>
        pub fn set_ssl_properties(
            mut self,
            input: std::option::Option<crate::model::SslProperties>,
        ) -> Self {
            self.inner = self.inner.set_ssl_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSourcePermissions`.
    ///
    /// <p>Updates the permissions to a data source.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataSourcePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_source_permissions_input::Builder,
    }
    impl<C, M, R> UpdateDataSourcePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSourcePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourcePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourcePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSourcePermissionsInputOperationOutputAlias,
                crate::output::UpdateDataSourcePermissionsOutput,
                crate::error::UpdateDataSourcePermissionsError,
                crate::input::UpdateDataSourcePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The ID of the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A list of resource permissions that you want to grant on the data source.</p>
        pub fn grant_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.grant_permissions(inp);
            self
        }
        /// <p>A list of resource permissions that you want to grant on the data source.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A list of resource permissions that you want to revoke on the data source.</p>
        pub fn revoke_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.revoke_permissions(inp);
            self
        }
        /// <p>A list of resource permissions that you want to revoke on the data source.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFolder`.
    ///
    /// <p>Updates the name of a folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_folder_input::Builder,
    }
    impl<C, M, R> UpdateFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFolderInputOperationOutputAlias,
                crate::output::UpdateFolderOutput,
                crate::error::UpdateFolderError,
                crate::input::UpdateFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// <p>The name of the folder.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the folder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFolderPermissions`.
    ///
    /// <p>Updates permissions of a folder.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFolderPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_folder_permissions_input::Builder,
    }
    impl<C, M, R> UpdateFolderPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFolderPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFolderPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFolderPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFolderPermissionsInputOperationOutputAlias,
                crate::output::UpdateFolderPermissionsOutput,
                crate::error::UpdateFolderPermissionsError,
                crate::input::UpdateFolderPermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The folder ID.</p>
        pub fn folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_id(inp);
            self
        }
        /// <p>The folder ID.</p>
        pub fn set_folder_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>The permissions that you want to grant on a resource.</p>
        pub fn grant_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.grant_permissions(inp);
            self
        }
        /// <p>The permissions that you want to grant on a resource.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>The permissions that you want to revoke from a resource.</p>
        pub fn revoke_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.revoke_permissions(inp);
            self
        }
        /// <p>The permissions that you want to revoke from a resource.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// <p>Changes a group description. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_input::Builder,
    }
    impl<C, M, R> UpdateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupInputOperationOutputAlias,
                crate::output::UpdateGroupOutput,
                crate::error::UpdateGroupError,
                crate::input::UpdateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group that you want to update.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group that you want to update.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The description for the group that you want to update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the group that you want to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the group is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIAMPolicyAssignment`.
    ///
    /// <p>Updates an existing IAMpolicy assignment. This operation updates only the optional
    /// parameter or parameters that are specified in the request.
    /// This overwrites all of the users included in <code>Identities</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIAMPolicyAssignment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_iam_policy_assignment_input::Builder,
    }
    impl<C, M, R> UpdateIAMPolicyAssignment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIAMPolicyAssignment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIamPolicyAssignmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIAMPolicyAssignmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIamPolicyAssignmentInputOperationOutputAlias,
                crate::output::UpdateIamPolicyAssignmentOutput,
                crate::error::UpdateIAMPolicyAssignmentError,
                crate::input::UpdateIamPolicyAssignmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the IAMpolicy assignment. </p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the IAMpolicy assignment. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The name of the assignment, also called a rule. This name must be unique within an Amazon Web Services account.</p>
        pub fn assignment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assignment_name(inp);
            self
        }
        /// <p>The name of the assignment, also called a rule. This name must be unique within an Amazon Web Services account.</p>
        pub fn set_assignment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assignment_name(input);
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace of the assignment.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> - Anything specified in this assignment is used when creating the data
        /// source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - This assignment isn't used when creating the data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the
        /// data source.</p>
        /// </li>
        /// </ul>
        pub fn assignment_status(mut self, inp: crate::model::AssignmentStatus) -> Self {
            self.inner = self.inner.assignment_status(inp);
            self
        }
        /// <p>The status of the assignment. Possible values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code> - Anything specified in this assignment is used when creating the data
        /// source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - This assignment isn't used when creating the data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the
        /// data source.</p>
        /// </li>
        /// </ul>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_assignment_status(input);
            self
        }
        /// <p>The ARN for the IAMpolicy to apply to the Amazon QuickSight users and groups
        /// specified in this assignment.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The ARN for the IAMpolicy to apply to the Amazon QuickSight users and groups
        /// specified in this assignment.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Adds a key-value pair to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn identities(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.identities(k, v);
            self
        }
        /// <p>The Amazon QuickSight users, groups, or both that you want to assign the policy to.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIpRestriction`.
    ///
    /// <p>Updates content and status of IP Rules.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIpRestriction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ip_restriction_input::Builder,
    }
    impl<C, M, R> UpdateIpRestriction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIpRestriction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIpRestrictionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIpRestrictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIpRestrictionInputOperationOutputAlias,
                crate::output::UpdateIpRestrictionOutput,
                crate::error::UpdateIpRestrictionError,
                crate::input::UpdateIpRestrictionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Your AWS account ID.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>Your AWS account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// Adds a key-value pair to `IpRestrictionRuleMap`.
        ///
        /// To override the contents of this collection use [`set_ip_restriction_rule_map`](Self::set_ip_restriction_rule_map).
        ///
        /// <p>Describes updated IP rules.</p>
        pub fn ip_restriction_rule_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.ip_restriction_rule_map(k, v);
            self
        }
        /// <p>Describes updated IP rules.</p>
        pub fn set_ip_restriction_rule_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_ip_restriction_rule_map(input);
            self
        }
        /// <p>Whether or not IP rules are enabled.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Whether or not IP rules are enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplate`.
    ///
    /// <p>Updates a template from an existing Amazon QuickSight analysis or another template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_input::Builder,
    }
    impl<C, M, R> UpdateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateInputOperationOutputAlias,
                crate::output::UpdateTemplateOutput,
                crate::error::UpdateTemplateError,
                crate::input::UpdateTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The entity that you are using as a source when you update the template. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source:
        /// <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an
        /// analysis. Both of these require an Amazon Resource Name (ARN). For
        /// <code>SourceTemplate</code>, specify the ARN of the source template. For
        /// <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code>
        /// ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
        /// <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed
        /// in the original. The schema in each dataset must match its placeholder. </p>
        pub fn source_entity(mut self, inp: crate::model::TemplateSourceEntity) -> Self {
            self.inner = self.inner.source_entity(inp);
            self
        }
        /// <p>The entity that you are using as a source when you update the template. In
        /// <code>SourceEntity</code>, you specify the type of object you're using as source:
        /// <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an
        /// analysis. Both of these require an Amazon Resource Name (ARN). For
        /// <code>SourceTemplate</code>, specify the ARN of the source template. For
        /// <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code>
        /// ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;. </p>
        /// <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
        /// <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed
        /// in the original. The schema in each dataset must match its placeholder. </p>
        pub fn set_source_entity(
            mut self,
            input: std::option::Option<crate::model::TemplateSourceEntity>,
        ) -> Self {
            self.inner = self.inner.set_source_entity(input);
            self
        }
        /// <p>A description of the current template version that is being updated. Every time you call
        /// <code>UpdateTemplate</code>, you create a new version of the template. Each version
        /// of the template maintains a description of the version in the
        /// <code>VersionDescription</code> field.</p>
        pub fn version_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(inp);
            self
        }
        /// <p>A description of the current template version that is being updated. Every time you call
        /// <code>UpdateTemplate</code>, you create a new version of the template. Each version
        /// of the template maintains a description of the version in the
        /// <code>VersionDescription</code> field.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The name for the template.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplateAlias`.
    ///
    /// <p>Updates the template alias of a template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTemplateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_alias_input::Builder,
    }
    impl<C, M, R> UpdateTemplateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateAliasInputOperationOutputAlias,
                crate::output::UpdateTemplateAliasOutput,
                crate::error::UpdateTemplateAliasError,
                crate::input::UpdateTemplateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template alias that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The alias of the template that you want to update. If you name a specific alias, you update
        /// the version that the alias points to. You can specify the latest version of the template
        /// by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter.
        /// The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The alias of the template that you want to update. If you name a specific alias, you update
        /// the version that the alias points to. You can specify the latest version of the template
        /// by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter.
        /// The keyword <code>$PUBLISHED</code> doesn't apply to templates.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn template_version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.template_version_number(inp);
            self
        }
        /// <p>The version number of the template.</p>
        pub fn set_template_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_template_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplatePermissions`.
    ///
    /// <p>Updates the resource permissions for a template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTemplatePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_permissions_input::Builder,
    }
    impl<C, M, R> UpdateTemplatePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplatePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplatePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplatePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplatePermissionsInputOperationOutputAlias,
                crate::output::UpdateTemplatePermissionsOutput,
                crate::error::UpdateTemplatePermissionsError,
                crate::input::UpdateTemplatePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the template.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the template.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>The ID for the template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A list of resource permissions to be granted on the template. </p>
        pub fn grant_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.grant_permissions(inp);
            self
        }
        /// <p>A list of resource permissions to be granted on the template. </p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A list of resource permissions to be revoked from the template. </p>
        pub fn revoke_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.revoke_permissions(inp);
            self
        }
        /// <p>A list of resource permissions to be revoked from the template. </p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTheme`.
    ///
    /// <p>Updates a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTheme<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_theme_input::Builder,
    }
    impl<C, M, R> UpdateTheme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTheme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThemeInputOperationOutputAlias,
                crate::output::UpdateThemeOutput,
                crate::error::UpdateThemeError,
                crate::input::UpdateThemeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name for the theme.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the theme.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from.
        /// All themes initially inherit from a default Amazon QuickSight theme.</p>
        pub fn base_theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_theme_id(inp);
            self
        }
        /// <p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from.
        /// All themes initially inherit from a default Amazon QuickSight theme.</p>
        pub fn set_base_theme_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_base_theme_id(input);
            self
        }
        /// <p>A description of the theme version that you're updating Every time that you call
        /// <code>UpdateTheme</code>, you create a new version of the theme. Each version of the
        /// theme maintains a description of the version in <code>VersionDescription</code>.</p>
        pub fn version_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(inp);
            self
        }
        /// <p>A description of the theme version that you're updating Every time that you call
        /// <code>UpdateTheme</code>, you create a new version of the theme. Each version of the
        /// theme maintains a description of the version in <code>VersionDescription</code>.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn configuration(mut self, inp: crate::model::ThemeConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The theme configuration, which contains the theme display properties.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ThemeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateThemeAlias`.
    ///
    /// <p>Updates an alias of a theme.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateThemeAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_theme_alias_input::Builder,
    }
    impl<C, M, R> UpdateThemeAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateThemeAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemeAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemeAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThemeAliasInputOperationOutputAlias,
                crate::output::UpdateThemeAliasOutput,
                crate::error::UpdateThemeAliasError,
                crate::input::UpdateThemeAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're updating.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme alias that you're updating.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// <p>The name of the theme alias that you want to update.</p>
        pub fn alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_name(inp);
            self
        }
        /// <p>The name of the theme alias that you want to update.</p>
        pub fn set_alias_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_name(input);
            self
        }
        /// <p>The version number of the theme that the alias should reference.</p>
        pub fn theme_version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.theme_version_number(inp);
            self
        }
        /// <p>The version number of the theme that the alias should reference.</p>
        pub fn set_theme_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_theme_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateThemePermissions`.
    ///
    /// <p>Updates the resource permissions for a theme. Permissions apply to the action to grant or
    /// revoke permissions on, for example <code>"quicksight:DescribeTheme"</code>.</p>
    /// <p>Theme permissions apply in groupings. Valid groupings include the following for the three
    /// levels of permissions, which are user, owner, or no permissions: </p>
    /// <ul>
    /// <li>
    /// <p>User</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"quicksight:DescribeTheme"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:DescribeThemeAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:ListThemeAliases"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:ListThemeVersions"</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Owner</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"quicksight:DescribeTheme"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:DescribeThemeAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:ListThemeAliases"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:ListThemeVersions"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:DeleteTheme"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:UpdateTheme"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:CreateThemeAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:DeleteThemeAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:UpdateThemeAlias"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:UpdateThemePermissions"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"quicksight:DescribeThemePermissions"</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>To specify no permissions, omit the permissions list.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateThemePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_theme_permissions_input::Builder,
    }
    impl<C, M, R> UpdateThemePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateThemePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThemePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThemePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThemePermissionsInputOperationOutputAlias,
                crate::output::UpdateThemePermissionsOutput,
                crate::error::UpdateThemePermissionsError,
                crate::input::UpdateThemePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID of the Amazon Web Services account that contains the theme.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn theme_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.theme_id(inp);
            self
        }
        /// <p>The ID for the theme.</p>
        pub fn set_theme_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_theme_id(input);
            self
        }
        /// Appends an item to `GrantPermissions`.
        ///
        /// To override the contents of this collection use [`set_grant_permissions`](Self::set_grant_permissions).
        ///
        /// <p>A list of resource permissions to be granted for the theme.</p>
        pub fn grant_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.grant_permissions(inp);
            self
        }
        /// <p>A list of resource permissions to be granted for the theme.</p>
        pub fn set_grant_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_grant_permissions(input);
            self
        }
        /// Appends an item to `RevokePermissions`.
        ///
        /// To override the contents of this collection use [`set_revoke_permissions`](Self::set_revoke_permissions).
        ///
        /// <p>A list of resource permissions to be revoked from the theme.</p>
        pub fn revoke_permissions(
            mut self,
            inp: impl Into<crate::model::ResourcePermission>,
        ) -> Self {
            self.inner = self.inner.revoke_permissions(inp);
            self
        }
        /// <p>A list of resource permissions to be revoked from the theme.</p>
        pub fn set_revoke_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourcePermission>>,
        ) -> Self {
            self.inner = self.inner.set_revoke_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Updates an Amazon QuickSight user.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_input::Builder,
    }
    impl<C, M, R> UpdateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserInputOperationOutputAlias,
                crate::output::UpdateUserOutput,
                crate::error::UpdateUserError,
                crate::input::UpdateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon QuickSight user name that you want to update.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The Amazon QuickSight user name that you want to update.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(inp);
            self
        }
        /// <p>The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the
        /// Amazon Web Services account that contains your Amazon QuickSight account.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>The namespace. Currently, you should set this to <code>default</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>The email address of the user that you want to update.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the user that you want to update.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The Amazon QuickSight role of the user. The role can be one of the
        /// following default security cohorts:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>READER</code>: A user who has read-only access to dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and
        /// dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight
        /// settings.</p>
        /// </li>
        /// </ul>
        /// <p>The name of the Amazon QuickSight role is invisible to the user except for the console
        /// screens dealing with permissions.</p>
        pub fn role(mut self, inp: crate::model::UserRole) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The Amazon QuickSight role of the user. The role can be one of the
        /// following default security cohorts:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>READER</code>: A user who has read-only access to dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and
        /// dashboards.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight
        /// settings.</p>
        /// </li>
        /// </ul>
        /// <p>The name of the Amazon QuickSight role is invisible to the user except for the console
        /// screens dealing with permissions.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::UserRole>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to
        /// assign to this user. Customized permissions allows you to control a user's access by
        /// restricting access the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>Create and update data sources</p>
        /// </li>
        /// <li>
        /// <p>Create and update datasets</p>
        /// </li>
        /// <li>
        /// <p>Create and update email reports</p>
        /// </li>
        /// <li>
        /// <p>Subscribe to email reports</p>
        /// </li>
        /// </ul>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently,
        /// you need to create the profile names for custom permission sets by using the Amazon QuickSight
        /// console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of
        /// permissions to a Amazon QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAMpolicies. Therefore, they
        /// override the permissions typically granted by assigning Amazon QuickSight users to one of the
        /// default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn custom_permissions_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_permissions_name(inp);
            self
        }
        /// <p>(Enterprise edition only) The name of the custom permissions profile that you want to
        /// assign to this user. Customized permissions allows you to control a user's access by
        /// restricting access the following operations:</p>
        /// <ul>
        /// <li>
        /// <p>Create and update data sources</p>
        /// </li>
        /// <li>
        /// <p>Create and update datasets</p>
        /// </li>
        /// <li>
        /// <p>Create and update email reports</p>
        /// </li>
        /// <li>
        /// <p>Subscribe to email reports</p>
        /// </li>
        /// </ul>
        /// <p>A set of custom permissions includes any combination of these restrictions. Currently,
        /// you need to create the profile names for custom permission sets by using the Amazon QuickSight
        /// console. Then, you use the <code>RegisterUser</code> API operation to assign the named set of
        /// permissions to a Amazon QuickSight user. </p>
        /// <p>Amazon QuickSight custom permissions are applied through IAMpolicies. Therefore, they
        /// override the permissions typically granted by assigning Amazon QuickSight users to one of the
        /// default security cohorts in Amazon QuickSight (admin, author, reader).</p>
        /// <p>This feature is available only to Amazon QuickSight Enterprise edition subscriptions.</p>
        pub fn set_custom_permissions_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_permissions_name(input);
            self
        }
        /// <p>A flag that you use to indicate that you want to remove all custom permissions
        /// from this user. Using this parameter resets the user to the state
        /// it was in before a custom permissions profile was applied. This parameter defaults to
        /// NULL and it doesn't accept any other value.</p>
        pub fn unapply_custom_permissions(mut self, inp: bool) -> Self {
            self.inner = self.inner.unapply_custom_permissions(inp);
            self
        }
        /// <p>A flag that you use to indicate that you want to remove all custom permissions
        /// from this user. Using this parameter resets the user to the state
        /// it was in before a custom permissions profile was applied. This parameter defaults to
        /// NULL and it doesn't accept any other value.</p>
        pub fn set_unapply_custom_permissions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_unapply_custom_permissions(input);
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code>: This clears all the previously saved external login information for a user. Use <code>
        /// <a>DescribeUser</a>
        /// </code> API to check the external login information.</p>
        /// </li>
        /// </ul>
        pub fn external_login_federation_provider_type(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.external_login_federation_provider_type(inp);
            self
        }
        /// <p>The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the <code>COGNITO</code> provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider. When choosing <code>CUSTOM_OIDC</code> type, use the <code>CustomFederationProviderUrl</code> parameter to provide the custom OIDC provider URL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code>: This clears all the previously saved external login information for a user. Use <code>
        /// <a>DescribeUser</a>
        /// </code> API to check the external login information.</p>
        /// </li>
        /// </ul>
        pub fn set_external_login_federation_provider_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_external_login_federation_provider_type(input);
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate
        /// into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should
        /// only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn custom_federation_provider_url(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.custom_federation_provider_url(inp);
            self
        }
        /// <p>The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate
        /// into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should
        /// only be used when <code>ExternalLoginFederationProviderType</code> parameter is set to <code>CUSTOM_OIDC</code>.</p>
        pub fn set_custom_federation_provider_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_federation_provider_url(input);
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn external_login_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_login_id(inp);
            self
        }
        /// <p>The identity ID for a user in the external login provider.</p>
        pub fn set_external_login_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_login_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
