// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You don't have access to this item. The provided credentials couldn't be
    /// validated. You might not be authorized to carry out the request. Make sure that your
    /// account is authorized to use the Amazon QuickSight service, that your policies have the
    /// correct permissions, and that you are using the correct access keys.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource is already in a state that indicates an operation is happening that must complete
    /// before a new update can be applied.</p>
    ConcurrentUpdatingException(crate::error::ConcurrentUpdatingException),
    /// <p>Updating or deleting a resource can cause an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The domain specified isn't on the allow list. All domains for embedded dashboards must be
    /// added to the approved list by an Amazon QuickSight admin.</p>
    DomainNotWhitelistedException(crate::error::DomainNotWhitelistedException),
    /// <p>The identity type specified isn't supported. Supported identity types include
    /// <code>IAM</code> and <code>QUICKSIGHT</code>.</p>
    IdentityTypeNotSupportedException(crate::error::IdentityTypeNotSupportedException),
    /// <p>An internal failure occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The <code>NextToken</code> value isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters has a value that isn't valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>A limit is exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>One or more preconditions aren't met.</p>
    PreconditionNotMetException(crate::error::PreconditionNotMetException),
    /// <p>The user with the provided name isn't found. This error can happen in any operation
    /// that requires finding a user based on a provided user name, such as
    /// <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>
    QuickSightUserNotFoundException(crate::error::QuickSightUserNotFoundException),
    /// <p>The resource specified already exists. </p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>One or more resources can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This resource is currently unavailable.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The number of minutes specified for the lifetime of a session isn't valid. The session
    /// lifetime must be 15-600 minutes.</p>
    SessionLifetimeInMinutesInvalidException(
        crate::error::SessionLifetimeInMinutesInvalidException,
    ),
    /// <p>Access is throttled.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This error indicates that you are calling an embedding operation in Amazon QuickSight
    /// without the required pricing plan on your Amazon Web Services account. Before you can use embedding
    /// for anonymous users, a Amazon QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You
    /// can do this on the <b>Manage Amazon QuickSight</b> page. </p>
    /// <p>After capacity pricing is added, you can use the
    /// <a>GetDashboardEmbedUrl</a> API operation with the
    /// <code>--identity-type ANONYMOUS</code> option.</p>
    UnsupportedPricingPlanException(crate::error::UnsupportedPricingPlanException),
    /// <p>This error indicates that you are calling an operation on an Amazon QuickSight
    /// subscription where the edition doesn't include support for that operation. Amazon
    /// Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and
    /// capability is available in every edition.</p>
    UnsupportedUserEditionException(crate::error::UnsupportedUserEditionException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::ConcurrentUpdatingException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::DomainNotWhitelistedException(inner) => inner.fmt(f),
            Error::IdentityTypeNotSupportedException(inner) => inner.fmt(f),
            Error::InternalFailureException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::PreconditionNotMetException(inner) => inner.fmt(f),
            Error::QuickSightUserNotFoundException(inner) => inner.fmt(f),
            Error::ResourceExistsException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ResourceUnavailableException(inner) => inner.fmt(f),
            Error::SessionLifetimeInMinutesInvalidException(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::UnsupportedPricingPlanException(inner) => inner.fmt(f),
            Error::UnsupportedUserEditionException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelIngestionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CancelIngestionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelIngestionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CancelIngestionErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CancelIngestionErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CancelIngestionErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CancelIngestionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CancelIngestionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CancelIngestionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAccountCustomizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAccountCustomizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateAccountCustomizationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateAccountCustomizationErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::CreateAccountCustomizationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateAccountCustomizationErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::CreateAccountCustomizationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CreateAccountCustomizationErrorKind::ResourceUnavailableException(inner) => Error::ResourceUnavailableException(inner),
                crate::error::CreateAccountCustomizationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::CreateAccountCustomizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAnalysisError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateAnalysisError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAnalysisErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateAnalysisErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateAnalysisErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateAnalysisErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateAnalysisErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateAnalysisErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateAnalysisErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::CreateAnalysisErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDashboardError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDashboardError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDashboardErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateDashboardErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateDashboardErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateDashboardErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateDashboardErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateDashboardErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateDashboardErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::CreateDashboardErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDataSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDataSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDataSetErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDataSetErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateDataSetErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateDataSetErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateDataSetErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateDataSetErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateDataSetErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateDataSetErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateDataSetErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::CreateDataSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDataSourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDataSourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDataSourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDataSourceErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateDataSourceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateDataSourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateDataSourceErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateDataSourceErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateDataSourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateDataSourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateDataSourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFolderErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateFolderErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateFolderErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateFolderErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateFolderErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateFolderErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateFolderErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateFolderErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateFolderErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::CreateFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFolderMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateFolderMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFolderMembershipErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateFolderMembershipErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateFolderMembershipErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::CreateFolderMembershipErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateFolderMembershipErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateFolderMembershipErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateFolderMembershipErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateFolderMembershipErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::CreateFolderMembershipErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateGroupErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateGroupErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateGroupErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateGroupErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::CreateGroupErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateGroupErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateGroupErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::CreateGroupErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGroupMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateGroupMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateGroupMembershipErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateGroupMembershipErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateGroupMembershipErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::CreateGroupMembershipErrorKind::PreconditionNotMetException(
                    inner,
                ) => Error::PreconditionNotMetException(inner),
                crate::error::CreateGroupMembershipErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateGroupMembershipErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::CreateGroupMembershipErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateGroupMembershipErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateIAMPolicyAssignmentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateIAMPolicyAssignmentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateIAMPolicyAssignmentErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(inner) => Error::ConcurrentUpdatingException(inner),
                crate::error::CreateIAMPolicyAssignmentErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::CreateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateIAMPolicyAssignmentErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::CreateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CreateIAMPolicyAssignmentErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::CreateIAMPolicyAssignmentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateIngestionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateIngestionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateIngestionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateIngestionErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateIngestionErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateIngestionErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateIngestionErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateIngestionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateIngestionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateIngestionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateNamespaceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateNamespaceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateNamespaceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateNamespaceErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateNamespaceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateNamespaceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateNamespaceErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateNamespaceErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::CreateNamespaceErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateNamespaceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateNamespaceErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::CreateNamespaceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateNamespaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTemplateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTemplateError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTemplateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateTemplateErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateTemplateErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateTemplateErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateTemplateErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateTemplateErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateTemplateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateTemplateErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateTemplateErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::CreateTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTemplateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateTemplateAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTemplateAliasErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateTemplateAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateTemplateAliasErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateTemplateAliasErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateTemplateAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateTemplateAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateTemplateAliasErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::CreateTemplateAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateThemeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateThemeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateThemeErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateThemeErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateThemeErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateThemeErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateThemeErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateThemeErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateThemeErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateThemeErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::CreateThemeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateThemeAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateThemeAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateThemeAliasErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::CreateThemeAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAccountCustomizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAccountCustomizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAccountCustomizationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteAccountCustomizationErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DeleteAccountCustomizationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteAccountCustomizationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteAccountCustomizationErrorKind::ResourceUnavailableException(inner) => Error::ResourceUnavailableException(inner),
                crate::error::DeleteAccountCustomizationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DeleteAccountCustomizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAnalysisError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteAnalysisError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAnalysisErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteAnalysisErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteAnalysisErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteAnalysisErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteAnalysisErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteAnalysisErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DeleteAnalysisErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDashboardError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDashboardError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDashboardErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteDashboardErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteDashboardErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteDashboardErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteDashboardErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteDashboardErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DeleteDashboardErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDataSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDataSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDataSetErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDataSetErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteDataSetErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteDataSetErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteDataSetErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteDataSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDataSourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDataSourceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteDataSourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteDataSourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteDataSourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteDataSourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFolderErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteFolderErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteFolderErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteFolderErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteFolderErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::DeleteFolderErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteFolderErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteFolderErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DeleteFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFolderMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFolderMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFolderMembershipErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteFolderMembershipErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteFolderMembershipErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteFolderMembershipErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteFolderMembershipErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteFolderMembershipErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::DeleteFolderMembershipErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteGroupErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteGroupErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteGroupErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::DeleteGroupErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteGroupErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DeleteGroupErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGroupMembershipError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteGroupMembershipError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteGroupMembershipErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteGroupMembershipErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteGroupMembershipErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteGroupMembershipErrorKind::PreconditionNotMetException(
                    inner,
                ) => Error::PreconditionNotMetException(inner),
                crate::error::DeleteGroupMembershipErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteGroupMembershipErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::DeleteGroupMembershipErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteGroupMembershipErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteIAMPolicyAssignmentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteIAMPolicyAssignmentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteIAMPolicyAssignmentErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(inner) => Error::ConcurrentUpdatingException(inner),
                crate::error::DeleteIAMPolicyAssignmentErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DeleteIAMPolicyAssignmentErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteIAMPolicyAssignmentErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::DeleteIAMPolicyAssignmentErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteIAMPolicyAssignmentErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DeleteIAMPolicyAssignmentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteNamespaceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteNamespaceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteNamespaceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteNamespaceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteNamespaceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteNamespaceErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::DeleteNamespaceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteNamespaceErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DeleteNamespaceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteNamespaceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTemplateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTemplateError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTemplateErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteTemplateErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteTemplateErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteTemplateErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::DeleteTemplateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteTemplateErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteTemplateErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DeleteTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTemplateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteTemplateAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTemplateAliasErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteTemplateAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteTemplateAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteTemplateAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteTemplateAliasErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::DeleteTemplateAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteThemeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteThemeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteThemeErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteThemeErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteThemeErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteThemeErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteThemeErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteThemeErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteThemeErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DeleteThemeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteThemeAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteThemeAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteThemeAliasErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteThemeAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteThemeAliasErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteThemeAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteThemeAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteThemeAliasErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DeleteThemeAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteUserErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteUserErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteUserErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteUserErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::DeleteUserErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteUserErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DeleteUserErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUserByPrincipalIdError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteUserByPrincipalIdError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteUserByPrincipalIdErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteUserByPrincipalIdErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DeleteUserByPrincipalIdErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteUserByPrincipalIdErrorKind::PreconditionNotMetException(
                    inner,
                ) => Error::PreconditionNotMetException(inner),
                crate::error::DeleteUserByPrincipalIdErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteUserByPrincipalIdErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::DeleteUserByPrincipalIdErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteUserByPrincipalIdErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountCustomizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountCustomizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAccountCustomizationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeAccountCustomizationErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeAccountCustomizationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeAccountCustomizationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeAccountCustomizationErrorKind::ResourceUnavailableException(inner) => Error::ResourceUnavailableException(inner),
                crate::error::DescribeAccountCustomizationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeAccountCustomizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountSettingsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeAccountSettingsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeAccountSettingsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeAccountSettingsErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeAccountSettingsErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::DescribeAccountSettingsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeAccountSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAnalysisErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeAnalysisErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeAnalysisErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeAnalysisErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeAnalysisErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeAnalysisErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DescribeAnalysisErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAnalysisPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAnalysisPermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeAnalysisPermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeAnalysisPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeAnalysisPermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeAnalysisPermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeAnalysisPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDashboardError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDashboardError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDashboardErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeDashboardErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeDashboardErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeDashboardErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeDashboardErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeDashboardErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeDashboardErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDashboardPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDashboardPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDashboardPermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeDashboardPermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeDashboardPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeDashboardPermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeDashboardPermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeDashboardPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeDataSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDataSetErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeDataSetErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeDataSetErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeDataSetErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeDataSetErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeDataSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataSetPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDataSetPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDataSetPermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeDataSetPermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeDataSetPermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeDataSetPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeDataSetPermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeDataSetPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataSourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDataSourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDataSourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeDataSourceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeDataSourceErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeDataSourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeDataSourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeDataSourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataSourcePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDataSourcePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDataSourcePermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeDataSourcePermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeDataSourcePermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeDataSourcePermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeDataSourcePermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeDataSourcePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeFolderErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeFolderErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeFolderErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeFolderErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeFolderErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeFolderErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DescribeFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFolderPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFolderPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeFolderPermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeFolderPermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeFolderPermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeFolderPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeFolderPermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeFolderPermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeFolderPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeFolderResolvedPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeFolderResolvedPermissionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeFolderResolvedPermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeFolderResolvedPermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeFolderResolvedPermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeFolderResolvedPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeFolderResolvedPermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeFolderResolvedPermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeFolderResolvedPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeGroupErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeGroupErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeGroupErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::DescribeGroupErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeGroupErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DescribeGroupErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeIAMPolicyAssignmentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeIAMPolicyAssignmentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeIAMPolicyAssignmentErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeIAMPolicyAssignmentErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeIAMPolicyAssignmentErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::DescribeIAMPolicyAssignmentErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeIAMPolicyAssignmentErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeIAMPolicyAssignmentErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeIAMPolicyAssignmentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeIngestionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeIngestionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeIngestionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeIngestionErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeIngestionErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeIngestionErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::DescribeIngestionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeIngestionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeIngestionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeIpRestrictionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeIpRestrictionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeIpRestrictionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeIpRestrictionErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeIpRestrictionErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeIpRestrictionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeIpRestrictionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeIpRestrictionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeNamespaceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeNamespaceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeNamespaceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeNamespaceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeNamespaceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeNamespaceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeNamespaceErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DescribeNamespaceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeNamespaceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTemplateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTemplateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeTemplateErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DescribeTemplateErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeTemplateErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeTemplateErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::DescribeTemplateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeTemplateErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeTemplateErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DescribeTemplateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTemplateAliasError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTemplateAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTemplateAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeTemplateAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeTemplateAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeTemplateAliasErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeTemplateAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTemplatePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTemplatePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeTemplatePermissionsErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::DescribeTemplatePermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeTemplatePermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeTemplatePermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeTemplatePermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeTemplatePermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeTemplatePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeThemeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeThemeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeThemeErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeThemeErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeThemeErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeThemeErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::DescribeThemeErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeThemeErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeThemeErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::DescribeThemeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeThemeAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeThemeAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeThemeAliasErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DescribeThemeAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeThemeAliasErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeThemeAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeThemeAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeThemeAliasErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeThemeAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeThemePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeThemePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeThemePermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeThemePermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::DescribeThemePermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeThemePermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeThemePermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeThemePermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::DescribeThemePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeUserErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeUserErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::DescribeUserErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeUserErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::DescribeUserErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DescribeUserErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::DescribeUserErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GenerateEmbedUrlForAnonymousUserError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GenerateEmbedUrlForAnonymousUserError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::SessionLifetimeInMinutesInvalidException(inner) => Error::SessionLifetimeInMinutesInvalidException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedPricingPlanException(inner) => Error::UnsupportedPricingPlanException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::GenerateEmbedUrlForAnonymousUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GenerateEmbedUrlForRegisteredUserError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GenerateEmbedUrlForRegisteredUserError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::QuickSightUserNotFoundException(inner) => Error::QuickSightUserNotFoundException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::SessionLifetimeInMinutesInvalidException(inner) => Error::SessionLifetimeInMinutesInvalidException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedPricingPlanException(inner) => Error::UnsupportedPricingPlanException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::GenerateEmbedUrlForRegisteredUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDashboardEmbedUrlError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDashboardEmbedUrlError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDashboardEmbedUrlErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::DomainNotWhitelistedException(inner) => Error::DomainNotWhitelistedException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::IdentityTypeNotSupportedException(inner) => Error::IdentityTypeNotSupportedException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::QuickSightUserNotFoundException(inner) => Error::QuickSightUserNotFoundException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(inner) => Error::SessionLifetimeInMinutesInvalidException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::UnsupportedPricingPlanException(inner) => Error::UnsupportedPricingPlanException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::GetDashboardEmbedUrlErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSessionEmbedUrlError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSessionEmbedUrlError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetSessionEmbedUrlErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::QuickSightUserNotFoundException(inner) => Error::QuickSightUserNotFoundException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::SessionLifetimeInMinutesInvalidException(inner) => Error::SessionLifetimeInMinutesInvalidException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::GetSessionEmbedUrlErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAnalysesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListAnalysesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAnalysesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListAnalysesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListAnalysesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListAnalysesErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::ListAnalysesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDashboardsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListDashboardsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDashboardsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListDashboardsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListDashboardsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListDashboardsErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::ListDashboardsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDashboardVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDashboardVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDashboardVersionsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListDashboardVersionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListDashboardVersionsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListDashboardVersionsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListDashboardVersionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListDashboardVersionsErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::ListDashboardVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDataSetsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListDataSetsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDataSetsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListDataSetsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListDataSetsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListDataSetsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListDataSetsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListDataSetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDataSourcesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListDataSourcesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDataSourcesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListDataSourcesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListDataSourcesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListDataSourcesErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListDataSourcesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListDataSourcesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFolderMembersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListFolderMembersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFolderMembersErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFolderMembersErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListFolderMembersErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListFolderMembersErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListFolderMembersErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListFolderMembersErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFolderMembersErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::ListFolderMembersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFoldersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListFoldersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFoldersErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFoldersErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListFoldersErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListFoldersErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListFoldersErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListFoldersErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFoldersErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::ListFoldersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGroupMembershipsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListGroupMembershipsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListGroupMembershipsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListGroupMembershipsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListGroupMembershipsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListGroupMembershipsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListGroupMembershipsErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::ListGroupMembershipsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListGroupMembershipsErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::ListGroupMembershipsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListGroupMembershipsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListGroupsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListGroupsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListGroupsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListGroupsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListGroupsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListGroupsErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::ListGroupsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListGroupsErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::ListGroupsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListIAMPolicyAssignmentsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListIAMPolicyAssignmentsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListIAMPolicyAssignmentsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListIAMPolicyAssignmentsErrorKind::InternalFailureException(
                    inner,
                ) => Error::InternalFailureException(inner),
                crate::error::ListIAMPolicyAssignmentsErrorKind::InvalidNextTokenException(
                    inner,
                ) => Error::InvalidNextTokenException(inner),
                crate::error::ListIAMPolicyAssignmentsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListIAMPolicyAssignmentsErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::ListIAMPolicyAssignmentsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListIAMPolicyAssignmentsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListIAMPolicyAssignmentsForUserError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListIAMPolicyAssignmentsForUserError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::ConcurrentUpdatingException(inner) => Error::ConcurrentUpdatingException(inner),
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListIAMPolicyAssignmentsForUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListIngestionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListIngestionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListIngestionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListIngestionsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListIngestionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListIngestionsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListIngestionsErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::ListIngestionsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListIngestionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListIngestionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListNamespacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListNamespacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListNamespacesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListNamespacesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListNamespacesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListNamespacesErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListNamespacesErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::ListNamespacesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListNamespacesErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::ListNamespacesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListNamespacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTemplateAliasesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTemplateAliasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTemplateAliasesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListTemplateAliasesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListTemplateAliasesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTemplateAliasesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListTemplateAliasesErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::ListTemplateAliasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTemplatesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTemplatesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTemplatesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListTemplatesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListTemplatesErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListTemplatesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTemplatesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListTemplatesErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::ListTemplatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTemplateVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTemplateVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTemplateVersionsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListTemplateVersionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListTemplateVersionsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListTemplateVersionsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTemplateVersionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListTemplateVersionsErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::ListTemplateVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListThemeAliasesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListThemeAliasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListThemeAliasesErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::ListThemeAliasesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListThemeAliasesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListThemeAliasesErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListThemeAliasesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListThemeAliasesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListThemeAliasesErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::ListThemeAliasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListThemesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListThemesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListThemesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListThemesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListThemesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListThemesErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListThemesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListThemesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListThemesErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::ListThemesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListThemeVersionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListThemeVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListThemeVersionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListThemeVersionsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListThemeVersionsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListThemeVersionsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListThemeVersionsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListThemeVersionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListThemeVersionsErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::ListThemeVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListUserGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListUserGroupsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListUserGroupsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListUserGroupsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListUserGroupsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListUserGroupsErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::ListUserGroupsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListUserGroupsErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::ListUserGroupsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListUserGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListUsersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListUsersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListUsersErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListUsersErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::ListUsersErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListUsersErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListUsersErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::ListUsersErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListUsersErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::ListUsersErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListUsersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RegisterUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterUserErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RegisterUserErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::RegisterUserErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::RegisterUserErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::RegisterUserErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::RegisterUserErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::RegisterUserErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::RegisterUserErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::RegisterUserErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::RegisterUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreAnalysisError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RestoreAnalysisError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RestoreAnalysisErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::RestoreAnalysisErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::RestoreAnalysisErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::RestoreAnalysisErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::RestoreAnalysisErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::RestoreAnalysisErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::RestoreAnalysisErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchAnalysesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SearchAnalysesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SearchAnalysesErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::SearchAnalysesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::SearchAnalysesErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::SearchAnalysesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::SearchAnalysesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::SearchAnalysesErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::SearchAnalysesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchDashboardsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SearchDashboardsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SearchDashboardsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::SearchDashboardsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::SearchDashboardsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::SearchDashboardsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::SearchDashboardsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::SearchDashboardsErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::SearchDashboardsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchFoldersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SearchFoldersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SearchFoldersErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SearchFoldersErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::SearchFoldersErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::SearchFoldersErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::SearchFoldersErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::SearchFoldersErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::SearchFoldersErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::SearchFoldersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::TagResourceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::TagResourceErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UntagResourceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAccountCustomizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAccountCustomizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateAccountCustomizationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateAccountCustomizationErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::UpdateAccountCustomizationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateAccountCustomizationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateAccountCustomizationErrorKind::ResourceUnavailableException(inner) => Error::ResourceUnavailableException(inner),
                crate::error::UpdateAccountCustomizationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateAccountCustomizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAccountSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAccountSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAccountSettingsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateAccountSettingsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateAccountSettingsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateAccountSettingsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateAccountSettingsErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::UpdateAccountSettingsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateAccountSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAnalysisErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateAnalysisErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateAnalysisErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateAnalysisErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::UpdateAnalysisErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateAnalysisErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateAnalysisErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::UpdateAnalysisErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAnalysisPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateAnalysisPermissionsErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::UpdateAnalysisPermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::UpdateAnalysisPermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateAnalysisPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateAnalysisPermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateAnalysisPermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::UpdateAnalysisPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDashboardError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateDashboardError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDashboardErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateDashboardErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateDashboardErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateDashboardErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateDashboardErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateDashboardErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateDashboardErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::UpdateDashboardErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDashboardPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDashboardPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDashboardPermissionsErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::UpdateDashboardPermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::UpdateDashboardPermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateDashboardPermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateDashboardPermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateDashboardPermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::UpdateDashboardPermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateDashboardPublishedVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateDashboardPublishedVersionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDashboardPublishedVersionErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::UpdateDashboardPublishedVersionErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::UpdateDashboardPublishedVersionErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateDashboardPublishedVersionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateDashboardPublishedVersionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateDashboardPublishedVersionErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::UpdateDashboardPublishedVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDataSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateDataSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDataSetErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateDataSetErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateDataSetErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateDataSetErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateDataSetErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateDataSetErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateDataSetErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateDataSetErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::UpdateDataSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDataSetPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDataSetPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDataSetPermissionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateDataSetPermissionsErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateDataSetPermissionsErrorKind::InternalFailureException(
                    inner,
                ) => Error::InternalFailureException(inner),
                crate::error::UpdateDataSetPermissionsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateDataSetPermissionsErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateDataSetPermissionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateDataSetPermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDataSourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateDataSourceErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateDataSourceErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateDataSourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateDataSourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateDataSourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateDataSourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDataSourcePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDataSourcePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDataSourcePermissionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateDataSourcePermissionsErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::UpdateDataSourcePermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::UpdateDataSourcePermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateDataSourcePermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateDataSourcePermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateDataSourcePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFolderErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateFolderErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateFolderErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateFolderErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateFolderErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::UpdateFolderErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateFolderErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateFolderErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::UpdateFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFolderPermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateFolderPermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFolderPermissionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateFolderPermissionsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateFolderPermissionsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateFolderPermissionsErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateFolderPermissionsErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateFolderPermissionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateFolderPermissionsErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::UpdateFolderPermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateGroupErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateGroupErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateGroupErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::UpdateGroupErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateGroupErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::UpdateGroupErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateIAMPolicyAssignmentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateIAMPolicyAssignmentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateIAMPolicyAssignmentErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateIAMPolicyAssignmentErrorKind::ConcurrentUpdatingException(inner) => Error::ConcurrentUpdatingException(inner),
                crate::error::UpdateIAMPolicyAssignmentErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::UpdateIAMPolicyAssignmentErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateIAMPolicyAssignmentErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::UpdateIAMPolicyAssignmentErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateIAMPolicyAssignmentErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateIAMPolicyAssignmentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateIpRestrictionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateIpRestrictionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateIpRestrictionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateIpRestrictionErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateIpRestrictionErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateIpRestrictionErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateIpRestrictionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateIpRestrictionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateIpRestrictionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTemplateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateTemplateError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTemplateErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateTemplateErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateTemplateErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateTemplateErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateTemplateErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::UpdateTemplateErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateTemplateErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateTemplateErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::UpdateTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTemplateAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateTemplateAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTemplateAliasErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateTemplateAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateTemplateAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateTemplateAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateTemplateAliasErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::UpdateTemplateAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTemplatePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateTemplatePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateTemplatePermissionsErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::UpdateTemplatePermissionsErrorKind::InternalFailureException(inner) => Error::InternalFailureException(inner),
                crate::error::UpdateTemplatePermissionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateTemplatePermissionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateTemplatePermissionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateTemplatePermissionsErrorKind::UnsupportedUserEditionException(inner) => Error::UnsupportedUserEditionException(inner),
                crate::error::UpdateTemplatePermissionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateThemeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateThemeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateThemeErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateThemeErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateThemeErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateThemeErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateThemeErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::UpdateThemeErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateThemeErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateThemeErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::UpdateThemeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateThemeAliasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateThemeAliasError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateThemeAliasErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateThemeAliasErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateThemeAliasErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateThemeAliasErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::UpdateThemeAliasErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateThemeAliasErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateThemeAliasErrorKind::UnsupportedUserEditionException(inner) => {
                    Error::UnsupportedUserEditionException(inner)
                }
                crate::error::UpdateThemeAliasErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateThemePermissionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateThemePermissionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateThemePermissionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateThemePermissionsErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateThemePermissionsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateThemePermissionsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateThemePermissionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateThemePermissionsErrorKind::UnsupportedUserEditionException(
                    inner,
                ) => Error::UnsupportedUserEditionException(inner),
                crate::error::UpdateThemePermissionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateUserErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateUserErrorKind::InternalFailureException(inner) => {
                    Error::InternalFailureException(inner)
                }
                crate::error::UpdateUserErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UpdateUserErrorKind::PreconditionNotMetException(inner) => {
                    Error::PreconditionNotMetException(inner)
                }
                crate::error::UpdateUserErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateUserErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::UpdateUserErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
