// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the page that was fetched.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FetchPageResult {
    /// <p>Contains details of the fetched page.</p>
    pub page: std::option::Option<crate::model::Page>,
    /// <p>Contains server-side performance information for the command.</p>
    pub timing_information: std::option::Option<crate::model::TimingInformation>,
    /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
    pub consumed_i_os: std::option::Option<crate::model::IoUsage>,
}
impl FetchPageResult {
    /// <p>Contains details of the fetched page.</p>
    pub fn page(&self) -> std::option::Option<&crate::model::Page> {
        self.page.as_ref()
    }
    /// <p>Contains server-side performance information for the command.</p>
    pub fn timing_information(&self) -> std::option::Option<&crate::model::TimingInformation> {
        self.timing_information.as_ref()
    }
    /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
    pub fn consumed_i_os(&self) -> std::option::Option<&crate::model::IoUsage> {
        self.consumed_i_os.as_ref()
    }
}
impl std::fmt::Debug for FetchPageResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FetchPageResult");
        formatter.field("page", &self.page);
        formatter.field("timing_information", &self.timing_information);
        formatter.field("consumed_i_os", &self.consumed_i_os);
        formatter.finish()
    }
}
/// See [`FetchPageResult`](crate::model::FetchPageResult)
pub mod fetch_page_result {
    /// A builder for [`FetchPageResult`](crate::model::FetchPageResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page: std::option::Option<crate::model::Page>,
        pub(crate) timing_information: std::option::Option<crate::model::TimingInformation>,
        pub(crate) consumed_i_os: std::option::Option<crate::model::IoUsage>,
    }
    impl Builder {
        /// <p>Contains details of the fetched page.</p>
        pub fn page(mut self, input: crate::model::Page) -> Self {
            self.page = Some(input);
            self
        }
        /// <p>Contains details of the fetched page.</p>
        pub fn set_page(mut self, input: std::option::Option<crate::model::Page>) -> Self {
            self.page = input;
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn timing_information(mut self, input: crate::model::TimingInformation) -> Self {
            self.timing_information = Some(input);
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn set_timing_information(
            mut self,
            input: std::option::Option<crate::model::TimingInformation>,
        ) -> Self {
            self.timing_information = input;
            self
        }
        /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
        pub fn consumed_i_os(mut self, input: crate::model::IoUsage) -> Self {
            self.consumed_i_os = Some(input);
            self
        }
        /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
        pub fn set_consumed_i_os(
            mut self,
            input: std::option::Option<crate::model::IoUsage>,
        ) -> Self {
            self.consumed_i_os = input;
            self
        }
        /// Consumes the builder and constructs a [`FetchPageResult`](crate::model::FetchPageResult)
        pub fn build(self) -> crate::model::FetchPageResult {
            crate::model::FetchPageResult {
                page: self.page,
                timing_information: self.timing_information,
                consumed_i_os: self.consumed_i_os,
            }
        }
    }
}
impl FetchPageResult {
    /// Creates a new builder-style object to manufacture [`FetchPageResult`](crate::model::FetchPageResult)
    pub fn builder() -> crate::model::fetch_page_result::Builder {
        crate::model::fetch_page_result::Builder::default()
    }
}

/// <p>Contains I/O usage metrics for a command that was invoked.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IoUsage {
    /// <p>The number of read I/O requests that the command made.</p>
    pub read_i_os: i64,
    /// <p>The number of write I/O requests that the command made.</p>
    pub write_i_os: i64,
}
impl IoUsage {
    /// <p>The number of read I/O requests that the command made.</p>
    pub fn read_i_os(&self) -> i64 {
        self.read_i_os
    }
    /// <p>The number of write I/O requests that the command made.</p>
    pub fn write_i_os(&self) -> i64 {
        self.write_i_os
    }
}
impl std::fmt::Debug for IoUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IoUsage");
        formatter.field("read_i_os", &self.read_i_os);
        formatter.field("write_i_os", &self.write_i_os);
        formatter.finish()
    }
}
/// See [`IoUsage`](crate::model::IoUsage)
pub mod io_usage {
    /// A builder for [`IoUsage`](crate::model::IoUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) read_i_os: std::option::Option<i64>,
        pub(crate) write_i_os: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of read I/O requests that the command made.</p>
        pub fn read_i_os(mut self, input: i64) -> Self {
            self.read_i_os = Some(input);
            self
        }
        /// <p>The number of read I/O requests that the command made.</p>
        pub fn set_read_i_os(mut self, input: std::option::Option<i64>) -> Self {
            self.read_i_os = input;
            self
        }
        /// <p>The number of write I/O requests that the command made.</p>
        pub fn write_i_os(mut self, input: i64) -> Self {
            self.write_i_os = Some(input);
            self
        }
        /// <p>The number of write I/O requests that the command made.</p>
        pub fn set_write_i_os(mut self, input: std::option::Option<i64>) -> Self {
            self.write_i_os = input;
            self
        }
        /// Consumes the builder and constructs a [`IoUsage`](crate::model::IoUsage)
        pub fn build(self) -> crate::model::IoUsage {
            crate::model::IoUsage {
                read_i_os: self.read_i_os.unwrap_or_default(),
                write_i_os: self.write_i_os.unwrap_or_default(),
            }
        }
    }
}
impl IoUsage {
    /// Creates a new builder-style object to manufacture [`IoUsage`](crate::model::IoUsage)
    pub fn builder() -> crate::model::io_usage::Builder {
        crate::model::io_usage::Builder::default()
    }
}

/// <p>Contains server-side performance information for a command. Amazon QLDB captures timing information between the times when it receives the request and when it sends the corresponding response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimingInformation {
    /// <p>The amount of time that QLDB spent on processing the command, measured in milliseconds.</p>
    pub processing_time_milliseconds: i64,
}
impl TimingInformation {
    /// <p>The amount of time that QLDB spent on processing the command, measured in milliseconds.</p>
    pub fn processing_time_milliseconds(&self) -> i64 {
        self.processing_time_milliseconds
    }
}
impl std::fmt::Debug for TimingInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimingInformation");
        formatter.field(
            "processing_time_milliseconds",
            &self.processing_time_milliseconds,
        );
        formatter.finish()
    }
}
/// See [`TimingInformation`](crate::model::TimingInformation)
pub mod timing_information {
    /// A builder for [`TimingInformation`](crate::model::TimingInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) processing_time_milliseconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The amount of time that QLDB spent on processing the command, measured in milliseconds.</p>
        pub fn processing_time_milliseconds(mut self, input: i64) -> Self {
            self.processing_time_milliseconds = Some(input);
            self
        }
        /// <p>The amount of time that QLDB spent on processing the command, measured in milliseconds.</p>
        pub fn set_processing_time_milliseconds(mut self, input: std::option::Option<i64>) -> Self {
            self.processing_time_milliseconds = input;
            self
        }
        /// Consumes the builder and constructs a [`TimingInformation`](crate::model::TimingInformation)
        pub fn build(self) -> crate::model::TimingInformation {
            crate::model::TimingInformation {
                processing_time_milliseconds: self.processing_time_milliseconds.unwrap_or_default(),
            }
        }
    }
}
impl TimingInformation {
    /// Creates a new builder-style object to manufacture [`TimingInformation`](crate::model::TimingInformation)
    pub fn builder() -> crate::model::timing_information::Builder {
        crate::model::timing_information::Builder::default()
    }
}

/// <p>Contains details of the fetched page.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Page {
    /// <p>A structure that contains values in multiple encoding formats.</p>
    pub values: std::option::Option<std::vec::Vec<crate::model::ValueHolder>>,
    /// <p>The token of the next page.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl Page {
    /// <p>A structure that contains values in multiple encoding formats.</p>
    pub fn values(&self) -> std::option::Option<&[crate::model::ValueHolder]> {
        self.values.as_deref()
    }
    /// <p>The token of the next page.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for Page {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Page");
        formatter.field("values", &self.values);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`Page`](crate::model::Page)
pub mod page {
    /// A builder for [`Page`](crate::model::Page)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) values: std::option::Option<std::vec::Vec<crate::model::ValueHolder>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A structure that contains values in multiple encoding formats.</p>
        pub fn values(mut self, input: crate::model::ValueHolder) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input);
            self.values = Some(v);
            self
        }
        /// <p>A structure that contains values in multiple encoding formats.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValueHolder>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The token of the next page.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token of the next page.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`Page`](crate::model::Page)
        pub fn build(self) -> crate::model::Page {
            crate::model::Page {
                values: self.values,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl Page {
    /// Creates a new builder-style object to manufacture [`Page`](crate::model::Page)
    pub fn builder() -> crate::model::page::Builder {
        crate::model::page::Builder::default()
    }
}

/// <p>A structure that can contain a value in multiple encoding formats.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValueHolder {
    /// <p>An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.</p>
    pub ion_binary: std::option::Option<aws_smithy_types::Blob>,
    /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
    pub ion_text: std::option::Option<std::string::String>,
}
impl ValueHolder {
    /// <p>An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.</p>
    pub fn ion_binary(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.ion_binary.as_ref()
    }
    /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
    pub fn ion_text(&self) -> std::option::Option<&str> {
        self.ion_text.as_deref()
    }
}
impl std::fmt::Debug for ValueHolder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValueHolder");
        formatter.field("ion_binary", &self.ion_binary);
        formatter.field("ion_text", &self.ion_text);
        formatter.finish()
    }
}
/// See [`ValueHolder`](crate::model::ValueHolder)
pub mod value_holder {
    /// A builder for [`ValueHolder`](crate::model::ValueHolder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ion_binary: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) ion_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.</p>
        pub fn ion_binary(mut self, input: aws_smithy_types::Blob) -> Self {
            self.ion_binary = Some(input);
            self
        }
        /// <p>An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.</p>
        pub fn set_ion_binary(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.ion_binary = input;
            self
        }
        /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
        pub fn ion_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.ion_text = Some(input.into());
            self
        }
        /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
        pub fn set_ion_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ion_text = input;
            self
        }
        /// Consumes the builder and constructs a [`ValueHolder`](crate::model::ValueHolder)
        pub fn build(self) -> crate::model::ValueHolder {
            crate::model::ValueHolder {
                ion_binary: self.ion_binary,
                ion_text: self.ion_text,
            }
        }
    }
}
impl ValueHolder {
    /// Creates a new builder-style object to manufacture [`ValueHolder`](crate::model::ValueHolder)
    pub fn builder() -> crate::model::value_holder::Builder {
        crate::model::value_holder::Builder::default()
    }
}

/// <p>Contains the details of the executed statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementResult {
    /// <p>Contains the details of the first fetched page.</p>
    pub first_page: std::option::Option<crate::model::Page>,
    /// <p>Contains server-side performance information for the command.</p>
    pub timing_information: std::option::Option<crate::model::TimingInformation>,
    /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
    pub consumed_i_os: std::option::Option<crate::model::IoUsage>,
}
impl ExecuteStatementResult {
    /// <p>Contains the details of the first fetched page.</p>
    pub fn first_page(&self) -> std::option::Option<&crate::model::Page> {
        self.first_page.as_ref()
    }
    /// <p>Contains server-side performance information for the command.</p>
    pub fn timing_information(&self) -> std::option::Option<&crate::model::TimingInformation> {
        self.timing_information.as_ref()
    }
    /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
    pub fn consumed_i_os(&self) -> std::option::Option<&crate::model::IoUsage> {
        self.consumed_i_os.as_ref()
    }
}
impl std::fmt::Debug for ExecuteStatementResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementResult");
        formatter.field("first_page", &self.first_page);
        formatter.field("timing_information", &self.timing_information);
        formatter.field("consumed_i_os", &self.consumed_i_os);
        formatter.finish()
    }
}
/// See [`ExecuteStatementResult`](crate::model::ExecuteStatementResult)
pub mod execute_statement_result {
    /// A builder for [`ExecuteStatementResult`](crate::model::ExecuteStatementResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) first_page: std::option::Option<crate::model::Page>,
        pub(crate) timing_information: std::option::Option<crate::model::TimingInformation>,
        pub(crate) consumed_i_os: std::option::Option<crate::model::IoUsage>,
    }
    impl Builder {
        /// <p>Contains the details of the first fetched page.</p>
        pub fn first_page(mut self, input: crate::model::Page) -> Self {
            self.first_page = Some(input);
            self
        }
        /// <p>Contains the details of the first fetched page.</p>
        pub fn set_first_page(mut self, input: std::option::Option<crate::model::Page>) -> Self {
            self.first_page = input;
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn timing_information(mut self, input: crate::model::TimingInformation) -> Self {
            self.timing_information = Some(input);
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn set_timing_information(
            mut self,
            input: std::option::Option<crate::model::TimingInformation>,
        ) -> Self {
            self.timing_information = input;
            self
        }
        /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
        pub fn consumed_i_os(mut self, input: crate::model::IoUsage) -> Self {
            self.consumed_i_os = Some(input);
            self
        }
        /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
        pub fn set_consumed_i_os(
            mut self,
            input: std::option::Option<crate::model::IoUsage>,
        ) -> Self {
            self.consumed_i_os = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementResult`](crate::model::ExecuteStatementResult)
        pub fn build(self) -> crate::model::ExecuteStatementResult {
            crate::model::ExecuteStatementResult {
                first_page: self.first_page,
                timing_information: self.timing_information,
                consumed_i_os: self.consumed_i_os,
            }
        }
    }
}
impl ExecuteStatementResult {
    /// Creates a new builder-style object to manufacture [`ExecuteStatementResult`](crate::model::ExecuteStatementResult)
    pub fn builder() -> crate::model::execute_statement_result::Builder {
        crate::model::execute_statement_result::Builder::default()
    }
}

/// <p>Contains the details of the aborted transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortTransactionResult {
    /// <p>Contains server-side performance information for the command.</p>
    pub timing_information: std::option::Option<crate::model::TimingInformation>,
}
impl AbortTransactionResult {
    /// <p>Contains server-side performance information for the command.</p>
    pub fn timing_information(&self) -> std::option::Option<&crate::model::TimingInformation> {
        self.timing_information.as_ref()
    }
}
impl std::fmt::Debug for AbortTransactionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortTransactionResult");
        formatter.field("timing_information", &self.timing_information);
        formatter.finish()
    }
}
/// See [`AbortTransactionResult`](crate::model::AbortTransactionResult)
pub mod abort_transaction_result {
    /// A builder for [`AbortTransactionResult`](crate::model::AbortTransactionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timing_information: std::option::Option<crate::model::TimingInformation>,
    }
    impl Builder {
        /// <p>Contains server-side performance information for the command.</p>
        pub fn timing_information(mut self, input: crate::model::TimingInformation) -> Self {
            self.timing_information = Some(input);
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn set_timing_information(
            mut self,
            input: std::option::Option<crate::model::TimingInformation>,
        ) -> Self {
            self.timing_information = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortTransactionResult`](crate::model::AbortTransactionResult)
        pub fn build(self) -> crate::model::AbortTransactionResult {
            crate::model::AbortTransactionResult {
                timing_information: self.timing_information,
            }
        }
    }
}
impl AbortTransactionResult {
    /// Creates a new builder-style object to manufacture [`AbortTransactionResult`](crate::model::AbortTransactionResult)
    pub fn builder() -> crate::model::abort_transaction_result::Builder {
        crate::model::abort_transaction_result::Builder::default()
    }
}

/// <p>Contains the details of the committed transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommitTransactionResult {
    /// <p>The transaction ID of the committed transaction.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>The commit digest of the committed transaction.</p>
    pub commit_digest: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Contains server-side performance information for the command.</p>
    pub timing_information: std::option::Option<crate::model::TimingInformation>,
    /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
    pub consumed_i_os: std::option::Option<crate::model::IoUsage>,
}
impl CommitTransactionResult {
    /// <p>The transaction ID of the committed transaction.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>The commit digest of the committed transaction.</p>
    pub fn commit_digest(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.commit_digest.as_ref()
    }
    /// <p>Contains server-side performance information for the command.</p>
    pub fn timing_information(&self) -> std::option::Option<&crate::model::TimingInformation> {
        self.timing_information.as_ref()
    }
    /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
    pub fn consumed_i_os(&self) -> std::option::Option<&crate::model::IoUsage> {
        self.consumed_i_os.as_ref()
    }
}
impl std::fmt::Debug for CommitTransactionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommitTransactionResult");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("commit_digest", &self.commit_digest);
        formatter.field("timing_information", &self.timing_information);
        formatter.field("consumed_i_os", &self.consumed_i_os);
        formatter.finish()
    }
}
/// See [`CommitTransactionResult`](crate::model::CommitTransactionResult)
pub mod commit_transaction_result {
    /// A builder for [`CommitTransactionResult`](crate::model::CommitTransactionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) commit_digest: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) timing_information: std::option::Option<crate::model::TimingInformation>,
        pub(crate) consumed_i_os: std::option::Option<crate::model::IoUsage>,
    }
    impl Builder {
        /// <p>The transaction ID of the committed transaction.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction ID of the committed transaction.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>The commit digest of the committed transaction.</p>
        pub fn commit_digest(mut self, input: aws_smithy_types::Blob) -> Self {
            self.commit_digest = Some(input);
            self
        }
        /// <p>The commit digest of the committed transaction.</p>
        pub fn set_commit_digest(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.commit_digest = input;
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn timing_information(mut self, input: crate::model::TimingInformation) -> Self {
            self.timing_information = Some(input);
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn set_timing_information(
            mut self,
            input: std::option::Option<crate::model::TimingInformation>,
        ) -> Self {
            self.timing_information = input;
            self
        }
        /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
        pub fn consumed_i_os(mut self, input: crate::model::IoUsage) -> Self {
            self.consumed_i_os = Some(input);
            self
        }
        /// <p>Contains metrics about the number of I/O requests that were consumed.</p>
        pub fn set_consumed_i_os(
            mut self,
            input: std::option::Option<crate::model::IoUsage>,
        ) -> Self {
            self.consumed_i_os = input;
            self
        }
        /// Consumes the builder and constructs a [`CommitTransactionResult`](crate::model::CommitTransactionResult)
        pub fn build(self) -> crate::model::CommitTransactionResult {
            crate::model::CommitTransactionResult {
                transaction_id: self.transaction_id,
                commit_digest: self.commit_digest,
                timing_information: self.timing_information,
                consumed_i_os: self.consumed_i_os,
            }
        }
    }
}
impl CommitTransactionResult {
    /// Creates a new builder-style object to manufacture [`CommitTransactionResult`](crate::model::CommitTransactionResult)
    pub fn builder() -> crate::model::commit_transaction_result::Builder {
        crate::model::commit_transaction_result::Builder::default()
    }
}

/// <p>Contains the details of the ended session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndSessionResult {
    /// <p>Contains server-side performance information for the command.</p>
    pub timing_information: std::option::Option<crate::model::TimingInformation>,
}
impl EndSessionResult {
    /// <p>Contains server-side performance information for the command.</p>
    pub fn timing_information(&self) -> std::option::Option<&crate::model::TimingInformation> {
        self.timing_information.as_ref()
    }
}
impl std::fmt::Debug for EndSessionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndSessionResult");
        formatter.field("timing_information", &self.timing_information);
        formatter.finish()
    }
}
/// See [`EndSessionResult`](crate::model::EndSessionResult)
pub mod end_session_result {
    /// A builder for [`EndSessionResult`](crate::model::EndSessionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timing_information: std::option::Option<crate::model::TimingInformation>,
    }
    impl Builder {
        /// <p>Contains server-side performance information for the command.</p>
        pub fn timing_information(mut self, input: crate::model::TimingInformation) -> Self {
            self.timing_information = Some(input);
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn set_timing_information(
            mut self,
            input: std::option::Option<crate::model::TimingInformation>,
        ) -> Self {
            self.timing_information = input;
            self
        }
        /// Consumes the builder and constructs a [`EndSessionResult`](crate::model::EndSessionResult)
        pub fn build(self) -> crate::model::EndSessionResult {
            crate::model::EndSessionResult {
                timing_information: self.timing_information,
            }
        }
    }
}
impl EndSessionResult {
    /// Creates a new builder-style object to manufacture [`EndSessionResult`](crate::model::EndSessionResult)
    pub fn builder() -> crate::model::end_session_result::Builder {
        crate::model::end_session_result::Builder::default()
    }
}

/// <p>Contains the details of the started transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTransactionResult {
    /// <p>The transaction ID of the started transaction.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>Contains server-side performance information for the command.</p>
    pub timing_information: std::option::Option<crate::model::TimingInformation>,
}
impl StartTransactionResult {
    /// <p>The transaction ID of the started transaction.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>Contains server-side performance information for the command.</p>
    pub fn timing_information(&self) -> std::option::Option<&crate::model::TimingInformation> {
        self.timing_information.as_ref()
    }
}
impl std::fmt::Debug for StartTransactionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTransactionResult");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("timing_information", &self.timing_information);
        formatter.finish()
    }
}
/// See [`StartTransactionResult`](crate::model::StartTransactionResult)
pub mod start_transaction_result {
    /// A builder for [`StartTransactionResult`](crate::model::StartTransactionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) timing_information: std::option::Option<crate::model::TimingInformation>,
    }
    impl Builder {
        /// <p>The transaction ID of the started transaction.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The transaction ID of the started transaction.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn timing_information(mut self, input: crate::model::TimingInformation) -> Self {
            self.timing_information = Some(input);
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn set_timing_information(
            mut self,
            input: std::option::Option<crate::model::TimingInformation>,
        ) -> Self {
            self.timing_information = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTransactionResult`](crate::model::StartTransactionResult)
        pub fn build(self) -> crate::model::StartTransactionResult {
            crate::model::StartTransactionResult {
                transaction_id: self.transaction_id,
                timing_information: self.timing_information,
            }
        }
    }
}
impl StartTransactionResult {
    /// Creates a new builder-style object to manufacture [`StartTransactionResult`](crate::model::StartTransactionResult)
    pub fn builder() -> crate::model::start_transaction_result::Builder {
        crate::model::start_transaction_result::Builder::default()
    }
}

/// <p>Contains the details of the started session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSessionResult {
    /// <p>Session token of the started session. This <code>SessionToken</code> is required for every subsequent command that is issued during the current session.</p>
    pub session_token: std::option::Option<std::string::String>,
    /// <p>Contains server-side performance information for the command.</p>
    pub timing_information: std::option::Option<crate::model::TimingInformation>,
}
impl StartSessionResult {
    /// <p>Session token of the started session. This <code>SessionToken</code> is required for every subsequent command that is issued during the current session.</p>
    pub fn session_token(&self) -> std::option::Option<&str> {
        self.session_token.as_deref()
    }
    /// <p>Contains server-side performance information for the command.</p>
    pub fn timing_information(&self) -> std::option::Option<&crate::model::TimingInformation> {
        self.timing_information.as_ref()
    }
}
impl std::fmt::Debug for StartSessionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSessionResult");
        formatter.field("session_token", &self.session_token);
        formatter.field("timing_information", &self.timing_information);
        formatter.finish()
    }
}
/// See [`StartSessionResult`](crate::model::StartSessionResult)
pub mod start_session_result {
    /// A builder for [`StartSessionResult`](crate::model::StartSessionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_token: std::option::Option<std::string::String>,
        pub(crate) timing_information: std::option::Option<crate::model::TimingInformation>,
    }
    impl Builder {
        /// <p>Session token of the started session. This <code>SessionToken</code> is required for every subsequent command that is issued during the current session.</p>
        pub fn session_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_token = Some(input.into());
            self
        }
        /// <p>Session token of the started session. This <code>SessionToken</code> is required for every subsequent command that is issued during the current session.</p>
        pub fn set_session_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_token = input;
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn timing_information(mut self, input: crate::model::TimingInformation) -> Self {
            self.timing_information = Some(input);
            self
        }
        /// <p>Contains server-side performance information for the command.</p>
        pub fn set_timing_information(
            mut self,
            input: std::option::Option<crate::model::TimingInformation>,
        ) -> Self {
            self.timing_information = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSessionResult`](crate::model::StartSessionResult)
        pub fn build(self) -> crate::model::StartSessionResult {
            crate::model::StartSessionResult {
                session_token: self.session_token,
                timing_information: self.timing_information,
            }
        }
    }
}
impl StartSessionResult {
    /// Creates a new builder-style object to manufacture [`StartSessionResult`](crate::model::StartSessionResult)
    pub fn builder() -> crate::model::start_session_result::Builder {
        crate::model::start_session_result::Builder::default()
    }
}

/// <p>Specifies the details of the page to be fetched.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FetchPageRequest {
    /// <p>Specifies the transaction ID of the page to be fetched.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>Specifies the next page token of the page to be fetched.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl FetchPageRequest {
    /// <p>Specifies the transaction ID of the page to be fetched.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>Specifies the next page token of the page to be fetched.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for FetchPageRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FetchPageRequest");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`FetchPageRequest`](crate::model::FetchPageRequest)
pub mod fetch_page_request {
    /// A builder for [`FetchPageRequest`](crate::model::FetchPageRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the transaction ID of the page to be fetched.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>Specifies the transaction ID of the page to be fetched.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>Specifies the next page token of the page to be fetched.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>Specifies the next page token of the page to be fetched.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`FetchPageRequest`](crate::model::FetchPageRequest)
        pub fn build(self) -> crate::model::FetchPageRequest {
            crate::model::FetchPageRequest {
                transaction_id: self.transaction_id,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl FetchPageRequest {
    /// Creates a new builder-style object to manufacture [`FetchPageRequest`](crate::model::FetchPageRequest)
    pub fn builder() -> crate::model::fetch_page_request::Builder {
        crate::model::fetch_page_request::Builder::default()
    }
}

/// <p>Specifies a request to execute a statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementRequest {
    /// <p>Specifies the transaction ID of the request.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>Specifies the statement of the request.</p>
    pub statement: std::option::Option<std::string::String>,
    /// <p>Specifies the parameters for the parameterized statement in the request.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::ValueHolder>>,
}
impl ExecuteStatementRequest {
    /// <p>Specifies the transaction ID of the request.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>Specifies the statement of the request.</p>
    pub fn statement(&self) -> std::option::Option<&str> {
        self.statement.as_deref()
    }
    /// <p>Specifies the parameters for the parameterized statement in the request.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::ValueHolder]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for ExecuteStatementRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementRequest");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("statement", &self.statement);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`ExecuteStatementRequest`](crate::model::ExecuteStatementRequest)
pub mod execute_statement_request {
    /// A builder for [`ExecuteStatementRequest`](crate::model::ExecuteStatementRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) statement: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::ValueHolder>>,
    }
    impl Builder {
        /// <p>Specifies the transaction ID of the request.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>Specifies the transaction ID of the request.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>Specifies the statement of the request.</p>
        pub fn statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement = Some(input.into());
            self
        }
        /// <p>Specifies the statement of the request.</p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Specifies the parameters for the parameterized statement in the request.</p>
        pub fn parameters(mut self, input: crate::model::ValueHolder) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>Specifies the parameters for the parameterized statement in the request.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValueHolder>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementRequest`](crate::model::ExecuteStatementRequest)
        pub fn build(self) -> crate::model::ExecuteStatementRequest {
            crate::model::ExecuteStatementRequest {
                transaction_id: self.transaction_id,
                statement: self.statement,
                parameters: self.parameters,
            }
        }
    }
}
impl ExecuteStatementRequest {
    /// Creates a new builder-style object to manufacture [`ExecuteStatementRequest`](crate::model::ExecuteStatementRequest)
    pub fn builder() -> crate::model::execute_statement_request::Builder {
        crate::model::execute_statement_request::Builder::default()
    }
}

/// <p>Contains the details of the transaction to abort.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortTransactionRequest {}
impl std::fmt::Debug for AbortTransactionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortTransactionRequest");
        formatter.finish()
    }
}
/// See [`AbortTransactionRequest`](crate::model::AbortTransactionRequest)
pub mod abort_transaction_request {
    /// A builder for [`AbortTransactionRequest`](crate::model::AbortTransactionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AbortTransactionRequest`](crate::model::AbortTransactionRequest)
        pub fn build(self) -> crate::model::AbortTransactionRequest {
            crate::model::AbortTransactionRequest {}
        }
    }
}
impl AbortTransactionRequest {
    /// Creates a new builder-style object to manufacture [`AbortTransactionRequest`](crate::model::AbortTransactionRequest)
    pub fn builder() -> crate::model::abort_transaction_request::Builder {
        crate::model::abort_transaction_request::Builder::default()
    }
}

/// <p>Contains the details of the transaction to commit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommitTransactionRequest {
    /// <p>Specifies the transaction ID of the transaction to commit.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>Specifies the commit digest for the transaction to commit. For every active transaction, the commit digest must be passed. QLDB validates <code>CommitDigest</code> and rejects the commit with an error if the digest computed on the client does not match the digest computed by QLDB.</p>
    /// <p>The purpose of the <code>CommitDigest</code> parameter is to ensure that QLDB commits a transaction if and only if the server has processed the exact set of statements sent by the client, in the same order that client sent them, and with no duplicates.</p>
    pub commit_digest: std::option::Option<aws_smithy_types::Blob>,
}
impl CommitTransactionRequest {
    /// <p>Specifies the transaction ID of the transaction to commit.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>Specifies the commit digest for the transaction to commit. For every active transaction, the commit digest must be passed. QLDB validates <code>CommitDigest</code> and rejects the commit with an error if the digest computed on the client does not match the digest computed by QLDB.</p>
    /// <p>The purpose of the <code>CommitDigest</code> parameter is to ensure that QLDB commits a transaction if and only if the server has processed the exact set of statements sent by the client, in the same order that client sent them, and with no duplicates.</p>
    pub fn commit_digest(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.commit_digest.as_ref()
    }
}
impl std::fmt::Debug for CommitTransactionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommitTransactionRequest");
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("commit_digest", &self.commit_digest);
        formatter.finish()
    }
}
/// See [`CommitTransactionRequest`](crate::model::CommitTransactionRequest)
pub mod commit_transaction_request {
    /// A builder for [`CommitTransactionRequest`](crate::model::CommitTransactionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) commit_digest: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>Specifies the transaction ID of the transaction to commit.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>Specifies the transaction ID of the transaction to commit.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>Specifies the commit digest for the transaction to commit. For every active transaction, the commit digest must be passed. QLDB validates <code>CommitDigest</code> and rejects the commit with an error if the digest computed on the client does not match the digest computed by QLDB.</p>
        /// <p>The purpose of the <code>CommitDigest</code> parameter is to ensure that QLDB commits a transaction if and only if the server has processed the exact set of statements sent by the client, in the same order that client sent them, and with no duplicates.</p>
        pub fn commit_digest(mut self, input: aws_smithy_types::Blob) -> Self {
            self.commit_digest = Some(input);
            self
        }
        /// <p>Specifies the commit digest for the transaction to commit. For every active transaction, the commit digest must be passed. QLDB validates <code>CommitDigest</code> and rejects the commit with an error if the digest computed on the client does not match the digest computed by QLDB.</p>
        /// <p>The purpose of the <code>CommitDigest</code> parameter is to ensure that QLDB commits a transaction if and only if the server has processed the exact set of statements sent by the client, in the same order that client sent them, and with no duplicates.</p>
        pub fn set_commit_digest(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.commit_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`CommitTransactionRequest`](crate::model::CommitTransactionRequest)
        pub fn build(self) -> crate::model::CommitTransactionRequest {
            crate::model::CommitTransactionRequest {
                transaction_id: self.transaction_id,
                commit_digest: self.commit_digest,
            }
        }
    }
}
impl CommitTransactionRequest {
    /// Creates a new builder-style object to manufacture [`CommitTransactionRequest`](crate::model::CommitTransactionRequest)
    pub fn builder() -> crate::model::commit_transaction_request::Builder {
        crate::model::commit_transaction_request::Builder::default()
    }
}

/// <p>Specifies a request to end the session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndSessionRequest {}
impl std::fmt::Debug for EndSessionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndSessionRequest");
        formatter.finish()
    }
}
/// See [`EndSessionRequest`](crate::model::EndSessionRequest)
pub mod end_session_request {
    /// A builder for [`EndSessionRequest`](crate::model::EndSessionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EndSessionRequest`](crate::model::EndSessionRequest)
        pub fn build(self) -> crate::model::EndSessionRequest {
            crate::model::EndSessionRequest {}
        }
    }
}
impl EndSessionRequest {
    /// Creates a new builder-style object to manufacture [`EndSessionRequest`](crate::model::EndSessionRequest)
    pub fn builder() -> crate::model::end_session_request::Builder {
        crate::model::end_session_request::Builder::default()
    }
}

/// <p>Specifies a request to start a transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTransactionRequest {}
impl std::fmt::Debug for StartTransactionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTransactionRequest");
        formatter.finish()
    }
}
/// See [`StartTransactionRequest`](crate::model::StartTransactionRequest)
pub mod start_transaction_request {
    /// A builder for [`StartTransactionRequest`](crate::model::StartTransactionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartTransactionRequest`](crate::model::StartTransactionRequest)
        pub fn build(self) -> crate::model::StartTransactionRequest {
            crate::model::StartTransactionRequest {}
        }
    }
}
impl StartTransactionRequest {
    /// Creates a new builder-style object to manufacture [`StartTransactionRequest`](crate::model::StartTransactionRequest)
    pub fn builder() -> crate::model::start_transaction_request::Builder {
        crate::model::start_transaction_request::Builder::default()
    }
}

/// <p>Specifies a request to start a new session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSessionRequest {
    /// <p>The name of the ledger to start a new session against.</p>
    pub ledger_name: std::option::Option<std::string::String>,
}
impl StartSessionRequest {
    /// <p>The name of the ledger to start a new session against.</p>
    pub fn ledger_name(&self) -> std::option::Option<&str> {
        self.ledger_name.as_deref()
    }
}
impl std::fmt::Debug for StartSessionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSessionRequest");
        formatter.field("ledger_name", &self.ledger_name);
        formatter.finish()
    }
}
/// See [`StartSessionRequest`](crate::model::StartSessionRequest)
pub mod start_session_request {
    /// A builder for [`StartSessionRequest`](crate::model::StartSessionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ledger_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger to start a new session against.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ledger_name = Some(input.into());
            self
        }
        /// <p>The name of the ledger to start a new session against.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ledger_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSessionRequest`](crate::model::StartSessionRequest)
        pub fn build(self) -> crate::model::StartSessionRequest {
            crate::model::StartSessionRequest {
                ledger_name: self.ledger_name,
            }
        }
    }
}
impl StartSessionRequest {
    /// Creates a new builder-style object to manufacture [`StartSessionRequest`](crate::model::StartSessionRequest)
    pub fn builder() -> crate::model::start_session_request::Builder {
        crate::model::start_session_request::Builder::default()
    }
}
