// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `SendCommand`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_command`](crate::client::Client::send_command).
///
/// See [`crate::client::fluent_builders::SendCommand`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendCommand {
    _private: (),
}
impl SendCommand {
    /// Creates a new builder-style object to manufacture [`SendCommandInput`](crate::input::SendCommandInput)
    pub fn builder() -> crate::input::send_command_input::Builder {
        crate::input::send_command_input::Builder::default()
    }
    /// Creates a new `SendCommand` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendCommand {
    type Output =
        std::result::Result<crate::output::SendCommandOutput, crate::error::SendCommandError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_command_error(response)
        } else {
            crate::operation_deser::parse_send_command_response(response)
        }
    }
}
