// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon QLDB
///
/// Client for invoking operations on Amazon QLDB. Each operation on Amazon QLDB is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_qldb::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_qldb::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_qldb::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CancelJournalKinesisStream`](crate::client::fluent_builders::CancelJournalKinesisStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ledger_name(impl Into<String>)`](crate::client::fluent_builders::CancelJournalKinesisStream::ledger_name) / [`set_ledger_name(Option<String>)`](crate::client::fluent_builders::CancelJournalKinesisStream::set_ledger_name): <p>The name of the ledger.</p>
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::CancelJournalKinesisStream::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::CancelJournalKinesisStream::set_stream_id): <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be canceled.</p>
    /// - On success, responds with [`CancelJournalKinesisStreamOutput`](crate::output::CancelJournalKinesisStreamOutput) with field(s):
    ///   - [`stream_id(Option<String>)`](crate::output::CancelJournalKinesisStreamOutput::stream_id): <p>The UUID (Base62-encoded text) of the canceled QLDB journal stream.</p>
    /// - On failure, responds with [`SdkError<CancelJournalKinesisStreamError>`](crate::error::CancelJournalKinesisStreamError)
    pub fn cancel_journal_kinesis_stream(
        &self,
    ) -> fluent_builders::CancelJournalKinesisStream<C, M, R> {
        fluent_builders::CancelJournalKinesisStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLedger`](crate::client::fluent_builders::CreateLedger) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateLedger::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateLedger::set_name): <p>The name of the ledger that you want to create. The name must be unique among all of the ledgers in your Amazon Web Services account in the current Region.</p>  <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    ///   - [`tags(HashMap<String, Option<String>>)`](crate::client::fluent_builders::CreateLedger::tags) / [`set_tags(Option<HashMap<String, Option<String>>>)`](crate::client::fluent_builders::CreateLedger::set_tags): <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.</p>
    ///   - [`permissions_mode(PermissionsMode)`](crate::client::fluent_builders::CreateLedger::permissions_mode) / [`set_permissions_mode(Option<PermissionsMode>)`](crate::client::fluent_builders::CreateLedger::set_permissions_mode): <p>The permissions mode to assign to the ledger that you want to create. This parameter can have one of the following values:</p>  <ul>   <li> <p> <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for ledgers.</p> <p>This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.</p> </li>   <li> <p> <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</p> <p>By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.</p> </li>  </ul> <note>   <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.</p>  </note>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::CreateLedger::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::CreateLedger::set_deletion_protection): <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>  <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::CreateLedger::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::CreateLedger::set_kms_key): <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>  <p>Use one of the following options to specify this parameter:</p>  <ul>   <li> <p> <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.</p> </li>   <li> <p> <b>Undefined</b>: By default, use an Amazon Web Services owned KMS key.</p> </li>   <li> <p> <b>A valid symmetric customer managed KMS key</b>: Use the specified KMS key in your account that you create, own, and manage.</p> <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>  </ul>  <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`CreateLedgerOutput`](crate::output::CreateLedgerOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateLedgerOutput::name): <p>The name of the ledger.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateLedgerOutput::arn): <p>The Amazon Resource Name (ARN) for the ledger.</p>
    ///   - [`state(Option<LedgerState>)`](crate::output::CreateLedgerOutput::state): <p>The current status of the ledger.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateLedgerOutput::creation_date_time): <p>The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
    ///   - [`permissions_mode(Option<PermissionsMode>)`](crate::output::CreateLedgerOutput::permissions_mode): <p>The permissions mode of the ledger that you created.</p>
    ///   - [`deletion_protection(Option<bool>)`](crate::output::CreateLedgerOutput::deletion_protection): <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>  <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::CreateLedgerOutput::kms_key_arn): <p>The ARN of the customer managed KMS key that the ledger uses for encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.</p>
    /// - On failure, responds with [`SdkError<CreateLedgerError>`](crate::error::CreateLedgerError)
    pub fn create_ledger(&self) -> fluent_builders::CreateLedger<C, M, R> {
        fluent_builders::CreateLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLedger`](crate::client::fluent_builders::DeleteLedger) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteLedger::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteLedger::set_name): <p>The name of the ledger that you want to delete.</p>
    /// - On success, responds with [`DeleteLedgerOutput`](crate::output::DeleteLedgerOutput)

    /// - On failure, responds with [`SdkError<DeleteLedgerError>`](crate::error::DeleteLedgerError)
    pub fn delete_ledger(&self) -> fluent_builders::DeleteLedger<C, M, R> {
        fluent_builders::DeleteLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJournalKinesisStream`](crate::client::fluent_builders::DescribeJournalKinesisStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ledger_name(impl Into<String>)`](crate::client::fluent_builders::DescribeJournalKinesisStream::ledger_name) / [`set_ledger_name(Option<String>)`](crate::client::fluent_builders::DescribeJournalKinesisStream::set_ledger_name): <p>The name of the ledger.</p>
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJournalKinesisStream::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::DescribeJournalKinesisStream::set_stream_id): <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to describe.</p>
    /// - On success, responds with [`DescribeJournalKinesisStreamOutput`](crate::output::DescribeJournalKinesisStreamOutput) with field(s):
    ///   - [`stream(Option<JournalKinesisStreamDescription>)`](crate::output::DescribeJournalKinesisStreamOutput::stream): <p>Information about the QLDB journal stream returned by a <code>DescribeJournalS3Export</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeJournalKinesisStreamError>`](crate::error::DescribeJournalKinesisStreamError)
    pub fn describe_journal_kinesis_stream(
        &self,
    ) -> fluent_builders::DescribeJournalKinesisStream<C, M, R> {
        fluent_builders::DescribeJournalKinesisStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJournalS3Export`](crate::client::fluent_builders::DescribeJournalS3Export) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeJournalS3Export::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeJournalS3Export::set_name): <p>The name of the ledger.</p>
    ///   - [`export_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJournalS3Export::export_id) / [`set_export_id(Option<String>)`](crate::client::fluent_builders::DescribeJournalS3Export::set_export_id): <p>The UUID (represented in Base62-encoded text) of the journal export job to describe.</p>
    /// - On success, responds with [`DescribeJournalS3ExportOutput`](crate::output::DescribeJournalS3ExportOutput) with field(s):
    ///   - [`export_description(Option<JournalS3ExportDescription>)`](crate::output::DescribeJournalS3ExportOutput::export_description): <p>Information about the journal export job returned by a <code>DescribeJournalS3Export</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeJournalS3ExportError>`](crate::error::DescribeJournalS3ExportError)
    pub fn describe_journal_s3_export(&self) -> fluent_builders::DescribeJournalS3Export<C, M, R> {
        fluent_builders::DescribeJournalS3Export::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLedger`](crate::client::fluent_builders::DescribeLedger) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeLedger::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeLedger::set_name): <p>The name of the ledger that you want to describe.</p>
    /// - On success, responds with [`DescribeLedgerOutput`](crate::output::DescribeLedgerOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeLedgerOutput::name): <p>The name of the ledger.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeLedgerOutput::arn): <p>The Amazon Resource Name (ARN) for the ledger.</p>
    ///   - [`state(Option<LedgerState>)`](crate::output::DescribeLedgerOutput::state): <p>The current status of the ledger.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeLedgerOutput::creation_date_time): <p>The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
    ///   - [`permissions_mode(Option<PermissionsMode>)`](crate::output::DescribeLedgerOutput::permissions_mode): <p>The permissions mode of the ledger.</p>
    ///   - [`deletion_protection(Option<bool>)`](crate::output::DescribeLedgerOutput::deletion_protection): <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>  <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    ///   - [`encryption_description(Option<LedgerEncryptionDescription>)`](crate::output::DescribeLedgerOutput::encryption_description): <p>Information about the encryption of data at rest in the ledger. This includes the current status, the KMS key, and when the key became inaccessible (in the case of an error).</p>
    /// - On failure, responds with [`SdkError<DescribeLedgerError>`](crate::error::DescribeLedgerError)
    pub fn describe_ledger(&self) -> fluent_builders::DescribeLedger<C, M, R> {
        fluent_builders::DescribeLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportJournalToS3`](crate::client::fluent_builders::ExportJournalToS3) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ExportJournalToS3::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ExportJournalToS3::set_name): <p>The name of the ledger.</p>
    ///   - [`inclusive_start_time(DateTime)`](crate::client::fluent_builders::ExportJournalToS3::inclusive_start_time) / [`set_inclusive_start_time(Option<DateTime>)`](crate::client::fluent_builders::ExportJournalToS3::set_inclusive_start_time): <p>The inclusive start date and time for the range of journal contents to export.</p>  <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>  <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>  <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's <code>CreationDateTime</code>.</p>
    ///   - [`exclusive_end_time(DateTime)`](crate::client::fluent_builders::ExportJournalToS3::exclusive_end_time) / [`set_exclusive_end_time(Option<DateTime>)`](crate::client::fluent_builders::ExportJournalToS3::set_exclusive_end_time): <p>The exclusive end date and time for the range of journal contents to export.</p>  <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>  <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and time.</p>
    ///   - [`s3_export_configuration(S3ExportConfiguration)`](crate::client::fluent_builders::ExportJournalToS3::s3_export_configuration) / [`set_s3_export_configuration(Option<S3ExportConfiguration>)`](crate::client::fluent_builders::ExportJournalToS3::set_s3_export_configuration): <p>The configuration settings of the Amazon S3 bucket destination for your export request.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::ExportJournalToS3::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::ExportJournalToS3::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the following:</p>  <ul>   <li> <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p> </li>   <li> <p>(Optional) Use your customer managed key in Key Management Service (KMS) for server-side encryption of your exported data.</p> </li>  </ul>  <p>To pass a role to QLDB when requesting a journal export, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal export requests.</p>
    ///   - [`output_format(OutputFormat)`](crate::client::fluent_builders::ExportJournalToS3::output_format) / [`set_output_format(Option<OutputFormat>)`](crate::client::fluent_builders::ExportJournalToS3::set_output_format): <p>The output format of your exported journal data. If this parameter is not specified, the exported data defaults to <code>ION_TEXT</code> format.</p>
    /// - On success, responds with [`ExportJournalToS3Output`](crate::output::ExportJournalToS3Output) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::ExportJournalToS3Output::export_id): <p>The UUID (represented in Base62-encoded text) that QLDB assigns to each journal export job.</p>  <p>To describe your export request and check the status of the job, you can use <code>ExportId</code> to call <code>DescribeJournalS3Export</code>.</p>
    /// - On failure, responds with [`SdkError<ExportJournalToS3Error>`](crate::error::ExportJournalToS3Error)
    pub fn export_journal_to_s3(&self) -> fluent_builders::ExportJournalToS3<C, M, R> {
        fluent_builders::ExportJournalToS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBlock`](crate::client::fluent_builders::GetBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetBlock::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetBlock::set_name): <p>The name of the ledger.</p>
    ///   - [`block_address(ValueHolder)`](crate::client::fluent_builders::GetBlock::block_address) / [`set_block_address(Option<ValueHolder>)`](crate::client::fluent_builders::GetBlock::set_block_address): <p>The location of the block that you want to request. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>  <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
    ///   - [`digest_tip_address(ValueHolder)`](crate::client::fluent_builders::GetBlock::digest_tip_address) / [`set_digest_tip_address(Option<ValueHolder>)`](crate::client::fluent_builders::GetBlock::set_digest_tip_address): <p>The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>  <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
    /// - On success, responds with [`GetBlockOutput`](crate::output::GetBlockOutput) with field(s):
    ///   - [`block(Option<ValueHolder>)`](crate::output::GetBlockOutput::block): <p>The block data object in Amazon Ion format.</p>
    ///   - [`proof(Option<ValueHolder>)`](crate::output::GetBlockOutput::proof): <p>The proof object in Amazon Ion format returned by a <code>GetBlock</code> request. A proof contains the list of hash values required to recalculate the specified digest using a Merkle tree, starting with the specified block.</p>
    /// - On failure, responds with [`SdkError<GetBlockError>`](crate::error::GetBlockError)
    pub fn get_block(&self) -> fluent_builders::GetBlock<C, M, R> {
        fluent_builders::GetBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDigest`](crate::client::fluent_builders::GetDigest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetDigest::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetDigest::set_name): <p>The name of the ledger.</p>
    /// - On success, responds with [`GetDigestOutput`](crate::output::GetDigestOutput) with field(s):
    ///   - [`digest(Option<Blob>)`](crate::output::GetDigestOutput::digest): <p>The 256-bit hash value representing the digest returned by a <code>GetDigest</code> request.</p>
    ///   - [`digest_tip_address(Option<ValueHolder>)`](crate::output::GetDigestOutput::digest_tip_address): <p>The latest block location covered by the digest that you requested. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
    /// - On failure, responds with [`SdkError<GetDigestError>`](crate::error::GetDigestError)
    pub fn get_digest(&self) -> fluent_builders::GetDigest<C, M, R> {
        fluent_builders::GetDigest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRevision`](crate::client::fluent_builders::GetRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetRevision::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetRevision::set_name): <p>The name of the ledger.</p>
    ///   - [`block_address(ValueHolder)`](crate::client::fluent_builders::GetRevision::block_address) / [`set_block_address(Option<ValueHolder>)`](crate::client::fluent_builders::GetRevision::set_block_address): <p>The block location of the document revision to be verified. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>  <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
    ///   - [`document_id(impl Into<String>)`](crate::client::fluent_builders::GetRevision::document_id) / [`set_document_id(Option<String>)`](crate::client::fluent_builders::GetRevision::set_document_id): <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
    ///   - [`digest_tip_address(ValueHolder)`](crate::client::fluent_builders::GetRevision::digest_tip_address) / [`set_digest_tip_address(Option<ValueHolder>)`](crate::client::fluent_builders::GetRevision::set_digest_tip_address): <p>The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>  <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
    /// - On success, responds with [`GetRevisionOutput`](crate::output::GetRevisionOutput) with field(s):
    ///   - [`proof(Option<ValueHolder>)`](crate::output::GetRevisionOutput::proof): <p>The proof object in Amazon Ion format returned by a <code>GetRevision</code> request. A proof contains the list of hash values that are required to recalculate the specified digest using a Merkle tree, starting with the specified document revision.</p>
    ///   - [`revision(Option<ValueHolder>)`](crate::output::GetRevisionOutput::revision): <p>The document revision data object in Amazon Ion format.</p>
    /// - On failure, responds with [`SdkError<GetRevisionError>`](crate::error::GetRevisionError)
    pub fn get_revision(&self) -> fluent_builders::GetRevision<C, M, R> {
        fluent_builders::GetRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJournalKinesisStreamsForLedger`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`ledger_name(impl Into<String>)`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger::ledger_name) / [`set_ledger_name(Option<String>)`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger::set_ledger_name): <p>The name of the ledger.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger::set_max_results): <p>The maximum number of results to return in a single <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results returned might be fewer.)</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger::set_next_token): <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input here.</p>
    /// - On success, responds with [`ListJournalKinesisStreamsForLedgerOutput`](crate::output::ListJournalKinesisStreamsForLedgerOutput) with field(s):
    ///   - [`streams(Option<Vec<JournalKinesisStreamDescription>>)`](crate::output::ListJournalKinesisStreamsForLedgerOutput::streams): <p>The array of QLDB journal stream descriptors that are associated with the given ledger.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJournalKinesisStreamsForLedgerOutput::next_token): <ul>   <li> <p>If <code>NextToken</code> is empty, the last page of results has been processed and there are no more results to be retrieved.</p> </li>   <li> <p>If <code>NextToken</code> is <i>not</i> empty, more results are available. To retrieve the next page of results, use the value of <code>NextToken</code> in a subsequent <code>ListJournalKinesisStreamsForLedger</code> call.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ListJournalKinesisStreamsForLedgerError>`](crate::error::ListJournalKinesisStreamsForLedgerError)
    pub fn list_journal_kinesis_streams_for_ledger(
        &self,
    ) -> fluent_builders::ListJournalKinesisStreamsForLedger<C, M, R> {
        fluent_builders::ListJournalKinesisStreamsForLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJournalS3Exports`](crate::client::fluent_builders::ListJournalS3Exports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJournalS3Exports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJournalS3Exports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJournalS3Exports::set_max_results): <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code> request. (The actual number of results returned might be fewer.)</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJournalS3Exports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJournalS3Exports::set_next_token): <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalS3Exports</code> call, then you should use that value as input here.</p>
    /// - On success, responds with [`ListJournalS3ExportsOutput`](crate::output::ListJournalS3ExportsOutput) with field(s):
    ///   - [`journal_s3_exports(Option<Vec<JournalS3ExportDescription>>)`](crate::output::ListJournalS3ExportsOutput::journal_s3_exports): <p>The array of journal export job descriptions for all ledgers that are associated with the current Amazon Web Services account and Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJournalS3ExportsOutput::next_token): <ul>   <li> <p>If <code>NextToken</code> is empty, then the last page of results has been processed and there are no more results to be retrieved.</p> </li>   <li> <p>If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the next page of results, use the value of <code>NextToken</code> in a subsequent <code>ListJournalS3Exports</code> call.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ListJournalS3ExportsError>`](crate::error::ListJournalS3ExportsError)
    pub fn list_journal_s3_exports(&self) -> fluent_builders::ListJournalS3Exports<C, M, R> {
        fluent_builders::ListJournalS3Exports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJournalS3ExportsForLedger`](crate::client::fluent_builders::ListJournalS3ExportsForLedger) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJournalS3ExportsForLedger::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListJournalS3ExportsForLedger::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListJournalS3ExportsForLedger::set_name): <p>The name of the ledger.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJournalS3ExportsForLedger::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJournalS3ExportsForLedger::set_max_results): <p>The maximum number of results to return in a single <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results returned might be fewer.)</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJournalS3ExportsForLedger::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJournalS3ExportsForLedger::set_next_token): <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input here.</p>
    /// - On success, responds with [`ListJournalS3ExportsForLedgerOutput`](crate::output::ListJournalS3ExportsForLedgerOutput) with field(s):
    ///   - [`journal_s3_exports(Option<Vec<JournalS3ExportDescription>>)`](crate::output::ListJournalS3ExportsForLedgerOutput::journal_s3_exports): <p>The array of journal export job descriptions that are associated with the specified ledger.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJournalS3ExportsForLedgerOutput::next_token): <ul>   <li> <p>If <code>NextToken</code> is empty, then the last page of results has been processed and there are no more results to be retrieved.</p> </li>   <li> <p>If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the next page of results, use the value of <code>NextToken</code> in a subsequent <code>ListJournalS3ExportsForLedger</code> call.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ListJournalS3ExportsForLedgerError>`](crate::error::ListJournalS3ExportsForLedgerError)
    pub fn list_journal_s3_exports_for_ledger(
        &self,
    ) -> fluent_builders::ListJournalS3ExportsForLedger<C, M, R> {
        fluent_builders::ListJournalS3ExportsForLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLedgers`](crate::client::fluent_builders::ListLedgers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLedgers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLedgers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLedgers::set_max_results): <p>The maximum number of results to return in a single <code>ListLedgers</code> request. (The actual number of results returned might be fewer.)</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLedgers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLedgers::set_next_token): <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListLedgers</code> call, then you should use that value as input here.</p>
    /// - On success, responds with [`ListLedgersOutput`](crate::output::ListLedgersOutput) with field(s):
    ///   - [`ledgers(Option<Vec<LedgerSummary>>)`](crate::output::ListLedgersOutput::ledgers): <p>The array of ledger summaries that are associated with the current Amazon Web Services account and Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLedgersOutput::next_token): <p>A pagination token, indicating whether there are more results available:</p>  <ul>   <li> <p>If <code>NextToken</code> is empty, then the last page of results has been processed and there are no more results to be retrieved.</p> </li>   <li> <p>If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the next page of results, use the value of <code>NextToken</code> in a subsequent <code>ListLedgers</code> call.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ListLedgersError>`](crate::error::ListLedgersError)
    pub fn list_ledgers(&self) -> fluent_builders::ListLedgers<C, M, R> {
        fluent_builders::ListLedgers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>  <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, Option<String>>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are currently associated with the specified Amazon QLDB resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StreamJournalToKinesis`](crate::client::fluent_builders::StreamJournalToKinesis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ledger_name(impl Into<String>)`](crate::client::fluent_builders::StreamJournalToKinesis::ledger_name) / [`set_ledger_name(Option<String>)`](crate::client::fluent_builders::StreamJournalToKinesis::set_ledger_name): <p>The name of the ledger.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::StreamJournalToKinesis::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::StreamJournalToKinesis::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.</p>  <p>To pass a role to QLDB when requesting a journal stream, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal stream requests.</p>
    ///   - [`tags(HashMap<String, Option<String>>)`](crate::client::fluent_builders::StreamJournalToKinesis::tags) / [`set_tags(Option<HashMap<String, Option<String>>>)`](crate::client::fluent_builders::StreamJournalToKinesis::set_tags): <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.</p>
    ///   - [`inclusive_start_time(DateTime)`](crate::client::fluent_builders::StreamJournalToKinesis::inclusive_start_time) / [`set_inclusive_start_time(Option<DateTime>)`](crate::client::fluent_builders::StreamJournalToKinesis::set_inclusive_start_time): <p>The inclusive start date and time from which to start streaming journal data. This parameter must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>  <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before <code>ExclusiveEndTime</code>.</p>  <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's <code>CreationDateTime</code>.</p>
    ///   - [`exclusive_end_time(DateTime)`](crate::client::fluent_builders::StreamJournalToKinesis::exclusive_end_time) / [`set_exclusive_end_time(Option<DateTime>)`](crate::client::fluent_builders::StreamJournalToKinesis::set_exclusive_end_time): <p>The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it.</p>  <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
    ///   - [`kinesis_configuration(KinesisConfiguration)`](crate::client::fluent_builders::StreamJournalToKinesis::kinesis_configuration) / [`set_kinesis_configuration(Option<KinesisConfiguration>)`](crate::client::fluent_builders::StreamJournalToKinesis::set_kinesis_configuration): <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
    ///   - [`stream_name(impl Into<String>)`](crate::client::fluent_builders::StreamJournalToKinesis::stream_name) / [`set_stream_name(Option<String>)`](crate::client::fluent_builders::StreamJournalToKinesis::set_stream_name): <p>The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.</p>  <p>Your stream name must be unique among other <i>active</i> streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    /// - On success, responds with [`StreamJournalToKinesisOutput`](crate::output::StreamJournalToKinesisOutput) with field(s):
    ///   - [`stream_id(Option<String>)`](crate::output::StreamJournalToKinesisOutput::stream_id): <p>The UUID (represented in Base62-encoded text) that QLDB assigns to each QLDB journal stream.</p>
    /// - On failure, responds with [`SdkError<StreamJournalToKinesisError>`](crate::error::StreamJournalToKinesisError)
    pub fn stream_journal_to_kinesis(&self) -> fluent_builders::StreamJournalToKinesis<C, M, R> {
        fluent_builders::StreamJournalToKinesis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>  <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
    ///   - [`tags(HashMap<String, Option<String>>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, Option<String>>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case sensitive. If you specify a key that already exists for the resource, your request fails and returns an error. Tag values are case sensitive and can be null.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>  <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLedger`](crate::client::fluent_builders::UpdateLedger) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateLedger::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateLedger::set_name): <p>The name of the ledger.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::UpdateLedger::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::UpdateLedger::set_deletion_protection): <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>  <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::UpdateLedger::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::UpdateLedger::set_kms_key): <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>  <p>Use one of the following options to specify this parameter:</p>  <ul>   <li> <p> <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.</p> </li>   <li> <p> <b>Undefined</b>: Make no changes to the KMS key of the ledger.</p> </li>   <li> <p> <b>A valid symmetric customer managed KMS key</b>: Use the specified KMS key in your account that you create, own, and manage.</p> <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>  </ul>  <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>  <p>For example:</p>  <ul>   <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>   <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>   <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On success, responds with [`UpdateLedgerOutput`](crate::output::UpdateLedgerOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateLedgerOutput::name): <p>The name of the ledger.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateLedgerOutput::arn): <p>The Amazon Resource Name (ARN) for the ledger.</p>
    ///   - [`state(Option<LedgerState>)`](crate::output::UpdateLedgerOutput::state): <p>The current status of the ledger.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateLedgerOutput::creation_date_time): <p>The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
    ///   - [`deletion_protection(Option<bool>)`](crate::output::UpdateLedgerOutput::deletion_protection): <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>  <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    ///   - [`encryption_description(Option<LedgerEncryptionDescription>)`](crate::output::UpdateLedgerOutput::encryption_description): <p>Information about the encryption of data at rest in the ledger. This includes the current status, the KMS key, and when the key became inaccessible (in the case of an error).</p>
    /// - On failure, responds with [`SdkError<UpdateLedgerError>`](crate::error::UpdateLedgerError)
    pub fn update_ledger(&self) -> fluent_builders::UpdateLedger<C, M, R> {
        fluent_builders::UpdateLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLedgerPermissionsMode`](crate::client::fluent_builders::UpdateLedgerPermissionsMode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateLedgerPermissionsMode::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateLedgerPermissionsMode::set_name): <p>The name of the ledger.</p>
    ///   - [`permissions_mode(PermissionsMode)`](crate::client::fluent_builders::UpdateLedgerPermissionsMode::permissions_mode) / [`set_permissions_mode(Option<PermissionsMode>)`](crate::client::fluent_builders::UpdateLedgerPermissionsMode::set_permissions_mode): <p>The permissions mode to assign to the ledger. This parameter can have one of the following values:</p>  <ul>   <li> <p> <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for ledgers.</p> <p>This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.</p> </li>   <li> <p> <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</p> <p>By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.</p> </li>  </ul> <note>   <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.</p>  </note>
    /// - On success, responds with [`UpdateLedgerPermissionsModeOutput`](crate::output::UpdateLedgerPermissionsModeOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateLedgerPermissionsModeOutput::name): <p>The name of the ledger.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateLedgerPermissionsModeOutput::arn): <p>The Amazon Resource Name (ARN) for the ledger.</p>
    ///   - [`permissions_mode(Option<PermissionsMode>)`](crate::output::UpdateLedgerPermissionsModeOutput::permissions_mode): <p>The current permissions mode of the ledger.</p>
    /// - On failure, responds with [`SdkError<UpdateLedgerPermissionsModeError>`](crate::error::UpdateLedgerPermissionsModeError)
    pub fn update_ledger_permissions_mode(
        &self,
    ) -> fluent_builders::UpdateLedgerPermissionsMode<C, M, R> {
        fluent_builders::UpdateLedgerPermissionsMode::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelJournalKinesisStream`.
    ///
    /// <p>Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be <code>ACTIVE</code>.</p>
    /// <p>You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention period, so they are automatically deleted after this limit expires.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJournalKinesisStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_journal_kinesis_stream_input::Builder,
    }
    impl<C, M, R> CancelJournalKinesisStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJournalKinesisStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJournalKinesisStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJournalKinesisStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJournalKinesisStreamInputOperationOutputAlias,
                crate::output::CancelJournalKinesisStreamOutput,
                crate::error::CancelJournalKinesisStreamError,
                crate::input::CancelJournalKinesisStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be canceled.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be canceled.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLedger`.
    ///
    /// <p>Creates a new ledger in your Amazon Web Services account in the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ledger_input::Builder,
    }
    impl<C, M, R> CreateLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLedgerInputOperationOutputAlias,
                crate::output::CreateLedgerOutput,
                crate::error::CreateLedgerError,
                crate::input::CreateLedgerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger that you want to create. The name must be unique among all of the ledgers in your Amazon Web Services account in the current Region.</p>
        /// <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger that you want to create. The name must be unique among all of the ledgers in your Amazon Web Services account in the current Region.</p>
        /// <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v);
            self
        }
        /// <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger that you want to create. This parameter can have one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for ledgers.</p> <p>This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.</p> </li>
        /// <li> <p> <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</p> <p>By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.</p> </li>
        /// </ul> <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.</p>
        /// </note>
        pub fn permissions_mode(mut self, input: crate::model::PermissionsMode) -> Self {
            self.inner = self.inner.permissions_mode(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger that you want to create. This parameter can have one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for ledgers.</p> <p>This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.</p> </li>
        /// <li> <p> <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</p> <p>By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.</p> </li>
        /// </ul> <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.</p>
        /// </note>
        pub fn set_permissions_mode(
            mut self,
            input: std::option::Option<crate::model::PermissionsMode>,
        ) -> Self {
            self.inner = self.inner.set_permissions_mode(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li> <p> <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.</p> </li>
        /// <li> <p> <b>Undefined</b>: By default, use an Amazon Web Services owned KMS key.</p> </li>
        /// <li> <p> <b>A valid symmetric customer managed KMS key</b>: Use the specified KMS key in your account that you create, own, and manage.</p> <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li> <p> <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.</p> </li>
        /// <li> <p> <b>Undefined</b>: By default, use an Amazon Web Services owned KMS key.</p> </li>
        /// <li> <p> <b>A valid symmetric customer managed KMS key</b>: Use the specified KMS key in your account that you create, own, and manage.</p> <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLedger`.
    ///
    /// <p>Deletes a ledger and all of its contents. This action is irreversible.</p>
    /// <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ledger_input::Builder,
    }
    impl<C, M, R> DeleteLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLedgerInputOperationOutputAlias,
                crate::output::DeleteLedgerOutput,
                crate::error::DeleteLedgerError,
                crate::input::DeleteLedgerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger that you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger that you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJournalKinesisStream`.
    ///
    /// <p>Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource Name (ARN), stream name, current status, creation time, and the parameters of the original stream creation request.</p>
    /// <p>This action does not return any expired journal streams. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJournalKinesisStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_journal_kinesis_stream_input::Builder,
    }
    impl<C, M, R> DescribeJournalKinesisStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJournalKinesisStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJournalKinesisStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJournalKinesisStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJournalKinesisStreamInputOperationOutputAlias,
                crate::output::DescribeJournalKinesisStreamOutput,
                crate::error::DescribeJournalKinesisStreamError,
                crate::input::DescribeJournalKinesisStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to describe.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to describe.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJournalS3Export`.
    ///
    /// <p>Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request.</p>
    /// <p>This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    /// <p>If the export job with the given <code>ExportId</code> doesn't exist, then throws <code>ResourceNotFoundException</code>.</p>
    /// <p>If the ledger with the given <code>Name</code> doesn't exist, then throws <code>ResourceNotFoundException</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJournalS3Export<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_journal_s3_export_input::Builder,
    }
    impl<C, M, R> DescribeJournalS3Export<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJournalS3Export`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJournalS3ExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJournalS3ExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJournalS3ExportInputOperationOutputAlias,
                crate::output::DescribeJournalS3ExportOutput,
                crate::error::DescribeJournalS3ExportError,
                crate::input::DescribeJournalS3ExportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job to describe.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job to describe.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLedger`.
    ///
    /// <p>Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ledger_input::Builder,
    }
    impl<C, M, R> DescribeLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLedgerInputOperationOutputAlias,
                crate::output::DescribeLedgerOutput,
                crate::error::DescribeLedgerError,
                crate::input::DescribeLedgerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger that you want to describe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger that you want to describe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportJournalToS3`.
    ///
    /// <p>Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export job can write the data objects in either the text or binary representation of Amazon Ion format, or in <i>JSON Lines</i> text format.</p>
    /// <p>In JSON Lines format, each journal block in the exported data object is a valid JSON object that is delimited by a newline. You can use this format to easily integrate JSON exports with analytics tools such as Glue and Amazon Athena because these services can parse newline-delimited JSON automatically. For more information about the format, see <a href="https://jsonlines.org/">JSON Lines</a>.</p>
    /// <p>If the ledger with the given <code>Name</code> doesn't exist, then throws <code>ResourceNotFoundException</code>.</p>
    /// <p>If the ledger with the given <code>Name</code> is in <code>CREATING</code> status, then throws <code>ResourcePreconditionNotMetException</code>.</p>
    /// <p>You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export requests throw <code>LimitExceededException</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportJournalToS3<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_journal_to_s3_input::Builder,
    }
    impl<C, M, R> ExportJournalToS3<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportJournalToS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportJournalToS3Output,
            aws_smithy_http::result::SdkError<crate::error::ExportJournalToS3Error>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportJournalToS3InputOperationOutputAlias,
                crate::output::ExportJournalToS3Output,
                crate::error::ExportJournalToS3Error,
                crate::input::ExportJournalToS3InputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents to export.</p>
        /// <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's <code>CreationDateTime</code>.</p>
        pub fn inclusive_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.inclusive_start_time(input);
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents to export.</p>
        /// <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's <code>CreationDateTime</code>.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_inclusive_start_time(input);
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents to export.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and time.</p>
        pub fn exclusive_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.exclusive_end_time(input);
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents to export.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and time.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_end_time(input);
            self
        }
        /// <p>The configuration settings of the Amazon S3 bucket destination for your export request.</p>
        pub fn s3_export_configuration(
            mut self,
            input: crate::model::S3ExportConfiguration,
        ) -> Self {
            self.inner = self.inner.s3_export_configuration(input);
            self
        }
        /// <p>The configuration settings of the Amazon S3 bucket destination for your export request.</p>
        pub fn set_s3_export_configuration(
            mut self,
            input: std::option::Option<crate::model::S3ExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_s3_export_configuration(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the following:</p>
        /// <ul>
        /// <li> <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p> </li>
        /// <li> <p>(Optional) Use your customer managed key in Key Management Service (KMS) for server-side encryption of your exported data.</p> </li>
        /// </ul>
        /// <p>To pass a role to QLDB when requesting a journal export, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal export requests.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the following:</p>
        /// <ul>
        /// <li> <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p> </li>
        /// <li> <p>(Optional) Use your customer managed key in Key Management Service (KMS) for server-side encryption of your exported data.</p> </li>
        /// </ul>
        /// <p>To pass a role to QLDB when requesting a journal export, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal export requests.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The output format of your exported journal data. If this parameter is not specified, the exported data defaults to <code>ION_TEXT</code> format.</p>
        pub fn output_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.output_format(input);
            self
        }
        /// <p>The output format of your exported journal data. If this parameter is not specified, the exported data defaults to <code>ION_TEXT</code> format.</p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_output_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlock`.
    ///
    /// <p>Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if <code>DigestTipAddress</code> is provided.</p>
    /// <p>For information about the data contents in a block, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html">Journal contents</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    /// <p>If the specified ledger doesn't exist or is in <code>DELETING</code> status, then throws <code>ResourceNotFoundException</code>.</p>
    /// <p>If the specified ledger is in <code>CREATING</code> status, then throws <code>ResourcePreconditionNotMetException</code>.</p>
    /// <p>If no block exists with the specified address, then throws <code>InvalidParameterException</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_block_input::Builder,
    }
    impl<C, M, R> GetBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlockInputOperationOutputAlias,
                crate::output::GetBlockOutput,
                crate::error::GetBlockError,
                crate::input::GetBlockInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The location of the block that you want to request. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn block_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.block_address(input);
            self
        }
        /// <p>The location of the block that you want to request. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn set_block_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_block_address(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn digest_tip_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.digest_tip_address(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn set_digest_tip_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_digest_tip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDigest`.
    ///
    /// <p>Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash value and a block address.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDigest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_digest_input::Builder,
    }
    impl<C, M, R> GetDigest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDigest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDigestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDigestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDigestInputOperationOutputAlias,
                crate::output::GetDigestOutput,
                crate::error::GetDigestError,
                crate::input::GetDigestInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRevision`.
    ///
    /// <p>Returns a revision data object for a specified document ID and block address. Also returns a proof of the specified revision for verification if <code>DigestTipAddress</code> is provided.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_revision_input::Builder,
    }
    impl<C, M, R> GetRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRevisionInputOperationOutputAlias,
                crate::output::GetRevisionOutput,
                crate::error::GetRevisionError,
                crate::input::GetRevisionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The block location of the document revision to be verified. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn block_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.block_address(input);
            self
        }
        /// <p>The block location of the document revision to be verified. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn set_block_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_block_address(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn digest_tip_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.digest_tip_address(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn set_digest_tip_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_digest_tip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJournalKinesisStreamsForLedger`.
    ///
    /// <p>Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream descriptor includes the same details that are returned by <code>DescribeJournalKinesisStream</code>.</p>
    /// <p>This action does not return any expired journal streams. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    /// <p>This action returns a maximum of <code>MaxResults</code> items. It is paginated so that you can retrieve all the items by calling <code>ListJournalKinesisStreamsForLedger</code> multiple times.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJournalKinesisStreamsForLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journal_kinesis_streams_for_ledger_input::Builder,
    }
    impl<C, M, R> ListJournalKinesisStreamsForLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJournalKinesisStreamsForLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJournalKinesisStreamsForLedgerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListJournalKinesisStreamsForLedgerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJournalKinesisStreamsForLedgerInputOperationOutputAlias,
                crate::output::ListJournalKinesisStreamsForLedgerOutput,
                crate::error::ListJournalKinesisStreamsForLedgerError,
                crate::input::ListJournalKinesisStreamsForLedgerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJournalKinesisStreamsForLedgerPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListJournalKinesisStreamsForLedgerPaginator<C, M, R> {
            crate::paginator::ListJournalKinesisStreamsForLedgerPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJournalS3Exports`.
    ///
    /// <p>Returns an array of journal export job descriptions for all ledgers that are associated with the current Amazon Web Services account and Region.</p>
    /// <p>This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the items by calling <code>ListJournalS3Exports</code> multiple times.</p>
    /// <p>This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJournalS3Exports<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journal_s3_exports_input::Builder,
    }
    impl<C, M, R> ListJournalS3Exports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJournalS3Exports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJournalS3ExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJournalS3ExportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJournalS3ExportsInputOperationOutputAlias,
                crate::output::ListJournalS3ExportsOutput,
                crate::error::ListJournalS3ExportsError,
                crate::input::ListJournalS3ExportsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJournalS3ExportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJournalS3ExportsPaginator<C, M, R> {
            crate::paginator::ListJournalS3ExportsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalS3Exports</code> call, then you should use that value as input here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalS3Exports</code> call, then you should use that value as input here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJournalS3ExportsForLedger`.
    ///
    /// <p>Returns an array of journal export job descriptions for a specified ledger.</p>
    /// <p>This action returns a maximum of <code>MaxResults</code> items, and is paginated so that you can retrieve all the items by calling <code>ListJournalS3ExportsForLedger</code> multiple times.</p>
    /// <p>This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJournalS3ExportsForLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journal_s3_exports_for_ledger_input::Builder,
    }
    impl<C, M, R> ListJournalS3ExportsForLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJournalS3ExportsForLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJournalS3ExportsForLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJournalS3ExportsForLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJournalS3ExportsForLedgerInputOperationOutputAlias,
                crate::output::ListJournalS3ExportsForLedgerOutput,
                crate::error::ListJournalS3ExportsForLedgerError,
                crate::input::ListJournalS3ExportsForLedgerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJournalS3ExportsForLedgerPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListJournalS3ExportsForLedgerPaginator<C, M, R> {
            crate::paginator::ListJournalS3ExportsForLedgerPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLedgers`.
    ///
    /// <p>Returns an array of ledger summaries that are associated with the current Amazon Web Services account and Region.</p>
    /// <p>This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling <code>ListLedgers</code> multiple times.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLedgers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ledgers_input::Builder,
    }
    impl<C, M, R> ListLedgers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLedgers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLedgersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLedgersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLedgersInputOperationOutputAlias,
                crate::output::ListLedgersOutput,
                crate::error::ListLedgersError,
                crate::input::ListLedgersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLedgersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLedgersPaginator<C, M, R> {
            crate::paginator::ListLedgersPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in a single <code>ListLedgers</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListLedgers</code> request. (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListLedgers</code> call, then you should use that value as input here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If you received a value for <code>NextToken</code> in the response from a previous <code>ListLedgers</code> call, then you should use that value as input here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns all tags for a specified Amazon QLDB resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>
        /// <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>
        /// <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StreamJournalToKinesis`.
    ///
    /// <p>Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StreamJournalToKinesis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stream_journal_to_kinesis_input::Builder,
    }
    impl<C, M, R> StreamJournalToKinesis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StreamJournalToKinesis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StreamJournalToKinesisOutput,
            aws_smithy_http::result::SdkError<crate::error::StreamJournalToKinesisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StreamJournalToKinesisInputOperationOutputAlias,
                crate::output::StreamJournalToKinesisOutput,
                crate::error::StreamJournalToKinesisError,
                crate::input::StreamJournalToKinesisInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.</p>
        /// <p>To pass a role to QLDB when requesting a journal stream, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal stream requests.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.</p>
        /// <p>To pass a role to QLDB when requesting a journal stream, you must have permissions to perform the <code>iam:PassRole</code> action on the IAM role resource. This is required for all journal stream requests.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v);
            self
        }
        /// <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data. This parameter must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's <code>CreationDateTime</code>.</p>
        pub fn inclusive_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.inclusive_start_time(input);
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data. This parameter must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's <code>CreationDateTime</code>.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_inclusive_start_time(input);
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        pub fn exclusive_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.exclusive_end_time(input);
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_end_time(input);
            self
        }
        /// <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
        pub fn kinesis_configuration(mut self, input: crate::model::KinesisConfiguration) -> Self {
            self.inner = self.inner.kinesis_configuration(input);
            self
        }
        /// <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
        pub fn set_kinesis_configuration(
            mut self,
            input: std::option::Option<crate::model::KinesisConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_configuration(input);
            self
        }
        /// <p>The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.</p>
        /// <p>Your stream name must be unique among other <i>active</i> streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(input.into());
            self
        }
        /// <p>The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.</p>
        /// <p>Your stream name must be unique among other <i>active</i> streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a specified Amazon QLDB resource.</p>
    /// <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>
        /// <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>
        /// <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case sensitive. If you specify a key that already exists for the resource, your request fails and returns an error. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v);
            self
        }
        /// <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case sensitive. If you specify a key that already exists for the resource, your request fails and returns an error. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>
        /// <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>
        /// <p> <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code> </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLedger`.
    ///
    /// <p>Updates properties on a ledger.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ledger_input::Builder,
    }
    impl<C, M, R> UpdateLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLedgerInputOperationOutputAlias,
                crate::output::UpdateLedgerOutput,
                crate::error::UpdateLedgerError,
                crate::input::UpdateLedgerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li> <p> <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.</p> </li>
        /// <li> <p> <b>Undefined</b>: Make no changes to the KMS key of the ledger.</p> </li>
        /// <li> <p> <b>A valid symmetric customer managed KMS key</b>: Use the specified KMS key in your account that you create, own, and manage.</p> <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li> <p> <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.</p> </li>
        /// <li> <p> <b>Undefined</b>: Make no changes to the KMS key of the ledger.</p> </li>
        /// <li> <p> <b>A valid symmetric customer managed KMS key</b>: Use the specified KMS key in your account that you create, own, and manage.</p> <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.</p> </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLedgerPermissionsMode`.
    ///
    /// <p>Updates the permissions mode of a ledger.</p> <important>
    /// <p>Before you switch to the <code>STANDARD</code> permissions mode, you must first create all required IAM policies and table tags to avoid disruption to your users. To learn more, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating">Migrating to the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLedgerPermissionsMode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ledger_permissions_mode_input::Builder,
    }
    impl<C, M, R> UpdateLedgerPermissionsMode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLedgerPermissionsMode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLedgerPermissionsModeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLedgerPermissionsModeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLedgerPermissionsModeInputOperationOutputAlias,
                crate::output::UpdateLedgerPermissionsModeOutput,
                crate::error::UpdateLedgerPermissionsModeError,
                crate::input::UpdateLedgerPermissionsModeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger. This parameter can have one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for ledgers.</p> <p>This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.</p> </li>
        /// <li> <p> <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</p> <p>By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.</p> </li>
        /// </ul> <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.</p>
        /// </note>
        pub fn permissions_mode(mut self, input: crate::model::PermissionsMode) -> Self {
            self.inner = self.inner.permissions_mode(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger. This parameter can have one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for ledgers.</p> <p>This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.</p> </li>
        /// <li> <p> <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands.</p> <p>By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.</p> </li>
        /// </ul> <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger data.</p>
        /// </note>
        pub fn set_permissions_mode(
            mut self,
            input: std::option::Option<crate::model::PermissionsMode>,
        ) -> Self {
            self.inner = self.inner.set_permissions_mode(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
