// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon QLDB
///
/// Client for invoking operations on Amazon QLDB. Each operation on Amazon QLDB is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_qldb::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_qldb::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_qldb::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelJournalKinesisStream` operation.
    ///
    /// See [`CancelJournalKinesisStream`](crate::client::fluent_builders::CancelJournalKinesisStream) for more information about the
    /// operation and its arguments.
    pub fn cancel_journal_kinesis_stream(
        &self,
    ) -> fluent_builders::CancelJournalKinesisStream<C, M, R> {
        fluent_builders::CancelJournalKinesisStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLedger` operation.
    ///
    /// See [`CreateLedger`](crate::client::fluent_builders::CreateLedger) for more information about the
    /// operation and its arguments.
    pub fn create_ledger(&self) -> fluent_builders::CreateLedger<C, M, R> {
        fluent_builders::CreateLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLedger` operation.
    ///
    /// See [`DeleteLedger`](crate::client::fluent_builders::DeleteLedger) for more information about the
    /// operation and its arguments.
    pub fn delete_ledger(&self) -> fluent_builders::DeleteLedger<C, M, R> {
        fluent_builders::DeleteLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJournalKinesisStream` operation.
    ///
    /// See [`DescribeJournalKinesisStream`](crate::client::fluent_builders::DescribeJournalKinesisStream) for more information about the
    /// operation and its arguments.
    pub fn describe_journal_kinesis_stream(
        &self,
    ) -> fluent_builders::DescribeJournalKinesisStream<C, M, R> {
        fluent_builders::DescribeJournalKinesisStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJournalS3Export` operation.
    ///
    /// See [`DescribeJournalS3Export`](crate::client::fluent_builders::DescribeJournalS3Export) for more information about the
    /// operation and its arguments.
    pub fn describe_journal_s3_export(&self) -> fluent_builders::DescribeJournalS3Export<C, M, R> {
        fluent_builders::DescribeJournalS3Export::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLedger` operation.
    ///
    /// See [`DescribeLedger`](crate::client::fluent_builders::DescribeLedger) for more information about the
    /// operation and its arguments.
    pub fn describe_ledger(&self) -> fluent_builders::DescribeLedger<C, M, R> {
        fluent_builders::DescribeLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportJournalToS3` operation.
    ///
    /// See [`ExportJournalToS3`](crate::client::fluent_builders::ExportJournalToS3) for more information about the
    /// operation and its arguments.
    pub fn export_journal_to_s3(&self) -> fluent_builders::ExportJournalToS3<C, M, R> {
        fluent_builders::ExportJournalToS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBlock` operation.
    ///
    /// See [`GetBlock`](crate::client::fluent_builders::GetBlock) for more information about the
    /// operation and its arguments.
    pub fn get_block(&self) -> fluent_builders::GetBlock<C, M, R> {
        fluent_builders::GetBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDigest` operation.
    ///
    /// See [`GetDigest`](crate::client::fluent_builders::GetDigest) for more information about the
    /// operation and its arguments.
    pub fn get_digest(&self) -> fluent_builders::GetDigest<C, M, R> {
        fluent_builders::GetDigest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRevision` operation.
    ///
    /// See [`GetRevision`](crate::client::fluent_builders::GetRevision) for more information about the
    /// operation and its arguments.
    pub fn get_revision(&self) -> fluent_builders::GetRevision<C, M, R> {
        fluent_builders::GetRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJournalKinesisStreamsForLedger` operation.
    ///
    /// See [`ListJournalKinesisStreamsForLedger`](crate::client::fluent_builders::ListJournalKinesisStreamsForLedger) for more information about the
    /// operation and its arguments.
    pub fn list_journal_kinesis_streams_for_ledger(
        &self,
    ) -> fluent_builders::ListJournalKinesisStreamsForLedger<C, M, R> {
        fluent_builders::ListJournalKinesisStreamsForLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJournalS3Exports` operation.
    ///
    /// See [`ListJournalS3Exports`](crate::client::fluent_builders::ListJournalS3Exports) for more information about the
    /// operation and its arguments.
    pub fn list_journal_s3_exports(&self) -> fluent_builders::ListJournalS3Exports<C, M, R> {
        fluent_builders::ListJournalS3Exports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJournalS3ExportsForLedger` operation.
    ///
    /// See [`ListJournalS3ExportsForLedger`](crate::client::fluent_builders::ListJournalS3ExportsForLedger) for more information about the
    /// operation and its arguments.
    pub fn list_journal_s3_exports_for_ledger(
        &self,
    ) -> fluent_builders::ListJournalS3ExportsForLedger<C, M, R> {
        fluent_builders::ListJournalS3ExportsForLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLedgers` operation.
    ///
    /// See [`ListLedgers`](crate::client::fluent_builders::ListLedgers) for more information about the
    /// operation and its arguments.
    pub fn list_ledgers(&self) -> fluent_builders::ListLedgers<C, M, R> {
        fluent_builders::ListLedgers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StreamJournalToKinesis` operation.
    ///
    /// See [`StreamJournalToKinesis`](crate::client::fluent_builders::StreamJournalToKinesis) for more information about the
    /// operation and its arguments.
    pub fn stream_journal_to_kinesis(&self) -> fluent_builders::StreamJournalToKinesis<C, M, R> {
        fluent_builders::StreamJournalToKinesis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLedger` operation.
    ///
    /// See [`UpdateLedger`](crate::client::fluent_builders::UpdateLedger) for more information about the
    /// operation and its arguments.
    pub fn update_ledger(&self) -> fluent_builders::UpdateLedger<C, M, R> {
        fluent_builders::UpdateLedger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLedgerPermissionsMode` operation.
    ///
    /// See [`UpdateLedgerPermissionsMode`](crate::client::fluent_builders::UpdateLedgerPermissionsMode) for more information about the
    /// operation and its arguments.
    pub fn update_ledger_permissions_mode(
        &self,
    ) -> fluent_builders::UpdateLedgerPermissionsMode<C, M, R> {
        fluent_builders::UpdateLedgerPermissionsMode::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelJournalKinesisStream`.
    ///
    /// <p>Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current
    /// status must be <code>ACTIVE</code>.</p>
    /// <p>You can't restart a stream after you cancel it. Canceled QLDB stream resources are
    /// subject to a 7-day retention period, so they are automatically deleted after this limit
    /// expires.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelJournalKinesisStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_journal_kinesis_stream_input::Builder,
    }
    impl<C, M, R> CancelJournalKinesisStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJournalKinesisStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJournalKinesisStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJournalKinesisStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJournalKinesisStreamInputOperationOutputAlias,
                crate::output::CancelJournalKinesisStreamOutput,
                crate::error::CancelJournalKinesisStreamError,
                crate::input::CancelJournalKinesisStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be
        /// canceled.</p>
        pub fn stream_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(inp);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be
        /// canceled.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLedger`.
    ///
    /// <p>Creates a new ledger in your account in the current Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ledger_input::Builder,
    }
    impl<C, M, R> CreateLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLedgerInputOperationOutputAlias,
                crate::output::CreateLedgerOutput,
                crate::error::CreateLedgerError,
                crate::input::CreateLedgerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger that you want to create. The name must be unique among all of
        /// the ledgers in your account in the current Region.</p>
        /// <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a>
        /// in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger that you want to create. The name must be unique among all of
        /// the ledgers in your account in the current Region.</p>
        /// <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a>
        /// in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::option::Option<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger that you want to create. This parameter can
        /// have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn permissions_mode(mut self, inp: crate::model::PermissionsMode) -> Self {
            self.inner = self.inner.permissions_mode(inp);
            self
        }
        /// <p>The permissions mode to assign to the ledger that you want to create. This parameter can
        /// have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn set_permissions_mode(
            mut self,
            input: std::option::Option<crate::model::PermissionsMode>,
        ) -> Self {
            self.inner = self.inner.set_permissions_mode(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: By default, use an Amazon Web Services owned KMS
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: By default, use an Amazon Web Services owned KMS
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLedger`.
    ///
    /// <p>Deletes a ledger and all of its contents. This action is irreversible.</p>
    /// <p>If deletion protection is enabled, you must first disable it before you can delete the
    /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ledger_input::Builder,
    }
    impl<C, M, R> DeleteLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLedgerInputOperationOutputAlias,
                crate::output::DeleteLedgerOutput,
                crate::error::DeleteLedgerError,
                crate::input::DeleteLedgerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger that you want to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger that you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJournalKinesisStream`.
    ///
    /// <p>Returns detailed information about a given Amazon QLDB journal stream. The output
    /// includes the Amazon Resource Name (ARN), stream name, current status, creation time, and
    /// the parameters of the original stream creation request.</p>
    /// <p>This action does not return any expired journal streams. For more information, see
    /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams</a> in the <i>Amazon QLDB Developer
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeJournalKinesisStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_journal_kinesis_stream_input::Builder,
    }
    impl<C, M, R> DescribeJournalKinesisStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJournalKinesisStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJournalKinesisStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJournalKinesisStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJournalKinesisStreamInputOperationOutputAlias,
                crate::output::DescribeJournalKinesisStreamOutput,
                crate::error::DescribeJournalKinesisStreamError,
                crate::input::DescribeJournalKinesisStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to
        /// describe.</p>
        pub fn stream_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(inp);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to
        /// describe.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJournalS3Export`.
    ///
    /// <p>Returns information about a journal export job, including the ledger name, export ID,
    /// creation time, current status, and the parameters of the original export creation
    /// request.</p>
    /// <p>This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration</a> in the <i>Amazon QLDB Developer
    /// Guide</i>.</p>
    /// <p>If the export job with the given <code>ExportId</code> doesn't exist, then throws
    /// <code>ResourceNotFoundException</code>.</p>
    /// <p>If the ledger with the given <code>Name</code> doesn't exist, then throws
    /// <code>ResourceNotFoundException</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeJournalS3Export<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_journal_s3_export_input::Builder,
    }
    impl<C, M, R> DescribeJournalS3Export<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJournalS3Export`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJournalS3ExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJournalS3ExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJournalS3ExportInputOperationOutputAlias,
                crate::output::DescribeJournalS3ExportOutput,
                crate::error::DescribeJournalS3ExportError,
                crate::input::DescribeJournalS3ExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job to
        /// describe.</p>
        pub fn export_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(inp);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job to
        /// describe.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLedger`.
    ///
    /// <p>Returns information about a ledger, including its state, permissions mode, encryption at
    /// rest settings, and when it was created.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ledger_input::Builder,
    }
    impl<C, M, R> DescribeLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLedgerInputOperationOutputAlias,
                crate::output::DescribeLedgerOutput,
                crate::error::DescribeLedgerError,
                crate::input::DescribeLedgerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger that you want to describe.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger that you want to describe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportJournalToS3`.
    ///
    /// <p>Exports journal contents within a date and time range from a ledger into a specified
    /// Amazon Simple Storage Service (Amazon S3) bucket. The data is written as files in Amazon Ion format.</p>
    /// <p>If the ledger with the given <code>Name</code> doesn't exist, then throws
    /// <code>ResourceNotFoundException</code>.</p>
    /// <p>If the ledger with the given <code>Name</code> is in <code>CREATING</code> status, then
    /// throws <code>ResourcePreconditionNotMetException</code>.</p>
    /// <p>You can initiate up to two concurrent journal export requests for each ledger. Beyond
    /// this limit, journal export requests throw <code>LimitExceededException</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExportJournalToS3<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_journal_to_s3_input::Builder,
    }
    impl<C, M, R> ExportJournalToS3<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportJournalToS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportJournalToS3Output,
            aws_smithy_http::result::SdkError<crate::error::ExportJournalToS3Error>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportJournalToS3InputOperationOutputAlias,
                crate::output::ExportJournalToS3Output,
                crate::error::ExportJournalToS3Error,
                crate::input::ExportJournalToS3InputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents to export.</p>
        /// <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time
        /// format and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn inclusive_start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.inclusive_start_time(inp);
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents to export.</p>
        /// <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time
        /// format and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_inclusive_start_time(input);
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents to export.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and
        /// time.</p>
        pub fn exclusive_end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.exclusive_end_time(inp);
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents to export.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and
        /// time.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_end_time(input);
            self
        }
        /// <p>The configuration settings of the Amazon S3 bucket destination for your export
        /// request.</p>
        pub fn s3_export_configuration(mut self, inp: crate::model::S3ExportConfiguration) -> Self {
            self.inner = self.inner.s3_export_configuration(inp);
            self
        }
        /// <p>The configuration settings of the Amazon S3 bucket destination for your export
        /// request.</p>
        pub fn set_s3_export_configuration(
            mut self,
            input: std::option::Option<crate::model::S3ExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_s3_export_configuration(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal export job to do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
        /// </li>
        /// <li>
        /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
        /// encryption of your exported data.</p>
        /// </li>
        /// </ul>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal export job to do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
        /// </li>
        /// <li>
        /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
        /// encryption of your exported data.</p>
        /// </li>
        /// </ul>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlock`.
    ///
    /// <p>Returns a block object at a specified address in a journal. Also returns a proof of the
    /// specified block for verification if <code>DigestTipAddress</code> is provided.</p>
    /// <p>For information about the data contents in a block, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html">Journal contents</a> in the
    /// <i>Amazon QLDB Developer Guide</i>.</p>
    /// <p>If the specified ledger doesn't exist or is in <code>DELETING</code> status, then throws
    /// <code>ResourceNotFoundException</code>.</p>
    /// <p>If the specified ledger is in <code>CREATING</code> status, then throws
    /// <code>ResourcePreconditionNotMetException</code>.</p>
    /// <p>If no block exists with the specified address, then throws
    /// <code>InvalidParameterException</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_block_input::Builder,
    }
    impl<C, M, R> GetBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlockInputOperationOutputAlias,
                crate::output::GetBlockOutput,
                crate::error::GetBlockError,
                crate::input::GetBlockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The location of the block that you want to request. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn block_address(mut self, inp: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.block_address(inp);
            self
        }
        /// <p>The location of the block that you want to request. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn set_block_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_block_address(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn digest_tip_address(mut self, inp: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.digest_tip_address(inp);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn set_digest_tip_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_digest_tip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDigest`.
    ///
    /// <p>Returns the digest of a ledger at the latest committed block in the journal. The
    /// response includes a 256-bit hash value and a block address.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDigest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_digest_input::Builder,
    }
    impl<C, M, R> GetDigest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDigest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDigestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDigestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDigestInputOperationOutputAlias,
                crate::output::GetDigestOutput,
                crate::error::GetDigestError,
                crate::input::GetDigestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRevision`.
    ///
    /// <p>Returns a revision data object for a specified document ID and block address. Also
    /// returns a proof of the specified revision for verification if <code>DigestTipAddress</code>
    /// is provided.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_revision_input::Builder,
    }
    impl<C, M, R> GetRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRevisionInputOperationOutputAlias,
                crate::output::GetRevisionOutput,
                crate::error::GetRevisionError,
                crate::input::GetRevisionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The block location of the document revision to be verified. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn block_address(mut self, inp: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.block_address(inp);
            self
        }
        /// <p>The block location of the document revision to be verified. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn set_block_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_block_address(input);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
        pub fn document_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_id(inp);
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document_id(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn digest_tip_address(mut self, inp: crate::model::ValueHolder) -> Self {
            self.inner = self.inner.digest_tip_address(inp);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn set_digest_tip_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.inner = self.inner.set_digest_tip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJournalKinesisStreamsForLedger`.
    ///
    /// <p>Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The
    /// output of each stream descriptor includes the same details that are returned by
    /// <code>DescribeJournalKinesisStream</code>.</p>
    /// <p>This action does not return any expired journal streams. For more information, see
    /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams</a> in the <i>Amazon QLDB Developer
    /// Guide</i>.</p>
    /// <p>This action returns a maximum of <code>MaxResults</code> items. It is paginated so that
    /// you can retrieve all the items by calling <code>ListJournalKinesisStreamsForLedger</code>
    /// multiple times.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJournalKinesisStreamsForLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journal_kinesis_streams_for_ledger_input::Builder,
    }
    impl<C, M, R> ListJournalKinesisStreamsForLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJournalKinesisStreamsForLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJournalKinesisStreamsForLedgerOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListJournalKinesisStreamsForLedgerError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJournalKinesisStreamsForLedgerInputOperationOutputAlias,
                crate::output::ListJournalKinesisStreamsForLedgerOutput,
                crate::error::ListJournalKinesisStreamsForLedgerError,
                crate::input::ListJournalKinesisStreamsForLedgerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input
        /// here.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input
        /// here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJournalS3Exports`.
    ///
    /// <p>Returns an array of journal export job descriptions for all ledgers that are associated
    /// with the current account and Region.</p>
    /// <p>This action returns a maximum of <code>MaxResults</code> items, and is paginated so that
    /// you can retrieve all the items by calling <code>ListJournalS3Exports</code> multiple
    /// times.</p>
    /// <p>This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration</a> in the <i>Amazon QLDB Developer
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJournalS3Exports<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journal_s3_exports_input::Builder,
    }
    impl<C, M, R> ListJournalS3Exports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJournalS3Exports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJournalS3ExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJournalS3ExportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJournalS3ExportsInputOperationOutputAlias,
                crate::output::ListJournalS3ExportsOutput,
                crate::error::ListJournalS3ExportsError,
                crate::input::ListJournalS3ExportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code>
        /// request. (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code>
        /// request. (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3Exports</code> call, then you should use that value as input
        /// here.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3Exports</code> call, then you should use that value as input
        /// here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJournalS3ExportsForLedger`.
    ///
    /// <p>Returns an array of journal export job descriptions for a specified ledger.</p>
    /// <p>This action returns a maximum of <code>MaxResults</code> items, and is paginated so that
    /// you can retrieve all the items by calling <code>ListJournalS3ExportsForLedger</code>
    /// multiple times.</p>
    /// <p>This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration</a> in the <i>Amazon QLDB Developer
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJournalS3ExportsForLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_journal_s3_exports_for_ledger_input::Builder,
    }
    impl<C, M, R> ListJournalS3ExportsForLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJournalS3ExportsForLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJournalS3ExportsForLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJournalS3ExportsForLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJournalS3ExportsForLedgerInputOperationOutputAlias,
                crate::output::ListJournalS3ExportsForLedgerOutput,
                crate::error::ListJournalS3ExportsForLedgerError,
                crate::input::ListJournalS3ExportsForLedgerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input
        /// here.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input
        /// here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLedgers`.
    ///
    /// <p>Returns an array of ledger summaries that are associated with the current account
    /// and Region.</p>
    /// <p>This action returns a maximum of 100 items and is paginated so that you can
    /// retrieve all the items by calling <code>ListLedgers</code> multiple times.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLedgers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ledgers_input::Builder,
    }
    impl<C, M, R> ListLedgers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLedgers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLedgersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLedgersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLedgersInputOperationOutputAlias,
                crate::output::ListLedgersOutput,
                crate::error::ListLedgersError,
                crate::input::ListLedgersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in a single <code>ListLedgers</code> request.
        /// (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListLedgers</code> request.
        /// (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListLedgers</code> call, then you should use that value as input here.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListLedgers</code> call, then you should use that value as input here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns all tags for a specified Amazon QLDB resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StreamJournalToKinesis`.
    ///
    /// <p>Creates a journal stream for a given Amazon QLDB ledger. The stream captures every
    /// document revision that is committed to the ledger's journal and delivers the data to a
    /// specified Amazon Kinesis Data Streams resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct StreamJournalToKinesis<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stream_journal_to_kinesis_input::Builder,
    }
    impl<C, M, R> StreamJournalToKinesis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StreamJournalToKinesis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StreamJournalToKinesisOutput,
            aws_smithy_http::result::SdkError<crate::error::StreamJournalToKinesisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StreamJournalToKinesisInputOperationOutputAlias,
                crate::output::StreamJournalToKinesisOutput,
                crate::error::StreamJournalToKinesisError,
                crate::input::StreamJournalToKinesisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ledger_name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ledger_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal stream to write data records to a Kinesis Data Streams resource.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal stream to write data records to a Kinesis Data Streams resource.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::option::Option<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data. This
        /// parameter must be in <code>ISO 8601</code> date and time format and in Universal
        /// Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before
        /// <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn inclusive_start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.inclusive_start_time(inp);
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data. This
        /// parameter must be in <code>ISO 8601</code> date and time format and in Universal
        /// Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before
        /// <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_inclusive_start_time(input);
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If you don't define
        /// this parameter, the stream runs indefinitely until you cancel it.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        pub fn exclusive_end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.exclusive_end_time(inp);
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If you don't define
        /// this parameter, the stream runs indefinitely until you cancel it.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_end_time(input);
            self
        }
        /// <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
        pub fn kinesis_configuration(mut self, inp: crate::model::KinesisConfiguration) -> Self {
            self.inner = self.inner.kinesis_configuration(inp);
            self
        }
        /// <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
        pub fn set_kinesis_configuration(
            mut self,
            input: std::option::Option<crate::model::KinesisConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_configuration(input);
            self
        }
        /// <p>The name that you want to assign to the QLDB journal stream. User-defined names can
        /// help identify and indicate the purpose of a stream.</p>
        /// <p>Your stream name must be unique among other <i>active</i> streams for a
        /// given ledger. Stream names have the same naming constraints as ledger names, as defined in
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer
        /// Guide</i>.</p>
        pub fn stream_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_name(inp);
            self
        }
        /// <p>The name that you want to assign to the QLDB journal stream. User-defined names can
        /// help identify and indicate the purpose of a stream.</p>
        /// <p>Your stream name must be unique among other <i>active</i> streams for a
        /// given ledger. Stream names have the same naming constraints as ledger names, as defined in
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer
        /// Guide</i>.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a specified Amazon QLDB resource.</p>
    /// <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a
    /// resource, your request fails and returns an error.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case
        /// sensitive. If you specify a key that already exists for the resource, your request fails
        /// and returns an error. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::option::Option<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case
        /// sensitive. If you specify a key that already exists for the resource, your request fails
        /// and returns an error. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50
    /// tag keys to remove.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tag keys to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLedger`.
    ///
    /// <p>Updates properties on a ledger.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLedger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ledger_input::Builder,
    }
    impl<C, M, R> UpdateLedger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLedger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLedgerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLedgerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLedgerInputOperationOutputAlias,
                crate::output::UpdateLedgerOutput,
                crate::error::UpdateLedgerError,
                crate::input::UpdateLedgerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn deletion_protection(mut self, inp: bool) -> Self {
            self.inner = self.inner.deletion_protection(inp);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: Make no changes to the KMS key of the
        /// ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: Make no changes to the KMS key of the
        /// ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLedgerPermissionsMode`.
    ///
    /// <p>Updates the permissions mode of a ledger.</p>
    /// <important>
    /// <p>Before you switch to the <code>STANDARD</code> permissions mode, you must first
    /// create all required IAM policies and table tags to avoid disruption to your users. To
    /// learn more, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating">Migrating to the standard permissions mode</a> in the <i>Amazon QLDB
    /// Developer Guide</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLedgerPermissionsMode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ledger_permissions_mode_input::Builder,
    }
    impl<C, M, R> UpdateLedgerPermissionsMode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLedgerPermissionsMode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLedgerPermissionsModeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLedgerPermissionsModeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLedgerPermissionsModeInputOperationOutputAlias,
                crate::output::UpdateLedgerPermissionsModeOutput,
                crate::error::UpdateLedgerPermissionsModeError,
                crate::input::UpdateLedgerPermissionsModeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger. This parameter can have one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn permissions_mode(mut self, inp: crate::model::PermissionsMode) -> Self {
            self.inner = self.inner.permissions_mode(inp);
            self
        }
        /// <p>The permissions mode to assign to the ledger. This parameter can have one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn set_permissions_mode(
            mut self,
            input: std::option::Option<crate::model::PermissionsMode>,
        ) -> Self {
            self.inner = self.inner.set_permissions_mode(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
