// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PermissionsMode {
    #[allow(missing_docs)] // documentation missing in model
    AllowAll,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PermissionsMode {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW_ALL" => PermissionsMode::AllowAll,
            "STANDARD" => PermissionsMode::Standard,
            other => PermissionsMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PermissionsMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PermissionsMode::from(s))
    }
}
impl PermissionsMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PermissionsMode::AllowAll => "ALLOW_ALL",
            PermissionsMode::Standard => "STANDARD",
            PermissionsMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW_ALL", "STANDARD"]
    }
}
impl AsRef<str> for PermissionsMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the encryption of data at rest in an Amazon QLDB ledger. This includes
/// the current status, the key in Key Management Service (KMS), and when the key became inaccessible (in
/// the case of an error).</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
/// the <i>Amazon QLDB Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LedgerEncryptionDescription {
    /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key that the ledger uses for
    /// encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key
    /// for encryption.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The current state of encryption at rest for the ledger. This can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code>: Encryption is fully enabled using the specified key.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code>: The ledger is actively processing the specified key
    /// change.</p>
    /// <p>Key changes in QLDB are asynchronous. The ledger is fully accessible without any
    /// performance impact while the key change is being processed. The amount of time it
    /// takes to update a key varies depending on the ledger size.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS_KEY_INACCESSIBLE</code>: The specified customer managed KMS key is not
    /// accessible, and the ledger is impaired. Either the key was disabled or deleted, or
    /// the grants on the key were revoked. When a ledger is impaired, it is not accessible
    /// and does not accept any read or write requests.</p>
    /// <p>An impaired ledger automatically returns to an active state after you restore the
    /// grants on the key, or re-enable the key that was disabled. However, deleting a
    /// customer managed KMS key is irreversible. After a key is deleted, you can no longer
    /// access the ledgers that are protected with that key, and the data becomes
    /// unrecoverable permanently.</p>
    /// </li>
    /// </ul>
    pub encryption_status: std::option::Option<crate::model::EncryptionStatus>,
    /// <p>The date and time, in epoch time format, when the KMS key first became inaccessible,
    /// in the case of an error. (Epoch time format is the number of seconds that have elapsed
    /// since 12:00:00 AM January 1, 1970 UTC.)</p>
    /// <p>This parameter is undefined if the KMS key is accessible.</p>
    pub inaccessible_kms_key_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl LedgerEncryptionDescription {
    /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key that the ledger uses for
    /// encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key
    /// for encryption.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The current state of encryption at rest for the ledger. This can be one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code>: Encryption is fully enabled using the specified key.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code>: The ledger is actively processing the specified key
    /// change.</p>
    /// <p>Key changes in QLDB are asynchronous. The ledger is fully accessible without any
    /// performance impact while the key change is being processed. The amount of time it
    /// takes to update a key varies depending on the ledger size.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS_KEY_INACCESSIBLE</code>: The specified customer managed KMS key is not
    /// accessible, and the ledger is impaired. Either the key was disabled or deleted, or
    /// the grants on the key were revoked. When a ledger is impaired, it is not accessible
    /// and does not accept any read or write requests.</p>
    /// <p>An impaired ledger automatically returns to an active state after you restore the
    /// grants on the key, or re-enable the key that was disabled. However, deleting a
    /// customer managed KMS key is irreversible. After a key is deleted, you can no longer
    /// access the ledgers that are protected with that key, and the data becomes
    /// unrecoverable permanently.</p>
    /// </li>
    /// </ul>
    pub fn encryption_status(&self) -> std::option::Option<&crate::model::EncryptionStatus> {
        self.encryption_status.as_ref()
    }
    /// <p>The date and time, in epoch time format, when the KMS key first became inaccessible,
    /// in the case of an error. (Epoch time format is the number of seconds that have elapsed
    /// since 12:00:00 AM January 1, 1970 UTC.)</p>
    /// <p>This parameter is undefined if the KMS key is accessible.</p>
    pub fn inaccessible_kms_key_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::Instant> {
        self.inaccessible_kms_key_date_time.as_ref()
    }
}
impl std::fmt::Debug for LedgerEncryptionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LedgerEncryptionDescription");
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("encryption_status", &self.encryption_status);
        formatter.field(
            "inaccessible_kms_key_date_time",
            &self.inaccessible_kms_key_date_time,
        );
        formatter.finish()
    }
}
/// See [`LedgerEncryptionDescription`](crate::model::LedgerEncryptionDescription)
pub mod ledger_encryption_description {
    /// A builder for [`LedgerEncryptionDescription`](crate::model::LedgerEncryptionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_status: std::option::Option<crate::model::EncryptionStatus>,
        pub(crate) inaccessible_kms_key_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key that the ledger uses for
        /// encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key
        /// for encryption.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed KMS key that the ledger uses for
        /// encryption at rest. If this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key
        /// for encryption.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The current state of encryption at rest for the ledger. This can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code>: Encryption is fully enabled using the specified key.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code>: The ledger is actively processing the specified key
        /// change.</p>
        /// <p>Key changes in QLDB are asynchronous. The ledger is fully accessible without any
        /// performance impact while the key change is being processed. The amount of time it
        /// takes to update a key varies depending on the ledger size.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS_KEY_INACCESSIBLE</code>: The specified customer managed KMS key is not
        /// accessible, and the ledger is impaired. Either the key was disabled or deleted, or
        /// the grants on the key were revoked. When a ledger is impaired, it is not accessible
        /// and does not accept any read or write requests.</p>
        /// <p>An impaired ledger automatically returns to an active state after you restore the
        /// grants on the key, or re-enable the key that was disabled. However, deleting a
        /// customer managed KMS key is irreversible. After a key is deleted, you can no longer
        /// access the ledgers that are protected with that key, and the data becomes
        /// unrecoverable permanently.</p>
        /// </li>
        /// </ul>
        pub fn encryption_status(mut self, input: crate::model::EncryptionStatus) -> Self {
            self.encryption_status = Some(input);
            self
        }
        /// <p>The current state of encryption at rest for the ledger. This can be one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code>: Encryption is fully enabled using the specified key.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code>: The ledger is actively processing the specified key
        /// change.</p>
        /// <p>Key changes in QLDB are asynchronous. The ledger is fully accessible without any
        /// performance impact while the key change is being processed. The amount of time it
        /// takes to update a key varies depending on the ledger size.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS_KEY_INACCESSIBLE</code>: The specified customer managed KMS key is not
        /// accessible, and the ledger is impaired. Either the key was disabled or deleted, or
        /// the grants on the key were revoked. When a ledger is impaired, it is not accessible
        /// and does not accept any read or write requests.</p>
        /// <p>An impaired ledger automatically returns to an active state after you restore the
        /// grants on the key, or re-enable the key that was disabled. However, deleting a
        /// customer managed KMS key is irreversible. After a key is deleted, you can no longer
        /// access the ledgers that are protected with that key, and the data becomes
        /// unrecoverable permanently.</p>
        /// </li>
        /// </ul>
        pub fn set_encryption_status(
            mut self,
            input: std::option::Option<crate::model::EncryptionStatus>,
        ) -> Self {
            self.encryption_status = input;
            self
        }
        /// <p>The date and time, in epoch time format, when the KMS key first became inaccessible,
        /// in the case of an error. (Epoch time format is the number of seconds that have elapsed
        /// since 12:00:00 AM January 1, 1970 UTC.)</p>
        /// <p>This parameter is undefined if the KMS key is accessible.</p>
        pub fn inaccessible_kms_key_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.inaccessible_kms_key_date_time = Some(input);
            self
        }
        /// <p>The date and time, in epoch time format, when the KMS key first became inaccessible,
        /// in the case of an error. (Epoch time format is the number of seconds that have elapsed
        /// since 12:00:00 AM January 1, 1970 UTC.)</p>
        /// <p>This parameter is undefined if the KMS key is accessible.</p>
        pub fn set_inaccessible_kms_key_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inaccessible_kms_key_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LedgerEncryptionDescription`](crate::model::LedgerEncryptionDescription)
        pub fn build(self) -> crate::model::LedgerEncryptionDescription {
            crate::model::LedgerEncryptionDescription {
                kms_key_arn: self.kms_key_arn,
                encryption_status: self.encryption_status,
                inaccessible_kms_key_date_time: self.inaccessible_kms_key_date_time,
            }
        }
    }
}
impl LedgerEncryptionDescription {
    /// Creates a new builder-style object to manufacture [`LedgerEncryptionDescription`](crate::model::LedgerEncryptionDescription)
    pub fn builder() -> crate::model::ledger_encryption_description::Builder {
        crate::model::ledger_encryption_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    KmsKeyInaccessible,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => EncryptionStatus::Enabled,
            "KMS_KEY_INACCESSIBLE" => EncryptionStatus::KmsKeyInaccessible,
            "UPDATING" => EncryptionStatus::Updating,
            other => EncryptionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionStatus::from(s))
    }
}
impl EncryptionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionStatus::Enabled => "ENABLED",
            EncryptionStatus::KmsKeyInaccessible => "KMS_KEY_INACCESSIBLE",
            EncryptionStatus::Updating => "UPDATING",
            EncryptionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED", "KMS_KEY_INACCESSIBLE", "UPDATING"]
    }
}
impl AsRef<str> for EncryptionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LedgerState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LedgerState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => LedgerState::Active,
            "CREATING" => LedgerState::Creating,
            "DELETED" => LedgerState::Deleted,
            "DELETING" => LedgerState::Deleting,
            other => LedgerState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LedgerState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LedgerState::from(s))
    }
}
impl LedgerState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LedgerState::Active => "ACTIVE",
            LedgerState::Creating => "CREATING",
            LedgerState::Deleted => "DELETED",
            LedgerState::Deleting => "DELETING",
            LedgerState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETED", "DELETING"]
    }
}
impl AsRef<str> for LedgerState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration settings of the Amazon Kinesis Data Streams destination for an Amazon QLDB journal
/// stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
    /// number of records sent per API call.</p>
    /// <p>
    /// <i>This option is enabled by default.</i> Record aggregation has important
    /// implications for processing records and requires de-aggregation in your stream consumer. To
    /// learn more, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a> and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer
    /// Guide</i>.</p>
    pub aggregation_enabled: std::option::Option<bool>,
}
impl KinesisConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
    /// number of records sent per API call.</p>
    /// <p>
    /// <i>This option is enabled by default.</i> Record aggregation has important
    /// implications for processing records and requires de-aggregation in your stream consumer. To
    /// learn more, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a> and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer
    /// Guide</i>.</p>
    pub fn aggregation_enabled(&self) -> std::option::Option<bool> {
        self.aggregation_enabled
    }
}
impl std::fmt::Debug for KinesisConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisConfiguration");
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("aggregation_enabled", &self.aggregation_enabled);
        formatter.finish()
    }
}
/// See [`KinesisConfiguration`](crate::model::KinesisConfiguration)
pub mod kinesis_configuration {
    /// A builder for [`KinesisConfiguration`](crate::model::KinesisConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) aggregation_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
        /// number of records sent per API call.</p>
        /// <p>
        /// <i>This option is enabled by default.</i> Record aggregation has important
        /// implications for processing records and requires de-aggregation in your stream consumer. To
        /// learn more, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a> and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer
        /// Guide</i>.</p>
        pub fn aggregation_enabled(mut self, input: bool) -> Self {
            self.aggregation_enabled = Some(input);
            self
        }
        /// <p>Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
        /// number of records sent per API call.</p>
        /// <p>
        /// <i>This option is enabled by default.</i> Record aggregation has important
        /// implications for processing records and requires de-aggregation in your stream consumer. To
        /// learn more, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a> and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer
        /// Guide</i>.</p>
        pub fn set_aggregation_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.aggregation_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisConfiguration`](crate::model::KinesisConfiguration)
        pub fn build(self) -> crate::model::KinesisConfiguration {
            crate::model::KinesisConfiguration {
                stream_arn: self.stream_arn,
                aggregation_enabled: self.aggregation_enabled,
            }
        }
    }
}
impl KinesisConfiguration {
    /// Creates a new builder-style object to manufacture [`KinesisConfiguration`](crate::model::KinesisConfiguration)
    pub fn builder() -> crate::model::kinesis_configuration::Builder {
        crate::model::kinesis_configuration::Builder::default()
    }
}

/// <p>Information about a ledger, including its name, state, and when it was created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LedgerSummary {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the ledger.</p>
    pub state: std::option::Option<crate::model::LedgerState>,
    /// <p>The date and time, in epoch time format, when the ledger was created. (Epoch time format
    /// is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl LedgerSummary {
    /// <p>The name of the ledger.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the ledger.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::LedgerState> {
        self.state.as_ref()
    }
    /// <p>The date and time, in epoch time format, when the ledger was created. (Epoch time format
    /// is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for LedgerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LedgerSummary");
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`LedgerSummary`](crate::model::LedgerSummary)
pub mod ledger_summary {
    /// A builder for [`LedgerSummary`](crate::model::LedgerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::LedgerState>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the ledger.</p>
        pub fn state(mut self, input: crate::model::LedgerState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current status of the ledger.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::LedgerState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time, in epoch time format, when the ledger was created. (Epoch time format
        /// is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time, in epoch time format, when the ledger was created. (Epoch time format
        /// is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LedgerSummary`](crate::model::LedgerSummary)
        pub fn build(self) -> crate::model::LedgerSummary {
            crate::model::LedgerSummary {
                name: self.name,
                state: self.state,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl LedgerSummary {
    /// Creates a new builder-style object to manufacture [`LedgerSummary`](crate::model::LedgerSummary)
    pub fn builder() -> crate::model::ledger_summary::Builder {
        crate::model::ledger_summary::Builder::default()
    }
}

/// <p>Information about a journal export job, including the ledger name, export ID, creation
/// time, current status, and the parameters of the original export creation request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JournalS3ExportDescription {
    /// <p>The name of the ledger.</p>
    pub ledger_name: std::option::Option<std::string::String>,
    /// <p>The UUID (represented in Base62-encoded text) of the journal export job.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>The date and time, in epoch time format, when the export job was created. (Epoch time
    /// format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
    pub export_creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current state of the journal export job.</p>
    pub status: std::option::Option<crate::model::ExportStatus>,
    /// <p>The inclusive start date and time for the range of journal contents that are specified
    /// in the original export request.</p>
    pub inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The exclusive end date and time for the range of journal contents that are specified in
    /// the original export request.</p>
    pub exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
    /// contents.</p>
    pub s3_export_configuration: std::option::Option<crate::model::S3ExportConfiguration>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
    /// journal export job to do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
    /// </li>
    /// <li>
    /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
    /// encryption of your exported data.</p>
    /// </li>
    /// </ul>
    pub role_arn: std::option::Option<std::string::String>,
}
impl JournalS3ExportDescription {
    /// <p>The name of the ledger.</p>
    pub fn ledger_name(&self) -> std::option::Option<&str> {
        self.ledger_name.as_deref()
    }
    /// <p>The UUID (represented in Base62-encoded text) of the journal export job.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>The date and time, in epoch time format, when the export job was created. (Epoch time
    /// format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
    pub fn export_creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.export_creation_time.as_ref()
    }
    /// <p>The current state of the journal export job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.status.as_ref()
    }
    /// <p>The inclusive start date and time for the range of journal contents that are specified
    /// in the original export request.</p>
    pub fn inclusive_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.inclusive_start_time.as_ref()
    }
    /// <p>The exclusive end date and time for the range of journal contents that are specified in
    /// the original export request.</p>
    pub fn exclusive_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.exclusive_end_time.as_ref()
    }
    /// <p>The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
    /// contents.</p>
    pub fn s3_export_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3ExportConfiguration> {
        self.s3_export_configuration.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
    /// journal export job to do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
    /// </li>
    /// <li>
    /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
    /// encryption of your exported data.</p>
    /// </li>
    /// </ul>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for JournalS3ExportDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JournalS3ExportDescription");
        formatter.field("ledger_name", &self.ledger_name);
        formatter.field("export_id", &self.export_id);
        formatter.field("export_creation_time", &self.export_creation_time);
        formatter.field("status", &self.status);
        formatter.field("inclusive_start_time", &self.inclusive_start_time);
        formatter.field("exclusive_end_time", &self.exclusive_end_time);
        formatter.field("s3_export_configuration", &self.s3_export_configuration);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`JournalS3ExportDescription`](crate::model::JournalS3ExportDescription)
pub mod journal_s3_export_description {
    /// A builder for [`JournalS3ExportDescription`](crate::model::JournalS3ExportDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ledger_name: std::option::Option<std::string::String>,
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) export_creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) s3_export_configuration:
            std::option::Option<crate::model::S3ExportConfiguration>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ledger_name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ledger_name = input;
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>The date and time, in epoch time format, when the export job was created. (Epoch time
        /// format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
        pub fn export_creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.export_creation_time = Some(input);
            self
        }
        /// <p>The date and time, in epoch time format, when the export job was created. (Epoch time
        /// format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)</p>
        pub fn set_export_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.export_creation_time = input;
            self
        }
        /// <p>The current state of the journal export job.</p>
        pub fn status(mut self, input: crate::model::ExportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the journal export job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents that are specified
        /// in the original export request.</p>
        pub fn inclusive_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.inclusive_start_time = Some(input);
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents that are specified
        /// in the original export request.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inclusive_start_time = input;
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents that are specified in
        /// the original export request.</p>
        pub fn exclusive_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.exclusive_end_time = Some(input);
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents that are specified in
        /// the original export request.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.exclusive_end_time = input;
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
        /// contents.</p>
        pub fn s3_export_configuration(
            mut self,
            input: crate::model::S3ExportConfiguration,
        ) -> Self {
            self.s3_export_configuration = Some(input);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
        /// contents.</p>
        pub fn set_s3_export_configuration(
            mut self,
            input: std::option::Option<crate::model::S3ExportConfiguration>,
        ) -> Self {
            self.s3_export_configuration = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal export job to do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
        /// </li>
        /// <li>
        /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
        /// encryption of your exported data.</p>
        /// </li>
        /// </ul>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal export job to do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
        /// </li>
        /// <li>
        /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
        /// encryption of your exported data.</p>
        /// </li>
        /// </ul>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`JournalS3ExportDescription`](crate::model::JournalS3ExportDescription)
        pub fn build(self) -> crate::model::JournalS3ExportDescription {
            crate::model::JournalS3ExportDescription {
                ledger_name: self.ledger_name,
                export_id: self.export_id,
                export_creation_time: self.export_creation_time,
                status: self.status,
                inclusive_start_time: self.inclusive_start_time,
                exclusive_end_time: self.exclusive_end_time,
                s3_export_configuration: self.s3_export_configuration,
                role_arn: self.role_arn,
            }
        }
    }
}
impl JournalS3ExportDescription {
    /// Creates a new builder-style object to manufacture [`JournalS3ExportDescription`](crate::model::JournalS3ExportDescription)
    pub fn builder() -> crate::model::journal_s3_export_description::Builder {
        crate::model::journal_s3_export_description::Builder::default()
    }
}

/// <p>The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
/// contents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ExportConfiguration {
    /// <p>The Amazon S3 bucket name in which a journal export job writes the journal contents.</p>
    /// <p>The bucket name must comply with the Amazon S3 bucket naming conventions. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
    /// Limitations</a> in the <i>Amazon S3 Developer Guide</i>.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The prefix for the Amazon S3 bucket in which a journal export job writes the journal
    /// contents.</p>
    /// <p>The prefix must comply with Amazon S3 key naming rules and restrictions. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a> in the <i>Amazon S3 Developer
    /// Guide</i>.</p>
    /// <p>The following are examples of valid <code>Prefix</code> values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>JournalExports-ForMyLedger/Testing/</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JournalExports</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>My:Tests/</code>
    /// </p>
    /// </li>
    /// </ul>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The encryption settings that are used by a journal export job to write data in an Amazon S3
    /// bucket.</p>
    pub encryption_configuration: std::option::Option<crate::model::S3EncryptionConfiguration>,
}
impl S3ExportConfiguration {
    /// <p>The Amazon S3 bucket name in which a journal export job writes the journal contents.</p>
    /// <p>The bucket name must comply with the Amazon S3 bucket naming conventions. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
    /// Limitations</a> in the <i>Amazon S3 Developer Guide</i>.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The prefix for the Amazon S3 bucket in which a journal export job writes the journal
    /// contents.</p>
    /// <p>The prefix must comply with Amazon S3 key naming rules and restrictions. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a> in the <i>Amazon S3 Developer
    /// Guide</i>.</p>
    /// <p>The following are examples of valid <code>Prefix</code> values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>JournalExports-ForMyLedger/Testing/</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JournalExports</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>My:Tests/</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The encryption settings that are used by a journal export job to write data in an Amazon S3
    /// bucket.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
}
impl std::fmt::Debug for S3ExportConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ExportConfiguration");
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.finish()
    }
}
/// See [`S3ExportConfiguration`](crate::model::S3ExportConfiguration)
pub mod s3_export_configuration {
    /// A builder for [`S3ExportConfiguration`](crate::model::S3ExportConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::S3EncryptionConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name in which a journal export job writes the journal contents.</p>
        /// <p>The bucket name must comply with the Amazon S3 bucket naming conventions. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
        /// Limitations</a> in the <i>Amazon S3 Developer Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket name in which a journal export job writes the journal contents.</p>
        /// <p>The bucket name must comply with the Amazon S3 bucket naming conventions. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
        /// Limitations</a> in the <i>Amazon S3 Developer Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The prefix for the Amazon S3 bucket in which a journal export job writes the journal
        /// contents.</p>
        /// <p>The prefix must comply with Amazon S3 key naming rules and restrictions. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a> in the <i>Amazon S3 Developer
        /// Guide</i>.</p>
        /// <p>The following are examples of valid <code>Prefix</code> values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>JournalExports-ForMyLedger/Testing/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JournalExports</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>My:Tests/</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the Amazon S3 bucket in which a journal export job writes the journal
        /// contents.</p>
        /// <p>The prefix must comply with Amazon S3 key naming rules and restrictions. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a> in the <i>Amazon S3 Developer
        /// Guide</i>.</p>
        /// <p>The following are examples of valid <code>Prefix</code> values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>JournalExports-ForMyLedger/Testing/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JournalExports</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>My:Tests/</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The encryption settings that are used by a journal export job to write data in an Amazon S3
        /// bucket.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::S3EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption settings that are used by a journal export job to write data in an Amazon S3
        /// bucket.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::S3EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ExportConfiguration`](crate::model::S3ExportConfiguration)
        pub fn build(self) -> crate::model::S3ExportConfiguration {
            crate::model::S3ExportConfiguration {
                bucket: self.bucket,
                prefix: self.prefix,
                encryption_configuration: self.encryption_configuration,
            }
        }
    }
}
impl S3ExportConfiguration {
    /// Creates a new builder-style object to manufacture [`S3ExportConfiguration`](crate::model::S3ExportConfiguration)
    pub fn builder() -> crate::model::s3_export_configuration::Builder {
        crate::model::s3_export_configuration::Builder::default()
    }
}

/// <p>The encryption settings that are used by a journal export job to write data in an
/// Amazon Simple Storage Service (Amazon S3) bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3EncryptionConfiguration {
    /// <p>The Amazon S3 object encryption type.</p>
    /// <p>To learn more about server-side encryption options in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data
    /// Using Server-Side Encryption</a> in the <i>Amazon S3 Developer
    /// Guide</i>.</p>
    pub object_encryption_type: std::option::Option<crate::model::S3ObjectEncryptionType>,
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) in Key Management Service
    /// (KMS). Amazon S3 does not support asymmetric CMKs.</p>
    /// <p>You must provide a <code>KmsKeyArn</code> if you specify <code>SSE_KMS</code> as the
    /// <code>ObjectEncryptionType</code>.</p>
    /// <p>
    /// <code>KmsKeyArn</code> is not required if you specify <code>SSE_S3</code> as the
    /// <code>ObjectEncryptionType</code>.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl S3EncryptionConfiguration {
    /// <p>The Amazon S3 object encryption type.</p>
    /// <p>To learn more about server-side encryption options in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data
    /// Using Server-Side Encryption</a> in the <i>Amazon S3 Developer
    /// Guide</i>.</p>
    pub fn object_encryption_type(
        &self,
    ) -> std::option::Option<&crate::model::S3ObjectEncryptionType> {
        self.object_encryption_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) in Key Management Service
    /// (KMS). Amazon S3 does not support asymmetric CMKs.</p>
    /// <p>You must provide a <code>KmsKeyArn</code> if you specify <code>SSE_KMS</code> as the
    /// <code>ObjectEncryptionType</code>.</p>
    /// <p>
    /// <code>KmsKeyArn</code> is not required if you specify <code>SSE_S3</code> as the
    /// <code>ObjectEncryptionType</code>.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for S3EncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3EncryptionConfiguration");
        formatter.field("object_encryption_type", &self.object_encryption_type);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`S3EncryptionConfiguration`](crate::model::S3EncryptionConfiguration)
pub mod s3_encryption_configuration {
    /// A builder for [`S3EncryptionConfiguration`](crate::model::S3EncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_encryption_type:
            std::option::Option<crate::model::S3ObjectEncryptionType>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 object encryption type.</p>
        /// <p>To learn more about server-side encryption options in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data
        /// Using Server-Side Encryption</a> in the <i>Amazon S3 Developer
        /// Guide</i>.</p>
        pub fn object_encryption_type(
            mut self,
            input: crate::model::S3ObjectEncryptionType,
        ) -> Self {
            self.object_encryption_type = Some(input);
            self
        }
        /// <p>The Amazon S3 object encryption type.</p>
        /// <p>To learn more about server-side encryption options in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data
        /// Using Server-Side Encryption</a> in the <i>Amazon S3 Developer
        /// Guide</i>.</p>
        pub fn set_object_encryption_type(
            mut self,
            input: std::option::Option<crate::model::S3ObjectEncryptionType>,
        ) -> Self {
            self.object_encryption_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) in Key Management Service
        /// (KMS). Amazon S3 does not support asymmetric CMKs.</p>
        /// <p>You must provide a <code>KmsKeyArn</code> if you specify <code>SSE_KMS</code> as the
        /// <code>ObjectEncryptionType</code>.</p>
        /// <p>
        /// <code>KmsKeyArn</code> is not required if you specify <code>SSE_S3</code> as the
        /// <code>ObjectEncryptionType</code>.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) in Key Management Service
        /// (KMS). Amazon S3 does not support asymmetric CMKs.</p>
        /// <p>You must provide a <code>KmsKeyArn</code> if you specify <code>SSE_KMS</code> as the
        /// <code>ObjectEncryptionType</code>.</p>
        /// <p>
        /// <code>KmsKeyArn</code> is not required if you specify <code>SSE_S3</code> as the
        /// <code>ObjectEncryptionType</code>.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3EncryptionConfiguration`](crate::model::S3EncryptionConfiguration)
        pub fn build(self) -> crate::model::S3EncryptionConfiguration {
            crate::model::S3EncryptionConfiguration {
                object_encryption_type: self.object_encryption_type,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl S3EncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`S3EncryptionConfiguration`](crate::model::S3EncryptionConfiguration)
    pub fn builder() -> crate::model::s3_encryption_configuration::Builder {
        crate::model::s3_encryption_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ObjectEncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    NoEncryption,
    #[allow(missing_docs)] // documentation missing in model
    SseKms,
    #[allow(missing_docs)] // documentation missing in model
    SseS3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ObjectEncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "NO_ENCRYPTION" => S3ObjectEncryptionType::NoEncryption,
            "SSE_KMS" => S3ObjectEncryptionType::SseKms,
            "SSE_S3" => S3ObjectEncryptionType::SseS3,
            other => S3ObjectEncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ObjectEncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ObjectEncryptionType::from(s))
    }
}
impl S3ObjectEncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ObjectEncryptionType::NoEncryption => "NO_ENCRYPTION",
            S3ObjectEncryptionType::SseKms => "SSE_KMS",
            S3ObjectEncryptionType::SseS3 => "SSE_S3",
            S3ObjectEncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_ENCRYPTION", "SSE_KMS", "SSE_S3"]
    }
}
impl AsRef<str> for S3ObjectEncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => ExportStatus::Cancelled,
            "COMPLETED" => ExportStatus::Completed,
            "IN_PROGRESS" => ExportStatus::InProgress,
            other => ExportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportStatus::from(s))
    }
}
impl ExportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportStatus::Cancelled => "CANCELLED",
            ExportStatus::Completed => "COMPLETED",
            ExportStatus::InProgress => "IN_PROGRESS",
            ExportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "COMPLETED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for ExportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an Amazon QLDB journal stream, including the Amazon Resource Name
/// (ARN), stream name, creation time, current status, and the parameters of the original
/// stream creation request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JournalKinesisStreamDescription {
    /// <p>The name of the ledger.</p>
    pub ledger_name: std::option::Option<std::string::String>,
    /// <p>The date and time, in epoch time format, when the QLDB journal stream was created.
    /// (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970
    /// UTC.)</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The inclusive start date and time from which to start streaming journal data.</p>
    pub inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The exclusive date and time that specifies when the stream ends. If this parameter is
    /// undefined, the stream runs indefinitely until you cancel it.</p>
    pub exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
    /// journal stream to write data records to a Kinesis Data Streams resource.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream.</p>
    pub stream_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the QLDB journal stream.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The current state of the QLDB journal stream.</p>
    pub status: std::option::Option<crate::model::StreamStatus>,
    /// <p>The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal
    /// stream.</p>
    pub kinesis_configuration: std::option::Option<crate::model::KinesisConfiguration>,
    /// <p>The error message that describes the reason that a stream has a status of
    /// <code>IMPAIRED</code> or <code>FAILED</code>. This is not applicable to streams that
    /// have other status values.</p>
    pub error_cause: std::option::Option<crate::model::ErrorCause>,
    /// <p>The user-defined name of the QLDB journal stream.</p>
    pub stream_name: std::option::Option<std::string::String>,
}
impl JournalKinesisStreamDescription {
    /// <p>The name of the ledger.</p>
    pub fn ledger_name(&self) -> std::option::Option<&str> {
        self.ledger_name.as_deref()
    }
    /// <p>The date and time, in epoch time format, when the QLDB journal stream was created.
    /// (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970
    /// UTC.)</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_time.as_ref()
    }
    /// <p>The inclusive start date and time from which to start streaming journal data.</p>
    pub fn inclusive_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.inclusive_start_time.as_ref()
    }
    /// <p>The exclusive date and time that specifies when the stream ends. If this parameter is
    /// undefined, the stream runs indefinitely until you cancel it.</p>
    pub fn exclusive_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.exclusive_end_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
    /// journal stream to write data records to a Kinesis Data Streams resource.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream.</p>
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the QLDB journal stream.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The current state of the QLDB journal stream.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StreamStatus> {
        self.status.as_ref()
    }
    /// <p>The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal
    /// stream.</p>
    pub fn kinesis_configuration(
        &self,
    ) -> std::option::Option<&crate::model::KinesisConfiguration> {
        self.kinesis_configuration.as_ref()
    }
    /// <p>The error message that describes the reason that a stream has a status of
    /// <code>IMPAIRED</code> or <code>FAILED</code>. This is not applicable to streams that
    /// have other status values.</p>
    pub fn error_cause(&self) -> std::option::Option<&crate::model::ErrorCause> {
        self.error_cause.as_ref()
    }
    /// <p>The user-defined name of the QLDB journal stream.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
}
impl std::fmt::Debug for JournalKinesisStreamDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JournalKinesisStreamDescription");
        formatter.field("ledger_name", &self.ledger_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("inclusive_start_time", &self.inclusive_start_time);
        formatter.field("exclusive_end_time", &self.exclusive_end_time);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("stream_id", &self.stream_id);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("kinesis_configuration", &self.kinesis_configuration);
        formatter.field("error_cause", &self.error_cause);
        formatter.field("stream_name", &self.stream_name);
        formatter.finish()
    }
}
/// See [`JournalKinesisStreamDescription`](crate::model::JournalKinesisStreamDescription)
pub mod journal_kinesis_stream_description {
    /// A builder for [`JournalKinesisStreamDescription`](crate::model::JournalKinesisStreamDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ledger_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StreamStatus>,
        pub(crate) kinesis_configuration: std::option::Option<crate::model::KinesisConfiguration>,
        pub(crate) error_cause: std::option::Option<crate::model::ErrorCause>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ledger_name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ledger_name = input;
            self
        }
        /// <p>The date and time, in epoch time format, when the QLDB journal stream was created.
        /// (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970
        /// UTC.)</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time, in epoch time format, when the QLDB journal stream was created.
        /// (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970
        /// UTC.)</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data.</p>
        pub fn inclusive_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.inclusive_start_time = Some(input);
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inclusive_start_time = input;
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If this parameter is
        /// undefined, the stream runs indefinitely until you cancel it.</p>
        pub fn exclusive_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.exclusive_end_time = Some(input);
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If this parameter is
        /// undefined, the stream runs indefinitely until you cancel it.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.exclusive_end_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal stream to write data records to a Kinesis Data Streams resource.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal stream to write data records to a Kinesis Data Streams resource.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the QLDB journal stream.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the QLDB journal stream.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The current state of the QLDB journal stream.</p>
        pub fn status(mut self, input: crate::model::StreamStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the QLDB journal stream.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StreamStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal
        /// stream.</p>
        pub fn kinesis_configuration(mut self, input: crate::model::KinesisConfiguration) -> Self {
            self.kinesis_configuration = Some(input);
            self
        }
        /// <p>The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal
        /// stream.</p>
        pub fn set_kinesis_configuration(
            mut self,
            input: std::option::Option<crate::model::KinesisConfiguration>,
        ) -> Self {
            self.kinesis_configuration = input;
            self
        }
        /// <p>The error message that describes the reason that a stream has a status of
        /// <code>IMPAIRED</code> or <code>FAILED</code>. This is not applicable to streams that
        /// have other status values.</p>
        pub fn error_cause(mut self, input: crate::model::ErrorCause) -> Self {
            self.error_cause = Some(input);
            self
        }
        /// <p>The error message that describes the reason that a stream has a status of
        /// <code>IMPAIRED</code> or <code>FAILED</code>. This is not applicable to streams that
        /// have other status values.</p>
        pub fn set_error_cause(
            mut self,
            input: std::option::Option<crate::model::ErrorCause>,
        ) -> Self {
            self.error_cause = input;
            self
        }
        /// <p>The user-defined name of the QLDB journal stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The user-defined name of the QLDB journal stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`JournalKinesisStreamDescription`](crate::model::JournalKinesisStreamDescription)
        pub fn build(self) -> crate::model::JournalKinesisStreamDescription {
            crate::model::JournalKinesisStreamDescription {
                ledger_name: self.ledger_name,
                creation_time: self.creation_time,
                inclusive_start_time: self.inclusive_start_time,
                exclusive_end_time: self.exclusive_end_time,
                role_arn: self.role_arn,
                stream_id: self.stream_id,
                arn: self.arn,
                status: self.status,
                kinesis_configuration: self.kinesis_configuration,
                error_cause: self.error_cause,
                stream_name: self.stream_name,
            }
        }
    }
}
impl JournalKinesisStreamDescription {
    /// Creates a new builder-style object to manufacture [`JournalKinesisStreamDescription`](crate::model::JournalKinesisStreamDescription)
    pub fn builder() -> crate::model::journal_kinesis_stream_description::Builder {
        crate::model::journal_kinesis_stream_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCause {
    #[allow(missing_docs)] // documentation missing in model
    IamPermissionRevoked,
    #[allow(missing_docs)] // documentation missing in model
    KinesisStreamNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCause {
    fn from(s: &str) -> Self {
        match s {
            "IAM_PERMISSION_REVOKED" => ErrorCause::IamPermissionRevoked,
            "KINESIS_STREAM_NOT_FOUND" => ErrorCause::KinesisStreamNotFound,
            other => ErrorCause::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCause {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCause::from(s))
    }
}
impl ErrorCause {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCause::IamPermissionRevoked => "IAM_PERMISSION_REVOKED",
            ErrorCause::KinesisStreamNotFound => "KINESIS_STREAM_NOT_FOUND",
            ErrorCause::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IAM_PERMISSION_REVOKED", "KINESIS_STREAM_NOT_FOUND"]
    }
}
impl AsRef<str> for ErrorCause {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Impaired,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => StreamStatus::Active,
            "CANCELED" => StreamStatus::Canceled,
            "COMPLETED" => StreamStatus::Completed,
            "FAILED" => StreamStatus::Failed,
            "IMPAIRED" => StreamStatus::Impaired,
            other => StreamStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamStatus::from(s))
    }
}
impl StreamStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamStatus::Active => "ACTIVE",
            StreamStatus::Canceled => "CANCELED",
            StreamStatus::Completed => "COMPLETED",
            StreamStatus::Failed => "FAILED",
            StreamStatus::Impaired => "IMPAIRED",
            StreamStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CANCELED", "COMPLETED", "FAILED", "IMPAIRED"]
    }
}
impl AsRef<str> for StreamStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that can contain a value in multiple encoding formats.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValueHolder {
    /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
    pub ion_text: std::option::Option<std::string::String>,
}
impl ValueHolder {
    /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
    pub fn ion_text(&self) -> std::option::Option<&str> {
        self.ion_text.as_deref()
    }
}
impl std::fmt::Debug for ValueHolder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValueHolder");
        formatter.field("ion_text", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ValueHolder`](crate::model::ValueHolder)
pub mod value_holder {
    /// A builder for [`ValueHolder`](crate::model::ValueHolder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ion_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
        pub fn ion_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.ion_text = Some(input.into());
            self
        }
        /// <p>An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.</p>
        pub fn set_ion_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ion_text = input;
            self
        }
        /// Consumes the builder and constructs a [`ValueHolder`](crate::model::ValueHolder)
        pub fn build(self) -> crate::model::ValueHolder {
            crate::model::ValueHolder {
                ion_text: self.ion_text,
            }
        }
    }
}
impl ValueHolder {
    /// Creates a new builder-style object to manufacture [`ValueHolder`](crate::model::ValueHolder)
    pub fn builder() -> crate::model::value_holder::Builder {
        crate::model::value_holder::Builder::default()
    }
}
