// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelJournalKinesisStreamInput`](crate::input::CancelJournalKinesisStreamInput)
pub mod cancel_journal_kinesis_stream_input {
    /// A builder for [`CancelJournalKinesisStreamInput`](crate::input::CancelJournalKinesisStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ledger_name: std::option::Option<std::string::String>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ledger_name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ledger_name = input;
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be
        /// canceled.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be
        /// canceled.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelJournalKinesisStreamInput`](crate::input::CancelJournalKinesisStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelJournalKinesisStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelJournalKinesisStreamInput {
                ledger_name: self.ledger_name,
                stream_id: self.stream_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelJournalKinesisStreamInputOperationOutputAlias =
    crate::operation::CancelJournalKinesisStream;
#[doc(hidden)]
pub type CancelJournalKinesisStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelJournalKinesisStreamInput {
    /// Consumes the builder and constructs an Operation<[`CancelJournalKinesisStream`](crate::operation::CancelJournalKinesisStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelJournalKinesisStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelJournalKinesisStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.ledger_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ledger_name",
                        details: "cannot be empty or unset",
                    })?;
            let ledger_name = aws_smithy_http::label::fmt_string(input_1, false);
            if ledger_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ledger_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.stream_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    })?;
            let stream_id = aws_smithy_http::label::fmt_string(input_2, false);
            if stream_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stream_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/ledgers/{LedgerName}/journal-kinesis-streams/{StreamId}",
                LedgerName = ledger_name,
                StreamId = stream_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelJournalKinesisStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelJournalKinesisStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelJournalKinesisStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelJournalKinesisStream",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelJournalKinesisStreamInput`](crate::input::CancelJournalKinesisStreamInput)
    pub fn builder() -> crate::input::cancel_journal_kinesis_stream_input::Builder {
        crate::input::cancel_journal_kinesis_stream_input::Builder::default()
    }
}

/// See [`CreateLedgerInput`](crate::input::CreateLedgerInput)
pub mod create_ledger_input {
    /// A builder for [`CreateLedgerInput`](crate::input::CreateLedgerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::option::Option<std::string::String>,
            >,
        >,
        pub(crate) permissions_mode: std::option::Option<crate::model::PermissionsMode>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger that you want to create. The name must be unique among all of
        /// the ledgers in your account in the current Region.</p>
        /// <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a>
        /// in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger that you want to create. The name must be unique among all of
        /// the ledgers in your account in the current Region.</p>
        /// <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a>
        /// in the <i>Amazon QLDB Developer Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::option::Option<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The permissions mode to assign to the ledger that you want to create. This parameter can
        /// have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn permissions_mode(mut self, input: crate::model::PermissionsMode) -> Self {
            self.permissions_mode = Some(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger that you want to create. This parameter can
        /// have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn set_permissions_mode(
            mut self,
            input: std::option::Option<crate::model::PermissionsMode>,
        ) -> Self {
            self.permissions_mode = input;
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: By default, use an Amazon Web Services owned KMS
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: By default, use an Amazon Web Services owned KMS
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLedgerInput`](crate::input::CreateLedgerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLedgerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLedgerInput {
                name: self.name,
                tags: self.tags,
                permissions_mode: self.permissions_mode,
                deletion_protection: self.deletion_protection,
                kms_key: self.kms_key,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLedgerInputOperationOutputAlias = crate::operation::CreateLedger;
#[doc(hidden)]
pub type CreateLedgerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLedgerInput {
    /// Consumes the builder and constructs an Operation<[`CreateLedger`](crate::operation::CreateLedger)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLedger,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLedgerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ledgers").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLedgerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLedgerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_ledger(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLedger::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLedger",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLedgerInput`](crate::input::CreateLedgerInput)
    pub fn builder() -> crate::input::create_ledger_input::Builder {
        crate::input::create_ledger_input::Builder::default()
    }
}

/// See [`DeleteLedgerInput`](crate::input::DeleteLedgerInput)
pub mod delete_ledger_input {
    /// A builder for [`DeleteLedgerInput`](crate::input::DeleteLedgerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger that you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger that you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLedgerInput`](crate::input::DeleteLedgerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLedgerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLedgerInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteLedgerInputOperationOutputAlias = crate::operation::DeleteLedger;
#[doc(hidden)]
pub type DeleteLedgerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLedgerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLedger`](crate::operation::DeleteLedger)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLedger,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLedgerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_3, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLedgerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLedgerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLedger::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLedger",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLedgerInput`](crate::input::DeleteLedgerInput)
    pub fn builder() -> crate::input::delete_ledger_input::Builder {
        crate::input::delete_ledger_input::Builder::default()
    }
}

/// See [`DescribeJournalKinesisStreamInput`](crate::input::DescribeJournalKinesisStreamInput)
pub mod describe_journal_kinesis_stream_input {
    /// A builder for [`DescribeJournalKinesisStreamInput`](crate::input::DescribeJournalKinesisStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ledger_name: std::option::Option<std::string::String>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ledger_name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ledger_name = input;
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to
        /// describe.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to
        /// describe.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJournalKinesisStreamInput`](crate::input::DescribeJournalKinesisStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJournalKinesisStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJournalKinesisStreamInput {
                ledger_name: self.ledger_name,
                stream_id: self.stream_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJournalKinesisStreamInputOperationOutputAlias =
    crate::operation::DescribeJournalKinesisStream;
#[doc(hidden)]
pub type DescribeJournalKinesisStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeJournalKinesisStreamInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJournalKinesisStream`](crate::operation::DescribeJournalKinesisStream)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJournalKinesisStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJournalKinesisStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.ledger_name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ledger_name",
                        details: "cannot be empty or unset",
                    })?;
            let ledger_name = aws_smithy_http::label::fmt_string(input_4, false);
            if ledger_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ledger_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.stream_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    })?;
            let stream_id = aws_smithy_http::label::fmt_string(input_5, false);
            if stream_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "stream_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/ledgers/{LedgerName}/journal-kinesis-streams/{StreamId}",
                LedgerName = ledger_name,
                StreamId = stream_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJournalKinesisStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJournalKinesisStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJournalKinesisStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJournalKinesisStream",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJournalKinesisStreamInput`](crate::input::DescribeJournalKinesisStreamInput)
    pub fn builder() -> crate::input::describe_journal_kinesis_stream_input::Builder {
        crate::input::describe_journal_kinesis_stream_input::Builder::default()
    }
}

/// See [`DescribeJournalS3ExportInput`](crate::input::DescribeJournalS3ExportInput)
pub mod describe_journal_s3_export_input {
    /// A builder for [`DescribeJournalS3ExportInput`](crate::input::DescribeJournalS3ExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) export_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job to
        /// describe.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the journal export job to
        /// describe.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJournalS3ExportInput`](crate::input::DescribeJournalS3ExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJournalS3ExportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJournalS3ExportInput {
                name: self.name,
                export_id: self.export_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJournalS3ExportInputOperationOutputAlias =
    crate::operation::DescribeJournalS3Export;
#[doc(hidden)]
pub type DescribeJournalS3ExportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeJournalS3ExportInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJournalS3Export`](crate::operation::DescribeJournalS3Export)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJournalS3Export,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJournalS3ExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_6, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.export_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "export_id",
                        details: "cannot be empty or unset",
                    })?;
            let export_id = aws_smithy_http::label::fmt_string(input_7, false);
            if export_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "export_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/ledgers/{Name}/journal-s3-exports/{ExportId}",
                Name = name,
                ExportId = export_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJournalS3ExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJournalS3ExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJournalS3Export::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJournalS3Export",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJournalS3ExportInput`](crate::input::DescribeJournalS3ExportInput)
    pub fn builder() -> crate::input::describe_journal_s3_export_input::Builder {
        crate::input::describe_journal_s3_export_input::Builder::default()
    }
}

/// See [`DescribeLedgerInput`](crate::input::DescribeLedgerInput)
pub mod describe_ledger_input {
    /// A builder for [`DescribeLedgerInput`](crate::input::DescribeLedgerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger that you want to describe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger that you want to describe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLedgerInput`](crate::input::DescribeLedgerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLedgerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLedgerInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeLedgerInputOperationOutputAlias = crate::operation::DescribeLedger;
#[doc(hidden)]
pub type DescribeLedgerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLedgerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLedger`](crate::operation::DescribeLedger)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLedger,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLedgerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_8, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLedgerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLedgerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLedger::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLedger",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLedgerInput`](crate::input::DescribeLedgerInput)
    pub fn builder() -> crate::input::describe_ledger_input::Builder {
        crate::input::describe_ledger_input::Builder::default()
    }
}

/// See [`ExportJournalToS3Input`](crate::input::ExportJournalToS3Input)
pub mod export_journal_to_s3_input {
    /// A builder for [`ExportJournalToS3Input`](crate::input::ExportJournalToS3Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) s3_export_configuration:
            std::option::Option<crate::model::S3ExportConfiguration>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents to export.</p>
        /// <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time
        /// format and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn inclusive_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.inclusive_start_time = Some(input);
            self
        }
        /// <p>The inclusive start date and time for the range of journal contents to export.</p>
        /// <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time
        /// format and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inclusive_start_time = input;
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents to export.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and
        /// time.</p>
        pub fn exclusive_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.exclusive_end_time = Some(input);
            self
        }
        /// <p>The exclusive end date and time for the range of journal contents to export.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and
        /// time.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.exclusive_end_time = input;
            self
        }
        /// <p>The configuration settings of the Amazon S3 bucket destination for your export
        /// request.</p>
        pub fn s3_export_configuration(
            mut self,
            input: crate::model::S3ExportConfiguration,
        ) -> Self {
            self.s3_export_configuration = Some(input);
            self
        }
        /// <p>The configuration settings of the Amazon S3 bucket destination for your export
        /// request.</p>
        pub fn set_s3_export_configuration(
            mut self,
            input: std::option::Option<crate::model::S3ExportConfiguration>,
        ) -> Self {
            self.s3_export_configuration = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal export job to do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
        /// </li>
        /// <li>
        /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
        /// encryption of your exported data.</p>
        /// </li>
        /// </ul>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal export job to do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
        /// </li>
        /// <li>
        /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
        /// encryption of your exported data.</p>
        /// </li>
        /// </ul>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportJournalToS3Input`](crate::input::ExportJournalToS3Input)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportJournalToS3Input,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportJournalToS3Input {
                name: self.name,
                inclusive_start_time: self.inclusive_start_time,
                exclusive_end_time: self.exclusive_end_time,
                s3_export_configuration: self.s3_export_configuration,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportJournalToS3InputOperationOutputAlias = crate::operation::ExportJournalToS3;
#[doc(hidden)]
pub type ExportJournalToS3InputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExportJournalToS3Input {
    /// Consumes the builder and constructs an Operation<[`ExportJournalToS3`](crate::operation::ExportJournalToS3)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportJournalToS3,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportJournalToS3Input,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_9, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}/journal-s3-exports", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportJournalToS3Input,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportJournalToS3Input,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_export_journal_to_s3(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportJournalToS3::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportJournalToS3",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportJournalToS3Input`](crate::input::ExportJournalToS3Input)
    pub fn builder() -> crate::input::export_journal_to_s3_input::Builder {
        crate::input::export_journal_to_s3_input::Builder::default()
    }
}

/// See [`GetBlockInput`](crate::input::GetBlockInput)
pub mod get_block_input {
    /// A builder for [`GetBlockInput`](crate::input::GetBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) block_address: std::option::Option<crate::model::ValueHolder>,
        pub(crate) digest_tip_address: std::option::Option<crate::model::ValueHolder>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The location of the block that you want to request. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn block_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.block_address = Some(input);
            self
        }
        /// <p>The location of the block that you want to request. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn set_block_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.block_address = input;
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn digest_tip_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.digest_tip_address = Some(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn set_digest_tip_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.digest_tip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlockInput`](crate::input::GetBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBlockInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBlockInput {
                name: self.name,
                block_address: self.block_address,
                digest_tip_address: self.digest_tip_address,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBlockInputOperationOutputAlias = crate::operation::GetBlock;
#[doc(hidden)]
pub type GetBlockInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBlockInput {
    /// Consumes the builder and constructs an Operation<[`GetBlock`](crate::operation::GetBlock)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBlock,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_10, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}/block", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_block(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBlock::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetBlock", "qldb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBlockInput`](crate::input::GetBlockInput)
    pub fn builder() -> crate::input::get_block_input::Builder {
        crate::input::get_block_input::Builder::default()
    }
}

/// See [`GetDigestInput`](crate::input::GetDigestInput)
pub mod get_digest_input {
    /// A builder for [`GetDigestInput`](crate::input::GetDigestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDigestInput`](crate::input::GetDigestInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDigestInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDigestInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetDigestInputOperationOutputAlias = crate::operation::GetDigest;
#[doc(hidden)]
pub type GetDigestInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDigestInput {
    /// Consumes the builder and constructs an Operation<[`GetDigest`](crate::operation::GetDigest)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDigest,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDigestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_11, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}/digest", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDigestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDigestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDigest::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDigest",
                    "qldb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDigestInput`](crate::input::GetDigestInput)
    pub fn builder() -> crate::input::get_digest_input::Builder {
        crate::input::get_digest_input::Builder::default()
    }
}

/// See [`GetRevisionInput`](crate::input::GetRevisionInput)
pub mod get_revision_input {
    /// A builder for [`GetRevisionInput`](crate::input::GetRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) block_address: std::option::Option<crate::model::ValueHolder>,
        pub(crate) document_id: std::option::Option<std::string::String>,
        pub(crate) digest_tip_address: std::option::Option<crate::model::ValueHolder>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The block location of the document revision to be verified. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn block_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.block_address = Some(input);
            self
        }
        /// <p>The block location of the document revision to be verified. An address is an Amazon Ion
        /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
        pub fn set_block_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.block_address = input;
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
        pub fn document_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_id = Some(input.into());
            self
        }
        /// <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
        pub fn set_document_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document_id = input;
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn digest_tip_address(mut self, input: crate::model::ValueHolder) -> Self {
            self.digest_tip_address = Some(input);
            self
        }
        /// <p>The latest block location covered by the digest for which to request a proof. An address
        /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
        /// <code>sequenceNo</code>.</p>
        /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
        pub fn set_digest_tip_address(
            mut self,
            input: std::option::Option<crate::model::ValueHolder>,
        ) -> Self {
            self.digest_tip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRevisionInput`](crate::input::GetRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRevisionInput {
                name: self.name,
                block_address: self.block_address,
                document_id: self.document_id,
                digest_tip_address: self.digest_tip_address,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRevisionInputOperationOutputAlias = crate::operation::GetRevision;
#[doc(hidden)]
pub type GetRevisionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRevisionInput {
    /// Consumes the builder and constructs an Operation<[`GetRevision`](crate::operation::GetRevision)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRevision,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.name;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_12, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}/revision", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_revision(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRevision",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRevisionInput`](crate::input::GetRevisionInput)
    pub fn builder() -> crate::input::get_revision_input::Builder {
        crate::input::get_revision_input::Builder::default()
    }
}

/// See [`ListJournalKinesisStreamsForLedgerInput`](crate::input::ListJournalKinesisStreamsForLedgerInput)
pub mod list_journal_kinesis_streams_for_ledger_input {
    /// A builder for [`ListJournalKinesisStreamsForLedgerInput`](crate::input::ListJournalKinesisStreamsForLedgerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ledger_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ledger_name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ledger_name = input;
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input
        /// here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input
        /// here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJournalKinesisStreamsForLedgerInput`](crate::input::ListJournalKinesisStreamsForLedgerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListJournalKinesisStreamsForLedgerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListJournalKinesisStreamsForLedgerInput {
                ledger_name: self.ledger_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJournalKinesisStreamsForLedgerInputOperationOutputAlias =
    crate::operation::ListJournalKinesisStreamsForLedger;
#[doc(hidden)]
pub type ListJournalKinesisStreamsForLedgerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListJournalKinesisStreamsForLedgerInput {
    /// Consumes the builder and constructs an Operation<[`ListJournalKinesisStreamsForLedger`](crate::operation::ListJournalKinesisStreamsForLedger)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJournalKinesisStreamsForLedger,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJournalKinesisStreamsForLedgerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.ledger_name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ledger_name",
                        details: "cannot be empty or unset",
                    })?;
            let ledger_name = aws_smithy_http::label::fmt_string(input_13, false);
            if ledger_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ledger_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/ledgers/{LedgerName}/journal-kinesis-streams",
                LedgerName = ledger_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListJournalKinesisStreamsForLedgerInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_14).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_15));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJournalKinesisStreamsForLedgerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJournalKinesisStreamsForLedgerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListJournalKinesisStreamsForLedger::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListJournalKinesisStreamsForLedger",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJournalKinesisStreamsForLedgerInput`](crate::input::ListJournalKinesisStreamsForLedgerInput)
    pub fn builder() -> crate::input::list_journal_kinesis_streams_for_ledger_input::Builder {
        crate::input::list_journal_kinesis_streams_for_ledger_input::Builder::default()
    }
}

/// See [`ListJournalS3ExportsInput`](crate::input::ListJournalS3ExportsInput)
pub mod list_journal_s3_exports_input {
    /// A builder for [`ListJournalS3ExportsInput`](crate::input::ListJournalS3ExportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code>
        /// request. (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code>
        /// request. (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3Exports</code> call, then you should use that value as input
        /// here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3Exports</code> call, then you should use that value as input
        /// here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJournalS3ExportsInput`](crate::input::ListJournalS3ExportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListJournalS3ExportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListJournalS3ExportsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJournalS3ExportsInputOperationOutputAlias = crate::operation::ListJournalS3Exports;
#[doc(hidden)]
pub type ListJournalS3ExportsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListJournalS3ExportsInput {
    /// Consumes the builder and constructs an Operation<[`ListJournalS3Exports`](crate::operation::ListJournalS3Exports)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJournalS3Exports,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJournalS3ExportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/journal-s3-exports").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListJournalS3ExportsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_16).encode(),
                );
            }
            if let Some(inner_17) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_17));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJournalS3ExportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJournalS3ExportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListJournalS3Exports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListJournalS3Exports",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJournalS3ExportsInput`](crate::input::ListJournalS3ExportsInput)
    pub fn builder() -> crate::input::list_journal_s3_exports_input::Builder {
        crate::input::list_journal_s3_exports_input::Builder::default()
    }
}

/// See [`ListJournalS3ExportsForLedgerInput`](crate::input::ListJournalS3ExportsForLedgerInput)
pub mod list_journal_s3_exports_for_ledger_input {
    /// A builder for [`ListJournalS3ExportsForLedgerInput`](crate::input::ListJournalS3ExportsForLedgerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single
        /// <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results
        /// returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input
        /// here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input
        /// here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJournalS3ExportsForLedgerInput`](crate::input::ListJournalS3ExportsForLedgerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListJournalS3ExportsForLedgerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListJournalS3ExportsForLedgerInput {
                name: self.name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJournalS3ExportsForLedgerInputOperationOutputAlias =
    crate::operation::ListJournalS3ExportsForLedger;
#[doc(hidden)]
pub type ListJournalS3ExportsForLedgerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListJournalS3ExportsForLedgerInput {
    /// Consumes the builder and constructs an Operation<[`ListJournalS3ExportsForLedger`](crate::operation::ListJournalS3ExportsForLedger)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJournalS3ExportsForLedger,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJournalS3ExportsForLedgerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.name;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_18, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}/journal-s3-exports", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListJournalS3ExportsForLedgerInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_19) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_19).encode(),
                );
            }
            if let Some(inner_20) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_20));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJournalS3ExportsForLedgerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJournalS3ExportsForLedgerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListJournalS3ExportsForLedger::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListJournalS3ExportsForLedger",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJournalS3ExportsForLedgerInput`](crate::input::ListJournalS3ExportsForLedgerInput)
    pub fn builder() -> crate::input::list_journal_s3_exports_for_ledger_input::Builder {
        crate::input::list_journal_s3_exports_for_ledger_input::Builder::default()
    }
}

/// See [`ListLedgersInput`](crate::input::ListLedgersInput)
pub mod list_ledgers_input {
    /// A builder for [`ListLedgersInput`](crate::input::ListLedgersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in a single <code>ListLedgers</code> request.
        /// (The actual number of results returned might be fewer.)</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single <code>ListLedgers</code> request.
        /// (The actual number of results returned might be fewer.)</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListLedgers</code> call, then you should use that value as input here.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
        /// you received a value for <code>NextToken</code> in the response from a previous
        /// <code>ListLedgers</code> call, then you should use that value as input here.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLedgersInput`](crate::input::ListLedgersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLedgersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLedgersInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLedgersInputOperationOutputAlias = crate::operation::ListLedgers;
#[doc(hidden)]
pub type ListLedgersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLedgersInput {
    /// Consumes the builder and constructs an Operation<[`ListLedgers`](crate::operation::ListLedgers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLedgers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLedgersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ledgers").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListLedgersInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.max_results {
                query.push_kv(
                    "max_results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_21).encode(),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("next_token", &aws_smithy_http::query::fmt_string(&inner_22));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLedgersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLedgersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLedgers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLedgers",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLedgersInput`](crate::input::ListLedgersInput)
    pub fn builder() -> crate::input::list_ledgers_input::Builder {
        crate::input::list_ledgers_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.resource_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_23, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StreamJournalToKinesisInput`](crate::input::StreamJournalToKinesisInput)
pub mod stream_journal_to_kinesis_input {
    /// A builder for [`StreamJournalToKinesisInput`](crate::input::StreamJournalToKinesisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ledger_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::option::Option<std::string::String>,
            >,
        >,
        pub(crate) inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) kinesis_configuration: std::option::Option<crate::model::KinesisConfiguration>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn ledger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ledger_name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_ledger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ledger_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal stream to write data records to a Kinesis Data Streams resource.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
        /// journal stream to write data records to a Kinesis Data Streams resource.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::option::Option<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are
        /// case sensitive. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data. This
        /// parameter must be in <code>ISO 8601</code> date and time format and in Universal
        /// Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before
        /// <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn inclusive_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.inclusive_start_time = Some(input);
            self
        }
        /// <p>The inclusive start date and time from which to start streaming journal data. This
        /// parameter must be in <code>ISO 8601</code> date and time format and in Universal
        /// Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
        /// <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before
        /// <code>ExclusiveEndTime</code>.</p>
        /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
        /// <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's
        /// <code>CreationDateTime</code>.</p>
        pub fn set_inclusive_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inclusive_start_time = input;
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If you don't define
        /// this parameter, the stream runs indefinitely until you cancel it.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        pub fn exclusive_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.exclusive_end_time = Some(input);
            self
        }
        /// <p>The exclusive date and time that specifies when the stream ends. If you don't define
        /// this parameter, the stream runs indefinitely until you cancel it.</p>
        /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
        /// and in Universal Coordinated Time (UTC). For example:
        /// <code>2019-06-13T21:36:34Z</code>.</p>
        pub fn set_exclusive_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.exclusive_end_time = input;
            self
        }
        /// <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
        pub fn kinesis_configuration(mut self, input: crate::model::KinesisConfiguration) -> Self {
            self.kinesis_configuration = Some(input);
            self
        }
        /// <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
        pub fn set_kinesis_configuration(
            mut self,
            input: std::option::Option<crate::model::KinesisConfiguration>,
        ) -> Self {
            self.kinesis_configuration = input;
            self
        }
        /// <p>The name that you want to assign to the QLDB journal stream. User-defined names can
        /// help identify and indicate the purpose of a stream.</p>
        /// <p>Your stream name must be unique among other <i>active</i> streams for a
        /// given ledger. Stream names have the same naming constraints as ledger names, as defined in
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer
        /// Guide</i>.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name that you want to assign to the QLDB journal stream. User-defined names can
        /// help identify and indicate the purpose of a stream.</p>
        /// <p>Your stream name must be unique among other <i>active</i> streams for a
        /// given ledger. Stream names have the same naming constraints as ledger names, as defined in
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer
        /// Guide</i>.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamJournalToKinesisInput`](crate::input::StreamJournalToKinesisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StreamJournalToKinesisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StreamJournalToKinesisInput {
                ledger_name: self.ledger_name,
                role_arn: self.role_arn,
                tags: self.tags,
                inclusive_start_time: self.inclusive_start_time,
                exclusive_end_time: self.exclusive_end_time,
                kinesis_configuration: self.kinesis_configuration,
                stream_name: self.stream_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StreamJournalToKinesisInputOperationOutputAlias = crate::operation::StreamJournalToKinesis;
#[doc(hidden)]
pub type StreamJournalToKinesisInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StreamJournalToKinesisInput {
    /// Consumes the builder and constructs an Operation<[`StreamJournalToKinesis`](crate::operation::StreamJournalToKinesis)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StreamJournalToKinesis,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StreamJournalToKinesisInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.ledger_name;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ledger_name",
                        details: "cannot be empty or unset",
                    })?;
            let ledger_name = aws_smithy_http::label::fmt_string(input_24, false);
            if ledger_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ledger_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/ledgers/{LedgerName}/journal-kinesis-streams",
                LedgerName = ledger_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StreamJournalToKinesisInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StreamJournalToKinesisInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stream_journal_to_kinesis(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StreamJournalToKinesis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StreamJournalToKinesis",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StreamJournalToKinesisInput`](crate::input::StreamJournalToKinesisInput)
    pub fn builder() -> crate::input::stream_journal_to_kinesis_input::Builder {
        crate::input::stream_journal_to_kinesis_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::option::Option<std::string::String>,
            >,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case
        /// sensitive. If you specify a key that already exists for the resource, your request fails
        /// and returns an error. Tag values are case sensitive and can be null.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::option::Option<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case
        /// sensitive. If you specify a key that already exists for the resource, your request fails
        /// and returns an error. Tag values are case sensitive and can be null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::option::Option<std::string::String>,
                >,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.resource_arn;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_25, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>
        /// <p>
        /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.resource_arn;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_26, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_27) = &_input.tag_keys {
                for inner_28 in inner_27 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_28));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateLedgerInput`](crate::input::UpdateLedgerInput)
pub mod update_ledger_input {
    /// A builder for [`UpdateLedgerInput`](crate::input::UpdateLedgerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
        /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
        /// <p>If deletion protection is enabled, you must first disable it before you can delete the
        /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: Make no changes to the KMS key of the
        /// ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
        /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
        /// the <i>Amazon QLDB Developer Guide</i>.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
        /// on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Undefined</b>: Make no changes to the KMS key of the
        /// ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b>: Use
        /// the specified KMS key in your account that you create, own, and manage.</p>
        /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
        /// Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
        /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
        /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
        /// ARN or alias ARN.</p>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias ARN:
        /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
        /// the <i>Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLedgerInput`](crate::input::UpdateLedgerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLedgerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLedgerInput {
                name: self.name,
                deletion_protection: self.deletion_protection,
                kms_key: self.kms_key,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLedgerInputOperationOutputAlias = crate::operation::UpdateLedger;
#[doc(hidden)]
pub type UpdateLedgerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateLedgerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLedger`](crate::operation::UpdateLedger)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLedger,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLedgerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.name;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_29, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}", Name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLedgerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLedgerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_ledger(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLedger::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLedger",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLedgerInput`](crate::input::UpdateLedgerInput)
    pub fn builder() -> crate::input::update_ledger_input::Builder {
        crate::input::update_ledger_input::Builder::default()
    }
}

/// See [`UpdateLedgerPermissionsModeInput`](crate::input::UpdateLedgerPermissionsModeInput)
pub mod update_ledger_permissions_mode_input {
    /// A builder for [`UpdateLedgerPermissionsModeInput`](crate::input::UpdateLedgerPermissionsModeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) permissions_mode: std::option::Option<crate::model::PermissionsMode>,
    }
    impl Builder {
        /// <p>The name of the ledger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the ledger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The permissions mode to assign to the ledger. This parameter can have one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn permissions_mode(mut self, input: crate::model::PermissionsMode) -> Self {
            self.permissions_mode = Some(input);
            self
        }
        /// <p>The permissions mode to assign to the ledger. This parameter can have one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
        /// API-level granularity for ledgers.</p>
        /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
        /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
        /// in the specified ledger. This mode disregards any table-level or command-level IAM
        /// permissions policies that you create for the ledger.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
        /// enables access control with finer granularity for ledgers, tables, and PartiQL
        /// commands.</p>
        /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
        /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
        /// permissions policies for specific table resources and PartiQL actions, in addition to
        /// the <code>SendCommand</code> API permission for the ledger. For information, see
        /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
        /// started with the standard permissions mode</a> in the <i>Amazon QLDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
        /// the security of your ledger data.</p>
        /// </note>
        pub fn set_permissions_mode(
            mut self,
            input: std::option::Option<crate::model::PermissionsMode>,
        ) -> Self {
            self.permissions_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLedgerPermissionsModeInput`](crate::input::UpdateLedgerPermissionsModeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLedgerPermissionsModeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLedgerPermissionsModeInput {
                name: self.name,
                permissions_mode: self.permissions_mode,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLedgerPermissionsModeInputOperationOutputAlias =
    crate::operation::UpdateLedgerPermissionsMode;
#[doc(hidden)]
pub type UpdateLedgerPermissionsModeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateLedgerPermissionsModeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLedgerPermissionsMode`](crate::operation::UpdateLedgerPermissionsMode)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLedgerPermissionsMode,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLedgerPermissionsModeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.name;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_30, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/ledgers/{Name}/permissions-mode", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLedgerPermissionsModeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLedgerPermissionsModeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_ledger_permissions_mode(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLedgerPermissionsMode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLedgerPermissionsMode",
            "qldb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLedgerPermissionsModeInput`](crate::input::UpdateLedgerPermissionsModeInput)
    pub fn builder() -> crate::input::update_ledger_permissions_mode_input::Builder {
        crate::input::update_ledger_permissions_mode_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLedgerPermissionsModeInput {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The permissions mode to assign to the ledger. This parameter can have one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
    /// API-level granularity for ledgers.</p>
    /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
    /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
    /// in the specified ledger. This mode disregards any table-level or command-level IAM
    /// permissions policies that you create for the ledger.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
    /// enables access control with finer granularity for ledgers, tables, and PartiQL
    /// commands.</p>
    /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
    /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
    /// permissions policies for specific table resources and PartiQL actions, in addition to
    /// the <code>SendCommand</code> API permission for the ledger. For information, see
    /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
    /// started with the standard permissions mode</a> in the <i>Amazon QLDB
    /// Developer Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
    /// the security of your ledger data.</p>
    /// </note>
    pub permissions_mode: std::option::Option<crate::model::PermissionsMode>,
}
impl std::fmt::Debug for UpdateLedgerPermissionsModeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLedgerPermissionsModeInput");
        formatter.field("name", &self.name);
        formatter.field("permissions_mode", &self.permissions_mode);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLedgerInput {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
    /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
    /// <p>If deletion protection is enabled, you must first disable it before you can delete the
    /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
    /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
    /// the <i>Amazon QLDB Developer Guide</i>.</p>
    /// <p>Use one of the following options to specify this parameter:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
    /// on your behalf.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Undefined</b>: Make no changes to the KMS key of the
    /// ledger.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>A valid symmetric customer managed KMS key</b>: Use
    /// the specified KMS key in your account that you create, own, and manage.</p>
    /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
    /// Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
    /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
    /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
    /// ARN or alias ARN.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Key ARN:
    /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name: <code>alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias ARN:
    /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
    /// the <i>Key Management Service Developer Guide</i>.</p>
    pub kms_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateLedgerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLedgerInput");
        formatter.field("name", &self.name);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("kms_key", &self.kms_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) from which to remove the tags. For example:</p>
    /// <p>
    /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) to which you want to add the tags. For example:</p>
    /// <p>
    /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key-value pairs to add as tags to the specified QLDB resource. Tag keys are case
    /// sensitive. If you specify a key that already exists for the resource, your request fails
    /// and returns an error. Tag values are case sensitive and can be null.</p>
    pub tags: std::option::Option<
        std::collections::HashMap<std::string::String, std::option::Option<std::string::String>>,
    >,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamJournalToKinesisInput {
    /// <p>The name of the ledger.</p>
    pub ledger_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
    /// journal stream to write data records to a Kinesis Data Streams resource.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The key-value pairs to add as tags to the stream that you want to create. Tag keys are
    /// case sensitive. Tag values are case sensitive and can be null.</p>
    pub tags: std::option::Option<
        std::collections::HashMap<std::string::String, std::option::Option<std::string::String>>,
    >,
    /// <p>The inclusive start date and time from which to start streaming journal data. This
    /// parameter must be in <code>ISO 8601</code> date and time format and in Universal
    /// Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>.</p>
    /// <p>The <code>InclusiveStartTime</code> cannot be in the future and must be before
    /// <code>ExclusiveEndTime</code>.</p>
    /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
    /// <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's
    /// <code>CreationDateTime</code>.</p>
    pub inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The exclusive date and time that specifies when the stream ends. If you don't define
    /// this parameter, the stream runs indefinitely until you cancel it.</p>
    /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
    /// and in Universal Coordinated Time (UTC). For example:
    /// <code>2019-06-13T21:36:34Z</code>.</p>
    pub exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The configuration settings of the Kinesis Data Streams destination for your stream request.</p>
    pub kinesis_configuration: std::option::Option<crate::model::KinesisConfiguration>,
    /// <p>The name that you want to assign to the QLDB journal stream. User-defined names can
    /// help identify and indicate the purpose of a stream.</p>
    /// <p>Your stream name must be unique among other <i>active</i> streams for a
    /// given ledger. Stream names have the same naming constraints as ledger names, as defined in
    /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a> in the <i>Amazon QLDB Developer
    /// Guide</i>.</p>
    pub stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StreamJournalToKinesisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamJournalToKinesisInput");
        formatter.field("ledger_name", &self.ledger_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("inclusive_start_time", &self.inclusive_start_time);
        formatter.field("exclusive_end_time", &self.exclusive_end_time);
        formatter.field("kinesis_configuration", &self.kinesis_configuration);
        formatter.field("stream_name", &self.stream_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for which to list the tags. For example:</p>
    /// <p>
    /// <code>arn:aws:qldb:us-east-1:123456789012:ledger/exampleLedger</code>
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLedgersInput {
    /// <p>The maximum number of results to return in a single <code>ListLedgers</code> request.
    /// (The actual number of results returned might be fewer.)</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
    /// you received a value for <code>NextToken</code> in the response from a previous
    /// <code>ListLedgers</code> call, then you should use that value as input here.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListLedgersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLedgersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJournalS3ExportsForLedgerInput {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single
    /// <code>ListJournalS3ExportsForLedger</code> request. (The actual number of results
    /// returned might be fewer.)</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
    /// you received a value for <code>NextToken</code> in the response from a previous
    /// <code>ListJournalS3ExportsForLedger</code> call, then you should use that value as input
    /// here.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListJournalS3ExportsForLedgerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJournalS3ExportsForLedgerInput");
        formatter.field("name", &self.name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJournalS3ExportsInput {
    /// <p>The maximum number of results to return in a single <code>ListJournalS3Exports</code>
    /// request. (The actual number of results returned might be fewer.)</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
    /// you received a value for <code>NextToken</code> in the response from a previous
    /// <code>ListJournalS3Exports</code> call, then you should use that value as input
    /// here.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListJournalS3ExportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJournalS3ExportsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJournalKinesisStreamsForLedgerInput {
    /// <p>The name of the ledger.</p>
    pub ledger_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single
    /// <code>ListJournalKinesisStreamsForLedger</code> request. (The actual number of results
    /// returned might be fewer.)</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A pagination token, indicating that you want to retrieve the next page of results. If
    /// you received a value for <code>NextToken</code> in the response from a previous
    /// <code>ListJournalKinesisStreamsForLedger</code> call, you should use that value as input
    /// here.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListJournalKinesisStreamsForLedgerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJournalKinesisStreamsForLedgerInput");
        formatter.field("ledger_name", &self.ledger_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRevisionInput {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The block location of the document revision to be verified. An address is an Amazon Ion
    /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
    /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
    pub block_address: std::option::Option<crate::model::ValueHolder>,
    /// <p>The UUID (represented in Base62-encoded text) of the document to be verified.</p>
    pub document_id: std::option::Option<std::string::String>,
    /// <p>The latest block location covered by the digest for which to request a proof. An address
    /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
    /// <code>sequenceNo</code>.</p>
    /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
    pub digest_tip_address: std::option::Option<crate::model::ValueHolder>,
}
impl std::fmt::Debug for GetRevisionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRevisionInput");
        formatter.field("name", &self.name);
        formatter.field("block_address", &"*** Sensitive Data Redacted ***");
        formatter.field("document_id", &self.document_id);
        formatter.field("digest_tip_address", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDigestInput {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDigestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDigestInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlockInput {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The location of the block that you want to request. An address is an Amazon Ion
    /// structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
    /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>.</p>
    pub block_address: std::option::Option<crate::model::ValueHolder>,
    /// <p>The latest block location covered by the digest for which to request a proof. An address
    /// is an Amazon Ion structure that has two fields: <code>strandId</code> and
    /// <code>sequenceNo</code>.</p>
    /// <p>For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>.</p>
    pub digest_tip_address: std::option::Option<crate::model::ValueHolder>,
}
impl std::fmt::Debug for GetBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlockInput");
        formatter.field("name", &self.name);
        formatter.field("block_address", &"*** Sensitive Data Redacted ***");
        formatter.field("digest_tip_address", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportJournalToS3Input {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The inclusive start date and time for the range of journal contents to export.</p>
    /// <p>The <code>InclusiveStartTime</code> must be in <code>ISO 8601</code> date and time
    /// format and in Universal Coordinated Time (UTC). For example:
    /// <code>2019-06-13T21:36:34Z</code>.</p>
    /// <p>The <code>InclusiveStartTime</code> must be before <code>ExclusiveEndTime</code>.</p>
    /// <p>If you provide an <code>InclusiveStartTime</code> that is before the ledger's
    /// <code>CreationDateTime</code>, Amazon QLDB defaults it to the ledger's
    /// <code>CreationDateTime</code>.</p>
    pub inclusive_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The exclusive end date and time for the range of journal contents to export.</p>
    /// <p>The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format
    /// and in Universal Coordinated Time (UTC). For example:
    /// <code>2019-06-13T21:36:34Z</code>.</p>
    /// <p>The <code>ExclusiveEndTime</code> must be less than or equal to the current UTC date and
    /// time.</p>
    pub exclusive_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The configuration settings of the Amazon S3 bucket destination for your export
    /// request.</p>
    pub s3_export_configuration: std::option::Option<crate::model::S3ExportConfiguration>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
    /// journal export job to do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.</p>
    /// </li>
    /// <li>
    /// <p>(Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
    /// encryption of your exported data.</p>
    /// </li>
    /// </ul>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExportJournalToS3Input {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportJournalToS3Input");
        formatter.field("name", &self.name);
        formatter.field("inclusive_start_time", &self.inclusive_start_time);
        formatter.field("exclusive_end_time", &self.exclusive_end_time);
        formatter.field("s3_export_configuration", &self.s3_export_configuration);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLedgerInput {
    /// <p>The name of the ledger that you want to describe.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeLedgerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLedgerInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJournalS3ExportInput {
    /// <p>The name of the ledger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The UUID (represented in Base62-encoded text) of the journal export job to
    /// describe.</p>
    pub export_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeJournalS3ExportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJournalS3ExportInput");
        formatter.field("name", &self.name);
        formatter.field("export_id", &self.export_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJournalKinesisStreamInput {
    /// <p>The name of the ledger.</p>
    pub ledger_name: std::option::Option<std::string::String>,
    /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to
    /// describe.</p>
    pub stream_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeJournalKinesisStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJournalKinesisStreamInput");
        formatter.field("ledger_name", &self.ledger_name);
        formatter.field("stream_id", &self.stream_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLedgerInput {
    /// <p>The name of the ledger that you want to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteLedgerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLedgerInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLedgerInput {
    /// <p>The name of the ledger that you want to create. The name must be unique among all of
    /// the ledgers in your account in the current Region.</p>
    /// <p>Naming constraints for ledger names are defined in <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a>
    /// in the <i>Amazon QLDB Developer Guide</i>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The key-value pairs to add as tags to the ledger that you want to create. Tag keys are
    /// case sensitive. Tag values are case sensitive and can be null.</p>
    pub tags: std::option::Option<
        std::collections::HashMap<std::string::String, std::option::Option<std::string::String>>,
    >,
    /// <p>The permissions mode to assign to the ledger that you want to create. This parameter can
    /// have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with
    /// API-level granularity for ledgers.</p>
    /// <p>This mode allows users who have the <code>SendCommand</code> API permission for
    /// this ledger to run all PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables
    /// in the specified ledger. This mode disregards any table-level or command-level IAM
    /// permissions policies that you create for the ledger.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that
    /// enables access control with finer granularity for ledgers, tables, and PartiQL
    /// commands.</p>
    /// <p>By default, this mode denies all user requests to run any PartiQL commands on any
    /// tables in this ledger. To allow PartiQL commands to run, you must create IAM
    /// permissions policies for specific table resources and PartiQL actions, in addition to
    /// the <code>SendCommand</code> API permission for the ledger. For information, see
    /// <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
    /// started with the standard permissions mode</a> in the <i>Amazon QLDB
    /// Developer Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>We strongly recommend using the <code>STANDARD</code> permissions mode to maximize
    /// the security of your ledger data.</p>
    /// </note>
    pub permissions_mode: std::option::Option<crate::model::PermissionsMode>,
    /// <p>The flag that prevents a ledger from being deleted by any user. If not provided on
    /// ledger creation, this feature is enabled (<code>true</code>) by default.</p>
    /// <p>If deletion protection is enabled, you must first disable it before you can delete the
    /// ledger. You can disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.</p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
    /// more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest</a> in
    /// the <i>Amazon QLDB Developer Guide</i>.</p>
    /// <p>Use one of the following options to specify this parameter:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AWS_OWNED_KMS_KEY</code>: Use an KMS key that is owned and managed by Amazon Web Services
    /// on your behalf.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Undefined</b>: By default, use an Amazon Web Services owned KMS
    /// key.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>A valid symmetric customer managed KMS key</b>: Use
    /// the specified KMS key in your account that you create, own, and manage.</p>
    /// <p>Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer
    /// Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <p>To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
    /// (ARN), alias name, or alias ARN. When using an alias name, prefix it with
    /// <code>"alias/"</code>. To specify a key in a different account, you must use the key
    /// ARN or alias ARN.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Key ARN:
    /// <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name: <code>alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias ARN:
    /// <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in
    /// the <i>Key Management Service Developer Guide</i>.</p>
    pub kms_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateLedgerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLedgerInput");
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.field("permissions_mode", &self.permissions_mode);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("kms_key", &self.kms_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJournalKinesisStreamInput {
    /// <p>The name of the ledger.</p>
    pub ledger_name: std::option::Option<std::string::String>,
    /// <p>The UUID (represented in Base62-encoded text) of the QLDB journal stream to be
    /// canceled.</p>
    pub stream_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelJournalKinesisStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJournalKinesisStreamInput");
        formatter.field("ledger_name", &self.ledger_name);
        formatter.field("stream_id", &self.stream_id);
        formatter.finish()
    }
}
