// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptEnvironmentAccountConnectionError {
    /// Kind of error that occurred.
    pub kind: AcceptEnvironmentAccountConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptEnvironmentAccountConnectionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptEnvironmentAccountConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AcceptEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AcceptEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptEnvironmentAccountConnectionError {
    fn code(&self) -> Option<&str> {
        AcceptEnvironmentAccountConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            AcceptEnvironmentAccountConnectionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            AcceptEnvironmentAccountConnectionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl AcceptEnvironmentAccountConnectionError {
    /// Creates a new `AcceptEnvironmentAccountConnectionError`.
    pub fn new(
        kind: AcceptEnvironmentAccountConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptEnvironmentAccountConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptEnvironmentAccountConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptEnvironmentAccountConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEnvironmentAccountConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptEnvironmentAccountConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEnvironmentAccountConnectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptEnvironmentAccountConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEnvironmentAccountConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptEnvironmentAccountConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptEnvironmentAccountConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEnvironmentAccountConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptEnvironmentAccountConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptEnvironmentAccountConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AcceptEnvironmentAccountConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            AcceptEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            AcceptEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AcceptEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelEnvironmentDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelEnvironmentDeploymentError {
    /// Kind of error that occurred.
    pub kind: CancelEnvironmentDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelEnvironmentDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelEnvironmentDeploymentErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelEnvironmentDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelEnvironmentDeploymentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelEnvironmentDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelEnvironmentDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelEnvironmentDeploymentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CancelEnvironmentDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelEnvironmentDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelEnvironmentDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelEnvironmentDeploymentError {
    fn code(&self) -> Option<&str> {
        CancelEnvironmentDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CancelEnvironmentDeploymentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CancelEnvironmentDeploymentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CancelEnvironmentDeploymentError {
    /// Creates a new `CancelEnvironmentDeploymentError`.
    pub fn new(kind: CancelEnvironmentDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelEnvironmentDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelEnvironmentDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelEnvironmentDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelEnvironmentDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelEnvironmentDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelEnvironmentDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelEnvironmentDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelEnvironmentDeploymentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelEnvironmentDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelEnvironmentDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelEnvironmentDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelEnvironmentDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelEnvironmentDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelEnvironmentDeploymentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelEnvironmentDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelEnvironmentDeploymentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelEnvironmentDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelEnvironmentDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelEnvironmentDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            CancelEnvironmentDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelEnvironmentDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelEnvironmentDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelEnvironmentDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            CancelEnvironmentDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelServiceInstanceDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelServiceInstanceDeploymentError {
    /// Kind of error that occurred.
    pub kind: CancelServiceInstanceDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelServiceInstanceDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelServiceInstanceDeploymentErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelServiceInstanceDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelServiceInstanceDeploymentErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CancelServiceInstanceDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelServiceInstanceDeploymentErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CancelServiceInstanceDeploymentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CancelServiceInstanceDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelServiceInstanceDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelServiceInstanceDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelServiceInstanceDeploymentError {
    fn code(&self) -> Option<&str> {
        CancelServiceInstanceDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CancelServiceInstanceDeploymentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CancelServiceInstanceDeploymentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CancelServiceInstanceDeploymentError {
    /// Creates a new `CancelServiceInstanceDeploymentError`.
    pub fn new(
        kind: CancelServiceInstanceDeploymentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelServiceInstanceDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelServiceInstanceDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelServiceInstanceDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelServiceInstanceDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelServiceInstanceDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceInstanceDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServiceInstanceDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceInstanceDeploymentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServiceInstanceDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceInstanceDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServiceInstanceDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceInstanceDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServiceInstanceDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceInstanceDeploymentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServiceInstanceDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServiceInstanceDeploymentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelServiceInstanceDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelServiceInstanceDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelServiceInstanceDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            CancelServiceInstanceDeploymentErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CancelServiceInstanceDeploymentErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CancelServiceInstanceDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelServiceInstanceDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            CancelServiceInstanceDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelServicePipelineDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelServicePipelineDeploymentError {
    /// Kind of error that occurred.
    pub kind: CancelServicePipelineDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelServicePipelineDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelServicePipelineDeploymentErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelServicePipelineDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelServicePipelineDeploymentErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CancelServicePipelineDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelServicePipelineDeploymentErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CancelServicePipelineDeploymentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CancelServicePipelineDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelServicePipelineDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelServicePipelineDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelServicePipelineDeploymentError {
    fn code(&self) -> Option<&str> {
        CancelServicePipelineDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CancelServicePipelineDeploymentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CancelServicePipelineDeploymentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CancelServicePipelineDeploymentError {
    /// Creates a new `CancelServicePipelineDeploymentError`.
    pub fn new(
        kind: CancelServicePipelineDeploymentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelServicePipelineDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelServicePipelineDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelServicePipelineDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelServicePipelineDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelServicePipelineDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServicePipelineDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServicePipelineDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServicePipelineDeploymentErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServicePipelineDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServicePipelineDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServicePipelineDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServicePipelineDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServicePipelineDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServicePipelineDeploymentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelServicePipelineDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelServicePipelineDeploymentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelServicePipelineDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelServicePipelineDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelServicePipelineDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            CancelServicePipelineDeploymentErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CancelServicePipelineDeploymentErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CancelServicePipelineDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelServicePipelineDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            CancelServicePipelineDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateEnvironmentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateEnvironmentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateEnvironmentError {
    /// Creates a new `CreateEnvironmentError`.
    pub fn new(kind: CreateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentAccountConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentAccountConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentAccountConnectionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentAccountConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentAccountConnectionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentAccountConnectionError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentAccountConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateEnvironmentAccountConnectionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateEnvironmentAccountConnectionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateEnvironmentAccountConnectionError {
    /// Creates a new `CreateEnvironmentAccountConnectionError`.
    pub fn new(
        kind: CreateEnvironmentAccountConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentAccountConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentAccountConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentAccountConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentAccountConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentAccountConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentAccountConnectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentAccountConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentAccountConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentAccountConnectionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentAccountConnectionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentAccountConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentAccountConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentAccountConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentAccountConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentAccountConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentAccountConnectionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentTemplateError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateEnvironmentTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateEnvironmentTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateEnvironmentTemplateError {
    /// Creates a new `CreateEnvironmentTemplateError`.
    pub fn new(kind: CreateEnvironmentTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateEnvironmentTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEnvironmentTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEnvironmentTemplateErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEnvironmentTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            CreateEnvironmentTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEnvironmentTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: CreateEnvironmentTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEnvironmentTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEnvironmentTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentTemplateVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentTemplateVersionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEnvironmentTemplateVersionError {
    fn code(&self) -> Option<&str> {
        CreateEnvironmentTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateEnvironmentTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateEnvironmentTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateEnvironmentTemplateVersionError {
    /// Creates a new `CreateEnvironmentTemplateVersionError`.
    pub fn new(
        kind: CreateEnvironmentTemplateVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEnvironmentTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEnvironmentTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateVersionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateVersionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEnvironmentTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEnvironmentTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateEnvironmentTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentTemplateVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentTemplateVersionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRepositoryError {
    /// Kind of error that occurred.
    pub kind: CreateRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRepositoryErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRepositoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRepositoryError {
    fn code(&self) -> Option<&str> {
        CreateRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateRepositoryErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateRepositoryErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateRepositoryError {
    /// Creates a new `CreateRepositoryError`.
    pub fn new(kind: CreateRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateRepositoryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRepositoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceError {
    /// Kind of error that occurred.
    pub kind: CreateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceError {
    fn code(&self) -> Option<&str> {
        CreateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateServiceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateServiceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateServiceError {
    /// Creates a new `CreateServiceError`.
    pub fn new(kind: CreateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateServiceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateServiceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateServiceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateServiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateServiceTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateServiceTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateServiceTemplateErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateServiceTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateServiceTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateServiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceTemplateError {
    fn code(&self) -> Option<&str> {
        CreateServiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateServiceTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateServiceTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateServiceTemplateError {
    /// Creates a new `CreateServiceTemplateError`.
    pub fn new(kind: CreateServiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateServiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateServiceTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            CreateServiceTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateServiceTemplateErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateServiceTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateServiceTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            CreateServiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: CreateServiceTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateServiceTemplateVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateServiceTemplateVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateServiceTemplateVersionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateServiceTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateServiceTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateServiceTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceTemplateVersionError {
    fn code(&self) -> Option<&str> {
        CreateServiceTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateServiceTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateServiceTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateServiceTemplateVersionError {
    /// Creates a new `CreateServiceTemplateVersionError`.
    pub fn new(kind: CreateServiceTemplateVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateVersionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateVersionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateServiceTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateServiceTemplateVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateServiceTemplateVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateServiceTemplateVersionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateServiceTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateServiceTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateServiceTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTemplateSyncConfigError {
    /// Kind of error that occurred.
    pub kind: CreateTemplateSyncConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTemplateSyncConfigErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTemplateSyncConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTemplateSyncConfigErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateTemplateSyncConfigErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateTemplateSyncConfigErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateTemplateSyncConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateTemplateSyncConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateTemplateSyncConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTemplateSyncConfigError {
    fn code(&self) -> Option<&str> {
        CreateTemplateSyncConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateTemplateSyncConfigErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateTemplateSyncConfigErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateTemplateSyncConfigError {
    /// Creates a new `CreateTemplateSyncConfigError`.
    pub fn new(kind: CreateTemplateSyncConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTemplateSyncConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTemplateSyncConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTemplateSyncConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTemplateSyncConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTemplateSyncConfigErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateSyncConfigErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateSyncConfigErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateSyncConfigErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateSyncConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateSyncConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateSyncConfigErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateSyncConfigErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateSyncConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateSyncConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTemplateSyncConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateSyncConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateTemplateSyncConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTemplateSyncConfigErrorKind::ConflictException(_inner) => Some(_inner),
            CreateTemplateSyncConfigErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateTemplateSyncConfigErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateTemplateSyncConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateTemplateSyncConfigErrorKind::ValidationException(_inner) => Some(_inner),
            CreateTemplateSyncConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteEnvironmentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteEnvironmentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteEnvironmentError {
    /// Creates a new `DeleteEnvironmentError`.
    pub fn new(kind: DeleteEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentAccountConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentAccountConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentAccountConnectionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentAccountConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentAccountConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentAccountConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteEnvironmentAccountConnectionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteEnvironmentAccountConnectionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteEnvironmentAccountConnectionError {
    /// Creates a new `DeleteEnvironmentAccountConnectionError`.
    pub fn new(
        kind: DeleteEnvironmentAccountConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentAccountConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentAccountConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentAccountConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentAccountConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentAccountConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentAccountConnectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentAccountConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentAccountConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentAccountConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentAccountConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentAccountConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentAccountConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentAccountConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentAccountConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteEnvironmentTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteEnvironmentTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteEnvironmentTemplateError {
    /// Creates a new `DeleteEnvironmentTemplateError`.
    pub fn new(kind: DeleteEnvironmentTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEnvironmentTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteEnvironmentTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEnvironmentTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEnvironmentTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentTemplateVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEnvironmentTemplateVersionError {
    fn code(&self) -> Option<&str> {
        DeleteEnvironmentTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteEnvironmentTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteEnvironmentTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteEnvironmentTemplateVersionError {
    /// Creates a new `DeleteEnvironmentTemplateVersionError`.
    pub fn new(
        kind: DeleteEnvironmentTemplateVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEnvironmentTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEnvironmentTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEnvironmentTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEnvironmentTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteEnvironmentTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentTemplateVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteRepositoryErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteRepositoryErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteRepositoryError {
    /// Creates a new `DeleteRepositoryError`.
    pub fn new(kind: DeleteRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteRepositoryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceError {
    fn code(&self) -> Option<&str> {
        DeleteServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteServiceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteServiceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteServiceError {
    /// Creates a new `DeleteServiceError`.
    pub fn new(kind: DeleteServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteServiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteServiceTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteServiceTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteServiceTemplateError {
    /// Creates a new `DeleteServiceTemplateError`.
    pub fn new(kind: DeleteServiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteServiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteServiceTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteServiceTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteServiceTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServiceTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteServiceTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteServiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteServiceTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteServiceTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceTemplateVersionError {
    fn code(&self) -> Option<&str> {
        DeleteServiceTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteServiceTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteServiceTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteServiceTemplateVersionError {
    /// Creates a new `DeleteServiceTemplateVersionError`.
    pub fn new(kind: DeleteServiceTemplateVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteServiceTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteServiceTemplateVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteServiceTemplateVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteServiceTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteServiceTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteServiceTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTemplateSyncConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteTemplateSyncConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTemplateSyncConfigErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTemplateSyncConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteTemplateSyncConfigErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteTemplateSyncConfigErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteTemplateSyncConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTemplateSyncConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteTemplateSyncConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteTemplateSyncConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTemplateSyncConfigError {
    fn code(&self) -> Option<&str> {
        DeleteTemplateSyncConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteTemplateSyncConfigErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteTemplateSyncConfigErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteTemplateSyncConfigError {
    /// Creates a new `DeleteTemplateSyncConfigError`.
    pub fn new(kind: DeleteTemplateSyncConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTemplateSyncConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTemplateSyncConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTemplateSyncConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTemplateSyncConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTemplateSyncConfigErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateSyncConfigErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateSyncConfigErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateSyncConfigErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateSyncConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateSyncConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateSyncConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateSyncConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateSyncConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateSyncConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTemplateSyncConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTemplateSyncConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteTemplateSyncConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteTemplateSyncConfigErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteTemplateSyncConfigErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteTemplateSyncConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTemplateSyncConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteTemplateSyncConfigErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteTemplateSyncConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: GetAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountSettingsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountSettingsError {
    fn code(&self) -> Option<&str> {
        GetAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetAccountSettingsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetAccountSettingsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetAccountSettingsError {
    /// Creates a new `GetAccountSettingsError`.
    pub fn new(kind: GetAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEnvironmentError {
    /// Kind of error that occurred.
    pub kind: GetEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEnvironmentErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEnvironmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEnvironmentError {
    fn code(&self) -> Option<&str> {
        GetEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetEnvironmentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetEnvironmentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetEnvironmentError {
    /// Creates a new `GetEnvironmentError`.
    pub fn new(kind: GetEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetEnvironmentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetEnvironmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEnvironmentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEnvironmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEnvironmentAccountConnectionError {
    /// Kind of error that occurred.
    pub kind: GetEnvironmentAccountConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEnvironmentAccountConnectionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEnvironmentAccountConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEnvironmentAccountConnectionError {
    fn code(&self) -> Option<&str> {
        GetEnvironmentAccountConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetEnvironmentAccountConnectionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetEnvironmentAccountConnectionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetEnvironmentAccountConnectionError {
    /// Creates a new `GetEnvironmentAccountConnectionError`.
    pub fn new(
        kind: GetEnvironmentAccountConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEnvironmentAccountConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEnvironmentAccountConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEnvironmentAccountConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentAccountConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentAccountConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentAccountConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentAccountConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentAccountConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentAccountConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentAccountConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentAccountConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEnvironmentAccountConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => Some(_inner),
            GetEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEnvironmentTemplateError {
    /// Kind of error that occurred.
    pub kind: GetEnvironmentTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEnvironmentTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEnvironmentTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEnvironmentTemplateError {
    fn code(&self) -> Option<&str> {
        GetEnvironmentTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetEnvironmentTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetEnvironmentTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetEnvironmentTemplateError {
    /// Creates a new `GetEnvironmentTemplateError`.
    pub fn new(kind: GetEnvironmentTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEnvironmentTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEnvironmentTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEnvironmentTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEnvironmentTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEnvironmentTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEnvironmentTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEnvironmentTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEnvironmentTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEnvironmentTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            GetEnvironmentTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEnvironmentTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: GetEnvironmentTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEnvironmentTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEnvironmentTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEnvironmentTemplateVersionError {
    fn code(&self) -> Option<&str> {
        GetEnvironmentTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetEnvironmentTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetEnvironmentTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetEnvironmentTemplateVersionError {
    /// Creates a new `GetEnvironmentTemplateVersionError`.
    pub fn new(
        kind: GetEnvironmentTemplateVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEnvironmentTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEnvironmentTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEnvironmentTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEnvironmentTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEnvironmentTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            GetEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryError {
    fn code(&self) -> Option<&str> {
        GetRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetRepositoryErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetRepositoryErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetRepositoryError {
    /// Creates a new `GetRepositoryError`.
    pub fn new(kind: GetRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetRepositoryErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetRepositoryErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetRepositoryErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRepositoryErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRepositoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRepositoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRepositoryErrorKind::ValidationException(_inner) => Some(_inner),
            GetRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepositorySyncStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositorySyncStatusError {
    /// Kind of error that occurred.
    pub kind: GetRepositorySyncStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepositorySyncStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositorySyncStatusErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositorySyncStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositorySyncStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRepositorySyncStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRepositorySyncStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRepositorySyncStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRepositorySyncStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRepositorySyncStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositorySyncStatusError {
    fn code(&self) -> Option<&str> {
        GetRepositorySyncStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetRepositorySyncStatusErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetRepositorySyncStatusErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetRepositorySyncStatusError {
    /// Creates a new `GetRepositorySyncStatusError`.
    pub fn new(kind: GetRepositorySyncStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositorySyncStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositorySyncStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositorySyncStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositorySyncStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositorySyncStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositorySyncStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositorySyncStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositorySyncStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositorySyncStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositorySyncStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositorySyncStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositorySyncStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositorySyncStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositorySyncStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRepositorySyncStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositorySyncStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRepositorySyncStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRepositorySyncStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRepositorySyncStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRepositorySyncStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetRepositorySyncStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceError {
    /// Kind of error that occurred.
    pub kind: GetServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceError {
    fn code(&self) -> Option<&str> {
        GetServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetServiceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetServiceErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl GetServiceError {
    /// Creates a new `GetServiceError`.
    pub fn new(kind: GetServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetServiceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServiceErrorKind::ValidationException(_inner) => Some(_inner),
            GetServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceInstanceError {
    /// Kind of error that occurred.
    pub kind: GetServiceInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceInstanceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceInstanceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServiceInstanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServiceInstanceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServiceInstanceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServiceInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceInstanceError {
    fn code(&self) -> Option<&str> {
        GetServiceInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetServiceInstanceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetServiceInstanceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetServiceInstanceError {
    /// Creates a new `GetServiceInstanceError`.
    pub fn new(kind: GetServiceInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceInstanceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceInstanceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceInstanceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceInstanceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceInstanceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceInstanceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServiceInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceInstanceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServiceInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServiceInstanceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServiceInstanceErrorKind::ValidationException(_inner) => Some(_inner),
            GetServiceInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceTemplateError {
    /// Kind of error that occurred.
    pub kind: GetServiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServiceTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServiceTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServiceTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceTemplateError {
    fn code(&self) -> Option<&str> {
        GetServiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetServiceTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetServiceTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetServiceTemplateError {
    /// Creates a new `GetServiceTemplateError`.
    pub fn new(kind: GetServiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServiceTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServiceTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServiceTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            GetServiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: GetServiceTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceTemplateVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetServiceTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetServiceTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServiceTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceTemplateVersionError {
    fn code(&self) -> Option<&str> {
        GetServiceTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetServiceTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetServiceTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetServiceTemplateVersionError {
    /// Creates a new `GetServiceTemplateVersionError`.
    pub fn new(kind: GetServiceTemplateVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServiceTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceTemplateVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetServiceTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetServiceTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            GetServiceTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTemplateSyncConfigError {
    /// Kind of error that occurred.
    pub kind: GetTemplateSyncConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTemplateSyncConfigErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTemplateSyncConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTemplateSyncConfigErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetTemplateSyncConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetTemplateSyncConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetTemplateSyncConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetTemplateSyncConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTemplateSyncConfigError {
    fn code(&self) -> Option<&str> {
        GetTemplateSyncConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetTemplateSyncConfigErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetTemplateSyncConfigErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetTemplateSyncConfigError {
    /// Creates a new `GetTemplateSyncConfigError`.
    pub fn new(kind: GetTemplateSyncConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTemplateSyncConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTemplateSyncConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTemplateSyncConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTemplateSyncConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTemplateSyncConfigErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncConfigErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetTemplateSyncConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTemplateSyncConfigErrorKind::InternalServerException(_inner) => Some(_inner),
            GetTemplateSyncConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetTemplateSyncConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetTemplateSyncConfigErrorKind::ValidationException(_inner) => Some(_inner),
            GetTemplateSyncConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTemplateSyncStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTemplateSyncStatusError {
    /// Kind of error that occurred.
    pub kind: GetTemplateSyncStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTemplateSyncStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTemplateSyncStatusErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTemplateSyncStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTemplateSyncStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTemplateSyncStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetTemplateSyncStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetTemplateSyncStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetTemplateSyncStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetTemplateSyncStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTemplateSyncStatusError {
    fn code(&self) -> Option<&str> {
        GetTemplateSyncStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetTemplateSyncStatusErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            GetTemplateSyncStatusErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetTemplateSyncStatusError {
    /// Creates a new `GetTemplateSyncStatusError`.
    pub fn new(kind: GetTemplateSyncStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTemplateSyncStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTemplateSyncStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTemplateSyncStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTemplateSyncStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTemplateSyncStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTemplateSyncStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateSyncStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetTemplateSyncStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTemplateSyncStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTemplateSyncStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            GetTemplateSyncStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetTemplateSyncStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetTemplateSyncStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetTemplateSyncStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironmentAccountConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentAccountConnectionsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentAccountConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironmentAccountConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentAccountConnectionsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentAccountConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentAccountConnectionsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentAccountConnectionsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentAccountConnectionsErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentAccountConnectionsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentAccountConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentAccountConnectionsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentAccountConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListEnvironmentAccountConnectionsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListEnvironmentAccountConnectionsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListEnvironmentAccountConnectionsError {
    /// Creates a new `ListEnvironmentAccountConnectionsError`.
    pub fn new(
        kind: ListEnvironmentAccountConnectionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentAccountConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentAccountConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentAccountConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentAccountConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentAccountConnectionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentAccountConnectionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentAccountConnectionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentAccountConnectionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentAccountConnectionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentAccountConnectionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentAccountConnectionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentAccountConnectionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentAccountConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentAccountConnectionsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentAccountConnectionsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentAccountConnectionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEnvironmentAccountConnectionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEnvironmentAccountConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironmentOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentOutputsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentOutputsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironmentOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentOutputsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentOutputsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentOutputsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEnvironmentOutputsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEnvironmentOutputsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEnvironmentOutputsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEnvironmentOutputsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEnvironmentOutputsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentOutputsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentOutputsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListEnvironmentOutputsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListEnvironmentOutputsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListEnvironmentOutputsError {
    /// Creates a new `ListEnvironmentOutputsError`.
    pub fn new(kind: ListEnvironmentOutputsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentOutputsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentOutputsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentOutputsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentOutputsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentOutputsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentOutputsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentOutputsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentOutputsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentOutputsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentOutputsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentOutputsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentOutputsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentOutputsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentOutputsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentOutputsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentOutputsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEnvironmentOutputsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEnvironmentOutputsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEnvironmentOutputsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEnvironmentOutputsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEnvironmentOutputsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironmentProvisionedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentProvisionedResourcesError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentProvisionedResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironmentProvisionedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentProvisionedResourcesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentProvisionedResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentProvisionedResourcesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentProvisionedResourcesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentProvisionedResourcesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentProvisionedResourcesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentProvisionedResourcesErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentProvisionedResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentProvisionedResourcesError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentProvisionedResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListEnvironmentProvisionedResourcesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListEnvironmentProvisionedResourcesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListEnvironmentProvisionedResourcesError {
    /// Creates a new `ListEnvironmentProvisionedResourcesError`.
    pub fn new(
        kind: ListEnvironmentProvisionedResourcesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentProvisionedResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentProvisionedResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentProvisionedResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentProvisionedResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentProvisionedResourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentProvisionedResourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentProvisionedResourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentProvisionedResourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentProvisionedResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentProvisionedResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentProvisionedResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentProvisionedResourcesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentProvisionedResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentProvisionedResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentProvisionedResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentProvisionedResourcesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentProvisionedResourcesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentProvisionedResourcesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentProvisionedResourcesErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentProvisionedResourcesErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentProvisionedResourcesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEnvironmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListEnvironmentsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListEnvironmentsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListEnvironmentsError {
    /// Creates a new `ListEnvironmentsError`.
    pub fn new(kind: ListEnvironmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEnvironmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironmentTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironmentTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentTemplatesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentTemplatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEnvironmentTemplatesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEnvironmentTemplatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEnvironmentTemplatesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEnvironmentTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentTemplatesError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListEnvironmentTemplatesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListEnvironmentTemplatesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListEnvironmentTemplatesError {
    /// Creates a new `ListEnvironmentTemplatesError`.
    pub fn new(kind: ListEnvironmentTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplatesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplatesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentTemplatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEnvironmentTemplatesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEnvironmentTemplatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEnvironmentTemplatesErrorKind::ValidationException(_inner) => Some(_inner),
            ListEnvironmentTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEnvironmentTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEnvironmentTemplateVersionsError {
    /// Kind of error that occurred.
    pub kind: ListEnvironmentTemplateVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEnvironmentTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEnvironmentTemplateVersionsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEnvironmentTemplateVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEnvironmentTemplateVersionsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentTemplateVersionsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListEnvironmentTemplateVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEnvironmentTemplateVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEnvironmentTemplateVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEnvironmentTemplateVersionsError {
    fn code(&self) -> Option<&str> {
        ListEnvironmentTemplateVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListEnvironmentTemplateVersionsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListEnvironmentTemplateVersionsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListEnvironmentTemplateVersionsError {
    /// Creates a new `ListEnvironmentTemplateVersionsError`.
    pub fn new(
        kind: ListEnvironmentTemplateVersionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEnvironmentTemplateVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEnvironmentTemplateVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEnvironmentTemplateVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEnvironmentTemplateVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplateVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplateVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplateVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplateVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplateVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplateVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplateVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplateVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEnvironmentTemplateVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEnvironmentTemplateVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEnvironmentTemplateVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEnvironmentTemplateVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEnvironmentTemplateVersionsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListEnvironmentTemplateVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEnvironmentTemplateVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEnvironmentTemplateVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRepositoriesError {
    /// Kind of error that occurred.
    pub kind: ListRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRepositoriesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRepositoriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRepositoriesError {
    fn code(&self) -> Option<&str> {
        ListRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListRepositoriesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListRepositoriesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListRepositoriesError {
    /// Creates a new `ListRepositoriesError`.
    pub fn new(kind: ListRepositoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRepositoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRepositoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRepositoriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::ValidationException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRepositorySyncDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRepositorySyncDefinitionsError {
    /// Kind of error that occurred.
    pub kind: ListRepositorySyncDefinitionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRepositorySyncDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRepositorySyncDefinitionsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRepositorySyncDefinitionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRepositorySyncDefinitionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRepositorySyncDefinitionsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListRepositorySyncDefinitionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRepositorySyncDefinitionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRepositorySyncDefinitionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRepositorySyncDefinitionsError {
    fn code(&self) -> Option<&str> {
        ListRepositorySyncDefinitionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListRepositorySyncDefinitionsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListRepositorySyncDefinitionsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListRepositorySyncDefinitionsError {
    /// Creates a new `ListRepositorySyncDefinitionsError`.
    pub fn new(
        kind: ListRepositorySyncDefinitionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRepositorySyncDefinitionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRepositorySyncDefinitionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRepositorySyncDefinitionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRepositorySyncDefinitionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRepositorySyncDefinitionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositorySyncDefinitionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositorySyncDefinitionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositorySyncDefinitionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositorySyncDefinitionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositorySyncDefinitionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositorySyncDefinitionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositorySyncDefinitionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRepositorySyncDefinitionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRepositorySyncDefinitionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRepositorySyncDefinitionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRepositorySyncDefinitionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRepositorySyncDefinitionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRepositorySyncDefinitionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceInstanceOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceInstanceOutputsError {
    /// Kind of error that occurred.
    pub kind: ListServiceInstanceOutputsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceInstanceOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceInstanceOutputsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceInstanceOutputsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceInstanceOutputsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServiceInstanceOutputsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServiceInstanceOutputsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListServiceInstanceOutputsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServiceInstanceOutputsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServiceInstanceOutputsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceInstanceOutputsError {
    fn code(&self) -> Option<&str> {
        ListServiceInstanceOutputsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServiceInstanceOutputsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServiceInstanceOutputsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListServiceInstanceOutputsError {
    /// Creates a new `ListServiceInstanceOutputsError`.
    pub fn new(kind: ListServiceInstanceOutputsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceInstanceOutputsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceInstanceOutputsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceInstanceOutputsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceInstanceOutputsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceInstanceOutputsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceOutputsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceOutputsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceOutputsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceOutputsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceOutputsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceOutputsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceOutputsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceOutputsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceOutputsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServiceInstanceOutputsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceInstanceOutputsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServiceInstanceOutputsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServiceInstanceOutputsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListServiceInstanceOutputsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServiceInstanceOutputsErrorKind::ValidationException(_inner) => Some(_inner),
            ListServiceInstanceOutputsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceInstanceProvisionedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceInstanceProvisionedResourcesError {
    /// Kind of error that occurred.
    pub kind: ListServiceInstanceProvisionedResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceInstanceProvisionedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceInstanceProvisionedResourcesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceInstanceProvisionedResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceInstanceProvisionedResourcesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceInstanceProvisionedResourcesError {
    fn code(&self) -> Option<&str> {
        ListServiceInstanceProvisionedResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServiceInstanceProvisionedResourcesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServiceInstanceProvisionedResourcesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListServiceInstanceProvisionedResourcesError {
    /// Creates a new `ListServiceInstanceProvisionedResourcesError`.
    pub fn new(
        kind: ListServiceInstanceProvisionedResourcesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceInstanceProvisionedResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceInstanceProvisionedResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceInstanceProvisionedResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceInstanceProvisionedResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceInstanceProvisionedResourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceProvisionedResourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceProvisionedResourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceProvisionedResourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceProvisionedResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceProvisionedResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceProvisionedResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceProvisionedResourcesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstanceProvisionedResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstanceProvisionedResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServiceInstanceProvisionedResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceInstanceProvisionedResourcesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListServiceInstanceProvisionedResourcesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListServiceInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceInstancesError {
    /// Kind of error that occurred.
    pub kind: ListServiceInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceInstancesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceInstancesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServiceInstancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServiceInstancesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListServiceInstancesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServiceInstancesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServiceInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceInstancesError {
    fn code(&self) -> Option<&str> {
        ListServiceInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServiceInstancesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServiceInstancesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListServiceInstancesError {
    /// Creates a new `ListServiceInstancesError`.
    pub fn new(kind: ListServiceInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceInstancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstancesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstancesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstancesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstancesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstancesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstancesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceInstancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceInstancesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServiceInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceInstancesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServiceInstancesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServiceInstancesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListServiceInstancesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServiceInstancesErrorKind::ValidationException(_inner) => Some(_inner),
            ListServiceInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServicePipelineOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicePipelineOutputsError {
    /// Kind of error that occurred.
    pub kind: ListServicePipelineOutputsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServicePipelineOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicePipelineOutputsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicePipelineOutputsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicePipelineOutputsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServicePipelineOutputsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServicePipelineOutputsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListServicePipelineOutputsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServicePipelineOutputsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServicePipelineOutputsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicePipelineOutputsError {
    fn code(&self) -> Option<&str> {
        ListServicePipelineOutputsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServicePipelineOutputsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServicePipelineOutputsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListServicePipelineOutputsError {
    /// Creates a new `ListServicePipelineOutputsError`.
    pub fn new(kind: ListServicePipelineOutputsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicePipelineOutputsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicePipelineOutputsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicePipelineOutputsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicePipelineOutputsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServicePipelineOutputsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineOutputsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineOutputsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineOutputsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineOutputsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineOutputsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineOutputsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineOutputsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineOutputsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineOutputsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServicePipelineOutputsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicePipelineOutputsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServicePipelineOutputsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServicePipelineOutputsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListServicePipelineOutputsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServicePipelineOutputsErrorKind::ValidationException(_inner) => Some(_inner),
            ListServicePipelineOutputsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServicePipelineProvisionedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicePipelineProvisionedResourcesError {
    /// Kind of error that occurred.
    pub kind: ListServicePipelineProvisionedResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServicePipelineProvisionedResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicePipelineProvisionedResourcesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicePipelineProvisionedResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicePipelineProvisionedResourcesErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListServicePipelineProvisionedResourcesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListServicePipelineProvisionedResourcesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListServicePipelineProvisionedResourcesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListServicePipelineProvisionedResourcesErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListServicePipelineProvisionedResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicePipelineProvisionedResourcesError {
    fn code(&self) -> Option<&str> {
        ListServicePipelineProvisionedResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServicePipelineProvisionedResourcesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServicePipelineProvisionedResourcesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListServicePipelineProvisionedResourcesError {
    /// Creates a new `ListServicePipelineProvisionedResourcesError`.
    pub fn new(
        kind: ListServicePipelineProvisionedResourcesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicePipelineProvisionedResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicePipelineProvisionedResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicePipelineProvisionedResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicePipelineProvisionedResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServicePipelineProvisionedResourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineProvisionedResourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineProvisionedResourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineProvisionedResourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineProvisionedResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineProvisionedResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineProvisionedResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineProvisionedResourcesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicePipelineProvisionedResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicePipelineProvisionedResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServicePipelineProvisionedResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicePipelineProvisionedResourcesErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListServicePipelineProvisionedResourcesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListServicePipelineProvisionedResourcesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListServicePipelineProvisionedResourcesErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListServicePipelineProvisionedResourcesErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListServicePipelineProvisionedResourcesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicesError {
    /// Kind of error that occurred.
    pub kind: ListServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicesError {
    fn code(&self) -> Option<&str> {
        ListServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServicesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServicesErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl ListServicesError {
    /// Creates a new `ListServicesError`.
    pub fn new(kind: ListServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServicesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServicesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServicesErrorKind::ValidationException(_inner) => Some(_inner),
            ListServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListServiceTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceTemplatesErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceTemplatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServiceTemplatesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServiceTemplatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServiceTemplatesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServiceTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceTemplatesError {
    fn code(&self) -> Option<&str> {
        ListServiceTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServiceTemplatesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServiceTemplatesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListServiceTemplatesError {
    /// Creates a new `ListServiceTemplatesError`.
    pub fn new(kind: ListServiceTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceTemplatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceTemplatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceTemplatesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplatesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServiceTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceTemplatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServiceTemplatesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServiceTemplatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServiceTemplatesErrorKind::ValidationException(_inner) => Some(_inner),
            ListServiceTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceTemplateVersionsError {
    /// Kind of error that occurred.
    pub kind: ListServiceTemplateVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceTemplateVersionsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceTemplateVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceTemplateVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServiceTemplateVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListServiceTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListServiceTemplateVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListServiceTemplateVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListServiceTemplateVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceTemplateVersionsError {
    fn code(&self) -> Option<&str> {
        ListServiceTemplateVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListServiceTemplateVersionsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListServiceTemplateVersionsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListServiceTemplateVersionsError {
    /// Creates a new `ListServiceTemplateVersionsError`.
    pub fn new(kind: ListServiceTemplateVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceTemplateVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceTemplateVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceTemplateVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceTemplateVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceTemplateVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplateVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceTemplateVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplateVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceTemplateVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplateVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceTemplateVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplateVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceTemplateVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceTemplateVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListServiceTemplateVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceTemplateVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServiceTemplateVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListServiceTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListServiceTemplateVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListServiceTemplateVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListServiceTemplateVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListTagsForResourceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `NotifyResourceDeploymentStatusChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct NotifyResourceDeploymentStatusChangeError {
    /// Kind of error that occurred.
    pub kind: NotifyResourceDeploymentStatusChangeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `NotifyResourceDeploymentStatusChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum NotifyResourceDeploymentStatusChangeErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for NotifyResourceDeploymentStatusChangeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            NotifyResourceDeploymentStatusChangeErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => _inner.fmt(f),
            NotifyResourceDeploymentStatusChangeErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for NotifyResourceDeploymentStatusChangeError {
    fn code(&self) -> Option<&str> {
        NotifyResourceDeploymentStatusChangeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            NotifyResourceDeploymentStatusChangeErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl NotifyResourceDeploymentStatusChangeError {
    /// Creates a new `NotifyResourceDeploymentStatusChangeError`.
    pub fn new(
        kind: NotifyResourceDeploymentStatusChangeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `NotifyResourceDeploymentStatusChangeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: NotifyResourceDeploymentStatusChangeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `NotifyResourceDeploymentStatusChangeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: NotifyResourceDeploymentStatusChangeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `NotifyResourceDeploymentStatusChangeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyResourceDeploymentStatusChangeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyResourceDeploymentStatusChangeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyResourceDeploymentStatusChangeErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyResourceDeploymentStatusChangeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyResourceDeploymentStatusChangeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyResourceDeploymentStatusChangeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyResourceDeploymentStatusChangeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyResourceDeploymentStatusChangeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyResourceDeploymentStatusChangeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyResourceDeploymentStatusChangeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyResourceDeploymentStatusChangeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `NotifyResourceDeploymentStatusChangeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyResourceDeploymentStatusChangeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for NotifyResourceDeploymentStatusChangeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            NotifyResourceDeploymentStatusChangeErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => Some(_inner),
            NotifyResourceDeploymentStatusChangeErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            NotifyResourceDeploymentStatusChangeErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RejectEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectEnvironmentAccountConnectionError {
    /// Kind of error that occurred.
    pub kind: RejectEnvironmentAccountConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectEnvironmentAccountConnectionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectEnvironmentAccountConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            RejectEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RejectEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            RejectEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RejectEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            RejectEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            RejectEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectEnvironmentAccountConnectionError {
    fn code(&self) -> Option<&str> {
        RejectEnvironmentAccountConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            RejectEnvironmentAccountConnectionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            RejectEnvironmentAccountConnectionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl RejectEnvironmentAccountConnectionError {
    /// Creates a new `RejectEnvironmentAccountConnectionError`.
    pub fn new(
        kind: RejectEnvironmentAccountConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectEnvironmentAccountConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectEnvironmentAccountConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectEnvironmentAccountConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectEnvironmentAccountConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectEnvironmentAccountConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectEnvironmentAccountConnectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectEnvironmentAccountConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectEnvironmentAccountConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectEnvironmentAccountConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectEnvironmentAccountConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectEnvironmentAccountConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectEnvironmentAccountConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectEnvironmentAccountConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RejectEnvironmentAccountConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            RejectEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            RejectEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            RejectEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            RejectEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            RejectEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            RejectEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            TagResourceErrorKind::ThrottlingException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UntagResourceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccountSettingsErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccountSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccountSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateAccountSettingsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateAccountSettingsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateAccountSettingsError {
    /// Creates a new `UpdateAccountSettingsError`.
    pub fn new(kind: UpdateAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountSettingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccountSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateEnvironmentErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateEnvironmentErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateEnvironmentError {
    /// Creates a new `UpdateEnvironmentError`.
    pub fn new(kind: UpdateEnvironmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateEnvironmentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateEnvironmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentAccountConnectionError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentAccountConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironmentAccountConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentAccountConnectionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentAccountConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentAccountConnectionError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentAccountConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateEnvironmentAccountConnectionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateEnvironmentAccountConnectionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateEnvironmentAccountConnectionError {
    /// Creates a new `UpdateEnvironmentAccountConnectionError`.
    pub fn new(
        kind: UpdateEnvironmentAccountConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentAccountConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentAccountConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentAccountConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentAccountConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentAccountConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentAccountConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentAccountConnectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentAccountConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentAccountConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentAccountConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentAccountConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentAccountConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentAccountConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentAccountConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentAccountConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentAccountConnectionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEnvironmentAccountConnectionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentAccountConnectionErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentAccountConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateEnvironmentTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateEnvironmentTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateEnvironmentTemplateError {
    /// Creates a new `UpdateEnvironmentTemplateError`.
    pub fn new(kind: UpdateEnvironmentTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEnvironmentTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateEnvironmentTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEnvironmentTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEnvironmentTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEnvironmentTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentTemplateVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEnvironmentTemplateVersionError {
    fn code(&self) -> Option<&str> {
        UpdateEnvironmentTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateEnvironmentTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateEnvironmentTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateEnvironmentTemplateVersionError {
    /// Creates a new `UpdateEnvironmentTemplateVersionError`.
    pub fn new(
        kind: UpdateEnvironmentTemplateVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEnvironmentTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEnvironmentTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEnvironmentTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEnvironmentTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEnvironmentTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateEnvironmentTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEnvironmentTemplateVersionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentTemplateVersionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateVersionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateEnvironmentTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateEnvironmentTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceError {
    fn code(&self) -> Option<&str> {
        UpdateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateServiceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateServiceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateServiceError {
    /// Creates a new `UpdateServiceError`.
    pub fn new(kind: UpdateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateServiceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceInstanceError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceInstanceErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServiceInstanceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateServiceInstanceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateServiceInstanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServiceInstanceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServiceInstanceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServiceInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceInstanceError {
    fn code(&self) -> Option<&str> {
        UpdateServiceInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateServiceInstanceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateServiceInstanceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateServiceInstanceError {
    /// Creates a new `UpdateServiceInstanceError`.
    pub fn new(kind: UpdateServiceInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceInstanceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceInstanceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceInstanceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceInstanceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceInstanceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceInstanceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceInstanceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceInstanceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServiceInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServiceInstanceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateServiceInstanceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateServiceInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServiceInstanceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServiceInstanceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServiceInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServicePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServicePipelineError {
    /// Kind of error that occurred.
    pub kind: UpdateServicePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServicePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServicePipelineErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServicePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServicePipelineErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServicePipelineErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateServicePipelineErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateServicePipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServicePipelineErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServicePipelineErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServicePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServicePipelineError {
    fn code(&self) -> Option<&str> {
        UpdateServicePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateServicePipelineErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateServicePipelineErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateServicePipelineError {
    /// Creates a new `UpdateServicePipelineError`.
    pub fn new(kind: UpdateServicePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServicePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServicePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServicePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServicePipelineErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServicePipelineErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePipelineErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePipelineErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePipelineErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePipelineErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePipelineErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePipelineErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePipelineErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePipelineErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePipelineErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServicePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServicePipelineErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServicePipelineErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateServicePipelineErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateServicePipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServicePipelineErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServicePipelineErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServicePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceTemplateErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateServiceTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateServiceTemplateErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateServiceTemplateErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateServiceTemplateError {
    /// Creates a new `UpdateServiceTemplateError`.
    pub fn new(kind: UpdateServiceTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServiceTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServiceTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateServiceTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateServiceTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServiceTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServiceTemplateErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServiceTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceTemplateVersionErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServiceTemplateVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateServiceTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceTemplateVersionError {
    fn code(&self) -> Option<&str> {
        UpdateServiceTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateServiceTemplateVersionErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateServiceTemplateVersionErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateServiceTemplateVersionError {
    /// Creates a new `UpdateServiceTemplateVersionError`.
    pub fn new(kind: UpdateServiceTemplateVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceTemplateVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceTemplateVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateServiceTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceTemplateVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServiceTemplateVersionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateServiceTemplateVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateServiceTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateServiceTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServiceTemplateVersionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateServiceTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTemplateSyncConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateTemplateSyncConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTemplateSyncConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTemplateSyncConfigErrorKind {
    /// <p>There <i>isn't</i> sufficient access for performing this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed to register with the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource <i>wasn't</i> found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTemplateSyncConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateTemplateSyncConfigErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateTemplateSyncConfigErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateTemplateSyncConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTemplateSyncConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateTemplateSyncConfigErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateTemplateSyncConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTemplateSyncConfigError {
    fn code(&self) -> Option<&str> {
        UpdateTemplateSyncConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateTemplateSyncConfigErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateTemplateSyncConfigErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateTemplateSyncConfigError {
    /// Creates a new `UpdateTemplateSyncConfigError`.
    pub fn new(kind: UpdateTemplateSyncConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTemplateSyncConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTemplateSyncConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTemplateSyncConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTemplateSyncConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTemplateSyncConfigErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateSyncConfigErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateSyncConfigErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateSyncConfigErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateSyncConfigErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateSyncConfigErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateSyncConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateSyncConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateSyncConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateSyncConfigErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTemplateSyncConfigErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateSyncConfigErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateTemplateSyncConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTemplateSyncConfigErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateTemplateSyncConfigErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateTemplateSyncConfigErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateTemplateSyncConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTemplateSyncConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateTemplateSyncConfigErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateTemplateSyncConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ThrottlingError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The request failed to register with the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The request <i>couldn't</i> be made due to a conflicting operation or resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>There <i>isn't</i> sufficient access for performing this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The requested resource <i>wasn't</i> found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}
