// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptEnvironmentAccountConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_environment_account_connection`](crate::client::Client::accept_environment_account_connection).
///
/// See [`crate::client::fluent_builders::AcceptEnvironmentAccountConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptEnvironmentAccountConnection {
    _private: (),
}
impl AcceptEnvironmentAccountConnection {
    /// Creates a new builder-style object to manufacture [`AcceptEnvironmentAccountConnectionInput`](crate::input::AcceptEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::accept_environment_account_connection_input::Builder {
        crate::input::accept_environment_account_connection_input::Builder::default()
    }
    /// Creates a new `AcceptEnvironmentAccountConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptEnvironmentAccountConnection {
    type Output = std::result::Result<
        crate::output::AcceptEnvironmentAccountConnectionOutput,
        crate::error::AcceptEnvironmentAccountConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_environment_account_connection_error(response)
        } else {
            crate::operation_deser::parse_accept_environment_account_connection_response(response)
        }
    }
}

/// Operation shape for `CancelEnvironmentDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_environment_deployment`](crate::client::Client::cancel_environment_deployment).
///
/// See [`crate::client::fluent_builders::CancelEnvironmentDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelEnvironmentDeployment {
    _private: (),
}
impl CancelEnvironmentDeployment {
    /// Creates a new builder-style object to manufacture [`CancelEnvironmentDeploymentInput`](crate::input::CancelEnvironmentDeploymentInput)
    pub fn builder() -> crate::input::cancel_environment_deployment_input::Builder {
        crate::input::cancel_environment_deployment_input::Builder::default()
    }
    /// Creates a new `CancelEnvironmentDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelEnvironmentDeployment {
    type Output = std::result::Result<
        crate::output::CancelEnvironmentDeploymentOutput,
        crate::error::CancelEnvironmentDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_environment_deployment_error(response)
        } else {
            crate::operation_deser::parse_cancel_environment_deployment_response(response)
        }
    }
}

/// Operation shape for `CancelServiceInstanceDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_service_instance_deployment`](crate::client::Client::cancel_service_instance_deployment).
///
/// See [`crate::client::fluent_builders::CancelServiceInstanceDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelServiceInstanceDeployment {
    _private: (),
}
impl CancelServiceInstanceDeployment {
    /// Creates a new builder-style object to manufacture [`CancelServiceInstanceDeploymentInput`](crate::input::CancelServiceInstanceDeploymentInput)
    pub fn builder() -> crate::input::cancel_service_instance_deployment_input::Builder {
        crate::input::cancel_service_instance_deployment_input::Builder::default()
    }
    /// Creates a new `CancelServiceInstanceDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelServiceInstanceDeployment {
    type Output = std::result::Result<
        crate::output::CancelServiceInstanceDeploymentOutput,
        crate::error::CancelServiceInstanceDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_service_instance_deployment_error(response)
        } else {
            crate::operation_deser::parse_cancel_service_instance_deployment_response(response)
        }
    }
}

/// Operation shape for `CancelServicePipelineDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_service_pipeline_deployment`](crate::client::Client::cancel_service_pipeline_deployment).
///
/// See [`crate::client::fluent_builders::CancelServicePipelineDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelServicePipelineDeployment {
    _private: (),
}
impl CancelServicePipelineDeployment {
    /// Creates a new builder-style object to manufacture [`CancelServicePipelineDeploymentInput`](crate::input::CancelServicePipelineDeploymentInput)
    pub fn builder() -> crate::input::cancel_service_pipeline_deployment_input::Builder {
        crate::input::cancel_service_pipeline_deployment_input::Builder::default()
    }
    /// Creates a new `CancelServicePipelineDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelServicePipelineDeployment {
    type Output = std::result::Result<
        crate::output::CancelServicePipelineDeploymentOutput,
        crate::error::CancelServicePipelineDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_service_pipeline_deployment_error(response)
        } else {
            crate::operation_deser::parse_cancel_service_pipeline_deployment_response(response)
        }
    }
}

/// Operation shape for `CreateEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_environment`](crate::client::Client::create_environment).
///
/// See [`crate::client::fluent_builders::CreateEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEnvironment {
    _private: (),
}
impl CreateEnvironment {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentInput`](crate::input::CreateEnvironmentInput)
    pub fn builder() -> crate::input::create_environment_input::Builder {
        crate::input::create_environment_input::Builder::default()
    }
    /// Creates a new `CreateEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEnvironment {
    type Output = std::result::Result<
        crate::output::CreateEnvironmentOutput,
        crate::error::CreateEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_environment_error(response)
        } else {
            crate::operation_deser::parse_create_environment_response(response)
        }
    }
}

/// Operation shape for `CreateEnvironmentAccountConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_environment_account_connection`](crate::client::Client::create_environment_account_connection).
///
/// See [`crate::client::fluent_builders::CreateEnvironmentAccountConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEnvironmentAccountConnection {
    _private: (),
}
impl CreateEnvironmentAccountConnection {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentAccountConnectionInput`](crate::input::CreateEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::create_environment_account_connection_input::Builder {
        crate::input::create_environment_account_connection_input::Builder::default()
    }
    /// Creates a new `CreateEnvironmentAccountConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEnvironmentAccountConnection {
    type Output = std::result::Result<
        crate::output::CreateEnvironmentAccountConnectionOutput,
        crate::error::CreateEnvironmentAccountConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_environment_account_connection_error(response)
        } else {
            crate::operation_deser::parse_create_environment_account_connection_response(response)
        }
    }
}

/// Operation shape for `CreateEnvironmentTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_environment_template`](crate::client::Client::create_environment_template).
///
/// See [`crate::client::fluent_builders::CreateEnvironmentTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEnvironmentTemplate {
    _private: (),
}
impl CreateEnvironmentTemplate {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentTemplateInput`](crate::input::CreateEnvironmentTemplateInput)
    pub fn builder() -> crate::input::create_environment_template_input::Builder {
        crate::input::create_environment_template_input::Builder::default()
    }
    /// Creates a new `CreateEnvironmentTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEnvironmentTemplate {
    type Output = std::result::Result<
        crate::output::CreateEnvironmentTemplateOutput,
        crate::error::CreateEnvironmentTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_environment_template_error(response)
        } else {
            crate::operation_deser::parse_create_environment_template_response(response)
        }
    }
}

/// Operation shape for `CreateEnvironmentTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_environment_template_version`](crate::client::Client::create_environment_template_version).
///
/// See [`crate::client::fluent_builders::CreateEnvironmentTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEnvironmentTemplateVersion {
    _private: (),
}
impl CreateEnvironmentTemplateVersion {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentTemplateVersionInput`](crate::input::CreateEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::create_environment_template_version_input::Builder {
        crate::input::create_environment_template_version_input::Builder::default()
    }
    /// Creates a new `CreateEnvironmentTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEnvironmentTemplateVersion {
    type Output = std::result::Result<
        crate::output::CreateEnvironmentTemplateVersionOutput,
        crate::error::CreateEnvironmentTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_environment_template_version_error(response)
        } else {
            crate::operation_deser::parse_create_environment_template_version_response(response)
        }
    }
}

/// Operation shape for `CreateRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_repository`](crate::client::Client::create_repository).
///
/// See [`crate::client::fluent_builders::CreateRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRepository {
    _private: (),
}
impl CreateRepository {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
    /// Creates a new `CreateRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRepository {
    type Output = std::result::Result<
        crate::output::CreateRepositoryOutput,
        crate::error::CreateRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_repository_error(response)
        } else {
            crate::operation_deser::parse_create_repository_response(response)
        }
    }
}

/// Operation shape for `CreateService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_service`](crate::client::Client::create_service).
///
/// See [`crate::client::fluent_builders::CreateService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateService {
    _private: (),
}
impl CreateService {
    /// Creates a new builder-style object to manufacture [`CreateServiceInput`](crate::input::CreateServiceInput)
    pub fn builder() -> crate::input::create_service_input::Builder {
        crate::input::create_service_input::Builder::default()
    }
    /// Creates a new `CreateService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateService {
    type Output =
        std::result::Result<crate::output::CreateServiceOutput, crate::error::CreateServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_service_error(response)
        } else {
            crate::operation_deser::parse_create_service_response(response)
        }
    }
}

/// Operation shape for `CreateServiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_service_template`](crate::client::Client::create_service_template).
///
/// See [`crate::client::fluent_builders::CreateServiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateServiceTemplate {
    _private: (),
}
impl CreateServiceTemplate {
    /// Creates a new builder-style object to manufacture [`CreateServiceTemplateInput`](crate::input::CreateServiceTemplateInput)
    pub fn builder() -> crate::input::create_service_template_input::Builder {
        crate::input::create_service_template_input::Builder::default()
    }
    /// Creates a new `CreateServiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateServiceTemplate {
    type Output = std::result::Result<
        crate::output::CreateServiceTemplateOutput,
        crate::error::CreateServiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_service_template_error(response)
        } else {
            crate::operation_deser::parse_create_service_template_response(response)
        }
    }
}

/// Operation shape for `CreateServiceTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_service_template_version`](crate::client::Client::create_service_template_version).
///
/// See [`crate::client::fluent_builders::CreateServiceTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateServiceTemplateVersion {
    _private: (),
}
impl CreateServiceTemplateVersion {
    /// Creates a new builder-style object to manufacture [`CreateServiceTemplateVersionInput`](crate::input::CreateServiceTemplateVersionInput)
    pub fn builder() -> crate::input::create_service_template_version_input::Builder {
        crate::input::create_service_template_version_input::Builder::default()
    }
    /// Creates a new `CreateServiceTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateServiceTemplateVersion {
    type Output = std::result::Result<
        crate::output::CreateServiceTemplateVersionOutput,
        crate::error::CreateServiceTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_service_template_version_error(response)
        } else {
            crate::operation_deser::parse_create_service_template_version_response(response)
        }
    }
}

/// Operation shape for `CreateTemplateSyncConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_template_sync_config`](crate::client::Client::create_template_sync_config).
///
/// See [`crate::client::fluent_builders::CreateTemplateSyncConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTemplateSyncConfig {
    _private: (),
}
impl CreateTemplateSyncConfig {
    /// Creates a new builder-style object to manufacture [`CreateTemplateSyncConfigInput`](crate::input::CreateTemplateSyncConfigInput)
    pub fn builder() -> crate::input::create_template_sync_config_input::Builder {
        crate::input::create_template_sync_config_input::Builder::default()
    }
    /// Creates a new `CreateTemplateSyncConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTemplateSyncConfig {
    type Output = std::result::Result<
        crate::output::CreateTemplateSyncConfigOutput,
        crate::error::CreateTemplateSyncConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_template_sync_config_error(response)
        } else {
            crate::operation_deser::parse_create_template_sync_config_response(response)
        }
    }
}

/// Operation shape for `DeleteEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_environment`](crate::client::Client::delete_environment).
///
/// See [`crate::client::fluent_builders::DeleteEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEnvironment {
    _private: (),
}
impl DeleteEnvironment {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentInput`](crate::input::DeleteEnvironmentInput)
    pub fn builder() -> crate::input::delete_environment_input::Builder {
        crate::input::delete_environment_input::Builder::default()
    }
    /// Creates a new `DeleteEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEnvironment {
    type Output = std::result::Result<
        crate::output::DeleteEnvironmentOutput,
        crate::error::DeleteEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_environment_error(response)
        } else {
            crate::operation_deser::parse_delete_environment_response(response)
        }
    }
}

/// Operation shape for `DeleteEnvironmentAccountConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_environment_account_connection`](crate::client::Client::delete_environment_account_connection).
///
/// See [`crate::client::fluent_builders::DeleteEnvironmentAccountConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEnvironmentAccountConnection {
    _private: (),
}
impl DeleteEnvironmentAccountConnection {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentAccountConnectionInput`](crate::input::DeleteEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::delete_environment_account_connection_input::Builder {
        crate::input::delete_environment_account_connection_input::Builder::default()
    }
    /// Creates a new `DeleteEnvironmentAccountConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEnvironmentAccountConnection {
    type Output = std::result::Result<
        crate::output::DeleteEnvironmentAccountConnectionOutput,
        crate::error::DeleteEnvironmentAccountConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_environment_account_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_environment_account_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteEnvironmentTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_environment_template`](crate::client::Client::delete_environment_template).
///
/// See [`crate::client::fluent_builders::DeleteEnvironmentTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEnvironmentTemplate {
    _private: (),
}
impl DeleteEnvironmentTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentTemplateInput`](crate::input::DeleteEnvironmentTemplateInput)
    pub fn builder() -> crate::input::delete_environment_template_input::Builder {
        crate::input::delete_environment_template_input::Builder::default()
    }
    /// Creates a new `DeleteEnvironmentTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEnvironmentTemplate {
    type Output = std::result::Result<
        crate::output::DeleteEnvironmentTemplateOutput,
        crate::error::DeleteEnvironmentTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_environment_template_error(response)
        } else {
            crate::operation_deser::parse_delete_environment_template_response(response)
        }
    }
}

/// Operation shape for `DeleteEnvironmentTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_environment_template_version`](crate::client::Client::delete_environment_template_version).
///
/// See [`crate::client::fluent_builders::DeleteEnvironmentTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEnvironmentTemplateVersion {
    _private: (),
}
impl DeleteEnvironmentTemplateVersion {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentTemplateVersionInput`](crate::input::DeleteEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::delete_environment_template_version_input::Builder {
        crate::input::delete_environment_template_version_input::Builder::default()
    }
    /// Creates a new `DeleteEnvironmentTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEnvironmentTemplateVersion {
    type Output = std::result::Result<
        crate::output::DeleteEnvironmentTemplateVersionOutput,
        crate::error::DeleteEnvironmentTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_environment_template_version_error(response)
        } else {
            crate::operation_deser::parse_delete_environment_template_version_response(response)
        }
    }
}

/// Operation shape for `DeleteRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository`](crate::client::Client::delete_repository).
///
/// See [`crate::client::fluent_builders::DeleteRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepository {
    _private: (),
}
impl DeleteRepository {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
    /// Creates a new `DeleteRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepository {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryOutput,
        crate::error::DeleteRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_service`](crate::client::Client::delete_service).
///
/// See [`crate::client::fluent_builders::DeleteService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteService {
    _private: (),
}
impl DeleteService {
    /// Creates a new builder-style object to manufacture [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    pub fn builder() -> crate::input::delete_service_input::Builder {
        crate::input::delete_service_input::Builder::default()
    }
    /// Creates a new `DeleteService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteService {
    type Output =
        std::result::Result<crate::output::DeleteServiceOutput, crate::error::DeleteServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_service_error(response)
        } else {
            crate::operation_deser::parse_delete_service_response(response)
        }
    }
}

/// Operation shape for `DeleteServiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_service_template`](crate::client::Client::delete_service_template).
///
/// See [`crate::client::fluent_builders::DeleteServiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteServiceTemplate {
    _private: (),
}
impl DeleteServiceTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteServiceTemplateInput`](crate::input::DeleteServiceTemplateInput)
    pub fn builder() -> crate::input::delete_service_template_input::Builder {
        crate::input::delete_service_template_input::Builder::default()
    }
    /// Creates a new `DeleteServiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteServiceTemplate {
    type Output = std::result::Result<
        crate::output::DeleteServiceTemplateOutput,
        crate::error::DeleteServiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_service_template_error(response)
        } else {
            crate::operation_deser::parse_delete_service_template_response(response)
        }
    }
}

/// Operation shape for `DeleteServiceTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_service_template_version`](crate::client::Client::delete_service_template_version).
///
/// See [`crate::client::fluent_builders::DeleteServiceTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteServiceTemplateVersion {
    _private: (),
}
impl DeleteServiceTemplateVersion {
    /// Creates a new builder-style object to manufacture [`DeleteServiceTemplateVersionInput`](crate::input::DeleteServiceTemplateVersionInput)
    pub fn builder() -> crate::input::delete_service_template_version_input::Builder {
        crate::input::delete_service_template_version_input::Builder::default()
    }
    /// Creates a new `DeleteServiceTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteServiceTemplateVersion {
    type Output = std::result::Result<
        crate::output::DeleteServiceTemplateVersionOutput,
        crate::error::DeleteServiceTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_service_template_version_error(response)
        } else {
            crate::operation_deser::parse_delete_service_template_version_response(response)
        }
    }
}

/// Operation shape for `DeleteTemplateSyncConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_template_sync_config`](crate::client::Client::delete_template_sync_config).
///
/// See [`crate::client::fluent_builders::DeleteTemplateSyncConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTemplateSyncConfig {
    _private: (),
}
impl DeleteTemplateSyncConfig {
    /// Creates a new builder-style object to manufacture [`DeleteTemplateSyncConfigInput`](crate::input::DeleteTemplateSyncConfigInput)
    pub fn builder() -> crate::input::delete_template_sync_config_input::Builder {
        crate::input::delete_template_sync_config_input::Builder::default()
    }
    /// Creates a new `DeleteTemplateSyncConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTemplateSyncConfig {
    type Output = std::result::Result<
        crate::output::DeleteTemplateSyncConfigOutput,
        crate::error::DeleteTemplateSyncConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_template_sync_config_error(response)
        } else {
            crate::operation_deser::parse_delete_template_sync_config_response(response)
        }
    }
}

/// Operation shape for `GetAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_settings`](crate::client::Client::get_account_settings).
///
/// See [`crate::client::fluent_builders::GetAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountSettings {
    _private: (),
}
impl GetAccountSettings {
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
    /// Creates a new `GetAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountSettings {
    type Output = std::result::Result<
        crate::output::GetAccountSettingsOutput,
        crate::error::GetAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_settings_error(response)
        } else {
            crate::operation_deser::parse_get_account_settings_response(response)
        }
    }
}

/// Operation shape for `GetEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_environment`](crate::client::Client::get_environment).
///
/// See [`crate::client::fluent_builders::GetEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEnvironment {
    _private: (),
}
impl GetEnvironment {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentInput`](crate::input::GetEnvironmentInput)
    pub fn builder() -> crate::input::get_environment_input::Builder {
        crate::input::get_environment_input::Builder::default()
    }
    /// Creates a new `GetEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEnvironment {
    type Output =
        std::result::Result<crate::output::GetEnvironmentOutput, crate::error::GetEnvironmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_environment_error(response)
        } else {
            crate::operation_deser::parse_get_environment_response(response)
        }
    }
}

/// Operation shape for `GetEnvironmentAccountConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_environment_account_connection`](crate::client::Client::get_environment_account_connection).
///
/// See [`crate::client::fluent_builders::GetEnvironmentAccountConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEnvironmentAccountConnection {
    _private: (),
}
impl GetEnvironmentAccountConnection {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentAccountConnectionInput`](crate::input::GetEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::get_environment_account_connection_input::Builder {
        crate::input::get_environment_account_connection_input::Builder::default()
    }
    /// Creates a new `GetEnvironmentAccountConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEnvironmentAccountConnection {
    type Output = std::result::Result<
        crate::output::GetEnvironmentAccountConnectionOutput,
        crate::error::GetEnvironmentAccountConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_environment_account_connection_error(response)
        } else {
            crate::operation_deser::parse_get_environment_account_connection_response(response)
        }
    }
}

/// Operation shape for `GetEnvironmentTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_environment_template`](crate::client::Client::get_environment_template).
///
/// See [`crate::client::fluent_builders::GetEnvironmentTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEnvironmentTemplate {
    _private: (),
}
impl GetEnvironmentTemplate {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentTemplateInput`](crate::input::GetEnvironmentTemplateInput)
    pub fn builder() -> crate::input::get_environment_template_input::Builder {
        crate::input::get_environment_template_input::Builder::default()
    }
    /// Creates a new `GetEnvironmentTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEnvironmentTemplate {
    type Output = std::result::Result<
        crate::output::GetEnvironmentTemplateOutput,
        crate::error::GetEnvironmentTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_environment_template_error(response)
        } else {
            crate::operation_deser::parse_get_environment_template_response(response)
        }
    }
}

/// Operation shape for `GetEnvironmentTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_environment_template_version`](crate::client::Client::get_environment_template_version).
///
/// See [`crate::client::fluent_builders::GetEnvironmentTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEnvironmentTemplateVersion {
    _private: (),
}
impl GetEnvironmentTemplateVersion {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentTemplateVersionInput`](crate::input::GetEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::get_environment_template_version_input::Builder {
        crate::input::get_environment_template_version_input::Builder::default()
    }
    /// Creates a new `GetEnvironmentTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEnvironmentTemplateVersion {
    type Output = std::result::Result<
        crate::output::GetEnvironmentTemplateVersionOutput,
        crate::error::GetEnvironmentTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_environment_template_version_error(response)
        } else {
            crate::operation_deser::parse_get_environment_template_version_response(response)
        }
    }
}

/// Operation shape for `GetRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository`](crate::client::Client::get_repository).
///
/// See [`crate::client::fluent_builders::GetRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepository {
    _private: (),
}
impl GetRepository {
    /// Creates a new builder-style object to manufacture [`GetRepositoryInput`](crate::input::GetRepositoryInput)
    pub fn builder() -> crate::input::get_repository_input::Builder {
        crate::input::get_repository_input::Builder::default()
    }
    /// Creates a new `GetRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepository {
    type Output =
        std::result::Result<crate::output::GetRepositoryOutput, crate::error::GetRepositoryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_error(response)
        } else {
            crate::operation_deser::parse_get_repository_response(response)
        }
    }
}

/// Operation shape for `GetRepositorySyncStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository_sync_status`](crate::client::Client::get_repository_sync_status).
///
/// See [`crate::client::fluent_builders::GetRepositorySyncStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepositorySyncStatus {
    _private: (),
}
impl GetRepositorySyncStatus {
    /// Creates a new builder-style object to manufacture [`GetRepositorySyncStatusInput`](crate::input::GetRepositorySyncStatusInput)
    pub fn builder() -> crate::input::get_repository_sync_status_input::Builder {
        crate::input::get_repository_sync_status_input::Builder::default()
    }
    /// Creates a new `GetRepositorySyncStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepositorySyncStatus {
    type Output = std::result::Result<
        crate::output::GetRepositorySyncStatusOutput,
        crate::error::GetRepositorySyncStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_sync_status_error(response)
        } else {
            crate::operation_deser::parse_get_repository_sync_status_response(response)
        }
    }
}

/// Operation shape for `GetService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service`](crate::client::Client::get_service).
///
/// See [`crate::client::fluent_builders::GetService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetService {
    _private: (),
}
impl GetService {
    /// Creates a new builder-style object to manufacture [`GetServiceInput`](crate::input::GetServiceInput)
    pub fn builder() -> crate::input::get_service_input::Builder {
        crate::input::get_service_input::Builder::default()
    }
    /// Creates a new `GetService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetService {
    type Output =
        std::result::Result<crate::output::GetServiceOutput, crate::error::GetServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_error(response)
        } else {
            crate::operation_deser::parse_get_service_response(response)
        }
    }
}

/// Operation shape for `GetServiceInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_instance`](crate::client::Client::get_service_instance).
///
/// See [`crate::client::fluent_builders::GetServiceInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceInstance {
    _private: (),
}
impl GetServiceInstance {
    /// Creates a new builder-style object to manufacture [`GetServiceInstanceInput`](crate::input::GetServiceInstanceInput)
    pub fn builder() -> crate::input::get_service_instance_input::Builder {
        crate::input::get_service_instance_input::Builder::default()
    }
    /// Creates a new `GetServiceInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceInstance {
    type Output = std::result::Result<
        crate::output::GetServiceInstanceOutput,
        crate::error::GetServiceInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_instance_error(response)
        } else {
            crate::operation_deser::parse_get_service_instance_response(response)
        }
    }
}

/// Operation shape for `GetServiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_template`](crate::client::Client::get_service_template).
///
/// See [`crate::client::fluent_builders::GetServiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceTemplate {
    _private: (),
}
impl GetServiceTemplate {
    /// Creates a new builder-style object to manufacture [`GetServiceTemplateInput`](crate::input::GetServiceTemplateInput)
    pub fn builder() -> crate::input::get_service_template_input::Builder {
        crate::input::get_service_template_input::Builder::default()
    }
    /// Creates a new `GetServiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceTemplate {
    type Output = std::result::Result<
        crate::output::GetServiceTemplateOutput,
        crate::error::GetServiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_template_error(response)
        } else {
            crate::operation_deser::parse_get_service_template_response(response)
        }
    }
}

/// Operation shape for `GetServiceTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_template_version`](crate::client::Client::get_service_template_version).
///
/// See [`crate::client::fluent_builders::GetServiceTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceTemplateVersion {
    _private: (),
}
impl GetServiceTemplateVersion {
    /// Creates a new builder-style object to manufacture [`GetServiceTemplateVersionInput`](crate::input::GetServiceTemplateVersionInput)
    pub fn builder() -> crate::input::get_service_template_version_input::Builder {
        crate::input::get_service_template_version_input::Builder::default()
    }
    /// Creates a new `GetServiceTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceTemplateVersion {
    type Output = std::result::Result<
        crate::output::GetServiceTemplateVersionOutput,
        crate::error::GetServiceTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_template_version_error(response)
        } else {
            crate::operation_deser::parse_get_service_template_version_response(response)
        }
    }
}

/// Operation shape for `GetTemplateSyncConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_template_sync_config`](crate::client::Client::get_template_sync_config).
///
/// See [`crate::client::fluent_builders::GetTemplateSyncConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTemplateSyncConfig {
    _private: (),
}
impl GetTemplateSyncConfig {
    /// Creates a new builder-style object to manufacture [`GetTemplateSyncConfigInput`](crate::input::GetTemplateSyncConfigInput)
    pub fn builder() -> crate::input::get_template_sync_config_input::Builder {
        crate::input::get_template_sync_config_input::Builder::default()
    }
    /// Creates a new `GetTemplateSyncConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTemplateSyncConfig {
    type Output = std::result::Result<
        crate::output::GetTemplateSyncConfigOutput,
        crate::error::GetTemplateSyncConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_template_sync_config_error(response)
        } else {
            crate::operation_deser::parse_get_template_sync_config_response(response)
        }
    }
}

/// Operation shape for `GetTemplateSyncStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_template_sync_status`](crate::client::Client::get_template_sync_status).
///
/// See [`crate::client::fluent_builders::GetTemplateSyncStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTemplateSyncStatus {
    _private: (),
}
impl GetTemplateSyncStatus {
    /// Creates a new builder-style object to manufacture [`GetTemplateSyncStatusInput`](crate::input::GetTemplateSyncStatusInput)
    pub fn builder() -> crate::input::get_template_sync_status_input::Builder {
        crate::input::get_template_sync_status_input::Builder::default()
    }
    /// Creates a new `GetTemplateSyncStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTemplateSyncStatus {
    type Output = std::result::Result<
        crate::output::GetTemplateSyncStatusOutput,
        crate::error::GetTemplateSyncStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_template_sync_status_error(response)
        } else {
            crate::operation_deser::parse_get_template_sync_status_response(response)
        }
    }
}

/// Operation shape for `ListEnvironmentAccountConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_environment_account_connections`](crate::client::Client::list_environment_account_connections).
///
/// See [`crate::client::fluent_builders::ListEnvironmentAccountConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnvironmentAccountConnections {
    _private: (),
}
impl ListEnvironmentAccountConnections {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentAccountConnectionsInput`](crate::input::ListEnvironmentAccountConnectionsInput)
    pub fn builder() -> crate::input::list_environment_account_connections_input::Builder {
        crate::input::list_environment_account_connections_input::Builder::default()
    }
    /// Creates a new `ListEnvironmentAccountConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnvironmentAccountConnections {
    type Output = std::result::Result<
        crate::output::ListEnvironmentAccountConnectionsOutput,
        crate::error::ListEnvironmentAccountConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_environment_account_connections_error(response)
        } else {
            crate::operation_deser::parse_list_environment_account_connections_response(response)
        }
    }
}

/// Operation shape for `ListEnvironmentOutputs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_environment_outputs`](crate::client::Client::list_environment_outputs).
///
/// See [`crate::client::fluent_builders::ListEnvironmentOutputs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnvironmentOutputs {
    _private: (),
}
impl ListEnvironmentOutputs {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentOutputsInput`](crate::input::ListEnvironmentOutputsInput)
    pub fn builder() -> crate::input::list_environment_outputs_input::Builder {
        crate::input::list_environment_outputs_input::Builder::default()
    }
    /// Creates a new `ListEnvironmentOutputs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnvironmentOutputs {
    type Output = std::result::Result<
        crate::output::ListEnvironmentOutputsOutput,
        crate::error::ListEnvironmentOutputsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_environment_outputs_error(response)
        } else {
            crate::operation_deser::parse_list_environment_outputs_response(response)
        }
    }
}

/// Operation shape for `ListEnvironmentProvisionedResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_environment_provisioned_resources`](crate::client::Client::list_environment_provisioned_resources).
///
/// See [`crate::client::fluent_builders::ListEnvironmentProvisionedResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnvironmentProvisionedResources {
    _private: (),
}
impl ListEnvironmentProvisionedResources {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentProvisionedResourcesInput`](crate::input::ListEnvironmentProvisionedResourcesInput)
    pub fn builder() -> crate::input::list_environment_provisioned_resources_input::Builder {
        crate::input::list_environment_provisioned_resources_input::Builder::default()
    }
    /// Creates a new `ListEnvironmentProvisionedResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnvironmentProvisionedResources {
    type Output = std::result::Result<
        crate::output::ListEnvironmentProvisionedResourcesOutput,
        crate::error::ListEnvironmentProvisionedResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_environment_provisioned_resources_error(response)
        } else {
            crate::operation_deser::parse_list_environment_provisioned_resources_response(response)
        }
    }
}

/// Operation shape for `ListEnvironments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_environments`](crate::client::Client::list_environments).
///
/// See [`crate::client::fluent_builders::ListEnvironments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnvironments {
    _private: (),
}
impl ListEnvironments {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsInput`](crate::input::ListEnvironmentsInput)
    pub fn builder() -> crate::input::list_environments_input::Builder {
        crate::input::list_environments_input::Builder::default()
    }
    /// Creates a new `ListEnvironments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnvironments {
    type Output = std::result::Result<
        crate::output::ListEnvironmentsOutput,
        crate::error::ListEnvironmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_environments_error(response)
        } else {
            crate::operation_deser::parse_list_environments_response(response)
        }
    }
}

/// Operation shape for `ListEnvironmentTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_environment_templates`](crate::client::Client::list_environment_templates).
///
/// See [`crate::client::fluent_builders::ListEnvironmentTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnvironmentTemplates {
    _private: (),
}
impl ListEnvironmentTemplates {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentTemplatesInput`](crate::input::ListEnvironmentTemplatesInput)
    pub fn builder() -> crate::input::list_environment_templates_input::Builder {
        crate::input::list_environment_templates_input::Builder::default()
    }
    /// Creates a new `ListEnvironmentTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnvironmentTemplates {
    type Output = std::result::Result<
        crate::output::ListEnvironmentTemplatesOutput,
        crate::error::ListEnvironmentTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_environment_templates_error(response)
        } else {
            crate::operation_deser::parse_list_environment_templates_response(response)
        }
    }
}

/// Operation shape for `ListEnvironmentTemplateVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_environment_template_versions`](crate::client::Client::list_environment_template_versions).
///
/// See [`crate::client::fluent_builders::ListEnvironmentTemplateVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEnvironmentTemplateVersions {
    _private: (),
}
impl ListEnvironmentTemplateVersions {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentTemplateVersionsInput`](crate::input::ListEnvironmentTemplateVersionsInput)
    pub fn builder() -> crate::input::list_environment_template_versions_input::Builder {
        crate::input::list_environment_template_versions_input::Builder::default()
    }
    /// Creates a new `ListEnvironmentTemplateVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEnvironmentTemplateVersions {
    type Output = std::result::Result<
        crate::output::ListEnvironmentTemplateVersionsOutput,
        crate::error::ListEnvironmentTemplateVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_environment_template_versions_error(response)
        } else {
            crate::operation_deser::parse_list_environment_template_versions_response(response)
        }
    }
}

/// Operation shape for `ListRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_repositories`](crate::client::Client::list_repositories).
///
/// See [`crate::client::fluent_builders::ListRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRepositories {
    _private: (),
}
impl ListRepositories {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
    pub fn builder() -> crate::input::list_repositories_input::Builder {
        crate::input::list_repositories_input::Builder::default()
    }
    /// Creates a new `ListRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRepositories {
    type Output = std::result::Result<
        crate::output::ListRepositoriesOutput,
        crate::error::ListRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_repositories_error(response)
        } else {
            crate::operation_deser::parse_list_repositories_response(response)
        }
    }
}

/// Operation shape for `ListRepositorySyncDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_repository_sync_definitions`](crate::client::Client::list_repository_sync_definitions).
///
/// See [`crate::client::fluent_builders::ListRepositorySyncDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRepositorySyncDefinitions {
    _private: (),
}
impl ListRepositorySyncDefinitions {
    /// Creates a new builder-style object to manufacture [`ListRepositorySyncDefinitionsInput`](crate::input::ListRepositorySyncDefinitionsInput)
    pub fn builder() -> crate::input::list_repository_sync_definitions_input::Builder {
        crate::input::list_repository_sync_definitions_input::Builder::default()
    }
    /// Creates a new `ListRepositorySyncDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRepositorySyncDefinitions {
    type Output = std::result::Result<
        crate::output::ListRepositorySyncDefinitionsOutput,
        crate::error::ListRepositorySyncDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_repository_sync_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_repository_sync_definitions_response(response)
        }
    }
}

/// Operation shape for `ListServiceInstanceOutputs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_instance_outputs`](crate::client::Client::list_service_instance_outputs).
///
/// See [`crate::client::fluent_builders::ListServiceInstanceOutputs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceInstanceOutputs {
    _private: (),
}
impl ListServiceInstanceOutputs {
    /// Creates a new builder-style object to manufacture [`ListServiceInstanceOutputsInput`](crate::input::ListServiceInstanceOutputsInput)
    pub fn builder() -> crate::input::list_service_instance_outputs_input::Builder {
        crate::input::list_service_instance_outputs_input::Builder::default()
    }
    /// Creates a new `ListServiceInstanceOutputs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceInstanceOutputs {
    type Output = std::result::Result<
        crate::output::ListServiceInstanceOutputsOutput,
        crate::error::ListServiceInstanceOutputsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_instance_outputs_error(response)
        } else {
            crate::operation_deser::parse_list_service_instance_outputs_response(response)
        }
    }
}

/// Operation shape for `ListServiceInstanceProvisionedResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_instance_provisioned_resources`](crate::client::Client::list_service_instance_provisioned_resources).
///
/// See [`crate::client::fluent_builders::ListServiceInstanceProvisionedResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceInstanceProvisionedResources {
    _private: (),
}
impl ListServiceInstanceProvisionedResources {
    /// Creates a new builder-style object to manufacture [`ListServiceInstanceProvisionedResourcesInput`](crate::input::ListServiceInstanceProvisionedResourcesInput)
    pub fn builder() -> crate::input::list_service_instance_provisioned_resources_input::Builder {
        crate::input::list_service_instance_provisioned_resources_input::Builder::default()
    }
    /// Creates a new `ListServiceInstanceProvisionedResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceInstanceProvisionedResources {
    type Output = std::result::Result<
        crate::output::ListServiceInstanceProvisionedResourcesOutput,
        crate::error::ListServiceInstanceProvisionedResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_instance_provisioned_resources_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_service_instance_provisioned_resources_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListServiceInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_instances`](crate::client::Client::list_service_instances).
///
/// See [`crate::client::fluent_builders::ListServiceInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceInstances {
    _private: (),
}
impl ListServiceInstances {
    /// Creates a new builder-style object to manufacture [`ListServiceInstancesInput`](crate::input::ListServiceInstancesInput)
    pub fn builder() -> crate::input::list_service_instances_input::Builder {
        crate::input::list_service_instances_input::Builder::default()
    }
    /// Creates a new `ListServiceInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceInstances {
    type Output = std::result::Result<
        crate::output::ListServiceInstancesOutput,
        crate::error::ListServiceInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_instances_error(response)
        } else {
            crate::operation_deser::parse_list_service_instances_response(response)
        }
    }
}

/// Operation shape for `ListServicePipelineOutputs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_pipeline_outputs`](crate::client::Client::list_service_pipeline_outputs).
///
/// See [`crate::client::fluent_builders::ListServicePipelineOutputs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServicePipelineOutputs {
    _private: (),
}
impl ListServicePipelineOutputs {
    /// Creates a new builder-style object to manufacture [`ListServicePipelineOutputsInput`](crate::input::ListServicePipelineOutputsInput)
    pub fn builder() -> crate::input::list_service_pipeline_outputs_input::Builder {
        crate::input::list_service_pipeline_outputs_input::Builder::default()
    }
    /// Creates a new `ListServicePipelineOutputs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServicePipelineOutputs {
    type Output = std::result::Result<
        crate::output::ListServicePipelineOutputsOutput,
        crate::error::ListServicePipelineOutputsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_pipeline_outputs_error(response)
        } else {
            crate::operation_deser::parse_list_service_pipeline_outputs_response(response)
        }
    }
}

/// Operation shape for `ListServicePipelineProvisionedResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_pipeline_provisioned_resources`](crate::client::Client::list_service_pipeline_provisioned_resources).
///
/// See [`crate::client::fluent_builders::ListServicePipelineProvisionedResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServicePipelineProvisionedResources {
    _private: (),
}
impl ListServicePipelineProvisionedResources {
    /// Creates a new builder-style object to manufacture [`ListServicePipelineProvisionedResourcesInput`](crate::input::ListServicePipelineProvisionedResourcesInput)
    pub fn builder() -> crate::input::list_service_pipeline_provisioned_resources_input::Builder {
        crate::input::list_service_pipeline_provisioned_resources_input::Builder::default()
    }
    /// Creates a new `ListServicePipelineProvisionedResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServicePipelineProvisionedResources {
    type Output = std::result::Result<
        crate::output::ListServicePipelineProvisionedResourcesOutput,
        crate::error::ListServicePipelineProvisionedResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_pipeline_provisioned_resources_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_service_pipeline_provisioned_resources_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_services`](crate::client::Client::list_services).
///
/// See [`crate::client::fluent_builders::ListServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServices {
    _private: (),
}
impl ListServices {
    /// Creates a new builder-style object to manufacture [`ListServicesInput`](crate::input::ListServicesInput)
    pub fn builder() -> crate::input::list_services_input::Builder {
        crate::input::list_services_input::Builder::default()
    }
    /// Creates a new `ListServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServices {
    type Output =
        std::result::Result<crate::output::ListServicesOutput, crate::error::ListServicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_services_error(response)
        } else {
            crate::operation_deser::parse_list_services_response(response)
        }
    }
}

/// Operation shape for `ListServiceTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_templates`](crate::client::Client::list_service_templates).
///
/// See [`crate::client::fluent_builders::ListServiceTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceTemplates {
    _private: (),
}
impl ListServiceTemplates {
    /// Creates a new builder-style object to manufacture [`ListServiceTemplatesInput`](crate::input::ListServiceTemplatesInput)
    pub fn builder() -> crate::input::list_service_templates_input::Builder {
        crate::input::list_service_templates_input::Builder::default()
    }
    /// Creates a new `ListServiceTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceTemplates {
    type Output = std::result::Result<
        crate::output::ListServiceTemplatesOutput,
        crate::error::ListServiceTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_templates_error(response)
        } else {
            crate::operation_deser::parse_list_service_templates_response(response)
        }
    }
}

/// Operation shape for `ListServiceTemplateVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_service_template_versions`](crate::client::Client::list_service_template_versions).
///
/// See [`crate::client::fluent_builders::ListServiceTemplateVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServiceTemplateVersions {
    _private: (),
}
impl ListServiceTemplateVersions {
    /// Creates a new builder-style object to manufacture [`ListServiceTemplateVersionsInput`](crate::input::ListServiceTemplateVersionsInput)
    pub fn builder() -> crate::input::list_service_template_versions_input::Builder {
        crate::input::list_service_template_versions_input::Builder::default()
    }
    /// Creates a new `ListServiceTemplateVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServiceTemplateVersions {
    type Output = std::result::Result<
        crate::output::ListServiceTemplateVersionsOutput,
        crate::error::ListServiceTemplateVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_service_template_versions_error(response)
        } else {
            crate::operation_deser::parse_list_service_template_versions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `NotifyResourceDeploymentStatusChange`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`notify_resource_deployment_status_change`](crate::client::Client::notify_resource_deployment_status_change).
///
/// See [`crate::client::fluent_builders::NotifyResourceDeploymentStatusChange`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct NotifyResourceDeploymentStatusChange {
    _private: (),
}
impl NotifyResourceDeploymentStatusChange {
    /// Creates a new builder-style object to manufacture [`NotifyResourceDeploymentStatusChangeInput`](crate::input::NotifyResourceDeploymentStatusChangeInput)
    pub fn builder() -> crate::input::notify_resource_deployment_status_change_input::Builder {
        crate::input::notify_resource_deployment_status_change_input::Builder::default()
    }
    /// Creates a new `NotifyResourceDeploymentStatusChange` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for NotifyResourceDeploymentStatusChange {
    type Output = std::result::Result<
        crate::output::NotifyResourceDeploymentStatusChangeOutput,
        crate::error::NotifyResourceDeploymentStatusChangeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_notify_resource_deployment_status_change_error(response)
        } else {
            crate::operation_deser::parse_notify_resource_deployment_status_change_response(
                response,
            )
        }
    }
}

/// Operation shape for `RejectEnvironmentAccountConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_environment_account_connection`](crate::client::Client::reject_environment_account_connection).
///
/// See [`crate::client::fluent_builders::RejectEnvironmentAccountConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectEnvironmentAccountConnection {
    _private: (),
}
impl RejectEnvironmentAccountConnection {
    /// Creates a new builder-style object to manufacture [`RejectEnvironmentAccountConnectionInput`](crate::input::RejectEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::reject_environment_account_connection_input::Builder {
        crate::input::reject_environment_account_connection_input::Builder::default()
    }
    /// Creates a new `RejectEnvironmentAccountConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectEnvironmentAccountConnection {
    type Output = std::result::Result<
        crate::output::RejectEnvironmentAccountConnectionOutput,
        crate::error::RejectEnvironmentAccountConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_environment_account_connection_error(response)
        } else {
            crate::operation_deser::parse_reject_environment_account_connection_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account_settings`](crate::client::Client::update_account_settings).
///
/// See [`crate::client::fluent_builders::UpdateAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccountSettings {
    _private: (),
}
impl UpdateAccountSettings {
    /// Creates a new builder-style object to manufacture [`UpdateAccountSettingsInput`](crate::input::UpdateAccountSettingsInput)
    pub fn builder() -> crate::input::update_account_settings_input::Builder {
        crate::input::update_account_settings_input::Builder::default()
    }
    /// Creates a new `UpdateAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccountSettings {
    type Output = std::result::Result<
        crate::output::UpdateAccountSettingsOutput,
        crate::error::UpdateAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_account_settings_error(response)
        } else {
            crate::operation_deser::parse_update_account_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateEnvironment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_environment`](crate::client::Client::update_environment).
///
/// See [`crate::client::fluent_builders::UpdateEnvironment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEnvironment {
    _private: (),
}
impl UpdateEnvironment {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentInput`](crate::input::UpdateEnvironmentInput)
    pub fn builder() -> crate::input::update_environment_input::Builder {
        crate::input::update_environment_input::Builder::default()
    }
    /// Creates a new `UpdateEnvironment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEnvironment {
    type Output = std::result::Result<
        crate::output::UpdateEnvironmentOutput,
        crate::error::UpdateEnvironmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_environment_error(response)
        } else {
            crate::operation_deser::parse_update_environment_response(response)
        }
    }
}

/// Operation shape for `UpdateEnvironmentAccountConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_environment_account_connection`](crate::client::Client::update_environment_account_connection).
///
/// See [`crate::client::fluent_builders::UpdateEnvironmentAccountConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEnvironmentAccountConnection {
    _private: (),
}
impl UpdateEnvironmentAccountConnection {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentAccountConnectionInput`](crate::input::UpdateEnvironmentAccountConnectionInput)
    pub fn builder() -> crate::input::update_environment_account_connection_input::Builder {
        crate::input::update_environment_account_connection_input::Builder::default()
    }
    /// Creates a new `UpdateEnvironmentAccountConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEnvironmentAccountConnection {
    type Output = std::result::Result<
        crate::output::UpdateEnvironmentAccountConnectionOutput,
        crate::error::UpdateEnvironmentAccountConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_environment_account_connection_error(response)
        } else {
            crate::operation_deser::parse_update_environment_account_connection_response(response)
        }
    }
}

/// Operation shape for `UpdateEnvironmentTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_environment_template`](crate::client::Client::update_environment_template).
///
/// See [`crate::client::fluent_builders::UpdateEnvironmentTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEnvironmentTemplate {
    _private: (),
}
impl UpdateEnvironmentTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentTemplateInput`](crate::input::UpdateEnvironmentTemplateInput)
    pub fn builder() -> crate::input::update_environment_template_input::Builder {
        crate::input::update_environment_template_input::Builder::default()
    }
    /// Creates a new `UpdateEnvironmentTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEnvironmentTemplate {
    type Output = std::result::Result<
        crate::output::UpdateEnvironmentTemplateOutput,
        crate::error::UpdateEnvironmentTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_environment_template_error(response)
        } else {
            crate::operation_deser::parse_update_environment_template_response(response)
        }
    }
}

/// Operation shape for `UpdateEnvironmentTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_environment_template_version`](crate::client::Client::update_environment_template_version).
///
/// See [`crate::client::fluent_builders::UpdateEnvironmentTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEnvironmentTemplateVersion {
    _private: (),
}
impl UpdateEnvironmentTemplateVersion {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentTemplateVersionInput`](crate::input::UpdateEnvironmentTemplateVersionInput)
    pub fn builder() -> crate::input::update_environment_template_version_input::Builder {
        crate::input::update_environment_template_version_input::Builder::default()
    }
    /// Creates a new `UpdateEnvironmentTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEnvironmentTemplateVersion {
    type Output = std::result::Result<
        crate::output::UpdateEnvironmentTemplateVersionOutput,
        crate::error::UpdateEnvironmentTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_environment_template_version_error(response)
        } else {
            crate::operation_deser::parse_update_environment_template_version_response(response)
        }
    }
}

/// Operation shape for `UpdateService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service`](crate::client::Client::update_service).
///
/// See [`crate::client::fluent_builders::UpdateService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateService {
    _private: (),
}
impl UpdateService {
    /// Creates a new builder-style object to manufacture [`UpdateServiceInput`](crate::input::UpdateServiceInput)
    pub fn builder() -> crate::input::update_service_input::Builder {
        crate::input::update_service_input::Builder::default()
    }
    /// Creates a new `UpdateService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateService {
    type Output =
        std::result::Result<crate::output::UpdateServiceOutput, crate::error::UpdateServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_error(response)
        } else {
            crate::operation_deser::parse_update_service_response(response)
        }
    }
}

/// Operation shape for `UpdateServiceInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_instance`](crate::client::Client::update_service_instance).
///
/// See [`crate::client::fluent_builders::UpdateServiceInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServiceInstance {
    _private: (),
}
impl UpdateServiceInstance {
    /// Creates a new builder-style object to manufacture [`UpdateServiceInstanceInput`](crate::input::UpdateServiceInstanceInput)
    pub fn builder() -> crate::input::update_service_instance_input::Builder {
        crate::input::update_service_instance_input::Builder::default()
    }
    /// Creates a new `UpdateServiceInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServiceInstance {
    type Output = std::result::Result<
        crate::output::UpdateServiceInstanceOutput,
        crate::error::UpdateServiceInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_instance_error(response)
        } else {
            crate::operation_deser::parse_update_service_instance_response(response)
        }
    }
}

/// Operation shape for `UpdateServicePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_pipeline`](crate::client::Client::update_service_pipeline).
///
/// See [`crate::client::fluent_builders::UpdateServicePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServicePipeline {
    _private: (),
}
impl UpdateServicePipeline {
    /// Creates a new builder-style object to manufacture [`UpdateServicePipelineInput`](crate::input::UpdateServicePipelineInput)
    pub fn builder() -> crate::input::update_service_pipeline_input::Builder {
        crate::input::update_service_pipeline_input::Builder::default()
    }
    /// Creates a new `UpdateServicePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServicePipeline {
    type Output = std::result::Result<
        crate::output::UpdateServicePipelineOutput,
        crate::error::UpdateServicePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_pipeline_error(response)
        } else {
            crate::operation_deser::parse_update_service_pipeline_response(response)
        }
    }
}

/// Operation shape for `UpdateServiceTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_template`](crate::client::Client::update_service_template).
///
/// See [`crate::client::fluent_builders::UpdateServiceTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServiceTemplate {
    _private: (),
}
impl UpdateServiceTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateServiceTemplateInput`](crate::input::UpdateServiceTemplateInput)
    pub fn builder() -> crate::input::update_service_template_input::Builder {
        crate::input::update_service_template_input::Builder::default()
    }
    /// Creates a new `UpdateServiceTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServiceTemplate {
    type Output = std::result::Result<
        crate::output::UpdateServiceTemplateOutput,
        crate::error::UpdateServiceTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_template_error(response)
        } else {
            crate::operation_deser::parse_update_service_template_response(response)
        }
    }
}

/// Operation shape for `UpdateServiceTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_template_version`](crate::client::Client::update_service_template_version).
///
/// See [`crate::client::fluent_builders::UpdateServiceTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServiceTemplateVersion {
    _private: (),
}
impl UpdateServiceTemplateVersion {
    /// Creates a new builder-style object to manufacture [`UpdateServiceTemplateVersionInput`](crate::input::UpdateServiceTemplateVersionInput)
    pub fn builder() -> crate::input::update_service_template_version_input::Builder {
        crate::input::update_service_template_version_input::Builder::default()
    }
    /// Creates a new `UpdateServiceTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServiceTemplateVersion {
    type Output = std::result::Result<
        crate::output::UpdateServiceTemplateVersionOutput,
        crate::error::UpdateServiceTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_template_version_error(response)
        } else {
            crate::operation_deser::parse_update_service_template_version_response(response)
        }
    }
}

/// Operation shape for `UpdateTemplateSyncConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_template_sync_config`](crate::client::Client::update_template_sync_config).
///
/// See [`crate::client::fluent_builders::UpdateTemplateSyncConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTemplateSyncConfig {
    _private: (),
}
impl UpdateTemplateSyncConfig {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateSyncConfigInput`](crate::input::UpdateTemplateSyncConfigInput)
    pub fn builder() -> crate::input::update_template_sync_config_input::Builder {
        crate::input::update_template_sync_config_input::Builder::default()
    }
    /// Creates a new `UpdateTemplateSyncConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTemplateSyncConfig {
    type Output = std::result::Result<
        crate::output::UpdateTemplateSyncConfigOutput,
        crate::error::UpdateTemplateSyncConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_template_sync_config_error(response)
        } else {
            crate::operation_deser::parse_update_template_sync_config_response(response)
        }
    }
}
