// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The detail data for a template sync configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateSyncConfig {
    /// <p>The template name.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The template type.</p>
    pub template_type: std::option::Option<crate::model::TemplateType>,
    /// <p>The repository provider.</p>
    pub repository_provider: std::option::Option<crate::model::RepositoryProvider>,
    /// <p>The name of the repository, for example <code>myrepos/myrepo</code>.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The repository branch.</p>
    pub branch: std::option::Option<std::string::String>,
    /// <p>A subdirectory path to your template bundle version.</p>
    pub subdirectory: std::option::Option<std::string::String>,
}
impl TemplateSyncConfig {
    /// <p>The template name.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The template type.</p>
    pub fn template_type(&self) -> std::option::Option<&crate::model::TemplateType> {
        self.template_type.as_ref()
    }
    /// <p>The repository provider.</p>
    pub fn repository_provider(&self) -> std::option::Option<&crate::model::RepositoryProvider> {
        self.repository_provider.as_ref()
    }
    /// <p>The name of the repository, for example <code>myrepos/myrepo</code>.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The repository branch.</p>
    pub fn branch(&self) -> std::option::Option<&str> {
        self.branch.as_deref()
    }
    /// <p>A subdirectory path to your template bundle version.</p>
    pub fn subdirectory(&self) -> std::option::Option<&str> {
        self.subdirectory.as_deref()
    }
}
impl std::fmt::Debug for TemplateSyncConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateSyncConfig");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_type", &self.template_type);
        formatter.field("repository_provider", &self.repository_provider);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("branch", &self.branch);
        formatter.field("subdirectory", &self.subdirectory);
        formatter.finish()
    }
}
/// See [`TemplateSyncConfig`](crate::model::TemplateSyncConfig)
pub mod template_sync_config {
    /// A builder for [`TemplateSyncConfig`](crate::model::TemplateSyncConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_type: std::option::Option<crate::model::TemplateType>,
        pub(crate) repository_provider: std::option::Option<crate::model::RepositoryProvider>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) branch: std::option::Option<std::string::String>,
        pub(crate) subdirectory: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The template name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The template type.</p>
        pub fn template_type(mut self, input: crate::model::TemplateType) -> Self {
            self.template_type = Some(input);
            self
        }
        /// <p>The template type.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.template_type = input;
            self
        }
        /// <p>The repository provider.</p>
        pub fn repository_provider(mut self, input: crate::model::RepositoryProvider) -> Self {
            self.repository_provider = Some(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_repository_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.repository_provider = input;
            self
        }
        /// <p>The name of the repository, for example <code>myrepos/myrepo</code>.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository, for example <code>myrepos/myrepo</code>.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The repository branch.</p>
        pub fn branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch = Some(input.into());
            self
        }
        /// <p>The repository branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch = input;
            self
        }
        /// <p>A subdirectory path to your template bundle version.</p>
        pub fn subdirectory(mut self, input: impl Into<std::string::String>) -> Self {
            self.subdirectory = Some(input.into());
            self
        }
        /// <p>A subdirectory path to your template bundle version.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subdirectory = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateSyncConfig`](crate::model::TemplateSyncConfig)
        pub fn build(self) -> crate::model::TemplateSyncConfig {
            crate::model::TemplateSyncConfig {
                template_name: self.template_name,
                template_type: self.template_type,
                repository_provider: self.repository_provider,
                repository_name: self.repository_name,
                branch: self.branch,
                subdirectory: self.subdirectory,
            }
        }
    }
}
impl TemplateSyncConfig {
    /// Creates a new builder-style object to manufacture [`TemplateSyncConfig`](crate::model::TemplateSyncConfig)
    pub fn builder() -> crate::model::template_sync_config::Builder {
        crate::model::template_sync_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RepositoryProvider {
    #[allow(missing_docs)] // documentation missing in model
    Bitbucket,
    #[allow(missing_docs)] // documentation missing in model
    Github,
    #[allow(missing_docs)] // documentation missing in model
    GithubEnterprise,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RepositoryProvider {
    fn from(s: &str) -> Self {
        match s {
            "BITBUCKET" => RepositoryProvider::Bitbucket,
            "GITHUB" => RepositoryProvider::Github,
            "GITHUB_ENTERPRISE" => RepositoryProvider::GithubEnterprise,
            other => RepositoryProvider::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RepositoryProvider {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RepositoryProvider::from(s))
    }
}
impl RepositoryProvider {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RepositoryProvider::Bitbucket => "BITBUCKET",
            RepositoryProvider::Github => "GITHUB",
            RepositoryProvider::GithubEnterprise => "GITHUB_ENTERPRISE",
            RepositoryProvider::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BITBUCKET", "GITHUB", "GITHUB_ENTERPRISE"]
    }
}
impl AsRef<str> for RepositoryProvider {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemplateType {
    #[allow(missing_docs)] // documentation missing in model
    Environment,
    #[allow(missing_docs)] // documentation missing in model
    Service,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemplateType {
    fn from(s: &str) -> Self {
        match s {
            "ENVIRONMENT" => TemplateType::Environment,
            "SERVICE" => TemplateType::Service,
            other => TemplateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemplateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemplateType::from(s))
    }
}
impl TemplateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemplateType::Environment => "ENVIRONMENT",
            TemplateType::Service => "SERVICE",
            TemplateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENVIRONMENT", "SERVICE"]
    }
}
impl AsRef<str> for TemplateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of the service template version detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceTemplateVersionSummary {
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The latest major version that's associated with the version of a service template.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of a service template.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>The recommended minor version of the service template.</p>
    pub recommended_minor_version: std::option::Option<std::string::String>,
    /// <p>The service template minor version status.</p>
    pub status: std::option::Option<crate::model::TemplateVersionStatus>,
    /// <p>A service template minor version status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A description of the version of a service template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the version of a service template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the version of a service template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl ServiceTemplateVersionSummary {
    /// <p>The name of the service template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The latest major version that's associated with the version of a service template.</p>
    pub fn major_version(&self) -> std::option::Option<&str> {
        self.major_version.as_deref()
    }
    /// <p>The minor version of a service template.</p>
    pub fn minor_version(&self) -> std::option::Option<&str> {
        self.minor_version.as_deref()
    }
    /// <p>The recommended minor version of the service template.</p>
    pub fn recommended_minor_version(&self) -> std::option::Option<&str> {
        self.recommended_minor_version.as_deref()
    }
    /// <p>The service template minor version status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TemplateVersionStatus> {
        self.status.as_ref()
    }
    /// <p>A service template minor version status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>A description of the version of a service template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the version of a service template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the version of a service template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
}
impl std::fmt::Debug for ServiceTemplateVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceTemplateVersionSummary");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("recommended_minor_version", &self.recommended_minor_version);
        formatter.field("status", &self.status);
        formatter.field("status_message", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.finish()
    }
}
/// See [`ServiceTemplateVersionSummary`](crate::model::ServiceTemplateVersionSummary)
pub mod service_template_version_summary {
    /// A builder for [`ServiceTemplateVersionSummary`](crate::model::ServiceTemplateVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) recommended_minor_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TemplateVersionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The latest major version that's associated with the version of a service template.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The latest major version that's associated with the version of a service template.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>The minor version of a service template.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of a service template.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>The recommended minor version of the service template.</p>
        pub fn recommended_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_minor_version = Some(input.into());
            self
        }
        /// <p>The recommended minor version of the service template.</p>
        pub fn set_recommended_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_minor_version = input;
            self
        }
        /// <p>The service template minor version status.</p>
        pub fn status(mut self, input: crate::model::TemplateVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The service template minor version status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A service template minor version status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A service template minor version status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A description of the version of a service template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the version of a service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the version of a service template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the version of a service template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the version of a service template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the version of a service template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceTemplateVersionSummary`](crate::model::ServiceTemplateVersionSummary)
        pub fn build(self) -> crate::model::ServiceTemplateVersionSummary {
            crate::model::ServiceTemplateVersionSummary {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
                recommended_minor_version: self.recommended_minor_version,
                status: self.status,
                status_message: self.status_message,
                description: self.description,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
            }
        }
    }
}
impl ServiceTemplateVersionSummary {
    /// Creates a new builder-style object to manufacture [`ServiceTemplateVersionSummary`](crate::model::ServiceTemplateVersionSummary)
    pub fn builder() -> crate::model::service_template_version_summary::Builder {
        crate::model::service_template_version_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemplateVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Published,
    #[allow(missing_docs)] // documentation missing in model
    RegistrationFailed,
    #[allow(missing_docs)] // documentation missing in model
    RegistrationInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemplateVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DRAFT" => TemplateVersionStatus::Draft,
            "PUBLISHED" => TemplateVersionStatus::Published,
            "REGISTRATION_FAILED" => TemplateVersionStatus::RegistrationFailed,
            "REGISTRATION_IN_PROGRESS" => TemplateVersionStatus::RegistrationInProgress,
            other => TemplateVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemplateVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemplateVersionStatus::from(s))
    }
}
impl TemplateVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemplateVersionStatus::Draft => "DRAFT",
            TemplateVersionStatus::Published => "PUBLISHED",
            TemplateVersionStatus::RegistrationFailed => "REGISTRATION_FAILED",
            TemplateVersionStatus::RegistrationInProgress => "REGISTRATION_IN_PROGRESS",
            TemplateVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DRAFT",
            "PUBLISHED",
            "REGISTRATION_FAILED",
            "REGISTRATION_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for TemplateVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The version of a service template detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceTemplateVersion {
    /// <p>The name of the version of a service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The latest major version that's associated with the version of a service template.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of a service template.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>The recommended minor version of the service template.</p>
    pub recommended_minor_version: std::option::Option<std::string::String>,
    /// <p>The service template version status.</p>
    pub status: std::option::Option<crate::model::TemplateVersionStatus>,
    /// <p>A service template version status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A description of the version of a service template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the version of a service template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the version of a service template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An array of compatible environment template names for the major version of a service template.</p>
    pub compatible_environment_templates:
        std::option::Option<std::vec::Vec<crate::model::CompatibleEnvironmentTemplate>>,
    /// <p>The schema of the version of a service template.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl ServiceTemplateVersion {
    /// <p>The name of the version of a service template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The latest major version that's associated with the version of a service template.</p>
    pub fn major_version(&self) -> std::option::Option<&str> {
        self.major_version.as_deref()
    }
    /// <p>The minor version of a service template.</p>
    pub fn minor_version(&self) -> std::option::Option<&str> {
        self.minor_version.as_deref()
    }
    /// <p>The recommended minor version of the service template.</p>
    pub fn recommended_minor_version(&self) -> std::option::Option<&str> {
        self.recommended_minor_version.as_deref()
    }
    /// <p>The service template version status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TemplateVersionStatus> {
        self.status.as_ref()
    }
    /// <p>A service template version status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>A description of the version of a service template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the version of a service template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the version of a service template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>An array of compatible environment template names for the major version of a service template.</p>
    pub fn compatible_environment_templates(
        &self,
    ) -> std::option::Option<&[crate::model::CompatibleEnvironmentTemplate]> {
        self.compatible_environment_templates.as_deref()
    }
    /// <p>The schema of the version of a service template.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for ServiceTemplateVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceTemplateVersion");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("recommended_minor_version", &self.recommended_minor_version);
        formatter.field("status", &self.status);
        formatter.field("status_message", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field(
            "compatible_environment_templates",
            &self.compatible_environment_templates,
        );
        formatter.field("schema", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServiceTemplateVersion`](crate::model::ServiceTemplateVersion)
pub mod service_template_version {
    /// A builder for [`ServiceTemplateVersion`](crate::model::ServiceTemplateVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) recommended_minor_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TemplateVersionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) compatible_environment_templates:
            std::option::Option<std::vec::Vec<crate::model::CompatibleEnvironmentTemplate>>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the version of a service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the version of a service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The latest major version that's associated with the version of a service template.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The latest major version that's associated with the version of a service template.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>The minor version of a service template.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of a service template.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>The recommended minor version of the service template.</p>
        pub fn recommended_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_minor_version = Some(input.into());
            self
        }
        /// <p>The recommended minor version of the service template.</p>
        pub fn set_recommended_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_minor_version = input;
            self
        }
        /// <p>The service template version status.</p>
        pub fn status(mut self, input: crate::model::TemplateVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The service template version status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A service template version status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A service template version status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A description of the version of a service template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the version of a service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of a service template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the version of a service template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the version of a service template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the version of a service template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the version of a service template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// Appends an item to `compatible_environment_templates`.
        ///
        /// To override the contents of this collection use [`set_compatible_environment_templates`](Self::set_compatible_environment_templates).
        ///
        /// <p>An array of compatible environment template names for the major version of a service template.</p>
        pub fn compatible_environment_templates(
            mut self,
            input: impl Into<crate::model::CompatibleEnvironmentTemplate>,
        ) -> Self {
            let mut v = self.compatible_environment_templates.unwrap_or_default();
            v.push(input.into());
            self.compatible_environment_templates = Some(v);
            self
        }
        /// <p>An array of compatible environment template names for the major version of a service template.</p>
        pub fn set_compatible_environment_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CompatibleEnvironmentTemplate>>,
        ) -> Self {
            self.compatible_environment_templates = input;
            self
        }
        /// <p>The schema of the version of a service template.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema of the version of a service template.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceTemplateVersion`](crate::model::ServiceTemplateVersion)
        pub fn build(self) -> crate::model::ServiceTemplateVersion {
            crate::model::ServiceTemplateVersion {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
                recommended_minor_version: self.recommended_minor_version,
                status: self.status,
                status_message: self.status_message,
                description: self.description,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                compatible_environment_templates: self.compatible_environment_templates,
                schema: self.schema,
            }
        }
    }
}
impl ServiceTemplateVersion {
    /// Creates a new builder-style object to manufacture [`ServiceTemplateVersion`](crate::model::ServiceTemplateVersion)
    pub fn builder() -> crate::model::service_template_version::Builder {
        crate::model::service_template_version::Builder::default()
    }
}

/// <p>Compatible environment template data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompatibleEnvironmentTemplate {
    /// <p>The compatible environment template name.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The major version of the compatible environment template.</p>
    pub major_version: std::option::Option<std::string::String>,
}
impl CompatibleEnvironmentTemplate {
    /// <p>The compatible environment template name.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The major version of the compatible environment template.</p>
    pub fn major_version(&self) -> std::option::Option<&str> {
        self.major_version.as_deref()
    }
}
impl std::fmt::Debug for CompatibleEnvironmentTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompatibleEnvironmentTemplate");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.finish()
    }
}
/// See [`CompatibleEnvironmentTemplate`](crate::model::CompatibleEnvironmentTemplate)
pub mod compatible_environment_template {
    /// A builder for [`CompatibleEnvironmentTemplate`](crate::model::CompatibleEnvironmentTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The compatible environment template name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The compatible environment template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The major version of the compatible environment template.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The major version of the compatible environment template.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CompatibleEnvironmentTemplate`](crate::model::CompatibleEnvironmentTemplate)
        pub fn build(self) -> crate::model::CompatibleEnvironmentTemplate {
            crate::model::CompatibleEnvironmentTemplate {
                template_name: self.template_name,
                major_version: self.major_version,
            }
        }
    }
}
impl CompatibleEnvironmentTemplate {
    /// Creates a new builder-style object to manufacture [`CompatibleEnvironmentTemplate`](crate::model::CompatibleEnvironmentTemplate)
    pub fn builder() -> crate::model::compatible_environment_template::Builder {
        crate::model::compatible_environment_template::Builder::default()
    }
}

/// <p>A description of a resource tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the resource tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the resource tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the resource tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the resource tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the resource tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the resource tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the resource tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the resource tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Compatible environment template data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompatibleEnvironmentTemplateInput {
    /// <p>The compatible environment template name.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The major version of the compatible environment template.</p>
    pub major_version: std::option::Option<std::string::String>,
}
impl CompatibleEnvironmentTemplateInput {
    /// <p>The compatible environment template name.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The major version of the compatible environment template.</p>
    pub fn major_version(&self) -> std::option::Option<&str> {
        self.major_version.as_deref()
    }
}
impl std::fmt::Debug for CompatibleEnvironmentTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompatibleEnvironmentTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.finish()
    }
}
/// See [`CompatibleEnvironmentTemplateInput`](crate::model::CompatibleEnvironmentTemplateInput)
pub mod compatible_environment_template_input {
    /// A builder for [`CompatibleEnvironmentTemplateInput`](crate::model::CompatibleEnvironmentTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The compatible environment template name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The compatible environment template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The major version of the compatible environment template.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The major version of the compatible environment template.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CompatibleEnvironmentTemplateInput`](crate::model::CompatibleEnvironmentTemplateInput)
        pub fn build(self) -> crate::model::CompatibleEnvironmentTemplateInput {
            crate::model::CompatibleEnvironmentTemplateInput {
                template_name: self.template_name,
                major_version: self.major_version,
            }
        }
    }
}
impl CompatibleEnvironmentTemplateInput {
    /// Creates a new builder-style object to manufacture [`CompatibleEnvironmentTemplateInput`](crate::model::CompatibleEnvironmentTemplateInput)
    pub fn builder() -> crate::model::compatible_environment_template_input::Builder {
        crate::model::compatible_environment_template_input::Builder::default()
    }
}

/// <p>Template version source data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum TemplateVersionSourceInput {
    /// <p>An S3 source object that includes the template bundle S3 path and name for a template minor version.</p>
    S3(crate::model::S3ObjectSource),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl TemplateVersionSourceInput {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`S3`](crate::model::TemplateVersionSourceInput::S3), extracting the inner [`S3ObjectSource`](crate::model::S3ObjectSource).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3(&self) -> std::result::Result<&crate::model::S3ObjectSource, &Self> {
        if let TemplateVersionSourceInput::S3(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`S3`](crate::model::TemplateVersionSourceInput::S3).
    pub fn is_s3(&self) -> bool {
        self.as_s3().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Template bundle S3 bucket data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ObjectSource {
    /// <p>The name of the S3 bucket that contains a template bundle.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The path to the S3 bucket that contains a template bundle.</p>
    pub key: std::option::Option<std::string::String>,
}
impl S3ObjectSource {
    /// <p>The name of the S3 bucket that contains a template bundle.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The path to the S3 bucket that contains a template bundle.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for S3ObjectSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ObjectSource");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`S3ObjectSource`](crate::model::S3ObjectSource)
pub mod s3_object_source {
    /// A builder for [`S3ObjectSource`](crate::model::S3ObjectSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket that contains a template bundle.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket that contains a template bundle.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The path to the S3 bucket that contains a template bundle.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The path to the S3 bucket that contains a template bundle.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ObjectSource`](crate::model::S3ObjectSource)
        pub fn build(self) -> crate::model::S3ObjectSource {
            crate::model::S3ObjectSource {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl S3ObjectSource {
    /// Creates a new builder-style object to manufacture [`S3ObjectSource`](crate::model::S3ObjectSource)
    pub fn builder() -> crate::model::s3_object_source::Builder {
        crate::model::s3_object_source::Builder::default()
    }
}

/// <p>The service template summary data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceTemplateSummary {
    /// <p>The name of the service template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the service template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the service template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The service template name as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the service template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The recommended version of the service template.</p>
    pub recommended_version: std::option::Option<std::string::String>,
    /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template, otherwise a service
    /// pipeline <i>isn't</i> included in the service template.</p>
    pub pipeline_provisioning: std::option::Option<crate::model::Provisioning>,
}
impl ServiceTemplateSummary {
    /// <p>The name of the service template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the service template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the service template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The service template name as displayed in the developer interface.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>A description of the service template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The recommended version of the service template.</p>
    pub fn recommended_version(&self) -> std::option::Option<&str> {
        self.recommended_version.as_deref()
    }
    /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template, otherwise a service
    /// pipeline <i>isn't</i> included in the service template.</p>
    pub fn pipeline_provisioning(&self) -> std::option::Option<&crate::model::Provisioning> {
        self.pipeline_provisioning.as_ref()
    }
}
impl std::fmt::Debug for ServiceTemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceTemplateSummary");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("recommended_version", &self.recommended_version);
        formatter.field("pipeline_provisioning", &self.pipeline_provisioning);
        formatter.finish()
    }
}
/// See [`ServiceTemplateSummary`](crate::model::ServiceTemplateSummary)
pub mod service_template_summary {
    /// A builder for [`ServiceTemplateSummary`](crate::model::ServiceTemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommended_version: std::option::Option<std::string::String>,
        pub(crate) pipeline_provisioning: std::option::Option<crate::model::Provisioning>,
    }
    impl Builder {
        /// <p>The name of the service template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the service template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the service template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the service template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the service template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The service template name as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The service template name as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the service template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The recommended version of the service template.</p>
        pub fn recommended_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_version = Some(input.into());
            self
        }
        /// <p>The recommended version of the service template.</p>
        pub fn set_recommended_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_version = input;
            self
        }
        /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template, otherwise a service
        /// pipeline <i>isn't</i> included in the service template.</p>
        pub fn pipeline_provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.pipeline_provisioning = Some(input);
            self
        }
        /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template, otherwise a service
        /// pipeline <i>isn't</i> included in the service template.</p>
        pub fn set_pipeline_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.pipeline_provisioning = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceTemplateSummary`](crate::model::ServiceTemplateSummary)
        pub fn build(self) -> crate::model::ServiceTemplateSummary {
            crate::model::ServiceTemplateSummary {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                display_name: self.display_name,
                description: self.description,
                recommended_version: self.recommended_version,
                pipeline_provisioning: self.pipeline_provisioning,
            }
        }
    }
}
impl ServiceTemplateSummary {
    /// Creates a new builder-style object to manufacture [`ServiceTemplateSummary`](crate::model::ServiceTemplateSummary)
    pub fn builder() -> crate::model::service_template_summary::Builder {
        crate::model::service_template_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Provisioning {
    #[allow(missing_docs)] // documentation missing in model
    CustomerManaged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Provisioning {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOMER_MANAGED" => Provisioning::CustomerManaged,
            other => Provisioning::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Provisioning {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Provisioning::from(s))
    }
}
impl Provisioning {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Provisioning::CustomerManaged => "CUSTOMER_MANAGED",
            Provisioning::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOMER_MANAGED"]
    }
}
impl AsRef<str> for Provisioning {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The service template detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceTemplate {
    /// <p>The name of the service template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the service template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the service template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The service template name as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the service template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The recommended version of the service template.</p>
    pub recommended_version: std::option::Option<std::string::String>,
    /// <p>The customer provided service template encryption key that's used to encrypt data.</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template. Otherwise, a service
    /// pipeline <i>isn't</i> included in the service template.</p>
    pub pipeline_provisioning: std::option::Option<crate::model::Provisioning>,
}
impl ServiceTemplate {
    /// <p>The name of the service template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the service template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the service template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The service template name as displayed in the developer interface.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>A description of the service template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The recommended version of the service template.</p>
    pub fn recommended_version(&self) -> std::option::Option<&str> {
        self.recommended_version.as_deref()
    }
    /// <p>The customer provided service template encryption key that's used to encrypt data.</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template. Otherwise, a service
    /// pipeline <i>isn't</i> included in the service template.</p>
    pub fn pipeline_provisioning(&self) -> std::option::Option<&crate::model::Provisioning> {
        self.pipeline_provisioning.as_ref()
    }
}
impl std::fmt::Debug for ServiceTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceTemplate");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("recommended_version", &self.recommended_version);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("pipeline_provisioning", &self.pipeline_provisioning);
        formatter.finish()
    }
}
/// See [`ServiceTemplate`](crate::model::ServiceTemplate)
pub mod service_template {
    /// A builder for [`ServiceTemplate`](crate::model::ServiceTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommended_version: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) pipeline_provisioning: std::option::Option<crate::model::Provisioning>,
    }
    impl Builder {
        /// <p>The name of the service template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the service template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the service template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the service template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the service template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The service template name as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The service template name as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the service template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The recommended version of the service template.</p>
        pub fn recommended_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_version = Some(input.into());
            self
        }
        /// <p>The recommended version of the service template.</p>
        pub fn set_recommended_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_version = input;
            self
        }
        /// <p>The customer provided service template encryption key that's used to encrypt data.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The customer provided service template encryption key that's used to encrypt data.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template. Otherwise, a service
        /// pipeline <i>isn't</i> included in the service template.</p>
        pub fn pipeline_provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.pipeline_provisioning = Some(input);
            self
        }
        /// <p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template. Otherwise, a service
        /// pipeline <i>isn't</i> included in the service template.</p>
        pub fn set_pipeline_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.pipeline_provisioning = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceTemplate`](crate::model::ServiceTemplate)
        pub fn build(self) -> crate::model::ServiceTemplate {
            crate::model::ServiceTemplate {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                display_name: self.display_name,
                description: self.description,
                recommended_version: self.recommended_version,
                encryption_key: self.encryption_key,
                pipeline_provisioning: self.pipeline_provisioning,
            }
        }
    }
}
impl ServiceTemplate {
    /// Creates a new builder-style object to manufacture [`ServiceTemplate`](crate::model::ServiceTemplate)
    pub fn builder() -> crate::model::service_template::Builder {
        crate::model::service_template::Builder::default()
    }
}

/// <p>A summary of the service detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSummary {
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The time when the service was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the service was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the service.</p>
    pub status: std::option::Option<crate::model::ServiceStatus>,
    /// <p>A service status message.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl ServiceSummary {
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the service.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the service template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The time when the service was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the service was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The status of the service.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ServiceStatus> {
        self.status.as_ref()
    }
    /// <p>A service status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
}
impl std::fmt::Debug for ServiceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSummary");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("status", &self.status);
        formatter.field("status_message", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServiceSummary`](crate::model::ServiceSummary)
pub mod service_summary {
    /// A builder for [`ServiceSummary`](crate::model::ServiceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ServiceStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The time when the service was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the service was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the service was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the service was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The status of the service.</p>
        pub fn status(mut self, input: crate::model::ServiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ServiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A service status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A service status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSummary`](crate::model::ServiceSummary)
        pub fn build(self) -> crate::model::ServiceSummary {
            crate::model::ServiceSummary {
                name: self.name,
                description: self.description,
                arn: self.arn,
                template_name: self.template_name,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl ServiceSummary {
    /// Creates a new builder-style object to manufacture [`ServiceSummary`](crate::model::ServiceSummary)
    pub fn builder() -> crate::model::service_summary::Builder {
        crate::model::service_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailedCleanupComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailedCleanupFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailedCleanupInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateCompleteCleanupFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailedCleanupComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailedCleanupFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailedCleanupInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ServiceStatus::Active,
            "CREATE_FAILED" => ServiceStatus::CreateFailed,
            "CREATE_FAILED_CLEANUP_COMPLETE" => ServiceStatus::CreateFailedCleanupComplete,
            "CREATE_FAILED_CLEANUP_FAILED" => ServiceStatus::CreateFailedCleanupFailed,
            "CREATE_FAILED_CLEANUP_IN_PROGRESS" => ServiceStatus::CreateFailedCleanupInProgress,
            "CREATE_IN_PROGRESS" => ServiceStatus::CreateInProgress,
            "DELETE_FAILED" => ServiceStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => ServiceStatus::DeleteInProgress,
            "UPDATE_COMPLETE_CLEANUP_FAILED" => ServiceStatus::UpdateCompleteCleanupFailed,
            "UPDATE_FAILED" => ServiceStatus::UpdateFailed,
            "UPDATE_FAILED_CLEANUP_COMPLETE" => ServiceStatus::UpdateFailedCleanupComplete,
            "UPDATE_FAILED_CLEANUP_FAILED" => ServiceStatus::UpdateFailedCleanupFailed,
            "UPDATE_FAILED_CLEANUP_IN_PROGRESS" => ServiceStatus::UpdateFailedCleanupInProgress,
            "UPDATE_IN_PROGRESS" => ServiceStatus::UpdateInProgress,
            other => ServiceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceStatus::from(s))
    }
}
impl ServiceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceStatus::Active => "ACTIVE",
            ServiceStatus::CreateFailed => "CREATE_FAILED",
            ServiceStatus::CreateFailedCleanupComplete => "CREATE_FAILED_CLEANUP_COMPLETE",
            ServiceStatus::CreateFailedCleanupFailed => "CREATE_FAILED_CLEANUP_FAILED",
            ServiceStatus::CreateFailedCleanupInProgress => "CREATE_FAILED_CLEANUP_IN_PROGRESS",
            ServiceStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            ServiceStatus::DeleteFailed => "DELETE_FAILED",
            ServiceStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            ServiceStatus::UpdateCompleteCleanupFailed => "UPDATE_COMPLETE_CLEANUP_FAILED",
            ServiceStatus::UpdateFailed => "UPDATE_FAILED",
            ServiceStatus::UpdateFailedCleanupComplete => "UPDATE_FAILED_CLEANUP_COMPLETE",
            ServiceStatus::UpdateFailedCleanupFailed => "UPDATE_FAILED_CLEANUP_FAILED",
            ServiceStatus::UpdateFailedCleanupInProgress => "UPDATE_FAILED_CLEANUP_IN_PROGRESS",
            ServiceStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            ServiceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATE_FAILED_CLEANUP_COMPLETE",
            "CREATE_FAILED_CLEANUP_FAILED",
            "CREATE_FAILED_CLEANUP_IN_PROGRESS",
            "CREATE_IN_PROGRESS",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "UPDATE_COMPLETE_CLEANUP_FAILED",
            "UPDATE_FAILED",
            "UPDATE_FAILED_CLEANUP_COMPLETE",
            "UPDATE_FAILED_CLEANUP_FAILED",
            "UPDATE_FAILED_CLEANUP_IN_PROGRESS",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ServiceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The service detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// <p>The name of the service.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of a service.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The time when the service was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the service was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the service.</p>
    pub status: std::option::Option<crate::model::ServiceStatus>,
    /// <p>A service status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The formatted specification that defines the service.</p>
    pub spec: std::option::Option<std::string::String>,
    /// <p>The service pipeline detail data.</p>
    pub pipeline: std::option::Option<crate::model::ServicePipeline>,
    /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up a repository connection</a> in the <i>Proton
    /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
    /// with Proton</a> in the <i>Proton User Guide</i>.</p>
    pub repository_connection_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the source code repository.</p>
    pub repository_id: std::option::Option<std::string::String>,
    /// <p>The name of the code repository branch that holds the code that's deployed in Proton.</p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl Service {
    /// <p>The name of the service.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of a service.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the service template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The time when the service was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the service was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The status of the service.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ServiceStatus> {
        self.status.as_ref()
    }
    /// <p>A service status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The formatted specification that defines the service.</p>
    pub fn spec(&self) -> std::option::Option<&str> {
        self.spec.as_deref()
    }
    /// <p>The service pipeline detail data.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::ServicePipeline> {
        self.pipeline.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up a repository connection</a> in the <i>Proton
    /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
    /// with Proton</a> in the <i>Proton User Guide</i>.</p>
    pub fn repository_connection_arn(&self) -> std::option::Option<&str> {
        self.repository_connection_arn.as_deref()
    }
    /// <p>The ID of the source code repository.</p>
    pub fn repository_id(&self) -> std::option::Option<&str> {
        self.repository_id.as_deref()
    }
    /// <p>The name of the code repository branch that holds the code that's deployed in Proton.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("status", &self.status);
        formatter.field("status_message", &"*** Sensitive Data Redacted ***");
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.field("pipeline", &self.pipeline);
        formatter.field("repository_connection_arn", &self.repository_connection_arn);
        formatter.field("repository_id", &self.repository_id);
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ServiceStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
        pub(crate) pipeline: std::option::Option<crate::model::ServicePipeline>,
        pub(crate) repository_connection_arn: std::option::Option<std::string::String>,
        pub(crate) repository_id: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of a service.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of a service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The time when the service was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the service was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the service was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the service was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The status of the service.</p>
        pub fn status(mut self, input: crate::model::ServiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ServiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A service status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A service status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The formatted specification that defines the service.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>The formatted specification that defines the service.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// <p>The service pipeline detail data.</p>
        pub fn pipeline(mut self, input: crate::model::ServicePipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>The service pipeline detail data.</p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::ServicePipeline>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up a repository connection</a> in the <i>Proton
        /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
        /// with Proton</a> in the <i>Proton User Guide</i>.</p>
        pub fn repository_connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up a repository connection</a> in the <i>Proton
        /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
        /// with Proton</a> in the <i>Proton User Guide</i>.</p>
        pub fn set_repository_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_connection_arn = input;
            self
        }
        /// <p>The ID of the source code repository.</p>
        pub fn repository_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_id = Some(input.into());
            self
        }
        /// <p>The ID of the source code repository.</p>
        pub fn set_repository_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_id = input;
            self
        }
        /// <p>The name of the code repository branch that holds the code that's deployed in Proton.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the code repository branch that holds the code that's deployed in Proton.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                name: self.name,
                description: self.description,
                arn: self.arn,
                template_name: self.template_name,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                status: self.status,
                status_message: self.status_message,
                spec: self.spec,
                pipeline: self.pipeline,
                repository_connection_arn: self.repository_connection_arn,
                repository_id: self.repository_id,
                branch_name: self.branch_name,
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

/// <p>The service pipeline detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServicePipeline {
    /// <p>The Amazon Resource Name (ARN) of the service pipeline.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the service pipeline was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when a deployment of the service pipeline was last attempted.</p>
    pub last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the service pipeline was last deployed successfully.</p>
    pub last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the service template that was used to create the service pipeline.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The major version of the service template that was used to create the service pipeline.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of the service template that was used to create the service pipeline.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>The deployment status of the service pipeline.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>A service pipeline deployment status message.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The service spec that was used to create the service pipeline.</p>
    pub spec: std::option::Option<std::string::String>,
}
impl ServicePipeline {
    /// <p>The Amazon Resource Name (ARN) of the service pipeline.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the service pipeline was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when a deployment of the service pipeline was last attempted.</p>
    pub fn last_deployment_attempted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_attempted_at.as_ref()
    }
    /// <p>The time when the service pipeline was last deployed successfully.</p>
    pub fn last_deployment_succeeded_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_succeeded_at.as_ref()
    }
    /// <p>The name of the service template that was used to create the service pipeline.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The major version of the service template that was used to create the service pipeline.</p>
    pub fn template_major_version(&self) -> std::option::Option<&str> {
        self.template_major_version.as_deref()
    }
    /// <p>The minor version of the service template that was used to create the service pipeline.</p>
    pub fn template_minor_version(&self) -> std::option::Option<&str> {
        self.template_minor_version.as_deref()
    }
    /// <p>The deployment status of the service pipeline.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>A service pipeline deployment status message.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The service spec that was used to create the service pipeline.</p>
    pub fn spec(&self) -> std::option::Option<&str> {
        self.spec.as_deref()
    }
}
impl std::fmt::Debug for ServicePipeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServicePipeline");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field(
            "last_deployment_attempted_at",
            &self.last_deployment_attempted_at,
        );
        formatter.field(
            "last_deployment_succeeded_at",
            &self.last_deployment_succeeded_at,
        );
        formatter.field("template_name", &self.template_name);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field(
            "deployment_status_message",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServicePipeline`](crate::model::ServicePipeline)
pub mod service_pipeline {
    /// A builder for [`ServicePipeline`](crate::model::ServicePipeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the service pipeline.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service pipeline.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the service pipeline was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the service pipeline was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when a deployment of the service pipeline was last attempted.</p>
        pub fn last_deployment_attempted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_attempted_at = Some(input);
            self
        }
        /// <p>The time when a deployment of the service pipeline was last attempted.</p>
        pub fn set_last_deployment_attempted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_attempted_at = input;
            self
        }
        /// <p>The time when the service pipeline was last deployed successfully.</p>
        pub fn last_deployment_succeeded_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_succeeded_at = Some(input);
            self
        }
        /// <p>The time when the service pipeline was last deployed successfully.</p>
        pub fn set_last_deployment_succeeded_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_succeeded_at = input;
            self
        }
        /// <p>The name of the service template that was used to create the service pipeline.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template that was used to create the service pipeline.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The major version of the service template that was used to create the service pipeline.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The major version of the service template that was used to create the service pipeline.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The minor version of the service template that was used to create the service pipeline.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of the service template that was used to create the service pipeline.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>The deployment status of the service pipeline.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The deployment status of the service pipeline.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>A service pipeline deployment status message.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>A service pipeline deployment status message.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The service spec that was used to create the service pipeline.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>The service spec that was used to create the service pipeline.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// Consumes the builder and constructs a [`ServicePipeline`](crate::model::ServicePipeline)
        pub fn build(self) -> crate::model::ServicePipeline {
            crate::model::ServicePipeline {
                arn: self.arn,
                created_at: self.created_at,
                last_deployment_attempted_at: self.last_deployment_attempted_at,
                last_deployment_succeeded_at: self.last_deployment_succeeded_at,
                template_name: self.template_name,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                spec: self.spec,
            }
        }
    }
}
impl ServicePipeline {
    /// Creates a new builder-style object to manufacture [`ServicePipeline`](crate::model::ServicePipeline)
    pub fn builder() -> crate::model::service_pipeline::Builder {
        crate::model::service_pipeline::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    DeleteComplete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => DeploymentStatus::Cancelled,
            "CANCELLING" => DeploymentStatus::Cancelling,
            "DELETE_COMPLETE" => DeploymentStatus::DeleteComplete,
            "DELETE_FAILED" => DeploymentStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => DeploymentStatus::DeleteInProgress,
            "FAILED" => DeploymentStatus::Failed,
            "IN_PROGRESS" => DeploymentStatus::InProgress,
            "SUCCEEDED" => DeploymentStatus::Succeeded,
            other => DeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentStatus::from(s))
    }
}
impl DeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentStatus::Cancelled => "CANCELLED",
            DeploymentStatus::Cancelling => "CANCELLING",
            DeploymentStatus::DeleteComplete => "DELETE_COMPLETE",
            DeploymentStatus::DeleteFailed => "DELETE_FAILED",
            DeploymentStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            DeploymentStatus::Failed => "FAILED",
            DeploymentStatus::InProgress => "IN_PROGRESS",
            DeploymentStatus::Succeeded => "SUCCEEDED",
            DeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "CANCELLING",
            "DELETE_COMPLETE",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "FAILED",
            "IN_PROGRESS",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for DeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentUpdateType {
    #[allow(missing_docs)] // documentation missing in model
    CurrentVersion,
    #[allow(missing_docs)] // documentation missing in model
    MajorVersion,
    #[allow(missing_docs)] // documentation missing in model
    MinorVersion,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentUpdateType {
    fn from(s: &str) -> Self {
        match s {
            "CURRENT_VERSION" => DeploymentUpdateType::CurrentVersion,
            "MAJOR_VERSION" => DeploymentUpdateType::MajorVersion,
            "MINOR_VERSION" => DeploymentUpdateType::MinorVersion,
            "NONE" => DeploymentUpdateType::None,
            other => DeploymentUpdateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentUpdateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentUpdateType::from(s))
    }
}
impl DeploymentUpdateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentUpdateType::CurrentVersion => "CURRENT_VERSION",
            DeploymentUpdateType::MajorVersion => "MAJOR_VERSION",
            DeploymentUpdateType::MinorVersion => "MINOR_VERSION",
            DeploymentUpdateType::None => "NONE",
            DeploymentUpdateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURRENT_VERSION", "MAJOR_VERSION", "MINOR_VERSION", "NONE"]
    }
}
impl AsRef<str> for DeploymentUpdateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Detail data for a provisioned resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedResource {
    /// <p>The provisioned resource name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The provisioned resource identifier.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The resource provisioning engine.</p>
    /// <important>
    /// <p>Provisioning by pull request is currently in feature preview and is
    /// only usable with Terraform based Proton Templates. To learn more about
    /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
    /// Previews.</p>
    /// </important>
    pub provisioning_engine: std::option::Option<crate::model::ProvisionedResourceEngine>,
}
impl ProvisionedResource {
    /// <p>The provisioned resource name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The provisioned resource identifier.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The resource provisioning engine.</p>
    /// <important>
    /// <p>Provisioning by pull request is currently in feature preview and is
    /// only usable with Terraform based Proton Templates. To learn more about
    /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
    /// Previews.</p>
    /// </important>
    pub fn provisioning_engine(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedResourceEngine> {
        self.provisioning_engine.as_ref()
    }
}
impl std::fmt::Debug for ProvisionedResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedResource");
        formatter.field("name", &self.name);
        formatter.field("identifier", &self.identifier);
        formatter.field("provisioning_engine", &self.provisioning_engine);
        formatter.finish()
    }
}
/// See [`ProvisionedResource`](crate::model::ProvisionedResource)
pub mod provisioned_resource {
    /// A builder for [`ProvisionedResource`](crate::model::ProvisionedResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) provisioning_engine:
            std::option::Option<crate::model::ProvisionedResourceEngine>,
    }
    impl Builder {
        /// <p>The provisioned resource name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The provisioned resource name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The provisioned resource identifier.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The provisioned resource identifier.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The resource provisioning engine.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn provisioning_engine(
            mut self,
            input: crate::model::ProvisionedResourceEngine,
        ) -> Self {
            self.provisioning_engine = Some(input);
            self
        }
        /// <p>The resource provisioning engine.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn set_provisioning_engine(
            mut self,
            input: std::option::Option<crate::model::ProvisionedResourceEngine>,
        ) -> Self {
            self.provisioning_engine = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedResource`](crate::model::ProvisionedResource)
        pub fn build(self) -> crate::model::ProvisionedResource {
            crate::model::ProvisionedResource {
                name: self.name,
                identifier: self.identifier,
                provisioning_engine: self.provisioning_engine,
            }
        }
    }
}
impl ProvisionedResource {
    /// Creates a new builder-style object to manufacture [`ProvisionedResource`](crate::model::ProvisionedResource)
    pub fn builder() -> crate::model::provisioned_resource::Builder {
        crate::model::provisioned_resource::Builder::default()
    }
}

/// List of provisioning engines
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProvisionedResourceEngine {
    #[allow(missing_docs)] // documentation missing in model
    Cloudformation,
    #[allow(missing_docs)] // documentation missing in model
    Terraform,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProvisionedResourceEngine {
    fn from(s: &str) -> Self {
        match s {
            "CLOUDFORMATION" => ProvisionedResourceEngine::Cloudformation,
            "TERRAFORM" => ProvisionedResourceEngine::Terraform,
            other => ProvisionedResourceEngine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProvisionedResourceEngine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProvisionedResourceEngine::from(s))
    }
}
impl ProvisionedResourceEngine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProvisionedResourceEngine::Cloudformation => "CLOUDFORMATION",
            ProvisionedResourceEngine::Terraform => "TERRAFORM",
            ProvisionedResourceEngine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUDFORMATION", "TERRAFORM"]
    }
}
impl AsRef<str> for ProvisionedResourceEngine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An infrastructure as code defined resource output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Output {
    /// <p>The output key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The output value.</p>
    pub value_string: std::option::Option<std::string::String>,
}
impl Output {
    /// <p>The output key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The output value.</p>
    pub fn value_string(&self) -> std::option::Option<&str> {
        self.value_string.as_deref()
    }
}
impl std::fmt::Debug for Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Output");
        formatter.field("key", &self.key);
        formatter.field("value_string", &self.value_string);
        formatter.finish()
    }
}
/// See [`Output`](crate::model::Output)
pub mod output {
    /// A builder for [`Output`](crate::model::Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The output key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The output key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The output value.</p>
        pub fn value_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.value_string = Some(input.into());
            self
        }
        /// <p>The output value.</p>
        pub fn set_value_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value_string = input;
            self
        }
        /// Consumes the builder and constructs a [`Output`](crate::model::Output)
        pub fn build(self) -> crate::model::Output {
            crate::model::Output {
                key: self.key,
                value_string: self.value_string,
            }
        }
    }
}
impl Output {
    /// Creates a new builder-style object to manufacture [`Output`](crate::model::Output)
    pub fn builder() -> crate::model::output::Builder {
        crate::model::output::Builder::default()
    }
}

/// <p>A summary of the service instance detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceInstanceSummary {
    /// <p>The name of the service instance.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the service instance was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when a deployment of the service was last attempted.</p>
    pub last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the service was last deployed successfully.</p>
    pub last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the service that the service instance belongs to.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The name of the environment that the service instance was deployed into.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the service template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The service instance template major version.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The service instance template minor version.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>The service instance deployment status.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>A service instance deployment status message.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
}
impl ServiceInstanceSummary {
    /// <p>The name of the service instance.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the service instance was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when a deployment of the service was last attempted.</p>
    pub fn last_deployment_attempted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_attempted_at.as_ref()
    }
    /// <p>The time when the service was last deployed successfully.</p>
    pub fn last_deployment_succeeded_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_succeeded_at.as_ref()
    }
    /// <p>The name of the service that the service instance belongs to.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The name of the environment that the service instance was deployed into.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The name of the service template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The service instance template major version.</p>
    pub fn template_major_version(&self) -> std::option::Option<&str> {
        self.template_major_version.as_deref()
    }
    /// <p>The service instance template minor version.</p>
    pub fn template_minor_version(&self) -> std::option::Option<&str> {
        self.template_minor_version.as_deref()
    }
    /// <p>The service instance deployment status.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>A service instance deployment status message.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
}
impl std::fmt::Debug for ServiceInstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceInstanceSummary");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field(
            "last_deployment_attempted_at",
            &self.last_deployment_attempted_at,
        );
        formatter.field(
            "last_deployment_succeeded_at",
            &self.last_deployment_succeeded_at,
        );
        formatter.field("service_name", &self.service_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field(
            "deployment_status_message",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.finish()
    }
}
/// See [`ServiceInstanceSummary`](crate::model::ServiceInstanceSummary)
pub mod service_instance_summary {
    /// A builder for [`ServiceInstanceSummary`](crate::model::ServiceInstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the service instance was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the service instance was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when a deployment of the service was last attempted.</p>
        pub fn last_deployment_attempted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_attempted_at = Some(input);
            self
        }
        /// <p>The time when a deployment of the service was last attempted.</p>
        pub fn set_last_deployment_attempted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_attempted_at = input;
            self
        }
        /// <p>The time when the service was last deployed successfully.</p>
        pub fn last_deployment_succeeded_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_succeeded_at = Some(input);
            self
        }
        /// <p>The time when the service was last deployed successfully.</p>
        pub fn set_last_deployment_succeeded_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_succeeded_at = input;
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The name of the environment that the service instance was deployed into.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment that the service instance was deployed into.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The service instance template major version.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The service instance template major version.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The service instance template minor version.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The service instance template minor version.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>The service instance deployment status.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The service instance deployment status.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>A service instance deployment status message.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>A service instance deployment status message.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceInstanceSummary`](crate::model::ServiceInstanceSummary)
        pub fn build(self) -> crate::model::ServiceInstanceSummary {
            crate::model::ServiceInstanceSummary {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                last_deployment_attempted_at: self.last_deployment_attempted_at,
                last_deployment_succeeded_at: self.last_deployment_succeeded_at,
                service_name: self.service_name,
                environment_name: self.environment_name,
                template_name: self.template_name,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
            }
        }
    }
}
impl ServiceInstanceSummary {
    /// Creates a new builder-style object to manufacture [`ServiceInstanceSummary`](crate::model::ServiceInstanceSummary)
    pub fn builder() -> crate::model::service_instance_summary::Builder {
        crate::model::service_instance_summary::Builder::default()
    }
}

/// <p>The service instance detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceInstance {
    /// <p>The name of the service instance.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the service instance was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when a deployment of the service instance was last attempted.</p>
    pub last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the service instance was last deployed successfully.</p>
    pub last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the service that the service instance belongs to.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The name of the environment that the service instance was deployed into.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The name of the service template that was used to create the service instance.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The major version of the service template that was used to create the service instance.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of the service template that was used to create the service instance.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>The service instance deployment status.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>A service instance deployment status message.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The service spec that was used to create the service instance.</p>
    pub spec: std::option::Option<std::string::String>,
}
impl ServiceInstance {
    /// <p>The name of the service instance.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the service instance was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when a deployment of the service instance was last attempted.</p>
    pub fn last_deployment_attempted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_attempted_at.as_ref()
    }
    /// <p>The time when the service instance was last deployed successfully.</p>
    pub fn last_deployment_succeeded_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_succeeded_at.as_ref()
    }
    /// <p>The name of the service that the service instance belongs to.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The name of the environment that the service instance was deployed into.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The name of the service template that was used to create the service instance.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The major version of the service template that was used to create the service instance.</p>
    pub fn template_major_version(&self) -> std::option::Option<&str> {
        self.template_major_version.as_deref()
    }
    /// <p>The minor version of the service template that was used to create the service instance.</p>
    pub fn template_minor_version(&self) -> std::option::Option<&str> {
        self.template_minor_version.as_deref()
    }
    /// <p>The service instance deployment status.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>A service instance deployment status message.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The service spec that was used to create the service instance.</p>
    pub fn spec(&self) -> std::option::Option<&str> {
        self.spec.as_deref()
    }
}
impl std::fmt::Debug for ServiceInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceInstance");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field(
            "last_deployment_attempted_at",
            &self.last_deployment_attempted_at,
        );
        formatter.field(
            "last_deployment_succeeded_at",
            &self.last_deployment_succeeded_at,
        );
        formatter.field("service_name", &self.service_name);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field(
            "deployment_status_message",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServiceInstance`](crate::model::ServiceInstance)
pub mod service_instance {
    /// A builder for [`ServiceInstance`](crate::model::ServiceInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the service instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the service instance was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the service instance was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when a deployment of the service instance was last attempted.</p>
        pub fn last_deployment_attempted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_attempted_at = Some(input);
            self
        }
        /// <p>The time when a deployment of the service instance was last attempted.</p>
        pub fn set_last_deployment_attempted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_attempted_at = input;
            self
        }
        /// <p>The time when the service instance was last deployed successfully.</p>
        pub fn last_deployment_succeeded_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_succeeded_at = Some(input);
            self
        }
        /// <p>The time when the service instance was last deployed successfully.</p>
        pub fn set_last_deployment_succeeded_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_succeeded_at = input;
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The name of the environment that the service instance was deployed into.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment that the service instance was deployed into.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The name of the service template that was used to create the service instance.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the service template that was used to create the service instance.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The major version of the service template that was used to create the service instance.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The major version of the service template that was used to create the service instance.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The minor version of the service template that was used to create the service instance.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of the service template that was used to create the service instance.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>The service instance deployment status.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The service instance deployment status.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>A service instance deployment status message.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>A service instance deployment status message.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The service spec that was used to create the service instance.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>The service spec that was used to create the service instance.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceInstance`](crate::model::ServiceInstance)
        pub fn build(self) -> crate::model::ServiceInstance {
            crate::model::ServiceInstance {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                last_deployment_attempted_at: self.last_deployment_attempted_at,
                last_deployment_succeeded_at: self.last_deployment_succeeded_at,
                service_name: self.service_name,
                environment_name: self.environment_name,
                template_name: self.template_name,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                spec: self.spec,
            }
        }
    }
}
impl ServiceInstance {
    /// Creates a new builder-style object to manufacture [`ServiceInstance`](crate::model::ServiceInstance)
    pub fn builder() -> crate::model::service_instance::Builder {
        crate::model::service_instance::Builder::default()
    }
}

/// <p>A summary of detail data for a registered repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositorySummary {
    /// <p>The Amazon Resource Name (ARN) for a repository.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The repository provider.</p>
    pub provider: std::option::Option<crate::model::RepositoryProvider>,
    /// <p>The repository name.</p>
    pub name: std::option::Option<std::string::String>,
}
impl RepositorySummary {
    /// <p>The Amazon Resource Name (ARN) for a repository.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The repository provider.</p>
    pub fn provider(&self) -> std::option::Option<&crate::model::RepositoryProvider> {
        self.provider.as_ref()
    }
    /// <p>The repository name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for RepositorySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositorySummary");
        formatter.field("arn", &self.arn);
        formatter.field("provider", &self.provider);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RepositorySummary`](crate::model::RepositorySummary)
pub mod repository_summary {
    /// A builder for [`RepositorySummary`](crate::model::RepositorySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<crate::model::RepositoryProvider>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for a repository.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a repository.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The repository provider.</p>
        pub fn provider(mut self, input: crate::model::RepositoryProvider) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// <p>The repository name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The repository name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositorySummary`](crate::model::RepositorySummary)
        pub fn build(self) -> crate::model::RepositorySummary {
            crate::model::RepositorySummary {
                arn: self.arn,
                provider: self.provider,
                name: self.name,
            }
        }
    }
}
impl RepositorySummary {
    /// Creates a new builder-style object to manufacture [`RepositorySummary`](crate::model::RepositorySummary)
    pub fn builder() -> crate::model::repository_summary::Builder {
        crate::model::repository_summary::Builder::default()
    }
}

/// <p>Detail date for a repository that has been registered with Proton.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Repository {
    /// <p>The repository Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The repository provider.</p>
    pub provider: std::option::Option<crate::model::RepositoryProvider>,
    /// <p>The repository name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The repository Amazon Web Services CodeStar connection that connects Proton to your repository.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>Your customer Amazon Web Services KMS encryption key.</p>
    pub encryption_key: std::option::Option<std::string::String>,
}
impl Repository {
    /// <p>The repository Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The repository provider.</p>
    pub fn provider(&self) -> std::option::Option<&crate::model::RepositoryProvider> {
        self.provider.as_ref()
    }
    /// <p>The repository name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The repository Amazon Web Services CodeStar connection that connects Proton to your repository.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>Your customer Amazon Web Services KMS encryption key.</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
}
impl std::fmt::Debug for Repository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Repository");
        formatter.field("arn", &self.arn);
        formatter.field("provider", &self.provider);
        formatter.field("name", &self.name);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.finish()
    }
}
/// See [`Repository`](crate::model::Repository)
pub mod repository {
    /// A builder for [`Repository`](crate::model::Repository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<crate::model::RepositoryProvider>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The repository Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The repository Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The repository provider.</p>
        pub fn provider(mut self, input: crate::model::RepositoryProvider) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// <p>The repository name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The repository name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The repository Amazon Web Services CodeStar connection that connects Proton to your repository.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The repository Amazon Web Services CodeStar connection that connects Proton to your repository.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>Your customer Amazon Web Services KMS encryption key.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>Your customer Amazon Web Services KMS encryption key.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Consumes the builder and constructs a [`Repository`](crate::model::Repository)
        pub fn build(self) -> crate::model::Repository {
            crate::model::Repository {
                arn: self.arn,
                provider: self.provider,
                name: self.name,
                connection_arn: self.connection_arn,
                encryption_key: self.encryption_key,
            }
        }
    }
}
impl Repository {
    /// Creates a new builder-style object to manufacture [`Repository`](crate::model::Repository)
    pub fn builder() -> crate::model::repository::Builder {
        crate::model::repository::Builder::default()
    }
}

/// <p>A summary of the version of an environment template detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentTemplateVersionSummary {
    /// <p>The name of the version of an environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The latest major version that's associated with the version of an environment template.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>The version of an environment template.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>The recommended minor version of the environment template.</p>
    pub recommended_minor_version: std::option::Option<std::string::String>,
    /// <p>The status of the version of an environment template.</p>
    pub status: std::option::Option<crate::model::TemplateVersionStatus>,
    /// <p>The status message of the version of an environment template.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A description of the version of an environment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the version of an environment template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the version of an environment template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl EnvironmentTemplateVersionSummary {
    /// <p>The name of the version of an environment template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The latest major version that's associated with the version of an environment template.</p>
    pub fn major_version(&self) -> std::option::Option<&str> {
        self.major_version.as_deref()
    }
    /// <p>The version of an environment template.</p>
    pub fn minor_version(&self) -> std::option::Option<&str> {
        self.minor_version.as_deref()
    }
    /// <p>The recommended minor version of the environment template.</p>
    pub fn recommended_minor_version(&self) -> std::option::Option<&str> {
        self.recommended_minor_version.as_deref()
    }
    /// <p>The status of the version of an environment template.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TemplateVersionStatus> {
        self.status.as_ref()
    }
    /// <p>The status message of the version of an environment template.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>A description of the version of an environment template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the version of an environment template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the version of an environment template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentTemplateVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentTemplateVersionSummary");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("recommended_minor_version", &self.recommended_minor_version);
        formatter.field("status", &self.status);
        formatter.field("status_message", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.finish()
    }
}
/// See [`EnvironmentTemplateVersionSummary`](crate::model::EnvironmentTemplateVersionSummary)
pub mod environment_template_version_summary {
    /// A builder for [`EnvironmentTemplateVersionSummary`](crate::model::EnvironmentTemplateVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) recommended_minor_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TemplateVersionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the version of an environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the version of an environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The latest major version that's associated with the version of an environment template.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The latest major version that's associated with the version of an environment template.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>The version of an environment template.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>The version of an environment template.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>The recommended minor version of the environment template.</p>
        pub fn recommended_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_minor_version = Some(input.into());
            self
        }
        /// <p>The recommended minor version of the environment template.</p>
        pub fn set_recommended_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_minor_version = input;
            self
        }
        /// <p>The status of the version of an environment template.</p>
        pub fn status(mut self, input: crate::model::TemplateVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the version of an environment template.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message of the version of an environment template.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message of the version of an environment template.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A description of the version of an environment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the version of an environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the version of an environment template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the version of an environment template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the version of an environment template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the version of an environment template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentTemplateVersionSummary`](crate::model::EnvironmentTemplateVersionSummary)
        pub fn build(self) -> crate::model::EnvironmentTemplateVersionSummary {
            crate::model::EnvironmentTemplateVersionSummary {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
                recommended_minor_version: self.recommended_minor_version,
                status: self.status,
                status_message: self.status_message,
                description: self.description,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
            }
        }
    }
}
impl EnvironmentTemplateVersionSummary {
    /// Creates a new builder-style object to manufacture [`EnvironmentTemplateVersionSummary`](crate::model::EnvironmentTemplateVersionSummary)
    pub fn builder() -> crate::model::environment_template_version_summary::Builder {
        crate::model::environment_template_version_summary::Builder::default()
    }
}

/// <p>The environment template version data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentTemplateVersion {
    /// <p>The name of the version of an environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The latest major version that's associated with the version of an environment template.</p>
    pub major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of an environment template.</p>
    pub minor_version: std::option::Option<std::string::String>,
    /// <p>The recommended minor version of the environment template.</p>
    pub recommended_minor_version: std::option::Option<std::string::String>,
    /// <p>The status of the version of an environment template.</p>
    pub status: std::option::Option<crate::model::TemplateVersionStatus>,
    /// <p>The status message of the version of an environment template.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A description of the minor version of an environment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the version of an environment template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the version of an environment template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The schema of the version of an environment template.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl EnvironmentTemplateVersion {
    /// <p>The name of the version of an environment template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The latest major version that's associated with the version of an environment template.</p>
    pub fn major_version(&self) -> std::option::Option<&str> {
        self.major_version.as_deref()
    }
    /// <p>The minor version of an environment template.</p>
    pub fn minor_version(&self) -> std::option::Option<&str> {
        self.minor_version.as_deref()
    }
    /// <p>The recommended minor version of the environment template.</p>
    pub fn recommended_minor_version(&self) -> std::option::Option<&str> {
        self.recommended_minor_version.as_deref()
    }
    /// <p>The status of the version of an environment template.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TemplateVersionStatus> {
        self.status.as_ref()
    }
    /// <p>The status message of the version of an environment template.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>A description of the minor version of an environment template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the version of an environment template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the version of an environment template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The schema of the version of an environment template.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for EnvironmentTemplateVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentTemplateVersion");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.field("minor_version", &self.minor_version);
        formatter.field("recommended_minor_version", &self.recommended_minor_version);
        formatter.field("status", &self.status);
        formatter.field("status_message", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("schema", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`EnvironmentTemplateVersion`](crate::model::EnvironmentTemplateVersion)
pub mod environment_template_version {
    /// A builder for [`EnvironmentTemplateVersion`](crate::model::EnvironmentTemplateVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
        pub(crate) minor_version: std::option::Option<std::string::String>,
        pub(crate) recommended_minor_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TemplateVersionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the version of an environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the version of an environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The latest major version that's associated with the version of an environment template.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>The latest major version that's associated with the version of an environment template.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// <p>The minor version of an environment template.</p>
        pub fn minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of an environment template.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minor_version = input;
            self
        }
        /// <p>The recommended minor version of the environment template.</p>
        pub fn recommended_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_minor_version = Some(input.into());
            self
        }
        /// <p>The recommended minor version of the environment template.</p>
        pub fn set_recommended_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_minor_version = input;
            self
        }
        /// <p>The status of the version of an environment template.</p>
        pub fn status(mut self, input: crate::model::TemplateVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the version of an environment template.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message of the version of an environment template.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message of the version of an environment template.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A description of the minor version of an environment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the minor version of an environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the version of an environment template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the version of an environment template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the version of an environment template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the version of an environment template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the version of an environment template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The schema of the version of an environment template.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema of the version of an environment template.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentTemplateVersion`](crate::model::EnvironmentTemplateVersion)
        pub fn build(self) -> crate::model::EnvironmentTemplateVersion {
            crate::model::EnvironmentTemplateVersion {
                template_name: self.template_name,
                major_version: self.major_version,
                minor_version: self.minor_version,
                recommended_minor_version: self.recommended_minor_version,
                status: self.status,
                status_message: self.status_message,
                description: self.description,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                schema: self.schema,
            }
        }
    }
}
impl EnvironmentTemplateVersion {
    /// Creates a new builder-style object to manufacture [`EnvironmentTemplateVersion`](crate::model::EnvironmentTemplateVersion)
    pub fn builder() -> crate::model::environment_template_version::Builder {
        crate::model::environment_template_version::Builder::default()
    }
}

/// <p>The environment template data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentTemplateSummary {
    /// <p>The name of the environment template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the environment template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the environment template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the environment template as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the environment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The recommended version of the environment template.</p>
    pub recommended_version: std::option::Option<std::string::String>,
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub provisioning: std::option::Option<crate::model::Provisioning>,
}
impl EnvironmentTemplateSummary {
    /// <p>The name of the environment template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the environment template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the environment template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The name of the environment template as displayed in the developer interface.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>A description of the environment template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The recommended version of the environment template.</p>
    pub fn recommended_version(&self) -> std::option::Option<&str> {
        self.recommended_version.as_deref()
    }
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub fn provisioning(&self) -> std::option::Option<&crate::model::Provisioning> {
        self.provisioning.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentTemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentTemplateSummary");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("recommended_version", &self.recommended_version);
        formatter.field("provisioning", &self.provisioning);
        formatter.finish()
    }
}
/// See [`EnvironmentTemplateSummary`](crate::model::EnvironmentTemplateSummary)
pub mod environment_template_summary {
    /// A builder for [`EnvironmentTemplateSummary`](crate::model::EnvironmentTemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommended_version: std::option::Option<std::string::String>,
        pub(crate) provisioning: std::option::Option<crate::model::Provisioning>,
    }
    impl Builder {
        /// <p>The name of the environment template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the environment template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the environment template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the environment template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the environment template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The name of the environment template as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The recommended version of the environment template.</p>
        pub fn recommended_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_version = Some(input.into());
            self
        }
        /// <p>The recommended version of the environment template.</p>
        pub fn set_recommended_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_version = input;
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.provisioning = Some(input);
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn set_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.provisioning = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentTemplateSummary`](crate::model::EnvironmentTemplateSummary)
        pub fn build(self) -> crate::model::EnvironmentTemplateSummary {
            crate::model::EnvironmentTemplateSummary {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                display_name: self.display_name,
                description: self.description,
                recommended_version: self.recommended_version,
                provisioning: self.provisioning,
            }
        }
    }
}
impl EnvironmentTemplateSummary {
    /// Creates a new builder-style object to manufacture [`EnvironmentTemplateSummary`](crate::model::EnvironmentTemplateSummary)
    pub fn builder() -> crate::model::environment_template_summary::Builder {
        crate::model::environment_template_summary::Builder::default()
    }
}

/// <p>The environment template data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentTemplate {
    /// <p>The name of the environment template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time when the environment template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the environment template was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the environment template as displayed in the developer interface.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of the environment template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the recommended version of the environment template.</p>
    pub recommended_version: std::option::Option<std::string::String>,
    /// <p>The customer provided encryption key for the environment template.</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub provisioning: std::option::Option<crate::model::Provisioning>,
}
impl EnvironmentTemplate {
    /// <p>The name of the environment template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time when the environment template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the environment template was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The name of the environment template as displayed in the developer interface.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>A description of the environment template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the recommended version of the environment template.</p>
    pub fn recommended_version(&self) -> std::option::Option<&str> {
        self.recommended_version.as_deref()
    }
    /// <p>The customer provided encryption key for the environment template.</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub fn provisioning(&self) -> std::option::Option<&crate::model::Provisioning> {
        self.provisioning.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentTemplate");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("display_name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("recommended_version", &self.recommended_version);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("provisioning", &self.provisioning);
        formatter.finish()
    }
}
/// See [`EnvironmentTemplate`](crate::model::EnvironmentTemplate)
pub mod environment_template {
    /// A builder for [`EnvironmentTemplate`](crate::model::EnvironmentTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommended_version: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) provisioning: std::option::Option<crate::model::Provisioning>,
    }
    impl Builder {
        /// <p>The name of the environment template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time when the environment template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the environment template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the environment template was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the environment template was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The name of the environment template as displayed in the developer interface.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the recommended version of the environment template.</p>
        pub fn recommended_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommended_version = Some(input.into());
            self
        }
        /// <p>The ID of the recommended version of the environment template.</p>
        pub fn set_recommended_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_version = input;
            self
        }
        /// <p>The customer provided encryption key for the environment template.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The customer provided encryption key for the environment template.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.provisioning = Some(input);
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn set_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.provisioning = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentTemplate`](crate::model::EnvironmentTemplate)
        pub fn build(self) -> crate::model::EnvironmentTemplate {
            crate::model::EnvironmentTemplate {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                last_modified_at: self.last_modified_at,
                display_name: self.display_name,
                description: self.description,
                recommended_version: self.recommended_version,
                encryption_key: self.encryption_key,
                provisioning: self.provisioning,
            }
        }
    }
}
impl EnvironmentTemplate {
    /// Creates a new builder-style object to manufacture [`EnvironmentTemplate`](crate::model::EnvironmentTemplate)
    pub fn builder() -> crate::model::environment_template::Builder {
        crate::model::environment_template::Builder::default()
    }
}

/// <p>A summary of the environment detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentSummary {
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The time when the environment was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when a deployment of the environment was last attempted.</p>
    pub last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the environment was last deployed successfully.</p>
    pub last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The major version of the environment template.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The minor version of the environment template.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>The environment deployment status.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>An environment deployment status message.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
    pub proton_service_role_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the environment account connection that the environment is associated with.</p>
    pub environment_account_connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
    pub environment_account_id: std::option::Option<std::string::String>,
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub provisioning: std::option::Option<crate::model::Provisioning>,
}
impl EnvironmentSummary {
    /// <p>The name of the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The time when the environment was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when a deployment of the environment was last attempted.</p>
    pub fn last_deployment_attempted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_attempted_at.as_ref()
    }
    /// <p>The time when the environment was last deployed successfully.</p>
    pub fn last_deployment_succeeded_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_succeeded_at.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the environment template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The major version of the environment template.</p>
    pub fn template_major_version(&self) -> std::option::Option<&str> {
        self.template_major_version.as_deref()
    }
    /// <p>The minor version of the environment template.</p>
    pub fn template_minor_version(&self) -> std::option::Option<&str> {
        self.template_minor_version.as_deref()
    }
    /// <p>The environment deployment status.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>An environment deployment status message.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
    pub fn proton_service_role_arn(&self) -> std::option::Option<&str> {
        self.proton_service_role_arn.as_deref()
    }
    /// <p>The ID of the environment account connection that the environment is associated with.</p>
    pub fn environment_account_connection_id(&self) -> std::option::Option<&str> {
        self.environment_account_connection_id.as_deref()
    }
    /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
    pub fn environment_account_id(&self) -> std::option::Option<&str> {
        self.environment_account_id.as_deref()
    }
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub fn provisioning(&self) -> std::option::Option<&crate::model::Provisioning> {
        self.provisioning.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentSummary");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("created_at", &self.created_at);
        formatter.field(
            "last_deployment_attempted_at",
            &self.last_deployment_attempted_at,
        );
        formatter.field(
            "last_deployment_succeeded_at",
            &self.last_deployment_succeeded_at,
        );
        formatter.field("arn", &self.arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field(
            "deployment_status_message",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("proton_service_role_arn", &self.proton_service_role_arn);
        formatter.field(
            "environment_account_connection_id",
            &self.environment_account_connection_id,
        );
        formatter.field("environment_account_id", &self.environment_account_id);
        formatter.field("provisioning", &self.provisioning);
        formatter.finish()
    }
}
/// See [`EnvironmentSummary`](crate::model::EnvironmentSummary)
pub mod environment_summary {
    /// A builder for [`EnvironmentSummary`](crate::model::EnvironmentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) proton_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_account_connection_id: std::option::Option<std::string::String>,
        pub(crate) environment_account_id: std::option::Option<std::string::String>,
        pub(crate) provisioning: std::option::Option<crate::model::Provisioning>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The time when the environment was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the environment was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when a deployment of the environment was last attempted.</p>
        pub fn last_deployment_attempted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_attempted_at = Some(input);
            self
        }
        /// <p>The time when a deployment of the environment was last attempted.</p>
        pub fn set_last_deployment_attempted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_attempted_at = input;
            self
        }
        /// <p>The time when the environment was last deployed successfully.</p>
        pub fn last_deployment_succeeded_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_succeeded_at = Some(input);
            self
        }
        /// <p>The time when the environment was last deployed successfully.</p>
        pub fn set_last_deployment_succeeded_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_succeeded_at = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The major version of the environment template.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The major version of the environment template.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The minor version of the environment template.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The minor version of the environment template.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>The environment deployment status.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The environment deployment status.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>An environment deployment status message.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>An environment deployment status message.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
        pub fn proton_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.proton_service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
        pub fn set_proton_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proton_service_role_arn = input;
            self
        }
        /// <p>The ID of the environment account connection that the environment is associated with.</p>
        pub fn environment_account_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection that the environment is associated with.</p>
        pub fn set_environment_account_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = input;
            self
        }
        /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
        pub fn environment_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
        pub fn set_environment_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_id = input;
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.provisioning = Some(input);
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn set_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.provisioning = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentSummary`](crate::model::EnvironmentSummary)
        pub fn build(self) -> crate::model::EnvironmentSummary {
            crate::model::EnvironmentSummary {
                name: self.name,
                description: self.description,
                created_at: self.created_at,
                last_deployment_attempted_at: self.last_deployment_attempted_at,
                last_deployment_succeeded_at: self.last_deployment_succeeded_at,
                arn: self.arn,
                template_name: self.template_name,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                proton_service_role_arn: self.proton_service_role_arn,
                environment_account_connection_id: self.environment_account_connection_id,
                environment_account_id: self.environment_account_id,
                provisioning: self.provisioning,
            }
        }
    }
}
impl EnvironmentSummary {
    /// Creates a new builder-style object to manufacture [`EnvironmentSummary`](crate::model::EnvironmentSummary)
    pub fn builder() -> crate::model::environment_summary::Builder {
        crate::model::environment_summary::Builder::default()
    }
}

/// <p>A search filter for environment templates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentTemplateFilter {
    /// <p>Include <code>templateName</code> to filter search for a template name.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Include <code>majorVersion</code> to filter search for a major version.</p>
    pub major_version: std::option::Option<std::string::String>,
}
impl EnvironmentTemplateFilter {
    /// <p>Include <code>templateName</code> to filter search for a template name.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Include <code>majorVersion</code> to filter search for a major version.</p>
    pub fn major_version(&self) -> std::option::Option<&str> {
        self.major_version.as_deref()
    }
}
impl std::fmt::Debug for EnvironmentTemplateFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentTemplateFilter");
        formatter.field("template_name", &self.template_name);
        formatter.field("major_version", &self.major_version);
        formatter.finish()
    }
}
/// See [`EnvironmentTemplateFilter`](crate::model::EnvironmentTemplateFilter)
pub mod environment_template_filter {
    /// A builder for [`EnvironmentTemplateFilter`](crate::model::EnvironmentTemplateFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) major_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Include <code>templateName</code> to filter search for a template name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>Include <code>templateName</code> to filter search for a template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Include <code>majorVersion</code> to filter search for a major version.</p>
        pub fn major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_version = Some(input.into());
            self
        }
        /// <p>Include <code>majorVersion</code> to filter search for a major version.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_version = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentTemplateFilter`](crate::model::EnvironmentTemplateFilter)
        pub fn build(self) -> crate::model::EnvironmentTemplateFilter {
            crate::model::EnvironmentTemplateFilter {
                template_name: self.template_name,
                major_version: self.major_version,
            }
        }
    }
}
impl EnvironmentTemplateFilter {
    /// Creates a new builder-style object to manufacture [`EnvironmentTemplateFilter`](crate::model::EnvironmentTemplateFilter)
    pub fn builder() -> crate::model::environment_template_filter::Builder {
        crate::model::environment_template_filter::Builder::default()
    }
}

/// <p>The environment detail data. An Proton environment is a set resources shared across an Proton service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Environment {
    /// <p>The name of the environment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the environment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The time when the environment was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when a deployment of the environment was last attempted.</p>
    pub last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the environment was last deployed successfully.</p>
    pub last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The ID of the major version of the environment template.</p>
    pub template_major_version: std::option::Option<std::string::String>,
    /// <p>The ID of the minor version of the environment template.</p>
    pub template_minor_version: std::option::Option<std::string::String>,
    /// <p>The environment deployment status.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>An environment deployment status message.</p>
    pub deployment_status_message: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
    pub proton_service_role_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the environment account connection that's used to provision infrastructure resources in an environment account.</p>
    pub environment_account_connection_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
    pub environment_account_id: std::option::Option<std::string::String>,
    /// <p>The environment spec.</p>
    pub spec: std::option::Option<std::string::String>,
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub provisioning: std::option::Option<crate::model::Provisioning>,
    /// <p>The repository that you provide with pull request provisioning.</p>
    /// <important>
    /// <p>Provisioning by pull request is currently in feature preview and is
    /// only usable with Terraform based Proton Templates. To learn more about
    /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
    /// Previews.</p>
    /// </important>
    pub provisioning_repository: std::option::Option<crate::model::RepositoryBranch>,
}
impl Environment {
    /// <p>The name of the environment.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the environment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The time when the environment was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when a deployment of the environment was last attempted.</p>
    pub fn last_deployment_attempted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_attempted_at.as_ref()
    }
    /// <p>The time when the environment was last deployed successfully.</p>
    pub fn last_deployment_succeeded_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_succeeded_at.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The ID of the major version of the environment template.</p>
    pub fn template_major_version(&self) -> std::option::Option<&str> {
        self.template_major_version.as_deref()
    }
    /// <p>The ID of the minor version of the environment template.</p>
    pub fn template_minor_version(&self) -> std::option::Option<&str> {
        self.template_minor_version.as_deref()
    }
    /// <p>The environment deployment status.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>An environment deployment status message.</p>
    pub fn deployment_status_message(&self) -> std::option::Option<&str> {
        self.deployment_status_message.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
    pub fn proton_service_role_arn(&self) -> std::option::Option<&str> {
        self.proton_service_role_arn.as_deref()
    }
    /// <p>The ID of the environment account connection that's used to provision infrastructure resources in an environment account.</p>
    pub fn environment_account_connection_id(&self) -> std::option::Option<&str> {
        self.environment_account_connection_id.as_deref()
    }
    /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
    pub fn environment_account_id(&self) -> std::option::Option<&str> {
        self.environment_account_id.as_deref()
    }
    /// <p>The environment spec.</p>
    pub fn spec(&self) -> std::option::Option<&str> {
        self.spec.as_deref()
    }
    /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
    pub fn provisioning(&self) -> std::option::Option<&crate::model::Provisioning> {
        self.provisioning.as_ref()
    }
    /// <p>The repository that you provide with pull request provisioning.</p>
    /// <important>
    /// <p>Provisioning by pull request is currently in feature preview and is
    /// only usable with Terraform based Proton Templates. To learn more about
    /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
    /// Previews.</p>
    /// </important>
    pub fn provisioning_repository(&self) -> std::option::Option<&crate::model::RepositoryBranch> {
        self.provisioning_repository.as_ref()
    }
}
impl std::fmt::Debug for Environment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Environment");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("created_at", &self.created_at);
        formatter.field(
            "last_deployment_attempted_at",
            &self.last_deployment_attempted_at,
        );
        formatter.field(
            "last_deployment_succeeded_at",
            &self.last_deployment_succeeded_at,
        );
        formatter.field("arn", &self.arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("template_major_version", &self.template_major_version);
        formatter.field("template_minor_version", &self.template_minor_version);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field(
            "deployment_status_message",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("proton_service_role_arn", &self.proton_service_role_arn);
        formatter.field(
            "environment_account_connection_id",
            &self.environment_account_connection_id,
        );
        formatter.field("environment_account_id", &self.environment_account_id);
        formatter.field("spec", &"*** Sensitive Data Redacted ***");
        formatter.field("provisioning", &self.provisioning);
        formatter.field("provisioning_repository", &self.provisioning_repository);
        formatter.finish()
    }
}
/// See [`Environment`](crate::model::Environment)
pub mod environment {
    /// A builder for [`Environment`](crate::model::Environment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_attempted_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_succeeded_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_major_version: std::option::Option<std::string::String>,
        pub(crate) template_minor_version: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_status_message: std::option::Option<std::string::String>,
        pub(crate) proton_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_account_connection_id: std::option::Option<std::string::String>,
        pub(crate) environment_account_id: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<std::string::String>,
        pub(crate) provisioning: std::option::Option<crate::model::Provisioning>,
        pub(crate) provisioning_repository: std::option::Option<crate::model::RepositoryBranch>,
    }
    impl Builder {
        /// <p>The name of the environment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the environment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the environment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The time when the environment was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the environment was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when a deployment of the environment was last attempted.</p>
        pub fn last_deployment_attempted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_attempted_at = Some(input);
            self
        }
        /// <p>The time when a deployment of the environment was last attempted.</p>
        pub fn set_last_deployment_attempted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_attempted_at = input;
            self
        }
        /// <p>The time when the environment was last deployed successfully.</p>
        pub fn last_deployment_succeeded_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_succeeded_at = Some(input);
            self
        }
        /// <p>The time when the environment was last deployed successfully.</p>
        pub fn set_last_deployment_succeeded_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_succeeded_at = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The ID of the major version of the environment template.</p>
        pub fn template_major_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_major_version = Some(input.into());
            self
        }
        /// <p>The ID of the major version of the environment template.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_major_version = input;
            self
        }
        /// <p>The ID of the minor version of the environment template.</p>
        pub fn template_minor_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_minor_version = Some(input.into());
            self
        }
        /// <p>The ID of the minor version of the environment template.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_minor_version = input;
            self
        }
        /// <p>The environment deployment status.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The environment deployment status.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>An environment deployment status message.</p>
        pub fn deployment_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status_message = Some(input.into());
            self
        }
        /// <p>An environment deployment status message.</p>
        pub fn set_deployment_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status_message = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
        pub fn proton_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.proton_service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>
        pub fn set_proton_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proton_service_role_arn = input;
            self
        }
        /// <p>The ID of the environment account connection that's used to provision infrastructure resources in an environment account.</p>
        pub fn environment_account_connection_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection that's used to provision infrastructure resources in an environment account.</p>
        pub fn set_environment_account_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_connection_id = input;
            self
        }
        /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
        pub fn environment_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>
        pub fn set_environment_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_id = input;
            self
        }
        /// <p>The environment spec.</p>
        pub fn spec(mut self, input: impl Into<std::string::String>) -> Self {
            self.spec = Some(input.into());
            self
        }
        /// <p>The environment spec.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spec = input;
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn provisioning(mut self, input: crate::model::Provisioning) -> Self {
            self.provisioning = Some(input);
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn set_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.provisioning = input;
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn provisioning_repository(mut self, input: crate::model::RepositoryBranch) -> Self {
            self.provisioning_repository = Some(input);
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn set_provisioning_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryBranch>,
        ) -> Self {
            self.provisioning_repository = input;
            self
        }
        /// Consumes the builder and constructs a [`Environment`](crate::model::Environment)
        pub fn build(self) -> crate::model::Environment {
            crate::model::Environment {
                name: self.name,
                description: self.description,
                created_at: self.created_at,
                last_deployment_attempted_at: self.last_deployment_attempted_at,
                last_deployment_succeeded_at: self.last_deployment_succeeded_at,
                arn: self.arn,
                template_name: self.template_name,
                template_major_version: self.template_major_version,
                template_minor_version: self.template_minor_version,
                deployment_status: self.deployment_status,
                deployment_status_message: self.deployment_status_message,
                proton_service_role_arn: self.proton_service_role_arn,
                environment_account_connection_id: self.environment_account_connection_id,
                environment_account_id: self.environment_account_id,
                spec: self.spec,
                provisioning: self.provisioning,
                provisioning_repository: self.provisioning_repository,
            }
        }
    }
}
impl Environment {
    /// Creates a new builder-style object to manufacture [`Environment`](crate::model::Environment)
    pub fn builder() -> crate::model::environment::Builder {
        crate::model::environment::Builder::default()
    }
}

/// <p>Detail data for a repository branch.</p>
/// <important>
/// <p>Provisioning by pull request is currently in feature preview and is
/// only usable with Terraform based Proton Templates. To learn more about
/// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
/// Previews.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryBranch {
    /// <p>The Amazon Resource Name (ARN) of the repository branch.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The repository provider.</p>
    pub provider: std::option::Option<crate::model::RepositoryProvider>,
    /// <p>The repository name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The repository branch.</p>
    pub branch: std::option::Option<std::string::String>,
}
impl RepositoryBranch {
    /// <p>The Amazon Resource Name (ARN) of the repository branch.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The repository provider.</p>
    pub fn provider(&self) -> std::option::Option<&crate::model::RepositoryProvider> {
        self.provider.as_ref()
    }
    /// <p>The repository name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The repository branch.</p>
    pub fn branch(&self) -> std::option::Option<&str> {
        self.branch.as_deref()
    }
}
impl std::fmt::Debug for RepositoryBranch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryBranch");
        formatter.field("arn", &self.arn);
        formatter.field("provider", &self.provider);
        formatter.field("name", &self.name);
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`RepositoryBranch`](crate::model::RepositoryBranch)
pub mod repository_branch {
    /// A builder for [`RepositoryBranch`](crate::model::RepositoryBranch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<crate::model::RepositoryProvider>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) branch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the repository branch.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository branch.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The repository provider.</p>
        pub fn provider(mut self, input: crate::model::RepositoryProvider) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// <p>The repository name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The repository name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The repository branch.</p>
        pub fn branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch = Some(input.into());
            self
        }
        /// <p>The repository branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryBranch`](crate::model::RepositoryBranch)
        pub fn build(self) -> crate::model::RepositoryBranch {
            crate::model::RepositoryBranch {
                arn: self.arn,
                provider: self.provider,
                name: self.name,
                branch: self.branch,
            }
        }
    }
}
impl RepositoryBranch {
    /// Creates a new builder-style object to manufacture [`RepositoryBranch`](crate::model::RepositoryBranch)
    pub fn builder() -> crate::model::repository_branch::Builder {
        crate::model::repository_branch::Builder::default()
    }
}

/// <p>Detail input data for a repository branch.</p>
/// <important>
/// <p>Provisioning by pull request is currently in feature preview and is
/// only usable with Terraform based Proton Templates. To learn more about
/// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
/// Previews.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryBranchInput {
    /// <p>The repository provider.</p>
    pub provider: std::option::Option<crate::model::RepositoryProvider>,
    /// <p>The repository name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The repository branch.</p>
    pub branch: std::option::Option<std::string::String>,
}
impl RepositoryBranchInput {
    /// <p>The repository provider.</p>
    pub fn provider(&self) -> std::option::Option<&crate::model::RepositoryProvider> {
        self.provider.as_ref()
    }
    /// <p>The repository name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The repository branch.</p>
    pub fn branch(&self) -> std::option::Option<&str> {
        self.branch.as_deref()
    }
}
impl std::fmt::Debug for RepositoryBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryBranchInput");
        formatter.field("provider", &self.provider);
        formatter.field("name", &self.name);
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`RepositoryBranchInput`](crate::model::RepositoryBranchInput)
pub mod repository_branch_input {
    /// A builder for [`RepositoryBranchInput`](crate::model::RepositoryBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider: std::option::Option<crate::model::RepositoryProvider>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) branch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The repository provider.</p>
        pub fn provider(mut self, input: crate::model::RepositoryProvider) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// <p>The repository name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The repository name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The repository branch.</p>
        pub fn branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch = Some(input.into());
            self
        }
        /// <p>The repository branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryBranchInput`](crate::model::RepositoryBranchInput)
        pub fn build(self) -> crate::model::RepositoryBranchInput {
            crate::model::RepositoryBranchInput {
                provider: self.provider,
                name: self.name,
                branch: self.branch,
            }
        }
    }
}
impl RepositoryBranchInput {
    /// Creates a new builder-style object to manufacture [`RepositoryBranchInput`](crate::model::RepositoryBranchInput)
    pub fn builder() -> crate::model::repository_branch_input::Builder {
        crate::model::repository_branch_input::Builder::default()
    }
}

/// <p>The environment account connection detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentAccountConnection {
    /// <p>The ID of the environment account connection.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the management account that's connected to the environment account connection.</p>
    pub management_account_id: std::option::Option<std::string::String>,
    /// <p>The environment account that's connected to the environment account connection.</p>
    pub environment_account_id: std::option::Option<std::string::String>,
    /// <p>The IAM service role that's associated with the environment account connection.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the environment that's associated with the environment account connection.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The time when the environment account connection request was made.</p>
    pub requested_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the environment account connection was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the environment account connection.</p>
    pub status: std::option::Option<crate::model::EnvironmentAccountConnectionStatus>,
}
impl EnvironmentAccountConnection {
    /// <p>The ID of the environment account connection.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the management account that's connected to the environment account connection.</p>
    pub fn management_account_id(&self) -> std::option::Option<&str> {
        self.management_account_id.as_deref()
    }
    /// <p>The environment account that's connected to the environment account connection.</p>
    pub fn environment_account_id(&self) -> std::option::Option<&str> {
        self.environment_account_id.as_deref()
    }
    /// <p>The IAM service role that's associated with the environment account connection.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The name of the environment that's associated with the environment account connection.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The time when the environment account connection request was made.</p>
    pub fn requested_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.requested_at.as_ref()
    }
    /// <p>The time when the environment account connection was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The status of the environment account connection.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EnvironmentAccountConnectionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentAccountConnection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentAccountConnection");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("management_account_id", &self.management_account_id);
        formatter.field("environment_account_id", &self.environment_account_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("requested_at", &self.requested_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`EnvironmentAccountConnection`](crate::model::EnvironmentAccountConnection)
pub mod environment_account_connection {
    /// A builder for [`EnvironmentAccountConnection`](crate::model::EnvironmentAccountConnection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) management_account_id: std::option::Option<std::string::String>,
        pub(crate) environment_account_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) requested_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentAccountConnectionStatus>,
    }
    impl Builder {
        /// <p>The ID of the environment account connection.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the management account that's connected to the environment account connection.</p>
        pub fn management_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.management_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the management account that's connected to the environment account connection.</p>
        pub fn set_management_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.management_account_id = input;
            self
        }
        /// <p>The environment account that's connected to the environment account connection.</p>
        pub fn environment_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_account_id = Some(input.into());
            self
        }
        /// <p>The environment account that's connected to the environment account connection.</p>
        pub fn set_environment_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_id = input;
            self
        }
        /// <p>The IAM service role that's associated with the environment account connection.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM service role that's associated with the environment account connection.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the environment that's associated with the environment account connection.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment that's associated with the environment account connection.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The time when the environment account connection request was made.</p>
        pub fn requested_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.requested_at = Some(input);
            self
        }
        /// <p>The time when the environment account connection request was made.</p>
        pub fn set_requested_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.requested_at = input;
            self
        }
        /// <p>The time when the environment account connection was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the environment account connection was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The status of the environment account connection.</p>
        pub fn status(mut self, input: crate::model::EnvironmentAccountConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the environment account connection.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentAccountConnection`](crate::model::EnvironmentAccountConnection)
        pub fn build(self) -> crate::model::EnvironmentAccountConnection {
            crate::model::EnvironmentAccountConnection {
                id: self.id,
                arn: self.arn,
                management_account_id: self.management_account_id,
                environment_account_id: self.environment_account_id,
                role_arn: self.role_arn,
                environment_name: self.environment_name,
                requested_at: self.requested_at,
                last_modified_at: self.last_modified_at,
                status: self.status,
            }
        }
    }
}
impl EnvironmentAccountConnection {
    /// Creates a new builder-style object to manufacture [`EnvironmentAccountConnection`](crate::model::EnvironmentAccountConnection)
    pub fn builder() -> crate::model::environment_account_connection::Builder {
        crate::model::environment_account_connection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentAccountConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentAccountConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => EnvironmentAccountConnectionStatus::Connected,
            "PENDING" => EnvironmentAccountConnectionStatus::Pending,
            "REJECTED" => EnvironmentAccountConnectionStatus::Rejected,
            other => EnvironmentAccountConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentAccountConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentAccountConnectionStatus::from(s))
    }
}
impl EnvironmentAccountConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentAccountConnectionStatus::Connected => "CONNECTED",
            EnvironmentAccountConnectionStatus::Pending => "PENDING",
            EnvironmentAccountConnectionStatus::Rejected => "REJECTED",
            EnvironmentAccountConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTED", "PENDING", "REJECTED"]
    }
}
impl AsRef<str> for EnvironmentAccountConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of the environment account connection detail data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentAccountConnectionSummary {
    /// <p>The ID of the environment account connection.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the management account that's connected to the environment account connection.</p>
    pub management_account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the environment account that's connected to the environment account connection.</p>
    pub environment_account_id: std::option::Option<std::string::String>,
    /// <p>The IAM service role that's associated with the environment account connection.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the environment that's associated with the environment account connection.</p>
    pub environment_name: std::option::Option<std::string::String>,
    /// <p>The time when the environment account connection request was made.</p>
    pub requested_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the environment account connection was last modified.</p>
    pub last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the environment account connection.</p>
    pub status: std::option::Option<crate::model::EnvironmentAccountConnectionStatus>,
}
impl EnvironmentAccountConnectionSummary {
    /// <p>The ID of the environment account connection.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the management account that's connected to the environment account connection.</p>
    pub fn management_account_id(&self) -> std::option::Option<&str> {
        self.management_account_id.as_deref()
    }
    /// <p>The ID of the environment account that's connected to the environment account connection.</p>
    pub fn environment_account_id(&self) -> std::option::Option<&str> {
        self.environment_account_id.as_deref()
    }
    /// <p>The IAM service role that's associated with the environment account connection.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The name of the environment that's associated with the environment account connection.</p>
    pub fn environment_name(&self) -> std::option::Option<&str> {
        self.environment_name.as_deref()
    }
    /// <p>The time when the environment account connection request was made.</p>
    pub fn requested_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.requested_at.as_ref()
    }
    /// <p>The time when the environment account connection was last modified.</p>
    pub fn last_modified_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_at.as_ref()
    }
    /// <p>The status of the environment account connection.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::EnvironmentAccountConnectionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentAccountConnectionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentAccountConnectionSummary");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("management_account_id", &self.management_account_id);
        formatter.field("environment_account_id", &self.environment_account_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("environment_name", &self.environment_name);
        formatter.field("requested_at", &self.requested_at);
        formatter.field("last_modified_at", &self.last_modified_at);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`EnvironmentAccountConnectionSummary`](crate::model::EnvironmentAccountConnectionSummary)
pub mod environment_account_connection_summary {
    /// A builder for [`EnvironmentAccountConnectionSummary`](crate::model::EnvironmentAccountConnectionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) management_account_id: std::option::Option<std::string::String>,
        pub(crate) environment_account_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) environment_name: std::option::Option<std::string::String>,
        pub(crate) requested_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::EnvironmentAccountConnectionStatus>,
    }
    impl Builder {
        /// <p>The ID of the environment account connection.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the environment account connection.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the management account that's connected to the environment account connection.</p>
        pub fn management_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.management_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the management account that's connected to the environment account connection.</p>
        pub fn set_management_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.management_account_id = input;
            self
        }
        /// <p>The ID of the environment account that's connected to the environment account connection.</p>
        pub fn environment_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_account_id = Some(input.into());
            self
        }
        /// <p>The ID of the environment account that's connected to the environment account connection.</p>
        pub fn set_environment_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_account_id = input;
            self
        }
        /// <p>The IAM service role that's associated with the environment account connection.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM service role that's associated with the environment account connection.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the environment that's associated with the environment account connection.</p>
        pub fn environment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.environment_name = Some(input.into());
            self
        }
        /// <p>The name of the environment that's associated with the environment account connection.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.environment_name = input;
            self
        }
        /// <p>The time when the environment account connection request was made.</p>
        pub fn requested_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.requested_at = Some(input);
            self
        }
        /// <p>The time when the environment account connection request was made.</p>
        pub fn set_requested_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.requested_at = input;
            self
        }
        /// <p>The time when the environment account connection was last modified.</p>
        pub fn last_modified_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_at = Some(input);
            self
        }
        /// <p>The time when the environment account connection was last modified.</p>
        pub fn set_last_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_at = input;
            self
        }
        /// <p>The status of the environment account connection.</p>
        pub fn status(mut self, input: crate::model::EnvironmentAccountConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the environment account connection.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentAccountConnectionSummary`](crate::model::EnvironmentAccountConnectionSummary)
        pub fn build(self) -> crate::model::EnvironmentAccountConnectionSummary {
            crate::model::EnvironmentAccountConnectionSummary {
                id: self.id,
                arn: self.arn,
                management_account_id: self.management_account_id,
                environment_account_id: self.environment_account_id,
                role_arn: self.role_arn,
                environment_name: self.environment_name,
                requested_at: self.requested_at,
                last_modified_at: self.last_modified_at,
                status: self.status,
            }
        }
    }
}
impl EnvironmentAccountConnectionSummary {
    /// Creates a new builder-style object to manufacture [`EnvironmentAccountConnectionSummary`](crate::model::EnvironmentAccountConnectionSummary)
    pub fn builder() -> crate::model::environment_account_connection_summary::Builder {
        crate::model::environment_account_connection_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentAccountConnectionRequesterAccountType {
    #[allow(missing_docs)] // documentation missing in model
    EnvironmentAccount,
    #[allow(missing_docs)] // documentation missing in model
    ManagementAccount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentAccountConnectionRequesterAccountType {
    fn from(s: &str) -> Self {
        match s {
            "ENVIRONMENT_ACCOUNT" => {
                EnvironmentAccountConnectionRequesterAccountType::EnvironmentAccount
            }
            "MANAGEMENT_ACCOUNT" => {
                EnvironmentAccountConnectionRequesterAccountType::ManagementAccount
            }
            other => EnvironmentAccountConnectionRequesterAccountType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentAccountConnectionRequesterAccountType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentAccountConnectionRequesterAccountType::from(s))
    }
}
impl EnvironmentAccountConnectionRequesterAccountType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentAccountConnectionRequesterAccountType::EnvironmentAccount => {
                "ENVIRONMENT_ACCOUNT"
            }
            EnvironmentAccountConnectionRequesterAccountType::ManagementAccount => {
                "MANAGEMENT_ACCOUNT"
            }
            EnvironmentAccountConnectionRequesterAccountType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENVIRONMENT_ACCOUNT", "MANAGEMENT_ACCOUNT"]
    }
}
impl AsRef<str> for EnvironmentAccountConnectionRequesterAccountType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Proton pipeline service role and repository data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountSettings {
    /// <p>The Amazon Resource Name (ARN) of the Proton pipeline service role.</p>
    pub pipeline_service_role_arn: std::option::Option<std::string::String>,
    /// <p>The repository that you provide with pull request provisioning.</p>
    /// <important>
    /// <p>Provisioning by pull request is currently in feature preview and is
    /// only usable with Terraform based Proton Templates. To learn more about
    /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
    /// Previews.</p>
    /// </important>
    pub pipeline_provisioning_repository: std::option::Option<crate::model::RepositoryBranch>,
}
impl AccountSettings {
    /// <p>The Amazon Resource Name (ARN) of the Proton pipeline service role.</p>
    pub fn pipeline_service_role_arn(&self) -> std::option::Option<&str> {
        self.pipeline_service_role_arn.as_deref()
    }
    /// <p>The repository that you provide with pull request provisioning.</p>
    /// <important>
    /// <p>Provisioning by pull request is currently in feature preview and is
    /// only usable with Terraform based Proton Templates. To learn more about
    /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
    /// Previews.</p>
    /// </important>
    pub fn pipeline_provisioning_repository(
        &self,
    ) -> std::option::Option<&crate::model::RepositoryBranch> {
        self.pipeline_provisioning_repository.as_ref()
    }
}
impl std::fmt::Debug for AccountSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountSettings");
        formatter.field("pipeline_service_role_arn", &self.pipeline_service_role_arn);
        formatter.field(
            "pipeline_provisioning_repository",
            &self.pipeline_provisioning_repository,
        );
        formatter.finish()
    }
}
/// See [`AccountSettings`](crate::model::AccountSettings)
pub mod account_settings {
    /// A builder for [`AccountSettings`](crate::model::AccountSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_service_role_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_provisioning_repository:
            std::option::Option<crate::model::RepositoryBranch>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Proton pipeline service role.</p>
        pub fn pipeline_service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton pipeline service role.</p>
        pub fn set_pipeline_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_service_role_arn = input;
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn pipeline_provisioning_repository(
            mut self,
            input: crate::model::RepositoryBranch,
        ) -> Self {
            self.pipeline_provisioning_repository = Some(input);
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn set_pipeline_provisioning_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryBranch>,
        ) -> Self {
            self.pipeline_provisioning_repository = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountSettings`](crate::model::AccountSettings)
        pub fn build(self) -> crate::model::AccountSettings {
            crate::model::AccountSettings {
                pipeline_service_role_arn: self.pipeline_service_role_arn,
                pipeline_provisioning_repository: self.pipeline_provisioning_repository,
            }
        }
    }
}
impl AccountSettings {
    /// Creates a new builder-style object to manufacture [`AccountSettings`](crate::model::AccountSettings)
    pub fn builder() -> crate::model::account_settings::Builder {
        crate::model::account_settings::Builder::default()
    }
}

/// The state that a PR-based deployment can be updated to.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceDeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceDeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ResourceDeploymentStatus::Failed,
            "IN_PROGRESS" => ResourceDeploymentStatus::InProgress,
            "SUCCEEDED" => ResourceDeploymentStatus::Succeeded,
            other => ResourceDeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceDeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceDeploymentStatus::from(s))
    }
}
impl ResourceDeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceDeploymentStatus::Failed => "FAILED",
            ResourceDeploymentStatus::InProgress => "IN_PROGRESS",
            ResourceDeploymentStatus::Succeeded => "SUCCEEDED",
            ResourceDeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for ResourceDeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The repository sync definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositorySyncDefinition {
    /// <p>The resource that is synced to.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The resource that is synced from.</p>
    pub parent: std::option::Option<std::string::String>,
    /// <p>The repository branch.</p>
    pub branch: std::option::Option<std::string::String>,
    /// <p>The directory in the repository.</p>
    pub directory: std::option::Option<std::string::String>,
}
impl RepositorySyncDefinition {
    /// <p>The resource that is synced to.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>The resource that is synced from.</p>
    pub fn parent(&self) -> std::option::Option<&str> {
        self.parent.as_deref()
    }
    /// <p>The repository branch.</p>
    pub fn branch(&self) -> std::option::Option<&str> {
        self.branch.as_deref()
    }
    /// <p>The directory in the repository.</p>
    pub fn directory(&self) -> std::option::Option<&str> {
        self.directory.as_deref()
    }
}
impl std::fmt::Debug for RepositorySyncDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositorySyncDefinition");
        formatter.field("target", &self.target);
        formatter.field("parent", &self.parent);
        formatter.field("branch", &self.branch);
        formatter.field("directory", &self.directory);
        formatter.finish()
    }
}
/// See [`RepositorySyncDefinition`](crate::model::RepositorySyncDefinition)
pub mod repository_sync_definition {
    /// A builder for [`RepositorySyncDefinition`](crate::model::RepositorySyncDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) parent: std::option::Option<std::string::String>,
        pub(crate) branch: std::option::Option<std::string::String>,
        pub(crate) directory: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource that is synced to.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The resource that is synced to.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The resource that is synced from.</p>
        pub fn parent(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent = Some(input.into());
            self
        }
        /// <p>The resource that is synced from.</p>
        pub fn set_parent(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent = input;
            self
        }
        /// <p>The repository branch.</p>
        pub fn branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch = Some(input.into());
            self
        }
        /// <p>The repository branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch = input;
            self
        }
        /// <p>The directory in the repository.</p>
        pub fn directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory = Some(input.into());
            self
        }
        /// <p>The directory in the repository.</p>
        pub fn set_directory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositorySyncDefinition`](crate::model::RepositorySyncDefinition)
        pub fn build(self) -> crate::model::RepositorySyncDefinition {
            crate::model::RepositorySyncDefinition {
                target: self.target,
                parent: self.parent,
                branch: self.branch,
                directory: self.directory,
            }
        }
    }
}
impl RepositorySyncDefinition {
    /// Creates a new builder-style object to manufacture [`RepositorySyncDefinition`](crate::model::RepositorySyncDefinition)
    pub fn builder() -> crate::model::repository_sync_definition::Builder {
        crate::model::repository_sync_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SyncType {
    #[allow(missing_docs)] // documentation missing in model
    TemplateSync,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SyncType {
    fn from(s: &str) -> Self {
        match s {
            "TEMPLATE_SYNC" => SyncType::TemplateSync,
            other => SyncType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SyncType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SyncType::from(s))
    }
}
impl SyncType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SyncType::TemplateSync => "TEMPLATE_SYNC",
            SyncType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TEMPLATE_SYNC"]
    }
}
impl AsRef<str> for SyncType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Revision detail data for a commit and push that activates a sync attempt</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Revision {
    /// <p>The repository name.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The repository provider.</p>
    pub repository_provider: std::option::Option<crate::model::RepositoryProvider>,
    /// <p>The secure hash algorithm (SHA) hash for the revision.</p>
    pub sha: std::option::Option<std::string::String>,
    /// <p>The repository directory changed by a commit and push that activated the sync attempt.</p>
    pub directory: std::option::Option<std::string::String>,
    /// <p>The repository branch.</p>
    pub branch: std::option::Option<std::string::String>,
}
impl Revision {
    /// <p>The repository name.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The repository provider.</p>
    pub fn repository_provider(&self) -> std::option::Option<&crate::model::RepositoryProvider> {
        self.repository_provider.as_ref()
    }
    /// <p>The secure hash algorithm (SHA) hash for the revision.</p>
    pub fn sha(&self) -> std::option::Option<&str> {
        self.sha.as_deref()
    }
    /// <p>The repository directory changed by a commit and push that activated the sync attempt.</p>
    pub fn directory(&self) -> std::option::Option<&str> {
        self.directory.as_deref()
    }
    /// <p>The repository branch.</p>
    pub fn branch(&self) -> std::option::Option<&str> {
        self.branch.as_deref()
    }
}
impl std::fmt::Debug for Revision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Revision");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("repository_provider", &self.repository_provider);
        formatter.field("sha", &self.sha);
        formatter.field("directory", &self.directory);
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`Revision`](crate::model::Revision)
pub mod revision {
    /// A builder for [`Revision`](crate::model::Revision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) repository_provider: std::option::Option<crate::model::RepositoryProvider>,
        pub(crate) sha: std::option::Option<std::string::String>,
        pub(crate) directory: std::option::Option<std::string::String>,
        pub(crate) branch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The repository name.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The repository provider.</p>
        pub fn repository_provider(mut self, input: crate::model::RepositoryProvider) -> Self {
            self.repository_provider = Some(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_repository_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.repository_provider = input;
            self
        }
        /// <p>The secure hash algorithm (SHA) hash for the revision.</p>
        pub fn sha(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha = Some(input.into());
            self
        }
        /// <p>The secure hash algorithm (SHA) hash for the revision.</p>
        pub fn set_sha(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sha = input;
            self
        }
        /// <p>The repository directory changed by a commit and push that activated the sync attempt.</p>
        pub fn directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory = Some(input.into());
            self
        }
        /// <p>The repository directory changed by a commit and push that activated the sync attempt.</p>
        pub fn set_directory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory = input;
            self
        }
        /// <p>The repository branch.</p>
        pub fn branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch = Some(input.into());
            self
        }
        /// <p>The repository branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`Revision`](crate::model::Revision)
        pub fn build(self) -> crate::model::Revision {
            crate::model::Revision {
                repository_name: self.repository_name,
                repository_provider: self.repository_provider,
                sha: self.sha,
                directory: self.directory,
                branch: self.branch,
            }
        }
    }
}
impl Revision {
    /// Creates a new builder-style object to manufacture [`Revision`](crate::model::Revision)
    pub fn builder() -> crate::model::revision::Builder {
        crate::model::revision::Builder::default()
    }
}

/// <p>Detail data for a resource sync attempt activated by a push to a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSyncAttempt {
    /// <p>Detail data for the initial repository commit, path and push.</p>
    pub initial_revision: std::option::Option<crate::model::Revision>,
    /// <p>Detail data for the target revision.</p>
    pub target_revision: std::option::Option<crate::model::Revision>,
    /// <p>The resource that is synced to.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The time when the sync attempt started.</p>
    pub started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the sync attempt.</p>
    pub status: std::option::Option<crate::model::ResourceSyncStatus>,
    /// <p>An array of events with detail data.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::ResourceSyncEvent>>,
}
impl ResourceSyncAttempt {
    /// <p>Detail data for the initial repository commit, path and push.</p>
    pub fn initial_revision(&self) -> std::option::Option<&crate::model::Revision> {
        self.initial_revision.as_ref()
    }
    /// <p>Detail data for the target revision.</p>
    pub fn target_revision(&self) -> std::option::Option<&crate::model::Revision> {
        self.target_revision.as_ref()
    }
    /// <p>The resource that is synced to.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>The time when the sync attempt started.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_at.as_ref()
    }
    /// <p>The status of the sync attempt.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceSyncStatus> {
        self.status.as_ref()
    }
    /// <p>An array of events with detail data.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::ResourceSyncEvent]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for ResourceSyncAttempt {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSyncAttempt");
        formatter.field("initial_revision", &self.initial_revision);
        formatter.field("target_revision", &self.target_revision);
        formatter.field("target", &self.target);
        formatter.field("started_at", &self.started_at);
        formatter.field("status", &self.status);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`ResourceSyncAttempt`](crate::model::ResourceSyncAttempt)
pub mod resource_sync_attempt {
    /// A builder for [`ResourceSyncAttempt`](crate::model::ResourceSyncAttempt)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_revision: std::option::Option<crate::model::Revision>,
        pub(crate) target_revision: std::option::Option<crate::model::Revision>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ResourceSyncStatus>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::ResourceSyncEvent>>,
    }
    impl Builder {
        /// <p>Detail data for the initial repository commit, path and push.</p>
        pub fn initial_revision(mut self, input: crate::model::Revision) -> Self {
            self.initial_revision = Some(input);
            self
        }
        /// <p>Detail data for the initial repository commit, path and push.</p>
        pub fn set_initial_revision(
            mut self,
            input: std::option::Option<crate::model::Revision>,
        ) -> Self {
            self.initial_revision = input;
            self
        }
        /// <p>Detail data for the target revision.</p>
        pub fn target_revision(mut self, input: crate::model::Revision) -> Self {
            self.target_revision = Some(input);
            self
        }
        /// <p>Detail data for the target revision.</p>
        pub fn set_target_revision(
            mut self,
            input: std::option::Option<crate::model::Revision>,
        ) -> Self {
            self.target_revision = input;
            self
        }
        /// <p>The resource that is synced to.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The resource that is synced to.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The time when the sync attempt started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time when the sync attempt started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The status of the sync attempt.</p>
        pub fn status(mut self, input: crate::model::ResourceSyncStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the sync attempt.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceSyncStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>An array of events with detail data.</p>
        pub fn events(mut self, input: impl Into<crate::model::ResourceSyncEvent>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>An array of events with detail data.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceSyncEvent>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSyncAttempt`](crate::model::ResourceSyncAttempt)
        pub fn build(self) -> crate::model::ResourceSyncAttempt {
            crate::model::ResourceSyncAttempt {
                initial_revision: self.initial_revision,
                target_revision: self.target_revision,
                target: self.target,
                started_at: self.started_at,
                status: self.status,
                events: self.events,
            }
        }
    }
}
impl ResourceSyncAttempt {
    /// Creates a new builder-style object to manufacture [`ResourceSyncAttempt`](crate::model::ResourceSyncAttempt)
    pub fn builder() -> crate::model::resource_sync_attempt::Builder {
        crate::model::resource_sync_attempt::Builder::default()
    }
}

/// <p>Detail data for a resource sync event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSyncEvent {
    /// <p>The type of event.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The external ID for the event.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The time when the event occurred.</p>
    pub time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A resource sync event.</p>
    pub event: std::option::Option<std::string::String>,
}
impl ResourceSyncEvent {
    /// <p>The type of event.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The external ID for the event.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>The time when the event occurred.</p>
    pub fn time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time.as_ref()
    }
    /// <p>A resource sync event.</p>
    pub fn event(&self) -> std::option::Option<&str> {
        self.event.as_deref()
    }
}
impl std::fmt::Debug for ResourceSyncEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSyncEvent");
        formatter.field("r#type", &self.r#type);
        formatter.field("external_id", &self.external_id);
        formatter.field("time", &self.time);
        formatter.field("event", &self.event);
        formatter.finish()
    }
}
/// See [`ResourceSyncEvent`](crate::model::ResourceSyncEvent)
pub mod resource_sync_event {
    /// A builder for [`ResourceSyncEvent`](crate::model::ResourceSyncEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of event.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of event.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The external ID for the event.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID for the event.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The time when the event occurred.</p>
        pub fn time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time = Some(input);
            self
        }
        /// <p>The time when the event occurred.</p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.time = input;
            self
        }
        /// <p>A resource sync event.</p>
        pub fn event(mut self, input: impl Into<std::string::String>) -> Self {
            self.event = Some(input.into());
            self
        }
        /// <p>A resource sync event.</p>
        pub fn set_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSyncEvent`](crate::model::ResourceSyncEvent)
        pub fn build(self) -> crate::model::ResourceSyncEvent {
            crate::model::ResourceSyncEvent {
                r#type: self.r#type,
                external_id: self.external_id,
                time: self.time,
                event: self.event,
            }
        }
    }
}
impl ResourceSyncEvent {
    /// Creates a new builder-style object to manufacture [`ResourceSyncEvent`](crate::model::ResourceSyncEvent)
    pub fn builder() -> crate::model::resource_sync_event::Builder {
        crate::model::resource_sync_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceSyncStatus {
    /// Syncing has failed.
    ///
    Failed,
    /// A sync attempt has been created and will begin soon.
    ///
    Initiated,
    /// Syncing has started and work is being done to reconcile state.
    ///
    InProgress,
    /// Syncing has completed successfully.
    ///
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceSyncStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ResourceSyncStatus::Failed,
            "INITIATED" => ResourceSyncStatus::Initiated,
            "IN_PROGRESS" => ResourceSyncStatus::InProgress,
            "SUCCEEDED" => ResourceSyncStatus::Succeeded,
            other => ResourceSyncStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceSyncStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceSyncStatus::from(s))
    }
}
impl ResourceSyncStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceSyncStatus::Failed => "FAILED",
            ResourceSyncStatus::Initiated => "INITIATED",
            ResourceSyncStatus::InProgress => "IN_PROGRESS",
            ResourceSyncStatus::Succeeded => "SUCCEEDED",
            ResourceSyncStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "INITIATED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for ResourceSyncStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Detail data for a repository sync attempt activated by a push to a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositorySyncAttempt {
    /// <p>The time when the sync attempt started.</p>
    pub started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The sync attempt status.</p>
    pub status: std::option::Option<crate::model::RepositorySyncStatus>,
    /// <p>Detail data for sync attempt events.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::RepositorySyncEvent>>,
}
impl RepositorySyncAttempt {
    /// <p>The time when the sync attempt started.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_at.as_ref()
    }
    /// <p>The sync attempt status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RepositorySyncStatus> {
        self.status.as_ref()
    }
    /// <p>Detail data for sync attempt events.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::RepositorySyncEvent]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for RepositorySyncAttempt {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositorySyncAttempt");
        formatter.field("started_at", &self.started_at);
        formatter.field("status", &self.status);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`RepositorySyncAttempt`](crate::model::RepositorySyncAttempt)
pub mod repository_sync_attempt {
    /// A builder for [`RepositorySyncAttempt`](crate::model::RepositorySyncAttempt)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::RepositorySyncStatus>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::RepositorySyncEvent>>,
    }
    impl Builder {
        /// <p>The time when the sync attempt started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time when the sync attempt started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The sync attempt status.</p>
        pub fn status(mut self, input: crate::model::RepositorySyncStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The sync attempt status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RepositorySyncStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>Detail data for sync attempt events.</p>
        pub fn events(mut self, input: impl Into<crate::model::RepositorySyncEvent>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>Detail data for sync attempt events.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositorySyncEvent>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositorySyncAttempt`](crate::model::RepositorySyncAttempt)
        pub fn build(self) -> crate::model::RepositorySyncAttempt {
            crate::model::RepositorySyncAttempt {
                started_at: self.started_at,
                status: self.status,
                events: self.events,
            }
        }
    }
}
impl RepositorySyncAttempt {
    /// Creates a new builder-style object to manufacture [`RepositorySyncAttempt`](crate::model::RepositorySyncAttempt)
    pub fn builder() -> crate::model::repository_sync_attempt::Builder {
        crate::model::repository_sync_attempt::Builder::default()
    }
}

/// <p>Repository sync event detail data for a sync attempt.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositorySyncEvent {
    /// <p>The type of event.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The external ID of the sync event.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The time that the sync event occurred.</p>
    pub time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Event detail for a repository sync attempt.</p>
    pub event: std::option::Option<std::string::String>,
}
impl RepositorySyncEvent {
    /// <p>The type of event.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The external ID of the sync event.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>The time that the sync event occurred.</p>
    pub fn time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time.as_ref()
    }
    /// <p>Event detail for a repository sync attempt.</p>
    pub fn event(&self) -> std::option::Option<&str> {
        self.event.as_deref()
    }
}
impl std::fmt::Debug for RepositorySyncEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositorySyncEvent");
        formatter.field("r#type", &self.r#type);
        formatter.field("external_id", &self.external_id);
        formatter.field("time", &self.time);
        formatter.field("event", &self.event);
        formatter.finish()
    }
}
/// See [`RepositorySyncEvent`](crate::model::RepositorySyncEvent)
pub mod repository_sync_event {
    /// A builder for [`RepositorySyncEvent`](crate::model::RepositorySyncEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of event.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of event.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The external ID of the sync event.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID of the sync event.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The time that the sync event occurred.</p>
        pub fn time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time = Some(input);
            self
        }
        /// <p>The time that the sync event occurred.</p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.time = input;
            self
        }
        /// <p>Event detail for a repository sync attempt.</p>
        pub fn event(mut self, input: impl Into<std::string::String>) -> Self {
            self.event = Some(input.into());
            self
        }
        /// <p>Event detail for a repository sync attempt.</p>
        pub fn set_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositorySyncEvent`](crate::model::RepositorySyncEvent)
        pub fn build(self) -> crate::model::RepositorySyncEvent {
            crate::model::RepositorySyncEvent {
                r#type: self.r#type,
                external_id: self.external_id,
                time: self.time,
                event: self.event,
            }
        }
    }
}
impl RepositorySyncEvent {
    /// Creates a new builder-style object to manufacture [`RepositorySyncEvent`](crate::model::RepositorySyncEvent)
    pub fn builder() -> crate::model::repository_sync_event::Builder {
        crate::model::repository_sync_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RepositorySyncStatus {
    /// The repository sync attempt has failed.
    ///
    Failed,
    /// A repository sync attempt has been created and will begin soon.
    ///
    Initiated,
    /// A repository sync attempt has started and work is being done to reconcile the branch.
    ///
    InProgress,
    /// The repository sync attempt didn't execute and was queued.
    ///
    Queued,
    /// The repository sync attempt has completed successfully.
    ///
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RepositorySyncStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => RepositorySyncStatus::Failed,
            "INITIATED" => RepositorySyncStatus::Initiated,
            "IN_PROGRESS" => RepositorySyncStatus::InProgress,
            "QUEUED" => RepositorySyncStatus::Queued,
            "SUCCEEDED" => RepositorySyncStatus::Succeeded,
            other => RepositorySyncStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RepositorySyncStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RepositorySyncStatus::from(s))
    }
}
impl RepositorySyncStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RepositorySyncStatus::Failed => "FAILED",
            RepositorySyncStatus::Initiated => "INITIATED",
            RepositorySyncStatus::InProgress => "IN_PROGRESS",
            RepositorySyncStatus::Queued => "QUEUED",
            RepositorySyncStatus::Succeeded => "SUCCEEDED",
            RepositorySyncStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "INITIATED", "IN_PROGRESS", "QUEUED", "SUCCEEDED"]
    }
}
impl AsRef<str> for RepositorySyncStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
