// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Proton
///
/// Client for invoking operations on AWS Proton. Each operation on AWS Proton is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_proton::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_proton::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_proton::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptEnvironmentAccountConnection` operation.
    ///
    /// See [`AcceptEnvironmentAccountConnection`](crate::client::fluent_builders::AcceptEnvironmentAccountConnection) for more information about the
    /// operation and its arguments.
    pub fn accept_environment_account_connection(
        &self,
    ) -> fluent_builders::AcceptEnvironmentAccountConnection<C, M, R> {
        fluent_builders::AcceptEnvironmentAccountConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelEnvironmentDeployment` operation.
    ///
    /// See [`CancelEnvironmentDeployment`](crate::client::fluent_builders::CancelEnvironmentDeployment) for more information about the
    /// operation and its arguments.
    pub fn cancel_environment_deployment(
        &self,
    ) -> fluent_builders::CancelEnvironmentDeployment<C, M, R> {
        fluent_builders::CancelEnvironmentDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelServiceInstanceDeployment` operation.
    ///
    /// See [`CancelServiceInstanceDeployment`](crate::client::fluent_builders::CancelServiceInstanceDeployment) for more information about the
    /// operation and its arguments.
    pub fn cancel_service_instance_deployment(
        &self,
    ) -> fluent_builders::CancelServiceInstanceDeployment<C, M, R> {
        fluent_builders::CancelServiceInstanceDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelServicePipelineDeployment` operation.
    ///
    /// See [`CancelServicePipelineDeployment`](crate::client::fluent_builders::CancelServicePipelineDeployment) for more information about the
    /// operation and its arguments.
    pub fn cancel_service_pipeline_deployment(
        &self,
    ) -> fluent_builders::CancelServicePipelineDeployment<C, M, R> {
        fluent_builders::CancelServicePipelineDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEnvironment` operation.
    ///
    /// See [`CreateEnvironment`](crate::client::fluent_builders::CreateEnvironment) for more information about the
    /// operation and its arguments.
    pub fn create_environment(&self) -> fluent_builders::CreateEnvironment<C, M, R> {
        fluent_builders::CreateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEnvironmentAccountConnection` operation.
    ///
    /// See [`CreateEnvironmentAccountConnection`](crate::client::fluent_builders::CreateEnvironmentAccountConnection) for more information about the
    /// operation and its arguments.
    pub fn create_environment_account_connection(
        &self,
    ) -> fluent_builders::CreateEnvironmentAccountConnection<C, M, R> {
        fluent_builders::CreateEnvironmentAccountConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEnvironmentTemplate` operation.
    ///
    /// See [`CreateEnvironmentTemplate`](crate::client::fluent_builders::CreateEnvironmentTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_environment_template(
        &self,
    ) -> fluent_builders::CreateEnvironmentTemplate<C, M, R> {
        fluent_builders::CreateEnvironmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEnvironmentTemplateVersion` operation.
    ///
    /// See [`CreateEnvironmentTemplateVersion`](crate::client::fluent_builders::CreateEnvironmentTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn create_environment_template_version(
        &self,
    ) -> fluent_builders::CreateEnvironmentTemplateVersion<C, M, R> {
        fluent_builders::CreateEnvironmentTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRepository` operation.
    ///
    /// See [`CreateRepository`](crate::client::fluent_builders::CreateRepository) for more information about the
    /// operation and its arguments.
    pub fn create_repository(&self) -> fluent_builders::CreateRepository<C, M, R> {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateService` operation.
    ///
    /// See [`CreateService`](crate::client::fluent_builders::CreateService) for more information about the
    /// operation and its arguments.
    pub fn create_service(&self) -> fluent_builders::CreateService<C, M, R> {
        fluent_builders::CreateService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateServiceTemplate` operation.
    ///
    /// See [`CreateServiceTemplate`](crate::client::fluent_builders::CreateServiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_service_template(&self) -> fluent_builders::CreateServiceTemplate<C, M, R> {
        fluent_builders::CreateServiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateServiceTemplateVersion` operation.
    ///
    /// See [`CreateServiceTemplateVersion`](crate::client::fluent_builders::CreateServiceTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn create_service_template_version(
        &self,
    ) -> fluent_builders::CreateServiceTemplateVersion<C, M, R> {
        fluent_builders::CreateServiceTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTemplateSyncConfig` operation.
    ///
    /// See [`CreateTemplateSyncConfig`](crate::client::fluent_builders::CreateTemplateSyncConfig) for more information about the
    /// operation and its arguments.
    pub fn create_template_sync_config(
        &self,
    ) -> fluent_builders::CreateTemplateSyncConfig<C, M, R> {
        fluent_builders::CreateTemplateSyncConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEnvironment` operation.
    ///
    /// See [`DeleteEnvironment`](crate::client::fluent_builders::DeleteEnvironment) for more information about the
    /// operation and its arguments.
    pub fn delete_environment(&self) -> fluent_builders::DeleteEnvironment<C, M, R> {
        fluent_builders::DeleteEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEnvironmentAccountConnection` operation.
    ///
    /// See [`DeleteEnvironmentAccountConnection`](crate::client::fluent_builders::DeleteEnvironmentAccountConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_environment_account_connection(
        &self,
    ) -> fluent_builders::DeleteEnvironmentAccountConnection<C, M, R> {
        fluent_builders::DeleteEnvironmentAccountConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEnvironmentTemplate` operation.
    ///
    /// See [`DeleteEnvironmentTemplate`](crate::client::fluent_builders::DeleteEnvironmentTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_environment_template(
        &self,
    ) -> fluent_builders::DeleteEnvironmentTemplate<C, M, R> {
        fluent_builders::DeleteEnvironmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEnvironmentTemplateVersion` operation.
    ///
    /// See [`DeleteEnvironmentTemplateVersion`](crate::client::fluent_builders::DeleteEnvironmentTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_environment_template_version(
        &self,
    ) -> fluent_builders::DeleteEnvironmentTemplateVersion<C, M, R> {
        fluent_builders::DeleteEnvironmentTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepository` operation.
    ///
    /// See [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) for more information about the
    /// operation and its arguments.
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository<C, M, R> {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteService` operation.
    ///
    /// See [`DeleteService`](crate::client::fluent_builders::DeleteService) for more information about the
    /// operation and its arguments.
    pub fn delete_service(&self) -> fluent_builders::DeleteService<C, M, R> {
        fluent_builders::DeleteService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServiceTemplate` operation.
    ///
    /// See [`DeleteServiceTemplate`](crate::client::fluent_builders::DeleteServiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_service_template(&self) -> fluent_builders::DeleteServiceTemplate<C, M, R> {
        fluent_builders::DeleteServiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServiceTemplateVersion` operation.
    ///
    /// See [`DeleteServiceTemplateVersion`](crate::client::fluent_builders::DeleteServiceTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_service_template_version(
        &self,
    ) -> fluent_builders::DeleteServiceTemplateVersion<C, M, R> {
        fluent_builders::DeleteServiceTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTemplateSyncConfig` operation.
    ///
    /// See [`DeleteTemplateSyncConfig`](crate::client::fluent_builders::DeleteTemplateSyncConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_template_sync_config(
        &self,
    ) -> fluent_builders::DeleteTemplateSyncConfig<C, M, R> {
        fluent_builders::DeleteTemplateSyncConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountSettings` operation.
    ///
    /// See [`GetAccountSettings`](crate::client::fluent_builders::GetAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn get_account_settings(&self) -> fluent_builders::GetAccountSettings<C, M, R> {
        fluent_builders::GetAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEnvironment` operation.
    ///
    /// See [`GetEnvironment`](crate::client::fluent_builders::GetEnvironment) for more information about the
    /// operation and its arguments.
    pub fn get_environment(&self) -> fluent_builders::GetEnvironment<C, M, R> {
        fluent_builders::GetEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEnvironmentAccountConnection` operation.
    ///
    /// See [`GetEnvironmentAccountConnection`](crate::client::fluent_builders::GetEnvironmentAccountConnection) for more information about the
    /// operation and its arguments.
    pub fn get_environment_account_connection(
        &self,
    ) -> fluent_builders::GetEnvironmentAccountConnection<C, M, R> {
        fluent_builders::GetEnvironmentAccountConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEnvironmentTemplate` operation.
    ///
    /// See [`GetEnvironmentTemplate`](crate::client::fluent_builders::GetEnvironmentTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_environment_template(&self) -> fluent_builders::GetEnvironmentTemplate<C, M, R> {
        fluent_builders::GetEnvironmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEnvironmentTemplateVersion` operation.
    ///
    /// See [`GetEnvironmentTemplateVersion`](crate::client::fluent_builders::GetEnvironmentTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn get_environment_template_version(
        &self,
    ) -> fluent_builders::GetEnvironmentTemplateVersion<C, M, R> {
        fluent_builders::GetEnvironmentTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepository` operation.
    ///
    /// See [`GetRepository`](crate::client::fluent_builders::GetRepository) for more information about the
    /// operation and its arguments.
    pub fn get_repository(&self) -> fluent_builders::GetRepository<C, M, R> {
        fluent_builders::GetRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepositorySyncStatus` operation.
    ///
    /// See [`GetRepositorySyncStatus`](crate::client::fluent_builders::GetRepositorySyncStatus) for more information about the
    /// operation and its arguments.
    pub fn get_repository_sync_status(&self) -> fluent_builders::GetRepositorySyncStatus<C, M, R> {
        fluent_builders::GetRepositorySyncStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetService` operation.
    ///
    /// See [`GetService`](crate::client::fluent_builders::GetService) for more information about the
    /// operation and its arguments.
    pub fn get_service(&self) -> fluent_builders::GetService<C, M, R> {
        fluent_builders::GetService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceInstance` operation.
    ///
    /// See [`GetServiceInstance`](crate::client::fluent_builders::GetServiceInstance) for more information about the
    /// operation and its arguments.
    pub fn get_service_instance(&self) -> fluent_builders::GetServiceInstance<C, M, R> {
        fluent_builders::GetServiceInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceTemplate` operation.
    ///
    /// See [`GetServiceTemplate`](crate::client::fluent_builders::GetServiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_service_template(&self) -> fluent_builders::GetServiceTemplate<C, M, R> {
        fluent_builders::GetServiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceTemplateVersion` operation.
    ///
    /// See [`GetServiceTemplateVersion`](crate::client::fluent_builders::GetServiceTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn get_service_template_version(
        &self,
    ) -> fluent_builders::GetServiceTemplateVersion<C, M, R> {
        fluent_builders::GetServiceTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTemplateSyncConfig` operation.
    ///
    /// See [`GetTemplateSyncConfig`](crate::client::fluent_builders::GetTemplateSyncConfig) for more information about the
    /// operation and its arguments.
    pub fn get_template_sync_config(&self) -> fluent_builders::GetTemplateSyncConfig<C, M, R> {
        fluent_builders::GetTemplateSyncConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTemplateSyncStatus` operation.
    ///
    /// See [`GetTemplateSyncStatus`](crate::client::fluent_builders::GetTemplateSyncStatus) for more information about the
    /// operation and its arguments.
    pub fn get_template_sync_status(&self) -> fluent_builders::GetTemplateSyncStatus<C, M, R> {
        fluent_builders::GetTemplateSyncStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEnvironmentAccountConnections` operation.
    ///
    /// See [`ListEnvironmentAccountConnections`](crate::client::fluent_builders::ListEnvironmentAccountConnections) for more information about the
    /// operation and its arguments.
    pub fn list_environment_account_connections(
        &self,
    ) -> fluent_builders::ListEnvironmentAccountConnections<C, M, R> {
        fluent_builders::ListEnvironmentAccountConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEnvironmentOutputs` operation.
    ///
    /// See [`ListEnvironmentOutputs`](crate::client::fluent_builders::ListEnvironmentOutputs) for more information about the
    /// operation and its arguments.
    pub fn list_environment_outputs(&self) -> fluent_builders::ListEnvironmentOutputs<C, M, R> {
        fluent_builders::ListEnvironmentOutputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEnvironmentProvisionedResources` operation.
    ///
    /// See [`ListEnvironmentProvisionedResources`](crate::client::fluent_builders::ListEnvironmentProvisionedResources) for more information about the
    /// operation and its arguments.
    pub fn list_environment_provisioned_resources(
        &self,
    ) -> fluent_builders::ListEnvironmentProvisionedResources<C, M, R> {
        fluent_builders::ListEnvironmentProvisionedResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEnvironments` operation.
    ///
    /// See [`ListEnvironments`](crate::client::fluent_builders::ListEnvironments) for more information about the
    /// operation and its arguments.
    pub fn list_environments(&self) -> fluent_builders::ListEnvironments<C, M, R> {
        fluent_builders::ListEnvironments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEnvironmentTemplates` operation.
    ///
    /// See [`ListEnvironmentTemplates`](crate::client::fluent_builders::ListEnvironmentTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_environment_templates(&self) -> fluent_builders::ListEnvironmentTemplates<C, M, R> {
        fluent_builders::ListEnvironmentTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEnvironmentTemplateVersions` operation.
    ///
    /// See [`ListEnvironmentTemplateVersions`](crate::client::fluent_builders::ListEnvironmentTemplateVersions) for more information about the
    /// operation and its arguments.
    pub fn list_environment_template_versions(
        &self,
    ) -> fluent_builders::ListEnvironmentTemplateVersions<C, M, R> {
        fluent_builders::ListEnvironmentTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRepositories` operation.
    ///
    /// See [`ListRepositories`](crate::client::fluent_builders::ListRepositories) for more information about the
    /// operation and its arguments.
    pub fn list_repositories(&self) -> fluent_builders::ListRepositories<C, M, R> {
        fluent_builders::ListRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRepositorySyncDefinitions` operation.
    ///
    /// See [`ListRepositorySyncDefinitions`](crate::client::fluent_builders::ListRepositorySyncDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_repository_sync_definitions(
        &self,
    ) -> fluent_builders::ListRepositorySyncDefinitions<C, M, R> {
        fluent_builders::ListRepositorySyncDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceInstanceOutputs` operation.
    ///
    /// See [`ListServiceInstanceOutputs`](crate::client::fluent_builders::ListServiceInstanceOutputs) for more information about the
    /// operation and its arguments.
    pub fn list_service_instance_outputs(
        &self,
    ) -> fluent_builders::ListServiceInstanceOutputs<C, M, R> {
        fluent_builders::ListServiceInstanceOutputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceInstanceProvisionedResources` operation.
    ///
    /// See [`ListServiceInstanceProvisionedResources`](crate::client::fluent_builders::ListServiceInstanceProvisionedResources) for more information about the
    /// operation and its arguments.
    pub fn list_service_instance_provisioned_resources(
        &self,
    ) -> fluent_builders::ListServiceInstanceProvisionedResources<C, M, R> {
        fluent_builders::ListServiceInstanceProvisionedResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceInstances` operation.
    ///
    /// See [`ListServiceInstances`](crate::client::fluent_builders::ListServiceInstances) for more information about the
    /// operation and its arguments.
    pub fn list_service_instances(&self) -> fluent_builders::ListServiceInstances<C, M, R> {
        fluent_builders::ListServiceInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServicePipelineOutputs` operation.
    ///
    /// See [`ListServicePipelineOutputs`](crate::client::fluent_builders::ListServicePipelineOutputs) for more information about the
    /// operation and its arguments.
    pub fn list_service_pipeline_outputs(
        &self,
    ) -> fluent_builders::ListServicePipelineOutputs<C, M, R> {
        fluent_builders::ListServicePipelineOutputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServicePipelineProvisionedResources` operation.
    ///
    /// See [`ListServicePipelineProvisionedResources`](crate::client::fluent_builders::ListServicePipelineProvisionedResources) for more information about the
    /// operation and its arguments.
    pub fn list_service_pipeline_provisioned_resources(
        &self,
    ) -> fluent_builders::ListServicePipelineProvisionedResources<C, M, R> {
        fluent_builders::ListServicePipelineProvisionedResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServices` operation.
    ///
    /// See [`ListServices`](crate::client::fluent_builders::ListServices) for more information about the
    /// operation and its arguments.
    pub fn list_services(&self) -> fluent_builders::ListServices<C, M, R> {
        fluent_builders::ListServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceTemplates` operation.
    ///
    /// See [`ListServiceTemplates`](crate::client::fluent_builders::ListServiceTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_service_templates(&self) -> fluent_builders::ListServiceTemplates<C, M, R> {
        fluent_builders::ListServiceTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceTemplateVersions` operation.
    ///
    /// See [`ListServiceTemplateVersions`](crate::client::fluent_builders::ListServiceTemplateVersions) for more information about the
    /// operation and its arguments.
    pub fn list_service_template_versions(
        &self,
    ) -> fluent_builders::ListServiceTemplateVersions<C, M, R> {
        fluent_builders::ListServiceTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `NotifyResourceDeploymentStatusChange` operation.
    ///
    /// See [`NotifyResourceDeploymentStatusChange`](crate::client::fluent_builders::NotifyResourceDeploymentStatusChange) for more information about the
    /// operation and its arguments.
    pub fn notify_resource_deployment_status_change(
        &self,
    ) -> fluent_builders::NotifyResourceDeploymentStatusChange<C, M, R> {
        fluent_builders::NotifyResourceDeploymentStatusChange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectEnvironmentAccountConnection` operation.
    ///
    /// See [`RejectEnvironmentAccountConnection`](crate::client::fluent_builders::RejectEnvironmentAccountConnection) for more information about the
    /// operation and its arguments.
    pub fn reject_environment_account_connection(
        &self,
    ) -> fluent_builders::RejectEnvironmentAccountConnection<C, M, R> {
        fluent_builders::RejectEnvironmentAccountConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccountSettings` operation.
    ///
    /// See [`UpdateAccountSettings`](crate::client::fluent_builders::UpdateAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn update_account_settings(&self) -> fluent_builders::UpdateAccountSettings<C, M, R> {
        fluent_builders::UpdateAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEnvironment` operation.
    ///
    /// See [`UpdateEnvironment`](crate::client::fluent_builders::UpdateEnvironment) for more information about the
    /// operation and its arguments.
    pub fn update_environment(&self) -> fluent_builders::UpdateEnvironment<C, M, R> {
        fluent_builders::UpdateEnvironment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEnvironmentAccountConnection` operation.
    ///
    /// See [`UpdateEnvironmentAccountConnection`](crate::client::fluent_builders::UpdateEnvironmentAccountConnection) for more information about the
    /// operation and its arguments.
    pub fn update_environment_account_connection(
        &self,
    ) -> fluent_builders::UpdateEnvironmentAccountConnection<C, M, R> {
        fluent_builders::UpdateEnvironmentAccountConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEnvironmentTemplate` operation.
    ///
    /// See [`UpdateEnvironmentTemplate`](crate::client::fluent_builders::UpdateEnvironmentTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_environment_template(
        &self,
    ) -> fluent_builders::UpdateEnvironmentTemplate<C, M, R> {
        fluent_builders::UpdateEnvironmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEnvironmentTemplateVersion` operation.
    ///
    /// See [`UpdateEnvironmentTemplateVersion`](crate::client::fluent_builders::UpdateEnvironmentTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn update_environment_template_version(
        &self,
    ) -> fluent_builders::UpdateEnvironmentTemplateVersion<C, M, R> {
        fluent_builders::UpdateEnvironmentTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateService` operation.
    ///
    /// See [`UpdateService`](crate::client::fluent_builders::UpdateService) for more information about the
    /// operation and its arguments.
    pub fn update_service(&self) -> fluent_builders::UpdateService<C, M, R> {
        fluent_builders::UpdateService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceInstance` operation.
    ///
    /// See [`UpdateServiceInstance`](crate::client::fluent_builders::UpdateServiceInstance) for more information about the
    /// operation and its arguments.
    pub fn update_service_instance(&self) -> fluent_builders::UpdateServiceInstance<C, M, R> {
        fluent_builders::UpdateServiceInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServicePipeline` operation.
    ///
    /// See [`UpdateServicePipeline`](crate::client::fluent_builders::UpdateServicePipeline) for more information about the
    /// operation and its arguments.
    pub fn update_service_pipeline(&self) -> fluent_builders::UpdateServicePipeline<C, M, R> {
        fluent_builders::UpdateServicePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceTemplate` operation.
    ///
    /// See [`UpdateServiceTemplate`](crate::client::fluent_builders::UpdateServiceTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_service_template(&self) -> fluent_builders::UpdateServiceTemplate<C, M, R> {
        fluent_builders::UpdateServiceTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceTemplateVersion` operation.
    ///
    /// See [`UpdateServiceTemplateVersion`](crate::client::fluent_builders::UpdateServiceTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn update_service_template_version(
        &self,
    ) -> fluent_builders::UpdateServiceTemplateVersion<C, M, R> {
        fluent_builders::UpdateServiceTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTemplateSyncConfig` operation.
    ///
    /// See [`UpdateTemplateSyncConfig`](crate::client::fluent_builders::UpdateTemplateSyncConfig) for more information about the
    /// operation and its arguments.
    pub fn update_template_sync_config(
        &self,
    ) -> fluent_builders::UpdateTemplateSyncConfig<C, M, R> {
        fluent_builders::UpdateTemplateSyncConfig::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptEnvironmentAccountConnection`.
    ///
    /// <p>In a management account, an environment account connection request is accepted. When the environment account connection request is accepted,
    /// Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account
    /// connections</a> in the <i>Proton Administrator guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptEnvironmentAccountConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_environment_account_connection_input::Builder,
    }
    impl<C, M, R> AcceptEnvironmentAccountConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptEnvironmentAccountConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptEnvironmentAccountConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptEnvironmentAccountConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptEnvironmentAccountConnectionInputOperationOutputAlias,
                crate::output::AcceptEnvironmentAccountConnectionOutput,
                crate::error::AcceptEnvironmentAccountConnectionError,
                crate::input::AcceptEnvironmentAccountConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelEnvironmentDeployment`.
    ///
    /// <p>Attempts to cancel an environment deployment on an <a>UpdateEnvironment</a> action, if the deployment is <code>IN_PROGRESS</code>.
    /// For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-update.html">Update an environment</a> in the
    /// <i>Proton Administrator guide</i>.</p>
    /// <p>The following list includes potential cancellation scenarios.</p>
    /// <ul>
    /// <li>
    /// <p>If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the current <a>UpdateEnvironment</a> action succeeds before the cancellation attempt starts, the resulting deployment state is
    /// <code>SUCCEEDED</code> and the cancellation attempt has no effect.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CancelEnvironmentDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_environment_deployment_input::Builder,
    }
    impl<C, M, R> CancelEnvironmentDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelEnvironmentDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelEnvironmentDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelEnvironmentDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelEnvironmentDeploymentInputOperationOutputAlias,
                crate::output::CancelEnvironmentDeploymentOutput,
                crate::error::CancelEnvironmentDeploymentError,
                crate::input::CancelEnvironmentDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment with the deployment to cancel.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the environment with the deployment to cancel.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelServiceInstanceDeployment`.
    ///
    /// <p>Attempts to cancel a service instance deployment on an <a>UpdateServiceInstance</a> action, if the deployment is
    /// <code>IN_PROGRESS</code>. For more information, see <i>Update a service instance</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-instance-update.html">Proton Administrator guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-instance-update.html">Proton User guide</a>.</p>
    /// <p>The following list includes potential cancellation scenarios.</p>
    /// <ul>
    /// <li>
    /// <p>If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the current <a>UpdateServiceInstance</a> action succeeds before the cancellation attempt starts, the resulting deployment
    /// state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CancelServiceInstanceDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_service_instance_deployment_input::Builder,
    }
    impl<C, M, R> CancelServiceInstanceDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelServiceInstanceDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelServiceInstanceDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelServiceInstanceDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelServiceInstanceDeploymentInputOperationOutputAlias,
                crate::output::CancelServiceInstanceDeploymentOutput,
                crate::error::CancelServiceInstanceDeploymentError,
                crate::input::CancelServiceInstanceDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service instance with the deployment to cancel.</p>
        pub fn service_instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_instance_name(inp);
            self
        }
        /// <p>The name of the service instance with the deployment to cancel.</p>
        pub fn set_service_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_instance_name(input);
            self
        }
        /// <p>The name of the service with the service instance deployment to cancel.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the service with the service instance deployment to cancel.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelServicePipelineDeployment`.
    ///
    /// <p>Attempts to cancel a service pipeline deployment on an <a>UpdateServicePipeline</a> action, if the deployment is
    /// <code>IN_PROGRESS</code>. For more information, see <i>Update a service pipeline</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-pipeline-update.html">Proton Administrator guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-pipeline-update.html">Proton User guide</a>.</p>
    /// <p>The following list includes potential cancellation scenarios.</p>
    /// <ul>
    /// <li>
    /// <p>If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.</p>
    /// </li>
    /// <li>
    /// <p>If the current <a>UpdateServicePipeline</a> action succeeds before the cancellation attempt starts, the resulting deployment
    /// state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CancelServicePipelineDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_service_pipeline_deployment_input::Builder,
    }
    impl<C, M, R> CancelServicePipelineDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelServicePipelineDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelServicePipelineDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelServicePipelineDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelServicePipelineDeploymentInputOperationOutputAlias,
                crate::output::CancelServicePipelineDeploymentOutput,
                crate::error::CancelServicePipelineDeploymentError,
                crate::input::CancelServicePipelineDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service with the service pipeline deployment to cancel.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the service with the service pipeline deployment to cancel.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironment`.
    ///
    /// <p>Deploy a new environment. An Proton environment is created from an environment template that defines infrastructure and resources that can
    /// be shared across services.</p>
    /// <p class="title">
    /// <b>You can provision environments using the following methods:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Standard provisioning: Proton makes direct calls to provision your resources.</p>
    /// </li>
    /// <li>
    /// <p>Pull request provisioning: Proton makes pull requests on your repository to provide compiled infrastructure as code (IaC) files that your
    /// IaC engine uses to provision resources.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> in the
    /// <i>Proton Administrator Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_input::Builder,
    }
    impl<C, M, R> CreateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentInputOperationOutputAlias,
                crate::output::CreateEnvironmentOutput,
                crate::error::CreateEnvironmentError,
                crate::input::CreateEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the environment template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>Proton Administrator Guide</i>.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the environment template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>Proton Administrator Guide</i>.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The major version of the environment template.</p>
        pub fn template_major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_major_version(inp);
            self
        }
        /// <p>The major version of the environment template.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_major_version(input);
            self
        }
        /// <p>The minor version of the environment template.</p>
        pub fn template_minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_minor_version(inp);
            self
        }
        /// <p>The minor version of the environment template.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_minor_version(input);
            self
        }
        /// <p>A description of the environment that's being created and deployed.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the environment that's being created and deployed.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A link to a YAML formatted spec file that provides inputs as defined in the environment template bundle schema file. For more information, see
        /// <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> in the <i>Proton Administrator
        /// Guide</i>.</p>
        pub fn spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>A link to a YAML formatted spec file that provides inputs as defined in the environment template bundle schema file. For more information, see
        /// <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> in the <i>Proton Administrator
        /// Guide</i>.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf. You must
        /// include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and value and omit the
        /// <code>provisioningRepository</code> parameter when you use standard provisioning.</p>
        pub fn proton_service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proton_service_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf. You must
        /// include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and value and omit the
        /// <code>provisioningRepository</code> parameter when you use standard provisioning.</p>
        pub fn set_proton_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proton_service_role_arn(input);
            self
        }
        /// <p>The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an
        /// environment account. You must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and
        /// value and omit the <code>provisioningRepository</code> parameter and values. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator
        /// guide</i>.</p>
        pub fn environment_account_connection_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_account_connection_id(inp);
            self
        }
        /// <p>The ID of the environment account connection that you provide if you're provisioning your environment infrastructure resources to an
        /// environment account. You must include either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and
        /// value and omit the <code>provisioningRepository</code> parameter and values. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator
        /// guide</i>.</p>
        pub fn set_environment_account_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_account_connection_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your environment. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for your environment. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The repository that you provide with pull request provisioning. If you provide this parameter, you must omit the
        /// <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn provisioning_repository(mut self, inp: crate::model::RepositoryBranchInput) -> Self {
            self.inner = self.inner.provisioning_repository(inp);
            self
        }
        /// <p>The repository that you provide with pull request provisioning. If you provide this parameter, you must omit the
        /// <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn set_provisioning_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryBranchInput>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironmentAccountConnection`.
    ///
    /// <p>Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the
    /// environment account from a management account.</p>
    /// <p>An environment account connection is a secure bi-directional connection between a <i>management account</i> and an
    /// <i>environment account</i> that maintains authorization and permissions. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator
    /// guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEnvironmentAccountConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_account_connection_input::Builder,
    }
    impl<C, M, R> CreateEnvironmentAccountConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironmentAccountConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentAccountConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateEnvironmentAccountConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentAccountConnectionInputOperationOutputAlias,
                crate::output::CreateEnvironmentAccountConnectionOutput,
                crate::error::CreateEnvironmentAccountConnectionError,
                crate::input::CreateEnvironmentAccountConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When included, if two identical requests are made with the same client token, Proton returns the environment account connection that the
        /// first request created.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>When included, if two identical requests are made with the same client token, Proton returns the environment account connection that the
        /// first request created.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ID of the management account that accepts or rejects the environment account connection. You create an manage the Proton environment in
        /// this account. If the management account accepts the environment account connection, Proton can use the associated IAM role to provision
        /// environment infrastructure resources in the associated environment account.</p>
        pub fn management_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.management_account_id(inp);
            self
        }
        /// <p>The ID of the management account that accepts or rejects the environment account connection. You create an manage the Proton environment in
        /// this account. If the management account accepts the environment account connection, Proton can use the associated IAM role to provision
        /// environment infrastructure resources in the associated environment account.</p>
        pub fn set_management_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_management_account_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. Proton uses this role to provision
        /// infrastructure resources in the associated environment account.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that's created in the environment account. Proton uses this role to provision
        /// infrastructure resources in the associated environment account.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the Proton environment that's created in the associated management account.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The name of the Proton environment that's created in the associated management account.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags for your environment account connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton resources and tagging</a> in the <i>Proton Administrator
        /// Guide</i>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags for your environment account connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton resources and tagging</a> in the <i>Proton Administrator
        /// Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironmentTemplate`.
    ///
    /// <p>Create an environment template for Proton. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>Proton Administrator Guide</i>.</p>
    /// <p>You can create an environment template in one of the two following ways:</p>
    /// <ul>
    /// <li>
    /// <p>Register and publish a <i>standard</i> environment template that instructs Proton to deploy and manage environment
    /// infrastructure.</p>
    /// </li>
    /// <li>
    /// <p>Register and publish a <i>customer managed</i> environment template that connects Proton to your existing provisioned
    /// infrastructure that you manage. Proton <i>doesn't</i> manage your existing provisioned infrastructure. To create an environment
    /// template for customer provisioned and managed infrastructure, include the <code>provisioning</code> parameter and set the value to
    /// <code>CUSTOMER_MANAGED</code>. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/template-create.html">Register and publish an environment template</a> in the <i>Proton Administrator Guide</i>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateEnvironmentTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_template_input::Builder,
    }
    impl<C, M, R> CreateEnvironmentTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentTemplateInputOperationOutputAlias,
                crate::output::CreateEnvironmentTemplateOutput,
                crate::error::CreateEnvironmentTemplateError,
                crate::input::CreateEnvironmentTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment template.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The environment template name as displayed in the developer interface.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The environment template name as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A customer provided encryption key that Proton uses to encrypt data.</p>
        pub fn encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>A customer provided encryption key that Proton uses to encrypt data.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn provisioning(mut self, inp: crate::model::Provisioning) -> Self {
            self.inner = self.inner.provisioning(inp);
            self
        }
        /// <p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>
        pub fn set_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.inner = self.inner.set_provisioning(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your environment template. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for your environment template. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEnvironmentTemplateVersion`.
    ///
    /// <p>Create a new major or minor version of an environment template. A major version of an environment template is a version that
    /// <i>isn't</i> backwards compatible. A minor version of an environment template is a version that's backwards compatible within its
    /// major version.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEnvironmentTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_environment_template_version_input::Builder,
    }
    impl<C, M, R> CreateEnvironmentTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEnvironmentTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEnvironmentTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEnvironmentTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEnvironmentTemplateVersionInputOperationOutputAlias,
                crate::output::CreateEnvironmentTemplateVersionOutput,
                crate::error::CreateEnvironmentTemplateVersionError,
                crate::input::CreateEnvironmentTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When included, if two identical requests are made with the same client token, Proton returns the environment template version that the
        /// first request created.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>When included, if two identical requests are made with the same client token, Proton returns the environment template version that the
        /// first request created.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A description of the new version of an environment template.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the new version of an environment template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>To create a new minor version of the environment template, include a <code>major Version</code>.</p>
        /// <p>To create a new major and minor version of the environment template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To create a new minor version of the environment template, include a <code>major Version</code>.</p>
        /// <p>To create a new major and minor version of the environment template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of an template.</p>
        pub fn source(mut self, inp: crate::model::TemplateVersionSourceInput) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of an template.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionSourceInput>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for a new version of an environment template.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for a new version of an environment template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p>Create and register a link to a repository that can be used with pull request provisioning or template sync configurations. For more
    /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Template bundles</a> and <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html">Template sync configurations</a> in the <i>Proton
    /// Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl<C, M, R> CreateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRepositoryInputOperationOutputAlias,
                crate::output::CreateRepositoryOutput,
                crate::error::CreateRepositoryError,
                crate::input::CreateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository provider.</p>
        pub fn provider(mut self, inp: crate::model::RepositoryProvider) -> Self {
            self.inner = self.inner.provider(inp);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The repository name, for example <code>myrepos/myrepo</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The repository name, for example <code>myrepos/myrepo</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection. For more information, see <a href="https://docs.aws.amazon.com/setting-up-for-service">Setting up for Proton</a> in the <i>Proton Administrator Guide</i>.</p>
        pub fn connection_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection. For more information, see <a href="https://docs.aws.amazon.com/setting-up-for-service">Setting up for Proton</a> in the <i>Proton Administrator Guide</i>.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
        /// <p>The ARN of your customer Amazon Web Services Key Management Service (Amazon Web Services KMS) key.</p>
        pub fn encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>The ARN of your customer Amazon Web Services Key Management Service (Amazon Web Services KMS) key.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateService`.
    ///
    /// <p>Create an Proton service. An Proton service is an instantiation of a service template and often includes several service instances and
    /// pipeline. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html">Services</a> in the
    /// <i>Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-service.html">Services</a>
    /// in the <i>Proton User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_input::Builder,
    }
    impl<C, M, R> CreateService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceInputOperationOutputAlias,
                crate::output::CreateServiceOutput,
                crate::error::CreateServiceError,
                crate::input::CreateServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The service name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the Proton service.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the Proton service.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the service template that's used to create the service.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the service template that's used to create the service.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The major version of the service template that was used to create the service.</p>
        pub fn template_major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_major_version(inp);
            self
        }
        /// <p>The major version of the service template that was used to create the service.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_major_version(input);
            self
        }
        /// <p>The minor version of the service template that was used to create the service.</p>
        pub fn template_minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_minor_version(inp);
            self
        }
        /// <p>The minor version of the service template that was used to create the service.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_minor_version(input);
            self
        }
        /// <p>A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. Don’t
        /// include pipeline inputs in the spec if your service template <i>doesn’t</i> include a service pipeline. For more information, see
        /// <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html">Create a service</a> in the <i>Proton
        /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html">Create a service</a> in the
        /// <i>Proton User Guide</i>.</p>
        pub fn spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. Don’t
        /// include pipeline inputs in the spec if your service template <i>doesn’t</i> include a service pipeline. For more information, see
        /// <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html">Create a service</a> in the <i>Proton
        /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html">Create a service</a> in the
        /// <i>Proton User Guide</i>.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up repository connection</a> in the <i>Proton
        /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
        /// with Proton</a> in the <i>Proton User Guide</i>. <i>Don't</i> include this parameter if your service
        /// template <i>doesn't</i> include a service pipeline.</p>
        pub fn repository_connection_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_connection_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up repository connection</a> in the <i>Proton
        /// Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up
        /// with Proton</a> in the <i>Proton User Guide</i>. <i>Don't</i> include this parameter if your service
        /// template <i>doesn't</i> include a service pipeline.</p>
        pub fn set_repository_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_connection_arn(input);
            self
        }
        /// <p>The ID of the code repository. <i>Don't</i> include this parameter if your service template <i>doesn't</i> include
        /// a service pipeline.</p>
        pub fn repository_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_id(inp);
            self
        }
        /// <p>The ID of the code repository. <i>Don't</i> include this parameter if your service template <i>doesn't</i> include
        /// a service pipeline.</p>
        pub fn set_repository_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_id(input);
            self
        }
        /// <p>The name of the code repository branch that holds the code that's deployed in Proton. <i>Don't</i> include this parameter if
        /// your service template <i>doesn't</i> include a service pipeline.</p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p>The name of the code repository branch that holds the code that's deployed in Proton. <i>Don't</i> include this parameter if
        /// your service template <i>doesn't</i> include a service pipeline.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your service. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for your service. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceTemplate`.
    ///
    /// <p>Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CICD service
    /// pipeline. Developers, in turn, select the service template from Proton. If the selected service template includes a service pipeline definition,
    /// they provide a link to their source code repository. Proton then deploys and manages the infrastructure defined by the selected service
    /// template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html">Service
    /// Templates</a> in the <i>Proton Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateServiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_template_input::Builder,
    }
    impl<C, M, R> CreateServiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateServiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceTemplateInputOperationOutputAlias,
                crate::output::CreateServiceTemplateOutput,
                crate::error::CreateServiceTemplateError,
                crate::input::CreateServiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service template.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the service template as displayed in the developer interface.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name of the service template as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>A description of the service template.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A customer provided encryption key that's used to encrypt data.</p>
        pub fn encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>A customer provided encryption key that's used to encrypt data.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// <p>Proton includes a service pipeline for your service by default. When included, this parameter indicates that an Proton service pipeline
        /// <i>won't</i> be included for your service. Once specified, this parameter <i>can't</i> be changed. For more
        /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Service template bundles</a> in the
        /// <i>Proton Administrator Guide</i>.</p>
        pub fn pipeline_provisioning(mut self, inp: crate::model::Provisioning) -> Self {
            self.inner = self.inner.pipeline_provisioning(inp);
            self
        }
        /// <p>Proton includes a service pipeline for your service by default. When included, this parameter indicates that an Proton service pipeline
        /// <i>won't</i> be included for your service. Once specified, this parameter <i>can't</i> be changed. For more
        /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Service template bundles</a> in the
        /// <i>Proton Administrator Guide</i>.</p>
        pub fn set_pipeline_provisioning(
            mut self,
            input: std::option::Option<crate::model::Provisioning>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_provisioning(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for your service template. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for your service template. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceTemplateVersion`.
    ///
    /// <p>Create a new major or minor version of a service template. A major version of a service template is a version that <i>isn't</i>
    /// backward compatible. A minor version of a service template is a version that's backward compatible within its major version.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateServiceTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_template_version_input::Builder,
    }
    impl<C, M, R> CreateServiceTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateServiceTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceTemplateVersionInputOperationOutputAlias,
                crate::output::CreateServiceTemplateVersionOutput,
                crate::error::CreateServiceTemplateVersionError,
                crate::input::CreateServiceTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When included, if two identical requests are made with the same client token, Proton returns the service template version that the first
        /// request created.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>When included, if two identical requests are made with the same client token, Proton returns the service template version that the first
        /// request created.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A description of the new version of a service template.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the new version of a service template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>To create a new minor version of the service template, include a <code>major Version</code>.</p>
        /// <p>To create a new major and minor version of the service template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To create a new minor version of the service template, include a <code>major Version</code>.</p>
        /// <p>To create a new major and minor version of the service template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of a service template.</p>
        pub fn source(mut self, inp: crate::model::TemplateVersionSourceInput) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>An object that includes the template bundle S3 bucket path and name for the new version of a service template.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionSourceInput>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `compatibleEnvironmentTemplates`.
        ///
        /// To override the contents of this collection use [`set_compatible_environment_templates`](Self::set_compatible_environment_templates).
        ///
        /// <p>An array of compatible environment template objects for the new version of a service template.</p>
        pub fn compatible_environment_templates(
            mut self,
            inp: impl Into<crate::model::CompatibleEnvironmentTemplateInput>,
        ) -> Self {
            self.inner = self.inner.compatible_environment_templates(inp);
            self
        }
        /// <p>An array of compatible environment template objects for the new version of a service template.</p>
        pub fn set_compatible_environment_templates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>,
            >,
        ) -> Self {
            self.inner = self.inner.set_compatible_environment_templates(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for a new version of a service template.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for a new version of a service template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTemplateSyncConfig`.
    ///
    /// <p>Set up a template for automated template version creation. When a commit is pushed to your registered <a href="https://docs.aws.amazon.com/proton/latest/APIReference/API_Repository.html">repository</a>, Proton checks for changes to your repository template bundles. If it
    /// detects a template bundle change, a new minor or major version of its template is created, if the version doesn’t already exist. For more
    /// information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html">Template sync configurations</a> in
    /// the <i>Proton Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTemplateSyncConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_template_sync_config_input::Builder,
    }
    impl<C, M, R> CreateTemplateSyncConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTemplateSyncConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTemplateSyncConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTemplateSyncConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTemplateSyncConfigInputOperationOutputAlias,
                crate::output::CreateTemplateSyncConfigOutput,
                crate::error::CreateTemplateSyncConfigError,
                crate::input::CreateTemplateSyncConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your registered template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of your registered template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The type of the registered template.</p>
        pub fn template_type(mut self, inp: crate::model::TemplateType) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The type of the registered template.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
        /// <p>The provider type for your repository.</p>
        pub fn repository_provider(mut self, inp: crate::model::RepositoryProvider) -> Self {
            self.inner = self.inner.repository_provider(inp);
            self
        }
        /// <p>The provider type for your repository.</p>
        pub fn set_repository_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.inner = self.inner.set_repository_provider(input);
            self
        }
        /// <p>The name of your repository, for example <code>myrepos/myrepo</code>.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of your repository, for example <code>myrepos/myrepo</code>.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch of the registered repository for your template.</p>
        pub fn branch(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch(inp);
            self
        }
        /// <p>The branch of the registered repository for your template.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch(input);
            self
        }
        /// <p>A repository subdirectory path to your template bundle directory. When included, Proton limits the template bundle search to this
        /// repository directory.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>A repository subdirectory path to your template bundle directory. When included, Proton limits the template bundle search to this
        /// repository directory.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironment`.
    ///
    /// <p>Delete an environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_input::Builder,
    }
    impl<C, M, R> DeleteEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentInputOperationOutputAlias,
                crate::output::DeleteEnvironmentOutput,
                crate::error::DeleteEnvironmentError,
                crate::input::DeleteEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironmentAccountConnection`.
    ///
    /// <p>In an environment account, delete an environment account connection.</p>
    /// <p>After you delete an environment account connection that’s in use by an Proton environment, Proton <i>can’t</i> manage the
    /// environment infrastructure resources until a new environment account connection is accepted for the environment account and associated environment.
    /// You're responsible for cleaning up provisioned resources that remain without an environment connection.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account
    /// connections</a> in the <i>Proton Administrator guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEnvironmentAccountConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_account_connection_input::Builder,
    }
    impl<C, M, R> DeleteEnvironmentAccountConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironmentAccountConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentAccountConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteEnvironmentAccountConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentAccountConnectionInputOperationOutputAlias,
                crate::output::DeleteEnvironmentAccountConnectionOutput,
                crate::error::DeleteEnvironmentAccountConnectionError,
                crate::input::DeleteEnvironmentAccountConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment account connection to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the environment account connection to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironmentTemplate`.
    ///
    /// <p>If no other major or minor versions of an environment template exist, delete the environment template.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEnvironmentTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_template_input::Builder,
    }
    impl<C, M, R> DeleteEnvironmentTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentTemplateInputOperationOutputAlias,
                crate::output::DeleteEnvironmentTemplateOutput,
                crate::error::DeleteEnvironmentTemplateError,
                crate::input::DeleteEnvironmentTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment template to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment template to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEnvironmentTemplateVersion`.
    ///
    /// <p>If no other minor versions of an environment template exist, delete a major version of the environment template if it's not the
    /// <code>Recommended</code> version. Delete the <code>Recommended</code> version of the environment template if no other major versions or minor
    /// versions of the environment template exist. A major version of an environment template is a version that's not backward compatible.</p>
    /// <p>Delete a minor version of an environment template if it <i>isn't</i> the <code>Recommended</code> version. Delete a
    /// <code>Recommended</code> minor version of the environment template if no other minor versions of the environment template exist. A minor version
    /// of an environment template is a version that's backward compatible.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEnvironmentTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_environment_template_version_input::Builder,
    }
    impl<C, M, R> DeleteEnvironmentTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEnvironmentTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEnvironmentTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEnvironmentTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEnvironmentTemplateVersionInputOperationOutputAlias,
                crate::output::DeleteEnvironmentTemplateVersionOutput,
                crate::error::DeleteEnvironmentTemplateVersionError,
                crate::input::DeleteEnvironmentTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The environment template major version to delete.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>The environment template major version to delete.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>The environment template minor version to delete.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>The environment template minor version to delete.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p>De-register and unlink your repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl<C, M, R> DeleteRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryInputOperationOutputAlias,
                crate::output::DeleteRepositoryOutput,
                crate::error::DeleteRepositoryError,
                crate::input::DeleteRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository provider.</p>
        pub fn provider(mut self, inp: crate::model::RepositoryProvider) -> Self {
            self.inner = self.inner.provider(inp);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteService`.
    ///
    /// <p>Delete a service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_input::Builder,
    }
    impl<C, M, R> DeleteService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceInputOperationOutputAlias,
                crate::output::DeleteServiceOutput,
                crate::error::DeleteServiceError,
                crate::input::DeleteServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceTemplate`.
    ///
    /// <p>If no other major or minor versions of the service template exist, delete the service template.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_template_input::Builder,
    }
    impl<C, M, R> DeleteServiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceTemplateInputOperationOutputAlias,
                crate::output::DeleteServiceTemplateOutput,
                crate::error::DeleteServiceTemplateError,
                crate::input::DeleteServiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service template to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service template to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceTemplateVersion`.
    ///
    /// <p>If no other minor versions of a service template exist, delete a major version of the service template if it's not the
    /// <code>Recommended</code> version. Delete the <code>Recommended</code> version of the service template if no other major versions or minor versions
    /// of the service template exist. A major version of a service template is a version that <i>isn't</i> backwards compatible.</p>
    /// <p>Delete a minor version of a service template if it's not the <code>Recommended</code> version. Delete a <code>Recommended</code> minor version
    /// of the service template if no other minor versions of the service template exist. A minor version of a service template is a version that's
    /// backwards compatible.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServiceTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_template_version_input::Builder,
    }
    impl<C, M, R> DeleteServiceTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceTemplateVersionInputOperationOutputAlias,
                crate::output::DeleteServiceTemplateVersionOutput,
                crate::error::DeleteServiceTemplateVersionError,
                crate::input::DeleteServiceTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The service template major version to delete.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>The service template major version to delete.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>The service template minor version to delete.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>The service template minor version to delete.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTemplateSyncConfig`.
    ///
    /// <p>Delete a template sync configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTemplateSyncConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_template_sync_config_input::Builder,
    }
    impl<C, M, R> DeleteTemplateSyncConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTemplateSyncConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTemplateSyncConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTemplateSyncConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTemplateSyncConfigInputOperationOutputAlias,
                crate::output::DeleteTemplateSyncConfigOutput,
                crate::error::DeleteTemplateSyncConfigError,
                crate::input::DeleteTemplateSyncConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The template name.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The template type.</p>
        pub fn template_type(mut self, inp: crate::model::TemplateType) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The template type.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSettings`.
    ///
    /// <p>Get detail data for the Proton pipeline service role.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_settings_input::Builder,
    }
    impl<C, M, R> GetAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountSettingsInputOperationOutputAlias,
                crate::output::GetAccountSettingsOutput,
                crate::error::GetAccountSettingsError,
                crate::input::GetAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetEnvironment`.
    ///
    /// <p>Get detail data for an environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_environment_input::Builder,
    }
    impl<C, M, R> GetEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEnvironmentInputOperationOutputAlias,
                crate::output::GetEnvironmentOutput,
                crate::error::GetEnvironmentError,
                crate::input::GetEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment that you want to get the detail data for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEnvironmentAccountConnection`.
    ///
    /// <p>In an environment account, view the detail data for an environment account connection.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account
    /// connections</a> in the <i>Proton Administrator guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEnvironmentAccountConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_environment_account_connection_input::Builder,
    }
    impl<C, M, R> GetEnvironmentAccountConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEnvironmentAccountConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnvironmentAccountConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnvironmentAccountConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEnvironmentAccountConnectionInputOperationOutputAlias,
                crate::output::GetEnvironmentAccountConnectionOutput,
                crate::error::GetEnvironmentAccountConnectionError,
                crate::input::GetEnvironmentAccountConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the environment account connection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEnvironmentTemplate`.
    ///
    /// <p>Get detail data for an environment template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEnvironmentTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_environment_template_input::Builder,
    }
    impl<C, M, R> GetEnvironmentTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEnvironmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnvironmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnvironmentTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEnvironmentTemplateInputOperationOutputAlias,
                crate::output::GetEnvironmentTemplateOutput,
                crate::error::GetEnvironmentTemplateError,
                crate::input::GetEnvironmentTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment template that you want to get the detail data for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment template that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEnvironmentTemplateVersion`.
    ///
    /// <p>View detail data for a major or minor version of an environment template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEnvironmentTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_environment_template_version_input::Builder,
    }
    impl<C, M, R> GetEnvironmentTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEnvironmentTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEnvironmentTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEnvironmentTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEnvironmentTemplateVersionInputOperationOutputAlias,
                crate::output::GetEnvironmentTemplateVersionOutput,
                crate::error::GetEnvironmentTemplateVersionError,
                crate::input::GetEnvironmentTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>To view environment template major version detail data, include <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To view environment template major version detail data, include <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>To view environment template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>To view environment template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepository`.
    ///
    /// <p>Get detail data for a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_input::Builder,
    }
    impl<C, M, R> GetRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryInputOperationOutputAlias,
                crate::output::GetRepositoryOutput,
                crate::error::GetRepositoryError,
                crate::input::GetRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository provider.</p>
        pub fn provider(mut self, inp: crate::model::RepositoryProvider) -> Self {
            self.inner = self.inner.provider(inp);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.inner = self.inner.set_provider(input);
            self
        }
        /// <p>The repository name, for example <code>myrepos/myrepo</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The repository name, for example <code>myrepos/myrepo</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositorySyncStatus`.
    ///
    /// <p>Get the repository sync status.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRepositorySyncStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_sync_status_input::Builder,
    }
    impl<C, M, R> GetRepositorySyncStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositorySyncStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositorySyncStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositorySyncStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositorySyncStatusInputOperationOutputAlias,
                crate::output::GetRepositorySyncStatusOutput,
                crate::error::GetRepositorySyncStatusError,
                crate::input::GetRepositorySyncStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository name.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository name.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn repository_provider(mut self, inp: crate::model::RepositoryProvider) -> Self {
            self.inner = self.inner.repository_provider(inp);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_repository_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.inner = self.inner.set_repository_provider(input);
            self
        }
        /// <p>The repository branch.</p>
        pub fn branch(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch(inp);
            self
        }
        /// <p>The repository branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch(input);
            self
        }
        /// <p>The repository sync type.</p>
        pub fn sync_type(mut self, inp: crate::model::SyncType) -> Self {
            self.inner = self.inner.sync_type(inp);
            self
        }
        /// <p>The repository sync type.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<crate::model::SyncType>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetService`.
    ///
    /// <p>Get detail data for a service.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_input::Builder,
    }
    impl<C, M, R> GetService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceInputOperationOutputAlias,
                crate::output::GetServiceOutput,
                crate::error::GetServiceError,
                crate::input::GetServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service that you want to get the detail data for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceInstance`.
    ///
    /// <p>Get detail data for a service instance. A service instance is an instantiation of service template, which is running in a specific
    /// environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_instance_input::Builder,
    }
    impl<C, M, R> GetServiceInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceInstanceInputOperationOutputAlias,
                crate::output::GetServiceInstanceOutput,
                crate::error::GetServiceInstanceError,
                crate::input::GetServiceInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a service instance that you want to get the detail data for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of a service instance that you want to get the detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceTemplate`.
    ///
    /// <p>Get detail data for a service template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_template_input::Builder,
    }
    impl<C, M, R> GetServiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceTemplateInputOperationOutputAlias,
                crate::output::GetServiceTemplateOutput,
                crate::error::GetServiceTemplateError,
                crate::input::GetServiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service template that you want to get detail data for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service template that you want to get detail data for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceTemplateVersion`.
    ///
    /// <p>View detail data for a major or minor version of a service template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_template_version_input::Builder,
    }
    impl<C, M, R> GetServiceTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceTemplateVersionInputOperationOutputAlias,
                crate::output::GetServiceTemplateVersionOutput,
                crate::error::GetServiceTemplateVersionError,
                crate::input::GetServiceTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>To view service template major version detail data, include <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To view service template major version detail data, include <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>To view service template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>To view service template minor version detail data, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTemplateSyncConfig`.
    ///
    /// <p>Get detail data for a template sync configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTemplateSyncConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_template_sync_config_input::Builder,
    }
    impl<C, M, R> GetTemplateSyncConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTemplateSyncConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemplateSyncConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTemplateSyncConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTemplateSyncConfigInputOperationOutputAlias,
                crate::output::GetTemplateSyncConfigOutput,
                crate::error::GetTemplateSyncConfigError,
                crate::input::GetTemplateSyncConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The template name.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The template type.</p>
        pub fn template_type(mut self, inp: crate::model::TemplateType) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The template type.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTemplateSyncStatus`.
    ///
    /// <p>Get the status of a template sync.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTemplateSyncStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_template_sync_status_input::Builder,
    }
    impl<C, M, R> GetTemplateSyncStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTemplateSyncStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemplateSyncStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTemplateSyncStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTemplateSyncStatusInputOperationOutputAlias,
                crate::output::GetTemplateSyncStatusOutput,
                crate::error::GetTemplateSyncStatusError,
                crate::input::GetTemplateSyncStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The template name.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The template type.</p>
        pub fn template_type(mut self, inp: crate::model::TemplateType) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The template type.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
        /// <p>The template version.</p>
        pub fn template_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_version(inp);
            self
        }
        /// <p>The template version.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironmentAccountConnections`.
    ///
    /// <p>View a list of environment account connections.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account
    /// connections</a> in the <i>Proton Administrator guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEnvironmentAccountConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environment_account_connections_input::Builder,
    }
    impl<C, M, R> ListEnvironmentAccountConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironmentAccountConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentAccountConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentAccountConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentAccountConnectionsInputOperationOutputAlias,
                crate::output::ListEnvironmentAccountConnectionsOutput,
                crate::error::ListEnvironmentAccountConnectionsError,
                crate::input::ListEnvironmentAccountConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of account making the <code>ListEnvironmentAccountConnections</code> request.</p>
        pub fn requested_by(
            mut self,
            inp: crate::model::EnvironmentAccountConnectionRequesterAccountType,
        ) -> Self {
            self.inner = self.inner.requested_by(inp);
            self
        }
        /// <p>The type of account making the <code>ListEnvironmentAccountConnections</code> request.</p>
        pub fn set_requested_by(
            mut self,
            input: std::option::Option<
                crate::model::EnvironmentAccountConnectionRequesterAccountType,
            >,
        ) -> Self {
            self.inner = self.inner.set_requested_by(input);
            self
        }
        /// <p>The environment name that's associated with each listed environment account connection.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The environment name that's associated with each listed environment account connection.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p>The status details for each listed environment account connection.</p>
        pub fn statuses(
            mut self,
            inp: impl Into<crate::model::EnvironmentAccountConnectionStatus>,
        ) -> Self {
            self.inner = self.inner.statuses(inp);
            self
        }
        /// <p>The status details for each listed environment account connection.</p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::EnvironmentAccountConnectionStatus>,
            >,
        ) -> Self {
            self.inner = self.inner.set_statuses(input);
            self
        }
        /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the list of
        /// environment account connections that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the list of
        /// environment account connections that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of environment account connections to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of environment account connections to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironmentOutputs`.
    ///
    /// <p>List the infrastructure as code outputs for your environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEnvironmentOutputs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environment_outputs_input::Builder,
    }
    impl<C, M, R> ListEnvironmentOutputs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironmentOutputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentOutputsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentOutputsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentOutputsInputOperationOutputAlias,
                crate::output::ListEnvironmentOutputsOutput,
                crate::error::ListEnvironmentOutputsError,
                crate::input::ListEnvironmentOutputsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The environment name.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The environment name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>A token to indicate the location of the next environment output in the array of environment outputs, after the list of environment outputs
        /// that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next environment output in the array of environment outputs, after the list of environment outputs
        /// that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironmentProvisionedResources`.
    ///
    /// <p>List the provisioned resources for your environment.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEnvironmentProvisionedResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environment_provisioned_resources_input::Builder,
    }
    impl<C, M, R> ListEnvironmentProvisionedResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironmentProvisionedResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentProvisionedResourcesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListEnvironmentProvisionedResourcesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentProvisionedResourcesInputOperationOutputAlias,
                crate::output::ListEnvironmentProvisionedResourcesOutput,
                crate::error::ListEnvironmentProvisionedResourcesError,
                crate::input::ListEnvironmentProvisionedResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The environment name.</p>
        pub fn environment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.environment_name(inp);
            self
        }
        /// <p>The environment name.</p>
        pub fn set_environment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_name(input);
            self
        }
        /// <p>A token to indicate the location of the next environment provisioned resource in the array of environment provisioned resources, after the
        /// list of environment provisioned resources that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next environment provisioned resource in the array of environment provisioned resources, after the
        /// list of environment provisioned resources that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironments`.
    ///
    /// <p>List environments with detail data summaries.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEnvironments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environments_input::Builder,
    }
    impl<C, M, R> ListEnvironments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentsInputOperationOutputAlias,
                crate::output::ListEnvironmentsOutput,
                crate::error::ListEnvironmentsError,
                crate::input::ListEnvironmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token to indicate the location of the next environment in the array of environments, after the list of environments that was previously
        /// requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next environment in the array of environments, after the list of environments that was previously
        /// requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of environments to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of environments to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `environmentTemplates`.
        ///
        /// To override the contents of this collection use [`set_environment_templates`](Self::set_environment_templates).
        ///
        /// <p>An array of the versions of the environment template.</p>
        pub fn environment_templates(
            mut self,
            inp: impl Into<crate::model::EnvironmentTemplateFilter>,
        ) -> Self {
            self.inner = self.inner.environment_templates(inp);
            self
        }
        /// <p>An array of the versions of the environment template.</p>
        pub fn set_environment_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_environment_templates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironmentTemplates`.
    ///
    /// <p>List environment templates.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEnvironmentTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environment_templates_input::Builder,
    }
    impl<C, M, R> ListEnvironmentTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironmentTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentTemplatesInputOperationOutputAlias,
                crate::output::ListEnvironmentTemplatesOutput,
                crate::error::ListEnvironmentTemplatesError,
                crate::input::ListEnvironmentTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the list of environment
        /// templates that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the list of environment
        /// templates that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of environment templates to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of environment templates to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEnvironmentTemplateVersions`.
    ///
    /// <p>List major or minor versions of an environment template with detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEnvironmentTemplateVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_environment_template_versions_input::Builder,
    }
    impl<C, M, R> ListEnvironmentTemplateVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEnvironmentTemplateVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEnvironmentTemplateVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEnvironmentTemplateVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEnvironmentTemplateVersionsInputOperationOutputAlias,
                crate::output::ListEnvironmentTemplateVersionsOutput,
                crate::error::ListEnvironmentTemplateVersionsError,
                crate::input::ListEnvironmentTemplateVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template, after
        /// the list of major or minor versions that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template, after
        /// the list of major or minor versions that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of major or minor versions of an environment template to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of major or minor versions of an environment template to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>To view a list of minor of versions under a major version of an environment template, include <code>major Version</code>.</p>
        /// <p>To view a list of major versions of an environment template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To view a list of minor of versions under a major version of an environment template, include <code>major Version</code>.</p>
        /// <p>To view a list of major versions of an environment template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositories`.
    ///
    /// <p>List repositories with detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repositories_input::Builder,
    }
    impl<C, M, R> ListRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoriesInputOperationOutputAlias,
                crate::output::ListRepositoriesOutput,
                crate::error::ListRepositoriesError,
                crate::input::ListRepositoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token to indicate the location of the next repository in the array of repositories, after the list of repositories previously
        /// requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next repository in the array of repositories, after the list of repositories previously
        /// requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repositories to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repositories to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositorySyncDefinitions`.
    ///
    /// <p>List repository sync definitions with detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRepositorySyncDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repository_sync_definitions_input::Builder,
    }
    impl<C, M, R> ListRepositorySyncDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositorySyncDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositorySyncDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositorySyncDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositorySyncDefinitionsInputOperationOutputAlias,
                crate::output::ListRepositorySyncDefinitionsOutput,
                crate::error::ListRepositorySyncDefinitionsError,
                crate::input::ListRepositorySyncDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository name.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository name.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn repository_provider(mut self, inp: crate::model::RepositoryProvider) -> Self {
            self.inner = self.inner.repository_provider(inp);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_repository_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.inner = self.inner.set_repository_provider(input);
            self
        }
        /// <p>The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.</p>
        pub fn sync_type(mut self, inp: crate::model::SyncType) -> Self {
            self.inner = self.inner.sync_type(inp);
            self
        }
        /// <p>The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<crate::model::SyncType>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
        /// <p>A token to indicate the location of the next repository sync definition in the array of repository sync definitions, after the list of
        /// repository sync definitions previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next repository sync definition in the array of repository sync definitions, after the list of
        /// repository sync definitions previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceInstanceOutputs`.
    ///
    /// <p>View a list service instance infrastructure as code outputs with detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceInstanceOutputs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_instance_outputs_input::Builder,
    }
    impl<C, M, R> ListServiceInstanceOutputs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceInstanceOutputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceInstanceOutputsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceInstanceOutputsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceInstanceOutputsInputOperationOutputAlias,
                crate::output::ListServiceInstanceOutputsOutput,
                crate::error::ListServiceInstanceOutputsError,
                crate::input::ListServiceInstanceOutputsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service instance name.</p>
        pub fn service_instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_instance_name(inp);
            self
        }
        /// <p>The service instance name.</p>
        pub fn set_service_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_instance_name(input);
            self
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>A token to indicate the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceInstanceProvisionedResources`.
    ///
    /// <p>List provisioned resources for a service instance with details.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceInstanceProvisionedResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_instance_provisioned_resources_input::Builder,
    }
    impl<C, M, R> ListServiceInstanceProvisionedResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceInstanceProvisionedResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceInstanceProvisionedResourcesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListServiceInstanceProvisionedResourcesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceInstanceProvisionedResourcesInputOperationOutputAlias,
                crate::output::ListServiceInstanceProvisionedResourcesOutput,
                crate::error::ListServiceInstanceProvisionedResourcesError,
                crate::input::ListServiceInstanceProvisionedResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The service instance name.</p>
        pub fn service_instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_instance_name(inp);
            self
        }
        /// <p>The service instance name.</p>
        pub fn set_service_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_instance_name(input);
            self
        }
        /// <p>A token to indicate the location of the next provisioned resource in the array of provisioned resources, after the list of provisioned
        /// resources that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next provisioned resource in the array of provisioned resources, after the list of provisioned
        /// resources that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceInstances`.
    ///
    /// <p>List service instances with summaries of detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_instances_input::Builder,
    }
    impl<C, M, R> ListServiceInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceInstancesInputOperationOutputAlias,
                crate::output::ListServiceInstancesOutput,
                crate::error::ListServiceInstancesError,
                crate::input::ListServiceInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>A token to indicate the location of the next service in the array of service instances, after the list of service instances that was
        /// previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next service in the array of service instances, after the list of service instances that was
        /// previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of service instances to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of service instances to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServicePipelineOutputs`.
    ///
    /// <p>View a list service pipeline infrastructure as code outputs with detail.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServicePipelineOutputs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_pipeline_outputs_input::Builder,
    }
    impl<C, M, R> ListServicePipelineOutputs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServicePipelineOutputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicePipelineOutputsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicePipelineOutputsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServicePipelineOutputsInputOperationOutputAlias,
                crate::output::ListServicePipelineOutputsOutput,
                crate::error::ListServicePipelineOutputsError,
                crate::input::ListServicePipelineOutputsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>A token to indicate the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServicePipelineProvisionedResources`.
    ///
    /// <p>List provisioned resources for a service and pipeline with details.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServicePipelineProvisionedResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_pipeline_provisioned_resources_input::Builder,
    }
    impl<C, M, R> ListServicePipelineProvisionedResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServicePipelineProvisionedResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicePipelineProvisionedResourcesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListServicePipelineProvisionedResourcesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServicePipelineProvisionedResourcesInputOperationOutputAlias,
                crate::output::ListServicePipelineProvisionedResourcesOutput,
                crate::error::ListServicePipelineProvisionedResourcesError,
                crate::input::ListServicePipelineProvisionedResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>A token to indicate the location of the next provisioned resource in the array of provisioned resources, after the list of provisioned
        /// resources that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next provisioned resource in the array of provisioned resources, after the list of provisioned
        /// resources that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServices`.
    ///
    /// <p>List services with summaries of detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_services_input::Builder,
    }
    impl<C, M, R> ListServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServicesInputOperationOutputAlias,
                crate::output::ListServicesOutput,
                crate::error::ListServicesError,
                crate::input::ListServicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token to indicate the location of the next service in the array of services, after the list of services that was previously
        /// requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next service in the array of services, after the list of services that was previously
        /// requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of services to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of services to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceTemplates`.
    ///
    /// <p>List service templates with detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_templates_input::Builder,
    }
    impl<C, M, R> ListServiceTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceTemplatesInputOperationOutputAlias,
                crate::output::ListServiceTemplatesOutput,
                crate::error::ListServiceTemplatesError,
                crate::input::ListServiceTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token to indicate the location of the next service template in the array of service templates, after the list of service templates
        /// previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next service template in the array of service templates, after the list of service templates
        /// previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of service templates to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of service templates to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceTemplateVersions`.
    ///
    /// <p>List major or minor versions of a service template with detail data.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceTemplateVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_template_versions_input::Builder,
    }
    impl<C, M, R> ListServiceTemplateVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceTemplateVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceTemplateVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceTemplateVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceTemplateVersionsInputOperationOutputAlias,
                crate::output::ListServiceTemplateVersionsOutput,
                crate::error::ListServiceTemplateVersionsError,
                crate::input::ListServiceTemplateVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after the
        /// list of major or minor versions that was previously requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after the
        /// list of major or minor versions that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of major or minor versions of a service template to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of major or minor versions of a service template to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>To view a list of minor of versions under a major version of a service template, include <code>major Version</code>.</p>
        /// <p>To view a list of major versions of a service template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To view a list of minor of versions under a major version of a service template, include <code>major Version</code>.</p>
        /// <p>To view a list of major versions of a service template, <i>exclude</i>
        /// <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags for a resource. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for the listed tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for the listed tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the list of resource tags that was previously
        /// requested.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the list of resource tags that was previously
        /// requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tags to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of tags to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyResourceDeploymentStatusChange`.
    ///
    /// <p>Notify Proton of status changes to a provisioned resource when you use pull request provisioning. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Template bundles</a>.</p>
    /// <important>
    /// <p>Provisioning by pull request is currently in feature preview and is
    /// only usable with Terraform based Proton Templates. To learn more about
    /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
    /// Previews.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct NotifyResourceDeploymentStatusChange<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::notify_resource_deployment_status_change_input::Builder,
    }
    impl<C, M, R> NotifyResourceDeploymentStatusChange<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `NotifyResourceDeploymentStatusChange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyResourceDeploymentStatusChangeOutput,
            aws_smithy_http::result::SdkError<
                crate::error::NotifyResourceDeploymentStatusChangeError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::NotifyResourceDeploymentStatusChangeInputOperationOutputAlias,
                crate::output::NotifyResourceDeploymentStatusChangeOutput,
                crate::error::NotifyResourceDeploymentStatusChangeError,
                crate::input::NotifyResourceDeploymentStatusChangeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The provisioned resource Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The provisioned resource Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The status of your provisioned resource.</p>
        pub fn status(mut self, inp: crate::model::ResourceDeploymentStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of your provisioned resource.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceDeploymentStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>The provisioned resource state change detail data that's returned by Proton.</p>
        pub fn outputs(mut self, inp: impl Into<crate::model::Output>) -> Self {
            self.inner = self.inner.outputs(inp);
            self
        }
        /// <p>The provisioned resource state change detail data that's returned by Proton.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// <p>The deployment ID for your provisioned resource.</p>
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// <p>The deployment ID for your provisioned resource.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// <p>The deployment status message for your provisioned resource.</p>
        pub fn status_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_message(inp);
            self
        }
        /// <p>The deployment status message for your provisioned resource.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectEnvironmentAccountConnection`.
    ///
    /// <p>In a management account, reject an environment account connection from another environment account.</p>
    /// <p>After you reject an environment account connection request, you <i>won’t</i> be able to accept or use the rejected environment
    /// account connection.</p>
    /// <p>You <i>can’t</i> reject an environment account connection that is connected to an environment.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account
    /// connections</a> in the <i>Proton Administrator guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectEnvironmentAccountConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_environment_account_connection_input::Builder,
    }
    impl<C, M, R> RejectEnvironmentAccountConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectEnvironmentAccountConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectEnvironmentAccountConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RejectEnvironmentAccountConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectEnvironmentAccountConnectionInputOperationOutputAlias,
                crate::output::RejectEnvironmentAccountConnectionOutput,
                crate::error::RejectEnvironmentAccountConnectionError,
                crate::input::RejectEnvironmentAccountConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment account connection to reject.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the environment account connection to reject.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tag a resource. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the resource tag is applied to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the resource tag is applied to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of resource tags to apply to a resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An array of resource tags to apply to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove a tag from a resource. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the tag is to be removed from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the tag is to be removed from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of tag keys indicating the resource tags to be removed from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>An array of tag keys indicating the resource tags to be removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountSettings`.
    ///
    /// <p>Update the Proton service pipeline role or repository settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_settings_input::Builder,
    }
    impl<C, M, R> UpdateAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountSettingsInputOperationOutputAlias,
                crate::output::UpdateAccountSettingsOutput,
                crate::error::UpdateAccountSettingsError,
                crate::input::UpdateAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton pipeline service role.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn pipeline_service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_service_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton pipeline service role.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn set_pipeline_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_service_role_arn(input);
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn pipeline_provisioning_repository(
            mut self,
            inp: crate::model::RepositoryBranchInput,
        ) -> Self {
            self.inner = self.inner.pipeline_provisioning_repository(inp);
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn set_pipeline_provisioning_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryBranchInput>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_provisioning_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironment`.
    ///
    /// <p>Update an environment.</p>
    /// <p>If the environment is associated with an environment account connection, <i>don't</i> update or include the
    /// <code>protonServiceRoleArn</code> and <code>provisioningRepository</code> parameter to update or connect to an environment account
    /// connection.</p>
    /// <p>You can only update to a new environment account connection if it was created in the same environment account that the current environment
    /// account connection was created in and is associated with the current environment.</p>
    /// <p>If the environment <i>isn't</i> associated with an environment account connection, <i>don't</i> update or include
    /// the <code>environmentAccountConnectionId</code> parameter to update or connect to an environment account connection.</p>
    /// <p>You can update either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and value. You can’t
    /// update both.</p>
    /// <p>If the environment was provisioned with pull request provisioning, include the <code>provisioningRepository</code> parameter and omit the
    /// <code>protonServiceRoleArn</code> and <code>environmentAccountConnectionId</code> parameters.</p>
    /// <p>If the environment wasn't provisioned with pull request provisioning, omit the <code>provisioningRepository</code> parameter.</p>
    /// <p>There are four modes for updating an environment as described in the following. The <code>deploymentType</code> field defines the mode.</p>
    /// <dl>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>CURRENT_VERSION</code>
    /// </p>
    /// <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated.
    /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MINOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version
    /// in use, by default. You can also specify a different minor version of the current major version in use.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MAJOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current
    /// template, by default. You can also specify a different major version that's higher than the major version in use and a minor version
    /// (optional).</p>
    /// </dd>
    /// </dl>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEnvironment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_input::Builder,
    }
    impl<C, M, R> UpdateEnvironment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentInputOperationOutputAlias,
                crate::output::UpdateEnvironmentOutput,
                crate::error::UpdateEnvironmentError,
                crate::input::UpdateEnvironmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the environment update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the environment update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The formatted specification that defines the update.</p>
        pub fn spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The formatted specification that defines the update.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>The major version of the environment to update.</p>
        pub fn template_major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_major_version(inp);
            self
        }
        /// <p>The major version of the environment to update.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_major_version(input);
            self
        }
        /// <p>The minor version of the environment to update.</p>
        pub fn template_minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_minor_version(inp);
            self
        }
        /// <p>The minor version of the environment to update.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_minor_version(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other services your behalf.</p>
        pub fn proton_service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proton_service_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other services your behalf.</p>
        pub fn set_proton_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_proton_service_role_arn(input);
            self
        }
        /// <p>There are four modes for updating an environment as described in the following. The <code>deploymentType</code> field defines the mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated.
        /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version
        /// in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current
        /// template, by default. You can also specify a different major version that is higher than the major version in use and a minor version
        /// (optional).</p>
        /// </dd>
        /// </dl>
        pub fn deployment_type(mut self, inp: crate::model::DeploymentUpdateType) -> Self {
            self.inner = self.inner.deployment_type(inp);
            self
        }
        /// <p>There are four modes for updating an environment as described in the following. The <code>deploymentType</code> field defines the mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated.
        /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version
        /// in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current
        /// template, by default. You can also specify a different major version that is higher than the major version in use and a minor version
        /// (optional).</p>
        /// </dd>
        /// </dl>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentUpdateType>,
        ) -> Self {
            self.inner = self.inner.set_deployment_type(input);
            self
        }
        /// <p>The ID of the environment account connection.</p>
        /// <p>You can only update to a new environment account connection if it was created in the same environment account that the current environment
        /// account connection was created in and is associated with the current environment.</p>
        pub fn environment_account_connection_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment_account_connection_id(inp);
            self
        }
        /// <p>The ID of the environment account connection.</p>
        /// <p>You can only update to a new environment account connection if it was created in the same environment account that the current environment
        /// account connection was created in and is associated with the current environment.</p>
        pub fn set_environment_account_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_environment_account_connection_id(input);
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn provisioning_repository(mut self, inp: crate::model::RepositoryBranchInput) -> Self {
            self.inner = self.inner.provisioning_repository(inp);
            self
        }
        /// <p>The repository that you provide with pull request provisioning.</p>
        /// <important>
        /// <p>Provisioning by pull request is currently in feature preview and is
        /// only usable with Terraform based Proton Templates. To learn more about
        /// <a href="https://aws.amazon.com/service-terms">Amazon Web Services Feature Preview terms</a>, see section 2 on Beta and
        /// Previews.</p>
        /// </important>
        pub fn set_provisioning_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryBranchInput>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironmentAccountConnection`.
    ///
    /// <p>In an environment account, update an environment account connection to use a new IAM role.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account
    /// connections</a> in the <i>Proton Administrator guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEnvironmentAccountConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_account_connection_input::Builder,
    }
    impl<C, M, R> UpdateEnvironmentAccountConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironmentAccountConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentAccountConnectionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateEnvironmentAccountConnectionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentAccountConnectionInputOperationOutputAlias,
                crate::output::UpdateEnvironmentAccountConnectionOutput,
                crate::error::UpdateEnvironmentAccountConnectionError,
                crate::input::UpdateEnvironmentAccountConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the environment account connection to update.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the environment account connection to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that is associated with the environment account connection to update.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role that is associated with the environment account connection to update.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironmentTemplate`.
    ///
    /// <p>Update an environment template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEnvironmentTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_template_input::Builder,
    }
    impl<C, M, R> UpdateEnvironmentTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentTemplateInputOperationOutputAlias,
                crate::output::UpdateEnvironmentTemplateOutput,
                crate::error::UpdateEnvironmentTemplateError,
                crate::input::UpdateEnvironmentTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment template to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the environment template to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the environment template to update as displayed in the developer interface.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name of the environment template to update as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>A description of the environment template update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the environment template update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEnvironmentTemplateVersion`.
    ///
    /// <p>Update a major or minor version of an environment template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEnvironmentTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_environment_template_version_input::Builder,
    }
    impl<C, M, R> UpdateEnvironmentTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEnvironmentTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEnvironmentTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEnvironmentTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEnvironmentTemplateVersionInputOperationOutputAlias,
                crate::output::UpdateEnvironmentTemplateVersionOutput,
                crate::error::UpdateEnvironmentTemplateVersionError,
                crate::input::UpdateEnvironmentTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the environment template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the environment template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>To update a major version of an environment template, include <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To update a major version of an environment template, include <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>To update a minor version of an environment template, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>To update a minor version of an environment template, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
        /// <p>A description of environment template version to update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of environment template version to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The status of the environment template minor version to update.</p>
        pub fn status(mut self, inp: crate::model::TemplateVersionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the environment template minor version to update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateService`.
    ///
    /// <p>Edit a service description or use a spec to add and delete service instances.</p>
    /// <note>
    /// <p>Existing service instances and the service pipeline <i>can't</i> be edited using this API. They can only be deleted.</p>
    /// </note>
    /// <p>Use the <code>description</code> parameter to modify the description.</p>
    /// <p>Edit the <code>spec</code> parameter to add or delete instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_input::Builder,
    }
    impl<C, M, R> UpdateService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceInputOperationOutputAlias,
                crate::output::UpdateServiceOutput,
                crate::error::UpdateServiceError,
                crate::input::UpdateServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service to edit.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service to edit.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The edited service description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The edited service description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Lists the service instances to add and the existing service instances to remain. Omit the existing service instances to delete from the list.
        /// <i>Don't</i> include edits to the existing service instances or pipeline. For more information, see <i>Edit a
        /// service</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-update.html">Proton Administrator Guide</a> or
        /// the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-update.html">Proton User Guide</a>.</p>
        pub fn spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>Lists the service instances to add and the existing service instances to remain. Omit the existing service instances to delete from the list.
        /// <i>Don't</i> include edits to the existing service instances or pipeline. For more information, see <i>Edit a
        /// service</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-update.html">Proton Administrator Guide</a> or
        /// the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-update.html">Proton User Guide</a>.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceInstance`.
    ///
    /// <p>Update a service instance.</p>
    /// <p>There are four modes for updating a service instance as described in the following. The <code>deploymentType</code> field defines the
    /// mode.</p>
    /// <dl>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>CURRENT_VERSION</code>
    /// </p>
    /// <p>In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated.
    /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MINOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major
    /// version in use, by default. You can also specify a different minor version of the current major version in use.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MAJOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current
    /// template, by default. You can also specify a different major version that is higher than the major version in use and a minor version
    /// (optional).</p>
    /// </dd>
    /// </dl>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServiceInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_instance_input::Builder,
    }
    impl<C, M, R> UpdateServiceInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceInstanceInputOperationOutputAlias,
                crate::output::UpdateServiceInstanceOutput,
                crate::error::UpdateServiceInstanceError,
                crate::input::UpdateServiceInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service instance to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service instance to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the service that the service instance belongs to.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service instance as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated.
        /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major
        /// version in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current
        /// template, by default. You can also specify a different major version that is higher than the major version in use and a minor version
        /// (optional).</p>
        /// </dd>
        /// </dl>
        pub fn deployment_type(mut self, inp: crate::model::DeploymentUpdateType) -> Self {
            self.inner = self.inner.deployment_type(inp);
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service instance as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated.
        /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major
        /// version in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current
        /// template, by default. You can also specify a different major version that is higher than the major version in use and a minor version
        /// (optional).</p>
        /// </dd>
        /// </dl>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentUpdateType>,
        ) -> Self {
            self.inner = self.inner.set_deployment_type(input);
            self
        }
        /// <p>The formatted specification that defines the service instance update.</p>
        pub fn spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The formatted specification that defines the service instance update.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>The major version of the service template to update.</p>
        pub fn template_major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_major_version(inp);
            self
        }
        /// <p>The major version of the service template to update.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_major_version(input);
            self
        }
        /// <p>The minor version of the service template to update.</p>
        pub fn template_minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_minor_version(inp);
            self
        }
        /// <p>The minor version of the service template to update.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_minor_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServicePipeline`.
    ///
    /// <p>Update the service pipeline.</p>
    /// <p>There are four modes for updating a service pipeline as described in the following. The <code>deploymentType</code> field defines the
    /// mode.</p>
    /// <dl>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>NONE</code>
    /// </p>
    /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>CURRENT_VERSION</code>
    /// </p>
    /// <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated.
    /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MINOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major
    /// version in use, by default. You can also specify a different minor version of the current major version in use.</p>
    /// </dd>
    /// <dt/>
    /// <dd>
    /// <p>
    /// <code>MAJOR_VERSION</code>
    /// </p>
    /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current
    /// template by default. You can also specify a different major version that is higher than the major version in use and a minor version
    /// (optional).</p>
    /// </dd>
    /// </dl>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServicePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_pipeline_input::Builder,
    }
    impl<C, M, R> UpdateServicePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServicePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServicePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServicePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServicePipelineInputOperationOutputAlias,
                crate::output::UpdateServicePipelineOutput,
                crate::error::UpdateServicePipelineError,
                crate::input::UpdateServicePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service to that the pipeline is associated with.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the service to that the pipeline is associated with.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The spec for the service pipeline to update.</p>
        pub fn spec(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spec(inp);
            self
        }
        /// <p>The spec for the service pipeline to update.</p>
        pub fn set_spec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service pipeline as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated.
        /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major
        /// version in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current
        /// template, by default. You can also specify a different major version that is higher than the major version in use and a minor version
        /// (optional).</p>
        /// </dd>
        /// </dl>
        pub fn deployment_type(mut self, inp: crate::model::DeploymentUpdateType) -> Self {
            self.inner = self.inner.deployment_type(inp);
            self
        }
        /// <p>The deployment type.</p>
        /// <p>There are four modes for updating a service pipeline as described in the following. The <code>deploymentType</code> field defines the
        /// mode.</p>
        /// <dl>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>NONE</code>
        /// </p>
        /// <p>In this mode, a deployment <i>doesn't</i> occur. Only the requested metadata parameters are updated.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>CURRENT_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated.
        /// <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MINOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major
        /// version in use, by default. You can also specify a different minor version of the current major version in use.</p>
        /// </dd>
        /// <dt/>
        /// <dd>
        /// <p>
        /// <code>MAJOR_VERSION</code>
        /// </p>
        /// <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current
        /// template, by default. You can also specify a different major version that is higher than the major version in use and a minor version
        /// (optional).</p>
        /// </dd>
        /// </dl>
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentUpdateType>,
        ) -> Self {
            self.inner = self.inner.set_deployment_type(input);
            self
        }
        /// <p>The major version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn template_major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_major_version(inp);
            self
        }
        /// <p>The major version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn set_template_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_major_version(input);
            self
        }
        /// <p>The minor version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn template_minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_minor_version(inp);
            self
        }
        /// <p>The minor version of the service template that was used to create the service that the pipeline is associated with.</p>
        pub fn set_template_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_minor_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceTemplate`.
    ///
    /// <p>Update a service template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServiceTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_template_input::Builder,
    }
    impl<C, M, R> UpdateServiceTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceTemplateInputOperationOutputAlias,
                crate::output::UpdateServiceTemplateOutput,
                crate::error::UpdateServiceTemplateError,
                crate::input::UpdateServiceTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service template to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the service template to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the service template to update as displayed in the developer interface.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The name of the service template to update as displayed in the developer interface.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>A description of the service template update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the service template update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceTemplateVersion`.
    ///
    /// <p>Update a major or minor version of a service template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServiceTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_template_version_input::Builder,
    }
    impl<C, M, R> UpdateServiceTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceTemplateVersionInputOperationOutputAlias,
                crate::output::UpdateServiceTemplateVersionOutput,
                crate::error::UpdateServiceTemplateVersionError,
                crate::input::UpdateServiceTemplateVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the service template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>To update a major version of a service template, include <code>major Version</code>.</p>
        pub fn major_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.major_version(inp);
            self
        }
        /// <p>To update a major version of a service template, include <code>major Version</code>.</p>
        pub fn set_major_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_major_version(input);
            self
        }
        /// <p>To update a minor version of a service template, include <code>minorVersion</code>.</p>
        pub fn minor_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.minor_version(inp);
            self
        }
        /// <p>To update a minor version of a service template, include <code>minorVersion</code>.</p>
        pub fn set_minor_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_minor_version(input);
            self
        }
        /// <p>A description of a service template version to update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of a service template version to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The status of the service template minor version to update.</p>
        pub fn status(mut self, inp: crate::model::TemplateVersionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the service template minor version to update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TemplateVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `compatibleEnvironmentTemplates`.
        ///
        /// To override the contents of this collection use [`set_compatible_environment_templates`](Self::set_compatible_environment_templates).
        ///
        /// <p>An array of compatible environment names for a service template major or minor version to update.</p>
        pub fn compatible_environment_templates(
            mut self,
            inp: impl Into<crate::model::CompatibleEnvironmentTemplateInput>,
        ) -> Self {
            self.inner = self.inner.compatible_environment_templates(inp);
            self
        }
        /// <p>An array of compatible environment names for a service template major or minor version to update.</p>
        pub fn set_compatible_environment_templates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CompatibleEnvironmentTemplateInput>,
            >,
        ) -> Self {
            self.inner = self.inner.set_compatible_environment_templates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplateSyncConfig`.
    ///
    /// <p>Update template sync configuration parameters, except for the <code>templateName</code> and <code>templateType</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTemplateSyncConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_sync_config_input::Builder,
    }
    impl<C, M, R> UpdateTemplateSyncConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplateSyncConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateSyncConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateSyncConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateSyncConfigInputOperationOutputAlias,
                crate::output::UpdateTemplateSyncConfigOutput,
                crate::error::UpdateTemplateSyncConfigError,
                crate::input::UpdateTemplateSyncConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The synced template name.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The synced template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The synced template type.</p>
        pub fn template_type(mut self, inp: crate::model::TemplateType) -> Self {
            self.inner = self.inner.template_type(inp);
            self
        }
        /// <p>The synced template type.</p>
        pub fn set_template_type(
            mut self,
            input: std::option::Option<crate::model::TemplateType>,
        ) -> Self {
            self.inner = self.inner.set_template_type(input);
            self
        }
        /// <p>The repository provider.</p>
        pub fn repository_provider(mut self, inp: crate::model::RepositoryProvider) -> Self {
            self.inner = self.inner.repository_provider(inp);
            self
        }
        /// <p>The repository provider.</p>
        pub fn set_repository_provider(
            mut self,
            input: std::option::Option<crate::model::RepositoryProvider>,
        ) -> Self {
            self.inner = self.inner.set_repository_provider(input);
            self
        }
        /// <p>The name of the repository, for example <code>myrepos/myrepo</code>.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository, for example <code>myrepos/myrepo</code>.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The repository branch.</p>
        pub fn branch(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch(inp);
            self
        }
        /// <p>The repository branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch(input);
            self
        }
        /// <p>A subdirectory path to your template bundle version. When included, limits the template bundle search to this repository directory.</p>
        pub fn subdirectory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdirectory(inp);
            self
        }
        /// <p>A subdirectory path to your template bundle version. When included, limits the template bundle search to this repository directory.</p>
        pub fn set_subdirectory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subdirectory(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
