// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceTemplateVersionsOutput {
    /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after
    /// the list of major or minor versions that was previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of major or minor versions of a service template with detail data.</p>
    pub template_versions:
        std::option::Option<std::vec::Vec<crate::model::ServiceTemplateVersionSummary>>,
}
impl ListServiceTemplateVersionsOutput {
    /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after
    /// the list of major or minor versions that was previously requested.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of major or minor versions of a service template with detail data.</p>
    pub fn template_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ServiceTemplateVersionSummary]> {
        self.template_versions.as_deref()
    }
}
impl std::fmt::Debug for ListServiceTemplateVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceTemplateVersionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("template_versions", &self.template_versions);
        formatter.finish()
    }
}
/// See [`ListServiceTemplateVersionsOutput`](crate::output::ListServiceTemplateVersionsOutput)
pub mod list_service_template_versions_output {
    /// A builder for [`ListServiceTemplateVersionsOutput`](crate::output::ListServiceTemplateVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) template_versions:
            std::option::Option<std::vec::Vec<crate::model::ServiceTemplateVersionSummary>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after
        /// the list of major or minor versions that was previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of a service template, after
        /// the list of major or minor versions that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `template_versions`.
        ///
        /// To override the contents of this collection use [`set_template_versions`](Self::set_template_versions).
        ///
        /// <p>An array of major or minor versions of a service template with detail data.</p>
        pub fn template_versions(
            mut self,
            input: impl Into<crate::model::ServiceTemplateVersionSummary>,
        ) -> Self {
            let mut v = self.template_versions.unwrap_or_default();
            v.push(input.into());
            self.template_versions = Some(v);
            self
        }
        /// <p>An array of major or minor versions of a service template with detail data.</p>
        pub fn set_template_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceTemplateVersionSummary>>,
        ) -> Self {
            self.template_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceTemplateVersionsOutput`](crate::output::ListServiceTemplateVersionsOutput)
        pub fn build(self) -> crate::output::ListServiceTemplateVersionsOutput {
            crate::output::ListServiceTemplateVersionsOutput {
                next_token: self.next_token,
                template_versions: self.template_versions,
            }
        }
    }
}
impl ListServiceTemplateVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListServiceTemplateVersionsOutput`](crate::output::ListServiceTemplateVersionsOutput)
    pub fn builder() -> crate::output::list_service_template_versions_output::Builder {
        crate::output::list_service_template_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceTemplateVersionOutput {
    /// <p>The service template version summary of detail data that's returned by AWS Proton.</p>
    pub service_template_version: std::option::Option<crate::model::ServiceTemplateVersion>,
}
impl CreateServiceTemplateVersionOutput {
    /// <p>The service template version summary of detail data that's returned by AWS Proton.</p>
    pub fn service_template_version(
        &self,
    ) -> std::option::Option<&crate::model::ServiceTemplateVersion> {
        self.service_template_version.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceTemplateVersionOutput");
        formatter.field("service_template_version", &self.service_template_version);
        formatter.finish()
    }
}
/// See [`CreateServiceTemplateVersionOutput`](crate::output::CreateServiceTemplateVersionOutput)
pub mod create_service_template_version_output {
    /// A builder for [`CreateServiceTemplateVersionOutput`](crate::output::CreateServiceTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template_version:
            std::option::Option<crate::model::ServiceTemplateVersion>,
    }
    impl Builder {
        /// <p>The service template version summary of detail data that's returned by AWS Proton.</p>
        pub fn service_template_version(
            mut self,
            input: crate::model::ServiceTemplateVersion,
        ) -> Self {
            self.service_template_version = Some(input);
            self
        }
        /// <p>The service template version summary of detail data that's returned by AWS Proton.</p>
        pub fn set_service_template_version(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplateVersion>,
        ) -> Self {
            self.service_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceTemplateVersionOutput`](crate::output::CreateServiceTemplateVersionOutput)
        pub fn build(self) -> crate::output::CreateServiceTemplateVersionOutput {
            crate::output::CreateServiceTemplateVersionOutput {
                service_template_version: self.service_template_version,
            }
        }
    }
}
impl CreateServiceTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceTemplateVersionOutput`](crate::output::CreateServiceTemplateVersionOutput)
    pub fn builder() -> crate::output::create_service_template_version_output::Builder {
        crate::output::create_service_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceTemplateVersionOutput {
    /// <p>The service template version detail data that's returned by AWS Proton.</p>
    pub service_template_version: std::option::Option<crate::model::ServiceTemplateVersion>,
}
impl DeleteServiceTemplateVersionOutput {
    /// <p>The service template version detail data that's returned by AWS Proton.</p>
    pub fn service_template_version(
        &self,
    ) -> std::option::Option<&crate::model::ServiceTemplateVersion> {
        self.service_template_version.as_ref()
    }
}
impl std::fmt::Debug for DeleteServiceTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceTemplateVersionOutput");
        formatter.field("service_template_version", &self.service_template_version);
        formatter.finish()
    }
}
/// See [`DeleteServiceTemplateVersionOutput`](crate::output::DeleteServiceTemplateVersionOutput)
pub mod delete_service_template_version_output {
    /// A builder for [`DeleteServiceTemplateVersionOutput`](crate::output::DeleteServiceTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template_version:
            std::option::Option<crate::model::ServiceTemplateVersion>,
    }
    impl Builder {
        /// <p>The service template version detail data that's returned by AWS Proton.</p>
        pub fn service_template_version(
            mut self,
            input: crate::model::ServiceTemplateVersion,
        ) -> Self {
            self.service_template_version = Some(input);
            self
        }
        /// <p>The service template version detail data that's returned by AWS Proton.</p>
        pub fn set_service_template_version(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplateVersion>,
        ) -> Self {
            self.service_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceTemplateVersionOutput`](crate::output::DeleteServiceTemplateVersionOutput)
        pub fn build(self) -> crate::output::DeleteServiceTemplateVersionOutput {
            crate::output::DeleteServiceTemplateVersionOutput {
                service_template_version: self.service_template_version,
            }
        }
    }
}
impl DeleteServiceTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceTemplateVersionOutput`](crate::output::DeleteServiceTemplateVersionOutput)
    pub fn builder() -> crate::output::delete_service_template_version_output::Builder {
        crate::output::delete_service_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceTemplateVersionOutput {
    /// <p>The service template version detail data that's returned by AWS Proton.</p>
    pub service_template_version: std::option::Option<crate::model::ServiceTemplateVersion>,
}
impl UpdateServiceTemplateVersionOutput {
    /// <p>The service template version detail data that's returned by AWS Proton.</p>
    pub fn service_template_version(
        &self,
    ) -> std::option::Option<&crate::model::ServiceTemplateVersion> {
        self.service_template_version.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceTemplateVersionOutput");
        formatter.field("service_template_version", &self.service_template_version);
        formatter.finish()
    }
}
/// See [`UpdateServiceTemplateVersionOutput`](crate::output::UpdateServiceTemplateVersionOutput)
pub mod update_service_template_version_output {
    /// A builder for [`UpdateServiceTemplateVersionOutput`](crate::output::UpdateServiceTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template_version:
            std::option::Option<crate::model::ServiceTemplateVersion>,
    }
    impl Builder {
        /// <p>The service template version detail data that's returned by AWS Proton.</p>
        pub fn service_template_version(
            mut self,
            input: crate::model::ServiceTemplateVersion,
        ) -> Self {
            self.service_template_version = Some(input);
            self
        }
        /// <p>The service template version detail data that's returned by AWS Proton.</p>
        pub fn set_service_template_version(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplateVersion>,
        ) -> Self {
            self.service_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceTemplateVersionOutput`](crate::output::UpdateServiceTemplateVersionOutput)
        pub fn build(self) -> crate::output::UpdateServiceTemplateVersionOutput {
            crate::output::UpdateServiceTemplateVersionOutput {
                service_template_version: self.service_template_version,
            }
        }
    }
}
impl UpdateServiceTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceTemplateVersionOutput`](crate::output::UpdateServiceTemplateVersionOutput)
    pub fn builder() -> crate::output::update_service_template_version_output::Builder {
        crate::output::update_service_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceTemplateVersionOutput {
    /// <p>The service template version detail data that's returned by AWS Proton.</p>
    pub service_template_version: std::option::Option<crate::model::ServiceTemplateVersion>,
}
impl GetServiceTemplateVersionOutput {
    /// <p>The service template version detail data that's returned by AWS Proton.</p>
    pub fn service_template_version(
        &self,
    ) -> std::option::Option<&crate::model::ServiceTemplateVersion> {
        self.service_template_version.as_ref()
    }
}
impl std::fmt::Debug for GetServiceTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceTemplateVersionOutput");
        formatter.field("service_template_version", &self.service_template_version);
        formatter.finish()
    }
}
/// See [`GetServiceTemplateVersionOutput`](crate::output::GetServiceTemplateVersionOutput)
pub mod get_service_template_version_output {
    /// A builder for [`GetServiceTemplateVersionOutput`](crate::output::GetServiceTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template_version:
            std::option::Option<crate::model::ServiceTemplateVersion>,
    }
    impl Builder {
        /// <p>The service template version detail data that's returned by AWS Proton.</p>
        pub fn service_template_version(
            mut self,
            input: crate::model::ServiceTemplateVersion,
        ) -> Self {
            self.service_template_version = Some(input);
            self
        }
        /// <p>The service template version detail data that's returned by AWS Proton.</p>
        pub fn set_service_template_version(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplateVersion>,
        ) -> Self {
            self.service_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceTemplateVersionOutput`](crate::output::GetServiceTemplateVersionOutput)
        pub fn build(self) -> crate::output::GetServiceTemplateVersionOutput {
            crate::output::GetServiceTemplateVersionOutput {
                service_template_version: self.service_template_version,
            }
        }
    }
}
impl GetServiceTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceTemplateVersionOutput`](crate::output::GetServiceTemplateVersionOutput)
    pub fn builder() -> crate::output::get_service_template_version_output::Builder {
        crate::output::get_service_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceTemplatesOutput {
    /// <p>A token to indicate the location of the next service template in the array of service templates, after the current requested list of
    /// service templates.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of service templates with detail data.</p>
    pub templates: std::option::Option<std::vec::Vec<crate::model::ServiceTemplateSummary>>,
}
impl ListServiceTemplatesOutput {
    /// <p>A token to indicate the location of the next service template in the array of service templates, after the current requested list of
    /// service templates.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of service templates with detail data.</p>
    pub fn templates(&self) -> std::option::Option<&[crate::model::ServiceTemplateSummary]> {
        self.templates.as_deref()
    }
}
impl std::fmt::Debug for ListServiceTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceTemplatesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("templates", &self.templates);
        formatter.finish()
    }
}
/// See [`ListServiceTemplatesOutput`](crate::output::ListServiceTemplatesOutput)
pub mod list_service_templates_output {
    /// A builder for [`ListServiceTemplatesOutput`](crate::output::ListServiceTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) templates:
            std::option::Option<std::vec::Vec<crate::model::ServiceTemplateSummary>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next service template in the array of service templates, after the current requested list of
        /// service templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next service template in the array of service templates, after the current requested list of
        /// service templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `templates`.
        ///
        /// To override the contents of this collection use [`set_templates`](Self::set_templates).
        ///
        /// <p>An array of service templates with detail data.</p>
        pub fn templates(mut self, input: impl Into<crate::model::ServiceTemplateSummary>) -> Self {
            let mut v = self.templates.unwrap_or_default();
            v.push(input.into());
            self.templates = Some(v);
            self
        }
        /// <p>An array of service templates with detail data.</p>
        pub fn set_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceTemplateSummary>>,
        ) -> Self {
            self.templates = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceTemplatesOutput`](crate::output::ListServiceTemplatesOutput)
        pub fn build(self) -> crate::output::ListServiceTemplatesOutput {
            crate::output::ListServiceTemplatesOutput {
                next_token: self.next_token,
                templates: self.templates,
            }
        }
    }
}
impl ListServiceTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListServiceTemplatesOutput`](crate::output::ListServiceTemplatesOutput)
    pub fn builder() -> crate::output::list_service_templates_output::Builder {
        crate::output::list_service_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub service_template: std::option::Option<crate::model::ServiceTemplate>,
}
impl CreateServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub fn service_template(&self) -> std::option::Option<&crate::model::ServiceTemplate> {
        self.service_template.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceTemplateOutput");
        formatter.field("service_template", &self.service_template);
        formatter.finish()
    }
}
/// See [`CreateServiceTemplateOutput`](crate::output::CreateServiceTemplateOutput)
pub mod create_service_template_output {
    /// A builder for [`CreateServiceTemplateOutput`](crate::output::CreateServiceTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template: std::option::Option<crate::model::ServiceTemplate>,
    }
    impl Builder {
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn service_template(mut self, input: crate::model::ServiceTemplate) -> Self {
            self.service_template = Some(input);
            self
        }
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn set_service_template(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplate>,
        ) -> Self {
            self.service_template = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceTemplateOutput`](crate::output::CreateServiceTemplateOutput)
        pub fn build(self) -> crate::output::CreateServiceTemplateOutput {
            crate::output::CreateServiceTemplateOutput {
                service_template: self.service_template,
            }
        }
    }
}
impl CreateServiceTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceTemplateOutput`](crate::output::CreateServiceTemplateOutput)
    pub fn builder() -> crate::output::create_service_template_output::Builder {
        crate::output::create_service_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub service_template: std::option::Option<crate::model::ServiceTemplate>,
}
impl DeleteServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub fn service_template(&self) -> std::option::Option<&crate::model::ServiceTemplate> {
        self.service_template.as_ref()
    }
}
impl std::fmt::Debug for DeleteServiceTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceTemplateOutput");
        formatter.field("service_template", &self.service_template);
        formatter.finish()
    }
}
/// See [`DeleteServiceTemplateOutput`](crate::output::DeleteServiceTemplateOutput)
pub mod delete_service_template_output {
    /// A builder for [`DeleteServiceTemplateOutput`](crate::output::DeleteServiceTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template: std::option::Option<crate::model::ServiceTemplate>,
    }
    impl Builder {
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn service_template(mut self, input: crate::model::ServiceTemplate) -> Self {
            self.service_template = Some(input);
            self
        }
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn set_service_template(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplate>,
        ) -> Self {
            self.service_template = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceTemplateOutput`](crate::output::DeleteServiceTemplateOutput)
        pub fn build(self) -> crate::output::DeleteServiceTemplateOutput {
            crate::output::DeleteServiceTemplateOutput {
                service_template: self.service_template,
            }
        }
    }
}
impl DeleteServiceTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceTemplateOutput`](crate::output::DeleteServiceTemplateOutput)
    pub fn builder() -> crate::output::delete_service_template_output::Builder {
        crate::output::delete_service_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub service_template: std::option::Option<crate::model::ServiceTemplate>,
}
impl UpdateServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub fn service_template(&self) -> std::option::Option<&crate::model::ServiceTemplate> {
        self.service_template.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceTemplateOutput");
        formatter.field("service_template", &self.service_template);
        formatter.finish()
    }
}
/// See [`UpdateServiceTemplateOutput`](crate::output::UpdateServiceTemplateOutput)
pub mod update_service_template_output {
    /// A builder for [`UpdateServiceTemplateOutput`](crate::output::UpdateServiceTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template: std::option::Option<crate::model::ServiceTemplate>,
    }
    impl Builder {
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn service_template(mut self, input: crate::model::ServiceTemplate) -> Self {
            self.service_template = Some(input);
            self
        }
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn set_service_template(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplate>,
        ) -> Self {
            self.service_template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceTemplateOutput`](crate::output::UpdateServiceTemplateOutput)
        pub fn build(self) -> crate::output::UpdateServiceTemplateOutput {
            crate::output::UpdateServiceTemplateOutput {
                service_template: self.service_template,
            }
        }
    }
}
impl UpdateServiceTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceTemplateOutput`](crate::output::UpdateServiceTemplateOutput)
    pub fn builder() -> crate::output::update_service_template_output::Builder {
        crate::output::update_service_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub service_template: std::option::Option<crate::model::ServiceTemplate>,
}
impl GetServiceTemplateOutput {
    /// <p>The service template detail data that's returned by AWS Proton.</p>
    pub fn service_template(&self) -> std::option::Option<&crate::model::ServiceTemplate> {
        self.service_template.as_ref()
    }
}
impl std::fmt::Debug for GetServiceTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceTemplateOutput");
        formatter.field("service_template", &self.service_template);
        formatter.finish()
    }
}
/// See [`GetServiceTemplateOutput`](crate::output::GetServiceTemplateOutput)
pub mod get_service_template_output {
    /// A builder for [`GetServiceTemplateOutput`](crate::output::GetServiceTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_template: std::option::Option<crate::model::ServiceTemplate>,
    }
    impl Builder {
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn service_template(mut self, input: crate::model::ServiceTemplate) -> Self {
            self.service_template = Some(input);
            self
        }
        /// <p>The service template detail data that's returned by AWS Proton.</p>
        pub fn set_service_template(
            mut self,
            input: std::option::Option<crate::model::ServiceTemplate>,
        ) -> Self {
            self.service_template = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceTemplateOutput`](crate::output::GetServiceTemplateOutput)
        pub fn build(self) -> crate::output::GetServiceTemplateOutput {
            crate::output::GetServiceTemplateOutput {
                service_template: self.service_template,
            }
        }
    }
}
impl GetServiceTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceTemplateOutput`](crate::output::GetServiceTemplateOutput)
    pub fn builder() -> crate::output::get_service_template_output::Builder {
        crate::output::get_service_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesOutput {
    /// <p>A token to indicate the location of the next service in the array of services, after the current requested list of services.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of services with summaries of detail data.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
}
impl ListServicesOutput {
    /// <p>A token to indicate the location of the next service in the array of services, after the current requested list of services.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of services with summaries of detail data.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::ServiceSummary]> {
        self.services.as_deref()
    }
}
impl std::fmt::Debug for ListServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("services", &self.services);
        formatter.finish()
    }
}
/// See [`ListServicesOutput`](crate::output::ListServicesOutput)
pub mod list_services_output {
    /// A builder for [`ListServicesOutput`](crate::output::ListServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next service in the array of services, after the current requested list of services.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next service in the array of services, after the current requested list of services.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>An array of services with summaries of detail data.</p>
        pub fn services(mut self, input: impl Into<crate::model::ServiceSummary>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>An array of services with summaries of detail data.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesOutput`](crate::output::ListServicesOutput)
        pub fn build(self) -> crate::output::ListServicesOutput {
            crate::output::ListServicesOutput {
                next_token: self.next_token,
                services: self.services,
            }
        }
    }
}
impl ListServicesOutput {
    /// Creates a new builder-style object to manufacture [`ListServicesOutput`](crate::output::ListServicesOutput)
    pub fn builder() -> crate::output::list_services_output::Builder {
        crate::output::list_services_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl CreateServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`CreateServiceOutput`](crate::output::CreateServiceOutput)
pub mod create_service_output {
    /// A builder for [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceOutput`](crate::output::CreateServiceOutput)
        pub fn build(self) -> crate::output::CreateServiceOutput {
            crate::output::CreateServiceOutput {
                service: self.service,
            }
        }
    }
}
impl CreateServiceOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    pub fn builder() -> crate::output::create_service_output::Builder {
        crate::output::create_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl DeleteServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for DeleteServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
pub mod delete_service_output {
    /// A builder for [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
        pub fn build(self) -> crate::output::DeleteServiceOutput {
            crate::output::DeleteServiceOutput {
                service: self.service,
            }
        }
    }
}
impl DeleteServiceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    pub fn builder() -> crate::output::delete_service_output::Builder {
        crate::output::delete_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl UpdateServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
pub mod update_service_output {
    /// A builder for [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
        pub fn build(self) -> crate::output::UpdateServiceOutput {
            crate::output::UpdateServiceOutput {
                service: self.service,
            }
        }
    }
}
impl UpdateServiceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    pub fn builder() -> crate::output::update_service_output::Builder {
        crate::output::update_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl GetServiceOutput {
    /// <p>The service detail data that's returned by AWS Proton.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for GetServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`GetServiceOutput`](crate::output::GetServiceOutput)
pub mod get_service_output {
    /// A builder for [`GetServiceOutput`](crate::output::GetServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The service detail data that's returned by AWS Proton.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceOutput`](crate::output::GetServiceOutput)
        pub fn build(self) -> crate::output::GetServiceOutput {
            crate::output::GetServiceOutput {
                service: self.service,
            }
        }
    }
}
impl GetServiceOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceOutput`](crate::output::GetServiceOutput)
    pub fn builder() -> crate::output::get_service_output::Builder {
        crate::output::get_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServicePipelineOutput {
    /// <p>The pipeline details returned by AWS Proton.</p>
    pub pipeline: std::option::Option<crate::model::ServicePipeline>,
}
impl UpdateServicePipelineOutput {
    /// <p>The pipeline details returned by AWS Proton.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::ServicePipeline> {
        self.pipeline.as_ref()
    }
}
impl std::fmt::Debug for UpdateServicePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServicePipelineOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.finish()
    }
}
/// See [`UpdateServicePipelineOutput`](crate::output::UpdateServicePipelineOutput)
pub mod update_service_pipeline_output {
    /// A builder for [`UpdateServicePipelineOutput`](crate::output::UpdateServicePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::ServicePipeline>,
    }
    impl Builder {
        /// <p>The pipeline details returned by AWS Proton.</p>
        pub fn pipeline(mut self, input: crate::model::ServicePipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>The pipeline details returned by AWS Proton.</p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::ServicePipeline>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServicePipelineOutput`](crate::output::UpdateServicePipelineOutput)
        pub fn build(self) -> crate::output::UpdateServicePipelineOutput {
            crate::output::UpdateServicePipelineOutput {
                pipeline: self.pipeline,
            }
        }
    }
}
impl UpdateServicePipelineOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServicePipelineOutput`](crate::output::UpdateServicePipelineOutput)
    pub fn builder() -> crate::output::update_service_pipeline_output::Builder {
        crate::output::update_service_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceInstancesOutput {
    /// <p>A token to indicate the location of the next service instance in the array of service instances, after the current requested list of
    /// service instances.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of service instances with summaries of detail data.</p>
    pub service_instances: std::option::Option<std::vec::Vec<crate::model::ServiceInstanceSummary>>,
}
impl ListServiceInstancesOutput {
    /// <p>A token to indicate the location of the next service instance in the array of service instances, after the current requested list of
    /// service instances.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of service instances with summaries of detail data.</p>
    pub fn service_instances(
        &self,
    ) -> std::option::Option<&[crate::model::ServiceInstanceSummary]> {
        self.service_instances.as_deref()
    }
}
impl std::fmt::Debug for ListServiceInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceInstancesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("service_instances", &self.service_instances);
        formatter.finish()
    }
}
/// See [`ListServiceInstancesOutput`](crate::output::ListServiceInstancesOutput)
pub mod list_service_instances_output {
    /// A builder for [`ListServiceInstancesOutput`](crate::output::ListServiceInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) service_instances:
            std::option::Option<std::vec::Vec<crate::model::ServiceInstanceSummary>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next service instance in the array of service instances, after the current requested list of
        /// service instances.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next service instance in the array of service instances, after the current requested list of
        /// service instances.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `service_instances`.
        ///
        /// To override the contents of this collection use [`set_service_instances`](Self::set_service_instances).
        ///
        /// <p>An array of service instances with summaries of detail data.</p>
        pub fn service_instances(
            mut self,
            input: impl Into<crate::model::ServiceInstanceSummary>,
        ) -> Self {
            let mut v = self.service_instances.unwrap_or_default();
            v.push(input.into());
            self.service_instances = Some(v);
            self
        }
        /// <p>An array of service instances with summaries of detail data.</p>
        pub fn set_service_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceInstanceSummary>>,
        ) -> Self {
            self.service_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceInstancesOutput`](crate::output::ListServiceInstancesOutput)
        pub fn build(self) -> crate::output::ListServiceInstancesOutput {
            crate::output::ListServiceInstancesOutput {
                next_token: self.next_token,
                service_instances: self.service_instances,
            }
        }
    }
}
impl ListServiceInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListServiceInstancesOutput`](crate::output::ListServiceInstancesOutput)
    pub fn builder() -> crate::output::list_service_instances_output::Builder {
        crate::output::list_service_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceInstanceOutput {
    /// <p>The service instance summary data returned by AWS Proton.</p>
    pub service_instance: std::option::Option<crate::model::ServiceInstance>,
}
impl UpdateServiceInstanceOutput {
    /// <p>The service instance summary data returned by AWS Proton.</p>
    pub fn service_instance(&self) -> std::option::Option<&crate::model::ServiceInstance> {
        self.service_instance.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceInstanceOutput");
        formatter.field("service_instance", &self.service_instance);
        formatter.finish()
    }
}
/// See [`UpdateServiceInstanceOutput`](crate::output::UpdateServiceInstanceOutput)
pub mod update_service_instance_output {
    /// A builder for [`UpdateServiceInstanceOutput`](crate::output::UpdateServiceInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_instance: std::option::Option<crate::model::ServiceInstance>,
    }
    impl Builder {
        /// <p>The service instance summary data returned by AWS Proton.</p>
        pub fn service_instance(mut self, input: crate::model::ServiceInstance) -> Self {
            self.service_instance = Some(input);
            self
        }
        /// <p>The service instance summary data returned by AWS Proton.</p>
        pub fn set_service_instance(
            mut self,
            input: std::option::Option<crate::model::ServiceInstance>,
        ) -> Self {
            self.service_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceInstanceOutput`](crate::output::UpdateServiceInstanceOutput)
        pub fn build(self) -> crate::output::UpdateServiceInstanceOutput {
            crate::output::UpdateServiceInstanceOutput {
                service_instance: self.service_instance,
            }
        }
    }
}
impl UpdateServiceInstanceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceInstanceOutput`](crate::output::UpdateServiceInstanceOutput)
    pub fn builder() -> crate::output::update_service_instance_output::Builder {
        crate::output::update_service_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceInstanceOutput {
    /// <p>The service instance detail data that's returned by AWS Proton.</p>
    pub service_instance: std::option::Option<crate::model::ServiceInstance>,
}
impl GetServiceInstanceOutput {
    /// <p>The service instance detail data that's returned by AWS Proton.</p>
    pub fn service_instance(&self) -> std::option::Option<&crate::model::ServiceInstance> {
        self.service_instance.as_ref()
    }
}
impl std::fmt::Debug for GetServiceInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceInstanceOutput");
        formatter.field("service_instance", &self.service_instance);
        formatter.finish()
    }
}
/// See [`GetServiceInstanceOutput`](crate::output::GetServiceInstanceOutput)
pub mod get_service_instance_output {
    /// A builder for [`GetServiceInstanceOutput`](crate::output::GetServiceInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_instance: std::option::Option<crate::model::ServiceInstance>,
    }
    impl Builder {
        /// <p>The service instance detail data that's returned by AWS Proton.</p>
        pub fn service_instance(mut self, input: crate::model::ServiceInstance) -> Self {
            self.service_instance = Some(input);
            self
        }
        /// <p>The service instance detail data that's returned by AWS Proton.</p>
        pub fn set_service_instance(
            mut self,
            input: std::option::Option<crate::model::ServiceInstance>,
        ) -> Self {
            self.service_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceInstanceOutput`](crate::output::GetServiceInstanceOutput)
        pub fn build(self) -> crate::output::GetServiceInstanceOutput {
            crate::output::GetServiceInstanceOutput {
                service_instance: self.service_instance,
            }
        }
    }
}
impl GetServiceInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceInstanceOutput`](crate::output::GetServiceInstanceOutput)
    pub fn builder() -> crate::output::get_service_instance_output::Builder {
        crate::output::get_service_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentTemplateVersionsOutput {
    /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template,
    /// after the list of major or minor versions that was previously requested.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of major or minor versions of an environment template detail data.</p>
    pub template_versions:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateVersionSummary>>,
}
impl ListEnvironmentTemplateVersionsOutput {
    /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template,
    /// after the list of major or minor versions that was previously requested.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of major or minor versions of an environment template detail data.</p>
    pub fn template_versions(
        &self,
    ) -> std::option::Option<&[crate::model::EnvironmentTemplateVersionSummary]> {
        self.template_versions.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentTemplateVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentTemplateVersionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("template_versions", &self.template_versions);
        formatter.finish()
    }
}
/// See [`ListEnvironmentTemplateVersionsOutput`](crate::output::ListEnvironmentTemplateVersionsOutput)
pub mod list_environment_template_versions_output {
    /// A builder for [`ListEnvironmentTemplateVersionsOutput`](crate::output::ListEnvironmentTemplateVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) template_versions:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateVersionSummary>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template,
        /// after the list of major or minor versions that was previously requested.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next major or minor version in the array of major or minor versions of an environment template,
        /// after the list of major or minor versions that was previously requested.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `template_versions`.
        ///
        /// To override the contents of this collection use [`set_template_versions`](Self::set_template_versions).
        ///
        /// <p>An array of major or minor versions of an environment template detail data.</p>
        pub fn template_versions(
            mut self,
            input: impl Into<crate::model::EnvironmentTemplateVersionSummary>,
        ) -> Self {
            let mut v = self.template_versions.unwrap_or_default();
            v.push(input.into());
            self.template_versions = Some(v);
            self
        }
        /// <p>An array of major or minor versions of an environment template detail data.</p>
        pub fn set_template_versions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::EnvironmentTemplateVersionSummary>,
            >,
        ) -> Self {
            self.template_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentTemplateVersionsOutput`](crate::output::ListEnvironmentTemplateVersionsOutput)
        pub fn build(self) -> crate::output::ListEnvironmentTemplateVersionsOutput {
            crate::output::ListEnvironmentTemplateVersionsOutput {
                next_token: self.next_token,
                template_versions: self.template_versions,
            }
        }
    }
}
impl ListEnvironmentTemplateVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentTemplateVersionsOutput`](crate::output::ListEnvironmentTemplateVersionsOutput)
    pub fn builder() -> crate::output::list_environment_template_versions_output::Builder {
        crate::output::list_environment_template_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentTemplateVersionOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub environment_template_version: std::option::Option<crate::model::EnvironmentTemplateVersion>,
}
impl CreateEnvironmentTemplateVersionOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub fn environment_template_version(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentTemplateVersion> {
        self.environment_template_version.as_ref()
    }
}
impl std::fmt::Debug for CreateEnvironmentTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentTemplateVersionOutput");
        formatter.field(
            "environment_template_version",
            &self.environment_template_version,
        );
        formatter.finish()
    }
}
/// See [`CreateEnvironmentTemplateVersionOutput`](crate::output::CreateEnvironmentTemplateVersionOutput)
pub mod create_environment_template_version_output {
    /// A builder for [`CreateEnvironmentTemplateVersionOutput`](crate::output::CreateEnvironmentTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template_version:
            std::option::Option<crate::model::EnvironmentTemplateVersion>,
    }
    impl Builder {
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn environment_template_version(
            mut self,
            input: crate::model::EnvironmentTemplateVersion,
        ) -> Self {
            self.environment_template_version = Some(input);
            self
        }
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template_version(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplateVersion>,
        ) -> Self {
            self.environment_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentTemplateVersionOutput`](crate::output::CreateEnvironmentTemplateVersionOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentTemplateVersionOutput {
            crate::output::CreateEnvironmentTemplateVersionOutput {
                environment_template_version: self.environment_template_version,
            }
        }
    }
}
impl CreateEnvironmentTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentTemplateVersionOutput`](crate::output::CreateEnvironmentTemplateVersionOutput)
    pub fn builder() -> crate::output::create_environment_template_version_output::Builder {
        crate::output::create_environment_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentTemplateVersionOutput {
    /// <p>The environment template version detail data that's returned by AWS Proton.</p>
    pub environment_template_version: std::option::Option<crate::model::EnvironmentTemplateVersion>,
}
impl DeleteEnvironmentTemplateVersionOutput {
    /// <p>The environment template version detail data that's returned by AWS Proton.</p>
    pub fn environment_template_version(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentTemplateVersion> {
        self.environment_template_version.as_ref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentTemplateVersionOutput");
        formatter.field(
            "environment_template_version",
            &self.environment_template_version,
        );
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentTemplateVersionOutput`](crate::output::DeleteEnvironmentTemplateVersionOutput)
pub mod delete_environment_template_version_output {
    /// A builder for [`DeleteEnvironmentTemplateVersionOutput`](crate::output::DeleteEnvironmentTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template_version:
            std::option::Option<crate::model::EnvironmentTemplateVersion>,
    }
    impl Builder {
        /// <p>The environment template version detail data that's returned by AWS Proton.</p>
        pub fn environment_template_version(
            mut self,
            input: crate::model::EnvironmentTemplateVersion,
        ) -> Self {
            self.environment_template_version = Some(input);
            self
        }
        /// <p>The environment template version detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template_version(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplateVersion>,
        ) -> Self {
            self.environment_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentTemplateVersionOutput`](crate::output::DeleteEnvironmentTemplateVersionOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentTemplateVersionOutput {
            crate::output::DeleteEnvironmentTemplateVersionOutput {
                environment_template_version: self.environment_template_version,
            }
        }
    }
}
impl DeleteEnvironmentTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentTemplateVersionOutput`](crate::output::DeleteEnvironmentTemplateVersionOutput)
    pub fn builder() -> crate::output::delete_environment_template_version_output::Builder {
        crate::output::delete_environment_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentTemplateVersionOutput {
    /// <p>The environment template version detail data that's returned by AWS Proton.</p>
    pub environment_template_version: std::option::Option<crate::model::EnvironmentTemplateVersion>,
}
impl UpdateEnvironmentTemplateVersionOutput {
    /// <p>The environment template version detail data that's returned by AWS Proton.</p>
    pub fn environment_template_version(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentTemplateVersion> {
        self.environment_template_version.as_ref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentTemplateVersionOutput");
        formatter.field(
            "environment_template_version",
            &self.environment_template_version,
        );
        formatter.finish()
    }
}
/// See [`UpdateEnvironmentTemplateVersionOutput`](crate::output::UpdateEnvironmentTemplateVersionOutput)
pub mod update_environment_template_version_output {
    /// A builder for [`UpdateEnvironmentTemplateVersionOutput`](crate::output::UpdateEnvironmentTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template_version:
            std::option::Option<crate::model::EnvironmentTemplateVersion>,
    }
    impl Builder {
        /// <p>The environment template version detail data that's returned by AWS Proton.</p>
        pub fn environment_template_version(
            mut self,
            input: crate::model::EnvironmentTemplateVersion,
        ) -> Self {
            self.environment_template_version = Some(input);
            self
        }
        /// <p>The environment template version detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template_version(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplateVersion>,
        ) -> Self {
            self.environment_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentTemplateVersionOutput`](crate::output::UpdateEnvironmentTemplateVersionOutput)
        pub fn build(self) -> crate::output::UpdateEnvironmentTemplateVersionOutput {
            crate::output::UpdateEnvironmentTemplateVersionOutput {
                environment_template_version: self.environment_template_version,
            }
        }
    }
}
impl UpdateEnvironmentTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentTemplateVersionOutput`](crate::output::UpdateEnvironmentTemplateVersionOutput)
    pub fn builder() -> crate::output::update_environment_template_version_output::Builder {
        crate::output::update_environment_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentTemplateVersionOutput {
    /// <p>The environment template version detail data that's returned by AWS Proton.</p>
    pub environment_template_version: std::option::Option<crate::model::EnvironmentTemplateVersion>,
}
impl GetEnvironmentTemplateVersionOutput {
    /// <p>The environment template version detail data that's returned by AWS Proton.</p>
    pub fn environment_template_version(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentTemplateVersion> {
        self.environment_template_version.as_ref()
    }
}
impl std::fmt::Debug for GetEnvironmentTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentTemplateVersionOutput");
        formatter.field(
            "environment_template_version",
            &self.environment_template_version,
        );
        formatter.finish()
    }
}
/// See [`GetEnvironmentTemplateVersionOutput`](crate::output::GetEnvironmentTemplateVersionOutput)
pub mod get_environment_template_version_output {
    /// A builder for [`GetEnvironmentTemplateVersionOutput`](crate::output::GetEnvironmentTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template_version:
            std::option::Option<crate::model::EnvironmentTemplateVersion>,
    }
    impl Builder {
        /// <p>The environment template version detail data that's returned by AWS Proton.</p>
        pub fn environment_template_version(
            mut self,
            input: crate::model::EnvironmentTemplateVersion,
        ) -> Self {
            self.environment_template_version = Some(input);
            self
        }
        /// <p>The environment template version detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template_version(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplateVersion>,
        ) -> Self {
            self.environment_template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentTemplateVersionOutput`](crate::output::GetEnvironmentTemplateVersionOutput)
        pub fn build(self) -> crate::output::GetEnvironmentTemplateVersionOutput {
            crate::output::GetEnvironmentTemplateVersionOutput {
                environment_template_version: self.environment_template_version,
            }
        }
    }
}
impl GetEnvironmentTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentTemplateVersionOutput`](crate::output::GetEnvironmentTemplateVersionOutput)
    pub fn builder() -> crate::output::get_environment_template_version_output::Builder {
        crate::output::get_environment_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentTemplatesOutput {
    /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the current requested
    /// list of environment templates.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of environment templates with detail data.</p>
    pub templates: std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateSummary>>,
}
impl ListEnvironmentTemplatesOutput {
    /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the current requested
    /// list of environment templates.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of environment templates with detail data.</p>
    pub fn templates(&self) -> std::option::Option<&[crate::model::EnvironmentTemplateSummary]> {
        self.templates.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentTemplatesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("templates", &self.templates);
        formatter.finish()
    }
}
/// See [`ListEnvironmentTemplatesOutput`](crate::output::ListEnvironmentTemplatesOutput)
pub mod list_environment_templates_output {
    /// A builder for [`ListEnvironmentTemplatesOutput`](crate::output::ListEnvironmentTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) templates:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateSummary>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the current requested
        /// list of environment templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next environment template in the array of environment templates, after the current requested
        /// list of environment templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `templates`.
        ///
        /// To override the contents of this collection use [`set_templates`](Self::set_templates).
        ///
        /// <p>An array of environment templates with detail data.</p>
        pub fn templates(
            mut self,
            input: impl Into<crate::model::EnvironmentTemplateSummary>,
        ) -> Self {
            let mut v = self.templates.unwrap_or_default();
            v.push(input.into());
            self.templates = Some(v);
            self
        }
        /// <p>An array of environment templates with detail data.</p>
        pub fn set_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentTemplateSummary>>,
        ) -> Self {
            self.templates = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentTemplatesOutput`](crate::output::ListEnvironmentTemplatesOutput)
        pub fn build(self) -> crate::output::ListEnvironmentTemplatesOutput {
            crate::output::ListEnvironmentTemplatesOutput {
                next_token: self.next_token,
                templates: self.templates,
            }
        }
    }
}
impl ListEnvironmentTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentTemplatesOutput`](crate::output::ListEnvironmentTemplatesOutput)
    pub fn builder() -> crate::output::list_environment_templates_output::Builder {
        crate::output::list_environment_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
}
impl CreateEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub fn environment_template(&self) -> std::option::Option<&crate::model::EnvironmentTemplate> {
        self.environment_template.as_ref()
    }
}
impl std::fmt::Debug for CreateEnvironmentTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentTemplateOutput");
        formatter.field("environment_template", &self.environment_template);
        formatter.finish()
    }
}
/// See [`CreateEnvironmentTemplateOutput`](crate::output::CreateEnvironmentTemplateOutput)
pub mod create_environment_template_output {
    /// A builder for [`CreateEnvironmentTemplateOutput`](crate::output::CreateEnvironmentTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
    }
    impl Builder {
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn environment_template(mut self, input: crate::model::EnvironmentTemplate) -> Self {
            self.environment_template = Some(input);
            self
        }
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplate>,
        ) -> Self {
            self.environment_template = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentTemplateOutput`](crate::output::CreateEnvironmentTemplateOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentTemplateOutput {
            crate::output::CreateEnvironmentTemplateOutput {
                environment_template: self.environment_template,
            }
        }
    }
}
impl CreateEnvironmentTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentTemplateOutput`](crate::output::CreateEnvironmentTemplateOutput)
    pub fn builder() -> crate::output::create_environment_template_output::Builder {
        crate::output::create_environment_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
}
impl DeleteEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub fn environment_template(&self) -> std::option::Option<&crate::model::EnvironmentTemplate> {
        self.environment_template.as_ref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentTemplateOutput");
        formatter.field("environment_template", &self.environment_template);
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentTemplateOutput`](crate::output::DeleteEnvironmentTemplateOutput)
pub mod delete_environment_template_output {
    /// A builder for [`DeleteEnvironmentTemplateOutput`](crate::output::DeleteEnvironmentTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
    }
    impl Builder {
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn environment_template(mut self, input: crate::model::EnvironmentTemplate) -> Self {
            self.environment_template = Some(input);
            self
        }
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplate>,
        ) -> Self {
            self.environment_template = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentTemplateOutput`](crate::output::DeleteEnvironmentTemplateOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentTemplateOutput {
            crate::output::DeleteEnvironmentTemplateOutput {
                environment_template: self.environment_template,
            }
        }
    }
}
impl DeleteEnvironmentTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentTemplateOutput`](crate::output::DeleteEnvironmentTemplateOutput)
    pub fn builder() -> crate::output::delete_environment_template_output::Builder {
        crate::output::delete_environment_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
}
impl UpdateEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub fn environment_template(&self) -> std::option::Option<&crate::model::EnvironmentTemplate> {
        self.environment_template.as_ref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentTemplateOutput");
        formatter.field("environment_template", &self.environment_template);
        formatter.finish()
    }
}
/// See [`UpdateEnvironmentTemplateOutput`](crate::output::UpdateEnvironmentTemplateOutput)
pub mod update_environment_template_output {
    /// A builder for [`UpdateEnvironmentTemplateOutput`](crate::output::UpdateEnvironmentTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
    }
    impl Builder {
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn environment_template(mut self, input: crate::model::EnvironmentTemplate) -> Self {
            self.environment_template = Some(input);
            self
        }
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplate>,
        ) -> Self {
            self.environment_template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentTemplateOutput`](crate::output::UpdateEnvironmentTemplateOutput)
        pub fn build(self) -> crate::output::UpdateEnvironmentTemplateOutput {
            crate::output::UpdateEnvironmentTemplateOutput {
                environment_template: self.environment_template,
            }
        }
    }
}
impl UpdateEnvironmentTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentTemplateOutput`](crate::output::UpdateEnvironmentTemplateOutput)
    pub fn builder() -> crate::output::update_environment_template_output::Builder {
        crate::output::update_environment_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
}
impl GetEnvironmentTemplateOutput {
    /// <p>The environment template detail data that's returned by AWS Proton.</p>
    pub fn environment_template(&self) -> std::option::Option<&crate::model::EnvironmentTemplate> {
        self.environment_template.as_ref()
    }
}
impl std::fmt::Debug for GetEnvironmentTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentTemplateOutput");
        formatter.field("environment_template", &self.environment_template);
        formatter.finish()
    }
}
/// See [`GetEnvironmentTemplateOutput`](crate::output::GetEnvironmentTemplateOutput)
pub mod get_environment_template_output {
    /// A builder for [`GetEnvironmentTemplateOutput`](crate::output::GetEnvironmentTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_template: std::option::Option<crate::model::EnvironmentTemplate>,
    }
    impl Builder {
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn environment_template(mut self, input: crate::model::EnvironmentTemplate) -> Self {
            self.environment_template = Some(input);
            self
        }
        /// <p>The environment template detail data that's returned by AWS Proton.</p>
        pub fn set_environment_template(
            mut self,
            input: std::option::Option<crate::model::EnvironmentTemplate>,
        ) -> Self {
            self.environment_template = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentTemplateOutput`](crate::output::GetEnvironmentTemplateOutput)
        pub fn build(self) -> crate::output::GetEnvironmentTemplateOutput {
            crate::output::GetEnvironmentTemplateOutput {
                environment_template: self.environment_template,
            }
        }
    }
}
impl GetEnvironmentTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentTemplateOutput`](crate::output::GetEnvironmentTemplateOutput)
    pub fn builder() -> crate::output::get_environment_template_output::Builder {
        crate::output::get_environment_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentsOutput {
    /// <p>A token to indicate the location of the next environment in the array of environments, after the current requested list of
    /// environments.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of environment detail data summaries.</p>
    pub environments: std::option::Option<std::vec::Vec<crate::model::EnvironmentSummary>>,
}
impl ListEnvironmentsOutput {
    /// <p>A token to indicate the location of the next environment in the array of environments, after the current requested list of
    /// environments.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of environment detail data summaries.</p>
    pub fn environments(&self) -> std::option::Option<&[crate::model::EnvironmentSummary]> {
        self.environments.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("environments", &self.environments);
        formatter.finish()
    }
}
/// See [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
pub mod list_environments_output {
    /// A builder for [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) environments:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentSummary>>,
    }
    impl Builder {
        /// <p>A token to indicate the location of the next environment in the array of environments, after the current requested list of
        /// environments.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next environment in the array of environments, after the current requested list of
        /// environments.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `environments`.
        ///
        /// To override the contents of this collection use [`set_environments`](Self::set_environments).
        ///
        /// <p>An array of environment detail data summaries.</p>
        pub fn environments(mut self, input: impl Into<crate::model::EnvironmentSummary>) -> Self {
            let mut v = self.environments.unwrap_or_default();
            v.push(input.into());
            self.environments = Some(v);
            self
        }
        /// <p>An array of environment detail data summaries.</p>
        pub fn set_environments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentSummary>>,
        ) -> Self {
            self.environments = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
        pub fn build(self) -> crate::output::ListEnvironmentsOutput {
            crate::output::ListEnvironmentsOutput {
                next_token: self.next_token,
                environments: self.environments,
            }
        }
    }
}
impl ListEnvironmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentsOutput`](crate::output::ListEnvironmentsOutput)
    pub fn builder() -> crate::output::list_environments_output::Builder {
        crate::output::list_environments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CreateEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CreateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentOutput");
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
pub mod create_environment_output {
    /// A builder for [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentOutput {
            crate::output::CreateEnvironmentOutput {
                environment: self.environment,
            }
        }
    }
}
impl CreateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentOutput`](crate::output::CreateEnvironmentOutput)
    pub fn builder() -> crate::output::create_environment_output::Builder {
        crate::output::create_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl DeleteEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentOutput");
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
pub mod delete_environment_output {
    /// A builder for [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentOutput {
            crate::output::DeleteEnvironmentOutput {
                environment: self.environment,
            }
        }
    }
}
impl DeleteEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentOutput`](crate::output::DeleteEnvironmentOutput)
    pub fn builder() -> crate::output::delete_environment_output::Builder {
        crate::output::delete_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl UpdateEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentOutput");
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
pub mod update_environment_output {
    /// A builder for [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
        pub fn build(self) -> crate::output::UpdateEnvironmentOutput {
            crate::output::UpdateEnvironmentOutput {
                environment: self.environment,
            }
        }
    }
}
impl UpdateEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentOutput`](crate::output::UpdateEnvironmentOutput)
    pub fn builder() -> crate::output::update_environment_output::Builder {
        crate::output::update_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl GetEnvironmentOutput {
    /// <p>The environment detail data that's returned by AWS Proton.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for GetEnvironmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentOutput");
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
pub mod get_environment_output {
    /// A builder for [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment detail data that's returned by AWS Proton.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
        pub fn build(self) -> crate::output::GetEnvironmentOutput {
            crate::output::GetEnvironmentOutput {
                environment: self.environment,
            }
        }
    }
}
impl GetEnvironmentOutput {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentOutput`](crate::output::GetEnvironmentOutput)
    pub fn builder() -> crate::output::get_environment_output::Builder {
        crate::output::get_environment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectEnvironmentAccountConnectionOutput {
    /// <p>The environment connection account detail data that's returned by AWS Proton.</p>
    pub environment_account_connection:
        std::option::Option<crate::model::EnvironmentAccountConnection>,
}
impl RejectEnvironmentAccountConnectionOutput {
    /// <p>The environment connection account detail data that's returned by AWS Proton.</p>
    pub fn environment_account_connection(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentAccountConnection> {
        self.environment_account_connection.as_ref()
    }
}
impl std::fmt::Debug for RejectEnvironmentAccountConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectEnvironmentAccountConnectionOutput");
        formatter.field(
            "environment_account_connection",
            &self.environment_account_connection,
        );
        formatter.finish()
    }
}
/// See [`RejectEnvironmentAccountConnectionOutput`](crate::output::RejectEnvironmentAccountConnectionOutput)
pub mod reject_environment_account_connection_output {
    /// A builder for [`RejectEnvironmentAccountConnectionOutput`](crate::output::RejectEnvironmentAccountConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_account_connection:
            std::option::Option<crate::model::EnvironmentAccountConnection>,
    }
    impl Builder {
        /// <p>The environment connection account detail data that's returned by AWS Proton.</p>
        pub fn environment_account_connection(
            mut self,
            input: crate::model::EnvironmentAccountConnection,
        ) -> Self {
            self.environment_account_connection = Some(input);
            self
        }
        /// <p>The environment connection account detail data that's returned by AWS Proton.</p>
        pub fn set_environment_account_connection(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnection>,
        ) -> Self {
            self.environment_account_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectEnvironmentAccountConnectionOutput`](crate::output::RejectEnvironmentAccountConnectionOutput)
        pub fn build(self) -> crate::output::RejectEnvironmentAccountConnectionOutput {
            crate::output::RejectEnvironmentAccountConnectionOutput {
                environment_account_connection: self.environment_account_connection,
            }
        }
    }
}
impl RejectEnvironmentAccountConnectionOutput {
    /// Creates a new builder-style object to manufacture [`RejectEnvironmentAccountConnectionOutput`](crate::output::RejectEnvironmentAccountConnectionOutput)
    pub fn builder() -> crate::output::reject_environment_account_connection_output::Builder {
        crate::output::reject_environment_account_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection data that's returned by AWS Proton.</p>
    pub environment_account_connection:
        std::option::Option<crate::model::EnvironmentAccountConnection>,
}
impl AcceptEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection data that's returned by AWS Proton.</p>
    pub fn environment_account_connection(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentAccountConnection> {
        self.environment_account_connection.as_ref()
    }
}
impl std::fmt::Debug for AcceptEnvironmentAccountConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptEnvironmentAccountConnectionOutput");
        formatter.field(
            "environment_account_connection",
            &self.environment_account_connection,
        );
        formatter.finish()
    }
}
/// See [`AcceptEnvironmentAccountConnectionOutput`](crate::output::AcceptEnvironmentAccountConnectionOutput)
pub mod accept_environment_account_connection_output {
    /// A builder for [`AcceptEnvironmentAccountConnectionOutput`](crate::output::AcceptEnvironmentAccountConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_account_connection:
            std::option::Option<crate::model::EnvironmentAccountConnection>,
    }
    impl Builder {
        /// <p>The environment account connection data that's returned by AWS Proton.</p>
        pub fn environment_account_connection(
            mut self,
            input: crate::model::EnvironmentAccountConnection,
        ) -> Self {
            self.environment_account_connection = Some(input);
            self
        }
        /// <p>The environment account connection data that's returned by AWS Proton.</p>
        pub fn set_environment_account_connection(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnection>,
        ) -> Self {
            self.environment_account_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptEnvironmentAccountConnectionOutput`](crate::output::AcceptEnvironmentAccountConnectionOutput)
        pub fn build(self) -> crate::output::AcceptEnvironmentAccountConnectionOutput {
            crate::output::AcceptEnvironmentAccountConnectionOutput {
                environment_account_connection: self.environment_account_connection,
            }
        }
    }
}
impl AcceptEnvironmentAccountConnectionOutput {
    /// Creates a new builder-style object to manufacture [`AcceptEnvironmentAccountConnectionOutput`](crate::output::AcceptEnvironmentAccountConnectionOutput)
    pub fn builder() -> crate::output::accept_environment_account_connection_output::Builder {
        crate::output::accept_environment_account_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEnvironmentAccountConnectionsOutput {
    /// <p>An array of environment account connections with details that's returned by AWS Proton. </p>
    pub environment_account_connections:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentAccountConnectionSummary>>,
    /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the
    /// current requested list of environment account connections.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEnvironmentAccountConnectionsOutput {
    /// <p>An array of environment account connections with details that's returned by AWS Proton. </p>
    pub fn environment_account_connections(
        &self,
    ) -> std::option::Option<&[crate::model::EnvironmentAccountConnectionSummary]> {
        self.environment_account_connections.as_deref()
    }
    /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the
    /// current requested list of environment account connections.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEnvironmentAccountConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEnvironmentAccountConnectionsOutput");
        formatter.field(
            "environment_account_connections",
            &self.environment_account_connections,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEnvironmentAccountConnectionsOutput`](crate::output::ListEnvironmentAccountConnectionsOutput)
pub mod list_environment_account_connections_output {
    /// A builder for [`ListEnvironmentAccountConnectionsOutput`](crate::output::ListEnvironmentAccountConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_account_connections:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentAccountConnectionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `environment_account_connections`.
        ///
        /// To override the contents of this collection use [`set_environment_account_connections`](Self::set_environment_account_connections).
        ///
        /// <p>An array of environment account connections with details that's returned by AWS Proton. </p>
        pub fn environment_account_connections(
            mut self,
            input: impl Into<crate::model::EnvironmentAccountConnectionSummary>,
        ) -> Self {
            let mut v = self.environment_account_connections.unwrap_or_default();
            v.push(input.into());
            self.environment_account_connections = Some(v);
            self
        }
        /// <p>An array of environment account connections with details that's returned by AWS Proton. </p>
        pub fn set_environment_account_connections(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::EnvironmentAccountConnectionSummary>,
            >,
        ) -> Self {
            self.environment_account_connections = input;
            self
        }
        /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the
        /// current requested list of environment account connections.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next environment account connection in the array of environment account connections, after the
        /// current requested list of environment account connections.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEnvironmentAccountConnectionsOutput`](crate::output::ListEnvironmentAccountConnectionsOutput)
        pub fn build(self) -> crate::output::ListEnvironmentAccountConnectionsOutput {
            crate::output::ListEnvironmentAccountConnectionsOutput {
                environment_account_connections: self.environment_account_connections,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEnvironmentAccountConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`ListEnvironmentAccountConnectionsOutput`](crate::output::ListEnvironmentAccountConnectionsOutput)
    pub fn builder() -> crate::output::list_environment_account_connections_output::Builder {
        crate::output::list_environment_account_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub environment_account_connection:
        std::option::Option<crate::model::EnvironmentAccountConnection>,
}
impl CreateEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub fn environment_account_connection(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentAccountConnection> {
        self.environment_account_connection.as_ref()
    }
}
impl std::fmt::Debug for CreateEnvironmentAccountConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEnvironmentAccountConnectionOutput");
        formatter.field(
            "environment_account_connection",
            &self.environment_account_connection,
        );
        formatter.finish()
    }
}
/// See [`CreateEnvironmentAccountConnectionOutput`](crate::output::CreateEnvironmentAccountConnectionOutput)
pub mod create_environment_account_connection_output {
    /// A builder for [`CreateEnvironmentAccountConnectionOutput`](crate::output::CreateEnvironmentAccountConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_account_connection:
            std::option::Option<crate::model::EnvironmentAccountConnection>,
    }
    impl Builder {
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn environment_account_connection(
            mut self,
            input: crate::model::EnvironmentAccountConnection,
        ) -> Self {
            self.environment_account_connection = Some(input);
            self
        }
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn set_environment_account_connection(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnection>,
        ) -> Self {
            self.environment_account_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEnvironmentAccountConnectionOutput`](crate::output::CreateEnvironmentAccountConnectionOutput)
        pub fn build(self) -> crate::output::CreateEnvironmentAccountConnectionOutput {
            crate::output::CreateEnvironmentAccountConnectionOutput {
                environment_account_connection: self.environment_account_connection,
            }
        }
    }
}
impl CreateEnvironmentAccountConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateEnvironmentAccountConnectionOutput`](crate::output::CreateEnvironmentAccountConnectionOutput)
    pub fn builder() -> crate::output::create_environment_account_connection_output::Builder {
        crate::output::create_environment_account_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub environment_account_connection:
        std::option::Option<crate::model::EnvironmentAccountConnection>,
}
impl DeleteEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub fn environment_account_connection(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentAccountConnection> {
        self.environment_account_connection.as_ref()
    }
}
impl std::fmt::Debug for DeleteEnvironmentAccountConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEnvironmentAccountConnectionOutput");
        formatter.field(
            "environment_account_connection",
            &self.environment_account_connection,
        );
        formatter.finish()
    }
}
/// See [`DeleteEnvironmentAccountConnectionOutput`](crate::output::DeleteEnvironmentAccountConnectionOutput)
pub mod delete_environment_account_connection_output {
    /// A builder for [`DeleteEnvironmentAccountConnectionOutput`](crate::output::DeleteEnvironmentAccountConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_account_connection:
            std::option::Option<crate::model::EnvironmentAccountConnection>,
    }
    impl Builder {
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn environment_account_connection(
            mut self,
            input: crate::model::EnvironmentAccountConnection,
        ) -> Self {
            self.environment_account_connection = Some(input);
            self
        }
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn set_environment_account_connection(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnection>,
        ) -> Self {
            self.environment_account_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEnvironmentAccountConnectionOutput`](crate::output::DeleteEnvironmentAccountConnectionOutput)
        pub fn build(self) -> crate::output::DeleteEnvironmentAccountConnectionOutput {
            crate::output::DeleteEnvironmentAccountConnectionOutput {
                environment_account_connection: self.environment_account_connection,
            }
        }
    }
}
impl DeleteEnvironmentAccountConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEnvironmentAccountConnectionOutput`](crate::output::DeleteEnvironmentAccountConnectionOutput)
    pub fn builder() -> crate::output::delete_environment_account_connection_output::Builder {
        crate::output::delete_environment_account_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub environment_account_connection:
        std::option::Option<crate::model::EnvironmentAccountConnection>,
}
impl UpdateEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub fn environment_account_connection(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentAccountConnection> {
        self.environment_account_connection.as_ref()
    }
}
impl std::fmt::Debug for UpdateEnvironmentAccountConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEnvironmentAccountConnectionOutput");
        formatter.field(
            "environment_account_connection",
            &self.environment_account_connection,
        );
        formatter.finish()
    }
}
/// See [`UpdateEnvironmentAccountConnectionOutput`](crate::output::UpdateEnvironmentAccountConnectionOutput)
pub mod update_environment_account_connection_output {
    /// A builder for [`UpdateEnvironmentAccountConnectionOutput`](crate::output::UpdateEnvironmentAccountConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_account_connection:
            std::option::Option<crate::model::EnvironmentAccountConnection>,
    }
    impl Builder {
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn environment_account_connection(
            mut self,
            input: crate::model::EnvironmentAccountConnection,
        ) -> Self {
            self.environment_account_connection = Some(input);
            self
        }
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn set_environment_account_connection(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnection>,
        ) -> Self {
            self.environment_account_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEnvironmentAccountConnectionOutput`](crate::output::UpdateEnvironmentAccountConnectionOutput)
        pub fn build(self) -> crate::output::UpdateEnvironmentAccountConnectionOutput {
            crate::output::UpdateEnvironmentAccountConnectionOutput {
                environment_account_connection: self.environment_account_connection,
            }
        }
    }
}
impl UpdateEnvironmentAccountConnectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEnvironmentAccountConnectionOutput`](crate::output::UpdateEnvironmentAccountConnectionOutput)
    pub fn builder() -> crate::output::update_environment_account_connection_output::Builder {
        crate::output::update_environment_account_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub environment_account_connection:
        std::option::Option<crate::model::EnvironmentAccountConnection>,
}
impl GetEnvironmentAccountConnectionOutput {
    /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
    pub fn environment_account_connection(
        &self,
    ) -> std::option::Option<&crate::model::EnvironmentAccountConnection> {
        self.environment_account_connection.as_ref()
    }
}
impl std::fmt::Debug for GetEnvironmentAccountConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEnvironmentAccountConnectionOutput");
        formatter.field(
            "environment_account_connection",
            &self.environment_account_connection,
        );
        formatter.finish()
    }
}
/// See [`GetEnvironmentAccountConnectionOutput`](crate::output::GetEnvironmentAccountConnectionOutput)
pub mod get_environment_account_connection_output {
    /// A builder for [`GetEnvironmentAccountConnectionOutput`](crate::output::GetEnvironmentAccountConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment_account_connection:
            std::option::Option<crate::model::EnvironmentAccountConnection>,
    }
    impl Builder {
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn environment_account_connection(
            mut self,
            input: crate::model::EnvironmentAccountConnection,
        ) -> Self {
            self.environment_account_connection = Some(input);
            self
        }
        /// <p>The environment account connection detail data that's returned by AWS Proton.</p>
        pub fn set_environment_account_connection(
            mut self,
            input: std::option::Option<crate::model::EnvironmentAccountConnection>,
        ) -> Self {
            self.environment_account_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEnvironmentAccountConnectionOutput`](crate::output::GetEnvironmentAccountConnectionOutput)
        pub fn build(self) -> crate::output::GetEnvironmentAccountConnectionOutput {
            crate::output::GetEnvironmentAccountConnectionOutput {
                environment_account_connection: self.environment_account_connection,
            }
        }
    }
}
impl GetEnvironmentAccountConnectionOutput {
    /// Creates a new builder-style object to manufacture [`GetEnvironmentAccountConnectionOutput`](crate::output::GetEnvironmentAccountConnectionOutput)
    pub fn builder() -> crate::output::get_environment_account_connection_output::Builder {
        crate::output::get_environment_account_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountSettingsOutput {
    /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
    pub account_settings: std::option::Option<crate::model::AccountSettings>,
}
impl UpdateAccountSettingsOutput {
    /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
    pub fn account_settings(&self) -> std::option::Option<&crate::model::AccountSettings> {
        self.account_settings.as_ref()
    }
}
impl std::fmt::Debug for UpdateAccountSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountSettingsOutput");
        formatter.field("account_settings", &self.account_settings);
        formatter.finish()
    }
}
/// See [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
pub mod update_account_settings_output {
    /// A builder for [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_settings: std::option::Option<crate::model::AccountSettings>,
    }
    impl Builder {
        /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
        pub fn account_settings(mut self, input: crate::model::AccountSettings) -> Self {
            self.account_settings = Some(input);
            self
        }
        /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
        pub fn set_account_settings(
            mut self,
            input: std::option::Option<crate::model::AccountSettings>,
        ) -> Self {
            self.account_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
        pub fn build(self) -> crate::output::UpdateAccountSettingsOutput {
            crate::output::UpdateAccountSettingsOutput {
                account_settings: self.account_settings,
            }
        }
    }
}
impl UpdateAccountSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccountSettingsOutput`](crate::output::UpdateAccountSettingsOutput)
    pub fn builder() -> crate::output::update_account_settings_output::Builder {
        crate::output::update_account_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSettingsOutput {
    /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
    pub account_settings: std::option::Option<crate::model::AccountSettings>,
}
impl GetAccountSettingsOutput {
    /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
    pub fn account_settings(&self) -> std::option::Option<&crate::model::AccountSettings> {
        self.account_settings.as_ref()
    }
}
impl std::fmt::Debug for GetAccountSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSettingsOutput");
        formatter.field("account_settings", &self.account_settings);
        formatter.finish()
    }
}
/// See [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
pub mod get_account_settings_output {
    /// A builder for [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_settings: std::option::Option<crate::model::AccountSettings>,
    }
    impl Builder {
        /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
        pub fn account_settings(mut self, input: crate::model::AccountSettings) -> Self {
            self.account_settings = Some(input);
            self
        }
        /// <p>The AWS Proton pipeline service role detail data that's returned by AWS Proton.</p>
        pub fn set_account_settings(
            mut self,
            input: std::option::Option<crate::model::AccountSettings>,
        ) -> Self {
            self.account_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
        pub fn build(self) -> crate::output::GetAccountSettingsOutput {
            crate::output::GetAccountSettingsOutput {
                account_settings: self.account_settings,
            }
        }
    }
}
impl GetAccountSettingsOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
    pub fn builder() -> crate::output::get_account_settings_output::Builder {
        crate::output::get_account_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>An array of resource tags with detail data.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the current requested list of resource
    /// tags.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>An array of resource tags with detail data.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the current requested list of resource
    /// tags.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of resource tags with detail data.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of resource tags with detail data.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the current requested list of resource
        /// tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to indicate the location of the next resource tag in the array of resource tags, after the current requested list of resource
        /// tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelServicePipelineDeploymentOutput {
    /// <p>The service pipeline detail data that's returned by AWS Proton.</p>
    pub pipeline: std::option::Option<crate::model::ServicePipeline>,
}
impl CancelServicePipelineDeploymentOutput {
    /// <p>The service pipeline detail data that's returned by AWS Proton.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::ServicePipeline> {
        self.pipeline.as_ref()
    }
}
impl std::fmt::Debug for CancelServicePipelineDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelServicePipelineDeploymentOutput");
        formatter.field("pipeline", &self.pipeline);
        formatter.finish()
    }
}
/// See [`CancelServicePipelineDeploymentOutput`](crate::output::CancelServicePipelineDeploymentOutput)
pub mod cancel_service_pipeline_deployment_output {
    /// A builder for [`CancelServicePipelineDeploymentOutput`](crate::output::CancelServicePipelineDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline: std::option::Option<crate::model::ServicePipeline>,
    }
    impl Builder {
        /// <p>The service pipeline detail data that's returned by AWS Proton.</p>
        pub fn pipeline(mut self, input: crate::model::ServicePipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>The service pipeline detail data that's returned by AWS Proton.</p>
        pub fn set_pipeline(
            mut self,
            input: std::option::Option<crate::model::ServicePipeline>,
        ) -> Self {
            self.pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelServicePipelineDeploymentOutput`](crate::output::CancelServicePipelineDeploymentOutput)
        pub fn build(self) -> crate::output::CancelServicePipelineDeploymentOutput {
            crate::output::CancelServicePipelineDeploymentOutput {
                pipeline: self.pipeline,
            }
        }
    }
}
impl CancelServicePipelineDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CancelServicePipelineDeploymentOutput`](crate::output::CancelServicePipelineDeploymentOutput)
    pub fn builder() -> crate::output::cancel_service_pipeline_deployment_output::Builder {
        crate::output::cancel_service_pipeline_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelServiceInstanceDeploymentOutput {
    /// <p>The service instance summary data that's returned by AWS Proton.</p>
    pub service_instance: std::option::Option<crate::model::ServiceInstance>,
}
impl CancelServiceInstanceDeploymentOutput {
    /// <p>The service instance summary data that's returned by AWS Proton.</p>
    pub fn service_instance(&self) -> std::option::Option<&crate::model::ServiceInstance> {
        self.service_instance.as_ref()
    }
}
impl std::fmt::Debug for CancelServiceInstanceDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelServiceInstanceDeploymentOutput");
        formatter.field("service_instance", &self.service_instance);
        formatter.finish()
    }
}
/// See [`CancelServiceInstanceDeploymentOutput`](crate::output::CancelServiceInstanceDeploymentOutput)
pub mod cancel_service_instance_deployment_output {
    /// A builder for [`CancelServiceInstanceDeploymentOutput`](crate::output::CancelServiceInstanceDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_instance: std::option::Option<crate::model::ServiceInstance>,
    }
    impl Builder {
        /// <p>The service instance summary data that's returned by AWS Proton.</p>
        pub fn service_instance(mut self, input: crate::model::ServiceInstance) -> Self {
            self.service_instance = Some(input);
            self
        }
        /// <p>The service instance summary data that's returned by AWS Proton.</p>
        pub fn set_service_instance(
            mut self,
            input: std::option::Option<crate::model::ServiceInstance>,
        ) -> Self {
            self.service_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelServiceInstanceDeploymentOutput`](crate::output::CancelServiceInstanceDeploymentOutput)
        pub fn build(self) -> crate::output::CancelServiceInstanceDeploymentOutput {
            crate::output::CancelServiceInstanceDeploymentOutput {
                service_instance: self.service_instance,
            }
        }
    }
}
impl CancelServiceInstanceDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CancelServiceInstanceDeploymentOutput`](crate::output::CancelServiceInstanceDeploymentOutput)
    pub fn builder() -> crate::output::cancel_service_instance_deployment_output::Builder {
        crate::output::cancel_service_instance_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelEnvironmentDeploymentOutput {
    /// <p>The environment summary data that's returned by AWS Proton.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CancelEnvironmentDeploymentOutput {
    /// <p>The environment summary data that's returned by AWS Proton.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CancelEnvironmentDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelEnvironmentDeploymentOutput");
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`CancelEnvironmentDeploymentOutput`](crate::output::CancelEnvironmentDeploymentOutput)
pub mod cancel_environment_deployment_output {
    /// A builder for [`CancelEnvironmentDeploymentOutput`](crate::output::CancelEnvironmentDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The environment summary data that's returned by AWS Proton.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment summary data that's returned by AWS Proton.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelEnvironmentDeploymentOutput`](crate::output::CancelEnvironmentDeploymentOutput)
        pub fn build(self) -> crate::output::CancelEnvironmentDeploymentOutput {
            crate::output::CancelEnvironmentDeploymentOutput {
                environment: self.environment,
            }
        }
    }
}
impl CancelEnvironmentDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CancelEnvironmentDeploymentOutput`](crate::output::CancelEnvironmentDeploymentOutput)
    pub fn builder() -> crate::output::cancel_environment_deployment_output::Builder {
        crate::output::cancel_environment_deployment_output::Builder::default()
    }
}
